﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/redshift-data/RedshiftDataAPIService_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/redshift-data/model/StatusString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace RedshiftDataAPIService
{
namespace Model
{

  /**
   * <p>The SQL statement to run.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/StatementData">AWS
   * API Reference</a></p>
   */
  class AWS_REDSHIFTDATAAPISERVICE_API StatementData
  {
  public:
    StatementData();
    StatementData(Aws::Utils::Json::JsonView jsonValue);
    StatementData& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The date and time (UTC) the statement was created. </p>
     */
    inline const Aws::Utils::DateTime& GetCreatedAt() const{ return m_createdAt; }

    /**
     * <p>The date and time (UTC) the statement was created. </p>
     */
    inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }

    /**
     * <p>The date and time (UTC) the statement was created. </p>
     */
    inline void SetCreatedAt(const Aws::Utils::DateTime& value) { m_createdAtHasBeenSet = true; m_createdAt = value; }

    /**
     * <p>The date and time (UTC) the statement was created. </p>
     */
    inline void SetCreatedAt(Aws::Utils::DateTime&& value) { m_createdAtHasBeenSet = true; m_createdAt = std::move(value); }

    /**
     * <p>The date and time (UTC) the statement was created. </p>
     */
    inline StatementData& WithCreatedAt(const Aws::Utils::DateTime& value) { SetCreatedAt(value); return *this;}

    /**
     * <p>The date and time (UTC) the statement was created. </p>
     */
    inline StatementData& WithCreatedAt(Aws::Utils::DateTime&& value) { SetCreatedAt(std::move(value)); return *this;}


    /**
     * <p>The SQL statement identifier. This value is a universally unique identifier
     * (UUID) generated by Amazon Redshift Data API. </p>
     */
    inline const Aws::String& GetId() const{ return m_id; }

    /**
     * <p>The SQL statement identifier. This value is a universally unique identifier
     * (UUID) generated by Amazon Redshift Data API. </p>
     */
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }

    /**
     * <p>The SQL statement identifier. This value is a universally unique identifier
     * (UUID) generated by Amazon Redshift Data API. </p>
     */
    inline void SetId(const Aws::String& value) { m_idHasBeenSet = true; m_id = value; }

    /**
     * <p>The SQL statement identifier. This value is a universally unique identifier
     * (UUID) generated by Amazon Redshift Data API. </p>
     */
    inline void SetId(Aws::String&& value) { m_idHasBeenSet = true; m_id = std::move(value); }

    /**
     * <p>The SQL statement identifier. This value is a universally unique identifier
     * (UUID) generated by Amazon Redshift Data API. </p>
     */
    inline void SetId(const char* value) { m_idHasBeenSet = true; m_id.assign(value); }

    /**
     * <p>The SQL statement identifier. This value is a universally unique identifier
     * (UUID) generated by Amazon Redshift Data API. </p>
     */
    inline StatementData& WithId(const Aws::String& value) { SetId(value); return *this;}

    /**
     * <p>The SQL statement identifier. This value is a universally unique identifier
     * (UUID) generated by Amazon Redshift Data API. </p>
     */
    inline StatementData& WithId(Aws::String&& value) { SetId(std::move(value)); return *this;}

    /**
     * <p>The SQL statement identifier. This value is a universally unique identifier
     * (UUID) generated by Amazon Redshift Data API. </p>
     */
    inline StatementData& WithId(const char* value) { SetId(value); return *this;}


    /**
     * <p>The SQL statement.</p>
     */
    inline const Aws::String& GetQueryString() const{ return m_queryString; }

    /**
     * <p>The SQL statement.</p>
     */
    inline bool QueryStringHasBeenSet() const { return m_queryStringHasBeenSet; }

    /**
     * <p>The SQL statement.</p>
     */
    inline void SetQueryString(const Aws::String& value) { m_queryStringHasBeenSet = true; m_queryString = value; }

    /**
     * <p>The SQL statement.</p>
     */
    inline void SetQueryString(Aws::String&& value) { m_queryStringHasBeenSet = true; m_queryString = std::move(value); }

    /**
     * <p>The SQL statement.</p>
     */
    inline void SetQueryString(const char* value) { m_queryStringHasBeenSet = true; m_queryString.assign(value); }

    /**
     * <p>The SQL statement.</p>
     */
    inline StatementData& WithQueryString(const Aws::String& value) { SetQueryString(value); return *this;}

    /**
     * <p>The SQL statement.</p>
     */
    inline StatementData& WithQueryString(Aws::String&& value) { SetQueryString(std::move(value)); return *this;}

    /**
     * <p>The SQL statement.</p>
     */
    inline StatementData& WithQueryString(const char* value) { SetQueryString(value); return *this;}


    /**
     * <p>The name or Amazon Resource Name (ARN) of the secret that enables access to
     * the database. </p>
     */
    inline const Aws::String& GetSecretArn() const{ return m_secretArn; }

    /**
     * <p>The name or Amazon Resource Name (ARN) of the secret that enables access to
     * the database. </p>
     */
    inline bool SecretArnHasBeenSet() const { return m_secretArnHasBeenSet; }

    /**
     * <p>The name or Amazon Resource Name (ARN) of the secret that enables access to
     * the database. </p>
     */
    inline void SetSecretArn(const Aws::String& value) { m_secretArnHasBeenSet = true; m_secretArn = value; }

    /**
     * <p>The name or Amazon Resource Name (ARN) of the secret that enables access to
     * the database. </p>
     */
    inline void SetSecretArn(Aws::String&& value) { m_secretArnHasBeenSet = true; m_secretArn = std::move(value); }

    /**
     * <p>The name or Amazon Resource Name (ARN) of the secret that enables access to
     * the database. </p>
     */
    inline void SetSecretArn(const char* value) { m_secretArnHasBeenSet = true; m_secretArn.assign(value); }

    /**
     * <p>The name or Amazon Resource Name (ARN) of the secret that enables access to
     * the database. </p>
     */
    inline StatementData& WithSecretArn(const Aws::String& value) { SetSecretArn(value); return *this;}

    /**
     * <p>The name or Amazon Resource Name (ARN) of the secret that enables access to
     * the database. </p>
     */
    inline StatementData& WithSecretArn(Aws::String&& value) { SetSecretArn(std::move(value)); return *this;}

    /**
     * <p>The name or Amazon Resource Name (ARN) of the secret that enables access to
     * the database. </p>
     */
    inline StatementData& WithSecretArn(const char* value) { SetSecretArn(value); return *this;}


    /**
     * <p>The name of the SQL statement. </p>
     */
    inline const Aws::String& GetStatementName() const{ return m_statementName; }

    /**
     * <p>The name of the SQL statement. </p>
     */
    inline bool StatementNameHasBeenSet() const { return m_statementNameHasBeenSet; }

    /**
     * <p>The name of the SQL statement. </p>
     */
    inline void SetStatementName(const Aws::String& value) { m_statementNameHasBeenSet = true; m_statementName = value; }

    /**
     * <p>The name of the SQL statement. </p>
     */
    inline void SetStatementName(Aws::String&& value) { m_statementNameHasBeenSet = true; m_statementName = std::move(value); }

    /**
     * <p>The name of the SQL statement. </p>
     */
    inline void SetStatementName(const char* value) { m_statementNameHasBeenSet = true; m_statementName.assign(value); }

    /**
     * <p>The name of the SQL statement. </p>
     */
    inline StatementData& WithStatementName(const Aws::String& value) { SetStatementName(value); return *this;}

    /**
     * <p>The name of the SQL statement. </p>
     */
    inline StatementData& WithStatementName(Aws::String&& value) { SetStatementName(std::move(value)); return *this;}

    /**
     * <p>The name of the SQL statement. </p>
     */
    inline StatementData& WithStatementName(const char* value) { SetStatementName(value); return *this;}


    /**
     * <p>The status of the SQL statement. An example is the that the SQL statement
     * finished. </p>
     */
    inline const StatusString& GetStatus() const{ return m_status; }

    /**
     * <p>The status of the SQL statement. An example is the that the SQL statement
     * finished. </p>
     */
    inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }

    /**
     * <p>The status of the SQL statement. An example is the that the SQL statement
     * finished. </p>
     */
    inline void SetStatus(const StatusString& value) { m_statusHasBeenSet = true; m_status = value; }

    /**
     * <p>The status of the SQL statement. An example is the that the SQL statement
     * finished. </p>
     */
    inline void SetStatus(StatusString&& value) { m_statusHasBeenSet = true; m_status = std::move(value); }

    /**
     * <p>The status of the SQL statement. An example is the that the SQL statement
     * finished. </p>
     */
    inline StatementData& WithStatus(const StatusString& value) { SetStatus(value); return *this;}

    /**
     * <p>The status of the SQL statement. An example is the that the SQL statement
     * finished. </p>
     */
    inline StatementData& WithStatus(StatusString&& value) { SetStatus(std::move(value)); return *this;}


    /**
     * <p>The date and time (UTC) that the statement metadata was last updated.</p>
     */
    inline const Aws::Utils::DateTime& GetUpdatedAt() const{ return m_updatedAt; }

    /**
     * <p>The date and time (UTC) that the statement metadata was last updated.</p>
     */
    inline bool UpdatedAtHasBeenSet() const { return m_updatedAtHasBeenSet; }

    /**
     * <p>The date and time (UTC) that the statement metadata was last updated.</p>
     */
    inline void SetUpdatedAt(const Aws::Utils::DateTime& value) { m_updatedAtHasBeenSet = true; m_updatedAt = value; }

    /**
     * <p>The date and time (UTC) that the statement metadata was last updated.</p>
     */
    inline void SetUpdatedAt(Aws::Utils::DateTime&& value) { m_updatedAtHasBeenSet = true; m_updatedAt = std::move(value); }

    /**
     * <p>The date and time (UTC) that the statement metadata was last updated.</p>
     */
    inline StatementData& WithUpdatedAt(const Aws::Utils::DateTime& value) { SetUpdatedAt(value); return *this;}

    /**
     * <p>The date and time (UTC) that the statement metadata was last updated.</p>
     */
    inline StatementData& WithUpdatedAt(Aws::Utils::DateTime&& value) { SetUpdatedAt(std::move(value)); return *this;}

  private:

    Aws::Utils::DateTime m_createdAt;
    bool m_createdAtHasBeenSet;

    Aws::String m_id;
    bool m_idHasBeenSet;

    Aws::String m_queryString;
    bool m_queryStringHasBeenSet;

    Aws::String m_secretArn;
    bool m_secretArnHasBeenSet;

    Aws::String m_statementName;
    bool m_statementNameHasBeenSet;

    StatusString m_status;
    bool m_statusHasBeenSet;

    Aws::Utils::DateTime m_updatedAt;
    bool m_updatedAtHasBeenSet;
  };

} // namespace Model
} // namespace RedshiftDataAPIService
} // namespace Aws
