﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SageMaker
{
namespace Model
{

  /**
   * <p>A description of an error that occurred while rendering the
   * template.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RenderingError">AWS
   * API Reference</a></p>
   */
  class AWS_SAGEMAKER_API RenderingError
  {
  public:
    RenderingError();
    RenderingError(Aws::Utils::Json::JsonView jsonValue);
    RenderingError& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>A unique identifier for a specific class of errors.</p>
     */
    inline const Aws::String& GetCode() const{ return m_code; }

    /**
     * <p>A unique identifier for a specific class of errors.</p>
     */
    inline bool CodeHasBeenSet() const { return m_codeHasBeenSet; }

    /**
     * <p>A unique identifier for a specific class of errors.</p>
     */
    inline void SetCode(const Aws::String& value) { m_codeHasBeenSet = true; m_code = value; }

    /**
     * <p>A unique identifier for a specific class of errors.</p>
     */
    inline void SetCode(Aws::String&& value) { m_codeHasBeenSet = true; m_code = std::move(value); }

    /**
     * <p>A unique identifier for a specific class of errors.</p>
     */
    inline void SetCode(const char* value) { m_codeHasBeenSet = true; m_code.assign(value); }

    /**
     * <p>A unique identifier for a specific class of errors.</p>
     */
    inline RenderingError& WithCode(const Aws::String& value) { SetCode(value); return *this;}

    /**
     * <p>A unique identifier for a specific class of errors.</p>
     */
    inline RenderingError& WithCode(Aws::String&& value) { SetCode(std::move(value)); return *this;}

    /**
     * <p>A unique identifier for a specific class of errors.</p>
     */
    inline RenderingError& WithCode(const char* value) { SetCode(value); return *this;}


    /**
     * <p>A human-readable message describing the error.</p>
     */
    inline const Aws::String& GetMessage() const{ return m_message; }

    /**
     * <p>A human-readable message describing the error.</p>
     */
    inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }

    /**
     * <p>A human-readable message describing the error.</p>
     */
    inline void SetMessage(const Aws::String& value) { m_messageHasBeenSet = true; m_message = value; }

    /**
     * <p>A human-readable message describing the error.</p>
     */
    inline void SetMessage(Aws::String&& value) { m_messageHasBeenSet = true; m_message = std::move(value); }

    /**
     * <p>A human-readable message describing the error.</p>
     */
    inline void SetMessage(const char* value) { m_messageHasBeenSet = true; m_message.assign(value); }

    /**
     * <p>A human-readable message describing the error.</p>
     */
    inline RenderingError& WithMessage(const Aws::String& value) { SetMessage(value); return *this;}

    /**
     * <p>A human-readable message describing the error.</p>
     */
    inline RenderingError& WithMessage(Aws::String&& value) { SetMessage(std::move(value)); return *this;}

    /**
     * <p>A human-readable message describing the error.</p>
     */
    inline RenderingError& WithMessage(const char* value) { SetMessage(value); return *this;}

  private:

    Aws::String m_code;
    bool m_codeHasBeenSet;

    Aws::String m_message;
    bool m_messageHasBeenSet;
  };

} // namespace Model
} // namespace SageMaker
} // namespace Aws
