﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/securityhub/model/VulnerabilityVendor.h>
#include <aws/securityhub/model/SoftwarePackage.h>
#include <aws/securityhub/model/Cvss.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p>A vulnerability associated with a finding.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Vulnerability">AWS
   * API Reference</a></p>
   */
  class AWS_SECURITYHUB_API Vulnerability
  {
  public:
    Vulnerability();
    Vulnerability(Aws::Utils::Json::JsonView jsonValue);
    Vulnerability& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The identifier of the vulnerability.</p>
     */
    inline const Aws::String& GetId() const{ return m_id; }

    /**
     * <p>The identifier of the vulnerability.</p>
     */
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }

    /**
     * <p>The identifier of the vulnerability.</p>
     */
    inline void SetId(const Aws::String& value) { m_idHasBeenSet = true; m_id = value; }

    /**
     * <p>The identifier of the vulnerability.</p>
     */
    inline void SetId(Aws::String&& value) { m_idHasBeenSet = true; m_id = std::move(value); }

    /**
     * <p>The identifier of the vulnerability.</p>
     */
    inline void SetId(const char* value) { m_idHasBeenSet = true; m_id.assign(value); }

    /**
     * <p>The identifier of the vulnerability.</p>
     */
    inline Vulnerability& WithId(const Aws::String& value) { SetId(value); return *this;}

    /**
     * <p>The identifier of the vulnerability.</p>
     */
    inline Vulnerability& WithId(Aws::String&& value) { SetId(std::move(value)); return *this;}

    /**
     * <p>The identifier of the vulnerability.</p>
     */
    inline Vulnerability& WithId(const char* value) { SetId(value); return *this;}


    /**
     * <p>List of software packages that have the vulnerability.</p>
     */
    inline const Aws::Vector<SoftwarePackage>& GetVulnerablePackages() const{ return m_vulnerablePackages; }

    /**
     * <p>List of software packages that have the vulnerability.</p>
     */
    inline bool VulnerablePackagesHasBeenSet() const { return m_vulnerablePackagesHasBeenSet; }

    /**
     * <p>List of software packages that have the vulnerability.</p>
     */
    inline void SetVulnerablePackages(const Aws::Vector<SoftwarePackage>& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages = value; }

    /**
     * <p>List of software packages that have the vulnerability.</p>
     */
    inline void SetVulnerablePackages(Aws::Vector<SoftwarePackage>&& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages = std::move(value); }

    /**
     * <p>List of software packages that have the vulnerability.</p>
     */
    inline Vulnerability& WithVulnerablePackages(const Aws::Vector<SoftwarePackage>& value) { SetVulnerablePackages(value); return *this;}

    /**
     * <p>List of software packages that have the vulnerability.</p>
     */
    inline Vulnerability& WithVulnerablePackages(Aws::Vector<SoftwarePackage>&& value) { SetVulnerablePackages(std::move(value)); return *this;}

    /**
     * <p>List of software packages that have the vulnerability.</p>
     */
    inline Vulnerability& AddVulnerablePackages(const SoftwarePackage& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages.push_back(value); return *this; }

    /**
     * <p>List of software packages that have the vulnerability.</p>
     */
    inline Vulnerability& AddVulnerablePackages(SoftwarePackage&& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages.push_back(std::move(value)); return *this; }


    /**
     * <p>CVSS scores from the advisory related to the vulnerability.</p>
     */
    inline const Aws::Vector<Cvss>& GetCvss() const{ return m_cvss; }

    /**
     * <p>CVSS scores from the advisory related to the vulnerability.</p>
     */
    inline bool CvssHasBeenSet() const { return m_cvssHasBeenSet; }

    /**
     * <p>CVSS scores from the advisory related to the vulnerability.</p>
     */
    inline void SetCvss(const Aws::Vector<Cvss>& value) { m_cvssHasBeenSet = true; m_cvss = value; }

    /**
     * <p>CVSS scores from the advisory related to the vulnerability.</p>
     */
    inline void SetCvss(Aws::Vector<Cvss>&& value) { m_cvssHasBeenSet = true; m_cvss = std::move(value); }

    /**
     * <p>CVSS scores from the advisory related to the vulnerability.</p>
     */
    inline Vulnerability& WithCvss(const Aws::Vector<Cvss>& value) { SetCvss(value); return *this;}

    /**
     * <p>CVSS scores from the advisory related to the vulnerability.</p>
     */
    inline Vulnerability& WithCvss(Aws::Vector<Cvss>&& value) { SetCvss(std::move(value)); return *this;}

    /**
     * <p>CVSS scores from the advisory related to the vulnerability.</p>
     */
    inline Vulnerability& AddCvss(const Cvss& value) { m_cvssHasBeenSet = true; m_cvss.push_back(value); return *this; }

    /**
     * <p>CVSS scores from the advisory related to the vulnerability.</p>
     */
    inline Vulnerability& AddCvss(Cvss&& value) { m_cvssHasBeenSet = true; m_cvss.push_back(std::move(value)); return *this; }


    /**
     * <p>List of vulnerabilities that are related to this vulnerability.</p>
     */
    inline const Aws::Vector<Aws::String>& GetRelatedVulnerabilities() const{ return m_relatedVulnerabilities; }

    /**
     * <p>List of vulnerabilities that are related to this vulnerability.</p>
     */
    inline bool RelatedVulnerabilitiesHasBeenSet() const { return m_relatedVulnerabilitiesHasBeenSet; }

    /**
     * <p>List of vulnerabilities that are related to this vulnerability.</p>
     */
    inline void SetRelatedVulnerabilities(const Aws::Vector<Aws::String>& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = value; }

    /**
     * <p>List of vulnerabilities that are related to this vulnerability.</p>
     */
    inline void SetRelatedVulnerabilities(Aws::Vector<Aws::String>&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = std::move(value); }

    /**
     * <p>List of vulnerabilities that are related to this vulnerability.</p>
     */
    inline Vulnerability& WithRelatedVulnerabilities(const Aws::Vector<Aws::String>& value) { SetRelatedVulnerabilities(value); return *this;}

    /**
     * <p>List of vulnerabilities that are related to this vulnerability.</p>
     */
    inline Vulnerability& WithRelatedVulnerabilities(Aws::Vector<Aws::String>&& value) { SetRelatedVulnerabilities(std::move(value)); return *this;}

    /**
     * <p>List of vulnerabilities that are related to this vulnerability.</p>
     */
    inline Vulnerability& AddRelatedVulnerabilities(const Aws::String& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(value); return *this; }

    /**
     * <p>List of vulnerabilities that are related to this vulnerability.</p>
     */
    inline Vulnerability& AddRelatedVulnerabilities(Aws::String&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(std::move(value)); return *this; }

    /**
     * <p>List of vulnerabilities that are related to this vulnerability.</p>
     */
    inline Vulnerability& AddRelatedVulnerabilities(const char* value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(value); return *this; }


    /**
     * <p>Information about the vendor that generates the vulnerability report.</p>
     */
    inline const VulnerabilityVendor& GetVendor() const{ return m_vendor; }

    /**
     * <p>Information about the vendor that generates the vulnerability report.</p>
     */
    inline bool VendorHasBeenSet() const { return m_vendorHasBeenSet; }

    /**
     * <p>Information about the vendor that generates the vulnerability report.</p>
     */
    inline void SetVendor(const VulnerabilityVendor& value) { m_vendorHasBeenSet = true; m_vendor = value; }

    /**
     * <p>Information about the vendor that generates the vulnerability report.</p>
     */
    inline void SetVendor(VulnerabilityVendor&& value) { m_vendorHasBeenSet = true; m_vendor = std::move(value); }

    /**
     * <p>Information about the vendor that generates the vulnerability report.</p>
     */
    inline Vulnerability& WithVendor(const VulnerabilityVendor& value) { SetVendor(value); return *this;}

    /**
     * <p>Information about the vendor that generates the vulnerability report.</p>
     */
    inline Vulnerability& WithVendor(VulnerabilityVendor&& value) { SetVendor(std::move(value)); return *this;}


    /**
     * <p>A list of URLs that provide additional information about the
     * vulnerability.</p>
     */
    inline const Aws::Vector<Aws::String>& GetReferenceUrls() const{ return m_referenceUrls; }

    /**
     * <p>A list of URLs that provide additional information about the
     * vulnerability.</p>
     */
    inline bool ReferenceUrlsHasBeenSet() const { return m_referenceUrlsHasBeenSet; }

    /**
     * <p>A list of URLs that provide additional information about the
     * vulnerability.</p>
     */
    inline void SetReferenceUrls(const Aws::Vector<Aws::String>& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = value; }

    /**
     * <p>A list of URLs that provide additional information about the
     * vulnerability.</p>
     */
    inline void SetReferenceUrls(Aws::Vector<Aws::String>&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = std::move(value); }

    /**
     * <p>A list of URLs that provide additional information about the
     * vulnerability.</p>
     */
    inline Vulnerability& WithReferenceUrls(const Aws::Vector<Aws::String>& value) { SetReferenceUrls(value); return *this;}

    /**
     * <p>A list of URLs that provide additional information about the
     * vulnerability.</p>
     */
    inline Vulnerability& WithReferenceUrls(Aws::Vector<Aws::String>&& value) { SetReferenceUrls(std::move(value)); return *this;}

    /**
     * <p>A list of URLs that provide additional information about the
     * vulnerability.</p>
     */
    inline Vulnerability& AddReferenceUrls(const Aws::String& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }

    /**
     * <p>A list of URLs that provide additional information about the
     * vulnerability.</p>
     */
    inline Vulnerability& AddReferenceUrls(Aws::String&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(std::move(value)); return *this; }

    /**
     * <p>A list of URLs that provide additional information about the
     * vulnerability.</p>
     */
    inline Vulnerability& AddReferenceUrls(const char* value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }

  private:

    Aws::String m_id;
    bool m_idHasBeenSet;

    Aws::Vector<SoftwarePackage> m_vulnerablePackages;
    bool m_vulnerablePackagesHasBeenSet;

    Aws::Vector<Cvss> m_cvss;
    bool m_cvssHasBeenSet;

    Aws::Vector<Aws::String> m_relatedVulnerabilities;
    bool m_relatedVulnerabilitiesHasBeenSet;

    VulnerabilityVendor m_vendor;
    bool m_vendorHasBeenSet;

    Aws::Vector<Aws::String> m_referenceUrls;
    bool m_referenceUrlsHasBeenSet;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
