/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.autoupdate.ui.LocalDownloadSupport;
import org.netbeans.modules.autoupdate.ui.LocallyDownloadedTableModel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UnitTab;
import org.openide.util.Exceptions;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;

final class LocallDownloadDnD
implements DropTargetListener {
    private final LocalDownloadSupport localDownloadSupport;
    private final LocallyDownloadedTableModel model;
    private final PluginManagerUI outer;
    private DataFlavor accept;
    private Object value;

    LocallDownloadDnD(LocalDownloadSupport localDownloadSupport, LocallyDownloadedTableModel locallyDownloadedTableModel, PluginManagerUI pluginManagerUI) {
        this.model = locallyDownloadedTableModel;
        this.outer = pluginManagerUI;
        this.localDownloadSupport = localDownloadSupport;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.accept = null;
        this.value = null;
        for (DataFlavor dataFlavor : dropTargetDragEvent.getCurrentDataFlavors()) {
            Object object = null;
            try {
                object = dropTargetDragEvent.getTransferable().getTransferData(dataFlavor);
            }
            catch (Exception exception) {
                continue;
            }
            if (dataFlavor.isFlavorJavaFileListType()) {
                this.accept = dataFlavor;
                this.value = object;
                break;
            }
            if (!"text".equals(dataFlavor.getPrimaryType()) || !"uri-list".equals(dataFlavor.getSubType()) || dataFlavor.getRepresentationClass() != String.class) continue;
            this.accept = dataFlavor;
            this.value = (String)object;
            break;
        }
        if (this.accept != null) {
            dropTargetDragEvent.acceptDrag(3);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.accept == null) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        try {
            dropTargetDropEvent.acceptDrop(3);
            List<File> list = null;
            if (this.value instanceof String) {
                list = new ArrayList();
                for (String string : ((String)this.value).split("\n")) {
                    File file = Utilities.toFile((URI)new URI(string.trim()));
                    assert (file.exists()) : "File shall exist: " + file;
                    list.add(file);
                }
            }
            if (this.value instanceof List) {
                list = NbCollections.checkedListByCopy((List)((List)this.value), File.class, (boolean)true);
            }
            if (list != null) {
                UnitTab unitTab = this.outer.findTabForModel(this.model);
                assert (unitTab != null);
                Map<String, Boolean> map = UnitCategoryTableModel.captureState(this.model.getUnits());
                this.localDownloadSupport.addUpdateUnits(list.toArray(new File[0]));
                unitTab.updateTab(map);
                this.outer.setSelectedTab(unitTab);
            }
            dropTargetDropEvent.dropComplete(true);
        }
        catch (Exception exception) {
            dropTargetDropEvent.dropComplete(false);
            Exceptions.printStackTrace((Throwable)exception);
        }
    }
}

