﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ram/RAM_EXPORTS.h>
#include <aws/ram/RAMRequest.h>
#include <aws/ram/model/ResourceOwner.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
namespace RAM
{
namespace Model
{

  /**
   */
  class AWS_RAM_API ListPrincipalsRequest : public RAMRequest
  {
  public:
    ListPrincipalsRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "ListPrincipals"; }

    Aws::String SerializePayload() const override;


    /**
     * <p>The type of owner.</p>
     */
    inline const ResourceOwner& GetResourceOwner() const{ return m_resourceOwner; }

    /**
     * <p>The type of owner.</p>
     */
    inline bool ResourceOwnerHasBeenSet() const { return m_resourceOwnerHasBeenSet; }

    /**
     * <p>The type of owner.</p>
     */
    inline void SetResourceOwner(const ResourceOwner& value) { m_resourceOwnerHasBeenSet = true; m_resourceOwner = value; }

    /**
     * <p>The type of owner.</p>
     */
    inline void SetResourceOwner(ResourceOwner&& value) { m_resourceOwnerHasBeenSet = true; m_resourceOwner = std::move(value); }

    /**
     * <p>The type of owner.</p>
     */
    inline ListPrincipalsRequest& WithResourceOwner(const ResourceOwner& value) { SetResourceOwner(value); return *this;}

    /**
     * <p>The type of owner.</p>
     */
    inline ListPrincipalsRequest& WithResourceOwner(ResourceOwner&& value) { SetResourceOwner(std::move(value)); return *this;}


    /**
     * <p>The Amazon Resource Name (ARN) of the resource.</p>
     */
    inline const Aws::String& GetResourceArn() const{ return m_resourceArn; }

    /**
     * <p>The Amazon Resource Name (ARN) of the resource.</p>
     */
    inline bool ResourceArnHasBeenSet() const { return m_resourceArnHasBeenSet; }

    /**
     * <p>The Amazon Resource Name (ARN) of the resource.</p>
     */
    inline void SetResourceArn(const Aws::String& value) { m_resourceArnHasBeenSet = true; m_resourceArn = value; }

    /**
     * <p>The Amazon Resource Name (ARN) of the resource.</p>
     */
    inline void SetResourceArn(Aws::String&& value) { m_resourceArnHasBeenSet = true; m_resourceArn = std::move(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the resource.</p>
     */
    inline void SetResourceArn(const char* value) { m_resourceArnHasBeenSet = true; m_resourceArn.assign(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the resource.</p>
     */
    inline ListPrincipalsRequest& WithResourceArn(const Aws::String& value) { SetResourceArn(value); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the resource.</p>
     */
    inline ListPrincipalsRequest& WithResourceArn(Aws::String&& value) { SetResourceArn(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the resource.</p>
     */
    inline ListPrincipalsRequest& WithResourceArn(const char* value) { SetResourceArn(value); return *this;}


    /**
     * <p>The principals.</p>
     */
    inline const Aws::Vector<Aws::String>& GetPrincipals() const{ return m_principals; }

    /**
     * <p>The principals.</p>
     */
    inline bool PrincipalsHasBeenSet() const { return m_principalsHasBeenSet; }

    /**
     * <p>The principals.</p>
     */
    inline void SetPrincipals(const Aws::Vector<Aws::String>& value) { m_principalsHasBeenSet = true; m_principals = value; }

    /**
     * <p>The principals.</p>
     */
    inline void SetPrincipals(Aws::Vector<Aws::String>&& value) { m_principalsHasBeenSet = true; m_principals = std::move(value); }

    /**
     * <p>The principals.</p>
     */
    inline ListPrincipalsRequest& WithPrincipals(const Aws::Vector<Aws::String>& value) { SetPrincipals(value); return *this;}

    /**
     * <p>The principals.</p>
     */
    inline ListPrincipalsRequest& WithPrincipals(Aws::Vector<Aws::String>&& value) { SetPrincipals(std::move(value)); return *this;}

    /**
     * <p>The principals.</p>
     */
    inline ListPrincipalsRequest& AddPrincipals(const Aws::String& value) { m_principalsHasBeenSet = true; m_principals.push_back(value); return *this; }

    /**
     * <p>The principals.</p>
     */
    inline ListPrincipalsRequest& AddPrincipals(Aws::String&& value) { m_principalsHasBeenSet = true; m_principals.push_back(std::move(value)); return *this; }

    /**
     * <p>The principals.</p>
     */
    inline ListPrincipalsRequest& AddPrincipals(const char* value) { m_principalsHasBeenSet = true; m_principals.push_back(value); return *this; }


    /**
     * <p>The resource type.</p> <p>Valid values:
     * <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> |
     * <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> |
     * <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> |
     * <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> |
     * <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> |
     * <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> |
     * <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> |
     * <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> |
     * <code>glue:Database</code> | <code>glue:Table</code> |
     * <code>license-manager:LicenseConfiguration</code> I
     * <code>network-firewall:FirewallPolicy</code> |
     * <code>network-firewall:StatefulRuleGroup</code> |
     * <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code>
     * | <code>resource-groups:Group</code> | <code>rds:Cluster</code> |
     * <code>route53resolver:FirewallRuleGroup</code>
     * |<code>route53resolver:ResolverQueryLogConfig</code> |
     * <code>route53resolver:ResolverRule</code> </p>
     */
    inline const Aws::String& GetResourceType() const{ return m_resourceType; }

    /**
     * <p>The resource type.</p> <p>Valid values:
     * <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> |
     * <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> |
     * <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> |
     * <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> |
     * <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> |
     * <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> |
     * <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> |
     * <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> |
     * <code>glue:Database</code> | <code>glue:Table</code> |
     * <code>license-manager:LicenseConfiguration</code> I
     * <code>network-firewall:FirewallPolicy</code> |
     * <code>network-firewall:StatefulRuleGroup</code> |
     * <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code>
     * | <code>resource-groups:Group</code> | <code>rds:Cluster</code> |
     * <code>route53resolver:FirewallRuleGroup</code>
     * |<code>route53resolver:ResolverQueryLogConfig</code> |
     * <code>route53resolver:ResolverRule</code> </p>
     */
    inline bool ResourceTypeHasBeenSet() const { return m_resourceTypeHasBeenSet; }

    /**
     * <p>The resource type.</p> <p>Valid values:
     * <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> |
     * <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> |
     * <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> |
     * <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> |
     * <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> |
     * <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> |
     * <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> |
     * <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> |
     * <code>glue:Database</code> | <code>glue:Table</code> |
     * <code>license-manager:LicenseConfiguration</code> I
     * <code>network-firewall:FirewallPolicy</code> |
     * <code>network-firewall:StatefulRuleGroup</code> |
     * <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code>
     * | <code>resource-groups:Group</code> | <code>rds:Cluster</code> |
     * <code>route53resolver:FirewallRuleGroup</code>
     * |<code>route53resolver:ResolverQueryLogConfig</code> |
     * <code>route53resolver:ResolverRule</code> </p>
     */
    inline void SetResourceType(const Aws::String& value) { m_resourceTypeHasBeenSet = true; m_resourceType = value; }

    /**
     * <p>The resource type.</p> <p>Valid values:
     * <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> |
     * <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> |
     * <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> |
     * <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> |
     * <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> |
     * <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> |
     * <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> |
     * <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> |
     * <code>glue:Database</code> | <code>glue:Table</code> |
     * <code>license-manager:LicenseConfiguration</code> I
     * <code>network-firewall:FirewallPolicy</code> |
     * <code>network-firewall:StatefulRuleGroup</code> |
     * <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code>
     * | <code>resource-groups:Group</code> | <code>rds:Cluster</code> |
     * <code>route53resolver:FirewallRuleGroup</code>
     * |<code>route53resolver:ResolverQueryLogConfig</code> |
     * <code>route53resolver:ResolverRule</code> </p>
     */
    inline void SetResourceType(Aws::String&& value) { m_resourceTypeHasBeenSet = true; m_resourceType = std::move(value); }

    /**
     * <p>The resource type.</p> <p>Valid values:
     * <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> |
     * <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> |
     * <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> |
     * <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> |
     * <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> |
     * <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> |
     * <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> |
     * <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> |
     * <code>glue:Database</code> | <code>glue:Table</code> |
     * <code>license-manager:LicenseConfiguration</code> I
     * <code>network-firewall:FirewallPolicy</code> |
     * <code>network-firewall:StatefulRuleGroup</code> |
     * <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code>
     * | <code>resource-groups:Group</code> | <code>rds:Cluster</code> |
     * <code>route53resolver:FirewallRuleGroup</code>
     * |<code>route53resolver:ResolverQueryLogConfig</code> |
     * <code>route53resolver:ResolverRule</code> </p>
     */
    inline void SetResourceType(const char* value) { m_resourceTypeHasBeenSet = true; m_resourceType.assign(value); }

    /**
     * <p>The resource type.</p> <p>Valid values:
     * <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> |
     * <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> |
     * <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> |
     * <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> |
     * <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> |
     * <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> |
     * <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> |
     * <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> |
     * <code>glue:Database</code> | <code>glue:Table</code> |
     * <code>license-manager:LicenseConfiguration</code> I
     * <code>network-firewall:FirewallPolicy</code> |
     * <code>network-firewall:StatefulRuleGroup</code> |
     * <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code>
     * | <code>resource-groups:Group</code> | <code>rds:Cluster</code> |
     * <code>route53resolver:FirewallRuleGroup</code>
     * |<code>route53resolver:ResolverQueryLogConfig</code> |
     * <code>route53resolver:ResolverRule</code> </p>
     */
    inline ListPrincipalsRequest& WithResourceType(const Aws::String& value) { SetResourceType(value); return *this;}

    /**
     * <p>The resource type.</p> <p>Valid values:
     * <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> |
     * <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> |
     * <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> |
     * <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> |
     * <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> |
     * <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> |
     * <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> |
     * <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> |
     * <code>glue:Database</code> | <code>glue:Table</code> |
     * <code>license-manager:LicenseConfiguration</code> I
     * <code>network-firewall:FirewallPolicy</code> |
     * <code>network-firewall:StatefulRuleGroup</code> |
     * <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code>
     * | <code>resource-groups:Group</code> | <code>rds:Cluster</code> |
     * <code>route53resolver:FirewallRuleGroup</code>
     * |<code>route53resolver:ResolverQueryLogConfig</code> |
     * <code>route53resolver:ResolverRule</code> </p>
     */
    inline ListPrincipalsRequest& WithResourceType(Aws::String&& value) { SetResourceType(std::move(value)); return *this;}

    /**
     * <p>The resource type.</p> <p>Valid values:
     * <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> |
     * <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> |
     * <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> |
     * <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> |
     * <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> |
     * <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> |
     * <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> |
     * <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> |
     * <code>glue:Database</code> | <code>glue:Table</code> |
     * <code>license-manager:LicenseConfiguration</code> I
     * <code>network-firewall:FirewallPolicy</code> |
     * <code>network-firewall:StatefulRuleGroup</code> |
     * <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code>
     * | <code>resource-groups:Group</code> | <code>rds:Cluster</code> |
     * <code>route53resolver:FirewallRuleGroup</code>
     * |<code>route53resolver:ResolverQueryLogConfig</code> |
     * <code>route53resolver:ResolverRule</code> </p>
     */
    inline ListPrincipalsRequest& WithResourceType(const char* value) { SetResourceType(value); return *this;}


    /**
     * <p>The Amazon Resource Names (ARN) of the resource shares.</p>
     */
    inline const Aws::Vector<Aws::String>& GetResourceShareArns() const{ return m_resourceShareArns; }

    /**
     * <p>The Amazon Resource Names (ARN) of the resource shares.</p>
     */
    inline bool ResourceShareArnsHasBeenSet() const { return m_resourceShareArnsHasBeenSet; }

    /**
     * <p>The Amazon Resource Names (ARN) of the resource shares.</p>
     */
    inline void SetResourceShareArns(const Aws::Vector<Aws::String>& value) { m_resourceShareArnsHasBeenSet = true; m_resourceShareArns = value; }

    /**
     * <p>The Amazon Resource Names (ARN) of the resource shares.</p>
     */
    inline void SetResourceShareArns(Aws::Vector<Aws::String>&& value) { m_resourceShareArnsHasBeenSet = true; m_resourceShareArns = std::move(value); }

    /**
     * <p>The Amazon Resource Names (ARN) of the resource shares.</p>
     */
    inline ListPrincipalsRequest& WithResourceShareArns(const Aws::Vector<Aws::String>& value) { SetResourceShareArns(value); return *this;}

    /**
     * <p>The Amazon Resource Names (ARN) of the resource shares.</p>
     */
    inline ListPrincipalsRequest& WithResourceShareArns(Aws::Vector<Aws::String>&& value) { SetResourceShareArns(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Names (ARN) of the resource shares.</p>
     */
    inline ListPrincipalsRequest& AddResourceShareArns(const Aws::String& value) { m_resourceShareArnsHasBeenSet = true; m_resourceShareArns.push_back(value); return *this; }

    /**
     * <p>The Amazon Resource Names (ARN) of the resource shares.</p>
     */
    inline ListPrincipalsRequest& AddResourceShareArns(Aws::String&& value) { m_resourceShareArnsHasBeenSet = true; m_resourceShareArns.push_back(std::move(value)); return *this; }

    /**
     * <p>The Amazon Resource Names (ARN) of the resource shares.</p>
     */
    inline ListPrincipalsRequest& AddResourceShareArns(const char* value) { m_resourceShareArnsHasBeenSet = true; m_resourceShareArns.push_back(value); return *this; }


    /**
     * <p>The token for the next page of results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>The token for the next page of results.</p>
     */
    inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }

    /**
     * <p>The token for the next page of results.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextTokenHasBeenSet = true; m_nextToken = value; }

    /**
     * <p>The token for the next page of results.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::move(value); }

    /**
     * <p>The token for the next page of results.</p>
     */
    inline void SetNextToken(const char* value) { m_nextTokenHasBeenSet = true; m_nextToken.assign(value); }

    /**
     * <p>The token for the next page of results.</p>
     */
    inline ListPrincipalsRequest& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>The token for the next page of results.</p>
     */
    inline ListPrincipalsRequest& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>The token for the next page of results.</p>
     */
    inline ListPrincipalsRequest& WithNextToken(const char* value) { SetNextToken(value); return *this;}


    /**
     * <p>The maximum number of results to return with a single call. To retrieve the
     * remaining results, make another call with the returned <code>nextToken</code>
     * value.</p>
     */
    inline int GetMaxResults() const{ return m_maxResults; }

    /**
     * <p>The maximum number of results to return with a single call. To retrieve the
     * remaining results, make another call with the returned <code>nextToken</code>
     * value.</p>
     */
    inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }

    /**
     * <p>The maximum number of results to return with a single call. To retrieve the
     * remaining results, make another call with the returned <code>nextToken</code>
     * value.</p>
     */
    inline void SetMaxResults(int value) { m_maxResultsHasBeenSet = true; m_maxResults = value; }

    /**
     * <p>The maximum number of results to return with a single call. To retrieve the
     * remaining results, make another call with the returned <code>nextToken</code>
     * value.</p>
     */
    inline ListPrincipalsRequest& WithMaxResults(int value) { SetMaxResults(value); return *this;}

  private:

    ResourceOwner m_resourceOwner;
    bool m_resourceOwnerHasBeenSet;

    Aws::String m_resourceArn;
    bool m_resourceArnHasBeenSet;

    Aws::Vector<Aws::String> m_principals;
    bool m_principalsHasBeenSet;

    Aws::String m_resourceType;
    bool m_resourceTypeHasBeenSet;

    Aws::Vector<Aws::String> m_resourceShareArns;
    bool m_resourceShareArnsHasBeenSet;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet;

    int m_maxResults;
    bool m_maxResultsHasBeenSet;
  };

} // namespace Model
} // namespace RAM
} // namespace Aws
