﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/securityhub/model/StringFilter.h>
#include <aws/securityhub/model/DateFilter.h>
#include <aws/securityhub/model/NumberFilter.h>
#include <aws/securityhub/model/MapFilter.h>
#include <aws/securityhub/model/IpFilter.h>
#include <aws/securityhub/model/KeywordFilter.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p>A collection of attributes that are applied to all active Security
   * Hub-aggregated findings and that result in a subset of findings that are
   * included in this insight.</p> <p>You can filter by up to 10 finding attributes.
   * For each attribute, you can provide up to 20 filter values.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsSecurityFindingFilters">AWS
   * API Reference</a></p>
   */
  class AWS_SECURITYHUB_API AwsSecurityFindingFilters
  {
  public:
    AwsSecurityFindingFilters();
    AwsSecurityFindingFilters(Aws::Utils::Json::JsonView jsonValue);
    AwsSecurityFindingFilters& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The ARN generated by Security Hub that uniquely identifies a third-party
     * company (security findings provider) after this provider's product (solution
     * that generates findings) is registered with Security Hub.</p>
     */
    inline const Aws::Vector<StringFilter>& GetProductArn() const{ return m_productArn; }

    /**
     * <p>The ARN generated by Security Hub that uniquely identifies a third-party
     * company (security findings provider) after this provider's product (solution
     * that generates findings) is registered with Security Hub.</p>
     */
    inline bool ProductArnHasBeenSet() const { return m_productArnHasBeenSet; }

    /**
     * <p>The ARN generated by Security Hub that uniquely identifies a third-party
     * company (security findings provider) after this provider's product (solution
     * that generates findings) is registered with Security Hub.</p>
     */
    inline void SetProductArn(const Aws::Vector<StringFilter>& value) { m_productArnHasBeenSet = true; m_productArn = value; }

    /**
     * <p>The ARN generated by Security Hub that uniquely identifies a third-party
     * company (security findings provider) after this provider's product (solution
     * that generates findings) is registered with Security Hub.</p>
     */
    inline void SetProductArn(Aws::Vector<StringFilter>&& value) { m_productArnHasBeenSet = true; m_productArn = std::move(value); }

    /**
     * <p>The ARN generated by Security Hub that uniquely identifies a third-party
     * company (security findings provider) after this provider's product (solution
     * that generates findings) is registered with Security Hub.</p>
     */
    inline AwsSecurityFindingFilters& WithProductArn(const Aws::Vector<StringFilter>& value) { SetProductArn(value); return *this;}

    /**
     * <p>The ARN generated by Security Hub that uniquely identifies a third-party
     * company (security findings provider) after this provider's product (solution
     * that generates findings) is registered with Security Hub.</p>
     */
    inline AwsSecurityFindingFilters& WithProductArn(Aws::Vector<StringFilter>&& value) { SetProductArn(std::move(value)); return *this;}

    /**
     * <p>The ARN generated by Security Hub that uniquely identifies a third-party
     * company (security findings provider) after this provider's product (solution
     * that generates findings) is registered with Security Hub.</p>
     */
    inline AwsSecurityFindingFilters& AddProductArn(const StringFilter& value) { m_productArnHasBeenSet = true; m_productArn.push_back(value); return *this; }

    /**
     * <p>The ARN generated by Security Hub that uniquely identifies a third-party
     * company (security findings provider) after this provider's product (solution
     * that generates findings) is registered with Security Hub.</p>
     */
    inline AwsSecurityFindingFilters& AddProductArn(StringFilter&& value) { m_productArnHasBeenSet = true; m_productArn.push_back(std::move(value)); return *this; }


    /**
     * <p>The AWS account ID that a finding is generated in.</p>
     */
    inline const Aws::Vector<StringFilter>& GetAwsAccountId() const{ return m_awsAccountId; }

    /**
     * <p>The AWS account ID that a finding is generated in.</p>
     */
    inline bool AwsAccountIdHasBeenSet() const { return m_awsAccountIdHasBeenSet; }

    /**
     * <p>The AWS account ID that a finding is generated in.</p>
     */
    inline void SetAwsAccountId(const Aws::Vector<StringFilter>& value) { m_awsAccountIdHasBeenSet = true; m_awsAccountId = value; }

    /**
     * <p>The AWS account ID that a finding is generated in.</p>
     */
    inline void SetAwsAccountId(Aws::Vector<StringFilter>&& value) { m_awsAccountIdHasBeenSet = true; m_awsAccountId = std::move(value); }

    /**
     * <p>The AWS account ID that a finding is generated in.</p>
     */
    inline AwsSecurityFindingFilters& WithAwsAccountId(const Aws::Vector<StringFilter>& value) { SetAwsAccountId(value); return *this;}

    /**
     * <p>The AWS account ID that a finding is generated in.</p>
     */
    inline AwsSecurityFindingFilters& WithAwsAccountId(Aws::Vector<StringFilter>&& value) { SetAwsAccountId(std::move(value)); return *this;}

    /**
     * <p>The AWS account ID that a finding is generated in.</p>
     */
    inline AwsSecurityFindingFilters& AddAwsAccountId(const StringFilter& value) { m_awsAccountIdHasBeenSet = true; m_awsAccountId.push_back(value); return *this; }

    /**
     * <p>The AWS account ID that a finding is generated in.</p>
     */
    inline AwsSecurityFindingFilters& AddAwsAccountId(StringFilter&& value) { m_awsAccountIdHasBeenSet = true; m_awsAccountId.push_back(std::move(value)); return *this; }


    /**
     * <p>The security findings provider-specific identifier for a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetId() const{ return m_id; }

    /**
     * <p>The security findings provider-specific identifier for a finding.</p>
     */
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }

    /**
     * <p>The security findings provider-specific identifier for a finding.</p>
     */
    inline void SetId(const Aws::Vector<StringFilter>& value) { m_idHasBeenSet = true; m_id = value; }

    /**
     * <p>The security findings provider-specific identifier for a finding.</p>
     */
    inline void SetId(Aws::Vector<StringFilter>&& value) { m_idHasBeenSet = true; m_id = std::move(value); }

    /**
     * <p>The security findings provider-specific identifier for a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithId(const Aws::Vector<StringFilter>& value) { SetId(value); return *this;}

    /**
     * <p>The security findings provider-specific identifier for a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithId(Aws::Vector<StringFilter>&& value) { SetId(std::move(value)); return *this;}

    /**
     * <p>The security findings provider-specific identifier for a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddId(const StringFilter& value) { m_idHasBeenSet = true; m_id.push_back(value); return *this; }

    /**
     * <p>The security findings provider-specific identifier for a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddId(StringFilter&& value) { m_idHasBeenSet = true; m_id.push_back(std::move(value)); return *this; }


    /**
     * <p>The identifier for the solution-specific component (a discrete unit of logic)
     * that generated a finding. In various security-findings providers' solutions,
     * this generator can be called a rule, a check, a detector, a plugin, etc.</p>
     */
    inline const Aws::Vector<StringFilter>& GetGeneratorId() const{ return m_generatorId; }

    /**
     * <p>The identifier for the solution-specific component (a discrete unit of logic)
     * that generated a finding. In various security-findings providers' solutions,
     * this generator can be called a rule, a check, a detector, a plugin, etc.</p>
     */
    inline bool GeneratorIdHasBeenSet() const { return m_generatorIdHasBeenSet; }

    /**
     * <p>The identifier for the solution-specific component (a discrete unit of logic)
     * that generated a finding. In various security-findings providers' solutions,
     * this generator can be called a rule, a check, a detector, a plugin, etc.</p>
     */
    inline void SetGeneratorId(const Aws::Vector<StringFilter>& value) { m_generatorIdHasBeenSet = true; m_generatorId = value; }

    /**
     * <p>The identifier for the solution-specific component (a discrete unit of logic)
     * that generated a finding. In various security-findings providers' solutions,
     * this generator can be called a rule, a check, a detector, a plugin, etc.</p>
     */
    inline void SetGeneratorId(Aws::Vector<StringFilter>&& value) { m_generatorIdHasBeenSet = true; m_generatorId = std::move(value); }

    /**
     * <p>The identifier for the solution-specific component (a discrete unit of logic)
     * that generated a finding. In various security-findings providers' solutions,
     * this generator can be called a rule, a check, a detector, a plugin, etc.</p>
     */
    inline AwsSecurityFindingFilters& WithGeneratorId(const Aws::Vector<StringFilter>& value) { SetGeneratorId(value); return *this;}

    /**
     * <p>The identifier for the solution-specific component (a discrete unit of logic)
     * that generated a finding. In various security-findings providers' solutions,
     * this generator can be called a rule, a check, a detector, a plugin, etc.</p>
     */
    inline AwsSecurityFindingFilters& WithGeneratorId(Aws::Vector<StringFilter>&& value) { SetGeneratorId(std::move(value)); return *this;}

    /**
     * <p>The identifier for the solution-specific component (a discrete unit of logic)
     * that generated a finding. In various security-findings providers' solutions,
     * this generator can be called a rule, a check, a detector, a plugin, etc.</p>
     */
    inline AwsSecurityFindingFilters& AddGeneratorId(const StringFilter& value) { m_generatorIdHasBeenSet = true; m_generatorId.push_back(value); return *this; }

    /**
     * <p>The identifier for the solution-specific component (a discrete unit of logic)
     * that generated a finding. In various security-findings providers' solutions,
     * this generator can be called a rule, a check, a detector, a plugin, etc.</p>
     */
    inline AwsSecurityFindingFilters& AddGeneratorId(StringFilter&& value) { m_generatorIdHasBeenSet = true; m_generatorId.push_back(std::move(value)); return *this; }


    /**
     * <p>A finding type in the format of <code>namespace/category/classifier</code>
     * that classifies a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetType() const{ return m_type; }

    /**
     * <p>A finding type in the format of <code>namespace/category/classifier</code>
     * that classifies a finding.</p>
     */
    inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }

    /**
     * <p>A finding type in the format of <code>namespace/category/classifier</code>
     * that classifies a finding.</p>
     */
    inline void SetType(const Aws::Vector<StringFilter>& value) { m_typeHasBeenSet = true; m_type = value; }

    /**
     * <p>A finding type in the format of <code>namespace/category/classifier</code>
     * that classifies a finding.</p>
     */
    inline void SetType(Aws::Vector<StringFilter>&& value) { m_typeHasBeenSet = true; m_type = std::move(value); }

    /**
     * <p>A finding type in the format of <code>namespace/category/classifier</code>
     * that classifies a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithType(const Aws::Vector<StringFilter>& value) { SetType(value); return *this;}

    /**
     * <p>A finding type in the format of <code>namespace/category/classifier</code>
     * that classifies a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithType(Aws::Vector<StringFilter>&& value) { SetType(std::move(value)); return *this;}

    /**
     * <p>A finding type in the format of <code>namespace/category/classifier</code>
     * that classifies a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddType(const StringFilter& value) { m_typeHasBeenSet = true; m_type.push_back(value); return *this; }

    /**
     * <p>A finding type in the format of <code>namespace/category/classifier</code>
     * that classifies a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddType(StringFilter&& value) { m_typeHasBeenSet = true; m_type.push_back(std::move(value)); return *this; }


    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider first observed the potential security issue that a finding
     * captured.</p>
     */
    inline const Aws::Vector<DateFilter>& GetFirstObservedAt() const{ return m_firstObservedAt; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider first observed the potential security issue that a finding
     * captured.</p>
     */
    inline bool FirstObservedAtHasBeenSet() const { return m_firstObservedAtHasBeenSet; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider first observed the potential security issue that a finding
     * captured.</p>
     */
    inline void SetFirstObservedAt(const Aws::Vector<DateFilter>& value) { m_firstObservedAtHasBeenSet = true; m_firstObservedAt = value; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider first observed the potential security issue that a finding
     * captured.</p>
     */
    inline void SetFirstObservedAt(Aws::Vector<DateFilter>&& value) { m_firstObservedAtHasBeenSet = true; m_firstObservedAt = std::move(value); }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider first observed the potential security issue that a finding
     * captured.</p>
     */
    inline AwsSecurityFindingFilters& WithFirstObservedAt(const Aws::Vector<DateFilter>& value) { SetFirstObservedAt(value); return *this;}

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider first observed the potential security issue that a finding
     * captured.</p>
     */
    inline AwsSecurityFindingFilters& WithFirstObservedAt(Aws::Vector<DateFilter>&& value) { SetFirstObservedAt(std::move(value)); return *this;}

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider first observed the potential security issue that a finding
     * captured.</p>
     */
    inline AwsSecurityFindingFilters& AddFirstObservedAt(const DateFilter& value) { m_firstObservedAtHasBeenSet = true; m_firstObservedAt.push_back(value); return *this; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider first observed the potential security issue that a finding
     * captured.</p>
     */
    inline AwsSecurityFindingFilters& AddFirstObservedAt(DateFilter&& value) { m_firstObservedAtHasBeenSet = true; m_firstObservedAt.push_back(std::move(value)); return *this; }


    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider most recently observed the potential security issue that a finding
     * captured.</p>
     */
    inline const Aws::Vector<DateFilter>& GetLastObservedAt() const{ return m_lastObservedAt; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider most recently observed the potential security issue that a finding
     * captured.</p>
     */
    inline bool LastObservedAtHasBeenSet() const { return m_lastObservedAtHasBeenSet; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider most recently observed the potential security issue that a finding
     * captured.</p>
     */
    inline void SetLastObservedAt(const Aws::Vector<DateFilter>& value) { m_lastObservedAtHasBeenSet = true; m_lastObservedAt = value; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider most recently observed the potential security issue that a finding
     * captured.</p>
     */
    inline void SetLastObservedAt(Aws::Vector<DateFilter>&& value) { m_lastObservedAtHasBeenSet = true; m_lastObservedAt = std::move(value); }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider most recently observed the potential security issue that a finding
     * captured.</p>
     */
    inline AwsSecurityFindingFilters& WithLastObservedAt(const Aws::Vector<DateFilter>& value) { SetLastObservedAt(value); return *this;}

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider most recently observed the potential security issue that a finding
     * captured.</p>
     */
    inline AwsSecurityFindingFilters& WithLastObservedAt(Aws::Vector<DateFilter>&& value) { SetLastObservedAt(std::move(value)); return *this;}

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider most recently observed the potential security issue that a finding
     * captured.</p>
     */
    inline AwsSecurityFindingFilters& AddLastObservedAt(const DateFilter& value) { m_lastObservedAtHasBeenSet = true; m_lastObservedAt.push_back(value); return *this; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider most recently observed the potential security issue that a finding
     * captured.</p>
     */
    inline AwsSecurityFindingFilters& AddLastObservedAt(DateFilter&& value) { m_lastObservedAtHasBeenSet = true; m_lastObservedAt.push_back(std::move(value)); return *this; }


    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider captured the potential security issue that a finding captured.</p>
     */
    inline const Aws::Vector<DateFilter>& GetCreatedAt() const{ return m_createdAt; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider captured the potential security issue that a finding captured.</p>
     */
    inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider captured the potential security issue that a finding captured.</p>
     */
    inline void SetCreatedAt(const Aws::Vector<DateFilter>& value) { m_createdAtHasBeenSet = true; m_createdAt = value; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider captured the potential security issue that a finding captured.</p>
     */
    inline void SetCreatedAt(Aws::Vector<DateFilter>&& value) { m_createdAtHasBeenSet = true; m_createdAt = std::move(value); }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider captured the potential security issue that a finding captured.</p>
     */
    inline AwsSecurityFindingFilters& WithCreatedAt(const Aws::Vector<DateFilter>& value) { SetCreatedAt(value); return *this;}

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider captured the potential security issue that a finding captured.</p>
     */
    inline AwsSecurityFindingFilters& WithCreatedAt(Aws::Vector<DateFilter>&& value) { SetCreatedAt(std::move(value)); return *this;}

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider captured the potential security issue that a finding captured.</p>
     */
    inline AwsSecurityFindingFilters& AddCreatedAt(const DateFilter& value) { m_createdAtHasBeenSet = true; m_createdAt.push_back(value); return *this; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider captured the potential security issue that a finding captured.</p>
     */
    inline AwsSecurityFindingFilters& AddCreatedAt(DateFilter&& value) { m_createdAtHasBeenSet = true; m_createdAt.push_back(std::move(value)); return *this; }


    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider last updated the finding record. </p>
     */
    inline const Aws::Vector<DateFilter>& GetUpdatedAt() const{ return m_updatedAt; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider last updated the finding record. </p>
     */
    inline bool UpdatedAtHasBeenSet() const { return m_updatedAtHasBeenSet; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider last updated the finding record. </p>
     */
    inline void SetUpdatedAt(const Aws::Vector<DateFilter>& value) { m_updatedAtHasBeenSet = true; m_updatedAt = value; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider last updated the finding record. </p>
     */
    inline void SetUpdatedAt(Aws::Vector<DateFilter>&& value) { m_updatedAtHasBeenSet = true; m_updatedAt = std::move(value); }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider last updated the finding record. </p>
     */
    inline AwsSecurityFindingFilters& WithUpdatedAt(const Aws::Vector<DateFilter>& value) { SetUpdatedAt(value); return *this;}

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider last updated the finding record. </p>
     */
    inline AwsSecurityFindingFilters& WithUpdatedAt(Aws::Vector<DateFilter>&& value) { SetUpdatedAt(std::move(value)); return *this;}

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider last updated the finding record. </p>
     */
    inline AwsSecurityFindingFilters& AddUpdatedAt(const DateFilter& value) { m_updatedAtHasBeenSet = true; m_updatedAt.push_back(value); return *this; }

    /**
     * <p>An ISO8601-formatted timestamp that indicates when the security-findings
     * provider last updated the finding record. </p>
     */
    inline AwsSecurityFindingFilters& AddUpdatedAt(DateFilter&& value) { m_updatedAtHasBeenSet = true; m_updatedAt.push_back(std::move(value)); return *this; }


    /**
     * <p>The label of a finding's severity.</p>
     */
    inline const Aws::Vector<StringFilter>& GetSeverityLabel() const{ return m_severityLabel; }

    /**
     * <p>The label of a finding's severity.</p>
     */
    inline bool SeverityLabelHasBeenSet() const { return m_severityLabelHasBeenSet; }

    /**
     * <p>The label of a finding's severity.</p>
     */
    inline void SetSeverityLabel(const Aws::Vector<StringFilter>& value) { m_severityLabelHasBeenSet = true; m_severityLabel = value; }

    /**
     * <p>The label of a finding's severity.</p>
     */
    inline void SetSeverityLabel(Aws::Vector<StringFilter>&& value) { m_severityLabelHasBeenSet = true; m_severityLabel = std::move(value); }

    /**
     * <p>The label of a finding's severity.</p>
     */
    inline AwsSecurityFindingFilters& WithSeverityLabel(const Aws::Vector<StringFilter>& value) { SetSeverityLabel(value); return *this;}

    /**
     * <p>The label of a finding's severity.</p>
     */
    inline AwsSecurityFindingFilters& WithSeverityLabel(Aws::Vector<StringFilter>&& value) { SetSeverityLabel(std::move(value)); return *this;}

    /**
     * <p>The label of a finding's severity.</p>
     */
    inline AwsSecurityFindingFilters& AddSeverityLabel(const StringFilter& value) { m_severityLabelHasBeenSet = true; m_severityLabel.push_back(value); return *this; }

    /**
     * <p>The label of a finding's severity.</p>
     */
    inline AwsSecurityFindingFilters& AddSeverityLabel(StringFilter&& value) { m_severityLabelHasBeenSet = true; m_severityLabel.push_back(std::move(value)); return *this; }


    /**
     * <p>A finding's confidence. Confidence is defined as the likelihood that a
     * finding accurately identifies the behavior or issue that it was intended to
     * identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale,
     * where 0 means zero percent confidence and 100 means 100 percent confidence.</p>
     */
    inline const Aws::Vector<NumberFilter>& GetConfidence() const{ return m_confidence; }

    /**
     * <p>A finding's confidence. Confidence is defined as the likelihood that a
     * finding accurately identifies the behavior or issue that it was intended to
     * identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale,
     * where 0 means zero percent confidence and 100 means 100 percent confidence.</p>
     */
    inline bool ConfidenceHasBeenSet() const { return m_confidenceHasBeenSet; }

    /**
     * <p>A finding's confidence. Confidence is defined as the likelihood that a
     * finding accurately identifies the behavior or issue that it was intended to
     * identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale,
     * where 0 means zero percent confidence and 100 means 100 percent confidence.</p>
     */
    inline void SetConfidence(const Aws::Vector<NumberFilter>& value) { m_confidenceHasBeenSet = true; m_confidence = value; }

    /**
     * <p>A finding's confidence. Confidence is defined as the likelihood that a
     * finding accurately identifies the behavior or issue that it was intended to
     * identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale,
     * where 0 means zero percent confidence and 100 means 100 percent confidence.</p>
     */
    inline void SetConfidence(Aws::Vector<NumberFilter>&& value) { m_confidenceHasBeenSet = true; m_confidence = std::move(value); }

    /**
     * <p>A finding's confidence. Confidence is defined as the likelihood that a
     * finding accurately identifies the behavior or issue that it was intended to
     * identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale,
     * where 0 means zero percent confidence and 100 means 100 percent confidence.</p>
     */
    inline AwsSecurityFindingFilters& WithConfidence(const Aws::Vector<NumberFilter>& value) { SetConfidence(value); return *this;}

    /**
     * <p>A finding's confidence. Confidence is defined as the likelihood that a
     * finding accurately identifies the behavior or issue that it was intended to
     * identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale,
     * where 0 means zero percent confidence and 100 means 100 percent confidence.</p>
     */
    inline AwsSecurityFindingFilters& WithConfidence(Aws::Vector<NumberFilter>&& value) { SetConfidence(std::move(value)); return *this;}

    /**
     * <p>A finding's confidence. Confidence is defined as the likelihood that a
     * finding accurately identifies the behavior or issue that it was intended to
     * identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale,
     * where 0 means zero percent confidence and 100 means 100 percent confidence.</p>
     */
    inline AwsSecurityFindingFilters& AddConfidence(const NumberFilter& value) { m_confidenceHasBeenSet = true; m_confidence.push_back(value); return *this; }

    /**
     * <p>A finding's confidence. Confidence is defined as the likelihood that a
     * finding accurately identifies the behavior or issue that it was intended to
     * identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale,
     * where 0 means zero percent confidence and 100 means 100 percent confidence.</p>
     */
    inline AwsSecurityFindingFilters& AddConfidence(NumberFilter&& value) { m_confidenceHasBeenSet = true; m_confidence.push_back(std::move(value)); return *this; }


    /**
     * <p>The level of importance assigned to the resources associated with the
     * finding.</p> <p>A score of 0 means that the underlying resources have no
     * criticality, and a score of 100 is reserved for the most critical resources.</p>
     */
    inline const Aws::Vector<NumberFilter>& GetCriticality() const{ return m_criticality; }

    /**
     * <p>The level of importance assigned to the resources associated with the
     * finding.</p> <p>A score of 0 means that the underlying resources have no
     * criticality, and a score of 100 is reserved for the most critical resources.</p>
     */
    inline bool CriticalityHasBeenSet() const { return m_criticalityHasBeenSet; }

    /**
     * <p>The level of importance assigned to the resources associated with the
     * finding.</p> <p>A score of 0 means that the underlying resources have no
     * criticality, and a score of 100 is reserved for the most critical resources.</p>
     */
    inline void SetCriticality(const Aws::Vector<NumberFilter>& value) { m_criticalityHasBeenSet = true; m_criticality = value; }

    /**
     * <p>The level of importance assigned to the resources associated with the
     * finding.</p> <p>A score of 0 means that the underlying resources have no
     * criticality, and a score of 100 is reserved for the most critical resources.</p>
     */
    inline void SetCriticality(Aws::Vector<NumberFilter>&& value) { m_criticalityHasBeenSet = true; m_criticality = std::move(value); }

    /**
     * <p>The level of importance assigned to the resources associated with the
     * finding.</p> <p>A score of 0 means that the underlying resources have no
     * criticality, and a score of 100 is reserved for the most critical resources.</p>
     */
    inline AwsSecurityFindingFilters& WithCriticality(const Aws::Vector<NumberFilter>& value) { SetCriticality(value); return *this;}

    /**
     * <p>The level of importance assigned to the resources associated with the
     * finding.</p> <p>A score of 0 means that the underlying resources have no
     * criticality, and a score of 100 is reserved for the most critical resources.</p>
     */
    inline AwsSecurityFindingFilters& WithCriticality(Aws::Vector<NumberFilter>&& value) { SetCriticality(std::move(value)); return *this;}

    /**
     * <p>The level of importance assigned to the resources associated with the
     * finding.</p> <p>A score of 0 means that the underlying resources have no
     * criticality, and a score of 100 is reserved for the most critical resources.</p>
     */
    inline AwsSecurityFindingFilters& AddCriticality(const NumberFilter& value) { m_criticalityHasBeenSet = true; m_criticality.push_back(value); return *this; }

    /**
     * <p>The level of importance assigned to the resources associated with the
     * finding.</p> <p>A score of 0 means that the underlying resources have no
     * criticality, and a score of 100 is reserved for the most critical resources.</p>
     */
    inline AwsSecurityFindingFilters& AddCriticality(NumberFilter&& value) { m_criticalityHasBeenSet = true; m_criticality.push_back(std::move(value)); return *this; }


    /**
     * <p>A finding's title.</p>
     */
    inline const Aws::Vector<StringFilter>& GetTitle() const{ return m_title; }

    /**
     * <p>A finding's title.</p>
     */
    inline bool TitleHasBeenSet() const { return m_titleHasBeenSet; }

    /**
     * <p>A finding's title.</p>
     */
    inline void SetTitle(const Aws::Vector<StringFilter>& value) { m_titleHasBeenSet = true; m_title = value; }

    /**
     * <p>A finding's title.</p>
     */
    inline void SetTitle(Aws::Vector<StringFilter>&& value) { m_titleHasBeenSet = true; m_title = std::move(value); }

    /**
     * <p>A finding's title.</p>
     */
    inline AwsSecurityFindingFilters& WithTitle(const Aws::Vector<StringFilter>& value) { SetTitle(value); return *this;}

    /**
     * <p>A finding's title.</p>
     */
    inline AwsSecurityFindingFilters& WithTitle(Aws::Vector<StringFilter>&& value) { SetTitle(std::move(value)); return *this;}

    /**
     * <p>A finding's title.</p>
     */
    inline AwsSecurityFindingFilters& AddTitle(const StringFilter& value) { m_titleHasBeenSet = true; m_title.push_back(value); return *this; }

    /**
     * <p>A finding's title.</p>
     */
    inline AwsSecurityFindingFilters& AddTitle(StringFilter&& value) { m_titleHasBeenSet = true; m_title.push_back(std::move(value)); return *this; }


    /**
     * <p>A finding's description.</p>
     */
    inline const Aws::Vector<StringFilter>& GetDescription() const{ return m_description; }

    /**
     * <p>A finding's description.</p>
     */
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }

    /**
     * <p>A finding's description.</p>
     */
    inline void SetDescription(const Aws::Vector<StringFilter>& value) { m_descriptionHasBeenSet = true; m_description = value; }

    /**
     * <p>A finding's description.</p>
     */
    inline void SetDescription(Aws::Vector<StringFilter>&& value) { m_descriptionHasBeenSet = true; m_description = std::move(value); }

    /**
     * <p>A finding's description.</p>
     */
    inline AwsSecurityFindingFilters& WithDescription(const Aws::Vector<StringFilter>& value) { SetDescription(value); return *this;}

    /**
     * <p>A finding's description.</p>
     */
    inline AwsSecurityFindingFilters& WithDescription(Aws::Vector<StringFilter>&& value) { SetDescription(std::move(value)); return *this;}

    /**
     * <p>A finding's description.</p>
     */
    inline AwsSecurityFindingFilters& AddDescription(const StringFilter& value) { m_descriptionHasBeenSet = true; m_description.push_back(value); return *this; }

    /**
     * <p>A finding's description.</p>
     */
    inline AwsSecurityFindingFilters& AddDescription(StringFilter&& value) { m_descriptionHasBeenSet = true; m_description.push_back(std::move(value)); return *this; }


    /**
     * <p>The recommendation of what to do about the issue described in a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetRecommendationText() const{ return m_recommendationText; }

    /**
     * <p>The recommendation of what to do about the issue described in a finding.</p>
     */
    inline bool RecommendationTextHasBeenSet() const { return m_recommendationTextHasBeenSet; }

    /**
     * <p>The recommendation of what to do about the issue described in a finding.</p>
     */
    inline void SetRecommendationText(const Aws::Vector<StringFilter>& value) { m_recommendationTextHasBeenSet = true; m_recommendationText = value; }

    /**
     * <p>The recommendation of what to do about the issue described in a finding.</p>
     */
    inline void SetRecommendationText(Aws::Vector<StringFilter>&& value) { m_recommendationTextHasBeenSet = true; m_recommendationText = std::move(value); }

    /**
     * <p>The recommendation of what to do about the issue described in a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithRecommendationText(const Aws::Vector<StringFilter>& value) { SetRecommendationText(value); return *this;}

    /**
     * <p>The recommendation of what to do about the issue described in a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithRecommendationText(Aws::Vector<StringFilter>&& value) { SetRecommendationText(std::move(value)); return *this;}

    /**
     * <p>The recommendation of what to do about the issue described in a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddRecommendationText(const StringFilter& value) { m_recommendationTextHasBeenSet = true; m_recommendationText.push_back(value); return *this; }

    /**
     * <p>The recommendation of what to do about the issue described in a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddRecommendationText(StringFilter&& value) { m_recommendationTextHasBeenSet = true; m_recommendationText.push_back(std::move(value)); return *this; }


    /**
     * <p>A URL that links to a page about the current finding in the security-findings
     * provider's solution.</p>
     */
    inline const Aws::Vector<StringFilter>& GetSourceUrl() const{ return m_sourceUrl; }

    /**
     * <p>A URL that links to a page about the current finding in the security-findings
     * provider's solution.</p>
     */
    inline bool SourceUrlHasBeenSet() const { return m_sourceUrlHasBeenSet; }

    /**
     * <p>A URL that links to a page about the current finding in the security-findings
     * provider's solution.</p>
     */
    inline void SetSourceUrl(const Aws::Vector<StringFilter>& value) { m_sourceUrlHasBeenSet = true; m_sourceUrl = value; }

    /**
     * <p>A URL that links to a page about the current finding in the security-findings
     * provider's solution.</p>
     */
    inline void SetSourceUrl(Aws::Vector<StringFilter>&& value) { m_sourceUrlHasBeenSet = true; m_sourceUrl = std::move(value); }

    /**
     * <p>A URL that links to a page about the current finding in the security-findings
     * provider's solution.</p>
     */
    inline AwsSecurityFindingFilters& WithSourceUrl(const Aws::Vector<StringFilter>& value) { SetSourceUrl(value); return *this;}

    /**
     * <p>A URL that links to a page about the current finding in the security-findings
     * provider's solution.</p>
     */
    inline AwsSecurityFindingFilters& WithSourceUrl(Aws::Vector<StringFilter>&& value) { SetSourceUrl(std::move(value)); return *this;}

    /**
     * <p>A URL that links to a page about the current finding in the security-findings
     * provider's solution.</p>
     */
    inline AwsSecurityFindingFilters& AddSourceUrl(const StringFilter& value) { m_sourceUrlHasBeenSet = true; m_sourceUrl.push_back(value); return *this; }

    /**
     * <p>A URL that links to a page about the current finding in the security-findings
     * provider's solution.</p>
     */
    inline AwsSecurityFindingFilters& AddSourceUrl(StringFilter&& value) { m_sourceUrlHasBeenSet = true; m_sourceUrl.push_back(std::move(value)); return *this; }


    /**
     * <p>A data type where security-findings providers can include additional
     * solution-specific details that aren't part of the defined
     * <code>AwsSecurityFinding</code> format.</p>
     */
    inline const Aws::Vector<MapFilter>& GetProductFields() const{ return m_productFields; }

    /**
     * <p>A data type where security-findings providers can include additional
     * solution-specific details that aren't part of the defined
     * <code>AwsSecurityFinding</code> format.</p>
     */
    inline bool ProductFieldsHasBeenSet() const { return m_productFieldsHasBeenSet; }

    /**
     * <p>A data type where security-findings providers can include additional
     * solution-specific details that aren't part of the defined
     * <code>AwsSecurityFinding</code> format.</p>
     */
    inline void SetProductFields(const Aws::Vector<MapFilter>& value) { m_productFieldsHasBeenSet = true; m_productFields = value; }

    /**
     * <p>A data type where security-findings providers can include additional
     * solution-specific details that aren't part of the defined
     * <code>AwsSecurityFinding</code> format.</p>
     */
    inline void SetProductFields(Aws::Vector<MapFilter>&& value) { m_productFieldsHasBeenSet = true; m_productFields = std::move(value); }

    /**
     * <p>A data type where security-findings providers can include additional
     * solution-specific details that aren't part of the defined
     * <code>AwsSecurityFinding</code> format.</p>
     */
    inline AwsSecurityFindingFilters& WithProductFields(const Aws::Vector<MapFilter>& value) { SetProductFields(value); return *this;}

    /**
     * <p>A data type where security-findings providers can include additional
     * solution-specific details that aren't part of the defined
     * <code>AwsSecurityFinding</code> format.</p>
     */
    inline AwsSecurityFindingFilters& WithProductFields(Aws::Vector<MapFilter>&& value) { SetProductFields(std::move(value)); return *this;}

    /**
     * <p>A data type where security-findings providers can include additional
     * solution-specific details that aren't part of the defined
     * <code>AwsSecurityFinding</code> format.</p>
     */
    inline AwsSecurityFindingFilters& AddProductFields(const MapFilter& value) { m_productFieldsHasBeenSet = true; m_productFields.push_back(value); return *this; }

    /**
     * <p>A data type where security-findings providers can include additional
     * solution-specific details that aren't part of the defined
     * <code>AwsSecurityFinding</code> format.</p>
     */
    inline AwsSecurityFindingFilters& AddProductFields(MapFilter&& value) { m_productFieldsHasBeenSet = true; m_productFields.push_back(std::move(value)); return *this; }


    /**
     * <p>The name of the solution (product) that generates findings.</p>
     */
    inline const Aws::Vector<StringFilter>& GetProductName() const{ return m_productName; }

    /**
     * <p>The name of the solution (product) that generates findings.</p>
     */
    inline bool ProductNameHasBeenSet() const { return m_productNameHasBeenSet; }

    /**
     * <p>The name of the solution (product) that generates findings.</p>
     */
    inline void SetProductName(const Aws::Vector<StringFilter>& value) { m_productNameHasBeenSet = true; m_productName = value; }

    /**
     * <p>The name of the solution (product) that generates findings.</p>
     */
    inline void SetProductName(Aws::Vector<StringFilter>&& value) { m_productNameHasBeenSet = true; m_productName = std::move(value); }

    /**
     * <p>The name of the solution (product) that generates findings.</p>
     */
    inline AwsSecurityFindingFilters& WithProductName(const Aws::Vector<StringFilter>& value) { SetProductName(value); return *this;}

    /**
     * <p>The name of the solution (product) that generates findings.</p>
     */
    inline AwsSecurityFindingFilters& WithProductName(Aws::Vector<StringFilter>&& value) { SetProductName(std::move(value)); return *this;}

    /**
     * <p>The name of the solution (product) that generates findings.</p>
     */
    inline AwsSecurityFindingFilters& AddProductName(const StringFilter& value) { m_productNameHasBeenSet = true; m_productName.push_back(value); return *this; }

    /**
     * <p>The name of the solution (product) that generates findings.</p>
     */
    inline AwsSecurityFindingFilters& AddProductName(StringFilter&& value) { m_productNameHasBeenSet = true; m_productName.push_back(std::move(value)); return *this; }


    /**
     * <p>The name of the findings provider (company) that owns the solution (product)
     * that generates findings.</p>
     */
    inline const Aws::Vector<StringFilter>& GetCompanyName() const{ return m_companyName; }

    /**
     * <p>The name of the findings provider (company) that owns the solution (product)
     * that generates findings.</p>
     */
    inline bool CompanyNameHasBeenSet() const { return m_companyNameHasBeenSet; }

    /**
     * <p>The name of the findings provider (company) that owns the solution (product)
     * that generates findings.</p>
     */
    inline void SetCompanyName(const Aws::Vector<StringFilter>& value) { m_companyNameHasBeenSet = true; m_companyName = value; }

    /**
     * <p>The name of the findings provider (company) that owns the solution (product)
     * that generates findings.</p>
     */
    inline void SetCompanyName(Aws::Vector<StringFilter>&& value) { m_companyNameHasBeenSet = true; m_companyName = std::move(value); }

    /**
     * <p>The name of the findings provider (company) that owns the solution (product)
     * that generates findings.</p>
     */
    inline AwsSecurityFindingFilters& WithCompanyName(const Aws::Vector<StringFilter>& value) { SetCompanyName(value); return *this;}

    /**
     * <p>The name of the findings provider (company) that owns the solution (product)
     * that generates findings.</p>
     */
    inline AwsSecurityFindingFilters& WithCompanyName(Aws::Vector<StringFilter>&& value) { SetCompanyName(std::move(value)); return *this;}

    /**
     * <p>The name of the findings provider (company) that owns the solution (product)
     * that generates findings.</p>
     */
    inline AwsSecurityFindingFilters& AddCompanyName(const StringFilter& value) { m_companyNameHasBeenSet = true; m_companyName.push_back(value); return *this; }

    /**
     * <p>The name of the findings provider (company) that owns the solution (product)
     * that generates findings.</p>
     */
    inline AwsSecurityFindingFilters& AddCompanyName(StringFilter&& value) { m_companyNameHasBeenSet = true; m_companyName.push_back(std::move(value)); return *this; }


    /**
     * <p>A list of name/value string pairs associated with the finding. These are
     * custom, user-defined fields added to a finding. </p>
     */
    inline const Aws::Vector<MapFilter>& GetUserDefinedFields() const{ return m_userDefinedFields; }

    /**
     * <p>A list of name/value string pairs associated with the finding. These are
     * custom, user-defined fields added to a finding. </p>
     */
    inline bool UserDefinedFieldsHasBeenSet() const { return m_userDefinedFieldsHasBeenSet; }

    /**
     * <p>A list of name/value string pairs associated with the finding. These are
     * custom, user-defined fields added to a finding. </p>
     */
    inline void SetUserDefinedFields(const Aws::Vector<MapFilter>& value) { m_userDefinedFieldsHasBeenSet = true; m_userDefinedFields = value; }

    /**
     * <p>A list of name/value string pairs associated with the finding. These are
     * custom, user-defined fields added to a finding. </p>
     */
    inline void SetUserDefinedFields(Aws::Vector<MapFilter>&& value) { m_userDefinedFieldsHasBeenSet = true; m_userDefinedFields = std::move(value); }

    /**
     * <p>A list of name/value string pairs associated with the finding. These are
     * custom, user-defined fields added to a finding. </p>
     */
    inline AwsSecurityFindingFilters& WithUserDefinedFields(const Aws::Vector<MapFilter>& value) { SetUserDefinedFields(value); return *this;}

    /**
     * <p>A list of name/value string pairs associated with the finding. These are
     * custom, user-defined fields added to a finding. </p>
     */
    inline AwsSecurityFindingFilters& WithUserDefinedFields(Aws::Vector<MapFilter>&& value) { SetUserDefinedFields(std::move(value)); return *this;}

    /**
     * <p>A list of name/value string pairs associated with the finding. These are
     * custom, user-defined fields added to a finding. </p>
     */
    inline AwsSecurityFindingFilters& AddUserDefinedFields(const MapFilter& value) { m_userDefinedFieldsHasBeenSet = true; m_userDefinedFields.push_back(value); return *this; }

    /**
     * <p>A list of name/value string pairs associated with the finding. These are
     * custom, user-defined fields added to a finding. </p>
     */
    inline AwsSecurityFindingFilters& AddUserDefinedFields(MapFilter&& value) { m_userDefinedFieldsHasBeenSet = true; m_userDefinedFields.push_back(std::move(value)); return *this; }


    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline const Aws::Vector<StringFilter>& GetMalwareName() const{ return m_malwareName; }

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline bool MalwareNameHasBeenSet() const { return m_malwareNameHasBeenSet; }

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline void SetMalwareName(const Aws::Vector<StringFilter>& value) { m_malwareNameHasBeenSet = true; m_malwareName = value; }

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline void SetMalwareName(Aws::Vector<StringFilter>&& value) { m_malwareNameHasBeenSet = true; m_malwareName = std::move(value); }

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& WithMalwareName(const Aws::Vector<StringFilter>& value) { SetMalwareName(value); return *this;}

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& WithMalwareName(Aws::Vector<StringFilter>&& value) { SetMalwareName(std::move(value)); return *this;}

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& AddMalwareName(const StringFilter& value) { m_malwareNameHasBeenSet = true; m_malwareName.push_back(value); return *this; }

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& AddMalwareName(StringFilter&& value) { m_malwareNameHasBeenSet = true; m_malwareName.push_back(std::move(value)); return *this; }


    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline const Aws::Vector<StringFilter>& GetMalwareType() const{ return m_malwareType; }

    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline bool MalwareTypeHasBeenSet() const { return m_malwareTypeHasBeenSet; }

    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline void SetMalwareType(const Aws::Vector<StringFilter>& value) { m_malwareTypeHasBeenSet = true; m_malwareType = value; }

    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline void SetMalwareType(Aws::Vector<StringFilter>&& value) { m_malwareTypeHasBeenSet = true; m_malwareType = std::move(value); }

    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& WithMalwareType(const Aws::Vector<StringFilter>& value) { SetMalwareType(value); return *this;}

    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& WithMalwareType(Aws::Vector<StringFilter>&& value) { SetMalwareType(std::move(value)); return *this;}

    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& AddMalwareType(const StringFilter& value) { m_malwareTypeHasBeenSet = true; m_malwareType.push_back(value); return *this; }

    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& AddMalwareType(StringFilter&& value) { m_malwareTypeHasBeenSet = true; m_malwareType.push_back(std::move(value)); return *this; }


    /**
     * <p>The filesystem path of the malware that was observed.</p>
     */
    inline const Aws::Vector<StringFilter>& GetMalwarePath() const{ return m_malwarePath; }

    /**
     * <p>The filesystem path of the malware that was observed.</p>
     */
    inline bool MalwarePathHasBeenSet() const { return m_malwarePathHasBeenSet; }

    /**
     * <p>The filesystem path of the malware that was observed.</p>
     */
    inline void SetMalwarePath(const Aws::Vector<StringFilter>& value) { m_malwarePathHasBeenSet = true; m_malwarePath = value; }

    /**
     * <p>The filesystem path of the malware that was observed.</p>
     */
    inline void SetMalwarePath(Aws::Vector<StringFilter>&& value) { m_malwarePathHasBeenSet = true; m_malwarePath = std::move(value); }

    /**
     * <p>The filesystem path of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& WithMalwarePath(const Aws::Vector<StringFilter>& value) { SetMalwarePath(value); return *this;}

    /**
     * <p>The filesystem path of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& WithMalwarePath(Aws::Vector<StringFilter>&& value) { SetMalwarePath(std::move(value)); return *this;}

    /**
     * <p>The filesystem path of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& AddMalwarePath(const StringFilter& value) { m_malwarePathHasBeenSet = true; m_malwarePath.push_back(value); return *this; }

    /**
     * <p>The filesystem path of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& AddMalwarePath(StringFilter&& value) { m_malwarePathHasBeenSet = true; m_malwarePath.push_back(std::move(value)); return *this; }


    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline const Aws::Vector<StringFilter>& GetMalwareState() const{ return m_malwareState; }

    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline bool MalwareStateHasBeenSet() const { return m_malwareStateHasBeenSet; }

    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline void SetMalwareState(const Aws::Vector<StringFilter>& value) { m_malwareStateHasBeenSet = true; m_malwareState = value; }

    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline void SetMalwareState(Aws::Vector<StringFilter>&& value) { m_malwareStateHasBeenSet = true; m_malwareState = std::move(value); }

    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& WithMalwareState(const Aws::Vector<StringFilter>& value) { SetMalwareState(value); return *this;}

    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& WithMalwareState(Aws::Vector<StringFilter>&& value) { SetMalwareState(std::move(value)); return *this;}

    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& AddMalwareState(const StringFilter& value) { m_malwareStateHasBeenSet = true; m_malwareState.push_back(value); return *this; }

    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline AwsSecurityFindingFilters& AddMalwareState(StringFilter&& value) { m_malwareStateHasBeenSet = true; m_malwareState.push_back(std::move(value)); return *this; }


    /**
     * <p>Indicates the direction of network traffic associated with a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetNetworkDirection() const{ return m_networkDirection; }

    /**
     * <p>Indicates the direction of network traffic associated with a finding.</p>
     */
    inline bool NetworkDirectionHasBeenSet() const { return m_networkDirectionHasBeenSet; }

    /**
     * <p>Indicates the direction of network traffic associated with a finding.</p>
     */
    inline void SetNetworkDirection(const Aws::Vector<StringFilter>& value) { m_networkDirectionHasBeenSet = true; m_networkDirection = value; }

    /**
     * <p>Indicates the direction of network traffic associated with a finding.</p>
     */
    inline void SetNetworkDirection(Aws::Vector<StringFilter>&& value) { m_networkDirectionHasBeenSet = true; m_networkDirection = std::move(value); }

    /**
     * <p>Indicates the direction of network traffic associated with a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkDirection(const Aws::Vector<StringFilter>& value) { SetNetworkDirection(value); return *this;}

    /**
     * <p>Indicates the direction of network traffic associated with a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkDirection(Aws::Vector<StringFilter>&& value) { SetNetworkDirection(std::move(value)); return *this;}

    /**
     * <p>Indicates the direction of network traffic associated with a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkDirection(const StringFilter& value) { m_networkDirectionHasBeenSet = true; m_networkDirection.push_back(value); return *this; }

    /**
     * <p>Indicates the direction of network traffic associated with a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkDirection(StringFilter&& value) { m_networkDirectionHasBeenSet = true; m_networkDirection.push_back(std::move(value)); return *this; }


    /**
     * <p>The protocol of network-related information about a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetNetworkProtocol() const{ return m_networkProtocol; }

    /**
     * <p>The protocol of network-related information about a finding.</p>
     */
    inline bool NetworkProtocolHasBeenSet() const { return m_networkProtocolHasBeenSet; }

    /**
     * <p>The protocol of network-related information about a finding.</p>
     */
    inline void SetNetworkProtocol(const Aws::Vector<StringFilter>& value) { m_networkProtocolHasBeenSet = true; m_networkProtocol = value; }

    /**
     * <p>The protocol of network-related information about a finding.</p>
     */
    inline void SetNetworkProtocol(Aws::Vector<StringFilter>&& value) { m_networkProtocolHasBeenSet = true; m_networkProtocol = std::move(value); }

    /**
     * <p>The protocol of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkProtocol(const Aws::Vector<StringFilter>& value) { SetNetworkProtocol(value); return *this;}

    /**
     * <p>The protocol of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkProtocol(Aws::Vector<StringFilter>&& value) { SetNetworkProtocol(std::move(value)); return *this;}

    /**
     * <p>The protocol of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkProtocol(const StringFilter& value) { m_networkProtocolHasBeenSet = true; m_networkProtocol.push_back(value); return *this; }

    /**
     * <p>The protocol of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkProtocol(StringFilter&& value) { m_networkProtocolHasBeenSet = true; m_networkProtocol.push_back(std::move(value)); return *this; }


    /**
     * <p>The source IPv4 address of network-related information about a finding.</p>
     */
    inline const Aws::Vector<IpFilter>& GetNetworkSourceIpV4() const{ return m_networkSourceIpV4; }

    /**
     * <p>The source IPv4 address of network-related information about a finding.</p>
     */
    inline bool NetworkSourceIpV4HasBeenSet() const { return m_networkSourceIpV4HasBeenSet; }

    /**
     * <p>The source IPv4 address of network-related information about a finding.</p>
     */
    inline void SetNetworkSourceIpV4(const Aws::Vector<IpFilter>& value) { m_networkSourceIpV4HasBeenSet = true; m_networkSourceIpV4 = value; }

    /**
     * <p>The source IPv4 address of network-related information about a finding.</p>
     */
    inline void SetNetworkSourceIpV4(Aws::Vector<IpFilter>&& value) { m_networkSourceIpV4HasBeenSet = true; m_networkSourceIpV4 = std::move(value); }

    /**
     * <p>The source IPv4 address of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkSourceIpV4(const Aws::Vector<IpFilter>& value) { SetNetworkSourceIpV4(value); return *this;}

    /**
     * <p>The source IPv4 address of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkSourceIpV4(Aws::Vector<IpFilter>&& value) { SetNetworkSourceIpV4(std::move(value)); return *this;}

    /**
     * <p>The source IPv4 address of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkSourceIpV4(const IpFilter& value) { m_networkSourceIpV4HasBeenSet = true; m_networkSourceIpV4.push_back(value); return *this; }

    /**
     * <p>The source IPv4 address of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkSourceIpV4(IpFilter&& value) { m_networkSourceIpV4HasBeenSet = true; m_networkSourceIpV4.push_back(std::move(value)); return *this; }


    /**
     * <p>The source IPv6 address of network-related information about a finding.</p>
     */
    inline const Aws::Vector<IpFilter>& GetNetworkSourceIpV6() const{ return m_networkSourceIpV6; }

    /**
     * <p>The source IPv6 address of network-related information about a finding.</p>
     */
    inline bool NetworkSourceIpV6HasBeenSet() const { return m_networkSourceIpV6HasBeenSet; }

    /**
     * <p>The source IPv6 address of network-related information about a finding.</p>
     */
    inline void SetNetworkSourceIpV6(const Aws::Vector<IpFilter>& value) { m_networkSourceIpV6HasBeenSet = true; m_networkSourceIpV6 = value; }

    /**
     * <p>The source IPv6 address of network-related information about a finding.</p>
     */
    inline void SetNetworkSourceIpV6(Aws::Vector<IpFilter>&& value) { m_networkSourceIpV6HasBeenSet = true; m_networkSourceIpV6 = std::move(value); }

    /**
     * <p>The source IPv6 address of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkSourceIpV6(const Aws::Vector<IpFilter>& value) { SetNetworkSourceIpV6(value); return *this;}

    /**
     * <p>The source IPv6 address of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkSourceIpV6(Aws::Vector<IpFilter>&& value) { SetNetworkSourceIpV6(std::move(value)); return *this;}

    /**
     * <p>The source IPv6 address of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkSourceIpV6(const IpFilter& value) { m_networkSourceIpV6HasBeenSet = true; m_networkSourceIpV6.push_back(value); return *this; }

    /**
     * <p>The source IPv6 address of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkSourceIpV6(IpFilter&& value) { m_networkSourceIpV6HasBeenSet = true; m_networkSourceIpV6.push_back(std::move(value)); return *this; }


    /**
     * <p>The source port of network-related information about a finding.</p>
     */
    inline const Aws::Vector<NumberFilter>& GetNetworkSourcePort() const{ return m_networkSourcePort; }

    /**
     * <p>The source port of network-related information about a finding.</p>
     */
    inline bool NetworkSourcePortHasBeenSet() const { return m_networkSourcePortHasBeenSet; }

    /**
     * <p>The source port of network-related information about a finding.</p>
     */
    inline void SetNetworkSourcePort(const Aws::Vector<NumberFilter>& value) { m_networkSourcePortHasBeenSet = true; m_networkSourcePort = value; }

    /**
     * <p>The source port of network-related information about a finding.</p>
     */
    inline void SetNetworkSourcePort(Aws::Vector<NumberFilter>&& value) { m_networkSourcePortHasBeenSet = true; m_networkSourcePort = std::move(value); }

    /**
     * <p>The source port of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkSourcePort(const Aws::Vector<NumberFilter>& value) { SetNetworkSourcePort(value); return *this;}

    /**
     * <p>The source port of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkSourcePort(Aws::Vector<NumberFilter>&& value) { SetNetworkSourcePort(std::move(value)); return *this;}

    /**
     * <p>The source port of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkSourcePort(const NumberFilter& value) { m_networkSourcePortHasBeenSet = true; m_networkSourcePort.push_back(value); return *this; }

    /**
     * <p>The source port of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkSourcePort(NumberFilter&& value) { m_networkSourcePortHasBeenSet = true; m_networkSourcePort.push_back(std::move(value)); return *this; }


    /**
     * <p>The source domain of network-related information about a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetNetworkSourceDomain() const{ return m_networkSourceDomain; }

    /**
     * <p>The source domain of network-related information about a finding.</p>
     */
    inline bool NetworkSourceDomainHasBeenSet() const { return m_networkSourceDomainHasBeenSet; }

    /**
     * <p>The source domain of network-related information about a finding.</p>
     */
    inline void SetNetworkSourceDomain(const Aws::Vector<StringFilter>& value) { m_networkSourceDomainHasBeenSet = true; m_networkSourceDomain = value; }

    /**
     * <p>The source domain of network-related information about a finding.</p>
     */
    inline void SetNetworkSourceDomain(Aws::Vector<StringFilter>&& value) { m_networkSourceDomainHasBeenSet = true; m_networkSourceDomain = std::move(value); }

    /**
     * <p>The source domain of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkSourceDomain(const Aws::Vector<StringFilter>& value) { SetNetworkSourceDomain(value); return *this;}

    /**
     * <p>The source domain of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkSourceDomain(Aws::Vector<StringFilter>&& value) { SetNetworkSourceDomain(std::move(value)); return *this;}

    /**
     * <p>The source domain of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkSourceDomain(const StringFilter& value) { m_networkSourceDomainHasBeenSet = true; m_networkSourceDomain.push_back(value); return *this; }

    /**
     * <p>The source domain of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkSourceDomain(StringFilter&& value) { m_networkSourceDomainHasBeenSet = true; m_networkSourceDomain.push_back(std::move(value)); return *this; }


    /**
     * <p>The source media access control (MAC) address of network-related information
     * about a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetNetworkSourceMac() const{ return m_networkSourceMac; }

    /**
     * <p>The source media access control (MAC) address of network-related information
     * about a finding.</p>
     */
    inline bool NetworkSourceMacHasBeenSet() const { return m_networkSourceMacHasBeenSet; }

    /**
     * <p>The source media access control (MAC) address of network-related information
     * about a finding.</p>
     */
    inline void SetNetworkSourceMac(const Aws::Vector<StringFilter>& value) { m_networkSourceMacHasBeenSet = true; m_networkSourceMac = value; }

    /**
     * <p>The source media access control (MAC) address of network-related information
     * about a finding.</p>
     */
    inline void SetNetworkSourceMac(Aws::Vector<StringFilter>&& value) { m_networkSourceMacHasBeenSet = true; m_networkSourceMac = std::move(value); }

    /**
     * <p>The source media access control (MAC) address of network-related information
     * about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkSourceMac(const Aws::Vector<StringFilter>& value) { SetNetworkSourceMac(value); return *this;}

    /**
     * <p>The source media access control (MAC) address of network-related information
     * about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkSourceMac(Aws::Vector<StringFilter>&& value) { SetNetworkSourceMac(std::move(value)); return *this;}

    /**
     * <p>The source media access control (MAC) address of network-related information
     * about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkSourceMac(const StringFilter& value) { m_networkSourceMacHasBeenSet = true; m_networkSourceMac.push_back(value); return *this; }

    /**
     * <p>The source media access control (MAC) address of network-related information
     * about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkSourceMac(StringFilter&& value) { m_networkSourceMacHasBeenSet = true; m_networkSourceMac.push_back(std::move(value)); return *this; }


    /**
     * <p>The destination IPv4 address of network-related information about a
     * finding.</p>
     */
    inline const Aws::Vector<IpFilter>& GetNetworkDestinationIpV4() const{ return m_networkDestinationIpV4; }

    /**
     * <p>The destination IPv4 address of network-related information about a
     * finding.</p>
     */
    inline bool NetworkDestinationIpV4HasBeenSet() const { return m_networkDestinationIpV4HasBeenSet; }

    /**
     * <p>The destination IPv4 address of network-related information about a
     * finding.</p>
     */
    inline void SetNetworkDestinationIpV4(const Aws::Vector<IpFilter>& value) { m_networkDestinationIpV4HasBeenSet = true; m_networkDestinationIpV4 = value; }

    /**
     * <p>The destination IPv4 address of network-related information about a
     * finding.</p>
     */
    inline void SetNetworkDestinationIpV4(Aws::Vector<IpFilter>&& value) { m_networkDestinationIpV4HasBeenSet = true; m_networkDestinationIpV4 = std::move(value); }

    /**
     * <p>The destination IPv4 address of network-related information about a
     * finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkDestinationIpV4(const Aws::Vector<IpFilter>& value) { SetNetworkDestinationIpV4(value); return *this;}

    /**
     * <p>The destination IPv4 address of network-related information about a
     * finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkDestinationIpV4(Aws::Vector<IpFilter>&& value) { SetNetworkDestinationIpV4(std::move(value)); return *this;}

    /**
     * <p>The destination IPv4 address of network-related information about a
     * finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkDestinationIpV4(const IpFilter& value) { m_networkDestinationIpV4HasBeenSet = true; m_networkDestinationIpV4.push_back(value); return *this; }

    /**
     * <p>The destination IPv4 address of network-related information about a
     * finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkDestinationIpV4(IpFilter&& value) { m_networkDestinationIpV4HasBeenSet = true; m_networkDestinationIpV4.push_back(std::move(value)); return *this; }


    /**
     * <p>The destination IPv6 address of network-related information about a
     * finding.</p>
     */
    inline const Aws::Vector<IpFilter>& GetNetworkDestinationIpV6() const{ return m_networkDestinationIpV6; }

    /**
     * <p>The destination IPv6 address of network-related information about a
     * finding.</p>
     */
    inline bool NetworkDestinationIpV6HasBeenSet() const { return m_networkDestinationIpV6HasBeenSet; }

    /**
     * <p>The destination IPv6 address of network-related information about a
     * finding.</p>
     */
    inline void SetNetworkDestinationIpV6(const Aws::Vector<IpFilter>& value) { m_networkDestinationIpV6HasBeenSet = true; m_networkDestinationIpV6 = value; }

    /**
     * <p>The destination IPv6 address of network-related information about a
     * finding.</p>
     */
    inline void SetNetworkDestinationIpV6(Aws::Vector<IpFilter>&& value) { m_networkDestinationIpV6HasBeenSet = true; m_networkDestinationIpV6 = std::move(value); }

    /**
     * <p>The destination IPv6 address of network-related information about a
     * finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkDestinationIpV6(const Aws::Vector<IpFilter>& value) { SetNetworkDestinationIpV6(value); return *this;}

    /**
     * <p>The destination IPv6 address of network-related information about a
     * finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkDestinationIpV6(Aws::Vector<IpFilter>&& value) { SetNetworkDestinationIpV6(std::move(value)); return *this;}

    /**
     * <p>The destination IPv6 address of network-related information about a
     * finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkDestinationIpV6(const IpFilter& value) { m_networkDestinationIpV6HasBeenSet = true; m_networkDestinationIpV6.push_back(value); return *this; }

    /**
     * <p>The destination IPv6 address of network-related information about a
     * finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkDestinationIpV6(IpFilter&& value) { m_networkDestinationIpV6HasBeenSet = true; m_networkDestinationIpV6.push_back(std::move(value)); return *this; }


    /**
     * <p>The destination port of network-related information about a finding.</p>
     */
    inline const Aws::Vector<NumberFilter>& GetNetworkDestinationPort() const{ return m_networkDestinationPort; }

    /**
     * <p>The destination port of network-related information about a finding.</p>
     */
    inline bool NetworkDestinationPortHasBeenSet() const { return m_networkDestinationPortHasBeenSet; }

    /**
     * <p>The destination port of network-related information about a finding.</p>
     */
    inline void SetNetworkDestinationPort(const Aws::Vector<NumberFilter>& value) { m_networkDestinationPortHasBeenSet = true; m_networkDestinationPort = value; }

    /**
     * <p>The destination port of network-related information about a finding.</p>
     */
    inline void SetNetworkDestinationPort(Aws::Vector<NumberFilter>&& value) { m_networkDestinationPortHasBeenSet = true; m_networkDestinationPort = std::move(value); }

    /**
     * <p>The destination port of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkDestinationPort(const Aws::Vector<NumberFilter>& value) { SetNetworkDestinationPort(value); return *this;}

    /**
     * <p>The destination port of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkDestinationPort(Aws::Vector<NumberFilter>&& value) { SetNetworkDestinationPort(std::move(value)); return *this;}

    /**
     * <p>The destination port of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkDestinationPort(const NumberFilter& value) { m_networkDestinationPortHasBeenSet = true; m_networkDestinationPort.push_back(value); return *this; }

    /**
     * <p>The destination port of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkDestinationPort(NumberFilter&& value) { m_networkDestinationPortHasBeenSet = true; m_networkDestinationPort.push_back(std::move(value)); return *this; }


    /**
     * <p>The destination domain of network-related information about a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetNetworkDestinationDomain() const{ return m_networkDestinationDomain; }

    /**
     * <p>The destination domain of network-related information about a finding.</p>
     */
    inline bool NetworkDestinationDomainHasBeenSet() const { return m_networkDestinationDomainHasBeenSet; }

    /**
     * <p>The destination domain of network-related information about a finding.</p>
     */
    inline void SetNetworkDestinationDomain(const Aws::Vector<StringFilter>& value) { m_networkDestinationDomainHasBeenSet = true; m_networkDestinationDomain = value; }

    /**
     * <p>The destination domain of network-related information about a finding.</p>
     */
    inline void SetNetworkDestinationDomain(Aws::Vector<StringFilter>&& value) { m_networkDestinationDomainHasBeenSet = true; m_networkDestinationDomain = std::move(value); }

    /**
     * <p>The destination domain of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkDestinationDomain(const Aws::Vector<StringFilter>& value) { SetNetworkDestinationDomain(value); return *this;}

    /**
     * <p>The destination domain of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithNetworkDestinationDomain(Aws::Vector<StringFilter>&& value) { SetNetworkDestinationDomain(std::move(value)); return *this;}

    /**
     * <p>The destination domain of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkDestinationDomain(const StringFilter& value) { m_networkDestinationDomainHasBeenSet = true; m_networkDestinationDomain.push_back(value); return *this; }

    /**
     * <p>The destination domain of network-related information about a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddNetworkDestinationDomain(StringFilter&& value) { m_networkDestinationDomainHasBeenSet = true; m_networkDestinationDomain.push_back(std::move(value)); return *this; }


    /**
     * <p>The name of the process.</p>
     */
    inline const Aws::Vector<StringFilter>& GetProcessName() const{ return m_processName; }

    /**
     * <p>The name of the process.</p>
     */
    inline bool ProcessNameHasBeenSet() const { return m_processNameHasBeenSet; }

    /**
     * <p>The name of the process.</p>
     */
    inline void SetProcessName(const Aws::Vector<StringFilter>& value) { m_processNameHasBeenSet = true; m_processName = value; }

    /**
     * <p>The name of the process.</p>
     */
    inline void SetProcessName(Aws::Vector<StringFilter>&& value) { m_processNameHasBeenSet = true; m_processName = std::move(value); }

    /**
     * <p>The name of the process.</p>
     */
    inline AwsSecurityFindingFilters& WithProcessName(const Aws::Vector<StringFilter>& value) { SetProcessName(value); return *this;}

    /**
     * <p>The name of the process.</p>
     */
    inline AwsSecurityFindingFilters& WithProcessName(Aws::Vector<StringFilter>&& value) { SetProcessName(std::move(value)); return *this;}

    /**
     * <p>The name of the process.</p>
     */
    inline AwsSecurityFindingFilters& AddProcessName(const StringFilter& value) { m_processNameHasBeenSet = true; m_processName.push_back(value); return *this; }

    /**
     * <p>The name of the process.</p>
     */
    inline AwsSecurityFindingFilters& AddProcessName(StringFilter&& value) { m_processNameHasBeenSet = true; m_processName.push_back(std::move(value)); return *this; }


    /**
     * <p>The path to the process executable.</p>
     */
    inline const Aws::Vector<StringFilter>& GetProcessPath() const{ return m_processPath; }

    /**
     * <p>The path to the process executable.</p>
     */
    inline bool ProcessPathHasBeenSet() const { return m_processPathHasBeenSet; }

    /**
     * <p>The path to the process executable.</p>
     */
    inline void SetProcessPath(const Aws::Vector<StringFilter>& value) { m_processPathHasBeenSet = true; m_processPath = value; }

    /**
     * <p>The path to the process executable.</p>
     */
    inline void SetProcessPath(Aws::Vector<StringFilter>&& value) { m_processPathHasBeenSet = true; m_processPath = std::move(value); }

    /**
     * <p>The path to the process executable.</p>
     */
    inline AwsSecurityFindingFilters& WithProcessPath(const Aws::Vector<StringFilter>& value) { SetProcessPath(value); return *this;}

    /**
     * <p>The path to the process executable.</p>
     */
    inline AwsSecurityFindingFilters& WithProcessPath(Aws::Vector<StringFilter>&& value) { SetProcessPath(std::move(value)); return *this;}

    /**
     * <p>The path to the process executable.</p>
     */
    inline AwsSecurityFindingFilters& AddProcessPath(const StringFilter& value) { m_processPathHasBeenSet = true; m_processPath.push_back(value); return *this; }

    /**
     * <p>The path to the process executable.</p>
     */
    inline AwsSecurityFindingFilters& AddProcessPath(StringFilter&& value) { m_processPathHasBeenSet = true; m_processPath.push_back(std::move(value)); return *this; }


    /**
     * <p>The process ID.</p>
     */
    inline const Aws::Vector<NumberFilter>& GetProcessPid() const{ return m_processPid; }

    /**
     * <p>The process ID.</p>
     */
    inline bool ProcessPidHasBeenSet() const { return m_processPidHasBeenSet; }

    /**
     * <p>The process ID.</p>
     */
    inline void SetProcessPid(const Aws::Vector<NumberFilter>& value) { m_processPidHasBeenSet = true; m_processPid = value; }

    /**
     * <p>The process ID.</p>
     */
    inline void SetProcessPid(Aws::Vector<NumberFilter>&& value) { m_processPidHasBeenSet = true; m_processPid = std::move(value); }

    /**
     * <p>The process ID.</p>
     */
    inline AwsSecurityFindingFilters& WithProcessPid(const Aws::Vector<NumberFilter>& value) { SetProcessPid(value); return *this;}

    /**
     * <p>The process ID.</p>
     */
    inline AwsSecurityFindingFilters& WithProcessPid(Aws::Vector<NumberFilter>&& value) { SetProcessPid(std::move(value)); return *this;}

    /**
     * <p>The process ID.</p>
     */
    inline AwsSecurityFindingFilters& AddProcessPid(const NumberFilter& value) { m_processPidHasBeenSet = true; m_processPid.push_back(value); return *this; }

    /**
     * <p>The process ID.</p>
     */
    inline AwsSecurityFindingFilters& AddProcessPid(NumberFilter&& value) { m_processPidHasBeenSet = true; m_processPid.push_back(std::move(value)); return *this; }


    /**
     * <p>The parent process ID.</p>
     */
    inline const Aws::Vector<NumberFilter>& GetProcessParentPid() const{ return m_processParentPid; }

    /**
     * <p>The parent process ID.</p>
     */
    inline bool ProcessParentPidHasBeenSet() const { return m_processParentPidHasBeenSet; }

    /**
     * <p>The parent process ID.</p>
     */
    inline void SetProcessParentPid(const Aws::Vector<NumberFilter>& value) { m_processParentPidHasBeenSet = true; m_processParentPid = value; }

    /**
     * <p>The parent process ID.</p>
     */
    inline void SetProcessParentPid(Aws::Vector<NumberFilter>&& value) { m_processParentPidHasBeenSet = true; m_processParentPid = std::move(value); }

    /**
     * <p>The parent process ID.</p>
     */
    inline AwsSecurityFindingFilters& WithProcessParentPid(const Aws::Vector<NumberFilter>& value) { SetProcessParentPid(value); return *this;}

    /**
     * <p>The parent process ID.</p>
     */
    inline AwsSecurityFindingFilters& WithProcessParentPid(Aws::Vector<NumberFilter>&& value) { SetProcessParentPid(std::move(value)); return *this;}

    /**
     * <p>The parent process ID.</p>
     */
    inline AwsSecurityFindingFilters& AddProcessParentPid(const NumberFilter& value) { m_processParentPidHasBeenSet = true; m_processParentPid.push_back(value); return *this; }

    /**
     * <p>The parent process ID.</p>
     */
    inline AwsSecurityFindingFilters& AddProcessParentPid(NumberFilter&& value) { m_processParentPidHasBeenSet = true; m_processParentPid.push_back(std::move(value)); return *this; }


    /**
     * <p>The date/time that the process was launched.</p>
     */
    inline const Aws::Vector<DateFilter>& GetProcessLaunchedAt() const{ return m_processLaunchedAt; }

    /**
     * <p>The date/time that the process was launched.</p>
     */
    inline bool ProcessLaunchedAtHasBeenSet() const { return m_processLaunchedAtHasBeenSet; }

    /**
     * <p>The date/time that the process was launched.</p>
     */
    inline void SetProcessLaunchedAt(const Aws::Vector<DateFilter>& value) { m_processLaunchedAtHasBeenSet = true; m_processLaunchedAt = value; }

    /**
     * <p>The date/time that the process was launched.</p>
     */
    inline void SetProcessLaunchedAt(Aws::Vector<DateFilter>&& value) { m_processLaunchedAtHasBeenSet = true; m_processLaunchedAt = std::move(value); }

    /**
     * <p>The date/time that the process was launched.</p>
     */
    inline AwsSecurityFindingFilters& WithProcessLaunchedAt(const Aws::Vector<DateFilter>& value) { SetProcessLaunchedAt(value); return *this;}

    /**
     * <p>The date/time that the process was launched.</p>
     */
    inline AwsSecurityFindingFilters& WithProcessLaunchedAt(Aws::Vector<DateFilter>&& value) { SetProcessLaunchedAt(std::move(value)); return *this;}

    /**
     * <p>The date/time that the process was launched.</p>
     */
    inline AwsSecurityFindingFilters& AddProcessLaunchedAt(const DateFilter& value) { m_processLaunchedAtHasBeenSet = true; m_processLaunchedAt.push_back(value); return *this; }

    /**
     * <p>The date/time that the process was launched.</p>
     */
    inline AwsSecurityFindingFilters& AddProcessLaunchedAt(DateFilter&& value) { m_processLaunchedAtHasBeenSet = true; m_processLaunchedAt.push_back(std::move(value)); return *this; }


    /**
     * <p>The date/time that the process was terminated.</p>
     */
    inline const Aws::Vector<DateFilter>& GetProcessTerminatedAt() const{ return m_processTerminatedAt; }

    /**
     * <p>The date/time that the process was terminated.</p>
     */
    inline bool ProcessTerminatedAtHasBeenSet() const { return m_processTerminatedAtHasBeenSet; }

    /**
     * <p>The date/time that the process was terminated.</p>
     */
    inline void SetProcessTerminatedAt(const Aws::Vector<DateFilter>& value) { m_processTerminatedAtHasBeenSet = true; m_processTerminatedAt = value; }

    /**
     * <p>The date/time that the process was terminated.</p>
     */
    inline void SetProcessTerminatedAt(Aws::Vector<DateFilter>&& value) { m_processTerminatedAtHasBeenSet = true; m_processTerminatedAt = std::move(value); }

    /**
     * <p>The date/time that the process was terminated.</p>
     */
    inline AwsSecurityFindingFilters& WithProcessTerminatedAt(const Aws::Vector<DateFilter>& value) { SetProcessTerminatedAt(value); return *this;}

    /**
     * <p>The date/time that the process was terminated.</p>
     */
    inline AwsSecurityFindingFilters& WithProcessTerminatedAt(Aws::Vector<DateFilter>&& value) { SetProcessTerminatedAt(std::move(value)); return *this;}

    /**
     * <p>The date/time that the process was terminated.</p>
     */
    inline AwsSecurityFindingFilters& AddProcessTerminatedAt(const DateFilter& value) { m_processTerminatedAtHasBeenSet = true; m_processTerminatedAt.push_back(value); return *this; }

    /**
     * <p>The date/time that the process was terminated.</p>
     */
    inline AwsSecurityFindingFilters& AddProcessTerminatedAt(DateFilter&& value) { m_processTerminatedAtHasBeenSet = true; m_processTerminatedAt.push_back(std::move(value)); return *this; }


    /**
     * <p>The type of a threat intelligence indicator.</p>
     */
    inline const Aws::Vector<StringFilter>& GetThreatIntelIndicatorType() const{ return m_threatIntelIndicatorType; }

    /**
     * <p>The type of a threat intelligence indicator.</p>
     */
    inline bool ThreatIntelIndicatorTypeHasBeenSet() const { return m_threatIntelIndicatorTypeHasBeenSet; }

    /**
     * <p>The type of a threat intelligence indicator.</p>
     */
    inline void SetThreatIntelIndicatorType(const Aws::Vector<StringFilter>& value) { m_threatIntelIndicatorTypeHasBeenSet = true; m_threatIntelIndicatorType = value; }

    /**
     * <p>The type of a threat intelligence indicator.</p>
     */
    inline void SetThreatIntelIndicatorType(Aws::Vector<StringFilter>&& value) { m_threatIntelIndicatorTypeHasBeenSet = true; m_threatIntelIndicatorType = std::move(value); }

    /**
     * <p>The type of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& WithThreatIntelIndicatorType(const Aws::Vector<StringFilter>& value) { SetThreatIntelIndicatorType(value); return *this;}

    /**
     * <p>The type of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& WithThreatIntelIndicatorType(Aws::Vector<StringFilter>&& value) { SetThreatIntelIndicatorType(std::move(value)); return *this;}

    /**
     * <p>The type of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& AddThreatIntelIndicatorType(const StringFilter& value) { m_threatIntelIndicatorTypeHasBeenSet = true; m_threatIntelIndicatorType.push_back(value); return *this; }

    /**
     * <p>The type of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& AddThreatIntelIndicatorType(StringFilter&& value) { m_threatIntelIndicatorTypeHasBeenSet = true; m_threatIntelIndicatorType.push_back(std::move(value)); return *this; }


    /**
     * <p>The value of a threat intelligence indicator.</p>
     */
    inline const Aws::Vector<StringFilter>& GetThreatIntelIndicatorValue() const{ return m_threatIntelIndicatorValue; }

    /**
     * <p>The value of a threat intelligence indicator.</p>
     */
    inline bool ThreatIntelIndicatorValueHasBeenSet() const { return m_threatIntelIndicatorValueHasBeenSet; }

    /**
     * <p>The value of a threat intelligence indicator.</p>
     */
    inline void SetThreatIntelIndicatorValue(const Aws::Vector<StringFilter>& value) { m_threatIntelIndicatorValueHasBeenSet = true; m_threatIntelIndicatorValue = value; }

    /**
     * <p>The value of a threat intelligence indicator.</p>
     */
    inline void SetThreatIntelIndicatorValue(Aws::Vector<StringFilter>&& value) { m_threatIntelIndicatorValueHasBeenSet = true; m_threatIntelIndicatorValue = std::move(value); }

    /**
     * <p>The value of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& WithThreatIntelIndicatorValue(const Aws::Vector<StringFilter>& value) { SetThreatIntelIndicatorValue(value); return *this;}

    /**
     * <p>The value of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& WithThreatIntelIndicatorValue(Aws::Vector<StringFilter>&& value) { SetThreatIntelIndicatorValue(std::move(value)); return *this;}

    /**
     * <p>The value of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& AddThreatIntelIndicatorValue(const StringFilter& value) { m_threatIntelIndicatorValueHasBeenSet = true; m_threatIntelIndicatorValue.push_back(value); return *this; }

    /**
     * <p>The value of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& AddThreatIntelIndicatorValue(StringFilter&& value) { m_threatIntelIndicatorValueHasBeenSet = true; m_threatIntelIndicatorValue.push_back(std::move(value)); return *this; }


    /**
     * <p>The category of a threat intelligence indicator.</p>
     */
    inline const Aws::Vector<StringFilter>& GetThreatIntelIndicatorCategory() const{ return m_threatIntelIndicatorCategory; }

    /**
     * <p>The category of a threat intelligence indicator.</p>
     */
    inline bool ThreatIntelIndicatorCategoryHasBeenSet() const { return m_threatIntelIndicatorCategoryHasBeenSet; }

    /**
     * <p>The category of a threat intelligence indicator.</p>
     */
    inline void SetThreatIntelIndicatorCategory(const Aws::Vector<StringFilter>& value) { m_threatIntelIndicatorCategoryHasBeenSet = true; m_threatIntelIndicatorCategory = value; }

    /**
     * <p>The category of a threat intelligence indicator.</p>
     */
    inline void SetThreatIntelIndicatorCategory(Aws::Vector<StringFilter>&& value) { m_threatIntelIndicatorCategoryHasBeenSet = true; m_threatIntelIndicatorCategory = std::move(value); }

    /**
     * <p>The category of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& WithThreatIntelIndicatorCategory(const Aws::Vector<StringFilter>& value) { SetThreatIntelIndicatorCategory(value); return *this;}

    /**
     * <p>The category of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& WithThreatIntelIndicatorCategory(Aws::Vector<StringFilter>&& value) { SetThreatIntelIndicatorCategory(std::move(value)); return *this;}

    /**
     * <p>The category of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& AddThreatIntelIndicatorCategory(const StringFilter& value) { m_threatIntelIndicatorCategoryHasBeenSet = true; m_threatIntelIndicatorCategory.push_back(value); return *this; }

    /**
     * <p>The category of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& AddThreatIntelIndicatorCategory(StringFilter&& value) { m_threatIntelIndicatorCategoryHasBeenSet = true; m_threatIntelIndicatorCategory.push_back(std::move(value)); return *this; }


    /**
     * <p>The date/time of the last observation of a threat intelligence indicator.</p>
     */
    inline const Aws::Vector<DateFilter>& GetThreatIntelIndicatorLastObservedAt() const{ return m_threatIntelIndicatorLastObservedAt; }

    /**
     * <p>The date/time of the last observation of a threat intelligence indicator.</p>
     */
    inline bool ThreatIntelIndicatorLastObservedAtHasBeenSet() const { return m_threatIntelIndicatorLastObservedAtHasBeenSet; }

    /**
     * <p>The date/time of the last observation of a threat intelligence indicator.</p>
     */
    inline void SetThreatIntelIndicatorLastObservedAt(const Aws::Vector<DateFilter>& value) { m_threatIntelIndicatorLastObservedAtHasBeenSet = true; m_threatIntelIndicatorLastObservedAt = value; }

    /**
     * <p>The date/time of the last observation of a threat intelligence indicator.</p>
     */
    inline void SetThreatIntelIndicatorLastObservedAt(Aws::Vector<DateFilter>&& value) { m_threatIntelIndicatorLastObservedAtHasBeenSet = true; m_threatIntelIndicatorLastObservedAt = std::move(value); }

    /**
     * <p>The date/time of the last observation of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& WithThreatIntelIndicatorLastObservedAt(const Aws::Vector<DateFilter>& value) { SetThreatIntelIndicatorLastObservedAt(value); return *this;}

    /**
     * <p>The date/time of the last observation of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& WithThreatIntelIndicatorLastObservedAt(Aws::Vector<DateFilter>&& value) { SetThreatIntelIndicatorLastObservedAt(std::move(value)); return *this;}

    /**
     * <p>The date/time of the last observation of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& AddThreatIntelIndicatorLastObservedAt(const DateFilter& value) { m_threatIntelIndicatorLastObservedAtHasBeenSet = true; m_threatIntelIndicatorLastObservedAt.push_back(value); return *this; }

    /**
     * <p>The date/time of the last observation of a threat intelligence indicator.</p>
     */
    inline AwsSecurityFindingFilters& AddThreatIntelIndicatorLastObservedAt(DateFilter&& value) { m_threatIntelIndicatorLastObservedAtHasBeenSet = true; m_threatIntelIndicatorLastObservedAt.push_back(std::move(value)); return *this; }


    /**
     * <p>The source of the threat intelligence.</p>
     */
    inline const Aws::Vector<StringFilter>& GetThreatIntelIndicatorSource() const{ return m_threatIntelIndicatorSource; }

    /**
     * <p>The source of the threat intelligence.</p>
     */
    inline bool ThreatIntelIndicatorSourceHasBeenSet() const { return m_threatIntelIndicatorSourceHasBeenSet; }

    /**
     * <p>The source of the threat intelligence.</p>
     */
    inline void SetThreatIntelIndicatorSource(const Aws::Vector<StringFilter>& value) { m_threatIntelIndicatorSourceHasBeenSet = true; m_threatIntelIndicatorSource = value; }

    /**
     * <p>The source of the threat intelligence.</p>
     */
    inline void SetThreatIntelIndicatorSource(Aws::Vector<StringFilter>&& value) { m_threatIntelIndicatorSourceHasBeenSet = true; m_threatIntelIndicatorSource = std::move(value); }

    /**
     * <p>The source of the threat intelligence.</p>
     */
    inline AwsSecurityFindingFilters& WithThreatIntelIndicatorSource(const Aws::Vector<StringFilter>& value) { SetThreatIntelIndicatorSource(value); return *this;}

    /**
     * <p>The source of the threat intelligence.</p>
     */
    inline AwsSecurityFindingFilters& WithThreatIntelIndicatorSource(Aws::Vector<StringFilter>&& value) { SetThreatIntelIndicatorSource(std::move(value)); return *this;}

    /**
     * <p>The source of the threat intelligence.</p>
     */
    inline AwsSecurityFindingFilters& AddThreatIntelIndicatorSource(const StringFilter& value) { m_threatIntelIndicatorSourceHasBeenSet = true; m_threatIntelIndicatorSource.push_back(value); return *this; }

    /**
     * <p>The source of the threat intelligence.</p>
     */
    inline AwsSecurityFindingFilters& AddThreatIntelIndicatorSource(StringFilter&& value) { m_threatIntelIndicatorSourceHasBeenSet = true; m_threatIntelIndicatorSource.push_back(std::move(value)); return *this; }


    /**
     * <p>The URL for more details from the source of the threat intelligence.</p>
     */
    inline const Aws::Vector<StringFilter>& GetThreatIntelIndicatorSourceUrl() const{ return m_threatIntelIndicatorSourceUrl; }

    /**
     * <p>The URL for more details from the source of the threat intelligence.</p>
     */
    inline bool ThreatIntelIndicatorSourceUrlHasBeenSet() const { return m_threatIntelIndicatorSourceUrlHasBeenSet; }

    /**
     * <p>The URL for more details from the source of the threat intelligence.</p>
     */
    inline void SetThreatIntelIndicatorSourceUrl(const Aws::Vector<StringFilter>& value) { m_threatIntelIndicatorSourceUrlHasBeenSet = true; m_threatIntelIndicatorSourceUrl = value; }

    /**
     * <p>The URL for more details from the source of the threat intelligence.</p>
     */
    inline void SetThreatIntelIndicatorSourceUrl(Aws::Vector<StringFilter>&& value) { m_threatIntelIndicatorSourceUrlHasBeenSet = true; m_threatIntelIndicatorSourceUrl = std::move(value); }

    /**
     * <p>The URL for more details from the source of the threat intelligence.</p>
     */
    inline AwsSecurityFindingFilters& WithThreatIntelIndicatorSourceUrl(const Aws::Vector<StringFilter>& value) { SetThreatIntelIndicatorSourceUrl(value); return *this;}

    /**
     * <p>The URL for more details from the source of the threat intelligence.</p>
     */
    inline AwsSecurityFindingFilters& WithThreatIntelIndicatorSourceUrl(Aws::Vector<StringFilter>&& value) { SetThreatIntelIndicatorSourceUrl(std::move(value)); return *this;}

    /**
     * <p>The URL for more details from the source of the threat intelligence.</p>
     */
    inline AwsSecurityFindingFilters& AddThreatIntelIndicatorSourceUrl(const StringFilter& value) { m_threatIntelIndicatorSourceUrlHasBeenSet = true; m_threatIntelIndicatorSourceUrl.push_back(value); return *this; }

    /**
     * <p>The URL for more details from the source of the threat intelligence.</p>
     */
    inline AwsSecurityFindingFilters& AddThreatIntelIndicatorSourceUrl(StringFilter&& value) { m_threatIntelIndicatorSourceUrlHasBeenSet = true; m_threatIntelIndicatorSourceUrl.push_back(std::move(value)); return *this; }


    /**
     * <p>Specifies the type of the resource that details are provided for.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceType() const{ return m_resourceType; }

    /**
     * <p>Specifies the type of the resource that details are provided for.</p>
     */
    inline bool ResourceTypeHasBeenSet() const { return m_resourceTypeHasBeenSet; }

    /**
     * <p>Specifies the type of the resource that details are provided for.</p>
     */
    inline void SetResourceType(const Aws::Vector<StringFilter>& value) { m_resourceTypeHasBeenSet = true; m_resourceType = value; }

    /**
     * <p>Specifies the type of the resource that details are provided for.</p>
     */
    inline void SetResourceType(Aws::Vector<StringFilter>&& value) { m_resourceTypeHasBeenSet = true; m_resourceType = std::move(value); }

    /**
     * <p>Specifies the type of the resource that details are provided for.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceType(const Aws::Vector<StringFilter>& value) { SetResourceType(value); return *this;}

    /**
     * <p>Specifies the type of the resource that details are provided for.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceType(Aws::Vector<StringFilter>&& value) { SetResourceType(std::move(value)); return *this;}

    /**
     * <p>Specifies the type of the resource that details are provided for.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceType(const StringFilter& value) { m_resourceTypeHasBeenSet = true; m_resourceType.push_back(value); return *this; }

    /**
     * <p>Specifies the type of the resource that details are provided for.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceType(StringFilter&& value) { m_resourceTypeHasBeenSet = true; m_resourceType.push_back(std::move(value)); return *this; }


    /**
     * <p>The canonical identifier for the given resource type.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceId() const{ return m_resourceId; }

    /**
     * <p>The canonical identifier for the given resource type.</p>
     */
    inline bool ResourceIdHasBeenSet() const { return m_resourceIdHasBeenSet; }

    /**
     * <p>The canonical identifier for the given resource type.</p>
     */
    inline void SetResourceId(const Aws::Vector<StringFilter>& value) { m_resourceIdHasBeenSet = true; m_resourceId = value; }

    /**
     * <p>The canonical identifier for the given resource type.</p>
     */
    inline void SetResourceId(Aws::Vector<StringFilter>&& value) { m_resourceIdHasBeenSet = true; m_resourceId = std::move(value); }

    /**
     * <p>The canonical identifier for the given resource type.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceId(const Aws::Vector<StringFilter>& value) { SetResourceId(value); return *this;}

    /**
     * <p>The canonical identifier for the given resource type.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceId(Aws::Vector<StringFilter>&& value) { SetResourceId(std::move(value)); return *this;}

    /**
     * <p>The canonical identifier for the given resource type.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceId(const StringFilter& value) { m_resourceIdHasBeenSet = true; m_resourceId.push_back(value); return *this; }

    /**
     * <p>The canonical identifier for the given resource type.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceId(StringFilter&& value) { m_resourceIdHasBeenSet = true; m_resourceId.push_back(std::move(value)); return *this; }


    /**
     * <p>The canonical AWS partition name that the Region is assigned to.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourcePartition() const{ return m_resourcePartition; }

    /**
     * <p>The canonical AWS partition name that the Region is assigned to.</p>
     */
    inline bool ResourcePartitionHasBeenSet() const { return m_resourcePartitionHasBeenSet; }

    /**
     * <p>The canonical AWS partition name that the Region is assigned to.</p>
     */
    inline void SetResourcePartition(const Aws::Vector<StringFilter>& value) { m_resourcePartitionHasBeenSet = true; m_resourcePartition = value; }

    /**
     * <p>The canonical AWS partition name that the Region is assigned to.</p>
     */
    inline void SetResourcePartition(Aws::Vector<StringFilter>&& value) { m_resourcePartitionHasBeenSet = true; m_resourcePartition = std::move(value); }

    /**
     * <p>The canonical AWS partition name that the Region is assigned to.</p>
     */
    inline AwsSecurityFindingFilters& WithResourcePartition(const Aws::Vector<StringFilter>& value) { SetResourcePartition(value); return *this;}

    /**
     * <p>The canonical AWS partition name that the Region is assigned to.</p>
     */
    inline AwsSecurityFindingFilters& WithResourcePartition(Aws::Vector<StringFilter>&& value) { SetResourcePartition(std::move(value)); return *this;}

    /**
     * <p>The canonical AWS partition name that the Region is assigned to.</p>
     */
    inline AwsSecurityFindingFilters& AddResourcePartition(const StringFilter& value) { m_resourcePartitionHasBeenSet = true; m_resourcePartition.push_back(value); return *this; }

    /**
     * <p>The canonical AWS partition name that the Region is assigned to.</p>
     */
    inline AwsSecurityFindingFilters& AddResourcePartition(StringFilter&& value) { m_resourcePartitionHasBeenSet = true; m_resourcePartition.push_back(std::move(value)); return *this; }


    /**
     * <p>The canonical AWS external Region name where this resource is located.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceRegion() const{ return m_resourceRegion; }

    /**
     * <p>The canonical AWS external Region name where this resource is located.</p>
     */
    inline bool ResourceRegionHasBeenSet() const { return m_resourceRegionHasBeenSet; }

    /**
     * <p>The canonical AWS external Region name where this resource is located.</p>
     */
    inline void SetResourceRegion(const Aws::Vector<StringFilter>& value) { m_resourceRegionHasBeenSet = true; m_resourceRegion = value; }

    /**
     * <p>The canonical AWS external Region name where this resource is located.</p>
     */
    inline void SetResourceRegion(Aws::Vector<StringFilter>&& value) { m_resourceRegionHasBeenSet = true; m_resourceRegion = std::move(value); }

    /**
     * <p>The canonical AWS external Region name where this resource is located.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceRegion(const Aws::Vector<StringFilter>& value) { SetResourceRegion(value); return *this;}

    /**
     * <p>The canonical AWS external Region name where this resource is located.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceRegion(Aws::Vector<StringFilter>&& value) { SetResourceRegion(std::move(value)); return *this;}

    /**
     * <p>The canonical AWS external Region name where this resource is located.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceRegion(const StringFilter& value) { m_resourceRegionHasBeenSet = true; m_resourceRegion.push_back(value); return *this; }

    /**
     * <p>The canonical AWS external Region name where this resource is located.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceRegion(StringFilter&& value) { m_resourceRegionHasBeenSet = true; m_resourceRegion.push_back(std::move(value)); return *this; }


    /**
     * <p>A list of AWS tags associated with a resource at the time the finding was
     * processed.</p>
     */
    inline const Aws::Vector<MapFilter>& GetResourceTags() const{ return m_resourceTags; }

    /**
     * <p>A list of AWS tags associated with a resource at the time the finding was
     * processed.</p>
     */
    inline bool ResourceTagsHasBeenSet() const { return m_resourceTagsHasBeenSet; }

    /**
     * <p>A list of AWS tags associated with a resource at the time the finding was
     * processed.</p>
     */
    inline void SetResourceTags(const Aws::Vector<MapFilter>& value) { m_resourceTagsHasBeenSet = true; m_resourceTags = value; }

    /**
     * <p>A list of AWS tags associated with a resource at the time the finding was
     * processed.</p>
     */
    inline void SetResourceTags(Aws::Vector<MapFilter>&& value) { m_resourceTagsHasBeenSet = true; m_resourceTags = std::move(value); }

    /**
     * <p>A list of AWS tags associated with a resource at the time the finding was
     * processed.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceTags(const Aws::Vector<MapFilter>& value) { SetResourceTags(value); return *this;}

    /**
     * <p>A list of AWS tags associated with a resource at the time the finding was
     * processed.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceTags(Aws::Vector<MapFilter>&& value) { SetResourceTags(std::move(value)); return *this;}

    /**
     * <p>A list of AWS tags associated with a resource at the time the finding was
     * processed.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceTags(const MapFilter& value) { m_resourceTagsHasBeenSet = true; m_resourceTags.push_back(value); return *this; }

    /**
     * <p>A list of AWS tags associated with a resource at the time the finding was
     * processed.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceTags(MapFilter&& value) { m_resourceTagsHasBeenSet = true; m_resourceTags.push_back(std::move(value)); return *this; }


    /**
     * <p>The instance type of the instance.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceAwsEc2InstanceType() const{ return m_resourceAwsEc2InstanceType; }

    /**
     * <p>The instance type of the instance.</p>
     */
    inline bool ResourceAwsEc2InstanceTypeHasBeenSet() const { return m_resourceAwsEc2InstanceTypeHasBeenSet; }

    /**
     * <p>The instance type of the instance.</p>
     */
    inline void SetResourceAwsEc2InstanceType(const Aws::Vector<StringFilter>& value) { m_resourceAwsEc2InstanceTypeHasBeenSet = true; m_resourceAwsEc2InstanceType = value; }

    /**
     * <p>The instance type of the instance.</p>
     */
    inline void SetResourceAwsEc2InstanceType(Aws::Vector<StringFilter>&& value) { m_resourceAwsEc2InstanceTypeHasBeenSet = true; m_resourceAwsEc2InstanceType = std::move(value); }

    /**
     * <p>The instance type of the instance.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceType(const Aws::Vector<StringFilter>& value) { SetResourceAwsEc2InstanceType(value); return *this;}

    /**
     * <p>The instance type of the instance.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceType(Aws::Vector<StringFilter>&& value) { SetResourceAwsEc2InstanceType(std::move(value)); return *this;}

    /**
     * <p>The instance type of the instance.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceType(const StringFilter& value) { m_resourceAwsEc2InstanceTypeHasBeenSet = true; m_resourceAwsEc2InstanceType.push_back(value); return *this; }

    /**
     * <p>The instance type of the instance.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceType(StringFilter&& value) { m_resourceAwsEc2InstanceTypeHasBeenSet = true; m_resourceAwsEc2InstanceType.push_back(std::move(value)); return *this; }


    /**
     * <p>The Amazon Machine Image (AMI) ID of the instance.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceAwsEc2InstanceImageId() const{ return m_resourceAwsEc2InstanceImageId; }

    /**
     * <p>The Amazon Machine Image (AMI) ID of the instance.</p>
     */
    inline bool ResourceAwsEc2InstanceImageIdHasBeenSet() const { return m_resourceAwsEc2InstanceImageIdHasBeenSet; }

    /**
     * <p>The Amazon Machine Image (AMI) ID of the instance.</p>
     */
    inline void SetResourceAwsEc2InstanceImageId(const Aws::Vector<StringFilter>& value) { m_resourceAwsEc2InstanceImageIdHasBeenSet = true; m_resourceAwsEc2InstanceImageId = value; }

    /**
     * <p>The Amazon Machine Image (AMI) ID of the instance.</p>
     */
    inline void SetResourceAwsEc2InstanceImageId(Aws::Vector<StringFilter>&& value) { m_resourceAwsEc2InstanceImageIdHasBeenSet = true; m_resourceAwsEc2InstanceImageId = std::move(value); }

    /**
     * <p>The Amazon Machine Image (AMI) ID of the instance.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceImageId(const Aws::Vector<StringFilter>& value) { SetResourceAwsEc2InstanceImageId(value); return *this;}

    /**
     * <p>The Amazon Machine Image (AMI) ID of the instance.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceImageId(Aws::Vector<StringFilter>&& value) { SetResourceAwsEc2InstanceImageId(std::move(value)); return *this;}

    /**
     * <p>The Amazon Machine Image (AMI) ID of the instance.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceImageId(const StringFilter& value) { m_resourceAwsEc2InstanceImageIdHasBeenSet = true; m_resourceAwsEc2InstanceImageId.push_back(value); return *this; }

    /**
     * <p>The Amazon Machine Image (AMI) ID of the instance.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceImageId(StringFilter&& value) { m_resourceAwsEc2InstanceImageIdHasBeenSet = true; m_resourceAwsEc2InstanceImageId.push_back(std::move(value)); return *this; }


    /**
     * <p>The IPv4 addresses associated with the instance.</p>
     */
    inline const Aws::Vector<IpFilter>& GetResourceAwsEc2InstanceIpV4Addresses() const{ return m_resourceAwsEc2InstanceIpV4Addresses; }

    /**
     * <p>The IPv4 addresses associated with the instance.</p>
     */
    inline bool ResourceAwsEc2InstanceIpV4AddressesHasBeenSet() const { return m_resourceAwsEc2InstanceIpV4AddressesHasBeenSet; }

    /**
     * <p>The IPv4 addresses associated with the instance.</p>
     */
    inline void SetResourceAwsEc2InstanceIpV4Addresses(const Aws::Vector<IpFilter>& value) { m_resourceAwsEc2InstanceIpV4AddressesHasBeenSet = true; m_resourceAwsEc2InstanceIpV4Addresses = value; }

    /**
     * <p>The IPv4 addresses associated with the instance.</p>
     */
    inline void SetResourceAwsEc2InstanceIpV4Addresses(Aws::Vector<IpFilter>&& value) { m_resourceAwsEc2InstanceIpV4AddressesHasBeenSet = true; m_resourceAwsEc2InstanceIpV4Addresses = std::move(value); }

    /**
     * <p>The IPv4 addresses associated with the instance.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceIpV4Addresses(const Aws::Vector<IpFilter>& value) { SetResourceAwsEc2InstanceIpV4Addresses(value); return *this;}

    /**
     * <p>The IPv4 addresses associated with the instance.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceIpV4Addresses(Aws::Vector<IpFilter>&& value) { SetResourceAwsEc2InstanceIpV4Addresses(std::move(value)); return *this;}

    /**
     * <p>The IPv4 addresses associated with the instance.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceIpV4Addresses(const IpFilter& value) { m_resourceAwsEc2InstanceIpV4AddressesHasBeenSet = true; m_resourceAwsEc2InstanceIpV4Addresses.push_back(value); return *this; }

    /**
     * <p>The IPv4 addresses associated with the instance.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceIpV4Addresses(IpFilter&& value) { m_resourceAwsEc2InstanceIpV4AddressesHasBeenSet = true; m_resourceAwsEc2InstanceIpV4Addresses.push_back(std::move(value)); return *this; }


    /**
     * <p>The IPv6 addresses associated with the instance.</p>
     */
    inline const Aws::Vector<IpFilter>& GetResourceAwsEc2InstanceIpV6Addresses() const{ return m_resourceAwsEc2InstanceIpV6Addresses; }

    /**
     * <p>The IPv6 addresses associated with the instance.</p>
     */
    inline bool ResourceAwsEc2InstanceIpV6AddressesHasBeenSet() const { return m_resourceAwsEc2InstanceIpV6AddressesHasBeenSet; }

    /**
     * <p>The IPv6 addresses associated with the instance.</p>
     */
    inline void SetResourceAwsEc2InstanceIpV6Addresses(const Aws::Vector<IpFilter>& value) { m_resourceAwsEc2InstanceIpV6AddressesHasBeenSet = true; m_resourceAwsEc2InstanceIpV6Addresses = value; }

    /**
     * <p>The IPv6 addresses associated with the instance.</p>
     */
    inline void SetResourceAwsEc2InstanceIpV6Addresses(Aws::Vector<IpFilter>&& value) { m_resourceAwsEc2InstanceIpV6AddressesHasBeenSet = true; m_resourceAwsEc2InstanceIpV6Addresses = std::move(value); }

    /**
     * <p>The IPv6 addresses associated with the instance.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceIpV6Addresses(const Aws::Vector<IpFilter>& value) { SetResourceAwsEc2InstanceIpV6Addresses(value); return *this;}

    /**
     * <p>The IPv6 addresses associated with the instance.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceIpV6Addresses(Aws::Vector<IpFilter>&& value) { SetResourceAwsEc2InstanceIpV6Addresses(std::move(value)); return *this;}

    /**
     * <p>The IPv6 addresses associated with the instance.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceIpV6Addresses(const IpFilter& value) { m_resourceAwsEc2InstanceIpV6AddressesHasBeenSet = true; m_resourceAwsEc2InstanceIpV6Addresses.push_back(value); return *this; }

    /**
     * <p>The IPv6 addresses associated with the instance.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceIpV6Addresses(IpFilter&& value) { m_resourceAwsEc2InstanceIpV6AddressesHasBeenSet = true; m_resourceAwsEc2InstanceIpV6Addresses.push_back(std::move(value)); return *this; }


    /**
     * <p>The key name associated with the instance.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceAwsEc2InstanceKeyName() const{ return m_resourceAwsEc2InstanceKeyName; }

    /**
     * <p>The key name associated with the instance.</p>
     */
    inline bool ResourceAwsEc2InstanceKeyNameHasBeenSet() const { return m_resourceAwsEc2InstanceKeyNameHasBeenSet; }

    /**
     * <p>The key name associated with the instance.</p>
     */
    inline void SetResourceAwsEc2InstanceKeyName(const Aws::Vector<StringFilter>& value) { m_resourceAwsEc2InstanceKeyNameHasBeenSet = true; m_resourceAwsEc2InstanceKeyName = value; }

    /**
     * <p>The key name associated with the instance.</p>
     */
    inline void SetResourceAwsEc2InstanceKeyName(Aws::Vector<StringFilter>&& value) { m_resourceAwsEc2InstanceKeyNameHasBeenSet = true; m_resourceAwsEc2InstanceKeyName = std::move(value); }

    /**
     * <p>The key name associated with the instance.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceKeyName(const Aws::Vector<StringFilter>& value) { SetResourceAwsEc2InstanceKeyName(value); return *this;}

    /**
     * <p>The key name associated with the instance.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceKeyName(Aws::Vector<StringFilter>&& value) { SetResourceAwsEc2InstanceKeyName(std::move(value)); return *this;}

    /**
     * <p>The key name associated with the instance.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceKeyName(const StringFilter& value) { m_resourceAwsEc2InstanceKeyNameHasBeenSet = true; m_resourceAwsEc2InstanceKeyName.push_back(value); return *this; }

    /**
     * <p>The key name associated with the instance.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceKeyName(StringFilter&& value) { m_resourceAwsEc2InstanceKeyNameHasBeenSet = true; m_resourceAwsEc2InstanceKeyName.push_back(std::move(value)); return *this; }


    /**
     * <p>The IAM profile ARN of the instance.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceAwsEc2InstanceIamInstanceProfileArn() const{ return m_resourceAwsEc2InstanceIamInstanceProfileArn; }

    /**
     * <p>The IAM profile ARN of the instance.</p>
     */
    inline bool ResourceAwsEc2InstanceIamInstanceProfileArnHasBeenSet() const { return m_resourceAwsEc2InstanceIamInstanceProfileArnHasBeenSet; }

    /**
     * <p>The IAM profile ARN of the instance.</p>
     */
    inline void SetResourceAwsEc2InstanceIamInstanceProfileArn(const Aws::Vector<StringFilter>& value) { m_resourceAwsEc2InstanceIamInstanceProfileArnHasBeenSet = true; m_resourceAwsEc2InstanceIamInstanceProfileArn = value; }

    /**
     * <p>The IAM profile ARN of the instance.</p>
     */
    inline void SetResourceAwsEc2InstanceIamInstanceProfileArn(Aws::Vector<StringFilter>&& value) { m_resourceAwsEc2InstanceIamInstanceProfileArnHasBeenSet = true; m_resourceAwsEc2InstanceIamInstanceProfileArn = std::move(value); }

    /**
     * <p>The IAM profile ARN of the instance.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceIamInstanceProfileArn(const Aws::Vector<StringFilter>& value) { SetResourceAwsEc2InstanceIamInstanceProfileArn(value); return *this;}

    /**
     * <p>The IAM profile ARN of the instance.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceIamInstanceProfileArn(Aws::Vector<StringFilter>&& value) { SetResourceAwsEc2InstanceIamInstanceProfileArn(std::move(value)); return *this;}

    /**
     * <p>The IAM profile ARN of the instance.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceIamInstanceProfileArn(const StringFilter& value) { m_resourceAwsEc2InstanceIamInstanceProfileArnHasBeenSet = true; m_resourceAwsEc2InstanceIamInstanceProfileArn.push_back(value); return *this; }

    /**
     * <p>The IAM profile ARN of the instance.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceIamInstanceProfileArn(StringFilter&& value) { m_resourceAwsEc2InstanceIamInstanceProfileArnHasBeenSet = true; m_resourceAwsEc2InstanceIamInstanceProfileArn.push_back(std::move(value)); return *this; }


    /**
     * <p>The identifier of the VPC that the instance was launched in.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceAwsEc2InstanceVpcId() const{ return m_resourceAwsEc2InstanceVpcId; }

    /**
     * <p>The identifier of the VPC that the instance was launched in.</p>
     */
    inline bool ResourceAwsEc2InstanceVpcIdHasBeenSet() const { return m_resourceAwsEc2InstanceVpcIdHasBeenSet; }

    /**
     * <p>The identifier of the VPC that the instance was launched in.</p>
     */
    inline void SetResourceAwsEc2InstanceVpcId(const Aws::Vector<StringFilter>& value) { m_resourceAwsEc2InstanceVpcIdHasBeenSet = true; m_resourceAwsEc2InstanceVpcId = value; }

    /**
     * <p>The identifier of the VPC that the instance was launched in.</p>
     */
    inline void SetResourceAwsEc2InstanceVpcId(Aws::Vector<StringFilter>&& value) { m_resourceAwsEc2InstanceVpcIdHasBeenSet = true; m_resourceAwsEc2InstanceVpcId = std::move(value); }

    /**
     * <p>The identifier of the VPC that the instance was launched in.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceVpcId(const Aws::Vector<StringFilter>& value) { SetResourceAwsEc2InstanceVpcId(value); return *this;}

    /**
     * <p>The identifier of the VPC that the instance was launched in.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceVpcId(Aws::Vector<StringFilter>&& value) { SetResourceAwsEc2InstanceVpcId(std::move(value)); return *this;}

    /**
     * <p>The identifier of the VPC that the instance was launched in.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceVpcId(const StringFilter& value) { m_resourceAwsEc2InstanceVpcIdHasBeenSet = true; m_resourceAwsEc2InstanceVpcId.push_back(value); return *this; }

    /**
     * <p>The identifier of the VPC that the instance was launched in.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceVpcId(StringFilter&& value) { m_resourceAwsEc2InstanceVpcIdHasBeenSet = true; m_resourceAwsEc2InstanceVpcId.push_back(std::move(value)); return *this; }


    /**
     * <p>The identifier of the subnet that the instance was launched in.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceAwsEc2InstanceSubnetId() const{ return m_resourceAwsEc2InstanceSubnetId; }

    /**
     * <p>The identifier of the subnet that the instance was launched in.</p>
     */
    inline bool ResourceAwsEc2InstanceSubnetIdHasBeenSet() const { return m_resourceAwsEc2InstanceSubnetIdHasBeenSet; }

    /**
     * <p>The identifier of the subnet that the instance was launched in.</p>
     */
    inline void SetResourceAwsEc2InstanceSubnetId(const Aws::Vector<StringFilter>& value) { m_resourceAwsEc2InstanceSubnetIdHasBeenSet = true; m_resourceAwsEc2InstanceSubnetId = value; }

    /**
     * <p>The identifier of the subnet that the instance was launched in.</p>
     */
    inline void SetResourceAwsEc2InstanceSubnetId(Aws::Vector<StringFilter>&& value) { m_resourceAwsEc2InstanceSubnetIdHasBeenSet = true; m_resourceAwsEc2InstanceSubnetId = std::move(value); }

    /**
     * <p>The identifier of the subnet that the instance was launched in.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceSubnetId(const Aws::Vector<StringFilter>& value) { SetResourceAwsEc2InstanceSubnetId(value); return *this;}

    /**
     * <p>The identifier of the subnet that the instance was launched in.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceSubnetId(Aws::Vector<StringFilter>&& value) { SetResourceAwsEc2InstanceSubnetId(std::move(value)); return *this;}

    /**
     * <p>The identifier of the subnet that the instance was launched in.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceSubnetId(const StringFilter& value) { m_resourceAwsEc2InstanceSubnetIdHasBeenSet = true; m_resourceAwsEc2InstanceSubnetId.push_back(value); return *this; }

    /**
     * <p>The identifier of the subnet that the instance was launched in.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceSubnetId(StringFilter&& value) { m_resourceAwsEc2InstanceSubnetIdHasBeenSet = true; m_resourceAwsEc2InstanceSubnetId.push_back(std::move(value)); return *this; }


    /**
     * <p>The date and time the instance was launched.</p>
     */
    inline const Aws::Vector<DateFilter>& GetResourceAwsEc2InstanceLaunchedAt() const{ return m_resourceAwsEc2InstanceLaunchedAt; }

    /**
     * <p>The date and time the instance was launched.</p>
     */
    inline bool ResourceAwsEc2InstanceLaunchedAtHasBeenSet() const { return m_resourceAwsEc2InstanceLaunchedAtHasBeenSet; }

    /**
     * <p>The date and time the instance was launched.</p>
     */
    inline void SetResourceAwsEc2InstanceLaunchedAt(const Aws::Vector<DateFilter>& value) { m_resourceAwsEc2InstanceLaunchedAtHasBeenSet = true; m_resourceAwsEc2InstanceLaunchedAt = value; }

    /**
     * <p>The date and time the instance was launched.</p>
     */
    inline void SetResourceAwsEc2InstanceLaunchedAt(Aws::Vector<DateFilter>&& value) { m_resourceAwsEc2InstanceLaunchedAtHasBeenSet = true; m_resourceAwsEc2InstanceLaunchedAt = std::move(value); }

    /**
     * <p>The date and time the instance was launched.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceLaunchedAt(const Aws::Vector<DateFilter>& value) { SetResourceAwsEc2InstanceLaunchedAt(value); return *this;}

    /**
     * <p>The date and time the instance was launched.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsEc2InstanceLaunchedAt(Aws::Vector<DateFilter>&& value) { SetResourceAwsEc2InstanceLaunchedAt(std::move(value)); return *this;}

    /**
     * <p>The date and time the instance was launched.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceLaunchedAt(const DateFilter& value) { m_resourceAwsEc2InstanceLaunchedAtHasBeenSet = true; m_resourceAwsEc2InstanceLaunchedAt.push_back(value); return *this; }

    /**
     * <p>The date and time the instance was launched.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsEc2InstanceLaunchedAt(DateFilter&& value) { m_resourceAwsEc2InstanceLaunchedAtHasBeenSet = true; m_resourceAwsEc2InstanceLaunchedAt.push_back(std::move(value)); return *this; }


    /**
     * <p>The canonical user ID of the owner of the S3 bucket.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceAwsS3BucketOwnerId() const{ return m_resourceAwsS3BucketOwnerId; }

    /**
     * <p>The canonical user ID of the owner of the S3 bucket.</p>
     */
    inline bool ResourceAwsS3BucketOwnerIdHasBeenSet() const { return m_resourceAwsS3BucketOwnerIdHasBeenSet; }

    /**
     * <p>The canonical user ID of the owner of the S3 bucket.</p>
     */
    inline void SetResourceAwsS3BucketOwnerId(const Aws::Vector<StringFilter>& value) { m_resourceAwsS3BucketOwnerIdHasBeenSet = true; m_resourceAwsS3BucketOwnerId = value; }

    /**
     * <p>The canonical user ID of the owner of the S3 bucket.</p>
     */
    inline void SetResourceAwsS3BucketOwnerId(Aws::Vector<StringFilter>&& value) { m_resourceAwsS3BucketOwnerIdHasBeenSet = true; m_resourceAwsS3BucketOwnerId = std::move(value); }

    /**
     * <p>The canonical user ID of the owner of the S3 bucket.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsS3BucketOwnerId(const Aws::Vector<StringFilter>& value) { SetResourceAwsS3BucketOwnerId(value); return *this;}

    /**
     * <p>The canonical user ID of the owner of the S3 bucket.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsS3BucketOwnerId(Aws::Vector<StringFilter>&& value) { SetResourceAwsS3BucketOwnerId(std::move(value)); return *this;}

    /**
     * <p>The canonical user ID of the owner of the S3 bucket.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsS3BucketOwnerId(const StringFilter& value) { m_resourceAwsS3BucketOwnerIdHasBeenSet = true; m_resourceAwsS3BucketOwnerId.push_back(value); return *this; }

    /**
     * <p>The canonical user ID of the owner of the S3 bucket.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsS3BucketOwnerId(StringFilter&& value) { m_resourceAwsS3BucketOwnerIdHasBeenSet = true; m_resourceAwsS3BucketOwnerId.push_back(std::move(value)); return *this; }


    /**
     * <p>The display name of the owner of the S3 bucket.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceAwsS3BucketOwnerName() const{ return m_resourceAwsS3BucketOwnerName; }

    /**
     * <p>The display name of the owner of the S3 bucket.</p>
     */
    inline bool ResourceAwsS3BucketOwnerNameHasBeenSet() const { return m_resourceAwsS3BucketOwnerNameHasBeenSet; }

    /**
     * <p>The display name of the owner of the S3 bucket.</p>
     */
    inline void SetResourceAwsS3BucketOwnerName(const Aws::Vector<StringFilter>& value) { m_resourceAwsS3BucketOwnerNameHasBeenSet = true; m_resourceAwsS3BucketOwnerName = value; }

    /**
     * <p>The display name of the owner of the S3 bucket.</p>
     */
    inline void SetResourceAwsS3BucketOwnerName(Aws::Vector<StringFilter>&& value) { m_resourceAwsS3BucketOwnerNameHasBeenSet = true; m_resourceAwsS3BucketOwnerName = std::move(value); }

    /**
     * <p>The display name of the owner of the S3 bucket.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsS3BucketOwnerName(const Aws::Vector<StringFilter>& value) { SetResourceAwsS3BucketOwnerName(value); return *this;}

    /**
     * <p>The display name of the owner of the S3 bucket.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsS3BucketOwnerName(Aws::Vector<StringFilter>&& value) { SetResourceAwsS3BucketOwnerName(std::move(value)); return *this;}

    /**
     * <p>The display name of the owner of the S3 bucket.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsS3BucketOwnerName(const StringFilter& value) { m_resourceAwsS3BucketOwnerNameHasBeenSet = true; m_resourceAwsS3BucketOwnerName.push_back(value); return *this; }

    /**
     * <p>The display name of the owner of the S3 bucket.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsS3BucketOwnerName(StringFilter&& value) { m_resourceAwsS3BucketOwnerNameHasBeenSet = true; m_resourceAwsS3BucketOwnerName.push_back(std::move(value)); return *this; }


    /**
     * <p>The user associated with the IAM access key related to a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceAwsIamAccessKeyUserName() const{ return m_resourceAwsIamAccessKeyUserName; }

    /**
     * <p>The user associated with the IAM access key related to a finding.</p>
     */
    inline bool ResourceAwsIamAccessKeyUserNameHasBeenSet() const { return m_resourceAwsIamAccessKeyUserNameHasBeenSet; }

    /**
     * <p>The user associated with the IAM access key related to a finding.</p>
     */
    inline void SetResourceAwsIamAccessKeyUserName(const Aws::Vector<StringFilter>& value) { m_resourceAwsIamAccessKeyUserNameHasBeenSet = true; m_resourceAwsIamAccessKeyUserName = value; }

    /**
     * <p>The user associated with the IAM access key related to a finding.</p>
     */
    inline void SetResourceAwsIamAccessKeyUserName(Aws::Vector<StringFilter>&& value) { m_resourceAwsIamAccessKeyUserNameHasBeenSet = true; m_resourceAwsIamAccessKeyUserName = std::move(value); }

    /**
     * <p>The user associated with the IAM access key related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsIamAccessKeyUserName(const Aws::Vector<StringFilter>& value) { SetResourceAwsIamAccessKeyUserName(value); return *this;}

    /**
     * <p>The user associated with the IAM access key related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsIamAccessKeyUserName(Aws::Vector<StringFilter>&& value) { SetResourceAwsIamAccessKeyUserName(std::move(value)); return *this;}

    /**
     * <p>The user associated with the IAM access key related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsIamAccessKeyUserName(const StringFilter& value) { m_resourceAwsIamAccessKeyUserNameHasBeenSet = true; m_resourceAwsIamAccessKeyUserName.push_back(value); return *this; }

    /**
     * <p>The user associated with the IAM access key related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsIamAccessKeyUserName(StringFilter&& value) { m_resourceAwsIamAccessKeyUserNameHasBeenSet = true; m_resourceAwsIamAccessKeyUserName.push_back(std::move(value)); return *this; }


    /**
     * <p>The status of the IAM access key related to a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceAwsIamAccessKeyStatus() const{ return m_resourceAwsIamAccessKeyStatus; }

    /**
     * <p>The status of the IAM access key related to a finding.</p>
     */
    inline bool ResourceAwsIamAccessKeyStatusHasBeenSet() const { return m_resourceAwsIamAccessKeyStatusHasBeenSet; }

    /**
     * <p>The status of the IAM access key related to a finding.</p>
     */
    inline void SetResourceAwsIamAccessKeyStatus(const Aws::Vector<StringFilter>& value) { m_resourceAwsIamAccessKeyStatusHasBeenSet = true; m_resourceAwsIamAccessKeyStatus = value; }

    /**
     * <p>The status of the IAM access key related to a finding.</p>
     */
    inline void SetResourceAwsIamAccessKeyStatus(Aws::Vector<StringFilter>&& value) { m_resourceAwsIamAccessKeyStatusHasBeenSet = true; m_resourceAwsIamAccessKeyStatus = std::move(value); }

    /**
     * <p>The status of the IAM access key related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsIamAccessKeyStatus(const Aws::Vector<StringFilter>& value) { SetResourceAwsIamAccessKeyStatus(value); return *this;}

    /**
     * <p>The status of the IAM access key related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsIamAccessKeyStatus(Aws::Vector<StringFilter>&& value) { SetResourceAwsIamAccessKeyStatus(std::move(value)); return *this;}

    /**
     * <p>The status of the IAM access key related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsIamAccessKeyStatus(const StringFilter& value) { m_resourceAwsIamAccessKeyStatusHasBeenSet = true; m_resourceAwsIamAccessKeyStatus.push_back(value); return *this; }

    /**
     * <p>The status of the IAM access key related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsIamAccessKeyStatus(StringFilter&& value) { m_resourceAwsIamAccessKeyStatusHasBeenSet = true; m_resourceAwsIamAccessKeyStatus.push_back(std::move(value)); return *this; }


    /**
     * <p>The creation date/time of the IAM access key related to a finding.</p>
     */
    inline const Aws::Vector<DateFilter>& GetResourceAwsIamAccessKeyCreatedAt() const{ return m_resourceAwsIamAccessKeyCreatedAt; }

    /**
     * <p>The creation date/time of the IAM access key related to a finding.</p>
     */
    inline bool ResourceAwsIamAccessKeyCreatedAtHasBeenSet() const { return m_resourceAwsIamAccessKeyCreatedAtHasBeenSet; }

    /**
     * <p>The creation date/time of the IAM access key related to a finding.</p>
     */
    inline void SetResourceAwsIamAccessKeyCreatedAt(const Aws::Vector<DateFilter>& value) { m_resourceAwsIamAccessKeyCreatedAtHasBeenSet = true; m_resourceAwsIamAccessKeyCreatedAt = value; }

    /**
     * <p>The creation date/time of the IAM access key related to a finding.</p>
     */
    inline void SetResourceAwsIamAccessKeyCreatedAt(Aws::Vector<DateFilter>&& value) { m_resourceAwsIamAccessKeyCreatedAtHasBeenSet = true; m_resourceAwsIamAccessKeyCreatedAt = std::move(value); }

    /**
     * <p>The creation date/time of the IAM access key related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsIamAccessKeyCreatedAt(const Aws::Vector<DateFilter>& value) { SetResourceAwsIamAccessKeyCreatedAt(value); return *this;}

    /**
     * <p>The creation date/time of the IAM access key related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceAwsIamAccessKeyCreatedAt(Aws::Vector<DateFilter>&& value) { SetResourceAwsIamAccessKeyCreatedAt(std::move(value)); return *this;}

    /**
     * <p>The creation date/time of the IAM access key related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsIamAccessKeyCreatedAt(const DateFilter& value) { m_resourceAwsIamAccessKeyCreatedAtHasBeenSet = true; m_resourceAwsIamAccessKeyCreatedAt.push_back(value); return *this; }

    /**
     * <p>The creation date/time of the IAM access key related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceAwsIamAccessKeyCreatedAt(DateFilter&& value) { m_resourceAwsIamAccessKeyCreatedAtHasBeenSet = true; m_resourceAwsIamAccessKeyCreatedAt.push_back(std::move(value)); return *this; }


    /**
     * <p>The name of the container related to a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceContainerName() const{ return m_resourceContainerName; }

    /**
     * <p>The name of the container related to a finding.</p>
     */
    inline bool ResourceContainerNameHasBeenSet() const { return m_resourceContainerNameHasBeenSet; }

    /**
     * <p>The name of the container related to a finding.</p>
     */
    inline void SetResourceContainerName(const Aws::Vector<StringFilter>& value) { m_resourceContainerNameHasBeenSet = true; m_resourceContainerName = value; }

    /**
     * <p>The name of the container related to a finding.</p>
     */
    inline void SetResourceContainerName(Aws::Vector<StringFilter>&& value) { m_resourceContainerNameHasBeenSet = true; m_resourceContainerName = std::move(value); }

    /**
     * <p>The name of the container related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceContainerName(const Aws::Vector<StringFilter>& value) { SetResourceContainerName(value); return *this;}

    /**
     * <p>The name of the container related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceContainerName(Aws::Vector<StringFilter>&& value) { SetResourceContainerName(std::move(value)); return *this;}

    /**
     * <p>The name of the container related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceContainerName(const StringFilter& value) { m_resourceContainerNameHasBeenSet = true; m_resourceContainerName.push_back(value); return *this; }

    /**
     * <p>The name of the container related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceContainerName(StringFilter&& value) { m_resourceContainerNameHasBeenSet = true; m_resourceContainerName.push_back(std::move(value)); return *this; }


    /**
     * <p>The identifier of the image related to a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceContainerImageId() const{ return m_resourceContainerImageId; }

    /**
     * <p>The identifier of the image related to a finding.</p>
     */
    inline bool ResourceContainerImageIdHasBeenSet() const { return m_resourceContainerImageIdHasBeenSet; }

    /**
     * <p>The identifier of the image related to a finding.</p>
     */
    inline void SetResourceContainerImageId(const Aws::Vector<StringFilter>& value) { m_resourceContainerImageIdHasBeenSet = true; m_resourceContainerImageId = value; }

    /**
     * <p>The identifier of the image related to a finding.</p>
     */
    inline void SetResourceContainerImageId(Aws::Vector<StringFilter>&& value) { m_resourceContainerImageIdHasBeenSet = true; m_resourceContainerImageId = std::move(value); }

    /**
     * <p>The identifier of the image related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceContainerImageId(const Aws::Vector<StringFilter>& value) { SetResourceContainerImageId(value); return *this;}

    /**
     * <p>The identifier of the image related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceContainerImageId(Aws::Vector<StringFilter>&& value) { SetResourceContainerImageId(std::move(value)); return *this;}

    /**
     * <p>The identifier of the image related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceContainerImageId(const StringFilter& value) { m_resourceContainerImageIdHasBeenSet = true; m_resourceContainerImageId.push_back(value); return *this; }

    /**
     * <p>The identifier of the image related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceContainerImageId(StringFilter&& value) { m_resourceContainerImageIdHasBeenSet = true; m_resourceContainerImageId.push_back(std::move(value)); return *this; }


    /**
     * <p>The name of the image related to a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetResourceContainerImageName() const{ return m_resourceContainerImageName; }

    /**
     * <p>The name of the image related to a finding.</p>
     */
    inline bool ResourceContainerImageNameHasBeenSet() const { return m_resourceContainerImageNameHasBeenSet; }

    /**
     * <p>The name of the image related to a finding.</p>
     */
    inline void SetResourceContainerImageName(const Aws::Vector<StringFilter>& value) { m_resourceContainerImageNameHasBeenSet = true; m_resourceContainerImageName = value; }

    /**
     * <p>The name of the image related to a finding.</p>
     */
    inline void SetResourceContainerImageName(Aws::Vector<StringFilter>&& value) { m_resourceContainerImageNameHasBeenSet = true; m_resourceContainerImageName = std::move(value); }

    /**
     * <p>The name of the image related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceContainerImageName(const Aws::Vector<StringFilter>& value) { SetResourceContainerImageName(value); return *this;}

    /**
     * <p>The name of the image related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceContainerImageName(Aws::Vector<StringFilter>&& value) { SetResourceContainerImageName(std::move(value)); return *this;}

    /**
     * <p>The name of the image related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceContainerImageName(const StringFilter& value) { m_resourceContainerImageNameHasBeenSet = true; m_resourceContainerImageName.push_back(value); return *this; }

    /**
     * <p>The name of the image related to a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceContainerImageName(StringFilter&& value) { m_resourceContainerImageNameHasBeenSet = true; m_resourceContainerImageName.push_back(std::move(value)); return *this; }


    /**
     * <p>The date/time that the container was started.</p>
     */
    inline const Aws::Vector<DateFilter>& GetResourceContainerLaunchedAt() const{ return m_resourceContainerLaunchedAt; }

    /**
     * <p>The date/time that the container was started.</p>
     */
    inline bool ResourceContainerLaunchedAtHasBeenSet() const { return m_resourceContainerLaunchedAtHasBeenSet; }

    /**
     * <p>The date/time that the container was started.</p>
     */
    inline void SetResourceContainerLaunchedAt(const Aws::Vector<DateFilter>& value) { m_resourceContainerLaunchedAtHasBeenSet = true; m_resourceContainerLaunchedAt = value; }

    /**
     * <p>The date/time that the container was started.</p>
     */
    inline void SetResourceContainerLaunchedAt(Aws::Vector<DateFilter>&& value) { m_resourceContainerLaunchedAtHasBeenSet = true; m_resourceContainerLaunchedAt = std::move(value); }

    /**
     * <p>The date/time that the container was started.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceContainerLaunchedAt(const Aws::Vector<DateFilter>& value) { SetResourceContainerLaunchedAt(value); return *this;}

    /**
     * <p>The date/time that the container was started.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceContainerLaunchedAt(Aws::Vector<DateFilter>&& value) { SetResourceContainerLaunchedAt(std::move(value)); return *this;}

    /**
     * <p>The date/time that the container was started.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceContainerLaunchedAt(const DateFilter& value) { m_resourceContainerLaunchedAtHasBeenSet = true; m_resourceContainerLaunchedAt.push_back(value); return *this; }

    /**
     * <p>The date/time that the container was started.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceContainerLaunchedAt(DateFilter&& value) { m_resourceContainerLaunchedAtHasBeenSet = true; m_resourceContainerLaunchedAt.push_back(std::move(value)); return *this; }


    /**
     * <p>The details of a resource that doesn't have a specific subfield for the
     * resource type defined.</p>
     */
    inline const Aws::Vector<MapFilter>& GetResourceDetailsOther() const{ return m_resourceDetailsOther; }

    /**
     * <p>The details of a resource that doesn't have a specific subfield for the
     * resource type defined.</p>
     */
    inline bool ResourceDetailsOtherHasBeenSet() const { return m_resourceDetailsOtherHasBeenSet; }

    /**
     * <p>The details of a resource that doesn't have a specific subfield for the
     * resource type defined.</p>
     */
    inline void SetResourceDetailsOther(const Aws::Vector<MapFilter>& value) { m_resourceDetailsOtherHasBeenSet = true; m_resourceDetailsOther = value; }

    /**
     * <p>The details of a resource that doesn't have a specific subfield for the
     * resource type defined.</p>
     */
    inline void SetResourceDetailsOther(Aws::Vector<MapFilter>&& value) { m_resourceDetailsOtherHasBeenSet = true; m_resourceDetailsOther = std::move(value); }

    /**
     * <p>The details of a resource that doesn't have a specific subfield for the
     * resource type defined.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceDetailsOther(const Aws::Vector<MapFilter>& value) { SetResourceDetailsOther(value); return *this;}

    /**
     * <p>The details of a resource that doesn't have a specific subfield for the
     * resource type defined.</p>
     */
    inline AwsSecurityFindingFilters& WithResourceDetailsOther(Aws::Vector<MapFilter>&& value) { SetResourceDetailsOther(std::move(value)); return *this;}

    /**
     * <p>The details of a resource that doesn't have a specific subfield for the
     * resource type defined.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceDetailsOther(const MapFilter& value) { m_resourceDetailsOtherHasBeenSet = true; m_resourceDetailsOther.push_back(value); return *this; }

    /**
     * <p>The details of a resource that doesn't have a specific subfield for the
     * resource type defined.</p>
     */
    inline AwsSecurityFindingFilters& AddResourceDetailsOther(MapFilter&& value) { m_resourceDetailsOtherHasBeenSet = true; m_resourceDetailsOther.push_back(std::move(value)); return *this; }


    /**
     * <p>Exclusive to findings that are generated as the result of a check run against
     * a specific rule in a supported standard, such as CIS AWS Foundations. Contains
     * security standard-related finding details.</p>
     */
    inline const Aws::Vector<StringFilter>& GetComplianceStatus() const{ return m_complianceStatus; }

    /**
     * <p>Exclusive to findings that are generated as the result of a check run against
     * a specific rule in a supported standard, such as CIS AWS Foundations. Contains
     * security standard-related finding details.</p>
     */
    inline bool ComplianceStatusHasBeenSet() const { return m_complianceStatusHasBeenSet; }

    /**
     * <p>Exclusive to findings that are generated as the result of a check run against
     * a specific rule in a supported standard, such as CIS AWS Foundations. Contains
     * security standard-related finding details.</p>
     */
    inline void SetComplianceStatus(const Aws::Vector<StringFilter>& value) { m_complianceStatusHasBeenSet = true; m_complianceStatus = value; }

    /**
     * <p>Exclusive to findings that are generated as the result of a check run against
     * a specific rule in a supported standard, such as CIS AWS Foundations. Contains
     * security standard-related finding details.</p>
     */
    inline void SetComplianceStatus(Aws::Vector<StringFilter>&& value) { m_complianceStatusHasBeenSet = true; m_complianceStatus = std::move(value); }

    /**
     * <p>Exclusive to findings that are generated as the result of a check run against
     * a specific rule in a supported standard, such as CIS AWS Foundations. Contains
     * security standard-related finding details.</p>
     */
    inline AwsSecurityFindingFilters& WithComplianceStatus(const Aws::Vector<StringFilter>& value) { SetComplianceStatus(value); return *this;}

    /**
     * <p>Exclusive to findings that are generated as the result of a check run against
     * a specific rule in a supported standard, such as CIS AWS Foundations. Contains
     * security standard-related finding details.</p>
     */
    inline AwsSecurityFindingFilters& WithComplianceStatus(Aws::Vector<StringFilter>&& value) { SetComplianceStatus(std::move(value)); return *this;}

    /**
     * <p>Exclusive to findings that are generated as the result of a check run against
     * a specific rule in a supported standard, such as CIS AWS Foundations. Contains
     * security standard-related finding details.</p>
     */
    inline AwsSecurityFindingFilters& AddComplianceStatus(const StringFilter& value) { m_complianceStatusHasBeenSet = true; m_complianceStatus.push_back(value); return *this; }

    /**
     * <p>Exclusive to findings that are generated as the result of a check run against
     * a specific rule in a supported standard, such as CIS AWS Foundations. Contains
     * security standard-related finding details.</p>
     */
    inline AwsSecurityFindingFilters& AddComplianceStatus(StringFilter&& value) { m_complianceStatusHasBeenSet = true; m_complianceStatus.push_back(std::move(value)); return *this; }


    /**
     * <p>The veracity of a finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetVerificationState() const{ return m_verificationState; }

    /**
     * <p>The veracity of a finding.</p>
     */
    inline bool VerificationStateHasBeenSet() const { return m_verificationStateHasBeenSet; }

    /**
     * <p>The veracity of a finding.</p>
     */
    inline void SetVerificationState(const Aws::Vector<StringFilter>& value) { m_verificationStateHasBeenSet = true; m_verificationState = value; }

    /**
     * <p>The veracity of a finding.</p>
     */
    inline void SetVerificationState(Aws::Vector<StringFilter>&& value) { m_verificationStateHasBeenSet = true; m_verificationState = std::move(value); }

    /**
     * <p>The veracity of a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithVerificationState(const Aws::Vector<StringFilter>& value) { SetVerificationState(value); return *this;}

    /**
     * <p>The veracity of a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithVerificationState(Aws::Vector<StringFilter>&& value) { SetVerificationState(std::move(value)); return *this;}

    /**
     * <p>The veracity of a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddVerificationState(const StringFilter& value) { m_verificationStateHasBeenSet = true; m_verificationState.push_back(value); return *this; }

    /**
     * <p>The veracity of a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddVerificationState(StringFilter&& value) { m_verificationStateHasBeenSet = true; m_verificationState.push_back(std::move(value)); return *this; }


    /**
     * <p>The workflow state of a finding.</p> <p>Note that this field is deprecated.
     * To search for a finding based on its workflow status, use
     * <code>WorkflowStatus</code>.</p>
     */
    inline const Aws::Vector<StringFilter>& GetWorkflowState() const{ return m_workflowState; }

    /**
     * <p>The workflow state of a finding.</p> <p>Note that this field is deprecated.
     * To search for a finding based on its workflow status, use
     * <code>WorkflowStatus</code>.</p>
     */
    inline bool WorkflowStateHasBeenSet() const { return m_workflowStateHasBeenSet; }

    /**
     * <p>The workflow state of a finding.</p> <p>Note that this field is deprecated.
     * To search for a finding based on its workflow status, use
     * <code>WorkflowStatus</code>.</p>
     */
    inline void SetWorkflowState(const Aws::Vector<StringFilter>& value) { m_workflowStateHasBeenSet = true; m_workflowState = value; }

    /**
     * <p>The workflow state of a finding.</p> <p>Note that this field is deprecated.
     * To search for a finding based on its workflow status, use
     * <code>WorkflowStatus</code>.</p>
     */
    inline void SetWorkflowState(Aws::Vector<StringFilter>&& value) { m_workflowStateHasBeenSet = true; m_workflowState = std::move(value); }

    /**
     * <p>The workflow state of a finding.</p> <p>Note that this field is deprecated.
     * To search for a finding based on its workflow status, use
     * <code>WorkflowStatus</code>.</p>
     */
    inline AwsSecurityFindingFilters& WithWorkflowState(const Aws::Vector<StringFilter>& value) { SetWorkflowState(value); return *this;}

    /**
     * <p>The workflow state of a finding.</p> <p>Note that this field is deprecated.
     * To search for a finding based on its workflow status, use
     * <code>WorkflowStatus</code>.</p>
     */
    inline AwsSecurityFindingFilters& WithWorkflowState(Aws::Vector<StringFilter>&& value) { SetWorkflowState(std::move(value)); return *this;}

    /**
     * <p>The workflow state of a finding.</p> <p>Note that this field is deprecated.
     * To search for a finding based on its workflow status, use
     * <code>WorkflowStatus</code>.</p>
     */
    inline AwsSecurityFindingFilters& AddWorkflowState(const StringFilter& value) { m_workflowStateHasBeenSet = true; m_workflowState.push_back(value); return *this; }

    /**
     * <p>The workflow state of a finding.</p> <p>Note that this field is deprecated.
     * To search for a finding based on its workflow status, use
     * <code>WorkflowStatus</code>.</p>
     */
    inline AwsSecurityFindingFilters& AddWorkflowState(StringFilter&& value) { m_workflowStateHasBeenSet = true; m_workflowState.push_back(std::move(value)); return *this; }


    /**
     * <p>The status of the investigation into a finding. Allowed values are the
     * following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding,
     * before it is reviewed.</p> <p>Security Hub also resets the workflow status from
     * <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the
     * following cases:</p> <ul> <li> <p>The record state changes from
     * <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p>The compliance
     * status changes from <code>PASSED</code> to either <code>WARNING</code>,
     * <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> </li> <li>
     * <p> <code>NOTIFIED</code> - Indicates that the resource owner has been notified
     * about the security issue. Used when the initial reviewer is not the resource
     * owner, and needs intervention from the resource owner.</p> </li> <li> <p>
     * <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be
     * acted upon.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed
     * and remediated and is now considered resolved. </p> </li> </ul>
     */
    inline const Aws::Vector<StringFilter>& GetWorkflowStatus() const{ return m_workflowStatus; }

    /**
     * <p>The status of the investigation into a finding. Allowed values are the
     * following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding,
     * before it is reviewed.</p> <p>Security Hub also resets the workflow status from
     * <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the
     * following cases:</p> <ul> <li> <p>The record state changes from
     * <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p>The compliance
     * status changes from <code>PASSED</code> to either <code>WARNING</code>,
     * <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> </li> <li>
     * <p> <code>NOTIFIED</code> - Indicates that the resource owner has been notified
     * about the security issue. Used when the initial reviewer is not the resource
     * owner, and needs intervention from the resource owner.</p> </li> <li> <p>
     * <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be
     * acted upon.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed
     * and remediated and is now considered resolved. </p> </li> </ul>
     */
    inline bool WorkflowStatusHasBeenSet() const { return m_workflowStatusHasBeenSet; }

    /**
     * <p>The status of the investigation into a finding. Allowed values are the
     * following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding,
     * before it is reviewed.</p> <p>Security Hub also resets the workflow status from
     * <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the
     * following cases:</p> <ul> <li> <p>The record state changes from
     * <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p>The compliance
     * status changes from <code>PASSED</code> to either <code>WARNING</code>,
     * <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> </li> <li>
     * <p> <code>NOTIFIED</code> - Indicates that the resource owner has been notified
     * about the security issue. Used when the initial reviewer is not the resource
     * owner, and needs intervention from the resource owner.</p> </li> <li> <p>
     * <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be
     * acted upon.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed
     * and remediated and is now considered resolved. </p> </li> </ul>
     */
    inline void SetWorkflowStatus(const Aws::Vector<StringFilter>& value) { m_workflowStatusHasBeenSet = true; m_workflowStatus = value; }

    /**
     * <p>The status of the investigation into a finding. Allowed values are the
     * following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding,
     * before it is reviewed.</p> <p>Security Hub also resets the workflow status from
     * <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the
     * following cases:</p> <ul> <li> <p>The record state changes from
     * <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p>The compliance
     * status changes from <code>PASSED</code> to either <code>WARNING</code>,
     * <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> </li> <li>
     * <p> <code>NOTIFIED</code> - Indicates that the resource owner has been notified
     * about the security issue. Used when the initial reviewer is not the resource
     * owner, and needs intervention from the resource owner.</p> </li> <li> <p>
     * <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be
     * acted upon.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed
     * and remediated and is now considered resolved. </p> </li> </ul>
     */
    inline void SetWorkflowStatus(Aws::Vector<StringFilter>&& value) { m_workflowStatusHasBeenSet = true; m_workflowStatus = std::move(value); }

    /**
     * <p>The status of the investigation into a finding. Allowed values are the
     * following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding,
     * before it is reviewed.</p> <p>Security Hub also resets the workflow status from
     * <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the
     * following cases:</p> <ul> <li> <p>The record state changes from
     * <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p>The compliance
     * status changes from <code>PASSED</code> to either <code>WARNING</code>,
     * <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> </li> <li>
     * <p> <code>NOTIFIED</code> - Indicates that the resource owner has been notified
     * about the security issue. Used when the initial reviewer is not the resource
     * owner, and needs intervention from the resource owner.</p> </li> <li> <p>
     * <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be
     * acted upon.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed
     * and remediated and is now considered resolved. </p> </li> </ul>
     */
    inline AwsSecurityFindingFilters& WithWorkflowStatus(const Aws::Vector<StringFilter>& value) { SetWorkflowStatus(value); return *this;}

    /**
     * <p>The status of the investigation into a finding. Allowed values are the
     * following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding,
     * before it is reviewed.</p> <p>Security Hub also resets the workflow status from
     * <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the
     * following cases:</p> <ul> <li> <p>The record state changes from
     * <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p>The compliance
     * status changes from <code>PASSED</code> to either <code>WARNING</code>,
     * <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> </li> <li>
     * <p> <code>NOTIFIED</code> - Indicates that the resource owner has been notified
     * about the security issue. Used when the initial reviewer is not the resource
     * owner, and needs intervention from the resource owner.</p> </li> <li> <p>
     * <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be
     * acted upon.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed
     * and remediated and is now considered resolved. </p> </li> </ul>
     */
    inline AwsSecurityFindingFilters& WithWorkflowStatus(Aws::Vector<StringFilter>&& value) { SetWorkflowStatus(std::move(value)); return *this;}

    /**
     * <p>The status of the investigation into a finding. Allowed values are the
     * following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding,
     * before it is reviewed.</p> <p>Security Hub also resets the workflow status from
     * <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the
     * following cases:</p> <ul> <li> <p>The record state changes from
     * <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p>The compliance
     * status changes from <code>PASSED</code> to either <code>WARNING</code>,
     * <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> </li> <li>
     * <p> <code>NOTIFIED</code> - Indicates that the resource owner has been notified
     * about the security issue. Used when the initial reviewer is not the resource
     * owner, and needs intervention from the resource owner.</p> </li> <li> <p>
     * <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be
     * acted upon.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed
     * and remediated and is now considered resolved. </p> </li> </ul>
     */
    inline AwsSecurityFindingFilters& AddWorkflowStatus(const StringFilter& value) { m_workflowStatusHasBeenSet = true; m_workflowStatus.push_back(value); return *this; }

    /**
     * <p>The status of the investigation into a finding. Allowed values are the
     * following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding,
     * before it is reviewed.</p> <p>Security Hub also resets the workflow status from
     * <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the
     * following cases:</p> <ul> <li> <p>The record state changes from
     * <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p>The compliance
     * status changes from <code>PASSED</code> to either <code>WARNING</code>,
     * <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> </li> <li>
     * <p> <code>NOTIFIED</code> - Indicates that the resource owner has been notified
     * about the security issue. Used when the initial reviewer is not the resource
     * owner, and needs intervention from the resource owner.</p> </li> <li> <p>
     * <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be
     * acted upon.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed
     * and remediated and is now considered resolved. </p> </li> </ul>
     */
    inline AwsSecurityFindingFilters& AddWorkflowStatus(StringFilter&& value) { m_workflowStatusHasBeenSet = true; m_workflowStatus.push_back(std::move(value)); return *this; }


    /**
     * <p>The updated record state for the finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetRecordState() const{ return m_recordState; }

    /**
     * <p>The updated record state for the finding.</p>
     */
    inline bool RecordStateHasBeenSet() const { return m_recordStateHasBeenSet; }

    /**
     * <p>The updated record state for the finding.</p>
     */
    inline void SetRecordState(const Aws::Vector<StringFilter>& value) { m_recordStateHasBeenSet = true; m_recordState = value; }

    /**
     * <p>The updated record state for the finding.</p>
     */
    inline void SetRecordState(Aws::Vector<StringFilter>&& value) { m_recordStateHasBeenSet = true; m_recordState = std::move(value); }

    /**
     * <p>The updated record state for the finding.</p>
     */
    inline AwsSecurityFindingFilters& WithRecordState(const Aws::Vector<StringFilter>& value) { SetRecordState(value); return *this;}

    /**
     * <p>The updated record state for the finding.</p>
     */
    inline AwsSecurityFindingFilters& WithRecordState(Aws::Vector<StringFilter>&& value) { SetRecordState(std::move(value)); return *this;}

    /**
     * <p>The updated record state for the finding.</p>
     */
    inline AwsSecurityFindingFilters& AddRecordState(const StringFilter& value) { m_recordStateHasBeenSet = true; m_recordState.push_back(value); return *this; }

    /**
     * <p>The updated record state for the finding.</p>
     */
    inline AwsSecurityFindingFilters& AddRecordState(StringFilter&& value) { m_recordStateHasBeenSet = true; m_recordState.push_back(std::move(value)); return *this; }


    /**
     * <p>The ARN of the solution that generated a related finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetRelatedFindingsProductArn() const{ return m_relatedFindingsProductArn; }

    /**
     * <p>The ARN of the solution that generated a related finding.</p>
     */
    inline bool RelatedFindingsProductArnHasBeenSet() const { return m_relatedFindingsProductArnHasBeenSet; }

    /**
     * <p>The ARN of the solution that generated a related finding.</p>
     */
    inline void SetRelatedFindingsProductArn(const Aws::Vector<StringFilter>& value) { m_relatedFindingsProductArnHasBeenSet = true; m_relatedFindingsProductArn = value; }

    /**
     * <p>The ARN of the solution that generated a related finding.</p>
     */
    inline void SetRelatedFindingsProductArn(Aws::Vector<StringFilter>&& value) { m_relatedFindingsProductArnHasBeenSet = true; m_relatedFindingsProductArn = std::move(value); }

    /**
     * <p>The ARN of the solution that generated a related finding.</p>
     */
    inline AwsSecurityFindingFilters& WithRelatedFindingsProductArn(const Aws::Vector<StringFilter>& value) { SetRelatedFindingsProductArn(value); return *this;}

    /**
     * <p>The ARN of the solution that generated a related finding.</p>
     */
    inline AwsSecurityFindingFilters& WithRelatedFindingsProductArn(Aws::Vector<StringFilter>&& value) { SetRelatedFindingsProductArn(std::move(value)); return *this;}

    /**
     * <p>The ARN of the solution that generated a related finding.</p>
     */
    inline AwsSecurityFindingFilters& AddRelatedFindingsProductArn(const StringFilter& value) { m_relatedFindingsProductArnHasBeenSet = true; m_relatedFindingsProductArn.push_back(value); return *this; }

    /**
     * <p>The ARN of the solution that generated a related finding.</p>
     */
    inline AwsSecurityFindingFilters& AddRelatedFindingsProductArn(StringFilter&& value) { m_relatedFindingsProductArnHasBeenSet = true; m_relatedFindingsProductArn.push_back(std::move(value)); return *this; }


    /**
     * <p>The solution-generated identifier for a related finding.</p>
     */
    inline const Aws::Vector<StringFilter>& GetRelatedFindingsId() const{ return m_relatedFindingsId; }

    /**
     * <p>The solution-generated identifier for a related finding.</p>
     */
    inline bool RelatedFindingsIdHasBeenSet() const { return m_relatedFindingsIdHasBeenSet; }

    /**
     * <p>The solution-generated identifier for a related finding.</p>
     */
    inline void SetRelatedFindingsId(const Aws::Vector<StringFilter>& value) { m_relatedFindingsIdHasBeenSet = true; m_relatedFindingsId = value; }

    /**
     * <p>The solution-generated identifier for a related finding.</p>
     */
    inline void SetRelatedFindingsId(Aws::Vector<StringFilter>&& value) { m_relatedFindingsIdHasBeenSet = true; m_relatedFindingsId = std::move(value); }

    /**
     * <p>The solution-generated identifier for a related finding.</p>
     */
    inline AwsSecurityFindingFilters& WithRelatedFindingsId(const Aws::Vector<StringFilter>& value) { SetRelatedFindingsId(value); return *this;}

    /**
     * <p>The solution-generated identifier for a related finding.</p>
     */
    inline AwsSecurityFindingFilters& WithRelatedFindingsId(Aws::Vector<StringFilter>&& value) { SetRelatedFindingsId(std::move(value)); return *this;}

    /**
     * <p>The solution-generated identifier for a related finding.</p>
     */
    inline AwsSecurityFindingFilters& AddRelatedFindingsId(const StringFilter& value) { m_relatedFindingsIdHasBeenSet = true; m_relatedFindingsId.push_back(value); return *this; }

    /**
     * <p>The solution-generated identifier for a related finding.</p>
     */
    inline AwsSecurityFindingFilters& AddRelatedFindingsId(StringFilter&& value) { m_relatedFindingsIdHasBeenSet = true; m_relatedFindingsId.push_back(std::move(value)); return *this; }


    /**
     * <p>The text of a note.</p>
     */
    inline const Aws::Vector<StringFilter>& GetNoteText() const{ return m_noteText; }

    /**
     * <p>The text of a note.</p>
     */
    inline bool NoteTextHasBeenSet() const { return m_noteTextHasBeenSet; }

    /**
     * <p>The text of a note.</p>
     */
    inline void SetNoteText(const Aws::Vector<StringFilter>& value) { m_noteTextHasBeenSet = true; m_noteText = value; }

    /**
     * <p>The text of a note.</p>
     */
    inline void SetNoteText(Aws::Vector<StringFilter>&& value) { m_noteTextHasBeenSet = true; m_noteText = std::move(value); }

    /**
     * <p>The text of a note.</p>
     */
    inline AwsSecurityFindingFilters& WithNoteText(const Aws::Vector<StringFilter>& value) { SetNoteText(value); return *this;}

    /**
     * <p>The text of a note.</p>
     */
    inline AwsSecurityFindingFilters& WithNoteText(Aws::Vector<StringFilter>&& value) { SetNoteText(std::move(value)); return *this;}

    /**
     * <p>The text of a note.</p>
     */
    inline AwsSecurityFindingFilters& AddNoteText(const StringFilter& value) { m_noteTextHasBeenSet = true; m_noteText.push_back(value); return *this; }

    /**
     * <p>The text of a note.</p>
     */
    inline AwsSecurityFindingFilters& AddNoteText(StringFilter&& value) { m_noteTextHasBeenSet = true; m_noteText.push_back(std::move(value)); return *this; }


    /**
     * <p>The timestamp of when the note was updated.</p>
     */
    inline const Aws::Vector<DateFilter>& GetNoteUpdatedAt() const{ return m_noteUpdatedAt; }

    /**
     * <p>The timestamp of when the note was updated.</p>
     */
    inline bool NoteUpdatedAtHasBeenSet() const { return m_noteUpdatedAtHasBeenSet; }

    /**
     * <p>The timestamp of when the note was updated.</p>
     */
    inline void SetNoteUpdatedAt(const Aws::Vector<DateFilter>& value) { m_noteUpdatedAtHasBeenSet = true; m_noteUpdatedAt = value; }

    /**
     * <p>The timestamp of when the note was updated.</p>
     */
    inline void SetNoteUpdatedAt(Aws::Vector<DateFilter>&& value) { m_noteUpdatedAtHasBeenSet = true; m_noteUpdatedAt = std::move(value); }

    /**
     * <p>The timestamp of when the note was updated.</p>
     */
    inline AwsSecurityFindingFilters& WithNoteUpdatedAt(const Aws::Vector<DateFilter>& value) { SetNoteUpdatedAt(value); return *this;}

    /**
     * <p>The timestamp of when the note was updated.</p>
     */
    inline AwsSecurityFindingFilters& WithNoteUpdatedAt(Aws::Vector<DateFilter>&& value) { SetNoteUpdatedAt(std::move(value)); return *this;}

    /**
     * <p>The timestamp of when the note was updated.</p>
     */
    inline AwsSecurityFindingFilters& AddNoteUpdatedAt(const DateFilter& value) { m_noteUpdatedAtHasBeenSet = true; m_noteUpdatedAt.push_back(value); return *this; }

    /**
     * <p>The timestamp of when the note was updated.</p>
     */
    inline AwsSecurityFindingFilters& AddNoteUpdatedAt(DateFilter&& value) { m_noteUpdatedAtHasBeenSet = true; m_noteUpdatedAt.push_back(std::move(value)); return *this; }


    /**
     * <p>The principal that created a note.</p>
     */
    inline const Aws::Vector<StringFilter>& GetNoteUpdatedBy() const{ return m_noteUpdatedBy; }

    /**
     * <p>The principal that created a note.</p>
     */
    inline bool NoteUpdatedByHasBeenSet() const { return m_noteUpdatedByHasBeenSet; }

    /**
     * <p>The principal that created a note.</p>
     */
    inline void SetNoteUpdatedBy(const Aws::Vector<StringFilter>& value) { m_noteUpdatedByHasBeenSet = true; m_noteUpdatedBy = value; }

    /**
     * <p>The principal that created a note.</p>
     */
    inline void SetNoteUpdatedBy(Aws::Vector<StringFilter>&& value) { m_noteUpdatedByHasBeenSet = true; m_noteUpdatedBy = std::move(value); }

    /**
     * <p>The principal that created a note.</p>
     */
    inline AwsSecurityFindingFilters& WithNoteUpdatedBy(const Aws::Vector<StringFilter>& value) { SetNoteUpdatedBy(value); return *this;}

    /**
     * <p>The principal that created a note.</p>
     */
    inline AwsSecurityFindingFilters& WithNoteUpdatedBy(Aws::Vector<StringFilter>&& value) { SetNoteUpdatedBy(std::move(value)); return *this;}

    /**
     * <p>The principal that created a note.</p>
     */
    inline AwsSecurityFindingFilters& AddNoteUpdatedBy(const StringFilter& value) { m_noteUpdatedByHasBeenSet = true; m_noteUpdatedBy.push_back(value); return *this; }

    /**
     * <p>The principal that created a note.</p>
     */
    inline AwsSecurityFindingFilters& AddNoteUpdatedBy(StringFilter&& value) { m_noteUpdatedByHasBeenSet = true; m_noteUpdatedBy.push_back(std::move(value)); return *this; }


    /**
     * <p>A keyword for a finding.</p>
     */
    inline const Aws::Vector<KeywordFilter>& GetKeyword() const{ return m_keyword; }

    /**
     * <p>A keyword for a finding.</p>
     */
    inline bool KeywordHasBeenSet() const { return m_keywordHasBeenSet; }

    /**
     * <p>A keyword for a finding.</p>
     */
    inline void SetKeyword(const Aws::Vector<KeywordFilter>& value) { m_keywordHasBeenSet = true; m_keyword = value; }

    /**
     * <p>A keyword for a finding.</p>
     */
    inline void SetKeyword(Aws::Vector<KeywordFilter>&& value) { m_keywordHasBeenSet = true; m_keyword = std::move(value); }

    /**
     * <p>A keyword for a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithKeyword(const Aws::Vector<KeywordFilter>& value) { SetKeyword(value); return *this;}

    /**
     * <p>A keyword for a finding.</p>
     */
    inline AwsSecurityFindingFilters& WithKeyword(Aws::Vector<KeywordFilter>&& value) { SetKeyword(std::move(value)); return *this;}

    /**
     * <p>A keyword for a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddKeyword(const KeywordFilter& value) { m_keywordHasBeenSet = true; m_keyword.push_back(value); return *this; }

    /**
     * <p>A keyword for a finding.</p>
     */
    inline AwsSecurityFindingFilters& AddKeyword(KeywordFilter&& value) { m_keywordHasBeenSet = true; m_keyword.push_back(std::move(value)); return *this; }


    /**
     * <p>The finding provider value for the finding confidence. Confidence is defined
     * as the likelihood that a finding accurately identifies the behavior or issue
     * that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis
     * using a ratio scale, where 0 means zero percent confidence and 100 means 100
     * percent confidence.</p>
     */
    inline const Aws::Vector<NumberFilter>& GetFindingProviderFieldsConfidence() const{ return m_findingProviderFieldsConfidence; }

    /**
     * <p>The finding provider value for the finding confidence. Confidence is defined
     * as the likelihood that a finding accurately identifies the behavior or issue
     * that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis
     * using a ratio scale, where 0 means zero percent confidence and 100 means 100
     * percent confidence.</p>
     */
    inline bool FindingProviderFieldsConfidenceHasBeenSet() const { return m_findingProviderFieldsConfidenceHasBeenSet; }

    /**
     * <p>The finding provider value for the finding confidence. Confidence is defined
     * as the likelihood that a finding accurately identifies the behavior or issue
     * that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis
     * using a ratio scale, where 0 means zero percent confidence and 100 means 100
     * percent confidence.</p>
     */
    inline void SetFindingProviderFieldsConfidence(const Aws::Vector<NumberFilter>& value) { m_findingProviderFieldsConfidenceHasBeenSet = true; m_findingProviderFieldsConfidence = value; }

    /**
     * <p>The finding provider value for the finding confidence. Confidence is defined
     * as the likelihood that a finding accurately identifies the behavior or issue
     * that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis
     * using a ratio scale, where 0 means zero percent confidence and 100 means 100
     * percent confidence.</p>
     */
    inline void SetFindingProviderFieldsConfidence(Aws::Vector<NumberFilter>&& value) { m_findingProviderFieldsConfidenceHasBeenSet = true; m_findingProviderFieldsConfidence = std::move(value); }

    /**
     * <p>The finding provider value for the finding confidence. Confidence is defined
     * as the likelihood that a finding accurately identifies the behavior or issue
     * that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis
     * using a ratio scale, where 0 means zero percent confidence and 100 means 100
     * percent confidence.</p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsConfidence(const Aws::Vector<NumberFilter>& value) { SetFindingProviderFieldsConfidence(value); return *this;}

    /**
     * <p>The finding provider value for the finding confidence. Confidence is defined
     * as the likelihood that a finding accurately identifies the behavior or issue
     * that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis
     * using a ratio scale, where 0 means zero percent confidence and 100 means 100
     * percent confidence.</p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsConfidence(Aws::Vector<NumberFilter>&& value) { SetFindingProviderFieldsConfidence(std::move(value)); return *this;}

    /**
     * <p>The finding provider value for the finding confidence. Confidence is defined
     * as the likelihood that a finding accurately identifies the behavior or issue
     * that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis
     * using a ratio scale, where 0 means zero percent confidence and 100 means 100
     * percent confidence.</p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsConfidence(const NumberFilter& value) { m_findingProviderFieldsConfidenceHasBeenSet = true; m_findingProviderFieldsConfidence.push_back(value); return *this; }

    /**
     * <p>The finding provider value for the finding confidence. Confidence is defined
     * as the likelihood that a finding accurately identifies the behavior or issue
     * that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis
     * using a ratio scale, where 0 means zero percent confidence and 100 means 100
     * percent confidence.</p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsConfidence(NumberFilter&& value) { m_findingProviderFieldsConfidenceHasBeenSet = true; m_findingProviderFieldsConfidence.push_back(std::move(value)); return *this; }


    /**
     * <p>The finding provider value for the level of importance assigned to the
     * resources associated with the findings.</p> <p>A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the
     * most critical resources. </p>
     */
    inline const Aws::Vector<NumberFilter>& GetFindingProviderFieldsCriticality() const{ return m_findingProviderFieldsCriticality; }

    /**
     * <p>The finding provider value for the level of importance assigned to the
     * resources associated with the findings.</p> <p>A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the
     * most critical resources. </p>
     */
    inline bool FindingProviderFieldsCriticalityHasBeenSet() const { return m_findingProviderFieldsCriticalityHasBeenSet; }

    /**
     * <p>The finding provider value for the level of importance assigned to the
     * resources associated with the findings.</p> <p>A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the
     * most critical resources. </p>
     */
    inline void SetFindingProviderFieldsCriticality(const Aws::Vector<NumberFilter>& value) { m_findingProviderFieldsCriticalityHasBeenSet = true; m_findingProviderFieldsCriticality = value; }

    /**
     * <p>The finding provider value for the level of importance assigned to the
     * resources associated with the findings.</p> <p>A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the
     * most critical resources. </p>
     */
    inline void SetFindingProviderFieldsCriticality(Aws::Vector<NumberFilter>&& value) { m_findingProviderFieldsCriticalityHasBeenSet = true; m_findingProviderFieldsCriticality = std::move(value); }

    /**
     * <p>The finding provider value for the level of importance assigned to the
     * resources associated with the findings.</p> <p>A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the
     * most critical resources. </p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsCriticality(const Aws::Vector<NumberFilter>& value) { SetFindingProviderFieldsCriticality(value); return *this;}

    /**
     * <p>The finding provider value for the level of importance assigned to the
     * resources associated with the findings.</p> <p>A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the
     * most critical resources. </p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsCriticality(Aws::Vector<NumberFilter>&& value) { SetFindingProviderFieldsCriticality(std::move(value)); return *this;}

    /**
     * <p>The finding provider value for the level of importance assigned to the
     * resources associated with the findings.</p> <p>A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the
     * most critical resources. </p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsCriticality(const NumberFilter& value) { m_findingProviderFieldsCriticalityHasBeenSet = true; m_findingProviderFieldsCriticality.push_back(value); return *this; }

    /**
     * <p>The finding provider value for the level of importance assigned to the
     * resources associated with the findings.</p> <p>A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the
     * most critical resources. </p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsCriticality(NumberFilter&& value) { m_findingProviderFieldsCriticalityHasBeenSet = true; m_findingProviderFieldsCriticality.push_back(std::move(value)); return *this; }


    /**
     * <p>The finding identifier of a related finding that is identified by the finding
     * provider.</p>
     */
    inline const Aws::Vector<StringFilter>& GetFindingProviderFieldsRelatedFindingsId() const{ return m_findingProviderFieldsRelatedFindingsId; }

    /**
     * <p>The finding identifier of a related finding that is identified by the finding
     * provider.</p>
     */
    inline bool FindingProviderFieldsRelatedFindingsIdHasBeenSet() const { return m_findingProviderFieldsRelatedFindingsIdHasBeenSet; }

    /**
     * <p>The finding identifier of a related finding that is identified by the finding
     * provider.</p>
     */
    inline void SetFindingProviderFieldsRelatedFindingsId(const Aws::Vector<StringFilter>& value) { m_findingProviderFieldsRelatedFindingsIdHasBeenSet = true; m_findingProviderFieldsRelatedFindingsId = value; }

    /**
     * <p>The finding identifier of a related finding that is identified by the finding
     * provider.</p>
     */
    inline void SetFindingProviderFieldsRelatedFindingsId(Aws::Vector<StringFilter>&& value) { m_findingProviderFieldsRelatedFindingsIdHasBeenSet = true; m_findingProviderFieldsRelatedFindingsId = std::move(value); }

    /**
     * <p>The finding identifier of a related finding that is identified by the finding
     * provider.</p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsRelatedFindingsId(const Aws::Vector<StringFilter>& value) { SetFindingProviderFieldsRelatedFindingsId(value); return *this;}

    /**
     * <p>The finding identifier of a related finding that is identified by the finding
     * provider.</p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsRelatedFindingsId(Aws::Vector<StringFilter>&& value) { SetFindingProviderFieldsRelatedFindingsId(std::move(value)); return *this;}

    /**
     * <p>The finding identifier of a related finding that is identified by the finding
     * provider.</p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsRelatedFindingsId(const StringFilter& value) { m_findingProviderFieldsRelatedFindingsIdHasBeenSet = true; m_findingProviderFieldsRelatedFindingsId.push_back(value); return *this; }

    /**
     * <p>The finding identifier of a related finding that is identified by the finding
     * provider.</p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsRelatedFindingsId(StringFilter&& value) { m_findingProviderFieldsRelatedFindingsIdHasBeenSet = true; m_findingProviderFieldsRelatedFindingsId.push_back(std::move(value)); return *this; }


    /**
     * <p>The ARN of the solution that generated a related finding that is identified
     * by the finding provider.</p>
     */
    inline const Aws::Vector<StringFilter>& GetFindingProviderFieldsRelatedFindingsProductArn() const{ return m_findingProviderFieldsRelatedFindingsProductArn; }

    /**
     * <p>The ARN of the solution that generated a related finding that is identified
     * by the finding provider.</p>
     */
    inline bool FindingProviderFieldsRelatedFindingsProductArnHasBeenSet() const { return m_findingProviderFieldsRelatedFindingsProductArnHasBeenSet; }

    /**
     * <p>The ARN of the solution that generated a related finding that is identified
     * by the finding provider.</p>
     */
    inline void SetFindingProviderFieldsRelatedFindingsProductArn(const Aws::Vector<StringFilter>& value) { m_findingProviderFieldsRelatedFindingsProductArnHasBeenSet = true; m_findingProviderFieldsRelatedFindingsProductArn = value; }

    /**
     * <p>The ARN of the solution that generated a related finding that is identified
     * by the finding provider.</p>
     */
    inline void SetFindingProviderFieldsRelatedFindingsProductArn(Aws::Vector<StringFilter>&& value) { m_findingProviderFieldsRelatedFindingsProductArnHasBeenSet = true; m_findingProviderFieldsRelatedFindingsProductArn = std::move(value); }

    /**
     * <p>The ARN of the solution that generated a related finding that is identified
     * by the finding provider.</p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsRelatedFindingsProductArn(const Aws::Vector<StringFilter>& value) { SetFindingProviderFieldsRelatedFindingsProductArn(value); return *this;}

    /**
     * <p>The ARN of the solution that generated a related finding that is identified
     * by the finding provider.</p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsRelatedFindingsProductArn(Aws::Vector<StringFilter>&& value) { SetFindingProviderFieldsRelatedFindingsProductArn(std::move(value)); return *this;}

    /**
     * <p>The ARN of the solution that generated a related finding that is identified
     * by the finding provider.</p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsRelatedFindingsProductArn(const StringFilter& value) { m_findingProviderFieldsRelatedFindingsProductArnHasBeenSet = true; m_findingProviderFieldsRelatedFindingsProductArn.push_back(value); return *this; }

    /**
     * <p>The ARN of the solution that generated a related finding that is identified
     * by the finding provider.</p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsRelatedFindingsProductArn(StringFilter&& value) { m_findingProviderFieldsRelatedFindingsProductArnHasBeenSet = true; m_findingProviderFieldsRelatedFindingsProductArn.push_back(std::move(value)); return *this; }


    /**
     * <p>The finding provider value for the severity label.</p>
     */
    inline const Aws::Vector<StringFilter>& GetFindingProviderFieldsSeverityLabel() const{ return m_findingProviderFieldsSeverityLabel; }

    /**
     * <p>The finding provider value for the severity label.</p>
     */
    inline bool FindingProviderFieldsSeverityLabelHasBeenSet() const { return m_findingProviderFieldsSeverityLabelHasBeenSet; }

    /**
     * <p>The finding provider value for the severity label.</p>
     */
    inline void SetFindingProviderFieldsSeverityLabel(const Aws::Vector<StringFilter>& value) { m_findingProviderFieldsSeverityLabelHasBeenSet = true; m_findingProviderFieldsSeverityLabel = value; }

    /**
     * <p>The finding provider value for the severity label.</p>
     */
    inline void SetFindingProviderFieldsSeverityLabel(Aws::Vector<StringFilter>&& value) { m_findingProviderFieldsSeverityLabelHasBeenSet = true; m_findingProviderFieldsSeverityLabel = std::move(value); }

    /**
     * <p>The finding provider value for the severity label.</p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsSeverityLabel(const Aws::Vector<StringFilter>& value) { SetFindingProviderFieldsSeverityLabel(value); return *this;}

    /**
     * <p>The finding provider value for the severity label.</p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsSeverityLabel(Aws::Vector<StringFilter>&& value) { SetFindingProviderFieldsSeverityLabel(std::move(value)); return *this;}

    /**
     * <p>The finding provider value for the severity label.</p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsSeverityLabel(const StringFilter& value) { m_findingProviderFieldsSeverityLabelHasBeenSet = true; m_findingProviderFieldsSeverityLabel.push_back(value); return *this; }

    /**
     * <p>The finding provider value for the severity label.</p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsSeverityLabel(StringFilter&& value) { m_findingProviderFieldsSeverityLabelHasBeenSet = true; m_findingProviderFieldsSeverityLabel.push_back(std::move(value)); return *this; }


    /**
     * <p>The finding provider's original value for the severity.</p>
     */
    inline const Aws::Vector<StringFilter>& GetFindingProviderFieldsSeverityOriginal() const{ return m_findingProviderFieldsSeverityOriginal; }

    /**
     * <p>The finding provider's original value for the severity.</p>
     */
    inline bool FindingProviderFieldsSeverityOriginalHasBeenSet() const { return m_findingProviderFieldsSeverityOriginalHasBeenSet; }

    /**
     * <p>The finding provider's original value for the severity.</p>
     */
    inline void SetFindingProviderFieldsSeverityOriginal(const Aws::Vector<StringFilter>& value) { m_findingProviderFieldsSeverityOriginalHasBeenSet = true; m_findingProviderFieldsSeverityOriginal = value; }

    /**
     * <p>The finding provider's original value for the severity.</p>
     */
    inline void SetFindingProviderFieldsSeverityOriginal(Aws::Vector<StringFilter>&& value) { m_findingProviderFieldsSeverityOriginalHasBeenSet = true; m_findingProviderFieldsSeverityOriginal = std::move(value); }

    /**
     * <p>The finding provider's original value for the severity.</p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsSeverityOriginal(const Aws::Vector<StringFilter>& value) { SetFindingProviderFieldsSeverityOriginal(value); return *this;}

    /**
     * <p>The finding provider's original value for the severity.</p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsSeverityOriginal(Aws::Vector<StringFilter>&& value) { SetFindingProviderFieldsSeverityOriginal(std::move(value)); return *this;}

    /**
     * <p>The finding provider's original value for the severity.</p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsSeverityOriginal(const StringFilter& value) { m_findingProviderFieldsSeverityOriginalHasBeenSet = true; m_findingProviderFieldsSeverityOriginal.push_back(value); return *this; }

    /**
     * <p>The finding provider's original value for the severity.</p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsSeverityOriginal(StringFilter&& value) { m_findingProviderFieldsSeverityOriginalHasBeenSet = true; m_findingProviderFieldsSeverityOriginal.push_back(std::move(value)); return *this; }


    /**
     * <p>One or more finding types that the finding provider assigned to the finding.
     * Uses the format of <code>namespace/category/classifier</code> that classify a
     * finding.</p> <p>Valid namespace values are: Software and Configuration Checks |
     * TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications</p>
     */
    inline const Aws::Vector<StringFilter>& GetFindingProviderFieldsTypes() const{ return m_findingProviderFieldsTypes; }

    /**
     * <p>One or more finding types that the finding provider assigned to the finding.
     * Uses the format of <code>namespace/category/classifier</code> that classify a
     * finding.</p> <p>Valid namespace values are: Software and Configuration Checks |
     * TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications</p>
     */
    inline bool FindingProviderFieldsTypesHasBeenSet() const { return m_findingProviderFieldsTypesHasBeenSet; }

    /**
     * <p>One or more finding types that the finding provider assigned to the finding.
     * Uses the format of <code>namespace/category/classifier</code> that classify a
     * finding.</p> <p>Valid namespace values are: Software and Configuration Checks |
     * TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications</p>
     */
    inline void SetFindingProviderFieldsTypes(const Aws::Vector<StringFilter>& value) { m_findingProviderFieldsTypesHasBeenSet = true; m_findingProviderFieldsTypes = value; }

    /**
     * <p>One or more finding types that the finding provider assigned to the finding.
     * Uses the format of <code>namespace/category/classifier</code> that classify a
     * finding.</p> <p>Valid namespace values are: Software and Configuration Checks |
     * TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications</p>
     */
    inline void SetFindingProviderFieldsTypes(Aws::Vector<StringFilter>&& value) { m_findingProviderFieldsTypesHasBeenSet = true; m_findingProviderFieldsTypes = std::move(value); }

    /**
     * <p>One or more finding types that the finding provider assigned to the finding.
     * Uses the format of <code>namespace/category/classifier</code> that classify a
     * finding.</p> <p>Valid namespace values are: Software and Configuration Checks |
     * TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications</p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsTypes(const Aws::Vector<StringFilter>& value) { SetFindingProviderFieldsTypes(value); return *this;}

    /**
     * <p>One or more finding types that the finding provider assigned to the finding.
     * Uses the format of <code>namespace/category/classifier</code> that classify a
     * finding.</p> <p>Valid namespace values are: Software and Configuration Checks |
     * TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications</p>
     */
    inline AwsSecurityFindingFilters& WithFindingProviderFieldsTypes(Aws::Vector<StringFilter>&& value) { SetFindingProviderFieldsTypes(std::move(value)); return *this;}

    /**
     * <p>One or more finding types that the finding provider assigned to the finding.
     * Uses the format of <code>namespace/category/classifier</code> that classify a
     * finding.</p> <p>Valid namespace values are: Software and Configuration Checks |
     * TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications</p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsTypes(const StringFilter& value) { m_findingProviderFieldsTypesHasBeenSet = true; m_findingProviderFieldsTypes.push_back(value); return *this; }

    /**
     * <p>One or more finding types that the finding provider assigned to the finding.
     * Uses the format of <code>namespace/category/classifier</code> that classify a
     * finding.</p> <p>Valid namespace values are: Software and Configuration Checks |
     * TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications</p>
     */
    inline AwsSecurityFindingFilters& AddFindingProviderFieldsTypes(StringFilter&& value) { m_findingProviderFieldsTypesHasBeenSet = true; m_findingProviderFieldsTypes.push_back(std::move(value)); return *this; }

  private:

    Aws::Vector<StringFilter> m_productArn;
    bool m_productArnHasBeenSet;

    Aws::Vector<StringFilter> m_awsAccountId;
    bool m_awsAccountIdHasBeenSet;

    Aws::Vector<StringFilter> m_id;
    bool m_idHasBeenSet;

    Aws::Vector<StringFilter> m_generatorId;
    bool m_generatorIdHasBeenSet;

    Aws::Vector<StringFilter> m_type;
    bool m_typeHasBeenSet;

    Aws::Vector<DateFilter> m_firstObservedAt;
    bool m_firstObservedAtHasBeenSet;

    Aws::Vector<DateFilter> m_lastObservedAt;
    bool m_lastObservedAtHasBeenSet;

    Aws::Vector<DateFilter> m_createdAt;
    bool m_createdAtHasBeenSet;

    Aws::Vector<DateFilter> m_updatedAt;
    bool m_updatedAtHasBeenSet;

    Aws::Vector<StringFilter> m_severityLabel;
    bool m_severityLabelHasBeenSet;

    Aws::Vector<NumberFilter> m_confidence;
    bool m_confidenceHasBeenSet;

    Aws::Vector<NumberFilter> m_criticality;
    bool m_criticalityHasBeenSet;

    Aws::Vector<StringFilter> m_title;
    bool m_titleHasBeenSet;

    Aws::Vector<StringFilter> m_description;
    bool m_descriptionHasBeenSet;

    Aws::Vector<StringFilter> m_recommendationText;
    bool m_recommendationTextHasBeenSet;

    Aws::Vector<StringFilter> m_sourceUrl;
    bool m_sourceUrlHasBeenSet;

    Aws::Vector<MapFilter> m_productFields;
    bool m_productFieldsHasBeenSet;

    Aws::Vector<StringFilter> m_productName;
    bool m_productNameHasBeenSet;

    Aws::Vector<StringFilter> m_companyName;
    bool m_companyNameHasBeenSet;

    Aws::Vector<MapFilter> m_userDefinedFields;
    bool m_userDefinedFieldsHasBeenSet;

    Aws::Vector<StringFilter> m_malwareName;
    bool m_malwareNameHasBeenSet;

    Aws::Vector<StringFilter> m_malwareType;
    bool m_malwareTypeHasBeenSet;

    Aws::Vector<StringFilter> m_malwarePath;
    bool m_malwarePathHasBeenSet;

    Aws::Vector<StringFilter> m_malwareState;
    bool m_malwareStateHasBeenSet;

    Aws::Vector<StringFilter> m_networkDirection;
    bool m_networkDirectionHasBeenSet;

    Aws::Vector<StringFilter> m_networkProtocol;
    bool m_networkProtocolHasBeenSet;

    Aws::Vector<IpFilter> m_networkSourceIpV4;
    bool m_networkSourceIpV4HasBeenSet;

    Aws::Vector<IpFilter> m_networkSourceIpV6;
    bool m_networkSourceIpV6HasBeenSet;

    Aws::Vector<NumberFilter> m_networkSourcePort;
    bool m_networkSourcePortHasBeenSet;

    Aws::Vector<StringFilter> m_networkSourceDomain;
    bool m_networkSourceDomainHasBeenSet;

    Aws::Vector<StringFilter> m_networkSourceMac;
    bool m_networkSourceMacHasBeenSet;

    Aws::Vector<IpFilter> m_networkDestinationIpV4;
    bool m_networkDestinationIpV4HasBeenSet;

    Aws::Vector<IpFilter> m_networkDestinationIpV6;
    bool m_networkDestinationIpV6HasBeenSet;

    Aws::Vector<NumberFilter> m_networkDestinationPort;
    bool m_networkDestinationPortHasBeenSet;

    Aws::Vector<StringFilter> m_networkDestinationDomain;
    bool m_networkDestinationDomainHasBeenSet;

    Aws::Vector<StringFilter> m_processName;
    bool m_processNameHasBeenSet;

    Aws::Vector<StringFilter> m_processPath;
    bool m_processPathHasBeenSet;

    Aws::Vector<NumberFilter> m_processPid;
    bool m_processPidHasBeenSet;

    Aws::Vector<NumberFilter> m_processParentPid;
    bool m_processParentPidHasBeenSet;

    Aws::Vector<DateFilter> m_processLaunchedAt;
    bool m_processLaunchedAtHasBeenSet;

    Aws::Vector<DateFilter> m_processTerminatedAt;
    bool m_processTerminatedAtHasBeenSet;

    Aws::Vector<StringFilter> m_threatIntelIndicatorType;
    bool m_threatIntelIndicatorTypeHasBeenSet;

    Aws::Vector<StringFilter> m_threatIntelIndicatorValue;
    bool m_threatIntelIndicatorValueHasBeenSet;

    Aws::Vector<StringFilter> m_threatIntelIndicatorCategory;
    bool m_threatIntelIndicatorCategoryHasBeenSet;

    Aws::Vector<DateFilter> m_threatIntelIndicatorLastObservedAt;
    bool m_threatIntelIndicatorLastObservedAtHasBeenSet;

    Aws::Vector<StringFilter> m_threatIntelIndicatorSource;
    bool m_threatIntelIndicatorSourceHasBeenSet;

    Aws::Vector<StringFilter> m_threatIntelIndicatorSourceUrl;
    bool m_threatIntelIndicatorSourceUrlHasBeenSet;

    Aws::Vector<StringFilter> m_resourceType;
    bool m_resourceTypeHasBeenSet;

    Aws::Vector<StringFilter> m_resourceId;
    bool m_resourceIdHasBeenSet;

    Aws::Vector<StringFilter> m_resourcePartition;
    bool m_resourcePartitionHasBeenSet;

    Aws::Vector<StringFilter> m_resourceRegion;
    bool m_resourceRegionHasBeenSet;

    Aws::Vector<MapFilter> m_resourceTags;
    bool m_resourceTagsHasBeenSet;

    Aws::Vector<StringFilter> m_resourceAwsEc2InstanceType;
    bool m_resourceAwsEc2InstanceTypeHasBeenSet;

    Aws::Vector<StringFilter> m_resourceAwsEc2InstanceImageId;
    bool m_resourceAwsEc2InstanceImageIdHasBeenSet;

    Aws::Vector<IpFilter> m_resourceAwsEc2InstanceIpV4Addresses;
    bool m_resourceAwsEc2InstanceIpV4AddressesHasBeenSet;

    Aws::Vector<IpFilter> m_resourceAwsEc2InstanceIpV6Addresses;
    bool m_resourceAwsEc2InstanceIpV6AddressesHasBeenSet;

    Aws::Vector<StringFilter> m_resourceAwsEc2InstanceKeyName;
    bool m_resourceAwsEc2InstanceKeyNameHasBeenSet;

    Aws::Vector<StringFilter> m_resourceAwsEc2InstanceIamInstanceProfileArn;
    bool m_resourceAwsEc2InstanceIamInstanceProfileArnHasBeenSet;

    Aws::Vector<StringFilter> m_resourceAwsEc2InstanceVpcId;
    bool m_resourceAwsEc2InstanceVpcIdHasBeenSet;

    Aws::Vector<StringFilter> m_resourceAwsEc2InstanceSubnetId;
    bool m_resourceAwsEc2InstanceSubnetIdHasBeenSet;

    Aws::Vector<DateFilter> m_resourceAwsEc2InstanceLaunchedAt;
    bool m_resourceAwsEc2InstanceLaunchedAtHasBeenSet;

    Aws::Vector<StringFilter> m_resourceAwsS3BucketOwnerId;
    bool m_resourceAwsS3BucketOwnerIdHasBeenSet;

    Aws::Vector<StringFilter> m_resourceAwsS3BucketOwnerName;
    bool m_resourceAwsS3BucketOwnerNameHasBeenSet;

    Aws::Vector<StringFilter> m_resourceAwsIamAccessKeyUserName;
    bool m_resourceAwsIamAccessKeyUserNameHasBeenSet;

    Aws::Vector<StringFilter> m_resourceAwsIamAccessKeyStatus;
    bool m_resourceAwsIamAccessKeyStatusHasBeenSet;

    Aws::Vector<DateFilter> m_resourceAwsIamAccessKeyCreatedAt;
    bool m_resourceAwsIamAccessKeyCreatedAtHasBeenSet;

    Aws::Vector<StringFilter> m_resourceContainerName;
    bool m_resourceContainerNameHasBeenSet;

    Aws::Vector<StringFilter> m_resourceContainerImageId;
    bool m_resourceContainerImageIdHasBeenSet;

    Aws::Vector<StringFilter> m_resourceContainerImageName;
    bool m_resourceContainerImageNameHasBeenSet;

    Aws::Vector<DateFilter> m_resourceContainerLaunchedAt;
    bool m_resourceContainerLaunchedAtHasBeenSet;

    Aws::Vector<MapFilter> m_resourceDetailsOther;
    bool m_resourceDetailsOtherHasBeenSet;

    Aws::Vector<StringFilter> m_complianceStatus;
    bool m_complianceStatusHasBeenSet;

    Aws::Vector<StringFilter> m_verificationState;
    bool m_verificationStateHasBeenSet;

    Aws::Vector<StringFilter> m_workflowState;
    bool m_workflowStateHasBeenSet;

    Aws::Vector<StringFilter> m_workflowStatus;
    bool m_workflowStatusHasBeenSet;

    Aws::Vector<StringFilter> m_recordState;
    bool m_recordStateHasBeenSet;

    Aws::Vector<StringFilter> m_relatedFindingsProductArn;
    bool m_relatedFindingsProductArnHasBeenSet;

    Aws::Vector<StringFilter> m_relatedFindingsId;
    bool m_relatedFindingsIdHasBeenSet;

    Aws::Vector<StringFilter> m_noteText;
    bool m_noteTextHasBeenSet;

    Aws::Vector<DateFilter> m_noteUpdatedAt;
    bool m_noteUpdatedAtHasBeenSet;

    Aws::Vector<StringFilter> m_noteUpdatedBy;
    bool m_noteUpdatedByHasBeenSet;

    Aws::Vector<KeywordFilter> m_keyword;
    bool m_keywordHasBeenSet;

    Aws::Vector<NumberFilter> m_findingProviderFieldsConfidence;
    bool m_findingProviderFieldsConfidenceHasBeenSet;

    Aws::Vector<NumberFilter> m_findingProviderFieldsCriticality;
    bool m_findingProviderFieldsCriticalityHasBeenSet;

    Aws::Vector<StringFilter> m_findingProviderFieldsRelatedFindingsId;
    bool m_findingProviderFieldsRelatedFindingsIdHasBeenSet;

    Aws::Vector<StringFilter> m_findingProviderFieldsRelatedFindingsProductArn;
    bool m_findingProviderFieldsRelatedFindingsProductArnHasBeenSet;

    Aws::Vector<StringFilter> m_findingProviderFieldsSeverityLabel;
    bool m_findingProviderFieldsSeverityLabelHasBeenSet;

    Aws::Vector<StringFilter> m_findingProviderFieldsSeverityOriginal;
    bool m_findingProviderFieldsSeverityOriginalHasBeenSet;

    Aws::Vector<StringFilter> m_findingProviderFieldsTypes;
    bool m_findingProviderFieldsTypesHasBeenSet;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
