﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sso-admin/SSOAdmin_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sso-admin/model/PrincipalType.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SSOAdmin
{
namespace Model
{

  /**
   * <p>The assignment that indicates a principal's limited access to a specified AWS
   * account with a specified permission set.</p>  <p>The term <i>principal</i>
   * here refers to a user or group that is defined in AWS SSO.</p> <p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AccountAssignment">AWS
   * API Reference</a></p>
   */
  class AWS_SSOADMIN_API AccountAssignment
  {
  public:
    AccountAssignment();
    AccountAssignment(Aws::Utils::Json::JsonView jsonValue);
    AccountAssignment& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The identifier of the AWS account.</p>
     */
    inline const Aws::String& GetAccountId() const{ return m_accountId; }

    /**
     * <p>The identifier of the AWS account.</p>
     */
    inline bool AccountIdHasBeenSet() const { return m_accountIdHasBeenSet; }

    /**
     * <p>The identifier of the AWS account.</p>
     */
    inline void SetAccountId(const Aws::String& value) { m_accountIdHasBeenSet = true; m_accountId = value; }

    /**
     * <p>The identifier of the AWS account.</p>
     */
    inline void SetAccountId(Aws::String&& value) { m_accountIdHasBeenSet = true; m_accountId = std::move(value); }

    /**
     * <p>The identifier of the AWS account.</p>
     */
    inline void SetAccountId(const char* value) { m_accountIdHasBeenSet = true; m_accountId.assign(value); }

    /**
     * <p>The identifier of the AWS account.</p>
     */
    inline AccountAssignment& WithAccountId(const Aws::String& value) { SetAccountId(value); return *this;}

    /**
     * <p>The identifier of the AWS account.</p>
     */
    inline AccountAssignment& WithAccountId(Aws::String&& value) { SetAccountId(std::move(value)); return *this;}

    /**
     * <p>The identifier of the AWS account.</p>
     */
    inline AccountAssignment& WithAccountId(const char* value) { SetAccountId(value); return *this;}


    /**
     * <p>The ARN of the permission set. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline const Aws::String& GetPermissionSetArn() const{ return m_permissionSetArn; }

    /**
     * <p>The ARN of the permission set. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline bool PermissionSetArnHasBeenSet() const { return m_permissionSetArnHasBeenSet; }

    /**
     * <p>The ARN of the permission set. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline void SetPermissionSetArn(const Aws::String& value) { m_permissionSetArnHasBeenSet = true; m_permissionSetArn = value; }

    /**
     * <p>The ARN of the permission set. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline void SetPermissionSetArn(Aws::String&& value) { m_permissionSetArnHasBeenSet = true; m_permissionSetArn = std::move(value); }

    /**
     * <p>The ARN of the permission set. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline void SetPermissionSetArn(const char* value) { m_permissionSetArnHasBeenSet = true; m_permissionSetArn.assign(value); }

    /**
     * <p>The ARN of the permission set. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline AccountAssignment& WithPermissionSetArn(const Aws::String& value) { SetPermissionSetArn(value); return *this;}

    /**
     * <p>The ARN of the permission set. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline AccountAssignment& WithPermissionSetArn(Aws::String&& value) { SetPermissionSetArn(std::move(value)); return *this;}

    /**
     * <p>The ARN of the permission set. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline AccountAssignment& WithPermissionSetArn(const char* value) { SetPermissionSetArn(value); return *this;}


    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline const PrincipalType& GetPrincipalType() const{ return m_principalType; }

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline bool PrincipalTypeHasBeenSet() const { return m_principalTypeHasBeenSet; }

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline void SetPrincipalType(const PrincipalType& value) { m_principalTypeHasBeenSet = true; m_principalType = value; }

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline void SetPrincipalType(PrincipalType&& value) { m_principalTypeHasBeenSet = true; m_principalType = std::move(value); }

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline AccountAssignment& WithPrincipalType(const PrincipalType& value) { SetPrincipalType(value); return *this;}

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline AccountAssignment& WithPrincipalType(PrincipalType&& value) { SetPrincipalType(std::move(value)); return *this;}


    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline const Aws::String& GetPrincipalId() const{ return m_principalId; }

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline bool PrincipalIdHasBeenSet() const { return m_principalIdHasBeenSet; }

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline void SetPrincipalId(const Aws::String& value) { m_principalIdHasBeenSet = true; m_principalId = value; }

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline void SetPrincipalId(Aws::String&& value) { m_principalIdHasBeenSet = true; m_principalId = std::move(value); }

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline void SetPrincipalId(const char* value) { m_principalIdHasBeenSet = true; m_principalId.assign(value); }

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline AccountAssignment& WithPrincipalId(const Aws::String& value) { SetPrincipalId(value); return *this;}

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline AccountAssignment& WithPrincipalId(Aws::String&& value) { SetPrincipalId(std::move(value)); return *this;}

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline AccountAssignment& WithPrincipalId(const char* value) { SetPrincipalId(value); return *this;}

  private:

    Aws::String m_accountId;
    bool m_accountIdHasBeenSet;

    Aws::String m_permissionSetArn;
    bool m_permissionSetArnHasBeenSet;

    PrincipalType m_principalType;
    bool m_principalTypeHasBeenSet;

    Aws::String m_principalId;
    bool m_principalIdHasBeenSet;
  };

} // namespace Model
} // namespace SSOAdmin
} // namespace Aws
