/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.persistence;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.desktop.datalab.AvailableColumnsModel;
import org.gephi.desktop.datalab.DataTablesModel;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.project.api.Workspace;
import org.gephi.project.spi.WorkspaceXMLPersistenceProvider;

public class DataLaboratoryPersistenceProvider
implements WorkspaceXMLPersistenceProvider {
    private static final String AVAILABLE_COLUMNS = "availablecolumns";
    private static final String NODE_COLUMN = "nodecolumn";
    private static final String EDGE_COLUMN = "edgecolumn";

    public void writeXML(XMLStreamWriter writer, Workspace workspace) {
        DataTablesModel dataTablesModel = (DataTablesModel)workspace.getLookup().lookup(DataTablesModel.class);
        if (dataTablesModel == null) {
            dataTablesModel = new DataTablesModel(workspace);
            workspace.add((Object)dataTablesModel);
        }
        try {
            this.writeDataTablesModel(writer, dataTablesModel);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void readXML(XMLStreamReader reader, Workspace workspace) {
        try {
            this.readDataTablesModel(reader, workspace);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getIdentifier() {
        return AVAILABLE_COLUMNS;
    }

    private void writeDataTablesModel(XMLStreamWriter writer, DataTablesModel dataTablesModel) throws XMLStreamException {
        for (Column column : dataTablesModel.getNodeAvailableColumnsModel().getAvailableColumns()) {
            writer.writeStartElement(NODE_COLUMN);
            writer.writeAttribute("id", String.valueOf(column.getIndex()));
            writer.writeEndElement();
        }
        for (Column column : dataTablesModel.getEdgeAvailableColumnsModel().getAvailableColumns()) {
            writer.writeStartElement(EDGE_COLUMN);
            writer.writeAttribute("id", String.valueOf(column.getIndex()));
            writer.writeEndElement();
        }
    }

    private void readDataTablesModel(XMLStreamReader reader, Workspace workspace) throws XMLStreamException {
        GraphModel graphModel = (GraphModel)workspace.getLookup().lookup(GraphModel.class);
        Table nodesTable = graphModel.getNodeTable();
        Table edgesTable = graphModel.getEdgeTable();
        DataTablesModel dataTablesModel = (DataTablesModel)workspace.getLookup().lookup(DataTablesModel.class);
        if (dataTablesModel == null) {
            dataTablesModel = new DataTablesModel(workspace);
            workspace.add((Object)dataTablesModel);
        }
        AvailableColumnsModel nodeColumns = dataTablesModel.getNodeAvailableColumnsModel();
        nodeColumns.removeAllColumns();
        AvailableColumnsModel edgeColumns = dataTablesModel.getEdgeAvailableColumnsModel();
        edgeColumns.removeAllColumns();
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                Column column;
                Integer id;
                String name = reader.getLocalName();
                if (NODE_COLUMN.equalsIgnoreCase(name)) {
                    id = Integer.parseInt(reader.getAttributeValue(null, "id"));
                    column = nodesTable.getColumn(id.intValue());
                    if (column == null) continue;
                    nodeColumns.addAvailableColumn(column);
                    continue;
                }
                if (!EDGE_COLUMN.equalsIgnoreCase(name) || (column = edgesTable.getColumn((id = Integer.valueOf(Integer.parseInt(reader.getAttributeValue(null, "id")))).intValue())) == null) continue;
                edgeColumns.addAvailableColumn(column);
                continue;
            }
            if (!eventType.equals(2) || !AVAILABLE_COLUMNS.equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }
}

