/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.builders;

import java.util.ArrayList;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.TextProperties;
import org.gephi.preview.api.Item;
import org.gephi.preview.plugin.items.EdgeLabelItem;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.visualization.api.VisualizationController;
import org.openide.util.Lookup;

public class EdgeLabelBuilder
implements ItemBuilder {
    public Item[] getItems(Graph graph) {
        VisualizationController vizController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        Column[] edgeColumns = vizController != null ? vizController.getEdgeTextColumns() : null;
        ArrayList<EdgeLabelItem> items = new ArrayList<EdgeLabelItem>();
        for (Edge e : graph.getEdges()) {
            EdgeLabelItem labelItem = new EdgeLabelItem(e);
            String label = this.getLabel(e, edgeColumns, graph.getView());
            labelItem.setData("label", label);
            TextProperties textData = e.getTextProperties();
            if (textData != null) {
                if (textData.getAlpha() != 0.0f) {
                    labelItem.setData("color", textData.getColor());
                }
                labelItem.setData("size", Float.valueOf(textData.getSize()));
                labelItem.setData("visible", textData.isVisible());
                if (!textData.isVisible()) continue;
                items.add(labelItem);
                continue;
            }
            if (label == null || label.isEmpty()) continue;
            items.add(labelItem);
        }
        return items.toArray(new Item[0]);
    }

    private String getLabel(Edge e, Column[] cols, GraphView view) {
        String str = "";
        if (cols != null) {
            int i = 0;
            for (Column c : cols) {
                if (i++ > 0) {
                    str = str + " - ";
                }
                Object val = e.getAttribute(c, view);
                str = str + (val != null ? val : "");
            }
        }
        if (str.isEmpty()) {
            str = e.getLabel();
        }
        if (str == null) {
            str = "";
        }
        return str;
    }

    public String getType() {
        return "edge_label";
    }
}

