/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.im.InputContext;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBoxModel;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public class AutoCompComboBox<E>
extends JosmComboBox<E>
implements KeyListener {
    private static final Pattern IS_NUMBER = Pattern.compile("^\\d+$");
    private boolean autocompleteEnabled = true;
    private int maxTextLength = -1;
    private boolean useFixedLocale;
    private final boolean AUTOCOMPLETE_NUMBERS = !Config.getPref().getBoolean("autocomplete.dont_complete_numbers", true);
    private final transient InputContext privateInputContext = InputContext.getInstance();

    public AutoCompComboBox() {
        this(new AutoCompComboBoxModel());
    }

    public AutoCompComboBox(AutoCompComboBoxModel<E> model) {
        super(model);
        Objects.requireNonNull(model, "A model cannot be null.");
        this.setEditable(true);
        JTextField editorComponent = this.getEditorComponent();
        editorComponent.addFocusListener(new InnerFocusListener(editorComponent));
        editorComponent.addKeyListener(this);
        ((AbstractDocument)editorComponent.getDocument()).setDocumentFilter(new MaxLengthDocumentFilter());
    }

    @Override
    public AutoCompComboBoxModel<E> getModel() {
        return (AutoCompComboBoxModel)this.dataModel;
    }

    private void autocomplete() {
        JTextField editor = this.getEditorComponent();
        String prefix = editor.getText();
        if (!this.AUTOCOMPLETE_NUMBERS && IS_NUMBER.matcher(prefix).matches()) {
            return;
        }
        Object item = ((AutoCompComboBoxModel)this.getModel()).findBestCandidate(prefix);
        if (item != null) {
            String text = item.toString();
            this.setSelectedItem(item);
            editor.setText(text);
            editor.select(prefix.length(), text.length());
            this.copyToSysSel(text);
        } else {
            this.setSelectedItem(null);
            editor.setText(prefix);
        }
    }

    void copyToSysSel(String s) {
        Clipboard sysSel = ClipboardUtils.getSystemSelection();
        if (sysSel != null) {
            StringSelection transferable = new StringSelection(s);
            sysSel.setContents(transferable, null);
        }
    }

    public void setMaxTextLength(int length) {
        this.maxTextLength = length;
    }

    @Deprecated
    public void setPossibleItems(Collection<E> elems) {
        LinkedList<E> reversed = new LinkedList<E>(elems);
        Collections.reverse(reversed);
        this.setPossibleAcItems(reversed);
    }

    @Deprecated
    public void setPossibleItemsTopDown(Collection<E> elems) {
        this.setPossibleAcItems(elems);
    }

    @Deprecated
    public void setPossibleAcItems(Collection<E> elems) {
        Object oldValue = this.getEditor().getItem();
        ((AutoCompComboBoxModel)this.getModel()).removeAllElements();
        ((AutoCompComboBoxModel)this.getModel()).addAllElements(elems);
        this.getEditor().setItem(oldValue);
    }

    public final boolean isAutocompleteEnabled() {
        return this.autocompleteEnabled;
    }

    public boolean setAutocompleteEnabled(boolean enabled) {
        boolean oldEnabled = this.autocompleteEnabled;
        this.autocompleteEnabled = enabled;
        return oldEnabled;
    }

    public void setFixedLocale(boolean f) {
        this.useFixedLocale = f;
        if (this.useFixedLocale) {
            Locale oldLocale = this.privateInputContext.getLocale();
            Logging.info("Using English input method");
            if (!this.privateInputContext.selectInputMethod(new Locale("en", "US"))) {
                Logging.warn("Unable to use English input method");
                this.useFixedLocale = false;
                if (oldLocale != null) {
                    Logging.info("Restoring input method to " + oldLocale);
                    if (!this.privateInputContext.selectInputMethod(oldLocale)) {
                        Logging.warn("Unable to restore input method to " + oldLocale);
                    }
                }
            }
        }
    }

    @Override
    public InputContext getInputContext() {
        if (this.useFixedLocale) {
            return this.privateInputContext;
        }
        return super.getInputContext();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.autocompleteEnabled && this.getEditorComponent().getSelectionEnd() == this.getEditorComponent().getText().length() && !Character.isISOControl(e.getKeyChar())) {
            SwingUtilities.invokeLater(() -> this.autocomplete());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private class MaxLengthDocumentFilter
    extends DocumentFilter {
        private MaxLengthDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (this.mustInsertOrReplace(fb, 0, string, attr)) {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
            if (this.mustInsertOrReplace(fb, length, string, attr)) {
                super.replace(fb, offset, length, string, attr);
            }
        }

        private boolean mustInsertOrReplace(DocumentFilter.FilterBypass fb, int length, String string, AttributeSet attr) {
            int newLen = fb.getDocument().getLength() - length + (string == null ? 0 : string.length());
            return AutoCompComboBox.this.maxTextLength == -1 || newLen <= AutoCompComboBox.this.maxTextLength || attr != null && attr.isDefined(StyleConstants.ComposedTextAttribute);
        }
    }

    static final class InnerFocusListener
    implements FocusListener {
        private final JTextComponent editorComponent;

        InnerFocusListener(JTextComponent editorComponent) {
            this.editorComponent = editorComponent;
        }

        @Override
        public void focusLost(FocusEvent e) {
            MapFrame map = MainApplication.getMap();
            if (map != null) {
                map.keyDetector.setEnabled(true);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            Clipboard sysSel;
            MapFrame map = MainApplication.getMap();
            if (map != null) {
                map.keyDetector.setEnabled(false);
            }
            if ((sysSel = ClipboardUtils.getSystemSelection()) != null) {
                Transferable old = ClipboardUtils.getClipboardContent(sysSel);
                this.editorComponent.selectAll();
                if (old != null) {
                    sysSel.setContents(old, null);
                }
            } else if (e != null && e.getOppositeComponent() != null) {
                this.editorComponent.selectAll();
            }
        }
    }
}

