require("source-map-support").install();
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */,
/* 2 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.errorParamsToUnsupportedVersionRange = errorParamsToUnsupportedVersionRange;
exports.normalizePath = normalizePath;
exports.getRootExpression = getRootExpression;
exports.getNodeReference = getNodeReference;
exports.getVariable = getVariable;
exports.getLocale = getLocale;
exports.getI18Data = getI18Data;
exports.buildI18nObject = buildI18nObject;
exports.checkMinNodeVersion = checkMinNodeVersion;
exports.getPackageTypeAsString = getPackageTypeAsString;
exports.ignorePrivateFunctions = ignorePrivateFunctions;
exports.ensureFilenameExists = ensureFilenameExists;
exports.isLocalUrl = isLocalUrl;
exports.apiToMessage = apiToMessage;
exports.isBrowserNamespace = isBrowserNamespace;
exports.parseCspPolicy = parseCspPolicy;
exports.getLineAndColumnFromMatch = getLineAndColumnFromMatch;
exports.couldBeMinifiedCode = couldBeMinifiedCode;
exports.firefoxStrictMinVersion = firefoxStrictMinVersion;
exports.basicCompatVersionComparison = basicCompatVersionComparison;
exports.firstStableVersion = firstStableVersion;
exports.isCompatible = isCompatible;
exports.createCompatibilityRule = createCompatibilityRule;
exports.i18n = exports.AddonsLinterUserError = void 0;

var _url = _interopRequireDefault(__webpack_require__(3));

var _upath = _interopRequireDefault(__webpack_require__(4));

var _jed2 = _interopRequireDefault(__webpack_require__(5));

var _semver = _interopRequireDefault(__webpack_require__(6));

var _commonTags = __webpack_require__(7);

var _osLocale = _interopRequireDefault(__webpack_require__(8));

var _logger = _interopRequireDefault(__webpack_require__(9));

var _const = __webpack_require__(11);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* global nodeRequire, localesRoot */
const SOURCE_MAP_RE = new RegExp(/\/\/[#@]\s(source(?:Mapping)?URL)=\s*(\S+)/); // Represents an error condition related to a user error (e.g. an invalid
// configuration option passed to the linter class, usually through the
// command line arguments).
//
// In bin/addons-linter instances of this error are recognized through the
// error name property and by default they will be logged on stderr as
// plain error messages and the error stack trace omitted (unless explicitly
// requested by passing --stack as an additional CLI options, useful for
// debugging reasons).

class AddonsLinterUserError extends Error {
  get name() {
    return 'AddonsLinterUserError';
  }

}

exports.AddonsLinterUserError = AddonsLinterUserError;

function errorParamsToUnsupportedVersionRange(errorParams) {
  const {
    min_manifest_version,
    max_manifest_version
  } = errorParams || {};

  if (min_manifest_version != null || max_manifest_version != null) {
    return [min_manifest_version ? `< ${min_manifest_version}` : undefined, max_manifest_version ? `> ${max_manifest_version}` : undefined].filter(e => e !== undefined).join(', ');
  }

  return '';
}

function normalizePath(iconPath) {
  // Convert the icon path to a URL so we can strip any fragments and resolve
  // . and .. automatically. We need an absolute URL to use as a base so we're
  // using https://example.com/.
  const {
    pathname
  } = new URL(iconPath, 'https://example.com/'); // Convert filename to unix path separator (as the ones stored
  // into the scanned files map).

  return _upath.default.toUnix(decodeURIComponent(pathname).slice(1));
}
/*
 * Takes an AST node and returns the root property.
 *
 * example: foo().bar.baz() will return the AST node for foo.
 */


function getRootExpression(node) {
  let root = node.callee; // If we encounter a member, grab the parent

  if (node.callee.type === 'MemberExpression') {
    let parent = node.callee.object;

    while (parent.type !== 'Identifier') {
      if (parent.callee.type === 'MemberExpression') {
        parent = parent.callee.object;
      } else {
        parent = parent.callee;
      }
    }

    root = parent;
  }

  return root;
}
/*
 * Returns the name of the reference node passed.
 *
 * example: var foo = document;
 *  The node for foo will return 'document'
 */


function getNodeReference(context, node) {
  const {
    variables
  } = context.getScope();
  let scopeVar; // Just return the value if the node passed in is a reference to a literal.

  if (typeof node === 'undefined' || node.type === 'Literal') {
    return node;
  } // Finds variable reference in current scope.


  for (let i = 0; i < variables.length; i++) {
    const variable = variables[i];

    if (variable.name === node.name) {
      scopeVar = variable;
      break;
    }
  }

  if (scopeVar && scopeVar.defs && scopeVar.defs[0] && scopeVar.defs[0].parent && scopeVar.defs[0].parent.parent && scopeVar.defs[0].parent.parent.body) {
    // This represents all occurrences of the variable
    const occurances = scopeVar.defs[0].parent.parent.body;
    let lastAssignment;

    if (occurances instanceof Array) {
      occurances.forEach(occurance => {
        if (occurance.type === 'VariableDeclaration' && occurance.declarations[0].init !== null) {
          // Get what the name of what it was assigned to or the raw
          // value depending on the initalization
          lastAssignment = occurance.declarations[0].init;
        } else if (occurance.type === 'ExpressionStatement' && occurance.expression.type === 'AssignmentExpression') {
          // Get the right hand side of the assignment
          lastAssignment = occurance.expression.right;
        }
      });
    } // Return the name of the first definition of the variable which
    // corresponds to the node passed in.


    if (lastAssignment) {
      return lastAssignment;
    }
  } // If that variable doesn't exist in scope, then just return the node's
  // name.


  return node;
}
/*
 * Get a variable from a eslint context object if it exists, otherwise
 * undefined.
 */


function getVariable(context, name) {
  const {
    variables
  } = context.getScope();
  let result;
  variables.forEach(variable => {
    if (variable.name === name && variable.defs && variable.defs[0] && variable.defs[0].name && variable.defs[0].name.parent) {
      result = variable.defs[0].name.parent.init;
    }
  });
  return result;
}

function getLocale() {
  return _osLocale.default.sync();
}

function getI18Data(locale) {
  let i18ndata = {};

  try {
    // eslint-disable-next-line global-require, import/no-dynamic-require
    i18ndata = nodeRequire(`${localesRoot}/${locale}/messages.js`);
  } catch (err) {
    _logger.default.info('Initialize locales using extract-locales command');
  }

  return i18ndata;
}
/*
 * Gettext utils. Used for translating strings.
 */


function buildI18nObject(i18nData) {
  const _jed = new _jed2.default(i18nData);

  return {
    jed: _jed,
    getI18Data,
    _: str => {
      return _jed.gettext(str);
    },
    gettext: str => {
      return _jed.gettext(str);
    },
    sprintf: (fmt, args) => {
      return _jed.sprintf(fmt, args);
    }
  };
}

const i18n = buildI18nObject(getI18Data(getLocale()));
/*
 * Check the minimum node version is met
 */

exports.i18n = i18n;

async function checkMinNodeVersion(minVersion, _process = process) {
  // eslint-disable-next-line no-param-reassign
  minVersion = minVersion || '0.12.0';

  if (!_semver.default.gte(_process.version, minVersion)) {
    throw new Error((0, _commonTags.oneLine)`Node version must be ${minVersion} or
                    greater. You are using ${_process.version}.`);
  }
}

function getPackageTypeAsString(numericPackageType) {
  const packageKeys = Object.keys(_const.PACKAGE_TYPES);

  for (let i = 0; i < packageKeys.length; i++) {
    const packageType = packageKeys[i];

    if (parseInt(numericPackageType, 10) === _const.PACKAGE_TYPES[packageType]) {
      return packageType;
    }
  }

  throw new Error(`Invalid package type constant "${numericPackageType}"`);
}
/*
 * Looks through all exported functions and returns only
 * "public" *functions* that aren't prefixed with an _
 *
 * Used for ignoring private functions and constants in rules files.
 * Rules can have private functions we don't run; anything that
 * starts with an "_" shouldn't be returned.
 *
 * This exists because we export private functions in rule files
 * for testing.
 */


function ignorePrivateFunctions(list) {
  const filteredList = {};
  Object.keys(list).forEach(functionName => {
    if (functionName.startsWith('_') === false && typeof list[functionName] === 'function') {
      filteredList[functionName] = list[functionName];
    }
  });
  return filteredList;
}
/*
 * Check a filename to make sure it's valid; used by scanners so we never
 * accept new scanners that don't specify which file they're referencing.
 */


function ensureFilenameExists(filename) {
  if (typeof filename !== 'string' || filename.length < 1) {
    throw new Error('Filename is required');
  }
}

function isLocalUrl(urlInput) {
  const parsedUrl = _url.default.parse(urlInput);

  const {
    protocol,
    path
  } = parsedUrl; // Check protocol is chrome: or resource: if set.
  // Details on the chrome protocol are here: https://goo.gl/W52T0Q
  // Details on resource protocol are here: https://goo.gl/HHqeJA

  if (protocol && !_const.LOCAL_PROTOCOLS.includes(protocol)) {
    return false;
  } // Disallow protocol-free remote urls.


  if (path.startsWith('//')) {
    return false;
  }

  return true;
}

function apiToMessage(string) {
  return string.replace(/^extension/, 'ext').replace(/\./g, '_').toUpperCase().substr(0, 25);
}

function isBrowserNamespace(string) {
  return ['browser', 'chrome'].includes(string);
}

function parseCspPolicy(policy) {
  if (!policy) {
    return {};
  } // eslint-disable-next-line no-param-reassign


  policy = policy.toLowerCase();
  const parsedPolicy = {};
  const directives = policy.split(';');
  directives.forEach(directive => {
    // eslint-disable-next-line no-param-reassign
    directive = directive.trim();
    const tokens = directive.split(/\s+/);
    const name = tokens[0];

    if (name) {
      parsedPolicy[name] = tokens.slice(1, tokens.length);
    }
  });
  return parsedPolicy;
}

function getLineAndColumnFromMatch(match) {
  const matchedLines = match.input.substr(0, match.index).split('\n');
  const matchedColumn = matchedLines.slice(-1)[0].length + 1;
  const matchedLine = matchedLines.length;
  return {
    matchedLine,
    matchedColumn
  };
}
/**
 * Determines if the source text is minified.
 * Using the percentage no. of the indented lines from a sample set of lines
 * to determine if the js file is minified.
 * Inspired by code for the Firefox Developer Toolbar.
 */


function couldBeMinifiedCode(code) {
  // Fast exit if `code` is empty. Could happen in tests, but also in real
  // files.
  if (!code) {
    return false;
  } // If there's a source map reference it's very certainly minified code.


  if (SOURCE_MAP_RE.test(code)) {
    return true;
  } // Number of lines to look at, taken from the head of the code.


  const sampleSize = 30; // Threshold in percent of indented lines to mark a file as not
  // minified.

  const indentCountThreshold = 20; // percentage
  // Length of a line that looks suspicious of being minified

  const hugeLinesLength = 500; // Number of huge lines to also mark a file as potentially minified
  // Hint: Minified AngularJS has 12 lines, jQuery 4

  const hugeLinesThreshold = 4;
  let lineEndIndex = 0;
  let lineStartIndex = 0;
  let lines = 1;
  let indentCount = 0;
  let hugeLinesCount = 0; // Strip comments.

  const normalizedCode = code.replace(/\/\*[\S\s]*?\*\/|\/\/.+/g, '');

  while (lines < sampleSize) {
    lineEndIndex = normalizedCode.indexOf('\n', lineStartIndex);

    if (lineEndIndex === -1) {
      break;
    }

    const currentLine = normalizedCode.slice(lineStartIndex, lineEndIndex);

    if (/^\s+/.test(currentLine)) {
      indentCount++;
    }

    if (currentLine.length >= hugeLinesLength) {
      hugeLinesCount++;
    }

    lineStartIndex = lineEndIndex + 1;
    lines++;
  }

  return indentCount / lines * 100 < indentCountThreshold || hugeLinesCount > hugeLinesThreshold;
}

function firefoxStrictMinVersion(manifestJson) {
  if (manifestJson.applications && manifestJson.applications.gecko && manifestJson.applications.gecko.strict_min_version) {
    return parseInt(manifestJson.applications.gecko.strict_min_version.split('.')[0], 10);
  }

  return null;
}

function basicCompatVersionComparison(versionAdded, minVersion) {
  const asNumber = parseInt(versionAdded, 10);
  return !Number.isNaN(asNumber) && asNumber > minVersion;
}
/**
 * @param {*} supportInfo - bcd support info of a feature
 * @returns {string|boolean} The first version number to support the feature
 *          or a boolean indicating if the feature is supported at all. We do
 *          not consider any holes in the supported versions, only the first
 *          stable version is taken into account.
 */


function firstStableVersion(supportInfo) {
  let supportInfoArray = supportInfo;

  if (!Array.isArray(supportInfo)) {
    supportInfoArray = [supportInfo];
  }

  return supportInfoArray.reduce((versionAdded, supportEntry) => {
    if (!Object.prototype.hasOwnProperty.call(supportEntry, 'flags') && (!versionAdded || supportEntry.version_added && !basicCompatVersionComparison(supportEntry.version_added, parseInt(versionAdded, 10)))) {
      return supportEntry.version_added;
    }

    return versionAdded;
  }, false);
}

function isCompatible(bcd, path, minVersion, application) {
  const steps = path.split('.');
  let {
    api
  } = bcd.webextensions;

  for (const step of steps) {
    if (Object.prototype.hasOwnProperty.call(api, step)) {
      api = api[step];
    } else {
      break;
    }
  } // API namespace may be undocumented or not implemented, ignore in that case.


  if (api.__compat) {
    const supportInfo = api.__compat.support[application];
    const versionAdded = firstStableVersion(supportInfo);
    return !basicCompatVersionComparison(versionAdded, minVersion);
  }

  return true;
}

function createCompatibilityRule(application, message, context, bcd, hasBrowserApi) {
  const {
    addonMetadata
  } = context.settings;
  const minVersion = addonMetadata && firefoxStrictMinVersion({
    applications: {
      gecko: {
        strict_min_version: context.settings.addonMetadata.firefoxMinVersion
      }
    }
  });

  if (minVersion) {
    return {
      MemberExpression(node) {
        if (!node.computed && node.object.object && isBrowserNamespace(node.object.object.name)) {
          const namespace = node.object.property.name;
          const property = node.property.name;
          const api = `${namespace}.${property}`;

          if (hasBrowserApi(namespace, property, addonMetadata) && !isCompatible(bcd, api, minVersion, application)) {
            context.report(node, message.messageFormat, {
              api,
              minVersion: addonMetadata.firefoxMinVersion
            });
          }
        }
      }

    };
  }

  return {};
}

/***/ }),
/* 3 */
/***/ ((module) => {

module.exports = require("url");

/***/ }),
/* 4 */
/***/ ((module) => {

module.exports = require("upath");

/***/ }),
/* 5 */
/***/ ((module) => {

module.exports = require("jed");

/***/ }),
/* 6 */
/***/ ((module) => {

module.exports = require("semver");

/***/ }),
/* 7 */
/***/ ((module) => {

module.exports = require("common-tags");

/***/ }),
/* 8 */
/***/ ((module) => {

module.exports = require("os-locale");

/***/ }),
/* 9 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createLogger = createLogger;
exports["default"] = void 0;

var _pino = _interopRequireDefault(__webpack_require__(10));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function createLogger(_process = process) {
  const level = _process.env.LOG_LEVEL || 'fatal';
  return (0, _pino.default)({
    name: 'AddonLinterJS',
    level
  }, process.stdout);
}

var _default = createLogger();

exports["default"] = _default;

/***/ }),
/* 10 */
/***/ ((module) => {

module.exports = require("pino");

/***/ }),
/* 11 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.RESTRICTED_HOMEPAGE_URLS = exports.ZIP_LIB_CORRUPT_FILE_ERROR = exports.MESSAGE_PLACEHOLDER_REGEXP = exports.LOCALES_DIRECTORY = exports.MESSAGES_JSON = exports.CSP_KEYWORD_RE = exports.TEMPORARY_APIS = exports.FLAGGED_FILE_MAGIC_NUMBERS = exports.DEPRECATED_JAVASCRIPT_APIS = exports.DEPRECATED_MANIFEST_PROPERTIES = exports.STATIC_THEME_IMAGE_MIMES = exports.FILE_EXTENSIONS_TO_MIME = exports.IMAGE_FILE_EXTENSIONS = exports.FLAGGED_FILE_EXTENSIONS = exports.RESERVED_FILENAMES = exports.PERMS_DATAPATH_REGEX = exports.ALREADY_SIGNED_REGEX = exports.FLAGGED_FILE_REGEX = exports.HIDDEN_FILE_REGEX = exports.MAX_FILE_SIZE_TO_PARSE_MB = exports.MANIFEST_VERSION_MAX = exports.MANIFEST_VERSION_MIN = exports.MANIFEST_VERSION_DEFAULT = exports.MANIFEST_JSON = exports.LOCAL_PROTOCOLS = exports.PACKAGE_TYPES = exports.PACKAGE_SUBPACKAGE = exports.PACKAGE_MULTI = exports.PACKAGE_SEARCHPROV = exports.PACKAGE_LANGPACK = exports.PACKAGE_DICTIONARY = exports.PACKAGE_THEME = exports.PACKAGE_EXTENSION = exports.PACKAGE_ANY = exports.MESSAGE_TYPES = exports.ESLINT_TYPES = exports.VALIDATION_WARNING = exports.VALIDATION_NOTICE = exports.VALIDATION_ERROR = exports.ESLINT_RULE_MAPPING = exports.EXTERNAL_RULE_MAPPING = exports.ESLINT_WARNING = exports.ESLINT_ERROR = void 0;
const ESLINT_ERROR = 2;
exports.ESLINT_ERROR = ESLINT_ERROR;
const ESLINT_WARNING = 1; // Disable escapers (Sanitizer.escapeHTML, escapeHTML)
// and unwrappers (Sanitizer.unwrapSafeHTML, unwrapSafeHTML)
// which are allowed by default by this plugin.

exports.ESLINT_WARNING = ESLINT_WARNING;
const DISABLE_ALLOWED_ESCAPERS = {
  escape: {
    taggedTemplates: [],
    methods: []
  }
}; // 3rd party / eslint-internal rules

const EXTERNAL_RULE_MAPPING = {
  'no-eval': [ESLINT_WARNING, {
    allowIndirect: false
  }],
  'no-implied-eval': ESLINT_WARNING,
  'no-new-func': ESLINT_WARNING,
  'no-unsanitized/method': [ESLINT_WARNING, DISABLE_ALLOWED_ESCAPERS],
  'no-unsanitized/property': [ESLINT_WARNING, DISABLE_ALLOWED_ESCAPERS]
};
exports.EXTERNAL_RULE_MAPPING = EXTERNAL_RULE_MAPPING;
const ESLINT_RULE_MAPPING = {
  'deprecated-entities': ESLINT_WARNING,
  'event-listener-fourth': ESLINT_WARNING,
  'global-require-arg': ESLINT_WARNING,
  'opendialog-nonlit-uri': ESLINT_WARNING,
  'opendialog-remote-uri': ESLINT_WARNING,
  'webextension-api': ESLINT_WARNING,
  'webextension-deprecated-api': ESLINT_WARNING,
  'webextension-unsupported-api': ESLINT_WARNING,
  'content-scripts-file-absent': ESLINT_ERROR,
  'webextension-api-compat': ESLINT_WARNING,
  'webextension-api-compat-android': ESLINT_WARNING,
  ...EXTERNAL_RULE_MAPPING
};
exports.ESLINT_RULE_MAPPING = ESLINT_RULE_MAPPING;
const VALIDATION_ERROR = 'error';
exports.VALIDATION_ERROR = VALIDATION_ERROR;
const VALIDATION_NOTICE = 'notice';
exports.VALIDATION_NOTICE = VALIDATION_NOTICE;
const VALIDATION_WARNING = 'warning';
exports.VALIDATION_WARNING = VALIDATION_WARNING;
const ESLINT_TYPES = {
  0: VALIDATION_NOTICE,
  1: VALIDATION_WARNING,
  2: VALIDATION_ERROR
};
exports.ESLINT_TYPES = ESLINT_TYPES;
const MESSAGE_TYPES = [VALIDATION_ERROR, VALIDATION_NOTICE, VALIDATION_WARNING]; // Package type constants.

exports.MESSAGE_TYPES = MESSAGE_TYPES;
const PACKAGE_ANY = 0;
exports.PACKAGE_ANY = PACKAGE_ANY;
const PACKAGE_EXTENSION = 1;
exports.PACKAGE_EXTENSION = PACKAGE_EXTENSION;
const PACKAGE_THEME = 2;
exports.PACKAGE_THEME = PACKAGE_THEME;
const PACKAGE_DICTIONARY = 3;
exports.PACKAGE_DICTIONARY = PACKAGE_DICTIONARY;
const PACKAGE_LANGPACK = 4;
exports.PACKAGE_LANGPACK = PACKAGE_LANGPACK;
const PACKAGE_SEARCHPROV = 5;
exports.PACKAGE_SEARCHPROV = PACKAGE_SEARCHPROV;
const PACKAGE_MULTI = 1; // A multi extension is an extension

exports.PACKAGE_MULTI = PACKAGE_MULTI;
const PACKAGE_SUBPACKAGE = 7;
exports.PACKAGE_SUBPACKAGE = PACKAGE_SUBPACKAGE;
const PACKAGE_TYPES = {
  PACKAGE_ANY,
  PACKAGE_EXTENSION,
  PACKAGE_THEME,
  PACKAGE_DICTIONARY,
  PACKAGE_LANGPACK,
  PACKAGE_SEARCHPROV,
  PACKAGE_MULTI,
  PACKAGE_SUBPACKAGE
};
exports.PACKAGE_TYPES = PACKAGE_TYPES;
const LOCAL_PROTOCOLS = ['chrome:', 'resource:'];
exports.LOCAL_PROTOCOLS = LOCAL_PROTOCOLS;
const MANIFEST_JSON = 'manifest.json'; // The manifest_version value to use to complete the validation if an explicit one
// was missing from the extension manifest.json (but we will still be collecting the
// error for the missing manifest_version property, because it is mandatory).

exports.MANIFEST_JSON = MANIFEST_JSON;
const MANIFEST_VERSION_DEFAULT = 2; // Default min/max_manifest_version values used for schema definitions that do not
// have an explicit one on their own.

exports.MANIFEST_VERSION_DEFAULT = MANIFEST_VERSION_DEFAULT;
const MANIFEST_VERSION_MIN = 2;
exports.MANIFEST_VERSION_MIN = MANIFEST_VERSION_MIN;
const MANIFEST_VERSION_MAX = 3; // This is the limit in megabytes of a file we will parse (eg. CSS, JS, etc.)
// A singular CSS/JS file over 4MB seems bad and may actually be full of data
// best stored in JSON/some other data format rather than code.
// https://github.com/mozilla/addons-linter/issues/730
// We increased this limit from 2MB to 4MB as per:
// https://github.com/mozilla/addons/issues/181
//
// We should be careful about increasing this any further.

exports.MANIFEST_VERSION_MAX = MANIFEST_VERSION_MAX;
const MAX_FILE_SIZE_TO_PARSE_MB = 4;
exports.MAX_FILE_SIZE_TO_PARSE_MB = MAX_FILE_SIZE_TO_PARSE_MB;
const HIDDEN_FILE_REGEX = /^__MACOSX\//;
exports.HIDDEN_FILE_REGEX = HIDDEN_FILE_REGEX;
const FLAGGED_FILE_REGEX = /thumbs\.db$|\.DS_Store$|\.orig$|\.old$|~$/i;
exports.FLAGGED_FILE_REGEX = FLAGGED_FILE_REGEX;
const ALREADY_SIGNED_REGEX = /^META-INF\/manifest\.mf/;
exports.ALREADY_SIGNED_REGEX = ALREADY_SIGNED_REGEX;
const PERMS_DATAPATH_REGEX = /^\/(permissions|optional_permissions|host_permissions)\/([\d+])/;
exports.PERMS_DATAPATH_REGEX = PERMS_DATAPATH_REGEX;
const RESERVED_FILENAMES = ['mozilla-recommendation.json'];
exports.RESERVED_FILENAMES = RESERVED_FILENAMES;
const FLAGGED_FILE_EXTENSIONS = ['.class', '.dll', '.dylib', '.exe', '.jar', '.sh', '.so', '.swf'];
exports.FLAGGED_FILE_EXTENSIONS = FLAGGED_FILE_EXTENSIONS;
const IMAGE_FILE_EXTENSIONS = ['jpg', 'jpeg', 'webp', 'gif', 'png', 'svg'];
exports.IMAGE_FILE_EXTENSIONS = IMAGE_FILE_EXTENSIONS;
const FILE_EXTENSIONS_TO_MIME = {
  svg: 'image/svg+xml',
  gif: 'image/gif',
  jpg: 'image/jpeg',
  jpeg: 'image/jpeg',
  png: 'image/png',
  webp: 'image/webp'
}; // Unique list of mime types for the allowed static theme images.

exports.FILE_EXTENSIONS_TO_MIME = FILE_EXTENSIONS_TO_MIME;
const STATIC_THEME_IMAGE_MIMES = [...new Set(Object.values(FILE_EXTENSIONS_TO_MIME))]; // Mapping of "schema data paths" of the deprecated properties that we
// issue warnings for.
// If the value is `null` we will be using the `deprecated` message
// from the schema. Otherwise `code`, `message` and `description` will be taken
// from the object provided.
// Note that we have to use the constants name as we can't import
// the message object here.

exports.STATIC_THEME_IMAGE_MIMES = STATIC_THEME_IMAGE_MIMES;
const DEPRECATED_MANIFEST_PROPERTIES = {
  '/theme/images/headerURL': 'MANIFEST_THEME_LWT_ALIAS',
  '/theme/colors/accentcolor': 'MANIFEST_THEME_LWT_ALIAS',
  '/theme/colors/textcolor': 'MANIFEST_THEME_LWT_ALIAS'
}; // Mapping of deprecated javascript apis.
// If the value is `null` we will be using the `deprecated` message
// from the schema. Otherwise `code`, `message` and `description` will be taken
// from the object provided.
// Note that we have to use the constants name as we can't import
// the message object here.

exports.DEPRECATED_MANIFEST_PROPERTIES = DEPRECATED_MANIFEST_PROPERTIES;
const DEPRECATED_JAVASCRIPT_APIS = {
  // These APIs were already deprecated by Chrome and Firefox never
  // supported them. We do still issue deprecation warnings for them.
  'app.getDetails': 'DEPRECATED_CHROME_API',
  'extension.onRequest': 'DEPRECATED_CHROME_API',
  'extension.onRequestExternal': 'DEPRECATED_CHROME_API',
  'extension.sendRequest': 'DEPRECATED_CHROME_API',
  'tabs.getAllInWindow': 'DEPRECATED_CHROME_API',
  'tabs.getSelected': 'DEPRECATED_CHROME_API',
  'tabs.onActiveChanged': 'DEPRECATED_CHROME_API',
  'tabs.onSelectionChanged': 'DEPRECATED_CHROME_API',
  'tabs.sendRequest': 'DEPRECATED_CHROME_API',
  // https://github.com/mozilla/addons-linter/issues/2556
  'proxy.register': 'DEPRECATED_API',
  'proxy.unregister': 'DEPRECATED_API',
  'proxy.onProxyError': 'DEPRECATED_API',
  'proxy.registerProxyScript': 'DEPRECATED_API'
}; // A list of magic numbers that we won't allow.

exports.DEPRECATED_JAVASCRIPT_APIS = DEPRECATED_JAVASCRIPT_APIS;
const FLAGGED_FILE_MAGIC_NUMBERS = [[0x4d, 0x5a], // EXE or DLL,
[0x5a, 0x4d], // Alternative EXE or DLL
[0x7f, 0x45, 0x4c, 0x46], // UNIX elf
[0x23, 0x21], // Shell script
[0xca, 0xfe, 0xba, 0xbe], // Java + Mach-O (dylib)
[0xca, 0xfe, 0xd0, 0x0d], // Java packed
[0x43, 0x57, 0x53] // Compressed SWF
]; // These are APIs that will cause problems when loaded temporarily
// in about:debugging.
// APIs listed here should be defined in https://mzl.la/31p4AMc

exports.FLAGGED_FILE_MAGIC_NUMBERS = FLAGGED_FILE_MAGIC_NUMBERS;
const TEMPORARY_APIS = ['identity.getRedirectURL', 'storage.sync', 'storage.managed', 'runtime.onMessageExternal', 'runtime.onConnectExternal']; // All valid CSP keywords that are options to keys like `default-src` and
// `script-src`. Used in manifest.json parser for validation.
// See https://mzl.la/2vwqbGU for more details and allowed options.

exports.TEMPORARY_APIS = TEMPORARY_APIS;
const CSP_KEYWORD_RE = new RegExp(['(self|none|unsafe-inline|strict-dynamic|unsafe-hashed-attributes)', // Only match these keywords, anything else is forbidden
'(?!.)', '|(sha(256|384|512)-|nonce-)'].join(''));
exports.CSP_KEYWORD_RE = CSP_KEYWORD_RE;
const MESSAGES_JSON = 'messages.json';
exports.MESSAGES_JSON = MESSAGES_JSON;
const LOCALES_DIRECTORY = '_locales'; // This is a string, since it has to be matched globally on a message string.
// This should match
// https://searchfox.org/mozilla-central/rev/3abf6fa7e2a6d9a7bfb88796141b0f012e68c2db/toolkit/components/extensions/ExtensionCommon.jsm#1711

exports.LOCALES_DIRECTORY = LOCALES_DIRECTORY;
const MESSAGE_PLACEHOLDER_REGEXP = '\\$([a-zA-Z0-9_@]+)\\$'; // yauzl should trow error with this message in case of corrupt zip file

exports.MESSAGE_PLACEHOLDER_REGEXP = MESSAGE_PLACEHOLDER_REGEXP;
const ZIP_LIB_CORRUPT_FILE_ERROR = 'end of central directory record signature not found'; // URLs in this array are restricted from being used in the manifest.json "homepage_url" prperty

exports.ZIP_LIB_CORRUPT_FILE_ERROR = ZIP_LIB_CORRUPT_FILE_ERROR;
const RESTRICTED_HOMEPAGE_URLS = ['addons-dev.allizom.org', 'addons.mozilla.org'];
exports.RESTRICTED_HOMEPAGE_URLS = RESTRICTED_HOMEPAGE_URLS;

/***/ }),
/* 12 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports._nonLiteralUri = _nonLiteralUri;
exports._methodPassedRemoteUri = _methodPassedRemoteUri;
exports.ESLINT_OVERWRITE_MESSAGE = exports.ANDROID_INCOMPATIBLE_API = exports.INCOMPATIBLE_API = exports.RUNTIME_ONCONNECTEXTERNAL = exports.RUNTIME_ONMESSAGEEXTERNAL = exports.STORAGE_MANAGED = exports.IDENTITY_GETREDIRECTURL = exports.STORAGE_SYNC = exports.DEPRECATED_CHROME_API = exports.DEPRECATED_API = exports.REMOVED_MV2_API = exports.UNSUPPORTED_API = exports.UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT = exports.KNOWN_LIBRARY = exports.UNADVISED_LIBRARY = exports.BANNED_LIBRARY = exports.NO_DOCUMENT_WRITE = exports.UNEXPECTED_GLOGAL_ARG = exports.NO_IMPLIED_EVAL = exports.DANGEROUS_EVAL = exports.OPENDIALOG_NONLIT_URI = exports.OPENDIALOG_REMOTE_URI = exports.CONTENT_SCRIPT_EMPTY = exports.CONTENT_SCRIPT_NOT_FOUND = exports.EVENT_LISTENER_FOURTH = exports.JS_SYNTAX_ERROR = void 0;

var _commonTags = __webpack_require__(7);

var _utils = __webpack_require__(2);

const JS_SYNTAX_ERROR = {
  code: 'JS_SYNTAX_ERROR',
  message: _utils.i18n._('JavaScript syntax error'),
  description: _utils.i18n._((0, _commonTags.oneLine)`There is a JavaScript syntax error in your
    code, which might be related to some experimental JavaScript features that
    aren't an official part of the language specification and therefore not
    supported yet. The validation cannot continue on this file.`)
};
exports.JS_SYNTAX_ERROR = JS_SYNTAX_ERROR;
const EVENT_LISTENER_FOURTH = {
  code: 'EVENT_LISTENER_FOURTH',
  message: _utils.i18n._('addEventListener` called with truthy fourth argument.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`When called with a truthy forth argument,
    listeners can be triggered potentially unsafely by untrusted code. This
    requires careful review.`)
};
exports.EVENT_LISTENER_FOURTH = EVENT_LISTENER_FOURTH;
const CONTENT_SCRIPT_NOT_FOUND = {
  code: 'CONTENT_SCRIPT_NOT_FOUND',
  legacyCode: null,
  message: _utils.i18n._('Content script file could not be found.'),
  description: _utils.i18n._('Content script file could not be found')
};
exports.CONTENT_SCRIPT_NOT_FOUND = CONTENT_SCRIPT_NOT_FOUND;
const CONTENT_SCRIPT_EMPTY = {
  code: 'CONTENT_SCRIPT_EMPTY',
  legacyCode: null,
  message: _utils.i18n._('Content script file name should not be empty.'),
  description: _utils.i18n._('Content script file name should not be empty')
};
exports.CONTENT_SCRIPT_EMPTY = CONTENT_SCRIPT_EMPTY;

function _nonLiteralUri(method) {
  return {
    code: `${method}_NONLIT_URI`.toUpperCase(),
    message: _utils.i18n._(`'${method}' called with a non-literal uri`),
    description: _utils.i18n._((0, _commonTags.oneLine)`Calling '${method}' with variable
      parameters can result in potential security vulnerabilities if the
      variable contains a remote URI. Consider using 'window.open' with
      the 'chrome=no' flag.`)
  };
}

function _methodPassedRemoteUri(method) {
  return {
    code: `${method}_REMOTE_URI`.toUpperCase(),
    message: _utils.i18n._(`'${method}' called with non-local URI`),
    description: _utils.i18n._((0, _commonTags.oneLine)`Calling '${method}' with a non-local
      URI will result in the dialog being opened with chrome privileges.`)
  };
}

const OPENDIALOG_REMOTE_URI = _methodPassedRemoteUri('openDialog');

exports.OPENDIALOG_REMOTE_URI = OPENDIALOG_REMOTE_URI;

const OPENDIALOG_NONLIT_URI = _nonLiteralUri('openDialog');

exports.OPENDIALOG_NONLIT_URI = OPENDIALOG_NONLIT_URI;
const DANGEROUS_EVAL = {
  code: 'DANGEROUS_EVAL',
  message: null,
  description: _utils.i18n._((0, _commonTags.oneLine)`Evaluation of strings as code can lead to
    security vulnerabilities and performance issues, even in the
    most innocuous of circumstances. Please avoid using \`eval\` and the
    \`Function\` constructor when at all possible.'`)
};
exports.DANGEROUS_EVAL = DANGEROUS_EVAL;
const NO_IMPLIED_EVAL = {
  code: 'NO_IMPLIED_EVAL',
  message: null,
  description: _utils.i18n._((0, _commonTags.oneLine)`setTimeout, setInterval and execScript
    functions should be called only with function expressions as their
    first argument`)
};
exports.NO_IMPLIED_EVAL = NO_IMPLIED_EVAL;
const UNEXPECTED_GLOGAL_ARG = {
  code: 'UNEXPECTED_GLOGAL_ARG',
  message: _utils.i18n._('Unexpected global passed as an argument'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Passing a global as an argument
    is not recommended. Please make this a var instead.`)
};
exports.UNEXPECTED_GLOGAL_ARG = UNEXPECTED_GLOGAL_ARG;
const NO_DOCUMENT_WRITE = {
  code: 'NO_DOCUMENT_WRITE',
  message: _utils.i18n._('Use of document.write strongly discouraged.'),
  description: _utils.i18n._((0, _commonTags.oneLine)`document.write will fail in many
    circumstances when used in extensions, and has potentially severe security
    repercussions when used improperly. Therefore, it should not be used.`)
};
exports.NO_DOCUMENT_WRITE = NO_DOCUMENT_WRITE;
const BANNED_LIBRARY = {
  code: 'BANNED_LIBRARY',
  message: _utils.i18n._('Banned 3rd-party JS library'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Your add-on uses a JavaScript library we
    consider unsafe. Read more: https://bit.ly/1TRIyZY`)
};
exports.BANNED_LIBRARY = BANNED_LIBRARY;
const UNADVISED_LIBRARY = {
  code: 'UNADVISED_LIBRARY',
  message: _utils.i18n._('Unadvised 3rd-party JS library'),
  description: _utils.i18n._((0, _commonTags.oneLine)`Your add-on uses a JavaScript library we do
    not recommend. Read more: https://bit.ly/1TRIyZY`)
};
exports.UNADVISED_LIBRARY = UNADVISED_LIBRARY;
const KNOWN_LIBRARY = {
  code: 'KNOWN_LIBRARY',
  message: _utils.i18n._('Known JS library detected'),
  description: _utils.i18n._((0, _commonTags.oneLine)`JavaScript libraries are discouraged for
    simple add-ons, but are generally accepted.`)
};
exports.KNOWN_LIBRARY = KNOWN_LIBRARY;
const UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT = {
  code: 'UNSAFE_VAR_ASSIGNMENT',
  // Uses original message from eslint
  message: null,
  description: _utils.i18n._((0, _commonTags.oneLine)`Due to both security and performance
    concerns, this may not be set using dynamic values which have
    not been adequately sanitized. This can lead to security issues or fairly
    serious performance degradation.`)
};
exports.UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT = UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT;
const UNSUPPORTED_API = {
  code: 'UNSUPPORTED_API',
  message: null,
  messageFormat: _utils.i18n._('{{api}} is not supported'),
  description: _utils.i18n._('This API has not been implemented by Firefox.')
};
exports.UNSUPPORTED_API = UNSUPPORTED_API;
const REMOVED_MV2_API = {
  code: 'UNSUPPORTED_API',
  message: null,
  messageFormat: _utils.i18n._('"{{api}}" has been removed in Manifest Version 3 (`manifest_version` property)'),
  description: null
};
exports.REMOVED_MV2_API = REMOVED_MV2_API;
const DEPRECATED_API = {
  code: 'DEPRECATED_API',
  message: null,
  messageFormat: _utils.i18n._('{{api}} is deprecated'),
  description: _utils.i18n._('This API has been deprecated by Firefox.')
};
exports.DEPRECATED_API = DEPRECATED_API;
const DEPRECATED_CHROME_API = {
  // We are re-using the same code here for consistency and for technical
  // reasons. We aren't really able to issue different codes from the same
  // rule, so until we have to, we're going to re-use the `DEPRECATED_API`
  // code.
  // Because of that implementation detail ``description`` isn't being usable
  // too.
  code: 'DEPRECATED_API',
  message: null,
  messageFormat: _utils.i18n._('"{{api}}" is deprecated or unimplemented'),
  description: null
};
exports.DEPRECATED_CHROME_API = DEPRECATED_CHROME_API;

function temporaryAPI(api) {
  return {
    code: (0, _utils.apiToMessage)(api),
    message: _utils.i18n._(`"${api}" can cause issues when loaded temporarily`),
    description: _utils.i18n._((0, _commonTags.oneLine)`This API can cause issues when loaded
      temporarily using about:debugging in Firefox unless you specify
      applications|browser_specific_settings > gecko > id in the manifest.
      Please see: https://mzl.la/2hizK4a for more.`)
  };
}

const STORAGE_SYNC = temporaryAPI('storage.sync');
exports.STORAGE_SYNC = STORAGE_SYNC;
const IDENTITY_GETREDIRECTURL = temporaryAPI('identity.getRedirectURL');
exports.IDENTITY_GETREDIRECTURL = IDENTITY_GETREDIRECTURL;
const STORAGE_MANAGED = temporaryAPI('storage.managed');
exports.STORAGE_MANAGED = STORAGE_MANAGED;
const RUNTIME_ONMESSAGEEXTERNAL = temporaryAPI('runtime.onMessageExternal');
exports.RUNTIME_ONMESSAGEEXTERNAL = RUNTIME_ONMESSAGEEXTERNAL;
const RUNTIME_ONCONNECTEXTERNAL = temporaryAPI('runtime.onConnectExternal');
exports.RUNTIME_ONCONNECTEXTERNAL = RUNTIME_ONCONNECTEXTERNAL;
const INCOMPATIBLE_API = {
  code: 'INCOMPATIBLE_API',
  message: null,
  messageFormat: _utils.i18n._('{{api}} is not supported in Firefox version {{minVersion}}'),
  description: _utils.i18n._('This API is not implemented by the given minimum Firefox version')
};
exports.INCOMPATIBLE_API = INCOMPATIBLE_API;
const ANDROID_INCOMPATIBLE_API = {
  code: 'ANDROID_INCOMPATIBLE_API',
  message: null,
  messageFormat: _utils.i18n._('{{api}} is not supported in Firefox for Android version {{minVersion}}'),
  description: _utils.i18n._('This API is not implemented by the given minimum Firefox for Android version')
};
exports.ANDROID_INCOMPATIBLE_API = ANDROID_INCOMPATIBLE_API;
const ESLINT_OVERWRITE_MESSAGE = {
  'no-eval': DANGEROUS_EVAL,
  'no-implied-eval': NO_IMPLIED_EVAL,
  'no-new-func': DANGEROUS_EVAL,
  'no-unsanitized/property': UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT,
  'no-unsanitized/method': UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT,
  'webextension-unsupported-api': UNSUPPORTED_API,
  'webextension-deprecated-api': DEPRECATED_API,
  'webextension-api-compat': INCOMPATIBLE_API,
  'webextension-api-compat-android': ANDROID_INCOMPATIBLE_API
};
exports.ESLINT_OVERWRITE_MESSAGE = ESLINT_OVERWRITE_MESSAGE;

/***/ }),
/* 13 */,
/* 14 */,
/* 15 */,
/* 16 */,
/* 17 */,
/* 18 */,
/* 19 */,
/* 20 */,
/* 21 */,
/* 22 */,
/* 23 */,
/* 24 */,
/* 25 */,
/* 26 */,
/* 27 */,
/* 28 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getManifestVersion = getManifestVersion;
exports.getMaxManifestVersion = getMaxManifestVersion;
exports.getMinManifestVersion = getMinManifestVersion;
exports.isTemporaryApi = isTemporaryApi;
exports.isMV2RemovedApi = isMV2RemovedApi;
exports.isInSupportedManifestVersionRange = isInSupportedManifestVersionRange;
exports.isDeprecatedApi = isDeprecatedApi;
exports.hasBrowserApi = hasBrowserApi;

var _const = __webpack_require__(11);

var _imported = _interopRequireDefault(__webpack_require__(29));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const schemaArrayNames = ['functions', 'events'];
const schemaObjectNames = ['types', 'properties'];

const schemas = _imported.default.reduce((all, current) => ({ ...all,
  [current.id]: current
}), {});

function getObjectProperty(schema, property) {
  for (const schemaProperty of schemaObjectNames) {
    if (schema && schema[schemaProperty] && property in schema[schemaProperty]) {
      return schema[schemaProperty][property];
    }
  }

  return null;
}

function getArrayProperty(schema, property) {
  for (const schemaProperty of schemaArrayNames) {
    if (schema && schemaProperty in schema) {
      const namespaceProperties = schema[schemaProperty];

      if (Array.isArray(namespaceProperties)) {
        for (const schemaItem of namespaceProperties) {
          if (schemaItem.name === property) {
            return schemaItem;
          }
        }
      }
    }
  }

  return null;
}

function getManifestVersion(addonMetadata) {
  const {
    manifestVersion
  } = addonMetadata || {
    manifestVersion: _const.MANIFEST_VERSION_DEFAULT
  };
  return manifestVersion;
}

function getMaxManifestVersion(namespace, property, addonMetadata, apiSchemas = schemas) {
  const schema = apiSchemas[namespace];
  const schemaItem = getObjectProperty(schema, property) || getArrayProperty(schema, property);
  let ns_max_mv = schema && schema.max_manifest_version;
  ns_max_mv = ns_max_mv == null ? _const.MANIFEST_VERSION_MAX : ns_max_mv;
  let prop_max_mv = schemaItem && schemaItem.max_manifest_version;
  prop_max_mv = prop_max_mv == null ? _const.MANIFEST_VERSION_MAX : prop_max_mv; // Return the lowest max_manifest_version value between the one set at
  // API namespace level and the one set on the particular property.

  return Math.min(ns_max_mv, prop_max_mv);
}

function getMinManifestVersion(namespace, property, addonMetadata, apiSchemas = schemas) {
  const schema = apiSchemas[namespace];
  const schemaItem = getObjectProperty(schema, property) || getArrayProperty(schema, property);
  let ns_min_mv = schema && schema.min_manifest_version;
  ns_min_mv = ns_min_mv == null ? _const.MANIFEST_VERSION_MIN : ns_min_mv;
  let prop_min_mv = schemaItem && schemaItem.min_manifest_version;
  prop_min_mv = prop_min_mv == null ? _const.MANIFEST_VERSION_MIN : prop_min_mv; // Return the highest min_manifest_version value between the one set at
  // API namespace level and the one set on the particular property.

  return Math.max(ns_min_mv, prop_min_mv);
}

function isTemporaryApi(namespace, property) {
  return _const.TEMPORARY_APIS.includes(`${namespace}.${property}`);
}

function isMV2RemovedApi(namespace, property, addonMetadata, apiSchemas = schemas) {
  // The message for API deprecated in manifest_version 3 should not be
  // used if the currently validated addon has manifest_version 2.
  if (addonMetadata.manifestVersion === 2) {
    return false;
  }

  return getMaxManifestVersion(namespace, property, addonMetadata, apiSchemas) === 2;
}

function isInSupportedManifestVersionRange(namespace, property, addonMetadata, apiSchemas = schemas) {
  const manifestVersion = getManifestVersion(addonMetadata);
  const min_manifest_version = getMinManifestVersion(namespace, property, addonMetadata, apiSchemas);
  const max_manifest_version = getMaxManifestVersion(namespace, property, addonMetadata, apiSchemas); // The API isn't in a supported manifest version range if its schema entry has a
  // min_manifest_version greater than the extension manifest version or a
  // max_manifest_version lower than the extension manifest version.

  if (manifestVersion < min_manifest_version || manifestVersion > max_manifest_version) {
    return false;
  }

  return true;
}

function isDeprecatedApi(namespace, property, addonMetadata, apiSchemas = schemas) {
  // If the API has been removed in a certain manifest version, or only
  // available starting from a manifest version, then it is unsupported
  // and not deprecated.
  if (!isInSupportedManifestVersionRange(namespace, property, addonMetadata, apiSchemas)) {
    return false;
  }

  const schema = apiSchemas[namespace];
  const schemaItem = getObjectProperty(schema, property) || getArrayProperty(schema, property);
  return schemaItem !== null && schemaItem.deprecated !== undefined || Object.prototype.hasOwnProperty.call(_const.DEPRECATED_JAVASCRIPT_APIS, `${namespace}.${property}`);
}

function hasBrowserApi(namespace, property, addonMetadata, apiSchemas = schemas) {
  // We "have" the API if it's deprecated or temporary so we don't double warn.
  if (isTemporaryApi(namespace, property) || isDeprecatedApi(namespace, property, addonMetadata, apiSchemas)) {
    return true;
  } // We don't have the API if the extension manifest_version is outside of the
  // manifest_version range where the API is actually supported for.


  if (!isInSupportedManifestVersionRange(namespace, property, addonMetadata, apiSchemas)) {
    return false;
  } // Or the schema entry for the API has an unsupported property set to true.


  const schema = apiSchemas[namespace];
  const schemaItem = getObjectProperty(schema, property) || getArrayProperty(schema, property);
  return schemaItem && !schemaItem.unsupported;
}

/***/ }),
/* 29 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var _activity_log = _interopRequireDefault(__webpack_require__(30));

var _alarms = _interopRequireDefault(__webpack_require__(31));

var _bookmarks = _interopRequireDefault(__webpack_require__(32));

var _action = _interopRequireDefault(__webpack_require__(33));

var _browser_action = _interopRequireDefault(__webpack_require__(34));

var _browser_settings = _interopRequireDefault(__webpack_require__(35));

var _browsing_data = _interopRequireDefault(__webpack_require__(36));

var _captive_portal = _interopRequireDefault(__webpack_require__(37));

var _chrome_settings_overrides = _interopRequireDefault(__webpack_require__(38));

var _clipboard = _interopRequireDefault(__webpack_require__(39));

var _commands = _interopRequireDefault(__webpack_require__(40));

var _content_scripts = _interopRequireDefault(__webpack_require__(41));

var _contextual_identities = _interopRequireDefault(__webpack_require__(42));

var _cookies = _interopRequireDefault(__webpack_require__(43));

var _devtools = _interopRequireDefault(__webpack_require__(44));

var _dns = _interopRequireDefault(__webpack_require__(45));

var _downloads = _interopRequireDefault(__webpack_require__(46));

var _events = _interopRequireDefault(__webpack_require__(47));

var _experiments = _interopRequireDefault(__webpack_require__(48));

var _extension = _interopRequireDefault(__webpack_require__(49));

var _extension_protocol_handlers = _interopRequireDefault(__webpack_require__(50));

var _extension_types = _interopRequireDefault(__webpack_require__(51));

var _find = _interopRequireDefault(__webpack_require__(52));

var _geckoProfiler = _interopRequireDefault(__webpack_require__(53));

var _history = _interopRequireDefault(__webpack_require__(54));

var _i18n = _interopRequireDefault(__webpack_require__(55));

var _identity = _interopRequireDefault(__webpack_require__(56));

var _idle = _interopRequireDefault(__webpack_require__(57));

var _management = _interopRequireDefault(__webpack_require__(58));

var _context_menus = _interopRequireDefault(__webpack_require__(59));

var _menus = _interopRequireDefault(__webpack_require__(60));

var _native_manifest = _interopRequireDefault(__webpack_require__(61));

var _network_status = _interopRequireDefault(__webpack_require__(62));

var _normandyAddonStudy = _interopRequireDefault(__webpack_require__(63));

var _notifications = _interopRequireDefault(__webpack_require__(64));

var _omnibox = _interopRequireDefault(__webpack_require__(65));

var _page_action = _interopRequireDefault(__webpack_require__(66));

var _permissions = _interopRequireDefault(__webpack_require__(67));

var _pkcs = _interopRequireDefault(__webpack_require__(68));

var _privacy = _interopRequireDefault(__webpack_require__(69));

var _proxy = _interopRequireDefault(__webpack_require__(70));

var _runtime = _interopRequireDefault(__webpack_require__(71));

var _search = _interopRequireDefault(__webpack_require__(72));

var _sessions = _interopRequireDefault(__webpack_require__(73));

var _sidebar_action = _interopRequireDefault(__webpack_require__(74));

var _storage = _interopRequireDefault(__webpack_require__(75));

var _tabs = _interopRequireDefault(__webpack_require__(76));

var _telemetry = _interopRequireDefault(__webpack_require__(77));

var _test = _interopRequireDefault(__webpack_require__(78));

var _theme = _interopRequireDefault(__webpack_require__(79));

var _top_sites = _interopRequireDefault(__webpack_require__(80));

var _types = _interopRequireDefault(__webpack_require__(81));

var _url_overrides = _interopRequireDefault(__webpack_require__(82));

var _urlbar = _interopRequireDefault(__webpack_require__(83));

var _userScripts = _interopRequireDefault(__webpack_require__(84));

var _web_navigation = _interopRequireDefault(__webpack_require__(85));

var _web_request = _interopRequireDefault(__webpack_require__(86));

var _windows = _interopRequireDefault(__webpack_require__(87));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// This file is generated by the schema import script.
var _default = [_activity_log.default, _alarms.default, _bookmarks.default, _action.default, _browser_action.default, _browser_settings.default, _browsing_data.default, _captive_portal.default, _chrome_settings_overrides.default, _clipboard.default, _commands.default, _content_scripts.default, _contextual_identities.default, _cookies.default, _devtools.default, _dns.default, _downloads.default, _events.default, _experiments.default, _extension.default, _extension_protocol_handlers.default, _extension_types.default, _find.default, _geckoProfiler.default, _history.default, _i18n.default, _identity.default, _idle.default, _management.default, _context_menus.default, _menus.default, _native_manifest.default, _network_status.default, _normandyAddonStudy.default, _notifications.default, _omnibox.default, _page_action.default, _permissions.default, _pkcs.default, _privacy.default, _proxy.default, _runtime.default, _search.default, _sessions.default, _sidebar_action.default, _storage.default, _tabs.default, _telemetry.default, _test.default, _theme.default, _top_sites.default, _types.default, _url_overrides.default, _urlbar.default, _userScripts.default, _web_navigation.default, _web_request.default, _windows.default];
exports["default"] = _default;

/***/ }),
/* 30 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"activityLog","description":"Monitor extension activity","permissions":["activityLog"],"events":[{"name":"onExtensionActivity","description":"Receives an activityItem for each logging event.","type":"function","parameters":[{"name":"details","type":"object","properties":{"timeStamp":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"The date string when this call is triggered."}]},"type":{"type":"string","enum":["api_call","api_event","content_script","user_script"],"description":"The type of log entry.  api_call is a function call made by the extension and api_event is an event callback to the extension.  content_script is logged when a content script is injected."},"viewType":{"type":"string","enum":["background","popup","sidebar","tab","devtools_page","devtools_panel"],"description":"The type of view where the activity occurred.  Content scripts will not have a viewType."},"name":{"type":"string","description":"The name of the api call or event, or the script url if this is a content or user script event."},"data":{"type":"object","properties":{"args":{"type":"array","items":{},"description":"A list of arguments passed to the call."},"result":{"type":"object","description":"The result of the call."},"tabId":{"type":"integer","description":"The tab associated with this event if it is a tab or content script."},"url":{"type":"string","description":"If the type is content_script, this is the url of the script that was injected."}}}},"required":["timeStamp","type","name","data"]}],"extraParameters":[{"name":"id","type":"string"}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["activityLog"]}]}},"refs":{"activityLog#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{}}');

/***/ }),
/* 31 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"alarms","permissions":["alarms"],"functions":[{"name":"create","type":"function","description":"Creates an alarm. After the delay is expired, the onAlarm event is fired. If there is another alarm with the same name (or no name if none is specified), it will be cancelled and replaced by this alarm.","parameters":[{"type":"string","name":"name","optional":true,"description":"Optional name to identify this alarm. Defaults to the empty string."},{"type":"object","name":"alarmInfo","description":"Details about the alarm. The alarm first fires either at \'when\' milliseconds past the epoch (if \'when\' is provided), after \'delayInMinutes\' minutes from the current time (if \'delayInMinutes\' is provided instead), or after \'periodInMinutes\' minutes from the current time (if only \'periodInMinutes\' is provided). Users should never provide both \'when\' and \'delayInMinutes\'. If \'periodInMinutes\' is provided, then the alarm recurs repeatedly after that many minutes.","properties":{"when":{"type":"number","description":"Time when the alarm is scheduled to first fire, in milliseconds past the epoch."},"delayInMinutes":{"type":"number","description":"Number of minutes from the current time after which the alarm should first fire."},"periodInMinutes":{"type":"number","description":"Number of minutes after which the alarm should recur repeatedly."}}}]},{"name":"get","type":"function","description":"Retrieves details about the specified alarm.","async":"callback","parameters":[{"type":"string","name":"name","optional":true,"description":"The name of the alarm to get. Defaults to the empty string."},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Alarm"},{"name":"alarm","optional":true}]}]}]},{"name":"getAll","type":"function","description":"Gets an array of all the alarms.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"alarms","type":"array","items":{"$ref":"#/types/Alarm"}}]}]},{"name":"clear","type":"function","description":"Clears the alarm with the given name.","async":"callback","parameters":[{"type":"string","name":"name","optional":true,"description":"The name of the alarm to clear. Defaults to the empty string."},{"type":"function","name":"callback","parameters":[{"name":"wasCleared","type":"boolean","description":"Whether an alarm of the given name was found to clear."}]}]},{"name":"clearAll","type":"function","description":"Clears all alarms.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"wasCleared","type":"boolean","description":"Whether any alarm was found to clear."}]}]}],"events":[{"name":"onAlarm","type":"function","description":"Fired when an alarm has expired. Useful for transient background pages.","parameters":[{"allOf":[{"$ref":"#/types/Alarm"},{"name":"name","description":"The alarm that has expired."}]}]}],"definitions":{},"refs":{},"types":{"Alarm":{"type":"object","properties":{"name":{"type":"string","description":"Name of this alarm."},"scheduledTime":{"type":"number","description":"Time when the alarm is scheduled to fire, in milliseconds past the epoch."},"periodInMinutes":{"type":"number","description":"When present, signals that the alarm triggers periodically after so many minutes."}},"required":["name","scheduledTime"]}}}');

/***/ }),
/* 32 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"bookmarks","description":"Use the <code>browser.bookmarks</code> API to create, organize, and otherwise manipulate bookmarks. Also see $(topic:override)[Override Pages], which you can use to create a custom Bookmark Manager page.","permissions":["bookmarks"],"functions":[{"name":"get","type":"function","description":"Retrieves the specified BookmarkTreeNode(s).","async":"callback","parameters":[{"name":"idOrIdList","description":"A single string-valued id, or an array of string-valued ids","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"},"minItems":1}]},{"type":"function","name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/BookmarkTreeNode"}}]}]},{"name":"getChildren","type":"function","description":"Retrieves the children of the specified BookmarkTreeNode id.","async":"callback","parameters":[{"type":"string","name":"id"},{"type":"function","name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/BookmarkTreeNode"}}]}]},{"name":"getRecent","type":"function","description":"Retrieves the recently added bookmarks.","async":"callback","parameters":[{"type":"integer","minimum":1,"name":"numberOfItems","description":"The maximum number of items to return."},{"type":"function","name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/BookmarkTreeNode"}}]}]},{"name":"getTree","type":"function","description":"Retrieves the entire Bookmarks hierarchy.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/BookmarkTreeNode"}}]}]},{"name":"getSubTree","type":"function","description":"Retrieves part of the Bookmarks hierarchy, starting at the specified node.","async":"callback","parameters":[{"type":"string","name":"id","description":"The ID of the root of the subtree to retrieve."},{"type":"function","name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/BookmarkTreeNode"}}]}]},{"name":"search","type":"function","description":"Searches for BookmarkTreeNodes matching the given query. Queries specified with an object produce BookmarkTreeNodes matching all specified properties.","async":"callback","parameters":[{"name":"query","description":"Either a string of words that are matched against bookmark URLs and titles, or an object. If an object, the properties <code>query</code>, <code>url</code>, and <code>title</code> may be specified and bookmarks matching all specified properties will be produced.","anyOf":[{"type":"string","description":"A string of words that are matched against bookmark URLs and titles."},{"type":"object","description":"An object specifying properties and values to match when searching. Produces bookmarks matching all properties.","properties":{"query":{"type":"string","description":"A string of words that are matched against bookmark URLs and titles."},"url":{"type":"string","format":"url","description":"The URL of the bookmark; matches verbatim. Note that folders have no URL."},"title":{"type":"string","description":"The title of the bookmark; matches verbatim."}}}]},{"type":"function","name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/BookmarkTreeNode"}}]}]},{"name":"create","type":"function","description":"Creates a bookmark or folder under the specified parentId.  If url is NULL or missing, it will be a folder.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/CreateDetails"},{"name":"bookmark"}]},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/BookmarkTreeNode"},{"name":"result"}]}]}]},{"name":"move","type":"function","description":"Moves the specified BookmarkTreeNode to the provided location.","async":"callback","parameters":[{"type":"string","name":"id"},{"type":"object","name":"destination","properties":{"parentId":{"type":"string"},"index":{"type":"integer","minimum":0}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/BookmarkTreeNode"},{"name":"result"}]}]}]},{"name":"update","type":"function","description":"Updates the properties of a bookmark or folder. Specify only the properties that you want to change; unspecified properties will be left unchanged.  <b>Note:</b> Currently, only \'title\' and \'url\' are supported.","async":"callback","parameters":[{"type":"string","name":"id"},{"type":"object","name":"changes","properties":{"title":{"type":"string"},"url":{"type":"string"}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/BookmarkTreeNode"},{"name":"result"}]}]}]},{"name":"remove","type":"function","description":"Removes a bookmark or an empty bookmark folder.","async":"callback","parameters":[{"type":"string","name":"id"},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"removeTree","type":"function","description":"Recursively removes a bookmark folder.","async":"callback","parameters":[{"type":"string","name":"id"},{"type":"function","name":"callback","optional":true,"parameters":[]}]}],"events":[{"name":"onCreated","type":"function","description":"Fired when a bookmark or folder is created.","parameters":[{"type":"string","name":"id"},{"allOf":[{"$ref":"#/types/BookmarkTreeNode"},{"name":"bookmark"}]}]},{"name":"onRemoved","type":"function","description":"Fired when a bookmark or folder is removed.  When a folder is removed recursively, a single notification is fired for the folder, and none for its contents.","parameters":[{"type":"string","name":"id"},{"type":"object","name":"removeInfo","properties":{"parentId":{"type":"string"},"index":{"type":"integer"},"node":{"$ref":"#/types/BookmarkTreeNode"}},"required":["parentId","index","node"]}]},{"name":"onChanged","type":"function","description":"Fired when a bookmark or folder changes.  <b>Note:</b> Currently, only title and url changes trigger this.","parameters":[{"type":"string","name":"id"},{"type":"object","name":"changeInfo","properties":{"title":{"type":"string"},"url":{"type":"string"}},"required":["title"]}]},{"name":"onMoved","type":"function","description":"Fired when a bookmark or folder is moved to a different parent folder.","parameters":[{"type":"string","name":"id"},{"type":"object","name":"moveInfo","properties":{"parentId":{"type":"string"},"index":{"type":"integer"},"oldParentId":{"type":"string"},"oldIndex":{"type":"integer"}},"required":["parentId","index","oldParentId","oldIndex"]}]},{"name":"onChildrenReordered","unsupported":true,"type":"function","description":"Fired when the children of a folder have changed their order due to the order being sorted in the UI.  This is not called as a result of a move().","parameters":[{"type":"string","name":"id"},{"type":"object","name":"reorderInfo","properties":{"childIds":{"type":"array","items":{"type":"string"}}},"required":["childIds"]}]},{"name":"onImportBegan","unsupported":true,"type":"function","description":"Fired when a bookmark import session is begun.  Expensive observers should ignore onCreated updates until onImportEnded is fired.  Observers should still handle other notifications immediately.","parameters":[]},{"name":"onImportEnded","unsupported":true,"type":"function","description":"Fired when a bookmark import session is ended.","parameters":[]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["bookmarks"]}]}},"refs":{"bookmarks#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"BookmarkTreeNodeUnmodifiable":{"type":"string","enum":["managed"],"description":"Indicates the reason why this node is unmodifiable. The <var>managed</var> value indicates that this node was configured by the system administrator or by the custodian of a supervised user. Omitted if the node can be modified by the user and the extension (default)."},"BookmarkTreeNodeType":{"type":"string","enum":["bookmark","folder","separator"],"description":"Indicates the type of a BookmarkTreeNode, which can be one of bookmark, folder or separator."},"BookmarkTreeNode":{"type":"object","description":"A node (either a bookmark or a folder) in the bookmark tree.  Child nodes are ordered within their parent folder.","properties":{"id":{"type":"string","description":"The unique identifier for the node. IDs are unique within the current profile, and they remain valid even after the browser is restarted."},"parentId":{"type":"string","description":"The <code>id</code> of the parent folder.  Omitted for the root node."},"index":{"type":"integer","description":"The 0-based position of this node within its parent folder."},"url":{"type":"string","description":"The URL navigated to when a user clicks the bookmark. Omitted for folders."},"title":{"type":"string","description":"The text displayed for the node."},"dateAdded":{"type":"number","description":"When this node was created, in milliseconds since the epoch (<code>new Date(dateAdded)</code>)."},"dateGroupModified":{"type":"number","description":"When the contents of this folder last changed, in milliseconds since the epoch."},"unmodifiable":{"allOf":[{"$ref":"#/types/BookmarkTreeNodeUnmodifiable"},{"description":"Indicates the reason why this node is unmodifiable. The <var>managed</var> value indicates that this node was configured by the system administrator or by the custodian of a supervised user. Omitted if the node can be modified by the user and the extension (default)."}]},"type":{"allOf":[{"$ref":"#/types/BookmarkTreeNodeType"},{"description":"Indicates the type of the BookmarkTreeNode, which can be one of bookmark, folder or separator."}]},"children":{"type":"array","items":{"$ref":"#/types/BookmarkTreeNode"},"description":"An ordered list of children of this node."}},"required":["id","title"]},"CreateDetails":{"description":"Object passed to the create() function.","type":"object","properties":{"parentId":{"type":"string","description":"Defaults to the Other Bookmarks folder."},"index":{"type":"integer","minimum":0},"title":{"type":"string"},"url":{"type":"string"},"type":{"allOf":[{"$ref":"#/types/BookmarkTreeNodeType"},{"description":"Indicates the type of BookmarkTreeNode to create, which can be one of bookmark, folder or separator."}]}}}}}');

/***/ }),
/* 33 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"action","description":"Use browser actions to put icons in the main browser toolbar, to the right of the address bar. In addition to its icon, a browser action can also have a tooltip, a badge, and a popup.","permissions":["manifest:action","manifest:browser_action"],"min_manifest_version":3,"functions":[{"name":"setTitle","type":"function","description":"Sets the title of the browser action. This shows up in the tooltip.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"action#/types/Details"},"with":{"name":"details","type":"object","properties":{"title":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The string the browser action should display when moused over."}},"required":["title"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getTitle","type":"function","description":"Gets the title of the browser action.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"setIcon","type":"function","description":"Sets the icon for the browser action. The icon can be specified either as the path to an image file or as the pixel data from a canvas element, or as dictionary of either one of those. Either the <b>path</b> or the <b>imageData</b> property must be specified.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"action#/types/Details"},"with":{"name":"details","type":"object","properties":{"imageData":{"anyOf":[{"$ref":"#/types/ImageDataType"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"$ref":"#/types/ImageDataType"}}}],"description":"Either an ImageData object or a dictionary {size -> ImageData} representing icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.imageData = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"},"path":{"anyOf":[{"type":"string"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}}],"description":"Either a relative image path or a dictionary {size -> relative image path} pointing to icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.path = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"}}}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"setPopup","type":"function","description":"Sets the html document to be opened as a popup when the user clicks on the browser action\'s icon.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"action#/types/Details"},"with":{"name":"details","type":"object","properties":{"popup":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The html file to show in a popup.  If set to the empty string (\'\'), no popup is shown."}},"required":["popup"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getPopup","type":"function","description":"Gets the html document set as the popup for this browser action.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"setBadgeText","type":"function","description":"Sets the badge text for the browser action. The badge is displayed on top of the icon.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"action#/types/Details"},"with":{"name":"details","type":"object","properties":{"text":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"Any number of characters can be passed, but only about four can fit in the space."}},"required":["text"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getBadgeText","type":"function","description":"Gets the badge text of the browser action. If no tab nor window is specified is specified, the global badge text is returned.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"setBadgeBackgroundColor","type":"function","description":"Sets the background color for the badge.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"action#/types/Details"},"with":{"name":"details","type":"object","properties":{"color":{"$ref":"#/types/ColorValue"}},"required":["color"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getBadgeBackgroundColor","type":"function","description":"Gets the background color of the browser action badge.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/ColorArray"},{"name":"result"}]}]}]},{"name":"setBadgeTextColor","type":"function","description":"Sets the text color for the badge.","async":true,"parameters":[{"$merge":{"source":{"$ref":"action#/types/Details"},"with":{"name":"details","type":"object","properties":{"color":{"$ref":"#/types/ColorValue"}},"required":["color"]}}}]},{"name":"getBadgeTextColor","type":"function","description":"Gets the text color of the browser action badge.","async":true,"parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]}]},{"name":"enable","type":"function","description":"Enables the browser action for a tab. By default, browser actions are enabled.","async":"callback","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0,"description":"The id of the tab for which you want to modify the browser action."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"disable","type":"function","description":"Disables the browser action for a tab.","async":"callback","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0,"description":"The id of the tab for which you want to modify the browser action."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"isEnabled","type":"function","description":"Checks whether the browser action is enabled.","async":true,"parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]}]},{"name":"openPopup","type":"function","requireUserInput":true,"description":"Opens the extension popup window in the active window.","async":true,"parameters":[]}],"events":[{"name":"onClicked","type":"function","description":"Fired when a browser action icon is clicked.  This event will not fire if the browser action has a popup.","parameters":[{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab"}]},{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","optional":true}]}]}],"definitions":{"WebExtensionManifest":{"properties":{"action":{"allOf":[{"$ref":"#/types/ActionManifest"},{"min_manifest_version":3}]},"browser_action":{"allOf":[{"$ref":"#/types/ActionManifest"},{"max_manifest_version":2}]}}}},"refs":{"action#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"Details":{"type":"object","description":"Specifies to which tab or window the value should be set, or from which one it should be retrieved. If no tab nor window is specified, the global value is set or retrieved.","properties":{"tabId":{"type":"integer","minimum":0,"description":"When setting a value, it will be specific to the specified tab, and will automatically reset when the tab navigates. When getting, specifies the tab to get the value from; if there is no tab-specific value, the window one will be inherited."},"windowId":{"type":"integer","minimum":-2,"description":"When setting a value, it will be specific to the specified window. When getting, specifies the window to get the value from; if there is no window-specific value, the global one will be inherited."}}},"ColorArray":{"type":"array","items":{"type":"integer","minimum":0,"maximum":255},"minItems":4,"maxItems":4},"ImageDataType":{"type":"object","isInstanceOf":"ImageData","additionalProperties":{},"postprocess":"convertImageDataToURL","description":"Pixel data for an image. Must be an ImageData object (for example, from a <code>canvas</code> element)."},"ColorValue":{"description":"An array of four integers in the range [0,255] that make up the RGBA color of the badge. For example, opaque red is <code>[255, 0, 0, 255]</code>. Can also be a string with a CSS value, with opaque red being <code>#FF0000</code> or <code>#F00</code>.","anyOf":[{"type":"string"},{"$ref":"#/types/ColorArray"},{"type":"null"}]},"OnClickData":{"type":"object","description":"Information sent when a browser action is clicked.","properties":{"modifiers":{"type":"array","items":{"type":"string","enum":["Shift","Alt","Command","Ctrl","MacCtrl"]},"description":"An array of keyboard modifiers that were held while the menu item was clicked."},"button":{"type":"integer","description":"An integer value of button by which menu item was clicked."}},"required":["modifiers"]},"ActionManifest":{"type":"object","properties":{"default_title":{"type":"string","preprocess":"localize"},"default_icon":{"$ref":"manifest#/types/IconPath"},"theme_icons":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/ThemeIcons"},"description":"Specifies icons to use for dark and light themes"},"default_popup":{"type":"string","format":"relativeUrl","preprocess":"localize"},"browser_style":{"type":"boolean","default":false},"default_area":{"description":"Defines the location the browserAction will appear by default.  The default location is navbar.","type":"string","enum":["navbar","menupanel","tabstrip","personaltoolbar"]}}}}}');

/***/ }),
/* 34 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"browserAction","description":"Use browser actions to put icons in the main browser toolbar, to the right of the address bar. In addition to its icon, a browser action can also have a tooltip, a badge, and a popup.","permissions":["manifest:action","manifest:browser_action"],"types":{"ActionManifest":{"type":"object","properties":{"default_title":{"type":"string","preprocess":"localize"},"default_icon":{"$ref":"manifest#/types/IconPath"},"theme_icons":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/ThemeIcons"},"description":"Specifies icons to use for dark and light themes"},"default_popup":{"type":"string","format":"relativeUrl","preprocess":"localize"},"browser_style":{"type":"boolean","default":false},"default_area":{"description":"Defines the location the browserAction will appear by default.  The default location is navbar.","type":"string","enum":["navbar","menupanel","tabstrip","personaltoolbar"]}}}},"functions":[{"name":"setTitle","type":"function","description":"Sets the title of the browser action. This shows up in the tooltip.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"browserAction#/types/Details"},"with":{"name":"details","type":"object","properties":{"title":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The string the browser action should display when moused over."}},"required":["title"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getTitle","type":"function","description":"Gets the title of the browser action.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"setIcon","type":"function","description":"Sets the icon for the browser action. The icon can be specified either as the path to an image file or as the pixel data from a canvas element, or as dictionary of either one of those. Either the <b>path</b> or the <b>imageData</b> property must be specified.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"browserAction#/types/Details"},"with":{"name":"details","type":"object","properties":{"imageData":{"anyOf":[{"$ref":"#/types/ImageDataType"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"$ref":"#/types/ImageDataType"}}}],"description":"Either an ImageData object or a dictionary {size -> ImageData} representing icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.imageData = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"},"path":{"anyOf":[{"type":"string"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}}],"description":"Either a relative image path or a dictionary {size -> relative image path} pointing to icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.path = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"}}}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"setPopup","type":"function","description":"Sets the html document to be opened as a popup when the user clicks on the browser action\'s icon.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"browserAction#/types/Details"},"with":{"name":"details","type":"object","properties":{"popup":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The html file to show in a popup.  If set to the empty string (\'\'), no popup is shown."}},"required":["popup"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getPopup","type":"function","description":"Gets the html document set as the popup for this browser action.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"setBadgeText","type":"function","description":"Sets the badge text for the browser action. The badge is displayed on top of the icon.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"browserAction#/types/Details"},"with":{"name":"details","type":"object","properties":{"text":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"Any number of characters can be passed, but only about four can fit in the space."}},"required":["text"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getBadgeText","type":"function","description":"Gets the badge text of the browser action. If no tab nor window is specified is specified, the global badge text is returned.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"setBadgeBackgroundColor","type":"function","description":"Sets the background color for the badge.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"browserAction#/types/Details"},"with":{"name":"details","type":"object","properties":{"color":{"$ref":"#/types/ColorValue"}},"required":["color"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getBadgeBackgroundColor","type":"function","description":"Gets the background color of the browser action badge.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/ColorArray"},{"name":"result"}]}]}]},{"name":"setBadgeTextColor","type":"function","description":"Sets the text color for the badge.","async":true,"parameters":[{"$merge":{"source":{"$ref":"browserAction#/types/Details"},"with":{"name":"details","type":"object","properties":{"color":{"$ref":"#/types/ColorValue"}},"required":["color"]}}}]},{"name":"getBadgeTextColor","type":"function","description":"Gets the text color of the browser action badge.","async":true,"parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]}]},{"name":"enable","type":"function","description":"Enables the browser action for a tab. By default, browser actions are enabled.","async":"callback","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0,"description":"The id of the tab for which you want to modify the browser action."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"disable","type":"function","description":"Disables the browser action for a tab.","async":"callback","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0,"description":"The id of the tab for which you want to modify the browser action."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"isEnabled","type":"function","description":"Checks whether the browser action is enabled.","async":true,"parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]}]},{"name":"openPopup","type":"function","requireUserInput":true,"description":"Opens the extension popup window in the active window.","async":true,"parameters":[]}],"events":[{"name":"onClicked","type":"function","description":"Fired when a browser action icon is clicked.  This event will not fire if the browser action has a popup.","parameters":[{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab"}]},{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","optional":true}]}]}],"max_manifest_version":2,"definitions":{"WebExtensionManifest":{"properties":{"action":{"allOf":[{"$ref":"#/types/ActionManifest"},{"min_manifest_version":3}]},"browser_action":{"allOf":[{"$ref":"#/types/ActionManifest"},{"max_manifest_version":2}]}}}},"refs":{"browserAction#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}}}');

/***/ }),
/* 35 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"browserSettings","description":"Use the <code>browser.browserSettings</code> API to control global settings of the browser.","permissions":["browserSettings"],"properties":{"allowPopupsForUserEvents":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allows or disallows pop-up windows from opening in response to user events."}]},"cacheEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Enables or disables the browser cache."}]},"closeTabsByDoubleClick":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether the selected tab can be closed with a double click."}]},"contextMenuShowEvent":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Controls after which mouse event context menus popup. This setting\'s value is of type ContextMenuMouseEvent, which has possible values of <code>mouseup</code> and <code>mousedown</code>."}]},"ftpProtocolEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Returns whether the FTP protocol is enabled. Read-only.","deprecated":"FTP support was removed from Firefox in bug 1574475"}]},"homepageOverride":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Returns the value of the overridden home page. Read-only."}]},"imageAnimationBehavior":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Controls the behaviour of image animation in the browser. This setting\'s value is of type ImageAnimationBehavior, defaulting to <code>normal</code>."}]},"newTabPageOverride":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Returns the value of the overridden new tab page. Read-only."}]},"newTabPosition":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Controls where new tabs are opened. `afterCurrent` will open all new tabs next to the current tab, `relatedAfterCurrent` will open only related tabs next to the current tab, and `atEnd` will open all tabs at the end of the tab strip. The default is `relatedAfterCurrent`."}]},"openBookmarksInNewTabs":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether bookmarks are opened in the current tab or in a new tab."}]},"openSearchResultsInNewTabs":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether search results are opened in the current tab or in a new tab."}]},"openUrlbarResultsInNewTabs":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether urlbar results are opened in the current tab or in a new tab."}]},"webNotificationsDisabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Disables webAPI notifications."}]},"overrideDocumentColors":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This setting controls whether the user-chosen colors override the page\'s colors."}]},"useDocumentFonts":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This setting controls whether the document\'s fonts are used."}]},"zoomFullPage":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether zoom is applied to the full page or to text only."}]},"zoomSiteSpecific":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether zoom is applied on a per-site basis or to the current tab only. If privacy.resistFingerprinting is true, this setting has no effect and zoom is applied to the current tab only."}]},"colorManagement":{"description":"Use the <code>browserSettings.colorManagement</code> API to query and set items related to color management.","permissions":["browserSettings"],"properties":{"mode":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This setting controls the mode used for color management and must be a string from $(ref:browserSettings.ColorManagementMode)"}]},"useNativeSRGB":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether or not native sRGB color management is used."}]},"useWebRenderCompositor":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether or not the WebRender compositor is used."}]}},"required":["mode","useNativeSRGB","useWebRenderCompositor"]}},"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["browserSettings"]}]}},"refs":{"browserSettings#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"ImageAnimationBehavior":{"type":"string","enum":["normal","none","once"],"description":"How images should be animated in the browser."},"ContextMenuMouseEvent":{"type":"string","enum":["mouseup","mousedown"],"description":"After which mouse event context menus should popup."},"ColorManagementMode":{"type":"string","enum":["off","full","tagged_only"],"description":"Color management mode."}}}');

/***/ }),
/* 36 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"browsingData","description":"Use the <code>chrome.browsingData</code> API to remove browsing data from a user\'s local profile.","permissions":["browsingData"],"functions":[{"name":"settings","description":"Reports which types of data are currently selected in the \'Clear browsing data\' settings UI.  Note: some of the data types included in this API are not available in the settings UI, and some UI settings control more than one data type listed here.","type":"function","async":"callback","parameters":[{"name":"callback","type":"function","parameters":[{"name":"result","type":"object","properties":{"options":{"$ref":"#/types/RemovalOptions"},"dataToRemove":{"allOf":[{"$ref":"#/types/DataTypeSet"},{"description":"All of the types will be present in the result, with values of <code>true</code> if they are both selected to be removed and permitted to be removed, otherwise <code>false</code>."}]},"dataRemovalPermitted":{"allOf":[{"$ref":"#/types/DataTypeSet"},{"description":"All of the types will be present in the result, with values of <code>true</code> if they are permitted to be removed (e.g., by enterprise policy) and <code>false</code> if not."}]}},"required":["options","dataToRemove","dataRemovalPermitted"]}]}]},{"name":"remove","description":"Clears various types of browsing data stored in a user\'s profile.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"allOf":[{"$ref":"#/types/DataTypeSet"},{"name":"dataToRemove","description":"The set of data types to remove."}]},{"name":"callback","type":"function","description":"Called when deletion has completed.","optional":true,"parameters":[]}]},{"name":"removeAppcache","description":"Clears websites\' appcache data.","type":"function","async":"callback","unsupported":true,"parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when websites\' appcache data has been cleared.","optional":true,"parameters":[]}]},{"name":"removeCache","description":"Clears the browser\'s cache.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when the browser\'s cache has been cleared.","optional":true,"parameters":[]}]},{"name":"removeCookies","description":"Clears the browser\'s cookies and server-bound certificates modified within a particular timeframe.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when the browser\'s cookies and server-bound certificates have been cleared.","optional":true,"parameters":[]}]},{"name":"removeDownloads","description":"Clears the browser\'s list of downloaded files (<em>not</em> the downloaded files themselves).","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when the browser\'s list of downloaded files has been cleared.","optional":true,"parameters":[]}]},{"name":"removeFileSystems","description":"Clears websites\' file system data.","type":"function","async":"callback","unsupported":true,"parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when websites\' file systems have been cleared.","optional":true,"parameters":[]}]},{"name":"removeFormData","description":"Clears the browser\'s stored form data (autofill).","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when the browser\'s form data has been cleared.","optional":true,"parameters":[]}]},{"name":"removeHistory","description":"Clears the browser\'s history.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when the browser\'s history has cleared.","optional":true,"parameters":[]}]},{"name":"removeIndexedDB","description":"Clears websites\' IndexedDB data.","type":"function","async":"callback","unsupported":true,"parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when websites\' IndexedDB data has been cleared.","optional":true,"parameters":[]}]},{"name":"removeLocalStorage","description":"Clears websites\' local storage data.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when websites\' local storage has been cleared.","optional":true,"parameters":[]}]},{"name":"removePluginData","description":"Clears plugins\' data.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when plugins\' data has been cleared.","optional":true,"parameters":[]}]},{"name":"removePasswords","description":"Clears the browser\'s stored passwords.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when the browser\'s passwords have been cleared.","optional":true,"parameters":[]}]},{"name":"removeWebSQL","description":"Clears websites\' WebSQL data.","type":"function","async":"callback","unsupported":true,"parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when websites\' WebSQL databases have been cleared.","optional":true,"parameters":[]}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["browsingData"]}]}},"refs":{"browsingData#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"RemovalOptions":{"type":"object","description":"Options that determine exactly what data will be removed.","properties":{"since":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"Remove data accumulated on or after this date, represented in milliseconds since the epoch (accessible via the <code>getTime</code> method of the JavaScript <code>Date</code> object). If absent, defaults to 0 (which would remove all browsing data)."}]},"hostnames":{"type":"array","items":{"type":"string","format":"hostname"},"description":"Only remove data associated with these hostnames (only applies to cookies and localStorage)."},"cookieStoreId":{"type":"string","description":"Only remove data associated with this specific cookieStoreId."},"originTypes":{"type":"object","description":"An object whose properties specify which origin types ought to be cleared. If this object isn\'t specified, it defaults to clearing only \\"unprotected\\" origins. Please ensure that you <em>really</em> want to remove application data before adding \'protectedWeb\' or \'extensions\'.","properties":{"unprotectedWeb":{"type":"boolean","description":"Normal websites."},"protectedWeb":{"type":"boolean","description":"Websites that have been installed as hosted applications (be careful!)."},"extension":{"type":"boolean","description":"Extensions and packaged applications a user has installed (be _really_ careful!)."}}}}},"DataTypeSet":{"type":"object","description":"A set of data types. Missing data types are interpreted as <code>false</code>.","properties":{"cache":{"type":"boolean","description":"The browser\'s cache. Note: when removing data, this clears the <em>entire</em> cache: it is not limited to the range you specify."},"cookies":{"type":"boolean","description":"The browser\'s cookies."},"downloads":{"type":"boolean","description":"The browser\'s download list."},"formData":{"type":"boolean","description":"The browser\'s stored form data."},"history":{"type":"boolean","description":"The browser\'s history."},"indexedDB":{"type":"boolean","description":"Websites\' IndexedDB data."},"localStorage":{"type":"boolean","description":"Websites\' local storage data."},"serverBoundCertificates":{"type":"boolean","description":"Server-bound certificates."},"passwords":{"type":"boolean","description":"Stored passwords."},"pluginData":{"type":"boolean","description":"Plugins\' data."},"serviceWorkers":{"type":"boolean","description":"Service Workers."}}}}}');

/***/ }),
/* 37 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"captivePortal","description":"This API provides the ability detect the captive portal state of the users connection.","permissions":["captivePortal"],"properties":{"canonicalURL":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Return the canonical captive-portal detection URL. Read-only."}]}},"functions":[{"name":"getState","type":"function","description":"Returns the current portal state, one of `unknown`, `not_captive`, `unlocked_portal`, `locked_portal`.","async":true,"parameters":[]},{"name":"getLastChecked","type":"function","description":"Returns the time difference between NOW and the last time a request was completed in milliseconds.","async":true,"parameters":[]}],"events":[{"name":"onStateChanged","type":"function","description":"Fired when the captive portal state changes.","parameters":[{"type":"object","name":"details","properties":{"state":{"type":"string","enum":["unknown","not_captive","unlocked_portal","locked_portal"],"description":"The current captive portal state."}},"required":["state"]}]},{"name":"onConnectivityAvailable","type":"function","description":"This notification will be emitted when the captive portal service has determined that we can connect to the internet. The service will pass either `captive` if there is an unlocked captive portal present, or `clear` if no captive portal was detected.","parameters":[{"name":"status","enum":["captive","clear"],"type":"string"}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["captivePortal"]}]}},"refs":{"captivePortal#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{}}');

/***/ }),
/* 38 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"chrome_settings_overrides","definitions":{"WebExtensionManifest":{"properties":{"chrome_settings_overrides":{"type":"object","properties":{"homepage":{"type":"string","format":"homepageUrl","preprocess":"localize"},"search_provider":{"type":"object","properties":{"name":{"type":"string","preprocess":"localize"},"keyword":{"anyOf":[{"type":"string","preprocess":"localize"},{"type":"array","items":{"type":"string","preprocess":"localize"},"minItems":1}]},"search_url":{"type":"string","format":"url","pattern":"^(https://|http://(localhost|127\\\\.0\\\\.0\\\\.1|\\\\[::1\\\\])(:\\\\d*)?(/|$)).*$","preprocess":"localize"},"favicon_url":{"anyOf":[{"type":"string","format":"relativeUrl","max_manifest_version":2},{"type":"string","format":"strictRelativeUrl"}],"preprocess":"localize"},"suggest_url":{"type":"string","pattern":"^$|^(https://|http://(localhost|127\\\\.0\\\\.0\\\\.1|\\\\[::1\\\\])(:\\\\d*)?(/|$)).*$","preprocess":"localize"},"instant_url":{"type":"string","format":"url","preprocess":"localize","deprecated":"Unsupported on Firefox at this time."},"image_url":{"type":"string","format":"url","preprocess":"localize","deprecated":"Unsupported on Firefox at this time."},"search_url_get_params":{"type":"string","preprocess":"localize","description":"GET parameters to the search_url as a query string."},"search_url_post_params":{"type":"string","preprocess":"localize","description":"POST parameters to the search_url as a query string."},"suggest_url_get_params":{"type":"string","preprocess":"localize","description":"GET parameters to the suggest_url as a query string."},"suggest_url_post_params":{"type":"string","preprocess":"localize","description":"POST parameters to the suggest_url as a query string."},"instant_url_post_params":{"type":"string","preprocess":"localize","deprecated":"Unsupported on Firefox at this time."},"image_url_post_params":{"type":"string","preprocess":"localize","deprecated":"Unsupported on Firefox at this time."},"search_form":{"type":"string","format":"url","pattern":"^(https://|http://(localhost|127\\\\.0\\\\.0\\\\.1|\\\\[::1\\\\])(:\\\\d*)?(/|$)).*$","preprocess":"localize"},"alternate_urls":{"type":"array","items":{"type":"string","format":"url","preprocess":"localize"},"deprecated":"Unsupported on Firefox at this time."},"prepopulated_id":{"type":"integer","deprecated":"Unsupported on Firefox."},"encoding":{"type":"string","description":"Encoding of the search term."},"is_default":{"type":"boolean","description":"Sets the default engine to a built-in engine only."},"params":{"type":"array","items":{"type":"object","properties":{"name":{"type":"string","description":"A url parameter name"},"condition":{"type":"string","enum":["purpose","pref"],"description":"The type of param can be either \\"purpose\\" or \\"pref\\"."},"pref":{"type":"string","description":"The preference to retrieve the value from.","preprocess":"localize"},"purpose":{"type":"string","enum":["contextmenu","searchbar","homepage","keyword","newtab"],"description":"The context that initiates a search, required if condition is \\"purpose\\"."},"value":{"type":"string","description":"A url parameter value.","preprocess":"localize"}},"required":["name"]},"description":"A list of optional search url parameters. This allows the additon of search url parameters based on how the search is performed in Firefox."}},"required":["name","search_url"]}}}}}},"refs":{"chrome_settings_overrides#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{}}');

/***/ }),
/* 39 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"clipboard","description":"Offers the ability to write to the clipboard. Reading is not supported because the clipboard can already be read through the standard web platform APIs.","permissions":["clipboardWrite"],"functions":[{"name":"setImageData","type":"function","description":"Copy an image to the clipboard. The image is re-encoded before it is written to the clipboard. If the image is invalid, the clipboard is not modified.","async":true,"parameters":[{"type":"object","isInstanceOf":"ArrayBuffer","additionalProperties":true,"name":"imageData","description":"The image data to be copied."},{"type":"string","name":"imageType","enum":["jpeg","png"],"description":"The type of imageData."}]}],"definitions":{},"refs":{},"types":{}}');

/***/ }),
/* 40 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"commands","description":"Use the commands API to add keyboard shortcuts that trigger actions in your extension, for example, an action to open the browser action or send a command to the xtension.","permissions":["manifest:commands"],"events":[{"name":"onCommand","description":"Fired when a registered command is activated using a keyboard shortcut.","type":"function","parameters":[{"name":"command","type":"string"}]}],"functions":[{"name":"update","type":"function","async":true,"description":"Update the details of an already defined command.","parameters":[{"type":"object","name":"detail","description":"The new description for the command.","properties":{"name":{"type":"string","description":"The name of the command."},"description":{"type":"string","description":"The new description for the command."},"shortcut":{"type":"string","format":"manifestShortcutKeyOrEmpty"}},"required":["name"]}]},{"name":"reset","type":"function","async":true,"description":"Reset a command\'s details to what is specified in the manifest.","parameters":[{"type":"string","name":"name","description":"The name of the command."}]},{"name":"getAll","type":"function","async":"callback","description":"Returns all the registered extension commands for this extension and their shortcut (if active).","parameters":[{"type":"function","name":"callback","optional":true,"parameters":[{"name":"commands","type":"array","items":{"$ref":"#/types/Command"}}],"description":"Called to return the registered commands."}]}],"definitions":{"WebExtensionManifest":{"properties":{"commands":{"type":"object","additionalProperties":{"type":"object","properties":{"suggested_key":{"type":"object","properties":{"default":{"$ref":"#/types/KeyName"},"mac":{"$ref":"#/types/KeyName"},"linux":{"$ref":"#/types/KeyName"},"windows":{"$ref":"#/types/KeyName"},"chromeos":{"type":"string"},"android":{"type":"string"},"ios":{"type":"string"},"additionalProperties":{"type":"string","deprecated":"Unknown platform name"}}},"description":{"type":"string","preprocess":"localize"}}}}}}},"refs":{"commands#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"Command":{"type":"object","properties":{"name":{"type":"string","description":"The name of the Extension Command"},"description":{"type":"string","description":"The Extension Command description"},"shortcut":{"type":"string","description":"The shortcut active for this command, or blank if not active."}}},"KeyName":{"type":"string","format":"manifestShortcutKey"}}}');

/***/ }),
/* 41 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"contentScripts","functions":[{"name":"register","type":"function","description":"Register a content script programmatically","async":true,"parameters":[{"allOf":[{"$ref":"#/types/RegisteredContentScriptOptions"},{"name":"contentScriptOptions"}]}]}],"definitions":{},"refs":{},"types":{"RegisteredContentScriptOptions":{"type":"object","description":"Details of a content script registered programmatically","properties":{"matches":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/MatchPattern"}},"excludeMatches":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/MatchPattern"}},"includeGlobs":{"type":"array","items":{"type":"string"}},"excludeGlobs":{"type":"array","items":{"type":"string"}},"css":{"type":"array","description":"The list of CSS files to inject","items":{"$ref":"extensionTypes#/types/ExtensionFileOrCode"}},"js":{"type":"array","description":"The list of JS files to inject","items":{"$ref":"extensionTypes#/types/ExtensionFileOrCode"}},"allFrames":{"type":"boolean","description":"If allFrames is <code>true</code>, implies that the JavaScript or CSS should be injected into all frames of current page. By default, it\'s <code>false</code> and is only injected into the top frame."},"matchAboutBlank":{"type":"boolean","description":"If matchAboutBlank is true, then the code is also injected in about:blank and about:srcdoc frames if your extension has access to its parent document. Code cannot be inserted in top-level about:-frames. By default it is <code>false</code>."},"runAt":{"allOf":[{"$ref":"extensionTypes#/types/RunAt"},{"description":"The soonest that the JavaScript or CSS will be injected into the tab. Defaults to \\"document_idle\\"."}]}},"required":["matches"]},"RegisteredContentScript":{"type":"object","description":"An object that represents a content script registered programmatically","functions":[{"name":"unregister","type":"function","description":"Unregister a content script registered programmatically","async":true,"parameters":[]}]}}}');

/***/ }),
/* 42 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"contextualIdentities","description":"Use the <code>browser.contextualIdentities</code> API to query and modify contextual identity, also called as containers.","permissions":["contextualIdentities"],"functions":[{"name":"get","type":"function","description":"Retrieves information about a single contextual identity.","async":true,"parameters":[{"type":"string","name":"cookieStoreId","description":"The ID of the contextual identity cookie store. "}]},{"name":"query","type":"function","description":"Retrieves all contextual identities","async":true,"parameters":[{"type":"object","name":"details","description":"Information to filter the contextual identities being retrieved.","properties":{"name":{"type":"string","description":"Filters the contextual identity by name."}}}]},{"name":"create","type":"function","description":"Creates a contextual identity with the given data.","async":true,"parameters":[{"type":"object","name":"details","description":"Details about the contextual identity being created.","properties":{"name":{"type":"string","description":"The name of the contextual identity."},"color":{"type":"string","description":"The color of the contextual identity."},"icon":{"type":"string","description":"The icon of the contextual identity."}},"required":["name","color","icon"]}]},{"name":"update","type":"function","description":"Updates a contextual identity with the given data.","async":true,"parameters":[{"type":"string","name":"cookieStoreId","description":"The ID of the contextual identity cookie store. "},{"type":"object","name":"details","description":"Details about the contextual identity being created.","properties":{"name":{"type":"string","description":"The name of the contextual identity."},"color":{"type":"string","description":"The color of the contextual identity."},"icon":{"type":"string","description":"The icon of the contextual identity."}}}]},{"name":"remove","type":"function","description":"Deletes a contetual identity by its cookie Store ID.","async":true,"parameters":[{"type":"string","name":"cookieStoreId","description":"The ID of the contextual identity cookie store. "}]}],"events":[{"name":"onUpdated","type":"function","description":"Fired when a container is updated.","parameters":[{"type":"object","name":"changeInfo","properties":{"contextualIdentity":{"allOf":[{"$ref":"#/types/ContextualIdentity"},{"description":"Contextual identity that has been updated"}]}},"required":["contextualIdentity"]}]},{"name":"onCreated","type":"function","description":"Fired when a new container is created.","parameters":[{"type":"object","name":"changeInfo","properties":{"contextualIdentity":{"allOf":[{"$ref":"#/types/ContextualIdentity"},{"description":"Contextual identity that has been created"}]}},"required":["contextualIdentity"]}]},{"name":"onRemoved","type":"function","description":"Fired when a container is removed.","parameters":[{"type":"object","name":"changeInfo","properties":{"contextualIdentity":{"allOf":[{"$ref":"#/types/ContextualIdentity"},{"description":"Contextual identity that has been removed"}]}},"required":["contextualIdentity"]}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["contextualIdentities"]}]}},"refs":{"contextualIdentities#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{"ContextualIdentity":{"type":"object","description":"Represents information about a contextual identity.","properties":{"name":{"type":"string","description":"The name of the contextual identity."},"icon":{"type":"string","description":"The icon name of the contextual identity."},"iconUrl":{"type":"string","description":"The icon url of the contextual identity."},"color":{"type":"string","description":"The color name of the contextual identity."},"colorCode":{"type":"string","description":"The color hash of the contextual identity."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."}},"required":["name","icon","iconUrl","color","colorCode","cookieStoreId"]}}}');

/***/ }),
/* 43 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"cookies","description":"Use the <code>browser.cookies</code> API to query and modify cookies, and to be notified when they change.","permissions":["cookies"],"functions":[{"name":"get","type":"function","description":"Retrieves information about a single cookie. If more than one cookie of the same name exists for the given URL, the one with the longest path will be returned. For cookies with the same path length, the cookie with the earliest creation time will be returned.","async":"callback","parameters":[{"type":"object","name":"details","description":"Details to identify the cookie being retrieved.","properties":{"url":{"type":"string","description":"The URL with which the cookie to retrieve is associated. This argument may be a full URL, in which case any data following the URL path (e.g. the query string) is simply ignored. If host permissions for this URL are not specified in the manifest file, the API call will fail."},"name":{"type":"string","description":"The name of the cookie to retrieve."},"storeId":{"type":"string","description":"The ID of the cookie store in which to look for the cookie. By default, the current execution context\'s cookie store will be used."},"firstPartyDomain":{"type":"string","description":"The first-party domain which the cookie to retrieve is associated. This attribute is required if First-Party Isolation is enabled."}},"required":["url","name"]},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Cookie"},{"name":"cookie","optional":true,"description":"Contains details about the cookie. This parameter is null if no such cookie was found."}]}]}]},{"name":"getAll","type":"function","description":"Retrieves all cookies from a single cookie store that match the given information.  The cookies returned will be sorted, with those with the longest path first.  If multiple cookies have the same path length, those with the earliest creation time will be first.","async":"callback","parameters":[{"type":"object","name":"details","description":"Information to filter the cookies being retrieved.","properties":{"url":{"type":"string","description":"Restricts the retrieved cookies to those that would match the given URL."},"name":{"type":"string","description":"Filters the cookies by name."},"domain":{"type":"string","description":"Restricts the retrieved cookies to those whose domains match or are subdomains of this one."},"path":{"type":"string","description":"Restricts the retrieved cookies to those whose path exactly matches this string."},"secure":{"type":"boolean","description":"Filters the cookies by their Secure property."},"session":{"type":"boolean","description":"Filters out session vs. persistent cookies."},"storeId":{"type":"string","description":"The cookie store to retrieve cookies from. If omitted, the current execution context\'s cookie store will be used."},"firstPartyDomain":{"type":"string","description":"Restricts the retrieved cookies to those whose first-party domains match this one. This attribute is required if First-Party Isolation is enabled. To not filter by a specific first-party domain, use `null` or `undefined`."}}},{"type":"function","name":"callback","parameters":[{"name":"cookies","type":"array","items":{"$ref":"#/types/Cookie"},"description":"All the existing, unexpired cookies that match the given cookie info."}]}]},{"name":"set","type":"function","description":"Sets a cookie with the given cookie data; may overwrite equivalent cookies if they exist.","async":"callback","parameters":[{"type":"object","name":"details","description":"Details about the cookie being set.","properties":{"url":{"type":"string","description":"The request-URI to associate with the setting of the cookie. This value can affect the default domain and path values of the created cookie. If host permissions for this URL are not specified in the manifest file, the API call will fail."},"name":{"type":"string","description":"The name of the cookie. Empty by default if omitted."},"value":{"type":"string","description":"The value of the cookie. Empty by default if omitted."},"domain":{"type":"string","description":"The domain of the cookie. If omitted, the cookie becomes a host-only cookie."},"path":{"type":"string","description":"The path of the cookie. Defaults to the path portion of the url parameter."},"secure":{"type":"boolean","description":"Whether the cookie should be marked as Secure. Defaults to false."},"httpOnly":{"type":"boolean","description":"Whether the cookie should be marked as HttpOnly. Defaults to false."},"sameSite":{"allOf":[{"$ref":"#/types/SameSiteStatus"},{"description":"The cookie\'s same-site status.","default":"no_restriction"}]},"expirationDate":{"type":"number","description":"The expiration date of the cookie as the number of seconds since the UNIX epoch. If omitted, the cookie becomes a session cookie."},"storeId":{"type":"string","description":"The ID of the cookie store in which to set the cookie. By default, the cookie is set in the current execution context\'s cookie store."},"firstPartyDomain":{"type":"string","description":"The first-party domain of the cookie. This attribute is required if First-Party Isolation is enabled."}},"required":["url"]},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Cookie"},{"name":"cookie","optional":true,"description":"Contains details about the cookie that\'s been set.  If setting failed for any reason, this will be \\"null\\", and $(ref:runtime.lastError) will be set."}]}]}]},{"name":"remove","type":"function","description":"Deletes a cookie by name.","async":"callback","parameters":[{"type":"object","name":"details","description":"Information to identify the cookie to remove.","properties":{"url":{"type":"string","description":"The URL associated with the cookie. If host permissions for this URL are not specified in the manifest file, the API call will fail."},"name":{"type":"string","description":"The name of the cookie to remove."},"storeId":{"type":"string","description":"The ID of the cookie store to look in for the cookie. If unspecified, the cookie is looked for by default in the current execution context\'s cookie store."},"firstPartyDomain":{"type":"string","description":"The first-party domain associated with the cookie. This attribute is required if First-Party Isolation is enabled."}},"required":["url","name"]},{"type":"function","name":"callback","optional":true,"parameters":[{"name":"details","type":"object","description":"Contains details about the cookie that\'s been removed.  If removal failed for any reason, this will be \\"null\\", and $(ref:runtime.lastError) will be set.","optional":true,"properties":{"url":{"type":"string","description":"The URL associated with the cookie that\'s been removed."},"name":{"type":"string","description":"The name of the cookie that\'s been removed."},"storeId":{"type":"string","description":"The ID of the cookie store from which the cookie was removed."},"firstPartyDomain":{"type":"string","description":"The first-party domain associated with the cookie that\'s been removed."}},"required":["url","name","storeId","firstPartyDomain"]}]}]},{"name":"getAllCookieStores","type":"function","description":"Lists all existing cookie stores.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"cookieStores","type":"array","items":{"$ref":"#/types/CookieStore"},"description":"All the existing cookie stores."}]}]}],"events":[{"name":"onChanged","type":"function","description":"Fired when a cookie is set or removed. As a special case, note that updating a cookie\'s properties is implemented as a two step process: the cookie to be updated is first removed entirely, generating a notification with \\"cause\\" of \\"overwrite\\" .  Afterwards, a new cookie is written with the updated values, generating a second notification with \\"cause\\" \\"explicit\\".","parameters":[{"type":"object","name":"changeInfo","properties":{"removed":{"type":"boolean","description":"True if a cookie was removed."},"cookie":{"allOf":[{"$ref":"#/types/Cookie"},{"description":"Information about the cookie that was set or removed."}]},"cause":{"allOf":[{"$ref":"#/types/OnChangedCause"},{"description":"The underlying reason behind the cookie\'s change."}]}},"required":["removed","cookie","cause"]}]}],"definitions":{"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["cookies"]}]}},"refs":{"cookies#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"}},"types":{"SameSiteStatus":{"type":"string","enum":["no_restriction","lax","strict"],"description":"A cookie\'s \'SameSite\' state (https://tools.ietf.org/html/draft-west-first-party-cookies). \'no_restriction\' corresponds to a cookie set without a \'SameSite\' attribute, \'lax\' to \'SameSite=Lax\', and \'strict\' to \'SameSite=Strict\'."},"Cookie":{"type":"object","description":"Represents information about an HTTP cookie.","properties":{"name":{"type":"string","description":"The name of the cookie."},"value":{"type":"string","description":"The value of the cookie."},"domain":{"type":"string","description":"The domain of the cookie (e.g. \\"www.google.com\\", \\"example.com\\")."},"hostOnly":{"type":"boolean","description":"True if the cookie is a host-only cookie (i.e. a request\'s host must exactly match the domain of the cookie)."},"path":{"type":"string","description":"The path of the cookie."},"secure":{"type":"boolean","description":"True if the cookie is marked as Secure (i.e. its scope is limited to secure channels, typically HTTPS)."},"httpOnly":{"type":"boolean","description":"True if the cookie is marked as HttpOnly (i.e. the cookie is inaccessible to client-side scripts)."},"sameSite":{"allOf":[{"$ref":"#/types/SameSiteStatus"},{"description":"The cookie\'s same-site status (i.e. whether the cookie is sent with cross-site requests)."}]},"session":{"type":"boolean","description":"True if the cookie is a session cookie, as opposed to a persistent cookie with an expiration date."},"expirationDate":{"type":"number","description":"The expiration date of the cookie as the number of seconds since the UNIX epoch. Not provided for session cookies."},"storeId":{"type":"string","description":"The ID of the cookie store containing this cookie, as provided in getAllCookieStores()."},"firstPartyDomain":{"type":"string","description":"The first-party domain of the cookie."}},"required":["name","value","domain","hostOnly","path","secure","httpOnly","sameSite","session","storeId","firstPartyDomain"]},"CookieStore":{"type":"object","description":"Represents a cookie store in the browser. An incognito mode window, for instance, uses a separate cookie store from a non-incognito window.","properties":{"id":{"type":"string","description":"The unique identifier for the cookie store."},"tabIds":{"type":"array","items":{"type":"integer"},"description":"Identifiers of all the browser tabs that share this cookie store."},"incognito":{"type":"boolean","description":"Indicates if this is an incognito cookie store"}},"required":["id","tabIds","incognito"]},"OnChangedCause":{"type":"string","enum":["evicted","expired","explicit","expired_overwrite","overwrite"],"description":"The underlying reason behind the cookie\'s change. If a cookie was inserted, or removed via an explicit call to $(ref:cookies.remove), \\"cause\\" will be \\"explicit\\". If a cookie was automatically removed due to expiry, \\"cause\\" will be \\"expired\\". If a cookie was removed due to being overwritten with an already-expired expiration date, \\"cause\\" will be set to \\"expired_overwrite\\".  If a cookie was automatically removed due to garbage collection, \\"cause\\" will be \\"evicted\\".  If a cookie was automatically removed due to a \\"set\\" call that overwrote it, \\"cause\\" will be \\"overwrite\\". Plan your response accordingly."}}}');

/***/ }),
/* 44 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"devtools","permissions":["manifest:devtools_page"],"allowedContexts":["devtools","devtools_only"],"defaultContexts":["devtools","devtools_only"],"definitions":{"WebExtensionManifest":{"properties":{"devtools_page":{"$ref":"manifest#/types/ExtensionURL"}}},"OptionalPermission":{"anyOf":[{"type":"string","enum":["devtools"]}]}},"refs":{"devtools#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"},"devtools#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"Resource":{"type":"object","description":"A resource within the inspected page, such as a document, a script, or an image.","properties":{"url":{"type":"string","description":"The URL of the resource."}},"functions":[{"name":"getContent","unsupported":true,"type":"function","async":"callback","description":"Gets the content of the resource.","parameters":[{"name":"callback","type":"function","description":"A function that receives resource content when the request completes.","parameters":[{"name":"content","type":"string","description":"Content of the resource (potentially encoded)."},{"name":"encoding","type":"string","description":"Empty if content is not encoded, encoding name otherwise. Currently, only base64 is supported."}]}]},{"name":"setContent","unsupported":true,"type":"function","async":"callback","description":"Sets the content of the resource.","parameters":[{"name":"content","type":"string","description":"New content of the resource. Only resources with the text type are currently supported."},{"name":"commit","type":"boolean","description":"True if the user has finished editing the resource, and the new content of the resource should be persisted; false if this is a minor change sent in progress of the user editing the resource."},{"name":"callback","type":"function","description":"A function called upon request completion.","optional":true,"parameters":[{"name":"error","type":"object","additionalProperties":{},"optional":true,"description":"Set to undefined if the resource content was set successfully; describes error otherwise."}]}]}],"required":["url"]},"Request":{"type":"object","description":"Represents a network request for a document resource (script, image and so on). See HAR Specification for reference.","functions":[{"name":"getContent","type":"function","description":"Returns content of the response body.","async":"callback","parameters":[{"name":"callback","type":"function","description":"A function that receives the response body when the request completes.","parameters":[{"name":"content","type":"string","description":"Content of the response body (potentially encoded)."},{"name":"encoding","type":"string","description":"Empty if content is not encoded, encoding name otherwise. Currently, only base64 is supported."}]}]}]},"ElementsPanel":{"type":"object","description":"Represents the Elements panel.","events":[{"name":"onSelectionChanged","type":"function","description":"Fired when an object is selected in the panel."}],"functions":[{"name":"createSidebarPane","async":"callback","type":"function","description":"Creates a pane within panel\'s sidebar.","parameters":[{"name":"title","type":"string","description":"Text that is displayed in sidebar caption."},{"name":"callback","type":"function","description":"A callback invoked when the sidebar is created.","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/ExtensionSidebarPane"},{"name":"result","description":"An ExtensionSidebarPane object for created sidebar pane."}]}]}]}]},"SourcesPanel":{"type":"object","description":"Represents the Sources panel.","events":[{"name":"onSelectionChanged","unsupported":true,"description":"Fired when an object is selected in the panel."}],"functions":[{"name":"createSidebarPane","unsupported":true,"type":"function","description":"Creates a pane within panel\'s sidebar.","parameters":[{"name":"title","type":"string","description":"Text that is displayed in sidebar caption."},{"name":"callback","type":"function","description":"A callback invoked when the sidebar is created.","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/ExtensionSidebarPane"},{"name":"result","description":"An ExtensionSidebarPane object for created sidebar pane."}]}]}]}]},"ExtensionPanel":{"type":"object","description":"Represents a panel created by extension.","functions":[{"name":"createStatusBarButton","unsupported":true,"description":"Appends a button to the status bar of the panel.","type":"function","parameters":[{"name":"iconPath","type":"string","description":"Path to the icon of the button. The file should contain a 64x24-pixel image composed of two 32x24 icons. The left icon is used when the button is inactive; the right icon is displayed when the button is pressed."},{"name":"tooltipText","type":"string","description":"Text shown as a tooltip when user hovers the mouse over the button."},{"name":"disabled","type":"boolean","description":"Whether the button is disabled."}],"returns":{"$ref":"#/types/Button"}}],"events":[{"name":"onSearch","unsupported":true,"description":"Fired upon a search action (start of a new search, search result navigation, or search being canceled).","parameters":[{"name":"action","type":"string","description":"Type of search action being performed."},{"name":"queryString","type":"string","optional":true,"description":"Query string (only for \'performSearch\')."}]},{"name":"onShown","type":"function","description":"Fired when the user switches to the panel.","parameters":[{"name":"window","type":"object","isInstanceOf":"global","additionalProperties":{},"description":"The JavaScript <code>window</code> object of panel\'s page."}]},{"name":"onHidden","type":"function","description":"Fired when the user switches away from the panel."}]},"ExtensionSidebarPane":{"type":"object","description":"A sidebar created by the extension.","functions":[{"name":"setHeight","unsupported":true,"type":"function","description":"Sets the height of the sidebar.","parameters":[{"name":"height","type":"string","description":"A CSS-like size specification, such as <code>\'100px\'</code> or <code>\'12ex\'</code>."}]},{"name":"setExpression","async":"callback","type":"function","description":"Sets an expression that is evaluated within the inspected page. The result is displayed in the sidebar pane.","parameters":[{"name":"expression","type":"string","description":"An expression to be evaluated in context of the inspected page. JavaScript objects and DOM nodes are displayed in an expandable tree similar to the console/watch."},{"name":"rootTitle","type":"string","optional":true,"description":"An optional title for the root of the expression tree."},{"name":"callback","type":"function","optional":true,"description":"A callback invoked after the sidebar pane is updated with the expression evaluation results."}]},{"name":"setObject","async":"callback","type":"function","description":"Sets a JSON-compliant object to be displayed in the sidebar pane.","parameters":[{"name":"jsonObject","type":"string","description":"An object to be displayed in context of the inspected page. Evaluated in the context of the caller (API client)."},{"name":"rootTitle","type":"string","optional":true,"description":"An optional title for the root of the expression tree."},{"name":"callback","type":"function","optional":true,"description":"A callback invoked after the sidebar is updated with the object."}]},{"name":"setPage","type":"function","async":true,"description":"Sets an HTML page to be displayed in the sidebar pane.","parameters":[{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"name":"path","description":"Relative path of an extension page to display within the sidebar."}]}]}],"events":[{"name":"onShown","type":"function","description":"Fired when the sidebar pane becomes visible as a result of user switching to the panel that hosts it.","parameters":[{"name":"window","type":"object","isInstanceOf":"global","additionalProperties":{},"description":"The JavaScript <code>window</code> object of the sidebar page, if one was set with the <code>setPage()</code> method."}]},{"name":"onHidden","type":"function","description":"Fired when the sidebar pane becomes hidden as a result of the user switching away from the panel that hosts the sidebar pane."}]},"Button":{"type":"object","description":"A button created by the extension.","functions":[{"name":"update","unsupported":true,"type":"function","description":"Updates the attributes of the button. If some of the arguments are omitted or <code>null</code>, the corresponding attributes are not updated.","parameters":[{"name":"iconPath","type":"string","optional":true,"description":"Path to the new icon of the button."},{"name":"tooltipText","type":"string","optional":true,"description":"Text shown as a tooltip when user hovers the mouse over the button."},{"name":"disabled","type":"boolean","optional":true,"description":"Whether the button is disabled."}]}],"events":[{"name":"onClicked","unsupported":true,"type":"function","description":"Fired when the button is clicked."}]}},"properties":{"inspectedWindow":{"allowedContexts":["devtools","devtools_only"],"defaultContexts":["devtools","devtools_only"],"description":"Use the <code>chrome.devtools.inspectedWindow</code> API to interact with the inspected window: obtain the tab ID for the inspected page, evaluate the code in the context of the inspected window, reload the page, or obtain the list of resources within the page.","nocompile":true,"properties":{"tabId":{"description":"The ID of the tab being inspected. This ID may be used with chrome.tabs.* API.","type":"integer"}},"functions":[{"name":"eval","type":"function","description":"Evaluates a JavaScript expression in the context of the main frame of the inspected page. The expression must evaluate to a JSON-compliant object, otherwise an exception is thrown. The eval function can report either a DevTools-side error or a JavaScript exception that occurs during evaluation. In either case, the <code>result</code> parameter of the callback is <code>undefined</code>. In the case of a DevTools-side error, the <code>isException</code> parameter is non-null and has <code>isError</code> set to true and <code>code</code> set to an error code. In the case of a JavaScript error, <code>isException</code> is set to true and <code>value</code> is set to the string value of thrown object.","async":"callback","parameters":[{"name":"expression","type":"string","description":"An expression to evaluate."},{"name":"options","type":"object","optional":true,"description":"The options parameter can contain one or more options.","properties":{"frameURL":{"type":"string","unsupported":true,"description":"If specified, the expression is evaluated on the iframe whose URL matches the one specified. By default, the expression is evaluated in the top frame of the inspected page."},"useContentScriptContext":{"type":"boolean","unsupported":true,"description":"Evaluate the expression in the context of the content script of the calling extension, provided that the content script is already injected into the inspected page. If not, the expression is not evaluated and the callback is invoked with the exception parameter set to an object that has the <code>isError</code> field set to true and the <code>code</code> field set to <code>E_NOTFOUND</code>."},"contextSecurityOrigin":{"type":"string","unsupported":true,"description":"Evaluate the expression in the context of a content script of an extension that matches the specified origin. If given, contextSecurityOrigin overrides the \'true\' setting on userContentScriptContext."}}},{"name":"callback","type":"function","description":"A function called when evaluation completes.","optional":true,"parameters":[{"name":"result","description":"The result of evaluation."},{"name":"exceptionInfo","type":"object","optional":true,"description":"An object providing details if an exception occurred while evaluating the expression.","properties":{"isError":{"type":"boolean","description":"Set if the error occurred on the DevTools side before the expression is evaluated."},"code":{"type":"string","description":"Set if the error occurred on the DevTools side before the expression is evaluated."},"description":{"type":"string","description":"Set if the error occurred on the DevTools side before the expression is evaluated."},"details":{"type":"array","items":{},"description":"Set if the error occurred on the DevTools side before the expression is evaluated, contains the array of the values that may be substituted into the description string to provide more information about the cause of the error."},"isException":{"type":"boolean","description":"Set if the evaluated code produces an unhandled exception."},"value":{"type":"string","description":"Set if the evaluated code produces an unhandled exception."}},"required":["isError","code","description","details","isException","value"]}]}]},{"name":"reload","type":"function","description":"Reloads the inspected page.","parameters":[{"type":"object","name":"reloadOptions","optional":true,"properties":{"ignoreCache":{"type":"boolean","description":"When true, the loader will bypass the cache for all inspected page resources loaded before the <code>load</code> event is fired. The effect is similar to pressing Ctrl+Shift+R in the inspected window or within the Developer Tools window."},"userAgent":{"type":"string","description":"If specified, the string will override the value of the <code>User-Agent</code> HTTP header that\'s sent while loading the resources of the inspected page. The string will also override the value of the <code>navigator.userAgent</code> property that\'s returned to any scripts that are running within the inspected page."},"injectedScript":{"type":"string","description":"If specified, the script will be injected into every frame of the inspected page immediately upon load, before any of the frame\'s scripts. The script will not be injected after subsequent reloads&mdash;for example, if the user presses Ctrl+R."},"preprocessorScript":{"unsupported":true,"type":"string","deprecated":"Please avoid using this parameter, it will be removed soon.","description":"If specified, this script evaluates into a function that accepts three string arguments: the source to preprocess, the URL of the source, and a function name if the source is an DOM event handler. The preprocessorerScript function should return a string to be compiled by Chrome in place of the input source. In the case that the source is a DOM event handler, the returned source must compile to a single JS function."}}}]},{"name":"getResources","unsupported":true,"type":"function","description":"Retrieves the list of resources from the inspected page.","async":"callback","parameters":[{"name":"callback","type":"function","description":"A function that receives the list of resources when the request completes.","parameters":[{"name":"resources","type":"array","items":{"$ref":"#/types/Resource"},"description":"The resources within the page."}]}]}],"events":[{"name":"onResourceAdded","unsupported":true,"type":"function","description":"Fired when a new resource is added to the inspected page.","parameters":[{"allOf":[{"$ref":"#/types/Resource"},{"name":"resource"}]}]},{"name":"onResourceContentCommitted","unsupported":true,"type":"function","description":"Fired when a new revision of the resource is committed (e.g. user saves an edited version of the resource in the Developer Tools).","parameters":[{"allOf":[{"$ref":"#/types/Resource"},{"name":"resource"}]},{"name":"content","type":"string","description":"New content of the resource."}]}],"required":["tabId"]},"network":{"allowedContexts":["devtools","devtools_only"],"defaultContexts":["devtools","devtools_only"],"description":"Use the <code>chrome.devtools.network</code> API to retrieve the information about network requests displayed by the Developer Tools in the Network panel.","functions":[{"name":"getHAR","type":"function","description":"Returns HAR log that contains all known network requests.","async":"callback","parameters":[{"name":"callback","type":"function","description":"A function that receives the HAR log when the request completes.","parameters":[{"name":"harLog","type":"object","additionalProperties":{},"description":"A HAR log. See HAR specification for details."}]}]}],"events":[{"name":"onRequestFinished","type":"function","description":"Fired when a network request is finished and all request data are available.","parameters":[{"allOf":[{"$ref":"#/types/Request"},{"name":"request","description":"Description of a network request in the form of a HAR entry. See HAR specification for details."}]}]},{"name":"onNavigated","type":"function","description":"Fired when the inspected window navigates to a new page.","parameters":[{"name":"url","type":"string","description":"URL of the new page."}]}]},"panels":{"allowedContexts":["devtools","devtools_only"],"defaultContexts":["devtools","devtools_only"],"description":"Use the <code>chrome.devtools.panels</code> API to integrate your extension into Developer Tools window UI: create your own panels, access existing panels, and add sidebars.","nocompile":true,"properties":{"elements":{"allOf":[{"$ref":"#/types/ElementsPanel"},{"description":"Elements panel."}]},"sources":{"allOf":[{"$ref":"#/types/SourcesPanel"},{"description":"Sources panel."}]},"themeName":{"type":"string","description":"The name of the current devtools theme."}},"functions":[{"name":"create","type":"function","description":"Creates an extension panel.","async":"callback","parameters":[{"name":"title","type":"string","description":"Title that is displayed next to the extension icon in the Developer Tools toolbar."},{"name":"iconPath","description":"Path of the panel\'s icon relative to the extension directory, or an empty string to use the default extension icon as the panel icon.","anyOf":[{"type":"string","enum":[""]},{"$ref":"manifest#/types/ExtensionURL"}]},{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"name":"pagePath","description":"Path of the panel\'s HTML page relative to the extension directory."}]},{"name":"callback","type":"function","optional":true,"description":"A function that is called when the panel is created.","parameters":[{"allOf":[{"$ref":"#/types/ExtensionPanel"},{"name":"panel","description":"An ExtensionPanel object representing the created panel."}]}]}]},{"name":"setOpenResourceHandler","unsupported":true,"type":"function","description":"Specifies the function to be called when the user clicks a resource link in the Developer Tools window. To unset the handler, either call the method with no parameters or pass null as the parameter.","async":"callback","parameters":[{"name":"callback","type":"function","optional":true,"description":"A function that is called when the user clicks on a valid resource link in Developer Tools window. Note that if the user clicks an invalid URL or an XHR, this function is not called.","parameters":[{"allOf":[{"$ref":"devtools#/types/inspectedWindow"},{"name":"resource","description":"A $(ref:devtools.inspectedWindow.Resource) object for the resource that was clicked."}]}]}]},{"name":"openResource","unsupported":true,"type":"function","description":"Requests DevTools to open a URL in a Developer Tools panel.","async":"callback","parameters":[{"name":"url","type":"string","description":"The URL of the resource to open."},{"name":"lineNumber","type":"integer","description":"Specifies the line number to scroll to when the resource is loaded."},{"name":"callback","type":"function","optional":true,"description":"A function that is called when the resource has been successfully loaded."}]}],"events":[{"name":"onThemeChanged","type":"function","description":"Fired when the devtools theme changes.","parameters":[{"name":"themeName","type":"string","description":"The name of the current devtools theme."}]}],"required":["elements","sources","themeName"]}}}');

/***/ }),
/* 45 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"dns","description":"Asynchronous DNS API","permissions":["dns"],"functions":[{"name":"resolve","type":"function","description":"Resolves a hostname to a DNS record.","async":true,"parameters":[{"name":"hostname","type":"string"},{"allOf":[{"$ref":"#/types/ResolveFlags"},{"name":"flags","optional":true,"default":[]}]}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["dns"]}]}},"refs":{"dns#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{"DNSRecord":{"type":"object","description":"An object encapsulating a DNS Record.","properties":{"canonicalName":{"type":"string","description":"The canonical hostname for this record.  this value is empty if the record was not fetched with the \'canonical_name\' flag."},"isTRR":{"type":"string","description":"Record retreived with TRR."},"addresses":{"type":"array","items":{"type":"string"}}},"required":["isTRR","addresses"]},"ResolveFlags":{"type":"array","items":{"type":"string","enum":["allow_name_collisions","bypass_cache","canonical_name","disable_ipv4","disable_ipv6","disable_trr","offline","priority_low","priority_medium","speculate"]}}}}');

/***/ }),
/* 46 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"downloads","permissions":["downloads"],"functions":[{"name":"download","type":"function","async":"callback","description":"Download a URL. If the URL uses the HTTP[S] protocol, then the request will include all cookies currently set for its hostname. If both <code>filename</code> and <code>saveAs</code> are specified, then the Save As dialog will be displayed, pre-populated with the specified <code>filename</code>. If the download started successfully, <code>callback</code> will be called with the new <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>downloadId</code>. If there was an error starting the download, then <code>callback</code> will be called with <code>downloadId=undefined</code> and <a href=\'extension.html#property-lastError\'>chrome.extension.lastError</a> will contain a descriptive string. The error strings are not guaranteed to remain backwards compatible between releases. You must not parse it.","parameters":[{"description":"What to download and how.","name":"options","type":"object","properties":{"url":{"description":"The URL to download.","type":"string","format":"url"},"filename":{"description":"A file path relative to the Downloads directory to contain the downloaded file.","type":"string"},"incognito":{"description":"Whether to associate the download with a private browsing session.","default":false,"type":"boolean"},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity; requires \\"cookies\\" permission."},"conflictAction":{"$ref":"#/types/FilenameConflictAction"},"saveAs":{"description":"Use a file-chooser to allow the user to select a filename. If the option is not specified, the file chooser will be shown only if the Firefox \\"Always ask you where to save files\\" option is enabled (i.e. the pref <code>browser.download.useDownloadDir</code> is set to <code>false</code>).","type":"boolean"},"method":{"description":"The HTTP method to use if the URL uses the HTTP[S] protocol.","enum":["GET","POST"],"type":"string"},"headers":{"type":"array","description":"Extra HTTP headers to send with the request if the URL uses the HTTP[s] protocol. Each header is represented as a dictionary containing the keys <code>name</code> and either <code>value</code> or <code>binaryValue</code>, restricted to those allowed by XMLHttpRequest.","items":{"type":"object","properties":{"name":{"description":"Name of the HTTP header.","type":"string"},"value":{"description":"Value of the HTTP header.","type":"string"}},"required":["name","value"]}},"body":{"description":"Post body.","type":"string"},"allowHttpErrors":{"description":"When this flag is set to <code>true</code>, then the browser will allow downloads to proceed after encountering HTTP errors such as <code>404 Not Found</code>.","default":false,"type":"boolean"}},"required":["url"]},{"name":"callback","type":"function","optional":true,"parameters":[{"name":"downloadId","type":"integer"}]}]},{"name":"search","type":"function","async":"callback","description":"Find <a href=\'#type-DownloadItem\'>DownloadItems</a>. Set <code>query</code> to the empty object to get all <a href=\'#type-DownloadItem\'>DownloadItems</a>. To get a specific <a href=\'#type-DownloadItem\'>DownloadItem</a>, set only the <code>id</code> field.","parameters":[{"allOf":[{"$ref":"#/types/DownloadQuery"},{"name":"query"}]},{"name":"callback","type":"function","parameters":[{"items":{"$ref":"#/types/DownloadItem"},"name":"results","type":"array"}]}]},{"name":"pause","type":"function","async":"callback","description":"Pause the download. If the request was successful the download is in a paused state. Otherwise <a href=\'extension.html#property-lastError\'>chrome.extension.lastError</a> contains an error message. The request will fail if the download is not active.","parameters":[{"description":"The id of the download to pause.","name":"downloadId","type":"integer"},{"name":"callback","optional":true,"parameters":[],"type":"function"}]},{"name":"resume","type":"function","async":"callback","description":"Resume a paused download. If the request was successful the download is in progress and unpaused. Otherwise <a href=\'extension.html#property-lastError\'>chrome.extension.lastError</a> contains an error message. The request will fail if the download is not active.","parameters":[{"description":"The id of the download to resume.","name":"downloadId","type":"integer"},{"name":"callback","optional":true,"parameters":[],"type":"function"}]},{"name":"cancel","type":"function","async":"callback","description":"Cancel a download. When <code>callback</code> is run, the download is cancelled, completed, interrupted or doesn\'t exist anymore.","parameters":[{"description":"The id of the download to cancel.","name":"downloadId","type":"integer"},{"name":"callback","optional":true,"parameters":[],"type":"function"}]},{"name":"getFileIcon","type":"function","async":"callback","description":"Retrieve an icon for the specified download. For new downloads, file icons are available after the <a href=\'#event-onCreated\'>onCreated</a> event has been received. The image returned by this function while a download is in progress may be different from the image returned after the download is complete. Icon retrieval is done by querying the underlying operating system or toolkit depending on the platform. The icon that is returned will therefore depend on a number of factors including state of the download, platform, registered file types and visual theme. If a file icon cannot be determined, <a href=\'extension.html#property-lastError\'>chrome.extension.lastError</a> will contain an error message.","parameters":[{"description":"The identifier for the download.","name":"downloadId","type":"integer"},{"name":"options","optional":true,"properties":{"size":{"description":"The size of the icon.  The returned icon will be square with dimensions size * size pixels.  The default size for the icon is 32x32 pixels.","minimum":1,"maximum":127,"type":"integer"}},"type":"object"},{"name":"callback","parameters":[{"name":"iconURL","optional":true,"type":"string"}],"type":"function"}]},{"name":"open","type":"function","async":"callback","requireUserInput":true,"description":"Open the downloaded file.","permissions":["downloads.open"],"parameters":[{"name":"downloadId","type":"integer"},{"name":"callback","type":"function","optional":true,"parameters":[]}]},{"name":"show","type":"function","description":"Show the downloaded file in its folder in a file manager.","async":"callback","parameters":[{"name":"downloadId","type":"integer"},{"name":"callback","type":"function","optional":true,"parameters":[{"name":"success","type":"boolean"}]}]},{"name":"showDefaultFolder","type":"function","parameters":[]},{"name":"erase","type":"function","async":"callback","description":"Erase matching <a href=\'#type-DownloadItem\'>DownloadItems</a> from history","parameters":[{"allOf":[{"$ref":"#/types/DownloadQuery"},{"name":"query"}]},{"name":"callback","type":"function","optional":true,"parameters":[{"items":{"type":"integer"},"name":"erasedIds","type":"array"}]}]},{"name":"removeFile","async":"callback","type":"function","parameters":[{"name":"downloadId","type":"integer"},{"name":"callback","type":"function","optional":true,"parameters":[]}]},{"description":"Prompt the user to either accept or cancel a dangerous download. <code>acceptDanger()</code> does not automatically accept dangerous downloads.","name":"acceptDanger","unsupported":true,"parameters":[{"name":"downloadId","type":"integer"},{"name":"callback","type":"function","optional":true,"parameters":[]}],"type":"function"},{"description":"Initiate dragging the file to another application.","name":"drag","unsupported":true,"parameters":[{"name":"downloadId","type":"integer"}],"type":"function"},{"name":"setShelfEnabled","type":"function","unsupported":true,"parameters":[{"name":"enabled","type":"boolean"}]}],"events":[{"description":"This event fires with the <a href=\'#type-DownloadItem\'>DownloadItem</a> object when a download begins.","name":"onCreated","parameters":[{"allOf":[{"$ref":"#/types/DownloadItem"},{"name":"downloadItem"}]}],"type":"function"},{"description":"Fires with the <code>downloadId</code> when a download is erased from history.","name":"onErased","parameters":[{"name":"downloadId","description":"The <code>id</code> of the <a href=\'#type-DownloadItem\'>DownloadItem</a> that was erased.","type":"integer"}],"type":"function"},{"name":"onChanged","description":"When any of a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s properties except <code>bytesReceived</code> changes, this event fires with the <code>downloadId</code> and an object containing the properties that changed.","parameters":[{"name":"downloadDelta","type":"object","properties":{"id":{"description":"The <code>id</code> of the <a href=\'#type-DownloadItem\'>DownloadItem</a> that changed.","type":"integer"},"url":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>url</code>."}]},"filename":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>filename</code>."}]},"danger":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>danger</code>."}]},"mime":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>mime</code>."}]},"startTime":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>startTime</code>."}]},"endTime":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>endTime</code>."}]},"state":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>state</code>."}]},"canResume":{"$ref":"#/types/BooleanDelta"},"paused":{"allOf":[{"$ref":"#/types/BooleanDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>paused</code>."}]},"error":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>error</code>."}]},"totalBytes":{"allOf":[{"$ref":"#/types/DoubleDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>totalBytes</code>."}]},"fileSize":{"allOf":[{"$ref":"#/types/DoubleDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>fileSize</code>."}]},"exists":{"$ref":"#/types/BooleanDelta"}},"required":["id"]}],"type":"function"}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["downloads","downloads.open"]}]}},"refs":{"downloads#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"FilenameConflictAction":{"type":"string","enum":["uniquify","overwrite","prompt"]},"InterruptReason":{"type":"string","enum":["FILE_FAILED","FILE_ACCESS_DENIED","FILE_NO_SPACE","FILE_NAME_TOO_LONG","FILE_TOO_LARGE","FILE_VIRUS_INFECTED","FILE_TRANSIENT_ERROR","FILE_BLOCKED","FILE_SECURITY_CHECK_FAILED","FILE_TOO_SHORT","NETWORK_FAILED","NETWORK_TIMEOUT","NETWORK_DISCONNECTED","NETWORK_SERVER_DOWN","NETWORK_INVALID_REQUEST","SERVER_FAILED","SERVER_NO_RANGE","SERVER_BAD_CONTENT","SERVER_UNAUTHORIZED","SERVER_CERT_PROBLEM","SERVER_FORBIDDEN","USER_CANCELED","USER_SHUTDOWN","CRASH"]},"DangerType":{"type":"string","enum":["file","url","content","uncommon","host","unwanted","safe","accepted"],"description":"<dl><dt>file</dt><dd>The download\'s filename is suspicious.</dd><dt>url</dt><dd>The download\'s URL is known to be malicious.</dd><dt>content</dt><dd>The downloaded file is known to be malicious.</dd><dt>uncommon</dt><dd>The download\'s URL is not commonly downloaded and could be dangerous.</dd><dt>safe</dt><dd>The download presents no known danger to the user\'s computer.</dd></dl>These string constants will never change, however the set of DangerTypes may change."},"State":{"type":"string","enum":["in_progress","interrupted","complete"],"description":"<dl><dt>in_progress</dt><dd>The download is currently receiving data from the server.</dd><dt>interrupted</dt><dd>An error broke the connection with the file host.</dd><dt>complete</dt><dd>The download completed successfully.</dd></dl>These string constants will never change, however the set of States may change."},"DownloadItem":{"type":"object","properties":{"id":{"description":"An identifier that is persistent across browser sessions.","type":"integer"},"url":{"description":"Absolute URL.","type":"string"},"referrer":{"type":"string"},"filename":{"description":"Absolute local path.","type":"string"},"incognito":{"description":"False if this download is recorded in the history, true if it is not recorded.","type":"boolean"},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"danger":{"allOf":[{"$ref":"#/types/DangerType"},{"description":"Indication of whether this download is thought to be safe or known to be suspicious."}]},"mime":{"description":"The file\'s MIME type.","type":"string"},"startTime":{"description":"Number of milliseconds between the unix epoch and when this download began.","type":"string"},"endTime":{"description":"Number of milliseconds between the unix epoch and when this download ended.","type":"string"},"estimatedEndTime":{"type":"string"},"state":{"allOf":[{"$ref":"#/types/State"},{"description":"Indicates whether the download is progressing, interrupted, or complete."}]},"paused":{"description":"True if the download has stopped reading data from the host, but kept the connection open.","type":"boolean"},"canResume":{"type":"boolean"},"error":{"allOf":[{"$ref":"#/types/InterruptReason"},{"description":"Number indicating why a download was interrupted."}]},"bytesReceived":{"description":"Number of bytes received so far from the host, without considering file compression.","type":"number"},"totalBytes":{"description":"Number of bytes in the whole file, without considering file compression, or -1 if unknown.","type":"number"},"fileSize":{"description":"Number of bytes in the whole file post-decompression, or -1 if unknown.","type":"number"},"exists":{"type":"boolean"},"byExtensionId":{"type":"string"},"byExtensionName":{"type":"string"}},"required":["id","url","filename","incognito","danger","startTime","state","paused","canResume","bytesReceived","totalBytes","fileSize","exists"]},"StringDelta":{"type":"object","properties":{"current":{"type":"string"},"previous":{"type":"string"}}},"DoubleDelta":{"type":"object","properties":{"current":{"type":"number"},"previous":{"type":"number"}}},"BooleanDelta":{"type":"object","properties":{"current":{"type":"boolean"},"previous":{"type":"boolean"}}},"DownloadTime":{"description":"A time specified as a Date object, a number or string representing milliseconds since the epoch, or an ISO 8601 string","anyOf":[{"type":"string","pattern":"^[1-9]\\\\d*$"},{"$ref":"extensionTypes#/types/Date"}]},"DownloadQuery":{"description":"Parameters that combine to specify a predicate that can be used to select a set of downloads.  Used for example in search() and erase()","type":"object","properties":{"query":{"description":"This array of search terms limits results to <a href=\'#type-DownloadItem\'>DownloadItems</a> whose <code>filename</code> or <code>url</code> contain all of the search terms that do not begin with a dash \'-\' and none of the search terms that do begin with a dash.","type":"array","items":{"type":"string"}},"startedBefore":{"allOf":[{"$ref":"#/types/DownloadTime"},{"description":"Limits results to downloads that started before the given ms since the epoch."}]},"startedAfter":{"allOf":[{"$ref":"#/types/DownloadTime"},{"description":"Limits results to downloads that started after the given ms since the epoch."}]},"endedBefore":{"allOf":[{"$ref":"#/types/DownloadTime"},{"description":"Limits results to downloads that ended before the given ms since the epoch."}]},"endedAfter":{"allOf":[{"$ref":"#/types/DownloadTime"},{"description":"Limits results to downloads that ended after the given ms since the epoch."}]},"totalBytesGreater":{"description":"Limits results to downloads whose totalBytes is greater than the given integer.","type":"number"},"totalBytesLess":{"description":"Limits results to downloads whose totalBytes is less than the given integer.","type":"number"},"filenameRegex":{"description":"Limits results to <a href=\'#type-DownloadItem\'>DownloadItems</a> whose <code>filename</code> matches the given regular expression.","type":"string"},"urlRegex":{"description":"Limits results to <a href=\'#type-DownloadItem\'>DownloadItems</a> whose <code>url</code> matches the given regular expression.","type":"string"},"limit":{"description":"Setting this integer limits the number of results. Otherwise, all matching <a href=\'#type-DownloadItem\'>DownloadItems</a> will be returned.","type":"integer"},"orderBy":{"description":"Setting elements of this array to <a href=\'#type-DownloadItem\'>DownloadItem</a> properties in order to sort the search results. For example, setting <code>orderBy=\'startTime\'</code> sorts the <a href=\'#type-DownloadItem\'>DownloadItems</a> by their start time in ascending order. To specify descending order, prefix <code>orderBy</code> with a hyphen: \'-startTime\'.","type":"array","items":{"type":"string"}},"id":{"type":"integer"},"url":{"description":"Absolute URL.","type":"string"},"filename":{"description":"Absolute local path.","type":"string"},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"danger":{"allOf":[{"$ref":"#/types/DangerType"},{"description":"Indication of whether this download is thought to be safe or known to be suspicious."}]},"mime":{"description":"The file\'s MIME type.","type":"string"},"startTime":{"type":"string"},"endTime":{"type":"string"},"state":{"allOf":[{"$ref":"#/types/State"},{"description":"Indicates whether the download is progressing, interrupted, or complete."}]},"paused":{"description":"True if the download has stopped reading data from the host, but kept the connection open.","type":"boolean"},"error":{"allOf":[{"$ref":"#/types/InterruptReason"},{"description":"Why a download was interrupted."}]},"bytesReceived":{"description":"Number of bytes received so far from the host, without considering file compression.","type":"number"},"totalBytes":{"description":"Number of bytes in the whole file, without considering file compression, or -1 if unknown.","type":"number"},"fileSize":{"description":"Number of bytes in the whole file post-decompression, or -1 if unknown.","type":"number"},"exists":{"type":"boolean"}}}}}');

/***/ }),
/* 47 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"events","description":"The <code>chrome.events</code> namespace contains common types used by APIs dispatching events to notify you when something interesting happens.","definitions":{},"refs":{},"types":{"Rule":{"type":"object","description":"Description of a declarative rule for handling events.","properties":{"id":{"type":"string","description":"Optional identifier that allows referencing this rule."},"tags":{"type":"array","items":{"type":"string"},"description":"Tags can be used to annotate rules and perform operations on sets of rules."},"conditions":{"type":"array","items":{},"description":"List of conditions that can trigger the actions."},"actions":{"type":"array","items":{},"description":"List of actions that are triggered if one of the condtions is fulfilled."},"priority":{"type":"integer","description":"Optional priority of this rule. Defaults to 100."}},"required":["conditions","actions"]},"Event":{"type":"object","description":"An object which allows the addition and removal of listeners for a Chrome event.","functions":[{"name":"addListener","type":"function","description":"Registers an event listener <em>callback</em> to an event.","parameters":[{"name":"callback","type":"function","description":"Called when an event occurs. The parameters of this function depend on the type of event."}]},{"name":"removeListener","type":"function","description":"Deregisters an event listener <em>callback</em> from an event.","parameters":[{"name":"callback","type":"function","description":"Listener that shall be unregistered."}]},{"name":"hasListener","type":"function","parameters":[{"name":"callback","type":"function","description":"Listener whose registration status shall be tested."}],"returns":{"type":"boolean","description":"True if <em>callback</em> is registered to the event."}},{"name":"hasListeners","type":"function","parameters":[],"returns":{"type":"boolean","description":"True if any event listeners are registered to the event."}},{"name":"addRules","unsupported":true,"type":"function","description":"Registers rules to handle events.","parameters":[{"name":"eventName","type":"string","description":"Name of the event this function affects."},{"name":"webViewInstanceId","type":"integer","description":"If provided, this is an integer that uniquely identfies the <webview> associated with this function call."},{"name":"rules","type":"array","items":{"$ref":"#/types/Rule"},"description":"Rules to be registered. These do not replace previously registered rules."},{"name":"callback","optional":true,"type":"function","parameters":[{"name":"rules","type":"array","items":{"$ref":"#/types/Rule"},"description":"Rules that were registered, the optional parameters are filled with values."}],"description":"Called with registered rules."}]},{"name":"getRules","unsupported":true,"type":"function","description":"Returns currently registered rules.","parameters":[{"name":"eventName","type":"string","description":"Name of the event this function affects."},{"name":"webViewInstanceId","type":"integer","description":"If provided, this is an integer that uniquely identfies the <webview> associated with this function call."},{"name":"ruleIdentifiers","optional":true,"type":"array","items":{"type":"string"},"description":"If an array is passed, only rules with identifiers contained in this array are returned."},{"name":"callback","type":"function","parameters":[{"name":"rules","type":"array","items":{"$ref":"#/types/Rule"},"description":"Rules that were registered, the optional parameters are filled with values."}],"description":"Called with registered rules."}]},{"name":"removeRules","unsupported":true,"type":"function","description":"Unregisters currently registered rules.","parameters":[{"name":"eventName","type":"string","description":"Name of the event this function affects."},{"name":"webViewInstanceId","type":"integer","description":"If provided, this is an integer that uniquely identfies the <webview> associated with this function call."},{"name":"ruleIdentifiers","optional":true,"type":"array","items":{"type":"string"},"description":"If an array is passed, only rules with identifiers contained in this array are unregistered."},{"name":"callback","optional":true,"type":"function","parameters":[],"description":"Called when rules were unregistered."}]}]},"UrlFilter":{"type":"object","description":"Filters URLs for various criteria. See <a href=\'events#filtered\'>event filtering</a>. All criteria are case sensitive.","properties":{"hostContains":{"type":"string","description":"Matches if the host name of the URL contains a specified string. To test whether a host name component has a prefix \'foo\', use hostContains: \'.foo\'. This matches \'www.foobar.com\' and \'foo.com\', because an implicit dot is added at the beginning of the host name. Similarly, hostContains can be used to match against component suffix (\'foo.\') and to exactly match against components (\'.foo.\'). Suffix- and exact-matching for the last components need to be done separately using hostSuffix, because no implicit dot is added at the end of the host name."},"hostEquals":{"type":"string","description":"Matches if the host name of the URL is equal to a specified string."},"hostPrefix":{"type":"string","description":"Matches if the host name of the URL starts with a specified string."},"hostSuffix":{"type":"string","description":"Matches if the host name of the URL ends with a specified string."},"pathContains":{"type":"string","description":"Matches if the path segment of the URL contains a specified string."},"pathEquals":{"type":"string","description":"Matches if the path segment of the URL is equal to a specified string."},"pathPrefix":{"type":"string","description":"Matches if the path segment of the URL starts with a specified string."},"pathSuffix":{"type":"string","description":"Matches if the path segment of the URL ends with a specified string."},"queryContains":{"type":"string","description":"Matches if the query segment of the URL contains a specified string."},"queryEquals":{"type":"string","description":"Matches if the query segment of the URL is equal to a specified string."},"queryPrefix":{"type":"string","description":"Matches if the query segment of the URL starts with a specified string."},"querySuffix":{"type":"string","description":"Matches if the query segment of the URL ends with a specified string."},"urlContains":{"type":"string","description":"Matches if the URL (without fragment identifier) contains a specified string. Port numbers are stripped from the URL if they match the default port number."},"urlEquals":{"type":"string","description":"Matches if the URL (without fragment identifier) is equal to a specified string. Port numbers are stripped from the URL if they match the default port number."},"urlMatches":{"type":"string","description":"Matches if the URL (without fragment identifier) matches a specified regular expression. Port numbers are stripped from the URL if they match the default port number. The regular expressions use the <a href=\\"https://github.com/google/re2/blob/master/doc/syntax.txt\\">RE2 syntax</a>."},"originAndPathMatches":{"type":"string","description":"Matches if the URL without query segment and fragment identifier matches a specified regular expression. Port numbers are stripped from the URL if they match the default port number. The regular expressions use the <a href=\\"https://github.com/google/re2/blob/master/doc/syntax.txt\\">RE2 syntax</a>."},"urlPrefix":{"type":"string","description":"Matches if the URL (without fragment identifier) starts with a specified string. Port numbers are stripped from the URL if they match the default port number."},"urlSuffix":{"type":"string","description":"Matches if the URL (without fragment identifier) ends with a specified string. Port numbers are stripped from the URL if they match the default port number."},"schemes":{"type":"array","description":"Matches if the scheme of the URL is equal to any of the schemes specified in the array.","items":{"type":"string"}},"ports":{"type":"array","description":"Matches if the port of the URL is contained in any of the specified port lists. For example <code>[80, 443, [1000, 1200]]</code> matches all requests on port 80, 443 and in the range 1000-1200.","items":{"anyOf":[{"type":"integer","description":"A specific port."},{"type":"array","minItems":2,"maxItems":2,"items":{"type":"integer"},"description":"A pair of integers identiying the start and end (both inclusive) of a port range."}]}}}}}}');

/***/ }),
/* 48 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"experiments","definitions":{"Permission":{"anyOf":[{"type":"string","pattern":"^experiments(\\\\.\\\\w+)+$"}]},"WebExtensionManifest":{"properties":{"experiment_apis":{"type":"object","additionalProperties":{"$ref":"experiments#/types/ExperimentAPI"}}}}},"refs":{"experiments#/definitions/Permission":{"namespace":"manifest","type":"Permission"},"experiments#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"ExperimentAPI":{"type":"object","properties":{"schema":{"$ref":"#/types/ExperimentURL"},"parent":{"type":"object","properties":{"events":{"allOf":[{"$ref":"#/types/APIEvents"},{"default":[]}]},"paths":{"allOf":[{"$ref":"#/types/APIPaths"},{"default":[]}]},"script":{"$ref":"#/types/ExperimentURL"},"scopes":{"type":"array","items":{"allOf":[{"$ref":"#/types/APIParentScope"},{"onError":"warn"}]},"default":[]}},"required":["script"]},"child":{"type":"object","properties":{"paths":{"$ref":"#/types/APIPaths"},"script":{"$ref":"#/types/ExperimentURL"},"scopes":{"type":"array","minItems":1,"items":{"allOf":[{"$ref":"#/types/APIChildScope"},{"onError":"warn"}]}}},"required":["paths","script","scopes"]}},"required":["schema"]},"ExperimentURL":{"type":"string","format":"unresolvedRelativeUrl"},"APIPaths":{"type":"array","items":{"$ref":"#/types/APIPath"},"minItems":1},"APIPath":{"type":"array","items":{"type":"string"},"minItems":1},"APIEvents":{"type":"array","items":{"allOf":[{"$ref":"#/types/APIEvent"},{"onError":"warn"}]}},"APIEvent":{"type":"string","enum":["startup"]},"APIParentScope":{"type":"string","enum":["addon_parent","content_parent","devtools_parent"]},"APIChildScope":{"type":"string","enum":["addon_child","content_child","devtools_child"]}}}');

/***/ }),
/* 49 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"extension","allowedContexts":["content","devtools"],"description":"The <code>browser.extension</code> API has utilities that can be used by any extension page. It includes support for exchanging messages between an extension and its content scripts or between extensions, as described in detail in $(topic:messaging)[Message Passing].","properties":{"lastError":{"type":"object","optional":true,"max_manifest_version":2,"deprecated":"Please use $(ref:runtime.lastError).","allowedContexts":["content","devtools"],"description":"Set for the lifetime of a callback if an ansychronous extension api has resulted in an error. If no error has occured lastError will be <var>undefined</var>.","properties":{"message":{"type":"string","description":"Description of the error that has taken place."}},"additionalProperties":{},"required":["message"]},"inIncognitoContext":{"type":"boolean","optional":true,"allowedContexts":["content","devtools"],"description":"True for content scripts running inside incognito tabs, and for extension pages running inside an incognito process. The latter only applies to extensions with \'split\' incognito_behavior."}},"functions":[{"name":"getURL","type":"function","deprecated":"Please use $(ref:runtime.getURL).","max_manifest_version":2,"allowedContexts":["content","devtools"],"description":"Converts a relative path within an extension install directory to a fully-qualified URL.","parameters":[{"type":"string","name":"path","description":"A path to a resource within an extension expressed relative to its install directory."}],"returns":{"type":"string","description":"The fully-qualified URL to the resource."}},{"name":"getViews","type":"function","description":"Returns an array of the JavaScript \'window\' objects for each of the pages running inside the current extension.","parameters":[{"type":"object","name":"fetchProperties","optional":true,"properties":{"type":{"allOf":[{"$ref":"#/types/ViewType"},{"description":"The type of view to get. If omitted, returns all views (including background pages and tabs). Valid values: \'tab\', \'popup\', \'sidebar\'."}]},"windowId":{"type":"integer","description":"The window to restrict the search to. If omitted, returns all views."},"tabId":{"type":"integer","description":"Find a view according to a tab id. If this field is omitted, returns all views."}}}],"returns":{"type":"array","description":"Array of global objects","items":{"type":"object","isInstanceOf":"Window","additionalProperties":{}}}},{"name":"getBackgroundPage","type":"function","max_manifest_version":2,"description":"Returns the JavaScript \'window\' object for the background page running inside the current extension. Returns null if the extension has no background page.","parameters":[],"returns":{"type":"object","optional":true,"isInstanceOf":"Window","additionalProperties":{}}},{"name":"isAllowedIncognitoAccess","type":"function","description":"Retrieves the state of the extension\'s access to Incognito-mode (as determined by the user-controlled \'Allowed in Incognito\' checkbox.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"isAllowedAccess","type":"boolean","description":"True if the extension has access to Incognito mode, false otherwise."}]}]},{"name":"isAllowedFileSchemeAccess","type":"function","description":"Retrieves the state of the extension\'s access to the \'file://\' scheme (as determined by the user-controlled \'Allow access to File URLs\' checkbox.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"isAllowedAccess","type":"boolean","description":"True if the extension can access the \'file://\' scheme, false otherwise."}]}]},{"name":"setUpdateUrlData","unsupported":true,"type":"function","description":"Sets the value of the ap CGI parameter used in the extension\'s update URL.  This value is ignored for extensions that are hosted in the browser vendor\'s store.","parameters":[{"type":"string","name":"data","maxLength":1024}]}],"events":[{"name":"onRequest","unsupported":true,"deprecated":"Please use $(ref:runtime.onMessage).","type":"function","description":"Fired when a request is sent from either an extension process or a content script.","parameters":[{"name":"request","optional":true,"description":"The request sent by the calling script."},{"allOf":[{"$ref":"runtime#/types/MessageSender"},{"name":"sender"}]},{"name":"sendResponse","type":"function","description":"Function to call (at most once) when you have a response. The argument should be any JSON-ifiable object, or undefined if there is no response. If you have more than one <code>onRequest</code> listener in the same document, then only one may send a response."}]},{"name":"onRequestExternal","unsupported":true,"deprecated":"Please use $(ref:runtime.onMessageExternal).","type":"function","description":"Fired when a request is sent from another extension.","parameters":[{"name":"request","optional":true,"description":"The request sent by the calling script."},{"allOf":[{"$ref":"runtime#/types/MessageSender"},{"name":"sender"}]},{"name":"sendResponse","type":"function","description":"Function to call when you have a response. The argument should be any JSON-ifiable object, or undefined if there is no response."}]}],"definitions":{},"refs":{},"types":{"ViewType":{"type":"string","enum":["tab","popup","sidebar"],"description":"The type of extension view."}}}');

/***/ }),
/* 50 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"extension_protocol_handlers","definitions":{"WebExtensionManifest":{"properties":{"protocol_handlers":{"description":"A list of protocol handler definitions.","type":"array","items":{"$ref":"#/types/ProtocolHandler"}}}}},"refs":{"extension_protocol_handlers#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"ProtocolHandler":{"type":"object","description":"Represents a protocol handler definition.","properties":{"name":{"description":"A user-readable title string for the protocol handler. This will be displayed to the user in interface objects as needed.","type":"string"},"protocol":{"description":"The protocol the site wishes to handle, specified as a string. For example, you can register to handle SMS text message links by registering to handle the \\"sms\\" scheme.","anyOf":[{"type":"string","enum":["bitcoin","dat","dweb","ftp","geo","gopher","im","ipfs","ipns","irc","ircs","magnet","mailto","matrix","mms","news","nntp","sip","sms","smsto","ssb","ssh","tel","urn","webcal","wtai","xmpp"]},{"type":"string","pattern":"^(ext|web)\\\\+[a-z0-9.+-]+$"}]},"uriTemplate":{"description":"The URL of the handler, as a string. This string should include \\"%s\\" as a placeholder which will be replaced with the escaped URL of the document to be handled. This URL might be a true URL, or it could be a phone number, email address, or so forth.","preprocess":"localize","anyOf":[{"$ref":"manifest#/types/ExtensionURL"},{"$ref":"manifest#/types/HttpURL"}]}},"required":["name","protocol","uriTemplate"]}}}');

/***/ }),
/* 51 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"extensionTypes","description":"The <code>browser.extensionTypes</code> API contains type declarations for WebExtensions.","definitions":{},"refs":{},"types":{"ImageFormat":{"type":"string","enum":["jpeg","png"],"description":"The format of an image."},"ImageDetails":{"type":"object","description":"Details about the format, quality, area and scale of the capture.","properties":{"format":{"allOf":[{"$ref":"#/types/ImageFormat"},{"description":"The format of the resulting image.  Default is <code>\\"jpeg\\"</code>."}]},"quality":{"type":"integer","minimum":0,"maximum":100,"description":"When format is <code>\\"jpeg\\"</code>, controls the quality of the resulting image.  This value is ignored for PNG images.  As quality is decreased, the resulting image will have more visual artifacts, and the number of bytes needed to store it will decrease."},"rect":{"type":"object","description":"The area of the document to capture, in CSS pixels, relative to the page.  If omitted, capture the visible viewport.","properties":{"x":{"type":"number"},"y":{"type":"number"},"width":{"type":"number"},"height":{"type":"number"}},"required":["x","y","width","height"]},"scale":{"type":"number","description":"The scale of the resulting image.  Defaults to <code>devicePixelRatio</code>."}}},"RunAt":{"type":"string","enum":["document_start","document_end","document_idle"],"description":"The soonest that the JavaScript or CSS will be injected into the tab."},"CSSOrigin":{"type":"string","enum":["user","author"],"description":"The origin of the CSS to inject, this affects the cascading order (priority) of the stylesheet."},"InjectDetails":{"type":"object","description":"Details of the script or CSS to inject. Either the code or the file property must be set, but both may not be set at the same time.","properties":{"code":{"type":"string","description":"JavaScript or CSS code to inject.<br><br><b>Warning:</b><br>Be careful using the <code>code</code> parameter. Incorrect use of it may open your extension to <a href=\\"https://en.wikipedia.org/wiki/Cross-site_scripting\\">cross site scripting</a> attacks."},"file":{"type":"string","description":"JavaScript or CSS file to inject."},"allFrames":{"type":"boolean","description":"If allFrames is <code>true</code>, implies that the JavaScript or CSS should be injected into all frames of current page. By default, it\'s <code>false</code> and is only injected into the top frame."},"matchAboutBlank":{"type":"boolean","description":"If matchAboutBlank is true, then the code is also injected in about:blank and about:srcdoc frames if your extension has access to its parent document. Code cannot be inserted in top-level about:-frames. By default it is <code>false</code>."},"frameId":{"type":"integer","minimum":0,"description":"The ID of the frame to inject the script into. This may not be used in combination with <code>allFrames</code>."},"runAt":{"allOf":[{"$ref":"#/types/RunAt"},{"default":"document_idle","description":"The soonest that the JavaScript or CSS will be injected into the tab. Defaults to \\"document_idle\\"."}]},"cssOrigin":{"allOf":[{"$ref":"#/types/CSSOrigin"},{"description":"The css origin of the stylesheet to inject. Defaults to \\"author\\"."}]}}},"Date":{"anyOf":[{"type":"string","format":"date"},{"type":"integer","minimum":0},{"type":"object","isInstanceOf":"Date","additionalProperties":{}}]},"ExtensionFileOrCode":{"anyOf":[{"type":"object","properties":{"file":{"$ref":"manifest#/types/ExtensionURL"}},"required":["file"]},{"type":"object","properties":{"code":{"type":"string"}},"required":["code"]}]},"PlainJSONValue":{"description":"A plain JSON value","anyOf":[{"type":"null"},{"type":"number"},{"type":"string"},{"type":"boolean"},{"type":"array","items":{"$ref":"#/types/PlainJSONValue"}},{"type":"object","additionalProperties":{"$ref":"#/types/PlainJSONValue"}}]}}}');

/***/ }),
/* 52 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"find","description":"Use the <code>browser.find</code> API to interact with the browser\'s <code>Find</code> interface.","permissions":["find"],"functions":[{"name":"find","type":"function","async":true,"description":"Search for text in document and store found ranges in array, in document order.","parameters":[{"name":"queryphrase","type":"string","description":"The string to search for."},{"name":"params","type":"object","description":"Search parameters.","optional":true,"properties":{"tabId":{"type":"integer","description":"Tab to query. Defaults to the active tab.","minimum":0},"caseSensitive":{"type":"boolean","description":"Find only ranges with case sensitive match."},"entireWord":{"type":"boolean","description":"Find only ranges that match entire word."},"includeRectData":{"description":"Return rectangle data which describes visual position of search results.","type":"boolean"},"includeRangeData":{"description":"Return range data which provides range data in a serializable form.","type":"boolean"}}}]},{"name":"highlightResults","type":"function","async":true,"description":"Highlight a range","parameters":[{"name":"params","type":"object","description":"highlightResults parameters","optional":true,"properties":{"rangeIndex":{"type":"integer","description":"Found range to be highlighted. Default highlights all ranges.","minimum":0},"tabId":{"type":"integer","description":"Tab to highlight. Defaults to the active tab.","minimum":0},"noScroll":{"type":"boolean","description":"Don\'t scroll to highlighted item."}}}]},{"name":"removeHighlighting","type":"function","async":true,"description":"Remove all highlighting from previous searches.","parameters":[{"name":"tabId","type":"integer","description":"Tab to highlight. Defaults to the active tab.","optional":true}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["find"]}]}},"refs":{"find#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{}}');

/***/ }),
/* 53 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"geckoProfiler","description":"Exposes the browser\'s profiler.","permissions":["geckoProfiler"],"functions":[{"name":"start","type":"function","description":"Starts the profiler with the specified settings.","async":true,"parameters":[{"name":"settings","type":"object","properties":{"bufferSize":{"type":"integer","minimum":0,"description":"The maximum size in bytes of the buffer used to store profiling data. A larger value allows capturing a profile that covers a greater amount of time."},"windowLength":{"type":"number","description":"The length of the window of time that\'s kept in the buffer. Any collected samples are discarded as soon as they are older than the number of seconds specified in this setting. Zero means no duration restriction."},"interval":{"type":"number","description":"Interval in milliseconds between samples of profiling data. A smaller value will increase the detail of the profiles captured."},"features":{"type":"array","description":"A list of active features for the profiler.","items":{"$ref":"#/types/ProfilerFeature"}},"threads":{"type":"array","description":"A list of thread names for which to capture profiles.","items":{"type":"string"}}},"required":["bufferSize","interval","features"]}]},{"name":"stop","type":"function","description":"Stops the profiler and discards any captured profile data.","async":true,"parameters":[]},{"name":"pause","type":"function","description":"Pauses the profiler, keeping any profile data that is already written.","async":true,"parameters":[]},{"name":"resume","type":"function","description":"Resumes the profiler with the settings that were initially used to start it.","async":true,"parameters":[]},{"name":"dumpProfileToFile","type":"function","description":"Gathers the profile data from the current profiling session, and writes it to disk. The returned promise resolves to a path that locates the created file.","async":true,"parameters":[{"type":"string","name":"fileName","description":"The name of the file inside the profile/profiler directory"}]},{"name":"getProfile","type":"function","description":"Gathers the profile data from the current profiling session.","async":true,"parameters":[]},{"name":"getProfileAsArrayBuffer","type":"function","description":"Gathers the profile data from the current profiling session. The returned promise resolves to an array buffer that contains a JSON string.","async":true,"parameters":[]},{"name":"getProfileAsGzippedArrayBuffer","type":"function","description":"Gathers the profile data from the current profiling session. The returned promise resolves to an array buffer that contains a gzipped JSON string.","async":true,"parameters":[]},{"name":"getSymbols","type":"function","description":"Gets the debug symbols for a particular library.","async":true,"parameters":[{"type":"string","name":"debugName","description":"The name of the library\'s debug file. For example, \'xul.pdb"},{"type":"string","name":"breakpadId","description":"The Breakpad ID of the library"}]}],"events":[{"name":"onRunning","type":"function","description":"Fires when the profiler starts/stops running.","parameters":[{"name":"isRunning","type":"boolean","description":"Whether the profiler is running or not. Pausing the profiler will not affect this value."}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["geckoProfiler"]}]}},"refs":{"geckoProfiler#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{"ProfilerFeature":{"type":"string","enum":["java","js","leaf","mainthreadio","responsiveness","screenshots","seqstyle","stackwalk","threads","jstracer","jsallocations","nostacksampling","nativeallocations","preferencereads","ipcmessages","fileio","fileioall","noiostacks","audiocallbacktracing","cpu","notimerresolutionchange"]},"supports":{"type":"string","enum":["windowLength"]}}}');

/***/ }),
/* 54 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"history","description":"Use the <code>browser.history</code> API to interact with the browser\'s record of visited pages. You can add, remove, and query for URLs in the browser\'s history. To override the history page with your own version, see $(topic:override)[Override Pages].","permissions":["history"],"functions":[{"name":"search","type":"function","description":"Searches the history for the last visit time of each page matching the query.","async":"callback","parameters":[{"name":"query","type":"object","properties":{"text":{"type":"string","description":"A free-text query to the history service.  Leave empty to retrieve all pages."},"startTime":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"Limit results to those visited after this date. If not specified, this defaults to 24 hours in the past."}]},"endTime":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"Limit results to those visited before this date."}]},"maxResults":{"type":"integer","minimum":1,"description":"The maximum number of results to retrieve.  Defaults to 100."}},"required":["text"]},{"name":"callback","type":"function","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/HistoryItem"}}]}]},{"name":"getVisits","type":"function","description":"Retrieves information about visits to a URL.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"url":{"type":"string","description":"The URL for which to retrieve visit information.  It must be in the format as returned from a call to history.search."}},"required":["url"]},{"name":"callback","type":"function","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/VisitItem"}}]}]},{"name":"addUrl","type":"function","description":"Adds a URL to the history with a default visitTime of the current time and a default $(topic:transition-types)[transition type] of \\"link\\".","async":"callback","parameters":[{"name":"details","type":"object","properties":{"url":{"type":"string","description":"The URL to add. Must be a valid URL that can be added to history."},"title":{"type":"string","description":"The title of the page."},"transition":{"allOf":[{"$ref":"#/types/TransitionType"},{"description":"The $(topic:transition-types)[transition type] for this visit from its referrer."}]},"visitTime":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"The date when this visit occurred."}]}},"required":["url"]},{"name":"callback","type":"function","optional":true,"parameters":[]}]},{"name":"deleteUrl","type":"function","description":"Removes all occurrences of the given URL from the history.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"url":{"type":"string","description":"The URL to remove."}},"required":["url"]},{"name":"callback","type":"function","optional":true,"parameters":[]}]},{"name":"deleteRange","type":"function","description":"Removes all items within the specified date range from the history.  Pages will not be removed from the history unless all visits fall within the range.","async":"callback","parameters":[{"name":"range","type":"object","properties":{"startTime":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"Items added to history after this date."}]},"endTime":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"Items added to history before this date."}]}},"required":["startTime","endTime"]},{"name":"callback","type":"function","parameters":[]}]},{"name":"deleteAll","type":"function","description":"Deletes all items from the history.","async":"callback","parameters":[{"name":"callback","type":"function","parameters":[]}]}],"events":[{"name":"onVisited","type":"function","description":"Fired when a URL is visited, providing the HistoryItem data for that URL.  This event fires before the page has loaded.","parameters":[{"allOf":[{"$ref":"#/types/HistoryItem"},{"name":"result"}]}]},{"name":"onVisitRemoved","type":"function","description":"Fired when one or more URLs are removed from the history service.  When all visits have been removed the URL is purged from history.","parameters":[{"name":"removed","type":"object","properties":{"allHistory":{"type":"boolean","description":"True if all history was removed.  If true, then urls will be empty."},"urls":{"type":"array","items":{"type":"string"}}},"required":["allHistory","urls"]}]},{"name":"onTitleChanged","type":"function","description":"Fired when the title of a URL is changed in the browser history.","parameters":[{"name":"changed","type":"object","properties":{"url":{"type":"string","description":"The URL for which the title has changed"},"title":{"type":"string","description":"The new title for the URL."}},"required":["url","title"]}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["history"]}]}},"refs":{"history#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"TransitionType":{"type":"string","enum":["link","typed","auto_bookmark","auto_subframe","manual_subframe","generated","auto_toplevel","form_submit","reload","keyword","keyword_generated"],"description":"The $(topic:transition-types)[transition type] for this visit from its referrer."},"HistoryItem":{"type":"object","description":"An object encapsulating one result of a history query.","properties":{"id":{"type":"string","description":"The unique identifier for the item."},"url":{"type":"string","description":"The URL navigated to by a user."},"title":{"type":"string","description":"The title of the page when it was last loaded."},"lastVisitTime":{"type":"number","description":"When this page was last loaded, represented in milliseconds since the epoch."},"visitCount":{"type":"integer","description":"The number of times the user has navigated to this page."},"typedCount":{"type":"integer","description":"The number of times the user has navigated to this page by typing in the address."}},"required":["id"]},"VisitItem":{"type":"object","description":"An object encapsulating one visit to a URL.","properties":{"id":{"type":"string","description":"The unique identifier for the item."},"visitId":{"type":"string","description":"The unique identifier for this visit."},"visitTime":{"type":"number","description":"When this visit occurred, represented in milliseconds since the epoch."},"referringVisitId":{"type":"string","description":"The visit ID of the referrer."},"transition":{"allOf":[{"$ref":"#/types/TransitionType"},{"description":"The $(topic:transition-types)[transition type] for this visit from its referrer."}]}},"required":["id","visitId","referringVisitId","transition"]}}}');

/***/ }),
/* 55 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"i18n","allowedContexts":["content","devtools"],"defaultContexts":["content","devtools"],"description":"Use the <code>browser.i18n</code> infrastructure to implement internationalization across your whole app or extension.","functions":[{"name":"getAcceptLanguages","type":"function","description":"Gets the accept-languages of the browser. This is different from the locale used by the browser; to get the locale, use $(ref:i18n.getUILanguage).","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"languages","type":"array","items":{"$ref":"#/types/LanguageCode"},"description":"Array of LanguageCode"}]}]},{"name":"getMessage","type":"function","description":"Gets the localized string for the specified message. If the message is missing, this method returns an empty string (\'\'). If the format of the <code>getMessage()</code> call is wrong &mdash; for example, <em>messageName</em> is not a string or the <em>substitutions</em> array has more than 9 elements &mdash; this method returns <code>undefined</code>.","parameters":[{"type":"string","name":"messageName","description":"The name of the message, as specified in the <code>$(topic:i18n-messages)[messages.json]</code> file."},{"name":"substitutions","optional":true,"description":"Substitution strings, if the message requires any."}],"returns":{"type":"string","description":"Message localized for current locale."}},{"name":"getUILanguage","type":"function","description":"Gets the browser UI language of the browser. This is different from $(ref:i18n.getAcceptLanguages) which returns the preferred user languages.","parameters":[],"returns":{"type":"string","description":"The browser UI language code such as en-US or fr-FR."}},{"name":"detectLanguage","type":"function","description":"Detects the language of the provided text using CLD.","async":"callback","parameters":[{"type":"string","name":"text","description":"User input string to be translated."},{"type":"function","name":"callback","parameters":[{"type":"object","name":"result","description":"LanguageDetectionResult object that holds detected langugae reliability and array of DetectedLanguage","properties":{"isReliable":{"type":"boolean","description":"CLD detected language reliability"},"languages":{"type":"array","description":"array of detectedLanguage","items":{"type":"object","description":"DetectedLanguage object that holds detected ISO language code and its percentage in the input string","properties":{"language":{"$ref":"#/types/LanguageCode"},"percentage":{"type":"integer","description":"The percentage of the detected language"}},"required":["language","percentage"]}}},"required":["isReliable","languages"]}]}]}],"events":[],"definitions":{"WebExtensionManifest":{"properties":{"default_locale":{"type":"string"},"l10n_resources":{"type":"array","items":{"type":"string"}}}}},"refs":{"i18n#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"LanguageCode":{"type":"string","description":"An ISO language code such as <code>en</code> or <code>fr</code>. For a complete list of languages supported by this method, see <a href=\'http://src.chromium.org/viewvc/chrome/trunk/src/third_party/cld/languages/internal/languages.cc\'>kLanguageInfoTable</a>. For an unknown language, <code>und</code> will be returned, which means that [percentage] of the text is unknown to CLD"}}}');

/***/ }),
/* 56 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"identity","description":"Use the chrome.identity API to get OAuth2 access tokens. ","permissions":["identity"],"functions":[{"name":"getAccounts","type":"function","unsupported":true,"description":"Retrieves a list of AccountInfo objects describing the accounts present on the profile.","async":"callback","parameters":[{"name":"callback","type":"function","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/AccountInfo"}}]}]},{"name":"getAuthToken","type":"function","unsupported":true,"description":"Gets an OAuth2 access token using the client ID and scopes specified in the oauth2 section of manifest.json.","async":"callback","parameters":[{"name":"details","optional":true,"type":"object","properties":{"interactive":{"type":"boolean"},"account":{"$ref":"#/types/AccountInfo"},"scopes":{"type":"array","items":{"type":"string"}}}},{"name":"callback","optional":true,"type":"function","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/AccountInfo"}}]}]},{"name":"getProfileUserInfo","type":"function","unsupported":true,"description":"Retrieves email address and obfuscated gaia id of the user signed into a profile.","async":"callback","parameters":[{"name":"callback","type":"function","parameters":[{"name":"userinfo","type":"object","properties":{"email":{"type":"string"},"id":{"type":"string"}},"required":["email","id"]}]}]},{"name":"removeCachedAuthToken","type":"function","unsupported":true,"description":"Removes an OAuth2 access token from the Identity API\'s token cache.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"token":{"type":"string"}},"required":["token"]},{"name":"callback","optional":true,"type":"function","parameters":[{"name":"userinfo","type":"object","properties":{"email":{"type":"string"},"id":{"type":"string"}},"required":["email","id"]}]}]},{"name":"launchWebAuthFlow","type":"function","description":"Starts an auth flow at the specified URL.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"url":{"$ref":"manifest#/types/HttpURL"},"interactive":{"type":"boolean"}},"required":["url"]},{"name":"callback","type":"function","parameters":[{"name":" responseUrl","type":"string","optional":true}]}]},{"name":"getRedirectURL","type":"function","description":"Generates a redirect URL to be used in |launchWebAuthFlow|.","parameters":[{"name":"path","type":"string","default":"","optional":true,"description":"The path appended to the end of the generated URL. "}],"returns":{"type":"string"}}],"events":[{"name":"onSignInChanged","unsupported":true,"type":"function","description":"Fired when signin state changes for an account on the user\'s profile.","parameters":[{"allOf":[{"$ref":"#/types/AccountInfo"},{"name":"account"}]},{"name":"signedIn","type":"boolean"}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["identity"]}]}},"refs":{"identity#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{"AccountInfo":{"type":"object","description":"An object encapsulating an OAuth account id.","properties":{"id":{"type":"string","description":"A unique identifier for the account. This ID will not change for the lifetime of the account. "}},"required":["id"]}}}');

/***/ }),
/* 57 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"idle","description":"Use the <code>browser.idle</code> API to detect when the machine\'s idle state changes.","permissions":["idle"],"functions":[{"name":"queryState","type":"function","description":"Returns \\"idle\\" if the user has not generated any input for a specified number of seconds, or \\"active\\" otherwise.","async":"callback","parameters":[{"name":"detectionIntervalInSeconds","type":"integer","minimum":15,"description":"The system is considered idle if detectionIntervalInSeconds seconds have elapsed since the last user input detected."},{"name":"callback","type":"function","parameters":[{"allOf":[{"$ref":"#/types/IdleState"},{"name":"newState"}]}]}]},{"name":"setDetectionInterval","type":"function","description":"Sets the interval, in seconds, used to determine when the system is in an idle state for onStateChanged events. The default interval is 60 seconds.","parameters":[{"name":"intervalInSeconds","type":"integer","minimum":15,"description":"Threshold, in seconds, used to determine when the system is in an idle state."}]}],"events":[{"name":"onStateChanged","type":"function","description":"Fired when the system changes to an active or idle state. The event fires with \\"idle\\" if the the user has not generated any input for a specified number of seconds, and \\"active\\" when the user generates input on an idle system.","parameters":[{"allOf":[{"$ref":"#/types/IdleState"},{"name":"newState"}]}]}],"definitions":{},"refs":{},"types":{"IdleState":{"type":"string","enum":["active","idle"]}}}');

/***/ }),
/* 58 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"management","description":"The <code>browser.management</code> API provides ways to manage the list of extensions that are installed and running.","functions":[{"name":"getAll","type":"function","permissions":["management"],"description":"Returns a list of information about installed extensions.","async":"callback","parameters":[{"name":"callback","type":"function","optional":true,"parameters":[{"type":"array","name":"result","items":{"$ref":"#/types/ExtensionInfo"}}]}]},{"name":"get","type":"function","permissions":["management"],"description":"Returns information about the installed extension that has the given ID.","async":"callback","parameters":[{"allOf":[{"$ref":"manifest#/types/ExtensionID"},{"name":"id","description":"The ID from an item of $(ref:management.ExtensionInfo)."}]},{"name":"callback","type":"function","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/ExtensionInfo"},{"name":"result"}]}]}]},{"name":"install","type":"function","requireUserInput":true,"permissions":["management"],"description":"Installs and enables a theme extension from the given url.","async":"callback","parameters":[{"name":"options","type":"object","properties":{"url":{"allOf":[{"$ref":"manifest#/types/HttpURL"},{"description":"URL pointing to the XPI file on addons.mozilla.org or similar."}]},"hash":{"type":"string","pattern":"^(sha256|sha512):[0-9a-fA-F]{64,128}$","description":"A hash of the XPI file, using sha256 or stronger."}},"required":["url"]},{"name":"callback","type":"function","optional":true,"parameters":[{"name":"result","type":"object","properties":{"id":{"$ref":"manifest#/types/ExtensionID"}},"required":["id"]}]}]},{"name":"getSelf","type":"function","description":"Returns information about the calling extension. Note: This function can be used without requesting the \'management\' permission in the manifest.","async":"callback","parameters":[{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/ExtensionInfo"},{"name":"result"}]}]}]},{"name":"uninstallSelf","type":"function","description":"Uninstalls the calling extension. Note: This function can be used without requesting the \'management\' permission in the manifest.","async":"callback","parameters":[{"type":"object","name":"options","optional":true,"properties":{"showConfirmDialog":{"type":"boolean","description":"Whether or not a confirm-uninstall dialog should prompt the user. Defaults to false."},"dialogMessage":{"type":"string","description":"The message to display to a user when being asked to confirm removal of the extension."}}},{"name":"callback","type":"function","optional":true,"parameters":[]}]},{"name":"setEnabled","type":"function","permissions":["management"],"description":"Enables or disables the given add-on.","async":"callback","parameters":[{"name":"id","type":"string","description":"ID of the add-on to enable/disable."},{"name":"enabled","type":"boolean","description":"Whether to enable or disable the add-on."},{"name":"callback","type":"function","optional":true,"parameters":[]}]}],"events":[{"name":"onDisabled","type":"function","permissions":["management"],"description":"Fired when an addon has been disabled.","parameters":[{"allOf":[{"$ref":"#/types/ExtensionInfo"},{"name":"info"}]}]},{"name":"onEnabled","type":"function","permissions":["management"],"description":"Fired when an addon has been enabled.","parameters":[{"allOf":[{"$ref":"#/types/ExtensionInfo"},{"name":"info"}]}]},{"name":"onInstalled","type":"function","permissions":["management"],"description":"Fired when an addon has been installed.","parameters":[{"allOf":[{"$ref":"#/types/ExtensionInfo"},{"name":"info"}]}]},{"name":"onUninstalled","type":"function","permissions":["management"],"description":"Fired when an addon has been uninstalled.","parameters":[{"allOf":[{"$ref":"#/types/ExtensionInfo"},{"name":"info"}]}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["management"]}]}},"refs":{"management#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"IconInfo":{"description":"Information about an icon belonging to an extension.","type":"object","properties":{"size":{"type":"integer","description":"A number representing the width and height of the icon. Likely values include (but are not limited to) 128, 48, 24, and 16."},"url":{"type":"string","description":"The URL for this icon image. To display a grayscale version of the icon (to indicate that an extension is disabled, for example), append <code>?grayscale=true</code> to the URL."}},"required":["size","url"]},"ExtensionDisabledReason":{"description":"A reason the item is disabled.","type":"string","enum":["unknown","permissions_increase"]},"ExtensionType":{"description":"The type of this extension, \'extension\' or \'theme\'.","type":"string","enum":["extension","theme"]},"ExtensionInstallType":{"description":"How the extension was installed. One of<br><var>development</var>: The extension was loaded unpacked in developer mode,<br><var>normal</var>: The extension was installed normally via an .xpi file,<br><var>sideload</var>: The extension was installed by other software on the machine,<br><var>other</var>: The extension was installed by other means.","type":"string","enum":["development","normal","sideload","other"]},"ExtensionInfo":{"description":"Information about an installed extension.","type":"object","properties":{"id":{"description":"The extension\'s unique identifier.","type":"string"},"name":{"description":"The name of this extension.","type":"string"},"shortName":{"description":"A short version of the name of this extension.","type":"string"},"description":{"description":"The description of this extension.","type":"string"},"version":{"description":"The <a href=\'manifest/version\'>version</a> of this extension.","type":"string"},"versionName":{"description":"The <a href=\'manifest/version#version_name\'>version name</a> of this extension if the manifest specified one.","type":"string"},"mayDisable":{"description":"Whether this extension can be disabled or uninstalled by the user.","type":"boolean"},"enabled":{"description":"Whether it is currently enabled or disabled.","type":"boolean"},"disabledReason":{"allOf":[{"$ref":"#/types/ExtensionDisabledReason"},{"description":"A reason the item is disabled."}]},"type":{"allOf":[{"$ref":"#/types/ExtensionType"},{"description":"The type of this extension, \'extension\' or \'theme\'."}]},"homepageUrl":{"description":"The URL of the homepage of this extension.","type":"string"},"updateUrl":{"description":"The update URL of this extension.","type":"string"},"optionsUrl":{"description":"The url for the item\'s options page, if it has one.","type":"string"},"icons":{"description":"A list of icon information. Note that this just reflects what was declared in the manifest, and the actual image at that url may be larger or smaller than what was declared, so you might consider using explicit width and height attributes on img tags referencing these images. See the <a href=\'manifest/icons\'>manifest documentation on icons</a> for more details.","type":"array","items":{"$ref":"#/types/IconInfo"}},"permissions":{"description":"Returns a list of API based permissions.","type":"array","items":{"type":"string"}},"hostPermissions":{"description":"Returns a list of host based permissions.","type":"array","items":{"type":"string"}},"installType":{"allOf":[{"$ref":"#/types/ExtensionInstallType"},{"description":"How the extension was installed."}]}},"required":["id","name","description","version","mayDisable","enabled","type","optionsUrl","installType"]}}}');

/***/ }),
/* 59 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"contextMenus","permissions":["menus","contextMenus"],"description":"Use the browser.contextMenus API to add items to the browser\'s context menu. You can choose what types of objects your context menu additions apply to, such as images, hyperlinks, and pages.","properties":{"ACTION_MENU_TOP_LEVEL_LIMIT":{"value":6,"description":"The maximum number of top level extension items that can be added to an extension action context menu. Any items beyond this limit will be ignored."}},"functions":[{"name":"create","type":"function","description":"Creates a new context menu item. Note that if an error occurs during creation, you may not find out until the creation callback fires (the details will be in $(ref:runtime.lastError)).","returns":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The ID of the newly created item."},"parameters":[{"type":"object","name":"createProperties","properties":{"type":{"allOf":[{"$ref":"#/types/ItemType"},{"description":"The type of menu item. Defaults to \'normal\' if not specified."}]},"id":{"type":"string","description":"The unique ID to assign to this item. Mandatory for event pages. Cannot be the same as another ID for this extension."},"icons":{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}},"title":{"type":"string","description":"The text to be displayed in the item; this is <em>required</em> unless <code>type</code> is \'separator\'. When the context is \'selection\', you can use <code>%s</code> within the string to show the selected text. For example, if this parameter\'s value is \\"Translate \'%s\' to Pig Latin\\" and the user selects the word \\"cool\\", the context menu item for the selection is \\"Translate \'cool\' to Pig Latin\\"."},"checked":{"type":"boolean","description":"The initial state of a checkbox or radio item: true for selected and false for unselected. Only one radio item can be selected at a time in a given group of radio items."},"contexts":{"type":"array","items":{"$ref":"#/types/ContextType"},"minItems":1,"description":"List of contexts this menu item will appear in. Defaults to [\'page\'] if not specified."},"viewTypes":{"type":"array","items":{"$ref":"extension#/types/ViewType"},"minItems":1,"description":"List of view types where the menu item will be shown. Defaults to any view, including those without a viewType."},"visible":{"type":"boolean","description":"Whether the item is visible in the menu."},"onclick":{"type":"function","description":"A function that will be called back when the menu item is clicked. Event pages cannot use this; instead, they should register a listener for $(ref:contextMenus.onClicked).","parameters":[{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","description":"Information about the item clicked and the context where the click happened."}]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the click took place. Note: this parameter only present for extensions."}]}]},"parentId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The ID of a parent menu item; this makes the item a child of a previously added item."},"documentUrlPatterns":{"type":"array","items":{"type":"string"},"description":"Lets you restrict the item to apply only to documents whose URL matches one of the given patterns. (This applies to frames as well.) For details on the format of a pattern, see $(topic:match_patterns)[Match Patterns]."},"targetUrlPatterns":{"type":"array","items":{"type":"string"},"description":"Similar to documentUrlPatterns, but lets you filter based on the src attribute of img/audio/video tags and the href of anchor tags."},"enabled":{"type":"boolean","description":"Whether this context menu item is enabled or disabled. Defaults to true."},"command":{"anyOf":[{"type":"string"},{"type":"string","enum":["_execute_browser_action","_execute_page_action","_execute_sidebar_action"],"max_manifest_version":2,"description":"Manifest V2 supports internal commands _execute_page_action, _execute_browser_action and _execute_sidebar_action."},{"type":"string","enum":["_execute_action","_execute_page_action","_execute_sidebar_action"],"min_manifest_version":3,"description":"Manifest V3 supports internal commands _execute_page_action, _execute_action and _execute_sidebar_action."}],"description":"Specifies a command to issue for the context click."}}},{"type":"function","name":"callback","optional":true,"description":"Called when the item has been created in the browser. If there were any problems creating the item, details will be available in $(ref:runtime.lastError).","parameters":[]}]},{"name":"update","type":"function","description":"Updates a previously created context menu item.","async":"callback","parameters":[{"anyOf":[{"type":"integer"},{"type":"string"}],"name":"id","description":"The ID of the item to update."},{"type":"object","name":"updateProperties","description":"The properties to update. Accepts the same values as the create function.","properties":{"type":{"$ref":"#/types/ItemType"},"icons":{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}},"title":{"type":"string"},"checked":{"type":"boolean"},"contexts":{"type":"array","items":{"$ref":"#/types/ContextType"},"minItems":1},"viewTypes":{"type":"array","items":{"$ref":"extension#/types/ViewType"},"minItems":1},"visible":{"type":"boolean","description":"Whether the item is visible in the menu."},"onclick":{"type":"function","parameters":[{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info"}]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the click took place. Note: this parameter only present for extensions."}]}]},"parentId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"Note: You cannot change an item to be a child of one of its own descendants."},"documentUrlPatterns":{"type":"array","items":{"type":"string"}},"targetUrlPatterns":{"type":"array","items":{"type":"string"}},"enabled":{"type":"boolean"}}},{"type":"function","name":"callback","optional":true,"parameters":[],"description":"Called when the context menu has been updated."}]},{"name":"remove","type":"function","description":"Removes a context menu item.","async":"callback","parameters":[{"anyOf":[{"type":"integer"},{"type":"string"}],"name":"menuItemId","description":"The ID of the context menu item to remove."},{"type":"function","name":"callback","optional":true,"parameters":[],"description":"Called when the context menu has been removed."}]},{"name":"removeAll","type":"function","description":"Removes all context menu items added by this extension.","async":"callback","parameters":[{"type":"function","name":"callback","optional":true,"parameters":[],"description":"Called when removal is complete."}]},{"name":"overrideContext","permissions":["menus.overrideContext"],"type":"function","description":"Show the matching menu items from this extension instead of the default menu. This should be called during a \'contextmenu\' DOM event handler, and only applies to the menu that opens after this event.","parameters":[{"name":"contextOptions","type":"object","properties":{"showDefaults":{"type":"boolean","default":false,"description":"Whether to also include default menu items in the menu."},"context":{"type":"string","enum":["bookmark","tab"],"description":"ContextType to override, to allow menu items from other extensions in the menu. Currently only \'bookmark\' and \'tab\' are supported. showDefaults cannot be used with this option."},"bookmarkId":{"type":"string","minLength":1,"description":"Required when context is \'bookmark\'. Requires \'bookmark\' permission."},"tabId":{"type":"integer","minimum":0,"description":"Required when context is \'tab\'. Requires \'tabs\' permission."}}}]},{"name":"refresh","type":"function","description":"Updates the extension items in the shown menu, including changes that have been made since the menu was shown. Has no effect if the menu is hidden. Rebuilding a shown menu is an expensive operation, only invoke this method when necessary.","async":true,"parameters":[]},{"name":"getTargetElement","type":"function","allowedContexts":["content","devtools"],"description":"Retrieve the element that was associated with a recent contextmenu event.","parameters":[{"type":"integer","description":"The identifier of the clicked element, available as info.targetElementId in the menus.onShown, onClicked or onclick event.","name":"targetElementId"}],"returns":{"type":"object","optional":true,"isInstanceOf":"Element","additionalProperties":{}}}],"events":[{"name":"onClicked","type":"function","description":"Fired when a context menu item is clicked.","parameters":[{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","description":"Information about the item clicked and the context where the click happened."}]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the click took place. If the click did not take place in a tab, this parameter will be missing.","optional":true}]}]},{"name":"onShown","type":"function","description":"Fired when a menu is shown. The extension can add, modify or remove menu items and call menus.refresh() to update the menu.","parameters":[{"name":"info","type":"object","description":"Information about the context of the menu action and the created menu items. For more information about each property, see OnClickData. The following properties are only set if the extension has host permissions for the given context: linkUrl, linkText, srcUrl, pageUrl, frameUrl, selectionText.","properties":{"menuIds":{"description":"A list of IDs of the menu items that were shown.","type":"array","items":{"anyOf":[{"type":"integer"},{"type":"string"}]}},"contexts":{"description":"A list of all contexts that apply to the menu.","type":"array","items":{"$ref":"#/types/ContextType"}},"viewType":{"$ref":"extension#/types/ViewType"},"editable":{"type":"boolean"},"mediaType":{"type":"string"},"linkUrl":{"type":"string"},"linkText":{"type":"string"},"srcUrl":{"type":"string"},"pageUrl":{"type":"string"},"frameUrl":{"type":"string"},"selectionText":{"type":"string"},"targetElementId":{"type":"integer"}},"required":["menuIds","contexts","editable"]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the menu was opened."}]}]},{"name":"onHidden","type":"function","description":"Fired when a menu is hidden. This event is only fired if onShown has fired before.","parameters":[]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["menus","contextMenus"]}]},"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["menus.overrideContext"]}]}},"refs":{"menus#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"},"menus#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"}},"types":{"ContextType":{"description":"The different contexts a menu can appear in. Specifying \'all\' is equivalent to the combination of all other contexts except for \'tab\' and \'tools_menu\'.","anyOf":[{"type":"string","enum":["all","page","frame","selection","link","editable","password","image","video","audio","launcher","bookmark","tab","tools_menu"]},{"type":"string","enum":["browser_action","page_action"],"max_manifest_version":2},{"type":"string","enum":["action"],"min_manifest_version":3}]},"ItemType":{"type":"string","enum":["normal","checkbox","radio","separator"],"description":"The type of menu item."},"OnClickData":{"type":"object","description":"Information sent when a context menu item is clicked.","properties":{"menuItemId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The ID of the menu item that was clicked."},"parentMenuItemId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The parent ID, if any, for the item clicked."},"viewType":{"allOf":[{"$ref":"extension#/types/ViewType"},{"description":"The type of view where the menu is clicked. May be unset if the menu is not associated with a view."}]},"mediaType":{"type":"string","description":"One of \'image\', \'video\', or \'audio\' if the context menu was activated on one of these types of elements."},"linkText":{"type":"string","description":"If the element is a link, the text of that link."},"linkUrl":{"type":"string","description":"If the element is a link, the URL it points to."},"srcUrl":{"type":"string","description":"Will be present for elements with a \'src\' URL."},"pageUrl":{"type":"string","description":"The URL of the page where the menu item was clicked. This property is not set if the click occured in a context where there is no current page, such as in a launcher context menu."},"frameId":{"type":"integer","minimum":0,"description":"The id of the frame of the element where the context menu was clicked."},"frameUrl":{"type":"string","description":" The URL of the frame of the element where the context menu was clicked, if it was in a frame."},"selectionText":{"type":"string","description":"The text for the context selection, if any."},"editable":{"type":"boolean","description":"A flag indicating whether the element is editable (text input, textarea, etc.)."},"wasChecked":{"type":"boolean","description":"A flag indicating the state of a checkbox or radio item before it was clicked."},"checked":{"type":"boolean","description":"A flag indicating the state of a checkbox or radio item after it is clicked."},"bookmarkId":{"type":"string","description":"The id of the bookmark where the context menu was clicked, if it was on a bookmark."},"modifiers":{"type":"array","items":{"type":"string","enum":["Shift","Alt","Command","Ctrl","MacCtrl"]},"description":"An array of keyboard modifiers that were held while the menu item was clicked."},"button":{"type":"integer","description":"An integer value of button by which menu item was clicked."},"targetElementId":{"type":"integer","description":"An identifier of the clicked element, if any. Use menus.getTargetElement in the page to find the corresponding element."}},"required":["menuItemId","editable","bookmarkId","modifiers"]}},"allowedContexts":["content","devtools"]}');

/***/ }),
/* 60 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"menus","permissions":["menus"],"description":"The part of the menus API that is available in all extension contexts, including content scripts.","properties":{"ACTION_MENU_TOP_LEVEL_LIMIT":{"value":6,"description":"The maximum number of top level extension items that can be added to an extension action context menu. Any items beyond this limit will be ignored."}},"functions":[{"name":"create","type":"function","description":"Creates a new context menu item. Note that if an error occurs during creation, you may not find out until the creation callback fires (the details will be in $(ref:runtime.lastError)).","returns":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The ID of the newly created item."},"parameters":[{"type":"object","name":"createProperties","properties":{"type":{"allOf":[{"$ref":"#/types/ItemType"},{"description":"The type of menu item. Defaults to \'normal\' if not specified."}]},"id":{"type":"string","description":"The unique ID to assign to this item. Mandatory for event pages. Cannot be the same as another ID for this extension."},"icons":{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}},"title":{"type":"string","description":"The text to be displayed in the item; this is <em>required</em> unless <code>type</code> is \'separator\'. When the context is \'selection\', you can use <code>%s</code> within the string to show the selected text. For example, if this parameter\'s value is \\"Translate \'%s\' to Pig Latin\\" and the user selects the word \\"cool\\", the context menu item for the selection is \\"Translate \'cool\' to Pig Latin\\"."},"checked":{"type":"boolean","description":"The initial state of a checkbox or radio item: true for selected and false for unselected. Only one radio item can be selected at a time in a given group of radio items."},"contexts":{"type":"array","items":{"$ref":"#/types/ContextType"},"minItems":1,"description":"List of contexts this menu item will appear in. Defaults to [\'page\'] if not specified."},"viewTypes":{"type":"array","items":{"$ref":"extension#/types/ViewType"},"minItems":1,"description":"List of view types where the menu item will be shown. Defaults to any view, including those without a viewType."},"visible":{"type":"boolean","description":"Whether the item is visible in the menu."},"onclick":{"type":"function","description":"A function that will be called back when the menu item is clicked. Event pages cannot use this; instead, they should register a listener for $(ref:contextMenus.onClicked).","parameters":[{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","description":"Information about the item clicked and the context where the click happened."}]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the click took place. Note: this parameter only present for extensions."}]}]},"parentId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The ID of a parent menu item; this makes the item a child of a previously added item."},"documentUrlPatterns":{"type":"array","items":{"type":"string"},"description":"Lets you restrict the item to apply only to documents whose URL matches one of the given patterns. (This applies to frames as well.) For details on the format of a pattern, see $(topic:match_patterns)[Match Patterns]."},"targetUrlPatterns":{"type":"array","items":{"type":"string"},"description":"Similar to documentUrlPatterns, but lets you filter based on the src attribute of img/audio/video tags and the href of anchor tags."},"enabled":{"type":"boolean","description":"Whether this context menu item is enabled or disabled. Defaults to true."},"command":{"anyOf":[{"type":"string"},{"type":"string","enum":["_execute_browser_action","_execute_page_action","_execute_sidebar_action"],"max_manifest_version":2,"description":"Manifest V2 supports internal commands _execute_page_action, _execute_browser_action and _execute_sidebar_action."},{"type":"string","enum":["_execute_action","_execute_page_action","_execute_sidebar_action"],"min_manifest_version":3,"description":"Manifest V3 supports internal commands _execute_page_action, _execute_action and _execute_sidebar_action."}],"description":"Specifies a command to issue for the context click."}}},{"type":"function","name":"callback","optional":true,"description":"Called when the item has been created in the browser. If there were any problems creating the item, details will be available in $(ref:runtime.lastError).","parameters":[]}]},{"name":"update","type":"function","description":"Updates a previously created context menu item.","async":"callback","parameters":[{"anyOf":[{"type":"integer"},{"type":"string"}],"name":"id","description":"The ID of the item to update."},{"type":"object","name":"updateProperties","description":"The properties to update. Accepts the same values as the create function.","properties":{"type":{"$ref":"#/types/ItemType"},"icons":{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}},"title":{"type":"string"},"checked":{"type":"boolean"},"contexts":{"type":"array","items":{"$ref":"#/types/ContextType"},"minItems":1},"viewTypes":{"type":"array","items":{"$ref":"extension#/types/ViewType"},"minItems":1},"visible":{"type":"boolean","description":"Whether the item is visible in the menu."},"onclick":{"type":"function","parameters":[{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info"}]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the click took place. Note: this parameter only present for extensions."}]}]},"parentId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"Note: You cannot change an item to be a child of one of its own descendants."},"documentUrlPatterns":{"type":"array","items":{"type":"string"}},"targetUrlPatterns":{"type":"array","items":{"type":"string"}},"enabled":{"type":"boolean"}}},{"type":"function","name":"callback","optional":true,"parameters":[],"description":"Called when the context menu has been updated."}]},{"name":"remove","type":"function","description":"Removes a context menu item.","async":"callback","parameters":[{"anyOf":[{"type":"integer"},{"type":"string"}],"name":"menuItemId","description":"The ID of the context menu item to remove."},{"type":"function","name":"callback","optional":true,"parameters":[],"description":"Called when the context menu has been removed."}]},{"name":"removeAll","type":"function","description":"Removes all context menu items added by this extension.","async":"callback","parameters":[{"type":"function","name":"callback","optional":true,"parameters":[],"description":"Called when removal is complete."}]},{"name":"overrideContext","permissions":["menus.overrideContext"],"type":"function","description":"Show the matching menu items from this extension instead of the default menu. This should be called during a \'contextmenu\' DOM event handler, and only applies to the menu that opens after this event.","parameters":[{"name":"contextOptions","type":"object","properties":{"showDefaults":{"type":"boolean","default":false,"description":"Whether to also include default menu items in the menu."},"context":{"type":"string","enum":["bookmark","tab"],"description":"ContextType to override, to allow menu items from other extensions in the menu. Currently only \'bookmark\' and \'tab\' are supported. showDefaults cannot be used with this option."},"bookmarkId":{"type":"string","minLength":1,"description":"Required when context is \'bookmark\'. Requires \'bookmark\' permission."},"tabId":{"type":"integer","minimum":0,"description":"Required when context is \'tab\'. Requires \'tabs\' permission."}}}]},{"name":"refresh","type":"function","description":"Updates the extension items in the shown menu, including changes that have been made since the menu was shown. Has no effect if the menu is hidden. Rebuilding a shown menu is an expensive operation, only invoke this method when necessary.","async":true,"parameters":[]},{"name":"getTargetElement","type":"function","allowedContexts":["content","devtools"],"description":"Retrieve the element that was associated with a recent contextmenu event.","parameters":[{"type":"integer","description":"The identifier of the clicked element, available as info.targetElementId in the menus.onShown, onClicked or onclick event.","name":"targetElementId"}],"returns":{"type":"object","optional":true,"isInstanceOf":"Element","additionalProperties":{}}}],"events":[{"name":"onClicked","type":"function","description":"Fired when a context menu item is clicked.","parameters":[{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","description":"Information about the item clicked and the context where the click happened."}]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the click took place. If the click did not take place in a tab, this parameter will be missing.","optional":true}]}]},{"name":"onShown","type":"function","description":"Fired when a menu is shown. The extension can add, modify or remove menu items and call menus.refresh() to update the menu.","parameters":[{"name":"info","type":"object","description":"Information about the context of the menu action and the created menu items. For more information about each property, see OnClickData. The following properties are only set if the extension has host permissions for the given context: linkUrl, linkText, srcUrl, pageUrl, frameUrl, selectionText.","properties":{"menuIds":{"description":"A list of IDs of the menu items that were shown.","type":"array","items":{"anyOf":[{"type":"integer"},{"type":"string"}]}},"contexts":{"description":"A list of all contexts that apply to the menu.","type":"array","items":{"$ref":"#/types/ContextType"}},"viewType":{"$ref":"extension#/types/ViewType"},"editable":{"type":"boolean"},"mediaType":{"type":"string"},"linkUrl":{"type":"string"},"linkText":{"type":"string"},"srcUrl":{"type":"string"},"pageUrl":{"type":"string"},"frameUrl":{"type":"string"},"selectionText":{"type":"string"},"targetElementId":{"type":"integer"}},"required":["menuIds","contexts","editable"]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the menu was opened."}]}]},{"name":"onHidden","type":"function","description":"Fired when a menu is hidden. This event is only fired if onShown has fired before.","parameters":[]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["menus","contextMenus"]}]},"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["menus.overrideContext"]}]}},"refs":{"menus#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"},"menus#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"}},"types":{"ContextType":{"description":"The different contexts a menu can appear in. Specifying \'all\' is equivalent to the combination of all other contexts except for \'tab\' and \'tools_menu\'.","anyOf":[{"type":"string","enum":["all","page","frame","selection","link","editable","password","image","video","audio","launcher","bookmark","tab","tools_menu"]},{"type":"string","enum":["browser_action","page_action"],"max_manifest_version":2},{"type":"string","enum":["action"],"min_manifest_version":3}]},"ItemType":{"type":"string","enum":["normal","checkbox","radio","separator"],"description":"The type of menu item."},"OnClickData":{"type":"object","description":"Information sent when a context menu item is clicked.","properties":{"menuItemId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The ID of the menu item that was clicked."},"parentMenuItemId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The parent ID, if any, for the item clicked."},"viewType":{"allOf":[{"$ref":"extension#/types/ViewType"},{"description":"The type of view where the menu is clicked. May be unset if the menu is not associated with a view."}]},"mediaType":{"type":"string","description":"One of \'image\', \'video\', or \'audio\' if the context menu was activated on one of these types of elements."},"linkText":{"type":"string","description":"If the element is a link, the text of that link."},"linkUrl":{"type":"string","description":"If the element is a link, the URL it points to."},"srcUrl":{"type":"string","description":"Will be present for elements with a \'src\' URL."},"pageUrl":{"type":"string","description":"The URL of the page where the menu item was clicked. This property is not set if the click occured in a context where there is no current page, such as in a launcher context menu."},"frameId":{"type":"integer","minimum":0,"description":"The id of the frame of the element where the context menu was clicked."},"frameUrl":{"type":"string","description":" The URL of the frame of the element where the context menu was clicked, if it was in a frame."},"selectionText":{"type":"string","description":"The text for the context selection, if any."},"editable":{"type":"boolean","description":"A flag indicating whether the element is editable (text input, textarea, etc.)."},"wasChecked":{"type":"boolean","description":"A flag indicating the state of a checkbox or radio item before it was clicked."},"checked":{"type":"boolean","description":"A flag indicating the state of a checkbox or radio item after it is clicked."},"bookmarkId":{"type":"string","description":"The id of the bookmark where the context menu was clicked, if it was on a bookmark."},"modifiers":{"type":"array","items":{"type":"string","enum":["Shift","Alt","Command","Ctrl","MacCtrl"]},"description":"An array of keyboard modifiers that were held while the menu item was clicked."},"button":{"type":"integer","description":"An integer value of button by which menu item was clicked."},"targetElementId":{"type":"integer","description":"An identifier of the clicked element, if any. Use menus.getTargetElement in the page to find the corresponding element."}},"required":["menuItemId","editable","bookmarkId","modifiers"]}},"allowedContexts":["content","devtools"]}');

/***/ }),
/* 61 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"native_manifest","definitions":{},"refs":{},"types":{"NativeManifest":{"description":"Represents a native manifest file","anyOf":[{"type":"object","properties":{"name":{"type":"string","pattern":"^\\\\w+(\\\\.\\\\w+)*$"},"description":{"type":"string"},"path":{"type":"string"},"type":{"type":"string","enum":["pkcs11","stdio"]},"allowed_extensions":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/ExtensionID"}}},"required":["name","description","path","type","allowed_extensions"]},{"type":"object","properties":{"name":{"$ref":"manifest#/types/ExtensionID"},"description":{"type":"string"},"data":{"type":"object","additionalProperties":{}},"type":{"type":"string","enum":["storage"]}},"required":["name","description","data","type"]}]}}}');

/***/ }),
/* 62 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"networkStatus","description":"This API provides the ability to determine the status of and detect changes in the network connection. This API can only be used in privileged extensions.","permissions":["networkStatus"],"functions":[{"name":"getLinkInfo","type":"function","description":"Returns the $(ref:NetworkLinkInfo} of the current network connection.","async":true,"parameters":[]}],"events":[{"name":"onConnectionChanged","type":"function","description":"Fired when the network connection state changes.","parameters":[{"allOf":[{"$ref":"#/types/NetworkLinkInfo"},{"name":"details"}]}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["networkStatus"]}]}},"refs":{"networkStatus#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{"NetworkLinkInfo":{"type":"object","properties":{"status":{"type":"string","enum":["unknown","up","down"],"description":"Status of the network link, if \\"unknown\\" then link is usually assumed to be \\"up\\""},"type":{"type":"string","enum":["unknown","ethernet","usb","wifi","wimax","mobile"],"description":"If known, the type of network connection that is avialable."},"id":{"type":"string","description":"If known, the network id or name."}},"required":["status","type"]}}}');

/***/ }),
/* 63 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"normandyAddonStudy","description":"Normandy Study API","allowedContexts":["content","devtools"],"defaultContexts":["content","devtools"],"permissions":["normandyAddonStudy"],"functions":[{"name":"getStudy","type":"function","description":"Returns a study object for the current study.","async":true,"parameters":[]},{"name":"endStudy","type":"function","description":"Marks the study as ended and then uninstalls the addon.","async":true,"parameters":[{"type":"string","name":"reason","description":"The reason why the study is ending."}]},{"name":"getClientMetadata","type":"function","description":"Returns an object with metadata about the client which may be required for constructing survey URLs.","async":true,"parameters":[]}],"events":[{"name":"onUnenroll","type":"function","description":"Fired when a user unenrolls from a study but before the addon is uninstalled.","parameters":[{"type":"string","name":"reason","description":"The reason why the study is ending."}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["normandyAddonStudy"]}]}},"refs":{"normandyAddonStudy#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{"Study":{"type":"object","properties":{"recipeId":{"type":"integer","description":"The ID of the recipe for the study."},"slug":{"type":"string","description":"A slug to identify the study."},"userFacingName":{"type":"string","description":"The name presented on about:studies."},"userFacingDescription":{"type":"string","description":"The description presented on about:studies."},"branch":{"type":"string","description":"The study branch in which the user is enrolled."},"active":{"type":"boolean","description":"The state of the study."},"addonId":{"type":"string","description":"The ID of the extension installed by the study."},"addonUrl":{"type":"string","description":"The URL of the XPI that was downloaded and installed by the study."},"addonVersion":{"type":"string","description":"The version of the extension installed by the study."},"studyStartDate":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"The start date for the study."}]},"studyEndDate":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"The end date for the study."}]},"extensionApiId":{"type":"integer","description":"The record ID for the extension in Normandy server\'s database."},"extensionHash":{"type":"string","description":"A hash of the extension XPI file."},"extensionHashAlgorithm":{"type":"string","description":"The algorithm used to hash the extension XPI file."}},"required":["recipeId","slug","userFacingName","userFacingDescription","branch","active","addonId","addonUrl","addonVersion","studyStartDate","studyEndDate","extensionApiId","extensionHash","extensionHashAlgorithm"]}}}');

/***/ }),
/* 64 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"notifications","permissions":["notifications"],"functions":[{"name":"create","type":"function","description":"Creates and displays a notification.","async":"callback","parameters":[{"optional":true,"type":"string","name":"notificationId","description":"Identifier of the notification. If it is empty, this method generates an id. If it matches an existing notification, this method first clears that notification before proceeding with the create operation."},{"allOf":[{"$ref":"#/types/CreateNotificationOptions"},{"name":"options","description":"Contents of the notification."}]},{"optional":true,"type":"function","name":"callback","parameters":[{"name":"notificationId","type":"string","description":"The notification id (either supplied or generated) that represents the created notification."}]}]},{"name":"update","unsupported":true,"type":"function","description":"Updates an existing notification.","async":"callback","parameters":[{"type":"string","name":"notificationId","description":"The id of the notification to be updated."},{"allOf":[{"$ref":"#/types/UpdateNotificationOptions"},{"name":"options","description":"Contents of the notification to update to."}]},{"optional":true,"type":"function","name":"callback","parameters":[{"name":"wasUpdated","type":"boolean","description":"Indicates whether a matching notification existed."}]}]},{"name":"clear","type":"function","description":"Clears an existing notification.","async":"callback","parameters":[{"type":"string","name":"notificationId","description":"The id of the notification to be updated."},{"optional":true,"type":"function","name":"callback","parameters":[{"name":"wasCleared","type":"boolean","description":"Indicates whether a matching notification existed."}]}]},{"name":"getAll","type":"function","description":"Retrieves all the notifications.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"notifications","type":"object","additionalProperties":{"$ref":"#/types/CreateNotificationOptions"},"description":"The set of notifications currently in the system."}]}]},{"name":"getPermissionLevel","unsupported":true,"type":"function","description":"Retrieves whether the user has enabled notifications from this app or extension.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/PermissionLevel"},{"name":"level","description":"The current permission level."}]}]}]}],"events":[{"name":"onClosed","type":"function","description":"Fired when the notification closed, either by the system or by user action.","parameters":[{"type":"string","name":"notificationId","description":"The notificationId of the closed notification."},{"type":"boolean","name":"byUser","description":"True if the notification was closed by the user."}]},{"name":"onClicked","type":"function","description":"Fired when the user clicked in a non-button area of the notification.","parameters":[{"type":"string","name":"notificationId","description":"The notificationId of the clicked notification."}]},{"name":"onButtonClicked","type":"function","description":"Fired when the  user pressed a button in the notification.","parameters":[{"type":"string","name":"notificationId","description":"The notificationId of the clicked notification."},{"type":"number","name":"buttonIndex","description":"The index of the button clicked by the user."}]},{"name":"onPermissionLevelChanged","unsupported":true,"type":"function","description":"Fired when the user changes the permission level.","parameters":[{"allOf":[{"$ref":"#/types/PermissionLevel"},{"name":"level","description":"The new permission level."}]}]},{"name":"onShowSettings","unsupported":true,"type":"function","description":"Fired when the user clicked on a link for the app\'s notification settings.","parameters":[]},{"name":"onShown","type":"function","description":"Fired when the notification is shown.","parameters":[{"type":"string","name":"notificationId","description":"The notificationId of the shown notification."}]}],"definitions":{},"refs":{},"types":{"TemplateType":{"type":"string","enum":["basic","image","list","progress"]},"PermissionLevel":{"type":"string","enum":["granted","denied"]},"NotificationItem":{"type":"object","properties":{"title":{"description":"Title of one item of a list notification.","type":"string"},"message":{"description":"Additional details about this item.","type":"string"}},"required":["title","message"]},"CreateNotificationOptions":{"type":"object","properties":{"type":{"allOf":[{"$ref":"#/types/TemplateType"},{"description":"Which type of notification to display."}]},"iconUrl":{"description":"A URL to the sender\'s avatar, app icon, or a thumbnail for image notifications.","type":"string"},"appIconMaskUrl":{"description":"A URL to the app icon mask.","type":"string"},"title":{"description":"Title of the notification (e.g. sender name for email).","type":"string"},"message":{"description":"Main notification content.","type":"string"},"contextMessage":{"description":"Alternate notification content with a lower-weight font.","type":"string"},"priority":{"description":"Priority ranges from -2 to 2. -2 is lowest priority. 2 is highest. Zero is default.","type":"integer","minimum":-2,"maximum":2},"eventTime":{"description":"A timestamp associated with the notification, in milliseconds past the epoch.","type":"number"},"buttons":{"unsupported":true,"description":"Text and icons for up to two notification action buttons.","type":"array","items":{"type":"object","properties":{"title":{"type":"string"},"iconUrl":{"type":"string"}},"required":["title"]}},"imageUrl":{"description":"A URL to the image thumbnail for image-type notifications.","type":"string"},"items":{"description":"Items for multi-item notifications.","type":"array","items":{"$ref":"#/types/NotificationItem"}},"progress":{"description":"Current progress ranges from 0 to 100.","type":"integer","minimum":0,"maximum":100},"isClickable":{"description":"Whether to show UI indicating that the app will visibly respond to clicks on the body of a notification.","type":"boolean"}},"required":["type","title","message"]},"UpdateNotificationOptions":{"type":"object","properties":{"type":{"allOf":[{"$ref":"#/types/TemplateType"},{"description":"Which type of notification to display."}]},"iconUrl":{"description":"A URL to the sender\'s avatar, app icon, or a thumbnail for image notifications.","type":"string"},"appIconMaskUrl":{"description":"A URL to the app icon mask.","type":"string"},"title":{"description":"Title of the notification (e.g. sender name for email).","type":"string"},"message":{"description":"Main notification content.","type":"string"},"contextMessage":{"description":"Alternate notification content with a lower-weight font.","type":"string"},"priority":{"description":"Priority ranges from -2 to 2. -2 is lowest priority. 2 is highest. Zero is default.","type":"integer","minimum":-2,"maximum":2},"eventTime":{"description":"A timestamp associated with the notification, in milliseconds past the epoch.","type":"number"},"buttons":{"unsupported":true,"description":"Text and icons for up to two notification action buttons.","type":"array","items":{"type":"object","properties":{"title":{"type":"string"},"iconUrl":{"type":"string"}},"required":["title"]}},"imageUrl":{"description":"A URL to the image thumbnail for image-type notifications.","type":"string"},"items":{"description":"Items for multi-item notifications.","type":"array","items":{"$ref":"#/types/NotificationItem"}},"progress":{"description":"Current progress ranges from 0 to 100.","type":"integer","minimum":0,"maximum":100},"isClickable":{"description":"Whether to show UI indicating that the app will visibly respond to clicks on the body of a notification.","type":"boolean"}}}}}');

/***/ }),
/* 65 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"omnibox","description":"The omnibox API allows you to register a keyword with Firefox\'s address bar.","permissions":["manifest:omnibox"],"functions":[{"name":"setDefaultSuggestion","type":"function","description":"Sets the description and styling for the default suggestion. The default suggestion is the text that is displayed in the first suggestion row underneath the URL bar.","parameters":[{"allOf":[{"$ref":"#/types/DefaultSuggestResult"},{"name":"suggestion","description":"A partial SuggestResult object, without the \'content\' parameter."}]}]}],"events":[{"name":"onInputStarted","type":"function","description":"User has started a keyword input session by typing the extension\'s keyword. This is guaranteed to be sent exactly once per input session, and before any onInputChanged events.","parameters":[]},{"name":"onInputChanged","type":"function","description":"User has changed what is typed into the omnibox.","parameters":[{"type":"string","name":"text"},{"name":"suggest","type":"function","description":"A callback passed to the onInputChanged event used for sending suggestions back to the browser.","parameters":[{"name":"suggestResults","type":"array","description":"Array of suggest results","items":{"$ref":"#/types/SuggestResult"}}]}]},{"name":"onInputEntered","type":"function","description":"User has accepted what is typed into the omnibox.","parameters":[{"type":"string","name":"text"},{"allOf":[{"$ref":"#/types/OnInputEnteredDisposition"},{"name":"disposition"}]}]},{"name":"onInputCancelled","type":"function","description":"User has ended the keyword input session without accepting the input.","parameters":[]}],"definitions":{"WebExtensionManifest":{"properties":{"omnibox":{"type":"object","properties":{"keyword":{"type":"string","pattern":"^[^?\\\\s:][^\\\\s:]*$"}},"required":["keyword"]}}}},"refs":{"omnibox#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"DescriptionStyleType":{"type":"string","description":"The style type.","enum":["url","match","dim"]},"OnInputEnteredDisposition":{"type":"string","enum":["currentTab","newForegroundTab","newBackgroundTab"],"description":"The window disposition for the omnibox query. This is the recommended context to display results. For example, if the omnibox command is to navigate to a certain URL, a disposition of \'newForegroundTab\' means the navigation should take place in a new selected tab."},"SuggestResult":{"type":"object","description":"A suggest result.","properties":{"content":{"type":"string","minLength":1,"description":"The text that is put into the URL bar, and that is sent to the extension when the user chooses this entry."},"description":{"type":"string","minLength":1,"description":"The text that is displayed in the URL dropdown. Can contain XML-style markup for styling. The supported tags are \'url\' (for a literal URL), \'match\' (for highlighting text that matched what the user\'s query), and \'dim\' (for dim helper text). The styles can be nested, eg. <dim><match>dimmed match</match></dim>. You must escape the five predefined entities to display them as text: stackoverflow.com/a/1091953/89484 "},"descriptionStyles":{"unsupported":true,"type":"array","description":"An array of style ranges for the description, as provided by the extension.","items":{"type":"object","description":"The style ranges for the description, as provided by the extension.","properties":{"offset":{"type":"integer"},"type":{"allOf":[{"$ref":"#/types/DescriptionStyleType"},{"description":"The style type"}]},"length":{"type":"integer"}},"required":["offset","type"]}},"descriptionStylesRaw":{"unsupported":true,"type":"array","description":"An array of style ranges for the description, as provided by ToValue().","items":{"type":"object","description":"The style ranges for the description, as provided by ToValue().","properties":{"offset":{"type":"integer"},"type":{"type":"integer"}},"required":["offset","type"]}}},"required":["content","description"]},"DefaultSuggestResult":{"type":"object","description":"A suggest result.","properties":{"description":{"type":"string","minLength":1,"description":"The text that is displayed in the URL dropdown."},"descriptionStyles":{"unsupported":true,"type":"array","description":"An array of style ranges for the description, as provided by the extension.","items":{"type":"object","description":"The style ranges for the description, as provided by the extension.","properties":{"offset":{"type":"integer"},"type":{"allOf":[{"$ref":"#/types/DescriptionStyleType"},{"description":"The style type"}]},"length":{"type":"integer"}},"required":["offset","type"]}},"descriptionStylesRaw":{"unsupported":true,"type":"array","description":"An array of style ranges for the description, as provided by ToValue().","items":{"type":"object","description":"The style ranges for the description, as provided by ToValue().","properties":{"offset":{"type":"integer"},"type":{"type":"integer"}},"required":["offset","type"]}}},"required":["description"]}}}');

/***/ }),
/* 66 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"pageAction","description":"Use the <code>browser.pageAction</code> API to put icons inside the address bar. Page actions represent actions that can be taken on the current page, but that aren\'t applicable to all pages.","permissions":["manifest:page_action"],"functions":[{"name":"show","type":"function","async":"callback","description":"Shows the page action. The page action is shown whenever the tab is selected.","parameters":[{"type":"integer","name":"tabId","minimum":0,"description":"The id of the tab for which you want to modify the page action."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"hide","type":"function","async":"callback","description":"Hides the page action.","parameters":[{"type":"integer","name":"tabId","minimum":0,"description":"The id of the tab for which you want to modify the page action."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"isShown","type":"function","description":"Checks whether the page action is shown.","async":true,"parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","description":"Specify the tab to get the shownness from."}},"required":["tabId"]}]},{"name":"setTitle","type":"function","description":"Sets the title of the page action. This is displayed in a tooltip over the page action.","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","minimum":0,"description":"The id of the tab for which you want to modify the page action."},"title":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The tooltip string."}},"required":["tabId","title"]}]},{"name":"getTitle","type":"function","description":"Gets the title of the page action.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","description":"Specify the tab to get the title from."}},"required":["tabId"]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"setIcon","type":"function","description":"Sets the icon for the page action. The icon can be specified either as the path to an image file or as the pixel data from a canvas element, or as dictionary of either one of those. Either the <b>path</b> or the <b>imageData</b> property must be specified.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","minimum":0,"description":"The id of the tab for which you want to modify the page action."},"imageData":{"anyOf":[{"$ref":"#/types/ImageDataType"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"$ref":"#/types/ImageDataType"}}}],"description":"Either an ImageData object or a dictionary {size -> ImageData} representing icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.imageData = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"},"path":{"anyOf":[{"type":"string"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}}],"description":"Either a relative image path or a dictionary {size -> relative image path} pointing to icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.path = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"}},"required":["tabId"]},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"setPopup","type":"function","async":true,"description":"Sets the html document to be opened as a popup when the user clicks on the page action\'s icon.","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","minimum":0,"description":"The id of the tab for which you want to modify the page action."},"popup":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The html file to show in a popup.  If set to the empty string (\'\'), no popup is shown."}},"required":["tabId","popup"]}]},{"name":"getPopup","type":"function","description":"Gets the html document set as the popup for this page action.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","description":"Specify the tab to get the popup from."}},"required":["tabId"]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"openPopup","type":"function","requireUserInput":true,"description":"Opens the extension page action in the active window.","async":true,"parameters":[]}],"events":[{"name":"onClicked","type":"function","description":"Fired when a page action icon is clicked.  This event will not fire if the page action has a popup.","parameters":[{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab"}]},{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","optional":true}]}]}],"definitions":{"WebExtensionManifest":{"properties":{"page_action":{"type":"object","properties":{"default_title":{"type":"string","preprocess":"localize"},"default_icon":{"$ref":"manifest#/types/IconPath"},"default_popup":{"type":"string","format":"relativeUrl","preprocess":"localize"},"browser_style":{"type":"boolean","default":false},"show_matches":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/MatchPattern"}},"hide_matches":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/MatchPatternRestricted"}},"pinned":{"type":"boolean","default":true}}}}}},"refs":{"pageAction#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"ImageDataType":{"type":"object","isInstanceOf":"ImageData","additionalProperties":{},"postprocess":"convertImageDataToURL","description":"Pixel data for an image. Must be an ImageData object (for example, from a <code>canvas</code> element)."},"OnClickData":{"type":"object","description":"Information sent when a page action is clicked.","properties":{"modifiers":{"type":"array","items":{"type":"string","enum":["Shift","Alt","Command","Ctrl","MacCtrl"]},"description":"An array of keyboard modifiers that were held while the menu item was clicked."},"button":{"type":"integer","description":"An integer value of button by which menu item was clicked."}},"required":["modifiers"]}}}');

/***/ }),
/* 67 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"permissions","permissions":["manifest:optional_permissions"],"functions":[{"name":"getAll","type":"function","async":"callback","description":"Get a list of all the extension\'s permissions.","parameters":[{"name":"callback","type":"function","parameters":[{"allOf":[{"$ref":"#/types/AnyPermissions"},{"name":"permissions"}]}]}]},{"name":"contains","type":"function","async":"callback","description":"Check if the extension has the given permissions.","parameters":[{"allOf":[{"$ref":"#/types/AnyPermissions"},{"name":"permissions"}]},{"name":"callback","type":"function","parameters":[{"name":"result","type":"boolean"}]}]},{"name":"request","type":"function","allowedContexts":["content"],"async":"callback","requireUserInput":true,"description":"Request the given permissions.","parameters":[{"allOf":[{"$ref":"#/types/Permissions"},{"name":"permissions"}]},{"name":"callback","type":"function","parameters":[{"name":"granted","type":"boolean"}]}]},{"name":"remove","type":"function","async":"callback","description":"Relinquish the given permissions.","parameters":[{"allOf":[{"$ref":"#/types/Permissions"},{"name":"permissions"}]},{"name":"callback","type":"function","parameters":[]}]}],"events":[{"name":"onAdded","type":"function","description":"Fired when the extension acquires new permissions.","parameters":[{"allOf":[{"$ref":"#/types/Permissions"},{"name":"permissions"}]}]},{"name":"onRemoved","type":"function","description":"Fired when permissions are removed from the extension.","parameters":[{"allOf":[{"$ref":"#/types/Permissions"},{"name":"permissions"}]}]}],"definitions":{},"refs":{},"types":{"Permissions":{"type":"object","properties":{"permissions":{"type":"array","items":{"$ref":"manifest#/types/OptionalPermission"},"default":[]},"origins":{"type":"array","items":{"$ref":"manifest#/types/MatchPattern"},"default":[]}}},"AnyPermissions":{"type":"object","properties":{"permissions":{"type":"array","items":{"$ref":"manifest#/types/Permission"},"default":[]},"origins":{"type":"array","items":{"$ref":"manifest#/types/MatchPattern"},"default":[]}}}}}');

/***/ }),
/* 68 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"pkcs11","description":"PKCS#11 module management API","permissions":["pkcs11"],"functions":[{"name":"isModuleInstalled","type":"function","description":"checks whether a PKCS#11 module, given by name, is installed","async":true,"parameters":[{"name":"name","type":"string"}]},{"name":"installModule","type":"function","description":"Install a PKCS#11 module with a given name","async":true,"parameters":[{"name":"name","type":"string"},{"name":"flags","type":"integer","optional":true}]},{"name":"uninstallModule","type":"function","description":"Remove an installed PKCS#11 module from firefox","async":true,"parameters":[{"name":"name","type":"string"}]},{"name":"getModuleSlots","type":"function","description":"Enumerate a module\'s slots, each with their name and whether a token is present","async":true,"parameters":[{"name":"name","type":"string"}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["pkcs11"]}]}},"refs":{"pkcs11#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{}}');

/***/ }),
/* 69 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"privacy","permissions":["privacy"],"properties":{"network":{"description":"Use the <code>browser.privacy</code> API to control usage of the features in the browser that can affect a user\'s privacy.","permissions":["privacy"],"properties":{"networkPredictionEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If enabled, the browser attempts to speed up your web browsing experience by pre-resolving DNS entries, prerendering sites (<code>&lt;link rel=\'prefetch\' ...&gt;</code>), and preemptively opening TCP and SSL connections to servers.  This preference\'s value is a boolean, defaulting to <code>true</code>."}]},"peerConnectionEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allow users to enable and disable RTCPeerConnections (aka WebRTC)."}]},"webRTCIPHandlingPolicy":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allow users to specify the media performance/privacy tradeoffs which impacts how WebRTC traffic will be routed and how much local address information is exposed. This preference\'s value is of type IPHandlingPolicy, defaulting to <code>default</code>."}]},"tlsVersionRestriction":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This property controls the minimum and maximum TLS versions. This setting\'s value is an object of $(ref:tlsVersionRestrictionConfig)."}]},"httpsOnlyMode":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allow users to query the mode for \'HTTPS-Only Mode\'. This setting\'s value is of type HTTPSOnlyModeOption, defaulting to <code>never</code>."}]}},"required":["networkPredictionEnabled","peerConnectionEnabled","webRTCIPHandlingPolicy","tlsVersionRestriction","httpsOnlyMode"]},"services":{"description":"Use the <code>browser.privacy</code> API to control usage of the features in the browser that can affect a user\'s privacy.","permissions":["privacy"],"properties":{"passwordSavingEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If enabled, the password manager will ask if you want to save passwords. This preference\'s value is a boolean, defaulting to <code>true</code>."}]}},"required":["passwordSavingEnabled"]},"websites":{"description":"Use the <code>browser.privacy</code> API to control usage of the features in the browser that can affect a user\'s privacy.","permissions":["privacy"],"properties":{"thirdPartyCookiesAllowed":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If disabled, the browser blocks third-party sites from setting cookies. The value of this preference is of type boolean, and the default value is <code>true</code>.","unsupported":true}]},"hyperlinkAuditingEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If enabled, the browser sends auditing pings when requested by a website (<code>&lt;a ping&gt;</code>). The value of this preference is of type boolean, and the default value is <code>true</code>."}]},"referrersEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If enabled, the browser sends <code>referer</code> headers with your requests. Yes, the name of this preference doesn\'t match the misspelled header. No, we\'re not going to change it. The value of this preference is of type boolean, and the default value is <code>true</code>."}]},"resistFingerprinting":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If enabled, the browser attempts to appear similar to other users by reporting generic information to websites. This can prevent websites from uniquely identifying users. Examples of data that is spoofed include number of CPU cores, precision of JavaScript timers, the local timezone, and disabling features such as GamePad support, and the WebSpeech and Navigator APIs. The value of this preference is of type boolean, and the default value is <code>false</code>."}]},"firstPartyIsolate":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If enabled, the browser will associate all data (including cookies, HSTS data, cached images, and more) for any third party domains with the domain in the address bar. This prevents third party trackers from using directly stored information to identify you across different websites, but may break websites where you login with a third party account (such as a Facebook or Google login.) The value of this preference is of type boolean, and the default value is <code>false</code>."}]},"protectedContentEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"<strong>Available on Windows and ChromeOS only</strong>: If enabled, the browser provides a unique ID to plugins in order to run protected content. The value of this preference is of type boolean, and the default value is <code>true</code>.","unsupported":true}]},"trackingProtectionMode":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allow users to specify the mode for tracking protection. This setting\'s value is of type TrackingProtectionModeOption, defaulting to <code>private_browsing_only</code>."}]},"cookieConfig":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allow users to specify the default settings for allowing cookies, as well as whether all cookies should be created as non-persistent cookies. This setting\'s value is of type CookieConfig."}]}},"required":["thirdPartyCookiesAllowed","hyperlinkAuditingEnabled","referrersEnabled","resistFingerprinting","firstPartyIsolate","protectedContentEnabled","trackingProtectionMode","cookieConfig"]}},"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["privacy"]}]}},"refs":{"privacy#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"IPHandlingPolicy":{"type":"string","enum":["default","default_public_and_private_interfaces","default_public_interface_only","disable_non_proxied_udp","proxy_only"],"description":"The IP handling policy of WebRTC."},"tlsVersionRestrictionConfig":{"type":"object","description":"An object which describes TLS minimum and maximum versions.","properties":{"minimum":{"type":"string","enum":["TLSv1","TLSv1.1","TLSv1.2","TLSv1.3","unknown"],"description":"The minimum TLS version supported."},"maximum":{"type":"string","enum":["TLSv1","TLSv1.1","TLSv1.2","TLSv1.3","unknown"],"description":"The maximum TLS version supported."}}},"HTTPSOnlyModeOption":{"type":"string","enum":["always","private_browsing","never"],"description":"The mode for https-only mode."},"TrackingProtectionModeOption":{"type":"string","enum":["always","never","private_browsing"],"description":"The mode for tracking protection."},"CookieConfig":{"type":"object","description":"The settings for cookies.","properties":{"behavior":{"type":"string","enum":["allow_all","reject_all","reject_third_party","allow_visited","reject_trackers","reject_trackers_and_partition_foreign"],"description":"The type of cookies to allow."},"nonPersistentCookies":{"type":"boolean","default":false,"description":"Whether to create all cookies as nonPersistent (i.e., session) cookies."}}}}}');

/***/ }),
/* 70 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"proxy","description":"Provides access to global proxy settings for Firefox and proxy event listeners to handle dynamic proxy implementations.","permissions":["proxy"],"properties":{"settings":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Configures proxy settings. This setting\'s value is an object of type ProxyConfig."}]}},"events":[{"name":"onRequest","type":"function","description":"Fired when proxy data is needed for a request.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"webRequest#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"fromCache":{"type":"boolean","description":"Indicates if this response was fetched from disk cache."},"requestHeaders":{"allOf":[{"$ref":"webRequest#/types/HttpHeaders"},{"description":"The HTTP request headers that are going to be sent out with this request."}]},"urlClassification":{"allOf":[{"$ref":"webRequest#/types/UrlClassification"},{"description":"Url classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","fromCache","urlClassification","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"webRequest#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"type":"string","enum":["requestHeaders"]}}]},{"name":"onError","type":"function","description":"Notifies about errors caused by the invalid use of the proxy API.","parameters":[{"name":"error","type":"object"}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["proxy"]}]}},"refs":{"proxy#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"ProxyConfig":{"type":"object","description":"An object which describes proxy settings.","properties":{"proxyType":{"type":"string","enum":["none","autoDetect","system","manual","autoConfig"],"description":"The type of proxy to use."},"http":{"type":"string","description":"The address of the http proxy, can include a port."},"httpProxyAll":{"type":"boolean","description":"Use the http proxy server for all protocols."},"ftp":{"type":"string","deprecated":true,"description":"The address of the ftp proxy, can include a port.  Deprecated since Firefox 88."},"ssl":{"type":"string","description":"The address of the ssl proxy, can include a port."},"socks":{"type":"string","description":"The address of the socks proxy, can include a port."},"socksVersion":{"type":"integer","description":"The version of the socks proxy.","minimum":4,"maximum":5},"passthrough":{"type":"string","description":"A list of hosts which should not be proxied."},"autoConfigUrl":{"type":"string","description":"A URL to use to configure the proxy."},"autoLogin":{"type":"boolean","description":"Do not prompt for authentication if password is saved."},"proxyDNS":{"type":"boolean","description":"Proxy DNS when using SOCKS v5."},"respectBeConservative":{"type":"boolean","default":true,"description":" If true (the default value), do not use newer TLS protocol features that might have interoperability problems on the Internet. This is intended only for use with critical infrastructure like the updates, and is only available to privileged addons."}}}}}');

/***/ }),
/* 71 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"runtime","allowedContexts":["content","devtools"],"description":"Use the <code>browser.runtime</code> API to retrieve the background page, return details about the manifest, and listen for and respond to events in the app or extension lifecycle. You can also use this API to convert the relative path of URLs to fully-qualified URLs.","properties":{"lastError":{"type":"object","optional":true,"allowedContexts":["content","devtools"],"description":"This will be defined during an API method callback if there was an error","properties":{"message":{"type":"string","description":"Details about the error which occurred."}},"additionalProperties":{}},"id":{"type":"string","allowedContexts":["content","devtools"],"description":"The ID of the extension/app."}},"functions":[{"name":"getBackgroundPage","max_manifest_version":2,"type":"function","description":"Retrieves the JavaScript \'window\' object for the background page running inside the current extension/app. If the background page is an event page, the system will ensure it is loaded before calling the callback. If there is no background page, an error is set.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"backgroundPage","optional":true,"type":"object","isInstanceOf":"Window","additionalProperties":{},"description":"The JavaScript \'window\' object for the background page."}]}]},{"name":"openOptionsPage","type":"function","description":"<p>Open your Extension\'s options page, if possible.</p><p>The precise behavior may depend on your manifest\'s <code>$(topic:optionsV2)[options_ui]</code> or <code>$(topic:options)[options_page]</code> key, or what the browser happens to support at the time.</p><p>If your Extension does not declare an options page, or the browser failed to create one for some other reason, the callback will set $(ref:lastError).</p>","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[],"optional":true}]},{"name":"getManifest","allowedContexts":["content","devtools"],"description":"Returns details about the app or extension from the manifest. The object returned is a serialization of the full $(topic:manifest)[manifest file].","type":"function","parameters":[],"returns":{"type":"object","properties":{},"additionalProperties":{},"description":"The manifest details."}},{"name":"getURL","type":"function","allowedContexts":["content","devtools"],"description":"Converts a relative path within an app/extension install directory to a fully-qualified URL.","parameters":[{"type":"string","name":"path","description":"A path to a resource within an app/extension expressed relative to its install directory."}],"returns":{"type":"string","description":"The fully-qualified URL to the resource."}},{"name":"setUninstallURL","type":"function","description":"Sets the URL to be visited upon uninstallation. This may be used to clean up server-side data, do analytics, and implement surveys. Maximum 255 characters.","async":"callback","parameters":[{"type":"string","name":"url","optional":true,"maxLength":255,"description":"URL to be opened after the extension is uninstalled. This URL must have an http: or https: scheme. Set an empty string to not open a new tab upon uninstallation."},{"type":"function","name":"callback","optional":true,"description":"Called when the uninstall URL is set. If the given URL is invalid, $(ref:runtime.lastError) will be set.","parameters":[]}]},{"name":"reload","description":"Reloads the app or extension.","type":"function","parameters":[]},{"name":"requestUpdateCheck","unsupported":true,"type":"function","description":"Requests an update check for this app/extension.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/RequestUpdateCheckStatus"},{"name":"status","description":"Result of the update check."}]},{"name":"details","type":"object","optional":true,"properties":{"version":{"type":"string","description":"The version of the available update."}},"description":"If an update is available, this contains more information about the available update.","required":["version"]}]}]},{"name":"restart","unsupported":true,"description":"Restart the device when the app runs in kiosk mode. Otherwise, it\'s no-op.","type":"function","parameters":[]},{"name":"connect","type":"function","allowedContexts":["content","devtools"],"description":"Attempts to connect to connect listeners within an extension/app (such as the background page), or other extensions/apps. This is useful for content scripts connecting to their extension processes, inter-app/extension communication, and $(topic:manifest/externally_connectable)[web messaging]. Note that this does not connect to any listeners in a content script. Extensions may connect to content scripts embedded in tabs via $(ref:tabs.connect).","parameters":[{"type":"string","name":"extensionId","optional":true,"description":"The ID of the extension or app to connect to. If omitted, a connection will be attempted with your own extension. Required if sending messages from a web page for $(topic:manifest/externally_connectable)[web messaging]."},{"type":"object","name":"connectInfo","properties":{"name":{"type":"string","description":"Will be passed into onConnect for processes that are listening for the connection event."},"includeTlsChannelId":{"type":"boolean","description":"Whether the TLS channel ID will be passed into onConnectExternal for processes that are listening for the connection event."}},"optional":true}],"returns":{"allOf":[{"$ref":"#/types/Port"},{"description":"Port through which messages can be sent and received. The port\'s $(ref:runtime.Port onDisconnect) event is fired if the extension/app does not exist. "}]}},{"name":"connectNative","type":"function","description":"Connects to a native application in the host machine.","allowedContexts":["content"],"permissions":["nativeMessaging"],"parameters":[{"type":"string","pattern":"^\\\\w+(\\\\.\\\\w+)*$","name":"application","description":"The name of the registered application to connect to."}],"returns":{"allOf":[{"$ref":"#/types/Port"},{"description":"Port through which messages can be sent and received with the application"}]}},{"name":"sendMessage","type":"function","allowAmbiguousOptionalArguments":true,"allowedContexts":["content","devtools"],"description":"Sends a single message to event listeners within your extension/app or a different extension/app. Similar to $(ref:runtime.connect) but only sends a single message, with an optional response. If sending to your extension, the $(ref:runtime.onMessage) event will be fired in each page, or $(ref:runtime.onMessageExternal), if a different extension. Note that extensions cannot send messages to content scripts using this method. To send messages to content scripts, use $(ref:tabs.sendMessage).","async":"responseCallback","parameters":[{"type":"string","name":"extensionId","optional":true,"description":"The ID of the extension/app to send the message to. If omitted, the message will be sent to your own extension/app. Required if sending messages from a web page for $(topic:manifest/externally_connectable)[web messaging]."},{"name":"message"},{"type":"object","name":"options","properties":{"includeTlsChannelId":{"type":"boolean","unsupported":true,"description":"Whether the TLS channel ID will be passed into onMessageExternal for processes that are listening for the connection event."}},"optional":true},{"type":"function","name":"responseCallback","optional":true,"parameters":[{"name":"response","description":"The JSON response object sent by the handler of the message. If an error occurs while connecting to the extension, the callback will be called with no arguments and $(ref:runtime.lastError) will be set to the error message."}]}]},{"name":"sendNativeMessage","type":"function","description":"Send a single message to a native application.","allowedContexts":["content"],"permissions":["nativeMessaging"],"async":"responseCallback","parameters":[{"name":"application","description":"The name of the native messaging host.","type":"string","pattern":"^\\\\w+(\\\\.\\\\w+)*$"},{"name":"message","description":"The message that will be passed to the native messaging host."},{"type":"function","name":"responseCallback","optional":true,"parameters":[{"name":"response","description":"The response message sent by the native messaging host. If an error occurs while connecting to the native messaging host, the callback will be called with no arguments and $(ref:runtime.lastError) will be set to the error message."}]}]},{"name":"getBrowserInfo","type":"function","description":"Returns information about the current browser.","async":"callback","parameters":[{"type":"function","name":"callback","description":"Called with results","parameters":[{"allOf":[{"$ref":"#/types/BrowserInfo"},{"name":"browserInfo"}]}]}]},{"name":"getPlatformInfo","type":"function","description":"Returns information about the current platform.","async":"callback","parameters":[{"type":"function","name":"callback","description":"Called with results","parameters":[{"allOf":[{"$ref":"#/types/PlatformInfo"},{"name":"platformInfo"}]}]}]},{"name":"getPackageDirectoryEntry","unsupported":true,"type":"function","description":"Returns a DirectoryEntry for the package directory.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"directoryEntry","type":"object","additionalProperties":{},"isInstanceOf":"DirectoryEntry"}]}]}],"events":[{"name":"onStartup","type":"function","description":"Fired when a profile that has this extension installed first starts up. This event is not fired for incognito profiles."},{"name":"onInstalled","type":"function","description":"Fired when the extension is first installed, when the extension is updated to a new version, and when the browser is updated to a new version.","parameters":[{"type":"object","name":"details","properties":{"reason":{"allOf":[{"$ref":"#/types/OnInstalledReason"},{"description":"The reason that this event is being dispatched."}]},"previousVersion":{"type":"string","description":"Indicates the previous version of the extension, which has just been updated. This is present only if \'reason\' is \'update\'."},"temporary":{"type":"boolean","description":"Indicates whether the addon is installed as a temporary extension."},"id":{"type":"string","unsupported":true,"description":"Indicates the ID of the imported shared module extension which updated. This is present only if \'reason\' is \'shared_module_update\'."}},"required":["reason","temporary"]}]},{"name":"onSuspend","unsupported":true,"type":"function","description":"Sent to the event page just before it is unloaded. This gives the extension opportunity to do some clean up. Note that since the page is unloading, any asynchronous operations started while handling this event are not guaranteed to complete. If more activity for the event page occurs before it gets unloaded the onSuspendCanceled event will be sent and the page won\'t be unloaded. "},{"name":"onSuspendCanceled","unsupported":true,"type":"function","description":"Sent after onSuspend to indicate that the app won\'t be unloaded after all."},{"name":"onUpdateAvailable","type":"function","description":"Fired when an update is available, but isn\'t installed immediately because the app is currently running. If you do nothing, the update will be installed the next time the background page gets unloaded, if you want it to be installed sooner you can explicitly call $(ref:runtime.reload). If your extension is using a persistent background page, the background page of course never gets unloaded, so unless you call $(ref:runtime.reload) manually in response to this event the update will not get installed until the next time the browser itself restarts. If no handlers are listening for this event, and your extension has a persistent background page, it behaves as if $(ref:runtime.reload) is called in response to this event.","parameters":[{"type":"object","name":"details","properties":{"version":{"type":"string","description":"The version number of the available update."}},"additionalProperties":{},"description":"The manifest details of the available update.","required":["version"]}]},{"name":"onBrowserUpdateAvailable","unsupported":true,"type":"function","description":"Fired when an update for the browser is available, but isn\'t installed immediately because a browser restart is required.","deprecated":"Please use $(ref:runtime.onRestartRequired).","parameters":[]},{"name":"onConnect","type":"function","allowedContexts":["content","devtools"],"description":"Fired when a connection is made from either an extension process or a content script.","parameters":[{"allOf":[{"$ref":"#/types/Port"},{"name":"port"}]}]},{"name":"onConnectExternal","type":"function","description":"Fired when a connection is made from another extension.","parameters":[{"allOf":[{"$ref":"#/types/Port"},{"name":"port"}]}]},{"name":"onMessage","type":"function","allowedContexts":["content","devtools"],"description":"Fired when a message is sent from either an extension process or a content script.","parameters":[{"name":"message","optional":true,"description":"The message sent by the calling script."},{"allOf":[{"$ref":"#/types/MessageSender"},{"name":"sender"}]},{"name":"sendResponse","type":"function","description":"Function to call (at most once) when you have a response. The argument should be any JSON-ifiable object. If you have more than one <code>onMessage</code> listener in the same document, then only one may send a response. This function becomes invalid when the event listener returns, unless you return true from the event listener to indicate you wish to send a response asynchronously (this will keep the message channel open to the other end until <code>sendResponse</code> is called)."}],"returns":{"type":"boolean","optional":true,"description":"Return true from the event listener if you wish to call <code>sendResponse</code> after the event listener returns."}},{"name":"onMessageExternal","type":"function","description":"Fired when a message is sent from another extension/app. Cannot be used in a content script.","parameters":[{"name":"message","optional":true,"description":"The message sent by the calling script."},{"allOf":[{"$ref":"#/types/MessageSender"},{"name":"sender"}]},{"name":"sendResponse","type":"function","description":"Function to call (at most once) when you have a response. The argument should be any JSON-ifiable object. If you have more than one <code>onMessage</code> listener in the same document, then only one may send a response. This function becomes invalid when the event listener returns, unless you return true from the event listener to indicate you wish to send a response asynchronously (this will keep the message channel open to the other end until <code>sendResponse</code> is called)."}],"returns":{"type":"boolean","optional":true,"description":"Return true from the event listener if you wish to call <code>sendResponse</code> after the event listener returns."}},{"name":"onRestartRequired","unsupported":true,"type":"function","description":"Fired when an app or the device that it runs on needs to be restarted. The app should close all its windows at its earliest convenient time to let the restart to happen. If the app does nothing, a restart will be enforced after a 24-hour grace period has passed. Currently, this event is only fired for Chrome OS kiosk apps.","parameters":[{"allOf":[{"$ref":"#/types/OnRestartRequiredReason"},{"name":"reason","description":"The reason that the event is being dispatched."}]}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["nativeMessaging"]}]}},"refs":{"runtime#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"Port":{"type":"object","allowedContexts":["content","devtools"],"description":"An object which allows two way communication with other pages.","properties":{"name":{"type":"string"},"disconnect":{"type":"function"},"onDisconnect":{"$ref":"events#/types/Event"},"onMessage":{"$ref":"events#/types/Event"},"postMessage":{"type":"function"},"sender":{"allOf":[{"$ref":"#/types/MessageSender"},{"description":"This property will <b>only</b> be present on ports passed to onConnect/onConnectExternal listeners."}]}},"additionalProperties":{},"required":["name","disconnect","onDisconnect","onMessage","postMessage"]},"MessageSender":{"type":"object","allowedContexts":["content","devtools"],"description":"An object containing information about the script context that sent a message or request.","properties":{"tab":{"allOf":[{"$ref":"tabs#/types/Tab"},{"description":"The $(ref:tabs.Tab) which opened the connection, if any. This property will <strong>only</strong> be present when the connection was opened from a tab (including content scripts), and <strong>only</strong> if the receiver is an extension, not an app."}]},"frameId":{"type":"integer","description":"The $(topic:frame_ids)[frame] that opened the connection. 0 for top-level frames, positive for child frames. This will only be set when <code>tab</code> is set."},"id":{"type":"string","description":"The ID of the extension or app that opened the connection, if any."},"url":{"type":"string","description":"The URL of the page or frame that opened the connection. If the sender is in an iframe, it will be iframe\'s URL not the URL of the page which hosts it."},"tlsChannelId":{"unsupported":true,"type":"string","description":"The TLS channel ID of the page or frame that opened the connection, if requested by the extension or app, and if available."}}},"PlatformOs":{"type":"string","allowedContexts":["content","devtools"],"description":"The operating system the browser is running on.","enum":["mac","win","android","cros","linux","openbsd"]},"PlatformArch":{"type":"string","enum":["aarch64","arm","ppc64","s390x","sparc64","x86-32","x86-64"],"allowedContexts":["content","devtools"],"description":"The machine\'s processor architecture."},"PlatformInfo":{"type":"object","allowedContexts":["content","devtools"],"description":"An object containing information about the current platform.","properties":{"os":{"allOf":[{"$ref":"#/types/PlatformOs"},{"description":"The operating system the browser is running on."}]},"arch":{"allOf":[{"$ref":"#/types/PlatformArch"},{"description":"The machine\'s processor architecture."}]},"nacl_arch":{"allOf":[{"$ref":"#/types/PlatformNaclArch"},{"unsupported":true,"description":"The native client architecture. This may be different from arch on some platforms."}]}},"required":["os","arch","nacl_arch"]},"BrowserInfo":{"type":"object","description":"An object containing information about the current browser.","properties":{"name":{"type":"string","description":"The name of the browser, for example \'Firefox\'."},"vendor":{"type":"string","description":"The name of the browser vendor, for example \'Mozilla\'."},"version":{"type":"string","description":"The browser\'s version, for example \'42.0.0\' or \'0.8.1pre\'."},"buildID":{"type":"string","description":"The browser\'s build ID/date, for example \'20160101\'."}},"required":["name","vendor","version","buildID"]},"RequestUpdateCheckStatus":{"type":"string","enum":["throttled","no_update","update_available"],"allowedContexts":["content","devtools"],"description":"Result of the update check."},"OnInstalledReason":{"type":"string","enum":["install","update","browser_update"],"allowedContexts":["content","devtools"],"description":"The reason that this event is being dispatched."},"OnRestartRequiredReason":{"type":"string","allowedContexts":["content","devtools"],"description":"The reason that the event is being dispatched. \'app_update\' is used when the restart is needed because the application is updated to a newer version. \'os_update\' is used when the restart is needed because the browser/OS is updated to a newer version. \'periodic\' is used when the system runs for more than the permitted uptime set in the enterprise policy.","enum":["app_update","os_update","periodic"]}}}');

/***/ }),
/* 72 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"search","description":"Use browser.search to interact with search engines.","permissions":["search"],"functions":[{"name":"get","type":"function","description":"Gets a list of search engines.","async":true,"parameters":[]},{"name":"search","type":"function","description":"Perform a search.","async":true,"parameters":[{"type":"object","name":"searchProperties","properties":{"query":{"type":"string","description":"Terms to search for."},"engine":{"type":"string","description":"Search engine to use. Uses the default if not specified."},"tabId":{"type":"integer","description":"The ID of the tab for the search results. If not specified, a new tab is created."}},"required":["query"]}]}],"definitions":{"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["search"]}]}},"refs":{"search#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"}},"types":{"SearchEngine":{"type":"object","description":"An object encapsulating a search engine","properties":{"name":{"type":"string"},"isDefault":{"type":"boolean"},"alias":{"type":"string"},"favIconUrl":{"type":"string","format":"url"}},"required":["name","isDefault"]}}}');

/***/ }),
/* 73 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"sessions","description":"Use the <code>chrome.sessions</code> API to query and restore tabs and windows from a browsing session.","permissions":["sessions"],"functions":[{"name":"forgetClosedTab","type":"function","description":"Forget a recently closed tab.","async":true,"parameters":[{"name":"windowId","type":"integer","description":"The windowId of the window to which the recently closed tab to be forgotten belongs."},{"name":"sessionId","type":"string","description":"The sessionId (closedId) of the recently closed tab to be forgotten."}]},{"name":"forgetClosedWindow","type":"function","description":"Forget a recently closed window.","async":true,"parameters":[{"name":"sessionId","type":"string","description":"The sessionId (closedId) of the recently closed window to be forgotten."}]},{"name":"getRecentlyClosed","type":"function","description":"Gets the list of recently closed tabs and/or windows.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Filter"},{"name":"filter","optional":true,"default":{}}]},{"type":"function","name":"callback","parameters":[{"name":"sessions","type":"array","items":{"$ref":"#/types/Session"},"description":"The list of closed entries in reverse order that they were closed (the most recently closed tab or window will be at index <code>0</code>). The entries may contain either tabs or windows."}]}]},{"name":"getDevices","unsupported":true,"type":"function","description":"Retrieves all devices with synced sessions.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Filter"},{"name":"filter","optional":true}]},{"type":"function","name":"callback","parameters":[{"name":"devices","type":"array","items":{"$ref":"#/types/Device"},"description":"The list of $(ref:sessions.Device) objects for each synced session, sorted in order from device with most recently modified session to device with least recently modified session. $(ref:tabs.Tab) objects are sorted by recency in the $(ref:windows.Window) of the $(ref:sessions.Session) objects."}]}]},{"name":"restore","type":"function","description":"Reopens a $(ref:windows.Window) or $(ref:tabs.Tab), with an optional callback to run when the entry has been restored.","async":"callback","parameters":[{"type":"string","name":"sessionId","optional":true,"description":"The $(ref:windows.Window.sessionId), or $(ref:tabs.Tab.sessionId) to restore. If this parameter is not specified, the most recently closed session is restored."},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Session"},{"name":"restoredSession","description":"A $(ref:sessions.Session) containing the restored $(ref:windows.Window) or $(ref:tabs.Tab) object."}]}]}]},{"name":"setTabValue","type":"function","description":"Set a key/value pair on a given tab.","async":true,"parameters":[{"type":"integer","minimum":0,"name":"tabId","description":"The id of the tab that the key/value pair is being set on."},{"type":"string","name":"key","description":"The key which corresponds to the value being set."},{"name":"value","description":"The value being set."}]},{"name":"getTabValue","type":"function","description":"Retrieve a value that was set for a given key on a given tab.","async":true,"parameters":[{"type":"integer","minimum":0,"name":"tabId","description":"The id of the tab whose value is being retrieved from."},{"type":"string","name":"key","description":"The key which corresponds to the value."}]},{"name":"removeTabValue","type":"function","description":"Remove a key/value pair that was set on a given tab.","async":true,"parameters":[{"type":"integer","minimum":0,"name":"tabId","description":"The id of the tab whose key/value pair is being removed."},{"type":"string","name":"key","description":"The key which corresponds to the value."}]},{"name":"setWindowValue","type":"function","description":"Set a key/value pair on a given window.","async":true,"parameters":[{"type":"integer","minimum":-2,"name":"windowId","description":"The id of the window that the key/value pair is being set on."},{"type":"string","name":"key","description":"The key which corresponds to the value being set."},{"name":"value","description":"The value being set."}]},{"name":"getWindowValue","type":"function","description":"Retrieve a value that was set for a given key on a given window.","async":true,"parameters":[{"type":"integer","minimum":-2,"name":"windowId","description":"The id of the window whose value is being retrieved from."},{"type":"string","name":"key","description":"The key which corresponds to the value."}]},{"name":"removeWindowValue","type":"function","description":"Remove a key/value pair that was set on a given window.","async":true,"parameters":[{"type":"integer","minimum":-2,"name":"windowId","description":"The id of the window whose key/value pair is being removed."},{"type":"string","name":"key","description":"The key which corresponds to the value."}]}],"events":[{"name":"onChanged","description":"Fired when recently closed tabs and/or windows are changed. This event does not monitor synced sessions changes.","type":"function"}],"properties":{"MAX_SESSION_RESULTS":{"value":25,"description":"The maximum number of $(ref:sessions.Session) that will be included in a requested list."}},"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["sessions"]}]}},"refs":{"sessions#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"Filter":{"type":"object","properties":{"maxResults":{"type":"integer","minimum":0,"maximum":25,"description":"The maximum number of entries to be fetched in the requested list. Omit this parameter to fetch the maximum number of entries ($(ref:sessions.MAX_SESSION_RESULTS))."}}},"Session":{"type":"object","properties":{"lastModified":{"type":"integer","description":"The time when the window or tab was closed or modified, represented in milliseconds since the epoch."},"tab":{"allOf":[{"$ref":"tabs#/types/Tab"},{"description":"The $(ref:tabs.Tab), if this entry describes a tab. Either this or $(ref:sessions.Session.window) will be set."}]},"window":{"allOf":[{"$ref":"windows#/types/Window"},{"description":"The $(ref:windows.Window), if this entry describes a window. Either this or $(ref:sessions.Session.tab) will be set."}]}},"required":["lastModified"]},"Device":{"type":"object","properties":{"info":{"type":"string"},"deviceName":{"type":"string","description":"The name of the foreign device."},"sessions":{"type":"array","items":{"$ref":"#/types/Session"},"description":"A list of open window sessions for the foreign device, sorted from most recently to least recently modified session."}},"required":["info","deviceName","sessions"]}}}');

/***/ }),
/* 74 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"sidebarAction","description":"Use sidebar actions to add a sidebar to Firefox.","permissions":["manifest:sidebar_action"],"functions":[{"name":"setTitle","type":"function","description":"Sets the title of the sidebar action. This shows up in the tooltip.","async":true,"parameters":[{"name":"details","type":"object","properties":{"title":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The string the sidebar action should display when moused over."},"tabId":{"type":"integer","description":"Sets the sidebar title for the tab specified by tabId. Automatically resets when the tab is closed."},"windowId":{"type":"integer","minimum":-2,"description":"Sets the sidebar title for the window specified by windowId."}},"required":["title"]}]},{"name":"getTitle","type":"function","description":"Gets the title of the sidebar action.","async":true,"parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","description":"Specify the tab to get the title from. If no tab nor window is specified, the global title is returned."},"windowId":{"type":"integer","minimum":-2,"description":"Specify the window to get the title from. If no tab nor window is specified, the global title is returned."}}}]},{"name":"setIcon","type":"function","description":"Sets the icon for the sidebar action. The icon can be specified either as the path to an image file or as the pixel data from a canvas element, or as dictionary of either one of those. Either the <strong>path</strong> or the <strong>imageData</strong> property must be specified.","async":true,"parameters":[{"name":"details","type":"object","properties":{"imageData":{"anyOf":[{"$ref":"#/types/ImageDataType"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"$ref":"#/types/ImageDataType"}},"additionalProperties":false}],"description":"Either an ImageData object or a dictionary {size -> ImageData} representing icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.imageData = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"},"path":{"anyOf":[{"type":"string"},{"type":"object","additionalProperties":{"type":"string"}}],"description":"Either a relative image path or a dictionary {size -> relative image path} pointing to icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.path = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"},"tabId":{"type":"integer","description":"Sets the sidebar icon for the tab specified by tabId. Automatically resets when the tab is closed."},"windowId":{"type":"integer","minimum":-2,"description":"Sets the sidebar icon for the window specified by windowId."}}}]},{"name":"setPanel","type":"function","description":"Sets the url to the html document to be opened in the sidebar when the user clicks on the sidebar action\'s icon.","async":true,"parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","minimum":0,"description":"Sets the sidebar url for the tab specified by tabId. Automatically resets when the tab is closed."},"windowId":{"type":"integer","minimum":-2,"description":"Sets the sidebar url for the window specified by windowId."},"panel":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The url to the html file to show in a sidebar.  If set to the empty string (\'\'), no sidebar is shown."}},"required":["panel"]}]},{"name":"getPanel","type":"function","description":"Gets the url to the html document set as the panel for this sidebar action.","async":true,"parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","description":"Specify the tab to get the panel from. If no tab nor window is specified, the global panel is returned."},"windowId":{"type":"integer","minimum":-2,"description":"Specify the window to get the panel from. If no tab nor window is specified, the global panel is returned."}}}]},{"name":"open","type":"function","requireUserInput":true,"description":"Opens the extension sidebar in the active window.","async":true,"parameters":[]},{"name":"close","type":"function","requireUserInput":true,"description":"Closes the extension sidebar in the active window if the sidebar belongs to the extension.","async":true,"parameters":[]},{"name":"toggle","type":"function","requireUserInput":true,"description":"Toggles the extension sidebar in the active window.","async":true,"parameters":[]},{"name":"isOpen","type":"function","description":"Checks whether the sidebar action is open.","async":true,"parameters":[{"name":"details","type":"object","properties":{"windowId":{"type":"integer","minimum":-2,"description":"Specify the window to get the openness from."}}}]}],"definitions":{"WebExtensionManifest":{"properties":{"sidebar_action":{"type":"object","properties":{"default_title":{"type":"string","preprocess":"localize"},"default_icon":{"$ref":"manifest#/types/IconPath"},"browser_style":{"type":"boolean","default":true},"default_panel":{"type":"string","format":"strictRelativeUrl","preprocess":"localize"},"open_at_install":{"type":"boolean","default":true,"description":"Whether or not the sidebar is opened at install. Default is <code>true</code>."}},"required":["default_panel"]}}}},"refs":{"sidebarAction#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"ImageDataType":{"type":"object","isInstanceOf":"ImageData","additionalProperties":{},"postprocess":"convertImageDataToURL","description":"Pixel data for an image. Must be an ImageData object (for example, from a <code>canvas</code> element)."}}}');

/***/ }),
/* 75 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"storage","allowedContexts":["content","devtools"],"defaultContexts":["content","devtools"],"description":"Use the <code>browser.storage</code> API to store, retrieve, and track changes to user data.","permissions":["storage"],"events":[{"name":"onChanged","type":"function","description":"Fired when one or more items change.","parameters":[{"name":"changes","type":"object","additionalProperties":{"$ref":"#/types/StorageChange"},"description":"Object mapping each key that changed to its corresponding $(ref:storage.StorageChange) for that item."},{"name":"areaName","type":"string","description":"The name of the storage area (<code>\\"sync\\"</code>, <code>\\"local\\"</code> or <code>\\"managed\\"</code>) the changes are for."}]}],"properties":{"sync":{"allOf":[{"$ref":"#/types/StorageAreaSync"},{"description":"Items in the <code>sync</code> storage area are synced by the browser.","properties":{"QUOTA_BYTES":{"value":102400,"description":"The maximum total amount (in bytes) of data that can be stored in sync storage, as measured by the JSON stringification of every value plus every key\'s length. Updates that would cause this limit to be exceeded fail immediately and set $(ref:runtime.lastError)."},"QUOTA_BYTES_PER_ITEM":{"value":8192,"description":"The maximum size (in bytes) of each individual item in sync storage, as measured by the JSON stringification of its value plus its key length. Updates containing items larger than this limit will fail immediately and set $(ref:runtime.lastError)."},"MAX_ITEMS":{"value":512,"description":"The maximum number of items that can be stored in sync storage. Updates that would cause this limit to be exceeded will fail immediately and set $(ref:runtime.lastError)."},"MAX_WRITE_OPERATIONS_PER_HOUR":{"value":1800,"description":"<p>The maximum number of <code>set</code>, <code>remove</code>, or <code>clear</code> operations that can be performed each hour. This is 1 every 2 seconds, a lower ceiling than the short term higher writes-per-minute limit.</p><p>Updates that would cause this limit to be exceeded fail immediately and set $(ref:runtime.lastError).</p>"},"MAX_WRITE_OPERATIONS_PER_MINUTE":{"value":120,"description":"<p>The maximum number of <code>set</code>, <code>remove</code>, or <code>clear</code> operations that can be performed each minute. This is 2 per second, providing higher throughput than writes-per-hour over a shorter period of time.</p><p>Updates that would cause this limit to be exceeded fail immediately and set $(ref:runtime.lastError).</p>"},"MAX_SUSTAINED_WRITE_OPERATIONS_PER_MINUTE":{"value":1000000,"deprecated":"The storage.sync API no longer has a sustained write operation quota.","description":""}},"required":["QUOTA_BYTES","QUOTA_BYTES_PER_ITEM","MAX_ITEMS","MAX_WRITE_OPERATIONS_PER_HOUR","MAX_WRITE_OPERATIONS_PER_MINUTE","MAX_SUSTAINED_WRITE_OPERATIONS_PER_MINUTE"]}]},"local":{"allOf":[{"$ref":"#/types/StorageArea"},{"description":"Items in the <code>local</code> storage area are local to each machine.","properties":{"QUOTA_BYTES":{"value":5242880,"description":"The maximum amount (in bytes) of data that can be stored in local storage, as measured by the JSON stringification of every value plus every key\'s length. This value will be ignored if the extension has the <code>unlimitedStorage</code> permission. Updates that would cause this limit to be exceeded fail immediately and set $(ref:runtime.lastError)."}},"required":["QUOTA_BYTES"]}]},"managed":{"allOf":[{"$ref":"#/types/StorageArea"},{"description":"Items in the <code>managed</code> storage area are set by administrators or native applications, and are read-only for the extension; trying to modify this namespace results in an error.","properties":{"QUOTA_BYTES":{"value":5242880,"description":"The maximum size (in bytes) of the managed storage JSON manifest file. Files larger than this limit will fail to load."}},"required":["QUOTA_BYTES"]}]}},"definitions":{},"refs":{},"types":{"StorageChange":{"type":"object","properties":{"oldValue":{"description":"The old value of the item, if there was an old value."},"newValue":{"description":"The new value of the item, if there is a new value."}}},"StorageArea":{"type":"object","functions":[{"name":"get","type":"function","description":"Gets one or more items from storage.","async":"callback","parameters":[{"name":"keys","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}},{"type":"object","description":"Storage items to return in the callback, where the values are replaced with those from storage if they exist.","additionalProperties":{}}],"description":"A single key to get, list of keys to get, or a dictionary specifying default values (see description of the object).  An empty list or object will return an empty result object.  Pass in <code>null</code> to get the entire contents of storage.","optional":true},{"name":"callback","type":"function","description":"Callback with storage items, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[{"name":"items","type":"object","additionalProperties":{},"description":"Object with items in their key-value mappings."}]}]},{"name":"getBytesInUse","unsupported":true,"type":"function","description":"Gets the amount of space (in bytes) being used by one or more items.","async":"callback","parameters":[{"name":"keys","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}],"description":"A single key or list of keys to get the total usage for. An empty list will return 0. Pass in <code>null</code> to get the total usage of all of storage.","optional":true},{"name":"callback","type":"function","description":"Callback with the amount of space being used by storage, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[{"name":"bytesInUse","type":"integer","description":"Amount of space being used in storage, in bytes."}]}]},{"name":"set","type":"function","description":"Sets multiple items.","async":"callback","parameters":[{"name":"items","type":"object","additionalProperties":{},"description":"<p>An object which gives each key/value pair to update storage with. Any other key/value pairs in storage will not be affected.</p><p>Primitive values such as numbers will serialize as expected. Values with a <code>typeof</code> <code>\\"object\\"</code> and <code>\\"function\\"</code> will typically serialize to <code>{}</code>, with the exception of <code>Array</code> (serializes as expected), <code>Date</code>, and <code>Regex</code> (serialize using their <code>String</code> representation).</p>"},{"name":"callback","type":"function","description":"Callback on success, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[],"optional":true}]},{"name":"remove","type":"function","description":"Removes one or more items from storage.","async":"callback","parameters":[{"name":"keys","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}],"description":"A single key or a list of keys for items to remove."},{"name":"callback","type":"function","description":"Callback on success, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[],"optional":true}]},{"name":"clear","type":"function","description":"Removes all items from storage.","async":"callback","parameters":[{"name":"callback","type":"function","description":"Callback on success, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[],"optional":true}]}]},"StorageAreaSync":{"type":"object","functions":[{"name":"get","type":"function","description":"Gets one or more items from storage.","async":"callback","parameters":[{"name":"keys","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}},{"type":"object","description":"Storage items to return in the callback, where the values are replaced with those from storage if they exist.","additionalProperties":{}}],"description":"A single key to get, list of keys to get, or a dictionary specifying default values (see description of the object).  An empty list or object will return an empty result object.  Pass in <code>null</code> to get the entire contents of storage.","optional":true},{"name":"callback","type":"function","description":"Callback with storage items, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[{"name":"items","type":"object","additionalProperties":{},"description":"Object with items in their key-value mappings."}]}]},{"name":"getBytesInUse","type":"function","description":"Gets the amount of space (in bytes) being used by one or more items.","async":"callback","parameters":[{"name":"keys","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}],"description":"A single key or list of keys to get the total usage for. An empty list will return 0. Pass in <code>null</code> to get the total usage of all of storage.","optional":true},{"name":"callback","type":"function","description":"Callback with the amount of space being used by storage, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[{"name":"bytesInUse","type":"integer","description":"Amount of space being used in storage, in bytes."}]}]},{"name":"set","type":"function","description":"Sets multiple items.","async":"callback","parameters":[{"name":"items","type":"object","additionalProperties":{},"description":"<p>An object which gives each key/value pair to update storage with. Any other key/value pairs in storage will not be affected.</p><p>Primitive values such as numbers will serialize as expected. Values with a <code>typeof</code> <code>\\"object\\"</code> and <code>\\"function\\"</code> will typically serialize to <code>{}</code>, with the exception of <code>Array</code> (serializes as expected), <code>Date</code>, and <code>Regex</code> (serialize using their <code>String</code> representation).</p>"},{"name":"callback","type":"function","description":"Callback on success, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[],"optional":true}]},{"name":"remove","type":"function","description":"Removes one or more items from storage.","async":"callback","parameters":[{"name":"keys","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}],"description":"A single key or a list of keys for items to remove."},{"name":"callback","type":"function","description":"Callback on success, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[],"optional":true}]},{"name":"clear","type":"function","description":"Removes all items from storage.","async":"callback","parameters":[{"name":"callback","type":"function","description":"Callback on success, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[],"optional":true}]}]}}}');

/***/ }),
/* 76 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"tabs","description":"Use the <code>browser.tabs</code> API to interact with the browser\'s tab system. You can use this API to create, modify, and rearrange tabs in the browser.","properties":{"TAB_ID_NONE":{"value":-1,"description":"An ID which represents the absence of a browser tab."}},"functions":[{"name":"get","type":"function","description":"Retrieves details about the specified tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab"}]}]}]},{"name":"getCurrent","type":"function","description":"Gets the tab that this script call is being made from. May be undefined if called from a non-tab context (for example: a background page or popup view).","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab","optional":true}]}]}]},{"name":"connect","type":"function","description":"Connects to the content script(s) in the specified tab. The $(ref:runtime.onConnect) event is fired in each content script running in the specified tab for the current extension. For more details, see $(topic:messaging)[Content Script Messaging].","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"connectInfo","properties":{"name":{"type":"string","description":"Will be passed into onConnect for content scripts that are listening for the connection event."},"frameId":{"type":"integer","minimum":0,"description":"Open a port to a specific $(topic:frame_ids)[frame] identified by <code>frameId</code> instead of all frames in the tab."}},"optional":true}],"returns":{"allOf":[{"$ref":"runtime#/types/Port"},{"description":"A port that can be used to communicate with the content scripts running in the specified tab. The port\'s $(ref:runtime.Port) event is fired if the tab closes or does not exist. "}]}},{"name":"sendRequest","deprecated":"Please use $(ref:runtime.sendMessage).","unsupported":true,"type":"function","description":"Sends a single request to the content script(s) in the specified tab, with an optional callback to run when a response is sent back.  The $(ref:extension.onRequest) event is fired in each content script running in the specified tab for the current extension.","parameters":[{"type":"integer","name":"tabId","minimum":0},{"name":"request"},{"type":"function","name":"responseCallback","optional":true,"parameters":[{"name":"response","description":"The JSON response object sent by the handler of the request. If an error occurs while connecting to the specified tab, the callback will be called with no arguments and $(ref:runtime.lastError) will be set to the error message."}]}]},{"name":"sendMessage","type":"function","description":"Sends a single message to the content script(s) in the specified tab, with an optional callback to run when a response is sent back.  The $(ref:runtime.onMessage) event is fired in each content script running in the specified tab for the current extension.","async":"responseCallback","parameters":[{"type":"integer","name":"tabId","minimum":0},{"name":"message"},{"type":"object","name":"options","properties":{"frameId":{"type":"integer","minimum":0,"description":"Send a message to a specific $(topic:frame_ids)[frame] identified by <code>frameId</code> instead of all frames in the tab."}},"optional":true},{"type":"function","name":"responseCallback","optional":true,"parameters":[{"name":"response","description":"The JSON response object sent by the handler of the message. If an error occurs while connecting to the specified tab, the callback will be called with no arguments and $(ref:runtime.lastError) will be set to the error message."}]}]},{"name":"getSelected","deprecated":"Please use $(ref:tabs.query) <code>{active: true}</code>.","unsupported":true,"type":"function","description":"Gets the tab that is selected in the specified window.","async":"callback","parameters":[{"type":"integer","name":"windowId","minimum":-2,"optional":true,"description":"Defaults to the $(topic:current-window)[current window]."},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab"}]}]}]},{"name":"getAllInWindow","deprecated":"Please use $(ref:tabs.query) <code>{windowId: windowId}</code>.","unsupported":true,"type":"function","description":"Gets details about all tabs in the specified window.","async":"callback","parameters":[{"type":"integer","name":"windowId","minimum":-2,"optional":true,"description":"Defaults to the $(topic:current-window)[current window]."},{"type":"function","name":"callback","parameters":[{"name":"tabs","type":"array","items":{"$ref":"#/types/Tab"}}]}]},{"name":"create","type":"function","description":"Creates a new tab.","async":"callback","parameters":[{"type":"object","name":"createProperties","properties":{"windowId":{"type":"integer","minimum":-2,"description":"The window to create the new tab in. Defaults to the $(topic:current-window)[current window]."},"index":{"type":"integer","minimum":0,"description":"The position the tab should take in the window. The provided value will be clamped to between zero and the number of tabs in the window."},"url":{"type":"string","description":"The URL to navigate the tab to initially. Fully-qualified URLs must include a scheme (i.e. \'http://www.google.com\', not \'www.google.com\'). Relative URLs will be relative to the current page within the extension. Defaults to the New Tab Page."},"active":{"type":"boolean","description":"Whether the tab should become the active tab in the window. Does not affect whether the window is focused (see $(ref:windows.update)). Defaults to <var>true</var>."},"selected":{"deprecated":"Please use <em>active</em>.","unsupported":true,"type":"boolean","description":"Whether the tab should become the selected tab in the window. Defaults to <var>true</var>"},"pinned":{"type":"boolean","description":"Whether the tab should be pinned. Defaults to <var>false</var>"},"openerTabId":{"type":"integer","minimum":0,"description":"The ID of the tab that opened this tab. If specified, the opener tab must be in the same window as the newly created tab."},"cookieStoreId":{"type":"string","description":"The CookieStoreId for the tab that opened this tab."},"openInReaderMode":{"type":"boolean","description":"Whether the document in the tab should be opened in reader mode."},"discarded":{"type":"boolean","description":"Whether the tab is marked as \'discarded\' when created."},"title":{"type":"string","description":"The title used for display if the tab is created in discarded mode."}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab","optional":true,"description":"Details about the created tab. Will contain the ID of the new tab."}]}]}]},{"name":"duplicate","type":"function","description":"Duplicates a tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"description":"The ID of the tab which is to be duplicated."},{"type":"object","name":"duplicateProperties","optional":true,"properties":{"index":{"type":"integer","description":"The position the new tab should take in the window. The provided value will be clamped to between zero and the number of tabs in the window."},"active":{"type":"boolean","description":"Whether the tab should become the active tab in the window. Does not affect whether the window is focused (see $(ref:windows.update)). Defaults to <var>true</var>."}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab","optional":true,"description":"Details about the duplicated tab. The $(ref:tabs.Tab) object doesn\'t contain <code>url</code>, <code>title</code> and <code>favIconUrl</code> if the <code>\\"tabs\\"</code> permission has not been requested."}]}]}]},{"name":"query","type":"function","description":"Gets all tabs that have the specified properties, or all tabs if no properties are specified.","async":"callback","parameters":[{"type":"object","name":"queryInfo","properties":{"active":{"type":"boolean","description":"Whether the tabs are active in their windows."},"attention":{"type":"boolean","description":"Whether the tabs are drawing attention."},"pinned":{"type":"boolean","description":"Whether the tabs are pinned."},"audible":{"type":"boolean","description":"Whether the tabs are audible."},"muted":{"type":"boolean","description":"Whether the tabs are muted."},"highlighted":{"type":"boolean","description":"Whether the tabs are highlighted.  Works as an alias of active."},"currentWindow":{"type":"boolean","description":"Whether the tabs are in the $(topic:current-window)[current window]."},"lastFocusedWindow":{"type":"boolean","description":"Whether the tabs are in the last focused window."},"status":{"allOf":[{"$ref":"#/types/TabStatus"},{"description":"Whether the tabs have completed loading."}]},"discarded":{"type":"boolean","description":"True while the tabs are not loaded with content."},"hidden":{"type":"boolean","description":"True while the tabs are hidden."},"title":{"type":"string","description":"Match page titles against a pattern."},"url":{"anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}],"description":"Match tabs against one or more $(topic:match_patterns)[URL patterns]. Note that fragment identifiers are not matched."},"windowId":{"type":"integer","minimum":-2,"description":"The ID of the parent window, or $(ref:windows.WINDOW_ID_CURRENT) for the $(topic:current-window)[current window]."},"windowType":{"allOf":[{"$ref":"#/types/WindowType"},{"description":"The type of window the tabs are in."}]},"index":{"type":"integer","minimum":0,"description":"The position of the tabs within their windows."},"cookieStoreId":{"type":"string","description":"The CookieStoreId used for the tab."},"openerTabId":{"type":"integer","minimum":0,"description":"The ID of the tab that opened this tab. If specified, the opener tab must be in the same window as this tab."},"screen":{"anyOf":[{"type":"string","enum":["Screen","Window","Application"]},{"type":"boolean"}],"description":"True for any screen sharing, or a string to specify type of screen sharing."},"camera":{"type":"boolean","description":"True if the tab is using the camera."},"microphone":{"type":"boolean","description":"True if the tab is using the microphone."}}},{"type":"function","name":"callback","parameters":[{"name":"result","type":"array","items":{"$ref":"#/types/Tab"}}]}]},{"name":"highlight","type":"function","description":"Highlights the given tabs.","async":"callback","parameters":[{"type":"object","name":"highlightInfo","properties":{"windowId":{"type":"integer","description":"The window that contains the tabs.","minimum":-2},"populate":{"type":"boolean","default":true,"description":"If true, the $(ref:windows.Window) returned will have a <var>tabs</var> property that contains a list of the $(ref:tabs.Tab) objects. The <code>Tab</code> objects only contain the <code>url</code>, <code>title</code> and <code>favIconUrl</code> properties if the extension\'s manifest file includes the <code>\\"tabs\\"</code> permission. If false, the $(ref:windows.Window) won\'t have the <var>tabs</var> property."},"tabs":{"description":"One or more tab indices to highlight.","anyOf":[{"type":"array","items":{"type":"integer","minimum":0}},{"type":"integer"}]}},"required":["tabs"]},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"windows#/types/Window"},{"name":"window","description":"Contains details about the window whose tabs were highlighted."}]}]}]},{"name":"update","type":"function","description":"Modifies the properties of a tab. Properties that are not specified in <var>updateProperties</var> are not modified.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"Defaults to the selected tab of the $(topic:current-window)[current window]."},{"type":"object","name":"updateProperties","properties":{"url":{"type":"string","description":"A URL to navigate the tab to."},"active":{"type":"boolean","description":"Whether the tab should be active. Does not affect whether the window is focused (see $(ref:windows.update))."},"highlighted":{"type":"boolean","description":"Adds or removes the tab from the current selection."},"selected":{"unsupported":true,"deprecated":"Please use <em>highlighted</em>.","type":"boolean","description":"Whether the tab should be selected."},"pinned":{"type":"boolean","description":"Whether the tab should be pinned."},"muted":{"type":"boolean","description":"Whether the tab should be muted."},"openerTabId":{"type":"integer","minimum":0,"description":"The ID of the tab that opened this tab. If specified, the opener tab must be in the same window as this tab."},"loadReplace":{"type":"boolean","description":"Whether the load should replace the current history entry for the tab."},"successorTabId":{"type":"integer","minimum":-1,"description":"The ID of this tab\'s successor. If specified, the successor tab must be in the same window as this tab."}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab","optional":true,"description":"Details about the updated tab. The $(ref:tabs.Tab) object doesn\'t contain <code>url</code>, <code>title</code> and <code>favIconUrl</code> if the <code>\\"tabs\\"</code> permission has not been requested."}]}]}]},{"name":"move","type":"function","description":"Moves one or more tabs to a new position within its window, or to a new window. Note that tabs can only be moved to and from normal (window.type === \\"normal\\") windows.","async":"callback","parameters":[{"name":"tabIds","description":"The tab or list of tabs to move.","anyOf":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0}}]},{"type":"object","name":"moveProperties","properties":{"windowId":{"type":"integer","minimum":-2,"description":"Defaults to the window the tab is currently in."},"index":{"type":"integer","minimum":-1,"description":"The position to move the window to. -1 will place the tab at the end of the window."}},"required":["index"]},{"type":"function","name":"callback","optional":true,"parameters":[{"name":"tabs","description":"Details about the moved tabs.","anyOf":[{"$ref":"#/types/Tab"},{"type":"array","items":{"$ref":"#/types/Tab"}}]}]}]},{"name":"reload","type":"function","description":"Reload a tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab to reload; defaults to the selected tab of the current window."},{"type":"object","name":"reloadProperties","optional":true,"properties":{"bypassCache":{"type":"boolean","description":"Whether using any local cache. Default is false."}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"warmup","type":"function","description":"Warm up a tab","async":true,"parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":false,"description":"The ID of the tab to warm up."}]},{"name":"remove","type":"function","description":"Closes one or more tabs.","async":"callback","parameters":[{"name":"tabIds","description":"The tab or list of tabs to close.","anyOf":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0}}]},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"discard","type":"function","description":"discards one or more tabs.","async":true,"parameters":[{"name":"tabIds","description":"The tab or list of tabs to discard.","anyOf":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0}}]}]},{"name":"detectLanguage","type":"function","description":"Detects the primary language of the content in a tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"Defaults to the active tab of the $(topic:current-window)[current window]."},{"type":"function","name":"callback","parameters":[{"type":"string","name":"language","description":"An ISO language code such as <code>en</code> or <code>fr</code>. For a complete list of languages supported by this method, see <a href=\'http://src.chromium.org/viewvc/chrome/trunk/src/third_party/cld/languages/internal/languages.cc\'>kLanguageInfoTable</a>. The 2nd to 4th columns will be checked and the first non-NULL value will be returned except for Simplified Chinese for which zh-CN will be returned. For an unknown language, <code>und</code> will be returned."}]}]},{"name":"toggleReaderMode","type":"function","description":"Toggles reader mode for the document in the tab.","async":true,"parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"Defaults to the active tab of the $(topic:current-window)[current window]."}]},{"name":"captureTab","type":"function","description":"Captures an area of a specified tab. You must have $(topic:declare_permissions)[&lt;all_urls&gt;] permission to use this method.","permissions":["<all_urls>"],"async":true,"parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The tab to capture. Defaults to the active tab of the current window."},{"allOf":[{"$ref":"extensionTypes#/types/ImageDetails"},{"name":"options","optional":true}]}]},{"name":"captureVisibleTab","type":"function","description":"Captures an area of the currently active tab in the specified window. You must have $(topic:declare_permissions)[&lt;all_urls&gt;] permission to use this method.","permissions":["<all_urls>"],"async":"callback","parameters":[{"type":"integer","name":"windowId","minimum":-2,"optional":true,"description":"The target window. Defaults to the $(topic:current-window)[current window]."},{"allOf":[{"$ref":"extensionTypes#/types/ImageDetails"},{"name":"options","optional":true}]},{"type":"function","name":"callback","parameters":[{"type":"string","name":"dataUrl","description":"A data URL which encodes an image of the visible area of the captured tab. May be assigned to the \'src\' property of an HTML Image element for display."}]}]},{"name":"executeScript","type":"function","description":"Injects JavaScript code into a page. For details, see the $(topic:content_scripts)[programmatic injection] section of the content scripts doc.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab in which to run the script; defaults to the active tab of the current window."},{"allOf":[{"$ref":"extensionTypes#/types/InjectDetails"},{"name":"details","description":"Details of the script to run."}]},{"type":"function","name":"callback","optional":true,"description":"Called after all the JavaScript has been executed.","parameters":[{"name":"result","optional":true,"type":"array","items":{},"description":"The result of the script in every injected frame."}]}]},{"name":"insertCSS","type":"function","description":"Injects CSS into a page. For details, see the $(topic:content_scripts)[programmatic injection] section of the content scripts doc.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab in which to insert the CSS; defaults to the active tab of the current window."},{"allOf":[{"$ref":"extensionTypes#/types/InjectDetails"},{"name":"details","description":"Details of the CSS text to insert."}]},{"type":"function","name":"callback","optional":true,"description":"Called when all the CSS has been inserted.","parameters":[]}]},{"name":"removeCSS","type":"function","description":"Removes injected CSS from a page. For details, see the $(topic:content_scripts)[programmatic injection] section of the content scripts doc.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab from which to remove the injected CSS; defaults to the active tab of the current window."},{"allOf":[{"$ref":"extensionTypes#/types/InjectDetails"},{"name":"details","description":"Details of the CSS text to remove."}]},{"type":"function","name":"callback","optional":true,"description":"Called when all the CSS has been removed.","parameters":[]}]},{"name":"setZoom","type":"function","description":"Zooms a specified tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab to zoom; defaults to the active tab of the current window."},{"type":"number","name":"zoomFactor","description":"The new zoom factor. Use a value of 0 here to set the tab to its current default zoom factor. Values greater than zero specify a (possibly non-default) zoom factor for the tab."},{"type":"function","name":"callback","optional":true,"description":"Called after the zoom factor has been changed.","parameters":[]}]},{"name":"getZoom","type":"function","description":"Gets the current zoom factor of a specified tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab to get the current zoom factor from; defaults to the active tab of the current window."},{"type":"function","name":"callback","description":"Called with the tab\'s current zoom factor after it has been fetched.","parameters":[{"type":"number","name":"zoomFactor","description":"The tab\'s current zoom factor."}]}]},{"name":"setZoomSettings","type":"function","description":"Sets the zoom settings for a specified tab, which define how zoom changes are handled. These settings are reset to defaults upon navigating the tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","optional":true,"minimum":0,"description":"The ID of the tab to change the zoom settings for; defaults to the active tab of the current window."},{"allOf":[{"$ref":"#/types/ZoomSettings"},{"name":"zoomSettings","description":"Defines how zoom changes are handled and at what scope."}]},{"type":"function","name":"callback","optional":true,"description":"Called after the zoom settings have been changed.","parameters":[]}]},{"name":"getZoomSettings","type":"function","description":"Gets the current zoom settings of a specified tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","optional":true,"minimum":0,"description":"The ID of the tab to get the current zoom settings from; defaults to the active tab of the current window."},{"type":"function","name":"callback","description":"Called with the tab\'s current zoom settings.","parameters":[{"allOf":[{"$ref":"#/types/ZoomSettings"},{"name":"zoomSettings","description":"The tab\'s current zoom settings."}]}]}]},{"name":"print","type":"function","description":"Prints page in active tab.","parameters":[]},{"name":"printPreview","type":"function","description":"Shows print preview for page in active tab.","async":"callback","parameters":[{"type":"function","name":"callback","optional":true,"description":"Called after print preview entered.","parameters":[]}]},{"name":"saveAsPDF","type":"function","description":"Saves page in active tab as a PDF file.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/PageSettings"},{"name":"pageSettings","description":"The page settings used to save the PDF file."}]},{"type":"function","name":"callback","optional":true,"description":"Called after save as dialog closed.","parameters":[{"type":"string","name":"status","description":"Save status: saved, replaced, canceled, not_saved, not_replaced."}]}]},{"name":"show","type":"function","description":"Shows one or more tabs.","permissions":["tabHide"],"async":true,"parameters":[{"name":"tabIds","description":"The TAB ID or list of TAB IDs to show.","anyOf":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0}}]}]},{"name":"hide","type":"function","description":"Hides one or more tabs. The <code>\\"tabHide\\"</code> permission is required to hide tabs.  Not all tabs are hidable.  Returns an array of hidden tabs.","permissions":["tabHide"],"async":true,"parameters":[{"name":"tabIds","description":"The TAB ID or list of TAB IDs to hide.","anyOf":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0}}]}]},{"name":"moveInSuccession","type":"function","async":true,"description":"Removes an array of tabs from their lines of succession and prepends or appends them in a chain to another tab.","parameters":[{"name":"tabIds","type":"array","items":{"type":"integer","minimum":0},"minItems":1,"description":"An array of tab IDs to move in the line of succession. For each tab in the array, the tab\'s current predecessors will have their successor set to the tab\'s current successor, and each tab will then be set to be the successor of the previous tab in the array. Any tabs not in the same window as the tab indicated by the second argument (or the first tab in the array, if no second argument) will be skipped."},{"name":"tabId","type":"integer","optional":true,"default":-1,"minimum":-1,"description":"The ID of a tab to set as the successor of the last tab in the array, or $(ref:tabs.TAB_ID_NONE) to leave the last tab without a successor. If options.append is true, then this tab is made the predecessor of the first tab in the array instead."},{"name":"options","type":"object","optional":true,"properties":{"append":{"type":"boolean","default":false,"description":"Whether to move the tabs before (false) or after (true) tabId in the succession. Defaults to false."},"insert":{"type":"boolean","default":false,"description":"Whether to link up the current predecessors or successor (depending on options.append) of tabId to the other side of the chain after it is prepended or appended. If true, one of the following happens: if options.append is false, the first tab in the array is set as the successor of any current predecessors of tabId; if options.append is true, the current successor of tabId is set as the successor of the last tab in the array. Defaults to false."}}}]},{"name":"goForward","type":"function","description":"Navigate to next page in tab\'s history, if available","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab to navigate forward."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"goBack","type":"function","description":"Navigate to previous page in tab\'s history, if available.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab to navigate backward."},{"type":"function","name":"callback","optional":true,"parameters":[]}]}],"events":[{"name":"onCreated","type":"function","description":"Fired when a tab is created. Note that the tab\'s URL may not be set at the time this event fired, but you can listen to onUpdated events to be notified when a URL is set.","parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab","description":"Details of the tab that was created."}]}]},{"name":"onUpdated","type":"function","description":"Fired when a tab is updated.","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"changeInfo","description":"Lists the changes to the state of the tab that was updated.","properties":{"attention":{"type":"boolean","description":"The tab\'s new attention state."},"audible":{"type":"boolean","description":"The tab\'s new audible state."},"discarded":{"type":"boolean","description":"True while the tab is not loaded with content."},"favIconUrl":{"type":"string","permissions":["tabs"],"description":"The tab\'s new favicon URL. This property is only present if the extension\'s manifest includes the <code>\\"tabs\\"</code> permission."},"hidden":{"type":"boolean","description":"The tab\'s new hidden state."},"isArticle":{"type":"boolean","description":"Whether the document in the tab can be rendered in reader mode."},"mutedInfo":{"allOf":[{"$ref":"#/types/MutedInfo"},{"description":"The tab\'s new muted state and the reason for the change."}]},"pinned":{"type":"boolean","description":"The tab\'s new pinned state."},"sharingState":{"allOf":[{"$ref":"#/types/SharingState"},{"description":"The tab\'s new sharing state for screen, microphone and camera."}]},"status":{"type":"string","description":"The status of the tab. Can be either <em>loading</em> or <em>complete</em>."},"title":{"type":"string","permissions":["tabs"],"description":"The title of the tab if it has changed. This property is only present if the extension\'s manifest includes the <code>\\"tabs\\"</code> permission."},"url":{"type":"string","permissions":["tabs"],"description":"The tab\'s URL if it has changed. This property is only present if the extension\'s manifest includes the <code>\\"tabs\\"</code> permission."}}},{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab","description":"Gives the state of the tab that was updated."}]}],"extraParameters":[{"allOf":[{"$ref":"#/types/UpdateFilter"},{"name":"filter","optional":true,"description":"A set of filters that restricts the events that will be sent to this listener."}]}]},{"name":"onMoved","type":"function","description":"Fired when a tab is moved within a window. Only one move event is fired, representing the tab the user directly moved. Move events are not fired for the other tabs that must move in response. This event is not fired when a tab is moved between windows. For that, see $(ref:tabs.onDetached).","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"moveInfo","properties":{"windowId":{"type":"integer","minimum":0},"fromIndex":{"type":"integer","minimum":0},"toIndex":{"type":"integer","minimum":0}},"required":["windowId","fromIndex","toIndex"]}]},{"name":"onSelectionChanged","deprecated":"Please use $(ref:tabs.onActivated).","unsupported":true,"type":"function","description":"Fires when the selected tab in a window changes.","parameters":[{"type":"integer","name":"tabId","minimum":0,"description":"The ID of the tab that has become active."},{"type":"object","name":"selectInfo","properties":{"windowId":{"type":"integer","minimum":0,"description":"The ID of the window the selected tab changed inside of."}},"required":["windowId"]}]},{"name":"onActiveChanged","deprecated":"Please use $(ref:tabs.onActivated).","unsupported":true,"type":"function","description":"Fires when the selected tab in a window changes. Note that the tab\'s URL may not be set at the time this event fired, but you can listen to $(ref:tabs.onUpdated) events to be notified when a URL is set.","parameters":[{"type":"integer","name":"tabId","minimum":0,"description":"The ID of the tab that has become active."},{"type":"object","name":"selectInfo","properties":{"windowId":{"type":"integer","minimum":0,"description":"The ID of the window the selected tab changed inside of."}},"required":["windowId"]}]},{"name":"onActivated","type":"function","description":"Fires when the active tab in a window changes. Note that the tab\'s URL may not be set at the time this event fired, but you can listen to onUpdated events to be notified when a URL is set.","parameters":[{"type":"object","name":"activeInfo","properties":{"tabId":{"type":"integer","minimum":0,"description":"The ID of the tab that has become active."},"previousTabId":{"type":"integer","minimum":0,"description":"The ID of the tab that was previously active, if that tab is still open."},"windowId":{"type":"integer","minimum":0,"description":"The ID of the window the active tab changed inside of."}},"required":["tabId","windowId"]}]},{"name":"onHighlightChanged","deprecated":"Please use $(ref:tabs.onHighlighted).","unsupported":true,"type":"function","description":"Fired when the highlighted or selected tabs in a window changes.","parameters":[{"type":"object","name":"selectInfo","properties":{"windowId":{"type":"integer","minimum":0,"description":"The window whose tabs changed."},"tabIds":{"type":"array","items":{"type":"integer","minimum":0},"description":"All highlighted tabs in the window."}},"required":["windowId","tabIds"]}]},{"name":"onHighlighted","type":"function","description":"Fired when the highlighted or selected tabs in a window changes.","parameters":[{"type":"object","name":"highlightInfo","properties":{"windowId":{"type":"integer","minimum":0,"description":"The window whose tabs changed."},"tabIds":{"type":"array","items":{"type":"integer","minimum":0},"description":"All highlighted tabs in the window."}},"required":["windowId","tabIds"]}]},{"name":"onDetached","type":"function","description":"Fired when a tab is detached from a window, for example because it is being moved between windows.","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"detachInfo","properties":{"oldWindowId":{"type":"integer","minimum":0},"oldPosition":{"type":"integer","minimum":0}},"required":["oldWindowId","oldPosition"]}]},{"name":"onAttached","type":"function","description":"Fired when a tab is attached to a window, for example because it was moved between windows.","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"attachInfo","properties":{"newWindowId":{"type":"integer","minimum":0},"newPosition":{"type":"integer","minimum":0}},"required":["newWindowId","newPosition"]}]},{"name":"onRemoved","type":"function","description":"Fired when a tab is closed.","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"removeInfo","properties":{"windowId":{"type":"integer","minimum":0,"description":"The window whose tab is closed."},"isWindowClosing":{"type":"boolean","description":"True when the tab is being closed because its window is being closed."}},"required":["windowId","isWindowClosing"]}]},{"name":"onReplaced","type":"function","description":"Fired when a tab is replaced with another tab due to prerendering or instant.","parameters":[{"type":"integer","name":"addedTabId","minimum":0},{"type":"integer","name":"removedTabId","minimum":0}]},{"name":"onZoomChange","type":"function","description":"Fired when a tab is zoomed.","parameters":[{"type":"object","name":"ZoomChangeInfo","properties":{"tabId":{"type":"integer","minimum":0},"oldZoomFactor":{"type":"number"},"newZoomFactor":{"type":"number"},"zoomSettings":{"$ref":"#/types/ZoomSettings"}},"required":["tabId","oldZoomFactor","newZoomFactor","zoomSettings"]}]}],"definitions":{"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["activeTab"]}]},"OptionalPermission":{"anyOf":[{"type":"string","enum":["tabs","tabHide"]}]}},"refs":{"tabs#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"},"tabs#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"MutedInfoReason":{"type":"string","description":"An event that caused a muted state change.","enum":[{"name":"user","description":"A user input action has set/overridden the muted state."},{"name":"capture","description":"Tab capture started, forcing a muted state change."},{"name":"extension","description":"An extension, identified by the extensionId field, set the muted state."}]},"MutedInfo":{"type":"object","description":"Tab muted state and the reason for the last state change.","properties":{"muted":{"type":"boolean","description":"Whether the tab is prevented from playing sound (but hasn\'t necessarily recently produced sound). Equivalent to whether the muted audio indicator is showing."},"reason":{"allOf":[{"$ref":"#/types/MutedInfoReason"},{"description":"The reason the tab was muted or unmuted. Not set if the tab\'s mute state has never been changed."}]},"extensionId":{"type":"string","description":"The ID of the extension that changed the muted state. Not set if an extension was not the reason the muted state last changed."}},"required":["muted"]},"SharingState":{"type":"object","description":"Tab sharing state for screen, microphone and camera.","properties":{"screen":{"type":"string","description":"If the tab is sharing the screen the value will be one of \\"Screen\\", \\"Window\\", or \\"Application\\", or undefined if not screen sharing."},"camera":{"type":"boolean","description":"True if the tab is using the camera."},"microphone":{"type":"boolean","description":"True if the tab is using the microphone."}},"required":["camera","microphone"]},"Tab":{"type":"object","properties":{"id":{"type":"integer","minimum":-1,"description":"The ID of the tab. Tab IDs are unique within a browser session. Under some circumstances a Tab may not be assigned an ID, for example when querying foreign tabs using the $(ref:sessions) API, in which case a session ID may be present. Tab ID can also be set to $(ref:tabs.TAB_ID_NONE) for apps and devtools windows."},"index":{"type":"integer","minimum":-1,"description":"The zero-based index of the tab within its window."},"windowId":{"type":"integer","minimum":0,"description":"The ID of the window the tab is contained within."},"openerTabId":{"type":"integer","minimum":0,"description":"The ID of the tab that opened this tab, if any. This property is only present if the opener tab still exists."},"selected":{"type":"boolean","description":"Whether the tab is selected.","deprecated":"Please use $(ref:tabs.Tab.highlighted).","unsupported":true},"highlighted":{"type":"boolean","description":"Whether the tab is highlighted. Works as an alias of active"},"active":{"type":"boolean","description":"Whether the tab is active in its window. (Does not necessarily mean the window is focused.)"},"pinned":{"type":"boolean","description":"Whether the tab is pinned."},"lastAccessed":{"type":"integer","description":"The last time the tab was accessed as the number of milliseconds since epoch."},"audible":{"type":"boolean","description":"Whether the tab has produced sound over the past couple of seconds (but it might not be heard if also muted). Equivalent to whether the speaker audio indicator is showing."},"mutedInfo":{"allOf":[{"$ref":"#/types/MutedInfo"},{"description":"Current tab muted state and the reason for the last state change."}]},"url":{"type":"string","permissions":["tabs"],"description":"The URL the tab is displaying. This property is only present if the extension\'s manifest includes the <code>\\"tabs\\"</code> permission."},"title":{"type":"string","permissions":["tabs"],"description":"The title of the tab. This property is only present if the extension\'s manifest includes the <code>\\"tabs\\"</code> permission."},"favIconUrl":{"type":"string","permissions":["tabs"],"description":"The URL of the tab\'s favicon. This property is only present if the extension\'s manifest includes the <code>\\"tabs\\"</code> permission. It may also be an empty string if the tab is loading."},"status":{"type":"string","description":"Either <em>loading</em> or <em>complete</em>."},"discarded":{"type":"boolean","description":"True while the tab is not loaded with content."},"incognito":{"type":"boolean","description":"Whether the tab is in an incognito window."},"width":{"type":"integer","description":"The width of the tab in pixels."},"height":{"type":"integer","description":"The height of the tab in pixels."},"hidden":{"type":"boolean","description":"True if the tab is hidden."},"sessionId":{"type":"string","description":"The session ID used to uniquely identify a Tab obtained from the $(ref:sessions) API."},"cookieStoreId":{"type":"string","description":"The CookieStoreId used for the tab."},"isArticle":{"type":"boolean","description":"Whether the document in the tab can be rendered in reader mode."},"isInReaderMode":{"type":"boolean","description":"Whether the document in the tab is being rendered in reader mode."},"sharingState":{"allOf":[{"$ref":"#/types/SharingState"},{"description":"Current tab sharing state for screen, microphone and camera."}]},"attention":{"type":"boolean","description":"Whether the tab is drawing attention."},"successorTabId":{"type":"integer","minimum":-1,"description":"The ID of this tab\'s successor, if any; $(ref:tabs.TAB_ID_NONE) otherwise."}},"required":["index","selected","highlighted","active","pinned","incognito"]},"ZoomSettingsMode":{"type":"string","description":"Defines how zoom changes are handled, i.e. which entity is responsible for the actual scaling of the page; defaults to <code>automatic</code>.","enum":[{"name":"automatic","description":"Zoom changes are handled automatically by the browser."},{"name":"manual","description":"Overrides the automatic handling of zoom changes. The <code>onZoomChange</code> event will still be dispatched, and it is the responsibility of the extension to listen for this event and manually scale the page. This mode does not support <code>per-origin</code> zooming, and will thus ignore the <code>scope</code> zoom setting and assume <code>per-tab</code>."},{"name":"disabled","description":"Disables all zooming in the tab. The tab will revert to the default zoom level, and all attempted zoom changes will be ignored."}]},"ZoomSettingsScope":{"type":"string","description":"Defines whether zoom changes will persist for the page\'s origin, or only take effect in this tab; defaults to <code>per-origin</code> when in <code>automatic</code> mode, and <code>per-tab</code> otherwise.","enum":[{"name":"per-origin","description":"Zoom changes will persist in the zoomed page\'s origin, i.e. all other tabs navigated to that same origin will be zoomed as well. Moreover, <code>per-origin</code> zoom changes are saved with the origin, meaning that when navigating to other pages in the same origin, they will all be zoomed to the same zoom factor. The <code>per-origin</code> scope is only available in the <code>automatic</code> mode."},{"name":"per-tab","description":"Zoom changes only take effect in this tab, and zoom changes in other tabs will not affect the zooming of this tab. Also, <code>per-tab</code> zoom changes are reset on navigation; navigating a tab will always load pages with their <code>per-origin</code> zoom factors."}]},"ZoomSettings":{"type":"object","description":"Defines how zoom changes in a tab are handled and at what scope.","properties":{"mode":{"allOf":[{"$ref":"#/types/ZoomSettingsMode"},{"description":"Defines how zoom changes are handled, i.e. which entity is responsible for the actual scaling of the page; defaults to <code>automatic</code>."}]},"scope":{"allOf":[{"$ref":"#/types/ZoomSettingsScope"},{"description":"Defines whether zoom changes will persist for the page\'s origin, or only take effect in this tab; defaults to <code>per-origin</code> when in <code>automatic</code> mode, and <code>per-tab</code> otherwise."}]},"defaultZoomFactor":{"type":"number","description":"Used to return the default zoom level for the current tab in calls to tabs.getZoomSettings."}}},"PageSettings":{"type":"object","description":"Defines the page settings to be used when saving a page as a pdf file.","properties":{"toFileName":{"type":"string","description":"The name of the file. May include optional .pdf extension."},"paperSizeUnit":{"type":"integer","description":"The page size unit: 0 = inches, 1 = millimeters. Default: 0."},"paperWidth":{"type":"number","description":"The paper width in paper size units. Default: 8.5."},"paperHeight":{"type":"number","description":"The paper height in paper size units. Default: 11.0."},"orientation":{"type":"integer","description":"The page content orientation: 0 = portrait, 1 = landscape. Default: 0."},"scaling":{"type":"number","description":"The page content scaling factor: 1.0 = 100% = normal size. Default: 1.0."},"shrinkToFit":{"type":"boolean","description":"Whether the page content should shrink to fit the page width (overrides scaling). Default: true."},"showBackgroundColors":{"type":"boolean","description":"Whether the page background colors should be shown. Default: false."},"showBackgroundImages":{"type":"boolean","description":"Whether the page background images should be shown. Default: false."},"edgeLeft":{"type":"number","description":"The spacing between the left header/footer and the left edge of the paper (inches). Default: 0."},"edgeRight":{"type":"number","description":"The spacing between the right header/footer and the right edge of the paper (inches). Default: 0."},"edgeTop":{"type":"number","description":"The spacing between the top of the headers and the top edge of the paper (inches). Default: 0"},"edgeBottom":{"type":"number","description":"The spacing between the bottom of the footers and the bottom edge of the paper (inches). Default: 0."},"marginLeft":{"type":"number","description":"The margin between the page content and the left edge of the paper (inches). Default: 0.5."},"marginRight":{"type":"number","description":"The margin between the page content and the right edge of the paper (inches). Default: 0.5."},"marginTop":{"type":"number","description":"The margin between the page content and the top edge of the paper (inches). Default: 0.5."},"marginBottom":{"type":"number","description":"The margin between the page content and the bottom edge of the paper (inches). Default: 0.5."},"headerLeft":{"type":"string","description":"The text for the page\'s left header. Default: \'&T\'."},"headerCenter":{"type":"string","description":"The text for the page\'s center header. Default: \'\'."},"headerRight":{"type":"string","description":"The text for the page\'s right header. Default: \'&U\'."},"footerLeft":{"type":"string","description":"The text for the page\'s left footer. Default: \'&PT\'."},"footerCenter":{"type":"string","description":"The text for the page\'s center footer. Default: \'\'."},"footerRight":{"type":"string","description":"The text for the page\'s right footer. Default: \'&D\'."}}},"TabStatus":{"type":"string","enum":["loading","complete"],"description":"Whether the tabs have completed loading."},"WindowType":{"type":"string","enum":["normal","popup","panel","app","devtools"],"description":"The type of window."},"UpdatePropertyName":{"type":"string","enum":["attention","audible","discarded","favIconUrl","hidden","isArticle","mutedInfo","pinned","sharingState","status","title","url"],"description":"Event names supported in onUpdated."},"UpdateFilter":{"type":"object","description":"An object describing filters to apply to tabs.onUpdated events.","properties":{"urls":{"type":"array","description":"A list of URLs or URL patterns. Events that cannot match any of the URLs will be filtered out.  Filtering with urls requires the <code>\\"tabs\\"</code> or  <code>\\"activeTab\\"</code> permission.","items":{"type":"string"},"minItems":1},"properties":{"type":"array","description":"A list of property names. Events that do not match any of the names will be filtered out.","items":{"$ref":"#/types/UpdatePropertyName"},"minItems":1},"tabId":{"type":"integer"},"windowId":{"type":"integer"}}}}}');

/***/ }),
/* 77 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"telemetry","description":"Use the <code>browser.telemetry</code> API to send telemetry data to the Mozilla Telemetry service. Restricted to Mozilla privileged webextensions.","permissions":["telemetry"],"functions":[{"name":"submitPing","type":"function","description":"Submits a custom ping to the Telemetry back-end. See <code>submitExternalPing</code> inside TelemetryController.jsm for more details.","async":true,"parameters":[{"name":"type","type":"string","pattern":"^[a-z0-9][a-z0-9-]+[a-z0-9]$","description":"The type of the ping."},{"name":"message","type":"object","additionalProperties":{},"description":"The data payload for the ping."},{"description":"Options object.","name":"options","type":"object","properties":{"addClientId":{"type":"boolean","default":false,"description":"True if the ping should contain the client id."},"addEnvironment":{"type":"boolean","default":false,"description":"True if the ping should contain the environment data."},"overrideEnvironment":{"type":"object","additionalProperties":{},"default":false,"description":"Set to override the environment data."},"usePingSender":{"type":"boolean","default":false,"description":"If true, send the ping using the PingSender."}}}]},{"name":"submitEncryptedPing","type":"function","description":"Submits a custom ping to the Telemetry back-end, with an encrypted payload. Requires a telemetry entry in the manifest to be used.","parameters":[{"name":"message","type":"object","additionalProperties":{},"description":"The data payload for the ping, which will be encrypted."},{"description":"Options object.","name":"options","type":"object","properties":{"schemaName":{"type":"string","description":"Schema name used for payload."},"schemaVersion":{"type":"integer","description":"Schema version used for payload."}},"required":["schemaName","schemaVersion"]}],"async":true},{"name":"canUpload","type":"function","description":"Checks if Telemetry upload is enabled.","parameters":[],"async":true},{"name":"scalarAdd","type":"function","description":"Adds the value to the given scalar.","async":true,"parameters":[{"name":"name","type":"string","description":"The scalar name."},{"name":"value","type":"integer","minimum":1,"description":"The numeric value to add to the scalar. Only unsigned integers supported."}]},{"name":"scalarSet","type":"function","description":"Sets the named scalar to the given value. Throws if the value type doesn\'t match the scalar type.","async":true,"parameters":[{"name":"name","type":"string","description":"The scalar name"},{"name":"value","description":"The value to set the scalar to","anyOf":[{"type":"string"},{"type":"boolean"},{"type":"integer"},{"type":"object","additionalProperties":{}}]}]},{"name":"scalarSetMaximum","type":"function","description":"Sets the scalar to the maximum of the current and the passed value","async":true,"parameters":[{"name":"name","type":"string","description":"The scalar name."},{"name":"value","type":"integer","minimum":0,"description":"The numeric value to set the scalar to. Only unsigned integers supported."}]},{"name":"keyedScalarAdd","type":"function","description":"Adds the value to the given keyed scalar.","async":true,"parameters":[{"name":"name","type":"string","description":"The scalar name"},{"name":"key","type":"string","description":"The key name"},{"name":"value","type":"integer","minimum":1,"description":"The numeric value to add to the scalar. Only unsigned integers supported."}]},{"name":"keyedScalarSet","type":"function","description":"Sets the keyed scalar to the given value. Throws if the value type doesn\'t match the scalar type.","async":true,"parameters":[{"name":"name","type":"string","description":"The scalar name."},{"name":"key","type":"string","description":"The key name."},{"name":"value","description":"The value to set the scalar to.","anyOf":[{"type":"string"},{"type":"boolean"},{"type":"integer"},{"type":"object","additionalProperties":{}}]}]},{"name":"keyedScalarSetMaximum","type":"function","description":"Sets the keyed scalar to the maximum of the current and the passed value","async":true,"parameters":[{"name":"name","type":"string","description":"The scalar name."},{"name":"key","type":"string","description":"The key name."},{"name":"value","type":"integer","minimum":0,"description":"The numeric value to set the scalar to. Only unsigned integers supported."}]},{"name":"recordEvent","type":"function","description":"Record an event in Telemetry. Throws when trying to record an unknown event.","async":true,"parameters":[{"name":"category","type":"string","description":"The category name."},{"name":"method","type":"string","description":"The method name."},{"name":"object","type":"string","description":"The object name."},{"name":"value","type":"string","optional":true,"description":"An optional string value to record."},{"name":"extra","type":"object","optional":true,"description":"An optional object of the form (string -> string). It should only contain registered extra keys.","additionalProperties":{"type":"string"}}]},{"name":"registerScalars","type":"function","description":"Register new scalars to record them from addons. See nsITelemetry.idl for more details.","async":true,"parameters":[{"name":"category","type":"string","description":"The unique category the scalars are registered in."},{"name":"data","type":"object","additionalProperties":{"$ref":"#/types/ScalarData"},"description":"An object that contains registration data for multiple scalars. Each property name is the scalar name, and the corresponding property value is an object of ScalarData type."}]},{"name":"registerEvents","type":"function","description":"Register new events to record them from addons. See nsITelemetry.idl for more details.","async":true,"parameters":[{"name":"category","type":"string","description":"The unique category the events are registered in."},{"name":"data","type":"object","additionalProperties":{"$ref":"#/types/EventData"},"description":"An object that contains registration data for 1+ events. Each property name is the category name, and the corresponding property value is an object of EventData type."}]},{"name":"setEventRecordingEnabled","type":"function","description":"Enable recording of events in a category. Events default to recording disabled. This allows to toggle recording for all events in the specified category.","async":true,"parameters":[{"name":"category","type":"string","description":"The category name."},{"name":"enabled","type":"boolean","description":"Whether recording is enabled for events in that category."}]}],"definitions":{"WebExtensionManifest":{"properties":{"telemetry":{"type":"object","properties":{"ping_type":{"type":"string"},"schemaNamespace":{"type":"string"},"public_key":{"type":"object","properties":{"id":{"type":"string"},"key":{"type":"object","properties":{"crv":{"type":"string"},"kty":{"type":"string"},"x":{"type":"string"},"y":{"type":"string"}}}},"required":["id","key"]},"study_name":{"type":"string"},"pioneer_id":{"type":"boolean","default":false}},"required":["ping_type","schemaNamespace","public_key"]}}},"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["telemetry"]}]}},"refs":{"telemetry#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"},"telemetry#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{"ScalarType":{"type":"string","enum":["count","string","boolean"],"description":"Type of scalar: \'count\' for numeric values, \'string\' for string values, \'boolean\' for boolean values. Maps to <code>nsITelemetry.SCALAR_TYPE_*</code>."},"ScalarData":{"type":"object","description":"Represents registration data for a Telemetry scalar.","properties":{"kind":{"$ref":"#/types/ScalarType"},"keyed":{"type":"boolean","default":false,"description":"True if this is a keyed scalar."},"record_on_release":{"type":"boolean","default":false,"description":"True if this data should be recorded on release."},"expired":{"type":"boolean","default":false,"description":"True if this scalar entry is expired. This allows recording it without error, but it will be discarded."}},"required":["kind"]},"EventData":{"type":"object","description":"Represents registration data for a Telemetry event.","properties":{"methods":{"type":"array","items":{"type":"string"},"description":"List of methods for this event entry."},"objects":{"type":"array","items":{"type":"string"},"description":"List of objects for this event entry."},"extra_keys":{"type":"array","items":{"type":"string"},"description":"List of allowed extra keys for this event entry."},"record_on_release":{"type":"boolean","default":false,"description":"True if this data should be recorded on release."},"expired":{"type":"boolean","default":false,"description":"True if this event entry is expired. This allows recording it without error, but it will be discarded."}},"required":["methods","objects","extra_keys"]}}}');

/***/ }),
/* 78 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"test","allowedContexts":["content","devtools"],"defaultContexts":["content","devtools"],"description":"none","functions":[{"name":"withHandlingUserInput","type":"function","description":"Calls the callback function wrapped with user input set.  This is only used for internal unit testing.","parameters":[{"type":"function","name":"callback"}]},{"name":"notifyFail","type":"function","description":"Notifies the browser process that test code running in the extension failed.  This is only used for internal unit testing.","parameters":[{"type":"string","name":"message"}]},{"name":"notifyPass","type":"function","description":"Notifies the browser process that test code running in the extension passed.  This is only used for internal unit testing.","parameters":[{"type":"string","name":"message","optional":true}]},{"name":"log","type":"function","description":"Logs a message during internal unit testing.","parameters":[{"type":"string","name":"message"}]},{"name":"sendMessage","type":"function","description":"Sends a string message to the browser process, generating a Notification that C++ test code can wait for.","allowAmbiguousOptionalArguments":true,"parameters":[{"name":"arg1","optional":true},{"name":"arg2","optional":true}]},{"name":"fail","type":"function","parameters":[{"name":"message","optional":true}]},{"name":"succeed","type":"function","parameters":[{"name":"message","optional":true}]},{"name":"assertTrue","type":"function","allowAmbiguousOptionalArguments":true,"parameters":[{"name":"test","optional":true},{"type":"string","name":"message","optional":true}]},{"name":"assertFalse","type":"function","allowAmbiguousOptionalArguments":true,"parameters":[{"name":"test","optional":true},{"type":"string","name":"message","optional":true}]},{"name":"assertBool","type":"function","unsupported":true,"parameters":[{"name":"test","anyOf":[{"type":"string"},{"type":"boolean"}]},{"type":"boolean","name":"expected"},{"type":"string","name":"message","optional":true}]},{"name":"checkDeepEq","type":"function","unsupported":true,"allowAmbiguousOptionalArguments":true,"parameters":[{"name":"expected"},{"name":"actual"}]},{"name":"assertEq","type":"function","allowAmbiguousOptionalArguments":true,"parameters":[{"name":"expected","optional":true},{"name":"actual","optional":true},{"type":"string","name":"message","optional":true}]},{"name":"assertNoLastError","type":"function","unsupported":true,"parameters":[]},{"name":"assertLastError","type":"function","unsupported":true,"parameters":[{"type":"string","name":"expectedError"}]},{"name":"assertRejects","type":"function","async":true,"parameters":[{"allOf":[{"$ref":"#/types/Promise"},{"name":"promise"}]},{"allOf":[{"$ref":"#/types/ExpectedError"},{"name":"expectedError"}]},{"name":"message","type":"string","optional":true}]},{"name":"assertThrows","type":"function","parameters":[{"name":"func","type":"function"},{"allOf":[{"$ref":"#/types/ExpectedError"},{"name":"expectedError"}]},{"name":"message","type":"string","optional":true}]}],"events":[{"name":"onMessage","type":"function","description":"Used to test sending messages to extensions.","parameters":[{"type":"string","name":"message"},{"name":"argument"}]}],"definitions":{},"refs":{},"types":{"ExpectedError":{"anyOf":[{"type":"string"},{"type":"object","isInstanceOf":"RegExp","additionalProperties":true},{"type":"function"}]},"Promise":{"anyOf":[{"type":"object","properties":{"then":{"type":"function"}},"additionalProperties":true,"required":["then"]},{"type":"object","isInstanceOf":"Promise","additionalProperties":true}]}}}');

/***/ }),
/* 79 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"theme","description":"The theme API allows customizing of visual elements of the browser.","events":[{"name":"onUpdated","type":"function","description":"Fired when a new theme has been applied","parameters":[{"allOf":[{"$ref":"#/types/ThemeUpdateInfo"},{"name":"updateInfo","description":"Details of the theme update"}]}]}],"functions":[{"name":"getCurrent","type":"function","async":true,"description":"Returns the current theme for the specified window or the last focused window.","parameters":[{"type":"integer","name":"windowId","optional":true,"description":"The window for which we want the theme."}]},{"name":"update","type":"function","async":true,"description":"Make complete updates to the theme. Resolves when the update has completed.","permissions":["theme"],"parameters":[{"type":"integer","name":"windowId","optional":true,"description":"The id of the window to update. No id updates all windows."},{"allOf":[{"$ref":"manifest#/types/ThemeType"},{"name":"details","description":"The properties of the theme to update."}]}]},{"name":"reset","type":"function","async":true,"description":"Removes the updates made to the theme.","permissions":["theme"],"parameters":[{"type":"integer","name":"windowId","optional":true,"description":"The id of the window to reset. No id resets all windows."}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["theme"]}]},"WebExtensionManifest":{"properties":{"theme_experiment":{"$ref":"#/types/ThemeExperiment"}}}},"refs":{"theme#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"},"theme#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"ThemeUpdateInfo":{"type":"object","description":"Info provided in the onUpdated listener.","properties":{"theme":{"type":"object","description":"The new theme after update"},"windowId":{"type":"integer","description":"The id of the window the theme has been applied to"}},"required":["theme"]},"ThemeColor":{"anyOf":[{"type":"string"},{"type":"array","minItems":3,"maxItems":3,"items":{"type":"integer","minimum":0,"maximum":255}},{"type":"array","minItems":4,"maxItems":4,"items":{"type":"number"}}]},"ThemeExperiment":{"type":"object","properties":{"stylesheet":{"$ref":"manifest#/types/ExtensionURL"},"images":{"type":"object","additionalProperties":{"type":"string"}},"colors":{"type":"object","additionalProperties":{"type":"string"}},"properties":{"type":"object","additionalProperties":{"type":"string"}}}},"ThemeType":{"type":"object","properties":{"images":{"type":"object","properties":{"additional_backgrounds":{"type":"array","items":{"$ref":"manifest#/types/ImageDataOrExtensionURL"},"maxItems":15},"headerURL":{"allOf":[{"$ref":"manifest#/types/ImageDataOrExtensionURL"},{"deprecated":"Unsupported images property, use \'theme.images.theme_frame\', this alias is ignored in Firefox >= 70."}]},"theme_frame":{"$ref":"manifest#/types/ImageDataOrExtensionURL"}},"additionalProperties":{"$ref":"manifest#/types/ImageDataOrExtensionURL"}},"colors":{"type":"object","properties":{"tab_selected":{"$ref":"#/types/ThemeColor"},"accentcolor":{"allOf":[{"$ref":"#/types/ThemeColor"},{"deprecated":"Unsupported colors property, use \'theme.colors.frame\', this alias is ignored in Firefox >= 70."}]},"frame":{"$ref":"#/types/ThemeColor"},"frame_inactive":{"$ref":"#/types/ThemeColor"},"textcolor":{"allOf":[{"$ref":"#/types/ThemeColor"},{"deprecated":"Unsupported color property, use \'theme.colors.tab_background_text\', this alias is ignored in Firefox >= 70."}]},"tab_background_text":{"$ref":"#/types/ThemeColor"},"tab_background_separator":{"$ref":"#/types/ThemeColor"},"tab_loading":{"$ref":"#/types/ThemeColor"},"tab_text":{"$ref":"#/types/ThemeColor"},"tab_line":{"$ref":"#/types/ThemeColor"},"toolbar":{"$ref":"#/types/ThemeColor"},"toolbar_text":{"allOf":[{"$ref":"#/types/ThemeColor"},{"description":"This color property is an alias of \'bookmark_text\'."}]},"bookmark_text":{"$ref":"#/types/ThemeColor"},"toolbar_field":{"$ref":"#/types/ThemeColor"},"toolbar_field_text":{"$ref":"#/types/ThemeColor"},"toolbar_field_border":{"$ref":"#/types/ThemeColor"},"toolbar_field_separator":{"allOf":[{"$ref":"#/types/ThemeColor"},{"deprecated":"This color property is ignored in Firefox >= 89."}]},"toolbar_top_separator":{"$ref":"#/types/ThemeColor"},"toolbar_bottom_separator":{"$ref":"#/types/ThemeColor"},"toolbar_vertical_separator":{"$ref":"#/types/ThemeColor"},"icons":{"$ref":"#/types/ThemeColor"},"icons_attention":{"$ref":"#/types/ThemeColor"},"button_background_hover":{"$ref":"#/types/ThemeColor"},"button_background_active":{"$ref":"#/types/ThemeColor"},"popup":{"$ref":"#/types/ThemeColor"},"popup_text":{"$ref":"#/types/ThemeColor"},"popup_border":{"$ref":"#/types/ThemeColor"},"toolbar_field_focus":{"$ref":"#/types/ThemeColor"},"toolbar_field_text_focus":{"$ref":"#/types/ThemeColor"},"toolbar_field_border_focus":{"$ref":"#/types/ThemeColor"},"popup_highlight":{"$ref":"#/types/ThemeColor"},"popup_highlight_text":{"$ref":"#/types/ThemeColor"},"ntp_background":{"$ref":"#/types/ThemeColor"},"ntp_text":{"$ref":"#/types/ThemeColor"},"sidebar":{"$ref":"#/types/ThemeColor"},"sidebar_border":{"$ref":"#/types/ThemeColor"},"sidebar_text":{"$ref":"#/types/ThemeColor"},"sidebar_highlight":{"$ref":"#/types/ThemeColor"},"sidebar_highlight_text":{"$ref":"#/types/ThemeColor"},"toolbar_field_highlight":{"$ref":"#/types/ThemeColor"},"toolbar_field_highlight_text":{"$ref":"#/types/ThemeColor"}},"additionalProperties":{"$ref":"#/types/ThemeColor"}},"properties":{"type":"object","properties":{"additional_backgrounds_alignment":{"type":"array","items":{"type":"string","enum":["bottom","center","left","right","top","center bottom","center center","center top","left bottom","left center","left top","right bottom","right center","right top"]},"maxItems":15},"additional_backgrounds_tiling":{"type":"array","items":{"type":"string","enum":["no-repeat","repeat","repeat-x","repeat-y"]},"maxItems":15}},"additionalProperties":{"type":"string"}}}},"ThemeManifest":{"$merge":{"source":{"$ref":"manifest#/types/ManifestBase"},"with":{"type":"object","description":"Contents of manifest.json for a static theme","properties":{"theme":{"$ref":"#/types/ThemeType"},"dark_theme":{"$ref":"#/types/ThemeType"},"default_locale":{"type":"string"},"theme_experiment":{"$ref":"#/types/ThemeExperiment"},"icons":{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}}},"required":["theme"]}}}}}');

/***/ }),
/* 80 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"topSites","description":"Use the chrome.topSites API to access the top sites that are displayed on the new tab page. ","permissions":["topSites"],"functions":[{"name":"get","type":"function","description":"Gets a list of top sites.","async":"callback","parameters":[{"type":"object","name":"options","properties":{"providers":{"type":"array","items":{"type":"string"},"deprecated":"Please use the other options to tune the results received from topSites.","default":[]},"limit":{"type":"integer","default":12,"maximum":100,"minimum":1,"description":"The number of top sites to return, defaults to the value used by Firefox"},"onePerDomain":{"type":"boolean","default":true,"description":"Limit the result to a single top site link per domain"},"includeBlocked":{"type":"boolean","default":false,"description":"Include sites that the user has blocked from appearing on the Firefox new tab."},"includeFavicon":{"type":"boolean","default":false,"description":"Include sites favicon if available."},"includePinned":{"type":"boolean","default":false,"description":"Include sites that the user has pinned on the Firefox new tab."},"includeSearchShortcuts":{"type":"boolean","default":false,"description":"Include search shortcuts appearing on the Firefox new tab."},"newtab":{"type":"boolean","default":false,"description":"Return the sites that exactly appear on the user\'s new-tab page. When true, all other options are ignored except limit and includeFavicon. If the user disabled newtab Top Sites, the newtab parameter will be ignored."}},"default":{},"optional":true},{"name":"callback","type":"function","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/MostVisitedURL"}}]}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["topSites"]}]}},"refs":{"topSites#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"MostVisitedURL":{"type":"object","description":"An object encapsulating a most visited URL, such as the URLs on the new tab page.","properties":{"url":{"type":"string","description":"The most visited URL."},"title":{"type":"string","description":"The title of the page."},"favicon":{"type":"string","description":"Data URL for the favicon, if available."},"type":{"type":"string","enum":["url","search"],"default":"url","description":"The entry type, either <code>url</code> for a normal page link, or <code>search</code> for a search shortcut."}},"required":["url"]}}}');

/***/ }),
/* 81 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"types","description":"Contains types used by other schemas.","definitions":{},"refs":{},"types":{"SettingScope":{"type":"string","enum":["regular","regular_only","incognito_persistent","incognito_session_only"],"description":"The scope of the Setting. One of<ul><li><var>regular</var>: setting for the regular profile (which is inherited by the incognito profile if not overridden elsewhere),</li><li><var>regular_only</var>: setting for the regular profile only (not inherited by the incognito profile),</li><li><var>incognito_persistent</var>: setting for the incognito profile that survives browser restarts (overrides regular preferences),</li><li><var>incognito_session_only</var>: setting for the incognito profile that can only be set during an incognito session and is deleted when the incognito session ends (overrides regular and incognito_persistent preferences).</li></ul> Only <var>regular</var> is supported by Firefox at this time."},"LevelOfControl":{"type":"string","enum":["not_controllable","controlled_by_other_extensions","controllable_by_this_extension","controlled_by_this_extension"],"description":"One of<ul><li><var>not_controllable</var>: cannot be controlled by any extension</li><li><var>controlled_by_other_extensions</var>: controlled by extensions with higher precedence</li><li><var>controllable_by_this_extension</var>: can be controlled by this extension</li><li><var>controlled_by_this_extension</var>: controlled by this extension</li></ul>"},"Setting":{"type":"object","functions":[{"name":"get","type":"function","description":"Gets the value of a setting.","async":"callback","parameters":[{"name":"details","type":"object","description":"Which setting to consider.","properties":{"incognito":{"type":"boolean","description":"Whether to return the value that applies to the incognito session (default false)."}}},{"name":"callback","type":"function","parameters":[{"name":"details","type":"object","description":"Details of the currently effective value.","properties":{"value":{"description":"The value of the setting."},"levelOfControl":{"allOf":[{"$ref":"types#/types/LevelOfControl"},{"description":"The level of control of the setting."}]},"incognitoSpecific":{"description":"Whether the effective value is specific to the incognito session.<br/>This property will <em>only</em> be present if the <var>incognito</var> property in the <var>details</var> parameter of <code>get()</code> was true.","type":"boolean"}},"required":["value","levelOfControl"]}]}]},{"name":"set","type":"function","description":"Sets the value of a setting.","async":"callback","parameters":[{"name":"details","type":"object","description":"Which setting to change.","properties":{"value":{"description":"The value of the setting. <br/>Note that every setting has a specific value type, which is described together with the setting. An extension should <em>not</em> set a value of a different type."},"scope":{"allOf":[{"$ref":"types#/types/SettingScope"},{"description":"Where to set the setting (default: regular)."}]}},"required":["value"]},{"name":"callback","type":"function","description":"Called at the completion of the set operation.","optional":true,"parameters":[]}]},{"name":"clear","type":"function","description":"Clears the setting, restoring any default value.","async":"callback","parameters":[{"name":"details","type":"object","description":"Which setting to clear.","properties":{"scope":{"allOf":[{"$ref":"types#/types/SettingScope"},{"description":"Where to clear the setting (default: regular)."}]}}},{"name":"callback","type":"function","description":"Called at the completion of the clear operation.","optional":true,"parameters":[]}]}],"events":[{"name":"onChange","type":"function","description":"Fired after the setting changes.","parameters":[{"type":"object","name":"details","properties":{"value":{"description":"The value of the setting after the change."},"levelOfControl":{"allOf":[{"$ref":"types#/types/LevelOfControl"},{"description":"The level of control of the setting."}]},"incognitoSpecific":{"description":"Whether the value that has changed is specific to the incognito session.<br/>This property will <em>only</em> be present if the user has enabled the extension in incognito mode.","type":"boolean"}},"required":["value","levelOfControl"]}]}]}}}');

/***/ }),
/* 82 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"url_overrides","definitions":{"WebExtensionManifest":{"properties":{"chrome_url_overrides":{"type":"object","properties":{"newtab":{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"preprocess":"localize"}]},"bookmarks":{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"unsupported":true,"preprocess":"localize"}]},"history":{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"unsupported":true,"preprocess":"localize"}]}}}}}},"refs":{"url_overrides#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{}}');

/***/ }),
/* 83 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"urlbar","description":"Use the <code>browser.urlbar</code> API to experiment with new features in the URLBar. Restricted to Mozilla privileged WebExtensions.","permissions":["urlbar"],"properties":{"engagementTelemetry":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Enables or disables the engagement telemetry."}]}},"functions":[{"name":"closeView","type":"function","async":true,"description":"Closes the urlbar view in the current window.","parameters":[]},{"name":"focus","type":"function","async":true,"description":"Focuses the urlbar in the current window.","parameters":[{"name":"select","type":"boolean","optional":true,"default":false,"description":"If true, the text in the urlbar will also be selected."}]},{"name":"search","type":"function","async":true,"description":"Starts a search in the urlbar in the current window.","parameters":[{"name":"searchString","type":"string","description":"The search string."},{"allOf":[{"$ref":"#/types/SearchOptions"},{"name":"options","optional":true,"default":{},"description":"Options for the search."}]}]}],"events":[{"name":"onBehaviorRequested","type":"function","description":"Before a query starts, this event is fired for the given provider. Its purpose is to request the provider\'s behavior for the query. The listener should return a behavior in response. By default, providers are inactive, so if your provider should always be inactive, you don\'t need to listen for this event.","parameters":[{"allOf":[{"$ref":"#/types/Query"},{"name":"query","description":"The query for which the behavior is requested."}]}],"extraParameters":[{"name":"providerName","type":"string","pattern":"^[a-zA-Z0-9_-]+$","description":"The name of the provider whose behavior the listener returns."}],"returns":{"type":"string","enum":["active","inactive","restricting"],"description":"The behavior of the provider for the query."}},{"name":"onEngagement","type":"function","description":"This event is fired when the user starts and ends an engagement with the urlbar.","parameters":[{"allOf":[{"$ref":"#/types/EngagementState"},{"name":"state","description":"The state of the engagement."}]}],"extraParameters":[{"name":"providerName","type":"string","pattern":"^[a-zA-Z0-9_-]+$","description":"The name of the provider that will listen for engagement events."}]},{"name":"onQueryCanceled","type":"function","description":"This event is fired for the given provider when a query is canceled. The listener should stop any ongoing fetch or creation of results and clean up its resources.","parameters":[{"allOf":[{"$ref":"#/types/Query"},{"name":"query","description":"The query that was canceled."}]}],"extraParameters":[{"name":"providerName","type":"string","pattern":"^[a-zA-Z0-9_-]+$","description":"The name of the provider that is creating results for the query."}]},{"name":"onResultsRequested","type":"function","description":"When a query starts, this event is fired for the given provider if the provider is active for the query and there are no other providers that are restricting. Its purpose is to request the provider\'s results for the query. The listener should return a list of results in response.","parameters":[{"allOf":[{"$ref":"#/types/Query"},{"name":"query","description":"The query for which results are requested."}]}],"extraParameters":[{"name":"providerName","type":"string","pattern":"^[a-zA-Z0-9_-]+$","description":"The name of the provider whose results the listener returns."}],"returns":{"type":"array","items":{"$ref":"#/types/Result"},"description":"The results that the provider fetched for the query."}},{"name":"onResultPicked","type":"function","description":"Typically, a provider includes a <code>url</code> property in its results\' payloads. When the user picks a result with a URL, Firefox automatically loads the URL. URLs don\'t make sense for every result type, however. When the user picks a result without a URL, this event is fired. The provider should take an appropriate action in response. Currently the only applicable <code>ResultTypes</code> are <code>dynamic</code> and <code>tip</code>.","parameters":[{"name":"payload","type":"object","description":"The payload of the result that was picked."},{"name":"elementName","type":"string","description":"If the result is a dynamic type, this is the name of the element in the result view that was picked. If the result is not a dynamic type, this is an empty string."}],"extraParameters":[{"name":"providerName","type":"string","pattern":"^[a-zA-Z0-9_-]+$","description":"The listener will be called for the results of the provider with this name."}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["urlbar"]}]}},"refs":{"urlbar#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{"EngagementState":{"type":"string","enum":["start","engagement","abandonment","discard"],"description":"The state of an engagement made with the urlbar by the user. <code>start</code>: The user has started an engagement. <code>engagement</code>: The user has completed an engagement by picking a result. <code>abandonment</code>: The user has abandoned their engagement, for example by blurring the urlbar. <code>discard</code>: The engagement ended in a way that should be ignored by listeners."},"Query":{"type":"object","description":"A query performed in the urlbar.","properties":{"isPrivate":{"type":"boolean","description":"Whether the query\'s browser context is private."},"maxResults":{"type":"integer","description":"The maximum number of results shown to the user."},"searchString":{"type":"string","description":"The query\'s search string."},"sources":{"type":"array","description":"List of acceptable source types to return.","items":{"$ref":"#/types/SourceType"}}},"required":["isPrivate","maxResults","searchString","sources"]},"Result":{"type":"object","description":"A result of a query. Queries can have many results. Each result is created by a provider.","properties":{"payload":{"type":"object","description":"An object with arbitrary properties depending on the result\'s type."},"source":{"allOf":[{"$ref":"#/types/SourceType"},{"description":"The result\'s source."}]},"type":{"allOf":[{"$ref":"#/types/ResultType"},{"description":"The result\'s type."}]},"suggestedIndex":{"type":"integer","description":"Suggest a preferred position for this result within the result set.","default":-1}},"required":["payload","source","type"]},"ResultType":{"type":"string","enum":["dynamic","remote_tab","search","tab","tip","url"],"description":"Possible types of results. <code>dynamic</code>: A result whose view and payload are specified by the extension. <code>remote_tab</code>: A synced tab from another device. <code>search</code>: A search suggestion from a search engine. <code>tab</code>: An open tab in the browser. <code>tip</code>: An actionable message to help the user with their query. <code>url</code>: A URL that\'s not one of the other types."},"SearchOptions":{"type":"object","description":"Options to the <code>search</code> function.","properties":{"focus":{"type":"boolean","default":true,"description":"Whether to focus the input field and select its contents."}}},"SourceType":{"type":"string","enum":["bookmarks","history","local","network","search","tabs"],"description":"Possible sources of results. <code>bookmarks</code>: The result comes from the user\'s bookmarks. <code>history</code>: The result comes from the user\'s history. <code>local</code>: The result comes from some local source not covered by another source type. <code>network</code>: The result comes from some network source not covered by another source type. <code>search</code>: The result comes from a search engine. <code>tabs</code>: The result is an open tab in the browser or a synced tab from another device."}}}');

/***/ }),
/* 84 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"userScripts","permissions":["manifest:user_scripts"],"functions":[{"name":"register","type":"function","description":"Register a user script programmatically given its $(ref:userScripts.UserScriptOptions), and resolves to a $(ref:userScripts.RegisteredUserScript) instance","async":true,"parameters":[{"allOf":[{"$ref":"#/types/UserScriptOptions"},{"name":"userScriptOptions"}]}]}],"definitions":{"WebExtensionManifest":{"properties":{"user_scripts":{"type":"object","properties":{"api_script":{"$ref":"manifest#/types/ExtensionURL"}}}}}},"refs":{"userScripts#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"UserScriptOptions":{"type":"object","description":"Details of a user script","properties":{"js":{"type":"array","description":"The list of JS files to inject","minItems":1,"items":{"$ref":"extensionTypes#/types/ExtensionFileOrCode"}},"scriptMetadata":{"allOf":[{"$ref":"extensionTypes#/types/PlainJSONValue"},{"description":"An opaque user script metadata value"}]},"matches":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/MatchPattern"}},"excludeMatches":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/MatchPattern"}},"includeGlobs":{"type":"array","items":{"type":"string"}},"excludeGlobs":{"type":"array","items":{"type":"string"}},"allFrames":{"type":"boolean","default":false,"description":"If allFrames is <code>true</code>, implies that the JavaScript should be injected into all frames of current page. By default, it\'s <code>false</code> and is only injected into the top frame."},"matchAboutBlank":{"type":"boolean","default":false,"description":"If matchAboutBlank is true, then the code is also injected in about:blank and about:srcdoc frames if your extension has access to its parent document. Code cannot be inserted in top-level about:-frames. By default it is <code>false</code>."},"runAt":{"allOf":[{"$ref":"extensionTypes#/types/RunAt"},{"default":"document_idle","description":"The soonest that the JavaScript will be injected into the tab. Defaults to \\"document_idle\\"."}]}},"required":["js","matches"]},"RegisteredUserScript":{"type":"object","description":"An object that represents a user script registered programmatically","functions":[{"name":"unregister","type":"function","description":"Unregister a user script registered programmatically","async":true,"parameters":[]}]}},"allowedContexts":["content"],"events":[{"name":"onBeforeScript","permissions":["manifest:user_scripts.api_script"],"allowedContexts":["content","content_only"],"type":"function","description":"Event called when a new userScript global has been created","parameters":[{"type":"object","name":"userScript","properties":{"metadata":{"description":"The userScript metadata (as set in userScripts.register)"},"global":{"description":"The userScript global"},"defineGlobals":{"type":"function","description":"Exports all the properties of a given plain object as userScript globals","parameters":[{"type":"object","name":"sourceObject","description":"A plain object whose properties are exported as userScript globals"}]},"export":{"type":"function","description":"Convert a given value to make it accessible to the userScript code","parameters":[{"name":"value","description":"A value to convert into an object accessible to the userScript"}],"returns":{}}},"required":["metadata","global","defineGlobals","export"]}]}]}');

/***/ }),
/* 85 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"webNavigation","description":"Use the <code>browser.webNavigation</code> API to receive notifications about the status of navigation requests in-flight.","permissions":["webNavigation"],"functions":[{"name":"getFrame","type":"function","description":"Retrieves information about the given frame. A frame refers to an &lt;iframe&gt; or a &lt;frame&gt; of a web page and is identified by a tab ID and a frame ID.","async":"callback","parameters":[{"type":"object","name":"details","description":"Information about the frame to retrieve information about.","properties":{"tabId":{"type":"integer","minimum":0,"description":"The ID of the tab in which the frame is."},"processId":{"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","minimum":0,"description":"The ID of the frame in the given tab."}},"required":["tabId","frameId"]},{"type":"function","name":"callback","parameters":[{"type":"object","name":"details","optional":true,"description":"Information about the requested frame, null if the specified frame ID and/or tab ID are invalid.","properties":{"errorOccurred":{"type":"boolean","description":"True if the last navigation in this frame was interrupted by an error, i.e. the onErrorOccurred event fired."},"url":{"type":"string","description":"The URL currently associated with this frame, if the frame identified by the frameId existed at one point in the given tab. The fact that an URL is associated with a given frameId does not imply that the corresponding frame still exists."},"tabId":{"type":"integer","description":"The ID of the tab in which the frame is."},"frameId":{"type":"integer","description":"The ID of the frame. 0 indicates that this is the main frame; a positive value indicates the ID of a subframe."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame. Set to -1 of no parent frame exists."}},"required":["url","tabId","frameId","parentFrameId"]}]}]},{"name":"getAllFrames","type":"function","description":"Retrieves information about all frames of a given tab.","async":"callback","parameters":[{"type":"object","name":"details","description":"Information about the tab to retrieve all frames from.","properties":{"tabId":{"type":"integer","minimum":0,"description":"The ID of the tab."}},"required":["tabId"]},{"type":"function","name":"callback","parameters":[{"name":"details","type":"array","description":"A list of frames in the given tab, null if the specified tab ID is invalid.","optional":true,"items":{"type":"object","properties":{"errorOccurred":{"type":"boolean","description":"True if the last navigation in this frame was interrupted by an error, i.e. the onErrorOccurred event fired."},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"tabId":{"type":"integer","description":"The ID of the tab in which the frame is."},"frameId":{"type":"integer","description":"The ID of the frame. 0 indicates that this is the main frame; a positive value indicates the ID of a subframe."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame. Set to -1 of no parent frame exists."},"url":{"type":"string","description":"The URL currently associated with this frame."}},"required":["processId","tabId","frameId","parentFrameId","url"]}}]}]}],"events":[{"name":"onBeforeNavigate","type":"function","description":"Fired when a navigation is about to occur.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation is about to occur."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique for a given tab and process."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame. Set to -1 of no parent frame exists."},"timeStamp":{"type":"number","description":"The time when the browser was about to start the navigation, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","parentFrameId","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onCommitted","type":"function","description":"Fired when a navigation is committed. The document (and the resources it refers to, such as images and subframes) might still be downloading, but at least part of the document has been received from the server and the browser has decided to switch to the new document.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation occurs."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique within a tab."},"transitionType":{"allOf":[{"$ref":"#/types/TransitionType"},{"unsupported":true,"description":"Cause of the navigation."}]},"transitionQualifiers":{"unsupported":true,"type":"array","description":"A list of transition qualifiers.","items":{"$ref":"#/types/TransitionQualifier"}},"timeStamp":{"type":"number","description":"The time when the navigation was committed, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","transitionType","transitionQualifiers","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onDOMContentLoaded","type":"function","description":"Fired when the page\'s DOM is fully constructed, but the referenced resources may not finish loading.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation occurs."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique within a tab."},"timeStamp":{"type":"number","description":"The time when the page\'s DOM was fully constructed, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onCompleted","type":"function","description":"Fired when a document, including the resources it refers to, is completely loaded and initialized.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation occurs."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique within a tab."},"timeStamp":{"type":"number","description":"The time when the document finished loading, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onErrorOccurred","type":"function","description":"Fired when an error occurs and the navigation is aborted. This can happen if either a network error occurred, or the user aborted the navigation.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation occurs."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique within a tab."},"error":{"unsupported":true,"type":"string","description":"The error description."},"timeStamp":{"type":"number","description":"The time when the error occurred, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","error","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onCreatedNavigationTarget","type":"function","description":"Fired when a new window, or a new tab in an existing window, is created to host a navigation.","parameters":[{"type":"object","name":"details","properties":{"sourceTabId":{"type":"integer","description":"The ID of the tab in which the navigation is triggered."},"sourceProcessId":{"type":"integer","description":"The ID of the process runs the renderer for the source tab."},"sourceFrameId":{"type":"integer","description":"The ID of the frame with sourceTabId in which the navigation is triggered. 0 indicates the main frame."},"url":{"type":"string","description":"The URL to be opened in the new window."},"tabId":{"type":"integer","description":"The ID of the tab in which the url is opened"},"timeStamp":{"type":"number","description":"The time when the browser was about to create a new view, in milliseconds since the epoch."}},"required":["sourceTabId","sourceProcessId","sourceFrameId","url","tabId","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onReferenceFragmentUpdated","type":"function","description":"Fired when the reference fragment of a frame was updated. All future events for that frame will use the updated URL.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation occurs."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique within a tab."},"transitionType":{"allOf":[{"$ref":"#/types/TransitionType"},{"unsupported":true,"description":"Cause of the navigation."}]},"transitionQualifiers":{"unsupported":true,"type":"array","description":"A list of transition qualifiers.","items":{"$ref":"#/types/TransitionQualifier"}},"timeStamp":{"type":"number","description":"The time when the navigation was committed, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","transitionType","transitionQualifiers","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onTabReplaced","type":"function","description":"Fired when the contents of the tab is replaced by a different (usually previously pre-rendered) tab.","parameters":[{"type":"object","name":"details","properties":{"replacedTabId":{"type":"integer","description":"The ID of the tab that was replaced."},"tabId":{"type":"integer","description":"The ID of the tab that replaced the old tab."},"timeStamp":{"type":"number","description":"The time when the replacement happened, in milliseconds since the epoch."}},"required":["replacedTabId","tabId","timeStamp"]}]},{"name":"onHistoryStateUpdated","type":"function","description":"Fired when the frame\'s history was updated to a new URL. All future events for that frame will use the updated URL.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation occurs."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique within a tab."},"transitionType":{"allOf":[{"$ref":"#/types/TransitionType"},{"unsupported":true,"description":"Cause of the navigation."}]},"transitionQualifiers":{"unsupported":true,"type":"array","description":"A list of transition qualifiers.","items":{"$ref":"#/types/TransitionQualifier"}},"timeStamp":{"type":"number","description":"The time when the navigation was committed, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","transitionType","transitionQualifiers","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["webNavigation"]}]}},"refs":{"webNavigation#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"TransitionType":{"type":"string","enum":["link","typed","auto_bookmark","auto_subframe","manual_subframe","generated","start_page","form_submit","reload","keyword","keyword_generated"],"description":"Cause of the navigation. The same transition types as defined in the history API are used. These are the same transition types as defined in the $(topic:transition_types)[history API] except with <code>\\"start_page\\"</code> in place of <code>\\"auto_toplevel\\"</code> (for backwards compatibility)."},"TransitionQualifier":{"type":"string","enum":["client_redirect","server_redirect","forward_back","from_address_bar"]},"EventUrlFilters":{"type":"object","properties":{"url":{"type":"array","minItems":1,"items":{"$ref":"events#/types/UrlFilter"}}},"required":["url"]}}}');

/***/ }),
/* 86 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"webRequest","description":"Use the <code>browser.webRequest</code> API to observe and analyze traffic and to intercept, block, or modify requests in-flight.","permissions":["webRequest"],"properties":{"MAX_HANDLER_BEHAVIOR_CHANGED_CALLS_PER_10_MINUTES":{"value":20,"description":"The maximum number of times that <code>handlerBehaviorChanged</code> can be called per 10 minute sustained interval. <code>handlerBehaviorChanged</code> is an expensive function call that shouldn\'t be called often."}},"functions":[{"name":"handlerBehaviorChanged","type":"function","description":"Needs to be called when the behavior of the webRequest handlers has changed to prevent incorrect handling due to caching. This function call is expensive. Don\'t call it often.","async":"callback","parameters":[{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"filterResponseData","permissions":["webRequestBlocking"],"type":"function","description":"...","parameters":[{"name":"requestId","type":"string"}],"returns":{"type":"object","additionalProperties":{},"isInstanceOf":"StreamFilter"}},{"name":"getSecurityInfo","type":"function","async":true,"description":"Retrieves the security information for the request.  Returns a promise that will resolve to a SecurityInfo object.","parameters":[{"name":"requestId","type":"string"},{"name":"options","optional":true,"type":"object","properties":{"certificateChain":{"type":"boolean","description":"Include the entire certificate chain."},"rawDER":{"type":"boolean","description":"Include raw certificate data for processing by the extension."}}}]}],"events":[{"name":"onBeforeRequest","type":"function","description":"Fired when a request is about to occur.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"requestBody":{"type":"object","description":"Contains the HTTP request body data. Only provided if extraInfoSpec contains \'requestBody\'.","properties":{"error":{"type":"string","description":"Errors when obtaining request body data."},"formData":{"type":"object","description":"If the request method is POST and the body is a sequence of key-value pairs encoded in UTF8, encoded as either multipart/form-data, or application/x-www-form-urlencoded, this dictionary is present and for each key contains the list of all values for that key. If the data is of another media type, or if it is malformed, the dictionary is not present. An example value of this dictionary is {\'key\': [\'value1\', \'value2\']}.","properties":{},"additionalProperties":{"type":"array","items":{"type":"string"}}},"raw":{"type":"array","items":{"$ref":"#/types/UploadData"},"description":"If the request method is PUT or POST, and the body is not already parsed in formData, then the unparsed request body elements are contained in this array."}}},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnBeforeRequestOptions"}}],"returns":{"allOf":[{"$ref":"#/types/BlockingResponse"},{"description":"If \\"blocking\\" is specified in the \\"extraInfoSpec\\" parameter, the event listener should return an object of this type.","optional":true}]}},{"name":"onBeforeSendHeaders","type":"function","description":"Fired before sending an HTTP request, once the request headers are available. This may occur after a TCP connection is made to the server, but before any HTTP data is sent. ","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"requestHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP request headers that are going to be sent out with this request."}]},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnBeforeSendHeadersOptions"}}],"returns":{"allOf":[{"$ref":"#/types/BlockingResponse"},{"description":"If \\"blocking\\" is specified in the \\"extraInfoSpec\\" parameter, the event listener should return an object of this type.","optional":true}]}},{"name":"onSendHeaders","type":"function","description":"Fired just before a request is going to be sent to the server (modifications of previous onBeforeSendHeaders callbacks are visible by the time onSendHeaders is fired).","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"requestHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP request headers that have been sent out with this request."}]},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnSendHeadersOptions"}}]},{"name":"onHeadersReceived","type":"function","description":"Fired when HTTP response headers of a request have been received.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"statusLine":{"type":"string","description":"HTTP status line of the response or the \'HTTP/0.9 200 OK\' string for HTTP/0.9 responses (i.e., responses that lack a status line)."},"responseHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP response headers that have been received with this response."}]},"statusCode":{"type":"integer","description":"Standard HTTP status code returned by the server."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","statusLine","statusCode","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnHeadersReceivedOptions"}}],"returns":{"allOf":[{"$ref":"#/types/BlockingResponse"},{"description":"If \\"blocking\\" is specified in the \\"extraInfoSpec\\" parameter, the event listener should return an object of this type.","optional":true}]}},{"name":"onAuthRequired","type":"function","description":"Fired when an authentication failure is received. The listener has three options: it can provide authentication credentials, it can cancel the request and display the error page, or it can take no action on the challenge. If bad user credentials are provided, this may be called multiple times for the same request.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"scheme":{"type":"string","description":"The authentication scheme, e.g. Basic or Digest."},"realm":{"type":"string","description":"The authentication realm provided by the server, if there is one."},"challenger":{"type":"object","description":"The server requesting authentication.","properties":{"host":{"type":"string"},"port":{"type":"integer"}},"required":["host","port"]},"isProxy":{"type":"boolean","description":"True for Proxy-Authenticate, false for WWW-Authenticate."},"responseHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP response headers that were received along with this response."}]},"statusLine":{"type":"string","description":"HTTP status line of the response or the \'HTTP/0.9 200 OK\' string for HTTP/0.9 responses (i.e., responses that lack a status line) or an empty string if there are no headers."},"statusCode":{"type":"integer","description":"Standard HTTP status code returned by the server."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","scheme","challenger","isProxy","statusLine","statusCode","thirdParty"]},{"type":"function","optional":true,"name":"callback","parameters":[{"allOf":[{"$ref":"#/types/BlockingResponse"},{"name":"response"}]}]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnAuthRequiredOptions"}}],"returns":{"allOf":[{"$ref":"#/types/BlockingResponse"},{"description":"If \\"blocking\\" is specified in the \\"extraInfoSpec\\" parameter, the event listener should return an object of this type.","optional":true}]}},{"name":"onResponseStarted","type":"function","description":"Fired when the first byte of the response body is received. For HTTP requests, this means that the status line and response headers are available.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"ip":{"type":"string","description":"The server IP address that the request was actually sent to. Note that it may be a literal IPv6 address."},"fromCache":{"type":"boolean","description":"Indicates if this response was fetched from disk cache."},"statusCode":{"type":"integer","description":"Standard HTTP status code returned by the server."},"responseHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP response headers that were received along with this response."}]},"statusLine":{"type":"string","description":"HTTP status line of the response or the \'HTTP/0.9 200 OK\' string for HTTP/0.9 responses (i.e., responses that lack a status line) or an empty string if there are no headers."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","fromCache","statusCode","statusLine","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnResponseStartedOptions"}}]},{"name":"onBeforeRedirect","type":"function","description":"Fired when a server-initiated redirect is about to occur.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"ip":{"type":"string","description":"The server IP address that the request was actually sent to. Note that it may be a literal IPv6 address."},"fromCache":{"type":"boolean","description":"Indicates if this response was fetched from disk cache."},"statusCode":{"type":"integer","description":"Standard HTTP status code returned by the server."},"redirectUrl":{"type":"string","description":"The new URL."},"responseHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP response headers that were received along with this redirect."}]},"statusLine":{"type":"string","description":"HTTP status line of the response or the \'HTTP/0.9 200 OK\' string for HTTP/0.9 responses (i.e., responses that lack a status line) or an empty string if there are no headers."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","fromCache","statusCode","redirectUrl","statusLine","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnBeforeRedirectOptions"}}]},{"name":"onCompleted","type":"function","description":"Fired when a request is completed.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"ip":{"type":"string","description":"The server IP address that the request was actually sent to. Note that it may be a literal IPv6 address."},"fromCache":{"type":"boolean","description":"Indicates if this response was fetched from disk cache."},"statusCode":{"type":"integer","description":"Standard HTTP status code returned by the server."},"responseHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP response headers that were received along with this response."}]},"statusLine":{"type":"string","description":"HTTP status line of the response or the \'HTTP/0.9 200 OK\' string for HTTP/0.9 responses (i.e., responses that lack a status line) or an empty string if there are no headers."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."},"requestSize":{"type":"integer","description":"For http requests, the bytes transferred in the request. Only available in onCompleted."},"responseSize":{"type":"integer","description":"For http requests, the bytes received in the request. Only available in onCompleted."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","fromCache","statusCode","statusLine","urlClassification","thirdParty","requestSize","responseSize"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnCompletedOptions"}}]},{"name":"onErrorOccurred","type":"function","description":"Fired when an error occurs.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"ip":{"type":"string","description":"The server IP address that the request was actually sent to. Note that it may be a literal IPv6 address."},"fromCache":{"type":"boolean","description":"Indicates if this response was fetched from disk cache."},"error":{"type":"string","description":"The error description. This string is <em>not</em> guaranteed to remain backwards compatible between releases. You must not parse and act based upon its content."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","fromCache","error","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]}]}],"definitions":{"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["webRequest","webRequestBlocking"]}]}},"refs":{"webRequest#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"}},"types":{"ResourceType":{"type":"string","enum":["main_frame","sub_frame","stylesheet","script","image","object","object_subrequest","xmlhttprequest","xslt","ping","beacon","xml_dtd","font","media","websocket","csp_report","imageset","web_manifest","speculative","other"]},"OnBeforeRequestOptions":{"type":"string","enum":["blocking","requestBody"],"postprocess":"webRequestBlockingPermissionRequired"},"OnBeforeSendHeadersOptions":{"type":"string","enum":["requestHeaders","blocking"],"postprocess":"webRequestBlockingPermissionRequired"},"OnSendHeadersOptions":{"type":"string","enum":["requestHeaders"]},"OnHeadersReceivedOptions":{"type":"string","enum":["blocking","responseHeaders"],"postprocess":"webRequestBlockingPermissionRequired"},"OnAuthRequiredOptions":{"type":"string","enum":["responseHeaders","blocking","asyncBlocking"],"postprocess":"webRequestBlockingPermissionRequired"},"OnResponseStartedOptions":{"type":"string","enum":["responseHeaders"]},"OnBeforeRedirectOptions":{"type":"string","enum":["responseHeaders"]},"OnCompletedOptions":{"type":"string","enum":["responseHeaders"]},"RequestFilter":{"type":"object","description":"An object describing filters to apply to webRequest events.","properties":{"urls":{"type":"array","description":"A list of URLs or URL patterns. Requests that cannot match any of the URLs will be filtered out.","items":{"type":"string"},"minItems":1},"types":{"type":"array","description":"A list of request types. Requests that cannot match any of the types will be filtered out.","items":{"allOf":[{"$ref":"#/types/ResourceType"},{"onError":"warn"}]},"minItems":1},"tabId":{"type":"integer"},"windowId":{"type":"integer"},"incognito":{"type":"boolean","description":"If provided, requests that do not match the incognito state will be filtered out."}},"required":["urls"]},"HttpHeaders":{"type":"array","description":"An array of HTTP headers. Each header is represented as a dictionary containing the keys <code>name</code> and either <code>value</code> or <code>binaryValue</code>.","items":{"type":"object","properties":{"name":{"type":"string","description":"Name of the HTTP header."},"value":{"type":"string","description":"Value of the HTTP header if it can be represented by UTF-8."},"binaryValue":{"type":"array","description":"Value of the HTTP header if it cannot be represented by UTF-8, stored as individual byte values (0..255).","items":{"type":"integer"}}},"required":["name"]}},"BlockingResponse":{"type":"object","description":"Returns value for event handlers that have the \'blocking\' extraInfoSpec applied. Allows the event handler to modify network requests.","properties":{"cancel":{"type":"boolean","description":"If true, the request is cancelled. Used in onBeforeRequest, this prevents the request from being sent."},"redirectUrl":{"type":"string","description":"Only used as a response to the onBeforeRequest and onHeadersReceived events. If set, the original request is prevented from being sent/completed and is instead redirected to the given URL. Redirections to non-HTTP schemes such as data: are allowed. Redirects initiated by a redirect action use the original request method for the redirect, with one exception: If the redirect is initiated at the onHeadersReceived stage, then the redirect will be issued using the GET method."},"upgradeToSecure":{"type":"boolean","description":"Only used as a response to the onBeforeRequest event. If set, the original request is prevented from being sent/completed and is instead upgraded to a secure request.  If any extension returns <code>redirectUrl</code> during onBeforeRequest, <code>upgradeToSecure</code> will have no affect."},"requestHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"Only used as a response to the onBeforeSendHeaders event. If set, the request is made with these request headers instead."}]},"responseHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"Only used as a response to the onHeadersReceived event. If set, the server is assumed to have responded with these response headers instead. Only return <code>responseHeaders</code> if you really want to modify the headers in order to limit the number of conflicts (only one extension may modify <code>responseHeaders</code> for each request)."}]},"authCredentials":{"type":"object","description":"Only used as a response to the onAuthRequired event. If set, the request is made using the supplied credentials.","properties":{"username":{"type":"string"},"password":{"type":"string"}},"required":["username","password"]}}},"CertificateInfo":{"type":"object","description":"Contains the certificate properties of the request if it is a secure request.","properties":{"subject":{"type":"string"},"issuer":{"type":"string"},"validity":{"type":"object","description":"Contains start and end timestamps.","properties":{"start":{"type":"integer"},"end":{"type":"integer"}},"required":["start","end"]},"fingerprint":{"type":"object","properties":{"sha1":{"type":"string"},"sha256":{"type":"string"}},"required":["sha1","sha256"]},"serialNumber":{"type":"string"},"isBuiltInRoot":{"type":"boolean"},"subjectPublicKeyInfoDigest":{"type":"object","properties":{"sha256":{"type":"string"}},"required":["sha256"]},"rawDER":{"type":"array","items":{"type":"integer"}}},"required":["subject","issuer","validity","fingerprint","serialNumber","isBuiltInRoot","subjectPublicKeyInfoDigest"]},"CertificateTransparencyStatus":{"type":"string","enum":["not_applicable","policy_compliant","policy_not_enough_scts","policy_not_diverse_scts"]},"TransportWeaknessReasons":{"type":"string","enum":["cipher"]},"SecurityInfo":{"type":"object","description":"Contains the security properties of the request (ie. SSL/TLS information).","properties":{"state":{"type":"string","enum":["insecure","weak","broken","secure"]},"errorMessage":{"type":"string","description":"Error message if state is \\"broken\\""},"protocolVersion":{"type":"string","description":"Protocol version if state is \\"secure\\"","enum":["TLSv1","TLSv1.1","TLSv1.2","TLSv1.3","unknown"]},"cipherSuite":{"type":"string","description":"The cipher suite used in this request if state is \\"secure\\"."},"keaGroupName":{"type":"string","description":"The key exchange algorithm used in this request if state is \\"secure\\"."},"signatureSchemeName":{"type":"string","description":"The signature scheme used in this request if state is \\"secure\\"."},"certificates":{"description":"Certificate data if state is \\"secure\\".  Will only contain one entry unless <code>certificateChain</code> is passed as an option.","type":"array","items":{"$ref":"#/types/CertificateInfo"}},"isDomainMismatch":{"description":"The domain name does not match the certificate domain.","type":"boolean"},"isExtendedValidation":{"type":"boolean"},"isNotValidAtThisTime":{"description":"The certificate is either expired or is not yet valid.  See <code>CertificateInfo.validity</code> for start and end dates.","type":"boolean"},"isUntrusted":{"type":"boolean"},"certificateTransparencyStatus":{"allOf":[{"$ref":"#/types/CertificateTransparencyStatus"},{"description":"Certificate transparency compliance per RFC 6962.  See <code>https://www.certificate-transparency.org/what-is-ct</code> for more information."}]},"hsts":{"type":"boolean","description":"True if host uses Strict Transport Security and state is \\"secure\\"."},"hpkp":{"type":"string","description":"True if host uses Public Key Pinning and state is \\"secure\\"."},"weaknessReasons":{"type":"array","items":{"$ref":"#/types/TransportWeaknessReasons"},"description":"list of reasons that cause the request to be considered weak, if state is \\"weak\\""}},"required":["state","certificates"]},"UploadData":{"type":"object","properties":{"bytes":{"description":"An ArrayBuffer with a copy of the data."},"file":{"type":"string","description":"A string with the file\'s path and name."}},"description":"Contains data uploaded in a URL request."},"UrlClassificationFlags":{"type":"string","enum":["fingerprinting","fingerprinting_content","cryptomining","cryptomining_content","tracking","tracking_ad","tracking_analytics","tracking_social","tracking_content","any_basic_tracking","any_strict_tracking","any_social_tracking"],"description":"Tracking flags that match our internal tracking classification"},"UrlClassificationParty":{"type":"array","items":{"$ref":"#/types/UrlClassificationFlags"},"description":"If the request has been classified this is an array of $(ref:UrlClassificationFlags)."},"UrlClassification":{"type":"object","properties":{"firstParty":{"allOf":[{"$ref":"#/types/UrlClassificationParty"},{"description":"Classification flags if the request has been classified and it is first party."}]},"thirdParty":{"allOf":[{"$ref":"#/types/UrlClassificationParty"},{"description":"Classification flags if the request has been classified and it or its window hierarchy is third party."}]}},"required":["firstParty","thirdParty"]}}}');

/***/ }),
/* 87 */
/***/ ((module) => {

module.exports = JSON.parse('{"id":"windows","description":"Use the <code>browser.windows</code> API to interact with browser windows. You can use this API to create, modify, and rearrange windows in the browser.","properties":{"WINDOW_ID_NONE":{"value":-1,"description":"The windowId value that represents the absence of a browser window."},"WINDOW_ID_CURRENT":{"value":-2,"description":"The windowId value that represents the $(topic:current-window)[current window]."}},"functions":[{"name":"get","type":"function","description":"Gets details about a window.","async":"callback","parameters":[{"type":"integer","name":"windowId","minimum":-2},{"allOf":[{"$ref":"#/types/GetInfo"},{"name":"getInfo","optional":true}]},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Window"},{"name":"window"}]}]}]},{"name":"getCurrent","type":"function","description":"Gets the $(topic:current-window)[current window].","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/GetInfo"},{"name":"getInfo","optional":true}]},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Window"},{"name":"window"}]}]}]},{"name":"getLastFocused","type":"function","description":"Gets the window that was most recently focused &mdash; typically the window \'on top\'.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/GetInfo"},{"name":"getInfo","optional":true}]},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Window"},{"name":"window"}]}]}]},{"name":"getAll","type":"function","description":"Gets all windows.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"windows#/types/GetInfo"},"with":{"type":"object","name":"getInfo","optional":true,"description":"Specifies properties used to filter the $(ref:windows.Window) returned and to determine whether they should contain a list of the $(ref:tabs.Tab) objects.","properties":{"windowTypes":{"type":"array","items":{"$ref":"#/types/WindowType"},"description":"If set, the $(ref:windows.Window) returned will be filtered based on its type. If unset the default filter is set to <code>[\'app\', \'normal\', \'panel\', \'popup\']</code>, with <code>\'app\'</code> and <code>\'panel\'</code> window types limited to the extension\'s own windows."}}}}},{"type":"function","name":"callback","parameters":[{"name":"windows","type":"array","items":{"$ref":"#/types/Window"}}]}]},{"name":"create","type":"function","description":"Creates (opens) a new browser with any optional sizing, position or default URL provided.","async":"callback","parameters":[{"type":"object","name":"createData","optional":true,"default":{},"properties":{"url":{"description":"A URL or array of URLs to open as tabs in the window. Fully-qualified URLs must include a scheme (i.e. \'http://www.google.com\', not \'www.google.com\'). Relative URLs will be relative to the current page within the extension. Defaults to the New Tab Page.","anyOf":[{"type":"string","format":"relativeUrl"},{"type":"array","items":{"type":"string","format":"relativeUrl"}}]},"tabId":{"type":"integer","minimum":0,"description":"The id of the tab for which you want to adopt to the new window."},"left":{"type":"integer","description":"The number of pixels to position the new window from the left edge of the screen. If not specified, the new window is offset naturally from the last focused window. This value is ignored for panels."},"top":{"type":"integer","description":"The number of pixels to position the new window from the top edge of the screen. If not specified, the new window is offset naturally from the last focused window. This value is ignored for panels."},"width":{"type":"integer","minimum":0,"description":"The width in pixels of the new window, including the frame. If not specified defaults to a natural width."},"height":{"type":"integer","minimum":0,"description":"The height in pixels of the new window, including the frame. If not specified defaults to a natural height."},"focused":{"anyOf":[{"type":"boolean","enum":[true]},{"type":"boolean","enum":[false],"deprecated":"Opening inactive windows is not supported."}],"description":"If true, opens an active window. If false, opens an inactive window."},"incognito":{"type":"boolean","description":"Whether the new window should be an incognito window."},"type":{"allOf":[{"$ref":"#/types/CreateType"},{"description":"Specifies what type of browser window to create. The \'panel\' and \'detached_panel\' types create a popup unless the \'--enable-panels\' flag is set."}]},"state":{"allOf":[{"$ref":"#/types/WindowState"},{"description":"The initial state of the window. The \'minimized\', \'maximized\' and \'fullscreen\' states cannot be combined with \'left\', \'top\', \'width\' or \'height\'."}]},"allowScriptsToClose":{"type":"boolean","description":"Allow scripts to close the window."},"cookieStoreId":{"type":"string","description":"The CookieStoreId to use for all tabs that were created when the window is opened."},"titlePreface":{"type":"string","description":"A string to add to the beginning of the window title."}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Window"},{"name":"window","description":"Contains details about the created window.","optional":true}]}]}]},{"name":"update","type":"function","description":"Updates the properties of a window. Specify only the properties that you want to change; unspecified properties will be left unchanged.","async":"callback","parameters":[{"type":"integer","name":"windowId","minimum":-2},{"type":"object","name":"updateInfo","properties":{"left":{"type":"integer","description":"The offset from the left edge of the screen to move the window to in pixels. This value is ignored for panels."},"top":{"type":"integer","description":"The offset from the top edge of the screen to move the window to in pixels. This value is ignored for panels."},"width":{"type":"integer","minimum":0,"description":"The width to resize the window to in pixels. This value is ignored for panels."},"height":{"type":"integer","minimum":0,"description":"The height to resize the window to in pixels. This value is ignored for panels."},"focused":{"type":"boolean","description":"If true, brings the window to the front. If false, brings the next window in the z-order to the front."},"drawAttention":{"type":"boolean","description":"If true, causes the window to be displayed in a manner that draws the user\'s attention to the window, without changing the focused window. The effect lasts until the user changes focus to the window. This option has no effect if the window already has focus. Set to false to cancel a previous draw attention request."},"state":{"allOf":[{"$ref":"#/types/WindowState"},{"description":"The new state of the window. The \'minimized\', \'maximized\' and \'fullscreen\' states cannot be combined with \'left\', \'top\', \'width\' or \'height\'."}]},"titlePreface":{"type":"string","description":"A string to add to the beginning of the window title."}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Window"},{"name":"window"}]}]}]},{"name":"remove","type":"function","description":"Removes (closes) a window, and all the tabs inside it.","async":"callback","parameters":[{"type":"integer","name":"windowId","minimum":-2},{"type":"function","name":"callback","optional":true,"parameters":[]}]}],"events":[{"name":"onCreated","type":"function","description":"Fired when a window is created.","filters":[{"name":"windowTypes","type":"array","items":{"$ref":"#/types/WindowType"},"description":"Conditions that the window\'s type being created must satisfy. By default it will satisfy <code>[\'app\', \'normal\', \'panel\', \'popup\']</code>, with <code>\'app\'</code> and <code>\'panel\'</code> window types limited to the extension\'s own windows."}],"parameters":[{"allOf":[{"$ref":"#/types/Window"},{"name":"window","description":"Details of the window that was created."}]}]},{"name":"onRemoved","type":"function","description":"Fired when a window is removed (closed).","filters":[{"name":"windowTypes","type":"array","items":{"$ref":"#/types/WindowType"},"description":"Conditions that the window\'s type being removed must satisfy. By default it will satisfy <code>[\'app\', \'normal\', \'panel\', \'popup\']</code>, with <code>\'app\'</code> and <code>\'panel\'</code> window types limited to the extension\'s own windows."}],"parameters":[{"type":"integer","name":"windowId","minimum":0,"description":"ID of the removed window."}]},{"name":"onFocusChanged","type":"function","description":"Fired when the currently focused window changes. Will be $(ref:windows.WINDOW_ID_NONE) if all browser windows have lost focus. Note: On some Linux window managers, WINDOW_ID_NONE will always be sent immediately preceding a switch from one browser window to another.","filters":[{"name":"windowTypes","type":"array","items":{"$ref":"#/types/WindowType"},"description":"Conditions that the window\'s type being removed must satisfy. By default it will satisfy <code>[\'app\', \'normal\', \'panel\', \'popup\']</code>, with <code>\'app\'</code> and <code>\'panel\'</code> window types limited to the extension\'s own windows."}],"parameters":[{"type":"integer","name":"windowId","minimum":-1,"description":"ID of the newly focused window."}]}],"definitions":{},"refs":{},"types":{"WindowType":{"type":"string","description":"The type of browser window this is. Under some circumstances a Window may not be assigned type property, for example when querying closed windows from the $(ref:sessions) API.","enum":["normal","popup","panel","app","devtools"]},"WindowState":{"type":"string","description":"The state of this browser window. Under some circumstances a Window may not be assigned state property, for example when querying closed windows from the $(ref:sessions) API.","enum":["normal","minimized","maximized","fullscreen","docked"]},"Window":{"type":"object","properties":{"id":{"type":"integer","minimum":0,"description":"The ID of the window. Window IDs are unique within a browser session. Under some circumstances a Window may not be assigned an ID, for example when querying windows using the $(ref:sessions) API, in which case a session ID may be present."},"focused":{"type":"boolean","description":"Whether the window is currently the focused window."},"top":{"type":"integer","description":"The offset of the window from the top edge of the screen in pixels. Under some circumstances a Window may not be assigned top property, for example when querying closed windows from the $(ref:sessions) API."},"left":{"type":"integer","description":"The offset of the window from the left edge of the screen in pixels. Under some circumstances a Window may not be assigned left property, for example when querying closed windows from the $(ref:sessions) API."},"width":{"type":"integer","description":"The width of the window, including the frame, in pixels. Under some circumstances a Window may not be assigned width property, for example when querying closed windows from the $(ref:sessions) API."},"height":{"type":"integer","description":"The height of the window, including the frame, in pixels. Under some circumstances a Window may not be assigned height property, for example when querying closed windows from the $(ref:sessions) API."},"tabs":{"type":"array","items":{"$ref":"tabs#/types/Tab"},"description":"Array of $(ref:tabs.Tab) objects representing the current tabs in the window."},"incognito":{"type":"boolean","description":"Whether the window is incognito."},"type":{"allOf":[{"$ref":"#/types/WindowType"},{"description":"The type of browser window this is."}]},"state":{"allOf":[{"$ref":"#/types/WindowState"},{"description":"The state of this browser window."}]},"alwaysOnTop":{"type":"boolean","description":"Whether the window is set to be always on top."},"sessionId":{"type":"string","description":"The session ID used to uniquely identify a Window obtained from the $(ref:sessions) API."},"title":{"type":"string","description":"The title of the window. Read-only."}},"required":["focused","incognito","alwaysOnTop"]},"CreateType":{"type":"string","description":"Specifies what type of browser window to create. The \'panel\' and \'detached_panel\' types create a popup unless the \'--enable-panels\' flag is set.","enum":["normal","popup","panel","detached_panel"]},"GetInfo":{"type":"object","description":"Specifies whether the $(ref:windows.Window) returned should contain a list of the $(ref:tabs.Tab) objects.","properties":{"populate":{"type":"boolean","description":"If true, the $(ref:windows.Window) returned will have a <var>tabs</var> property that contains a list of the $(ref:tabs.Tab) objects. The <code>Tab</code> objects only contain the <code>url</code>, <code>title</code> and <code>favIconUrl</code> properties if the extension\'s manifest file includes the <code>\\"tabs\\"</code> permission."},"windowTypes":{"type":"array","items":{"$ref":"#/types/WindowType"},"deprecated":true,"description":"<code>windowTypes</code> is deprecated and ignored on Firefox."}}}}}');

/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
var exports = __webpack_exports__;


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.create = exports["default"] = void 0;

var _javascript = __webpack_require__(12);

var _browserApis = __webpack_require__(28);

var _utils = __webpack_require__(2);

const rule = {
  create(context) {
    return {
      MemberExpression(node) {
        if (!node.computed && node.object.object && (0, _utils.isBrowserNamespace)(node.object.object.name)) {
          const namespace = node.object.property.name;
          const property = node.property.name;
          const api = `${namespace}.${property}`;
          const {
            addonMetadata
          } = context.settings;

          if ((0, _browserApis.hasBrowserApi)(namespace, property, addonMetadata)) {
            return;
          }

          if ((0, _browserApis.isMV2RemovedApi)(namespace, property, addonMetadata)) {
            context.report({
              node,
              message: _javascript.REMOVED_MV2_API.messageFormat,
              data: {
                api
              }
            });
            return;
          }

          context.report(node, _javascript.UNSUPPORTED_API.messageFormat, {
            api
          });
        }
      }

    };
  }

};
var _default = rule;
exports["default"] = _default;
const {
  create
} = rule;
exports.create = create;
})();

module.exports = __webpack_exports__["default"];
/******/ })()
;
//# sourceMappingURL=webextension-unsupported-api.js.map