/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.controller.Controller;
import freemind.controller.FreeMindToolBar;
import freemind.controller.StructuredMenuHolder;
import freemind.controller.ZoomListener;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.mindmapmode.JAutoScrollBarPane;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JToolBar;

public class MindMapToolBar
extends FreeMindToolBar
implements ZoomListener {
    private static final String[] sizes = new String[]{"8", "10", "12", "14", "16", "18", "20", "24", "28"};
    private MindMapController c;
    private JComboBox fonts;
    private JComboBox size;
    private JAutoScrollBarPane iconToolBarScrollPane;
    private JToolBar iconToolBar;
    private boolean fontSize_IgnoreChangeEvent = false;
    private boolean fontFamily_IgnoreChangeEvent = false;
    private ItemListener fontsListener;
    private ItemListener sizeListener;
    private JComboBox zoom;
    private String userDefinedZoom;
    protected static Logger logger = null;

    public MindMapToolBar(MindMapController controller) {
        this.c = controller;
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.setRollover(true);
        this.fonts = new FreeMindComboBox(Tools.getAvailableFontFamilyNamesAsVector());
        this.fonts.setFocusable(false);
        this.size = new FreeMindComboBox(sizes);
        this.size.setFocusable(false);
        this.iconToolBar = new FreeMindToolBar();
        this.iconToolBarScrollPane = new JAutoScrollBarPane(this.iconToolBar);
        this.iconToolBar.setOrientation(1);
        this.iconToolBar.setRollover(true);
        this.iconToolBarScrollPane.getVerticalScrollBar().setUnitIncrement(100);
        this.fontsListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (MindMapToolBar.this.fontFamily_IgnoreChangeEvent) {
                    return;
                }
                MindMapToolBar.this.fontFamily_IgnoreChangeEvent = true;
                ((MindMapToolBar)MindMapToolBar.this).c.fontFamily.actionPerformed((String)e.getItem());
                MindMapToolBar.this.fontFamily_IgnoreChangeEvent = false;
            }
        };
        this.fonts.addItemListener(this.fontsListener);
        this.sizeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (MindMapToolBar.this.fontSize_IgnoreChangeEvent) {
                    return;
                }
                ((MindMapToolBar)MindMapToolBar.this).c.fontSize.actionPerformed((String)e.getItem());
            }
        };
        this.size.addItemListener(this.sizeListener);
        this.userDefinedZoom = controller.getText("user_defined_zoom");
        this.zoom = new FreeMindComboBox(controller.getController().getZooms());
        this.zoom.setSelectedItem("100%");
        this.zoom.addItem(this.userDefinedZoom);
        this.zoom.setFocusable(false);
        this.zoom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MindMapToolBar.this.setZoomByItem(e.getItem());
                }
            }
        });
    }

    private void setZoomByItem(Object item) {
        if (((String)item).equals(this.userDefinedZoom)) {
            return;
        }
        String dirty = (String)item;
        String cleaned = dirty.substring(0, dirty.length() - 1);
        float zoomValue = Float.parseFloat(cleaned) / 100.0f;
        this.getController().setZoom(zoomValue);
    }

    protected Controller getController() {
        return this.c.getController();
    }

    public void update(StructuredMenuHolder holder) {
        this.removeAll();
        holder.updateMenus(this, "mindmapmode_toolbar/");
        this.add(this.zoom);
        this.fonts.setMaximumRowCount(30);
        this.add(this.fonts);
        this.add(this.size);
        this.iconToolBar.removeAll();
        this.iconToolBar.add(this.c.removeLastIconAction);
        this.iconToolBar.add(this.c.removeAllIconsAction);
        this.iconToolBar.addSeparator();
        for (int i = 0; i < this.c.iconActions.size(); ++i) {
            this.iconToolBar.add((Action)this.c.iconActions.get(i));
        }
    }

    public void selectFontSize(String fontSize) {
        this.fontSize_IgnoreChangeEvent = true;
        this.size.setSelectedItem(fontSize);
        this.fontSize_IgnoreChangeEvent = false;
    }

    Component getLeftToolBar() {
        return this.iconToolBarScrollPane;
    }

    public void selectFontName(String fontName) {
        if (this.fontFamily_IgnoreChangeEvent) {
            return;
        }
        this.fontFamily_IgnoreChangeEvent = true;
        this.fonts.setEditable(true);
        this.fonts.setSelectedItem(fontName);
        this.fonts.setEditable(false);
        this.fontFamily_IgnoreChangeEvent = false;
    }

    void setAllActions(boolean enabled) {
        this.fonts.setEnabled(enabled);
        this.size.setEnabled(enabled);
    }

    @Override
    public void setZoom(float f) {
        logger.fine("setZoomComboBox is called with " + f + ".");
        String toBeFound = this.getItemForZoom(f);
        for (int i = 0; i < this.zoom.getItemCount(); ++i) {
            if (!toBeFound.equals((String)this.zoom.getItemAt(i))) continue;
            this.zoom.setSelectedItem(toBeFound);
            return;
        }
        this.zoom.setSelectedItem(this.userDefinedZoom);
    }

    private String getItemForZoom(float f) {
        return (int)(f * 100.0f) + "%";
    }

    public void startup() {
        this.getController().registerZoomListener(this);
    }

    public void shutdown() {
        this.getController().deregisterZoomListener(this);
    }

    private final class FreeMindComboBox
    extends JComboBox {
        private FreeMindComboBox(Vector pItems) {
            super(pItems);
        }

        public FreeMindComboBox(String[] pItems) {
            super(pItems);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

