/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFXMode;
import org.apache.fop.render.PrintRendererConfigurator;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.util.LogUtil;

public class PDFRendererConfigurator
extends PrintRendererConfigurator {
    public PDFRendererConfigurator(FOUserAgent userAgent) {
        super(userAgent);
    }

    public void configure(Renderer renderer) throws FOPException {
        Configuration cfg = super.getRendererConfig(renderer);
        if (cfg != null) {
            PDFRenderer pdfRenderer = (PDFRenderer)renderer;
            try {
                Map filterMap = PDFRendererConfigurator.buildFilterMapFromConfiguration(cfg);
                if (filterMap != null) {
                    pdfRenderer.setFilterMap(filterMap);
                }
            }
            catch (ConfigurationException e) {
                LogUtil.handleException((Log)PrintRendererConfigurator.log, (Exception)e, (boolean)false);
            }
            super.configure(renderer);
            String s = cfg.getChild("pdf-a-mode", true).getValue(null);
            if (s != null) {
                pdfRenderer.setAMode(PDFAMode.valueOf(s));
            }
            if ((s = cfg.getChild("pdf-x-mode", true).getValue(null)) != null) {
                pdfRenderer.setXMode(PDFXMode.valueOf(s));
            }
            if ((s = cfg.getChild("output-profile", true).getValue(null)) != null) {
                pdfRenderer.setOutputProfileURI(s);
            }
        }
    }

    public static Map buildFilterMapFromConfiguration(Configuration cfg) throws ConfigurationException {
        HashMap filterMap = new HashMap();
        Configuration[] filterLists = cfg.getChildren("filterList");
        int i = 0;
        while (i < filterLists.length) {
            Configuration filters = filterLists[i];
            String type = filters.getAttribute("type", null);
            Configuration[] filt = filters.getChildren("value");
            ArrayList<String> filterList = new ArrayList<String>();
            int j = 0;
            while (j < filt.length) {
                String name = filt[j].getValue();
                filterList.add(name);
                ++j;
            }
            if (type == null) {
                type = "default";
            }
            if (!filterList.isEmpty() && PrintRendererConfigurator.log.isDebugEnabled()) {
                StringBuffer debug = new StringBuffer("Adding PDF filter");
                if (filterList.size() != 1) {
                    debug.append("s");
                }
                debug.append(" for type ").append(type).append(": ");
                int j2 = 0;
                while (j2 < filterList.size()) {
                    if (j2 != 0) {
                        debug.append(", ");
                    }
                    debug.append(filterList.get(j2));
                    ++j2;
                }
                PrintRendererConfigurator.log.debug(debug.toString());
            }
            if (filterMap.get(type) != null) {
                throw new ConfigurationException("A filterList of type '" + type + "' has already been defined");
            }
            filterMap.put(type, filterList);
            ++i;
        }
        return filterMap;
    }
}

