﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/customer-profiles/CustomerProfiles_EXPORTS.h>
#include <aws/customer-profiles/CustomerProfilesRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace CustomerProfiles
{
namespace Model
{

  /**
   */
  class AWS_CUSTOMERPROFILES_API DeleteProfileObjectRequest : public CustomerProfilesRequest
  {
  public:
    DeleteProfileObjectRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "DeleteProfileObject"; }

    Aws::String SerializePayload() const override;


    /**
     * <p>The unique identifier of a customer profile.</p>
     */
    inline const Aws::String& GetProfileId() const{ return m_profileId; }

    /**
     * <p>The unique identifier of a customer profile.</p>
     */
    inline bool ProfileIdHasBeenSet() const { return m_profileIdHasBeenSet; }

    /**
     * <p>The unique identifier of a customer profile.</p>
     */
    inline void SetProfileId(const Aws::String& value) { m_profileIdHasBeenSet = true; m_profileId = value; }

    /**
     * <p>The unique identifier of a customer profile.</p>
     */
    inline void SetProfileId(Aws::String&& value) { m_profileIdHasBeenSet = true; m_profileId = std::move(value); }

    /**
     * <p>The unique identifier of a customer profile.</p>
     */
    inline void SetProfileId(const char* value) { m_profileIdHasBeenSet = true; m_profileId.assign(value); }

    /**
     * <p>The unique identifier of a customer profile.</p>
     */
    inline DeleteProfileObjectRequest& WithProfileId(const Aws::String& value) { SetProfileId(value); return *this;}

    /**
     * <p>The unique identifier of a customer profile.</p>
     */
    inline DeleteProfileObjectRequest& WithProfileId(Aws::String&& value) { SetProfileId(std::move(value)); return *this;}

    /**
     * <p>The unique identifier of a customer profile.</p>
     */
    inline DeleteProfileObjectRequest& WithProfileId(const char* value) { SetProfileId(value); return *this;}


    /**
     * <p>The unique identifier of the profile object generated by the service.</p>
     */
    inline const Aws::String& GetProfileObjectUniqueKey() const{ return m_profileObjectUniqueKey; }

    /**
     * <p>The unique identifier of the profile object generated by the service.</p>
     */
    inline bool ProfileObjectUniqueKeyHasBeenSet() const { return m_profileObjectUniqueKeyHasBeenSet; }

    /**
     * <p>The unique identifier of the profile object generated by the service.</p>
     */
    inline void SetProfileObjectUniqueKey(const Aws::String& value) { m_profileObjectUniqueKeyHasBeenSet = true; m_profileObjectUniqueKey = value; }

    /**
     * <p>The unique identifier of the profile object generated by the service.</p>
     */
    inline void SetProfileObjectUniqueKey(Aws::String&& value) { m_profileObjectUniqueKeyHasBeenSet = true; m_profileObjectUniqueKey = std::move(value); }

    /**
     * <p>The unique identifier of the profile object generated by the service.</p>
     */
    inline void SetProfileObjectUniqueKey(const char* value) { m_profileObjectUniqueKeyHasBeenSet = true; m_profileObjectUniqueKey.assign(value); }

    /**
     * <p>The unique identifier of the profile object generated by the service.</p>
     */
    inline DeleteProfileObjectRequest& WithProfileObjectUniqueKey(const Aws::String& value) { SetProfileObjectUniqueKey(value); return *this;}

    /**
     * <p>The unique identifier of the profile object generated by the service.</p>
     */
    inline DeleteProfileObjectRequest& WithProfileObjectUniqueKey(Aws::String&& value) { SetProfileObjectUniqueKey(std::move(value)); return *this;}

    /**
     * <p>The unique identifier of the profile object generated by the service.</p>
     */
    inline DeleteProfileObjectRequest& WithProfileObjectUniqueKey(const char* value) { SetProfileObjectUniqueKey(value); return *this;}


    /**
     * <p>The name of the profile object type.</p>
     */
    inline const Aws::String& GetObjectTypeName() const{ return m_objectTypeName; }

    /**
     * <p>The name of the profile object type.</p>
     */
    inline bool ObjectTypeNameHasBeenSet() const { return m_objectTypeNameHasBeenSet; }

    /**
     * <p>The name of the profile object type.</p>
     */
    inline void SetObjectTypeName(const Aws::String& value) { m_objectTypeNameHasBeenSet = true; m_objectTypeName = value; }

    /**
     * <p>The name of the profile object type.</p>
     */
    inline void SetObjectTypeName(Aws::String&& value) { m_objectTypeNameHasBeenSet = true; m_objectTypeName = std::move(value); }

    /**
     * <p>The name of the profile object type.</p>
     */
    inline void SetObjectTypeName(const char* value) { m_objectTypeNameHasBeenSet = true; m_objectTypeName.assign(value); }

    /**
     * <p>The name of the profile object type.</p>
     */
    inline DeleteProfileObjectRequest& WithObjectTypeName(const Aws::String& value) { SetObjectTypeName(value); return *this;}

    /**
     * <p>The name of the profile object type.</p>
     */
    inline DeleteProfileObjectRequest& WithObjectTypeName(Aws::String&& value) { SetObjectTypeName(std::move(value)); return *this;}

    /**
     * <p>The name of the profile object type.</p>
     */
    inline DeleteProfileObjectRequest& WithObjectTypeName(const char* value) { SetObjectTypeName(value); return *this;}


    /**
     * <p>The unique name of the domain.</p>
     */
    inline const Aws::String& GetDomainName() const{ return m_domainName; }

    /**
     * <p>The unique name of the domain.</p>
     */
    inline bool DomainNameHasBeenSet() const { return m_domainNameHasBeenSet; }

    /**
     * <p>The unique name of the domain.</p>
     */
    inline void SetDomainName(const Aws::String& value) { m_domainNameHasBeenSet = true; m_domainName = value; }

    /**
     * <p>The unique name of the domain.</p>
     */
    inline void SetDomainName(Aws::String&& value) { m_domainNameHasBeenSet = true; m_domainName = std::move(value); }

    /**
     * <p>The unique name of the domain.</p>
     */
    inline void SetDomainName(const char* value) { m_domainNameHasBeenSet = true; m_domainName.assign(value); }

    /**
     * <p>The unique name of the domain.</p>
     */
    inline DeleteProfileObjectRequest& WithDomainName(const Aws::String& value) { SetDomainName(value); return *this;}

    /**
     * <p>The unique name of the domain.</p>
     */
    inline DeleteProfileObjectRequest& WithDomainName(Aws::String&& value) { SetDomainName(std::move(value)); return *this;}

    /**
     * <p>The unique name of the domain.</p>
     */
    inline DeleteProfileObjectRequest& WithDomainName(const char* value) { SetDomainName(value); return *this;}

  private:

    Aws::String m_profileId;
    bool m_profileIdHasBeenSet;

    Aws::String m_profileObjectUniqueKey;
    bool m_profileObjectUniqueKeyHasBeenSet;

    Aws::String m_objectTypeName;
    bool m_objectTypeNameHasBeenSet;

    Aws::String m_domainName;
    bool m_domainNameHasBeenSet;
  };

} // namespace Model
} // namespace CustomerProfiles
} // namespace Aws
