/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.UpdateCheck;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.SafeTransferListener;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;

@Named
public class DefaultArtifactResolver
implements ArtifactResolver,
Service {
    private static final String CONFIG_PROP_SNAPSHOT_NORMALIZATION = "aether.artifactResolver.snapshotNormalization";
    private static final Logger LOGGER = org.slf4j.LoggerFactory.getLogger(DefaultArtifactResolver.class);
    private FileProcessor fileProcessor;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private VersionResolver versionResolver;
    private UpdateCheckManager updateCheckManager;
    private RepositoryConnectorProvider repositoryConnectorProvider;
    private RemoteRepositoryManager remoteRepositoryManager;
    private SyncContextFactory syncContextFactory;
    private OfflineController offlineController;

    public DefaultArtifactResolver() {
    }

    @Inject
    DefaultArtifactResolver(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, VersionResolver versionResolver, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController) {
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setVersionResolver(versionResolver);
        this.setUpdateCheckManager(updateCheckManager);
        this.setRepositoryConnectorProvider(repositoryConnectorProvider);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setSyncContextFactory(syncContextFactory);
        this.setOfflineController(offlineController);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setUpdateCheckManager(locator.getService(UpdateCheckManager.class));
        this.setRepositoryConnectorProvider(locator.getService(RepositoryConnectorProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setOfflineController(locator.getService(OfflineController.class));
    }

    @Deprecated
    public DefaultArtifactResolver setLoggerFactory(LoggerFactory loggerFactory) {
        return this;
    }

    public DefaultArtifactResolver setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor, "file processor cannot be null");
        return this;
    }

    public DefaultArtifactResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repository event dispatcher cannot be null");
        return this;
    }

    public DefaultArtifactResolver setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "version resolver cannot be null");
        return this;
    }

    public DefaultArtifactResolver setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        this.updateCheckManager = Objects.requireNonNull(updateCheckManager, "update check manager cannot be null");
        return this;
    }

    public DefaultArtifactResolver setRepositoryConnectorProvider(RepositoryConnectorProvider repositoryConnectorProvider) {
        this.repositoryConnectorProvider = Objects.requireNonNull(repositoryConnectorProvider, "repository connector provider cannot be null");
        return this;
    }

    public DefaultArtifactResolver setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    public DefaultArtifactResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public DefaultArtifactResolver setOfflineController(OfflineController offlineController) {
        this.offlineController = Objects.requireNonNull(offlineController, "offline controller cannot be null");
        return this;
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session2, ArtifactRequest request) throws ArtifactResolutionException {
        return this.resolveArtifacts(session2, Collections.singleton(request)).get(0);
    }

    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session2, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        try (SyncContext syncContext = this.syncContextFactory.newInstance(session2, false);){
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>(requests.size());
            for (ArtifactRequest artifactRequest : requests) {
                if (artifactRequest.getArtifact().getProperty("localPath", null) != null) continue;
                artifacts.add(artifactRequest.getArtifact());
            }
            syncContext.acquire(artifacts, null);
            List<ArtifactResult> list = this.resolve(session2, requests);
            return list;
        }
    }

    private List<ArtifactResult> resolve(RepositorySystemSession session2, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        ArrayList<ArtifactResult> results = new ArrayList<ArtifactResult>(requests.size());
        boolean failures = false;
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        WorkspaceReader workspace = session2.getWorkspaceReader();
        ArrayList<ResolutionGroup> groups = new ArrayList<ResolutionGroup>();
        for (ArtifactRequest artifactRequest : requests) {
            File file2;
            VersionResult versionResult;
            RequestTrace trace = RequestTrace.newChild(artifactRequest.getTrace(), artifactRequest);
            ArtifactResult result = new ArtifactResult(artifactRequest);
            results.add(result);
            Artifact artifact = artifactRequest.getArtifact();
            List<RemoteRepository> repos = artifactRequest.getRepositories();
            this.artifactResolving(session2, trace, artifact);
            String localPath = artifact.getProperty("localPath", null);
            if (localPath != null) {
                File file3 = new File(localPath);
                if (!file3.isFile()) {
                    failures = true;
                    result.addException(new ArtifactNotFoundException(artifact, null));
                    continue;
                }
                artifact = artifact.setFile(file3);
                result.setArtifact(artifact);
                this.artifactResolved(session2, trace, artifact, null, result.getExceptions());
                continue;
            }
            try {
                VersionRequest versionRequest = new VersionRequest(artifact, repos, artifactRequest.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session2, versionRequest);
            }
            catch (VersionResolutionException e2) {
                result.addException(e2);
                continue;
            }
            artifact = artifact.setVersion(versionResult.getVersion());
            if (versionResult.getRepository() != null) {
                repos = versionResult.getRepository() instanceof RemoteRepository ? Collections.singletonList((RemoteRepository)versionResult.getRepository()) : Collections.emptyList();
            }
            if (workspace != null && (file2 = workspace.findArtifact(artifact)) != null) {
                artifact = artifact.setFile(file2);
                result.setArtifact(artifact);
                result.setRepository(workspace.getRepository());
                this.artifactResolved(session2, trace, artifact, result.getRepository(), null);
                continue;
            }
            LocalArtifactResult local2 = lrm.find(session2, new LocalArtifactRequest(artifact, repos, artifactRequest.getRequestContext()));
            if (this.isLocallyInstalled(local2, versionResult)) {
                if (local2.getRepository() != null) {
                    result.setRepository(local2.getRepository());
                } else {
                    result.setRepository(lrm.getRepository());
                }
                try {
                    artifact = artifact.setFile(this.getFile(session2, artifact, local2.getFile()));
                    result.setArtifact(artifact);
                    this.artifactResolved(session2, trace, artifact, result.getRepository(), null);
                }
                catch (ArtifactTransferException e3) {
                    result.addException(e3);
                }
                if (local2.isAvailable()) continue;
                lrm.add(session2, new LocalArtifactRegistration(artifact));
                continue;
            }
            if (local2.getFile() != null) {
                LOGGER.debug("Verifying availability of {} from {}", (Object)local2.getFile(), (Object)repos);
            }
            LOGGER.debug("Resolving artifact {} from {}", (Object)artifact, (Object)repos);
            AtomicBoolean resolved = new AtomicBoolean(false);
            Iterator<Object> groupIt = groups.iterator();
            for (RemoteRepository repo : repos) {
                if (!repo.getPolicy(artifact.isSnapshot()).isEnabled()) continue;
                try {
                    Utils.checkOffline(session2, this.offlineController, repo);
                }
                catch (RepositoryOfflineException e4) {
                    ArtifactNotFoundException exception = new ArtifactNotFoundException(artifact, repo, "Cannot access " + repo.getId() + " (" + repo.getUrl() + ") in offline mode and the artifact " + artifact + " has not been downloaded from it before.", e4);
                    result.addException(exception);
                    continue;
                }
                ResolutionGroup group = null;
                while (groupIt.hasNext()) {
                    ResolutionGroup t = (ResolutionGroup)groupIt.next();
                    if (!t.matches(repo)) continue;
                    group = t;
                    break;
                }
                if (group == null) {
                    group = new ResolutionGroup(repo);
                    groups.add(group);
                    groupIt = Collections.emptyList().iterator();
                }
                group.items.add(new ResolutionItem(trace, artifact, resolved, result, local2, repo));
            }
        }
        for (ResolutionGroup resolutionGroup : groups) {
            this.performDownloads(session2, resolutionGroup);
        }
        for (ArtifactResult artifactResult : results) {
            ArtifactRequest request = artifactResult.getRequest();
            Artifact artifact = artifactResult.getArtifact();
            if (artifact != null && artifact.getFile() != null) continue;
            failures = true;
            if (artifactResult.getExceptions().isEmpty()) {
                ArtifactNotFoundException exception = new ArtifactNotFoundException(request.getArtifact(), null);
                artifactResult.addException(exception);
            }
            RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
            this.artifactResolved(session2, trace, request.getArtifact(), null, artifactResult.getExceptions());
        }
        if (failures) {
            throw new ArtifactResolutionException(results);
        }
        return results;
    }

    private boolean isLocallyInstalled(LocalArtifactResult lar, VersionResult vr) {
        if (lar.isAvailable()) {
            return true;
        }
        if (lar.getFile() != null) {
            if (vr.getRepository() instanceof LocalRepository) {
                return true;
            }
            if (vr.getRepository() == null && lar.getRequest().getRepositories().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private File getFile(RepositorySystemSession session2, Artifact artifact, File file2) throws ArtifactTransferException {
        if (artifact.isSnapshot() && !artifact.getVersion().equals(artifact.getBaseVersion()) && ConfigUtils.getBoolean(session2, true, CONFIG_PROP_SNAPSHOT_NORMALIZATION)) {
            boolean copy2;
            String name2 = file2.getName().replace(artifact.getVersion(), artifact.getBaseVersion());
            File dst = new File(file2.getParent(), name2);
            boolean bl = copy2 = dst.length() != file2.length() || dst.lastModified() != file2.lastModified();
            if (copy2) {
                try {
                    this.fileProcessor.copy(file2, dst);
                    dst.setLastModified(file2.lastModified());
                }
                catch (IOException e2) {
                    throw new ArtifactTransferException(artifact, null, e2);
                }
            }
            file2 = dst;
        }
        return file2;
    }

    private void performDownloads(RepositorySystemSession session2, ResolutionGroup group) {
        List<ArtifactDownload> downloads = this.gatherDownloads(session2, group);
        if (downloads.isEmpty()) {
            return;
        }
        for (ArtifactDownload download : downloads) {
            this.artifactDownloading(session2, download.getTrace(), download.getArtifact(), group.repository);
        }
        try {
            RemoteRepository repo = group.repository;
            if (repo.isBlocked()) {
                if (repo.getMirroredRepositories().isEmpty()) {
                    throw new NoRepositoryConnectorException(repo, "Blocked repository: " + repo);
                }
                throw new NoRepositoryConnectorException(repo, "Blocked mirror for repositories: " + repo.getMirroredRepositories());
            }
            try (RepositoryConnector connector = this.repositoryConnectorProvider.newRepositoryConnector(session2, group.repository);){
                connector.get(downloads, null);
            }
        }
        catch (NoRepositoryConnectorException e2) {
            for (ArtifactDownload download : downloads) {
                download.setException(new ArtifactTransferException(download.getArtifact(), group.repository, e2));
            }
        }
        this.evaluateDownloads(session2, group);
    }

    private List<ArtifactDownload> gatherDownloads(RepositorySystemSession session2, ResolutionGroup group) {
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        ArrayList<ArtifactDownload> downloads = new ArrayList<ArtifactDownload>();
        for (ResolutionItem item : group.items) {
            Artifact artifact = item.artifact;
            if (item.resolved.get()) continue;
            ArtifactDownload download = new ArtifactDownload();
            download.setArtifact(artifact);
            download.setRequestContext(item.request.getRequestContext());
            download.setListener(SafeTransferListener.wrap(session2));
            download.setTrace(item.trace);
            if (item.local.getFile() != null) {
                download.setFile(item.local.getFile());
                download.setExistenceCheck(true);
            } else {
                String path2 = lrm.getPathForRemoteArtifact(artifact, group.repository, item.request.getRequestContext());
                download.setFile(new File(lrm.getRepository().getBasedir(), path2));
            }
            boolean snapshot = artifact.isSnapshot();
            RepositoryPolicy policy = this.remoteRepositoryManager.getPolicy(session2, group.repository, !snapshot, snapshot);
            int errorPolicy = Utils.getPolicy(session2, artifact, group.repository);
            if ((errorPolicy & 3) != 0) {
                UpdateCheck<Artifact, ArtifactTransferException> check2 = new UpdateCheck<Artifact, ArtifactTransferException>();
                check2.setItem(artifact);
                check2.setFile(download.getFile());
                check2.setFileValid(false);
                check2.setRepository(group.repository);
                check2.setPolicy(policy.getUpdatePolicy());
                item.updateCheck = check2;
                this.updateCheckManager.checkArtifact(session2, check2);
                if (!check2.isRequired()) {
                    item.result.addException(check2.getException());
                    continue;
                }
            }
            download.setChecksumPolicy(policy.getChecksumPolicy());
            download.setRepositories(item.repository.getMirroredRepositories());
            downloads.add(download);
            item.download = download;
        }
        return downloads;
    }

    private void evaluateDownloads(RepositorySystemSession session2, ResolutionGroup group) {
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        for (ResolutionItem item : group.items) {
            ArtifactDownload download = item.download;
            if (download == null) continue;
            Artifact artifact = download.getArtifact();
            if (download.getException() == null) {
                item.resolved.set(true);
                item.result.setRepository(group.repository);
                try {
                    artifact = artifact.setFile(this.getFile(session2, artifact, download.getFile()));
                    item.result.setArtifact(artifact);
                    lrm.add(session2, new LocalArtifactRegistration(artifact, group.repository, download.getSupportedContexts()));
                }
                catch (ArtifactTransferException e2) {
                    download.setException(e2);
                    item.result.addException(e2);
                }
            } else {
                item.result.addException(download.getException());
            }
            if (item.updateCheck != null) {
                item.updateCheck.setException(download.getException());
                this.updateCheckManager.touchArtifact(session2, item.updateCheck);
            }
            this.artifactDownloaded(session2, download.getTrace(), artifact, group.repository, download.getException());
            if (download.getException() != null) continue;
            this.artifactResolved(session2, download.getTrace(), artifact, group.repository, null);
        }
    }

    private void artifactResolving(RepositorySystemSession session2, RequestTrace trace, Artifact artifact) {
        RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_RESOLVING);
        event2.setTrace(trace);
        event2.setArtifact(artifact);
        this.repositoryEventDispatcher.dispatch(event2.build());
    }

    private void artifactResolved(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, ArtifactRepository repository, List<Exception> exceptions) {
        RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_RESOLVED);
        event2.setTrace(trace);
        event2.setArtifact(artifact);
        event2.setRepository(repository);
        event2.setExceptions(exceptions);
        if (artifact != null) {
            event2.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch(event2.build());
    }

    private void artifactDownloading(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, RemoteRepository repository) {
        RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_DOWNLOADING);
        event2.setTrace(trace);
        event2.setArtifact(artifact);
        event2.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event2.build());
    }

    private void artifactDownloaded(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, RemoteRepository repository, Exception exception) {
        RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_DOWNLOADED);
        event2.setTrace(trace);
        event2.setArtifact(artifact);
        event2.setRepository(repository);
        event2.setException(exception);
        if (artifact != null) {
            event2.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch(event2.build());
    }

    static class ResolutionItem {
        final RequestTrace trace;
        final ArtifactRequest request;
        final ArtifactResult result;
        final LocalArtifactResult local;
        final RemoteRepository repository;
        final Artifact artifact;
        final AtomicBoolean resolved;
        ArtifactDownload download;
        UpdateCheck<Artifact, ArtifactTransferException> updateCheck;

        ResolutionItem(RequestTrace trace, Artifact artifact, AtomicBoolean resolved, ArtifactResult result, LocalArtifactResult local2, RemoteRepository repository) {
            this.trace = trace;
            this.artifact = artifact;
            this.resolved = resolved;
            this.result = result;
            this.request = result.getRequest();
            this.local = local2;
            this.repository = repository;
        }
    }

    static class ResolutionGroup {
        final RemoteRepository repository;
        final List<ResolutionItem> items = new ArrayList<ResolutionItem>();

        ResolutionGroup(RemoteRepository repository) {
            this.repository = repository;
        }

        boolean matches(RemoteRepository repo) {
            return this.repository.getUrl().equals(repo.getUrl()) && this.repository.getContentType().equals(repo.getContentType()) && this.repository.isRepositoryManager() == repo.isRepositoryManager();
        }
    }
}

