/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.repository;

import org.jetbrains.kotlin.org.apache.ivy.core.event.IvyEvent;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.Repository;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.Resource;

public class TransferEvent
extends IvyEvent {
    private Resource resource;
    private int eventType;
    private int requestType;
    private Exception exception;
    private Repository repository;
    private long length;
    private long totalLength;
    private boolean isTotalLengthSet = false;
    private long[] timeTracking = new long[5];

    public TransferEvent(Repository repository, Resource resource, int eventType, int requestType) {
        super(TransferEvent.getName(eventType));
        this.repository = repository;
        this.setResource(resource);
        this.setEventType(eventType);
        this.setRequestType(requestType);
    }

    private static String getName(int eventType) {
        switch (eventType) {
            case 0: {
                return "transfer-initiated";
            }
            case 1: {
                return "transfer-started";
            }
            case 3: {
                return "transfer-progress";
            }
            case 2: {
                return "transfer-completed";
            }
            case 4: {
                return "transfer-error";
            }
        }
        return null;
    }

    protected void setRequestType(int requestType) {
        switch (requestType) {
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal request type: " + requestType);
            }
        }
        this.requestType = requestType;
        this.addAttribute("request-type", requestType == 5 ? "get" : "put");
    }

    public int getEventType() {
        return this.eventType;
    }

    protected void setEventType(int eventType) {
        this.checkEventType(eventType);
        if (this.eventType != eventType) {
            this.eventType = eventType;
            this.timeTracking[eventType] = System.currentTimeMillis();
            if (eventType > 0) {
                this.addAttribute("total-duration", String.valueOf(this.getElapsedTime(0, eventType)));
                if (eventType > 1) {
                    this.addAttribute("duration", String.valueOf(this.getElapsedTime(1, eventType)));
                }
            }
        }
    }

    protected void setResource(Resource resource) {
        this.resource = resource;
        this.addAttribute("resource", this.resource.getName());
    }

    protected void setLength(long length) {
        this.length = length;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    protected void setTotalLength(long totalLength) {
        this.totalLength = totalLength;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isTotalLengthSet() {
        return this.isTotalLengthSet;
    }

    public void setTotalLengthSet(boolean isTotalLengthSet) {
        this.isTotalLengthSet = isTotalLengthSet;
    }

    public long getElapsedTime(int fromEventType, int toEventType) {
        this.checkEventType(fromEventType);
        this.checkEventType(toEventType);
        long start = this.timeTracking[fromEventType];
        long end = this.timeTracking[toEventType];
        if (start == 0L || end == 0L) {
            return -1L;
        }
        if (end < start) {
            return 0L;
        }
        return end - start;
    }

    private void checkEventType(int eventType) {
        if (eventType < 0 || eventType > 4) {
            throw new IllegalArgumentException("invalid event type " + eventType);
        }
    }
}

