/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.PerReplicaStatesOps;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMutator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected SolrZkClient zkClient;

    public NodeMutator(SolrCloudManager cloudManager) {
        this.zkClient = SliceMutator.getZkClient(cloudManager);
    }

    public List<ZkWriteCommand> downNode(ClusterState clusterState, ZkNodeProps message) {
        ArrayList<ZkWriteCommand> zkWriteCommands = new ArrayList<ZkWriteCommand>();
        String nodeName = message.getStr("node_name");
        log.debug("DownNode state invoked for node: {}", (Object)nodeName);
        Map collections = clusterState.getCollectionsMap();
        for (Map.Entry entry : collections.entrySet()) {
            ArrayList<String> downedReplicas = new ArrayList<String>();
            String collection = (String)entry.getKey();
            DocCollection docCollection = (DocCollection)entry.getValue();
            LinkedHashMap<String, Slice> slicesCopy = new LinkedHashMap<String, Slice>(docCollection.getSlicesMap());
            boolean needToUpdateCollection = false;
            for (Map.Entry sliceEntry : slicesCopy.entrySet()) {
                Slice slice = (Slice)sliceEntry.getValue();
                Map newReplicas = slice.getReplicasCopy();
                Collection replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    String rNodeName = replica.getNodeName();
                    if (rNodeName == null) {
                        throw new RuntimeException("Replica without node name! " + replica);
                    }
                    if (!rNodeName.equals(nodeName)) continue;
                    log.debug("Update replica state for {} to {}", (Object)replica, (Object)Replica.State.DOWN);
                    Map props = replica.shallowCopy();
                    props.put("state", Replica.State.DOWN.toString());
                    Replica newReplica = new Replica(replica.getName(), props, collection, slice.getName());
                    newReplicas.put(replica.getName(), newReplica);
                    needToUpdateCollection = true;
                    downedReplicas.add(replica.getName());
                }
                Slice newSlice = new Slice(slice.getName(), newReplicas, slice.shallowCopy(), collection);
                slicesCopy.put(slice.getName(), newSlice);
            }
            if (!needToUpdateCollection) continue;
            if (docCollection.isPerReplicaState()) {
                zkWriteCommands.add(new ZkWriteCommand(collection, docCollection.copyWithSlices(slicesCopy), PerReplicaStatesOps.downReplicas(downedReplicas, (PerReplicaStates)PerReplicaStates.fetch((String)docCollection.getZNode(), (SolrZkClient)this.zkClient, (PerReplicaStates)docCollection.getPerReplicaStates())), false));
                continue;
            }
            zkWriteCommands.add(new ZkWriteCommand(collection, docCollection.copyWithSlices(slicesCopy)));
        }
        return zkWriteCommands;
    }
}

