/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;

public class VariantODataFilterQuery
implements Variant {
    private static final Logger log = LogManager.getLogger(VariantODataFilterQuery.class);
    private static final Pattern patternFilterParameters = Pattern.compile("\\$filter[ ]*=[ ]*([\\w\\s()',./\\-:]*)");
    private static final Pattern patternParameters = Pattern.compile("([\\w]+)\\s+(eq|ne|gt|ge|lt|le|and|or|not)\\s+([\\w'/]+)");
    private String beforeFilterExpression = null;
    private String afterFilterExpression = null;
    private Map<String, OperationParameter> mapParameters = Collections.emptyMap();

    @Override
    public void setMessage(HttpMessage msg) {
        URI uri = msg.getRequestHeader().getURI();
        this.parse(uri);
    }

    private void parse(URI uri) {
        try {
            String query = uri.getQuery();
            if (query != null) {
                Matcher matcher = patternFilterParameters.matcher(query);
                if (matcher.find()) {
                    String filterExpression = "";
                    filterExpression = matcher.group(1);
                    int begin = query.indexOf(filterExpression);
                    int end = begin + filterExpression.length();
                    this.beforeFilterExpression = query.substring(0, begin);
                    this.afterFilterExpression = query.substring(end);
                    this.mapParameters = new HashMap<String, OperationParameter>();
                    Matcher matcherParameters = patternParameters.matcher(filterExpression);
                    while (matcherParameters.find()) {
                        String nameOpAndValue = matcherParameters.group(0);
                        String paramName = matcherParameters.group(1);
                        String operator = matcherParameters.group(2);
                        String paramValue = matcherParameters.group(3);
                        begin = filterExpression.indexOf(nameOpAndValue);
                        end = begin + nameOpAndValue.length();
                        String before = filterExpression.substring(0, begin);
                        String after = filterExpression.substring(end);
                        OperationParameter opParam = new OperationParameter(paramName, operator, paramValue, before, after);
                        this.mapParameters.put(opParam.getParameterName(), opParam);
                    }
                } else {
                    this.beforeFilterExpression = null;
                    this.afterFilterExpression = null;
                    this.mapParameters = Collections.emptyMap();
                }
            } else {
                this.beforeFilterExpression = null;
                this.afterFilterExpression = null;
                this.mapParameters = Collections.emptyMap();
            }
        }
        catch (URIException e) {
            log.error(e.getMessage() + uri, (Throwable)e);
        }
    }

    public Vector<NameValuePair> getParamList() {
        Vector<NameValuePair> out = new Vector<NameValuePair>(this.mapParameters.values().size());
        int i = 1;
        for (OperationParameter opParam : this.mapParameters.values()) {
            out.add(new NameValuePair(1, opParam.getParameterName(), opParam.getValue(), i++));
        }
        return out;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        OperationParameter opParam = this.mapParameters.get(param);
        if (opParam != null) {
            String newfilter = opParam.getModifiedFilter(value);
            String modifiedQuery = this.beforeFilterExpression + newfilter + this.afterFilterExpression;
            try {
                msg.getRequestHeader().getURI().setQuery(modifiedQuery);
            }
            catch (NullPointerException | URIException e) {
                log.error("Exception with the modified query " + modifiedQuery, e);
            }
            return newfilter;
        }
        return null;
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        return this.setParameter(msg, originalPair, param, value);
    }

    static class OperationParameter {
        private String paramName;
        private String operator;
        private String originalValue;
        private String stringBeforeOperation;
        private String stringAfterOperation;

        public OperationParameter(String name, String operator, String value, String stringBeforeOperation, String stringAfterOperation) {
            this.paramName = name;
            this.operator = operator;
            this.originalValue = value;
            this.stringBeforeOperation = stringBeforeOperation;
            this.stringAfterOperation = stringAfterOperation;
        }

        public String getValue() {
            return this.originalValue;
        }

        public String getParameterName() {
            return this.paramName;
        }

        public String getModifiedFilter(String newIdValue) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.stringBeforeOperation).append(this.paramName).append(' ').append(this.operator).append(' ').append(newIdValue).append(this.stringAfterOperation);
            return builder.toString();
        }
    }
}

