/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.dbinfo;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.ReferenceObject;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Schema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TextTable;
import org.hsqldb.TriggerDef;
import org.hsqldb.View;
import org.hsqldb.dbinfo.DITableInfo;
import org.hsqldb.dbinfo.DatabaseInformationMain;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LineGroupReader;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DirectoryBlockCachedObject;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.persist.TextCache;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.Right;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

final class DatabaseInformationFull
extends DatabaseInformationMain {
    static final String resourceFileName = "/org/hsqldb/resources/information-schema.sql";
    static final HashMappedList statementMap = LineGroupReader.getStatementMap("/org/hsqldb/resources/information-schema.sql");

    DatabaseInformationFull(Database database) {
        super(database);
    }

    @Override
    protected Table generateTable(Session session, PersistentStore persistentStore, int n) {
        switch (n) {
            case 15: {
                return this.SYSTEM_CACHEINFO(session, persistentStore);
            }
            case 16: {
                return this.SYSTEM_COLUMN_SEQUENCE_USAGE(session, persistentStore);
            }
            case 17: {
                return this.SYSTEM_COMMENTS(session, persistentStore);
            }
            case 19: {
                return this.SYSTEM_INDEXSTATS(session, persistentStore);
            }
            case 20: {
                return this.SYSTEM_KEY_INDEX_USAGE(session, persistentStore);
            }
            case 23: {
                return this.SYSTEM_SESSIONS(session, persistentStore);
            }
            case 22: {
                return this.SYSTEM_SESSIONINFO(session, persistentStore);
            }
            case 21: {
                return this.SYSTEM_PROPERTIES(session, persistentStore);
            }
            case 26: {
                return this.SYSTEM_SYNONYMS(session, persistentStore);
            }
            case 24: {
                return this.SYSTEM_TABLESTATS(session, persistentStore);
            }
            case 25: {
                return this.SYSTEM_TEXTTABLES(session, persistentStore);
            }
            case 27: {
                return this.ADMINISTRABLE_ROLE_AUTHORIZATIONS(session, persistentStore);
            }
            case 28: {
                return this.APPLICABLE_ROLES(session, persistentStore);
            }
            case 29: {
                return this.ASSERTIONS(session, persistentStore);
            }
            case 30: {
                return this.AUTHORIZATIONS(session, persistentStore);
            }
            case 31: {
                return this.CHARACTER_SETS(session, persistentStore);
            }
            case 32: {
                return this.CHECK_CONSTRAINT_ROUTINE_USAGE(session, persistentStore);
            }
            case 33: {
                return this.CHECK_CONSTRAINTS(session, persistentStore);
            }
            case 34: {
                return this.COLLATIONS(session, persistentStore);
            }
            case 35: {
                return this.COLUMN_COLUMN_USAGE(session, persistentStore);
            }
            case 36: {
                return this.COLUMN_DOMAIN_USAGE(session, persistentStore);
            }
            case 38: {
                return this.COLUMN_UDT_USAGE(session, persistentStore);
            }
            case 40: {
                return this.CONSTRAINT_COLUMN_USAGE(session, persistentStore);
            }
            case 41: {
                return this.CONSTRAINT_PERIOD_USAGE(session, persistentStore);
            }
            case 42: {
                return this.CONSTRAINT_TABLE_USAGE(session, persistentStore);
            }
            case 39: {
                return this.COLUMNS(session, persistentStore);
            }
            case 43: {
                return this.DATA_TYPE_PRIVILEGES(session, persistentStore);
            }
            case 44: {
                return this.DOMAIN_CONSTRAINTS(session, persistentStore);
            }
            case 45: {
                return this.DOMAINS(session, persistentStore);
            }
            case 46: {
                return this.ELEMENT_TYPES(session, persistentStore);
            }
            case 47: {
                return this.ENABLED_ROLES(session, persistentStore);
            }
            case 49: {
                return this.JAR_JAR_USAGE(session, persistentStore);
            }
            case 50: {
                return this.JARS(session, persistentStore);
            }
            case 51: {
                return this.KEY_COLUMN_USAGE(session, persistentStore);
            }
            case 52: {
                return this.KEY_PERIOD_USAGE(session, persistentStore);
            }
            case 53: {
                return this.METHOD_SPECIFICATIONS(session, persistentStore);
            }
            case 54: {
                return this.MODULE_COLUMN_USAGE(session, persistentStore);
            }
            case 55: {
                return this.MODULE_PRIVILEGES(session, persistentStore);
            }
            case 56: {
                return this.MODULE_TABLE_USAGE(session, persistentStore);
            }
            case 57: {
                return this.MODULES(session, persistentStore);
            }
            case 58: {
                return this.PARAMETERS(session, persistentStore);
            }
            case 59: {
                return this.PERIODS(session, persistentStore);
            }
            case 60: {
                return this.REFERENTIAL_CONSTRAINTS(session, persistentStore);
            }
            case 61: {
                return this.ROLE_AUTHORIZATION_DESCRIPTORS(session, persistentStore);
            }
            case 62: {
                return this.ROLE_COLUMN_GRANTS(session, persistentStore);
            }
            case 64: {
                return this.ROLE_ROUTINE_GRANTS(session, persistentStore);
            }
            case 65: {
                return this.ROLE_TABLE_GRANTS(session, persistentStore);
            }
            case 67: {
                return this.ROLE_USAGE_GRANTS(session, persistentStore);
            }
            case 66: {
                return this.ROLE_UDT_GRANTS(session, persistentStore);
            }
            case 68: {
                return this.ROUTINE_COLUMN_USAGE(session, persistentStore);
            }
            case 69: {
                return this.ROUTINE_JAR_USAGE(session, persistentStore);
            }
            case 70: {
                return this.ROUTINE_PERIOD_USAGE(session, persistentStore);
            }
            case 71: {
                return this.ROUTINE_PRIVILEGES(session, persistentStore);
            }
            case 72: {
                return this.ROUTINE_ROUTINE_USAGE(session, persistentStore);
            }
            case 73: {
                return this.ROUTINE_SEQUENCE_USAGE(session, persistentStore);
            }
            case 74: {
                return this.ROUTINE_TABLE_USAGE(session, persistentStore);
            }
            case 75: {
                return this.ROUTINES(session, persistentStore);
            }
            case 76: {
                return this.SCHEMATA(session, persistentStore);
            }
            case 77: {
                return this.SEQUENCES(session, persistentStore);
            }
            case 78: {
                return this.SQL_FEATURES(session, persistentStore);
            }
            case 79: {
                return this.SQL_IMPLEMENTATION_INFO(session, persistentStore);
            }
            case 80: {
                return this.SQL_PACKAGES(session, persistentStore);
            }
            case 81: {
                return this.SQL_PARTS(session, persistentStore);
            }
            case 82: {
                return this.SQL_SIZING(session, persistentStore);
            }
            case 83: {
                return this.SQL_SIZING_PROFILES(session, persistentStore);
            }
            case 84: {
                return this.TABLE_CONSTRAINTS(session, persistentStore);
            }
            case 86: {
                return this.TABLES(session, persistentStore);
            }
            case 87: {
                return this.TRANSLATIONS(session, persistentStore);
            }
            case 93: {
                return this.TRIGGERED_UPDATE_COLUMNS(session, persistentStore);
            }
            case 88: {
                return this.TRIGGER_COLUMN_USAGE(session, persistentStore);
            }
            case 89: {
                return this.TRIGGER_PERIOD_USAGE(session, persistentStore);
            }
            case 90: {
                return this.TRIGGER_ROUTINE_USAGE(session, persistentStore);
            }
            case 91: {
                return this.TRIGGER_SEQUENCE_USAGE(session, persistentStore);
            }
            case 92: {
                return this.TRIGGER_TABLE_USAGE(session, persistentStore);
            }
            case 94: {
                return this.TRIGGERS(session, persistentStore);
            }
            case 96: {
                return this.UDT_PRIVILEGES(session, persistentStore);
            }
            case 97: {
                return this.USAGE_PRIVILEGES(session, persistentStore);
            }
            case 98: {
                return this.USER_DEFINED_TYPES(session, persistentStore);
            }
            case 99: {
                return this.VIEW_COLUMN_USAGE(session, persistentStore);
            }
            case 100: {
                return this.VIEW_PERIOD_USAGE(session, persistentStore);
            }
            case 101: {
                return this.VIEW_ROUTINE_USAGE(session, persistentStore);
            }
            case 102: {
                return this.VIEW_TABLE_USAGE(session, persistentStore);
            }
            case 103: {
                return this.VIEWS(session, persistentStore);
            }
        }
        return super.generateTable(session, persistentStore, n);
    }

    Table SYSTEM_CACHEINFO(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[15];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[15]);
            this.addColumn(table, "CACHE_FILE", CHARACTER_DATA);
            this.addColumn(table, "MAX_CACHE_COUNT", CARDINAL_NUMBER);
            this.addColumn(table, "MAX_CACHE_BYTES", CARDINAL_NUMBER);
            this.addColumn(table, "CACHE_SIZE", CARDINAL_NUMBER);
            this.addColumn(table, "CACHE_BYTES", CARDINAL_NUMBER);
            this.addColumn(table, "FILE_LOST_BYTES", CARDINAL_NUMBER);
            this.addColumn(table, "FILE_FREE_POS", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[15].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, true);
            return table;
        }
        DataFileCache dataFileCache = null;
        if (!session.isAdmin()) {
            return table;
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.isText()) continue;
            dataFileCache = null;
            PersistentStore persistentStore2 = table2.getRowStore(session);
            if (persistentStore2 != null) {
                dataFileCache = persistentStore2.getCache();
            }
            if (dataFileCache == null) continue;
            hashSet.add(dataFileCache);
        }
        if (this.database.logger.hasCache()) {
            dataFileCache = this.database.logger.getCache();
            hashSet.add(dataFileCache);
        }
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            dataFileCache = (DataFileCache)iterator2.next();
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = FileUtil.getFileUtil().canonicalOrAbsolutePath(dataFileCache.getFileName());
            objectArray[1] = ValuePool.getLong(dataFileCache.capacity());
            objectArray[2] = ValuePool.getLong(dataFileCache.bytesCapacity());
            objectArray[3] = ValuePool.getLong(dataFileCache.getCachedObjectCount());
            objectArray[4] = ValuePool.getLong(dataFileCache.getTotalCachedBlockSize());
            objectArray[5] = ValuePool.getLong(dataFileCache.getLostBlockSize());
            objectArray[6] = ValuePool.getLong(dataFileCache.getFileFreePos());
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table SYSTEM_COLUMN_SEQUENCE_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[16];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[16]);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[16].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4}, false);
            return table;
        }
        Iterator iterator = this.allTables();
        while (iterator.hasNext()) {
            OrderedHashSet orderedHashSet;
            Table table2 = (Table)iterator.next();
            if (!table2.hasIdentityColumn() || (orderedHashSet = session.getGrantee().getColumnsForAllPrivileges(table2)).isEmpty()) continue;
            int n = table2.getColumnCount();
            for (int i = 0; i < n; ++i) {
                NumberSequence numberSequence;
                ColumnSchema columnSchema = table2.getColumn(i);
                if (!columnSchema.isIdentity() || (numberSequence = columnSchema.getIdentitySequence()).getName() == null || !orderedHashSet.contains(columnSchema.getName())) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = table2.getSchemaName().name;
                objectArray[2] = table2.getName().name;
                objectArray[3] = columnSchema.getName().name;
                objectArray[4] = this.database.getCatalogName().name;
                objectArray[5] = numberSequence.getSchemaName().name;
                objectArray[6] = numberSequence.getName().name;
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table SYSTEM_COMMENTS(Session session, PersistentStore persistentStore) {
        Object[] objectArray;
        SchemaObject schemaObject;
        Table table = this.sysTables[17];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[17]);
            this.addColumn(table, "OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_TYPE", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COMMENT", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[17].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4}, false);
            return table;
        }
        DITableInfo dITableInfo = new DITableInfo();
        Iterator iterator = this.allTables();
        while (iterator.hasNext()) {
            schemaObject = (Table)iterator.next();
            if (!session.getGrantee().isAccessible(schemaObject)) continue;
            dITableInfo.setTable((Table)schemaObject);
            int n = ((TableBase)((Object)schemaObject)).getColumnCount();
            for (int i = 0; i < n; ++i) {
                ColumnSchema columnSchema = ((Table)schemaObject).getColumn(i);
                if (columnSchema.getName().comment == null) continue;
                objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = ((Table)schemaObject).getSchemaName().name;
                objectArray[2] = ((Table)schemaObject).getName().name;
                objectArray[3] = "COLUMN";
                objectArray[4] = columnSchema.getName().name;
                objectArray[5] = columnSchema.getName().comment;
                table.insertSys(session, persistentStore, objectArray);
            }
            if (((TableBase)((Object)schemaObject)).getTableType() != 1 && ((Table)schemaObject).getName().comment == null) continue;
            objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = ((Table)schemaObject).getSchemaName().name;
            objectArray[2] = ((Table)schemaObject).getName().name;
            objectArray[3] = ((Table)schemaObject).isView() || ((TableBase)((Object)schemaObject)).getTableType() == 1 ? "VIEW" : "TABLE";
            objectArray[4] = null;
            objectArray[5] = dITableInfo.getRemark();
            table.insertSys(session, persistentStore, objectArray);
        }
        iterator = this.database.schemaManager.databaseObjectIterator(18);
        while (iterator.hasNext()) {
            schemaObject = (SchemaObject)iterator.next();
            if (!session.getGrantee().isAccessible(schemaObject) || schemaObject.getName().comment == null) continue;
            objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = schemaObject.getSchemaName().name;
            objectArray[2] = schemaObject.getName().name;
            objectArray[3] = "ROUTINE";
            objectArray[4] = null;
            objectArray[5] = schemaObject.getName().comment;
            table.insertSys(session, persistentStore, objectArray);
        }
        iterator = this.database.schemaManager.databaseObjectIterator(7);
        while (iterator.hasNext()) {
            schemaObject = (SchemaObject)iterator.next();
            if (!session.getGrantee().isAccessible(schemaObject) || schemaObject.getName().comment == null) continue;
            objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = schemaObject.getSchemaName().name;
            objectArray[2] = schemaObject.getName().name;
            objectArray[3] = "SEQUENCE";
            objectArray[4] = null;
            objectArray[5] = schemaObject.getName().comment;
            table.insertSys(session, persistentStore, objectArray);
        }
        iterator = this.database.schemaManager.databaseObjectIterator(7);
        while (iterator.hasNext()) {
            schemaObject = (SchemaObject)iterator.next();
            if (!session.getGrantee().isAccessible(schemaObject) || schemaObject.getName().comment == null) continue;
            objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = schemaObject.getSchemaName().name;
            objectArray[2] = schemaObject.getName().name;
            objectArray[3] = "TRIGGER";
            objectArray[4] = null;
            objectArray[5] = schemaObject.getName().comment;
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table SYSTEM_PROPERTIES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[21];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[21]);
            this.addColumn(table, "PROPERTY_SCOPE", CHARACTER_DATA);
            this.addColumn(table, "PROPERTY_NAMESPACE", CHARACTER_DATA);
            this.addColumn(table, "PROPERTY_NAME", CHARACTER_DATA);
            this.addColumn(table, "PROPERTY_VALUE", CHARACTER_DATA);
            this.addColumn(table, "PROPERTY_CLASS", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[21].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, true);
            return table;
        }
        String string = "SESSION";
        HsqlDatabaseProperties hsqlDatabaseProperties = this.database.getProperties();
        String string2 = "database.properties";
        Iterator iterator = hsqlDatabaseProperties.getUserDefinedPropertyData().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            Object[] objectArray2 = table.getEmptyRowData();
            objectArray2[0] = string;
            objectArray2[1] = string2;
            objectArray2[2] = objectArray[0];
            objectArray2[3] = this.database.logger.getValueStringForProperty((String)objectArray2[2]);
            if (objectArray2[3] == null) {
                objectArray2[3] = hsqlDatabaseProperties.getPropertyString((String)objectArray2[2]);
            }
            objectArray2[4] = objectArray[2];
            table.insertSys(session, persistentStore, objectArray2);
        }
        return table;
    }

    Table SYSTEM_SESSIONINFO(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[22];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[22]);
            this.addColumn(table, "KEY", CHARACTER_DATA);
            this.addColumn(table, "VALUE", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[22].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, true);
            return table;
        }
        Object[] objectArray = table.getEmptyRowData();
        objectArray[0] = "SESSION ID";
        objectArray[1] = String.valueOf(session.getId());
        table.insertSys(session, persistentStore, objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "AUTOCOMMIT";
        objectArray[1] = session.isAutoCommit() ? "TRUE" : "FALSE";
        table.insertSys(session, persistentStore, objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "USER";
        objectArray[1] = session.getUsername();
        table.insertSys(session, persistentStore, objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "ROLE";
        Grantee grantee = session.getRole();
        String string = grantee == null ? "" : grantee.getName().getNameString();
        objectArray[1] = string;
        table.insertSys(session, persistentStore, objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "RESULT MEMORY ROWS";
        int n = session.getResultMemoryRowCount();
        objectArray[1] = String.valueOf(n);
        table.insertSys(session, persistentStore, objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "SESSION READONLY";
        objectArray[1] = session.isReadOnlyDefault() ? "TRUE" : "FALSE";
        table.insertSys(session, persistentStore, objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "DATABASE READONLY";
        objectArray[1] = this.database.isReadOnly() ? "TRUE" : "FALSE";
        table.insertSys(session, persistentStore, objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "DATABASE";
        objectArray[1] = this.database.getURI();
        table.insertSys(session, persistentStore, objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "IDENTITY";
        objectArray[1] = String.valueOf(session.getLastIdentity());
        table.insertSys(session, persistentStore, objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "CURRENT SCHEMA";
        objectArray[1] = String.valueOf(session.getSchemaName(null));
        table.insertSys(session, persistentStore, objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "ISOLATION LEVEL";
        objectArray[1] = String.valueOf(session.getIsolation());
        table.insertSys(session, persistentStore, objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "IGNORECASE";
        objectArray[1] = session.isIgnorecase() ? "TRUE" : "FALSE";
        table.insertSys(session, persistentStore, objectArray);
        objectArray = table.getEmptyRowData();
        objectArray[0] = "CURRENT STATEMENT";
        objectArray[1] = "";
        Statement statement = session.sessionContext.currentStatement;
        if (statement != null) {
            objectArray[1] = statement.getSQL();
        }
        table.insertSys(session, persistentStore, objectArray);
        return table;
    }

    Table SYSTEM_SESSIONS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[23];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[23]);
            this.addColumn(table, "SESSION_ID", CARDINAL_NUMBER);
            this.addColumn(table, "CONNECTED", TIME_STAMP);
            this.addColumn(table, "USER_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "IS_ADMIN", Type.SQL_BOOLEAN);
            this.addColumn(table, "AUTOCOMMIT", Type.SQL_BOOLEAN);
            this.addColumn(table, "READONLY", Type.SQL_BOOLEAN);
            this.addColumn(table, "LAST_IDENTITY", CARDINAL_NUMBER);
            this.addColumn(table, "SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TRANSACTION", Type.SQL_BOOLEAN);
            this.addColumn(table, "TRANSACTION_SIZE", CARDINAL_NUMBER);
            this.addColumn(table, "WAITING_FOR_THIS", CHARACTER_DATA);
            this.addColumn(table, "THIS_WAITING_FOR", CHARACTER_DATA);
            this.addColumn(table, "CURRENT_STATEMENT", CHARACTER_DATA);
            this.addColumn(table, "LATCH_COUNT", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[23].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, true);
            return table;
        }
        Session[] sessionArray = this.database.sessionManager.getVisibleSessions(session);
        for (int i = 0; i < sessionArray.length; ++i) {
            int n;
            Object[] objectArray;
            Object object;
            if (sessionArray[i].isClosed()) continue;
            Session session2 = sessionArray[i];
            Object[] objectArray2 = table.getEmptyRowData();
            objectArray2[0] = ValuePool.getLong(session2.getId());
            objectArray2[1] = new TimestampData(session2.getConnectTime() / 1000L);
            objectArray2[2] = session2.getUsername();
            objectArray2[3] = session2.isAdmin() ? Boolean.TRUE : Boolean.FALSE;
            objectArray2[4] = session2.sessionContext.isAutoCommit;
            objectArray2[5] = session2.isReadOnlyDefault;
            Number number = session2.getLastIdentity();
            if (number != null) {
                objectArray2[6] = ValuePool.getLong(number.longValue());
            }
            objectArray2[8] = session2.isInMidTransaction() ? Boolean.TRUE : Boolean.FALSE;
            objectArray2[9] = ValuePool.getLong(session2.getTransactionSize());
            HsqlNameManager.HsqlName hsqlName = session2.getCurrentSchemaHsqlName();
            if (hsqlName != null) {
                objectArray2[7] = hsqlName.name;
            }
            objectArray2[10] = "";
            objectArray2[11] = "";
            if (session2.waitingSessions.size() > 0) {
                object = new StringBuilder();
                objectArray = new Session[session2.waitingSessions.size()];
                session2.waitingSessions.toArray(objectArray);
                for (n = 0; n < objectArray.length; ++n) {
                    if (n > 0) {
                        ((StringBuilder)object).append(',');
                    }
                    ((StringBuilder)object).append(((Session)objectArray[n]).getId());
                }
                objectArray2[10] = ((StringBuilder)object).toString();
            }
            if (session2.waitedSessions.size() > 0) {
                object = new StringBuilder();
                objectArray = new Session[session2.waitedSessions.size()];
                session2.waitedSessions.toArray(objectArray);
                for (n = 0; n < objectArray.length; ++n) {
                    if (n > 0) {
                        ((StringBuilder)object).append(',');
                    }
                    ((StringBuilder)object).append(((Session)objectArray[n]).getId());
                }
                objectArray2[11] = ((StringBuilder)object).toString();
            }
            objectArray2[12] = (object = session2.sessionContext.currentStatement) == null ? "" : ((Statement)object).getSQL();
            objectArray2[13] = (long)session2.latch.getCount();
            table.insertSys(session, persistentStore, objectArray2);
        }
        return table;
    }

    Table SYSTEM_SYNONYMS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[26];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[26]);
            this.addColumn(table, "SYNONYM_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SYNONYM_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SYNONYM_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_TYPE", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[26].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        if (!session.isAdmin()) {
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(29);
        while (iterator.hasNext()) {
            ReferenceObject referenceObject = (ReferenceObject)iterator.next();
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = referenceObject.getSchemaName().name;
            objectArray[2] = referenceObject.getName().name;
            objectArray[3] = this.database.getCatalogName().name;
            objectArray[4] = referenceObject.getTarget().schema.name;
            objectArray[5] = referenceObject.getTarget().name;
            switch (referenceObject.getTarget().type) {
                case 3: {
                    objectArray[6] = "TABLE";
                    break;
                }
                case 4: {
                    objectArray[6] = "VIEW";
                    break;
                }
                case 7: {
                    objectArray[6] = "SEQUENCE";
                    break;
                }
                case 18: {
                    objectArray[6] = "ROUTINE";
                    break;
                }
                case 16: {
                    objectArray[6] = "FUNCTION";
                    break;
                }
                case 17: {
                    objectArray[6] = "PROCEDURE";
                }
            }
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table SYSTEM_TEXTTABLES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[25];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[25]);
            this.addColumn(table, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DATA_SOURCE_DEFINTION", CHARACTER_DATA);
            this.addColumn(table, "FILE_PATH", CHARACTER_DATA);
            this.addColumn(table, "FILE_ENCODING", CHARACTER_DATA);
            this.addColumn(table, "FIELD_SEPARATOR", CHARACTER_DATA);
            this.addColumn(table, "VARCHAR_SEPARATOR", CHARACTER_DATA);
            this.addColumn(table, "LONGVARCHAR_SEPARATOR", CHARACTER_DATA);
            this.addColumn(table, "IS_IGNORE_FIRST", Type.SQL_BOOLEAN);
            this.addColumn(table, "IS_QUOTED", Type.SQL_BOOLEAN);
            this.addColumn(table, "IS_ALL_QUOTED", Type.SQL_BOOLEAN);
            this.addColumn(table, "IS_DESC", Type.SQL_BOOLEAN);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[25].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        if (!session.isAdmin()) {
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.isText()) continue;
            PersistentStore persistentStore2 = table2.getRowStore(session);
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = table2.getSchemaName().name;
            objectArray[2] = table2.getName().name;
            objectArray[3] = ((TextTable)table2).getDataSource();
            TextCache textCache = (TextCache)persistentStore2.getCache();
            if (textCache != null) {
                TextFileSettings textFileSettings = textCache.getTextFileSettings();
                objectArray[4] = FileUtil.getFileUtil().canonicalOrAbsolutePath(textCache.getFileName());
                objectArray[5] = textFileSettings.stringEncoding;
                objectArray[6] = textFileSettings.fs;
                objectArray[7] = textFileSettings.vs;
                objectArray[8] = textFileSettings.lvs;
                objectArray[9] = textFileSettings.isIgnoreFirst ? Boolean.TRUE : Boolean.FALSE;
                objectArray[10] = textFileSettings.isQuoted ? Boolean.TRUE : Boolean.FALSE;
                objectArray[11] = textFileSettings.isAllQuoted ? Boolean.TRUE : Boolean.FALSE;
                objectArray[12] = ((TextTable)table2).isDescDataSource() ? Boolean.TRUE : Boolean.FALSE;
            }
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table SYSTEM_TABLESTATS(Session session, PersistentStore persistentStore) {
        long l;
        long l2;
        Object[] objectArray;
        Object object;
        Table table = this.sysTables[24];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[24]);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_TYPE", SQL_IDENTIFIER);
            this.addColumn(table, "CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(table, "SPACE_ID", CARDINAL_NUMBER);
            this.addColumn(table, "USED_SPACE", CARDINAL_NUMBER);
            this.addColumn(table, "ALLOCATED_SPACE", CARDINAL_NUMBER);
            this.addColumn(table, "USED_MEMORY", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[24].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        if (!session.isAdmin()) {
            return table;
        }
        DataSpaceManager dataSpaceManager = null;
        DirectoryBlockCachedObject[] directoryBlockCachedObjectArray = new DirectoryBlockCachedObject[]{};
        int n = 0;
        int n2 = 0;
        boolean bl = this.database.logger.hasCache();
        if (bl) {
            object = this.database.logger.getCache();
            dataSpaceManager = ((DataFileCache)object).spaceManager;
            directoryBlockCachedObjectArray = ((DataFileCache)object).spaceManager.getDirectoryList();
            n = ((DataFileCache)object).getDataFileScale();
            n2 = dataSpaceManager.getFileBlockSize();
        }
        Iterator iterator = this.allTables();
        block3: while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = table2.getSchemaName().name;
            objectArray[2] = table2.getName().name;
            objectArray[3] = table2.getTableTypeString();
            switch (table2.getTableType()) {
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            object = table2.getRowStore(session);
            objectArray[4] = object.elementCount();
            if (table2.isCached()) {
                int n3 = table2.getSpaceID();
                objectArray[5] = (long)n3;
                objectArray[7] = null;
                objectArray[6] = null;
                objectArray[8] = null;
                if (bl && dataSpaceManager.isMultiSpace() && n3 != 7) {
                    l2 = 0L;
                    l = 0L;
                    for (int i = 0; i < directoryBlockCachedObjectArray.length; ++i) {
                        int[] nArray = directoryBlockCachedObjectArray[i].getTableIdArray();
                        char[] cArray = directoryBlockCachedObjectArray[i].getFreeSpaceArray();
                        for (int j = 0; j < nArray.length; ++j) {
                            if (nArray[j] != n3) continue;
                            l2 += (long)n2;
                            l += (long)(n2 - cArray[j] * n);
                        }
                    }
                    if (l2 > 0L) {
                        TableSpaceManager tableSpaceManager = object.getSpaceManager();
                        l -= tableSpaceManager.getLostBlocksSize();
                    }
                    objectArray[7] = l2;
                    objectArray[6] = l;
                }
            }
            table.insertSys(session, persistentStore, objectArray);
        }
        long l3 = 0L;
        l2 = 0L;
        l = 0L;
        long l4 = 0L;
        long l5 = 0L;
        for (int i = 0; i < directoryBlockCachedObjectArray.length; ++i) {
            int[] nArray = directoryBlockCachedObjectArray[i].getTableIdArray();
            char[] cArray = directoryBlockCachedObjectArray[i].getFreeSpaceArray();
            int[] nArray2 = directoryBlockCachedObjectArray[i].getBitmapAddressArray();
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] == 7) {
                    l3 += (long)n2;
                    l2 += (long)(n2 - cArray[j] * n);
                    continue;
                }
                if (nArray[j] == 0 && nArray2[j] != 0) {
                    l += (long)n2;
                    continue;
                }
                if (nArray[j] == 1) {
                    l4 += (long)n2;
                    continue;
                }
                if (nArray[j] != 6) continue;
                l5 += (long)n2;
            }
        }
        if (bl) {
            objectArray = table.getEmptyRowData();
            objectArray[2] = "UNUSED_SPACE";
            objectArray[7] = l;
            objectArray[6] = 0L;
            objectArray[5] = 0L;
            table.insertSys(session, persistentStore, objectArray);
            objectArray = table.getEmptyRowData();
            objectArray[2] = "COMMON_SPACE";
            objectArray[7] = l3;
            objectArray[6] = l2;
            objectArray[5] = 7L;
            table.insertSys(session, persistentStore, objectArray);
            objectArray = table.getEmptyRowData();
            objectArray[2] = "SYSTEM_SPACE";
            objectArray[7] = l4;
            objectArray[6] = l4;
            objectArray[5] = 1L;
            table.insertSys(session, persistentStore, objectArray);
            if (l5 != 0L) {
                objectArray = table.getEmptyRowData();
                objectArray[2] = "SET_ASIDE_SPACE";
                objectArray[7] = l5;
                objectArray[6] = l5;
                objectArray[5] = 1L;
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    final Table SYSTEM_INDEXSTATS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[19];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[19]);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_TYPE", SQL_IDENTIFIER);
            this.addColumn(table, "INDEX_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ORDINAL_POSITION", CARDINAL_NUMBER);
            this.addColumn(table, "CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(table, "ALLOCATED_ROWS", CARDINAL_NUMBER);
            this.addColumn(table, "USED_SPACE", CARDINAL_NUMBER);
            this.addColumn(table, "ALLOCATED_SPACE", CARDINAL_NUMBER);
            this.addColumn(table, "SPACE_ID", CARDINAL_NUMBER);
            this.addColumn(table, "BASE_SPACE", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[19].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 4}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !this.isAccessibleTable(session, table2)) continue;
            String string = table2.getCatalogName().name;
            String string2 = table2.getSchemaName().name;
            String string3 = table2.getName().name;
            String string4 = table2.getTableTypeString();
            int n = table2.getIndexCount();
            for (int i = 0; i < n; ++i) {
                Index index = table2.getIndex(i);
                String string5 = index.getName().name;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = string3;
                objectArray[3] = string4;
                objectArray[4] = string5;
                objectArray[5] = (long)(index.getPosition() + 1);
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    final Table SYSTEM_KEY_INDEX_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[20];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[20]);
            this.addColumn(table, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "INDEX_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "INDEX_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "INDEX_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[20].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5}, true);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !session.getGrantee().isAccessible(table2.getName())) continue;
            String string = table2.getCatalogName().name;
            String string2 = table2.getName().schema.name;
            Constraint[] constraintArray = table2.getConstraints();
            for (int i = 0; i < constraintArray.length; ++i) {
                Constraint constraint = constraintArray[i];
                boolean bl = false;
                int n = constraint.getConstraintType();
                int[] nArray = null;
                Index index = null;
                switch (n) {
                    case 2: 
                    case 4: {
                        nArray = constraint.getMainColumns();
                        index = constraint.getMainIndex();
                        bl = true;
                        break;
                    }
                    case 0: {
                        nArray = constraint.getRefColumns();
                        index = constraint.getRefIndex();
                        bl = true;
                    }
                }
                if (!bl || !session.getGrantee().hasColumnRights(table2, nArray)) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = constraint.getName().name;
                objectArray[3] = string;
                objectArray[4] = index.getName().schema.name;
                objectArray[5] = index.getName().name;
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table ADMINISTRABLE_ROLE_AUTHORIZATIONS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[27];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[27]);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "ROLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "IS_GRANTABLE", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[27].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        if (session.isAdmin()) {
            this.insertRoles(session, table, session.getGrantee(), true);
        }
        return table;
    }

    Table APPLICABLE_ROLES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[28];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[28]);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "ROLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "IS_GRANTABLE", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[28].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        this.insertRoles(session, table, session.getGrantee(), session.isAdmin());
        return table;
    }

    private void insertRoles(Session session, Table table, Grantee grantee, boolean bl) {
        PersistentStore persistentStore = table.getRowStore(session);
        if (bl) {
            Set set = this.database.getGranteeManager().getRoleNames();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = grantee.getName().getNameString();
                objectArray[1] = string;
                objectArray[2] = "YES";
                table.insertSys(session, persistentStore, objectArray);
            }
        } else {
            OrderedHashSet orderedHashSet = grantee.getDirectRoles();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                Grantee grantee2 = (Grantee)orderedHashSet.get(i);
                String string = grantee2.getName().getNameString();
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = grantee.getName().getNameString();
                objectArray[1] = string;
                objectArray[2] = "NO";
                table.insertSys(session, persistentStore, objectArray);
                grantee = this.database.getGranteeManager().getRole(string);
                this.insertRoles(session, table, grantee, bl);
            }
        }
    }

    Table ASSERTIONS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[29];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[29]);
            this.addColumn(table, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "IS_DEFERRABLE", YES_OR_NO);
            this.addColumn(table, "INITIALLY_DEFERRED", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[29].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        return table;
    }

    Table AUTHORIZATIONS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[30];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[30]);
            this.addColumn(table, "AUTHORIZATION_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "AUTHORIZATION_TYPE", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[30].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, true);
            return table;
        }
        Iterator iterator = session.getGrantee().visibleGrantees().iterator();
        while (iterator.hasNext()) {
            Grantee grantee = (Grantee)iterator.next();
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = grantee.getName().getNameString();
            objectArray[1] = grantee.isRole() ? "ROLE" : "USER";
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table CHARACTER_SETS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[31];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[31]);
            this.addColumn(table, "CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_REPERTOIRE", SQL_IDENTIFIER);
            this.addColumn(table, "FORM_OF_USE", SQL_IDENTIFIER);
            this.addColumn(table, "DEFAULT_COLLATE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "DEFAULT_COLLATE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "DEFAULT_COLLATE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[31].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(14);
        while (iterator.hasNext()) {
            Charset charset = (Charset)iterator.next();
            if (!session.getGrantee().isAccessible(charset)) continue;
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = charset.getSchemaName().name;
            objectArray[2] = charset.getName().name;
            objectArray[3] = "UCS";
            objectArray[4] = "UTF16";
            objectArray[5] = objectArray[0];
            if (charset.base == null) {
                objectArray[6] = objectArray[1];
                objectArray[7] = objectArray[2];
            } else {
                objectArray[6] = charset.base.schema.name;
                objectArray[7] = charset.base.name;
            }
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table CHECK_CONSTRAINT_ROUTINE_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[32];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[32]);
            this.addColumn(table, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[32].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(5);
        block4: while (iterator.hasNext()) {
            Constraint constraint;
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)iterator.next();
            if (hsqlName.parent == null) continue;
            switch (hsqlName.parent.type) {
                case 3: {
                    Cloneable cloneable = (Table)this.database.schemaManager.findSchemaObject(hsqlName.parent.name, hsqlName.parent.schema.name, 3);
                    if (cloneable != null && (constraint = ((Table)cloneable).getConstraint(hsqlName.name)).getConstraintType() == 3) break;
                    continue block4;
                }
                case 13: {
                    Cloneable cloneable = (Type)this.database.schemaManager.findSchemaObject(hsqlName.parent.name, hsqlName.parent.schema.name, 13);
                    if (cloneable == null) continue block4;
                    constraint = ((Type)cloneable).userTypeModifier.getConstraint(hsqlName.name);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            OrderedHashSet orderedHashSet = constraint.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName2.type != 24 || !session.getGrantee().isFullyAccessibleByRole(hsqlName2)) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = constraint.getSchemaName().name;
                objectArray[2] = constraint.getName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = hsqlName2.schema.name;
                objectArray[5] = hsqlName2.name;
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table CHECK_CONSTRAINTS(Session session, PersistentStore persistentStore) {
        Object[] objectArray;
        Table table = this.sysTables[33];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[33]);
            this.addColumn(table, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "CHECK_CLAUSE", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[33].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{2, 1, 0}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !session.getGrantee().isFullyAccessibleByRole(table2.getName())) continue;
            for (Constraint constraint : table2.getConstraints()) {
                if (constraint.getConstraintType() != 3) continue;
                objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = table2.getSchemaName().name;
                objectArray[2] = constraint.getName().name;
                try {
                    objectArray[3] = constraint.getCheckSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        Iterator iterator2 = this.database.schemaManager.databaseObjectIterator(13);
        while (iterator2.hasNext()) {
            Type type = (Type)iterator2.next();
            if (!type.isDomainType() || !session.getGrantee().isFullyAccessibleByRole(type.getName())) continue;
            for (Constraint constraint : type.userTypeModifier.getConstraints()) {
                objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = type.getSchemaName().name;
                objectArray[2] = constraint.getName().name;
                try {
                    objectArray[3] = constraint.getCheckSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table COLLATIONS(Session session, PersistentStore persistentStore) {
        String string;
        String string2;
        Object[] objectArray;
        Table table = this.sysTables[34];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[34]);
            this.addColumn(table, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PAD_ATTRIBUTE", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[34].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        String string3 = "PAD SPACE";
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(15);
        while (iterator.hasNext()) {
            objectArray = table.getEmptyRowData();
            Collation collation = (Collation)iterator.next();
            string2 = collation.getSchemaName().name;
            string = collation.getName().name;
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = string2;
            objectArray[2] = string;
            objectArray[3] = collation.isPadSpace() ? "PAD SPACE" : "NO PAD";
            table.insertSys(session, persistentStore, objectArray);
        }
        iterator = Collation.nameToJavaName.keySet().iterator();
        while (iterator.hasNext()) {
            objectArray = table.getEmptyRowData();
            string2 = "INFORMATION_SCHEMA";
            string = (String)iterator.next();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = string2;
            objectArray[2] = string;
            objectArray[3] = string3;
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table COLUMN_COLUMN_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[35];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[35]);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DEPENDENT_COLUMN", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[35].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !session.getGrantee().isFullyAccessibleByRole(table2.getName()) || !table2.hasGeneratedColumn()) continue;
            HsqlNameManager.HsqlName hsqlName = table2.getName();
            for (int i = 0; i < table2.getColumnCount(); ++i) {
                OrderedHashSet orderedHashSet;
                ColumnSchema columnSchema = table2.getColumn(i);
                if (!columnSchema.isGenerated() || (orderedHashSet = columnSchema.getGeneratedColumnReferences()) == null) continue;
                for (int j = 0; j < orderedHashSet.size(); ++j) {
                    Object[] objectArray = table.getEmptyRowData();
                    objectArray[0] = this.database.getCatalogName().name;
                    objectArray[1] = hsqlName.schema.name;
                    objectArray[2] = hsqlName.name;
                    objectArray[3] = ((HsqlNameManager.HsqlName)orderedHashSet.get((int)j)).name;
                    objectArray[4] = columnSchema.getName().name;
                    table.insertSys(session, persistentStore, objectArray);
                }
            }
        }
        return table;
    }

    Table COLUMN_DOMAIN_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[36];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[36]);
            this.addColumn(table, "DOMAIN_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "DOMAIN_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "DOMAIN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[36].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.allTables();
        Grantee grantee = session.getGrantee();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            int n = table2.getColumnCount();
            HsqlNameManager.HsqlName hsqlName = table2.getName();
            for (int i = 0; i < n; ++i) {
                ColumnSchema columnSchema = table2.getColumn(i);
                Type type = columnSchema.getDataType();
                if (!type.isDomainType() || !grantee.isFullyAccessibleByRole(type.getName())) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = type.getSchemaName().name;
                objectArray[2] = type.getName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = hsqlName.schema.name;
                objectArray[5] = hsqlName.name;
                objectArray[6] = columnSchema.getNameString();
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table COLUMN_UDT_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[38];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[38]);
            this.addColumn(table, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[38].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.allTables();
        Grantee grantee = session.getGrantee();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            int n = table2.getColumnCount();
            HsqlNameManager.HsqlName hsqlName = table2.getName();
            for (int i = 0; i < n; ++i) {
                ColumnSchema columnSchema = table2.getColumn(i);
                Type type = columnSchema.getDataType();
                if (!type.isDistinctType() || !grantee.isFullyAccessibleByRole(type.getName())) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = type.getSchemaName().name;
                objectArray[2] = type.getName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = hsqlName.schema.name;
                objectArray[5] = hsqlName.name;
                objectArray[6] = columnSchema.getNameString();
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table COLUMNS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[39];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[39]);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ORDINAL_POSITION", CARDINAL_NUMBER);
            this.addColumn(table, "COLUMN_DEFAULT", CHARACTER_DATA);
            this.addColumn(table, "IS_NULLABLE", YES_OR_NO);
            this.addColumn(table, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "CHARACTER_MAXIMUM_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(table, "INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_SET_CATALOG", CHARACTER_DATA);
            this.addColumn(table, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DOMAIN_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "DOMAIN_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "DOMAIN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "MAXIMUM_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(table, "DTD_IDENTIFIER", SQL_IDENTIFIER);
            this.addColumn(table, "IS_SELF_REFERENCING", YES_OR_NO);
            this.addColumn(table, "IS_IDENTITY", YES_OR_NO);
            this.addColumn(table, "IDENTITY_GENERATION", CHARACTER_DATA);
            this.addColumn(table, "IDENTITY_START", CHARACTER_DATA);
            this.addColumn(table, "IDENTITY_INCREMENT", CHARACTER_DATA);
            this.addColumn(table, "IDENTITY_MAXIMUM", CHARACTER_DATA);
            this.addColumn(table, "IDENTITY_MINIMUM", CHARACTER_DATA);
            this.addColumn(table, "IDENTITY_CYCLE", YES_OR_NO);
            this.addColumn(table, "IS_GENERATED", CHARACTER_DATA);
            this.addColumn(table, "GENERATION_EXPRESSION", CHARACTER_DATA);
            this.addColumn(table, "IS_SYSTEM_TIME_PERIOD_START", YES_OR_NO);
            this.addColumn(table, "IS_SYSTEM_TIME_PERIOD_END", YES_OR_NO);
            this.addColumn(table, "SYSTEM_TIME_PERIOD_TIMESTAMP_GENERATION", CHARACTER_DATA);
            this.addColumn(table, "IS_UPDATABLE", YES_OR_NO);
            this.addColumn(table, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[39].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{3, 2, 1, 4}, false);
            return table;
        }
        Iterator iterator = this.allTables();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            OrderedHashSet orderedHashSet = session.getGrantee().getColumnsForAllPrivileges(table2);
            if (orderedHashSet.isEmpty()) continue;
            int n = table2.getColumnCount();
            for (int i = 0; i < n; ++i) {
                ColumnSchema columnSchema = table2.getColumn(i);
                Type type = columnSchema.getDataType();
                if (!orderedHashSet.contains(columnSchema.getName())) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = table2.getSchemaName().name;
                objectArray[2] = table2.getName().name;
                objectArray[3] = columnSchema.getName().name;
                objectArray[4] = ValuePool.getLong(i + 1);
                objectArray[5] = columnSchema.getDefaultSQL();
                objectArray[6] = columnSchema.isNullable() ? "YES" : "NO";
                objectArray[7] = type.getFullNameString();
                if (type.isCharacterType()) {
                    objectArray[8] = ValuePool.getLong(type.precision);
                    objectArray[9] = ValuePool.getLong(type.precision * 2L);
                    objectArray[16] = this.database.getCatalogName().name;
                    objectArray[17] = type.getCharacterSet().getSchemaName().name;
                    objectArray[18] = type.getCharacterSet().getName().name;
                    objectArray[19] = this.database.getCatalogName().name;
                    objectArray[20] = type.getCollation().getSchemaName().name;
                    objectArray[21] = type.getCollation().getName().name;
                } else if (type.isNumberType()) {
                    objectArray[10] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                    objectArray[48] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                    if (type.isExactNumberType()) {
                        objectArray[12] = objectArray[49] = ValuePool.getLong(type.scale);
                    }
                    objectArray[11] = ValuePool.getLong(type.getPrecisionRadix());
                } else if (!type.isBooleanType()) {
                    if (type.isDateTimeType()) {
                        objectArray[13] = ValuePool.getLong(type.scale);
                    } else if (type.isIntervalType()) {
                        objectArray[7] = "INTERVAL";
                        objectArray[14] = IntervalType.getQualifier(type.typeCode);
                        objectArray[15] = ValuePool.getLong(type.precision);
                        objectArray[13] = ValuePool.getLong(type.scale);
                    } else if (type.isBinaryType()) {
                        objectArray[8] = ValuePool.getLong(type.precision);
                        objectArray[9] = ValuePool.getLong(type.precision);
                    } else if (type.isBitType()) {
                        objectArray[8] = ValuePool.getLong(type.precision);
                        objectArray[9] = ValuePool.getLong(type.precision);
                    } else if (type.isArrayType()) {
                        objectArray[31] = ValuePool.getLong(type.arrayLimitCardinality());
                        objectArray[7] = "ARRAY";
                    }
                }
                if (type.isDomainType()) {
                    objectArray[22] = this.database.getCatalogName().name;
                    objectArray[23] = type.getSchemaName().name;
                    objectArray[24] = type.getName().name;
                }
                if (type.isDistinctType()) {
                    objectArray[25] = this.database.getCatalogName().name;
                    objectArray[26] = type.getSchemaName().name;
                    objectArray[27] = type.getName().name;
                }
                objectArray[28] = null;
                objectArray[29] = null;
                objectArray[30] = null;
                objectArray[32] = type.getDefinition();
                objectArray[33] = null;
                Object object = objectArray[34] = columnSchema.isIdentity() ? "YES" : "NO";
                if (columnSchema.isIdentity()) {
                    NumberSequence numberSequence = columnSchema.getIdentitySequence();
                    objectArray[35] = numberSequence.isAlways() ? "ALWAYS" : "BY DEFAULT";
                    objectArray[36] = Long.toString(numberSequence.getStartValue());
                    objectArray[37] = Long.toString(numberSequence.getIncrement());
                    objectArray[38] = Long.toString(numberSequence.getMaxValue());
                    objectArray[39] = Long.toString(numberSequence.getMinValue());
                    Object object2 = objectArray[40] = numberSequence.isCycle() ? "YES" : "NO";
                }
                if (columnSchema.isGenerated()) {
                    objectArray[41] = "ALWAYS";
                    objectArray[42] = columnSchema.getGeneratingExpression().getSQL();
                } else {
                    objectArray[41] = "NEVER";
                }
                switch (columnSchema.getSystemPeriodType()) {
                    case 1: {
                        objectArray[43] = "YES";
                        objectArray[45] = "ALWAYS";
                        break;
                    }
                    case 2: {
                        objectArray[44] = "YES";
                        objectArray[45] = "ALWAYS";
                        break;
                    }
                    case 0: {
                        objectArray[43] = "NO";
                        objectArray[44] = "NO";
                    }
                }
                objectArray[46] = table2.isWritable() ? "YES" : "NO";
                objectArray[47] = objectArray[7];
                if (type.isNumberType()) {
                    objectArray[48] = objectArray[10];
                    objectArray[49] = objectArray[12];
                }
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table CONSTRAINT_COLUMN_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[40];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[40]);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[40].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !session.getGrantee().isFullyAccessibleByRole(table2.getName())) continue;
            Constraint[] constraintArray = table2.getConstraints();
            int n = constraintArray.length;
            String string = this.database.getCatalogName().name;
            String string2 = table2.getSchemaName().name;
            block9: for (int i = 0; i < n; ++i) {
                Constraint constraint = constraintArray[i];
                String string3 = constraint.getName().name;
                switch (constraint.getConstraintType()) {
                    case 3: {
                        Object[] objectArray;
                        Object object;
                        Object object2 = constraint.getCheckColumnExpressions();
                        if (object2 == null) continue block9;
                        Iterator iterator2 = ((HashSet)object2).iterator();
                        while (iterator2.hasNext()) {
                            object = (ExpressionColumn)iterator2.next();
                            HsqlNameManager.HsqlName hsqlName = ((ExpressionColumn)object).getColumn().getName();
                            if (hsqlName.type != 9) continue;
                            objectArray = table.getEmptyRowData();
                            objectArray[0] = this.database.getCatalogName().name;
                            objectArray[1] = hsqlName.schema.name;
                            objectArray[2] = hsqlName.parent.name;
                            objectArray[3] = hsqlName.name;
                            objectArray[4] = string;
                            objectArray[5] = string2;
                            objectArray[6] = string3;
                            try {
                                table.insertSys(session, persistentStore, objectArray);
                            }
                            catch (HsqlException hsqlException) {}
                        }
                        continue block9;
                    }
                    case 0: 
                    case 2: 
                    case 4: {
                        Object[] objectArray;
                        Object object2 = table2;
                        Object object = constraint.getMainColumns();
                        if (constraint.getConstraintType() == 0) {
                            object = constraint.getRefColumns();
                        }
                        for (int j = 0; j < ((int[])object).length; ++j) {
                            objectArray = table.getEmptyRowData();
                            objectArray[0] = this.database.getCatalogName().name;
                            objectArray[1] = string2;
                            objectArray[2] = ((Table)object2).getName().name;
                            objectArray[3] = ((Table)object2).getColumn((int)object[j]).getName().name;
                            objectArray[4] = string;
                            objectArray[5] = string2;
                            objectArray[6] = string3;
                            try {
                                table.insertSys(session, persistentStore, objectArray);
                                continue;
                            }
                            catch (HsqlException hsqlException) {
                                // empty catch block
                            }
                        }
                        continue block9;
                    }
                }
            }
        }
        return table;
    }

    Table CONSTRAINT_PERIOD_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[41];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[41]);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PERIOD_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[41].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !session.getGrantee().isFullyAccessibleByRole(table2.getName())) continue;
            Constraint[] constraintArray = table2.getConstraints();
            int n = constraintArray.length;
            String string = this.database.getCatalogName().name;
            String string2 = table2.getSchemaName().name;
            block4: for (int i = 0; i < n; ++i) {
                Constraint constraint = constraintArray[i];
                String string3 = constraint.getName().name;
                switch (constraint.getConstraintType()) {
                    case 3: {
                        continue block4;
                    }
                }
            }
        }
        return table;
    }

    Table CONSTRAINT_TABLE_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[42];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[42]);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[42].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Session session2 = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        Result result = session2.executeDirectStatement("select DISTINCT TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, CONSTRAINT_CATALOG, CONSTRAINT_SCHEMA, CONSTRAINT_NAME from INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE");
        table.insertSys(session, persistentStore, result);
        session2.close();
        return table;
    }

    Table DATA_TYPE_PRIVILEGES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[43];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[43]);
            this.addColumn(table, "OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_TYPE", SQL_IDENTIFIER);
            this.addColumn(table, "DTD_IDENTIFIER", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[43].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4}, false);
            return table;
        }
        Session session2 = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        String string = (String)statementMap.get("/*data_type_privileges*/");
        Result result = session2.executeDirectStatement(string);
        table.insertSys(session, persistentStore, result);
        session2.close();
        return table;
    }

    Table DOMAIN_CONSTRAINTS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[44];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[44]);
            this.addColumn(table, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DOMAIN_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "DOMAIN_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "DOMAIN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "IS_DEFERRABLE", YES_OR_NO);
            this.addColumn(table, "INITIALLY_DEFERRED", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[44].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(13);
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            if (!type.isDomainType() || !session.getGrantee().isFullyAccessibleByRole(type.getName())) continue;
            Constraint[] constraintArray = type.userTypeModifier.getConstraints();
            for (int i = 0; i < constraintArray.length; ++i) {
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = objectArray[3] = this.database.getCatalogName().name;
                objectArray[1] = objectArray[4] = type.getSchemaName().name;
                objectArray[2] = constraintArray[i].getName().name;
                objectArray[5] = type.getName().name;
                objectArray[6] = "NO";
                objectArray[7] = "NO";
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table DOMAINS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[45];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[45]);
            this.addColumn(table, "DOMAIN_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "DOMAIN_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "DOMAIN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DATA_TYPE", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_MAXIMUM_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(table, "INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "DOMAIN_DEFAULT", CHARACTER_DATA);
            this.addColumn(table, "MAXIMUM_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(table, "DTD_IDENTIFIER", SQL_IDENTIFIER);
            this.addColumn(table, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[45].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(13);
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            if (!type.isDomainType() || !session.getGrantee().isAccessible(type)) continue;
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = type.getSchemaName().name;
            objectArray[2] = type.getName().name;
            objectArray[3] = type.getFullNameString();
            if (type.isCharacterType()) {
                objectArray[4] = ValuePool.getLong(type.precision);
                objectArray[5] = ValuePool.getLong(type.precision * 2L);
                objectArray[6] = this.database.getCatalogName().name;
                objectArray[7] = type.getCharacterSet().getSchemaName().name;
                objectArray[8] = type.getCharacterSet().getName().name;
                objectArray[9] = this.database.getCatalogName().name;
                objectArray[10] = type.getCollation().getSchemaName().name;
                objectArray[11] = type.getCollation().getName().name;
            } else if (type.isNumberType()) {
                objectArray[12] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                objectArray[22] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                if (type.isExactNumberType()) {
                    objectArray[14] = objectArray[23] = ValuePool.getLong(type.scale);
                }
                objectArray[13] = ValuePool.getLong(type.getPrecisionRadix());
            } else if (!type.isBooleanType()) {
                if (type.isDateTimeType()) {
                    objectArray[15] = ValuePool.getLong(type.scale);
                } else if (type.isIntervalType()) {
                    objectArray[3] = "INTERVAL";
                    objectArray[16] = IntervalType.getQualifier(type.typeCode);
                    objectArray[17] = ValuePool.getLong(type.precision);
                    objectArray[15] = ValuePool.getLong(type.scale);
                } else if (type.isBinaryType()) {
                    objectArray[4] = ValuePool.getLong(type.precision);
                    objectArray[5] = ValuePool.getLong(type.precision);
                } else if (type.isBitType()) {
                    objectArray[4] = ValuePool.getLong(type.precision);
                    objectArray[5] = ValuePool.getLong(type.precision);
                } else if (type.isArrayType()) {
                    objectArray[19] = ValuePool.getLong(type.arrayLimitCardinality());
                    objectArray[3] = "ARRAY";
                }
            }
            objectArray[20] = type.getDefinition();
            objectArray[21] = objectArray[3];
            Expression expression = type.userTypeModifier.getDefaultClause();
            if (expression != null) {
                objectArray[18] = expression.getSQL();
            }
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table ELEMENT_TYPES(Session session, PersistentStore persistentStore) {
        Object[] objectArray;
        Type type;
        SchemaObject schemaObject;
        Table table = this.sysTables[46];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[46]);
            this.addColumn(table, "OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_TYPE", SQL_IDENTIFIER);
            this.addColumn(table, "COLLECTION_TYPE_IDENTIFIER", SQL_IDENTIFIER);
            this.addColumn(table, "DATA_TYPE", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_MAXIMUM_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(table, "INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "MAXIMUM_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(table, "DTD_IDENTIFIER", SQL_IDENTIFIER);
            this.addColumn(table, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[46].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 4, 5, 27}, true);
            return table;
        }
        Iterator iterator = this.allTables();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            OrderedHashSet orderedHashSet = session.getGrantee().getColumnsForAllPrivileges(table2);
            if (orderedHashSet.isEmpty()) continue;
            int n = table2.getColumnCount();
            for (int i = 0; i < n; ++i) {
                schemaObject = table2.getColumn(i);
                if (!orderedHashSet.contains(((ColumnSchema)schemaObject).getName()) || (type = ((ColumnBase)((Object)schemaObject)).getDataType()).isDistinctType() || type.isDomainType() || !type.isArrayType()) continue;
                objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = table2.getSchemaName().name;
                objectArray[2] = table2.getName().name;
                objectArray[3] = "TABLE";
                objectArray[4] = type.getDefinition();
                this.addTypeInfo(objectArray, type.collectionBaseType());
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        Iterator iterator2 = this.database.schemaManager.databaseObjectIterator(13);
        while (iterator2.hasNext()) {
            type = (Type)iterator2.next();
            if (!type.isDomainType() || !type.isArrayType() || !session.getGrantee().isAccessible(type)) continue;
            objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = type.getSchemaName().name;
            objectArray[2] = type.getName().name;
            objectArray[3] = "DOMAIN";
            objectArray[4] = type.getDefinition();
            this.addTypeInfo(objectArray, type.collectionBaseType());
            table.insertSys(session, persistentStore, objectArray);
        }
        iterator2 = this.database.schemaManager.databaseObjectIterator(12);
        while (iterator2.hasNext()) {
            type = (Type)iterator2.next();
            if (!type.isDistinctType() || !type.isArrayType() || !session.getGrantee().isAccessible(type)) continue;
            objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = type.getSchemaName().name;
            objectArray[2] = type.getName().name;
            objectArray[3] = "USER-DEFINED TYPE";
            objectArray[4] = type.getDefinition();
            this.addTypeInfo(objectArray, type.collectionBaseType());
            try {
                table.insertSys(session, persistentStore, objectArray);
            }
            catch (HsqlException hsqlException) {}
        }
        iterator2 = this.database.schemaManager.databaseObjectIterator(24);
        while (iterator2.hasNext()) {
            schemaObject = (Routine)iterator2.next();
            if (!session.getGrantee().isAccessible(schemaObject)) continue;
            Type type2 = type = ((Routine)schemaObject).isProcedure() ? null : ((Routine)schemaObject).getReturnType();
            if (type != null && !type.isDistinctType() && !type.isDomainType() && type.isArrayType()) {
                objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = ((Routine)schemaObject).getSchemaName().name;
                objectArray[2] = ((Routine)schemaObject).getName().name;
                objectArray[3] = "ROUTINE";
                objectArray[4] = type.getDefinition();
                this.addTypeInfo(objectArray, type.collectionBaseType());
                try {
                    table.insertSys(session, persistentStore, objectArray);
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
            Type type3 = type;
            int n = ((Routine)schemaObject).getParameterCount();
            for (int i = 0; i < n; ++i) {
                ColumnSchema columnSchema = ((Routine)schemaObject).getParameter(i);
                type = columnSchema.getDataType();
                if (type.isDistinctType() || type.isDomainType() || !type.isArrayType() || type.equals(type3)) continue;
                objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = ((Routine)schemaObject).getSchemaName().name;
                objectArray[2] = ((Routine)schemaObject).getName().name;
                objectArray[3] = "ROUTINE";
                objectArray[4] = type.getDefinition();
                this.addTypeInfo(objectArray, type.collectionBaseType());
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    void addTypeInfo(Object[] objectArray, Type type) {
        objectArray[5] = type.getFullNameString();
        if (type.isCharacterType()) {
            objectArray[6] = ValuePool.getLong(type.precision);
            objectArray[7] = ValuePool.getLong(type.precision * 2L);
            objectArray[8] = this.database.getCatalogName().name;
            objectArray[9] = type.getCharacterSet().getSchemaName().name;
            objectArray[10] = type.getCharacterSet().getName().name;
            objectArray[11] = this.database.getCatalogName().name;
            objectArray[12] = type.getCollation().getSchemaName().name;
            objectArray[13] = type.getCollation().getName().name;
        } else if (type.isNumberType()) {
            objectArray[14] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
            objectArray[29] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
            if (type.isExactNumberType()) {
                objectArray[16] = objectArray[30] = ValuePool.getLong(type.scale);
            }
            objectArray[15] = ValuePool.getLong(type.getPrecisionRadix());
        } else if (!type.isBooleanType()) {
            if (type.isDateTimeType()) {
                objectArray[17] = ValuePool.getLong(type.scale);
            } else if (type.isIntervalType()) {
                objectArray[5] = "INTERVAL";
                objectArray[18] = IntervalType.getQualifier(type.typeCode);
                objectArray[19] = ValuePool.getLong(type.precision);
                objectArray[17] = ValuePool.getLong(type.scale);
            } else if (type.isBinaryType()) {
                objectArray[6] = ValuePool.getLong(type.precision);
                objectArray[7] = ValuePool.getLong(type.precision);
            } else if (type.isBitType()) {
                objectArray[6] = ValuePool.getLong(type.precision);
                objectArray[7] = ValuePool.getLong(type.precision);
            } else if (type.isArrayType()) {
                objectArray[26] = ValuePool.getLong(type.arrayLimitCardinality());
            }
        }
        objectArray[27] = type.getDefinition();
        objectArray[28] = objectArray[5];
    }

    Table ENABLED_ROLES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[47];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[47]);
            this.addColumn(table, "ROLE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[47].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, true);
            return table;
        }
        Iterator iterator = session.getGrantee().getAllRoles().iterator();
        while (iterator.hasNext()) {
            Grantee grantee = (Grantee)iterator.next();
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = grantee.getName().getNameString();
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table JAR_JAR_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[49];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[49]);
            this.addColumn(table, "PATH_JAR_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "PATH_JAR_SCHAMA", SQL_IDENTIFIER);
            this.addColumn(table, "PATH_JAR_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "JAR_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "JAR_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "JAR_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[49].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        return table;
    }

    Table JARS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[50];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[50]);
            this.addColumn(table, "JAR_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "JAR_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "JAR_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "JAR_PATH", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[50].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3}, false);
            return table;
        }
        return table;
    }

    Table KEY_COLUMN_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[51];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[51]);
            this.addColumn(table, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ORDINAL_POSITION", CARDINAL_NUMBER);
            this.addColumn(table, "POSITION_IN_UNIQUE_CONSTRAINT", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[51].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{2, 1, 0, 6, 7}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            String string = this.database.getCatalogName().name;
            HsqlNameManager.HsqlName hsqlName = table2.getName();
            if (table2.isView() || !session.getGrantee().isAccessible(hsqlName)) continue;
            Constraint[] constraintArray = table2.getConstraints();
            for (int i = 0; i < constraintArray.length; ++i) {
                Constraint constraint = constraintArray[i];
                if (constraint.getConstraintType() != 4 && constraint.getConstraintType() != 2 && constraint.getConstraintType() != 0) continue;
                String string2 = constraint.getName().name;
                int[] nArray = constraint.getMainColumns();
                int[] nArray2 = null;
                if (constraint.getConstraintType() == 0) {
                    Table table3 = constraint.getMain();
                    Constraint constraint2 = table3.getConstraint(constraint.getUniqueName().name);
                    int[] nArray3 = constraint2.getMainColumns();
                    nArray2 = new int[nArray.length];
                    for (int j = 0; j < nArray.length; ++j) {
                        nArray2[j] = ArrayUtil.find(nArray3, nArray[j]);
                    }
                    nArray = constraint.getRefColumns();
                }
                if (!session.getGrantee().hasColumnRights(table2, nArray)) continue;
                for (int j = 0; j < nArray.length; ++j) {
                    Object[] objectArray = table.getEmptyRowData();
                    objectArray[0] = string;
                    objectArray[1] = hsqlName.schema.name;
                    objectArray[2] = string2;
                    objectArray[3] = string;
                    objectArray[4] = hsqlName.schema.name;
                    objectArray[5] = hsqlName.name;
                    objectArray[6] = table2.getColumn((int)nArray[j]).getName().name;
                    objectArray[7] = ValuePool.getLong(j + 1);
                    if (constraint.getConstraintType() == 0) {
                        objectArray[8] = ValuePool.getInt(nArray2[j] + 1);
                    }
                    table.insertSys(session, persistentStore, objectArray);
                }
            }
        }
        return table;
    }

    Table KEY_PERIOD_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[52];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[52]);
            this.addColumn(table, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PERIOD_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[52].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{2, 1, 0, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            String string = this.database.getCatalogName().name;
            HsqlNameManager.HsqlName hsqlName = table2.getName();
            if (table2.isView() || !session.getGrantee().isAccessible(hsqlName)) continue;
            Constraint[] constraintArray = table2.getConstraints();
            for (int i = 0; i < constraintArray.length; ++i) {
                Constraint constraint = constraintArray[i];
                switch (constraint.getConstraintType()) {
                    default: 
                }
            }
        }
        return table;
    }

    Table METHOD_SPECIFICATION_PARAMETERS(Session session, PersistentStore persistentStore) {
        return null;
    }

    Table METHOD_SPECIFICATIONS(Session session, PersistentStore persistentStore) {
        return null;
    }

    Table MODULE_COLUMN_USAGE(Session session, PersistentStore persistentStore) {
        return null;
    }

    Table MODULE_PRIVILEGES(Session session, PersistentStore persistentStore) {
        return null;
    }

    Table MODULE_TABLE_USAGE(Session session, PersistentStore persistentStore) {
        return null;
    }

    Table MODULES(Session session, PersistentStore persistentStore) {
        return null;
    }

    Table PARAMETERS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[58];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[58]);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ORDINAL_POSITION", CARDINAL_NUMBER);
            this.addColumn(table, "PARAMETER_MODE", CHARACTER_DATA);
            this.addColumn(table, "IS_RESULT", YES_OR_NO);
            this.addColumn(table, "AS_LOCATOR", YES_OR_NO);
            this.addColumn(table, "PARAMETER_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "FROM_SQL_SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "FROM_SQL_SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "FROM_SQL_SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TO_SQL_SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TO_SQL_SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TO_SQL_SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "CHARACTER_MAXIMUM_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_SET_CATALOG", CHARACTER_DATA);
            this.addColumn(table, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(table, "INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "MAXIMUM_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(table, "DTD_IDENTIFIER", SQL_IDENTIFIER);
            this.addColumn(table, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[58].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(18);
        while (iterator.hasNext()) {
            RoutineSchema routineSchema = (RoutineSchema)iterator.next();
            if (!session.getGrantee().isAccessible(routineSchema)) continue;
            Routine[] routineArray = routineSchema.getSpecificRoutines();
            for (int i = 0; i < routineArray.length; ++i) {
                Routine routine = routineArray[i];
                int n = routine.getParameterCount();
                for (int j = 0; j < n; ++j) {
                    ColumnSchema columnSchema = routine.getParameter(j);
                    Type type = columnSchema.getDataType();
                    Object[] objectArray = table.getEmptyRowData();
                    objectArray[0] = this.database.getCatalogName().name;
                    objectArray[1] = routine.getSchemaName().name;
                    objectArray[2] = routine.getSpecificName().name;
                    objectArray[7] = columnSchema.getName().name;
                    objectArray[3] = ValuePool.getLong(j + 1);
                    switch (columnSchema.getParameterMode()) {
                        case 1: {
                            objectArray[4] = "IN";
                            break;
                        }
                        case 4: {
                            objectArray[4] = "OUT";
                            break;
                        }
                        case 2: {
                            objectArray[4] = "INOUT";
                        }
                    }
                    objectArray[5] = "NO";
                    objectArray[6] = "NO";
                    objectArray[14] = type.getFullNameString();
                    if (type.isCharacterType()) {
                        objectArray[15] = ValuePool.getLong(type.precision);
                        objectArray[16] = ValuePool.getLong(type.precision * 2L);
                        objectArray[17] = this.database.getCatalogName().name;
                        objectArray[18] = type.getCharacterSet().getSchemaName().name;
                        objectArray[19] = type.getCharacterSet().getName().name;
                        objectArray[20] = this.database.getCatalogName().name;
                        objectArray[21] = type.getCollation().getSchemaName().name;
                        objectArray[22] = type.getCollation().getName().name;
                    } else if (type.isNumberType()) {
                        objectArray[23] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                        objectArray[24] = ValuePool.getLong(type.getPrecisionRadix());
                    } else if (!type.isBooleanType()) {
                        if (type.isDateTimeType()) {
                            objectArray[26] = ValuePool.getLong(type.scale);
                        } else if (type.isIntervalType()) {
                            objectArray[14] = "INTERVAL";
                            objectArray[27] = IntervalType.getQualifier(type.typeCode);
                            objectArray[28] = ValuePool.getLong(type.precision);
                            objectArray[26] = ValuePool.getLong(type.scale);
                        } else if (type.isBinaryType()) {
                            objectArray[15] = ValuePool.getLong(type.precision);
                            objectArray[16] = ValuePool.getLong(type.precision);
                        } else if (type.isBitType()) {
                            objectArray[15] = ValuePool.getLong(type.precision);
                            objectArray[16] = ValuePool.getLong(type.precision);
                        } else if (type.isArrayType()) {
                            objectArray[35] = ValuePool.getLong(type.arrayLimitCardinality());
                            objectArray[14] = "ARRAY";
                        }
                    }
                    if (type.isDistinctType()) {
                        objectArray[29] = this.database.getCatalogName().name;
                        objectArray[30] = type.getSchemaName().name;
                        objectArray[31] = type.getName().name;
                    }
                    objectArray[36] = type.getDefinition();
                    table.insertSys(session, persistentStore, objectArray);
                }
            }
        }
        return table;
    }

    Table PERIODS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[59];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[59]);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PERIOD_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "START_COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "END_COLUMN_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[59].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !this.isAccessibleTable(session, table2)) continue;
            PeriodDefinition periodDefinition = table2.getSystemPeriod();
            PeriodDefinition periodDefinition2 = table2.getApplicationPeriod();
            if (periodDefinition == null && periodDefinition2 == null) continue;
            HsqlNameManager.HsqlName hsqlName = table2.getName();
            for (int i = 0; i < 2; ++i) {
                PeriodDefinition periodDefinition3;
                PeriodDefinition periodDefinition4 = periodDefinition3 = i == 0 ? periodDefinition : periodDefinition2;
                if (periodDefinition3 == null) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = hsqlName.schema.name;
                objectArray[2] = hsqlName.name;
                objectArray[3] = periodDefinition3.getName().name;
                if (session.getGrantee().isFullyAccessibleByRole(hsqlName)) {
                    objectArray[4] = periodDefinition3.getStartColumn().getNameString();
                    objectArray[5] = periodDefinition3.getEndColumn().getNameString();
                }
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table REFERENTIAL_CONSTRAINTS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[60];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[60]);
            this.addColumn(table, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "UNIQUE_CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "UNIQUE_CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "UNIQUE_CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "MATCH_OPTION", CHARACTER_DATA);
            this.addColumn(table, "UPDATE_RULE", CHARACTER_DATA);
            this.addColumn(table, "DELETE_RULE", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[60].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !session.getGrantee().hasNonSelectTableRight(table2)) continue;
            Constraint[] constraintArray = table2.getConstraints();
            for (int i = 0; i < constraintArray.length; ++i) {
                Constraint constraint = constraintArray[i];
                if (constraint.getConstraintType() != 0) continue;
                HsqlNameManager.HsqlName hsqlName = constraint.getUniqueName();
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = constraint.getSchemaName().name;
                objectArray[2] = constraint.getName().name;
                if (this.isAccessibleTable(session, constraint.getMain())) {
                    objectArray[3] = this.database.getCatalogName().name;
                    objectArray[4] = hsqlName.schema.name;
                    objectArray[5] = hsqlName.name;
                }
                objectArray[6] = "NONE";
                objectArray[7] = constraint.getUpdateActionString();
                objectArray[8] = constraint.getDeleteActionString();
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table ROLE_COLUMN_GRANTS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[62];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[62]);
            this.addColumn(table, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[62].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{5, 6, 1, 0, 4, 3, 2}, false);
            return table;
        }
        Session session2 = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        Result result = session2.executeDirectStatement("SELECT C.GRANTOR, C.GRANTEE, C.TABLE_CATALOG, C.TABLE_SCHEMA, C.TABLE_NAME, C.COLUMN_NAME, C.PRIVILEGE_TYPE, C.IS_GRANTABLE FROM INFORMATION_SCHEMA.COLUMN_PRIVILEGES C JOIN INFORMATION_SCHEMA.APPLICABLE_ROLES ON C.GRANTEE = ROLE_NAME;");
        table.insertSys(session, persistentStore, result);
        session2.close();
        return table;
    }

    Table ROLE_ROUTINE_GRANTS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[64];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[64]);
            this.addColumn(table, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[64].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, false);
            return table;
        }
        Session session2 = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        Result result = session2.executeDirectStatement("SELECT R.GRANTOR, R.GRANTEE, R.SPECIFIC_CATALOG, R.SPECIFIC_SCHEMA, R.SPECIFIC_NAME, R.ROUTINE_CATALOG, R.ROUTINE_SCHEMA, R.ROUTINE_NAME, R.PRIVILEGE_TYPE, R.IS_GRANTABLE FROM INFORMATION_SCHEMA.ROUTINE_PRIVILEGES R JOIN INFORMATION_SCHEMA.APPLICABLE_ROLES ON R.GRANTEE = ROLE_NAME;");
        table.insertSys(session, persistentStore, result);
        session2.close();
        return table;
    }

    Table ROLE_TABLE_GRANTS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[65];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[65]);
            this.addColumn(table, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "IS_GRANTABLE", YES_OR_NO);
            this.addColumn(table, "WITH_HIERARCHY", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[65].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{3, 4, 5, 0, 1}, false);
            return table;
        }
        Session session2 = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        Result result = session2.executeDirectStatement("SELECT T.GRANTOR, T.GRANTEE, T.TABLE_CATALOG, T.TABLE_SCHEMA, T.TABLE_NAME, T.PRIVILEGE_TYPE, T.IS_GRANTABLE, 'NO' FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES T JOIN INFORMATION_SCHEMA.APPLICABLE_ROLES ON T.GRANTEE = ROLE_NAME;");
        table.insertSys(session, persistentStore, result);
        session2.close();
        return table;
    }

    Table ROLE_UDT_GRANTS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[66];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[66]);
            this.addColumn(table, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[66].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, null, false);
            return table;
        }
        Session session2 = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        Result result = session2.executeDirectStatement("SELECT U.GRANTOR, U.GRANTEE, U.UDT_CATALOG, U.UDT_SCHEMA, U.UDT_NAME, U.PRIVILEGE_TYPE, U.IS_GRANTABLE FROM INFORMATION_SCHEMA.UDT_PRIVILEGES U JOIN INFORMATION_SCHEMA.APPLICABLE_ROLES ON U.GRANTEE = ROLE_NAME;");
        table.insertSys(session, persistentStore, result);
        session2.close();
        return table;
    }

    Table ROLE_USAGE_GRANTS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[67];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[67]);
            this.addColumn(table, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_TYPE", CHARACTER_DATA);
            this.addColumn(table, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[67].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6, 7}, false);
            return table;
        }
        Session session2 = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        Result result = session2.executeDirectStatement("SELECT U.GRANTOR, U.GRANTEE, U.OBJECT_CATALOG, U.OBJECT_SCHEMA, U.OBJECT_NAME, U.OBJECT_TYPE, U.PRIVILEGE_TYPE, U.IS_GRANTABLE FROM INFORMATION_SCHEMA.USAGE_PRIVILEGES U JOIN INFORMATION_SCHEMA.APPLICABLE_ROLES A ON U.GRANTEE = A.ROLE_NAME;");
        table.insertSys(session, persistentStore, result);
        session2.close();
        return table;
    }

    Table ROUTINE_COLUMN_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[68];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[68]);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[68].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{3, 4, 5, 0, 1, 2, 6, 7, 8, 9}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(24);
        while (iterator.hasNext()) {
            Routine routine = (Routine)iterator.next();
            OrderedHashSet orderedHashSet = routine.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 9 || !session.getGrantee().isFullyAccessibleByRole(hsqlName)) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = routine.getSchemaName().name;
                objectArray[2] = routine.getSpecificName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = routine.getSchemaName().name;
                objectArray[5] = routine.getName().name;
                objectArray[6] = this.database.getCatalogName().name;
                objectArray[7] = hsqlName.parent.schema.name;
                objectArray[8] = hsqlName.parent.name;
                objectArray[9] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    Table ROUTINE_JAR_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[69];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[69]);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "JAR_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "JAR_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "JAR_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[69].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        if (!session.isAdmin()) {
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(24);
        while (iterator.hasNext()) {
            Routine routine = (Routine)iterator.next();
            if (routine.getLanguage() != 1) continue;
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = routine.getSchemaName().name;
            objectArray[2] = routine.getSpecificName().name;
            objectArray[3] = this.database.getCatalogName().name;
            objectArray[4] = this.database.schemaManager.getSQLJSchemaHsqlName().name;
            objectArray[5] = "CLASSPATH";
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table ROUTINE_PERIOD_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[70];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[70]);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PERIOD_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[70].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{3, 4, 5, 0, 1, 2, 6, 7, 8, 9}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(24);
        while (iterator.hasNext()) {
            Routine routine = (Routine)iterator.next();
            OrderedHashSet orderedHashSet = routine.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 30 || !session.getGrantee().isFullyAccessibleByRole(hsqlName)) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = routine.getSchemaName().name;
                objectArray[2] = routine.getSpecificName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = routine.getSchemaName().name;
                objectArray[5] = routine.getName().name;
                objectArray[6] = this.database.getCatalogName().name;
                objectArray[7] = hsqlName.schema.name;
                objectArray[8] = hsqlName.parent.name;
                objectArray[9] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    Table ROUTINE_PRIVILEGES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[71];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[71]);
            this.addColumn(table, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[71].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, false);
            return table;
        }
        OrderedHashSet orderedHashSet = session.getGrantee().visibleGrantees();
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(24);
        while (iterator.hasNext()) {
            Routine routine = (Routine)iterator.next();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                Grantee grantee = (Grantee)orderedHashSet.get(i);
                OrderedHashSet orderedHashSet2 = grantee.getAllDirectPrivileges(routine);
                OrderedHashSet orderedHashSet3 = grantee.getAllGrantedPrivileges(routine);
                if (!orderedHashSet3.isEmpty()) {
                    orderedHashSet3.addAll(orderedHashSet2);
                    orderedHashSet2 = orderedHashSet3;
                }
                for (int j = 0; j < orderedHashSet2.size(); ++j) {
                    Right right = (Right)orderedHashSet2.get(j);
                    Right right2 = right.getGrantableRights();
                    if (!right.canAccessFully(32)) continue;
                    String string = "EXECUTE";
                    Object[] objectArray = table.getEmptyRowData();
                    objectArray[0] = right.getGrantor().getName().name;
                    objectArray[1] = right.getGrantee().getName().name;
                    objectArray[2] = this.database.getCatalogName().name;
                    objectArray[3] = routine.getSchemaName().name;
                    objectArray[4] = routine.getSpecificName().name;
                    objectArray[5] = this.database.getCatalogName().name;
                    objectArray[6] = routine.getSchemaName().name;
                    objectArray[7] = routine.getName().name;
                    objectArray[8] = string;
                    objectArray[9] = right.getGrantee() == routine.getOwner() || right2.canAccessFully(32) ? "YES" : "NO";
                    try {
                        table.insertSys(session, persistentStore, objectArray);
                        continue;
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
            }
        }
        return table;
    }

    Table ROUTINE_ROUTINE_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[72];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[72]);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[72].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(24);
        while (iterator.hasNext()) {
            Routine routine = (Routine)iterator.next();
            OrderedHashSet orderedHashSet = routine.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 24 || !session.getGrantee().isFullyAccessibleByRole(hsqlName)) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = routine.getSchemaName().name;
                objectArray[2] = routine.getSpecificName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = hsqlName.schema.name;
                objectArray[5] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    Table ROUTINE_SEQUENCE_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[73];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[73]);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[73].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(24);
        while (iterator.hasNext()) {
            Routine routine = (Routine)iterator.next();
            OrderedHashSet orderedHashSet = routine.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 7 || !session.getGrantee().isFullyAccessibleByRole(hsqlName)) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = routine.getSchemaName().name;
                objectArray[2] = routine.getSpecificName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = hsqlName.schema.name;
                objectArray[5] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    Table ROUTINE_TABLE_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[74];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[74]);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[74].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{3, 4, 5, 0, 1, 2, 6, 7, 8}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(24);
        while (iterator.hasNext()) {
            Routine routine = (Routine)iterator.next();
            OrderedHashSet orderedHashSet = routine.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 3 && hsqlName.type != 4 || !session.getGrantee().isFullyAccessibleByRole(hsqlName)) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = routine.getSchemaName().name;
                objectArray[2] = routine.getSpecificName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = routine.getSchemaName().name;
                objectArray[5] = routine.getName().name;
                objectArray[6] = this.database.getCatalogName().name;
                objectArray[7] = hsqlName.schema.name;
                objectArray[8] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    Table ROUTINES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[75];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[75]);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "MODULE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "MODULE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "MODULE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "CHARACTER_MAXIMUM_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(table, "INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "TYPE_UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TYPE_UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TYPE_UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "MAXIMUM_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(table, "DTD_IDENTIFIER", SQL_IDENTIFIER);
            this.addColumn(table, "ROUTINE_BODY", CHARACTER_DATA);
            this.addColumn(table, "ROUTINE_DEFINITION", CHARACTER_DATA);
            this.addColumn(table, "EXTERNAL_NAME", CHARACTER_DATA);
            this.addColumn(table, "EXTERNAL_LANGUAGE", CHARACTER_DATA);
            this.addColumn(table, "PARAMETER_STYLE", CHARACTER_DATA);
            this.addColumn(table, "IS_DETERMINISTIC", YES_OR_NO);
            this.addColumn(table, "SQL_DATA_ACCESS", CHARACTER_DATA);
            this.addColumn(table, "IS_NULL_CALL", YES_OR_NO);
            this.addColumn(table, "SQL_PATH", CHARACTER_DATA);
            this.addColumn(table, "SCHEMA_LEVEL_ROUTINE", YES_OR_NO);
            this.addColumn(table, "MAX_DYNAMIC_RESULT_SETS", CARDINAL_NUMBER);
            this.addColumn(table, "IS_USER_DEFINED_CAST", YES_OR_NO);
            this.addColumn(table, "IS_IMPLICITLY_INVOCABLE", YES_OR_NO);
            this.addColumn(table, "SECURITY_TYPE", CHARACTER_DATA);
            this.addColumn(table, "TO_SQL_SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TO_SQL_SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TO_SQL_SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "AS_LOCATOR", YES_OR_NO);
            this.addColumn(table, "CREATED", TIME_STAMP);
            this.addColumn(table, "LAST_ALTERED", TIME_STAMP);
            this.addColumn(table, "NEW_SAVEPOINT_LEVEL", YES_OR_NO);
            this.addColumn(table, "IS_UDT_DEPENDENT", YES_OR_NO);
            this.addColumn(table, "RESULT_CAST_FROM_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "RESULT_CAST_AS_LOCATOR", YES_OR_NO);
            this.addColumn(table, "RESULT_CAST_CHAR_MAX_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "RESULT_CAST_CHAR_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "RESULT_CAST_CHAR_SET_CATALOG", CHARACTER_DATA);
            this.addColumn(table, "RESULT_CAST_CHAR_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "RESULT_CAST_CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "RESULT_CAST_COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "RESULT_CAST_COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "RESULT_CAST_COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "RESULT_CAST_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "RESULT_CAST_NUMERIC_RADIX", CARDINAL_NUMBER);
            this.addColumn(table, "RESULT_CAST_NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "RESULT_CAST_DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "RESULT_CAST_INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(table, "RESULT_CAST_INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "RESULT_CAST_TYPE_UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "RESULT_CAST_TYPE_UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "RESULT_CAST_TYPE_UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "RESULT_CAST_SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "RESULT_CAST_SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "RESULT_CAST_SCOPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "RESULT_CAST_MAX_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(table, "RESULT_CAST_DTD_IDENTIFIER", CHARACTER_DATA);
            this.addColumn(table, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "RESULT_CAST_FROM_DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "RESULT_CAST_DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "RESULT_CAST_DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[75].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{3, 4, 5, 0, 1, 2}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(24);
        while (iterator.hasNext()) {
            Routine routine = (Routine)iterator.next();
            if (!session.getGrantee().isAccessible(routine)) continue;
            boolean bl = session.getGrantee().isFullyAccessibleByRole(routine.getName());
            Object[] objectArray = table.getEmptyRowData();
            Type type = routine.isProcedure() ? null : routine.getReturnType();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = routine.getSchemaName().name;
            objectArray[2] = routine.getSpecificName().name;
            objectArray[3] = this.database.getCatalogName().name;
            objectArray[4] = routine.getSchemaName().name;
            objectArray[5] = routine.getName().name;
            objectArray[6] = routine.isProcedure() ? "PROCEDURE" : "FUNCTION";
            objectArray[7] = null;
            objectArray[8] = null;
            objectArray[9] = null;
            objectArray[10] = null;
            objectArray[11] = null;
            objectArray[12] = null;
            Object object = objectArray[13] = type == null ? null : type.getNameString();
            if (type != null) {
                if (type.isCharacterType()) {
                    objectArray[14] = ValuePool.getLong(type.precision);
                    objectArray[15] = ValuePool.getLong(type.precision * 2L);
                    objectArray[16] = this.database.getCatalogName().name;
                    objectArray[17] = type.getCharacterSet().getSchemaName().name;
                    objectArray[18] = type.getCharacterSet().getName().name;
                    objectArray[19] = this.database.getCatalogName().name;
                    objectArray[20] = type.getCollation().getSchemaName().name;
                    objectArray[21] = type.getCollation().getName().name;
                } else if (type.isNumberType()) {
                    objectArray[22] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                    objectArray[83] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                    if (type.isExactNumberType()) {
                        objectArray[24] = objectArray[84] = ValuePool.getLong(type.scale);
                    }
                    objectArray[23] = ValuePool.getLong(type.getPrecisionRadix());
                } else if (!type.isBooleanType()) {
                    if (type.isDateTimeType()) {
                        objectArray[25] = ValuePool.getLong(type.scale);
                    } else if (type.isIntervalType()) {
                        objectArray[13] = "INTERVAL";
                        objectArray[26] = IntervalType.getQualifier(type.typeCode);
                        objectArray[27] = ValuePool.getLong(type.precision);
                        objectArray[25] = ValuePool.getLong(type.scale);
                    } else if (type.isBinaryType()) {
                        objectArray[14] = ValuePool.getLong(type.precision);
                        objectArray[15] = ValuePool.getLong(type.precision);
                    } else if (type.isBitType()) {
                        objectArray[14] = ValuePool.getLong(type.precision);
                        objectArray[15] = ValuePool.getLong(type.precision);
                    } else if (type.isArrayType()) {
                        objectArray[34] = ValuePool.getLong(type.arrayLimitCardinality());
                        objectArray[13] = "ARRAY";
                    }
                }
                objectArray[35] = type.getDefinition();
                objectArray[82] = objectArray[13];
            }
            objectArray[28] = null;
            objectArray[29] = null;
            objectArray[30] = null;
            objectArray[31] = null;
            objectArray[32] = null;
            objectArray[33] = null;
            objectArray[36] = routine.getLanguage() == 1 ? "EXTERNAL" : "SQL";
            objectArray[37] = bl ? routine.getSQL() : null;
            objectArray[38] = routine.getExternalName();
            objectArray[39] = routine.getLanguage() == 1 ? "JAVA" : null;
            objectArray[40] = routine.getLanguage() == 1 ? "JAVA" : null;
            objectArray[41] = routine.isDeterministic() ? "YES" : "NO";
            objectArray[42] = routine.getDataImpactString();
            objectArray[43] = type == null ? null : (routine.isNullInputOutput() ? "YES" : "NO");
            objectArray[44] = null;
            objectArray[45] = "YES";
            objectArray[46] = ValuePool.getLong(0L);
            objectArray[47] = type == null ? null : "NO";
            objectArray[48] = null;
            objectArray[49] = "DEFINER";
            objectArray[50] = null;
            objectArray[51] = null;
            objectArray[52] = null;
            objectArray[53] = type == null ? null : "NO";
            objectArray[54] = null;
            objectArray[55] = null;
            objectArray[56] = "YES";
            objectArray[57] = null;
            objectArray[58] = null;
            objectArray[59] = null;
            objectArray[60] = null;
            objectArray[61] = null;
            objectArray[62] = null;
            objectArray[63] = null;
            objectArray[64] = null;
            objectArray[65] = null;
            objectArray[66] = null;
            objectArray[67] = null;
            objectArray[68] = null;
            objectArray[69] = null;
            objectArray[70] = null;
            objectArray[71] = null;
            objectArray[72] = null;
            objectArray[73] = null;
            objectArray[74] = null;
            objectArray[75] = null;
            objectArray[76] = null;
            objectArray[77] = null;
            objectArray[78] = null;
            objectArray[79] = null;
            objectArray[80] = null;
            objectArray[81] = null;
            objectArray[82] = objectArray[13];
            objectArray[83] = objectArray[22];
            objectArray[84] = objectArray[24];
            objectArray[85] = null;
            objectArray[86] = null;
            objectArray[87] = null;
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table SCHEMATA(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[76];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[76]);
            this.addColumn(table, "CATALOG_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SCHEMA_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SCHEMA_OWNER", SQL_IDENTIFIER);
            this.addColumn(table, "DEFAULT_CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "DEFAULT_CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "DEFAULT_CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SQL_PATH", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[76].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1}, false);
            return table;
        }
        String string = "INFORMATION_SCHEMA";
        String string2 = "SQL_TEXT";
        Object var8_8 = null;
        Grantee grantee = session.getGrantee();
        Schema[] schemaArray = this.database.schemaManager.getAllSchemas();
        for (int i = 0; i < schemaArray.length; ++i) {
            Schema schema = schemaArray[i];
            if (!grantee.hasSchemaUpdateOrGrantRights(schema.getName().getNameString())) continue;
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = schema.getName().getNameString();
            objectArray[2] = schema.getOwner().getName().getNameString();
            objectArray[3] = this.database.getCatalogName().name;
            objectArray[4] = string;
            objectArray[5] = string2;
            objectArray[6] = var8_8;
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table SQL_FEATURES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[78];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[78]);
            this.addColumn(table, "FEATURE_ID", CHARACTER_DATA);
            this.addColumn(table, "FEATURE_NAME", CHARACTER_DATA);
            this.addColumn(table, "SUB_FEATURE_ID", CHARACTER_DATA);
            this.addColumn(table, "SUB_FEATURE_NAME", CHARACTER_DATA);
            this.addColumn(table, "IS_SUPPORTED", YES_OR_NO);
            this.addColumn(table, "IS_VERIFIED_BY", CHARACTER_DATA);
            this.addColumn(table, "COMMENTS", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[78].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 2}, false);
            return table;
        }
        Session session2 = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        String string = (String)statementMap.get("/*sql_features*/");
        Result result = session2.executeDirectStatement(string);
        table.insertSys(session, persistentStore, result);
        return table;
    }

    Table SQL_IMPLEMENTATION_INFO(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[79];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[79]);
            this.addColumn(table, "IMPLEMENTATION_INFO_ID", CARDINAL_NUMBER);
            this.addColumn(table, "IMPLEMENTATION_INFO_NAME", CHARACTER_DATA);
            this.addColumn(table, "INTEGER_VALUE", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_VALUE", CHARACTER_DATA);
            this.addColumn(table, "COMMENTS", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[79].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, false);
            return table;
        }
        Session session2 = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        String string = (String)statementMap.get("/*sql_implementation_info*/");
        Result result = session2.executeDirectStatement(string);
        table.insertSys(session, persistentStore, result);
        return table;
    }

    Table SQL_PACKAGES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[80];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[80]);
            this.addColumn(table, "ID", CHARACTER_DATA);
            this.addColumn(table, "NAME", CHARACTER_DATA);
            this.addColumn(table, "IS_SUPPORTED", YES_OR_NO);
            this.addColumn(table, "IS_VERIFIED_BY", CHARACTER_DATA);
            this.addColumn(table, "COMMENTS", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[80].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, false);
            return table;
        }
        Session session2 = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        String string = (String)statementMap.get("/*sql_packages*/");
        Result result = session2.executeDirectStatement(string);
        table.insertSys(session, persistentStore, result);
        return table;
    }

    Table SQL_PARTS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[81];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[81]);
            this.addColumn(table, "PART", CHARACTER_DATA);
            this.addColumn(table, "NAME", CHARACTER_DATA);
            this.addColumn(table, "IS_SUPPORTED", YES_OR_NO);
            this.addColumn(table, "IS_VERIFIED_BY", CHARACTER_DATA);
            this.addColumn(table, "COMMENTS", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[81].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, false);
            return table;
        }
        Session session2 = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        String string = (String)statementMap.get("/*sql_parts*/");
        Result result = session2.executeDirectStatement(string);
        table.insertSys(session, persistentStore, result);
        return table;
    }

    Table SQL_SIZING(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[82];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[82]);
            this.addColumn(table, "SIZING_ID", CARDINAL_NUMBER);
            this.addColumn(table, "SIZING_NAME", CHARACTER_DATA);
            this.addColumn(table, "SUPPORTED_VALUE", CARDINAL_NUMBER);
            this.addColumn(table, "COMMENTS", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[82].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, false);
            return table;
        }
        Session session2 = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        String string = (String)statementMap.get("/*sql_sizing*/");
        Result result = session2.executeDirectStatement(string);
        table.insertSys(session, persistentStore, result);
        return table;
    }

    Table SQL_SIZING_PROFILES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[83];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[83]);
            this.addColumn(table, "SIZING_ID", CARDINAL_NUMBER);
            this.addColumn(table, "SIZING_NAME", CHARACTER_DATA);
            this.addColumn(table, "PROFILE_ID", CARDINAL_NUMBER);
            this.addColumn(table, "PROFILE_NAME", CHARACTER_DATA);
            this.addColumn(table, "REQUIRED_VALUE", CARDINAL_NUMBER);
            this.addColumn(table, "COMMENTS", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[83].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, false);
            return table;
        }
        return table;
    }

    Table TABLE_CONSTRAINTS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[84];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[84]);
            this.addColumn(table, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "CONSTRAINT_TYPE", CHARACTER_DATA);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "IS_DEFERRABLE", YES_OR_NO);
            this.addColumn(table, "INITIALLY_DEFERRED", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[84].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        Table table2 = null;
        while (iterator.hasNext()) {
            table2 = (Table)iterator.next();
            if (table2.isView() || !session.getGrantee().hasNonSelectTableRight(table2)) continue;
            block7: for (Constraint constraint : table2.getConstraints()) {
                Object[] objectArray = table.getEmptyRowData();
                switch (constraint.getConstraintType()) {
                    case 3: {
                        objectArray[3] = "CHECK";
                        break;
                    }
                    case 2: {
                        objectArray[3] = "UNIQUE";
                        break;
                    }
                    case 0: {
                        objectArray[3] = "FOREIGN KEY";
                        table2 = constraint.getRef();
                        break;
                    }
                    case 4: {
                        objectArray[3] = "PRIMARY KEY";
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                String string = this.database.getCatalogName().name;
                String string2 = table2.getSchemaName().name;
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = constraint.getName().name;
                objectArray[4] = string;
                objectArray[5] = string2;
                objectArray[6] = table2.getName().name;
                objectArray[7] = "NO";
                objectArray[8] = "NO";
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table TRANSLATIONS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[87];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[87]);
            this.addColumn(table, "TRANSLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TRANSLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TRANSLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SOURCE_CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SOURCE_CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SOURCE_CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TARGET_CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TARGET_CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TARGET_CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TRANSLATION_SOURCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TRANSLATION_SOURCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TRANSLATION_SOURCE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[87].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        return table;
    }

    Table TRIGGER_COLUMN_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[88];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[88]);
            this.addColumn(table, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[88].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(8);
        while (iterator.hasNext()) {
            TriggerDef triggerDef = (TriggerDef)iterator.next();
            if (!session.getGrantee().isFullyAccessibleByRole(triggerDef.getName())) continue;
            OrderedHashSet orderedHashSet = triggerDef.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 9 || !session.getGrantee().isAccessible(hsqlName)) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = triggerDef.getSchemaName().name;
                objectArray[2] = triggerDef.getName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = hsqlName.parent.schema.name;
                objectArray[5] = hsqlName.parent.name;
                objectArray[6] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    Table TRIGGER_PERIOD_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[89];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[89]);
            this.addColumn(table, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PERIOD_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[89].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(8);
        while (iterator.hasNext()) {
            TriggerDef triggerDef = (TriggerDef)iterator.next();
            if (!session.getGrantee().isFullyAccessibleByRole(triggerDef.getName())) continue;
            OrderedHashSet orderedHashSet = triggerDef.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 3) continue;
                Table table2 = this.database.schemaManager.getUserTable(hsqlName);
                PeriodDefinition periodDefinition = table2.getSystemPeriod();
                PeriodDefinition periodDefinition2 = table2.getApplicationPeriod();
                if (periodDefinition == null && periodDefinition2 == null) continue;
                for (int j = 0; j < 2; ++j) {
                    PeriodDefinition periodDefinition3;
                    PeriodDefinition periodDefinition4 = periodDefinition3 = j == 0 ? periodDefinition : periodDefinition2;
                    if (periodDefinition3 == null) continue;
                    Object[] objectArray = table.getEmptyRowData();
                    objectArray[0] = this.database.getCatalogName().name;
                    objectArray[1] = triggerDef.getSchemaName().name;
                    objectArray[2] = triggerDef.getName().name;
                    objectArray[3] = this.database.getCatalogName().name;
                    objectArray[4] = hsqlName.schema.name;
                    objectArray[5] = hsqlName.name;
                    objectArray[6] = periodDefinition3.getName().name;
                    try {
                        table.insertSys(session, persistentStore, objectArray);
                        continue;
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
            }
        }
        return table;
    }

    Table TRIGGER_ROUTINE_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[90];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[90]);
            this.addColumn(table, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[90].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(8);
        while (iterator.hasNext()) {
            TriggerDef triggerDef = (TriggerDef)iterator.next();
            if (!session.getGrantee().isFullyAccessibleByRole(triggerDef.getName())) continue;
            OrderedHashSet orderedHashSet = triggerDef.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 24) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = triggerDef.getSchemaName().name;
                objectArray[2] = triggerDef.getName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = hsqlName.schema.name;
                objectArray[5] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    Table TRIGGER_SEQUENCE_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[91];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[91]);
            this.addColumn(table, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[91].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(8);
        while (iterator.hasNext()) {
            TriggerDef triggerDef = (TriggerDef)iterator.next();
            if (!session.getGrantee().isFullyAccessibleByRole(triggerDef.getName())) continue;
            OrderedHashSet orderedHashSet = triggerDef.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 7) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = triggerDef.getSchemaName().name;
                objectArray[2] = triggerDef.getName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = hsqlName.schema.name;
                objectArray[5] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    Table TRIGGER_TABLE_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[92];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[92]);
            this.addColumn(table, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[92].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(8);
        while (iterator.hasNext()) {
            TriggerDef triggerDef = (TriggerDef)iterator.next();
            if (!session.getGrantee().isFullyAccessibleByRole(triggerDef.getName())) continue;
            OrderedHashSet orderedHashSet = triggerDef.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 3 && hsqlName.type != 4) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = triggerDef.getSchemaName().name;
                objectArray[2] = triggerDef.getName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = hsqlName.schema.name;
                objectArray[5] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    Table TRIGGERS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[94];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[94]);
            this.addColumn(table, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "EVENT_MANIPULATION", SQL_IDENTIFIER);
            this.addColumn(table, "EVENT_OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "EVENT_OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "EVENT_OBJECT_TABLE", SQL_IDENTIFIER);
            this.addColumn(table, "ACTION_ORDER", CARDINAL_NUMBER);
            this.addColumn(table, "ACTION_CONDITION", CHARACTER_DATA);
            this.addColumn(table, "ACTION_STATEMENT", CHARACTER_DATA);
            this.addColumn(table, "ACTION_ORIENTATION", CHARACTER_DATA);
            this.addColumn(table, "ACTION_TIMING", CHARACTER_DATA);
            this.addColumn(table, "ACTION_REFERENCE_OLD_TABLE", SQL_IDENTIFIER);
            this.addColumn(table, "ACTION_REFERENCE_NEW_TABLE", SQL_IDENTIFIER);
            this.addColumn(table, "ACTION_REFERENCE_OLD_ROW", SQL_IDENTIFIER);
            this.addColumn(table, "ACTION_REFERENCE_NEW_ROW", SQL_IDENTIFIER);
            this.addColumn(table, "CREATED", TIME_STAMP);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[94].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(8);
        while (iterator.hasNext()) {
            TriggerDef triggerDef = (TriggerDef)iterator.next();
            boolean bl = session.getGrantee().isFullyAccessibleByRole(triggerDef.getName());
            if (!session.getGrantee().hasNonSelectTableRight(triggerDef.getTable())) continue;
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = triggerDef.getSchemaName().name;
            objectArray[2] = triggerDef.getName().name;
            objectArray[3] = triggerDef.getEventTypeString();
            objectArray[4] = this.database.getCatalogName().name;
            objectArray[5] = triggerDef.getTable().getSchemaName().name;
            objectArray[6] = triggerDef.getTable().getName().name;
            int n = triggerDef.getTable().getTriggerIndex(triggerDef.getName().name);
            objectArray[7] = ValuePool.getLong(n);
            objectArray[8] = bl ? triggerDef.getConditionSQL() : null;
            objectArray[9] = bl ? triggerDef.getProcedureSQL() : null;
            objectArray[10] = triggerDef.getActionOrientationString();
            objectArray[11] = triggerDef.getActionTimingString();
            objectArray[12] = triggerDef.getOldTransitionTableName();
            objectArray[13] = triggerDef.getNewTransitionTableName();
            objectArray[14] = triggerDef.getOldTransitionRowName();
            objectArray[15] = triggerDef.getNewTransitionRowName();
            objectArray[16] = null;
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table TRIGGERED_UPDATE_COLUMNS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[93];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[93]);
            this.addColumn(table, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "EVENT_OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "EVENT_OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "EVENT_OBJECT_TABLE", SQL_IDENTIFIER);
            this.addColumn(table, "EVENT_OBJECT_COLUMN", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[93].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(8);
        while (iterator.hasNext()) {
            int[] nArray;
            TriggerDef triggerDef = (TriggerDef)iterator.next();
            if (!session.getGrantee().isAccessible(triggerDef) || (nArray = triggerDef.getUpdateColumnIndexes()) == null) continue;
            for (int i = 0; i < nArray.length; ++i) {
                ColumnSchema columnSchema = triggerDef.getTable().getColumn(nArray[i]);
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = triggerDef.getSchemaName().name;
                objectArray[2] = triggerDef.getName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = triggerDef.getTable().getSchemaName().name;
                objectArray[5] = triggerDef.getTable().getName().name;
                objectArray[6] = columnSchema.getNameString();
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table UDT_PRIVILEGES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[96];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[96]);
            this.addColumn(table, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[96].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(12);
        OrderedHashSet orderedHashSet = session.getGrantee().getGranteeAndAllRolesWithPublic();
        while (iterator.hasNext()) {
            SchemaObject schemaObject = (SchemaObject)iterator.next();
            if (schemaObject.getType() != 12) continue;
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                Grantee grantee = (Grantee)orderedHashSet.get(i);
                OrderedHashSet orderedHashSet2 = grantee.getAllDirectPrivileges(schemaObject);
                OrderedHashSet orderedHashSet3 = grantee.getAllGrantedPrivileges(schemaObject);
                if (!orderedHashSet3.isEmpty()) {
                    orderedHashSet3.addAll(orderedHashSet2);
                    orderedHashSet2 = orderedHashSet3;
                }
                for (int j = 0; j < orderedHashSet2.size(); ++j) {
                    Right right = (Right)orderedHashSet2.get(j);
                    Right right2 = right.getGrantableRights();
                    Object[] objectArray = table.getEmptyRowData();
                    objectArray[0] = right.getGrantor().getName().name;
                    objectArray[1] = right.getGrantee().getName().name;
                    objectArray[2] = this.database.getCatalogName().name;
                    objectArray[3] = schemaObject.getSchemaName().name;
                    objectArray[4] = schemaObject.getName().name;
                    objectArray[5] = "USAGE";
                    objectArray[6] = right.getGrantee() == schemaObject.getOwner() || right2.isFull() ? "YES" : "NO";
                    try {
                        table.insertSys(session, persistentStore, objectArray);
                        continue;
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
            }
        }
        return table;
    }

    Table USAGE_PRIVILEGES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[97];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[97]);
            this.addColumn(table, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "OBJECT_TYPE", CHARACTER_DATA);
            this.addColumn(table, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[97].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6, 7}, false);
            return table;
        }
        WrapperIterator wrapperIterator = new WrapperIterator(this.database.schemaManager.databaseObjectIterator(7), this.database.schemaManager.databaseObjectIterator(15));
        wrapperIterator = new WrapperIterator(wrapperIterator, this.database.schemaManager.databaseObjectIterator(14));
        wrapperIterator = new WrapperIterator(wrapperIterator, this.database.schemaManager.databaseObjectIterator(13));
        OrderedHashSet orderedHashSet = session.getGrantee().getGranteeAndAllRolesWithPublic();
        while (wrapperIterator.hasNext()) {
            SchemaObject schemaObject = (SchemaObject)wrapperIterator.next();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                Grantee grantee = (Grantee)orderedHashSet.get(i);
                OrderedHashSet orderedHashSet2 = grantee.getAllDirectPrivileges(schemaObject);
                OrderedHashSet orderedHashSet3 = grantee.getAllGrantedPrivileges(schemaObject);
                if (!orderedHashSet3.isEmpty()) {
                    orderedHashSet3.addAll(orderedHashSet2);
                    orderedHashSet2 = orderedHashSet3;
                }
                for (int j = 0; j < orderedHashSet2.size(); ++j) {
                    Right right = (Right)orderedHashSet2.get(j);
                    Right right2 = right.getGrantableRights();
                    Object[] objectArray = table.getEmptyRowData();
                    objectArray[0] = right.getGrantor().getName().name;
                    objectArray[1] = right.getGrantee().getName().name;
                    objectArray[2] = this.database.getCatalogName().name;
                    objectArray[3] = schemaObject.getSchemaName().name;
                    objectArray[4] = schemaObject.getName().name;
                    objectArray[5] = SchemaObjectSet.getName(schemaObject.getName().type);
                    objectArray[6] = "USAGE";
                    objectArray[7] = right.getGrantee() == schemaObject.getOwner() || right2.isFull() ? "YES" : "NO";
                    try {
                        table.insertSys(session, persistentStore, objectArray);
                        continue;
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
            }
        }
        return table;
    }

    Table USER_DEFINED_TYPES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[98];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[98]);
            this.addColumn(table, "USER_DEFINED_TYPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "USER_DEFINED_TYPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "USER_DEFINED_TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "USER_DEFINED_TYPE_CATEGORY", SQL_IDENTIFIER);
            this.addColumn(table, "IS_INSTANTIABLE", YES_OR_NO);
            this.addColumn(table, "IS_FINAL", YES_OR_NO);
            this.addColumn(table, "ORDERING_FORM", SQL_IDENTIFIER);
            this.addColumn(table, "ORDERING_CATEGORY", SQL_IDENTIFIER);
            this.addColumn(table, "ORDERING_ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "ORDERING_ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "ORDERING_ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "REFERENCE_TYPE", SQL_IDENTIFIER);
            this.addColumn(table, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "CHARACTER_MAXIMUM_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(table, "CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(table, "INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "SOURCE_DTD_IDENTIFIER", CHARACTER_DATA);
            this.addColumn(table, "REF_DTD_IDENTIFIER", CHARACTER_DATA);
            this.addColumn(table, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "MAXIMUM_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(table, "EXTERNAL_NAME", CHARACTER_DATA);
            this.addColumn(table, "EXTERNAL_LANGUAGE", CHARACTER_DATA);
            this.addColumn(table, "JAVA_INTERFACE", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[98].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(12);
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            if (!type.isDistinctType()) continue;
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = type.getSchemaName().name;
            objectArray[2] = type.getName().name;
            objectArray[12] = type.getFullNameString();
            objectArray[3] = "DISTINCT";
            objectArray[4] = "YES";
            objectArray[5] = "YES";
            objectArray[6] = "FULL";
            if (type.isCharacterType()) {
                objectArray[13] = ValuePool.getLong(type.precision);
                objectArray[14] = ValuePool.getLong(type.precision * 2L);
                objectArray[15] = this.database.getCatalogName().name;
                objectArray[16] = type.getCharacterSet().getSchemaName().name;
                objectArray[17] = type.getCharacterSet().getName().name;
                objectArray[18] = this.database.getCatalogName().name;
                objectArray[19] = type.getCollation().getSchemaName().name;
                objectArray[20] = type.getCollation().getName().name;
            } else if (type.isNumberType()) {
                objectArray[21] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                objectArray[30] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                if (type.isExactNumberType()) {
                    objectArray[23] = objectArray[31] = ValuePool.getLong(type.scale);
                }
                objectArray[22] = ValuePool.getLong(type.getPrecisionRadix());
            } else if (!type.isBooleanType()) {
                if (type.isDateTimeType()) {
                    objectArray[24] = ValuePool.getLong(type.scale);
                } else if (type.isIntervalType()) {
                    objectArray[12] = "INTERVAL";
                    objectArray[25] = IntervalType.getQualifier(type.typeCode);
                    objectArray[26] = ValuePool.getLong(type.precision);
                    objectArray[24] = ValuePool.getLong(type.scale);
                } else if (type.isBinaryType()) {
                    objectArray[13] = ValuePool.getLong(type.precision);
                    objectArray[14] = ValuePool.getLong(type.precision);
                } else if (type.isBitType()) {
                    objectArray[13] = ValuePool.getLong(type.precision);
                    objectArray[14] = ValuePool.getLong(type.precision);
                } else if (type.isArrayType()) {
                    objectArray[32] = ValuePool.getLong(type.arrayLimitCardinality());
                    objectArray[12] = "ARRAY";
                }
            }
            objectArray[27] = type.getDefinition();
            objectArray[29] = objectArray[12];
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table VIEW_COLUMN_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[99];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[99]);
            this.addColumn(table, "VIEW_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "VIEW_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "VIEW_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[99].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.isView() || !session.getGrantee().isFullyAccessibleByRole(table2.getName())) continue;
            String string = this.database.getCatalogName().name;
            String string2 = table2.getSchemaName().name;
            String string3 = table2.getName().name;
            View view = (View)table2;
            OrderedHashSet orderedHashSet = view.getReferences();
            Iterator iterator2 = orderedHashSet.iterator();
            while (iterator2.hasNext()) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)iterator2.next();
                if (hsqlName.type != 9) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = string3;
                objectArray[3] = string;
                objectArray[4] = hsqlName.parent.schema.name;
                objectArray[5] = hsqlName.parent.name;
                objectArray[6] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                }
                catch (HsqlException hsqlException) {}
            }
        }
        return table;
    }

    Table VIEW_PERIOD_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[100];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[100]);
            this.addColumn(table, "VIEW_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "VIEW_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "VIEW_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PERIOD_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[100].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.isView()) continue;
            OrderedHashSet orderedHashSet = table2.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 30 || !session.getGrantee().isFullyAccessibleByRole(hsqlName)) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = table2.getSchemaName().name;
                objectArray[2] = table2.getName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = hsqlName.schema.name;
                objectArray[5] = hsqlName.parent.name;
                objectArray[6] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    Table VIEW_ROUTINE_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[101];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[101]);
            this.addColumn(table, "VIEW_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "VIEW_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "VIEW_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[101].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.isView()) continue;
            OrderedHashSet orderedHashSet = table2.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 24 || !session.getGrantee().isFullyAccessibleByRole(hsqlName)) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = table2.getSchemaName().name;
                objectArray[2] = table2.getName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = hsqlName.schema.name;
                objectArray[5] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    Table VIEW_TABLE_USAGE(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[102];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[102]);
            this.addColumn(table, "VIEW_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "VIEW_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "VIEW_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[102].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.isView()) continue;
            OrderedHashSet orderedHashSet = table2.getReferences();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                if (hsqlName.type != 3 && hsqlName.type != 4 || !session.getGrantee().isFullyAccessibleByRole(hsqlName)) continue;
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = this.database.getCatalogName().name;
                objectArray[1] = table2.getSchemaName().name;
                objectArray[2] = table2.getName().name;
                objectArray[3] = this.database.getCatalogName().name;
                objectArray[4] = hsqlName.schema.name;
                objectArray[5] = hsqlName.name;
                try {
                    table.insertSys(session, persistentStore, objectArray);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
        return table;
    }

    Table VIEWS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[103];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[103]);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "VIEW_DEFINITION", CHARACTER_DATA);
            this.addColumn(table, "CHECK_OPTION", CHARACTER_DATA);
            this.addColumn(table, "IS_UPDATABLE", YES_OR_NO);
            this.addColumn(table, "INSERTABLE_INTO", YES_OR_NO);
            this.addColumn(table, "IS_TRIGGER_UPDATABLE", YES_OR_NO);
            this.addColumn(table, "IS_TRIGGER_DELETABLE", YES_OR_NO);
            this.addColumn(table, "IS_TRIGGER_INSERTABLE_INTO", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[103].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{1, 2, 0}, false);
            return table;
        }
        Iterator iterator = this.allTables();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.isView() && table2.getSchemaName() != SqlInvariants.INFORMATION_SCHEMA_HSQLNAME || !this.isAccessibleTable(session, table2)) continue;
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = table2.getSchemaName().name;
            objectArray[2] = table2.getName().name;
            String string = "NONE";
            if (table2 instanceof View) {
                if (session.getGrantee().isFullyAccessibleByRole(table2.getName())) {
                    objectArray[3] = ((View)table2).getStatement();
                }
                switch (((View)table2).getCheckOption()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        string = "LOCAL";
                        break;
                    }
                    case 2: {
                        string = "CASCADED";
                    }
                }
            }
            objectArray[4] = string;
            objectArray[5] = table2.isUpdatable() ? "YES" : "NO";
            objectArray[6] = table2.isInsertable() ? "YES" : "NO";
            objectArray[7] = table2.isTriggerUpdatable() ? "YES" : "NO";
            objectArray[8] = table2.isTriggerDeletable() ? "YES" : "NO";
            objectArray[9] = table2.isTriggerInsertable() ? "YES" : "NO";
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table ROLE_AUTHORIZATION_DESCRIPTORS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[61];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[61]);
            this.addColumn(table, "ROLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(table, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[61].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1}, true);
            return table;
        }
        String string = "_SYSTEM";
        Iterator iterator = session.getGrantee().visibleGrantees().iterator();
        while (iterator.hasNext()) {
            String string2;
            Grantee grantee = (Grantee)iterator.next();
            String string3 = grantee.getName().getNameString();
            Iterator iterator2 = grantee.getDirectRoles().iterator();
            String string4 = string2 = grantee.isAdmin() ? "YES" : "NO";
            while (iterator2.hasNext()) {
                Grantee grantee2 = (Grantee)iterator2.next();
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = grantee2.getName().getNameString();
                objectArray[1] = string3;
                objectArray[2] = string;
                objectArray[3] = string2;
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }
}

