/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number;

import org.python.icu.impl.number.NumberStringBuilder;
import org.python.icu.text.DecimalFormatSymbols;
import org.python.icu.text.NumberFormat;

public class AffixPatternUtils {
    private static final int STATE_BASE = 0;
    private static final int STATE_FIRST_QUOTE = 1;
    private static final int STATE_INSIDE_QUOTE = 2;
    private static final int STATE_AFTER_QUOTE = 3;
    private static final int STATE_FIRST_CURR = 4;
    private static final int STATE_SECOND_CURR = 5;
    private static final int STATE_THIRD_CURR = 6;
    private static final int STATE_OVERFLOW_CURR = 7;
    private static final int TYPE_CODEPOINT = 0;
    public static final int TYPE_MINUS_SIGN = -1;
    public static final int TYPE_PLUS_SIGN = -2;
    public static final int TYPE_PERCENT = -3;
    public static final int TYPE_PERMILLE = -4;
    public static final int TYPE_CURRENCY_SINGLE = -5;
    public static final int TYPE_CURRENCY_DOUBLE = -6;
    public static final int TYPE_CURRENCY_TRIPLE = -7;
    public static final int TYPE_CURRENCY_OVERFLOW = -15;

    public static int unescapedLength(CharSequence patternString) {
        int cp;
        if (patternString == null) {
            return 0;
        }
        int state = 0;
        int length = 0;
        block9: for (int offset = 0; offset < patternString.length(); offset += Character.charCount(cp)) {
            cp = Character.codePointAt(patternString, offset);
            switch (state) {
                case 0: {
                    if (cp == 39) {
                        state = 1;
                        continue block9;
                    }
                    ++length;
                    continue block9;
                }
                case 1: {
                    if (cp == 39) {
                        ++length;
                        state = 0;
                        continue block9;
                    }
                    ++length;
                    state = 2;
                    continue block9;
                }
                case 2: {
                    if (cp == 39) {
                        state = 3;
                        continue block9;
                    }
                    ++length;
                    continue block9;
                }
                case 3: {
                    if (cp == 39) {
                        ++length;
                        state = 2;
                        continue block9;
                    }
                    ++length;
                    continue block9;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        switch (state) {
            case 1: 
            case 2: {
                throw new IllegalArgumentException("Unterminated quote: \"" + patternString + "\"");
            }
        }
        return length;
    }

    public static int escape(CharSequence input, StringBuilder output) {
        int cp;
        if (input == null) {
            return 0;
        }
        int state = 0;
        int startLength = output.length();
        block4: for (int offset = 0; offset < input.length(); offset += Character.charCount(cp)) {
            cp = Character.codePointAt(input, offset);
            switch (cp) {
                case 39: {
                    output.append("''");
                    continue block4;
                }
                case 37: 
                case 43: 
                case 45: 
                case 164: 
                case 8240: {
                    if (state == 0) {
                        output.append('\'');
                        output.appendCodePoint(cp);
                        state = 2;
                        continue block4;
                    }
                    output.appendCodePoint(cp);
                    continue block4;
                }
                default: {
                    if (state == 2) {
                        output.append('\'');
                        output.appendCodePoint(cp);
                        state = 0;
                        continue block4;
                    }
                    output.appendCodePoint(cp);
                }
            }
        }
        if (state == 2) {
            output.append('\'');
        }
        return output.length() - startLength;
    }

    public static void unescape(CharSequence affixPattern, DecimalFormatSymbols symbols, String currency1, String currency2, String currency3, String minusSign, NumberStringBuilder output) {
        if (affixPattern == null || affixPattern.length() == 0) {
            return;
        }
        if (minusSign == null) {
            minusSign = symbols.getMinusSignString();
        }
        long tag = 0L;
        block10: while (AffixPatternUtils.hasNext(tag, affixPattern)) {
            tag = AffixPatternUtils.nextToken(tag, affixPattern);
            int typeOrCp = AffixPatternUtils.getTypeOrCp(tag);
            switch (typeOrCp) {
                case -1: {
                    output.append(minusSign, NumberFormat.Field.SIGN);
                    continue block10;
                }
                case -2: {
                    output.append(symbols.getPlusSignString(), NumberFormat.Field.SIGN);
                    continue block10;
                }
                case -3: {
                    output.append(symbols.getPercentString(), NumberFormat.Field.PERCENT);
                    continue block10;
                }
                case -4: {
                    output.append(symbols.getPerMillString(), NumberFormat.Field.PERMILLE);
                    continue block10;
                }
                case -5: {
                    output.append(currency1, NumberFormat.Field.CURRENCY);
                    continue block10;
                }
                case -6: {
                    output.append(currency2, NumberFormat.Field.CURRENCY);
                    continue block10;
                }
                case -7: {
                    output.append(currency3, NumberFormat.Field.CURRENCY);
                    continue block10;
                }
                case -15: {
                    output.append("\ufffd", NumberFormat.Field.CURRENCY);
                    continue block10;
                }
            }
            output.appendCodePoint(typeOrCp, null);
        }
    }

    public static boolean containsType(CharSequence affixPattern, int type) {
        if (affixPattern == null || affixPattern.length() == 0) {
            return false;
        }
        long tag = 0L;
        while (AffixPatternUtils.hasNext(tag, affixPattern)) {
            if (AffixPatternUtils.getTypeOrCp(tag = AffixPatternUtils.nextToken(tag, affixPattern)) != type) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCurrencySymbols(CharSequence affixPattern) {
        if (affixPattern == null || affixPattern.length() == 0) {
            return false;
        }
        long tag = 0L;
        while (AffixPatternUtils.hasNext(tag, affixPattern)) {
            int typeOrCp = AffixPatternUtils.getTypeOrCp(tag = AffixPatternUtils.nextToken(tag, affixPattern));
            if (typeOrCp != -5 && typeOrCp != -6 && typeOrCp != -7 && typeOrCp != -15) continue;
            return true;
        }
        return false;
    }

    public static String replaceType(CharSequence affixPattern, int type, char replacementChar) {
        if (affixPattern == null || affixPattern.length() == 0) {
            return "";
        }
        char[] chars = affixPattern.toString().toCharArray();
        long tag = 0L;
        while (AffixPatternUtils.hasNext(tag, affixPattern)) {
            if (AffixPatternUtils.getTypeOrCp(tag = AffixPatternUtils.nextToken(tag, affixPattern)) != type) continue;
            int offset = AffixPatternUtils.getOffset(tag);
            chars[offset - 1] = replacementChar;
        }
        return new String(chars);
    }

    public static long nextToken(long tag, CharSequence patternString) {
        int offset = AffixPatternUtils.getOffset(tag);
        int state = AffixPatternUtils.getState(tag);
        block27: while (offset < patternString.length()) {
            int cp = Character.codePointAt(patternString, offset);
            int count2 = Character.charCount(cp);
            switch (state) {
                case 0: {
                    switch (cp) {
                        case 39: {
                            state = 1;
                            offset += count2;
                            continue block27;
                        }
                        case 45: {
                            return AffixPatternUtils.makeTag(offset + count2, -1, 0, 0);
                        }
                        case 43: {
                            return AffixPatternUtils.makeTag(offset + count2, -2, 0, 0);
                        }
                        case 37: {
                            return AffixPatternUtils.makeTag(offset + count2, -3, 0, 0);
                        }
                        case 8240: {
                            return AffixPatternUtils.makeTag(offset + count2, -4, 0, 0);
                        }
                        case 164: {
                            state = 4;
                            offset += count2;
                            continue block27;
                        }
                    }
                    return AffixPatternUtils.makeTag(offset + count2, 0, 0, cp);
                }
                case 1: {
                    if (cp == 39) {
                        return AffixPatternUtils.makeTag(offset + count2, 0, 0, cp);
                    }
                    return AffixPatternUtils.makeTag(offset + count2, 0, 2, cp);
                }
                case 2: {
                    if (cp == 39) {
                        state = 3;
                        offset += count2;
                        continue block27;
                    }
                    return AffixPatternUtils.makeTag(offset + count2, 0, 2, cp);
                }
                case 3: {
                    if (cp == 39) {
                        return AffixPatternUtils.makeTag(offset + count2, 0, 2, cp);
                    }
                    state = 0;
                    continue block27;
                }
                case 4: {
                    if (cp == 164) {
                        state = 5;
                        offset += count2;
                        continue block27;
                    }
                    return AffixPatternUtils.makeTag(offset, -5, 0, 0);
                }
                case 5: {
                    if (cp == 164) {
                        state = 6;
                        offset += count2;
                        continue block27;
                    }
                    return AffixPatternUtils.makeTag(offset, -6, 0, 0);
                }
                case 6: {
                    if (cp == 164) {
                        state = 7;
                        offset += count2;
                        continue block27;
                    }
                    return AffixPatternUtils.makeTag(offset, -7, 0, 0);
                }
                case 7: {
                    if (cp == 164) {
                        offset += count2;
                        continue block27;
                    }
                    return AffixPatternUtils.makeTag(offset, -15, 0, 0);
                }
            }
            throw new AssertionError();
        }
        switch (state) {
            case 0: {
                return -1L;
            }
            case 1: 
            case 2: {
                throw new IllegalArgumentException("Unterminated quote in pattern affix: \"" + patternString + "\"");
            }
            case 3: {
                return -1L;
            }
            case 4: {
                return AffixPatternUtils.makeTag(offset, -5, 0, 0);
            }
            case 5: {
                return AffixPatternUtils.makeTag(offset, -6, 0, 0);
            }
            case 6: {
                return AffixPatternUtils.makeTag(offset, -7, 0, 0);
            }
            case 7: {
                return AffixPatternUtils.makeTag(offset, -15, 0, 0);
            }
        }
        throw new AssertionError();
    }

    public static boolean hasNext(long tag, CharSequence string) {
        assert (tag >= 0L);
        int state = AffixPatternUtils.getState(tag);
        int offset = AffixPatternUtils.getOffset(tag);
        if (state == 2 && offset == string.length() - 1 && string.charAt(offset) == '\'') {
            return false;
        }
        if (state != 0) {
            return true;
        }
        return offset < string.length();
    }

    public static int getTypeOrCp(long tag) {
        assert (tag >= 0L);
        int type = AffixPatternUtils.getType(tag);
        return type == 0 ? AffixPatternUtils.getCodePoint(tag) : -type;
    }

    private static long makeTag(int offset, int type, int state, int cp) {
        long tag = 0L;
        tag |= (long)offset;
        tag |= -((long)type) << 32;
        tag |= (long)state << 36;
        assert ((tag |= (long)cp << 40) >= 0L);
        return tag;
    }

    static int getOffset(long tag) {
        return (int)(tag & 0xFFFFFFFFFFFFFFFFL);
    }

    static int getType(long tag) {
        return (int)(tag >>> 32 & 0xFL);
    }

    static int getState(long tag) {
        return (int)(tag >>> 36 & 0xFL);
    }

    static int getCodePoint(long tag) {
        return (int)(tag >>> 40);
    }
}

