/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import java.util.ArrayList;
import org.sunflow.core.AccelerationStructure;
import org.sunflow.core.AccelerationStructureFactory;
import org.sunflow.core.Camera;
import org.sunflow.core.Display;
import org.sunflow.core.ImageSampler;
import org.sunflow.core.Instance;
import org.sunflow.core.InstanceList;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.LightServer;
import org.sunflow.core.LightSource;
import org.sunflow.core.Options;
import org.sunflow.core.PhotonStore;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingCache;
import org.sunflow.core.ShadingState;
import org.sunflow.core.Statistics;
import org.sunflow.core.display.FrameDisplay;
import org.sunflow.image.Color;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.MathUtils;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class Scene {
    private LightServer lightServer = new LightServer(this);
    private InstanceList instanceList = new InstanceList();
    private InstanceList infiniteInstanceList = new InstanceList();
    private Camera camera = null;
    private AccelerationStructure intAccel;
    private String acceltype = "auto";
    private Statistics stats = new Statistics();
    private boolean bakingViewDependent = false;
    private Instance bakingInstance = null;
    private PrimitiveList bakingPrimitives = null;
    private AccelerationStructure bakingAccel = null;
    private boolean rebuildAccel = true;
    private int imageWidth = 640;
    private int imageHeight = 480;
    private int threads = 0;
    private boolean lowPriority = true;

    public int getThreads() {
        return this.threads <= 0 ? Runtime.getRuntime().availableProcessors() : this.threads;
    }

    public int getThreadPriority() {
        return this.lowPriority ? 1 : 5;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    Camera getCamera() {
        return this.camera;
    }

    public void setInstanceLists(Instance[] instanceArray, Instance[] instanceArray2) {
        this.infiniteInstanceList = new InstanceList(instanceArray2);
        this.instanceList = new InstanceList(instanceArray);
        this.rebuildAccel = true;
    }

    public void setLightList(LightSource[] lightSourceArray) {
        this.lightServer.setLights(lightSourceArray);
    }

    public void setShaderOverride(Shader shader, boolean bl) {
        this.lightServer.setShaderOverride(shader, bl);
    }

    public void setBakingInstance(Instance instance) {
        this.bakingInstance = instance;
    }

    public ShadingState getRadiance(IntersectionState intersectionState, float f, float f2, double d, double d2, double d3, int n, int n2, ShadingCache shadingCache) {
        ++intersectionState.numEyeRays;
        float f3 = this.camera.getTime((float)d3);
        if (this.bakingPrimitives == null) {
            Ray ray = this.camera.getRay(f, f2, this.imageWidth, this.imageHeight, d, d2, f3);
            return ray != null ? this.lightServer.getRadiance(f, f2, f3, n, n2, ray, intersectionState, shadingCache) : null;
        }
        Ray ray = new Ray(f / (float)this.imageWidth, f2 / (float)this.imageHeight, -1.0f, 0.0f, 0.0f, 1.0f);
        this.traceBake(ray, intersectionState);
        if (!intersectionState.hit()) {
            return null;
        }
        ShadingState shadingState = ShadingState.createState(intersectionState, f, f2, f3, ray, n, n2, this.lightServer);
        this.bakingPrimitives.prepareShadingState(shadingState);
        if (this.bakingViewDependent) {
            shadingState.setRay(this.camera.getRay(shadingState.getPoint(), f3));
        } else {
            Point3 point3 = shadingState.getPoint();
            Vector3 vector3 = shadingState.getNormal();
            Ray ray2 = new Ray(point3.x + vector3.x, point3.y + vector3.y, point3.z + vector3.z, -vector3.x, -vector3.y, -vector3.z);
            ray2.setMax(1.0f);
            shadingState.setRay(ray2);
        }
        this.lightServer.shadeBakeResult(shadingState);
        return shadingState;
    }

    public BoundingBox getBounds() {
        return this.instanceList.getWorldBounds(null);
    }

    public void accumulateStats(IntersectionState intersectionState) {
        this.stats.accumulate(intersectionState);
    }

    public void accumulateStats(ShadingCache shadingCache) {
        this.stats.accumulate(shadingCache);
    }

    void trace(Ray ray, IntersectionState intersectionState) {
        ++intersectionState.numRays;
        intersectionState.instance = null;
        intersectionState.current = null;
        for (int i = 0; i < this.infiniteInstanceList.getNumPrimitives(); ++i) {
            this.infiniteInstanceList.intersectPrimitive(ray, i, intersectionState);
        }
        intersectionState.current = null;
        this.intAccel.intersect(ray, intersectionState);
    }

    Color traceShadow(Ray ray, IntersectionState intersectionState) {
        ++intersectionState.numShadowRays;
        this.trace(ray, intersectionState);
        return intersectionState.hit() ? Color.WHITE : Color.BLACK;
    }

    void traceBake(Ray ray, IntersectionState intersectionState) {
        intersectionState.current = this.bakingInstance;
        intersectionState.instance = null;
        this.bakingAccel.intersect(ray, intersectionState);
    }

    private void createAreaLightInstances() {
        ArrayList<Instance> arrayList = null;
        ArrayList<Instance> arrayList2 = null;
        for (LightSource lightSource : this.lightServer.lights) {
            Instance instance = lightSource.createInstance();
            if (instance == null) continue;
            if (instance.getBounds() == null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Instance>();
                }
                arrayList.add(instance);
                continue;
            }
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Instance>();
            }
            arrayList2.add(instance);
        }
        if (arrayList != null && arrayList.size() > 0) {
            this.infiniteInstanceList.addLightSourceInstances(arrayList.toArray(new Instance[arrayList.size()]));
        } else {
            this.infiniteInstanceList.clearLightSources();
        }
        if (arrayList2 != null && arrayList2.size() > 0) {
            this.instanceList.addLightSourceInstances(arrayList2.toArray(new Instance[arrayList2.size()]));
        } else {
            this.instanceList.clearLightSources();
        }
        this.rebuildAccel = true;
    }

    private void removeAreaLightInstances() {
        this.infiniteInstanceList.clearLightSources();
        this.instanceList.clearLightSources();
    }

    public void render(Options options, ImageSampler imageSampler, Display display) {
        this.stats.reset();
        if (display == null) {
            display = new FrameDisplay();
        }
        if (this.bakingInstance != null) {
            UI.printDetailed(UI.Module.SCENE, "Creating primitives for lightmapping ...", new Object[0]);
            this.bakingPrimitives = this.bakingInstance.getBakingPrimitives();
            if (this.bakingPrimitives == null) {
                UI.printError(UI.Module.SCENE, "Lightmap baking is not supported for the given instance.", new Object[0]);
                return;
            }
            int n = this.bakingPrimitives.getNumPrimitives();
            UI.printInfo(UI.Module.SCENE, "Building acceleration structure for lightmapping (%d num primitives) ...", n);
            this.bakingAccel = AccelerationStructureFactory.create("auto", n, true);
            this.bakingAccel.build(this.bakingPrimitives);
        } else {
            this.bakingPrimitives = null;
            this.bakingAccel = null;
        }
        this.bakingViewDependent = options.getBoolean("baking.viewdep", this.bakingViewDependent);
        if (this.bakingInstance != null && this.bakingViewDependent && this.camera == null || this.bakingInstance == null && this.camera == null) {
            UI.printError(UI.Module.SCENE, "No camera found", new Object[0]);
            return;
        }
        this.threads = options.getInt("threads", 0);
        this.lowPriority = options.getBoolean("threads.lowPriority", true);
        this.imageWidth = options.getInt("resolutionX", 640);
        this.imageHeight = options.getInt("resolutionY", 480);
        this.imageWidth = MathUtils.clamp(this.imageWidth, 1, 16384);
        this.imageHeight = MathUtils.clamp(this.imageHeight, 1, 16384);
        this.createAreaLightInstances();
        long l = 0L;
        for (int i = 0; i < this.instanceList.getNumPrimitives(); ++i) {
            l += (long)this.instanceList.getNumPrimitives(i);
        }
        UI.printInfo(UI.Module.SCENE, "Scene stats:", new Object[0]);
        UI.printInfo(UI.Module.SCENE, "  * Infinite instances:  %d", this.infiniteInstanceList.getNumPrimitives());
        UI.printInfo(UI.Module.SCENE, "  * Instances:           %d", this.instanceList.getNumPrimitives());
        UI.printInfo(UI.Module.SCENE, "  * Primitives:          %d", l);
        String string = options.getString("accel", null);
        if (string != null) {
            this.rebuildAccel = this.rebuildAccel || !this.acceltype.equals(string);
            this.acceltype = string;
        }
        UI.printInfo(UI.Module.SCENE, "  * Instance accel:      %s", this.acceltype);
        if (this.rebuildAccel) {
            this.intAccel = AccelerationStructureFactory.create(this.acceltype, this.instanceList.getNumPrimitives(), false);
            this.intAccel.build(this.instanceList);
            this.rebuildAccel = false;
        }
        UI.printInfo(UI.Module.SCENE, "  * Scene bounds:        %s", this.getBounds());
        UI.printInfo(UI.Module.SCENE, "  * Scene center:        %s", this.getBounds().getCenter());
        UI.printInfo(UI.Module.SCENE, "  * Scene diameter:      %.2f", Float.valueOf(this.getBounds().getExtents().length()));
        Object[] objectArray = new Object[1];
        objectArray[0] = this.bakingInstance != null ? (this.bakingViewDependent ? "view" : "ortho") : "off";
        UI.printInfo(UI.Module.SCENE, "  * Lightmap bake:       %s", objectArray);
        if (imageSampler == null) {
            return;
        }
        if (!this.lightServer.build(options)) {
            return;
        }
        UI.printInfo(UI.Module.SCENE, "Rendering ...", new Object[0]);
        this.stats.setResolution(this.imageWidth, this.imageHeight);
        imageSampler.prepare(options, this, this.imageWidth, this.imageHeight);
        imageSampler.render(display);
        this.stats.displayStats();
        this.lightServer.showStats();
        this.removeAreaLightInstances();
        this.bakingPrimitives = null;
        this.bakingAccel = null;
        UI.printInfo(UI.Module.SCENE, "Done.", new Object[0]);
    }

    public boolean calculatePhotons(PhotonStore photonStore, String string, int n, Options options) {
        return this.lightServer.calculatePhotons(photonStore, string, n, options);
    }
}

