// SDB-CGEN V1.8.2
// gcc -DMAIN=1 riscv.c ; ./a.out > riscv.h
#include <ctype.h>
#include <stdio.h>
#include <string.h>

struct kv { const char *name; const char *value; };
static struct kv kvs[] = {
  {"add","add"}, 
  {"addi","add immediate"}, 
  {"addiw","add immediate to 32-bit word"}, 
  {"addw","add 32-bit words"}, 
  {"amoadd.d","atomic memory operation, add (64 bits)"}, 
  {"amoadd.w","atomic memory operation, add (32 bits)"}, 
  {"amoand.d","atomic memory operation, bitwise AND (64 bits)"}, 
  {"amoand.w","atomic memory operation, bitwise AND (32 bits)"}, 
  {"amomax.d","atomic memory operation, signed integer maximum (64 bits)"}, 
  {"amomax.w","atomic memory operation, signed integer maximum (32 bits)"}, 
  {"amomaxu.d","atomic memory operation, unsigned integer maximum (64 bits)"}, 
  {"amomaxu.w","atomic memory operation, unsigned integer maximum (32 bits)"}, 
  {"amomin.d","atomic memory operation, signed integer minimum (64 bits)"}, 
  {"amomin.w","atomic memory operation, signed integer minimum (32 bits)"}, 
  {"amominu.d","atomic memory operation, unsigned integer minimum (64 bits)"}, 
  {"amominu.w","atomic memory operation, unsigned integer minimum (32 bits)"}, 
  {"amoor.d","atomic memory operation, bitwise OR (64 bits)"}, 
  {"amoor.w","atomic memory operation, bitwise OR (32 bits)"}, 
  {"amoswap.d","atomic memory operation, swap (64 bits)"}, 
  {"amoswap.w","atomic memory operation, swap (32 bits)"}, 
  {"amoxor.d","atomic memory operation, "}, 
  {"amoxor.w","atomic memory operation, "}, 
  {"and","bitwise and"}, 
  {"andi","bitwise and with immediate"}, 
  {"auipc","add upper immediate to PC"}, 
  {"beq","branch if equal"}, 
  {"beqz","branch if equal to zero"}, 
  {"bge","branch if greater than"}, 
  {"bgeu","branch if greater than, unsigned"}, 
  {"bgez","branch if greater than or equal to zero"}, 
  {"bgt","branch if greater than"}, 
  {"bgtu","branch if greater than, unsigned"}, 
  {"bgtz","branch if greater than zero"}, 
  {"ble","branch if less than or equal to"}, 
  {"bleu","branch if less than or equal to, unsigned"}, 
  {"blez","branch if less than or equal to zero"}, 
  {"blt","branch if less than"}, 
  {"bltu","branch if less than, unsigned"}, 
  {"bltz","branch if less than zero"}, 
  {"bne","branch if not equal"}, 
  {"bnez","branch if not equal to zero"}, 
  {"c.add","add (compressed instruction)"}, 
  {"c.addi","add immediate  (compressed instruction)"}, 
  {"c.addi16sp","add signed immediate*16 to stack pointer (compressed instruction)"}, 
  {"c.addi4spn","add unsigned immediate*4 to stack pointer (compressed instruction)"}, 
  {"c.addiw","add immediate to 32-bit word (compressed instruction)"}, 
  {"c.addw","add 32-bit words (compressed instruction)"}, 
  {"c.and","bitwise AND (compressed instruction)"}, 
  {"c.andi","bitwirse AND with immediate (compressed instruction)"}, 
  {"c.beqz","branch if equal to zero (compressed instruction)"}, 
  {"c.bnez","branch if not equal to zero (compressed instruction)"}, 
  {"c.ebreak","environment breakpoint (compressed instruction)"}, 
  {"c.fld","floating-point load, double precision (compressed instruction)"}, 
  {"c.fldsp","floating-point load, double precision, SP relative (compressed instruction)"}, 
  {"c.flw","floating-point load, single precision (compressed instruction)"}, 
  {"c.flwsp","floating-point load, single precision, SP relative (compressed instruction)"}, 
  {"c.fsd","floating-point store, double precision (compressed instruction)"}, 
  {"c.fsdsp","floating-point store, double precision, SP relative (compressed instruction)"}, 
  {"c.fsw","floating-point store, single precision (compressed instruction)"}, 
  {"c.fswsp","floating-point store, single precision, SP relative (compressed instruction)"}, 
  {"c.j","jump (compressed instruction)"}, 
  {"c.jal","jump and link (compressed instruction)"}, 
  {"c.jalr","jump and link, register relative (compressed instruction)"}, 
  {"c.jr","jump, register relative (compressed instruction)"}, 
  {"c.ld","load double word (64 bits) (compressed instruction)"}, 
  {"c.ldsp","load double word (64 bits), SP relative (compressed instruction)"}, 
  {"c.li","load immediate (compressed instruction)"}, 
  {"c.lui","load upper immediate (compressed instruction)"}, 
  {"c.lw","load word (32 bits) (compressed instruction)"}, 
  {"c.lwsp","load word (32 bits), SP relative (compressed instruction)"}, 
  {"c.mv","move (compressed instruction)"}, 
  {"c.or","bitwise OR (compressed instruction)"}, 
  {"c.sd","store double word (64 bits) (compressed instruction)"}, 
  {"c.sdsp","store double word (64 bits), SP relative (compressed instruction)"}, 
  {"c.slli","logical left shift by immediate (compressed instruction)"}, 
  {"c.srai","shift right arithmetically by immediate (compressed instruction)"}, 
  {"c.srli","shift right logically by immediate (compressed instruction)"}, 
  {"c.sub","subtract (compressed instruction)"}, 
  {"c.subw","subtract words (32 bits) (compressed instruction)"}, 
  {"c.sw","store word (32 bits) (compressed instruction)"}, 
  {"c.swsp","store word (32 bits), SP relative (compressed instruction)"}, 
  {"c.xor","exclusive OR (compressed instruction)"}, 
  {"csrrc","atomic read and clear bit in CSR"}, 
  {"csrrci","atomic read and clear immediate bit in CSR"}, 
  {"csrrs","atomic read and set bit in CSR"}, 
  {"csrrsi","atomic read and set immediate bit in CSR"}, 
  {"csrrw","atomic read/write CSR"}, 
  {"csrrwi","atomic read/write CSR with immediate"}, 
  {"div","signed division"}, 
  {"divu","unsigned division"}, 
  {"divuw","unsigned division of words (32 bits)"}, 
  {"divw","signed division of words (32 bits)"}, 
  {"ebreak","environment breakpoint"}, 
  {"ecall","environment call"}, 
  {"eret","environment return"}, 
  {"fadd.d","floating-point add, double precision"}, 
  {"fadd.s","floating-point add, single precision"}, 
  {"fclass.d","classify floating point number, double precision"}, 
  {"fclass.s","classify floating point number, single precision"}, 
  {"fcvt.d.l","convert to double from long (64 bits)"}, 
  {"fcvt.d.lu","convert to double from unsigned long (64 bits)"}, 
  {"fcvt.d.s","convert to double from single"}, 
  {"fcvt.d.w","convert to double from word (32 bits)"}, 
  {"fcvt.d.wu","convert to double from unsigned word (32 bits)"}, 
  {"fcvt.l.d","convert to long (64 bits) from double"}, 
  {"fcvt.l.s","convert to long (64 bits) from single"}, 
  {"fcvt.lu.d","convert to unsigned long (64 bits) from double"}, 
  {"fcvt.lu.s","convert to unsigned long (64 bits) from single"}, 
  {"fcvt.s.d","convert to single from double"}, 
  {"fcvt.s.l","convert to single from long (64 bits)"}, 
  {"fcvt.s.lu","convert to single from unsigned long (64 bits)"}, 
  {"fcvt.s.w","convert to single from word (32 bits)"}, 
  {"fcvt.s.wu","convert to single from unsigned word (32 bits)"}, 
  {"fcvt.w.d","convert to word (32 bits) from double"}, 
  {"fcvt.w.s","convert to word (32 bits) from single"}, 
  {"fcvt.wu.d","convert to unsigned word (32 bits) from double"}, 
  {"fcvt.wu.s","convert to unsigned word (32 bits) from single"}, 
  {"fdiv.d","floating-point division, double precision"}, 
  {"fdiv.s","floating-point division, single precision"}, 
  {"fence","memory fence"}, 
  {"fence.i","instruction cache fence"}, 
  {"feq.d","floating-point \""}, 
  {"feq.s","floating-point \""}, 
  {"fld","floating-point load double"}, 
  {"fle.d","floating-point \""}, 
  {"fle.s","floating-point \""}, 
  {"flt.d","floating-point \""}, 
  {"flt.s","floating-point \""}, 
  {"flw","floating-point load word"}, 
  {"fmadd.d","floating-point multiply-add, double precision"}, 
  {"fmadd.s","floating-point multiply-add, single precision"}, 
  {"fmax.d","floating-point maximum, double precision"}, 
  {"fmax.s","floating-point maximum, single precision"}, 
  {"fmin.d","floating-point minimum, double precision"}, 
  {"fmin.s","floating-point minimum, single precision"}, 
  {"fmsub.d","floating-point multiply-subtract, double precision"}, 
  {"fmsub.s","floating-point multiply-subtract, single precision"}, 
  {"fmul.d","floating-point multiply, double precision"}, 
  {"fmul.s","floating-point multiply, single precision"}, 
  {"fmv.d.x","move double to integer register"}, 
  {"fmv.s.x","move single to integer register"}, 
  {"fmv.x.d","move integer register to double"}, 
  {"fmv.x.s","move integer register to double"}, 
  {"fnmadd.d","floating-point negated multiply-add, double precision"}, 
  {"fnmadd.s","floating-point negated multiply-add, single precision"}, 
  {"fnmsub.d","floating-point negated multiply-subtract, double precision"}, 
  {"fnmsub.s","floating-point negated multiply-subtract, single precision"}, 
  {"fsd","floating-point store double"}, 
  {"fsgnj.d","floating-point sign-injection, double precision"}, 
  {"fsgnj.s","floating-point sign-injection, single precision"}, 
  {"fsgnjn.d","floating-point negated sign-injection, double precision"}, 
  {"fsgnjn.s","floating-point negated sign-injection, single precision"}, 
  {"fsgnjx.d","floating-point XOR sign-injection, double precision"}, 
  {"fsgnjx.s","floating-point XOR sign-injection, single precision"}, 
  {"fsqrt.d","floating-point square root, double precision"}, 
  {"fsqrt.s","floating-point square root, single precision"}, 
  {"fsub.d","floating-point subtract, double precision"}, 
  {"fsub.s","floating-point subtract, single precision"}, 
  {"fsw","floating-point store word (single precision value)"}, 
  {"hrts","hypervisor redirect trap to supervisor"}, 
  {"j","jump"}, 
  {"jal","jump and link (call)"}, 
  {"jalr","jump and link (call); register-based"}, 
  {"jr","jump register"}, 
  {"lb","load byte"}, 
  {"lbu","load byte, unsigned"}, 
  {"ld","load double word (64 bits)"}, 
  {"lh","load half-word (16 bits)"}, 
  {"lhu","load half-word (16 bits), unsigned"}, 
  {"li","load immediate"}, 
  {"lr","load reserved"}, 
  {"lr.d","load reserved (64 bits)"}, 
  {"lr.w","load reserved (32 bits)"}, 
  {"lui","load upper immediate"}, 
  {"lw","load word (32 bits)"}, 
  {"lwu","load word (32 bits) unsigned"}, 
  {"mrth","machine redirect trap to hypervisor"}, 
  {"mrts","machine redirect trap to supervisor"}, 
  {"mul","multiply"}, 
  {"mulh","multiply, high half"}, 
  {"mulhsu","multiply signed*unsigned, high half"}, 
  {"mulhu","multiply unsigned, high half"}, 
  {"mulw","multiply word (32 bits)"}, 
  {"mv","copy"}, 
  {"neg","two's complement"}, 
  {"negw","two's complement word"}, 
  {"nop","no operation"}, 
  {"not","one's complement"}, 
  {"or","bitwise OR"}, 
  {"ori","bitwise OR with immediate"}, 
  {"rdcycle","read cycle counter"}, 
  {"rdcycleh","read cycle counter, high half"}, 
  {"rdinstret","read \""}, 
  {"rdinstreth","read \""}, 
  {"rdtime","read real-time clock"}, 
  {"rdtimeh","read real-time clock, high half"}, 
  {"rem","remainder of division"}, 
  {"remu","remainder of unsigned division"}, 
  {"remuw","remainder of unsigned division (32 bits)"}, 
  {"remw","remainder of division (32 bits)"}, 
  {"sb","store byte"}, 
  {"sc","store conditional"}, 
  {"sc.d","store conditional (64 bits)"}, 
  {"sc.w","store conditional (32 bits)"}, 
  {"sd","store double word (64 bits)"}, 
  {"seqz","set if equal to zero"}, 
  {"sfence.vm","supervisor-mode fence for virtual memory"}, 
  {"sgtz","set if greater than zero"}, 
  {"sh","store half-word (16 bits)"}, 
  {"sll","shift left logically"}, 
  {"slli","shift left logically by immediate"}, 
  {"slliw","shift left logically by immediate (32 bits)"}, 
  {"sllw","shift left logically (32 bits)"}, 
  {"slt","set if less than"}, 
  {"slti","set if less than immediate"}, 
  {"sltiu","set if less than immediate, unsigned"}, 
  {"sltu","set if less than, unsigned"}, 
  {"sltz","set if less than zero"}, 
  {"snez","set if not equal to zero"}, 
  {"sra","shift right arithmetically"}, 
  {"srai","shift right arithmetically by immediate"}, 
  {"sraiw","shift right arithmetically by immediate (32 bits)"}, 
  {"sraw","shift right arithmetically (32 bits)"}, 
  {"srl","shift right logically"}, 
  {"srli","shift right logically by immediate"}, 
  {"srliw","shift right logically by immediate (32 bits)"}, 
  {"srlw","shift right logically (32 bits)"}, 
  {"sub","subtract"}, 
  {"subw","subtract word (32 bits)"}, 
  {"sw","store word (32 bits)"}, 
  {"wfi","wait for interrupt"}, 
  {"xor","exclusive or"}, 
  {"xori","exclusive or with immediate"}, 
  {NULL, NULL}
};
// 0xaaab0c6a8550
// TODO
typedef int (*GperfForeachCallback)(void *user, const char *k, const char *v);
int gperf_riscv_foreach(GperfForeachCallback cb, void *user) {
  int i = 0; while (kvs[i].name) {
  cb (user, kvs[i].name, kvs[i].value);
  i++;}
  return 0;
}
const char *gperf_riscv_get(const char *s) {
  int i = 0; while (kvs[i].name) {
  if (!strcmp (s, kvs[i].name)) return kvs[i].value;
  i++;}
  return NULL;
}
#define sdb_hash_c_riscv(x,y) gperf_riscv_hash(x)
const unsigned int gperf_riscv_hash(const char *s) {
  int sum = strlen (s);
  while (*s) { sum += *s; s++; }
  return sum;
}
struct {const char *name;void *get;void *hash;void *foreach;} gperf_riscv = {
  .name = "riscv",
  .get = &gperf_riscv_get,
  .hash = &gperf_riscv_hash,
  .foreach = &gperf_riscv_foreach
};

#if MAIN
int main () {
	const char *s = ((char*(*)(char*))gperf_riscv.get)("foo");
	printf ("%s\n", s);
}
#endif
