/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.FullScreenAdapter;
import com.apple.eawt.FullScreenListener;
import com.apple.eawt.FullScreenUtilities;
import com.eteks.sweethome3d.SweetHome3D;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.HomePane;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.HomeView;
import com.sun.j3d.exp.swing.JCanvas3D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.desktop.QuitStrategy;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.media.j3d.Canvas3D;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputAdapter;

class MacOSXConfiguration {
    private static boolean fullScreen;

    private MacOSXConfiguration() {
    }

    public static boolean isScreenMenuBarSupported() {
        if (OperatingSystem.isJavaVersionGreaterOrEqual("1.9")) {
            try {
                Class<?> clazz = Class.forName("java.awt.Desktop");
                Object object = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                Class<?> clazz2 = Class.forName("java.awt.Desktop$Action");
                return (Boolean)clazz.getMethod("isSupported", clazz2).invoke(object, clazz2.getField("APP_ABOUT").get(null));
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return Application.getApplication().isAboutMenuItemPresent();
    }

    public static void bindToApplicationMenu(final SweetHome3D sweetHome3D) {
        Object object;
        Object object2;
        Serializable serializable;
        Application application = Application.getApplication();
        final HomeController homeController = sweetHome3D.createHomeFrameController(sweetHome3D.createHome()).getHomeController();
        final HomePane homePane = (HomePane)homeController.getView();
        MacOSXConfiguration.setDefaultActionsEnabled(homePane, false);
        JMenuBar jMenuBar = homePane.getJMenuBar();
        JFrame jFrame = null;
        if (Boolean.getBoolean("apple.laf.useScreenMenuBar")) {
            if (OperatingSystem.isJavaVersionBetween("1.7", "1.7.0_60")) {
                jFrame = MacOSXConfiguration.createDummyFrameWithDefaultMenuBar(sweetHome3D, homePane, jMenuBar);
            } else if (UIManager.getLookAndFeel().getClass().getName().equals(UIManager.getSystemLookAndFeelClassName())) {
                try {
                    if (OperatingSystem.isJavaVersionGreaterOrEqual("1.9")) {
                        serializable = Class.forName("java.awt.Desktop");
                        Object object3 = ((Class)serializable).getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                        ((Class)serializable).getMethod("setDefaultMenuBar", JMenuBar.class).invoke(object3, jMenuBar);
                    } else {
                        application.setDefaultMenuBar(jMenuBar);
                    }
                    MacOSXConfiguration.addWindowMenu(null, jMenuBar, sweetHome3D, homePane, null);
                }
                catch (Throwable throwable) {
                    jFrame = MacOSXConfiguration.createDummyFrameWithDefaultMenuBar(sweetHome3D, homePane, jMenuBar);
                }
            }
        }
        serializable = jFrame;
        boolean bl = false;
        try {
            application.getClass().getMethod("addApplicationListener", Class.forName("com.apple.eawt.ApplicationListener")).invoke((Object)application, MacOSXApplicationListener.class.getConstructor(SweetHome3D.class, HomeController.class, JFrame.class).newInstance(sweetHome3D, homeController, serializable));
            application.setEnabledAboutMenu(true);
            application.setEnabledPreferencesMenu(true);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        if (!bl && OperatingSystem.isJavaVersionGreaterOrEqual("1.9")) {
            try {
                object2 = Class.forName("java.awt.Desktop");
                object = ((Class)object2).getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                QuitHandler quitHandler = new QuitHandler(){
                    final /* synthetic */ JFrame val$defaultFrame;
                    {
                        this.val$defaultFrame = jFrame;
                    }

                    @Override
                    public void handleQuitRequestWith(QuitEvent quitEvent, QuitResponse quitResponse) {
                        MacOSXConfiguration.handleQuit(sweetHome3D, homeController, this.val$defaultFrame);
                        quitResponse.cancelQuit();
                    }
                };
                ((Class)object2).getMethod("setQuitHandler", QuitHandler.class).invoke(object, quitHandler);
                AboutHandler aboutHandler = new AboutHandler(){
                    final /* synthetic */ JFrame val$defaultFrame;
                    {
                        this.val$defaultFrame = jFrame;
                    }

                    @Override
                    public void handleAbout(AboutEvent aboutEvent) {
                        MacOSXConfiguration.handleAbout(sweetHome3D, homeController, this.val$defaultFrame);
                    }
                };
                ((Class)object2).getMethod("setAboutHandler", AboutHandler.class).invoke(object, aboutHandler);
                PreferencesHandler preferencesHandler = new PreferencesHandler(){
                    final /* synthetic */ JFrame val$defaultFrame;
                    {
                        this.val$defaultFrame = jFrame;
                    }

                    @Override
                    public void handlePreferences(PreferencesEvent preferencesEvent) {
                        MacOSXConfiguration.handlePreferences(sweetHome3D, homeController, this.val$defaultFrame);
                    }
                };
                ((Class)object2).getMethod("setPreferencesHandler", PreferencesHandler.class).invoke(object, preferencesHandler);
                OpenFilesHandler openFilesHandler = new OpenFilesHandler(){

                    @Override
                    public void openFiles(OpenFilesEvent openFilesEvent) {
                        for (File file : openFilesEvent.getFiles()) {
                            MacOSXConfiguration.handleOpenFile(sweetHome3D, file.getAbsolutePath());
                        }
                    }
                };
                ((Class)object2).getMethod("setOpenFileHandler", OpenFilesHandler.class).invoke(object, openFilesHandler);
                ((Class)object2).getMethod("setQuitStrategy", QuitStrategy.class).invoke(object, new Object[]{QuitStrategy.CLOSE_ALL_WINDOWS});
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        sweetHome3D.addHomesListener(new CollectionListener<Home>(){
            final /* synthetic */ JFrame val$defaultFrame;
            {
                this.val$defaultFrame = jFrame;
            }

            @Override
            public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    final JFrame jFrame = sweetHome3D.getHomeFrame(collectionEvent.getItem());
                    if (!Boolean.getBoolean("com.eteks.sweethome3d.no3D") && !OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
                        jFrame.setResizable(false);
                        Executors.newSingleThreadExecutor().submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    final AtomicBoolean atomicBoolean = new AtomicBoolean();
                                    do {
                                        Thread.sleep(50L);
                                        EventQueue.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                atomicBoolean.set(jFrame.isShowing() && this.isParentOfCanvas3D(jFrame, new Class[]{Canvas3D.class, JCanvas3D.class}));
                                            }
                                        });
                                    } while (!atomicBoolean.get());
                                }
                                catch (InterruptedException interruptedException) {
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            jFrame.setResizable(true);
                                        }
                                    });
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    try {
                                        invocationTargetException.printStackTrace();
                                    }
                                    catch (Throwable throwable) {
                                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                        throw throwable;
                                    }
                                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                }
                                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }

                            private boolean isParentOfCanvas3D(Container container, Class<?> ... classArray) {
                                for (int i = 0; i < container.getComponentCount(); ++i) {
                                    Component component = container.getComponent(i);
                                    for (Class<?> clazz : classArray) {
                                        if (!clazz.isInstance(component) && (!(component instanceof Container) || !this.isParentOfCanvas3D((Container)component, classArray))) continue;
                                        return true;
                                    }
                                }
                                if (container instanceof Window) {
                                    for (Window window : ((Window)container).getOwnedWindows()) {
                                        if (!this.isParentOfCanvas3D(window, classArray)) continue;
                                        return true;
                                    }
                                }
                                return false;
                            }
                        });
                    }
                    MacOSXConfiguration.addWindowMenu(jFrame, jFrame.getJMenuBar(), sweetHome3D, homePane, collectionEvent.getItem());
                    if (OperatingSystem.isJavaVersionBetween("1.7", "1.7.0_60")) {
                        jFrame.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent windowEvent) {
                                if (val$defaultFrame != null) {
                                    List<Home> list = sweetHome3D.getHomes();
                                    val$defaultFrame.setVisible(false);
                                    val$defaultFrame.setVisible(true);
                                    if (list.size() > 0) {
                                        sweetHome3D.getHomeFrame(list.get(0)).toFront();
                                        val$defaultFrame.setVisible(false);
                                    }
                                }
                            }
                        });
                    }
                    jFrame.addWindowStateListener(new WindowStateListener(){

                        @Override
                        public void windowStateChanged(WindowEvent windowEvent) {
                            MacOSXConfiguration.enableDefaultActions(sweetHome3D, homePane);
                        }
                    });
                    MacOSXConfiguration.setDefaultActionsEnabled(homePane, false);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    MacOSXConfiguration.enableDefaultActions(sweetHome3D, homePane);
                }
            }
        });
        if (!Boolean.getBoolean("sweethome3d.bundle")) {
            try {
                object2 = sweetHome3D.getUserPreferences().getLocalizedString(HomePane.class, "about.icon", new Object[0]);
                object = ImageIO.read(HomePane.class.getResource((String)object2));
                application.setDockIconImage((Image)object);
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void handleQuit(final SweetHome3D sweetHome3D, final HomeController homeController, final JFrame jFrame) {
        Home home = null;
        int n = 0;
        for (Home home2 : sweetHome3D.getHomes()) {
            if (!home2.isModified()) continue;
            home = home2;
            ++n;
        }
        if (n == 1) {
            sweetHome3D.getHomeFrame(home).toFront();
            sweetHome3D.getHomeFrameController(home).getHomeController().close(new Runnable(){

                @Override
                public void run() {
                    for (Home home : sweetHome3D.getHomes()) {
                        if (!home.isModified()) continue;
                        return;
                    }
                    System.exit(0);
                }
            });
        } else {
            MacOSXConfiguration.handleApplicationMenuAction(new Runnable(){

                @Override
                public void run() {
                    MacOSXConfiguration.getActiveHomeController(sweetHome3D, homeController, jFrame).exit();
                }
            }, jFrame);
            if (sweetHome3D.getHomes().isEmpty()) {
                System.exit(0);
            }
        }
    }

    protected static void handleAbout(final SweetHome3D sweetHome3D, final HomeController homeController, final JFrame jFrame) {
        MacOSXConfiguration.handleApplicationMenuAction(new Runnable(){

            @Override
            public void run() {
                MacOSXConfiguration.getActiveHomeController(sweetHome3D, homeController, jFrame).about();
            }
        }, jFrame);
    }

    private static void handlePreferences(final SweetHome3D sweetHome3D, final HomeController homeController, final JFrame jFrame) {
        MacOSXConfiguration.handleApplicationMenuAction(new Runnable(){

            @Override
            public void run() {
                MacOSXConfiguration.getActiveHomeController(sweetHome3D, homeController, jFrame).editPreferences();
            }
        }, jFrame);
    }

    private static void handleOpenFile(SweetHome3D sweetHome3D, String string) {
        sweetHome3D.start(new String[]{"-open", string});
    }

    private static void handleReOpenApplication(SweetHome3D sweetHome3D) {
        sweetHome3D.start(new String[0]);
    }

    private static void handleApplicationMenuAction(Runnable runnable, JFrame jFrame) {
        Application application = Application.getApplication();
        Frame frame = MacOSXConfiguration.getActiveFrame(jFrame);
        if (jFrame != null && frame == null) {
            jFrame.setLocationRelativeTo(null);
            jFrame.toFront();
            jFrame.setAlwaysOnTop(true);
        }
        try {
            application.setEnabledAboutMenu(false);
            application.setEnabledPreferencesMenu(false);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        runnable.run();
        try {
            application.setEnabledAboutMenu(true);
            application.setEnabledPreferencesMenu(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (frame != null) {
            frame.toFront();
        }
        if (jFrame != null && frame == null) {
            jFrame.setAlwaysOnTop(false);
            jFrame.toBack();
            jFrame.setLocation(-10, 0);
        }
    }

    private static HomeController getActiveHomeController(SweetHome3D sweetHome3D, HomeController homeController, JFrame jFrame) {
        Frame frame;
        if (jFrame != null && (frame = MacOSXConfiguration.getActiveFrame(jFrame)) != null) {
            for (Home home : sweetHome3D.getHomes()) {
                if (sweetHome3D.getHomeFrame(home) != frame) continue;
                return sweetHome3D.getHomeFrameController(home).getHomeController();
            }
        }
        return homeController;
    }

    private static Frame getActiveFrame(JFrame jFrame) {
        Frame frame = null;
        for (Frame frame2 : Frame.getFrames()) {
            if (frame2 == jFrame || !frame2.isActive()) continue;
            frame = frame2;
            break;
        }
        return frame;
    }

    private static void enableDefaultActions(SweetHome3D sweetHome3D, HomePane homePane) {
        for (Home home : sweetHome3D.getHomes()) {
            if ((sweetHome3D.getHomeFrame(home).getState() & 1) != 0) continue;
            MacOSXConfiguration.setDefaultActionsEnabled(homePane, false);
            return;
        }
        MacOSXConfiguration.setDefaultActionsEnabled(homePane, true);
    }

    private static void setDefaultActionsEnabled(HomePane homePane, boolean bl) {
        block3: for (HomeView.ActionType actionType : HomeView.ActionType.values()) {
            switch (actionType) {
                case ABOUT: 
                case NEW_HOME: 
                case NEW_HOME_FROM_EXAMPLE: 
                case OPEN: 
                case DELETE_RECENT_HOMES: 
                case HELP: {
                    homePane.setEnabled(actionType, bl);
                    continue block3;
                }
                default: {
                    homePane.setEnabled(actionType, false);
                }
            }
        }
    }

    private static JFrame createDummyFrameWithDefaultMenuBar(final SweetHome3D sweetHome3D, final HomePane homePane, final JMenuBar jMenuBar) {
        final JFrame jFrame = new JFrame();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                jFrame.setLocation(-10, 0);
                jFrame.setUndecorated(true);
                jFrame.setBackground(new Color(0, 0, 0, 0));
                jFrame.setVisible(true);
                jFrame.setJMenuBar(jMenuBar);
                jFrame.setContentPane(homePane);
                MacOSXConfiguration.addWindowMenu(jFrame, jMenuBar, sweetHome3D, homePane, null);
            }
        });
        sweetHome3D.addHomesListener(new CollectionListener<Home>(){

            @Override
            public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            List<Home> list;
                            if (jFrame.isActive() && (list = sweetHome3D.getHomes()).size() >= 1) {
                                sweetHome3D.getHomeFrame(list.get(list.size() - 1)).requestFocus();
                            }
                        }
                    });
                }
            }
        });
        return jFrame;
    }

    private static void addWindowMenu(final JFrame jFrame, JMenuBar jMenuBar, final SweetHome3D sweetHome3D, HomePane homePane, final Home home) {
        UserPreferences userPreferences = sweetHome3D.getUserPreferences();
        final JMenu jMenu = new JMenu(new ResourceAction(userPreferences, MacOSXConfiguration.class, "WINDOW_MENU", true));
        boolean bl = home != null;
        jMenuBar.add((Component)jMenu, jMenuBar.getComponentCount() - 1);
        jMenu.add(new JMenuItem(new ResourceAction(userPreferences, MacOSXConfiguration.class, "MINIMIZE", bl){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setState(1);
            }
        }));
        jMenu.add(new JMenuItem(new ResourceAction(userPreferences, MacOSXConfiguration.class, "ZOOM", bl){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ((jFrame.getExtendedState() & 6) != 0) {
                    jFrame.setExtendedState(jFrame.getExtendedState() & 0xFFFFFFF9);
                } else {
                    jFrame.setExtendedState(jFrame.getExtendedState() | 6);
                }
            }
        }));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(new ResourceAction(userPreferences, MacOSXConfiguration.class, "BRING_ALL_TO_FRONT", bl){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setAlwaysOnTop(true);
                for (Home home : sweetHome3D.getHomes()) {
                    JFrame jFrame2 = sweetHome3D.getHomeFrame(home);
                    if (jFrame2 == jFrame || jFrame2.getState() == 1) continue;
                    jFrame2.setFocusableWindowState(false);
                    jFrame2.toFront();
                    jFrame2.setFocusableWindowState(true);
                }
                jFrame.setAlwaysOnTop(false);
            }
        }));
        final int n = jMenu.getMenuComponentCount();
        jMenu.addSeparator();
        List<Home> list = sweetHome3D.getHomes();
        for (int i = 0; i < list.size(); ++i) {
            jMenu.add(MacOSXConfiguration.createWindowCheckBoxMenuItem(sweetHome3D, i));
        }
        sweetHome3D.addHomesListener(new CollectionListener<Home>(){

            @Override
            public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                switch (collectionEvent.getType()) {
                    case ADD: {
                        jMenu.add(MacOSXConfiguration.createWindowCheckBoxMenuItem(sweetHome3D, sweetHome3D.getHomes().size() - 1));
                        break;
                    }
                    case DELETE: {
                        jMenu.remove(jMenu.getMenuComponentCount() - 1);
                        if (home != collectionEvent.getItem()) break;
                        sweetHome3D.removeHomesListener(this);
                    }
                }
            }
        });
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                List<Home> list = sweetHome3D.getHomes();
                jMenu.getMenuComponent(n).setVisible(list.size() > 0);
                int n3 = n + 1;
                int n2 = 0;
                while (n3 < jMenu.getMenuComponentCount()) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenu.getMenuComponent(n3);
                    JFrame jFrame2 = sweetHome3D.getHomeFrame(list.get(n2));
                    jCheckBoxMenuItem.setText(jFrame2.getTitle());
                    jCheckBoxMenuItem.setSelected(jFrame == jFrame2);
                    ++n3;
                    ++n2;
                }
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
    }

    private static JCheckBoxMenuItem createWindowCheckBoxMenuItem(final SweetHome3D sweetHome3D, final int n) {
        return new JCheckBoxMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                sweetHome3D.getHomeFrame(sweetHome3D.getHomes().get(n)).toFront();
            }
        });
    }

    public static void installToolBar(final JRootPane jRootPane) {
        List<JToolBar> list = SwingTools.findChildren(jRootPane, JToolBar.class);
        if (list.size() == 1) {
            JToolBar jToolBar;
            jToolBar.setFloatable((jToolBar = list.get(0)).isFloatable() && jToolBar.getComponentOrientation().isLeftToRight());
            if (OperatingSystem.isJavaVersionGreaterOrEqual("1.7.0_12")) {
                JComponent jComponent;
                jToolBar.setFloatable(false);
                jRootPane.putClientProperty("apple.awt.brushMetalLook", true);
                final boolean bl = OperatingSystem.isMacOSXBigSurOrSuperior() && OperatingSystem.isJavaVersionGreaterOrEqual("15");
                jToolBar.setBorder(new AbstractBorder(){
                    private final Color TOP_GRADIENT_COLOR_ACTIVATED_FRAME;
                    private final Color BOTTOM_GRADIENT_COLOR_ACTIVATED_FRAME;
                    private final Color TOP_GRADIENT_COLOR_DEACTIVATED_FRAME;
                    private final Color BOTTOM_GRADIENT_COLOR_DEACTIVATED_FRAME;
                    private final int INSETS_TOP;
                    private final int INSETS_BOTTOM;
                    {
                        Color color = bl ? new Color(245, 245, 245) : (this.TOP_GRADIENT_COLOR_ACTIVATED_FRAME = OperatingSystem.isMacOSXYosemiteOrSuperior() ? new Color(212, 212, 212) : new Color(222, 222, 222));
                        this.BOTTOM_GRADIENT_COLOR_ACTIVATED_FRAME = bl ? this.TOP_GRADIENT_COLOR_ACTIVATED_FRAME : (OperatingSystem.isMacOSXYosemiteOrSuperior() ? new Color(209, 209, 209) : new Color(178, 178, 178));
                        this.TOP_GRADIENT_COLOR_DEACTIVATED_FRAME = bl ? new Color(242, 242, 242) : new Color(244, 244, 244);
                        this.BOTTOM_GRADIENT_COLOR_DEACTIVATED_FRAME = bl ? this.TOP_GRADIENT_COLOR_DEACTIVATED_FRAME : this.TOP_GRADIENT_COLOR_ACTIVATED_FRAME;
                        this.INSETS_TOP = OperatingSystem.isMacOSXBigSurOrSuperior() ? 0 : -4;
                        this.INSETS_BOTTOM = OperatingSystem.isMacOSXBigSurOrSuperior() ? -2 : 0;
                    }

                    @Override
                    public boolean isBorderOpaque() {
                        return true;
                    }

                    @Override
                    public Insets getBorderInsets(Component component) {
                        return new Insets(this.INSETS_TOP, 4, this.INSETS_BOTTOM, 4);
                    }

                    @Override
                    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                        Component component2 = SwingUtilities.getRoot(jRootPane);
                        boolean bl2 = ((JFrame)component2).isActive();
                        ((Graphics2D)graphics).setPaint(new GradientPaint(0.0f, n2, bl2 ? this.TOP_GRADIENT_COLOR_ACTIVATED_FRAME : this.TOP_GRADIENT_COLOR_DEACTIVATED_FRAME, 0.0f, n2 + n4 - 1, bl2 ? this.BOTTOM_GRADIENT_COLOR_ACTIVATED_FRAME : this.BOTTOM_GRADIENT_COLOR_DEACTIVATED_FRAME));
                        graphics.fillRect(n, n2, n + n3, n2 + n4);
                    }
                });
                final MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
                    private Point lastLocation;

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        this.lastLocation = mouseEvent.getPoint();
                        SwingUtilities.convertPointToScreen(this.lastLocation, mouseEvent.getComponent());
                    }

                    @Override
                    public void mouseDragged(MouseEvent mouseEvent) {
                        Point point = mouseEvent.getPoint();
                        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                        Component component = SwingUtilities.getRoot(jRootPane);
                        component.setLocation(component.getX() + point.x - this.lastLocation.x, component.getY() + point.y - this.lastLocation.y);
                        this.lastLocation = point;
                    }
                };
                jToolBar.addMouseListener(mouseInputAdapter);
                jToolBar.addMouseMotionListener(mouseInputAdapter);
                jToolBar.addAncestorListener(new AncestorListener(){
                    private Object fullScreenListener;

                    @Override
                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                        ((Window)SwingUtilities.getRoot(jToolBar)).addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowActivated(WindowEvent windowEvent) {
                                jToolBar.repaint();
                            }

                            @Override
                            public void windowDeactivated(WindowEvent windowEvent) {
                                jToolBar.repaint();
                            }
                        });
                        jToolBar.repaint();
                        try {
                            Class<?> clazz = Class.forName("com.apple.eawt.FullScreenUtilities");
                            this.fullScreenListener = new FullScreenAdapter(){

                                public void windowEnteredFullScreen(AppEvent.FullScreenEvent fullScreenEvent) {
                                    fullScreen = true;
                                    jToolBar.removeMouseListener(mouseInputAdapter);
                                    jToolBar.removeMouseMotionListener(mouseInputAdapter);
                                }

                                public void windowExitedFullScreen(AppEvent.FullScreenEvent fullScreenEvent) {
                                    fullScreen = false;
                                    jToolBar.addMouseListener(mouseInputAdapter);
                                    jToolBar.addMouseMotionListener(mouseInputAdapter);
                                }
                            };
                            FullScreenUtilities.addFullScreenListenerTo((Window)((Window)SwingUtilities.getRoot(jRootPane)), (FullScreenListener)((FullScreenListener)this.fullScreenListener));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                        jToolBar.removeAncestorListener(this);
                        try {
                            Class<?> clazz = Class.forName("com.apple.eawt.FullScreenUtilities");
                            FullScreenUtilities.removeFullScreenListenerFrom((Window)((Window)SwingUtilities.getRoot(jRootPane)), (FullScreenListener)((FullScreenListener)this.fullScreenListener));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                });
                List<JSplitPane> list2 = SwingTools.findChildren((JComponent)jToolBar.getParent(), JSplitPane.class);
                if (list2.size() >= 1 && (jComponent = (JComponent)list2.get(0)).getParent() == jToolBar.getParent()) {
                    Border border = jComponent.getBorder();
                    final Insets insets = border.getBorderInsets(jComponent);
                    final Insets insets2 = new Insets(1, 0, 0, 0);
                    jComponent.setBorder(new CompoundBorder(border, new AbstractBorder(){

                        @Override
                        public Insets getBorderInsets(Component component) {
                            return insets2;
                        }

                        @Override
                        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                            Color color = component.getBackground();
                            graphics.setColor(color);
                            graphics.fillRect(n, n2, n3, 1);
                            graphics.fillRect(n - insets.left, n2, insets.left, n4 + insets.bottom);
                            graphics.fillRect(n + n3, n2, insets.right, n4 + insets.bottom);
                            graphics.fillRect(n, n2 + n4, n3, insets.bottom);
                        }
                    }));
                }
            }
        }
    }

    public static boolean isWindowFullScreen(JFrame jFrame) {
        return fullScreen;
    }

    private static class MacOSXApplicationListener
    extends ApplicationAdapter {
        private final JFrame defaultFrame;
        private final SweetHome3D homeApplication;
        private final HomeController defaultController;

        public MacOSXApplicationListener(SweetHome3D sweetHome3D, HomeController homeController, JFrame jFrame) {
            this.defaultFrame = jFrame;
            this.homeApplication = sweetHome3D;
            this.defaultController = homeController;
        }

        public void handleQuit(ApplicationEvent applicationEvent) {
            MacOSXConfiguration.handleQuit(this.homeApplication, this.defaultController, this.defaultFrame);
        }

        public void handleAbout(ApplicationEvent applicationEvent) {
            MacOSXConfiguration.handleAbout(this.homeApplication, this.defaultController, this.defaultFrame);
            applicationEvent.setHandled(true);
        }

        public void handlePreferences(ApplicationEvent applicationEvent) {
            MacOSXConfiguration.handlePreferences(this.homeApplication, this.defaultController, this.defaultFrame);
        }

        public void handleOpenFile(ApplicationEvent applicationEvent) {
            MacOSXConfiguration.handleOpenFile(this.homeApplication, applicationEvent.getFilename());
        }

        public void handleReOpenApplication(ApplicationEvent applicationEvent) {
            MacOSXConfiguration.handleReOpenApplication(this.homeApplication);
        }
    }
}

