# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2013 Kristian Høgsberg
# Copyright © 2013      Rafael Antognolli
# Copyright © 2013      Jasper St. Pierre
# Copyright © 2010-2013 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

import enum

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource


class ZxdgPositionerV6(Interface):
    """Child surface positioner

    The :class:`~pywayland.protocol.xdg_shell.XdgPositioner` provides a
    collection of rules for the placement of a child surface relative to a
    parent surface. Rules can be defined to ensure the child surface remains
    within the visible area's borders, and to specify how the child surface
    changes its position, such as sliding along an axis, or flipping around a
    rectangle. These positioner-created rules are constrained by the
    requirement that a child surface must intersect with or be at least
    partially adjacent to its parent surface.

    See the various requests for details about possible rules.

    At the time of the request, the compositor makes a copy of the rules
    specified by the :class:`~pywayland.protocol.xdg_shell.XdgPositioner`.
    Thus, after the request is complete the
    :class:`~pywayland.protocol.xdg_shell.XdgPositioner` object can be
    destroyed or reused; further changes to the object will have no effect on
    previous usages.

    For an :class:`~pywayland.protocol.xdg_shell.XdgPositioner` object to be
    considered complete, it must have a non-zero size set by set_size, and a
    non-zero anchor rectangle set by set_anchor_rect. Passing an incomplete
    :class:`~pywayland.protocol.xdg_shell.XdgPositioner` object when
    positioning a surface raises an error.
    """

    name = "zxdg_positioner_v6"
    version = 1

    class error(enum.IntEnum):
        invalid_input = 0

    class anchor(enum.IntFlag):
        none = 0
        top = 1
        bottom = 2
        left = 4
        right = 8

    class gravity(enum.IntFlag):
        none = 0
        top = 1
        bottom = 2
        left = 4
        right = 8

    class constraint_adjustment(enum.IntFlag):
        none = 0
        slide_x = 1
        slide_y = 2
        flip_x = 4
        flip_y = 8
        resize_x = 16
        resize_y = 32


class ZxdgPositionerV6Proxy(Proxy):
    interface = ZxdgPositionerV6

    @ZxdgPositionerV6.request()
    def destroy(self):
        """Destroy the :class:`~pywayland.protocol.xdg_shell.XdgPositioner` object

        Notify the compositor that the
        :class:`~pywayland.protocol.xdg_shell.XdgPositioner` will no longer be
        used.
        """
        self._marshal(0)
        self._destroy()

    @ZxdgPositionerV6.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def set_size(self, width, height):
        """Set the size of the to-be positioned rectangle

        Set the size of the surface that is to be positioned with the
        positioner object. The size is in surface-local coordinates and
        corresponds to the window geometry. See
        :func:`XdgSurface.set_window_geometry()
        <pywayland.protocol.xdg_shell.XdgSurface.set_window_geometry>`.

        If a zero or negative size is set the invalid_input error is raised.

        :param width:
            width of positioned rectangle
        :type width:
            `ArgumentType.Int`
        :param height:
            height of positioned rectangle
        :type height:
            `ArgumentType.Int`
        """
        self._marshal(1, width, height)

    @ZxdgPositionerV6.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def set_anchor_rect(self, x, y, width, height):
        """Set the anchor rectangle within the parent surface

        Specify the anchor rectangle within the parent surface that the child
        surface will be placed relative to. The rectangle is relative to the
        window geometry as defined by :func:`XdgSurface.set_window_geometry()
        <pywayland.protocol.xdg_shell.XdgSurface.set_window_geometry>` of the
        parent surface. The rectangle must be at least 1x1 large.

        When the :class:`~pywayland.protocol.xdg_shell.XdgPositioner` object is
        used to position a child surface, the anchor rectangle may not extend
        outside the window geometry of the positioned child's parent surface.

        If a zero or negative size is set the invalid_input error is raised.

        :param x:
            x position of anchor rectangle
        :type x:
            `ArgumentType.Int`
        :param y:
            y position of anchor rectangle
        :type y:
            `ArgumentType.Int`
        :param width:
            width of anchor rectangle
        :type width:
            `ArgumentType.Int`
        :param height:
            height of anchor rectangle
        :type height:
            `ArgumentType.Int`
        """
        self._marshal(2, x, y, width, height)

    @ZxdgPositionerV6.request(
        Argument(ArgumentType.Uint),
    )
    def set_anchor(self, anchor):
        """Set anchor rectangle anchor edges

        Defines a set of edges for the anchor rectangle. These are used to
        derive an anchor point that the child surface will be positioned
        relative to. If two orthogonal edges are specified (e.g. 'top' and
        'left'), then the anchor point will be the intersection of the edges
        (e.g. the top left position of the rectangle); otherwise, the derived
        anchor point will be centered on the specified edge, or in the center
        of the anchor rectangle if no edge is specified.

        If two parallel anchor edges are specified (e.g. 'left' and 'right'),
        the invalid_input error is raised.

        :param anchor:
            bit mask of anchor edges
        :type anchor:
            `ArgumentType.Uint`
        """
        self._marshal(3, anchor)

    @ZxdgPositionerV6.request(
        Argument(ArgumentType.Uint),
    )
    def set_gravity(self, gravity):
        """Set child surface gravity

        Defines in what direction a surface should be positioned, relative to
        the anchor point of the parent surface. If two orthogonal gravities are
        specified (e.g. 'bottom' and 'right'), then the child surface will be
        placed in the specified direction; otherwise, the child surface will be
        centered over the anchor point on any axis that had no gravity
        specified.

        If two parallel gravities are specified (e.g. 'left' and 'right'), the
        invalid_input error is raised.

        :param gravity:
            bit mask of gravity directions
        :type gravity:
            `ArgumentType.Uint`
        """
        self._marshal(4, gravity)

    @ZxdgPositionerV6.request(
        Argument(ArgumentType.Uint),
    )
    def set_constraint_adjustment(self, constraint_adjustment):
        """Set the adjustment to be done when constrained

        Specify how the window should be positioned if the originally intended
        position caused the surface to be constrained, meaning at least
        partially outside positioning boundaries set by the compositor. The
        adjustment is set by constructing a bitmask describing the adjustment
        to be made when the surface is constrained on that axis.

        If no bit for one axis is set, the compositor will assume that the
        child surface should not change its position on that axis when
        constrained.

        If more than one bit for one axis is set, the order of how adjustments
        are applied is specified in the corresponding adjustment descriptions.

        The default adjustment is none.

        :param constraint_adjustment:
            bit mask of constraint adjustments
        :type constraint_adjustment:
            `ArgumentType.Uint`
        """
        self._marshal(5, constraint_adjustment)

    @ZxdgPositionerV6.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def set_offset(self, x, y):
        """Set surface position offset

        Specify the surface position offset relative to the position of the
        anchor on the anchor rectangle and the anchor on the surface. For
        example if the anchor of the anchor rectangle is at (x, y), the surface
        has the gravity bottom|right, and the offset is (ox, oy), the
        calculated surface position will be (x + ox, y + oy). The offset
        position of the surface is the one used for constraint testing. See
        set_constraint_adjustment.

        An example use case is placing a popup menu on top of a user interface
        element, while aligning the user interface element of the parent
        surface with some user interface element placed somewhere in the popup
        surface.

        :param x:
            surface position x offset
        :type x:
            `ArgumentType.Int`
        :param y:
            surface position y offset
        :type y:
            `ArgumentType.Int`
        """
        self._marshal(6, x, y)


class ZxdgPositionerV6Resource(Resource):
    interface = ZxdgPositionerV6


class ZxdgPositionerV6Global(Global):
    interface = ZxdgPositionerV6


ZxdgPositionerV6._gen_c()
ZxdgPositionerV6.proxy_class = ZxdgPositionerV6Proxy
ZxdgPositionerV6.resource_class = ZxdgPositionerV6Resource
ZxdgPositionerV6.global_class = ZxdgPositionerV6Global
