/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.model;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;

public final class NodesCache {
    private Reference<Map<NodeKey, HeapViewerNode[]>> cache;

    public void storeChildren(HeapViewerNode node, HeapViewerNode[] children) {
        this.getCache().put(new NodeKey(node), children);
    }

    public HeapViewerNode[] retrieveChildren(HeapViewerNode node) {
        return this.getCache().remove(new NodeKey(node));
    }

    public void clear() {
        this.cache = null;
    }

    private Map<NodeKey, HeapViewerNode[]> getCache() {
        Map<NodeKey, HeapViewerNode[]> c;
        Map<NodeKey, HeapViewerNode[]> map = c = this.cache == null ? null : this.cache.get();
        if (c == null) {
            c = new HashMap<NodeKey, HeapViewerNode[]>();
            this.cache = new WeakReference<Map<NodeKey, HeapViewerNode[]>>(c);
        }
        return c;
    }

    private static final class NodeKey {
        private final HeapViewerNode node;
        private int distance;
        private int hashCode;

        NodeKey(HeapViewerNode node) {
            this.node = node;
            this.distance = 0;
            this.hashCode = 1;
            while (node != null) {
                this.hashCode = 31 * this.hashCode + ((Object)((Object)node)).hashCode();
                ++this.distance;
                node = node.getParent();
            }
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NodeKey)) {
                return false;
            }
            NodeKey nk = (NodeKey)o;
            if (this.distance != nk.distance) {
                return false;
            }
            HeapViewerNode n = nk.node;
            HeapViewerNode t = this.node;
            while (t != null) {
                if (!((Object)((Object)t)).equals((Object)n)) {
                    return false;
                }
                t = t.getParent();
                n = n.getParent();
            }
            return true;
        }
    }
}

