/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_uk extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bn = "\u0431\u0435\u043d\u0433\u0430\u043b\u044c\u0441\u044c\u043a\u0430";
        final String metaValue_bo = "\u0442\u0438\u0431\u0435\u0442\u0441\u044c\u043a\u0430";
        final String metaValue_el = "\u0433\u0440\u0435\u0446\u044c\u043a\u0430";
        final String metaValue_gu = "\u0433\u0443\u0434\u0436\u0430\u0440\u0430\u0442\u0456";
        final String metaValue_he = "\u0456\u0432\u0440\u0438\u0442";
        final String metaValue_hy = "\u0432\u0456\u0440\u043c\u0435\u043d\u0441\u044c\u043a\u0430";
        final String metaValue_ja = "\u044f\u043f\u043e\u043d\u0441\u044c\u043a\u0430";
        final String metaValue_ka = "\u0433\u0440\u0443\u0437\u0438\u043d\u0441\u044c\u043a\u0430";
        final String metaValue_km = "\u043a\u0445\u043c\u0435\u0440\u0441\u044c\u043a\u0430";
        final String metaValue_kn = "\u043a\u0430\u043d\u043d\u0430\u0434\u0430";
        final String metaValue_ko = "\u043a\u043e\u0440\u0435\u0439\u0441\u044c\u043a\u0430";
        final String metaValue_lo = "\u043b\u0430\u043e\u0441\u044c\u043a\u0430";
        final String metaValue_mn = "\u043c\u043e\u043d\u0433\u043e\u043b\u044c\u0441\u044c\u043a\u0430";
        final String metaValue_si = "\u0441\u0438\u043d\u0433\u0430\u043b\u044c\u0441\u044c\u043a\u0430";
        final String metaValue_ta = "\u0442\u0430\u043c\u0456\u043b\u044c\u0441\u044c\u043a\u0430";
        final String metaValue_te = "\u0442\u0435\u043b\u0443\u0433\u0443";
        final String metaValue_th = "\u0442\u0430\u0439\u0441\u044c\u043a\u0430";
        final String metaValue_zh = "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0430";
        final String metaValue_bax = "\u0431\u0430\u043c\u0443\u043c";
        final String metaValue_ccp = "\u0447\u0430\u043a\u043c\u0430";
        final String metaValue_chr = "\u0447\u0435\u0440\u043e\u043a\u0456";
        final String metaValue_nqo = "\u043d\u043a\u043e";
        final String metaValue_vai = "\u0432\u0430\u0457";
        final String metaValue_key_nu = "\u0446\u0438\u0444\u0440\u0438";
        final Object[][] data = new Object[][] {
            { "ksh", "\u043a\u0435\u043b\u044c\u043d\u0441\u044c\u043a\u0430" },
            { "Ogam", "\u043e\u0433\u0430\u043c\u0456\u0447\u043d\u0438\u0439" },
            { "mwl", "\u043c\u0456\u0440\u0430\u043d\u0434\u0441\u044c\u043a\u0430" },
            { "Zsym", "\u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u0430" },
            { "cch", "\u0430\u0442\u0441\u0430\u043c" },
            { "mwr", "\u043c\u0430\u0440\u0432\u0430\u0440\u0456" },
            { "Tagb", "\u0442\u0430\u0433\u0431\u0430\u043d\u0432\u0430" },
            { "Zsye", "\u0435\u043c\u043e\u0434\u0437\u0456" },
            { "%%NJIVA", "\u0414\u0456\u0430\u043b\u0435\u043a\u0442 \u041d\u0434\u0436\u0456\u0432\u0430" },
            { "ccp", metaValue_ccp },
            { "egy", "\u0434\u0430\u0432\u043d\u044c\u043e\u0454\u0433\u0438\u043f\u0435\u0442\u0441\u044c\u043a\u0430" },
            { "raj", "\u0440\u0430\u0434\u0436\u0430\u0441\u0442\u0445\u0430\u043d\u0456" },
            { "Phag", "\u043f\u0445\u0430\u0433\u0441-\u043f\u0430" },
            { "tem", "\u0442\u0435\u043c\u043d\u0435" },
            { "teo", "\u0442\u0435\u0441\u043e" },
            { "rap", "\u0440\u0430\u043f\u0430\u043d\u0443\u0457" },
            { "ter", "\u0442\u0435\u0440\u0435\u043d\u043e" },
            { "AC", "\u041e\u0441\u0442\u0440\u0456\u0432 \u0412\u043e\u0437\u043d\u0435\u0441\u0456\u043d\u043d\u044f" },
            { "rar", "\u0440\u0430\u0440\u043e\u0442\u043e\u043d\u0433\u0430" },
            { "tet", "\u0442\u0435\u0442\u0443\u043c" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u041e\u0431\u02bc\u0454\u0434\u043d\u0430\u043d\u0456 \u0410\u0440\u0430\u0431\u0441\u044c\u043a\u0456 \u0415\u043c\u0456\u0440\u0430\u0442\u0438" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0434\u0441\u044c\u043a\u0430" },
            { "AF", "\u0410\u0444\u0433\u0430\u043d\u0456\u0441\u0442\u0430\u043d" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0456 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "type.ca.ethiopic", "\u0435\u0444\u0456\u043e\u043f\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "AI", "\u0410\u043d\u0433\u0456\u043b\u044c\u044f" },
            { "key.tz", "\u0447\u0430\u0441\u043e\u0432\u0438\u0439 \u043f\u043e\u044f\u0441" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0456\u044f" },
            { "AM", "\u0412\u0456\u0440\u043c\u0435\u043d\u0456\u044f" },
            { "Teng", "\u0442\u0435\u043d\u0433\u0432\u0430\u0440" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u043a\u0430" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "Prti", "\u043f\u0430\u0440\u0444\u044f\u043d\u0441\u044c\u043a\u0438\u0439" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0435 \u0421\u0430\u043c\u043e\u0430" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0456\u044f" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0456\u044f" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "en_US", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u0430\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "mye", "\u043c\u0438\u0456\u043d" },
            { "AZ", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d" },
            { "%%AREVELA", "\u0421\u0445\u0456\u0434\u043d\u043e\u0432\u0456\u0440\u043c\u0435\u043d\u0441\u044c\u043a\u0438\u0439" },
            { "BA", "\u0411\u043e\u0441\u043d\u0456\u044f \u0456 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "kum", "\u043a\u0443\u043c\u0438\u0446\u044c\u043a\u0430" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0456\u044f" },
            { "gmh", "\u0441\u0435\u0440\u0435\u0434\u043d\u044c\u043e\u0432\u0435\u0440\u0445\u043d\u044c\u043e\u043d\u0456\u043c\u0435\u0446\u044c\u043a\u0430" },
            { "BF", "\u0411\u0443\u0440\u043a\u0456\u043d\u0430-\u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440\u0456\u044f" },
            { "BH", "\u0411\u0430\u0445\u0440\u0435\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0456" },
            { "BJ", "\u0411\u0435\u043d\u0456\u043d" },
            { "BL", "\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u0435\u043b\u0435\u043c\u0456" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "kut", "\u043a\u0443\u0442\u0435\u043d\u0430\u0457" },
            { "myv", "\u0435\u0440\u0437\u044f" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439" },
            { "BO", "\u0411\u043e\u043b\u0456\u0432\u0456\u044f" },
            { "BQ", "\u041a\u0430\u0440\u0438\u0431\u0441\u044c\u043a\u0456 \u041d\u0456\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0438" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b\u0456\u044f" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u041e\u0441\u0442\u0440\u0456\u0432 \u0411\u0443\u0432\u0435" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "BY", "\u0411\u0456\u043b\u043e\u0440\u0443\u0441\u044c" },
            { "BZ", "\u0411\u0435\u043b\u0456\u0437" },
            { "Visp", "\u0432\u0438\u0434\u0438\u043c\u0435 \u043c\u043e\u0432\u043b\u0435\u043d\u043d\u044f" },
            { "type.ca.persian", "\u043f\u0435\u0440\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.nu.hebr", "\u0446\u0438\u0444\u0440\u0438 \u0456\u0432\u0440\u0438\u0442\u0443" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u0456 (\u041a\u0456\u043b\u0456\u043d\u0433) \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "mzn", "\u043c\u0430\u0437\u0430\u043d\u0434\u0435\u0440\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "CD", "\u041a\u043e\u043d\u0433\u043e \u2013 \u041a\u0456\u043d\u0448\u0430\u0441\u0430" },
            { "CF", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e \u2013 \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0456\u043b\u044c" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0456\u044f" },
            { "CI", "\u041a\u043e\u0442-\u0434\u02bc\u0406\u0432\u0443\u0430\u0440" },
            { "CK", "\u041e\u0441\u0442\u0440\u043e\u0432\u0438 \u041a\u0443\u043a\u0430" },
            { "CL", "\u0427\u0438\u043b\u0456" },
            { "Kthi", "\u043a\u0430\u0457\u0442\u0456" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u041a\u0438\u0442\u0430\u0439" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0456\u044f" },
            { "CP", "\u041e\u0441\u0442\u0440\u0456\u0432 \u041a\u043b\u0456\u043f\u043f\u0435\u0440\u0442\u043e\u043d" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u044e\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u041e\u0441\u0442\u0440\u0456\u0432 \u0420\u0456\u0437\u0434\u0432\u0430" },
            { "CY", "\u041a\u0456\u043f\u0440" },
            { "CZ", "\u0427\u0435\u0445\u0456\u044f" },
            { "eka", "\u0435\u043a\u0430\u0434\u0436\u0443\u043a" },
            { "Ahom", "\u0430\u0445\u043e\u043c" },
            { "DE", "\u041d\u0456\u043c\u0435\u0447\u0447\u0438\u043d\u0430" },
            { "goh", "\u0434\u0430\u0432\u043d\u044c\u043e\u0432\u0435\u0440\u0445\u043d\u044c\u043e\u043d\u0456\u043c\u0435\u0446\u044c\u043a\u0430" },
            { "ace", "\u0430\u0447\u0435\u0445\u0441\u044c\u043a\u0430" },
            { "cgg", "\u043a\u0456\u0433\u0430" },
            { "DG", "\u0414\u0456\u0454\u0433\u043e-\u0413\u0430\u0440\u0441\u0456\u044f" },
            { "type.nu.deva", "\u0446\u0438\u0444\u0440\u0438 \u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0456" },
            { "DJ", "\u0414\u0436\u0438\u0431\u0443\u0442\u0456" },
            { "DK", "\u0414\u0430\u043d\u0456\u044f" },
            { "ach", "\u0430\u0447\u043e\u043b\u0456" },
            { "gon", "\u0433\u043e\u043d\u0434\u0456" },
            { "Brai", "\u0448\u0440\u0438\u0444\u0442 \u0411\u0440\u0430\u0439\u043b\u044f" },
            { "Brah", "\u0431\u0440\u0430\u0445\u043c\u0456" },
            { "DM", "\u0414\u043e\u043c\u0456\u043d\u0456\u043a\u0430" },
            { "type.nu.armnlow", "\u0432\u0456\u0440\u043c\u0435\u043d\u0441\u044c\u043a\u0456 \u043c\u0430\u043b\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "DO", "\u0414\u043e\u043c\u0456\u043d\u0456\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430" },
            { "gor", "\u0433\u043e\u0440\u043e\u043d\u0442\u0430\u043b\u043e" },
            { "got", "\u0433\u043e\u0442\u0441\u044c\u043a\u0430" },
            { "Mtei", "\u043c\u0435\u0439\u0442\u0435\u0439 \u043c\u0430\u0439\u0454\u043a" },
            { "zun", "\u0437\u0443\u043d\u044c\u0457" },
            { "tig", "\u0442\u0438\u0433\u0440\u0435" },
            { "DZ", "\u0410\u043b\u0436\u0438\u0440" },
            { "pag", "\u043f\u0430\u043d\u0433\u0430\u0441\u0456\u043d\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "type.d0.hwidth", "\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u043d\u0430 \u0448\u0438\u0440\u0438\u043d\u0430" },
            { "pal", "\u043f\u0435\u0445\u043b\u0435\u0432\u0456" },
            { "EA", "\u0421\u0435\u0443\u0442\u0430 \u0456 \u041c\u0435\u043b\u0456\u043b\u044c\u044f" },
            { "chb", "\u0447\u0456\u0431\u0447\u0430" },
            { "pam", "\u043f\u0430\u043c\u043f\u0430\u043d\u0433\u0430" },
            { "EC", "\u0415\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "pap", "\u043f\u0430\u043f\u02bc\u044f\u043c\u0435\u043d\u0442\u043e" },
            { "ada", "\u0430\u0434\u0430\u043d\u0433\u043c\u0435" },
            { "EE", "\u0415\u0441\u0442\u043e\u043d\u0456\u044f" },
            { "tiv", "\u0442\u0456\u0432" },
            { "EG", "\u0404\u0433\u0438\u043f\u0435\u0442" },
            { "EH", "\u0417\u0430\u0445\u0456\u0434\u043d\u0430 \u0421\u0430\u0445\u0430\u0440\u0430" },
            { "chg", "\u0447\u0430\u0433\u0430\u0442\u0430\u0439\u0441\u044c\u043a\u0430" },
            { "pau", "\u043f\u0430\u043b\u0430\u0443\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "chk", "\u0447\u0443\u0443\u043a\u0441\u044c\u043a\u0430" },
            { "chn", "\u0447\u0438\u043d\u0443\u043a \u0436\u0430\u0440\u0433\u043e\u043d" },
            { "chm", "\u043c\u0430\u0440\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "chp", "\u0447\u0456\u043f\u0435\u0432\u02bc\u044f\u043d" },
            { "cho", "\u0447\u043e\u043a\u0442\u043e" },
            { "chr", metaValue_chr },
            { "ER", "\u0415\u0440\u0438\u0442\u0440\u0435\u044f" },
            { "ES", "\u0406\u0441\u043f\u0430\u043d\u0456\u044f" },
            { "ET", "\u0415\u0444\u0456\u043e\u043f\u0456\u044f" },
            { "EU", "\u0404\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u0438\u0439 \u0421\u043e\u044e\u0437" },
            { "elx", "\u0435\u043b\u0430\u043c\u0441\u044c\u043a\u0430" },
            { "type.ca.gregorian", "\u0433\u0440\u0438\u0433\u043e\u0440\u0456\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "EZ", "\u0404\u0432\u0440\u043e\u0437\u043e\u043d\u0430" },
            { "chy", "\u0447\u0435\u0439\u0454\u043d\u043d" },
            { "type.nu.gujr", "\u0446\u0438\u0444\u0440\u0438 \u0433\u0443\u0434\u0436\u0430\u0440\u0430\u0442\u0456" },
            { "Inds", "\u0445\u0430\u0440\u0430\u043f\u0441\u044c\u043a\u0438\u0439" },
            { "ady", "\u0430\u0434\u0438\u0433\u0435\u0439\u0441\u044c\u043a\u0430" },
            { "FI", "\u0424\u0456\u043d\u043b\u044f\u043d\u0434\u0456\u044f" },
            { "FJ", "\u0424\u0456\u0434\u0436\u0456" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "FM", "\u041c\u0456\u043a\u0440\u043e\u043d\u0435\u0437\u0456\u044f" },
            { "key.va", "\u0432\u0430\u0440\u0456\u0430\u043d\u0442 \u043c\u043e\u0432\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0443" },
            { "FO", "\u0424\u0430\u0440\u0435\u0440\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "Taml", metaValue_ta },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u0456\u044f" },
            { "tkl", "\u0442\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "grb", "\u0433\u0440\u0435\u0431\u043e" },
            { "type.ca.indian", "\u0456\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0441\u0432\u0456\u0442\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "grc", "\u0434\u0430\u0432\u043d\u044c\u043e\u0433\u0440\u0435\u0446\u044c\u043a\u0430" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "vot", "\u0432\u043e\u0434\u0441\u044c\u043a\u0430" },
            { "GB", "\u0412\u0435\u043b\u0438\u043a\u0430 \u0411\u0440\u0438\u0442\u0430\u043d\u0456\u044f" },
            { "pcm", "\u043d\u0456\u0433\u0435\u0440\u0456\u0439\u0441\u044c\u043a\u043e-\u043a\u0440\u0435\u043e\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u0440\u0443\u0437\u0456\u044f" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0430 \u0413\u0432\u0456\u0430\u043d\u0430" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0456" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "Tale", "\u0442\u0430\u0439-\u043b\u0456" },
            { "GI", "\u0413\u0456\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "afh", "\u0430\u0444\u0440\u0438\u0445\u0456\u043b\u0456" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0456\u044f" },
            { "enm", "\u0441\u0435\u0440\u0435\u0434\u043d\u044c\u043e\u0430\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "GM", "\u0413\u0430\u043c\u0431\u0456\u044f" },
            { "GN", "\u0413\u0432\u0456\u043d\u0435\u044f" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430" },
            { "GQ", "\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0456\u0430\u043b\u044c\u043d\u0430 \u0413\u0432\u0456\u043d\u0435\u044f" },
            { "GR", "\u0413\u0440\u0435\u0446\u0456\u044f" },
            { "GS", "\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0430 \u0414\u0436\u043e\u0440\u0434\u0436\u0456\u044f \u0442\u0430 \u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0456 \u0421\u0430\u043d\u0434\u0432\u0456\u0447\u0435\u0432\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0456\u043d\u0435\u044f-\u0411\u0456\u0441\u0430\u0443" },
            { "tli", "\u0442\u043b\u0456\u043d\u0433\u0456\u0442" },
            { "tlh", "\u043a\u043b\u0456\u043d\u0433\u043e\u043d\u0441\u044c\u043a\u0430" },
            { "Talu", "\u043d\u043e\u0432\u0438\u0439 \u0442\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u043b\u0443\u0435" },
            { "GY", "\u0413\u0430\u044f\u043d\u0430" },
            { "ckb", "\u0446\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u043a\u0443\u0440\u0434\u0441\u044c\u043a\u0430" },
            { "zxx", "\u043f\u0440\u0438\u0440\u043e\u0434\u043d\u043e\u043c\u043e\u0432\u043d\u0438\u0439 \u0442\u0435\u043a\u0441\u0442 \u0432\u0456\u0434\u0441\u0443\u0442\u043d\u0456\u0439" },
            { "de_AT", "\u0430\u0432\u0441\u0442\u0440\u0456\u0439\u0441\u044c\u043a\u0430 \u043d\u0456\u043c\u0435\u0446\u044c\u043a\u0430" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0413\u043e\u043d\u043a\u043e\u043d\u0433, \u041e\u0410\u0420 \u041a\u0438\u0442\u0430\u044e" },
            { "HM", "\u041e\u0441\u0442\u0440\u043e\u0432\u0438 \u0413\u0435\u0440\u0434 \u0456 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u0434" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442\u0456\u044f" },
            { "agq", "\u0430\u0433\u0435\u043c" },
            { "gsw", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u044c\u043a\u0430 \u043d\u0456\u043c\u0435\u0446\u044c\u043a\u0430" },
            { "type.ca.islamic-umalqura", "\u0456\u0441\u043b\u0430\u043c\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 (\u0423\u043c\u043c \u0430\u043b\u044c-\u041a\u0443\u0440\u0430)" },
            { "HT", "\u0413\u0430\u0457\u0442\u0456" },
            { "HU", "\u0423\u0433\u043e\u0440\u0449\u0438\u043d\u0430" },
            { "tmh", "\u0442\u0430\u043c\u0430\u0448\u0435\u043a" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "nan", "\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u043c\u0456\u043d\u044c\u0441\u044c\u043a\u0430" },
            { "ID", "\u0406\u043d\u0434\u043e\u043d\u0435\u0437\u0456\u044f" },
            { "peo", "\u0434\u0430\u0432\u043d\u044c\u043e\u043f\u0435\u0440\u0441\u044c\u043a\u0430" },
            { "Adlm", "\u0430\u0434\u043b\u0430\u043c" },
            { "IE", "\u0406\u0440\u043b\u0430\u043d\u0434\u0456\u044f" },
            { "nap", "\u043d\u0435\u0430\u043f\u043e\u043b\u0456\u0442\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "zza", "\u0437\u0430\u0437\u0430\u043a\u0456" },
            { "Tang", "\u0442\u0430\u043d\u0433\u0443\u0442" },
            { "IL", "\u0406\u0437\u0440\u0430\u0457\u043b\u044c" },
            { "IM", "\u041e\u0441\u0442\u0440\u0456\u0432 \u041c\u0435\u043d" },
            { "IN", "\u0406\u043d\u0434\u0456\u044f" },
            { "type.co.eor", "\u0454\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u0456 \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0443\u043f\u043e\u0440\u044f\u0434\u043a\u0443\u0432\u0430\u043d\u043d\u044f" },
            { "IO", "\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u044c\u043a\u0430 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0456\u044f \u0432 \u0406\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u043e\u043c\u0443 \u041e\u043a\u0435\u0430\u043d\u0456" },
            { "IQ", "\u0406\u0440\u0430\u043a" },
            { "IR", "\u0406\u0440\u0430\u043d" },
            { "IS", "\u0406\u0441\u043b\u0430\u043d\u0434\u0456\u044f" },
            { "IT", "\u0406\u0442\u0430\u043b\u0456\u044f" },
            { "Zmth", "\u043c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u043d\u0430" },
            { "type.nu.thai", "\u0442\u0430\u0439\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "%%POSIX", "\u041a\u043e\u043c\u043f\u02bc\u044e\u0442\u0435\u0440\u043d\u0438\u0439" },
            { "type.nu.beng", "\u0431\u0435\u043d\u0491\u0430\u043b\u044c\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "JE", "\u0414\u0436\u0435\u0440\u0441\u0456" },
            { "type.ca.islamic", "\u0456\u0441\u043b\u0430\u043c\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "Beng", metaValue_bn },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "JO", "\u0419\u043e\u0440\u0434\u0430\u043d\u0456\u044f" },
            { "JP", "\u042f\u043f\u043e\u043d\u0456\u044f" },
            { "%%1606NICT", "\u041f\u0456\u0437\u043d\u044c\u043e\u0441\u0435\u0440\u0435\u0434\u043d\u044c\u043e\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u044c\u043a\u0430 \u0434\u043e 1606" },
            { "ain", "\u0430\u0439\u043d\u0441\u044c\u043a\u0430" },
            { "guz", "\u0433\u0443\u0441\u0456\u0457" },
            { "tog", "\u043d\u044c\u044f\u0441\u0430 \u0442\u043e\u043d\u0433\u0430" },
            { "type.nu.knda", "\u0446\u0438\u0444\u0440\u0438 \u043a\u0430\u043d\u043d\u0430\u0434\u0430" },
            { "Kali", "\u043a\u0430\u044f \u043b\u0456" },
            { "de_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u044c\u043a\u0430 \u0432\u0435\u0440\u0445\u043d\u044c\u043e\u043d\u0456\u043c\u0435\u0446\u044c\u043a\u0430" },
            { "type.co.phonetic", "\u0444\u043e\u043d\u0435\u0442\u0438\u0447\u043d\u0438\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f" },
            { "type.ca.buddhist", "\u0431\u0443\u0434\u0434\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "KE", "\u041a\u0435\u043d\u0456\u044f" },
            { "419", "\u041b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "KG", "\u041a\u0438\u0440\u0433\u0438\u0437\u0441\u0442\u0430\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430" },
            { "KI", "\u041a\u0456\u0440\u0438\u0431\u0430\u0442\u0456" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440\u0438" },
            { "Knda", metaValue_kn },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0456\u0442\u0441 \u0456 \u041d\u0435\u0432\u0456\u0441" },
            { "Zinh", "\u0443\u0441\u043f\u0430\u0434\u043a\u043e\u0432\u0430\u043d\u0430" },
            { "fr_CA", "\u043a\u0430\u043d\u0430\u0434\u0441\u044c\u043a\u0430 \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0430" },
            { "KP", "\u041f\u0456\u0432\u043d\u0456\u0447\u043d\u0430 \u041a\u043e\u0440\u0435\u044f" },
            { "KR", "\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0430 \u041a\u043e\u0440\u0435\u044f" },
            { "Plrd", "\u043f\u0438\u0441\u0435\u043c\u043d\u0456\u0441\u0442\u044c \u041f\u043e\u043b\u043b\u0430\u0440\u0434\u0430" },
            { "fr_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u044c\u043a\u0430 \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0430" },
            { "KW", "\u041a\u0443\u0432\u0435\u0439\u0442" },
            { "tpi", "\u0442\u043e\u043a-\u043f\u0456\u0441\u0456\u043d" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d\u043e\u0432\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "KZ", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d" },
            { "Cyrl", "\u043a\u0438\u0440\u0438\u043b\u0438\u0446\u044f" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0456\u0432\u0430\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0456\u044f" },
            { "phn", "\u0444\u0456\u043d\u0456\u043a\u0456\u0439\u0441\u044c\u043a\u043e-\u043f\u0443\u043d\u0456\u0447\u043d\u0430" },
            { "Cyrs", "\u0434\u0430\u0432\u043d\u044c\u043e\u0446\u0435\u0440\u043a\u043e\u0432\u043d\u043e\u0441\u043b\u043e\u0432\u02bc\u044f\u043d\u0441\u044c\u043a\u0438\u0439" },
            { "gwi", "\u043a\u0443\u0447\u0456\u043d" },
            { "nds", "\u043d\u0438\u0436\u043d\u044c\u043e\u043d\u0456\u043c\u0435\u0446\u044c\u043a\u0430" },
            { "LI", "\u041b\u0456\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "LK", "\u0428\u0440\u0456-\u041b\u0430\u043d\u043a\u0430" },
            { "akk", "\u0430\u043a\u043a\u0430\u0434\u0441\u044c\u043a\u0430" },
            { "cop", "\u043a\u043e\u043f\u0442\u0441\u044c\u043a\u0430" },
            { "LR", "\u041b\u0456\u0431\u0435\u0440\u0456\u044f" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "Phlv", "\u043f\u0435\u0445\u043b\u0435\u0432\u0456 \u043b\u0456\u0442\u0435\u0440\u0430\u0442\u0443\u0440\u043d\u0438\u0439" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0456\u044f" },
            { "Kana", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "LY", "\u041b\u0456\u0432\u0456\u044f" },
            { "lad", "\u043b\u0430\u0434\u0456\u043d\u043e" },
            { "vun", "\u0432\u0443\u043d\u044c\u043e" },
            { "akz", "\u0430\u043b\u0430\u0431\u0430\u043c\u0430" },
            { "lah", "\u043b\u0430\u043d\u0434\u0430" },
            { "lag", "\u043b\u0430\u043d\u0433\u0456" },
            { "Thaa", "\u0442\u0430\u0430\u043d\u0430" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u043a\u043e" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u043e\u0432\u0430" },
            { "ME", "\u0427\u043e\u0440\u043d\u043e\u0433\u043e\u0440\u0456\u044f" },
            { "MF", "\u0421\u0435\u043d-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "lam", "\u043b\u0430\u043c\u0431\u0430" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "Thai", metaValue_th },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u043e\u0432\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "ale", "\u0430\u043b\u0435\u0443\u0442\u0441\u044c\u043a\u0430" },
            { "type.nu.vaii", "\u0446\u0438\u0444\u0440\u0438 \u0432\u0430\u0457" },
            { "MK", "\u041f\u0456\u0432\u043d\u0456\u0447\u043d\u0430 \u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0456\u044f" },
            { "ML", "\u041c\u0430\u043b\u0456" },
            { "MM", "\u041c\u02bc\u044f\u043d\u043c\u0430 (\u0411\u0456\u0440\u043c\u0430)" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b\u0456\u044f" },
            { "new", "\u043d\u0435\u0432\u0430\u0440\u0456" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e, \u041e\u0410\u0420 \u041a\u0438\u0442\u0430\u044e" },
            { "MP", "\u041f\u0456\u0432\u043d\u0456\u0447\u043d\u0456 \u041c\u0430\u0440\u0456\u0430\u043d\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0456\u043a\u0430" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0456\u044f" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "type.m0.ungegn", "\u0442\u0440\u0430\u043d\u0441\u043b\u0456\u0442\u0435\u0440\u0430\u0446\u0456\u044f \u0413\u0415\u0413\u041d \u041e\u041e\u041d" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0456\u0439" },
            { "alt", "\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u0430\u043b\u0442\u0430\u0439\u0441\u044c\u043a\u0430" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u0456\u0432\u0438" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0456" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430" },
            { "type.ca.japanese", "\u044f\u043f\u043e\u043d\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437\u0456\u044f" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0456\u043a" },
            { "Phli", "\u043f\u0435\u0445\u043b\u0435\u0432\u0456 \u043d\u0430\u043f\u0438\u0441\u0456\u0432" },
            { "NA", "\u041d\u0430\u043c\u0456\u0431\u0456\u044f" },
            { "202", "\u0410\u0444\u0440\u0438\u043a\u0430 \u043d\u0430 \u043f\u0456\u0432\u0434\u0435\u043d\u044c \u0432\u0456\u0434 \u0421\u0430\u0445\u0430\u0440\u0438" },
            { "type.ca.hebrew", "\u0454\u0432\u0440\u0435\u0439\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.co.dictionary", "\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f \u0437\u0430 \u0441\u043b\u043e\u0432\u043d\u0438\u043a\u043e\u043c" },
            { "NC", "\u041d\u043e\u0432\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0456\u044f" },
            { "%%WADEGILE", "\u0420\u043e\u043c\u0430\u043d\u0456\u0437\u0430\u0446\u0456\u044f \u0412\u0435\u0439\u0434\u0430-\u0414\u0436\u0430\u0439\u043b\u0437\u0430" },
            { "NE", "\u041d\u0456\u0433\u0435\u0440" },
            { "NF", "\u041e\u0441\u0442\u0440\u0456\u0432 \u041d\u043e\u0440\u0444\u043e\u043b\u043a" },
            { "NG", "\u041d\u0456\u0433\u0435\u0440\u0456\u044f" },
            { "trv", "\u0442\u0430\u0440\u043e\u043a\u043e" },
            { "Phlp", "\u043f\u0435\u0445\u043b\u0435\u0432\u0456 \u0440\u0435\u043b\u0456\u0433\u0456\u0439\u043d\u0438\u0439" },
            { "NI", "\u041d\u0456\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "Hmng", "\u043f\u0430\u0445\u0430\u0443 \u0445\u043c\u043e\u043d\u0433" },
            { "NL", "\u041d\u0456\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0438" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0456\u044f" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0456\u0443\u0435" },
            { "Phnx", "\u0444\u0456\u043d\u0456\u043a\u0456\u0439\u0441\u044c\u043a\u0438\u0439" },
            { "rof", "\u0440\u043e\u043c\u0431\u043e" },
            { "tsi", "\u0446\u0438\u043c\u0448\u0438\u0430\u043d" },
            { "NZ", "\u041d\u043e\u0432\u0430 \u0417\u0435\u043b\u0430\u043d\u0434\u0456\u044f" },
            { "rom", "\u0446\u0438\u0433\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "Mero", "\u043c\u0435\u0440\u043e\u0457\u0442\u0441\u044c\u043a\u0438\u0439" },
            { "crh", "\u043a\u0440\u0438\u043c\u0441\u044c\u043a\u043e\u0442\u0430\u0442\u0430\u0440\u0441\u044c\u043a\u0430" },
            { "ang", "\u0434\u0430\u0432\u043d\u044c\u043e\u0430\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "OM", "\u041e\u043c\u0430\u043d" },
            { "anp", "\u0430\u043d\u0433\u0456\u043a\u0430" },
            { "crs", "\u0441\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u044c\u043a\u0430 \u043a\u0440\u0435\u043e\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "Xpeo", "\u0434\u0430\u0432\u043d\u044c\u043e\u043f\u0435\u0440\u0441\u044c\u043a\u0438\u0439" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "type.ca.islamic-civil", "\u043c\u0443\u0441\u0443\u043b\u044c\u043c\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0441\u0432\u0456\u0442\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "csb", "\u043a\u0430\u0448\u0443\u0431\u0441\u044c\u043a\u0430" },
            { "en_GB", "\u0431\u0440\u0438\u0442\u0430\u043d\u0441\u044c\u043a\u0430 \u0430\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0430 \u041f\u043e\u043b\u0456\u043d\u0435\u0437\u0456\u044f" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430-\u041d\u043e\u0432\u0430 \u0413\u0432\u0456\u043d\u0435\u044f" },
            { "PH", "\u0424\u0456\u043b\u0456\u043f\u043f\u0456\u043d\u0438" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0449\u0430" },
            { "ewo", "\u0435\u0432\u043e\u043d\u0434\u043e" },
            { "PM", "\u0421\u0435\u043d-\u041f\u02bc\u0454\u0440 \u0456 \u041c\u0456\u043a\u0435\u043b\u043e\u043d" },
            { "PN", "\u041e\u0441\u0442\u0440\u043e\u0432\u0438 \u041f\u0456\u0442\u043a\u0435\u0440\u043d" },
            { "PR", "\u041f\u0443\u0435\u0440\u0442\u043e-\u0420\u0438\u043a\u043e" },
            { "PS", "\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0441\u044c\u043a\u0456 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0456\u0457" },
            { "Bali", "\u0431\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0456\u044f" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "nia", "\u043d\u0456\u0430\u0441\u044c\u043a\u0430" },
            { "type.nu.greklow", "\u0433\u0440\u0435\u0446\u044c\u043a\u0456 \u043c\u0430\u043b\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "tum", "\u0442\u0443\u043c\u0431\u0443\u043a\u0430" },
            { "Hebr", metaValue_he },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "%%SCOTLAND", "\u0428\u043e\u0442\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0430 \u0430\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "niu", "\u043d\u0456\u0443\u0435" },
            { "QO", "\u0412\u0456\u0434\u0434\u0430\u043b\u0435\u043d\u0430 \u041e\u043a\u0435\u0430\u043d\u0456\u044f" },
            { "lez", "\u043b\u0435\u0437\u0433\u0456\u043d\u0441\u044c\u043a\u0430" },
            { "%%FONUPA", "\u0423\u0440\u0430\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0444\u043e\u043d\u0435\u0442\u0438\u0447\u043d\u0438\u0439 \u0430\u043b\u0444\u0430\u0432\u0456\u0442" },
            { "tvl", "\u0442\u0443\u0432\u0430\u043b\u0443" },
            { "Tavt", "\u0442\u0430\u0439-\u0432\u02bc\u0454\u0442" },
            { "001", "\u0421\u0432\u0456\u0442" },
            { "002", "\u0410\u0444\u0440\u0438\u043a\u0430" },
            { "njo", "\u0430\u043e \u043d\u0430\u0433\u0430" },
            { "003", "\u041f\u0456\u0432\u043d\u0456\u0447\u043d\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "RE", "\u0420\u0435\u044e\u043d\u044c\u0439\u043e\u043d" },
            { "005", "\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "jbo", "\u043b\u043e\u0436\u0431\u0430\u043d" },
            { "Rjng", "\u0440\u0435\u0434\u0436\u0430\u043d\u0433" },
            { "009", "\u041e\u043a\u0435\u0430\u043d\u0456\u044f" },
            { "RO", "\u0420\u0443\u043c\u0443\u043d\u0456\u044f" },
            { "RS", "\u0421\u0435\u0440\u0431\u0456\u044f" },
            { "RU", "\u0420\u043e\u0441\u0456\u044f" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "Mani", "\u043c\u0430\u043d\u0456\u0445\u0435\u0439\u0441\u044c\u043a\u0438\u0439" },
            { "Ugar", "\u0443\u0433\u0430\u0440\u0438\u0442\u0441\u044c\u043a\u0438\u0439" },
            { "Khar", "\u043a\u0445\u0430\u0440\u043e\u0448\u0442\u0445\u0456" },
            { "SA", "\u0421\u0430\u0443\u0434\u0456\u0432\u0441\u044c\u043a\u0430 \u0410\u0440\u0430\u0432\u0456\u044f" },
            { "pon", "\u043f\u043e\u043d\u0430\u043f\u0435" },
            { "Mand", "\u043c\u0430\u043d\u0434\u0435\u0439\u0441\u044c\u043a\u0438\u0439" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u043e\u0432\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "twq", "\u0442\u0430\u0441\u0430\u0432\u0430\u043a" },
            { "011", "\u0417\u0430\u0445\u0456\u0434\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "013", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "SE", "\u0428\u0432\u0435\u0446\u0456\u044f" },
            { "014", "\u0421\u0445\u0456\u0434\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "arc", "\u0430\u0440\u0430\u043c\u0435\u0439\u0441\u044c\u043a\u0430" },
            { "Loma", "\u043b\u043e\u043c\u0430" },
            { "015", "\u041f\u0456\u0432\u043d\u0456\u0447\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SG", "\u0421\u0456\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u041e\u0441\u0442\u0440\u0456\u0432 \u0421\u0432\u044f\u0442\u043e\u0457 \u0404\u043b\u0435\u043d\u0438" },
            { "type.lb.strict", "\u0442\u043e\u0447\u043d\u0438\u0439 \u0441\u0442\u0438\u043b\u044c \u0440\u043e\u0437\u0440\u0438\u0432\u0443 \u0440\u044f\u0434\u043a\u0430" },
            { "017", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0456\u044f" },
            { "018", "\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0435\u0433\u0456\u043e\u043d" },
            { "SJ", "\u0428\u043f\u0456\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u0442\u0430 \u042f\u043d-\u041c\u0430\u0454\u043d" },
            { "Bamu", metaValue_bax },
            { "019", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0435\u0433\u0456\u043e\u043d" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u0447\u0447\u0438\u043d\u0430" },
            { "SL", "\u0421\u044c\u0454\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0456" },
            { "arn", "\u0430\u0440\u0430\u0443\u043a\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "arp", "\u0430\u0440\u0430\u043f\u0430\u0445\u043e" },
            { "type.nu.taml", "\u0442\u0430\u043c\u0456\u043b\u044c\u0441\u044c\u043a\u0456 \u0442\u0440\u0430\u0434\u0438\u0446\u0456\u0439\u043d\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "aro", "\u0430\u0440\u0430\u043e\u043d\u0430" },
            { "SS", "\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0438\u0439 \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0456 \u041f\u0440\u0438\u043d\u0441\u0456\u043f\u0456" },
            { "arq", "\u0430\u043b\u0436\u0438\u0440\u0441\u044c\u043a\u0430 \u0430\u0440\u0430\u0431\u0441\u044c\u043a\u0430" },
            { "SV", "\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "ars", "\u043d\u0430\u0434\u0436\u0434\u0456\u0439\u0441\u044c\u043a\u0430 \u0430\u0440\u0430\u0431\u0441\u044c\u043a\u0430" },
            { "SX", "\u0421\u0456\u043d\u0442-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0421\u0438\u0440\u0456\u044f" },
            { "yao", "\u044f\u043e" },
            { "SZ", "\u0415\u0441\u0432\u0430\u0442\u0456\u043d\u0456" },
            { "arw", "\u0430\u0440\u0430\u0432\u0430\u043a\u0441\u044c\u043a\u0430" },
            { "yap", "\u044f\u043f" },
            { "TA", "\u0422\u0440\u0456\u0441\u0442\u0430\u043d-\u0434\u0430-\u041a\u0443\u043d\u044c\u044f" },
            { "asa", "\u0430\u0441\u0443" },
            { "type.ms.ussystem", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043c\u0456\u0440" },
            { "021", "\u041f\u0456\u0432\u043d\u0456\u0447\u043d\u043e\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0435\u0433\u0456\u043e\u043d" },
            { "TC", "\u041e\u0441\u0442\u0440\u043e\u0432\u0438 \u0422\u0435\u0440\u043a\u0441 \u0456 \u041a\u0430\u0439\u043a\u043e\u0441" },
            { "yav", "\u044f\u043d\u0433\u0431\u0435\u043d" },
            { "TD", "\u0427\u0430\u0434" },
            { "Qaag", "\u0437\u043e\u0434\u0436\u0456" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0456 \u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0456 \u0422\u0435\u0440\u0438\u0442\u043e\u0440\u0456\u0457" },
            { "ase", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u043c\u043e\u0432\u0430 \u0440\u0443\u0445\u0456\u0432" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "TH", "\u0422\u0430\u0457\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "029", "\u041a\u0430\u0440\u0438\u0431\u0441\u044c\u043a\u0438\u0439 \u0431\u0430\u0441\u0435\u0439\u043d" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u0422\u0456\u043c\u043e\u0440-\u041b\u0435\u0448\u0442\u0456" },
            { "ybb", "\u0454\u043c\u0431\u0430" },
            { "type.co.searchjl", "\u043f\u043e\u0448\u0443\u043a \u0437\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u043e\u0432\u043e\u044e \u043f\u0440\u0438\u0433\u043e\u043b\u043e\u0441\u043d\u043e\u044e \u0445\u0430\u043d\u0433\u0443\u043b" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0456\u0441\u0442\u0430\u043d" },
            { "%%BOONT", "\u0411\u0443\u043d\u0442\u043b\u0456\u043d\u0433" },
            { "TN", "\u0422\u0443\u043d\u0456\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u0443\u0440\u0435\u0447\u0447\u0438\u043d\u0430" },
            { "TT", "\u0422\u0440\u0438\u043d\u0456\u0434\u0430\u0434 \u0456 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d\u044c" },
            { "ast", "\u0430\u0441\u0442\u0443\u0440\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "Orkh", "\u043e\u0440\u0445\u043e\u043d\u0441\u044c\u043a\u0438\u0439" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0456\u044f" },
            { "nmg", "\u043a\u0432\u0430\u0437\u0456\u043e" },
            { "Zzzz", "\u043d\u0435\u0432\u0456\u0434\u043e\u043c\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043f\u0438\u0441\u044c\u043c\u0430" },
            { "UA", "\u0423\u043a\u0440\u0430\u0457\u043d\u0430" },
            { "rup", "\u0430\u0440\u0443\u043c\u0443\u043d\u0441\u044c\u043a\u0430" },
            { "030", "\u0421\u0445\u0456\u0434\u043d\u0430 \u0410\u0437\u0456\u044f" },
            { "tyv", "\u0442\u0443\u0432\u0438\u043d\u0441\u044c\u043a\u0430" },
            { "sw_CD", "\u0441\u0443\u0430\u0445\u0456\u043b\u0456 (\u041a\u043e\u043d\u0433\u043e)" },
            { "034", "\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0430 \u0410\u0437\u0456\u044f" },
            { "hai", "\u0445\u0430\u0439\u0434\u0430" },
            { "035", "\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u043e-\u0421\u0445\u0456\u0434\u043d\u0430 \u0410\u0437\u0456\u044f" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "hak", "\u0445\u0430\u043a\u043a\u0430\u0441\u044c\u043a\u0430" },
            { "type.co.pinyin", "\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f \u043f\u0456\u043d\u044c\u0457\u043d\u044c" },
            { "039", "\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0430 \u0404\u0432\u0440\u043e\u043f\u0430" },
            { "Sinh", metaValue_si },
            { "UM", "\u0412\u0456\u0434\u0434\u0430\u043b\u0435\u043d\u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438 \u0421\u0428\u0410" },
            { "UN", "\u041e\u0440\u0433\u0430\u043d\u0456\u0437\u0430\u0446\u0456\u044f \u041e\u0431\u2019\u0454\u0434\u043d\u0430\u043d\u0438\u0445 \u041d\u0430\u0446\u0456\u0439" },
            { "US", "\u0421\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0456 \u0428\u0442\u0430\u0442\u0438" },
            { "haw", "\u0433\u0430\u0432\u0430\u0439\u0441\u044c\u043a\u0430" },
            { "type.co.gb2312han", "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u0441\u043f\u0440\u043e\u0449\u0435\u043d\u0438\u0439" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "prg", "\u043f\u0440\u0443\u0441\u0441\u044c\u043a\u0430" },
            { "UZ", "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "tzm", "\u0446\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0430\u0442\u043b\u0430\u0441\u044c\u043a\u0430 \u0442\u0430\u043c\u0430\u0437\u0456\u0433\u0442" },
            { "type.co.stroke", "\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f \u0437\u0430 \u0440\u0438\u0441\u043a\u0430\u043c\u0438" },
            { "nnh", "\u043d\u0433\u0454\u043c\u0431\u0443\u043d" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d" },
            { "pro", "\u0434\u0430\u0432\u043d\u044c\u043e\u043f\u0440\u043e\u0432\u0430\u043d\u0441\u0430\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0456\u043d\u0441\u0435\u043d\u0442 \u0456 \u0413\u0440\u0435\u043d\u0430\u0434\u0456\u043d\u0438" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u0435\u043b\u0430" },
            { "VG", "\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u044c\u043a\u0456 \u0412\u0456\u0440\u0433\u0456\u043d\u0441\u044c\u043a\u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "VI", "\u0412\u0456\u0440\u0433\u0456\u043d\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438 (\u0421\u0428\u0410)" },
            { "VN", "\u0412\u02bc\u0454\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "nog", "\u043d\u043e\u0433\u0430\u0439\u0441\u044c\u043a\u0430" },
            { "rwk", "\u0440\u0432\u0430" },
            { "non", "\u0434\u0430\u0432\u043d\u044c\u043e\u043d\u043e\u0440\u0432\u0435\u0437\u044c\u043a\u0430" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0430\u0437\u0456\u044f" },
            { "%%AREVMDA", "\u0417\u0430\u0445\u0456\u0434\u043d\u043e\u0432\u0456\u0440\u043c\u0435\u043d\u0441\u044c\u043a\u0438\u0439" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0456\u044f" },
            { "WF", "\u0423\u043e\u043b\u043b\u0456\u0441 \u0456 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "type.co.traditional", "\u0442\u0440\u0430\u0434\u0438\u0446\u0456\u0439\u043d\u0438\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f" },
            { "057", "\u041c\u0456\u043a\u0440\u043e\u043d\u0435\u0437\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0435\u0433\u0456\u043e\u043d" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u0430" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0430" },
            { "type.nu.finance", "\u0444\u0456\u043d\u0430\u043d\u0441\u043e\u0432\u0456 \u0441\u0438\u043c\u0432\u043e\u043b\u0438 \u0447\u0438\u0441\u0435\u043b" },
            { "type.co.compat", "\u043f\u043e\u043f\u0435\u0440\u0435\u0434\u043d\u0456\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f, \u0434\u043b\u044f \u0441\u0443\u043c\u0456\u0441\u043d\u043e\u0441\u0442\u0456" },
            { "wae", "\u0432\u0430\u043b\u044c\u0437\u0435\u0440\u0441\u044c\u043a\u0430" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "Bass", "\u0431\u0430\u0441\u0441\u0430" },
            { "wal", "\u0432\u043e\u043b\u0430\u0439\u0442\u0442\u0430" },
            { "was", "\u0432\u0430\u0448\u043e" },
            { "XA", "\u041f\u0441\u0435\u0432\u0434\u043e\u0430\u043a\u0446\u0435\u043d\u0442\u0438" },
            { "war", "\u0432\u0430\u0440\u0430\u0439" },
            { "XB", "\u041f\u0441\u0435\u0432\u0434\u043e\u0431\u0456\u0434\u0456" },
            { "awa", "\u0430\u0432\u0430\u0434\u0445\u0456" },
            { "061", "\u041f\u043e\u043b\u0456\u043d\u0435\u0437\u0456\u044f" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0431\u0435\u0437\u043f\u0438\u0441\u0435\u043c\u043d\u0430" },
            { "Olck", "\u0441\u0430\u043d\u0442\u0430\u043b\u044c\u0441\u044c\u043a\u0438\u0439" },
            { "wbp", "\u0432\u0430\u043b\u043f\u0456\u0440\u0456" },
            { "Batk", "\u0431\u0430\u0442\u0430\u043a" },
            { "Blis", "\u0441\u0438\u043c\u0432\u043e\u043b\u0438 \u0411\u043b\u0456\u0441\u0441\u0430" },
            { "YE", "\u0404\u043c\u0435\u043d" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0438\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f" },
            { "fan", "\u0444\u0430\u043d\u0433" },
            { "%%ROZAJ", "\u0420\u0435\u0437\u044c\u044f\u043d\u0441\u044c\u043a\u0438\u0439" },
            { "fat", "\u0444\u0430\u043d\u0442\u0456" },
            { "Sgnw", "\u0437\u043d\u0430\u043a\u043e\u0432\u0438\u0439" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0430" },
            { "ZA", "\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u043e-\u0410\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430" },
            { "type.lb.loose", "\u043d\u0435\u0442\u043e\u0447\u043d\u0438\u0439 \u0441\u0442\u0438\u043b\u044c \u0440\u043e\u0437\u0440\u0438\u0432\u0443 \u0440\u044f\u0434\u043a\u0430" },
            { "Deva", "\u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0456" },
            { "type.nu.geor", "\u0433\u0440\u0443\u0437\u0438\u043d\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "type.co.zhuyin", "\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f \u0447\u0436\u0443\u0457\u043d\u044c" },
            { "Hira", "\u0445\u0456\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0456\u044f" },
            { "%%PINYIN", "\u0420\u043e\u043c\u0430\u043d\u0456\u0437\u0430\u0446\u0456\u044f \u043f\u0456\u043d\u044c\u0457\u043d" },
            { "ZW", "\u0417\u0456\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u041d\u0435\u0432\u0456\u0434\u043e\u043c\u0438\u0439 \u0440\u0435\u0433\u0456\u043e\u043d" },
            { "Runr", "\u0440\u0443\u043d\u0456\u0447\u043d\u0438\u0439" },
            { "type.ms.metric", "\u043c\u0435\u0440\u0442\u0438\u0447\u043d\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u0430" },
            { "type.ca.iso8601", "\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 ISO-8601" },
            { "lol", "\u043c\u043e\u043d\u0433\u043e" },
            { "nso", "\u043f\u0456\u0432\u043d\u0456\u0447\u043d\u0430 \u0441\u043e\u0442\u043e" },
            { "type.nu.telu", "\u0446\u0438\u0444\u0440\u0438 \u0442\u0435\u043b\u0443\u0433\u0443" },
            { "lou", "\u043b\u0443\u0457\u0437\u0456\u0430\u043d\u0441\u044c\u043a\u0430 \u043a\u0440\u0435\u043e\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "loz", "\u043b\u043e\u0437\u0456" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c\u0435" },
            { "type.nu.hansfin", "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0456 \u0444\u0456\u043d\u0430\u043d\u0441\u043e\u0432\u0456 \u0441\u0438\u043c\u0432\u043e\u043b\u0438 \u0447\u0438\u0441\u0435\u043b (\u0441\u043f\u0440\u043e\u0449\u0435\u043d\u0435 \u043f\u0438\u0441\u044c\u043c\u043e)" },
            { "hil", "\u0445\u0456\u043b\u0456\u0433\u0430\u0439\u043d\u043e\u043d" },
            { "type.nu.arabext", "\u0430\u0440\u0430\u0431\u0441\u044c\u043a\u043e-\u0456\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0456 \u0440\u043e\u0437\u0448\u0438\u0440\u0435\u043d\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "nus", "\u043d\u0443\u0435\u0440" },
            { "dak", "\u0434\u0430\u043a\u043e\u0442\u0430" },
            { "type.nu.fullwide", "\u0446\u0438\u0444\u0440\u0438 \u043f\u043e\u0432\u043d\u043e\u0457 \u0448\u0438\u0440\u0438\u043d\u0438" },
            { "hit", "\u0445\u0456\u0442\u0456\u0442\u0456" },
            { "dar", "\u0434\u0430\u0440\u0433\u0456\u043d\u0441\u044c\u043a\u0430" },
            { "dav", "\u0442\u0430\u0456\u0442\u0430" },
            { "Maya", "\u043c\u0430\u0439\u044f \u0456\u0454\u0440\u043e\u0433\u043b\u0456\u0444\u0456\u0447\u043d\u0438\u0439" },
            { "lrc", "\u043f\u0456\u0432\u043d\u0456\u0447\u043d\u043e\u043b\u0443\u0440\u0441\u044c\u043a\u0430" },
            { "type.co.emoji", "\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f \u0437\u0430 \u0435\u043c\u043e\u0434\u0437\u0456" },
            { "Copt", "\u043a\u043e\u043f\u0442\u0441\u044c\u043a\u0438\u0439" },
            { "nwc", "\u043d\u0435\u0432\u0430\u0440\u0456 \u043a\u043b\u0430\u0441\u0438\u0447\u043d\u0430" },
            { "udm", "\u0443\u0434\u043c\u0443\u0440\u0442\u0441\u044c\u043a\u0430" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "\u0456\u0441\u043b\u0430\u043c\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 \u0421\u0430\u0443\u0434\u0456\u0432\u0441\u044c\u043a\u043e\u0457 \u0410\u0440\u0430\u0432\u0456\u0457" },
            { "Limb", "\u043b\u0456\u043c\u0431\u0443" },
            { "sad", "\u0441\u0430\u043d\u0434\u0430\u0432\u0435" },
            { "type.nu.roman", "\u0440\u0438\u043c\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "sah", "\u0441\u0430\u0445\u0430" },
            { "sam", "\u0441\u0430\u043c\u0430\u0440\u0438\u0442\u044f\u043d\u0441\u044c\u043a\u0430 \u0430\u0440\u0430\u043c\u0435\u0439\u0441\u044c\u043a\u0430" },
            { "Aghb", "\u043a\u0430\u0432\u043a\u0430\u0437\u044c\u043a\u0430 \u0430\u043b\u0431\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "%%SCOUSE", "\u041b\u0456\u0432\u0435\u0440\u043f\u0443\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0434\u0456\u0430\u043b\u0435\u043a\u0442" },
            { "saq", "\u0441\u0430\u043c\u0431\u0443\u0440\u0443" },
            { "sas", "\u0441\u0430\u0441\u0430\u043a\u0441\u044c\u043a\u0430" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "Tfng", "\u0442\u0438\u0444\u0456\u043d\u0430\u0433" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "jpr", "\u044e\u0434\u0435\u043e-\u043f\u0435\u0440\u0441\u044c\u043a\u0430" },
            { "type.nu.native", "\u043c\u0456\u0441\u0446\u0435\u0432\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "sba", "\u043d\u0433\u0430\u043c\u0431\u0430\u0439" },
            { "Guru", "\u0433\u0443\u0440\u043c\u0443\u0445\u0456" },
            { "lua", "\u043b\u0443\u0431\u0430-\u043b\u0443\u043b\u0443\u0430" },
            { "type.d0.fwidth", "\u043f\u043e\u0432\u043d\u0430 \u0448\u0438\u0440\u0438\u043d\u0430" },
            { "sbp", "\u0441\u0430\u043d\u0433\u0443" },
            { "lui", "\u043b\u0443\u0457\u0441\u0435\u043d\u044c\u043e" },
            { "nyn", "\u043d\u044c\u044f\u043d\u043a\u043e\u043b\u0435" },
            { "nym", "\u043d\u044c\u044f\u043c\u0432\u0435\u0437\u0456" },
            { "lun", "\u043b\u0443\u043d\u0434\u0430" },
            { "nyo", "\u043d\u044c\u043e\u0440\u043e" },
            { "luo", "\u043b\u0443\u043e" },
            { "fil", "\u0444\u0456\u043b\u0456\u043f\u043f\u0456\u043d\u0441\u044c\u043a\u0430" },
            { "hmn", "\u0445\u043c\u043e\u043d\u0433" },
            { "del", "\u0434\u0435\u043b\u0430\u0432\u0430\u0440\u0441\u044c\u043a\u0430" },
            { "lus", "\u043c\u0456\u0437\u043e" },
            { "bal", "\u0431\u0430\u043b\u0443\u0447\u0456" },
            { "den", "\u0441\u043b\u0435\u0439\u0432" },
            { "ban", "\u0431\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "uga", "\u0443\u0433\u0430\u0440\u0438\u0442\u0441\u044c\u043a\u0430" },
            { "luy", "\u043b\u0443\u0439\u044f" },
            { "bar", "\u0431\u0430\u0435\u0440\u0456\u0448" },
            { "bas", "\u0431\u0430\u0441\u0430" },
            { "bax", metaValue_bax },
            { "jrb", "\u044e\u0434\u0435\u043e-\u0430\u0440\u0430\u0431\u0441\u044c\u043a\u0430" },
            { "es_ES", "\u0454\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u0430 \u0456\u0441\u043f\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "nzi", "\u043d\u0437\u0456\u043c\u0430" },
            { "sco", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0430" },
            { "scn", "\u0441\u0438\u0446\u0438\u043b\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "aa", "\u0430\u0444\u0430\u0440\u0441\u044c\u043a\u0430" },
            { "ab", "\u0430\u0431\u0445\u0430\u0437\u044c\u043a\u0430" },
            { "Aran", "\u043d\u0430\u0441\u0442\u0430\u043b\u0456\u043a" },
            { "bbc", "\u0431\u0430\u0442\u0430\u043a \u0442\u043e\u0431\u0430" },
            { "ae", "\u0430\u0432\u0435\u0441\u0442\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u0430\u043d\u0441" },
            { "ak", "\u0430\u043a\u0430\u043d" },
            { "bbj", "\u0433\u043e\u043c\u0430\u043b\u0430" },
            { "am", "\u0430\u043c\u0445\u0430\u0440\u0441\u044c\u043a\u0430" },
            { "an", "\u0430\u0440\u0430\u0433\u043e\u043d\u0441\u044c\u043a\u0430" },
            { "Arab", "\u0430\u0440\u0430\u0431\u0438\u0446\u044f" },
            { "%%SOLBA", "\u0414\u0456\u0430\u043b\u0435\u043a\u0442 \u0421\u0442\u043e\u043b\u0432\u0456\u0446\u0430/\u0421\u043e\u043b\u0431\u0456\u043a\u0430" },
            { "Jpan", metaValue_ja },
            { "ar", "\u0430\u0440\u0430\u0431\u0441\u044c\u043a\u0430" },
            { "Hrkt", "\u044f\u043f\u043e\u043d\u0441\u044c\u043a\u0456 \u0441\u0438\u043b\u0430\u0431\u0430\u0440\u0456\u0457" },
            { "as", "\u0430\u0441\u0430\u043c\u0441\u044c\u043a\u0430" },
            { "Lina", "\u043b\u0456\u043d\u0456\u0439\u043d\u0438\u0439 \u0410" },
            { "av", "\u0430\u0432\u0430\u0440\u0441\u044c\u043a\u0430" },
            { "Linb", "\u043b\u0456\u043d\u0456\u0439\u043d\u0438\u0439 \u0412" },
            { "sdh", "\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u043a\u0443\u0440\u0434\u0441\u044c\u043a\u0430" },
            { "ay", "\u0430\u0439\u043c\u0430\u0440\u0430" },
            { "az", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "%%OSOJS", "\u041e\u0441\u043e\u044f\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0456\u0430\u043b\u0435\u043a\u0442" },
            { "ba", "\u0431\u0430\u0448\u043a\u0438\u0440\u0441\u044c\u043a\u0430" },
            { "type.co.unihan", "\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f \u0437\u0430 \u043a\u043b\u044e\u0447\u0430\u043c\u0438 \u0456\u0454\u0440\u043e\u0433\u043b\u0456\u0444\u0456\u0432" },
            { "be", "\u0431\u0456\u043b\u043e\u0440\u0443\u0441\u044c\u043a\u0430" },
            { "bg", "\u0431\u043e\u043b\u0433\u0430\u0440\u0441\u044c\u043a\u0430" },
            { "bi", "\u0431\u0456\u0441\u043b\u0430\u043c\u0430" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0430" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u0434\u043e\u0433\u0440\u0438\u0431\u0441\u044c\u043a\u0430" },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d\u0441\u044c\u043a\u0430" },
            { "bs", "\u0431\u043e\u0441\u043d\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "see", "\u0441\u0435\u043d\u0435\u043a\u0430" },
            { "Mymr", "\u043c\u02bc\u044f\u043d\u043c\u0441\u044c\u043a\u0430" },
            { "type.nu.laoo", "\u043b\u0430\u043e\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u0441\u0435\u043b\u044c\u043a\u0443\u043f\u0441\u044c\u043a\u0430" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u043e\u043d\u0441\u044c\u043a\u0430" },
            { "ses", "\u043a\u043e\u0439\u0440\u0430\u0431\u043e\u0440\u043e \u0441\u0435\u043d\u0456" },
            { "ce", "\u0447\u0435\u0447\u0435\u043d\u0441\u044c\u043a\u0430" },
            { "ch", "\u0447\u0430\u043c\u043e\u0440\u0440\u043e" },
            { "%%REVISED", "\u041d\u043e\u0432\u0430 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0456\u044f" },
            { "co", "\u043a\u043e\u0440\u0441\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "Orya", "\u043e\u0440\u0456\u044f" },
            { "cr", "\u043a\u0440\u0456" },
            { "cs", "\u0447\u0435\u0441\u044c\u043a\u0430" },
            { "cu", "\u0446\u0435\u0440\u043a\u043e\u0432\u043d\u043e\u0441\u043b\u043e\u0432\u02bc\u044f\u043d\u0441\u044c\u043a\u0430" },
            { "cv", "\u0447\u0443\u0432\u0430\u0441\u044c\u043a\u0430" },
            { "cy", "\u0432\u0430\u043b\u043b\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "type.nu.ethi", "\u0435\u0444\u0456\u043e\u043f\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "Yiii", "\u0439\u0457" },
            { "da", "\u0434\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "pt_PT", "\u0454\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u0430 \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "de", "\u043d\u0456\u043c\u0435\u0446\u044c\u043a\u0430" },
            { "type.cf.standard", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0438\u0439 \u0433\u0440\u043e\u0448\u043e\u0432\u0438\u0439 \u0444\u043e\u0440\u043c\u0430\u0442" },
            { "bej", "\u0431\u0435\u0434\u0436\u0430" },
            { "din", "\u0434\u0456\u043d\u043a\u0430" },
            { "Bugi", "\u0431\u0443\u0433\u0456\u0439\u0441\u044c\u043a\u0438\u0439" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "sga", "\u0434\u0430\u0432\u043d\u044c\u043e\u0456\u0440\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0430" },
            { "type.nu.mong", "\u043c\u043e\u043d\u0433\u043e\u043b\u044c\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "dv", "\u0434\u0456\u0432\u0435\u0445\u0456" },
            { "es_419", "\u043b\u0430\u0442\u0438\u043d\u043e\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u0456\u0441\u043f\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "bew", "\u0431\u0435\u0442\u0430\u0432\u0456" },
            { "dz", "\u0434\u0437\u043e\u043d\u0433-\u043a\u0435" },
            { "bez", "\u0431\u0435\u043d\u0430" },
            { "type.ca.chinese", "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "Lisu", "\u0430\u0431\u0435\u0442\u043a\u0430 \u0424\u0440\u0435\u0439\u0437\u0435\u0440\u0430" },
            { "dje", "\u0434\u0436\u0435\u0440\u043c\u0430" },
            { "type.nu.grek", "\u0433\u0440\u0435\u0446\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "ee", "\u0435\u0432\u0435" },
            { "bfd", "\u0431\u0430\u0444\u0443\u0442" },
            { "type.lb.normal", "\u0437\u0432\u0438\u0447\u0430\u0439\u043d\u0438\u0439 \u0441\u0442\u0438\u043b\u044c \u0440\u043e\u0437\u0440\u0438\u0432\u0443 \u0440\u044f\u0434\u043a\u0430" },
            { "ro_MD", "\u043c\u043e\u043b\u0434\u0430\u0432\u0441\u044c\u043a\u0430" },
            { "el", metaValue_el },
            { "en", "\u0430\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "eo", "\u0435\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "bfq", "\u0431\u0430\u0434\u0430\u0433\u0430" },
            { "type.co.big5han", "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u0442\u0440\u0430\u0434\u0438\u0446\u0456\u0439\u043d\u0438\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f Big5" },
            { "es", "\u0456\u0441\u043f\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "et", "\u0435\u0441\u0442\u043e\u043d\u0441\u044c\u043a\u0430" },
            { "Hanb", "\u0445\u0430\u043d\u044c" },
            { "eu", "\u0431\u0430\u0441\u043a\u0441\u044c\u043a\u0430" },
            { "Buhd", "\u0431\u0443\u0445\u0456\u0434" },
            { "Hang", "\u0445\u0430\u043d\u0433\u0438\u043b\u044c" },
            { "Samr", "\u0441\u0430\u043c\u0430\u0440\u0438\u0442\u044f\u043d\u0441\u044c\u043a\u0438\u0439" },
            { "shi", "\u0442\u0430\u0447\u0435\u043b\u0456\u0442" },
            { "Hani", metaValue_zh },
            { "hsb", "\u0432\u0435\u0440\u0445\u043d\u044c\u043e\u043b\u0443\u0436\u0438\u0446\u044c\u043a\u0430" },
            { "shn", "\u0448\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "Hano", "\u0445\u0430\u043d\u0443\u043d\u0443" },
            { "fa", "\u043f\u0435\u0440\u0441\u044c\u043a\u0430" },
            { "Hans", "\u0441\u043f\u0440\u043e\u0449\u0435\u043d\u0430" },
            { "type.nu.latn", "\u0437\u0430\u0445\u0456\u0434\u043d\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "Hant", "\u0442\u0440\u0430\u0434\u0438\u0446\u0456\u0439\u043d\u0430" },
            { "az_Arab", "\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "ff", "\u0444\u0443\u043b\u0430" },
            { "shu", "\u0447\u0430\u0434\u0456\u0439\u0441\u044c\u043a\u0430 \u0430\u0440\u0430\u0431\u0441\u044c\u043a\u0430" },
            { "hsn", "\u0441\u044f\u043d\u0441\u044c\u043a\u0430 \u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0430" },
            { "fi", "\u0444\u0456\u043d\u0441\u044c\u043a\u0430" },
            { "fj", "\u0444\u0456\u0434\u0436\u0456" },
            { "fon", "\u0444\u043e\u043d" },
            { "bgn", "\u0441\u0445\u0456\u0434\u043d\u043e\u0431\u0435\u043b\u0443\u0434\u0436\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "yue", "\u043a\u0430\u043d\u0442\u043e\u043d\u0441\u044c\u043a\u0430" },
            { "fo", "\u0444\u0430\u0440\u0435\u0440\u0441\u044c\u043a\u0430" },
            { "type.m0.bgn", "\u0442\u0440\u0430\u043d\u0441\u043b\u0456\u0442\u0435\u0440\u0430\u0446\u0456\u044f \u0420\u0413\u041d \u0421\u0428\u0410" },
            { "umb", "\u0443\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0430" },
            { "sid", "\u0441\u0456\u0434\u0430\u043c\u043e" },
            { "fy", "\u0437\u0430\u0445\u0456\u0434\u043d\u043e\u0444\u0440\u0438\u0437\u044c\u043a\u0430" },
            { "ga", "\u0456\u0440\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0430" },
            { "gd", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0430 \u0433\u0435\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "gl", "\u0433\u0430\u043b\u0456\u0441\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0456" },
            { "bho", "\u0431\u0445\u043e\u0434\u0436\u043f\u0443\u0440\u0456" },
            { "und", "\u043d\u0435\u0432\u0456\u0434\u043e\u043c\u0430 \u043c\u043e\u0432\u0430" },
            { "type.ca.ethiopic-amete-alem", "\u0435\u0444\u0456\u043e\u043f\u0441\u044c\u043a\u0438\u0439 \u0430\u043c\u0435\u0442\u0435 \u0430\u043b\u0435\u043c \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u0456\u0441\u043b\u0430\u043c\u0441\u044c\u043a\u0438\u0439 \u0430\u0441\u0442\u0440\u043e\u043d\u043e\u043c\u0456\u0447\u043d\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "gv", "\u043c\u0435\u043d\u043a\u0441\u044c\u043a\u0430" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "he", metaValue_he },
            { "hi", "\u0433\u0456\u043d\u0434\u0456" },
            { "hup", "\u0445\u0443\u043f\u0430" },
            { "bik", "\u0431\u0456\u043a\u043e\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "bin", "\u0431\u0456\u043d\u0456" },
            { "ho", "\u0445\u0456\u0440\u0456-\u043c\u043e\u0442\u0443" },
            { "hr", "\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u044c\u043a\u0430" },
            { "ht", "\u0433\u0430\u0457\u0442\u044f\u043d\u0441\u044c\u043a\u0430 \u043a\u0440\u0435\u043e\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "hu", "\u0443\u0433\u043e\u0440\u0441\u044c\u043a\u0430" },
            { "hy", metaValue_hy },
            { "hz", "\u0433\u0435\u0440\u0435\u0440\u043e" },
            { "frc", "\u043a\u0430\u0436\u0443\u043d\u0441\u044c\u043a\u0430 \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0430" },
            { "%%FONIPA", "\u041c\u0456\u0436\u043d\u0430\u0440\u043e\u0434\u043d\u0438\u0439 \u0444\u043e\u043d\u0435\u0442\u0438\u0447\u043d\u0438\u0439 \u0430\u043b\u0444\u0430\u0432\u0456\u0442" },
            { "ia", "\u0456\u043d\u0442\u0435\u0440\u043b\u0456\u043d\u0433\u0432\u0430" },
            { "Jamo", "\u0447\u0430\u043c\u043e" },
            { "id", "\u0456\u043d\u0434\u043e\u043d\u0435\u0437\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "type.nu.tibt", "\u0442\u0438\u0431\u0435\u0442\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "ie", "\u0456\u043d\u0442\u0435\u0440\u043b\u0456\u043d\u0433\u0432\u0435" },
            { "ig", "\u0456\u0433\u0431\u043e" },
            { "ii", "\u0441\u0438\u0447\u0443\u0430\u043d\u044c\u0441\u044c\u043a\u0430 \u0457" },
            { "frm", "\u0441\u0435\u0440\u0435\u0434\u043d\u044c\u043e\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0430" },
            { "ik", "\u0456\u043d\u0443\u043f\u0456\u0430\u043a" },
            { "fro", "\u0434\u0430\u0432\u043d\u044c\u043e\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0430" },
            { "frp", "\u0430\u0440\u043f\u0456\u0442\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "io", "\u0456\u0434\u043e" },
            { "frs", "\u0444\u0440\u0438\u0437\u044c\u043a\u0430 \u0441\u0445\u0456\u0434\u043d\u0430" },
            { "bjn", "\u0431\u0430\u043d\u0434\u0436\u0430\u0440\u0441\u044c\u043a\u0430" },
            { "frr", "\u0444\u0440\u0438\u0437\u044c\u043a\u0430 \u043f\u0456\u0432\u043d\u0456\u0447\u043d\u0430" },
            { "is", "\u0456\u0441\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0430" },
            { "it", "\u0456\u0442\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "iu", "\u0456\u043d\u0443\u043a\u0442\u0456\u0442\u0443\u0442" },
            { "ja", metaValue_ja },
            { "Mlym", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c\u0441\u044c\u043a\u0430" },
            { "Sara", "\u0441\u0430\u0440\u0430\u0442\u0456" },
            { "doi", "\u0434\u043e\u0433\u0440\u0456" },
            { "bkm", "\u043a\u043e\u043c" },
            { "sma", "\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u0441\u0430\u0430\u043c\u0441\u044c\u043a\u0430" },
            { "jv", "\u044f\u0432\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "Shaw", "\u0448\u043e\u0443" },
            { "mad", "\u043c\u0430\u0434\u0443\u0440\u0441\u044c\u043a\u0430" },
            { "smj", "\u0441\u0430\u0430\u043c\u0441\u044c\u043a\u0430 \u043b\u0443\u043b\u0435" },
            { "mag", "\u043c\u0430\u0433\u0430\u0434\u0445\u0456" },
            { "maf", "\u043c\u0430\u0444\u0430" },
            { "mai", "\u043c\u0430\u0439\u0442\u0445\u0456\u043b\u0456" },
            { "smn", "\u0441\u0430\u0430\u043c\u0441\u044c\u043a\u0430 \u0456\u043d\u0430\u0440\u0456" },
            { "ka", metaValue_ka },
            { "bla", "\u0441\u0456\u043a\u0441\u0456\u043a\u0430" },
            { "mak", "\u043c\u0430\u043a\u0430\u0441\u0430\u0440\u0441\u044c\u043a\u0430" },
            { "wuu", "\u0443\u0441\u044c\u043a\u0430 \u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0430" },
            { "sms", "\u0441\u043a\u043e\u043b\u044c\u0442-\u0441\u0430\u0430\u043c\u0441\u044c\u043a\u0430" },
            { "man", "\u043c\u0430\u043d\u0434\u0456\u043d\u0433\u043e" },
            { "kg", "\u043a\u043e\u043d\u0491\u043e\u043b\u0435\u0437\u044c\u043a\u0430" },
            { "Goth", "\u0433\u043e\u0442\u0438\u0447\u043d\u0438\u0439" },
            { "ki", "\u043a\u0456\u043a\u0443\u0439\u044e" },
            { "mas", "\u043c\u0430\u0441\u0430\u0457" },
            { "kj", "\u043a\u0443\u043d\u0430\u043c\u0430" },
            { "kk", "\u043a\u0430\u0437\u0430\u0445\u0441\u044c\u043a\u0430" },
            { "kl", "\u043a\u0430\u043b\u0430\u0430\u043b\u043b\u0456\u0441\u0443\u0442" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u0456" },
            { "ks", "\u043a\u0430\u0448\u043c\u0456\u0440\u0441\u044c\u043a\u0430" },
            { "Cirt", "\u043a\u0438\u0440\u0442" },
            { "Lepc", "\u043b\u0435\u043f\u0447\u0430" },
            { "Avst", "\u0430\u0432\u0435\u0441\u0442\u0456\u0439\u0441\u044c\u043a\u0438\u0439" },
            { "ku", "\u043a\u0443\u0440\u0434\u0441\u044c\u043a\u0430" },
            { "kv", "\u043a\u043e\u043c\u0456" },
            { "kw", "\u043a\u043e\u0440\u043d\u0441\u044c\u043a\u0430" },
            { "ky", "\u043a\u0438\u0440\u0433\u0438\u0437\u044c\u043a\u0430" },
            { "snk", "\u0441\u043e\u043d\u0456\u043d\u043a\u0435" },
            { "la", "\u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u0430" },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0437\u044c\u043a\u0430" },
            { "type.nu.mlym", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430" },
            { "Roro", "\u0440\u043e\u043d\u0433\u043e-\u0440\u043e\u043d\u0433\u043e" },
            { "li", "\u043b\u0456\u043c\u0431\u0443\u0440\u0433\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "Tibt", metaValue_bo },
            { "ln", "\u043b\u0456\u043d\u0433\u0430\u043b\u0430" },
            { "fur", "\u0444\u0440\u0456\u0443\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0430\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043c\u0456\u0440" },
            { "lt", "\u043b\u0438\u0442\u043e\u0432\u0441\u044c\u043a\u0430" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "lv", "\u043b\u0430\u0442\u0438\u0441\u044c\u043a\u0430" },
            { "sog", "\u0441\u043e\u0433\u0434\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "mh", "\u043c\u0430\u0440\u0448\u0430\u043b\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "type.co.ducet", "\u0442\u0438\u043f\u043e\u0432\u0438\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f \u042e\u043d\u0456\u043a\u043e\u0434" },
            { "mi", "\u043c\u0430\u043e\u0440\u0456" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u044c\u043a\u0430" },
            { "ml", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c" },
            { "mn", metaValue_mn },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0445\u0456" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439\u0441\u044c\u043a\u0430" },
            { "mt", "\u043c\u0430\u043b\u044c\u0442\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "my", "\u0431\u0456\u0440\u043c\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "Saur", "\u0441\u0430\u0443\u0440\u0430\u0448\u0442\u0440\u0430" },
            { "Armn", metaValue_hy },
            { "mdf", "\u043c\u043e\u043a\u0448\u0430" },
            { "mde", "\u043c\u0430\u0431\u0430" },
            { "dsb", "\u043d\u0438\u0436\u043d\u044c\u043e\u043b\u0443\u0436\u0438\u0446\u044c\u043a\u0430" },
            { "Armi", "\u0430\u0440\u043c\u0456" },
            { "na", "\u043d\u0430\u0443\u0440\u0443" },
            { "type.co.search", "\u0443\u043d\u0456\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u0438\u0439 \u043f\u043e\u0448\u0443\u043a" },
            { "nb", "\u043d\u043e\u0440\u0432\u0435\u0437\u044c\u043a\u0430 (\u0431\u0443\u043a\u043c\u043e\u043b)" },
            { "nd", "\u043f\u0456\u0432\u043d\u0456\u0447\u043d\u0430 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "ng", "\u043d\u0434\u043e\u043d\u0433\u0430" },
            { "mdr", "\u043c\u0430\u043d\u0434\u0430\u0440\u0441\u044c\u043a\u0430" },
            { "nl", "\u043d\u0456\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0430" },
            { "nn", "\u043d\u043e\u0440\u0432\u0435\u0437\u044c\u043a\u0430 (\u043d\u044e\u043d\u043e\u0448\u043a)" },
            { "no", "\u043d\u043e\u0440\u0432\u0435\u0437\u044c\u043a\u0430" },
            { "nr", "\u043d\u0434\u0435\u0431\u0435\u043b\u0454 \u043f\u0456\u0432\u0434\u0435\u043d\u043d\u0430" },
            { "Osge", "\u043e\u0441\u0435\u0439\u0434\u0436\u0438\u0441\u044c\u043a\u0430" },
            { "nv", "\u043d\u0430\u0432\u0430\u0445\u043e" },
            { "kaa", "\u043a\u0430\u0440\u0430\u043a\u0430\u043b\u043f\u0430\u0446\u044c\u043a\u0430" },
            { "ny", "\u043d\u044c\u044f\u043d\u0434\u0436\u0430" },
            { "kac", "\u043a\u0430\u0447\u0456\u043d" },
            { "kab", "\u043a\u0430\u0431\u0456\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "%%POLYTON", "\u041f\u043e\u043b\u0456\u0442\u043e\u043d\u0456\u0447\u043d\u0438\u0439" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "kaj", "\u0439\u044e" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430" },
            { "men", "\u043c\u0435\u043d\u0434\u0435" },
            { "oj", "\u043e\u0434\u0436\u0456\u0431\u0432\u0430" },
            { "mer", "\u043c\u0435\u0440\u0443" },
            { "type.nu.armn", "\u0432\u0456\u0440\u043c\u0435\u043d\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "kaw", "\u043a\u0430\u0432\u0456" },
            { "or", "\u043e\u0434\u0456\u044f" },
            { "os", "\u043e\u0441\u0435\u0442\u0438\u043d\u0441\u044c\u043a\u0430" },
            { "kbd", "\u043a\u0430\u0431\u0430\u0440\u0434\u0438\u043d\u0441\u044c\u043a\u0430" },
            { "mfe", "\u043c\u0430\u0432\u0440\u0438\u043a\u0456\u0439\u0441\u044c\u043a\u0430 \u043a\u0440\u0435\u043e\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "srn", "\u0441\u0440\u0430\u043d\u0430\u043d \u0442\u043e\u043d\u0433\u043e" },
            { "pa", "\u043f\u0430\u043d\u0434\u0436\u0430\u0431\u0456" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430" },
            { "srr", "\u0441\u0435\u0440\u0435\u0440" },
            { "%%LIPAW", "\u041b\u0456\u043f\u043e\u0432\u0430\u0437\u0441\u044c\u043a\u0438\u0439 \u0434\u0456\u0430\u043b\u0435\u043a\u0442 \u0440\u0435\u0437\u044c\u044f\u043d\u0441\u044c\u043a\u043e\u0457 \u043c\u043e\u0432\u0438" },
            { "kbl", "\u043a\u0430\u043d\u0435\u043c\u0431\u0443" },
            { "pi", "\u043f\u0430\u043b\u0456" },
            { "bqi", "\u0431\u0430\u0445\u0442\u0456\u0430\u0440\u0456" },
            { "pl", "\u043f\u043e\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "dum", "\u0441\u0435\u0440\u0435\u0434\u043d\u044c\u043e\u043d\u0456\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0430" },
            { "type.ca.dangi", "\u043a\u043e\u0440\u0435\u0439\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "mga", "\u0441\u0435\u0440\u0435\u0434\u043d\u044c\u043e\u0456\u0440\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0430" },
            { "key.co", "\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f" },
            { "pt_BR", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0430 \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "kcg", "\u0442\u0456\u0430\u043f" },
            { "mgh", "\u043c\u0430\u043a\u0443\u0432\u0430-\u043c\u0435\u0435\u0442\u043e" },
            { "key.cf", "\u0433\u0440\u043e\u0448\u043e\u0432\u0438\u0439 \u0444\u043e\u0440\u043c\u0430\u0442" },
            { "bra", "\u0431\u0440\u0430\u0434\u0436" },
            { "key.ca", "\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u043c\u0435\u0442\u0430" },
            { "type.hc.h23", "24-\u0433\u043e\u0434\u0438\u043d\u043d\u0438\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 (0\u201323)" },
            { "type.hc.h24", "24-\u0433\u043e\u0434\u0438\u043d\u043d\u0438\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 (1\u201324)" },
            { "ssy", "\u0441\u0430\u0445\u043e" },
            { "type.nu.mymr", "\u043c\u02bc\u044f\u043d\u043c\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "zap", "\u0441\u0430\u043f\u043e\u0442\u0435\u043a\u0441\u044c\u043a\u0430" },
            { "brx", "\u0431\u043e\u0434\u043e" },
            { "Lana", "\u043b\u0430\u043d\u043d\u0430" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u0435" },
            { "Ethi", "\u0435\u0444\u0456\u043e\u043f\u0441\u044c\u043a\u0430" },
            { "type.hc.h12", "12-\u0433\u043e\u0434\u0438\u043d\u043d\u0438\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 (1\u201312)" },
            { "type.hc.h11", "12-\u0433\u043e\u0434\u0438\u043d\u043d\u0438\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 (0\u201311)" },
            { "rm", "\u0440\u0435\u0442\u043e\u0440\u043e\u043c\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "rn", "\u0440\u0443\u043d\u0434\u0456" },
            { "key.cu", "\u0432\u0430\u043b\u044e\u0442\u0430" },
            { "ro", "\u0440\u0443\u043c\u0443\u043d\u0441\u044c\u043a\u0430" },
            { "%%SAAHO", "\u0421\u0430\u0445\u043e" },
            { "type.nu.orya", "\u0446\u0438\u0444\u0440\u0438 \u043e\u0440\u0456\u044f" },
            { "type.nu.hanidec", "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0456 \u0434\u0435\u0441\u044f\u0442\u043a\u043e\u0432\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "ru", "\u0440\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "bss", "\u0430\u043a\u0443\u0441" },
            { "rw", "\u043a\u0456\u043d\u044c\u044f\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "zbl", "\u0431\u043b\u0456\u0441\u0441\u0430 \u043c\u043e\u0432\u0430" },
            { "kea", "\u043a\u0430\u0431\u0443\u0432\u0435\u0440\u0434\u0456\u0430\u043d\u0443" },
            { "mic", "\u043c\u0456\u043a\u043c\u0430\u043a" },
            { "suk", "\u0441\u0443\u043a\u0443\u043c\u0430" },
            { "en_AU", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0430 \u0430\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "sc", "\u0441\u0430\u0440\u0434\u0438\u043d\u0441\u044c\u043a\u0430" },
            { "sus", "\u0441\u0443\u0441\u0443" },
            { "sd", "\u0441\u0438\u043d\u0434\u0445\u0456" },
            { "se", "\u043f\u0456\u0432\u043d\u0456\u0447\u043d\u043e\u0441\u0430\u0430\u043c\u0441\u044c\u043a\u0430" },
            { "min", "\u043c\u0456\u043d\u0430\u043d\u0433\u043a\u0430\u0431\u0430\u0443" },
            { "sg", "\u0441\u0430\u043d\u0433\u043e" },
            { "sh", "\u0441\u0435\u0440\u0431\u0441\u044c\u043a\u043e-\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u044c\u043a\u0430" },
            { "si", metaValue_si },
            { "sux", "\u0448\u0443\u043c\u0435\u0440\u0441\u044c\u043a\u0430" },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u0446\u044c\u043a\u0430" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u044c\u043a\u0430" },
            { "sm", "\u0441\u0430\u043c\u043e\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0456" },
            { "type.nu.arab", "\u0430\u0440\u0430\u0431\u0441\u044c\u043a\u043e-\u0456\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "sr", "\u0441\u0435\u0440\u0431\u0441\u044c\u043a\u0430" },
            { "ss", "\u0441\u0456\u0441\u0432\u0430\u0442\u0456" },
            { "type.cf.account", "\u043e\u0431\u043b\u0456\u043a\u043e\u0432\u0438\u0439 \u0433\u0440\u043e\u0448\u043e\u0432\u0438\u0439 \u0444\u043e\u0440\u043c\u0430\u0442" },
            { "st", "\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u0430 \u0441\u043e\u0442\u043e" },
            { "Java", "\u044f\u0432\u0430\u043d\u0441\u044c\u043a\u0438\u0439" },
            { "su", "\u0441\u0443\u043d\u0434\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "%%NEDIS", "\u041d\u0430\u0442\u0456\u0441\u043e\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0456\u0430\u043b\u0435\u043a\u0442" },
            { "sv", "\u0448\u0432\u0435\u0434\u0441\u044c\u043a\u0430" },
            { "sw", "\u0441\u0443\u0430\u0445\u0456\u043b\u0456" },
            { "type.nu.hantfin", "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0456 \u0444\u0456\u043d\u0430\u043d\u0441\u043e\u0432\u0456 \u0441\u0438\u043c\u0432\u043e\u043b\u0438 \u0447\u0438\u0441\u0435\u043b (\u0442\u0440\u0430\u0434\u0438\u0446\u0456\u0439\u043d\u0435 \u043f\u0438\u0441\u044c\u043c\u043e)" },
            { "ibb", "\u0456\u0431\u0456\u0431\u0456\u043e" },
            { "iba", "\u0456\u0431\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "ta", metaValue_ta },
            { "142", "\u0410\u0437\u0456\u044f" },
            { "bua", "\u0431\u0443\u0440\u044f\u0442\u0441\u044c\u043a\u0430" },
            { "143", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430 \u0410\u0437\u0456\u044f" },
            { "te", metaValue_te },
            { "145", "\u0417\u0430\u0445\u0456\u0434\u043d\u0430 \u0410\u0437\u0456\u044f" },
            { "tg", "\u0442\u0430\u0434\u0436\u0438\u0446\u044c\u043a\u0430" },
            { "th", metaValue_th },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u043d\u044c\u044f" },
            { "bug", "\u0431\u0443\u0433\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "kfo", "\u043a\u043e\u0440\u043e" },
            { "en_CA", "\u043a\u0430\u043d\u0430\u0434\u0441\u044c\u043a\u0430 \u0430\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u044c\u043a\u0430" },
            { "tl", "\u0442\u0430\u0433\u0430\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "tn", "\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "to", "\u0442\u043e\u043d\u0433\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "bum", "\u0431\u0443\u043b\u0443" },
            { "dyo", "\u0434\u044c\u043e\u043b\u0430-\u0444\u043e\u043d\u0456" },
            { "type.nu.jpan", "\u044f\u043f\u043e\u043d\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "tr", "\u0442\u0443\u0440\u0435\u0446\u044c\u043a\u0430" },
            { "Cakm", metaValue_ccp },
            { "ts", "\u0442\u0441\u043e\u043d\u0433\u0430" },
            { "swb", "\u043a\u043e\u043c\u043e\u0440\u0441\u044c\u043a\u0430" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440\u0441\u044c\u043a\u0430" },
            { "dyu", "\u0434\u0456\u0443\u043b\u0430" },
            { "tw", "\u0442\u0432\u0456" },
            { "ty", "\u0442\u0430\u0457\u0442\u044f\u043d\u0441\u044c\u043a\u0430" },
            { "%%BISKE", "\u0414\u0456\u0430\u043b\u0435\u043a\u0442 \u0421\u0430\u043d-\u0414\u0436\u043e\u0440\u0434\u0436\u0456\u043e/\u0411\u0456\u043b\u0430" },
            { "150", "\u0404\u0432\u0440\u043e\u043f\u0430" },
            { "151", "\u0421\u0445\u0456\u0434\u043d\u0430 \u0404\u0432\u0440\u043e\u043f\u0430" },
            { "154", "\u041f\u0456\u0432\u043d\u0456\u0447\u043d\u0430 \u0404\u0432\u0440\u043e\u043f\u0430" },
            { "dzg", "\u0434\u0430\u0437\u0430\u0433\u0430" },
            { "155", "\u0417\u0430\u0445\u0456\u0434\u043d\u0430 \u0404\u0432\u0440\u043e\u043f\u0430" },
            { "ug", "\u0443\u0439\u0433\u0443\u0440\u0441\u044c\u043a\u0430" },
            { "Kore", metaValue_ko },
            { "Ital", "\u0434\u0430\u0432\u043d\u044c\u043e\u0456\u0442\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439" },
            { "Zyyy", "\u0437\u0432\u0438\u0447\u0430\u0439\u043d\u0430" },
            { "uk", "\u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430" },
            { "type.ca.coptic", "\u043a\u043e\u043f\u0442\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "%%1994", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u0438\u0437\u043e\u0432\u0430\u043d\u0430 \u0440\u0435\u0437\u044c\u044f\u043d\u0441\u044c\u043a\u0430 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0456\u044f" },
            { "xal", "\u043a\u0430\u043b\u043c\u0438\u0446\u044c\u043a\u0430" },
            { "zen", "\u0437\u0435\u043d\u0430\u0433\u0430" },
            { "uz", "\u0443\u0437\u0431\u0435\u0446\u044c\u043a\u0430" },
            { "kha", "\u043a\u0445\u0430\u0441\u0456" },
            { "%%1996", "\u041d\u043e\u0432\u0430 \u043d\u0456\u043c\u0435\u0446\u044c\u043a\u0430 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0456\u044f \u0437 1996 \u0440." },
            { "nds_NL", "\u043d\u0438\u0436\u043d\u044c\u043e\u0441\u0430\u043a\u0441\u043e\u043d\u0441\u044c\u043a\u0430" },
            { "Sylo", "\u0441\u0456\u043b\u043e\u0442\u0456 \u043d\u0430\u0433\u0440\u0456" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "type.ca.roc", "\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 \u041a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u043e\u0457 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0438" },
            { "vi", "\u0432\u02bc\u0454\u0442\u043d\u0430\u043c\u0441\u044c\u043a\u0430" },
            { "kho", "\u0445\u043e\u0442\u0430\u043d\u043e\u0441\u0430\u043a\u0441\u044c\u043a\u0430" },
            { "khq", "\u043a\u043e\u0439\u0440\u0430 \u0447\u0456\u0457\u043d\u0456" },
            { "key.hc", "\u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0430\u0441\u0443 (12 \u0430\u0431\u043e 24 \u0433\u043e\u0434\u0438\u043d\u0438)" },
            { "%%TARASK", "\u041e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0456\u044f \u0422\u0430\u0440\u0430\u0441\u043a\u0435\u0432\u0438\u0447\u0430" },
            { "vo", "\u0432\u043e\u043b\u0430\u043f\u044e\u043a" },
            { "syc", "\u0441\u0438\u0440\u0456\u0439\u0441\u044c\u043a\u0430 \u043a\u043b\u0430\u0441\u0438\u0447\u043d\u0430" },
            { "Osma", "\u043e\u0441\u043c\u0430\u043d\u0441\u044c\u043a\u0438\u0439" },
            { "quc", "\u043a\u0456\u0447\u0435" },
            { "Newa", "\u043d\u0435\u0432\u0430" },
            { "gaa", "\u0433\u0430" },
            { "wa", "\u0432\u0430\u043b\u043b\u043e\u043d\u0441\u044c\u043a\u0430" },
            { "gag", "\u0433\u0430\u0433\u0430\u0443\u0437\u044c\u043a\u0430" },
            { "syr", "\u0441\u0438\u0440\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "Grek", metaValue_el },
            { "gan", "\u0491\u0430\u043d\u044c" },
            { "Lydi", "\u043b\u0456\u0434\u0456\u0439\u0441\u044c\u043a\u0438\u0439" },
            { "Xsux", "\u0448\u0443\u043c\u0435\u0440\u043e-\u0430\u043a\u043a\u0430\u0434\u0441\u044c\u043a\u0438\u0439 \u043a\u043b\u0456\u043d\u043e\u043f\u0438\u0441" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444" },
            { "zgh", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0430 \u043c\u0430\u0440\u043e\u043a\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u0431\u0435\u0440\u0431\u0435\u0440\u0441\u044c\u043a\u0430" },
            { "ar_001", "\u0441\u0443\u0447\u0430\u0441\u043d\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0430 \u0430\u0440\u0430\u0431\u0441\u044c\u043a\u0430" },
            { "Cans", "\u0443\u043d\u0456\u0444\u0456\u043a\u043e\u0432\u0430\u043d\u0456 \u0441\u0438\u043c\u0432\u043e\u043b\u0438 \u043a\u0430\u043d\u0430\u0434\u0441\u044c\u043a\u0438\u0445 \u0442\u0443\u0431\u0456\u043b\u044c\u0446\u0456\u0432" },
            { "gay", "\u0433\u0430\u0439\u043e" },
            { "Mong", metaValue_mn },
            { "mnc", "\u043c\u0430\u043d\u0447\u0436\u0443\u0440\u0441\u044c\u043a\u0430" },
            { "Latf", "\u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043a\u0442\u0443\u0440\u043d\u0438\u0439" },
            { "gba", "\u0433\u0431\u0430\u0439\u044f" },
            { "mni", "\u043c\u0430\u043d\u0456\u043f\u0443\u0440\u0456" },
            { "Latn", "\u043b\u0430\u0442\u0438\u043d\u0438\u0446\u044f" },
            { "Latg", "\u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u0433\u0435\u043b\u044c\u0441\u044c\u043a\u0438\u0439" },
            { "type.nu.hans", "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0456 \u0441\u0438\u043c\u0432\u043e\u043b\u0438 \u0447\u0438\u0441\u0435\u043b (\u0441\u043f\u0440\u043e\u0449\u0435\u043d\u0435 \u043f\u0438\u0441\u044c\u043c\u043e)" },
            { "type.nu.hant", "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0456 \u0441\u0438\u043c\u0432\u043e\u043b\u0438 \u0447\u0438\u0441\u0435\u043b (\u0442\u0440\u0430\u0434\u0438\u0446\u0456\u0439\u043d\u0435 \u043f\u0438\u0441\u044c\u043c\u043e)" },
            { "xh", "\u043a\u0445\u043e\u0441\u0430" },
            { "type.nu.romanlow", "\u0440\u0438\u043c\u0441\u044c\u043a\u0456 \u043c\u0430\u043b\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "byn", "\u0431\u043b\u0456\u043d" },
            { "Lyci", "\u043b\u0456\u043a\u0456\u0439\u0441\u044c\u043a\u0438\u0439" },
            { "osa", "\u043e\u0441\u0435\u0439\u0434\u0436" },
            { "byv", "\u043c\u0435\u0434\u0443\u043c\u0431\u0430" },
            { "Moon", "\u043c\u0443\u043d" },
            { "moh", "\u043c\u0430\u0433\u0430\u0432\u043a" },
            { "kkj", "\u043a\u0430\u043a\u043e" },
            { "yi", "\u0457\u0434\u0438\u0448" },
            { "mos", "\u043c\u043e\u0441\u0441\u0456" },
            { "Syrc", "\u0441\u0438\u0440\u0456\u0439\u0441\u044c\u043a\u0438\u0439" },
            { "Dsrt", "\u0434\u0435\u0437\u0435\u0440\u0435\u0442" },
            { "yo", "\u0439\u043e\u0440\u0443\u0431\u0430" },
            { "type.nu.traditional", "\u0442\u0440\u0430\u0434\u0438\u0446\u0456\u0439\u043d\u0456 \u0441\u0438\u043c\u0432\u043e\u043b\u0438 \u0447\u0438\u0441\u0435\u043b" },
            { "es_MX", "\u043c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u0456\u0441\u043f\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "Syrj", "\u0434\u0430\u0432\u043d\u044c\u043e\u0441\u0438\u0440\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0437\u0430\u0445\u0456\u0434\u043d\u0438\u0439" },
            { "ota", "\u043e\u0441\u043c\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "Syre", "\u0434\u0430\u0432\u043d\u044c\u043e\u0441\u0438\u0440\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0435\u0441\u0442\u0440\u0430\u043d\u0433\u0435\u043b\u043e" },
            { "vai", metaValue_vai },
            { "za", "\u0447\u0436\u0443\u0430\u043d" },
            { "Cari", "\u043a\u0430\u0440\u0456\u0430\u043d\u0441\u044c\u043a\u0438\u0439" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u0434\u0436\u0438\u043d" },
            { "zh", metaValue_zh },
            { "Afak", "\u0430\u0444\u0430\u043a\u0430" },
            { "Bopo", "\u0431\u043e\u043f\u043e\u043c\u043e\u0444\u043e" },
            { "Perm", "\u0434\u0430\u0432\u043d\u044c\u043e\u043f\u0435\u0440\u043c\u0441\u044c\u043a\u0438\u0439" },
            { "key.lb", "\u0441\u0442\u0438\u043b\u044c \u0440\u043e\u0437\u0440\u0438\u0432\u0443 \u0440\u044f\u0434\u043a\u0430" },
            { "zu", "\u0437\u0443\u043b\u0443\u0441\u044c\u043a\u0430" },
            { "type.co.phonebook", "\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f \u0437\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u0438\u043c \u0434\u043e\u0432\u0456\u0434\u043d\u0438\u043a\u043e\u043c" },
            { "%%MONOTON", "\u041c\u043e\u043d\u043e\u0442\u043e\u043d\u0456\u0447\u043d\u0438\u0439" },
            { "Geor", metaValue_ka },
            { "kmb", "\u043a\u0456\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "type.nu.jpanfin", "\u044f\u043f\u043e\u043d\u0441\u044c\u043a\u0456 \u0444\u0456\u043d\u0430\u043d\u0441\u043e\u0432\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "Cham", "\u0445\u0430\u043c\u0456\u0442\u0441\u044c\u043a\u0438\u0439" },
            { "gez", "\u0433\u0454\u0435\u0437" },
            { "Syrn", "\u0434\u0430\u0432\u043d\u044c\u043e\u0441\u0438\u0440\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0441\u0445\u0456\u0434\u043d\u0438\u0439" },
            { "type.co.reformed", "\u0440\u0435\u0444\u043e\u0440\u043c\u043e\u0432\u0430\u043d\u0438\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f" },
            { "Tglg", "\u0442\u0430\u0433\u0430\u043b\u044c\u0441\u044c\u043a\u0438\u0439" },
            { "Egyd", "\u0454\u0433\u0438\u043f\u0435\u0442\u0441\u044c\u043a\u0438\u0439 \u0434\u0435\u043c\u043e\u0442\u0438\u0447\u043d\u0438\u0439" },
            { "Egyh", "\u0454\u0433\u0438\u043f\u0435\u0442\u0441\u044c\u043a\u0438\u0439 \u0456\u0454\u0440\u0430\u0442\u0438\u0447\u043d\u0438\u0439" },
            { "ebu", "\u0435\u043c\u0431\u0443" },
            { "Egyp", "\u0454\u0433\u0438\u043f\u0435\u0442\u0441\u044c\u043a\u0438\u0439 \u0456\u0454\u0440\u043e\u0433\u043b\u0456\u0444\u0456\u0447\u043d\u0438\u0439" },
            { "Geok", "\u043a\u0445\u0443\u0442\u0441\u0443\u0440\u0456" },
            { "zh_Hans", "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0430 (\u0441\u043f\u0440\u043e\u0449\u0435\u043d\u0435 \u043f\u0438\u0441\u044c\u043c\u043e)" },
            { "koi", "\u043a\u043e\u043c\u0456-\u043f\u0435\u0440\u043c\u2019\u044f\u0446\u044c\u043a\u0430" },
            { "Hung", "\u0434\u0430\u0432\u043d\u044c\u043e\u0443\u0433\u043e\u0440\u0441\u044c\u043a\u0438\u0439" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0456" },
            { "%%1901", "\u0422\u0440\u0430\u0434\u0438\u0446\u0456\u0439\u043d\u0430 \u043d\u0456\u043c\u0435\u0446\u044c\u043a\u0430 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0456\u044f" },
            { "kos", "\u043a\u043e\u0441\u0440\u0430\u0435" },
            { "zh_Hant", "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0430 (\u0442\u0440\u0430\u0434\u0438\u0446\u0456\u0439\u043d\u0435 \u043f\u0438\u0441\u044c\u043c\u043e)" },
            { "Sund", "\u0441\u0443\u043d\u0434\u0430\u043d\u0441\u044c\u043a\u0438\u0439" },
            { "kpe", "\u043a\u043f\u0435\u043b\u043b\u0454" },
            { "type.nu.khmr", "\u043a\u0445\u043c\u0435\u0440\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "ilo", "\u0456\u043b\u043e\u043a\u0430\u043d\u0441\u044c\u043a\u0430" },
            { "%%VALENCIA", "\u0412\u0430\u043b\u0435\u043d\u0441\u0456\u0439\u0441\u044c\u043a\u0430" },
            { "Cprt", "\u043a\u0456\u043f\u0440\u0441\u044c\u043a\u0438\u0439" },
            { "%%BAKU1926", "\u0423\u043d\u0456\u0444\u0456\u043a\u043e\u0432\u0430\u043d\u0438\u0439 \u0442\u0443\u0440\u0435\u0446\u044c\u043a\u0438\u0439 \u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u0430\u043b\u0444\u0430\u0432\u0456\u0442" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "type.nu.guru", "\u0446\u0438\u0444\u0440\u0438 \u0433\u0443\u0440\u043c\u0443\u043a\u0445\u0456" },
            { "mul", "\u043a\u0456\u043b\u044c\u043a\u0430 \u043c\u043e\u0432" },
            { "cad", "\u043a\u0430\u0434\u0434\u043e" },
            { "key.ms", "\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u0432\u0438\u043c\u0456\u0440\u044e\u0432\u0430\u043d\u043d\u044f" },
            { "mus", "\u043a\u0440\u0456\u043a" },
            { "Glag", "\u0433\u043b\u0430\u0433\u043e\u043b\u0438\u0447\u043d\u0438\u0439" },
            { "gil", "\u0433\u0456\u043b\u044c\u0431\u0435\u0440\u0442\u0441\u044c\u043a\u0430" },
            { "Cher", metaValue_chr },
            { "car", "\u043a\u0430\u0440\u0456\u0431\u0441\u044c\u043a\u0430" },
            { "cay", "\u043a\u0430\u0439\u044e\u0433\u0430" },
            { "type.nu.tamldec", "\u0442\u0430\u043c\u0456\u043b\u044c\u0441\u044c\u043a\u0456 \u0446\u0438\u0444\u0440\u0438" },
            { "krc", "\u043a\u0430\u0440\u0430\u0447\u0430\u0454\u0432\u043e-\u0431\u0430\u043b\u043a\u0430\u0440\u0441\u044c\u043a\u0430" },
            { "inh", "\u0456\u043d\u0433\u0443\u0441\u044c\u043a\u0430" },
            { "fa_AF", "\u0434\u0430\u0440\u0456" },
            { "krl", "\u043a\u0430\u0440\u0435\u043b\u044c\u0441\u044c\u043a\u0430" },
            { "efi", "\u0435\u0444\u0456\u043a" },
            { "key.nu", metaValue_key_nu },
            { "kru", "\u043a\u0443\u0440\u0443\u043a\u0445" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b\u0430" },
            { "Telu", metaValue_te },
            { "ksf", "\u0431\u0430\u0444\u0456\u0430" },
        };
        return data;
    }
}
