/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.File;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Poll;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Sockaddr;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteBufferUtils;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Acceptor;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.AprSSLSupport;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SendfileDataBase;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketProcessorBase;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.net.openssl.OpenSSLContext;
import org.apache.tomcat.util.net.openssl.OpenSSLUtil;

@Deprecated
public class AprEndpoint
extends AbstractEndpoint<Long, Long>
implements SSLContext.SNICallBack {
    private static final Log log = LogFactory.getLog(AprEndpoint.class);
    protected long rootPool = 0L;
    protected volatile long serverSock = 0L;
    protected long serverSockPool = 0L;
    protected long sslContext = 0L;
    protected boolean deferAccept = true;
    private boolean ipv6v6only = false;
    protected int sendfileSize = 1024;
    protected int pollTime = 2000;
    private boolean useSendFileSet = false;
    protected Poller poller = null;
    protected Sendfile sendfile = null;
    private String unixDomainSocketPath = null;
    private String unixDomainSocketPathPermissions = null;

    public AprEndpoint() {
        this.setUseAsyncIO(false);
    }

    public void setDeferAccept(boolean bl) {
        this.deferAccept = bl;
    }

    @Override
    public boolean getDeferAccept() {
        return this.deferAccept;
    }

    public void setIpv6v6only(boolean bl) {
        this.ipv6v6only = bl;
    }

    public boolean getIpv6v6only() {
        return this.ipv6v6only;
    }

    public void setSendfileSize(int n) {
        this.sendfileSize = n;
    }

    public int getSendfileSize() {
        return this.sendfileSize;
    }

    public int getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(int n) {
        if (n > 0) {
            this.pollTime = n;
        }
    }

    @Override
    public void setUseSendfile(boolean bl) {
        this.useSendFileSet = true;
        super.setUseSendfile(bl);
    }

    private void setUseSendfileInternal(boolean bl) {
        super.setUseSendfile(bl);
    }

    public Poller getPoller() {
        return this.poller;
    }

    public Sendfile getSendfile() {
        return this.sendfile;
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        long l;
        long l2 = this.serverSock;
        if (l2 == 0L) {
            return null;
        }
        try {
            l = Address.get((int)0, (long)l2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        Sockaddr sockaddr = Address.getInfo((long)l);
        if (sockaddr.hostname == null) {
            if (sockaddr.family == 2) {
                return new InetSocketAddress("::", sockaddr.port);
            }
            return new InetSocketAddress("0.0.0.0", sockaddr.port);
        }
        return new InetSocketAddress(sockaddr.hostname, sockaddr.port);
    }

    @Override
    public void setMaxConnections(int n) {
        if (n == -1) {
            log.warn((Object)sm.getString("endpoint.apr.maxConnections.unlimited", new Object[]{this.getMaxConnections()}));
            return;
        }
        if (this.running) {
            log.warn((Object)sm.getString("endpoint.apr.maxConnections.running", new Object[]{this.getMaxConnections()}));
            return;
        }
        super.setMaxConnections(n);
    }

    public String getUnixDomainSocketPath() {
        return this.unixDomainSocketPath;
    }

    public void setUnixDomainSocketPath(String string) {
        this.unixDomainSocketPath = string;
    }

    public String getUnixDomainSocketPathPermissions() {
        return this.unixDomainSocketPathPermissions;
    }

    public void setUnixDomainSocketPathPermissions(String string) {
        this.unixDomainSocketPathPermissions = string;
    }

    public int getKeepAliveCount() {
        if (this.poller == null) {
            return 0;
        }
        return this.poller.getConnectionCount();
    }

    public int getSendfileCount() {
        if (this.sendfile == null) {
            return 0;
        }
        return this.sendfile.getSendfileCount();
    }

    @Override
    public String getId() {
        if (this.getUnixDomainSocketPath() != null) {
            return this.getUnixDomainSocketPath();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void bind() throws Exception {
        Object object3;
        Object object2;
        int n;
        int n2;
        String string = null;
        try {
            this.rootPool = Pool.create((long)0L);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new Exception(sm.getString("endpoint.init.notavail"));
        }
        this.serverSockPool = Pool.create((long)this.rootPool);
        if (this.getUnixDomainSocketPath() != null) {
            if (!Library.APR_HAVE_UNIX) throw new Exception(sm.getString("endpoint.init.unixnotavail"));
            string = this.getUnixDomainSocketPath();
            n2 = 3;
        } else {
            if (this.getAddress() != null) {
                string = this.getAddress().getHostAddress();
            }
            n2 = 0;
        }
        long l = Address.info((String)string, (int)n2, (int)this.getPortWithOffset(), (int)0, (long)this.rootPool);
        if (n2 == 3) {
            this.serverSock = Socket.create((int)n2, (int)0, (int)0, (long)this.rootPool);
        } else {
            n = Address.getInfo((long)l).family;
            this.serverSock = Socket.create((int)n, (int)0, (int)6, (long)this.rootPool);
            if (OS.IS_UNIX) {
                Socket.optSet((long)this.serverSock, (int)16, (int)1);
            }
            if (Library.APR_HAVE_IPV6 && n == 2) {
                if (this.getIpv6v6only()) {
                    Socket.optSet((long)this.serverSock, (int)16384, (int)1);
                } else {
                    Socket.optSet((long)this.serverSock, (int)16384, (int)0);
                }
            }
            Socket.optSet((long)this.serverSock, (int)2, (int)1);
        }
        n = Socket.bind((long)this.serverSock, (long)l);
        if (n != 0) {
            throw new Exception(sm.getString("endpoint.init.bind", new Object[]{"" + n, Error.strerror((int)n)}));
        }
        n = Socket.listen((long)this.serverSock, (int)this.getAcceptCount());
        if (n != 0) {
            throw new Exception(sm.getString("endpoint.init.listen", new Object[]{"" + n, Error.strerror((int)n)}));
        }
        if (n2 == 3) {
            if (this.getUnixDomainSocketPathPermissions() != null) {
                object2 = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(this.getUnixDomainSocketPathPermissions()));
                object3 = Paths.get(this.getUnixDomainSocketPath(), new String[0]);
                Files.setAttribute((Path)object3, object2.name(), object2.value(), new LinkOption[0]);
            }
        } else if (OS.IS_WIN32 || OS.IS_WIN64) {
            Socket.optSet((long)this.serverSock, (int)16, (int)1);
        }
        if (!this.useSendFileSet) {
            this.setUseSendfileInternal(Library.APR_HAS_SENDFILE);
        } else if (this.getUseSendfile() && !Library.APR_HAS_SENDFILE) {
            this.setUseSendfileInternal(false);
        }
        if (this.deferAccept && Socket.optSet((long)this.serverSock, (int)32768, (int)1) == 70023) {
            this.deferAccept = false;
        }
        if (!this.isSSLEnabled()) return;
        for (Object object3 : this.sslHostConfigs.values()) {
            this.createSSLContext((SSLHostConfig)object3);
        }
        object2 = (SSLHostConfig)this.sslHostConfigs.get(this.getDefaultSSLHostConfigName());
        if (object2 == null) {
            throw new IllegalArgumentException(sm.getString("endpoint.noSslHostConfig", new Object[]{this.getDefaultSSLHostConfigName(), this.getName()}));
        }
        object3 = ((SSLHostConfig)object2).getOpenSslContext();
        this.sslContext = (Long)object3;
        SSLContext.registerDefault((Long)object3, (SSLContext.SNICallBack)this);
        if (!this.getUseSendfile()) return;
        this.setUseSendfileInternal(false);
        if (!this.useSendFileSet) return;
        log.warn((Object)sm.getString("endpoint.apr.noSendfileWithSSL"));
    }

    @Override
    protected void createSSLContext(SSLHostConfig sSLHostConfig) throws Exception {
        OpenSSLContext openSSLContext = null;
        Set<SSLHostConfigCertificate> set = sSLHostConfig.getCertificates(true);
        for (SSLHostConfigCertificate sSLHostConfigCertificate : set) {
            OpenSSLUtil openSSLUtil;
            if (openSSLContext == null) {
                openSSLUtil = new OpenSSLUtil(sSLHostConfigCertificate);
                sSLHostConfig.setEnabledProtocols(openSSLUtil.getEnabledProtocols());
                sSLHostConfig.setEnabledCiphers(openSSLUtil.getEnabledCiphers());
                try {
                    openSSLContext = (OpenSSLContext)openSSLUtil.createSSLContext(this.negotiableProtocols);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(exception.getMessage(), exception);
                }
            } else {
                openSSLUtil = new OpenSSLUtil(sSLHostConfigCertificate);
                KeyManager[] keyManagerArray = openSSLUtil.getKeyManagers();
                sSLHostConfigCertificate.setCertificateKeyManager(OpenSSLUtil.chooseKeyManager(keyManagerArray));
                openSSLContext.addCertificate(sSLHostConfigCertificate);
            }
            sSLHostConfigCertificate.setSslContext(openSSLContext);
        }
        if (set.size() > 2) {
            throw new Exception(sm.getString("endpoint.apr.tooManyCertFiles"));
        }
    }

    public long getSslContext(String string) {
        SSLHostConfig sSLHostConfig = this.getSSLHostConfig(string);
        Long l = sSLHostConfig.getOpenSslContext();
        if (l != null) {
            return l;
        }
        return 0L;
    }

    @Override
    public boolean isAlpnSupported() {
        return this.isSSLEnabled();
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            if (this.socketProperties.getProcessorCache() != 0) {
                this.processorCache = new SynchronizedStack(128, this.socketProperties.getProcessorCache());
            }
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.poller = new Poller();
            this.poller.init();
            this.poller.start();
            if (this.getUseSendfile()) {
                this.sendfile = new Sendfile();
                this.sendfile.init();
                this.sendfile.start();
            }
            this.startAcceptorThread();
        }
    }

    @Override
    public void stopInternal() {
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.acceptor.stop(10);
            this.poller.stop();
            for (Object object : this.connections.values()) {
                ((SocketWrapperBase)object).close();
            }
            if (this.acceptor.getState() != Acceptor.AcceptorState.ENDED && !this.getBindOnInit()) {
                log.warn((Object)sm.getString("endpoint.warn.unlockAcceptorFailed", new Object[]{this.acceptor.getThreadName()}));
                if (this.serverSock != 0L) {
                    Socket.shutdown((long)this.serverSock, (int)0);
                    this.serverSock = 0L;
                }
            }
            for (Object object : this.connections.keySet()) {
                Socket.shutdown((long)((Long)object), (int)2);
            }
            try {
                this.poller.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.poller = null;
            this.connections.clear();
            if (this.getUseSendfile()) {
                try {
                    this.sendfile.stop();
                    this.sendfile.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sendfile = null;
            }
            if (this.processorCache != null) {
                this.processorCache.clear();
                this.processorCache = null;
            }
        }
        this.shutdownExecutor();
    }

    @Override
    public void unbind() throws Exception {
        if (this.running) {
            this.stop();
        }
        if (this.serverSockPool != 0L) {
            Pool.destroy((long)this.serverSockPool);
            this.serverSockPool = 0L;
        }
        this.doCloseServerSocket();
        this.destroySsl();
        if (this.rootPool != 0L) {
            Pool.destroy((long)this.rootPool);
            this.rootPool = 0L;
        }
        this.getHandler().recycle();
    }

    @Override
    protected void doCloseServerSocket() {
        if (this.serverSock != 0L) {
            Socket.close((long)this.serverSock);
            this.serverSock = 0L;
        }
    }

    @Override
    protected boolean setSocketOptions(SocketWrapperBase<Long> socketWrapperBase) {
        long l = socketWrapperBase.getSocket();
        int n = 1;
        try {
            if (this.socketProperties.getSoLingerOn() && this.socketProperties.getSoLingerTime() >= 0) {
                Socket.optSet((long)l, (int)1, (int)this.socketProperties.getSoLingerTime());
            }
            if (this.socketProperties.getTcpNoDelay()) {
                Socket.optSet((long)l, (int)512, (int)(this.socketProperties.getTcpNoDelay() ? 1 : 0));
            }
            Socket.timeoutSet((long)l, (long)(this.socketProperties.getSoTimeout() * 1000));
            n = 2;
            if (this.sslContext != 0L) {
                int n2;
                byte[] byArray;
                String string;
                SSLSocket.attach((long)this.sslContext, (long)l);
                if (SSLSocket.handshake((long)l) != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(sm.getString("endpoint.err.handshake") + ": " + SSL.getLastError()));
                    }
                    return false;
                }
                if (this.negotiableProtocols.size() > 0 && (string = new String(byArray = new byte[256], 0, n2 = SSLSocket.getALPN((long)l, (byte[])byArray), StandardCharsets.UTF_8)).length() > 0) {
                    socketWrapperBase.setNegotiatedProtocol(string);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("endpoint.alpn.negotiated", new Object[]{string}));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            if (log.isDebugEnabled()) {
                if (n == 2) {
                    log.debug((Object)sm.getString("endpoint.err.handshake"), throwable);
                } else {
                    log.debug((Object)sm.getString("endpoint.err.unexpected"), throwable);
                }
            }
            return false;
        }
        return true;
    }

    protected long allocatePoller(int n, long l, int n2) {
        try {
            return Poll.create((int)n, (long)l, (int)0, (long)(n2 * 1000));
        }
        catch (Error error) {
            if (Status.APR_STATUS_IS_EINVAL((int)error.getError())) {
                log.info((Object)sm.getString("endpoint.poll.limitedpollsize", new Object[]{"" + n}));
                return 0L;
            }
            log.error((Object)sm.getString("endpoint.poll.initfail"), (Throwable)error);
            return -1L;
        }
    }

    @Override
    protected boolean setSocketOptions(Long l) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("endpoint.debug.socket", new Object[]{l}));
            }
            AprSocketWrapper aprSocketWrapper = new AprSocketWrapper(l, this);
            this.connections.put(l, aprSocketWrapper);
            aprSocketWrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
            aprSocketWrapper.setReadTimeout(this.getConnectionTimeout());
            aprSocketWrapper.setWriteTimeout(this.getConnectionTimeout());
            this.getExecutor().execute(new SocketWithOptionsProcessor(aprSocketWrapper));
            return true;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            log.warn((Object)sm.getString("endpoint.rejectedExecution", new Object[]{l}), (Throwable)rejectedExecutionException);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.error((Object)sm.getString("endpoint.process.fail"), throwable);
        }
        return false;
    }

    @Override
    protected Long serverSocketAccept() throws Exception {
        long l = Socket.accept((long)this.serverSock);
        if (log.isDebugEnabled()) {
            long l2 = Address.get((int)1, (long)l);
            Sockaddr sockaddr = Address.getInfo((long)l2);
            log.debug((Object)sm.getString("endpoint.apr.remoteport", new Object[]{l, (long)sockaddr.port}));
        }
        return l;
    }

    protected boolean processSocket(long l, SocketEvent socketEvent) {
        SocketWrapperBase socketWrapperBase = (SocketWrapperBase)this.connections.get(l);
        if (socketWrapperBase == null) {
            return false;
        }
        if (socketEvent == SocketEvent.OPEN_READ && socketWrapperBase.readOperation != null) {
            return socketWrapperBase.readOperation.process();
        }
        if (socketEvent == SocketEvent.OPEN_WRITE && socketWrapperBase.writeOperation != null) {
            return socketWrapperBase.writeOperation.process();
        }
        return this.processSocket(socketWrapperBase, socketEvent, true);
    }

    @Override
    protected SocketProcessorBase<Long> createSocketProcessor(SocketWrapperBase<Long> socketWrapperBase, SocketEvent socketEvent) {
        return new SocketProcessor(socketWrapperBase, socketEvent);
    }

    private void closeSocketInternal(long l) {
        this.closeSocket(l);
    }

    @Override
    protected void destroySocket(Long l) {
        this.countDownConnection();
        this.destroySocketInternal(l);
    }

    private void destroySocketInternal(long l) {
        if (log.isDebugEnabled()) {
            String string = sm.getString("endpoint.debug.destroySocket", new Object[]{l});
            if (log.isTraceEnabled()) {
                log.trace((Object)string, (Throwable)new Exception());
            } else {
                log.debug((Object)string);
            }
        }
        if (l != 0L) {
            Socket.destroy((long)l);
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    public static class AprSocketWrapper
    extends SocketWrapperBase<Long> {
        private static final int SSL_OUTPUT_BUFFER_SIZE = 8192;
        private final ByteBuffer sslOutputBuffer;
        private int pollerFlags = 0;
        private volatile boolean blockingStatus = true;
        private final Lock blockingStatusReadLock;
        private final ReentrantReadWriteLock.WriteLock blockingStatusWriteLock;

        public AprSocketWrapper(Long l, AprEndpoint aprEndpoint) {
            super(l, aprEndpoint);
            ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
            this.blockingStatusReadLock = reentrantReadWriteLock.readLock();
            this.blockingStatusWriteLock = reentrantReadWriteLock.writeLock();
            if (aprEndpoint.isSSLEnabled()) {
                this.sslOutputBuffer = ByteBuffer.allocateDirect(8192);
                this.sslOutputBuffer.position(8192);
            } else {
                this.sslOutputBuffer = null;
            }
            this.socketBufferHandler = new SocketBufferHandler(9000, 9000, true);
        }

        public boolean getBlockingStatus() {
            return this.blockingStatus;
        }

        public void setBlockingStatus(boolean bl) {
            this.blockingStatus = bl;
        }

        public Lock getBlockingStatusReadLock() {
            return this.blockingStatusReadLock;
        }

        public ReentrantReadWriteLock.WriteLock getBlockingStatusWriteLock() {
            return this.blockingStatusWriteLock;
        }

        @Override
        public int read(boolean bl, byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.populateReadBuffer(byArray, n, n2);
            if (n3 > 0) {
                return n3;
            }
            n3 = this.fillReadBuffer(bl);
            if (n3 > 0) {
                this.socketBufferHandler.configureReadBufferForRead();
                n3 = Math.min(n3, n2);
                this.socketBufferHandler.getReadBuffer().get(byArray, n, n3);
            }
            return n3;
        }

        @Override
        public int read(boolean bl, ByteBuffer byteBuffer) throws IOException {
            int n = this.populateReadBuffer(byteBuffer);
            if (n > 0) {
                return n;
            }
            int n2 = this.socketBufferHandler.getReadBuffer().capacity();
            if (byteBuffer.isDirect() && byteBuffer.remaining() >= n2) {
                byteBuffer.limit(byteBuffer.position() + n2);
                n = this.fillReadBuffer(bl, byteBuffer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Socket: [" + this + "], Read direct from socket: [" + n + "]"));
                }
            } else {
                n = this.fillReadBuffer(bl);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Socket: [" + this + "], Read into buffer: [" + n + "]"));
                }
                if (n > 0) {
                    n = this.populateReadBuffer(byteBuffer);
                }
            }
            return n;
        }

        private int fillReadBuffer(boolean bl) throws IOException {
            this.socketBufferHandler.configureReadBufferForWrite();
            return this.fillReadBuffer(bl, this.socketBufferHandler.getReadBuffer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int fillReadBuffer(boolean bl, ByteBuffer byteBuffer) throws IOException {
            Lock lock = this.getBlockingStatusReadLock();
            ReentrantReadWriteLock.WriteLock writeLock = this.getBlockingStatusWriteLock();
            boolean bl2 = false;
            int n = 0;
            lock.lock();
            try {
                this.checkClosed();
                if (this.getBlockingStatus() == bl) {
                    if (bl) {
                        Socket.timeoutSet((long)((Long)this.getSocket()), (long)(this.getReadTimeout() * 1000L));
                    }
                    n = Socket.recvb((long)((Long)this.getSocket()), (ByteBuffer)byteBuffer, (int)byteBuffer.position(), (int)byteBuffer.remaining());
                    bl2 = true;
                }
            }
            finally {
                lock.unlock();
            }
            if (!bl2) {
                writeLock.lock();
                try {
                    this.checkClosed();
                    this.setBlockingStatus(bl);
                    if (bl) {
                        Socket.timeoutSet((long)((Long)this.getSocket()), (long)(this.getReadTimeout() * 1000L));
                    } else {
                        Socket.timeoutSet((long)((Long)this.getSocket()), (long)0L);
                    }
                    lock.lock();
                    try {
                        writeLock.unlock();
                        n = Socket.recvb((long)((Long)this.getSocket()), (ByteBuffer)byteBuffer, (int)byteBuffer.position(), (int)byteBuffer.remaining());
                    }
                    finally {
                        lock.unlock();
                    }
                }
                finally {
                    if (writeLock.isHeldByCurrentThread()) {
                        writeLock.unlock();
                    }
                }
            }
            if (n > 0) {
                byteBuffer.position(byteBuffer.position() + n);
                return n;
            }
            if (n == 0 || -n == 120002) {
                return 0;
            }
            if (-n == 120005 || -n == 120001) {
                if (bl) {
                    throw new SocketTimeoutException(sm.getString("iib.readtimeout"));
                }
                return 0;
            }
            if (-n == 70014) {
                return -1;
            }
            if ((OS.IS_WIN32 || OS.IS_WIN64) && -n == 730053) {
                throw new EOFException(sm.getString("socket.apr.clientAbort"));
            }
            throw new IOException(sm.getString("socket.apr.read.error", new Object[]{-n, this.getSocket(), this}));
        }

        @Override
        public boolean isReadyForRead() throws IOException {
            this.socketBufferHandler.configureReadBufferForRead();
            if (this.socketBufferHandler.getReadBuffer().remaining() > 0) {
                return true;
            }
            int n = this.fillReadBuffer(false);
            boolean bl = this.socketBufferHandler.getReadBuffer().position() > 0 || n == -1;
            return bl;
        }

        private void checkClosed() throws IOException {
            if (this.isClosed()) {
                throw new IOException(sm.getString("socket.apr.closed", new Object[]{this.getSocket()}));
            }
        }

        @Override
        protected void doClose() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calling [" + this.getEndpoint() + "].closeSocket([" + this + "])"));
            }
            this.getEndpoint().connections.remove(this.getSocket());
            this.socketBufferHandler.free();
            this.socketBufferHandler = SocketBufferHandler.EMPTY;
            this.nonBlockingWriteBuffer.clear();
            if (this.sslOutputBuffer != null) {
                ByteBufferUtils.cleanDirectBuffer((ByteBuffer)this.sslOutputBuffer);
            }
            ((AprEndpoint)this.getEndpoint()).getPoller().close((Long)this.getSocket());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(boolean bl, ByteBuffer byteBuffer) throws IOException {
            Lock lock = this.getBlockingStatusReadLock();
            ReentrantReadWriteLock.WriteLock writeLock = this.getBlockingStatusWriteLock();
            lock.lock();
            try {
                this.checkClosed();
                if (this.getBlockingStatus() == bl) {
                    if (bl) {
                        Socket.timeoutSet((long)((Long)this.getSocket()), (long)(this.getWriteTimeout() * 1000L));
                    }
                    this.doWriteInternal(byteBuffer);
                    return;
                }
            }
            finally {
                lock.unlock();
            }
            writeLock.lock();
            try {
                this.checkClosed();
                this.setBlockingStatus(bl);
                if (bl) {
                    Socket.timeoutSet((long)((Long)this.getSocket()), (long)(this.getWriteTimeout() * 1000L));
                } else {
                    Socket.timeoutSet((long)((Long)this.getSocket()), (long)0L);
                }
                lock.lock();
                try {
                    writeLock.unlock();
                    this.doWriteInternal(byteBuffer);
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                if (writeLock.isHeldByCurrentThread()) {
                    writeLock.unlock();
                }
            }
        }

        private void doWriteInternal(ByteBuffer byteBuffer) throws IOException {
            int n;
            if (this.previousIOException != null) {
                throw new IOException(this.previousIOException);
            }
            do {
                n = 0;
                if (this.getEndpoint().isSSLEnabled()) {
                    if (this.sslOutputBuffer.remaining() == 0) {
                        this.sslOutputBuffer.clear();
                        AprSocketWrapper.transfer(byteBuffer, this.sslOutputBuffer);
                        this.sslOutputBuffer.flip();
                    }
                    if ((n = Socket.sendb((long)((Long)this.getSocket()), (ByteBuffer)this.sslOutputBuffer, (int)this.sslOutputBuffer.position(), (int)this.sslOutputBuffer.limit())) > 0) {
                        this.sslOutputBuffer.position(this.sslOutputBuffer.position() + n);
                    }
                } else {
                    n = Socket.sendb((long)((Long)this.getSocket()), (ByteBuffer)byteBuffer, (int)byteBuffer.position(), (int)byteBuffer.remaining());
                    if (n > 0) {
                        byteBuffer.position(byteBuffer.position() + n);
                    }
                }
                if (Status.APR_STATUS_IS_EAGAIN((int)(-n))) {
                    n = 0;
                    continue;
                }
                if (-n == 70014) {
                    throw new EOFException(sm.getString("socket.apr.clientAbort"));
                }
                if ((OS.IS_WIN32 || OS.IS_WIN64) && -n == 730053) {
                    throw new EOFException(sm.getString("socket.apr.clientAbort"));
                }
                if (n >= 0) continue;
                this.previousIOException = new IOException(sm.getString("socket.apr.write.error", new Object[]{-n, this.getSocket(), this}));
                throw this.previousIOException;
            } while ((n > 0 || this.getBlockingStatus()) && byteBuffer.hasRemaining());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerReadInterest() {
            AtomicBoolean atomicBoolean = this.closed;
            synchronized (atomicBoolean) {
                Poller poller;
                if (this.isClosed()) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("endpoint.debug.registerRead", new Object[]{this}));
                }
                if ((poller = ((AprEndpoint)this.getEndpoint()).getPoller()) != null) {
                    poller.add((Long)this.getSocket(), this.getReadTimeout(), 1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerWriteInterest() {
            AtomicBoolean atomicBoolean = this.closed;
            synchronized (atomicBoolean) {
                if (this.isClosed()) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("endpoint.debug.registerWrite", new Object[]{this}));
                }
                ((AprEndpoint)this.getEndpoint()).getPoller().add((Long)this.getSocket(), this.getWriteTimeout(), 4);
            }
        }

        @Override
        public SendfileDataBase createSendfileData(String string, long l, long l2) {
            return new SendfileData(string, l, l2);
        }

        @Override
        public SendfileState processSendfile(SendfileDataBase sendfileDataBase) {
            ((SendfileData)sendfileDataBase).socket = (Long)this.getSocket();
            return ((AprEndpoint)this.getEndpoint()).getSendfile().add((SendfileData)sendfileDataBase);
        }

        @Override
        protected void populateRemoteAddr() {
            if (this.isClosed()) {
                return;
            }
            try {
                long l = (Long)this.getSocket();
                long l2 = Address.get((int)1, (long)l);
                this.remoteAddr = Address.getip((long)l2);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("endpoint.warn.noRemoteAddr", new Object[]{this.getSocket()}), (Throwable)exception);
            }
        }

        @Override
        protected void populateRemoteHost() {
            if (this.isClosed()) {
                return;
            }
            try {
                long l = (Long)this.getSocket();
                long l2 = Address.get((int)1, (long)l);
                this.remoteHost = Address.getnameinfo((long)l2, (int)0);
                if (this.remoteAddr == null) {
                    this.remoteAddr = Address.getip((long)l2);
                }
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("endpoint.warn.noRemoteHost", new Object[]{this.getSocket()}), (Throwable)exception);
            }
        }

        @Override
        protected void populateRemotePort() {
            if (this.isClosed()) {
                return;
            }
            try {
                long l = (Long)this.getSocket();
                long l2 = Address.get((int)1, (long)l);
                Sockaddr sockaddr = Address.getInfo((long)l2);
                this.remotePort = sockaddr.port;
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("endpoint.warn.noRemotePort", new Object[]{this.getSocket()}), (Throwable)exception);
            }
        }

        @Override
        protected void populateLocalName() {
            if (this.isClosed()) {
                return;
            }
            try {
                long l = (Long)this.getSocket();
                long l2 = Address.get((int)0, (long)l);
                this.localName = Address.getnameinfo((long)l2, (int)0);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("endpoint.warn.noLocalName"), (Throwable)exception);
            }
        }

        @Override
        protected void populateLocalAddr() {
            if (this.isClosed()) {
                return;
            }
            try {
                long l = (Long)this.getSocket();
                long l2 = Address.get((int)0, (long)l);
                this.localAddr = Address.getip((long)l2);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("endpoint.warn.noLocalAddr"), (Throwable)exception);
            }
        }

        @Override
        protected void populateLocalPort() {
            if (this.isClosed()) {
                return;
            }
            try {
                long l = (Long)this.getSocket();
                long l2 = Address.get((int)0, (long)l);
                Sockaddr sockaddr = Address.getInfo((long)l2);
                this.localPort = sockaddr.port;
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("endpoint.warn.noLocalPort"), (Throwable)exception);
            }
        }

        @Override
        public SSLSupport getSslSupport(String string) {
            if (this.getEndpoint().isSSLEnabled()) {
                return new AprSSLSupport(this, string);
            }
            return null;
        }

        @Override
        public SSLSupport getSslSupport() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doClientAuth(SSLSupport sSLSupport) throws IOException {
            block14: {
                long l = (Long)this.getSocket();
                Lock lock = this.getBlockingStatusReadLock();
                ReentrantReadWriteLock.WriteLock writeLock = this.getBlockingStatusWriteLock();
                boolean bl = false;
                try {
                    lock.lock();
                    try {
                        if (this.getBlockingStatus()) {
                            Socket.timeoutSet((long)((Long)this.getSocket()), (long)(this.getReadTimeout() * 1000L));
                            SSLSocket.setVerify((long)l, (int)2, (int)-1);
                            SSLSocket.renegotiate((long)l);
                            bl = true;
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                    if (bl) break block14;
                    writeLock.lock();
                    try {
                        this.setBlockingStatus(true);
                        Socket.timeoutSet((long)((Long)this.getSocket()), (long)(this.getReadTimeout() * 1000L));
                        lock.lock();
                        try {
                            writeLock.unlock();
                            SSLSocket.setVerify((long)l, (int)2, (int)-1);
                            SSLSocket.renegotiate((long)l);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    finally {
                        if (writeLock.isHeldByCurrentThread()) {
                            writeLock.unlock();
                        }
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    throw new IOException(sm.getString("socket.sslreneg"), throwable);
                }
            }
        }

        @Override
        public void setAppReadBufHandler(ApplicationBufferHandler applicationBufferHandler) {
        }

        String getSSLInfoS(int n) {
            AtomicBoolean atomicBoolean = this.closed;
            synchronized (atomicBoolean) {
                if (this.isClosed()) {
                    return null;
                }
                try {
                    return SSLSocket.getInfoS((long)((Long)this.getSocket()), (int)n);
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
        }

        int getSSLInfoI(int n) {
            AtomicBoolean atomicBoolean = this.closed;
            synchronized (atomicBoolean) {
                if (this.isClosed()) {
                    return 0;
                }
                try {
                    return SSLSocket.getInfoI((long)((Long)this.getSocket()), (int)n);
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
        }

        byte[] getSSLInfoB(int n) {
            AtomicBoolean atomicBoolean = this.closed;
            synchronized (atomicBoolean) {
                if (this.isClosed()) {
                    return null;
                }
                try {
                    return SSLSocket.getInfoB((long)((Long)this.getSocket()), (int)n);
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
        }

        @Override
        protected <A> SocketWrapperBase.OperationState<A> newOperationState(boolean bl, ByteBuffer[] byteBufferArray, int n, int n2, SocketWrapperBase.BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, SocketWrapperBase.CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> vectoredIOCompletionHandler) {
            return new AprOperationState(bl, byteBufferArray, n, n2, blockingMode, l, timeUnit, a, completionCheck, completionHandler, semaphore, vectoredIOCompletionHandler);
        }

        private class AprOperationState<A>
        extends SocketWrapperBase.OperationState<A> {
            private volatile boolean inline;
            private volatile long flushBytes;

            private AprOperationState(boolean bl, ByteBuffer[] byteBufferArray, int n, int n2, SocketWrapperBase.BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, SocketWrapperBase.CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> vectoredIOCompletionHandler) {
                super(AprSocketWrapper.this, bl, byteBufferArray, n, n2, blockingMode, l, timeUnit, a, completionCheck, completionHandler, semaphore, vectoredIOCompletionHandler);
                this.inline = true;
                this.flushBytes = 0L;
            }

            @Override
            protected boolean isInline() {
                return this.inline;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                long l = 0L;
                if (AprSocketWrapper.this.getError() == null) {
                    try {
                        object = this;
                        synchronized (object) {
                            int n;
                            if (!this.completionDone) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Skip concurrent " + (this.read ? "read" : "write") + " notification"));
                                }
                                return;
                            }
                            ByteBuffer byteBuffer = null;
                            for (n = 0; n < this.length; ++n) {
                                if (!this.buffers[n + this.offset].hasRemaining()) continue;
                                byteBuffer = this.buffers[n + this.offset];
                                break;
                            }
                            if (byteBuffer == null && this.flushBytes == 0L) {
                                this.completion.completed(0L, this);
                                return;
                            }
                            if (this.read) {
                                l = AprSocketWrapper.this.read(false, byteBuffer);
                            } else if (!AprSocketWrapper.this.flush(this.block == SocketWrapperBase.BlockingMode.BLOCK)) {
                                if (this.flushBytes > 0L) {
                                    l = this.flushBytes;
                                    this.flushBytes = 0L;
                                } else {
                                    n = byteBuffer.remaining();
                                    AprSocketWrapper.this.write(this.block == SocketWrapperBase.BlockingMode.BLOCK, byteBuffer);
                                    l = n - byteBuffer.remaining();
                                    if (l > 0L && AprSocketWrapper.this.flush(this.block == SocketWrapperBase.BlockingMode.BLOCK)) {
                                        this.inline = false;
                                        AprSocketWrapper.this.registerWriteInterest();
                                        this.flushBytes = l;
                                        return;
                                    }
                                }
                            } else {
                                this.inline = false;
                                AprSocketWrapper.this.registerWriteInterest();
                                return;
                            }
                            if (l != 0L) {
                                this.completionDone = false;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        AprSocketWrapper.this.setError(iOException);
                    }
                }
                if (l > 0L) {
                    this.completion.completed(l, this);
                } else if (l < 0L || AprSocketWrapper.this.getError() != null) {
                    object = AprSocketWrapper.this.getError();
                    if (object == null) {
                        object = new EOFException();
                    }
                    this.completion.failed((Throwable)object, this);
                } else {
                    this.inline = false;
                    if (this.read) {
                        AprSocketWrapper.this.registerReadInterest();
                    } else {
                        AprSocketWrapper.this.registerWriteInterest();
                    }
                }
            }
        }
    }

    protected class SocketProcessor
    extends SocketProcessorBase<Long> {
        public SocketProcessor(SocketWrapperBase<Long> socketWrapperBase, SocketEvent socketEvent) {
            super(socketWrapperBase, socketEvent);
        }

        @Override
        protected void doRun() {
            try {
                AbstractEndpoint.Handler.SocketState socketState = AprEndpoint.this.getHandler().process(this.socketWrapper, this.event);
                if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                    this.socketWrapper.close();
                }
            }
            finally {
                this.socketWrapper = null;
                this.event = null;
                if (AprEndpoint.this.running && !AprEndpoint.this.paused && AprEndpoint.this.processorCache != null) {
                    AprEndpoint.this.processorCache.push((Object)this);
                }
            }
        }
    }

    protected class SocketWithOptionsProcessor
    implements Runnable {
        protected SocketWrapperBase<Long> socket = null;

        public SocketWithOptionsProcessor(SocketWrapperBase<Long> socketWrapperBase) {
            this.socket = socketWrapperBase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketWrapperBase<Long> socketWrapperBase = this.socket;
            synchronized (socketWrapperBase) {
                if (!AprEndpoint.this.deferAccept) {
                    if (AprEndpoint.this.setSocketOptions(this.socket)) {
                        AprEndpoint.this.getPoller().add(this.socket.getSocket(), AprEndpoint.this.getConnectionTimeout(), 1);
                    } else {
                        AprEndpoint.this.getHandler().process(this.socket, SocketEvent.CONNECT_FAIL);
                        this.socket.close();
                        this.socket = null;
                    }
                } else {
                    if (!AprEndpoint.this.setSocketOptions(this.socket)) {
                        AprEndpoint.this.getHandler().process(this.socket, SocketEvent.CONNECT_FAIL);
                        this.socket.close();
                        this.socket = null;
                        return;
                    }
                    AbstractEndpoint.Handler.SocketState socketState = AprEndpoint.this.getHandler().process(this.socket, SocketEvent.OPEN_READ);
                    if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.socket.close();
                        this.socket = null;
                    }
                }
            }
        }
    }

    public class Sendfile
    implements Runnable {
        protected long sendfilePollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected HashMap<Long, SendfileData> sendfileData;
        protected int sendfileCount;
        protected ArrayList<SendfileData> addS;
        private volatile Thread sendfileThread;
        private volatile boolean sendfileRunning = true;

        public int getSendfileCount() {
            return this.sendfileCount;
        }

        protected void init() {
            this.pool = Pool.create((long)AprEndpoint.this.serverSockPool);
            int n = AprEndpoint.this.sendfileSize;
            if (n <= 0) {
                n = 16384;
            }
            this.sendfilePollset = AprEndpoint.this.allocatePoller(n, this.pool, AprEndpoint.this.getConnectionTimeout());
            this.desc = new long[n * 2];
            this.sendfileData = new HashMap(n);
            this.addS = new ArrayList();
        }

        protected void start() {
            this.sendfileThread = new Thread((Runnable)AprEndpoint.this.sendfile, AprEndpoint.this.getName() + "-Sendfile");
            this.sendfileThread.setPriority(AprEndpoint.this.threadPriority);
            this.sendfileThread.setDaemon(true);
            this.sendfileThread.start();
        }

        protected synchronized void stop() {
            this.sendfileRunning = false;
            this.notify();
            for (int i = 50; i > 0 && this.sendfileThread.isAlive(); --i) {
                try {
                    this.wait(AprEndpoint.this.pollTime / 1000);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.sendfileThread.isAlive()) {
                log.warn((Object)AbstractEndpoint.sm.getString("endpoint.sendfileThreadStop"));
            }
        }

        protected void destroy() {
            int n;
            for (n = this.addS.size() - 1; n >= 0; --n) {
                SendfileData sendfileData = this.addS.get(n);
                AprEndpoint.this.closeSocketInternal(sendfileData.socket);
            }
            n = Poll.pollset((long)this.sendfilePollset, (long[])this.desc);
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    AprEndpoint.this.closeSocketInternal(this.desc[i * 2 + 1]);
                }
            }
            Pool.destroy((long)this.pool);
            this.sendfileData.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SendfileState add(SendfileData sendfileData) {
            try {
                sendfileData.fdpool = Socket.pool((long)sendfileData.socket);
                sendfileData.fd = File.open((String)sendfileData.fileName, (int)4129, (int)0, (long)sendfileData.fdpool);
                Socket.timeoutSet((long)sendfileData.socket, (long)0L);
                while (this.sendfileRunning) {
                    long l = Socket.sendfilen((long)sendfileData.socket, (long)sendfileData.fd, (long)sendfileData.pos, (long)sendfileData.length, (int)0);
                    if (l < 0L) {
                        if (-l == 120002L) break;
                        Pool.destroy((long)sendfileData.fdpool);
                        sendfileData.socket = 0L;
                        return SendfileState.ERROR;
                    }
                    sendfileData.pos += l;
                    sendfileData.length -= l;
                    if (sendfileData.length != 0L) continue;
                    Pool.destroy((long)sendfileData.fdpool);
                    Socket.timeoutSet((long)sendfileData.socket, (long)(AprEndpoint.this.getConnectionTimeout() * 1000));
                    return SendfileState.DONE;
                }
            }
            catch (Exception exception) {
                log.warn((Object)AbstractEndpoint.sm.getString("endpoint.sendfile.error"), (Throwable)exception);
                return SendfileState.ERROR;
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.addS.add(sendfileData);
                this.notify();
            }
            return SendfileState.PENDING;
        }

        protected void remove(SendfileData sendfileData) {
            int n = Poll.remove((long)this.sendfilePollset, (long)sendfileData.socket);
            if (n == 0) {
                --this.sendfileCount;
            }
            this.sendfileData.remove(sendfileData.socket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = 0L;
            while (this.sendfileRunning) {
                Sendfile sendfile;
                while (this.sendfileRunning && AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(AprEndpoint.this.pollTime / 1000);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                while (this.sendfileRunning && this.sendfileCount < 1 && this.addS.size() < 1) {
                    l = 0L;
                    try {
                        sendfile = this;
                        synchronized (sendfile) {
                            if (this.sendfileRunning && this.sendfileCount < 1 && this.addS.size() < 1) {
                                this.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                if (!this.sendfileRunning) break;
                try {
                    Object object;
                    int n;
                    if (this.addS.size() > 0) {
                        sendfile = this;
                        synchronized (sendfile) {
                            for (n = this.addS.size() - 1; n >= 0; --n) {
                                object = this.addS.get(n);
                                int n2 = Poll.add((long)this.sendfilePollset, (long)((SendfileData)object).socket, (int)4);
                                if (n2 == 0) {
                                    this.sendfileData.put(((SendfileData)object).socket, (SendfileData)object);
                                    ++this.sendfileCount;
                                    continue;
                                }
                                AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.sendfile.addfail", new Object[]{n2, Error.strerror((int)n2)}));
                                AprEndpoint.this.closeSocketInternal(((SendfileData)object).socket);
                            }
                            this.addS.clear();
                        }
                    }
                    l += (long)AprEndpoint.this.pollTime;
                    int n3 = Poll.poll((long)this.sendfilePollset, (long)AprEndpoint.this.pollTime, (long[])this.desc, (boolean)false);
                    if (n3 > 0) {
                        block27: for (n = 0; n < n3; ++n) {
                            object = this.sendfileData.get(this.desc[n * 2 + 1]);
                            if ((this.desc[n * 2] & 0x20L) == 32L || (this.desc[n * 2] & 0x10L) == 16L) {
                                this.remove((SendfileData)object);
                                AprEndpoint.this.closeSocketInternal(((SendfileData)object).socket);
                                continue;
                            }
                            long l2 = Socket.sendfilen((long)((SendfileData)object).socket, (long)((SendfileData)object).fd, (long)((SendfileData)object).pos, (long)((SendfileData)object).length, (int)0);
                            if (l2 < 0L) {
                                this.remove((SendfileData)object);
                                AprEndpoint.this.closeSocketInternal(((SendfileData)object).socket);
                                continue;
                            }
                            ((SendfileData)object).pos += l2;
                            ((SendfileData)object).length -= l2;
                            if (((SendfileData)object).length != 0L) continue;
                            this.remove((SendfileData)object);
                            switch (((SendfileData)object).keepAliveState) {
                                case NONE: {
                                    AprEndpoint.this.closeSocketInternal(((SendfileData)object).socket);
                                    continue block27;
                                }
                                case PIPELINED: {
                                    Pool.destroy((long)((SendfileData)object).fdpool);
                                    Socket.timeoutSet((long)((SendfileData)object).socket, (long)(AprEndpoint.this.getConnectionTimeout() * 1000));
                                    if (AprEndpoint.this.processSocket(((SendfileData)object).socket, SocketEvent.OPEN_READ)) continue block27;
                                    AprEndpoint.this.closeSocketInternal(((SendfileData)object).socket);
                                    continue block27;
                                }
                                case OPEN: {
                                    Pool.destroy((long)((SendfileData)object).fdpool);
                                    Socket.timeoutSet((long)((SendfileData)object).socket, (long)(AprEndpoint.this.getConnectionTimeout() * 1000));
                                    AprEndpoint.this.getPoller().add(((SendfileData)object).socket, AprEndpoint.this.getKeepAliveTimeout(), 1);
                                }
                            }
                        }
                    } else if (n3 < 0 && (n = -n3) != 120001 && n != 120003) {
                        if (n > 120000) {
                            n -= 120000;
                        }
                        AprEndpoint.this.getLog().error((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollError", new Object[]{n, Error.strerror((int)n)}));
                        object = this;
                        synchronized (object) {
                            this.destroy();
                            this.init();
                            continue;
                        }
                    }
                    if (AprEndpoint.this.getConnectionTimeout() <= 0 || l <= 1000000L || !this.sendfileRunning) continue;
                    n3 = Poll.maintain((long)this.sendfilePollset, (long[])this.desc, (boolean)false);
                    l = 0L;
                    if (n3 <= 0) continue;
                    for (n = 0; n < n3; ++n) {
                        object = this.sendfileData.get(this.desc[n]);
                        this.remove((SendfileData)object);
                        AprEndpoint.this.closeSocketInternal(((SendfileData)object).socket);
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    AprEndpoint.this.getLog().error((Object)AbstractEndpoint.sm.getString("endpoint.poll.error"), throwable);
                }
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.notifyAll();
            }
        }
    }

    public static class SendfileData
    extends SendfileDataBase {
        protected long fd;
        protected long fdpool;
        protected long socket;

        public SendfileData(String string, long l, long l2) {
            super(string, l, l2);
        }
    }

    public class Poller
    implements Runnable {
        private long aprPoller;
        private int pollerSize = 0;
        private long pool = 0L;
        private long[] desc;
        private SocketList addList = null;
        private SocketList closeList = null;
        private SocketTimeouts timeouts = null;
        private long lastMaintain = System.currentTimeMillis();
        private AtomicInteger connectionCount = new AtomicInteger(0);
        private volatile Thread pollerThread;
        private volatile boolean pollerRunning = true;

        public int getConnectionCount() {
            return this.connectionCount.get();
        }

        protected synchronized void init() {
            this.pool = Pool.create((long)AprEndpoint.this.serverSockPool);
            this.pollerSize = AprEndpoint.this.getMaxConnections();
            this.timeouts = new SocketTimeouts(this.pollerSize);
            this.aprPoller = AprEndpoint.this.allocatePoller(this.pollerSize, this.pool, -1);
            this.desc = new long[this.pollerSize * 4];
            this.connectionCount.set(0);
            this.addList = new SocketList(this.pollerSize);
            this.closeList = new SocketList(this.pollerSize);
        }

        protected void start() {
            this.pollerThread = new Thread((Runnable)AprEndpoint.this.poller, AprEndpoint.this.getName() + "-Poller");
            this.pollerThread.setPriority(AprEndpoint.this.threadPriority);
            this.pollerThread.setDaemon(true);
            this.pollerThread.start();
        }

        protected synchronized void stop() {
            this.pollerRunning = false;
            this.notify();
        }

        protected synchronized void destroy() {
            for (int i = 50; i > 0 && this.pollerThread.isAlive(); --i) {
                try {
                    this.wait(AprEndpoint.this.pollTime / 1000);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.pollerThread.isAlive()) {
                log.warn((Object)AbstractEndpoint.sm.getString("endpoint.pollerThreadStop"));
            }
            SocketInfo socketInfo = this.closeList.get();
            while (socketInfo != null) {
                this.addList.remove(socketInfo.socket);
                this.removeFromPoller(socketInfo.socket);
                AprEndpoint.this.closeSocketInternal(socketInfo.socket);
                AprEndpoint.this.destroySocketInternal(socketInfo.socket);
                socketInfo = this.closeList.get();
            }
            this.closeList.clear();
            socketInfo = this.addList.get();
            while (socketInfo != null) {
                this.removeFromPoller(socketInfo.socket);
                AprEndpoint.this.closeSocketInternal(socketInfo.socket);
                AprEndpoint.this.destroySocketInternal(socketInfo.socket);
                socketInfo = this.addList.get();
            }
            this.addList.clear();
            int n = Poll.pollset((long)this.aprPoller, (long[])this.desc);
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    AprEndpoint.this.closeSocketInternal(this.desc[i * 2 + 1]);
                    AprEndpoint.this.destroySocketInternal(this.desc[i * 2 + 1]);
                }
            }
            Pool.destroy((long)this.pool);
            this.connectionCount.set(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(long l, long l2, int n) {
            Object object;
            if (log.isDebugEnabled()) {
                object = AbstractEndpoint.sm.getString("endpoint.debug.pollerAdd", new Object[]{l, l2, n});
                if (log.isTraceEnabled()) {
                    log.trace(object, (Throwable)new Exception());
                } else {
                    log.debug(object);
                }
            }
            if (l2 <= 0L) {
                l2 = Integer.MAX_VALUE;
            }
            object = this;
            synchronized (object) {
                if (this.addList.add(l, l2, n)) {
                    this.notify();
                }
            }
        }

        private boolean addToPoller(long l, int n) {
            int n2 = Poll.add((long)this.aprPoller, (long)l, (int)n);
            if (n2 == 0) {
                this.connectionCount.incrementAndGet();
                return true;
            }
            return false;
        }

        private synchronized void close(long l) {
            this.closeList.add(l, 0L, 0);
            this.notify();
        }

        private void removeFromPoller(long l) {
            int n;
            if (log.isDebugEnabled()) {
                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.pollerRemove", new Object[]{l}));
            }
            if ((n = Poll.remove((long)this.aprPoller, (long)l)) != 70015) {
                this.connectionCount.decrementAndGet();
                if (log.isDebugEnabled()) {
                    log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.pollerRemoved", new Object[]{l}));
                }
            }
            this.timeouts.remove(l);
        }

        private synchronized void maintain() {
            long l = System.currentTimeMillis();
            if (l - this.lastMaintain < 1000L) {
                return;
            }
            this.lastMaintain = l;
            long l2 = this.timeouts.check(l);
            while (l2 != 0L) {
                SocketWrapperBase socketWrapperBase;
                if (log.isDebugEnabled()) {
                    log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.socketTimeout", new Object[]{l2}));
                }
                if ((socketWrapperBase = (SocketWrapperBase)AprEndpoint.this.connections.get(l2)) != null) {
                    socketWrapperBase.setError(new SocketTimeoutException());
                    if (socketWrapperBase.readOperation != null || socketWrapperBase.writeOperation != null) {
                        if (socketWrapperBase.readOperation != null) {
                            socketWrapperBase.readOperation.process();
                        } else {
                            socketWrapperBase.writeOperation.process();
                        }
                    } else {
                        AprEndpoint.this.processSocket(socketWrapperBase, SocketEvent.ERROR, true);
                    }
                }
                l2 = this.timeouts.check(l);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Poller");
            long[] lArray = new long[this.pollerSize * 2];
            int n = Poll.pollset((long)this.aprPoller, (long[])lArray);
            stringBuilder.append(" [ ");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.desc[2 * i + 1]).append(' ');
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketList socketList = new SocketList(AprEndpoint.this.getMaxConnections());
            SocketList socketList2 = new SocketList(AprEndpoint.this.getMaxConnections());
            while (this.pollerRunning) {
                Object object;
                while (this.pollerRunning && this.connectionCount.get() < 1 && this.addList.size() < 1 && this.closeList.size() < 1) {
                    try {
                        if (AprEndpoint.this.getConnectionTimeout() > 0 && this.pollerRunning) {
                            this.maintain();
                        }
                        object = this;
                        synchronized (object) {
                            if (this.pollerRunning && this.addList.size() < 1 && this.closeList.size() < 1) {
                                this.wait(10000L);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.timeout.err"));
                    }
                }
                if (!this.pollerRunning) break;
                try {
                    long l;
                    int n;
                    object = this;
                    synchronized (object) {
                        if (this.closeList.size() > 0) {
                            this.closeList.duplicate(socketList2);
                            this.closeList.clear();
                        } else {
                            socketList2.clear();
                        }
                    }
                    object = this;
                    synchronized (object) {
                        if (this.addList.size() > 0) {
                            this.addList.duplicate(socketList);
                            this.addList.clear();
                        } else {
                            socketList.clear();
                        }
                    }
                    if (socketList2.size() > 0) {
                        object = socketList2.get();
                        while (object != null) {
                            socketList.remove(((SocketInfo)object).socket);
                            this.removeFromPoller(((SocketInfo)object).socket);
                            AprEndpoint.this.closeSocketInternal(((SocketInfo)object).socket);
                            AprEndpoint.this.destroySocketInternal(((SocketInfo)object).socket);
                            object = socketList2.get();
                        }
                    }
                    if (socketList.size() > 0) {
                        object = socketList.get();
                        while (object != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.pollerAddDo", new Object[]{((SocketInfo)object).socket}));
                            }
                            this.timeouts.remove(((SocketInfo)object).socket);
                            AprSocketWrapper aprSocketWrapper = (AprSocketWrapper)AprEndpoint.this.connections.get(((SocketInfo)object).socket);
                            if (aprSocketWrapper != null) {
                                if (((SocketInfo)object).read() || ((SocketInfo)object).write()) {
                                    aprSocketWrapper.pollerFlags = aprSocketWrapper.pollerFlags | (((SocketInfo)object).read() ? 1 : 0) | (((SocketInfo)object).write() ? 4 : 0);
                                    this.removeFromPoller(((SocketInfo)object).socket);
                                    if (!this.addToPoller(((SocketInfo)object).socket, aprSocketWrapper.pollerFlags)) {
                                        aprSocketWrapper.close();
                                    } else {
                                        this.timeouts.add(((SocketInfo)object).socket, System.currentTimeMillis() + ((SocketInfo)object).timeout);
                                    }
                                } else {
                                    aprSocketWrapper.close();
                                    AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollAddInvalid", new Object[]{object}));
                                }
                            }
                            object = socketList.get();
                        }
                    }
                    boolean bl = false;
                    int n2 = Poll.poll((long)this.aprPoller, (long)AprEndpoint.this.pollTime, (long[])this.desc, (boolean)true);
                    if (n2 > 0) {
                        n2 = this.mergeDescriptors(this.desc, n2);
                        this.connectionCount.addAndGet(-n2);
                        for (n = 0; n < n2; ++n) {
                            if (AprEndpoint.this.getLog().isDebugEnabled()) {
                                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.pollerProcess", new Object[]{this.desc[n * 2 + 1], this.desc[n * 2]}));
                            }
                            l = this.timeouts.remove(this.desc[n * 2 + 1]);
                            AprSocketWrapper aprSocketWrapper = (AprSocketWrapper)AprEndpoint.this.connections.get(this.desc[n * 2 + 1]);
                            if (aprSocketWrapper == null) continue;
                            aprSocketWrapper.pollerFlags = aprSocketWrapper.pollerFlags & ~((int)this.desc[n * 2]);
                            if ((this.desc[n * 2] & 0x20L) == 32L || (this.desc[n * 2] & 0x10L) == 16L || (this.desc[n * 2] & 0x40L) == 64L) {
                                if ((this.desc[n * 2] & 1L) == 1L) {
                                    if (AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketEvent.OPEN_READ)) continue;
                                    aprSocketWrapper.close();
                                    continue;
                                }
                                if ((this.desc[n * 2] & 4L) == 4L) {
                                    if (AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketEvent.OPEN_WRITE)) continue;
                                    aprSocketWrapper.close();
                                    continue;
                                }
                                if ((aprSocketWrapper.pollerFlags & 1) == 1) {
                                    if (AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketEvent.OPEN_READ)) continue;
                                    aprSocketWrapper.close();
                                    continue;
                                }
                                if ((aprSocketWrapper.pollerFlags & 4) == 4) {
                                    if (AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketEvent.OPEN_WRITE)) continue;
                                    aprSocketWrapper.close();
                                    continue;
                                }
                                aprSocketWrapper.close();
                                continue;
                            }
                            if ((this.desc[n * 2] & 1L) == 1L || (this.desc[n * 2] & 4L) == 4L) {
                                boolean bl2 = false;
                                if ((this.desc[n * 2] & 1L) == 1L && !AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketEvent.OPEN_READ)) {
                                    bl2 = true;
                                    aprSocketWrapper.close();
                                }
                                if (!bl2 && (this.desc[n * 2] & 4L) == 4L && !AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketEvent.OPEN_WRITE)) {
                                    bl2 = true;
                                    aprSocketWrapper.close();
                                }
                                if (bl2 || aprSocketWrapper.pollerFlags == 0) continue;
                                if (l > 0L) {
                                    l -= System.currentTimeMillis();
                                }
                                if (l <= 0L) {
                                    l = 1L;
                                }
                                if (l > Integer.MAX_VALUE) {
                                    l = Integer.MAX_VALUE;
                                }
                                this.add(this.desc[n * 2 + 1], (int)l, aprSocketWrapper.pollerFlags);
                                continue;
                            }
                            AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollUnknownEvent", new Object[]{this.desc[n * 2]}));
                            aprSocketWrapper.close();
                        }
                    } else if (n2 < 0 && (n = -n2) != 120001 && n != 120003) {
                        if (n > 120000) {
                            n -= 120000;
                        }
                        AprEndpoint.this.getLog().error((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollError", new Object[]{n, Error.strerror((int)n)}));
                        bl = true;
                    }
                    if (bl && this.pollerRunning) {
                        n = Poll.pollset((long)this.aprPoller, (long[])this.desc);
                        l = AprEndpoint.this.allocatePoller(this.pollerSize, this.pool, -1);
                        this.connectionCount.addAndGet(-n);
                        Poll.destroy((long)this.aprPoller);
                        this.aprPoller = l;
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.poll.error"), throwable);
                }
                try {
                    if (AprEndpoint.this.getConnectionTimeout() <= 0 || !this.pollerRunning) continue;
                    this.maintain();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.timeout.err"), throwable);
                }
            }
            Poller poller = this;
            synchronized (poller) {
                this.notifyAll();
            }
        }

        private int mergeDescriptors(long[] lArray, int n) {
            int n2;
            HashMap<Long, Long> hashMap = new HashMap<Long, Long>(n);
            for (n2 = 0; n2 < n; ++n2) {
                Long l3 = hashMap.merge(lArray[2 * n2 + 1], lArray[2 * n2], (l, l2) -> l | l2);
                if (!log.isDebugEnabled() || l3 == lArray[2 * n2]) continue;
                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollMergeEvents", new Object[]{lArray[2 * n2 + 1], lArray[2 * n2], l3}));
            }
            n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                lArray[n2++] = (Long)entry.getValue();
                lArray[n2++] = (Long)entry.getKey();
            }
            return hashMap.size();
        }
    }

    public static class SocketList {
        protected volatile int size = 0;
        protected int pos = 0;
        protected long[] sockets;
        protected long[] timeouts;
        protected int[] flags;
        protected SocketInfo info = new SocketInfo();

        public SocketList(int n) {
            this.sockets = new long[n];
            this.timeouts = new long[n];
            this.flags = new int[n];
        }

        public int size() {
            return this.size;
        }

        public SocketInfo get() {
            if (this.pos == this.size) {
                return null;
            }
            this.info.socket = this.sockets[this.pos];
            this.info.timeout = this.timeouts[this.pos];
            this.info.flags = this.flags[this.pos];
            ++this.pos;
            return this.info;
        }

        public void clear() {
            this.size = 0;
            this.pos = 0;
        }

        public boolean add(long l, long l2, int n) {
            if (this.size == this.sockets.length) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != l) continue;
                this.flags[i] = SocketInfo.merge(this.flags[i], n);
                return true;
            }
            this.sockets[this.size] = l;
            this.timeouts[this.size] = l2;
            this.flags[this.size] = n;
            ++this.size;
            return true;
        }

        public boolean remove(long l) {
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != l) continue;
                this.sockets[i] = this.sockets[this.size - 1];
                this.timeouts[i] = this.timeouts[this.size - 1];
                this.flags[this.size] = this.flags[this.size - 1];
                --this.size;
                return true;
            }
            return false;
        }

        public void duplicate(SocketList socketList) {
            socketList.size = this.size;
            socketList.pos = this.pos;
            System.arraycopy(this.sockets, 0, socketList.sockets, 0, this.size);
            System.arraycopy(this.timeouts, 0, socketList.timeouts, 0, this.size);
            System.arraycopy(this.flags, 0, socketList.flags, 0, this.size);
        }
    }

    public static class SocketTimeouts {
        protected int size = 0;
        protected long[] sockets;
        protected long[] timeouts;
        protected int pos = 0;

        public SocketTimeouts(int n) {
            this.sockets = new long[n];
            this.timeouts = new long[n];
        }

        public void add(long l, long l2) {
            this.sockets[this.size] = l;
            this.timeouts[this.size] = l2;
            ++this.size;
        }

        public long remove(long l) {
            long l2 = 0L;
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != l) continue;
                l2 = this.timeouts[i];
                this.sockets[i] = this.sockets[this.size - 1];
                this.timeouts[i] = this.timeouts[this.size - 1];
                --this.size;
                break;
            }
            return l2;
        }

        public long check(long l) {
            while (this.pos < this.size) {
                if (l >= this.timeouts[this.pos]) {
                    long l2 = this.sockets[this.pos];
                    this.sockets[this.pos] = this.sockets[this.size - 1];
                    this.timeouts[this.pos] = this.timeouts[this.size - 1];
                    --this.size;
                    return l2;
                }
                ++this.pos;
            }
            this.pos = 0;
            return 0L;
        }
    }

    public static class SocketInfo {
        public long socket;
        public long timeout;
        public int flags;

        public boolean read() {
            return (this.flags & 1) == 1;
        }

        public boolean write() {
            return (this.flags & 4) == 4;
        }

        public static int merge(int n, int n2) {
            return n & 1 | n2 & 1 | (n & 4 | n2 & 4);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Socket: [");
            stringBuilder.append(this.socket);
            stringBuilder.append("], timeout: [");
            stringBuilder.append(this.timeout);
            stringBuilder.append("], flags: [");
            stringBuilder.append(this.flags);
            return stringBuilder.toString();
        }
    }
}

