/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

public final class SecurityClassLoad {
    public static void securityClassLoad(ClassLoader classLoader) throws Exception {
        SecurityClassLoad.securityClassLoad(classLoader, true);
    }

    static void securityClassLoad(ClassLoader classLoader, boolean bl) throws Exception {
        if (bl && System.getSecurityManager() == null) {
            return;
        }
        SecurityClassLoad.loadCorePackage(classLoader);
        SecurityClassLoad.loadCoyotePackage(classLoader);
        SecurityClassLoad.loadLoaderPackage(classLoader);
        SecurityClassLoad.loadRealmPackage(classLoader);
        SecurityClassLoad.loadServletsPackage(classLoader);
        SecurityClassLoad.loadSessionPackage(classLoader);
        SecurityClassLoad.loadUtilPackage(classLoader);
        SecurityClassLoad.loadJavaxPackage(classLoader);
        SecurityClassLoad.loadConnectorPackage(classLoader);
        SecurityClassLoad.loadTomcatPackage(classLoader);
    }

    private static final void loadCorePackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.core.AccessLogAdapter");
        classLoader.loadClass("org.apache.catalina.core.ApplicationContextFacade$PrivilegedExecuteMethod");
        classLoader.loadClass("org.apache.catalina.core.ApplicationDispatcher$PrivilegedForward");
        classLoader.loadClass("org.apache.catalina.core.ApplicationDispatcher$PrivilegedInclude");
        classLoader.loadClass("org.apache.catalina.core.ApplicationPushBuilder");
        classLoader.loadClass("org.apache.catalina.core.AsyncContextImpl");
        classLoader.loadClass("org.apache.catalina.core.AsyncContextImpl$AsyncRunnable");
        classLoader.loadClass("org.apache.catalina.core.AsyncContextImpl$DebugException");
        classLoader.loadClass("org.apache.catalina.core.AsyncListenerWrapper");
        classLoader.loadClass("org.apache.catalina.core.ContainerBase$PrivilegedAddChild");
        classLoader.loadClass("org.apache.catalina.core.DefaultInstanceManager$AnnotationCacheEntry");
        classLoader.loadClass("org.apache.catalina.core.DefaultInstanceManager$AnnotationCacheEntryType");
        classLoader.loadClass("org.apache.catalina.core.DefaultInstanceManager$PrivilegedGetField");
        classLoader.loadClass("org.apache.catalina.core.DefaultInstanceManager$PrivilegedGetMethod");
        classLoader.loadClass("org.apache.catalina.core.DefaultInstanceManager$PrivilegedLoadClass");
        classLoader.loadClass("org.apache.catalina.core.ApplicationHttpRequest$AttributeNamesEnumerator");
    }

    private static final void loadLoaderPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.loader.WebappClassLoaderBase$PrivilegedFindClassByName");
        classLoader.loadClass("org.apache.catalina.loader.WebappClassLoaderBase$PrivilegedHasLoggingConfig");
    }

    private static final void loadRealmPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.realm.LockOutRealm$LockRecord");
    }

    private static final void loadServletsPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.servlets.DefaultServlet");
    }

    private static final void loadSessionPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.session.StandardSession");
        classLoader.loadClass("org.apache.catalina.session.StandardSession$PrivilegedNewSessionFacade");
        classLoader.loadClass("org.apache.catalina.session.StandardManager$PrivilegedDoUnload");
    }

    private static final void loadUtilPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.util.ParameterMap");
        classLoader.loadClass("org.apache.catalina.util.RequestUtil");
        classLoader.loadClass("org.apache.catalina.util.TLSUtil");
    }

    private static final void loadCoyotePackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.coyote.http11.Constants");
        Class<?> clazz = classLoader.loadClass("org.apache.coyote.Constants");
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        classLoader.loadClass("org.apache.coyote.http2.Stream$PrivilegedPush");
    }

    private static final void loadJavaxPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("javax.servlet.http.Cookie");
    }

    private static final void loadConnectorPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetAttributePrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetParameterMapPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetRequestDispatcherPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetParameterPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetParameterNamesPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetParameterValuePrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetCharacterEncodingPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetHeadersPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetHeaderNamesPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetCookiesPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetLocalePrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetLocalesPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.ResponseFacade$SetContentTypePrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.ResponseFacade$DateHeaderPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetSessionPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.ResponseFacade$FlushBufferPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.OutputBuffer$PrivilegedCreateConverter");
        classLoader.loadClass("org.apache.catalina.connector.CoyoteInputStream$PrivilegedAvailable");
        classLoader.loadClass("org.apache.catalina.connector.CoyoteInputStream$PrivilegedClose");
        classLoader.loadClass("org.apache.catalina.connector.CoyoteInputStream$PrivilegedRead");
        classLoader.loadClass("org.apache.catalina.connector.CoyoteInputStream$PrivilegedReadArray");
        classLoader.loadClass("org.apache.catalina.connector.CoyoteInputStream$PrivilegedReadBuffer");
        classLoader.loadClass("org.apache.catalina.connector.CoyoteOutputStream");
        classLoader.loadClass("org.apache.catalina.connector.InputBuffer$PrivilegedCreateConverter");
        classLoader.loadClass("org.apache.catalina.connector.Response$PrivilegedDoIsEncodable");
        classLoader.loadClass("org.apache.catalina.connector.Response$PrivilegedGenerateCookieString");
        classLoader.loadClass("org.apache.catalina.connector.Response$PrivilegedEncodeUrl");
    }

    private static final void loadTomcatPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.tomcat.util.buf.B2CConverter");
        classLoader.loadClass("org.apache.tomcat.util.buf.ByteBufferUtils");
        classLoader.loadClass("org.apache.tomcat.util.buf.C2BConverter");
        classLoader.loadClass("org.apache.tomcat.util.buf.HexUtils");
        classLoader.loadClass("org.apache.tomcat.util.buf.StringCache");
        classLoader.loadClass("org.apache.tomcat.util.buf.StringCache$ByteEntry");
        classLoader.loadClass("org.apache.tomcat.util.buf.StringCache$CharEntry");
        classLoader.loadClass("org.apache.tomcat.util.buf.UriUtil");
        classLoader.loadClass("org.apache.tomcat.util.collections.CaseInsensitiveKeyMap");
        classLoader.loadClass("org.apache.tomcat.util.collections.CaseInsensitiveKeyMap$EntryImpl");
        classLoader.loadClass("org.apache.tomcat.util.collections.CaseInsensitiveKeyMap$EntryIterator");
        classLoader.loadClass("org.apache.tomcat.util.collections.CaseInsensitiveKeyMap$EntrySet");
        classLoader.loadClass("org.apache.tomcat.util.collections.CaseInsensitiveKeyMap$Key");
        classLoader.loadClass("org.apache.tomcat.util.http.CookieProcessor");
        classLoader.loadClass("org.apache.tomcat.util.http.NamesEnumerator");
        Class<?> clazz = classLoader.loadClass("org.apache.tomcat.util.http.FastHttpDateFormat");
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        classLoader.loadClass("org.apache.tomcat.util.http.parser.HttpParser");
        classLoader.loadClass("org.apache.tomcat.util.http.parser.MediaType");
        classLoader.loadClass("org.apache.tomcat.util.http.parser.MediaTypeCache");
        classLoader.loadClass("org.apache.tomcat.util.http.parser.SkipResult");
        classLoader.loadClass("org.apache.tomcat.util.net.Constants");
        classLoader.loadClass("org.apache.tomcat.util.net.DispatchType");
        classLoader.loadClass("org.apache.tomcat.util.net.AprEndpoint$AprSocketWrapper$AprOperationState");
        classLoader.loadClass("org.apache.tomcat.util.net.NioEndpoint$NioSocketWrapper$NioOperationState");
        classLoader.loadClass("org.apache.tomcat.util.net.Nio2Endpoint$Nio2SocketWrapper$Nio2OperationState");
        classLoader.loadClass("org.apache.tomcat.util.net.SocketWrapperBase$BlockingMode");
        classLoader.loadClass("org.apache.tomcat.util.net.SocketWrapperBase$CompletionCheck");
        classLoader.loadClass("org.apache.tomcat.util.net.SocketWrapperBase$CompletionHandlerCall");
        classLoader.loadClass("org.apache.tomcat.util.net.SocketWrapperBase$CompletionState");
        classLoader.loadClass("org.apache.tomcat.util.net.SocketWrapperBase$VectoredIOCompletionHandler");
        classLoader.loadClass("org.apache.tomcat.util.net.TLSClientHelloExtractor");
        classLoader.loadClass("org.apache.tomcat.util.net.TLSClientHelloExtractor$ExtractorResult");
        classLoader.loadClass("org.apache.tomcat.util.security.PrivilegedGetTccl");
        classLoader.loadClass("org.apache.tomcat.util.security.PrivilegedSetTccl");
    }
}

