/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import javax.naming.NamingException;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.ClientEndpointHolder;
import org.apache.tomcat.websocket.pojo.PojoEndpointClient;

public class PojoHolder
implements ClientEndpointHolder {
    private static final StringManager sm = StringManager.getManager(PojoHolder.class);
    private final Object pojo;
    private final ClientEndpointConfig clientEndpointConfig;

    public PojoHolder(Object object, ClientEndpointConfig clientEndpointConfig) {
        this.pojo = object;
        this.clientEndpointConfig = clientEndpointConfig;
    }

    @Override
    public String getClassName() {
        return this.pojo.getClass().getName();
    }

    @Override
    public Endpoint getInstance(InstanceManager instanceManager) throws DeploymentException {
        if (instanceManager != null) {
            try {
                instanceManager.newInstance(this.pojo);
            }
            catch (ReflectiveOperationException | NamingException exception) {
                throw new DeploymentException(sm.getString("clientEndpointHolder.instanceRegistrationFailed"), (Throwable)exception);
            }
        }
        return new PojoEndpointClient(this.pojo, this.clientEndpointConfig.getDecoders(), instanceManager);
    }
}

