/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.cpu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ThreadInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.common.ProfilingSettingsPresets;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.filters.InstrumentationFilter;
import org.graalvm.visualvm.lib.jfluid.results.ResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.StackTraceSnapshotBuilder;
import org.graalvm.visualvm.lib.profiler.LoadedSnapshot;
import org.graalvm.visualvm.lib.profiler.ResultsManager;
import org.graalvm.visualvm.sampler.AbstractSamplerSupport;
import org.graalvm.visualvm.sampler.cpu.CPUView;
import org.graalvm.visualvm.sampler.cpu.ThreadInfoProvider;
import org.graalvm.visualvm.sampler.cpu.ThreadsCPU;
import org.graalvm.visualvm.sampler.cpu.ThreadsCPUInfo;
import org.graalvm.visualvm.sampler.cpu.ThreadsCPUView;
import org.openide.util.NbBundle;

public abstract class CPUSamplerSupport
extends AbstractSamplerSupport {
    private final Application application;
    private final ThreadInfoProvider threadInfoProvider;
    private final SnapshotDumper snapshotDumper;
    private final ThreadDumper threadDumper;
    private Timer timer;
    private TimerTask samplerTask;
    private final AbstractSamplerSupport.Refresher refresher;
    private int refreshRate;
    private StackTraceSnapshotBuilder builder;
    private volatile boolean sampleRunning;
    private final Object updateLock = new Object();
    private long currentLiveUpdate;
    private long lastLiveUpdate;
    private CPUView cpuView;
    private DataViewComponent.DetailsView[] detailsViews;
    private javax.swing.Timer threadCPUTimer;
    private AbstractSamplerSupport.Refresher threadCPURefresher;
    private ThreadsCPUView threadCPUView;
    private ThreadsCPU threadsCPU;

    public CPUSamplerSupport(Application application, ThreadInfoProvider tip, ThreadsCPU tcpu, SnapshotDumper snapshotDumper, ThreadDumper threadDumper) {
        this.application = application;
        this.threadInfoProvider = tip;
        this.threadsCPU = tcpu;
        this.snapshotDumper = snapshotDumper;
        this.threadDumper = threadDumper;
        this.refreshRate = GlobalPreferences.sharedInstance().getMonitoredDataPoll() * 1000;
        this.refresher = new AbstractSamplerSupport.Refresher(){

            @Override
            public void setRefreshRate(int rr) {
                CPUSamplerSupport.this.refreshRate = rr;
            }

            @Override
            public int getRefreshRate() {
                return CPUSamplerSupport.this.refreshRate;
            }

            @Override
            protected boolean checkRefresh() {
                return CPUSamplerSupport.this.samplerTask != null && CPUSamplerSupport.this.cpuView.isShowing();
            }

            @Override
            protected void doRefresh() {
                CPUSamplerSupport.this.doRefreshImpl();
            }
        };
        if (this.threadsCPU != null) {
            this.threadCPURefresher = new AbstractSamplerSupport.Refresher(){

                @Override
                public final boolean checkRefresh() {
                    if (CPUSamplerSupport.this.threadCPUTimer == null) {
                        return false;
                    }
                    if (!CPUSamplerSupport.this.threadCPUTimer.isRunning()) {
                        return false;
                    }
                    return CPUSamplerSupport.this.threadCPUView.isShowing();
                }

                @Override
                public final void doRefresh() {
                    CPUSamplerSupport.this.doRefreshImpl(CPUSamplerSupport.this.threadCPUTimer, CPUSamplerSupport.this.threadCPUView);
                }

                @Override
                public final void setRefreshRate(int refreshRate) {
                    CPUSamplerSupport.this.threadCPUTimer.setDelay(refreshRate);
                    CPUSamplerSupport.this.threadCPUTimer.setInitialDelay(refreshRate);
                    CPUSamplerSupport.this.threadCPUTimer.restart();
                }

                @Override
                public final int getRefreshRate() {
                    return CPUSamplerSupport.this.threadCPUTimer.getDelay();
                }
            };
        }
    }

    @Override
    public DataViewComponent.DetailsView[] getDetailsView() {
        if (this.detailsViews == null) {
            this.cpuView = new CPUView(this.refresher, this.snapshotDumper, this.threadDumper, this.application);
            this.detailsViews = new DataViewComponent.DetailsView[this.threadsCPU != null ? 2 : 1];
            this.detailsViews[0] = new DataViewComponent.DetailsView(NbBundle.getMessage(CPUSamplerSupport.class, (String)"LBL_Cpu_samples"), null, 10, (JComponent)this.cpuView, null);
            if (this.threadsCPU != null) {
                this.threadCPUView = new ThreadsCPUView(this.threadCPURefresher, this.threadDumper);
                this.detailsViews[1] = new DataViewComponent.DetailsView(NbBundle.getMessage(CPUSamplerSupport.class, (String)"LBL_ThreadAlloc"), null, 20, (JComponent)this.threadCPUView, null);
            }
        }
        this.cpuView.initSession();
        if (this.threadsCPU != null) {
            this.threadCPUView.initSession();
        }
        return (DataViewComponent.DetailsView[])this.detailsViews.clone();
    }

    @Override
    public boolean startSampling(ProfilingSettings settings, int samplingRate, int refreshRate) {
        this.checkCPUSamplingRate(samplingRate);
        GenericFilter sf = settings.getInstrumentationFilter();
        InstrumentationFilter filter = new InstrumentationFilter(sf);
        this.builder = this.snapshotDumper.getNewBuilder(filter, samplingRate);
        this.refresher.setRefreshRate(refreshRate);
        final StackTraceSnapshotBuilder _builder = this.builder;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CPUSamplerSupport.this.cpuView != null) {
                    CPUSamplerSupport.this.cpuView.setBuilder(_builder);
                    CPUSamplerSupport.this.cpuView.starting();
                }
                if (CPUSamplerSupport.this.threadCPUView != null) {
                    CPUSamplerSupport.this.threadCPUView.starting();
                }
            }
        });
        if (this.timer == null) {
            this.timer = this.getTimer();
        }
        this.samplerTask = new SamplerTask(this.builder);
        this.timer.scheduleAtFixedRate(this.samplerTask, 0L, (long)samplingRate);
        if (this.threadsCPU != null) {
            this.threadCPUTimer = new javax.swing.Timer(refreshRate, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CPUSamplerSupport.this.threadCPURefresher.refresh();
                }
            });
            this.threadCPURefresher.setRefreshRate(refreshRate);
        }
        return true;
    }

    @Override
    public void takeSnapshot(boolean openView) {
        this.snapshotDumper.takeSnapshot(openView);
    }

    @Override
    public synchronized void stopSampling() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CPUSamplerSupport.this.cpuView != null) {
                    CPUSamplerSupport.this.cpuView.stopping();
                }
                if (CPUSamplerSupport.this.threadCPUView != null) {
                    CPUSamplerSupport.this.threadCPUView.stopping();
                }
            }
        });
        if (this.samplerTask != null) {
            this.samplerTask.cancel();
            this.samplerTask = null;
        }
        if (this.threadCPUTimer != null) {
            this.threadCPUTimer.stop();
            this.threadCPUTimer = null;
        }
    }

    @Override
    public synchronized void terminate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CPUSamplerSupport.this.cpuView != null) {
                    CPUSamplerSupport.this.cpuView.terminated();
                }
                if (CPUSamplerSupport.this.threadCPUView != null) {
                    CPUSamplerSupport.this.threadCPUView.terminated();
                }
            }
        });
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.builder = null;
    }

    private void doRefreshImpl() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (CPUSamplerSupport.this.samplerTask == null) {
                    return;
                }
                if (!CPUSamplerSupport.this.sampleRunning) {
                    Object object = CPUSamplerSupport.this.updateLock;
                    synchronized (object) {
                        CPUSamplerSupport.this.lastLiveUpdate = CPUSamplerSupport.this.currentLiveUpdate;
                        CPUSamplerSupport.this.cpuView.refresh();
                    }
                } else {
                    SwingUtilities.invokeLater(this);
                }
            }
        });
    }

    private void doRefreshImpl(final javax.swing.Timer stimer, final ThreadsCPUView view) {
        if (!stimer.isRunning() || view.isPaused()) {
            return;
        }
        try {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (!stimer.isRunning()) {
                            return;
                        }
                        CPUSamplerSupport.this.doRefreshImplImpl(CPUSamplerSupport.this.threadsCPU.getThreadsCPUInfo(), view);
                    }
                    catch (Exception e) {
                        CPUSamplerSupport.this.terminate();
                    }
                }
            }, 0L);
        }
        catch (Exception e) {
            this.terminate();
        }
    }

    private void doRefreshImplImpl(final ThreadsCPUInfo info, final ThreadsCPUView view) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                view.refresh(info);
            }
        });
    }

    public static abstract class SnapshotDumper {
        private StackTraceSnapshotBuilder builder;
        private int samplingRate;

        StackTraceSnapshotBuilder getNewBuilder(InstrumentationFilter filter, int sampling) {
            this.builder = new StackTraceSnapshotBuilder(1, filter);
            this.samplingRate = sampling;
            return this.builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final LoadedSnapshot takeNPSSnapshot(File directory) throws IOException, CPUResultsSnapshot.NoDataAvailableException {
            if (this.builder == null) {
                throw new IllegalStateException("Builder is null");
            }
            long time = System.currentTimeMillis();
            CPUResultsSnapshot snapshot = this.builder.createSnapshot(time);
            ProfilingSettings settings = ProfilingSettingsPresets.createCPUPreset();
            settings.setInstrumentationFilter((GenericFilter)this.builder.getFilter());
            settings.setSamplingFrequency(this.samplingRate);
            LoadedSnapshot ls = new LoadedSnapshot((ResultsSnapshot)snapshot, settings, null, null);
            File file = Utils.getUniqueFile((File)directory, (String)ResultsManager.getDefault().getDefaultSnapshotFileName(ls), (String)".nps");
            try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
                ls.save(dos);
                ls.setFile(file);
                ls.setSaved(true);
            }
            return ls;
        }

        public abstract void takeSnapshot(boolean var1);
    }

    public static abstract class ThreadDumper {
        public abstract void takeThreadDump(boolean var1);
    }

    private class SamplerTask
    extends TimerTask {
        private final StackTraceSnapshotBuilder builder;
        private final Set samplingThreads = new HashSet();

        SamplerTask(StackTraceSnapshotBuilder builder) {
            this.builder = builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (CPUSamplerSupport.this.sampleRunning) {
                return;
            }
            CPUSamplerSupport.this.sampleRunning = true;
            Object object = CPUSamplerSupport.this.updateLock;
            synchronized (object) {
                try {
                    ThreadInfo[] infos = CPUSamplerSupport.this.threadInfoProvider.dumpAllThreads();
                    long timestamp = System.nanoTime();
                    String samplingThreadName = this.findSamplingThread(infos);
                    if (samplingThreadName != null && this.samplingThreads.add(samplingThreadName)) {
                        this.builder.setIgnoredThreads(this.samplingThreads);
                    }
                    this.builder.addStacktrace(infos, timestamp);
                    CPUSamplerSupport.this.currentLiveUpdate = timestamp / 1000000L;
                    if (CPUSamplerSupport.this.currentLiveUpdate - CPUSamplerSupport.this.lastLiveUpdate >= (long)CPUSamplerSupport.this.refreshRate) {
                        CPUSamplerSupport.this.refresher.refresh();
                    }
                }
                catch (Throwable ex) {
                    CPUSamplerSupport.this.terminate();
                }
                finally {
                    CPUSamplerSupport.this.sampleRunning = false;
                }
            }
        }

        private String findSamplingThread(ThreadInfo[] infos) {
            return null;
        }
    }
}

