/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.lang.management.ThreadInfo;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.FilterUtils;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.SearchUtils;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.McsTimeRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberPercentRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.graalvm.visualvm.sampler.AbstractSamplerSupport;
import org.graalvm.visualvm.sampler.cpu.Bundle;
import org.graalvm.visualvm.sampler.cpu.CPUSamplerSupport;
import org.graalvm.visualvm.sampler.cpu.CPUView;
import org.graalvm.visualvm.sampler.cpu.ThreadsCPUInfo;
import org.openide.util.NbBundle;

final class ThreadsCPUView
extends JPanel {
    private static final double NSEC_TO_USEC = 1000.0;
    private final AbstractSamplerSupport.Refresher refresher;
    private final CPUSamplerSupport.ThreadDumper threadDumper;
    private boolean forceRefresh = false;
    private List<ThreadInfo> threads;
    private List<Long> threadCPUInfo;
    private List<Long> threadCPUInfoPerSec;
    private ThreadsCPUInfo currentThreadsInfo;
    private ThreadsCPUInfo baseThreadsInfo;
    private int totalThreads = -1;
    private long totalCPUTime = -1L;
    private JLabel lrLabel;
    private JToggleButton lrPauseButton;
    private JButton lrRefreshButton;
    private JToggleButton lrDeltasButton;
    private ProfilerToolbar toolbar;
    private AbstractButton threaddumpButton;
    private boolean popupPause;
    private JComponent bottomPanel;
    private JComponent filterPanel;
    private JComponent searchPanel;
    private NumberRenderer threadsCount;
    private McsTimeRenderer threadsTotalTime;
    private TreadsCPUTableModel tableModel;
    private ProfilerTable table;
    private HideableBarRenderer[] renderers;
    private static final String COL_NAME = NbBundle.getMessage(CPUView.class, (String)"COL_Thread_name");
    private static final String COL_BYTES = NbBundle.getMessage(CPUView.class, (String)"COL_ABytes");
    private static final String COL_BYTES_SEC = NbBundle.getMessage(CPUView.class, (String)"COL_ABytes_Sec");

    ThreadsCPUView(AbstractSamplerSupport.Refresher refresher, CPUSamplerSupport.ThreadDumper threadDumper) {
        this.refresher = refresher;
        this.threadDumper = threadDumper;
        this.threads = Collections.EMPTY_LIST;
        this.threadCPUInfo = Collections.EMPTY_LIST;
        this.threadCPUInfoPerSec = Collections.EMPTY_LIST;
        this.initComponents();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && ThreadsCPUView.this.isShowing()) {
                    ThreadsCPUView.this.refresher.refresh();
                }
            }
        });
    }

    void initSession() {
    }

    boolean isPaused() {
        return this.lrPauseButton.isSelected() && !this.forceRefresh;
    }

    boolean isEmpty() {
        return this.tableModel.getRowCount() == 0;
    }

    void refresh(ThreadsCPUInfo info) {
        if (!this.isShowing() || this.lrPauseButton.isSelected() && !this.forceRefresh) {
            return;
        }
        this.forceRefresh = false;
        this.threads = info.getThreads();
        this.threadCPUInfo = info.getThreadCPUTime();
        this.totalCPUTime = info.getTotalCPUTime();
        if (this.currentThreadsInfo != null) {
            this.threadCPUInfoPerSec = this.currentThreadsInfo.getCPUTimePerSecond(info);
        }
        this.currentThreadsInfo = info;
        boolean diff = this.lrDeltasButton.isSelected();
        if (diff) {
            if (this.baseThreadsInfo == null) {
                this.baseThreadsInfo = info;
            }
            this.totalThreads = this.threads.size() - this.baseThreadsInfo.getThreads().size();
            this.threadCPUInfo = this.baseThreadsInfo.getThreadCPUTimeDiff(info);
            this.totalCPUTime = this.baseThreadsInfo.getTotalDiffCPUTime();
        } else {
            if (this.baseThreadsInfo != null) {
                this.baseThreadsInfo = null;
            }
            this.threadCPUInfo = info.getThreadCPUTime();
            this.totalCPUTime = info.getTotalCPUTime();
            this.totalThreads = this.threads.size();
        }
        this.renderers[0].setDiffMode(diff);
        this.renderers[0].setMaxValue((long)Math.ceil((double)this.totalCPUTime / 1000.0));
        this.threadsCount.setDiffMode(diff);
        this.threadsCount.setValue((Object)this.totalThreads, -1);
        this.threadsTotalTime.setDiffMode(diff);
        this.threadsTotalTime.setValue((Object)Math.ceil((double)this.totalCPUTime / 1000.0), -1);
        this.tableModel.fireTableDataChanged();
    }

    void starting() {
        this.lrPauseButton.setEnabled(true);
        this.lrRefreshButton.setEnabled(false);
        this.lrDeltasButton.setEnabled(true);
    }

    void stopping() {
        this.lrPauseButton.setEnabled(false);
        this.lrRefreshButton.setEnabled(false);
        this.lrDeltasButton.setEnabled(false);
    }

    void terminated() {
        this.lrPauseButton.setEnabled(false);
        this.lrRefreshButton.setEnabled(false);
        this.lrDeltasButton.setEnabled(false);
        this.threaddumpButton.setEnabled(false);
    }

    private void initComponents() {
        this.tableModel = new TreadsCPUTableModel();
        this.table = new ProfilerTable(this.tableModel, true, true, null){

            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                popup.add(this.createCopyMenuItem());
                popup.addSeparator();
                popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        ThreadsCPUView.this.activateFilter();
                    }
                });
                popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        ThreadsCPUView.this.activateSearch();
                    }
                });
            }

            protected void popupShowing() {
                if (ThreadsCPUView.this.lrPauseButton.isEnabled() && !ThreadsCPUView.this.lrRefreshButton.isEnabled()) {
                    ThreadsCPUView.this.popupPause = true;
                    ThreadsCPUView.this.lrPauseButton.setSelected(true);
                }
            }

            protected void popupHidden() {
                if (ThreadsCPUView.this.lrPauseButton.isEnabled() && ThreadsCPUView.this.popupPause) {
                    ThreadsCPUView.this.popupPause = false;
                    ThreadsCPUView.this.lrPauseButton.setSelected(false);
                }
            }
        };
        this.table.setColumnToolTips(new String[]{NbBundle.getMessage(ThreadsCPUView.class, (String)"ThreadsCPUView_TOOLTIP_Col_name"), NbBundle.getMessage(ThreadsCPUView.class, (String)"ThreadsCPUView_TOOLTIP_Col_time"), NbBundle.getMessage(ThreadsCPUView.class, (String)"ThreadsCPUView_TOOLTIP_Col_timesec")});
        this.table.providePopupMenu(true);
        this.table.setMainColumn(0);
        this.table.setFitWidthColumn(0);
        this.table.setSortColumn(1);
        this.table.setDefaultSortOrder(1, SortOrder.DESCENDING);
        this.renderers = new HideableBarRenderer[2];
        this.renderers[0] = new HideableBarRenderer((ProfilerRenderer)new NumberPercentRenderer((ProfilerRenderer)new McsTimeRenderer()));
        this.renderers[0].setBarDiffMode(HideableBarRenderer.BarDiffMode.MODE_BAR_NORMAL);
        this.renderers[1] = new HideableBarRenderer((ProfilerRenderer)new NumberPercentRenderer((ProfilerRenderer)new McsTimeRenderer()));
        this.renderers[1].setBarDiffMode(HideableBarRenderer.BarDiffMode.MODE_BAR_NORMAL);
        LabelRenderer threadRenderer = new LabelRenderer();
        threadRenderer.setIcon(Icons.getIcon((String)"ProfilerIcons.Thread"));
        threadRenderer.setFont(threadRenderer.getFont().deriveFont(1));
        this.table.setColumnRenderer(0, (ProfilerRenderer)threadRenderer);
        this.table.setColumnRenderer(1, (ProfilerRenderer)this.renderers[0]);
        this.table.setColumnRenderer(2, (ProfilerRenderer)this.renderers[1]);
        long refTime = 12345678L;
        this.renderers[0].setMaxValue(refTime);
        this.renderers[1].setMaxValue(refTime);
        this.table.setDefaultColumnWidth(1, this.renderers[0].getOptimalWidth());
        this.table.setDefaultColumnWidth(2, this.renderers[1].getOptimalWidth());
        this.renderers[1].setMaxValue(1000000L);
        ProfilerTableContainer tableContainer = new ProfilerTableContainer(this.table, false, null);
        this.lrLabel = new GrayLabel(Bundle.MethodsFeatureUI_liveResults());
        this.lrPauseButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Pause")){

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                boolean paused = this.isSelected();
                ThreadsCPUView.this.lrRefreshButton.setEnabled(paused && !ThreadsCPUView.this.popupPause);
                if (!paused) {
                    ThreadsCPUView.this.refresher.refresh();
                }
            }
        };
        this.lrPauseButton.setToolTipText(NbBundle.getMessage(CPUView.class, (String)"TOOLTIP_Pause_results"));
        this.lrRefreshButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ThreadsCPUView.this.forceRefresh = true;
                ThreadsCPUView.this.refresher.refresh();
            }
        };
        this.lrRefreshButton.setToolTipText(NbBundle.getMessage(CPUView.class, (String)"TOOLTIP_Update_results"));
        this.lrRefreshButton.setEnabled(false);
        Icon icon = Icons.getIcon((String)"ProfilerIcons.DeltaResults");
        this.lrDeltasButton = new JToggleButton(icon){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                if (!ThreadsCPUView.this.lrPauseButton.isSelected()) {
                    ThreadsCPUView.this.forceRefresh = true;
                    ThreadsCPUView.this.refresher.refresh();
                }
            }
        };
        this.lrDeltasButton.setToolTipText(NbBundle.getMessage(CPUView.class, (String)"TOOLTIP_Deltas"));
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.lrPauseButton);
        this.toolbar.add((Component)this.lrRefreshButton);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrDeltasButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(NbBundle.getMessage(ThreadsCPUView.class, (String)"ThreadsCPUView_LBL_Statistics")));
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new JLabel(NbBundle.getMessage(ThreadsCPUView.class, (String)"ThreadsCPUView_LBL_TCount")));
        final Dimension tcDim = new Dimension(-1, -1);
        final JLabel threadsCountL = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (tcDim.width >= 0) {
                    dim.width = Math.max(dim.width, tcDim.width);
                    dim.height = Math.max(dim.height, tcDim.height);
                }
                return dim;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.threadsCount = new NumberRenderer(){

            public void setText(String text) {
                super.setText(text);
                threadsCountL.setText(super.getText());
            }
        };
        this.threadsCount.setDiffMode(true);
        this.threadsCount.setValue((Object)99, -1);
        tcDim.setSize(threadsCountL.getPreferredSize());
        this.threadsCount.setDiffMode(false);
        this.threadsCount.setValue((Object)0, -1);
        this.toolbar.addSpace(3);
        this.toolbar.add((Component)threadsCountL);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new JLabel(NbBundle.getMessage(ThreadsCPUView.class, (String)"ThreadsCPUView_LBL_Total_time")));
        final JLabel threadsTotalTimeL = new JLabel();
        this.threadsTotalTime = new McsTimeRenderer(){

            public void setText(String text) {
                super.setText(text);
                threadsTotalTimeL.setText(super.getText());
            }
        };
        this.toolbar.addSpace(3);
        this.toolbar.add((Component)threadsTotalTimeL);
        this.toolbar.addFiller();
        this.threaddumpButton = new JButton(NbBundle.getMessage(CPUView.class, (String)"LBL_Thread_dump")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                ThreadsCPUView.this.threadDumper.takeThreadDump((event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width += 5;
                return dim;
            }
        };
        this.threaddumpButton.setToolTipText(NbBundle.getMessage(CPUView.class, (String)"TOOLTIP_Thread_dump"));
        this.threaddumpButton.setOpaque(false);
        this.threaddumpButton.setEnabled(this.threadDumper != null);
        this.toolbar.add((Component)this.threaddumpButton);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbar.getComponent(), "North");
        this.add((Component)tableContainer, "Center");
    }

    private JComponent getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new FilterFindLayout());
            this.bottomPanel.setOpaque(true);
            this.bottomPanel.setBackground(UIManager.getColor("controlShadow"));
            this.add((Component)this.bottomPanel, "South");
        }
        return this.bottomPanel;
    }

    private void activateFilter() {
        JComponent panel = this.getBottomPanel();
        if (this.filterPanel == null) {
            this.filterPanel = FilterUtils.createFilterPanel((ProfilerTable)this.table, null);
            panel.add(this.filterPanel);
            Container parent = panel.getParent();
            parent.invalidate();
            parent.revalidate();
            parent.repaint();
        }
        panel.setVisible(true);
        this.filterPanel.setVisible(true);
        this.filterPanel.requestFocusInWindow();
    }

    private void activateSearch() {
        JComponent panel = this.getBottomPanel();
        if (this.searchPanel == null) {
            this.searchPanel = SearchUtils.createSearchPanel((ProfilerTable)this.table);
            panel.add(this.searchPanel);
            Container parent = panel.getParent();
            parent.invalidate();
            parent.revalidate();
            parent.repaint();
        }
        panel.setVisible(true);
        this.searchPanel.setVisible(true);
        this.searchPanel.requestFocusInWindow();
    }

    private final class FilterFindLayout
    implements LayoutManager {
        private FilterFindLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JComponent search;
            JComponent filter = ThreadsCPUView.this.filterPanel;
            if (filter != null && !filter.isVisible()) {
                filter = null;
            }
            if ((search = ThreadsCPUView.this.searchPanel) != null && !search.isVisible()) {
                search = null;
            }
            Dimension dim = new Dimension();
            if (filter != null && search != null) {
                Dimension dim1 = filter.getPreferredSize();
                Dimension dim2 = search.getPreferredSize();
                dim.width = dim1.width + dim2.width + 1;
                dim.height = Math.max(dim1.height, dim2.height);
            } else if (filter != null) {
                dim = filter.getPreferredSize();
            } else if (search != null) {
                dim = search.getPreferredSize();
            }
            if (filter != null || search != null) {
                ++dim.height;
            }
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JComponent search;
            JComponent filter = ThreadsCPUView.this.filterPanel;
            if (filter != null && !filter.isVisible()) {
                filter = null;
            }
            if ((search = ThreadsCPUView.this.searchPanel) != null && !search.isVisible()) {
                search = null;
            }
            Dimension dim = new Dimension();
            if (filter != null && search != null) {
                Dimension dim1 = filter.getMinimumSize();
                Dimension dim2 = search.getMinimumSize();
                dim.width = dim1.width + dim2.width + 1;
                dim.height = Math.max(dim1.height, dim2.height);
            } else if (filter != null) {
                dim = filter.getMinimumSize();
            } else if (search != null) {
                dim = search.getMinimumSize();
            }
            if (filter != null || search != null) {
                ++dim.height;
            }
            return dim;
        }

        @Override
        public void layoutContainer(Container parent) {
            JComponent search;
            JComponent filter = ThreadsCPUView.this.filterPanel;
            if (filter != null && !filter.isVisible()) {
                filter = null;
            }
            if ((search = ThreadsCPUView.this.searchPanel) != null && !search.isVisible()) {
                search = null;
            }
            int bottomOffset = 0;
            if (filter != null && search != null) {
                Dimension size = parent.getSize();
                int w = (size.width - 1) / 2;
                filter.setBounds(0, 0, w, size.height - bottomOffset);
                search.setBounds(w + 1, 0, size.width - w - 1, size.height - bottomOffset);
            } else if (filter != null) {
                Dimension size = parent.getSize();
                filter.setBounds(0, 0, size.width, size.height - bottomOffset);
            } else if (search != null) {
                Dimension size = parent.getSize();
                search.setBounds(0, 0, size.width, size.height - bottomOffset);
            }
        }
    }

    private class TreadsCPUTableModel
    extends AbstractTableModel {
        private TreadsCPUTableModel() {
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return COL_NAME;
            }
            if (columnIndex == 1) {
                return COL_BYTES;
            }
            if (columnIndex == 2) {
                return COL_BYTES_SEC;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return Long.class;
        }

        @Override
        public int getRowCount() {
            return ThreadsCPUView.this.threads.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ((ThreadInfo)ThreadsCPUView.this.threads.get(rowIndex)).getThreadName();
            }
            if (columnIndex == 1) {
                long threadCPUtime = (Long)ThreadsCPUView.this.threadCPUInfo.get(rowIndex);
                return (double)threadCPUtime / 1000.0;
            }
            if (columnIndex == 2) {
                return ThreadsCPUView.this.threadCPUInfoPerSec.isEmpty() ? 0.0 : Math.min((double)((Long)ThreadsCPUView.this.threadCPUInfoPerSec.get(rowIndex)).longValue() / 1000.0, 1000000.0);
            }
            return null;
        }
    }
}

