/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import net.miginfocom.swing.MigLayout;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.DataLaboratoryHelper;
import org.gephi.datalab.plugin.manipulators.general.MergeNodeDuplicates;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategy;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Node;
import org.gephi.ui.components.richtooltip.RichTooltip;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class MergeNodeDuplicatesUI
extends JPanel
implements ManipulatorUI {
    private static final ImageIcon CONFIG_BUTTONS_ICON = ImageUtilities.loadImageIcon((String)"org/gephi/datalab/plugin/manipulators/resources/gear.png", (boolean)true);
    private static final ImageIcon INFO_LABELS_ICON = ImageUtilities.loadImageIcon((String)"org/gephi/datalab/plugin/manipulators/resources/information.png", (boolean)true);
    private MergeNodeDuplicates manipulator;
    private DialogControls dialogControls;
    private Column[] columns;
    private List<List<Node>> duplicateGroups;
    private JCheckBox deleteMergedNodesCheckBox;
    private JCheckBox caseSensitiveCheckBox;
    private JComboBox baseColumnComboBox;
    private Element[] rows;
    private StrategyComboBox[] strategiesComboBoxes;
    private StrategyConfigurationButton[] strategiesConfigurationButtons;
    private JScrollPane scroll;
    private JScrollPane scrollStrategies;

    public MergeNodeDuplicatesUI() {
        this.initComponents();
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
        this.manipulator = (MergeNodeDuplicates)m;
        this.dialogControls = dialogControls;
        this.columns = this.manipulator.getColumns();
        this.loadSettings();
    }

    public void unSetup() {
        this.manipulator.setDeleteMergedNodes(this.deleteMergedNodesCheckBox.isSelected());
        this.manipulator.setCaseSensitive(this.caseSensitiveCheckBox.isSelected());
        if (this.duplicateGroups != null && this.duplicateGroups.size() > 0) {
            AttributeRowsMergeStrategy[] chosenStrategies = new AttributeRowsMergeStrategy[this.strategiesComboBoxes.length];
            for (int i = 0; i < this.strategiesComboBoxes.length; ++i) {
                chosenStrategies[i] = this.strategiesComboBoxes[i].getSelectedItem() != null ? ((StrategyWrapper)this.strategiesComboBoxes[i].getSelectedItem()).getStrategy() : null;
            }
            this.manipulator.setMergeStrategies(chosenStrategies);
            this.manipulator.setDuplicateGroups(this.duplicateGroups);
        }
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        return this;
    }

    public boolean isModal() {
        return true;
    }

    private void calculateDuplicates() {
        if (this.baseColumnComboBox.getSelectedIndex() != -1) {
            this.duplicateGroups = ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).detectNodeDuplicatesByColumn(this.columns[this.baseColumnComboBox.getSelectedIndex()], this.caseSensitiveCheckBox.isSelected());
        }
    }

    public void loadSettings() {
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout((LayoutManager)new MigLayout("fillx"));
        this.loadDescription(settingsPanel);
        this.loadBaseColumn(settingsPanel);
        this.loadDeleteMergedNodesCheckBox(settingsPanel);
        this.scroll.setViewportView(settingsPanel);
        this.refreshDuplicatesAndStrategies();
    }

    private void refreshDuplicatesAndStrategies() {
        this.calculateDuplicates();
        this.loadColumnsStrategies();
    }

    private void loadColumnsStrategies() {
        JPanel strategiesPanel = new JPanel();
        strategiesPanel.setLayout((LayoutManager)new MigLayout("fillx"));
        if (this.duplicateGroups != null && this.duplicateGroups.size() > 0) {
            int i;
            strategiesPanel.add((Component)new JLabel(NbBundle.getMessage(MergeNodeDuplicatesUI.class, (String)"MergeNodeDuplicatesUI.duplicateGroupsNumber", (Object)this.duplicateGroups.size())), "wrap 15px");
            List<Node> nodes = this.duplicateGroups.get(0);
            this.rows = new Element[nodes.size()];
            for (i = 0; i < nodes.size(); ++i) {
                this.rows[i] = (Element)nodes.get(i);
            }
            this.strategiesConfigurationButtons = new StrategyConfigurationButton[this.columns.length];
            this.strategiesComboBoxes = new StrategyComboBox[this.columns.length];
            for (i = 0; i < this.columns.length; ++i) {
                StrategyComboBox strategyComboBox;
                StrategyInfoLabel infoLabel = new StrategyInfoLabel(i);
                this.strategiesConfigurationButtons[i] = new StrategyConfigurationButton(i);
                this.strategiesComboBoxes[i] = strategyComboBox = new StrategyComboBox(this.strategiesConfigurationButtons[i], infoLabel);
                for (AttributeRowsMergeStrategy strategy : this.getColumnAvailableStrategies(this.columns[i])) {
                    strategyComboBox.addItem(new StrategyWrapper(strategy));
                }
                strategyComboBox.refresh();
                strategiesPanel.add((Component)new JLabel(this.columns[i].getTitle() + ": "), "wrap");
                strategiesPanel.add((Component)infoLabel, "split 3");
                strategiesPanel.add(this.strategiesConfigurationButtons[i]);
                strategiesPanel.add((Component)strategyComboBox, "growx, wrap 15px");
            }
            this.dialogControls.setOkButtonEnabled(true);
        } else {
            strategiesPanel.add(new JLabel(this.getMessage("MergeNodeDuplicatesUI.noDuplicatesText")));
            this.dialogControls.setOkButtonEnabled(false);
        }
        this.scrollStrategies.setViewportView(strategiesPanel);
    }

    private List<AttributeRowsMergeStrategy> getColumnAvailableStrategies(Column column) {
        ArrayList<AttributeRowsMergeStrategy> availableStrategies = new ArrayList<AttributeRowsMergeStrategy>();
        for (AttributeRowsMergeStrategy strategy : DataLaboratoryHelper.getDefault().getAttributeRowsMergeStrategies()) {
            strategy.setup(this.rows, this.rows[0], column);
            if (!strategy.canExecute()) continue;
            availableStrategies.add(strategy);
        }
        return availableStrategies;
    }

    private void loadDescription(JPanel settingsPanel) {
        JLabel descriptionLabel = new JLabel();
        descriptionLabel.setText(this.getMessage("MergeNodeDuplicatesUI.description"));
        settingsPanel.add((Component)descriptionLabel, "wrap 25px");
    }

    private void loadBaseColumn(JPanel settingsPanel) {
        this.baseColumnComboBox = new JComboBox();
        for (Column column : this.columns) {
            this.baseColumnComboBox.addItem(column.getTitle());
        }
        settingsPanel.add((Component)new JLabel(this.getMessage("MergeNodeDuplicatesUI.baseColumnText")), "split 2");
        settingsPanel.add((Component)this.baseColumnComboBox, "growx, wrap");
        this.caseSensitiveCheckBox = new JCheckBox(this.getMessage("MergeNodeDuplicatesUI.caseSensitiveText"), this.manipulator.isCaseSensitive());
        settingsPanel.add((Component)this.caseSensitiveCheckBox, "wrap");
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeNodeDuplicatesUI.this.refreshDuplicatesAndStrategies();
            }
        };
        this.baseColumnComboBox.addActionListener(listener);
        this.caseSensitiveCheckBox.addActionListener(listener);
    }

    private void loadDeleteMergedNodesCheckBox(JPanel settingsPanel) {
        this.deleteMergedNodesCheckBox = new JCheckBox(this.getMessage("MergeNodeDuplicatesUI.deleteMergedNodesText"), this.manipulator.isDeleteMergedNodes());
        settingsPanel.add((Component)this.deleteMergedNodesCheckBox, "wrap");
    }

    private String getMessage(String resName) {
        return NbBundle.getMessage(MergeNodeDuplicatesUI.class, (String)resName);
    }

    private AttributeRowsMergeStrategy getStrategy(int strategyIndex) {
        StrategyWrapper sw;
        if (this.strategiesComboBoxes[strategyIndex] != null && (sw = (StrategyWrapper)this.strategiesComboBoxes[strategyIndex].getSelectedItem()) != null) {
            return sw.getStrategy();
        }
        return null;
    }

    private void initComponents() {
        this.scrollStrategies = new JScrollPane();
        this.scroll = new JScrollPane();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollStrategies, -1, 782, Short.MAX_VALUE).addComponent(this.scroll, -1, 782, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.scroll, -2, 192, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollStrategies, -1, 308, Short.MAX_VALUE)));
    }

    class StrategyWrapper {
        private final AttributeRowsMergeStrategy strategy;

        public StrategyWrapper(AttributeRowsMergeStrategy strategy) {
            this.strategy = strategy;
        }

        public String toString() {
            return this.strategy.getName();
        }

        public AttributeRowsMergeStrategy getStrategy() {
            return this.strategy;
        }
    }

    class StrategyInfoLabel
    extends JLabel {
        private final int strategyIndex;

        public StrategyInfoLabel(int strategyIndex) {
            this.strategyIndex = strategyIndex;
            this.setIcon(INFO_LABELS_ICON);
            this.prepareRichTooltip();
        }

        public void refreshEnabledState() {
            AttributeRowsMergeStrategy strategy = MergeNodeDuplicatesUI.this.getStrategy(this.strategyIndex);
            this.setEnabled(strategy != null && strategy.getDescription() != null && !strategy.getDescription().isEmpty());
        }

        private void prepareRichTooltip() {
            this.addMouseListener(new MouseAdapter(){
                RichTooltip richTooltip;

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (StrategyInfoLabel.this.isEnabled()) {
                        this.richTooltip = this.buildTooltip(MergeNodeDuplicatesUI.this.getStrategy(StrategyInfoLabel.this.strategyIndex));
                    }
                    if (this.richTooltip != null) {
                        this.richTooltip.showTooltip((JComponent)StrategyInfoLabel.this);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (this.richTooltip != null) {
                        this.richTooltip.hideTooltip();
                        this.richTooltip = null;
                    }
                }

                private RichTooltip buildTooltip(AttributeRowsMergeStrategy strategy) {
                    if (strategy.getDescription() != null && !strategy.getDescription().isEmpty()) {
                        RichTooltip tooltip = new RichTooltip(strategy.getName(), strategy.getDescription());
                        if (strategy.getIcon() != null) {
                            tooltip.setMainImage(ImageUtilities.icon2Image((Icon)strategy.getIcon()));
                        }
                        return tooltip;
                    }
                    return null;
                }
            });
        }
    }

    class StrategyComboBox
    extends JComboBox
    implements ActionListener {
        private final StrategyConfigurationButton button;
        private final StrategyInfoLabel infoLabel;

        public StrategyComboBox(StrategyConfigurationButton button, StrategyInfoLabel infoLabel) {
            this.button = button;
            this.infoLabel = infoLabel;
            this.addActionListener(this);
        }

        public void refresh() {
            this.button.refreshEnabledState();
            this.infoLabel.refreshEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.refresh();
        }
    }

    class StrategyConfigurationButton
    extends JButton
    implements ActionListener {
        private final int strategyIndex;

        public StrategyConfigurationButton(int strategyIndex) {
            this.strategyIndex = strategyIndex;
            this.setIcon(CONFIG_BUTTONS_ICON);
            this.setToolTipText(MergeNodeDuplicatesUI.this.getMessage("MergeNodeDuplicatesUI.configurationText"));
            this.addActionListener(this);
        }

        public void refreshEnabledState() {
            AttributeRowsMergeStrategy strategy = MergeNodeDuplicatesUI.this.getStrategy(this.strategyIndex);
            this.setEnabled(strategy != null && strategy.getUI() != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataLaboratoryHelper.getDefault().showAttributeRowsMergeStrategyUIDialog(MergeNodeDuplicatesUI.this.getStrategy(this.strategyIndex));
        }
    }
}

