/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.PrintWriter;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.storeconfig.IStoreConfig;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFileMover;
import org.apache.catalina.storeconfig.StoreRegistry;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class StoreConfig
implements IStoreConfig {
    private static Log log = LogFactory.getLog(StoreConfig.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.storeconfig");
    private String serverFilename = "conf/server.xml";
    private StoreRegistry registry;
    private Server server;

    public String getServerFilename() {
        return this.serverFilename;
    }

    public void setServerFilename(String string) {
        this.serverFilename = string;
    }

    @Override
    public StoreRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setRegistry(StoreRegistry storeRegistry) {
        this.registry = storeRegistry;
    }

    @Override
    public void storeConfig() {
        this.store(this.server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeServer(String string, boolean bl, boolean bl2) throws MalformedObjectNameException {
        block9: {
            ObjectName objectName;
            if (string == null || string.length() == 0) {
                log.error((Object)sm.getString("config.emptyObjectName"));
                return;
            }
            MBeanServer mBeanServer = MBeanUtils.createServer();
            if (mBeanServer.isRegistered(objectName = new ObjectName(string))) {
                try {
                    Server server = (Server)mBeanServer.getAttribute(objectName, "managedResource");
                    StoreDescription storeDescription = null;
                    storeDescription = this.getRegistry().findDescription(StandardContext.class);
                    if (storeDescription != null) {
                        boolean bl3 = storeDescription.isStoreSeparate();
                        boolean bl4 = storeDescription.isBackup();
                        boolean bl5 = storeDescription.isExternalAllowed();
                        try {
                            storeDescription.setStoreSeparate(true);
                            storeDescription.setBackup(bl);
                            storeDescription.setExternalAllowed(bl2);
                            this.store(server);
                            break block9;
                        }
                        finally {
                            storeDescription.setStoreSeparate(bl3);
                            storeDescription.setBackup(bl4);
                            storeDescription.setExternalAllowed(bl5);
                        }
                    }
                    this.store(server);
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("config.storeServerError"), (Throwable)exception);
                }
            } else {
                log.info((Object)sm.getString("config.objectNameNotFound", new Object[]{string}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeContext(String string, boolean bl, boolean bl2) throws MalformedObjectNameException {
        block9: {
            ObjectName objectName;
            if (string == null || string.length() == 0) {
                log.error((Object)sm.getString("config.emptyObjectName"));
                return;
            }
            MBeanServer mBeanServer = MBeanUtils.createServer();
            if (mBeanServer.isRegistered(objectName = new ObjectName(string))) {
                try {
                    Context context = (Context)mBeanServer.getAttribute(objectName, "managedResource");
                    URL uRL = context.getConfigFile();
                    if (uRL != null) {
                        StoreDescription storeDescription = null;
                        storeDescription = this.getRegistry().findDescription(context.getClass());
                        if (storeDescription == null) break block9;
                        boolean bl3 = storeDescription.isStoreSeparate();
                        boolean bl4 = storeDescription.isBackup();
                        boolean bl5 = storeDescription.isExternalAllowed();
                        try {
                            storeDescription.setStoreSeparate(true);
                            storeDescription.setBackup(bl);
                            storeDescription.setExternalAllowed(bl2);
                            storeDescription.getStoreFactory().store(null, -2, context);
                            break block9;
                        }
                        finally {
                            storeDescription.setStoreSeparate(bl3);
                            storeDescription.setBackup(bl4);
                            storeDescription.setBackup(bl5);
                        }
                    }
                    log.error((Object)sm.getString("config.missingContextFile", new Object[]{context.getPath()}));
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("config.storeContextError", new Object[]{string}), (Throwable)exception);
                }
            } else {
                log.info((Object)sm.getString("config.objectNameNotFound", new Object[]{string}));
            }
        }
    }

    @Override
    public synchronized boolean store(Server server) {
        StoreFileMover storeFileMover = new StoreFileMover(Bootstrap.getCatalinaBase(), this.getServerFilename(), this.getRegistry().getEncoding());
        try {
            try (PrintWriter printWriter = storeFileMover.getWriter();){
                this.store(printWriter, -2, server);
            }
            storeFileMover.move();
            return true;
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("config.storeServerError"), (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean store(Context context) {
        try {
            StoreDescription storeDescription = null;
            storeDescription = this.getRegistry().findDescription(context.getClass());
            if (storeDescription != null) {
                boolean bl = storeDescription.isStoreSeparate();
                try {
                    storeDescription.setStoreSeparate(true);
                    storeDescription.getStoreFactory().store(null, -2, context);
                }
                finally {
                    storeDescription.setStoreSeparate(bl);
                }
            }
            return true;
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("config.storeContextError", new Object[]{context.getName()}), (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(PrintWriter printWriter, int n, Context context) throws Exception {
        boolean bl = true;
        StoreDescription storeDescription = null;
        try {
            storeDescription = this.getRegistry().findDescription(context.getClass());
            bl = storeDescription.isStoreSeparate();
            storeDescription.setStoreSeparate(false);
            storeDescription.getStoreFactory().store(printWriter, n, context);
        }
        finally {
            if (storeDescription != null) {
                storeDescription.setStoreSeparate(bl);
            }
        }
    }

    @Override
    public void store(PrintWriter printWriter, int n, Host host) throws Exception {
        StoreDescription storeDescription = this.getRegistry().findDescription(host.getClass());
        storeDescription.getStoreFactory().store(printWriter, n, host);
    }

    @Override
    public void store(PrintWriter printWriter, int n, Service service) throws Exception {
        StoreDescription storeDescription = this.getRegistry().findDescription(service.getClass());
        storeDescription.getStoreFactory().store(printWriter, n, service);
    }

    @Override
    public void store(PrintWriter printWriter, int n, Server server) throws Exception {
        StoreDescription storeDescription = this.getRegistry().findDescription(server.getClass());
        storeDescription.getStoreFactory().store(printWriter, n, server);
    }
}

