/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSName;

public class JNDIRealm
extends RealmBase {
    protected String authentication = null;
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    protected String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    protected String derefAliases = null;
    public static final String DEREF_ALIASES = "java.naming.ldap.derefAliases";
    protected String protocol = null;
    protected boolean adCompat = false;
    protected String referrals = null;
    protected String userBase = "";
    protected String userSearch = null;
    private boolean userSearchAsUser = false;
    protected boolean userSubtree = false;
    protected String userPassword = null;
    protected String userRoleAttribute = null;
    protected String[] userPatternArray = null;
    protected String userPattern = null;
    protected String roleBase = "";
    protected String userRoleName = null;
    protected String roleName = null;
    protected String roleSearch = null;
    protected boolean roleSubtree = false;
    protected boolean roleNested = false;
    protected boolean roleSearchAsUser = false;
    protected String alternateURL;
    protected int connectionAttempt = 0;
    protected String commonRole = null;
    protected String connectionTimeout = "5000";
    protected String readTimeout = "5000";
    protected long sizeLimit = 0L;
    protected int timeLimit = 0;
    protected boolean useDelegatedCredential = true;
    protected String spnegoDelegationQop = "auth-conf";
    private boolean useStartTls = false;
    private StartTlsResponse tls = null;
    private String[] cipherSuitesArray = null;
    private HostnameVerifier hostnameVerifier = null;
    private SSLSocketFactory sslSocketFactory = null;
    private String sslSocketFactoryClassName;
    private String cipherSuites;
    private String hostNameVerifierClassName;
    private String sslProtocol;
    private boolean forceDnHexEscape = false;
    protected JNDIConnection singleConnection = new JNDIConnection();
    protected final Lock singleConnectionLock = new ReentrantLock();
    protected SynchronizedStack<JNDIConnection> connectionPool = null;
    protected int connectionPoolSize = 1;
    protected boolean useContextClassLoader = true;

    public boolean getForceDnHexEscape() {
        return this.forceDnHexEscape;
    }

    public void setForceDnHexEscape(boolean bl) {
        this.forceDnHexEscape = bl;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String string) {
        this.authentication = string;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String string) {
        this.connectionPassword = string;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String string) {
        this.connectionURL = string;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String string) {
        this.contextFactory = string;
    }

    public String getDerefAliases() {
        return this.derefAliases;
    }

    public void setDerefAliases(String string) {
        this.derefAliases = string;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public boolean getAdCompat() {
        return this.adCompat;
    }

    public void setAdCompat(boolean bl) {
        this.adCompat = bl;
    }

    public String getReferrals() {
        return this.referrals;
    }

    public void setReferrals(String string) {
        this.referrals = string;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public void setUserBase(String string) {
        this.userBase = string;
    }

    public String getUserSearch() {
        return this.userSearch;
    }

    public void setUserSearch(String string) {
        this.userSearch = string;
        this.singleConnection = this.create();
    }

    public boolean isUserSearchAsUser() {
        return this.userSearchAsUser;
    }

    public void setUserSearchAsUser(boolean bl) {
        this.userSearchAsUser = bl;
    }

    public boolean getUserSubtree() {
        return this.userSubtree;
    }

    public void setUserSubtree(boolean bl) {
        this.userSubtree = bl;
    }

    public String getUserRoleName() {
        return this.userRoleName;
    }

    public void setUserRoleName(String string) {
        this.userRoleName = string;
    }

    public String getRoleBase() {
        return this.roleBase;
    }

    public void setRoleBase(String string) {
        this.roleBase = string;
        this.singleConnection = this.create();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String string) {
        this.roleName = string;
    }

    public String getRoleSearch() {
        return this.roleSearch;
    }

    public void setRoleSearch(String string) {
        this.roleSearch = string;
        this.singleConnection = this.create();
    }

    public boolean isRoleSearchAsUser() {
        return this.roleSearchAsUser;
    }

    public void setRoleSearchAsUser(boolean bl) {
        this.roleSearchAsUser = bl;
    }

    public boolean getRoleSubtree() {
        return this.roleSubtree;
    }

    public void setRoleSubtree(boolean bl) {
        this.roleSubtree = bl;
    }

    public boolean getRoleNested() {
        return this.roleNested;
    }

    public void setRoleNested(boolean bl) {
        this.roleNested = bl;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String string) {
        this.userPassword = string;
    }

    public String getUserRoleAttribute() {
        return this.userRoleAttribute;
    }

    public void setUserRoleAttribute(String string) {
        this.userRoleAttribute = string;
    }

    public String getUserPattern() {
        return this.userPattern;
    }

    public void setUserPattern(String string) {
        this.userPattern = string;
        if (string == null) {
            this.userPatternArray = null;
        } else {
            this.userPatternArray = this.parseUserPatternString(string);
            this.singleConnection = this.create();
        }
    }

    public String getAlternateURL() {
        return this.alternateURL;
    }

    public void setAlternateURL(String string) {
        this.alternateURL = string;
    }

    public String getCommonRole() {
        return this.commonRole;
    }

    public void setCommonRole(String string) {
        this.commonRole = string;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String string) {
        this.connectionTimeout = string;
    }

    public String getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(String string) {
        this.readTimeout = string;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(long l) {
        this.sizeLimit = l;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int n) {
        this.timeLimit = n;
    }

    public boolean isUseDelegatedCredential() {
        return this.useDelegatedCredential;
    }

    public void setUseDelegatedCredential(boolean bl) {
        this.useDelegatedCredential = bl;
    }

    public String getSpnegoDelegationQop() {
        return this.spnegoDelegationQop;
    }

    public void setSpnegoDelegationQop(String string) {
        this.spnegoDelegationQop = string;
    }

    public boolean getUseStartTls() {
        return this.useStartTls;
    }

    public void setUseStartTls(boolean bl) {
        this.useStartTls = bl;
    }

    private String[] getCipherSuitesArray() {
        if (this.cipherSuites == null || this.cipherSuitesArray != null) {
            return this.cipherSuitesArray;
        }
        if (this.cipherSuites.trim().isEmpty()) {
            this.containerLog.warn((Object)sm.getString("jndiRealm.emptyCipherSuites"));
            this.cipherSuitesArray = null;
        } else {
            this.cipherSuitesArray = this.cipherSuites.trim().split("\\s*,\\s*");
            this.containerLog.debug((Object)sm.getString("jndiRealm.cipherSuites", new Object[]{Arrays.toString(this.cipherSuitesArray)}));
        }
        return this.cipherSuitesArray;
    }

    public void setCipherSuites(String string) {
        this.cipherSuites = string;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void setConnectionPoolSize(int n) {
        this.connectionPoolSize = n;
    }

    public String getHostnameVerifierClassName() {
        if (this.hostnameVerifier == null) {
            return "";
        }
        return this.hostnameVerifier.getClass().getCanonicalName();
    }

    public void setHostnameVerifierClassName(String string) {
        this.hostNameVerifierClassName = string != null ? string.trim() : null;
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.hostnameVerifier != null) {
            return this.hostnameVerifier;
        }
        if (this.hostNameVerifierClassName == null || this.hostNameVerifierClassName.equals("")) {
            return null;
        }
        try {
            Object object = this.constructInstance(this.hostNameVerifierClassName);
            if (object instanceof HostnameVerifier) {
                this.hostnameVerifier = (HostnameVerifier)object;
                return this.hostnameVerifier;
            }
            throw new IllegalArgumentException(sm.getString("jndiRealm.invalidHostnameVerifier", new Object[]{this.hostNameVerifierClassName}));
        }
        catch (ReflectiveOperationException | SecurityException exception) {
            throw new IllegalArgumentException(sm.getString("jndiRealm.invalidHostnameVerifier", new Object[]{this.hostNameVerifierClassName}), exception);
        }
    }

    public void setSslSocketFactoryClassName(String string) {
        this.sslSocketFactoryClassName = string;
    }

    public void setSslProtocol(String string) {
        this.sslProtocol = string;
    }

    private String[] getSupportedSslProtocols() {
        try {
            SSLContext sSLContext = SSLContext.getDefault();
            return sSLContext.getSupportedSSLParameters().getProtocols();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(sm.getString("jndiRealm.exception"), noSuchAlgorithmException);
        }
    }

    private Object constructInstance(String string) throws ReflectiveOperationException {
        Class<?> clazz = Class.forName(string);
        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void setUseContextClassLoader(boolean bl) {
        this.useContextClassLoader = bl;
    }

    public boolean isUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String string, String string2) {
        ClassLoader classLoader = null;
        JNDIConnection jNDIConnection = null;
        Principal principal = null;
        try {
            if (!this.isUseContextClassLoader()) {
                classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            jNDIConnection = this.get();
            try {
                principal = this.authenticate(jNDIConnection, string, string2);
            }
            catch (NullPointerException | NamingException exception) {
                this.containerLog.info((Object)sm.getString("jndiRealm.exception.retry"), (Throwable)exception);
                this.close(jNDIConnection);
                this.closePooledConnections();
                jNDIConnection = this.get();
                principal = this.authenticate(jNDIConnection, string, string2);
            }
            this.release(jNDIConnection);
            Principal principal2 = principal;
            return principal2;
        }
        catch (NamingException namingException) {
            this.containerLog.error((Object)sm.getString("jndiRealm.exception"), (Throwable)namingException);
            this.close(jNDIConnection);
            this.closePooledConnections();
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"Returning null principal.");
            }
            Principal principal3 = null;
            return principal3;
        }
        finally {
            if (!this.isUseContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(JNDIConnection jNDIConnection, String string, String string2) throws NamingException {
        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"username null or empty: returning null principal.");
            }
            return null;
        }
        ClassLoader classLoader = null;
        try {
            if (!this.isUseContextClassLoader()) {
                classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            if (this.userPatternArray != null) {
                for (int i = 0; i < this.userPatternArray.length; ++i) {
                    User user = this.getUser(jNDIConnection, string, string2, i);
                    if (user == null) continue;
                    try {
                        if (!this.checkCredentials(jNDIConnection.context, user, string2)) continue;
                        List<String> list = this.getRoles(jNDIConnection, user);
                        if (this.containerLog.isDebugEnabled()) {
                            this.containerLog.debug((Object)("Found roles: " + list.toString()));
                        }
                        GenericPrincipal genericPrincipal = new GenericPrincipal(string, list);
                        return genericPrincipal;
                    }
                    catch (InvalidNameException invalidNameException) {
                        this.containerLog.warn((Object)sm.getString("jndiRealm.exception"), (Throwable)invalidNameException);
                    }
                }
                Principal principal = null;
                return principal;
            }
            User user = this.getUser(jNDIConnection, string, string2);
            if (user == null) {
                Principal principal = null;
                return principal;
            }
            if (!this.checkCredentials(jNDIConnection.context, user, string2)) {
                Principal principal = null;
                return principal;
            }
            List<String> list = this.getRoles(jNDIConnection, user);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("Found roles: " + list.toString()));
            }
            GenericPrincipal genericPrincipal = new GenericPrincipal(string, list);
            return genericPrincipal;
        }
        finally {
            if (!this.isUseContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String string) {
        ClassLoader classLoader = null;
        try {
            if (!this.isUseContextClassLoader()) {
                classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            Principal principal = super.authenticate(string);
            return principal;
        }
        finally {
            if (!this.isUseContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        ClassLoader classLoader = null;
        try {
            if (!this.isUseContextClassLoader()) {
                classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            Principal principal = super.authenticate(string, string2, string3, string4, string5, string6, string7, string8);
            return principal;
        }
        finally {
            if (!this.isUseContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(X509Certificate[] x509CertificateArray) {
        ClassLoader classLoader = null;
        try {
            if (!this.isUseContextClassLoader()) {
                classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            Principal principal = super.authenticate(x509CertificateArray);
            return principal;
        }
        finally {
            if (!this.isUseContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(GSSContext gSSContext, boolean bl) {
        ClassLoader classLoader = null;
        try {
            if (!this.isUseContextClassLoader()) {
                classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            Principal principal = super.authenticate(gSSContext, bl);
            return principal;
        }
        finally {
            if (!this.isUseContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(GSSName gSSName, GSSCredential gSSCredential) {
        ClassLoader classLoader = null;
        try {
            if (!this.isUseContextClassLoader()) {
                classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            Principal principal = super.authenticate(gSSName, gSSCredential);
            return principal;
        }
        finally {
            if (!this.isUseContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    protected User getUser(JNDIConnection jNDIConnection, String string) throws NamingException {
        return this.getUser(jNDIConnection, string, null, -1);
    }

    protected User getUser(JNDIConnection jNDIConnection, String string, String string2) throws NamingException {
        return this.getUser(jNDIConnection, string, string2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User getUser(JNDIConnection jNDIConnection, String string, String string2, int n) throws NamingException {
        User user = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.userPassword != null) {
            arrayList.add(this.userPassword);
        }
        if (this.userRoleName != null) {
            arrayList.add(this.userRoleName);
        }
        if (this.userRoleAttribute != null) {
            arrayList.add(this.userRoleAttribute);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        if (this.userPatternArray != null && n >= 0) {
            user = this.getUserByPattern(jNDIConnection, string, string2, stringArray, n);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("Found user by pattern [" + user + "]"));
            }
        } else {
            boolean bl = this.isUserSearchAsUser();
            try {
                if (bl) {
                    this.userCredentialsAdd(jNDIConnection.context, string, string2);
                }
                user = this.getUserBySearch(jNDIConnection, string, stringArray);
            }
            finally {
                if (bl) {
                    this.userCredentialsRemove(jNDIConnection.context);
                }
            }
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("Found user by search [" + user + "]"));
            }
        }
        if (this.userPassword == null && string2 != null && user != null) {
            return new User(user.getUserName(), user.getDN(), string2, user.getRoles(), user.getUserRoleId());
        }
        return user;
    }

    protected User getUserByPattern(DirContext dirContext, String string, String[] stringArray, String string2) throws NamingException {
        if (stringArray == null || stringArray.length == 0) {
            return new User(string, string2, null, null, null);
        }
        Attributes attributes = null;
        try {
            attributes = dirContext.getAttributes(string2, stringArray);
        }
        catch (NameNotFoundException nameNotFoundException) {
            return null;
        }
        if (attributes == null) {
            return null;
        }
        String string3 = null;
        if (this.userPassword != null) {
            string3 = this.getAttributeValue(this.userPassword, attributes);
        }
        String string4 = null;
        if (this.userRoleAttribute != null) {
            string4 = this.getAttributeValue(this.userRoleAttribute, attributes);
        }
        ArrayList<String> arrayList = null;
        if (this.userRoleName != null) {
            arrayList = this.addAttributeValues(this.userRoleName, attributes, arrayList);
        }
        return new User(string, string2, string3, arrayList, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User getUserByPattern(JNDIConnection jNDIConnection, String string, String string2, String[] stringArray, int n) throws NamingException {
        User user = null;
        if (string == null || this.userPatternArray[n] == null) {
            return null;
        }
        String string3 = jNDIConnection.userPatternFormatArray[n].format(new String[]{this.doAttributeValueEscaping(string)});
        try {
            user = this.getUserByPattern(jNDIConnection.context, string, stringArray, string3);
        }
        catch (NameNotFoundException nameNotFoundException) {
            return null;
        }
        catch (NamingException namingException) {
            try {
                this.userCredentialsAdd(jNDIConnection.context, string3, string2);
                user = this.getUserByPattern(jNDIConnection.context, string, stringArray, string3);
            }
            finally {
                this.userCredentialsRemove(jNDIConnection.context);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected User getUserBySearch(JNDIConnection jNDIConnection, String string, String[] stringArray) throws NamingException {
        Attributes attributes;
        SearchResult searchResult;
        if (string == null) return null;
        if (jNDIConnection.userSearchFormat == null) {
            return null;
        }
        String string2 = jNDIConnection.userSearchFormat.format(new String[]{this.doFilterEscaping(string)});
        SearchControls searchControls = new SearchControls();
        if (this.userSubtree) {
            searchControls.setSearchScope(2);
        } else {
            searchControls.setSearchScope(1);
        }
        searchControls.setCountLimit(this.sizeLimit);
        searchControls.setTimeLimit(this.timeLimit);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        searchControls.setReturningAttributes(stringArray);
        NamingEnumeration<SearchResult> namingEnumeration = jNDIConnection.context.search(this.userBase, string2, searchControls);
        try {
            if (namingEnumeration == null || !namingEnumeration.hasMore()) {
                User user = null;
                return user;
            }
            searchResult = namingEnumeration.next();
            try {
                if (namingEnumeration.hasMore()) {
                    if (this.containerLog.isInfoEnabled()) {
                        this.containerLog.info((Object)sm.getString("jndiRealm.multipleEntries", new Object[]{string}));
                    }
                    User user = null;
                    return user;
                }
            }
            catch (PartialResultException partialResultException) {
                if (!this.adCompat) {
                    throw partialResultException;
                }
            }
        }
        catch (PartialResultException partialResultException) {
            if (!this.adCompat) {
                throw partialResultException;
            }
            User user = null;
            return user;
        }
        String string3 = this.getDistinguishedName(jNDIConnection.context, this.userBase, searchResult);
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  entry found for " + string + " with dn " + string3));
        }
        if ((attributes = searchResult.getAttributes()) == null) {
            return null;
        }
        String string4 = null;
        if (this.userPassword != null) {
            string4 = this.getAttributeValue(this.userPassword, attributes);
        }
        String string5 = null;
        if (this.userRoleAttribute != null) {
            string5 = this.getAttributeValue(this.userRoleAttribute, attributes);
        }
        ArrayList<String> arrayList = null;
        if (this.userRoleName == null) return new User(string, string3, string4, arrayList, string5);
        arrayList = this.addAttributeValues(this.userRoleName, attributes, arrayList);
        return new User(string, string3, string4, arrayList, string5);
        finally {
            if (namingEnumeration != null) {
                namingEnumeration.close();
            }
        }
    }

    protected boolean checkCredentials(DirContext dirContext, User user, String string) throws NamingException {
        boolean bl = false;
        bl = this.userPassword == null ? this.bindAsUser(dirContext, user, string) : this.compareCredentials(dirContext, user, string);
        if (this.containerLog.isTraceEnabled()) {
            if (bl) {
                this.containerLog.trace((Object)sm.getString("jndiRealm.authenticateSuccess", new Object[]{user.getUserName()}));
            } else {
                this.containerLog.trace((Object)sm.getString("jndiRealm.authenticateFailure", new Object[]{user.getUserName()}));
            }
        }
        return bl;
    }

    protected boolean compareCredentials(DirContext dirContext, User user, String string) throws NamingException {
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)"  validating credentials");
        }
        if (user == null || string == null) {
            return false;
        }
        String string2 = user.getPassword();
        return this.getCredentialHandler().matches(string, string2);
    }

    protected boolean bindAsUser(DirContext dirContext, User user, String string) throws NamingException {
        boolean bl;
        block6: {
            if (string == null || user == null) {
                return false;
            }
            String string2 = user.getDN();
            if (string2 == null) {
                return false;
            }
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)"  validating credentials by binding as the user");
            }
            this.userCredentialsAdd(dirContext, string2, string);
            bl = false;
            try {
                if (this.containerLog.isTraceEnabled()) {
                    this.containerLog.trace((Object)("  binding as " + string2));
                }
                dirContext.getAttributes("", null);
                bl = true;
            }
            catch (AuthenticationException authenticationException) {
                if (!this.containerLog.isTraceEnabled()) break block6;
                this.containerLog.trace((Object)"  bind attempt failed");
            }
        }
        this.userCredentialsRemove(dirContext);
        return bl;
    }

    private void userCredentialsAdd(DirContext dirContext, String string, String string2) throws NamingException {
        dirContext.addToEnvironment("java.naming.security.principal", string);
        dirContext.addToEnvironment("java.naming.security.credentials", string2);
    }

    private void userCredentialsRemove(DirContext dirContext) throws NamingException {
        if (this.connectionName != null) {
            dirContext.addToEnvironment("java.naming.security.principal", this.connectionName);
        } else {
            dirContext.removeFromEnvironment("java.naming.security.principal");
        }
        if (this.connectionPassword != null) {
            dirContext.addToEnvironment("java.naming.security.credentials", this.connectionPassword);
        } else {
            dirContext.removeFromEnvironment("java.naming.security.credentials");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getRoles(JNDIConnection jNDIConnection, User user) throws NamingException {
        Object object;
        Object object2;
        Cloneable cloneable;
        NamingEnumeration<SearchResult> namingEnumeration;
        if (user == null) {
            return null;
        }
        String string = user.getDN();
        String string2 = user.getUserName();
        String string3 = user.getUserRoleId();
        if (string == null || string2 == null) {
            return null;
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  getRoles(" + string + ")"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = user.getRoles();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (this.commonRole != null) {
            arrayList.add(this.commonRole);
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  Found " + arrayList.size() + " user internal roles"));
            this.containerLog.trace((Object)("  Found user internal roles " + ((Object)arrayList).toString()));
        }
        if (jNDIConnection.roleFormat == null || this.roleName == null) {
            return arrayList;
        }
        String string4 = jNDIConnection.roleFormat.format(new String[]{this.doFilterEscaping(string), this.doFilterEscaping(this.doAttributeValueEscaping(string2)), this.doFilterEscaping(this.doAttributeValueEscaping(string3))});
        SearchControls searchControls = new SearchControls();
        if (this.roleSubtree) {
            searchControls.setSearchScope(2);
        } else {
            searchControls.setSearchScope(1);
        }
        searchControls.setReturningAttributes(new String[]{this.roleName});
        String string5 = null;
        if (jNDIConnection.roleBaseFormat != null) {
            namingEnumeration = jNDIConnection.context.getNameParser("");
            cloneable = namingEnumeration.parse(string);
            object2 = new String[cloneable.size()];
            for (int i = 0; i < cloneable.size(); ++i) {
                object2[i] = JNDIRealm.convertToHexEscape(cloneable.get(i));
            }
            string5 = jNDIConnection.roleBaseFormat.format(object2);
        } else {
            string5 = "";
        }
        namingEnumeration = this.searchAsUser(jNDIConnection.context, user, string5, string4, searchControls, this.isRoleSearchAsUser());
        if (namingEnumeration == null) {
            return arrayList;
        }
        cloneable = new HashMap();
        try {
            while (namingEnumeration.hasMore()) {
                object2 = (SearchResult)namingEnumeration.next();
                Attributes attributes = ((SearchResult)object2).getAttributes();
                if (attributes == null) continue;
                object = this.getDistinguishedName(jNDIConnection.context, string5, (SearchResult)object2);
                String object3 = this.getAttributeValue(this.roleName, attributes);
                if (object3 == null || object == null) continue;
                cloneable.put(object, object3);
            }
        }
        catch (PartialResultException partialResultException) {
            if (!this.adCompat) {
                throw partialResultException;
            }
        }
        finally {
            namingEnumeration.close();
        }
        if (this.containerLog.isTraceEnabled()) {
            object2 = cloneable.entrySet();
            this.containerLog.trace((Object)("  Found " + object2.size() + " direct roles"));
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                this.containerLog.trace((Object)("  Found direct role " + (String)object.getKey() + " -> " + (String)object.getValue()));
            }
        }
        if (this.getRoleNested()) {
            object2 = new HashMap(cloneable);
            while (!object2.isEmpty()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (Map.Entry entry : object2.entrySet()) {
                    string4 = jNDIConnection.roleFormat.format(new String[]{this.doFilterEscaping((String)entry.getKey()), this.doFilterEscaping(this.doAttributeValueEscaping((String)entry.getValue())), this.doFilterEscaping(this.doAttributeValueEscaping((String)entry.getValue()))});
                    if (this.containerLog.isTraceEnabled()) {
                        this.containerLog.trace((Object)("Perform a nested group search with base " + this.roleBase + " and filter " + string4));
                    }
                    namingEnumeration = this.searchAsUser(jNDIConnection.context, user, string5, string4, searchControls, this.isRoleSearchAsUser());
                    try {
                        while (namingEnumeration.hasMore()) {
                            SearchResult searchResult = namingEnumeration.next();
                            Attributes attributes = searchResult.getAttributes();
                            if (attributes == null) continue;
                            String string6 = this.getDistinguishedName(jNDIConnection.context, this.roleBase, searchResult);
                            String string7 = this.getAttributeValue(this.roleName, attributes);
                            if (string7 == null || string6 == null || cloneable.keySet().contains(string6)) continue;
                            cloneable.put(string6, string7);
                            hashMap.put(string6, string7);
                            if (!this.containerLog.isTraceEnabled()) continue;
                            this.containerLog.trace((Object)("  Found nested role " + string6 + " -> " + string7));
                        }
                    }
                    catch (PartialResultException partialResultException) {
                        if (this.adCompat) continue;
                        throw partialResultException;
                    }
                    finally {
                        namingEnumeration.close();
                    }
                }
                object2 = hashMap;
            }
        }
        arrayList.addAll(cloneable.values());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamingEnumeration<SearchResult> searchAsUser(DirContext dirContext, User user, String string, String string2, SearchControls searchControls, boolean bl) throws NamingException {
        NamingEnumeration<SearchResult> namingEnumeration;
        try {
            if (bl) {
                this.userCredentialsAdd(dirContext, user.getDN(), user.getPassword());
            }
            namingEnumeration = dirContext.search(string, string2, searchControls);
        }
        finally {
            if (bl) {
                this.userCredentialsRemove(dirContext);
            }
        }
        return namingEnumeration;
    }

    private String getAttributeValue(String string, Attributes attributes) throws NamingException {
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  retrieving attribute " + string));
        }
        if (string == null || attributes == null) {
            return null;
        }
        Attribute attribute = attributes.get(string);
        if (attribute == null) {
            return null;
        }
        Object object = attribute.get();
        if (object == null) {
            return null;
        }
        String string2 = null;
        string2 = object instanceof byte[] ? new String((byte[])object) : object.toString();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> addAttributeValues(String string, Attributes attributes, ArrayList<String> arrayList) throws NamingException {
        Attribute attribute;
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  retrieving values for attribute " + string));
        }
        if (string == null || attributes == null) {
            return arrayList;
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if ((attribute = attributes.get(string)) == null) {
            return arrayList;
        }
        try (NamingEnumeration<?> namingEnumeration = attribute.getAll();){
            while (namingEnumeration.hasMore()) {
                String string2 = (String)namingEnumeration.next();
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    protected void close(JNDIConnection jNDIConnection) {
        if (jNDIConnection == null || jNDIConnection.context == null) {
            if (this.connectionPool == null) {
                this.singleConnectionLock.unlock();
            }
            return;
        }
        if (this.tls != null) {
            try {
                this.tls.close();
            }
            catch (IOException iOException) {
                this.containerLog.error((Object)sm.getString("jndiRealm.tlsClose"), (Throwable)iOException);
            }
        }
        try {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"Closing directory context");
            }
            jNDIConnection.context.close();
        }
        catch (NamingException namingException) {
            this.containerLog.error((Object)sm.getString("jndiRealm.close"), (Throwable)namingException);
        }
        jNDIConnection.context = null;
        if (this.connectionPool == null) {
            this.singleConnectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closePooledConnections() {
        if (this.connectionPool != null) {
            SynchronizedStack<JNDIConnection> synchronizedStack = this.connectionPool;
            synchronized (synchronizedStack) {
                JNDIConnection jNDIConnection = null;
                while ((jNDIConnection = (JNDIConnection)this.connectionPool.pop()) != null) {
                    this.close(jNDIConnection);
                }
            }
        }
    }

    @Override
    protected String getPassword(String string) {
        String string2 = this.getUserPassword();
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        JNDIConnection jNDIConnection = null;
        User user = null;
        try {
            jNDIConnection = this.get();
            try {
                user = this.getUser(jNDIConnection, string, null);
            }
            catch (NullPointerException | NamingException exception) {
                this.containerLog.info((Object)sm.getString("jndiRealm.exception.retry"), (Throwable)exception);
                this.close(jNDIConnection);
                this.closePooledConnections();
                jNDIConnection = this.get();
                user = this.getUser(jNDIConnection, string, null);
            }
            this.release(jNDIConnection);
            if (user == null) {
                return null;
            }
            return user.getPassword();
        }
        catch (NamingException namingException) {
            this.containerLog.error((Object)sm.getString("jndiRealm.exception"), (Throwable)namingException);
            return null;
        }
    }

    @Override
    protected Principal getPrincipal(String string) {
        return this.getPrincipal(string, null);
    }

    @Override
    protected Principal getPrincipal(GSSName gSSName, GSSCredential gSSCredential) {
        int n;
        String string = gSSName.toString();
        if (this.isStripRealmForGss() && (n = string.indexOf(64)) > 0) {
            string = string.substring(0, n);
        }
        return this.getPrincipal(string, gSSCredential);
    }

    protected Principal getPrincipal(String string, GSSCredential gSSCredential) {
        JNDIConnection jNDIConnection = null;
        Principal principal = null;
        try {
            jNDIConnection = this.get();
            try {
                principal = this.getPrincipal(jNDIConnection, string, gSSCredential);
            }
            catch (CommunicationException | ServiceUnavailableException namingException) {
                this.containerLog.info((Object)sm.getString("jndiRealm.exception.retry"), (Throwable)namingException);
                this.close(jNDIConnection);
                this.closePooledConnections();
                jNDIConnection = this.get();
                principal = this.getPrincipal(jNDIConnection, string, gSSCredential);
            }
            this.release(jNDIConnection);
            return principal;
        }
        catch (NamingException namingException) {
            this.containerLog.error((Object)sm.getString("jndiRealm.exception"), (Throwable)namingException);
            this.close(jNDIConnection);
            this.closePooledConnections();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Principal getPrincipal(JNDIConnection jNDIConnection, String string, GSSCredential gSSCredential) throws NamingException {
        User user = null;
        List<String> list = null;
        Hashtable<?, ?> hashtable = null;
        DirContext dirContext = jNDIConnection.context;
        try {
            if (gSSCredential != null && this.isUseDelegatedCredential()) {
                hashtable = dirContext.getEnvironment();
                dirContext.addToEnvironment("java.naming.security.authentication", "GSSAPI");
                dirContext.addToEnvironment("javax.security.sasl.server.authentication", "true");
                dirContext.addToEnvironment("javax.security.sasl.qop", this.spnegoDelegationQop);
            }
            if ((user = this.getUser(jNDIConnection, string)) != null) {
                list = this.getRoles(jNDIConnection, user);
            }
        }
        finally {
            if (gSSCredential != null && this.isUseDelegatedCredential()) {
                this.restoreEnvironmentParameter(dirContext, "java.naming.security.authentication", hashtable);
                this.restoreEnvironmentParameter(dirContext, "javax.security.sasl.server.authentication", hashtable);
                this.restoreEnvironmentParameter(dirContext, "javax.security.sasl.qop", hashtable);
            }
        }
        if (user != null) {
            return new GenericPrincipal(user.getUserName(), list, null, null, gSSCredential);
        }
        return null;
    }

    private void restoreEnvironmentParameter(DirContext dirContext, String string, Hashtable<?, ?> hashtable) {
        try {
            dirContext.removeFromEnvironment(string);
            if (hashtable != null && hashtable.containsKey(string)) {
                dirContext.addToEnvironment(string, hashtable.get(string));
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    protected JNDIConnection get() throws NamingException {
        JNDIConnection jNDIConnection = null;
        if (this.connectionPool != null) {
            jNDIConnection = (JNDIConnection)this.connectionPool.pop();
            if (jNDIConnection == null) {
                jNDIConnection = this.create();
            }
        } else {
            this.singleConnectionLock.lock();
            jNDIConnection = this.singleConnection;
        }
        if (jNDIConnection.context == null) {
            this.open(jNDIConnection);
        }
        return jNDIConnection;
    }

    protected void release(JNDIConnection jNDIConnection) {
        if (this.connectionPool != null) {
            if (!this.connectionPool.push((Object)jNDIConnection)) {
                this.close(jNDIConnection);
            }
        } else {
            this.singleConnectionLock.unlock();
        }
    }

    protected JNDIConnection create() {
        JNDIConnection jNDIConnection = new JNDIConnection();
        if (this.userSearch != null) {
            jNDIConnection.userSearchFormat = new MessageFormat(this.userSearch);
        }
        if (this.userPattern != null) {
            int n = this.userPatternArray.length;
            jNDIConnection.userPatternFormatArray = new MessageFormat[n];
            for (int i = 0; i < n; ++i) {
                jNDIConnection.userPatternFormatArray[i] = new MessageFormat(this.userPatternArray[i]);
            }
        }
        if (this.roleBase != null) {
            jNDIConnection.roleBaseFormat = new MessageFormat(this.roleBase);
        }
        if (this.roleSearch != null) {
            jNDIConnection.roleFormat = new MessageFormat(this.roleSearch);
        }
        return jNDIConnection;
    }

    protected void open(JNDIConnection jNDIConnection) throws NamingException {
        try {
            jNDIConnection.context = this.createDirContext(this.getDirectoryContextEnvironment());
        }
        catch (Exception exception) {
            if (this.alternateURL == null || this.alternateURL.length() == 0) {
                throw exception;
            }
            this.connectionAttempt = 1;
            this.containerLog.info((Object)sm.getString("jndiRealm.exception.retry"), (Throwable)exception);
            jNDIConnection.context = this.createDirContext(this.getDirectoryContextEnvironment());
        }
        finally {
            this.connectionAttempt = 0;
        }
    }

    @Override
    public boolean isAvailable() {
        return this.connectionPool != null || this.singleConnection.context != null;
    }

    private DirContext createDirContext(Hashtable<String, String> hashtable) throws NamingException {
        if (this.useStartTls) {
            return this.createTlsDirContext(hashtable);
        }
        return new InitialDirContext(hashtable);
    }

    private SSLSocketFactory getSSLSocketFactory() {
        if (this.sslSocketFactory != null) {
            return this.sslSocketFactory;
        }
        SSLSocketFactory sSLSocketFactory = this.sslSocketFactoryClassName != null && !this.sslSocketFactoryClassName.trim().equals("") ? this.createSSLSocketFactoryFromClassName(this.sslSocketFactoryClassName) : this.createSSLContextFactoryFromProtocol(this.sslProtocol);
        this.sslSocketFactory = sSLSocketFactory;
        return sSLSocketFactory;
    }

    private SSLSocketFactory createSSLSocketFactoryFromClassName(String string) {
        try {
            Object object = this.constructInstance(string);
            if (object instanceof SSLSocketFactory) {
                return this.sslSocketFactory;
            }
            throw new IllegalArgumentException(sm.getString("jndiRealm.invalidSslSocketFactory", new Object[]{string}));
        }
        catch (ReflectiveOperationException | SecurityException exception) {
            throw new IllegalArgumentException(sm.getString("jndiRealm.invalidSslSocketFactory", new Object[]{string}), exception);
        }
    }

    private SSLSocketFactory createSSLContextFactoryFromProtocol(String string) {
        try {
            SSLContext sSLContext;
            if (string != null) {
                sSLContext = SSLContext.getInstance(string);
                sSLContext.init(null, null, null);
            } else {
                sSLContext = SSLContext.getDefault();
            }
            return sSLContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            List<String> list = Arrays.asList(this.getSupportedSslProtocols());
            throw new IllegalArgumentException(sm.getString("jndiRealm.invalidSslProtocol", new Object[]{string, list}), generalSecurityException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirContext createTlsDirContext(Hashtable<String, String> hashtable) throws NamingException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object3 : Arrays.asList("java.naming.security.authentication", "java.naming.security.credentials", "java.naming.security.principal", "java.naming.security.protocol")) {
            String string = hashtable.remove(object3);
            if (string == null) continue;
            hashMap.put(object3, string);
        }
        Object object = null;
        try {
            object = new InitialLdapContext(hashtable, null);
            this.tls = (StartTlsResponse)object.extendedOperation(new StartTlsRequest());
            if (this.getHostnameVerifier() != null) {
                this.tls.setHostnameVerifier(this.getHostnameVerifier());
            }
            if (this.getCipherSuitesArray() != null) {
                this.tls.setEnabledCipherSuites(this.getCipherSuitesArray());
            }
            try {
                SSLSession iOException = this.tls.negotiate(this.getSSLSocketFactory());
                this.containerLog.debug((Object)sm.getString("jndiRealm.negotiatedTls", new Object[]{iOException.getProtocol()}));
            }
            catch (IOException iOException) {
                throw new NamingException(iOException.getMessage());
            }
        }
        finally {
            if (object != null) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    object.addToEnvironment((String)entry.getKey(), entry.getValue());
                }
            }
        }
        return object;
    }

    protected Hashtable<String, String> getDirectoryContextEnvironment() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.containerLog.isDebugEnabled() && this.connectionAttempt == 0) {
            this.containerLog.debug((Object)("Connecting to URL " + this.connectionURL));
        } else if (this.containerLog.isDebugEnabled() && this.connectionAttempt > 0) {
            this.containerLog.debug((Object)("Connecting to URL " + this.alternateURL));
        }
        hashtable.put("java.naming.factory.initial", this.contextFactory);
        if (this.connectionName != null) {
            hashtable.put("java.naming.security.principal", this.connectionName);
        }
        if (this.connectionPassword != null) {
            hashtable.put("java.naming.security.credentials", this.connectionPassword);
        }
        if (this.connectionURL != null && this.connectionAttempt == 0) {
            hashtable.put("java.naming.provider.url", this.connectionURL);
        } else if (this.alternateURL != null && this.connectionAttempt > 0) {
            hashtable.put("java.naming.provider.url", this.alternateURL);
        }
        if (this.authentication != null) {
            hashtable.put("java.naming.security.authentication", this.authentication);
        }
        if (this.protocol != null) {
            hashtable.put("java.naming.security.protocol", this.protocol);
        }
        if (this.referrals != null) {
            hashtable.put("java.naming.referral", this.referrals);
        }
        if (this.derefAliases != null) {
            hashtable.put(DEREF_ALIASES, this.derefAliases);
        }
        if (this.connectionTimeout != null) {
            hashtable.put("com.sun.jndi.ldap.connect.timeout", this.connectionTimeout);
        }
        if (this.readTimeout != null) {
            hashtable.put("com.sun.jndi.ldap.read.timeout", this.readTimeout);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        if (this.connectionPoolSize != 1) {
            this.connectionPool = new SynchronizedStack(128, this.connectionPoolSize);
        }
        ClassLoader classLoader = null;
        JNDIConnection jNDIConnection = null;
        try {
            if (!this.isUseContextClassLoader()) {
                classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            jNDIConnection = this.get();
            this.release(jNDIConnection);
            if (!this.isUseContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        catch (NamingException namingException) {
            try {
                this.containerLog.error((Object)sm.getString("jndiRealm.open"), (Throwable)namingException);
                this.release(jNDIConnection);
                if (!this.isUseContextClassLoader()) {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            }
            catch (Throwable throwable) {
                this.release(jNDIConnection);
                if (!this.isUseContextClassLoader()) {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                throw throwable;
            }
        }
        super.startInternal();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (this.connectionPool == null) {
            this.singleConnectionLock.lock();
            this.close(this.singleConnection);
        } else {
            this.closePooledConnections();
            this.connectionPool = null;
        }
    }

    protected String[] parseUserPatternString(String string) {
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = string.indexOf(40);
            if (n == -1) {
                return new String[]{string};
            }
            int n2 = 0;
            while (n > -1) {
                int n3 = 0;
                while (string.charAt(n + 1) == '|' || n != 0 && string.charAt(n - 1) == '\\') {
                    n = string.indexOf(40, n + 1);
                }
                n3 = string.indexOf(41, n + 1);
                while (string.charAt(n3 - 1) == '\\') {
                    n3 = string.indexOf(41, n3 + 1);
                }
                String string2 = string.substring(n + 1, n3);
                arrayList.add(string2);
                n2 = n3 + 1;
                n = string.indexOf(40, n2);
            }
            return arrayList.toArray(new String[0]);
        }
        return null;
    }

    @Deprecated
    protected String doRFC2254Encoding(String string) {
        return this.doFilterEscaping(string);
    }

    protected String doFilterEscaping(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuilder.append("\\5c");
                    continue block7;
                }
                case '*': {
                    stringBuilder.append("\\2a");
                    continue block7;
                }
                case '(': {
                    stringBuilder.append("\\28");
                    continue block7;
                }
                case ')': {
                    stringBuilder.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    stringBuilder.append("\\00");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    protected String getDistinguishedName(DirContext dirContext, String string, SearchResult searchResult) throws NamingException {
        Name name;
        String string2 = searchResult.getName();
        if (searchResult.isRelative()) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)("  search returned relative name: " + string2));
            }
            NameParser nameParser = dirContext.getNameParser("");
            Name name2 = nameParser.parse(dirContext.getNameInNamespace());
            Name name3 = nameParser.parse(string);
            Name name4 = nameParser.parse(new CompositeName(string2).get(0));
            name = name2.addAll(name3);
            name = name.addAll(name4);
        } else {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)("  search returned absolute name: " + string2));
            }
            try {
                NameParser nameParser = dirContext.getNameParser("");
                URI uRI = new URI(string2);
                String string3 = uRI.getPath();
                if (string3.length() < 1) {
                    throw new InvalidNameException("Search returned unparseable absolute name: " + string2);
                }
                name = nameParser.parse(string3.substring(1));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new InvalidNameException("Search returned unparseable absolute name: " + string2);
            }
        }
        if (this.getForceDnHexEscape()) {
            return JNDIRealm.convertToHexEscape(name.toString());
        }
        return name.toString();
    }

    protected String doAttributeValueEscaping(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || i == n - 1) {
                        stringBuilder.append("\\20");
                        continue block12;
                    }
                    stringBuilder.append(c);
                    continue block12;
                }
                case '#': {
                    if (i == 0) {
                        stringBuilder.append("\\23");
                        continue block12;
                    }
                    stringBuilder.append(c);
                    continue block12;
                }
                case '\"': {
                    stringBuilder.append("\\22");
                    continue block12;
                }
                case '+': {
                    stringBuilder.append("\\2B");
                    continue block12;
                }
                case ',': {
                    stringBuilder.append("\\2C");
                    continue block12;
                }
                case ';': {
                    stringBuilder.append("\\3B");
                    continue block12;
                }
                case '<': {
                    stringBuilder.append("\\3C");
                    continue block12;
                }
                case '>': {
                    stringBuilder.append("\\3E");
                    continue block12;
                }
                case '\\': {
                    stringBuilder.append("\\5C");
                    continue block12;
                }
                case '\u0000': {
                    stringBuilder.append("\\00");
                    continue block12;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    protected static String convertToHexEscape(String string) {
        if (string.indexOf(92) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 6);
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                switch (c) {
                    case ' ': {
                        stringBuilder.append("\\20");
                        break;
                    }
                    case '\"': {
                        stringBuilder.append("\\22");
                        break;
                    }
                    case '#': {
                        stringBuilder.append("\\23");
                        break;
                    }
                    case '+': {
                        stringBuilder.append("\\2B");
                        break;
                    }
                    case ',': {
                        stringBuilder.append("\\2C");
                        break;
                    }
                    case ';': {
                        stringBuilder.append("\\3B");
                        break;
                    }
                    case '<': {
                        stringBuilder.append("\\3C");
                        break;
                    }
                    case '=': {
                        stringBuilder.append("\\3D");
                        break;
                    }
                    case '>': {
                        stringBuilder.append("\\3E");
                        break;
                    }
                    case '\\': {
                        stringBuilder.append("\\5C");
                        break;
                    }
                    default: {
                        stringBuilder.append('\\');
                        stringBuilder.append(c);
                    }
                }
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        if (bl) {
            stringBuilder.append('\\');
        }
        return stringBuilder.toString();
    }

    protected static class JNDIConnection {
        public MessageFormat userSearchFormat = null;
        public MessageFormat[] userPatternFormatArray = null;
        public MessageFormat roleBaseFormat = null;
        public MessageFormat roleFormat = null;
        public DirContext context = null;

        protected JNDIConnection() {
        }
    }

    protected static class User {
        private final String username;
        private final String dn;
        private final String password;
        private final List<String> roles;
        private final String userRoleId;

        public User(String string, String string2, String string3, List<String> list, String string4) {
            this.username = string;
            this.dn = string2;
            this.password = string3;
            this.roles = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
            this.userRoleId = string4;
        }

        public String getUserName() {
            return this.username;
        }

        public String getDN() {
            return this.dn;
        }

        public String getPassword() {
            return this.password;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public String getUserRoleId() {
            return this.userRoleId;
        }
    }
}

