/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.DataSourceRepository;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.explorer.ExplorerSupport;
import org.graalvm.visualvm.jfr.JFRSnapshotSupport;
import org.graalvm.visualvm.jfr.JFRSnapshotsContainer;
import org.graalvm.visualvm.jfr.impl.JFRSnapshotImpl;
import org.graalvm.visualvm.lib.ui.SwingWorker;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class JFRSnapshotProvider {
    private static final Logger LOGGER = Logger.getLogger(JFRSnapshotProvider.class.getName());
    private static final String SNAPSHOT_VERSION = "snapshot_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "0";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.0";

    static void createJFRSnapshot(final String jfrSnapshotFile, final String displayName, final boolean deleteJFRSnapshot) {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                JFRSnapshotProvider.createJFRSnapshotImpl(jfrSnapshotFile, displayName, deleteJFRSnapshot);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createJFRSnapshotImpl(String jfrSnapshotFile, final String displayName, boolean deleteJFRSnapshot) {
        final JFRSnapshotImpl knownJFRSnapshot = JFRSnapshotProvider.getJFRSnapshotByFile(new File(jfrSnapshotFile));
        if (knownJFRSnapshot != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExplorerSupport.sharedInstance().selectDataSource((DataSource)knownJFRSnapshot);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFRSnapshotProvider.class, (String)"MSG_Core_dump_already_added", (Object[])new Object[]{displayName, DataSourceDescriptorFactory.getDescriptor((DataSource)knownJFRSnapshot).getName()}), 0));
                }
            });
            return;
        }
        if (deleteJFRSnapshot) {
            ProgressHandle pHandleF;
            ProgressHandle pHandle = null;
            try {
                pHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(JFRSnapshotProvider.class, (String)"MSG_Adding", (Object)displayName));
                pHandle.setInitialDelay(0);
                pHandle.start();
                File file = new File(jfrSnapshotFile);
                File copy = Utils.getUniqueFile((File)JFRSnapshotSupport.getStorageDirectory(), (String)file.getName());
                if (Utils.copyFile((File)file, (File)copy)) {
                    jfrSnapshotFile = copy.getAbsolutePath();
                    if (!file.delete()) {
                        file.deleteOnExit();
                    }
                }
                pHandleF = pHandle;
            }
            catch (Throwable throwable) {
                ProgressHandle pHandleF2 = pHandle;
                SwingUtilities.invokeLater(new Runnable(pHandleF2){
                    final /* synthetic */ ProgressHandle val$pHandleF;
                    {
                        this.val$pHandleF = progressHandle;
                    }

                    @Override
                    public void run() {
                        if (this.val$pHandleF != null) {
                            this.val$pHandleF.finish();
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        String[] propNames = new String[]{SNAPSHOT_VERSION, "prop_file", "prop_name"};
        String[] propValues = new String[]{CURRENT_SNAPSHOT_VERSION, jfrSnapshotFile, displayName};
        File customPropertiesStorage = Utils.getUniqueFile((File)JFRSnapshotSupport.getStorageDirectory(), (String)new File(jfrSnapshotFile).getName(), (String)".properties");
        Storage storage = new Storage(customPropertiesStorage.getParentFile(), customPropertiesStorage.getName());
        try {
            JFRSnapshotImpl newJFRSnapshot = new JFRSnapshotImpl(new File(jfrSnapshotFile), storage);
            if (newJFRSnapshot != null) {
                new SnapshotAdder(newJFRSnapshot, storage, propNames, propValues).execute();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error creating JFR snapshot", e);
        }
    }

    private static JFRSnapshotImpl getJFRSnapshotByFile(File file) {
        if (!file.isFile()) {
            return null;
        }
        Set knownJFRSnapshots = DataSourceRepository.sharedInstance().getDataSources(JFRSnapshotImpl.class);
        for (JFRSnapshotImpl knownJFRSnapshot : knownJFRSnapshots) {
            if (!knownJFRSnapshot.getFile().equals(file)) continue;
            return knownJFRSnapshot;
        }
        return null;
    }

    private void initPersistedJFRSnapshots() {
        if (!JFRSnapshotSupport.storageDirectoryExists()) {
            return;
        }
        File[] files = JFRSnapshotSupport.getStorageDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        HashSet<File> unresolvedJFRSnapshotsF = new HashSet<File>();
        HashSet<String> unresolvedJFRSnapshotsS = new HashSet<String>();
        HashSet<JFRSnapshotImpl> snapshots = new HashSet<JFRSnapshotImpl>();
        for (File file : files) {
            Storage storage = new Storage(file.getParentFile(), file.getName());
            String[] propNames = new String[]{"prop_file"};
            String[] propValues = storage.getCustomProperties(propNames);
            if (propValues[0] == null) continue;
            JFRSnapshotImpl persistedSnapshot = null;
            try {
                persistedSnapshot = new JFRSnapshotImpl(new File(propValues[0]), storage);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Error loading persisted JFR snapshot", e);
                unresolvedJFRSnapshotsF.add(file);
                unresolvedJFRSnapshotsS.add(propValues[0]);
            }
            if (persistedSnapshot == null) continue;
            snapshots.add(persistedSnapshot);
        }
        if (!unresolvedJFRSnapshotsF.isEmpty()) {
            JFRSnapshotProvider.notifyUnresolvedJFRSnapshots(unresolvedJFRSnapshotsF, unresolvedJFRSnapshotsS);
        }
        if (!snapshots.isEmpty()) {
            JFRSnapshotsContainer.sharedInstance().getRepository().addDataSources(snapshots);
        }
    }

    private static void notifyUnresolvedJFRSnapshots(final Set<File> unresolvedJFRSnapshotsF, final Set<String> unresolvedJFRSnapshotsS) {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                JPanel messagePanel = new JPanel(new BorderLayout(5, 5));
                messagePanel.add((Component)new JLabel(NbBundle.getMessage(JFRSnapshotProvider.class, (String)"MSG_Unresolved_CoreDumps")), "North");
                JList<Object> list = new JList<Object>(unresolvedJFRSnapshotsS.toArray());
                list.setVisibleRowCount(4);
                messagePanel.add((Component)new JScrollPane(list), "Center");
                NotifyDescriptor dd = new NotifyDescriptor((Object)messagePanel, NbBundle.getMessage(JFRSnapshotProvider.class, (String)"Title_Unresolved_CoreDumps"), 0, 0, null, NotifyDescriptor.YES_OPTION);
                if (DialogDisplayer.getDefault().notify(dd) == NotifyDescriptor.NO_OPTION) {
                    for (File file : unresolvedJFRSnapshotsF) {
                        Utils.delete((File)file, (boolean)true);
                    }
                }
                unresolvedJFRSnapshotsF.clear();
                unresolvedJFRSnapshotsS.clear();
            }
        }, 1000);
    }

    JFRSnapshotProvider() {
    }

    public static void register() {
        final JFRSnapshotProvider provider = new JFRSnapshotProvider();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                VisualVM.getInstance().runTask(new Runnable(){

                    @Override
                    public void run() {
                        provider.initPersistedJFRSnapshots();
                    }
                });
            }
        });
    }

    private static class SnapshotAdder
    extends SwingWorker {
        private volatile ProgressHandle ph = null;
        private volatile boolean success = false;
        private JFRSnapshotImpl newSnapshot;
        private Storage storage;
        private String[] propNames;
        private String[] propValues;

        SnapshotAdder(JFRSnapshotImpl newSnapshot, Storage storage, String[] propNames, String[] propValues) {
            this.newSnapshot = newSnapshot;
            this.storage = storage;
            this.propValues = propValues;
            this.propNames = propNames;
        }

        protected void doInBackground() {
            this.storage.setCustomProperties(this.propNames, this.propValues);
            JFRSnapshotsContainer.sharedInstance().getRepository().addDataSource((DataSource)this.newSnapshot);
            this.success = true;
        }

        protected void nonResponding() {
            this.ph = ProgressHandle.createHandle((String)NbBundle.getMessage(JFRSnapshotProvider.class, (String)"LBL_Inspecting_core_dump"));
            this.ph.start();
        }

        protected void done() {
            if (this.ph != null) {
                this.ph.finish();
            }
            if (!this.success) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFRSnapshotProvider.class, (String)"MSG_not_valid_core_dump", (Object)this.newSnapshot.getFile().getAbsolutePath())));
            }
        }
    }
}

