/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.core.ui.components.SectionSeparator;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.profiling.presets.PresetSelector;
import org.graalvm.visualvm.profiling.presets.SamplerCPUPanel;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public abstract class CPUSettingsSupport {
    private static final String PROP_MODE = "CPUSettingsSupport.Mode";
    private static final String PROP_SPLIT_COMPILED_INLINED = "CPUSettingsSupport.SplitCompiledInlined";
    private JPanel container;
    private SamplerCPUPanel panel;
    private PresetSelector selector;
    private DataViewComponent.DetailsView detailsView;

    public DataViewComponent.DetailsView getDetailsView() {
        if (this.detailsView == null) {
            this.detailsView = new DataViewComponent.DetailsView(NbBundle.getMessage(CPUSettingsSupport.class, (String)"LBL_Cpu_settings"), null, 10, (JComponent)new ScrollableContainer((JComponent)this.createPanel()), null);
        }
        return this.detailsView;
    }

    public ProfilingSettings getSettings() {
        return this.panel.getSettings();
    }

    public int getSamplingRate() {
        return this.panel.getSamplingRate();
    }

    public int getRefreshRate() {
        return this.panel.getRefreshRate();
    }

    public String getMode() {
        return NbPreferences.forModule(CPUSettingsSupport.class).get(PROP_MODE, Mode.EXCLUDE_INLINED_ROOTS.name());
    }

    public boolean isSplitCompiledInlined() {
        return NbPreferences.forModule(CPUSettingsSupport.class).getBoolean(PROP_SPLIT_COMPILED_INLINED, false);
    }

    public void saveSettings() {
    }

    public abstract boolean presetValid();

    public boolean settingsValid() {
        return this.panel.settingsValid();
    }

    public void showSettings(DataViewComponent dvc) {
        dvc.selectDetailsView(this.getDetailsView());
    }

    public abstract PresetSelector createSelector(Runnable var1);

    public void setEnabled(boolean enabled) {
        if (this.container != null) {
            this.container.setEnabled(enabled);
        }
    }

    private JPanel createPanel() {
        this.panel = new SamplerCPUPanel(){

            public void settingsChanged() {
                CPUSettingsSupport.this.panel.saveToPreset(CPUSettingsSupport.this.selector.customize(CPUSettingsSupport.this.presetValid()));
            }
        };
        this.selector = this.createSelector(new Runnable(){

            @Override
            public void run() {
                CPUSettingsSupport.this.panel.loadFromPreset(CPUSettingsSupport.this.selector.getSelectedPreset());
            }
        });
        this.selector.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.container = new JPanel(new BorderLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        this.container.setOpaque(false);
        this.container.add((Component)this.panel, "Center");
        JPanel southPanel = new JPanel(new BorderLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        southPanel.setOpaque(false);
        southPanel.add((Component)this.selector, "North");
        JPanel engineSettingsPanel = new JPanel(new GridBagLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        engineSettingsPanel.setOpaque(false);
        SectionSeparator section = new SectionSeparator(NbBundle.getMessage(CPUSettingsSupport.class, (String)"SEP_EngineSettings"), new JLabel().getFont());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(25, 10, 5, 5);
        engineSettingsPanel.add((Component)section, constraints);
        JLabel modeLabel = new JLabel();
        modeLabel.setText(NbBundle.getMessage(CPUSettingsSupport.class, (String)"LBL_Mode"));
        modeLabel.setToolTipText(NbBundle.getMessage(CPUSettingsSupport.class, (String)"TOOLTIP_Mode"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 5, 5);
        engineSettingsPanel.add((Component)modeLabel, constraints);
        final JComboBox modeCombo = new JComboBox((Object[])Mode.values()){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        modeCombo.setSelectedItem((Object)Mode.valueOf(this.getMode()));
        modeLabel.setLabelFor(modeCombo);
        modeCombo.setToolTipText(NbBundle.getMessage(CPUSettingsSupport.class, (String)"TOOLTIP_Mode"));
        modeCombo.setEditable(false);
        modeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mode selected = (Mode)((Object)modeCombo.getSelectedItem());
                NbPreferences.forModule(CPUSettingsSupport.class).put(CPUSettingsSupport.PROP_MODE, selected.name());
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 0, 5, 5);
        engineSettingsPanel.add((Component)modeCombo, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 0, 5, 0);
        engineSettingsPanel.add((Component)Spacer.create(), constraints);
        final JCheckBox splitChoice = new JCheckBox();
        splitChoice.setSelected(this.isSplitCompiledInlined());
        splitChoice.setText(NbBundle.getMessage(CPUSettingsSupport.class, (String)"LBL_Split"));
        splitChoice.setToolTipText(NbBundle.getMessage(CPUSettingsSupport.class, (String)"TOOLTIP_Split"));
        splitChoice.setOpaque(false);
        splitChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NbPreferences.forModule(CPUSettingsSupport.class).putBoolean(CPUSettingsSupport.PROP_SPLIT_COMPILED_INLINED, splitChoice.isSelected());
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(1, 10, 10, 5);
        engineSettingsPanel.add((Component)splitChoice, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 0, 10, 0);
        engineSettingsPanel.add((Component)Spacer.create(), constraints);
        southPanel.add((Component)engineSettingsPanel, "South");
        this.container.add((Component)southPanel, "South");
        return this.container;
    }

    private static enum Mode {
        EXCLUDE_INLINED_ROOTS{

            public String toString() {
                return NbBundle.getMessage(CPUSettingsSupport.class, (String)"MODE_EXCLUDE_INLINED_ROOTS");
            }
        }
        ,
        ROOTS{

            public String toString() {
                return NbBundle.getMessage(CPUSettingsSupport.class, (String)"MODE_ROOTS");
            }
        }
        ,
        STATEMENTS{

            public String toString() {
                return NbBundle.getMessage(CPUSettingsSupport.class, (String)"MODE_STATEMENTS");
            }
        };

    }
}

