/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.overrides.DeepCopyIrTreeWithSymbolsForFakeOverrides;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\n\u0010\f\u001a\u00020\b*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\b*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\b*\u00020\u0011\u001a\u001c\u0010\u0012\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"buildFakeOverrideMember", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "superType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "member", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isInFriendModules", "", "thisModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "friendModule", "isOverridableFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isOverridableMemberOrAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isOverridableProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "isPrivateToThisModule", "thisClass", "memberClass", "ir.tree"})
public final class IrOverridingUtilKt {
    private static final boolean isPrivateToThisModule(IrOverridableMember $this$isPrivateToThisModule, IrClass thisClass, IrClass memberClass) {
        IrModuleFragment memberModule;
        if (!Intrinsics.areEqual($this$isPrivateToThisModule.getVisibility(), DescriptorVisibilities.INTERNAL)) {
            return false;
        }
        IrFile irFile = IrUtilsKt.getFileOrNull(thisClass);
        IrModuleFragment thisModule = irFile == null ? null : irFile.getModule();
        IrFile irFile2 = IrUtilsKt.getFileOrNull(memberClass);
        IrModuleFragment irModuleFragment = memberModule = irFile2 == null ? null : irFile2.getModule();
        if (Intrinsics.areEqual(thisModule, memberModule)) {
            return false;
        }
        if (thisModule == null || memberModule == null) {
            return false;
        }
        return !IrOverridingUtilKt.isInFriendModules(thisModule, memberModule);
    }

    private static final boolean isInFriendModules(IrModuleFragment thisModule, IrModuleFragment friendModule) {
        return false;
    }

    @NotNull
    public static final IrOverridableMember buildFakeOverrideMember(@NotNull IrType superType2, @NotNull IrOverridableMember member2, @NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter(superType2, "superType");
        Intrinsics.checkNotNullParameter(member2, "member");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        boolean bl = superType2 instanceof IrSimpleType;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl42 = false;
            String string2 = "superType is " + superType2 + ", expected IrSimpleType";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        IrClassifierSymbol classifier2 = ((IrSimpleType)superType2).getClassifier();
        bl2 = classifier2 instanceof IrClassSymbol;
        bl3 = false;
        boolean bl42 = false;
        if (!bl2) {
            boolean bl5 = false;
            String bl42 = Intrinsics.stringPlus("superType classifier is not IrClassSymbol: ", classifier2);
            throw (Throwable)new IllegalArgumentException(bl42.toString());
        }
        List<IrTypeParameter> typeParameters2 = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)((IrClassSymbol)classifier2).getOwner());
        List<IrTypeArgument> superArguments = ((IrSimpleType)superType2).getArguments();
        bl42 = typeParameters2.size() == superArguments.size();
        int bl5 = 0;
        if (_Assertions.ENABLED && !bl42) {
            boolean $i$a$-assert-IrOverridingUtilKt$buildFakeOverrideMember$42 = false;
            String $i$a$-assert-IrOverridingUtilKt$buildFakeOverrideMember$42 = "typeParameters = " + typeParameters2 + " size != typeArguments = " + superArguments + " size ";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-IrOverridingUtilKt$buildFakeOverrideMember$42));
        }
        bl5 = 0;
        Map substitutionMap = new LinkedHashMap();
        bl5 = 0;
        int $i$a$-assert-IrOverridingUtilKt$buildFakeOverrideMember$42 = typeParameters2.size() + -1;
        if (bl5 <= $i$a$-assert-IrOverridingUtilKt$buildFakeOverrideMember$42) {
            do {
                int i = bl5++;
                IrTypeParameter tp = typeParameters2.get(i);
                IrTypeArgument ta = superArguments.get(i);
                boolean bl6 = ta instanceof IrTypeProjection;
                boolean bl7 = false;
                boolean bl8 = false;
                if (!bl6) {
                    boolean bl9 = false;
                    String string3 = "Unexpected super type argument: " + RenderIrElementKt.render(ta) + " @ " + i;
                    throw (Throwable)new IllegalArgumentException(string3.toString());
                }
                bl6 = ((IrTypeProjection)ta).getVariance() == Variance.INVARIANT;
                bl7 = false;
                if (_Assertions.ENABLED && !bl6) {
                    boolean bl10 = false;
                    String string4 = "Unexpected variance in super type argument: " + (Object)((Object)((IrTypeProjection)ta).getVariance()) + " @" + i;
                    throw (Throwable)((Object)new AssertionError((Object)string4));
                }
                Map map = substitutionMap;
                IrTypeParameterSymbol irTypeParameterSymbol = tp.getSymbol();
                IrType irType = ((IrTypeProjection)ta).getType();
                boolean bl11 = false;
                map.put(irTypeParameterSymbol, irType);
            } while (bl5 <= $i$a$-assert-IrOverridingUtilKt$buildFakeOverrideMember$42);
        }
        DeepCopyIrTreeWithSymbolsForFakeOverrides copier2 = new DeepCopyIrTreeWithSymbolsForFakeOverrides(substitutionMap);
        IrOverridableMember deepCopyFakeOverride = (IrOverridableMember)copier2.copy(member2, clazz);
        deepCopyFakeOverride.setParent(clazz);
        if (IrOverridingUtilKt.isPrivateToThisModule(deepCopyFakeOverride, clazz, (IrClass)((IrClassSymbol)classifier2).getOwner())) {
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.INVISIBLE_FAKE;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "INVISIBLE_FAKE");
            deepCopyFakeOverride.setVisibility(descriptorVisibility);
        }
        return deepCopyFakeOverride;
    }

    public static final boolean isOverridableFunction(@NotNull IrSimpleFunction $this$isOverridableFunction) {
        Intrinsics.checkNotNullParameter($this$isOverridableFunction, "<this>");
        return !Intrinsics.areEqual($this$isOverridableFunction.getVisibility(), DescriptorVisibilities.PRIVATE) && $this$isOverridableFunction.getDispatchReceiverParameter() != null;
    }

    public static final boolean isOverridableProperty(@NotNull IrProperty $this$isOverridableProperty) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter($this$isOverridableProperty, "<this>");
        return !Intrinsics.areEqual($this$isOverridableProperty.getVisibility(), DescriptorVisibilities.PRIVATE) && (((irSimpleFunction = $this$isOverridableProperty.getGetter()) == null ? null : irSimpleFunction.getDispatchReceiverParameter()) != null || ((irSimpleFunction = $this$isOverridableProperty.getSetter()) == null ? null : irSimpleFunction.getDispatchReceiverParameter()) != null);
    }

    public static final boolean isOverridableMemberOrAccessor(@NotNull IrDeclaration $this$isOverridableMemberOrAccessor) {
        Intrinsics.checkNotNullParameter($this$isOverridableMemberOrAccessor, "<this>");
        IrDeclaration irDeclaration2 = $this$isOverridableMemberOrAccessor;
        return irDeclaration2 instanceof IrSimpleFunction ? IrOverridingUtilKt.isOverridableFunction((IrSimpleFunction)$this$isOverridableMemberOrAccessor) : (irDeclaration2 instanceof IrProperty ? IrOverridingUtilKt.isOverridableProperty((IrProperty)$this$isOverridableMemberOrAccessor) : false);
    }
}

