/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
    anjuta-autogen.h
    Copyright (C) 2004 Sebastien Granjoux

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __ANJUTA_AUTOGEN_H__
#define __ANJUTA_AUTOGEN_H__

#include <glib.h>

/**
 * AnjutaAutogen:
 *
 * A GObject wrapper for running GNU autogen.
 **/

typedef struct _AnjutaAutogen AnjutaAutogen;
typedef struct _AnjutaAutogenClass AnjutaAutogenClass;

#define ANJUTA_TYPE_AUTOGEN             (anjuta_autogen_get_type ())
#define ANJUTA_AUTOGEN(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), ANJUTA_TYPE_AUTOGEN, AnjutaAutogen))
#define ANJUTA_AUTOGEN_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), ANJUTA_TYPE_AUTOGEN, AnjutaAutogenClass))
#define ANJUTA_IS_AUTOGEN(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ANJUTA_TYPE_AUTOGEN))
#define ANJUTA_IS_AUTOGEN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), ANJUTA_TYPE_AUTOGEN))
#define ANJUTA_AUTOGEN_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), ANJUTA_TYPE_AUTOGEN, AnjutaAutogenClass))

GType anjuta_autogen_get_type (void) G_GNUC_CONST;

/**
 * AnjutaAutogenFunc:
 * @autogen: #AnjutaAutogen object.
 * @data: user data passed to the callback.
 *
 * This function is called when the autogen process is completed.
 */
typedef void (*AnjutaAutogenFunc) (AnjutaAutogen* autogen, gpointer data);

/**
 * AnjutaAutogenOutputFunc:
 * @output: data generated by autogen.
 * @data: user data passed to the callback.
 *
 * This function is called each time there is new data from autogen.
 */
typedef void (*AnjutaAutogenOutputFunc) (const gchar* output, gpointer data);


AnjutaAutogen* anjuta_autogen_new (void);

gboolean anjuta_autogen_write_definition_file (AnjutaAutogen* this, GHashTable* values, GError **error);

void anjuta_autogen_set_library_path (AnjutaAutogen* this, const gchar *directory);
void anjuta_autogen_clear_library_path (AnjutaAutogen* this);
GList *anjuta_autogen_get_library_paths (AnjutaAutogen* this);
gboolean anjuta_autogen_set_input_file (AnjutaAutogen* this, const gchar* filename, const gchar* start_marker, const gchar* end_marker);
gboolean anjuta_autogen_set_output_file (AnjutaAutogen* this, const gchar* filename);
gboolean anjuta_autogen_set_output_callback (AnjutaAutogen* this, AnjutaAutogenOutputFunc func, gpointer user_data, GDestroyNotify destroy);

gboolean anjuta_autogen_execute (AnjutaAutogen* this, AnjutaAutogenFunc func, gpointer data, GError** error);

gboolean anjuta_check_autogen(void);

#endif
