#!/usr/bin/env sh

# Valid actions:

# - FATAL       - netdata exited due to a fatal condition
#      ACTION_RESULT  -- program name and thread tag
#      ACTION_DATA    -- fmt, args passed to fatal
# - START       - netdata started
#      ACTION_DATA     -- nan
# - EXIT        - installation action
#      ACTION_DATA     -- ret value of

ACTION="${1}"
ACTION_RESULT="${2}"
ACTION_DATA="${3}"
ACTION_DATA=$(echo "${ACTION_DATA}" | tr '"' "'")

# -------------------------------------------------------------------------------------------------
# check opt-out

if [ -f "/etc/netdata/.opt-out-from-anonymous-statistics" ] || [ ! "${DO_NOT_TRACK:-0}" -eq 0 ] || [ -n "$DO_NOT_TRACK" ]; then
  exit 0
fi

# Shorten version for easier reporting
NETDATA_VERSION=$(echo "${NETDATA_VERSION}" | sed 's/-.*//g' | tr -d 'v')

# -------------------------------------------------------------------------------------------------
# Get the extra variables

NETDATA_CONFIG_STREAM_ENABLED="${4}"
NETDATA_CONFIG_MEMORY_MODE="${5}"
NETDATA_CONFIG_EXPORTING_ENABLED="${6}"
NETDATA_EXPORTING_CONNECTORS="${7}"
NETDATA_ALLMETRICS_PROMETHEUS_USED="${8}"
NETDATA_ALLMETRICS_SHELL_USED="${9}"
NETDATA_ALLMETRICS_JSON_USED="${10}"
NETDATA_DASHBOARD_USED="${11}"
NETDATA_COLLECTORS="${12}"
NETDATA_COLLECTORS_COUNT="${13}"
NETDATA_BUILDINFO="${14}"
NETDATA_CONFIG_PAGE_CACHE_SIZE="${15}"
NETDATA_CONFIG_MULTIDB_DISK_QUOTA="${16}"
NETDATA_CONFIG_HTTPS_ENABLED="${17}"
NETDATA_CONFIG_WEB_ENABLED="${18}"
NETDATA_CONFIG_RELEASE_CHANNEL="${19}"
NETDATA_MIRRORED_HOST_COUNT="${20}"
NETDATA_MIRRORED_HOSTS_REACHABLE="${21}"
NETDATA_MIRRORED_HOSTS_UNREACHABLE="${22}"
NETDATA_NOTIFICATION_METHODS="${23}"
NETDATA_ALARMS_NORMAL="${24}"
NETDATA_ALARMS_WARNING="${25}"
NETDATA_ALARMS_CRITICAL="${26}"
NETDATA_CHARTS_COUNT="${27}"
NETDATA_METRICS_COUNT="${28}"
NETDATA_CONFIG_IS_PARENT="${29}"
NETDATA_CONFIG_HOSTS_AVAILABLE="${30}"
NETDATA_HOST_CLOUD_AVAILABLE="${31}"
NETDATA_HOST_ACLK_AVAILABLE="${32}"
NETDATA_HOST_ACLK_IMPLEMENTATION="${33}"
NETDATA_HOST_AGENT_CLAIMED="${34}"
NETDATA_HOST_CLOUD_ENABLED="${35}"

# define body of request to be sent
REQ_BODY="$(cat << EOF
{
    "api_key": "mqkwGT0JNFqO-zX2t0mW6Tec9yooaVu7xCBlXtHnt5Y",
    "event": "${ACTION} ${ACTION_RESULT}",
    "properties": {
        "distinct_id": "${NETDATA_REGISTRY_UNIQUE_ID}",
        "\$current_url": "agent backend",
        "\$pathname": "netdata-backend",
        "\$host": "backend.netdata.io",
        "\$ip": "127.0.0.1",
        "event_source": "agent backend",
        "action": "${ACTION}",
        "action_result": "${ACTION_RESULT}",
        "action_data": "${ACTION_DATA}",
        "netdata_machine_guid": "${NETDATA_REGISTRY_UNIQUE_ID}",
        "netdata_version": "${NETDATA_VERSION}",
        "netdata_buildinfo": ${NETDATA_BUILDINFO},
        "netdata_release_channel": ${NETDATA_CONFIG_RELEASE_CHANNEL},
        "host_os_name": "${NETDATA_HOST_OS_NAME}",
        "host_os_id": "${NETDATA_HOST_OS_ID}",
        "host_os_id_like": "${NETDATA_HOST_OS_ID_LIKE}",
        "host_os_version": "${NETDATA_HOST_OS_VERSION}",
        "host_os_version_id": "${NETDATA_HOST_OS_VERSION_ID}",
        "host_os_detection": "${NETDATA_HOST_OS_DETECTION}",
        "host_is_k8s_node": "${NETDATA_HOST_IS_K8S_NODE}",
        "system_kernel_name": "${NETDATA_SYSTEM_KERNEL_NAME}",
        "system_kernel_version": "${NETDATA_SYSTEM_KERNEL_VERSION}",
        "system_architecture": "${NETDATA_SYSTEM_ARCHITECTURE}",
        "system_virtualization": "${NETDATA_SYSTEM_VIRTUALIZATION}",
        "system_virt_detection": "${NETDATA_SYSTEM_VIRT_DETECTION}",
        "system_container": "${NETDATA_SYSTEM_CONTAINER}",
        "system_container_detection": "${NETDATA_SYSTEM_CONTAINER_DETECTION}",
        "container_os_name": "${NETDATA_CONTAINER_OS_NAME}",
        "container_os_id": "${NETDATA_CONTAINER_OS_ID}",
        "container_os_id_like": "${NETDATA_CONTAINER_OS_ID_LIKE}",
        "container_os_version": "${NETDATA_CONTAINER_OS_VERSION}",
        "container_os_version_id": "${NETDATA_CONTAINER_OS_VERSION_ID}",
        "container_os_detection": "${NETDATA_CONTAINER_OS_DETECTION}",
        "system_cpu_detection": "${NETDATA_SYSTEM_CPU_DETECTION}",
        "system_cpu_freq": "${NETDATA_SYSTEM_CPU_FREQ}",
        "system_cpu_logical_cpu_count": "${NETDATA_SYSTEM_CPU_LOGICAL_CPU_COUNT}",
        "system_cpu_model": "${NETDATA_SYSTEM_CPU_MODEL}",
        "system_cpu_vendor": "${NETDATA_SYSTEM_CPU_VENDOR}",
        "system_disk_detection": "${NETDATA_SYSTEM_DISK_DETECTION}",
        "system_ram_detection": "${NETDATA_SYSTEM_RAM_DETECTION}",
        "system_total_disk_size": "${NETDATA_SYSTEM_TOTAL_DISK_SIZE}",
        "system_total_ram": "${NETDATA_SYSTEM_TOTAL_RAM}",
        "config_stream_enabled": ${NETDATA_CONFIG_STREAM_ENABLED},
        "config_memory_mode": ${NETDATA_CONFIG_MEMORY_MODE},
        "config_page_cache_size": ${NETDATA_CONFIG_PAGE_CACHE_SIZE},
        "config_multidb_disk_quota": ${NETDATA_CONFIG_MULTIDB_DISK_QUOTA},
        "config_https_enabled": ${NETDATA_CONFIG_HTTPS_ENABLED},
        "config_web_enabled": ${NETDATA_CONFIG_WEB_ENABLED},
        "config_exporting_enabled": ${NETDATA_CONFIG_EXPORTING_ENABLED},
        "config_is_parent": ${NETDATA_CONFIG_IS_PARENT},
        "config_hosts_available": ${NETDATA_CONFIG_HOSTS_AVAILABLE},
        "alarms_normal": ${NETDATA_ALARMS_NORMAL},
        "alarms_warning": ${NETDATA_ALARMS_WARNING},
        "alarms_critical": ${NETDATA_ALARMS_CRITICAL},
        "host_charts_count": ${NETDATA_CHARTS_COUNT},
        "host_metrics_count": ${NETDATA_METRICS_COUNT},
        "host_collectors":[
            ${NETDATA_COLLECTORS}
        ],
        "host_collectors_count": ${NETDATA_COLLECTORS_COUNT},
        "host_notification_methods": ${NETDATA_NOTIFICATION_METHODS},
        "host_allmetrics_prometheus_used": ${NETDATA_ALLMETRICS_PROMETHEUS_USED},
        "host_allmetrics_shell_used": ${NETDATA_ALLMETRICS_SHELL_USED},
        "host_allmetrics_json_used": ${NETDATA_ALLMETRICS_JSON_USED},
        "host_dashboard_used": ${NETDATA_DASHBOARD_USED},
        "host_cloud_available": ${NETDATA_HOST_CLOUD_AVAILABLE},
        "host_cloud_enabled": ${NETDATA_HOST_CLOUD_ENABLED},
        "host_agent_claimed": ${NETDATA_HOST_AGENT_CLAIMED},
        "host_aclk_available": ${NETDATA_HOST_ACLK_AVAILABLE},
        "host_aclk_implementation": ${NETDATA_HOST_ACLK_IMPLEMENTATION},
        "mirrored_host_count": ${NETDATA_MIRRORED_HOST_COUNT},
        "mirrored_hosts_reachable": ${NETDATA_MIRRORED_HOSTS_REACHABLE},
        "mirrored_hosts_unreachable": ${NETDATA_MIRRORED_HOSTS_UNREACHABLE},
        "exporting_connectors": ${NETDATA_EXPORTING_CONNECTORS}
  }
}
EOF
)"

# send the anonymous statistics to the Netdata PostHog
if [ -n "$(command -v curl 2> /dev/null)" ]; then
  curl -X POST --max-time 2 --header "Content-Type: application/json" -d "${REQ_BODY}" https://posthog.netdata.cloud/capture/ > /dev/null 2>&1
else
  wget -q -O - --no-check-certificate \
  --method POST \
  --timeout=1 \
  --header 'Content-Type: application/json' \
  --body-data "${REQ_BODY}" \
   'https://posthog.netdata.cloud/capture/' > /dev/null 2>&1
fi
