/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ScaledImageComponent;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileContentManager
implements ContentManager {
    private static final String OBJ_EXTENSION = ".obj";
    private static final FileFilter[] OBJ_FILTER = new FileFilter[]{new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.OBJ_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "OBJ - Wavefront";
        }
    }};
    private static final String LWS_EXTENSION = ".lws";
    private static final String THREEDS_EXTENSION = ".3ds";
    private static final String DAE_EXTENSION = ".dae";
    private static final String KMZ_EXTENSION = ".kmz";
    private static final String ZIP_EXTENSION = ".zip";
    private static final FileFilter[] MODEL_FILTERS = new FileFilter[]{OBJ_FILTER[0], new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.LWS_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "LWS - LightWave Scene";
        }
    }, new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.THREEDS_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "3DS - 3D Studio";
        }
    }, new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.DAE_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "DAE - Collada";
        }
    }, new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.KMZ_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "KMZ";
        }
    }, new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.ZIP_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "ZIP";
        }
    }};
    private static final String PNG_EXTENSION = ".png";
    private static final FileFilter[] PNG_FILTER = new FileFilter[]{new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.PNG_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "PNG";
        }
    }};
    private static final String JPEG_EXTENSION = ".jpg";
    private static final FileFilter[] JPEG_FILTER = new FileFilter[]{new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.JPEG_EXTENSION) || file.getName().toLowerCase().endsWith("jpeg");
        }

        @Override
        public String getDescription() {
            return "JPEG";
        }
    }};
    private static final String BMP_EXTENSION = ".bmp";
    private static final String WBMP_EXTENSION = ".wbmp";
    private static final String GIF_EXTENSION = ".gif";
    private static final FileFilter[] IMAGE_FILTERS = new FileFilter[]{new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.BMP_EXTENSION) || file.getName().toLowerCase().endsWith(FileContentManager.WBMP_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "BMP";
        }
    }, new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.GIF_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "GIF";
        }
    }, JPEG_FILTER[0], PNG_FILTER[0]};
    private static final String MOV_EXTENSION = ".mov";
    private static final FileFilter[] MOV_FILTER = new FileFilter[]{new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.MOV_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "MOV";
        }
    }};
    private static final String PDF_EXTENSION = ".pdf";
    private static final FileFilter[] PDF_FILTER = new FileFilter[]{new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.PDF_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "PDF";
        }
    }};
    private static final String CSV_EXTENSION = ".csv";
    private static final FileFilter[] CSV_FILTER = new FileFilter[]{new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.CSV_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "CSV - Tab Separated Values";
        }
    }};
    private static final String SVG_EXTENSION = ".svg";
    private static final FileFilter[] SVG_FILTER = new FileFilter[]{new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.SVG_EXTENSION);
        }

        @Override
        public String getDescription() {
            return "SVG - Scalable Vector Graphics";
        }
    }};
    private final UserPreferences preferences;
    private final String sweetHome3DFileExtension;
    private final String sweetHome3DFileExtension2;
    private final String languageLibraryFileExtension;
    private final String furnitureLibraryFileExtension;
    private final String texturesLibraryFileExtension;
    private final String pluginFileExtension;
    private Map<ContentManager.ContentType, File> lastDirectories;
    private Map<ContentManager.ContentType, FileFilter[]> fileFilters;
    private Map<ContentManager.ContentType, String[]> fileExtensions;

    public FileContentManager(final UserPreferences userPreferences) {
        String[] stringArray;
        String string;
        this.preferences = userPreferences;
        this.sweetHome3DFileExtension = userPreferences.getLocalizedString(FileContentManager.class, "homeExtension", new Object[0]);
        try {
            string = userPreferences.getLocalizedString(FileContentManager.class, "homeExtension2", new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = null;
        }
        this.sweetHome3DFileExtension2 = string;
        this.languageLibraryFileExtension = userPreferences.getLocalizedString(FileContentManager.class, "languageLibraryExtension", new Object[0]);
        this.furnitureLibraryFileExtension = userPreferences.getLocalizedString(FileContentManager.class, "furnitureLibraryExtension", new Object[0]);
        this.texturesLibraryFileExtension = userPreferences.getLocalizedString(FileContentManager.class, "texturesLibraryExtension", new Object[0]);
        this.pluginFileExtension = userPreferences.getLocalizedString(FileContentManager.class, "pluginExtension", new Object[0]);
        this.lastDirectories = new HashMap<ContentManager.ContentType, File>();
        this.fileFilters = new HashMap<ContentManager.ContentType, FileFilter[]>();
        this.fileFilters.put(ContentManager.ContentType.MODEL, MODEL_FILTERS);
        this.fileFilters.put(ContentManager.ContentType.IMAGE, IMAGE_FILTERS);
        this.fileFilters.put(ContentManager.ContentType.MOV, MOV_FILTER);
        this.fileFilters.put(ContentManager.ContentType.PNG, PNG_FILTER);
        this.fileFilters.put(ContentManager.ContentType.JPEG, JPEG_FILTER);
        this.fileFilters.put(ContentManager.ContentType.PDF, PDF_FILTER);
        this.fileFilters.put(ContentManager.ContentType.CSV, CSV_FILTER);
        this.fileFilters.put(ContentManager.ContentType.SVG, SVG_FILTER);
        this.fileFilters.put(ContentManager.ContentType.OBJ, OBJ_FILTER);
        this.fileFilters.put(ContentManager.ContentType.SWEET_HOME_3D, new FileFilter[]{new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.this.sweetHome3DFileExtension) || FileContentManager.this.sweetHome3DFileExtension2 != null && file.getName().toLowerCase().endsWith(FileContentManager.this.sweetHome3DFileExtension2);
            }

            @Override
            public String getDescription() {
                return userPreferences.getLocalizedString(FileContentManager.class, "homeDescription", new Object[0]);
            }
        }});
        this.fileFilters.put(ContentManager.ContentType.LANGUAGE_LIBRARY, new FileFilter[]{new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.this.languageLibraryFileExtension);
            }

            @Override
            public String getDescription() {
                return userPreferences.getLocalizedString(FileContentManager.class, "languageLibraryDescription", new Object[0]);
            }
        }});
        this.fileFilters.put(ContentManager.ContentType.FURNITURE_LIBRARY, new FileFilter[]{new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.this.furnitureLibraryFileExtension);
            }

            @Override
            public String getDescription() {
                return userPreferences.getLocalizedString(FileContentManager.class, "furnitureLibraryDescription", new Object[0]);
            }
        }});
        this.fileFilters.put(ContentManager.ContentType.TEXTURES_LIBRARY, new FileFilter[]{new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.this.texturesLibraryFileExtension);
            }

            @Override
            public String getDescription() {
                return userPreferences.getLocalizedString(FileContentManager.class, "texturesLibraryDescription", new Object[0]);
            }
        }});
        this.fileFilters.put(ContentManager.ContentType.PLUGIN, new FileFilter[]{new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(FileContentManager.this.pluginFileExtension);
            }

            @Override
            public String getDescription() {
                return userPreferences.getLocalizedString(FileContentManager.class, "pluginDescription", new Object[0]);
            }
        }});
        this.fileFilters.put(ContentManager.ContentType.PHOTOS_DIRECTORY, new FileFilter[]{new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Photos";
            }
        }});
        this.fileExtensions = new HashMap<ContentManager.ContentType, String[]>();
        if (this.sweetHome3DFileExtension2 != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.sweetHome3DFileExtension;
            stringArray = stringArray2;
            stringArray2[1] = this.sweetHome3DFileExtension2;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.sweetHome3DFileExtension;
        }
        String[] stringArray4 = stringArray;
        this.fileExtensions.put(ContentManager.ContentType.SWEET_HOME_3D, stringArray4);
        this.fileExtensions.put(ContentManager.ContentType.LANGUAGE_LIBRARY, new String[]{this.languageLibraryFileExtension});
        this.fileExtensions.put(ContentManager.ContentType.FURNITURE_LIBRARY, new String[]{this.furnitureLibraryFileExtension});
        this.fileExtensions.put(ContentManager.ContentType.TEXTURES_LIBRARY, new String[]{this.texturesLibraryFileExtension});
        this.fileExtensions.put(ContentManager.ContentType.PLUGIN, new String[]{this.pluginFileExtension});
        this.fileExtensions.put(ContentManager.ContentType.PNG, new String[]{PNG_EXTENSION});
        this.fileExtensions.put(ContentManager.ContentType.JPEG, new String[]{JPEG_EXTENSION});
        this.fileExtensions.put(ContentManager.ContentType.MOV, new String[]{MOV_EXTENSION});
        this.fileExtensions.put(ContentManager.ContentType.PDF, new String[]{PDF_EXTENSION});
        this.fileExtensions.put(ContentManager.ContentType.CSV, new String[]{CSV_EXTENSION});
        this.fileExtensions.put(ContentManager.ContentType.SVG, new String[]{SVG_EXTENSION});
        this.fileExtensions.put(ContentManager.ContentType.OBJ, new String[]{OBJ_EXTENSION});
        this.fileExtensions.put(ContentManager.ContentType.MODEL, new String[]{OBJ_EXTENSION, LWS_EXTENSION, THREEDS_EXTENSION, DAE_EXTENSION, ZIP_EXTENSION, KMZ_EXTENSION});
        this.fileExtensions.put(ContentManager.ContentType.IMAGE, new String[]{PNG_EXTENSION, JPEG_EXTENSION, BMP_EXTENSION, WBMP_EXTENSION, GIF_EXTENSION});
    }

    @Override
    public Content getContent(String string) throws RecorderException {
        try {
            return new URLContent(new File(string).toURI().toURL());
        }
        catch (IOException iOException) {
            throw new RecorderException("Couldn't access to content " + string);
        }
    }

    @Override
    public String getPresentationName(String string, ContentManager.ContentType contentType) {
        switch (contentType) {
            case SWEET_HOME_3D: 
            case FURNITURE_LIBRARY: 
            case TEXTURES_LIBRARY: 
            case LANGUAGE_LIBRARY: 
            case PLUGIN: {
                return new File(string).getName();
            }
        }
        String string2 = new File(string).getName();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    protected FileFilter[] getFileFilter(ContentManager.ContentType contentType) {
        if (contentType == ContentManager.ContentType.USER_DEFINED) {
            throw new IllegalArgumentException("Unknown user defined content type");
        }
        return this.fileFilters.get((Object)contentType);
    }

    public String getDefaultFileExtension(ContentManager.ContentType contentType) {
        String[] stringArray = this.fileExtensions.get((Object)contentType);
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    protected String[] getFileExtensions(ContentManager.ContentType contentType) {
        return this.fileExtensions.get((Object)contentType);
    }

    @Override
    public boolean isAcceptable(String string, ContentManager.ContentType contentType) {
        File file = new File(string);
        for (FileFilter fileFilter : this.getFileFilter(contentType)) {
            if (!fileFilter.accept(file)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDirectory(ContentManager.ContentType contentType) {
        return contentType == ContentManager.ContentType.PHOTOS_DIRECTORY;
    }

    @Override
    public String showOpenDialog(View view, String string, ContentManager.ContentType contentType) {
        if (OperatingSystem.isMacOSX() && !this.isDirectory(contentType)) {
            return this.showFileDialog(view, string, contentType, null, false);
        }
        return this.showFileChooser(view, string, contentType, null, false);
    }

    @Override
    public String showSaveDialog(View view, String string, ContentManager.ContentType contentType, String string2) {
        int n;
        String string3 = this.getDefaultFileExtension(contentType);
        if (string2 != null && (n = string2.lastIndexOf(46)) != -1) {
            string2 = string2.substring(0, n);
            if (string3 != null) {
                string2 = string2 + string3;
            }
        }
        String string4 = OperatingSystem.isMacOSX() && !this.isDirectory(contentType) ? this.showFileDialog(view, string, contentType, string2, true) : this.showFileChooser(view, string, contentType, string2, true);
        boolean bl = false;
        if (string4 != null) {
            File file;
            if (string3 != null && !string4.toLowerCase().endsWith(string3)) {
                string4 = string4 + string3;
                bl = true;
            }
            if (OperatingSystem.isMacOSX() && !bl) {
                return string4;
            }
            if (!this.isDirectory(contentType) && (file = new File(string4)).exists() && !this.confirmOverwrite(view, file.getName())) {
                return this.showSaveDialog(view, string, contentType, string4);
            }
        }
        return string4;
    }

    private String showFileDialog(View view, String string, final ContentManager.ContentType contentType, String string2, boolean bl) {
        FileDialog fileDialog = new FileDialog(JOptionPane.getFrameForComponent((JComponent)((Object)view)));
        if (bl && string2 != null) {
            fileDialog.setFile(new File(string2).getName());
        }
        fileDialog.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return FileContentManager.this.isAcceptable(new File(file, string).toString(), contentType);
            }
        });
        File file = this.getLastDirectory(contentType);
        if (file != null && file.exists()) {
            if (this.isDirectory(contentType)) {
                fileDialog.setDirectory(file.getParent());
                fileDialog.setFile(file.getName());
            } else {
                fileDialog.setDirectory(file.toString());
            }
        }
        if (bl) {
            fileDialog.setMode(1);
        } else {
            fileDialog.setMode(0);
        }
        if (string == null) {
            string = this.getFileDialogTitle(bl);
        }
        fileDialog.setTitle(string);
        fileDialog.setVisible(true);
        String string3 = fileDialog.getFile();
        if (string3 != null) {
            string3 = new File(fileDialog.getDirectory(), string3).toString();
            file = this.isDirectory(contentType) ? new File(string3) : new File(fileDialog.getDirectory());
            this.setLastDirectory(contentType, file);
            return string3;
        }
        return null;
    }

    protected File getLastDirectory(ContentManager.ContentType contentType) {
        File file = this.lastDirectories.get((Object)contentType);
        if (file == null) {
            file = this.lastDirectories.get(null);
        }
        return file;
    }

    protected void setLastDirectory(ContentManager.ContentType contentType, File file) {
        this.lastDirectories.put(contentType, file);
        this.lastDirectories.put(null, file);
    }

    private String showFileChooser(View view, String string, ContentManager.ContentType contentType, String string2, boolean bl) {
        FileFilter[] fileFilterArray;
        Object object;
        Serializable serializable;
        JFileChooser jFileChooser;
        if (OperatingSystem.isWindows() && UIManager.getLookAndFeel().getClass().getName().equals(UIManager.getSystemLookAndFeelClassName()) && !OperatingSystem.isJavaVersionGreaterOrEqual("1.8.0_141") && (!OperatingSystem.isJavaVersionGreaterOrEqual("1.8.0_60") && OperatingSystem.compareVersions(System.getProperty("os.version"), "6.3") >= 0 || OperatingSystem.isJavaVersionGreaterOrEqual("1.8.0_60") && OperatingSystem.compareVersions(System.getProperty("os.version"), "10.0") >= 0)) {
            UIManager.put("FileChooser.useSystemExtensionHiding", false);
        }
        if (this.isDirectory(contentType)) {
            jFileChooser = new DirectoryChooser(this.preferences);
        } else {
            jFileChooser = new JFileChooser();
            if (!bl && contentType == ContentManager.ContentType.IMAGE) {
                serializable = new ScaledImageComponent();
                object = Executors.newSingleThreadExecutor();
                fileFilterArray = new AtomicReference();
                jFileChooser.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){
                    final /* synthetic */ ScaledImageComponent val$previewLabel;
                    final /* synthetic */ JFileChooser val$fileChooser;
                    final /* synthetic */ AtomicReference val$selectedImageFile;
                    final /* synthetic */ ExecutorService val$previewImageLoader;
                    {
                        this.val$previewLabel = scaledImageComponent;
                        this.val$fileChooser = jFileChooser;
                        this.val$selectedImageFile = atomicReference;
                        this.val$previewImageLoader = executorService;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        final File file = (File)propertyChangeEvent.getNewValue();
                        this.val$previewLabel.setImage(null);
                        if (file != null && !file.isDirectory() && FileContentManager.this.isAcceptable(file.getPath(), ContentManager.ContentType.IMAGE)) {
                            this.val$fileChooser.setCursor(Cursor.getPredefinedCursor(3));
                            this.val$selectedImageFile.set(file);
                            this.val$previewImageLoader.execute(new Runnable(){

                                @Override
                                public void run() {
                                    BufferedImage bufferedImage;
                                    BufferedImage bufferedImage2 = null;
                                    try {
                                        if (val$selectedImageFile.get() == file) {
                                            bufferedImage2 = ImageIO.read(file);
                                        }
                                        bufferedImage = bufferedImage2;
                                    }
                                    catch (IOException iOException) {
                                        BufferedImage bufferedImage3 = bufferedImage2;
                                        EventQueue.invokeLater(new Runnable(){
                                            final /* synthetic */ BufferedImage val$previewedImage;
                                            {
                                                this.val$previewedImage = bufferedImage;
                                            }

                                            @Override
                                            public void run() {
                                                if (val$selectedImageFile.get() == file) {
                                                    val$previewLabel.setImage(this.val$previewedImage);
                                                    val$fileChooser.setCursor(Cursor.getDefaultCursor());
                                                }
                                            }
                                        });
                                    }
                                    catch (Throwable throwable) {
                                        BufferedImage bufferedImage4 = bufferedImage2;
                                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                        throw throwable;
                                    }
                                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                }
                            });
                        } else {
                            this.val$selectedImageFile.set(null);
                            this.val$fileChooser.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                });
                jFileChooser.addPropertyChangeListener("directoryChanged", new PropertyChangeListener(){
                    final /* synthetic */ ScaledImageComponent val$previewLabel;
                    final /* synthetic */ AtomicReference val$selectedImageFile;
                    final /* synthetic */ JFileChooser val$fileChooser;
                    {
                        this.val$previewLabel = scaledImageComponent;
                        this.val$selectedImageFile = atomicReference;
                        this.val$fileChooser = jFileChooser;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.val$previewLabel.setImage(null);
                        this.val$selectedImageFile.set(null);
                        this.val$fileChooser.setCursor(Cursor.getDefaultCursor());
                    }
                });
                ((JComponent)serializable).addAncestorListener(new AncestorListener(){
                    final /* synthetic */ ExecutorService val$previewImageLoader;
                    {
                        this.val$previewImageLoader = executorService;
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                        this.val$previewImageLoader.shutdownNow();
                    }

                    @Override
                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }
                });
                ((JComponent)serializable).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, OperatingSystem.isMacOSX() ? 0 : 5, 0, OperatingSystem.isMacOSX() ? 5 : 0), BorderFactory.createLineBorder(Color.GRAY)));
                ((JComponent)serializable).setPreferredSize(new Dimension(140, 130));
                jFileChooser.setAccessory((JComponent)serializable);
            }
        }
        if (string == null) {
            string = this.getFileDialogTitle(bl);
        }
        jFileChooser.setDialogTitle(string);
        serializable = this.getLastDirectory(contentType);
        if (serializable != null && ((File)serializable).exists()) {
            if (this.isDirectory(contentType)) {
                jFileChooser.setCurrentDirectory(((File)serializable).getParentFile());
                jFileChooser.setSelectedFile((File)serializable);
            } else {
                jFileChooser.setCurrentDirectory((File)serializable);
            }
        }
        if (bl && string2 != null && (serializable == null || !this.isDirectory(contentType))) {
            jFileChooser.setSelectedFile(new File(string2));
        }
        object = jFileChooser.getAcceptAllFileFilter();
        jFileChooser.addChoosableFileFilter((FileFilter)object);
        for (FileFilter fileFilter : fileFilterArray = this.getFileFilter(contentType)) {
            jFileChooser.addChoosableFileFilter(fileFilter);
        }
        if (fileFilterArray.length == 1) {
            jFileChooser.setFileFilter(fileFilterArray[0]);
        } else {
            jFileChooser.setFileFilter((FileFilter)object);
        }
        int n = this.isDirectory(contentType) ? jFileChooser.showDialog((JComponent)((Object)view), this.preferences.getLocalizedString(FileContentManager.class, "selectFolderButton.text", new Object[0])) : (bl ? jFileChooser.showSaveDialog((JComponent)((Object)view)) : jFileChooser.showOpenDialog((JComponent)((Object)view)));
        if (n == 0) {
            serializable = this.isDirectory(contentType) ? jFileChooser.getSelectedFile() : jFileChooser.getCurrentDirectory();
            this.setLastDirectory(contentType, (File)serializable);
            return jFileChooser.getSelectedFile().toString();
        }
        return null;
    }

    protected String getFileDialogTitle(boolean bl) {
        if (bl) {
            return this.preferences.getLocalizedString(FileContentManager.class, "saveDialog.title", new Object[0]);
        }
        return this.preferences.getLocalizedString(FileContentManager.class, "openDialog.title", new Object[0]);
    }

    protected boolean confirmOverwrite(View view, String string) {
        String string2 = this.preferences.getLocalizedString(FileContentManager.class, "confirmOverwrite.message", string);
        String string3 = this.preferences.getLocalizedString(FileContentManager.class, "confirmOverwrite.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(FileContentManager.class, "confirmOverwrite.overwrite", new Object[0]);
        String string5 = this.preferences.getLocalizedString(FileContentManager.class, "confirmOverwrite.cancel", new Object[0]);
        return SwingTools.showOptionDialog(SwingUtilities.getRootPane((JComponent)((Object)view)), string2, string3, 2, 3, new Object[]{string4, string5}, string5) == 0;
    }

    private static class DirectoryChooser
    extends JFileChooser {
        private Executor fileSystemViewExecutor;
        private JTree directoriesTree;
        private TreeSelectionListener treeSelectionListener;
        private PropertyChangeListener selectedFileListener;
        private Action createDirectoryAction;

        public DirectoryChooser(final UserPreferences userPreferences) {
            this.setFileSelectionMode(1);
            this.fileSystemViewExecutor = Executors.newSingleThreadExecutor();
            this.directoriesTree = new JTree(new DefaultTreeModel(new DirectoryNode()));
            this.directoriesTree.setRootVisible(false);
            this.directoriesTree.setEditable(false);
            this.directoriesTree.getSelectionModel().setSelectionMode(1);
            this.directoriesTree.setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                    DirectoryNode directoryNode = (DirectoryNode)object;
                    File file = (File)directoryNode.getUserObject();
                    super.getTreeCellRendererComponent(jTree, DirectoryChooser.this.getName(file), bl, bl2, bl3, n, bl4);
                    this.setIcon(DirectoryChooser.this.getIcon(file));
                    if (!directoryNode.isWritable()) {
                        this.setForeground(Color.GRAY);
                    }
                    return this;
                }
            });
            this.treeSelectionListener = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    TreePath treePath = DirectoryChooser.this.directoriesTree.getSelectionPath();
                    if (treePath != null) {
                        DirectoryNode directoryNode = (DirectoryNode)treePath.getLastPathComponent();
                        DirectoryChooser.this.setSelectedFile((File)directoryNode.getUserObject());
                    }
                }
            };
            this.directoriesTree.addTreeSelectionListener(this.treeSelectionListener);
            this.selectedFileListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DirectoryChooser.this.showSelectedFile();
                }
            };
            this.addPropertyChangeListener("SelectedFileChangedProperty", this.selectedFileListener);
            this.directoriesTree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                    if (treeExpansionEvent.getPath().isDescendant(DirectoryChooser.this.directoriesTree.getSelectionPath())) {
                        DirectoryChooser.this.removePropertyChangeListener("SelectedFileChangedProperty", DirectoryChooser.this.selectedFileListener);
                        DirectoryChooser.this.directoriesTree.setSelectionPath(treeExpansionEvent.getPath());
                        DirectoryChooser.this.addPropertyChangeListener("SelectedFileChangedProperty", DirectoryChooser.this.selectedFileListener);
                    }
                }

                @Override
                public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                }
            });
            final String string = UIManager.getString("FileChooser.win32.newFolder");
            this.createDirectoryAction = new AbstractAction(string){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string4;
                    String string2 = string4 = OperatingSystem.isWindows() || OperatingSystem.isMacOSX() ? string : UIManager.getString("FileChooser.other.newFolder");
                    DirectoryNode directoryNode = (DirectoryNode)DirectoryChooser.this.directoriesTree.getLastSelectedPathComponent();
                    File file = (File)directoryNode.getUserObject();
                    int n = 2;
                    while (new File(file, string2).exists()) {
                        string2 = string4;
                        if (OperatingSystem.isWindows() || OperatingSystem.isMacOSX()) {
                            string2 = string2 + " ";
                        }
                        string2 = string2 + n;
                        ++n;
                    }
                    string2 = (String)JOptionPane.showInputDialog(DirectoryChooser.this, userPreferences.getLocalizedString(FileContentManager.class, "createFolder.message", new Object[0]), string, 3, null, null, string2);
                    if (string2 != null) {
                        File file2 = new File(file, string2);
                        if (!file2.mkdir()) {
                            String string3 = UIManager.getString("FileChooser.newFolderErrorText");
                            SwingTools.showMessageDialog(DirectoryChooser.this, string3, string3, 0);
                        } else {
                            directoryNode.updateChildren(directoryNode.getChildDirectories());
                            ((DefaultTreeModel)DirectoryChooser.this.directoriesTree.getModel()).nodeStructureChanged(directoryNode);
                            DirectoryChooser.this.setSelectedFile(file2);
                        }
                    }
                }
            };
            this.setSelectedFile(this.getFileSystemView().getHomeDirectory());
        }

        @Override
        public void setSelectedFile(File file) {
            if (file != null && file.isFile()) {
                file = file.getParentFile();
            }
            super.setSelectedFile(file);
        }

        private void showSelectedFile() {
            final File file = this.getSelectedFile();
            if (file != null) {
                final DirectoryNode directoryNode = (DirectoryNode)this.directoriesTree.getModel().getRoot();
                this.fileSystemViewExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block8: {
                            try {
                                EventQueue.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        DirectoryChooser.this.createDirectoryAction.setEnabled(false);
                                        if (DirectoryChooser.this.directoriesTree.isShowing()) {
                                            DirectoryChooser.this.directoriesTree.setCursor(Cursor.getPredefinedCursor(3));
                                        }
                                    }
                                });
                                File file3 = file.getCanonicalFile();
                                ArrayList<File> arrayList = new ArrayList<File>();
                                Serializable serializable = file3;
                                while (serializable != null) {
                                    arrayList.add(0, (File)serializable);
                                    serializable = DirectoryChooser.this.getFileSystemView().getParentDirectory((File)serializable);
                                }
                                serializable = new ArrayList();
                                DirectoryNode directoryNode3 = directoryNode;
                                serializable.add(directoryNode3);
                                for (final File file2 : arrayList) {
                                    final File[] fileArray = directoryNode3.isLoaded() ? null : directoryNode3.getChildDirectories();
                                    final DirectoryNode directoryNode2 = directoryNode3;
                                    EventQueue.invokeAndWait(new Runnable(){
                                        final /* synthetic */ List val$pathToFileNode;
                                        {
                                            this.val$pathToFileNode = list;
                                        }

                                        @Override
                                        public void run() {
                                            if (!directoryNode2.isLoaded()) {
                                                directoryNode2.updateChildren(fileArray);
                                                ((DefaultTreeModel)DirectoryChooser.this.directoriesTree.getModel()).nodeStructureChanged(directoryNode2);
                                            }
                                            int n = directoryNode2.getChildCount();
                                            for (int i = 0; i < n; ++i) {
                                                DirectoryNode directoryNode = (DirectoryNode)directoryNode2.getChildAt(i);
                                                if (!file2.equals(directoryNode.getUserObject())) continue;
                                                this.val$pathToFileNode.add(directoryNode);
                                                break;
                                            }
                                        }
                                    });
                                    directoryNode3 = (DirectoryNode)serializable.get(serializable.size() - 1);
                                    if (directoryNode2 != directoryNode3) continue;
                                    break;
                                }
                                if (serializable.size() <= 1) break block8;
                                final TreePath treePath = new TreePath(serializable.toArray(new TreeNode[serializable.size()]));
                                EventQueue.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        DirectoryChooser.this.directoriesTree.removeTreeSelectionListener(DirectoryChooser.this.treeSelectionListener);
                                        DirectoryChooser.this.directoriesTree.expandPath(treePath);
                                        DirectoryChooser.this.directoriesTree.setSelectionPath(treePath);
                                        DirectoryChooser.this.directoriesTree.scrollRowToVisible(DirectoryChooser.this.directoriesTree.getRowForPath(treePath));
                                        DirectoryChooser.this.directoriesTree.addTreeSelectionListener(DirectoryChooser.this.treeSelectionListener);
                                    }
                                });
                            }
                            catch (IOException iOException) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DirectoryChooser.this.createDirectoryAction.setEnabled(DirectoryChooser.this.directoriesTree.getSelectionCount() > 0 && ((DirectoryNode)DirectoryChooser.this.directoriesTree.getSelectionPath().getLastPathComponent()).isWritable());
                                        DirectoryChooser.this.directoriesTree.setCursor(Cursor.getDefaultCursor());
                                    }
                                });
                            }
                            catch (InterruptedException interruptedException) {
                                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                try {
                                    invocationTargetException.printStackTrace();
                                }
                                catch (Throwable throwable) {
                                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    throw throwable;
                                }
                                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                        }
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
            }
        }

        @Override
        public int showDialog(Component component, final String string) {
            JButton jButton = new JButton(this.createDirectoryAction);
            final JButton jButton2 = new JButton(string);
            Object object = UIManager.get("FileChooser.cancelButtonText");
            Object[] objectArray = OperatingSystem.isMacOSX() ? new Object[]{jButton2, object, jButton} : new Object[]{jButton, jButton2, object};
            final JOptionPane jOptionPane = new JOptionPane(SwingTools.createScrollPane(this.directoriesTree), -1, -1, null, objectArray, jButton2);
            final JDialog jDialog = jOptionPane.createDialog(SwingUtilities.getRootPane(component), this.getDialogTitle());
            jDialog.setResizable(true);
            jDialog.pack();
            if (this.directoriesTree.getSelectionCount() > 0) {
                this.directoriesTree.scrollPathToVisible(this.directoriesTree.getSelectionPath());
                boolean bl = ((DirectoryNode)this.directoriesTree.getSelectionPath().getLastPathComponent()).isWritable();
                jButton2.setEnabled(bl);
                this.createDirectoryAction.setEnabled(bl);
            }
            this.directoriesTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    TreePath treePath = treeSelectionEvent.getPath();
                    boolean bl = treePath != null && ((DirectoryNode)treeSelectionEvent.getPath().getLastPathComponent()).isWritable();
                    jButton2.setEnabled(bl);
                    DirectoryChooser.this.createDirectoryAction.setEnabled(bl);
                }
            });
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jOptionPane.setValue(string);
                    jDialog.setVisible(false);
                }
            });
            jDialog.setMinimumSize(jDialog.getPreferredSize());
            jDialog.setVisible(true);
            jDialog.dispose();
            if (string.equals(jOptionPane.getValue())) {
                return 0;
            }
            return 1;
        }

        private class DirectoryNode
        extends DefaultMutableTreeNode {
            private boolean loaded;
            private boolean writable;

            private DirectoryNode() {
                super(null);
            }

            private DirectoryNode(File file) {
                super(file);
                this.writable = file.canWrite();
            }

            public boolean isWritable() {
                return this.writable;
            }

            @Override
            public int getChildCount() {
                if (!this.loaded) {
                    this.loaded = true;
                    return this.updateChildren(this.getChildDirectories());
                }
                return super.getChildCount();
            }

            public File[] getChildDirectories() {
                File[] fileArray;
                File[] fileArray2 = fileArray = this.getUserObject() == null ? DirectoryChooser.this.getFileSystemView().getRoots() : DirectoryChooser.this.getFileSystemView().getFiles((File)this.getUserObject(), true);
                if (fileArray != null) {
                    ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
                    for (File file : fileArray) {
                        if (!DirectoryChooser.this.isTraversable(file)) continue;
                        arrayList.add(file);
                    }
                    return arrayList.toArray(new File[arrayList.size()]);
                }
                return new File[0];
            }

            public boolean isLoaded() {
                return this.loaded;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int updateChildren(File[] fileArray) {
                if (this.children == null) {
                    this.children = new Vector(fileArray.length);
                }
                Vector vector = this.children;
                synchronized (vector) {
                    this.removeAllChildren();
                    for (File file : fileArray) {
                        this.add(new DirectoryNode(file));
                    }
                    return fileArray.length;
                }
            }
        }
    }
}

