// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32wb55.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32wb55
// +build stm32,stm32wb55

// STM32WBxx_CM4
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32WB55"
	CPU          = "CM4"
	FPUPresent   = true
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// System window watchdog
	IRQ_WWDG = 0

	// External interrupt/event controller
	IRQ_PVD = 1

	// Real-time clock
	IRQ_RTC_TAMP = 2

	// Real-time clock
	IRQ_RTC_WKUP = 3

	// Flash
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	// Direct memory access controller
	IRQ_DMA1_Channel1 = 11

	// Direct memory access controller
	IRQ_DMA1_Channel2 = 12

	// Direct memory access controller
	IRQ_DMA1_Channel3 = 13

	// Direct memory access controller
	IRQ_DMA1_Channel4 = 14

	// Direct memory access controller
	IRQ_DMA1_Channel5 = 15

	// Direct memory access controller
	IRQ_DMA1_Channel6 = 16

	// Direct memory access controller
	IRQ_DMA1_Channel7 = 17

	// Analog to Digital Converter instance 1
	IRQ_ADC1 = 18

	// Universal serial bus full-speed device interface
	IRQ_USB_HP = 19

	// Universal serial bus full-speed device interface
	IRQ_USB_LP = 20

	// External interrupt/event controller
	IRQ_C2SEV = 21

	// Comparator instance 1
	IRQ_COMP = 22

	// External interrupt/event controller
	IRQ_EXTI5_9 = 23

	// Advanced-timers
	IRQ_TIM1_BRK = 24

	// Advanced-timers
	IRQ_TIM1_UP = 25

	// Advanced-timers
	IRQ_TIM1_TRG_COM_TIM17 = 26

	// Advanced-timers
	IRQ_TIM1_CC = 27

	// General-purpose-timers
	IRQ_TIM2 = 28

	// PKA
	IRQ_PKA = 29

	// Inter-integrated circuit
	IRQ_I2C1_EV = 30

	// Inter-integrated circuit
	IRQ_I2C1_ER = 31

	IRQ_I2C3_EV = 32

	IRQ_I2C3_ER = 33

	// Serial peripheral interface/Inter-IC sound
	IRQ_SPI1 = 34

	IRQ_SPI2 = 35

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 36

	IRQ_LPUART1 = 37

	// Serial audio interface
	IRQ_SAI1 = 38

	// Touch sensing controller
	IRQ_TSC = 39

	// External interrupt/event controller
	IRQ_EXTI10_15 = 40

	// Real-time clock
	IRQ_RTC_ALARM = 41

	// Clock recovery system
	IRQ_CRS_IT = 42

	// Power control
	IRQ_PWR_SOTF = 43

	// IPCC
	IRQ_IPCC_C1_RX_IT = 44

	// IPCC
	IRQ_IPCC_C1_TX_IT = 45

	// HSEM
	IRQ_HSEM = 46

	// Low power timer
	IRQ_LPTIM1 = 47

	IRQ_LPTIM2 = 48

	// Liquid crystal display controller
	IRQ_LCD = 49

	// QuadSPI interface
	IRQ_QUADSPI = 50

	// Advanced encryption standard hardware accelerator 1
	IRQ_AES1 = 51

	// Advanced encryption standard hardware accelerator 1
	IRQ_AES2 = 52

	// Random number generator
	IRQ_True_RNG = 53

	// Floting point unit
	IRQ_FPU = 54

	// Direct memory access controller
	IRQ_DMA2_CH1 = 55

	// Direct memory access controller
	IRQ_DMA2_CH2 = 56

	// Direct memory access controller
	IRQ_DMA2_CH3 = 57

	// Direct memory access controller
	IRQ_DMA2_CH4 = 58

	// Direct memory access controller
	IRQ_DMA2_CH5 = 59

	// Direct memory access controller
	IRQ_DMA2_CH6 = 60

	// Direct memory access controller
	IRQ_DMA2_CH7 = 61

	// Direct memory access Multiplexer
	IRQ_DMAMUX_OVR = 62

	// Highest interrupt number on this device.
	IRQ_max = 62
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG, "WWDG_IRQHandler")
	_ = interrupt.Register(IRQ_PVD, "PVD_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_TAMP, "RTC_TAMP_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_WKUP, "RTC_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0, "EXTI0_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI1, "EXTI1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2, "EXTI2_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI3, "EXTI3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4, "EXTI4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel1, "DMA1_Channel1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel2, "DMA1_Channel2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel3, "DMA1_Channel3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel4, "DMA1_Channel4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel5, "DMA1_Channel5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel6, "DMA1_Channel6_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel7, "DMA1_Channel7_IRQHandler")
	_ = interrupt.Register(IRQ_ADC1, "ADC1_IRQHandler")
	_ = interrupt.Register(IRQ_USB_HP, "USB_HP_IRQHandler")
	_ = interrupt.Register(IRQ_USB_LP, "USB_LP_IRQHandler")
	_ = interrupt.Register(IRQ_C2SEV, "C2SEV_IRQHandler")
	_ = interrupt.Register(IRQ_COMP, "COMP_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI5_9, "EXTI5_9_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK, "TIM1_BRK_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_UP, "TIM1_UP_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_TRG_COM_TIM17, "TIM1_TRG_COM_TIM17_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC, "TIM1_CC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_PKA, "PKA_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_EV, "I2C1_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_ER, "I2C1_ER_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_EV, "I2C3_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_ER, "I2C3_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_LPUART1, "LPUART1_IRQHandler")
	_ = interrupt.Register(IRQ_SAI1, "SAI1_IRQHandler")
	_ = interrupt.Register(IRQ_TSC, "TSC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI10_15, "EXTI10_15_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_ALARM, "RTC_ALARM_IRQHandler")
	_ = interrupt.Register(IRQ_CRS_IT, "CRS_IT_IRQHandler")
	_ = interrupt.Register(IRQ_PWR_SOTF, "PWR_SOTF_IRQHandler")
	_ = interrupt.Register(IRQ_IPCC_C1_RX_IT, "IPCC_C1_RX_IT_IRQHandler")
	_ = interrupt.Register(IRQ_IPCC_C1_TX_IT, "IPCC_C1_TX_IT_IRQHandler")
	_ = interrupt.Register(IRQ_HSEM, "HSEM_IRQHandler")
	_ = interrupt.Register(IRQ_LPTIM1, "LPTIM1_IRQHandler")
	_ = interrupt.Register(IRQ_LPTIM2, "LPTIM2_IRQHandler")
	_ = interrupt.Register(IRQ_LCD, "LCD_IRQHandler")
	_ = interrupt.Register(IRQ_QUADSPI, "QUADSPI_IRQHandler")
	_ = interrupt.Register(IRQ_AES1, "AES1_IRQHandler")
	_ = interrupt.Register(IRQ_AES2, "AES2_IRQHandler")
	_ = interrupt.Register(IRQ_True_RNG, "True_RNG_IRQHandler")
	_ = interrupt.Register(IRQ_FPU, "FPU_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH1, "DMA2_CH1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH2, "DMA2_CH2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH3, "DMA2_CH3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH4, "DMA2_CH4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH5, "DMA2_CH5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH6, "DMA2_CH6_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH7, "DMA2_CH7_IRQHandler")
	_ = interrupt.Register(IRQ_DMAMUX_OVR, "DMAMUX_OVR_IRQHandler")
)

// Peripherals.
var (
	// Direct memory access controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Direct memory access controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// Direct memory access Multiplexer
	DMAMUX1 = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Liquid crystal display controller
	LCD = (*LCD_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Touch sensing controller
	TSC = (*TSC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Comparator instance 1
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40010200)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Flash
	Flash = (*Flash_Type)(unsafe.Pointer(uintptr(0x58004000)))

	// QuadSPI interface
	QUADSPI = (*QUADSPI_Type)(unsafe.Pointer(uintptr(0xa0001000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x58000000)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x58000400)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010100)))

	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x58001000)))

	// Advanced encryption standard hardware accelerator 1
	AES1 = (*AES1_Type)(unsafe.Pointer(uintptr(0x50060000)))

	// Advanced encryption standard hardware accelerator 1
	AES2 = (*AES1_Type)(unsafe.Pointer(uintptr(0x58001800)))

	// HSEM
	HSEM = (*Hardware_Semaphore_Type)(unsafe.Pointer(uintptr(0x58001400)))

	// Analog to Digital Converter instance 1
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040000)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000400)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000800)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001000)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001c00)))

	// Serial audio interface
	SAI1 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015400)))

	// General-purpose-timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General purpose timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// General purpose timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Serial peripheral interface/Inter-IC sound
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Voltage reference buffer
	VREFBUF = (*VREF_Type)(unsafe.Pointer(uintptr(0x40010030)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Debug support
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// PKA
	PKA = (*PKA_Type)(unsafe.Pointer(uintptr(0x58002000)))

	// IPCC
	IPCC = (*IPCC_Type)(unsafe.Pointer(uintptr(0x58000c00)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x58000800)))

	// Clock recovery system
	CRS = (*CRS_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Universal serial bus full-speed device interface
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x40006800)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000c00)))

	// Low power timer
	LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009400)))

	// Universal synchronous asynchronous receiver transmitter
	LPUART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Serial peripheral interface/Inter-IC sound
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))
)

// Direct memory access controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
}

// Direct memory access Multiplexer
type DMAMUX_Type struct {
	C0CR  volatile.Register32 // 0x0
	C1CR  volatile.Register32 // 0x4
	C2CR  volatile.Register32 // 0x8
	C3CR  volatile.Register32 // 0xC
	C4CR  volatile.Register32 // 0x10
	C5CR  volatile.Register32 // 0x14
	C6CR  volatile.Register32 // 0x18
	C7CR  volatile.Register32 // 0x1C
	C8CR  volatile.Register32 // 0x20
	C9CR  volatile.Register32 // 0x24
	C10CR volatile.Register32 // 0x28
	C11CR volatile.Register32 // 0x2C
	C12CR volatile.Register32 // 0x30
	C13CR volatile.Register32 // 0x34
	_     [72]byte
	CSR   volatile.Register32 // 0x80
	CFR   volatile.Register32 // 0x84
	_     [120]byte
	RG0CR volatile.Register32 // 0x100
	RG1CR volatile.Register32 // 0x104
	RG2CR volatile.Register32 // 0x108
	RG3CR volatile.Register32 // 0x10C
	_     [48]byte
	RGSR  volatile.Register32 // 0x140
	RGCFR volatile.Register32 // 0x144
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// Liquid crystal display controller
type LCD_Type struct {
	CR       volatile.Register32 // 0x0
	FCR      volatile.Register32 // 0x4
	SR       volatile.Register32 // 0x8
	CLR      volatile.Register32 // 0xC
	_        [4]byte
	RAM_COM0 volatile.Register32 // 0x14
	_        [4]byte
	RAM_COM1 volatile.Register32 // 0x1C
	_        [4]byte
	RAM_COM2 volatile.Register32 // 0x24
	_        [4]byte
	RAM_COM3 volatile.Register32 // 0x2C
	_        [4]byte
	RAM_COM4 volatile.Register32 // 0x34
	_        [4]byte
	RAM_COM5 volatile.Register32 // 0x3C
	_        [4]byte
	RAM_COM6 volatile.Register32 // 0x44
	_        [4]byte
	RAM_COM7 volatile.Register32 // 0x4C
}

// Touch sensing controller
type TSC_Type struct {
	CR     volatile.Register32 // 0x0
	IER    volatile.Register32 // 0x4
	ICR    volatile.Register32 // 0x8
	ISR    volatile.Register32 // 0xC
	IOHCR  volatile.Register32 // 0x10
	_      [4]byte
	IOASCR volatile.Register32 // 0x18
	_      [4]byte
	IOSCR  volatile.Register32 // 0x20
	_      [4]byte
	IOCCR  volatile.Register32 // 0x28
	_      [4]byte
	IOGCSR volatile.Register32 // 0x30
	IOG1CR volatile.Register32 // 0x34
	IOG2CR volatile.Register32 // 0x38
	IOG3CR volatile.Register32 // 0x3C
	IOG4CR volatile.Register32 // 0x40
	IOG5CR volatile.Register32 // 0x44
	IOG6CR volatile.Register32 // 0x48
	IOG7CR volatile.Register32 // 0x4C
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Comparator instance 1
type COMP_Type struct {
	COMP1_CSR volatile.Register32 // 0x0
	COMP2_CSR volatile.Register32 // 0x4
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Flash
type Flash_Type struct {
	ACR       volatile.Register32 // 0x0
	_         [4]byte
	KEYR      volatile.Register32 // 0x8
	OPTKEYR   volatile.Register32 // 0xC
	SR        volatile.Register32 // 0x10
	CR        volatile.Register32 // 0x14
	ECCR      volatile.Register32 // 0x18
	_         [4]byte
	OPTR      volatile.Register32 // 0x20
	PCROP1ASR volatile.Register32 // 0x24
	PCROP1AER volatile.Register32 // 0x28
	WRP1AR    volatile.Register32 // 0x2C
	WRP1BR    volatile.Register32 // 0x30
	PCROP1BSR volatile.Register32 // 0x34
	PCROP1BER volatile.Register32 // 0x38
	IPCCBR    volatile.Register32 // 0x3C
	_         [28]byte
	C2ACR     volatile.Register32 // 0x5C
	C2SR      volatile.Register32 // 0x60
	C2CR      volatile.Register32 // 0x64
	_         [24]byte
	SFR       volatile.Register32 // 0x80
	SRRVR     volatile.Register32 // 0x84
}

// QuadSPI interface
type QUADSPI_Type struct {
	CR    volatile.Register32 // 0x0
	DCR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	FCR   volatile.Register32 // 0xC
	DLR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	AR    volatile.Register32 // 0x18
	ABR   volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
	PSMKR volatile.Register32 // 0x24
	PSMAR volatile.Register32 // 0x28
	PIR   volatile.Register32 // 0x2C
	LPTR  volatile.Register32 // 0x30
}

// Reset and clock control
type RCC_Type struct {
	CR           volatile.Register32 // 0x0
	ICSCR        volatile.Register32 // 0x4
	CFGR         volatile.Register32 // 0x8
	PLLCFGR      volatile.Register32 // 0xC
	PLLSAI1CFGR  volatile.Register32 // 0x10
	_            [4]byte
	CIER         volatile.Register32 // 0x18
	CIFR         volatile.Register32 // 0x1C
	CICR         volatile.Register32 // 0x20
	SMPSCR       volatile.Register32 // 0x24
	AHB1RSTR     volatile.Register32 // 0x28
	AHB2RSTR     volatile.Register32 // 0x2C
	AHB3RSTR     volatile.Register32 // 0x30
	_            [4]byte
	APB1RSTR1    volatile.Register32 // 0x38
	APB1RSTR2    volatile.Register32 // 0x3C
	APB2RSTR     volatile.Register32 // 0x40
	APB3RSTR     volatile.Register32 // 0x44
	AHB1ENR      volatile.Register32 // 0x48
	AHB2ENR      volatile.Register32 // 0x4C
	AHB3ENR      volatile.Register32 // 0x50
	_            [4]byte
	APB1ENR1     volatile.Register32 // 0x58
	APB1ENR2     volatile.Register32 // 0x5C
	APB2ENR      volatile.Register32 // 0x60
	_            [4]byte
	AHB1SMENR    volatile.Register32 // 0x68
	AHB2SMENR    volatile.Register32 // 0x6C
	AHB3SMENR    volatile.Register32 // 0x70
	_            [4]byte
	APB1SMENR1   volatile.Register32 // 0x78
	APB1SMENR2   volatile.Register32 // 0x7C
	APB2SMENR    volatile.Register32 // 0x80
	_            [4]byte
	CCIPR        volatile.Register32 // 0x88
	_            [4]byte
	BDCR         volatile.Register32 // 0x90
	CSR          volatile.Register32 // 0x94
	CRRCR        volatile.Register32 // 0x98
	HSECR        volatile.Register32 // 0x9C
	_            [104]byte
	EXTCFGR      volatile.Register32 // 0x108
	_            [60]byte
	C2AHB1ENR    volatile.Register32 // 0x148
	C2AHB2ENR    volatile.Register32 // 0x14C
	C2AHB3ENR    volatile.Register32 // 0x150
	_            [4]byte
	C2APB1ENR1   volatile.Register32 // 0x158
	C2APB1ENR2   volatile.Register32 // 0x15C
	C2APB2ENR    volatile.Register32 // 0x160
	C2APB3ENR    volatile.Register32 // 0x164
	C2AHB1SMENR  volatile.Register32 // 0x168
	C2AHB2SMENR  volatile.Register32 // 0x16C
	C2AHB3SMENR  volatile.Register32 // 0x170
	_            [4]byte
	C2APB1SMENR1 volatile.Register32 // 0x178
	C2APB1SMENR2 volatile.Register32 // 0x17C
	C2APB2SMENR  volatile.Register32 // 0x180
	C2APB3SMENR  volatile.Register32 // 0x184
}

// Power control
type PWR_Type struct {
	CR1    volatile.Register32 // 0x0
	CR2    volatile.Register32 // 0x4
	CR3    volatile.Register32 // 0x8
	CR4    volatile.Register32 // 0xC
	SR1    volatile.Register32 // 0x10
	SR2    volatile.Register32 // 0x14
	SCR    volatile.Register32 // 0x18
	CR5    volatile.Register32 // 0x1C
	PUCRA  volatile.Register32 // 0x20
	PDCRA  volatile.Register32 // 0x24
	PUCRB  volatile.Register32 // 0x28
	PDCRB  volatile.Register32 // 0x2C
	PUCRC  volatile.Register32 // 0x30
	PDCRC  volatile.Register32 // 0x34
	PUCRD  volatile.Register32 // 0x38
	PDCRD  volatile.Register32 // 0x3C
	PUCRE  volatile.Register32 // 0x40
	PDCRE  volatile.Register32 // 0x44
	_      [16]byte
	PUCRH  volatile.Register32 // 0x58
	PDCRH  volatile.Register32 // 0x5C
	_      [32]byte
	C2CR1  volatile.Register32 // 0x80
	C2CR3  volatile.Register32 // 0x84
	EXTSCR volatile.Register32 // 0x88
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRMP  volatile.Register32 // 0x0
	CFGR1   volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	SCSR    volatile.Register32 // 0x18
	CFGR2   volatile.Register32 // 0x1C
	SWPR    volatile.Register32 // 0x20
	SKR     volatile.Register32 // 0x24
	SWPR2   volatile.Register32 // 0x28
	IMR1    volatile.Register32 // 0x2C
	IMR2    volatile.Register32 // 0x30
	C2IMR1  volatile.Register32 // 0x34
	C2IMR2  volatile.Register32 // 0x38
	SIPCR   volatile.Register32 // 0x3C
}

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// Advanced encryption standard hardware accelerator 1
type AES1_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	DINR   volatile.Register32 // 0x8
	DOUTR  volatile.Register32 // 0xC
	KEYR0  volatile.Register32 // 0x10
	KEYR1  volatile.Register32 // 0x14
	KEYR2  volatile.Register32 // 0x18
	KEYR3  volatile.Register32 // 0x1C
	IVR0   volatile.Register32 // 0x20
	IVR1   volatile.Register32 // 0x24
	IVR2   volatile.Register32 // 0x28
	IVR3   volatile.Register32 // 0x2C
	KEYR4  volatile.Register32 // 0x30
	KEYR5  volatile.Register32 // 0x34
	KEYR6  volatile.Register32 // 0x38
	KEYR7  volatile.Register32 // 0x3C
	SUSP0R volatile.Register32 // 0x40
	SUSP1R volatile.Register32 // 0x44
	SUSP2R volatile.Register32 // 0x48
	SUSP3R volatile.Register32 // 0x4C
	SUSP4R volatile.Register32 // 0x50
	SUSP5R volatile.Register32 // 0x54
	SUSP6R volatile.Register32 // 0x58
	SUSP7R volatile.Register32 // 0x5C
	_      [912]byte
	HWCFR  volatile.Register32 // 0x3F0
	VERR   volatile.Register32 // 0x3F4
	IPIDR  volatile.Register32 // 0x3F8
	SIDR   volatile.Register32 // 0x3FC
}

// HSEM
type Hardware_Semaphore_Type struct {
	R0      volatile.Register32 // 0x0
	R1      volatile.Register32 // 0x4
	R2      volatile.Register32 // 0x8
	R3      volatile.Register32 // 0xC
	R4      volatile.Register32 // 0x10
	R5      volatile.Register32 // 0x14
	R6      volatile.Register32 // 0x18
	R7      volatile.Register32 // 0x1C
	R8      volatile.Register32 // 0x20
	R9      volatile.Register32 // 0x24
	R10     volatile.Register32 // 0x28
	R11     volatile.Register32 // 0x2C
	R12     volatile.Register32 // 0x30
	R13     volatile.Register32 // 0x34
	R14     volatile.Register32 // 0x38
	R15     volatile.Register32 // 0x3C
	R16     volatile.Register32 // 0x40
	R17     volatile.Register32 // 0x44
	R18     volatile.Register32 // 0x48
	R19     volatile.Register32 // 0x4C
	R20     volatile.Register32 // 0x50
	R21     volatile.Register32 // 0x54
	R22     volatile.Register32 // 0x58
	R23     volatile.Register32 // 0x5C
	R24     volatile.Register32 // 0x60
	R25     volatile.Register32 // 0x64
	R26     volatile.Register32 // 0x68
	R27     volatile.Register32 // 0x6C
	R28     volatile.Register32 // 0x70
	R29     volatile.Register32 // 0x74
	R30     volatile.Register32 // 0x78
	R31     volatile.Register32 // 0x7C
	RLR0    volatile.Register32 // 0x80
	RLR1    volatile.Register32 // 0x84
	RLR2    volatile.Register32 // 0x88
	RLR3    volatile.Register32 // 0x8C
	RLR4    volatile.Register32 // 0x90
	RLR5    volatile.Register32 // 0x94
	RLR6    volatile.Register32 // 0x98
	RLR7    volatile.Register32 // 0x9C
	RLR8    volatile.Register32 // 0xA0
	RLR9    volatile.Register32 // 0xA4
	RLR10   volatile.Register32 // 0xA8
	RLR11   volatile.Register32 // 0xAC
	RLR12   volatile.Register32 // 0xB0
	RLR13   volatile.Register32 // 0xB4
	RLR14   volatile.Register32 // 0xB8
	RLR15   volatile.Register32 // 0xBC
	RLR16   volatile.Register32 // 0xC0
	RLR17   volatile.Register32 // 0xC4
	RLR18   volatile.Register32 // 0xC8
	RLR19   volatile.Register32 // 0xCC
	RLR20   volatile.Register32 // 0xD0
	RLR21   volatile.Register32 // 0xD4
	RLR22   volatile.Register32 // 0xD8
	RLR23   volatile.Register32 // 0xDC
	RLR24   volatile.Register32 // 0xE0
	RLR25   volatile.Register32 // 0xE4
	RLR26   volatile.Register32 // 0xE8
	RLR27   volatile.Register32 // 0xEC
	RLR28   volatile.Register32 // 0xF0
	RLR29   volatile.Register32 // 0xF4
	RLR30   volatile.Register32 // 0xF8
	RLR31   volatile.Register32 // 0xFC
	C1IER0  volatile.Register32 // 0x100
	C1ICR   volatile.Register32 // 0x104
	C1ISR   volatile.Register32 // 0x108
	C1MISR  volatile.Register32 // 0x10C
	C2IER0  volatile.Register32 // 0x110
	C2ICR   volatile.Register32 // 0x114
	C2ISR   volatile.Register32 // 0x118
	C2MISR  volatile.Register32 // 0x11C
	_       [32]byte
	CR      volatile.Register32 // 0x140
	KEYR    volatile.Register32 // 0x144
	_       [676]byte
	HWCFGR2 volatile.Register32 // 0x3EC
	HWCFGR1 volatile.Register32 // 0x3F0
	VERR    volatile.Register32 // 0x3F4
	IPIDR   volatile.Register32 // 0x3F8
	SIDR    volatile.Register32 // 0x3FC
}

// Analog to Digital Converter instance 1
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR    volatile.Register32 // 0xC
	CFGR2   volatile.Register32 // 0x10
	SMPR1   volatile.Register32 // 0x14
	SMPR2   volatile.Register32 // 0x18
	_       [4]byte
	TR1     volatile.Register32 // 0x20
	TR2     volatile.Register32 // 0x24
	TR3     volatile.Register32 // 0x28
	_       [4]byte
	SQR1    volatile.Register32 // 0x30
	SQR2    volatile.Register32 // 0x34
	SQR3    volatile.Register32 // 0x38
	SQR4    volatile.Register32 // 0x3C
	DR      volatile.Register32 // 0x40
	_       [8]byte
	JSQR    volatile.Register32 // 0x4C
	_       [16]byte
	OFR1    volatile.Register32 // 0x60
	OFR2    volatile.Register32 // 0x64
	OFR3    volatile.Register32 // 0x68
	OFR4    volatile.Register32 // 0x6C
	_       [16]byte
	JDR1    volatile.Register32 // 0x80
	JDR2    volatile.Register32 // 0x84
	JDR3    volatile.Register32 // 0x88
	JDR4    volatile.Register32 // 0x8C
	_       [16]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [8]byte
	DIFSEL  volatile.Register32 // 0xB0
	CALFACT volatile.Register32 // 0xB4
	_       [592]byte
	CCR     volatile.Register32 // 0x308
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// Serial audio interface
type SAI_Type struct {
	GCR volatile.Register32 // 0x0
	CH  [2]struct {
		CR1   volatile.Register32
		CR2   volatile.Register32
		FRCR  volatile.Register32
		SLOTR volatile.Register32
		IM    volatile.Register32
		SR    volatile.Register32
		CLRFR volatile.Register32
		DR    volatile.Register32
	} // 0x4
	PDMCR  volatile.Register32 // 0x44
	PDMDLY volatile.Register32 // 0x48
}

// General-purpose-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	_            [4]byte
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	_            [4]byte
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	OR           volatile.Register32 // 0x50
	_            [12]byte
	AF           volatile.Register32 // 0x60
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
	OR   volatile.Register32 // 0x20
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	BRR   volatile.Register32 // 0xC
	GTPR  volatile.Register32 // 0x10
	RTOR  volatile.Register32 // 0x14
	RQR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	ICR   volatile.Register32 // 0x20
	RDR   volatile.Register32 // 0x24
	TDR   volatile.Register32 // 0x28
	PRESC volatile.Register32 // 0x2C
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1    volatile.Register32 // 0x0
	CR2    volatile.Register32 // 0x4
	SR     volatile.Register32 // 0x8
	DR     volatile.Register32 // 0xC
	CRCPR  volatile.Register32 // 0x10
	RXCRCR volatile.Register32 // 0x14
	TXCRCR volatile.Register32 // 0x18
}

// Voltage reference buffer
type VREF_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAMPCR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	OR       volatile.Register32 // 0x4C
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
}

// Debug support
type DBGMCU_Type struct {
	IDCODE      volatile.Register32 // 0x0
	CR          volatile.Register32 // 0x4
	_           [52]byte
	APB1FZR1    volatile.Register32 // 0x3C
	C2AP_B1FZR1 volatile.Register32 // 0x40
	APB1FZR2    volatile.Register32 // 0x44
	C2APB1FZR2  volatile.Register32 // 0x48
	APB2FZR     volatile.Register32 // 0x4C
}

// PKA
type PKA_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	CLRFR volatile.Register32 // 0x8
	_     [8168]byte
	VERR  volatile.Register32 // 0x1FF4
	IPIDR volatile.Register32 // 0x1FF8
	SIDR  volatile.Register32 // 0x1FFC
}

// IPCC
type IPCC_Type struct {
	C1CR     volatile.Register32 // 0x0
	C1MR     volatile.Register32 // 0x4
	C1SCR    volatile.Register32 // 0x8
	C1TO2SR  volatile.Register32 // 0xC
	C2CR     volatile.Register32 // 0x10
	C2MR     volatile.Register32 // 0x14
	C2SCR    volatile.Register32 // 0x18
	C2TOC1SR volatile.Register32 // 0x1C
	_        [976]byte
	HWCFGR   volatile.Register32 // 0x3F0
	VERR     volatile.Register32 // 0x3F4
	IPIDR    volatile.Register32 // 0x3F8
	SIDR     volatile.Register32 // 0x3FC
}

// External interrupt/event controller
type EXTI_Type struct {
	RTSR1   volatile.Register32 // 0x0
	FTSR1   volatile.Register32 // 0x4
	SWIER1  volatile.Register32 // 0x8
	PR1     volatile.Register32 // 0xC
	_       [16]byte
	RTSR2   volatile.Register32 // 0x20
	FTSR2   volatile.Register32 // 0x24
	SWIER2  volatile.Register32 // 0x28
	PR2     volatile.Register32 // 0x2C
	_       [80]byte
	C1IMR1  volatile.Register32 // 0x80
	C1EMR1  volatile.Register32 // 0x84
	_       [8]byte
	C1IMR2  volatile.Register32 // 0x90
	C1EMR2  volatile.Register32 // 0x94
	_       [40]byte
	C2IMR1  volatile.Register32 // 0xC0
	C2EMR1  volatile.Register32 // 0xC4
	_       [8]byte
	C2IMR2  volatile.Register32 // 0xD0
	C2EMR2  volatile.Register32 // 0xD4
	_       [768]byte
	HWCFGR7 volatile.Register32 // 0x3D8
	HWCFGR6 volatile.Register32 // 0x3DC
	HWCFGR5 volatile.Register32 // 0x3E0
	HWCFGR4 volatile.Register32 // 0x3E4
	HWCFGR3 volatile.Register32 // 0x3E8
	HWCFGR2 volatile.Register32 // 0x3EC
	HWCFGR1 volatile.Register32 // 0x3F0
	VERR    volatile.Register32 // 0x3F4
	IPIDR   volatile.Register32 // 0x3F8
	SIDR    volatile.Register32 // 0x3FC
}

// Clock recovery system
type CRS_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	ISR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
}

// Universal serial bus full-speed device interface
type USB_Type struct {
	EP0R      volatile.Register16 // 0x0
	_         [2]byte
	EP1R      volatile.Register16 // 0x4
	_         [2]byte
	EP2R      volatile.Register16 // 0x8
	_         [2]byte
	EP3R      volatile.Register16 // 0xC
	_         [2]byte
	EP4R      volatile.Register16 // 0x10
	_         [2]byte
	EP5R      volatile.Register16 // 0x14
	_         [2]byte
	EP6R      volatile.Register16 // 0x18
	_         [2]byte
	EP7R      volatile.Register16 // 0x1C
	_         [34]byte
	CNTR      volatile.Register16 // 0x40
	_         [2]byte
	ISTR      volatile.Register16 // 0x44
	_         [2]byte
	FNR       volatile.Register16 // 0x48
	_         [2]byte
	DADDR     volatile.Register16 // 0x4C
	_         [2]byte
	BTABLE    volatile.Register16 // 0x50
	COUNT0_TX volatile.Register16 // 0x52
	ADDR0_RX  volatile.Register16 // 0x54
	COUNT0_RX volatile.Register16 // 0x56
	BCDR      volatile.Register16 // 0x58
	COUNT1_TX volatile.Register16 // 0x5A
	ADDR1_RX  volatile.Register16 // 0x5C
	COUNT1_RX volatile.Register16 // 0x5E
	_         [2]byte
	COUNT2_TX volatile.Register16 // 0x62
	ADDR2_RX  volatile.Register16 // 0x64
	COUNT2_RX volatile.Register16 // 0x66
	_         [2]byte
	COUNT3_TX volatile.Register16 // 0x6A
	ADDR3_RX  volatile.Register16 // 0x6C
	COUNT3_RX volatile.Register16 // 0x6E
	_         [2]byte
	COUNT4_TX volatile.Register16 // 0x72
	ADDR4_RX  volatile.Register16 // 0x74
	COUNT4_RX volatile.Register16 // 0x76
	_         [2]byte
	COUNT5_TX volatile.Register16 // 0x7A
	ADDR5_RX  volatile.Register16 // 0x7C
	COUNT5_RX volatile.Register16 // 0x7E
	_         [2]byte
	COUNT6_TX volatile.Register16 // 0x82
	ADDR6_RX  volatile.Register16 // 0x84
	COUNT6_RX volatile.Register16 // 0x86
	_         [2]byte
	COUNT7_TX volatile.Register16 // 0x8A
	ADDR7_RX  volatile.Register16 // 0x8C
	COUNT7_RX volatile.Register16 // 0x8E
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCRS                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	_     [120]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	_     [120]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	_     [120]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	_     [120]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	_     [248]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
}

// Bitfields for DMA1: Direct memory access controller
const (
	// ISR: interrupt status register
	// Position of TEIF7 field.
	DMA_ISR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA_ISR_TEIF7 = 0x8000000
	// Position of HTIF7 field.
	DMA_ISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_ISR_HTIF7 = 0x4000000
	// Position of TCIF7 field.
	DMA_ISR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA_ISR_TCIF7 = 0x2000000
	// Position of GIF7 field.
	DMA_ISR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA_ISR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA_ISR_GIF7 = 0x1000000
	// Position of TEIF6 field.
	DMA_ISR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA_ISR_TEIF6 = 0x800000
	// Position of HTIF6 field.
	DMA_ISR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA_ISR_HTIF6 = 0x400000
	// Position of TCIF6 field.
	DMA_ISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_ISR_TCIF6 = 0x200000
	// Position of GIF6 field.
	DMA_ISR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA_ISR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA_ISR_GIF6 = 0x100000
	// Position of TEIF5 field.
	DMA_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_ISR_TEIF5 = 0x80000
	// Position of HTIF5 field.
	DMA_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_ISR_HTIF5 = 0x40000
	// Position of TCIF5 field.
	DMA_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_ISR_TCIF5 = 0x20000
	// Position of GIF5 field.
	DMA_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_ISR_GIF5 = 0x10000
	// Position of TEIF4 field.
	DMA_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_ISR_TEIF4 = 0x8000
	// Position of HTIF4 field.
	DMA_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_ISR_HTIF4 = 0x4000
	// Position of TCIF4 field.
	DMA_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_ISR_TCIF4 = 0x2000
	// Position of GIF4 field.
	DMA_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_ISR_GIF4 = 0x1000
	// Position of TEIF3 field.
	DMA_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_ISR_TEIF3 = 0x800
	// Position of HTIF3 field.
	DMA_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_ISR_HTIF3 = 0x400
	// Position of TCIF3 field.
	DMA_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_ISR_TCIF3 = 0x200
	// Position of GIF3 field.
	DMA_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_ISR_GIF3 = 0x100
	// Position of TEIF2 field.
	DMA_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_ISR_TEIF2 = 0x80
	// Position of HTIF2 field.
	DMA_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_ISR_HTIF2 = 0x40
	// Position of TCIF2 field.
	DMA_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_ISR_TCIF2 = 0x20
	// Position of GIF2 field.
	DMA_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_ISR_GIF2 = 0x10
	// Position of TEIF1 field.
	DMA_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_ISR_TEIF1 = 0x8
	// Position of HTIF1 field.
	DMA_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_ISR_HTIF1 = 0x4
	// Position of TCIF1 field.
	DMA_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_ISR_TCIF1 = 0x2
	// Position of GIF1 field.
	DMA_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_ISR_GIF1 = 0x1

	// IFCR: interrupt flag clear register
	// Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Pos = 0x1b
	// Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000
	// Bit CTEIF7.
	DMA_IFCR_CTEIF7 = 0x8000000
	// Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_IFCR_CHTIF7 = 0x4000000
	// Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Pos = 0x19
	// Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000
	// Bit CTCIF7.
	DMA_IFCR_CTCIF7 = 0x2000000
	// Position of CGIF7 field.
	DMA_IFCR_CGIF7_Pos = 0x18
	// Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7_Msk = 0x1000000
	// Bit CGIF7.
	DMA_IFCR_CGIF7 = 0x1000000
	// Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Pos = 0x17
	// Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000
	// Bit CTEIF6.
	DMA_IFCR_CTEIF6 = 0x800000
	// Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Pos = 0x16
	// Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000
	// Bit CHTIF6.
	DMA_IFCR_CHTIF6 = 0x400000
	// Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_IFCR_CTCIF6 = 0x200000
	// Position of CGIF6 field.
	DMA_IFCR_CGIF6_Pos = 0x14
	// Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6_Msk = 0x100000
	// Bit CGIF6.
	DMA_IFCR_CGIF6 = 0x100000
	// Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Pos = 0x13
	// Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000
	// Bit CTEIF5.
	DMA_IFCR_CTEIF5 = 0x80000
	// Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Pos = 0x12
	// Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000
	// Bit CHTIF5.
	DMA_IFCR_CHTIF5 = 0x40000
	// Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Pos = 0x11
	// Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000
	// Bit CTCIF5.
	DMA_IFCR_CTCIF5 = 0x20000
	// Position of CGIF5 field.
	DMA_IFCR_CGIF5_Pos = 0x10
	// Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5_Msk = 0x10000
	// Bit CGIF5.
	DMA_IFCR_CGIF5 = 0x10000
	// Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Pos = 0xf
	// Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000
	// Bit CTEIF4.
	DMA_IFCR_CTEIF4 = 0x8000
	// Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Pos = 0xe
	// Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000
	// Bit CHTIF4.
	DMA_IFCR_CHTIF4 = 0x4000
	// Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Pos = 0xd
	// Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000
	// Bit CTCIF4.
	DMA_IFCR_CTCIF4 = 0x2000
	// Position of CGIF4 field.
	DMA_IFCR_CGIF4_Pos = 0xc
	// Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4_Msk = 0x1000
	// Bit CGIF4.
	DMA_IFCR_CGIF4 = 0x1000
	// Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Pos = 0xb
	// Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800
	// Bit CTEIF3.
	DMA_IFCR_CTEIF3 = 0x800
	// Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Pos = 0xa
	// Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400
	// Bit CHTIF3.
	DMA_IFCR_CHTIF3 = 0x400
	// Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Pos = 0x9
	// Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200
	// Bit CTCIF3.
	DMA_IFCR_CTCIF3 = 0x200
	// Position of CGIF3 field.
	DMA_IFCR_CGIF3_Pos = 0x8
	// Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3_Msk = 0x100
	// Bit CGIF3.
	DMA_IFCR_CGIF3 = 0x100
	// Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Pos = 0x7
	// Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80
	// Bit CTEIF2.
	DMA_IFCR_CTEIF2 = 0x80
	// Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Pos = 0x6
	// Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40
	// Bit CHTIF2.
	DMA_IFCR_CHTIF2 = 0x40
	// Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Pos = 0x5
	// Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20
	// Bit CTCIF2.
	DMA_IFCR_CTCIF2 = 0x20
	// Position of CGIF2 field.
	DMA_IFCR_CGIF2_Pos = 0x4
	// Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2_Msk = 0x10
	// Bit CGIF2.
	DMA_IFCR_CGIF2 = 0x10
	// Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Pos = 0x3
	// Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8
	// Bit CTEIF1.
	DMA_IFCR_CTEIF1 = 0x8
	// Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Pos = 0x2
	// Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4
	// Bit CHTIF1.
	DMA_IFCR_CHTIF1 = 0x4
	// Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Pos = 0x1
	// Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2
	// Bit CTCIF1.
	DMA_IFCR_CTCIF1 = 0x2
	// Position of CGIF1 field.
	DMA_IFCR_CGIF1_Pos = 0x0
	// Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1_Msk = 0x1
	// Bit CGIF1.
	DMA_IFCR_CGIF1 = 0x1

	// CCR1: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR1_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR1_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR1_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR1_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR1_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR1_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR1_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR1_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR1_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR1_MINC = 0x80
	// Position of PINC field.
	DMA_CCR1_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR1_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR1_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR1_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR1_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR1_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR1_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR1_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR1_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR1_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR1_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR1_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR1_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR1_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR1_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR1_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR1_TCIE = 0x2
	// Position of EN field.
	DMA_CCR1_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR1_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR1_EN = 0x1

	// CNDTR1: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR1_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR1_NDT_Msk = 0xffff

	// CPAR1: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR1_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff

	// CMAR1: channel x memory address register
	// Position of MA field.
	DMA_CMAR1_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff

	// CCR2: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR2_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR2_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR2_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR2_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR2_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR2_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR2_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR2_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR2_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR2_MINC = 0x80
	// Position of PINC field.
	DMA_CCR2_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR2_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR2_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR2_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR2_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR2_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR2_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR2_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR2_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR2_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR2_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR2_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR2_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR2_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR2_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR2_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR2_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR2_TCIE = 0x2
	// Position of EN field.
	DMA_CCR2_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR2_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR2_EN = 0x1

	// CNDTR2: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR2_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR2_NDT_Msk = 0xffff

	// CPAR2: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR2_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff

	// CMAR2: channel x memory address register
	// Position of MA field.
	DMA_CMAR2_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff

	// CCR3: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR3_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR3_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR3_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR3_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR3_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR3_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR3_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR3_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR3_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR3_MINC = 0x80
	// Position of PINC field.
	DMA_CCR3_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR3_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR3_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR3_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR3_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR3_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR3_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR3_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR3_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR3_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR3_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR3_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR3_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR3_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR3_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR3_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR3_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR3_TCIE = 0x2
	// Position of EN field.
	DMA_CCR3_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR3_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR3_EN = 0x1

	// CNDTR3: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR3_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR3_NDT_Msk = 0xffff

	// CPAR3: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR3_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff

	// CMAR3: channel x memory address register
	// Position of MA field.
	DMA_CMAR3_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff

	// CCR4: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR4_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR4_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR4_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR4_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR4_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR4_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR4_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR4_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR4_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR4_MINC = 0x80
	// Position of PINC field.
	DMA_CCR4_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR4_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR4_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR4_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR4_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR4_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR4_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR4_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR4_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR4_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR4_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR4_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR4_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR4_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR4_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR4_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR4_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR4_TCIE = 0x2
	// Position of EN field.
	DMA_CCR4_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR4_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR4_EN = 0x1

	// CNDTR4: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR4_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR4_NDT_Msk = 0xffff

	// CPAR4: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR4_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff

	// CMAR4: channel x memory address register
	// Position of MA field.
	DMA_CMAR4_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff

	// CCR5: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR5_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR5_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR5_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR5_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR5_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR5_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR5_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR5_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR5_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR5_MINC = 0x80
	// Position of PINC field.
	DMA_CCR5_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR5_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR5_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR5_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR5_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR5_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR5_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR5_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR5_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR5_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR5_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR5_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR5_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR5_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR5_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR5_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR5_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR5_TCIE = 0x2
	// Position of EN field.
	DMA_CCR5_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR5_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR5_EN = 0x1

	// CNDTR5: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR5_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR5_NDT_Msk = 0xffff

	// CPAR5: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR5_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff

	// CMAR5: channel x memory address register
	// Position of MA field.
	DMA_CMAR5_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff

	// CCR6: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR6_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR6_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR6_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR6_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR6_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR6_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR6_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR6_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR6_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR6_MINC = 0x80
	// Position of PINC field.
	DMA_CCR6_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR6_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR6_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR6_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR6_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR6_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR6_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR6_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR6_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR6_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR6_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR6_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR6_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR6_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR6_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR6_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR6_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR6_TCIE = 0x2
	// Position of EN field.
	DMA_CCR6_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR6_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR6_EN = 0x1

	// CNDTR6: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR6_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR6_NDT_Msk = 0xffff

	// CPAR6: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR6_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff

	// CMAR6: channel x memory address register
	// Position of MA field.
	DMA_CMAR6_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff

	// CCR7: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR7_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR7_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR7_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR7_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR7_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR7_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR7_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR7_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR7_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR7_MINC = 0x80
	// Position of PINC field.
	DMA_CCR7_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR7_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR7_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR7_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR7_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR7_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR7_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR7_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR7_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR7_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR7_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR7_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR7_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR7_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR7_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR7_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR7_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR7_TCIE = 0x2
	// Position of EN field.
	DMA_CCR7_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR7_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR7_EN = 0x1

	// CNDTR7: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR7_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR7_NDT_Msk = 0xffff

	// CPAR7: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR7_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff

	// CMAR7: channel x memory address register
	// Position of MA field.
	DMA_CMAR7_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff
)

// Bitfields for DMAMUX1: Direct memory access Multiplexer
const (
	// C0CR: DMA Multiplexer Channel 0 Control register
	// Position of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C0CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C0CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C0CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C0CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C0CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C0CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C0CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C0CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C0CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C0CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C0CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C0CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C0CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Msk = 0xff

	// C1CR: DMA Multiplexer Channel 1 Control register
	// Position of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C1CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C1CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C1CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C1CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C1CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C1CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C1CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C1CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C1CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C1CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C1CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C1CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C1CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Msk = 0xff

	// C2CR: DMA Multiplexer Channel 2 Control register
	// Position of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C2CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C2CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C2CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C2CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C2CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C2CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C2CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C2CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C2CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C2CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C2CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C2CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C2CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Msk = 0xff

	// C3CR: DMA Multiplexer Channel 3 Control register
	// Position of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C3CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C3CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C3CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C3CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C3CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C3CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C3CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C3CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C3CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C3CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C3CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C3CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C3CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Msk = 0xff

	// C4CR: DMA Multiplexer Channel 4 Control register
	// Position of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C4CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C4CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C4CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C4CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C4CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C4CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C4CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C4CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C4CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C4CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C4CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C4CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C4CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Msk = 0xff

	// C5CR: DMA Multiplexer Channel 5 Control register
	// Position of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C5CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C5CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C5CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C5CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C5CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C5CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C5CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C5CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C5CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C5CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C5CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C5CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C5CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Msk = 0xff

	// C6CR: DMA Multiplexer Channel 6 Control register
	// Position of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C6CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C6CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C6CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C6CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C6CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C6CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C6CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C6CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C6CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C6CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C6CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C6CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C6CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Msk = 0xff

	// C7CR: DMA Multiplexer Channel 7 Control register
	// Position of SYNC_ID field.
	DMAMUX_C7CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C7CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C7CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C7CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C7CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C7CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C7CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C7CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C7CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C7CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C7CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C7CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C7CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C7CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C7CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C7CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C7CR_DMAREQ_ID_Msk = 0xff

	// C8CR: DMA Multiplexer Channel 8 Control register
	// Position of SYNC_ID field.
	DMAMUX_C8CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C8CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C8CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C8CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C8CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C8CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C8CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C8CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C8CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C8CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C8CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C8CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C8CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C8CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C8CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C8CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C8CR_DMAREQ_ID_Msk = 0xff

	// C9CR: DMA Multiplexer Channel 9 Control register
	// Position of SYNC_ID field.
	DMAMUX_C9CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C9CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C9CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C9CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C9CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C9CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C9CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C9CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C9CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C9CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C9CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C9CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C9CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C9CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C9CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C9CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C9CR_DMAREQ_ID_Msk = 0xff

	// C10CR: DMA Multiplexer Channel 10 Control register
	// Position of SYNC_ID field.
	DMAMUX_C10CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C10CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C10CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C10CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C10CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C10CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C10CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C10CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C10CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C10CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C10CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C10CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C10CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C10CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C10CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C10CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C10CR_DMAREQ_ID_Msk = 0xff

	// C11CR: DMA Multiplexer Channel 11 Control register
	// Position of SYNC_ID field.
	DMAMUX_C11CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C11CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C11CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C11CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C11CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C11CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C11CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C11CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C11CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C11CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C11CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C11CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C11CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C11CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C11CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C11CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C11CR_DMAREQ_ID_Msk = 0xff

	// C12CR: DMA Multiplexer Channel 12 Control register
	// Position of SYNC_ID field.
	DMAMUX_C12CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C12CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C12CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C12CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C12CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C12CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C12CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C12CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C12CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C12CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C12CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C12CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C12CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C12CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C12CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C12CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C12CR_DMAREQ_ID_Msk = 0xff

	// C13CR: DMA Multiplexer Channel 13 Control register
	// Position of SYNC_ID field.
	DMAMUX_C13CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C13CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C13CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C13CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C13CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C13CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C13CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C13CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C13CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C13CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C13CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C13CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C13CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C13CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C13CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C13CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C13CR_DMAREQ_ID_Msk = 0xff

	// CSR: DMA Multiplexer Channel Status register
	// Position of SOF0 field.
	DMAMUX_CSR_SOF0_Pos = 0x0
	// Bit mask of SOF0 field.
	DMAMUX_CSR_SOF0_Msk = 0x1
	// Bit SOF0.
	DMAMUX_CSR_SOF0 = 0x1
	// Position of SOF1 field.
	DMAMUX_CSR_SOF1_Pos = 0x1
	// Bit mask of SOF1 field.
	DMAMUX_CSR_SOF1_Msk = 0x2
	// Bit SOF1.
	DMAMUX_CSR_SOF1 = 0x2
	// Position of SOF2 field.
	DMAMUX_CSR_SOF2_Pos = 0x2
	// Bit mask of SOF2 field.
	DMAMUX_CSR_SOF2_Msk = 0x4
	// Bit SOF2.
	DMAMUX_CSR_SOF2 = 0x4
	// Position of SOF3 field.
	DMAMUX_CSR_SOF3_Pos = 0x3
	// Bit mask of SOF3 field.
	DMAMUX_CSR_SOF3_Msk = 0x8
	// Bit SOF3.
	DMAMUX_CSR_SOF3 = 0x8
	// Position of SOF4 field.
	DMAMUX_CSR_SOF4_Pos = 0x4
	// Bit mask of SOF4 field.
	DMAMUX_CSR_SOF4_Msk = 0x10
	// Bit SOF4.
	DMAMUX_CSR_SOF4 = 0x10
	// Position of SOF5 field.
	DMAMUX_CSR_SOF5_Pos = 0x5
	// Bit mask of SOF5 field.
	DMAMUX_CSR_SOF5_Msk = 0x20
	// Bit SOF5.
	DMAMUX_CSR_SOF5 = 0x20
	// Position of SOF6 field.
	DMAMUX_CSR_SOF6_Pos = 0x6
	// Bit mask of SOF6 field.
	DMAMUX_CSR_SOF6_Msk = 0x40
	// Bit SOF6.
	DMAMUX_CSR_SOF6 = 0x40
	// Position of SOF7 field.
	DMAMUX_CSR_SOF7_Pos = 0x7
	// Bit mask of SOF7 field.
	DMAMUX_CSR_SOF7_Msk = 0x80
	// Bit SOF7.
	DMAMUX_CSR_SOF7 = 0x80
	// Position of SOF8 field.
	DMAMUX_CSR_SOF8_Pos = 0x8
	// Bit mask of SOF8 field.
	DMAMUX_CSR_SOF8_Msk = 0x100
	// Bit SOF8.
	DMAMUX_CSR_SOF8 = 0x100
	// Position of SOF9 field.
	DMAMUX_CSR_SOF9_Pos = 0x9
	// Bit mask of SOF9 field.
	DMAMUX_CSR_SOF9_Msk = 0x200
	// Bit SOF9.
	DMAMUX_CSR_SOF9 = 0x200
	// Position of SOF10 field.
	DMAMUX_CSR_SOF10_Pos = 0xa
	// Bit mask of SOF10 field.
	DMAMUX_CSR_SOF10_Msk = 0x400
	// Bit SOF10.
	DMAMUX_CSR_SOF10 = 0x400
	// Position of SOF11 field.
	DMAMUX_CSR_SOF11_Pos = 0xb
	// Bit mask of SOF11 field.
	DMAMUX_CSR_SOF11_Msk = 0x800
	// Bit SOF11.
	DMAMUX_CSR_SOF11 = 0x800
	// Position of SOF12 field.
	DMAMUX_CSR_SOF12_Pos = 0xc
	// Bit mask of SOF12 field.
	DMAMUX_CSR_SOF12_Msk = 0x1000
	// Bit SOF12.
	DMAMUX_CSR_SOF12 = 0x1000
	// Position of SOF13 field.
	DMAMUX_CSR_SOF13_Pos = 0xd
	// Bit mask of SOF13 field.
	DMAMUX_CSR_SOF13_Msk = 0x2000
	// Bit SOF13.
	DMAMUX_CSR_SOF13 = 0x2000

	// CFR: DMA Channel Clear Flag Register
	// Position of CSOF0 field.
	DMAMUX_CFR_CSOF0_Pos = 0x0
	// Bit mask of CSOF0 field.
	DMAMUX_CFR_CSOF0_Msk = 0x1
	// Bit CSOF0.
	DMAMUX_CFR_CSOF0 = 0x1
	// Position of CSOF1 field.
	DMAMUX_CFR_CSOF1_Pos = 0x1
	// Bit mask of CSOF1 field.
	DMAMUX_CFR_CSOF1_Msk = 0x2
	// Bit CSOF1.
	DMAMUX_CFR_CSOF1 = 0x2
	// Position of CSOF2 field.
	DMAMUX_CFR_CSOF2_Pos = 0x2
	// Bit mask of CSOF2 field.
	DMAMUX_CFR_CSOF2_Msk = 0x4
	// Bit CSOF2.
	DMAMUX_CFR_CSOF2 = 0x4
	// Position of CSOF3 field.
	DMAMUX_CFR_CSOF3_Pos = 0x3
	// Bit mask of CSOF3 field.
	DMAMUX_CFR_CSOF3_Msk = 0x8
	// Bit CSOF3.
	DMAMUX_CFR_CSOF3 = 0x8
	// Position of CSOF4 field.
	DMAMUX_CFR_CSOF4_Pos = 0x4
	// Bit mask of CSOF4 field.
	DMAMUX_CFR_CSOF4_Msk = 0x10
	// Bit CSOF4.
	DMAMUX_CFR_CSOF4 = 0x10
	// Position of CSOF5 field.
	DMAMUX_CFR_CSOF5_Pos = 0x5
	// Bit mask of CSOF5 field.
	DMAMUX_CFR_CSOF5_Msk = 0x20
	// Bit CSOF5.
	DMAMUX_CFR_CSOF5 = 0x20
	// Position of CSOF6 field.
	DMAMUX_CFR_CSOF6_Pos = 0x6
	// Bit mask of CSOF6 field.
	DMAMUX_CFR_CSOF6_Msk = 0x40
	// Bit CSOF6.
	DMAMUX_CFR_CSOF6 = 0x40
	// Position of CSOF7 field.
	DMAMUX_CFR_CSOF7_Pos = 0x7
	// Bit mask of CSOF7 field.
	DMAMUX_CFR_CSOF7_Msk = 0x80
	// Bit CSOF7.
	DMAMUX_CFR_CSOF7 = 0x80
	// Position of CSOF8 field.
	DMAMUX_CFR_CSOF8_Pos = 0x8
	// Bit mask of CSOF8 field.
	DMAMUX_CFR_CSOF8_Msk = 0x100
	// Bit CSOF8.
	DMAMUX_CFR_CSOF8 = 0x100
	// Position of CSOF9 field.
	DMAMUX_CFR_CSOF9_Pos = 0x9
	// Bit mask of CSOF9 field.
	DMAMUX_CFR_CSOF9_Msk = 0x200
	// Bit CSOF9.
	DMAMUX_CFR_CSOF9 = 0x200
	// Position of CSOF10 field.
	DMAMUX_CFR_CSOF10_Pos = 0xa
	// Bit mask of CSOF10 field.
	DMAMUX_CFR_CSOF10_Msk = 0x400
	// Bit CSOF10.
	DMAMUX_CFR_CSOF10 = 0x400
	// Position of CSOF11 field.
	DMAMUX_CFR_CSOF11_Pos = 0xb
	// Bit mask of CSOF11 field.
	DMAMUX_CFR_CSOF11_Msk = 0x800
	// Bit CSOF11.
	DMAMUX_CFR_CSOF11 = 0x800
	// Position of CSOF12 field.
	DMAMUX_CFR_CSOF12_Pos = 0xc
	// Bit mask of CSOF12 field.
	DMAMUX_CFR_CSOF12_Msk = 0x1000
	// Bit CSOF12.
	DMAMUX_CFR_CSOF12 = 0x1000
	// Position of CSOF13 field.
	DMAMUX_CFR_CSOF13_Pos = 0xd
	// Bit mask of CSOF13 field.
	DMAMUX_CFR_CSOF13_Msk = 0x2000
	// Bit CSOF13.
	DMAMUX_CFR_CSOF13 = 0x2000

	// RG0CR: DMA Request Generator 0 Control Register
	// Position of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG0CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG0CR_GPOL_Msk = 0x60000
	// Position of GE field.
	DMAMUX_RG0CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG0CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG0CR_GE = 0x10000
	// Position of OIE field.
	DMAMUX_RG0CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG0CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG0CR_OIE = 0x100
	// Position of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Msk = 0x1f

	// RG1CR: DMA Request Generator 1 Control Register
	// Position of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG1CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG1CR_GPOL_Msk = 0x60000
	// Position of GE field.
	DMAMUX_RG1CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG1CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG1CR_GE = 0x10000
	// Position of OIE field.
	DMAMUX_RG1CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG1CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG1CR_OIE = 0x100
	// Position of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Msk = 0x1f

	// RG2CR: DMA Request Generator 2 Control Register
	// Position of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG2CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG2CR_GPOL_Msk = 0x60000
	// Position of GE field.
	DMAMUX_RG2CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG2CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG2CR_GE = 0x10000
	// Position of OIE field.
	DMAMUX_RG2CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG2CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG2CR_OIE = 0x100
	// Position of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Msk = 0x1f

	// RG3CR: DMA Request Generator 3 Control Register
	// Position of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG3CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG3CR_GPOL_Msk = 0x60000
	// Position of GE field.
	DMAMUX_RG3CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG3CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG3CR_GE = 0x10000
	// Position of OIE field.
	DMAMUX_RG3CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG3CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG3CR_OIE = 0x100
	// Position of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Msk = 0x1f

	// RGSR: DMA Request Generator Status Register
	// Position of OF0 field.
	DMAMUX_RGSR_OF0_Pos = 0x0
	// Bit mask of OF0 field.
	DMAMUX_RGSR_OF0_Msk = 0x1
	// Bit OF0.
	DMAMUX_RGSR_OF0 = 0x1
	// Position of OF1 field.
	DMAMUX_RGSR_OF1_Pos = 0x1
	// Bit mask of OF1 field.
	DMAMUX_RGSR_OF1_Msk = 0x2
	// Bit OF1.
	DMAMUX_RGSR_OF1 = 0x2
	// Position of OF2 field.
	DMAMUX_RGSR_OF2_Pos = 0x2
	// Bit mask of OF2 field.
	DMAMUX_RGSR_OF2_Msk = 0x4
	// Bit OF2.
	DMAMUX_RGSR_OF2 = 0x4
	// Position of OF3 field.
	DMAMUX_RGSR_OF3_Pos = 0x3
	// Bit mask of OF3 field.
	DMAMUX_RGSR_OF3_Msk = 0x8
	// Bit OF3.
	DMAMUX_RGSR_OF3 = 0x8

	// RGCFR: DMA Request Generator Clear Flag Register
	// Position of CSOF0 field.
	DMAMUX_RGCFR_CSOF0_Pos = 0x0
	// Bit mask of CSOF0 field.
	DMAMUX_RGCFR_CSOF0_Msk = 0x1
	// Bit CSOF0.
	DMAMUX_RGCFR_CSOF0 = 0x1
	// Position of CSOF1 field.
	DMAMUX_RGCFR_CSOF1_Pos = 0x1
	// Bit mask of CSOF1 field.
	DMAMUX_RGCFR_CSOF1_Msk = 0x2
	// Bit CSOF1.
	DMAMUX_RGCFR_CSOF1 = 0x2
	// Position of CSOF2 field.
	DMAMUX_RGCFR_CSOF2_Pos = 0x2
	// Bit mask of CSOF2 field.
	DMAMUX_RGCFR_CSOF2_Msk = 0x4
	// Bit CSOF2.
	DMAMUX_RGCFR_CSOF2 = 0x4
	// Position of CSOF3 field.
	DMAMUX_RGCFR_CSOF3_Pos = 0x3
	// Bit mask of CSOF3 field.
	DMAMUX_RGCFR_CSOF3_Msk = 0x8
	// Bit CSOF3.
	DMAMUX_RGCFR_CSOF3 = 0x8
)

// Bitfields for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xffffffff

	// CR: Control register
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1

	// INIT: Initial CRC value
	// Position of CRC_INIT field.
	CRC_INIT_CRC_INIT_Pos = 0x0
	// Bit mask of CRC_INIT field.
	CRC_INIT_CRC_INIT_Msk = 0xffffffff

	// POL: polynomial
	// Position of POL field.
	CRC_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	CRC_POL_POL_Msk = 0xffffffff
)

// Bitfields for LCD: Liquid crystal display controller
const (
	// CR: control register
	// Position of BIAS field.
	LCD_CR_BIAS_Pos = 0x5
	// Bit mask of BIAS field.
	LCD_CR_BIAS_Msk = 0x60
	// Position of DUTY field.
	LCD_CR_DUTY_Pos = 0x2
	// Bit mask of DUTY field.
	LCD_CR_DUTY_Msk = 0x1c
	// Position of VSEL field.
	LCD_CR_VSEL_Pos = 0x1
	// Bit mask of VSEL field.
	LCD_CR_VSEL_Msk = 0x2
	// Bit VSEL.
	LCD_CR_VSEL = 0x2
	// Position of LCDEN field.
	LCD_CR_LCDEN_Pos = 0x0
	// Bit mask of LCDEN field.
	LCD_CR_LCDEN_Msk = 0x1
	// Bit LCDEN.
	LCD_CR_LCDEN = 0x1
	// Position of MUX_SEG field.
	LCD_CR_MUX_SEG_Pos = 0x7
	// Bit mask of MUX_SEG field.
	LCD_CR_MUX_SEG_Msk = 0x80
	// Bit MUX_SEG.
	LCD_CR_MUX_SEG = 0x80
	// Position of BUFEN field.
	LCD_CR_BUFEN_Pos = 0x8
	// Bit mask of BUFEN field.
	LCD_CR_BUFEN_Msk = 0x100
	// Bit BUFEN.
	LCD_CR_BUFEN = 0x100

	// FCR: frame control register
	// Position of PS field.
	LCD_FCR_PS_Pos = 0x16
	// Bit mask of PS field.
	LCD_FCR_PS_Msk = 0x3c00000
	// Position of DIV field.
	LCD_FCR_DIV_Pos = 0x12
	// Bit mask of DIV field.
	LCD_FCR_DIV_Msk = 0x3c0000
	// Position of BLINK field.
	LCD_FCR_BLINK_Pos = 0x10
	// Bit mask of BLINK field.
	LCD_FCR_BLINK_Msk = 0x30000
	// Position of BLINKF field.
	LCD_FCR_BLINKF_Pos = 0xd
	// Bit mask of BLINKF field.
	LCD_FCR_BLINKF_Msk = 0xe000
	// Position of CC field.
	LCD_FCR_CC_Pos = 0xa
	// Bit mask of CC field.
	LCD_FCR_CC_Msk = 0x1c00
	// Position of DEAD field.
	LCD_FCR_DEAD_Pos = 0x7
	// Bit mask of DEAD field.
	LCD_FCR_DEAD_Msk = 0x380
	// Position of PON field.
	LCD_FCR_PON_Pos = 0x4
	// Bit mask of PON field.
	LCD_FCR_PON_Msk = 0x70
	// Position of UDDIE field.
	LCD_FCR_UDDIE_Pos = 0x3
	// Bit mask of UDDIE field.
	LCD_FCR_UDDIE_Msk = 0x8
	// Bit UDDIE.
	LCD_FCR_UDDIE = 0x8
	// Position of SOFIE field.
	LCD_FCR_SOFIE_Pos = 0x1
	// Bit mask of SOFIE field.
	LCD_FCR_SOFIE_Msk = 0x2
	// Bit SOFIE.
	LCD_FCR_SOFIE = 0x2
	// Position of HD field.
	LCD_FCR_HD_Pos = 0x0
	// Bit mask of HD field.
	LCD_FCR_HD_Msk = 0x1
	// Bit HD.
	LCD_FCR_HD = 0x1

	// SR: status register
	// Position of FCRSF field.
	LCD_SR_FCRSF_Pos = 0x5
	// Bit mask of FCRSF field.
	LCD_SR_FCRSF_Msk = 0x20
	// Bit FCRSF.
	LCD_SR_FCRSF = 0x20
	// Position of RDY field.
	LCD_SR_RDY_Pos = 0x4
	// Bit mask of RDY field.
	LCD_SR_RDY_Msk = 0x10
	// Bit RDY.
	LCD_SR_RDY = 0x10
	// Position of UDD field.
	LCD_SR_UDD_Pos = 0x3
	// Bit mask of UDD field.
	LCD_SR_UDD_Msk = 0x8
	// Bit UDD.
	LCD_SR_UDD = 0x8
	// Position of UDR field.
	LCD_SR_UDR_Pos = 0x2
	// Bit mask of UDR field.
	LCD_SR_UDR_Msk = 0x4
	// Bit UDR.
	LCD_SR_UDR = 0x4
	// Position of SOF field.
	LCD_SR_SOF_Pos = 0x1
	// Bit mask of SOF field.
	LCD_SR_SOF_Msk = 0x2
	// Bit SOF.
	LCD_SR_SOF = 0x2
	// Position of ENS field.
	LCD_SR_ENS_Pos = 0x0
	// Bit mask of ENS field.
	LCD_SR_ENS_Msk = 0x1
	// Bit ENS.
	LCD_SR_ENS = 0x1

	// CLR: clear register
	// Position of UDDC field.
	LCD_CLR_UDDC_Pos = 0x3
	// Bit mask of UDDC field.
	LCD_CLR_UDDC_Msk = 0x8
	// Bit UDDC.
	LCD_CLR_UDDC = 0x8
	// Position of SOFC field.
	LCD_CLR_SOFC_Pos = 0x1
	// Bit mask of SOFC field.
	LCD_CLR_SOFC_Msk = 0x2
	// Bit SOFC.
	LCD_CLR_SOFC = 0x2

	// RAM_COM0: display memory
	// Position of S31 field.
	LCD_RAM_COM0_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM0_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM0_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM0_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM0_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM0_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM0_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM0_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM0_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM0_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM0_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM0_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM0_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM0_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM0_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM0_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM0_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM0_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM0_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM0_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM0_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM0_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM0_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM0_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM0_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM0_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM0_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM0_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM0_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM0_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM0_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM0_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM0_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM0_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM0_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM0_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM0_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM0_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM0_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM0_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM0_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM0_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM0_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM0_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM0_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM0_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM0_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM0_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM0_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM0_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM0_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM0_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM0_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM0_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM0_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM0_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM0_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM0_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM0_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM0_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM0_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM0_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM0_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM0_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM0_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM0_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM0_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM0_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM0_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM0_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM0_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM0_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM0_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM0_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM0_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM0_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM0_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM0_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM0_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM0_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM0_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM0_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM0_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM0_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM0_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM0_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM0_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM0_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM0_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM0_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM0_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM0_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM0_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM0_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM0_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM0_S00 = 0x1

	// RAM_COM1: display memory
	// Position of S31 field.
	LCD_RAM_COM1_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM1_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM1_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM1_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM1_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM1_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM1_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM1_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM1_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM1_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM1_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM1_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM1_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM1_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM1_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM1_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM1_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM1_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM1_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM1_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM1_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM1_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM1_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM1_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM1_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM1_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM1_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM1_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM1_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM1_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM1_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM1_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM1_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM1_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM1_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM1_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM1_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM1_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM1_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM1_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM1_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM1_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM1_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM1_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM1_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM1_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM1_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM1_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM1_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM1_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM1_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM1_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM1_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM1_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM1_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM1_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM1_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM1_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM1_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM1_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM1_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM1_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM1_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM1_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM1_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM1_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM1_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM1_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM1_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM1_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM1_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM1_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM1_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM1_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM1_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM1_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM1_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM1_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM1_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM1_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM1_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM1_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM1_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM1_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM1_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM1_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM1_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM1_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM1_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM1_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM1_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM1_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM1_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM1_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM1_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM1_S00 = 0x1

	// RAM_COM2: display memory
	// Position of S31 field.
	LCD_RAM_COM2_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM2_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM2_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM2_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM2_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM2_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM2_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM2_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM2_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM2_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM2_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM2_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM2_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM2_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM2_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM2_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM2_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM2_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM2_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM2_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM2_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM2_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM2_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM2_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM2_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM2_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM2_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM2_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM2_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM2_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM2_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM2_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM2_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM2_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM2_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM2_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM2_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM2_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM2_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM2_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM2_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM2_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM2_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM2_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM2_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM2_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM2_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM2_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM2_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM2_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM2_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM2_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM2_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM2_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM2_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM2_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM2_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM2_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM2_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM2_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM2_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM2_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM2_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM2_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM2_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM2_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM2_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM2_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM2_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM2_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM2_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM2_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM2_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM2_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM2_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM2_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM2_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM2_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM2_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM2_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM2_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM2_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM2_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM2_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM2_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM2_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM2_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM2_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM2_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM2_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM2_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM2_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM2_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM2_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM2_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM2_S00 = 0x1

	// RAM_COM3: display memory
	// Position of S31 field.
	LCD_RAM_COM3_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM3_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM3_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM3_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM3_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM3_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM3_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM3_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM3_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM3_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM3_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM3_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM3_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM3_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM3_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM3_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM3_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM3_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM3_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM3_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM3_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM3_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM3_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM3_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM3_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM3_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM3_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM3_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM3_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM3_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM3_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM3_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM3_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM3_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM3_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM3_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM3_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM3_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM3_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM3_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM3_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM3_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM3_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM3_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM3_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM3_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM3_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM3_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM3_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM3_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM3_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM3_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM3_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM3_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM3_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM3_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM3_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM3_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM3_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM3_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM3_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM3_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM3_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM3_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM3_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM3_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM3_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM3_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM3_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM3_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM3_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM3_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM3_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM3_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM3_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM3_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM3_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM3_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM3_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM3_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM3_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM3_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM3_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM3_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM3_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM3_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM3_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM3_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM3_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM3_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM3_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM3_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM3_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM3_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM3_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM3_S00 = 0x1

	// RAM_COM4: display memory
	// Position of S31 field.
	LCD_RAM_COM4_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM4_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM4_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM4_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM4_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM4_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM4_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM4_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM4_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM4_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM4_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM4_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM4_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM4_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM4_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM4_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM4_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM4_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM4_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM4_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM4_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM4_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM4_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM4_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM4_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM4_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM4_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM4_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM4_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM4_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM4_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM4_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM4_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM4_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM4_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM4_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM4_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM4_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM4_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM4_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM4_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM4_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM4_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM4_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM4_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM4_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM4_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM4_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM4_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM4_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM4_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM4_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM4_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM4_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM4_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM4_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM4_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM4_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM4_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM4_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM4_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM4_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM4_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM4_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM4_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM4_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM4_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM4_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM4_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM4_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM4_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM4_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM4_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM4_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM4_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM4_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM4_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM4_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM4_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM4_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM4_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM4_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM4_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM4_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM4_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM4_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM4_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM4_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM4_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM4_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM4_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM4_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM4_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM4_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM4_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM4_S00 = 0x1

	// RAM_COM5: display memory
	// Position of S31 field.
	LCD_RAM_COM5_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM5_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM5_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM5_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM5_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM5_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM5_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM5_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM5_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM5_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM5_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM5_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM5_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM5_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM5_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM5_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM5_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM5_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM5_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM5_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM5_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM5_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM5_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM5_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM5_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM5_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM5_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM5_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM5_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM5_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM5_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM5_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM5_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM5_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM5_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM5_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM5_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM5_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM5_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM5_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM5_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM5_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM5_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM5_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM5_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM5_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM5_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM5_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM5_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM5_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM5_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM5_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM5_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM5_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM5_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM5_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM5_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM5_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM5_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM5_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM5_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM5_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM5_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM5_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM5_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM5_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM5_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM5_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM5_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM5_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM5_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM5_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM5_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM5_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM5_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM5_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM5_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM5_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM5_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM5_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM5_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM5_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM5_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM5_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM5_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM5_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM5_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM5_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM5_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM5_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM5_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM5_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM5_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM5_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM5_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM5_S00 = 0x1

	// RAM_COM6: display memory
	// Position of S31 field.
	LCD_RAM_COM6_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM6_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM6_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM6_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM6_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM6_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM6_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM6_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM6_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM6_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM6_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM6_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM6_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM6_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM6_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM6_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM6_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM6_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM6_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM6_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM6_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM6_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM6_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM6_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM6_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM6_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM6_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM6_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM6_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM6_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM6_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM6_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM6_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM6_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM6_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM6_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM6_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM6_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM6_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM6_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM6_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM6_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM6_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM6_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM6_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM6_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM6_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM6_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM6_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM6_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM6_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM6_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM6_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM6_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM6_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM6_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM6_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM6_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM6_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM6_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM6_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM6_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM6_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM6_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM6_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM6_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM6_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM6_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM6_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM6_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM6_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM6_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM6_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM6_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM6_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM6_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM6_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM6_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM6_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM6_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM6_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM6_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM6_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM6_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM6_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM6_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM6_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM6_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM6_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM6_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM6_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM6_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM6_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM6_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM6_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM6_S00 = 0x1

	// RAM_COM7: display memory
	// Position of S31 field.
	LCD_RAM_COM7_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM7_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM7_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM7_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM7_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM7_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM7_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM7_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM7_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM7_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM7_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM7_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM7_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM7_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM7_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM7_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM7_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM7_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM7_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM7_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM7_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM7_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM7_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM7_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM7_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM7_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM7_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM7_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM7_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM7_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM7_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM7_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM7_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM7_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM7_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM7_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM7_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM7_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM7_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM7_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM7_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM7_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM7_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM7_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM7_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM7_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM7_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM7_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM7_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM7_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM7_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM7_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM7_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM7_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM7_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM7_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM7_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM7_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM7_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM7_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM7_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM7_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM7_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM7_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM7_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM7_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM7_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM7_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM7_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM7_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM7_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM7_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM7_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM7_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM7_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM7_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM7_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM7_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM7_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM7_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM7_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM7_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM7_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM7_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM7_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM7_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM7_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM7_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM7_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM7_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM7_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM7_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM7_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM7_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM7_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM7_S00 = 0x1
)

// Bitfields for TSC: Touch sensing controller
const (
	// CR: control register
	// Position of CTPH field.
	TSC_CR_CTPH_Pos = 0x1c
	// Bit mask of CTPH field.
	TSC_CR_CTPH_Msk = 0xf0000000
	// Position of CTPL field.
	TSC_CR_CTPL_Pos = 0x18
	// Bit mask of CTPL field.
	TSC_CR_CTPL_Msk = 0xf000000
	// Position of SSD field.
	TSC_CR_SSD_Pos = 0x11
	// Bit mask of SSD field.
	TSC_CR_SSD_Msk = 0xfe0000
	// Position of SSE field.
	TSC_CR_SSE_Pos = 0x10
	// Bit mask of SSE field.
	TSC_CR_SSE_Msk = 0x10000
	// Bit SSE.
	TSC_CR_SSE = 0x10000
	// Position of SSPSC field.
	TSC_CR_SSPSC_Pos = 0xf
	// Bit mask of SSPSC field.
	TSC_CR_SSPSC_Msk = 0x8000
	// Bit SSPSC.
	TSC_CR_SSPSC = 0x8000
	// Position of PGPSC field.
	TSC_CR_PGPSC_Pos = 0xc
	// Bit mask of PGPSC field.
	TSC_CR_PGPSC_Msk = 0x7000
	// Position of MCV field.
	TSC_CR_MCV_Pos = 0x5
	// Bit mask of MCV field.
	TSC_CR_MCV_Msk = 0xe0
	// Position of IODEF field.
	TSC_CR_IODEF_Pos = 0x4
	// Bit mask of IODEF field.
	TSC_CR_IODEF_Msk = 0x10
	// Bit IODEF.
	TSC_CR_IODEF = 0x10
	// Position of SYNCPOL field.
	TSC_CR_SYNCPOL_Pos = 0x3
	// Bit mask of SYNCPOL field.
	TSC_CR_SYNCPOL_Msk = 0x8
	// Bit SYNCPOL.
	TSC_CR_SYNCPOL = 0x8
	// Position of AM field.
	TSC_CR_AM_Pos = 0x2
	// Bit mask of AM field.
	TSC_CR_AM_Msk = 0x4
	// Bit AM.
	TSC_CR_AM = 0x4
	// Position of START field.
	TSC_CR_START_Pos = 0x1
	// Bit mask of START field.
	TSC_CR_START_Msk = 0x2
	// Bit START.
	TSC_CR_START = 0x2
	// Position of TSCE field.
	TSC_CR_TSCE_Pos = 0x0
	// Bit mask of TSCE field.
	TSC_CR_TSCE_Msk = 0x1
	// Bit TSCE.
	TSC_CR_TSCE = 0x1

	// IER: interrupt enable register
	// Position of MCEIE field.
	TSC_IER_MCEIE_Pos = 0x1
	// Bit mask of MCEIE field.
	TSC_IER_MCEIE_Msk = 0x2
	// Bit MCEIE.
	TSC_IER_MCEIE = 0x2
	// Position of EOAIE field.
	TSC_IER_EOAIE_Pos = 0x0
	// Bit mask of EOAIE field.
	TSC_IER_EOAIE_Msk = 0x1
	// Bit EOAIE.
	TSC_IER_EOAIE = 0x1

	// ICR: interrupt clear register
	// Position of MCEIC field.
	TSC_ICR_MCEIC_Pos = 0x1
	// Bit mask of MCEIC field.
	TSC_ICR_MCEIC_Msk = 0x2
	// Bit MCEIC.
	TSC_ICR_MCEIC = 0x2
	// Position of EOAIC field.
	TSC_ICR_EOAIC_Pos = 0x0
	// Bit mask of EOAIC field.
	TSC_ICR_EOAIC_Msk = 0x1
	// Bit EOAIC.
	TSC_ICR_EOAIC = 0x1

	// ISR: interrupt status register
	// Position of MCEF field.
	TSC_ISR_MCEF_Pos = 0x1
	// Bit mask of MCEF field.
	TSC_ISR_MCEF_Msk = 0x2
	// Bit MCEF.
	TSC_ISR_MCEF = 0x2
	// Position of EOAF field.
	TSC_ISR_EOAF_Pos = 0x0
	// Bit mask of EOAF field.
	TSC_ISR_EOAF_Msk = 0x1
	// Bit EOAF.
	TSC_ISR_EOAF = 0x1

	// IOHCR: I/O hysteresis control register
	// Position of G7_IO4 field.
	TSC_IOHCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOHCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOHCR_G7_IO4 = 0x8000000
	// Position of G7_IO3 field.
	TSC_IOHCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOHCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOHCR_G7_IO3 = 0x4000000
	// Position of G7_IO2 field.
	TSC_IOHCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOHCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOHCR_G7_IO2 = 0x2000000
	// Position of G7_IO1 field.
	TSC_IOHCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOHCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOHCR_G7_IO1 = 0x1000000
	// Position of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOHCR_G6_IO4 = 0x800000
	// Position of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOHCR_G6_IO3 = 0x400000
	// Position of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOHCR_G6_IO2 = 0x200000
	// Position of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOHCR_G6_IO1 = 0x100000
	// Position of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOHCR_G5_IO4 = 0x80000
	// Position of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOHCR_G5_IO3 = 0x40000
	// Position of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOHCR_G5_IO2 = 0x20000
	// Position of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOHCR_G5_IO1 = 0x10000
	// Position of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOHCR_G4_IO4 = 0x8000
	// Position of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOHCR_G4_IO3 = 0x4000
	// Position of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOHCR_G4_IO2 = 0x2000
	// Position of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOHCR_G4_IO1 = 0x1000
	// Position of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOHCR_G3_IO4 = 0x800
	// Position of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOHCR_G3_IO3 = 0x400
	// Position of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOHCR_G3_IO2 = 0x200
	// Position of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOHCR_G3_IO1 = 0x100
	// Position of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOHCR_G2_IO4 = 0x80
	// Position of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOHCR_G2_IO3 = 0x40
	// Position of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOHCR_G2_IO2 = 0x20
	// Position of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOHCR_G2_IO1 = 0x10
	// Position of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOHCR_G1_IO4 = 0x8
	// Position of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOHCR_G1_IO3 = 0x4
	// Position of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOHCR_G1_IO2 = 0x2
	// Position of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOHCR_G1_IO1 = 0x1

	// IOASCR: I/O analog switch control register
	// Position of G7_IO4 field.
	TSC_IOASCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOASCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOASCR_G7_IO4 = 0x8000000
	// Position of G7_IO3 field.
	TSC_IOASCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOASCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOASCR_G7_IO3 = 0x4000000
	// Position of G7_IO2 field.
	TSC_IOASCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOASCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOASCR_G7_IO2 = 0x2000000
	// Position of G7_IO1 field.
	TSC_IOASCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOASCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOASCR_G7_IO1 = 0x1000000
	// Position of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOASCR_G6_IO4 = 0x800000
	// Position of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOASCR_G6_IO3 = 0x400000
	// Position of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOASCR_G6_IO2 = 0x200000
	// Position of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOASCR_G6_IO1 = 0x100000
	// Position of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOASCR_G5_IO4 = 0x80000
	// Position of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOASCR_G5_IO3 = 0x40000
	// Position of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOASCR_G5_IO2 = 0x20000
	// Position of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOASCR_G5_IO1 = 0x10000
	// Position of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOASCR_G4_IO4 = 0x8000
	// Position of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOASCR_G4_IO3 = 0x4000
	// Position of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOASCR_G4_IO2 = 0x2000
	// Position of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOASCR_G4_IO1 = 0x1000
	// Position of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOASCR_G3_IO4 = 0x800
	// Position of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOASCR_G3_IO3 = 0x400
	// Position of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOASCR_G3_IO2 = 0x200
	// Position of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOASCR_G3_IO1 = 0x100
	// Position of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOASCR_G2_IO4 = 0x80
	// Position of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOASCR_G2_IO3 = 0x40
	// Position of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOASCR_G2_IO2 = 0x20
	// Position of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOASCR_G2_IO1 = 0x10
	// Position of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOASCR_G1_IO4 = 0x8
	// Position of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOASCR_G1_IO3 = 0x4
	// Position of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOASCR_G1_IO2 = 0x2
	// Position of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOASCR_G1_IO1 = 0x1

	// IOSCR: I/O sampling control register
	// Position of G7_IO4 field.
	TSC_IOSCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOSCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOSCR_G7_IO4 = 0x8000000
	// Position of G7_IO3 field.
	TSC_IOSCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOSCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOSCR_G7_IO3 = 0x4000000
	// Position of G7_IO2 field.
	TSC_IOSCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOSCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOSCR_G7_IO2 = 0x2000000
	// Position of G7_IO1 field.
	TSC_IOSCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOSCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOSCR_G7_IO1 = 0x1000000
	// Position of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOSCR_G6_IO4 = 0x800000
	// Position of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOSCR_G6_IO3 = 0x400000
	// Position of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOSCR_G6_IO2 = 0x200000
	// Position of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOSCR_G6_IO1 = 0x100000
	// Position of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOSCR_G5_IO4 = 0x80000
	// Position of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOSCR_G5_IO3 = 0x40000
	// Position of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOSCR_G5_IO2 = 0x20000
	// Position of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOSCR_G5_IO1 = 0x10000
	// Position of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOSCR_G4_IO4 = 0x8000
	// Position of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOSCR_G4_IO3 = 0x4000
	// Position of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOSCR_G4_IO2 = 0x2000
	// Position of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOSCR_G4_IO1 = 0x1000
	// Position of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOSCR_G3_IO4 = 0x800
	// Position of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOSCR_G3_IO3 = 0x400
	// Position of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOSCR_G3_IO2 = 0x200
	// Position of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOSCR_G3_IO1 = 0x100
	// Position of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOSCR_G2_IO4 = 0x80
	// Position of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOSCR_G2_IO3 = 0x40
	// Position of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOSCR_G2_IO2 = 0x20
	// Position of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOSCR_G2_IO1 = 0x10
	// Position of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOSCR_G1_IO4 = 0x8
	// Position of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOSCR_G1_IO3 = 0x4
	// Position of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOSCR_G1_IO2 = 0x2
	// Position of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOSCR_G1_IO1 = 0x1

	// IOCCR: I/O channel control register
	// Position of G7_IO4 field.
	TSC_IOCCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOCCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOCCR_G7_IO4 = 0x8000000
	// Position of G7_IO3 field.
	TSC_IOCCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOCCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOCCR_G7_IO3 = 0x4000000
	// Position of G7_IO2 field.
	TSC_IOCCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOCCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOCCR_G7_IO2 = 0x2000000
	// Position of G7_IO1 field.
	TSC_IOCCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOCCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOCCR_G7_IO1 = 0x1000000
	// Position of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOCCR_G6_IO4 = 0x800000
	// Position of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOCCR_G6_IO3 = 0x400000
	// Position of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOCCR_G6_IO2 = 0x200000
	// Position of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOCCR_G6_IO1 = 0x100000
	// Position of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOCCR_G5_IO4 = 0x80000
	// Position of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOCCR_G5_IO3 = 0x40000
	// Position of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOCCR_G5_IO2 = 0x20000
	// Position of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOCCR_G5_IO1 = 0x10000
	// Position of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOCCR_G4_IO4 = 0x8000
	// Position of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOCCR_G4_IO3 = 0x4000
	// Position of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOCCR_G4_IO2 = 0x2000
	// Position of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOCCR_G4_IO1 = 0x1000
	// Position of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOCCR_G3_IO4 = 0x800
	// Position of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOCCR_G3_IO3 = 0x400
	// Position of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOCCR_G3_IO2 = 0x200
	// Position of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOCCR_G3_IO1 = 0x100
	// Position of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOCCR_G2_IO4 = 0x80
	// Position of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOCCR_G2_IO3 = 0x40
	// Position of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOCCR_G2_IO2 = 0x20
	// Position of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOCCR_G2_IO1 = 0x10
	// Position of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOCCR_G1_IO4 = 0x8
	// Position of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOCCR_G1_IO3 = 0x4
	// Position of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOCCR_G1_IO2 = 0x2
	// Position of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOCCR_G1_IO1 = 0x1

	// IOGCSR: I/O group control status register
	// Position of G7S field.
	TSC_IOGCSR_G7S_Pos = 0x16
	// Bit mask of G7S field.
	TSC_IOGCSR_G7S_Msk = 0x400000
	// Bit G7S.
	TSC_IOGCSR_G7S = 0x400000
	// Position of G6S field.
	TSC_IOGCSR_G6S_Pos = 0x15
	// Bit mask of G6S field.
	TSC_IOGCSR_G6S_Msk = 0x200000
	// Bit G6S.
	TSC_IOGCSR_G6S = 0x200000
	// Position of G5S field.
	TSC_IOGCSR_G5S_Pos = 0x14
	// Bit mask of G5S field.
	TSC_IOGCSR_G5S_Msk = 0x100000
	// Bit G5S.
	TSC_IOGCSR_G5S = 0x100000
	// Position of G4S field.
	TSC_IOGCSR_G4S_Pos = 0x13
	// Bit mask of G4S field.
	TSC_IOGCSR_G4S_Msk = 0x80000
	// Bit G4S.
	TSC_IOGCSR_G4S = 0x80000
	// Position of G3S field.
	TSC_IOGCSR_G3S_Pos = 0x12
	// Bit mask of G3S field.
	TSC_IOGCSR_G3S_Msk = 0x40000
	// Bit G3S.
	TSC_IOGCSR_G3S = 0x40000
	// Position of G2S field.
	TSC_IOGCSR_G2S_Pos = 0x11
	// Bit mask of G2S field.
	TSC_IOGCSR_G2S_Msk = 0x20000
	// Bit G2S.
	TSC_IOGCSR_G2S = 0x20000
	// Position of G1S field.
	TSC_IOGCSR_G1S_Pos = 0x10
	// Bit mask of G1S field.
	TSC_IOGCSR_G1S_Msk = 0x10000
	// Bit G1S.
	TSC_IOGCSR_G1S = 0x10000
	// Position of G7E field.
	TSC_IOGCSR_G7E_Pos = 0x6
	// Bit mask of G7E field.
	TSC_IOGCSR_G7E_Msk = 0x40
	// Bit G7E.
	TSC_IOGCSR_G7E = 0x40
	// Position of G6E field.
	TSC_IOGCSR_G6E_Pos = 0x5
	// Bit mask of G6E field.
	TSC_IOGCSR_G6E_Msk = 0x20
	// Bit G6E.
	TSC_IOGCSR_G6E = 0x20
	// Position of G5E field.
	TSC_IOGCSR_G5E_Pos = 0x4
	// Bit mask of G5E field.
	TSC_IOGCSR_G5E_Msk = 0x10
	// Bit G5E.
	TSC_IOGCSR_G5E = 0x10
	// Position of G4E field.
	TSC_IOGCSR_G4E_Pos = 0x3
	// Bit mask of G4E field.
	TSC_IOGCSR_G4E_Msk = 0x8
	// Bit G4E.
	TSC_IOGCSR_G4E = 0x8
	// Position of G3E field.
	TSC_IOGCSR_G3E_Pos = 0x2
	// Bit mask of G3E field.
	TSC_IOGCSR_G3E_Msk = 0x4
	// Bit G3E.
	TSC_IOGCSR_G3E = 0x4
	// Position of G2E field.
	TSC_IOGCSR_G2E_Pos = 0x1
	// Bit mask of G2E field.
	TSC_IOGCSR_G2E_Msk = 0x2
	// Bit G2E.
	TSC_IOGCSR_G2E = 0x2
	// Position of G1E field.
	TSC_IOGCSR_G1E_Pos = 0x0
	// Bit mask of G1E field.
	TSC_IOGCSR_G1E_Msk = 0x1
	// Bit G1E.
	TSC_IOGCSR_G1E = 0x1

	// IOG1CR: I/O group x counter register
	// Position of CNT field.
	TSC_IOG1CR_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TSC_IOG1CR_CNT_Msk = 0x3fff

	// IOG2CR: I/O group x counter register
	// Position of CNT field.
	TSC_IOG2CR_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TSC_IOG2CR_CNT_Msk = 0x3fff

	// IOG3CR: I/O group x counter register
	// Position of CNT field.
	TSC_IOG3CR_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TSC_IOG3CR_CNT_Msk = 0x3fff

	// IOG4CR: I/O group x counter register
	// Position of CNT field.
	TSC_IOG4CR_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TSC_IOG4CR_CNT_Msk = 0x3fff

	// IOG5CR: I/O group x counter register
	// Position of CNT field.
	TSC_IOG5CR_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TSC_IOG5CR_CNT_Msk = 0x3fff

	// IOG6CR: I/O group x counter register
	// Position of CNT field.
	TSC_IOG6CR_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TSC_IOG6CR_CNT_Msk = 0x3fff

	// IOG7CR: I/O group x counter register
	// Position of CNT field.
	TSC_IOG7CR_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TSC_IOG7CR_CNT_Msk = 0x3fff
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of WVU field.
	IWDG_SR_WVU_Pos = 0x2
	// Bit mask of WVU field.
	IWDG_SR_WVU_Msk = 0x4
	// Bit WVU.
	IWDG_SR_WVU = 0x4
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1

	// WINR: Window register
	// Position of WIN field.
	IWDG_WINR_WIN_Pos = 0x0
	// Bit mask of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff
)

// Bitfields for WWDG: System window watchdog
const (
	// CR: Control register
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f

	// CFR: Configuration register
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0xb
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x3800
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f

	// SR: Status register
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
)

// Bitfields for COMP: Comparator instance 1
const (
	// COMP1_CSR: Comparator control and status register
	// Position of COMP1_EN field.
	COMP_COMP1_CSR_COMP1_EN_Pos = 0x0
	// Bit mask of COMP1_EN field.
	COMP_COMP1_CSR_COMP1_EN_Msk = 0x1
	// Bit COMP1_EN.
	COMP_COMP1_CSR_COMP1_EN = 0x1
	// Position of COMP1_PWRMODE field.
	COMP_COMP1_CSR_COMP1_PWRMODE_Pos = 0x2
	// Bit mask of COMP1_PWRMODE field.
	COMP_COMP1_CSR_COMP1_PWRMODE_Msk = 0xc
	// Position of COMP1_INMSEL field.
	COMP_COMP1_CSR_COMP1_INMSEL_Pos = 0x4
	// Bit mask of COMP1_INMSEL field.
	COMP_COMP1_CSR_COMP1_INMSEL_Msk = 0x70
	// Position of COMP1_INPSEL field.
	COMP_COMP1_CSR_COMP1_INPSEL_Pos = 0x7
	// Bit mask of COMP1_INPSEL field.
	COMP_COMP1_CSR_COMP1_INPSEL_Msk = 0x180
	// Position of COMP1_POLARITY field.
	COMP_COMP1_CSR_COMP1_POLARITY_Pos = 0xf
	// Bit mask of COMP1_POLARITY field.
	COMP_COMP1_CSR_COMP1_POLARITY_Msk = 0x8000
	// Bit COMP1_POLARITY.
	COMP_COMP1_CSR_COMP1_POLARITY = 0x8000
	// Position of COMP1_HYST field.
	COMP_COMP1_CSR_COMP1_HYST_Pos = 0x10
	// Bit mask of COMP1_HYST field.
	COMP_COMP1_CSR_COMP1_HYST_Msk = 0x30000
	// Position of COMP1_BLANKING field.
	COMP_COMP1_CSR_COMP1_BLANKING_Pos = 0x12
	// Bit mask of COMP1_BLANKING field.
	COMP_COMP1_CSR_COMP1_BLANKING_Msk = 0x1c0000
	// Position of COMP1_BRGEN field.
	COMP_COMP1_CSR_COMP1_BRGEN_Pos = 0x16
	// Bit mask of COMP1_BRGEN field.
	COMP_COMP1_CSR_COMP1_BRGEN_Msk = 0x400000
	// Bit COMP1_BRGEN.
	COMP_COMP1_CSR_COMP1_BRGEN = 0x400000
	// Position of COMP1_SCALEN field.
	COMP_COMP1_CSR_COMP1_SCALEN_Pos = 0x17
	// Bit mask of COMP1_SCALEN field.
	COMP_COMP1_CSR_COMP1_SCALEN_Msk = 0x800000
	// Bit COMP1_SCALEN.
	COMP_COMP1_CSR_COMP1_SCALEN = 0x800000
	// Position of COMP1_INMESEL field.
	COMP_COMP1_CSR_COMP1_INMESEL_Pos = 0x19
	// Bit mask of COMP1_INMESEL field.
	COMP_COMP1_CSR_COMP1_INMESEL_Msk = 0x6000000
	// Position of COMP1_VALUE field.
	COMP_COMP1_CSR_COMP1_VALUE_Pos = 0x1e
	// Bit mask of COMP1_VALUE field.
	COMP_COMP1_CSR_COMP1_VALUE_Msk = 0x40000000
	// Bit COMP1_VALUE.
	COMP_COMP1_CSR_COMP1_VALUE = 0x40000000
	// Position of COMP1_LOCK field.
	COMP_COMP1_CSR_COMP1_LOCK_Pos = 0x1f
	// Bit mask of COMP1_LOCK field.
	COMP_COMP1_CSR_COMP1_LOCK_Msk = 0x80000000
	// Bit COMP1_LOCK.
	COMP_COMP1_CSR_COMP1_LOCK = 0x80000000

	// COMP2_CSR: Comparator 2 control and status register
	// Position of COMP2_EN field.
	COMP_COMP2_CSR_COMP2_EN_Pos = 0x0
	// Bit mask of COMP2_EN field.
	COMP_COMP2_CSR_COMP2_EN_Msk = 0x1
	// Bit COMP2_EN.
	COMP_COMP2_CSR_COMP2_EN = 0x1
	// Position of COMP2_PWRMODE field.
	COMP_COMP2_CSR_COMP2_PWRMODE_Pos = 0x2
	// Bit mask of COMP2_PWRMODE field.
	COMP_COMP2_CSR_COMP2_PWRMODE_Msk = 0xc
	// Position of COMP2_INMSEL field.
	COMP_COMP2_CSR_COMP2_INMSEL_Pos = 0x4
	// Bit mask of COMP2_INMSEL field.
	COMP_COMP2_CSR_COMP2_INMSEL_Msk = 0x30
	// Position of COMP2_INPSEL field.
	COMP_COMP2_CSR_COMP2_INPSEL_Pos = 0x7
	// Bit mask of COMP2_INPSEL field.
	COMP_COMP2_CSR_COMP2_INPSEL_Msk = 0x180
	// Position of COMP2_WINMODE field.
	COMP_COMP2_CSR_COMP2_WINMODE_Pos = 0x9
	// Bit mask of COMP2_WINMODE field.
	COMP_COMP2_CSR_COMP2_WINMODE_Msk = 0x200
	// Bit COMP2_WINMODE.
	COMP_COMP2_CSR_COMP2_WINMODE = 0x200
	// Position of COMP2_POLARITY field.
	COMP_COMP2_CSR_COMP2_POLARITY_Pos = 0xf
	// Bit mask of COMP2_POLARITY field.
	COMP_COMP2_CSR_COMP2_POLARITY_Msk = 0x8000
	// Bit COMP2_POLARITY.
	COMP_COMP2_CSR_COMP2_POLARITY = 0x8000
	// Position of COMP2_HYST field.
	COMP_COMP2_CSR_COMP2_HYST_Pos = 0x10
	// Bit mask of COMP2_HYST field.
	COMP_COMP2_CSR_COMP2_HYST_Msk = 0x30000
	// Position of COMP2_BLANKING field.
	COMP_COMP2_CSR_COMP2_BLANKING_Pos = 0x12
	// Bit mask of COMP2_BLANKING field.
	COMP_COMP2_CSR_COMP2_BLANKING_Msk = 0x1c0000
	// Position of COMP2_BRGEN field.
	COMP_COMP2_CSR_COMP2_BRGEN_Pos = 0x16
	// Bit mask of COMP2_BRGEN field.
	COMP_COMP2_CSR_COMP2_BRGEN_Msk = 0x400000
	// Bit COMP2_BRGEN.
	COMP_COMP2_CSR_COMP2_BRGEN = 0x400000
	// Position of COMP2_SCALEN field.
	COMP_COMP2_CSR_COMP2_SCALEN_Pos = 0x17
	// Bit mask of COMP2_SCALEN field.
	COMP_COMP2_CSR_COMP2_SCALEN_Msk = 0x800000
	// Bit COMP2_SCALEN.
	COMP_COMP2_CSR_COMP2_SCALEN = 0x800000
	// Position of COMP2_INMESEL field.
	COMP_COMP2_CSR_COMP2_INMESEL_Pos = 0x19
	// Bit mask of COMP2_INMESEL field.
	COMP_COMP2_CSR_COMP2_INMESEL_Msk = 0x6000000
	// Position of COMP2_VALUE field.
	COMP_COMP2_CSR_COMP2_VALUE_Pos = 0x1e
	// Bit mask of COMP2_VALUE field.
	COMP_COMP2_CSR_COMP2_VALUE_Msk = 0x40000000
	// Bit COMP2_VALUE.
	COMP_COMP2_CSR_COMP2_VALUE = 0x40000000
	// Position of COMP2_LOCK field.
	COMP_COMP2_CSR_COMP2_LOCK_Pos = 0x1f
	// Bit mask of COMP2_LOCK field.
	COMP_COMP2_CSR_COMP2_LOCK_Msk = 0x80000000
	// Bit COMP2_LOCK.
	COMP_COMP2_CSR_COMP2_LOCK = 0x80000000
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Position of TXIE field.
	I2C_CR1_TXIE_Pos = 0x1
	// Bit mask of TXIE field.
	I2C_CR1_TXIE_Msk = 0x2
	// Bit TXIE.
	I2C_CR1_TXIE = 0x2
	// Position of RXIE field.
	I2C_CR1_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	I2C_CR1_RXIE_Msk = 0x4
	// Bit RXIE.
	I2C_CR1_RXIE = 0x4
	// Position of ADDRIE field.
	I2C_CR1_ADDRIE_Pos = 0x3
	// Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE_Msk = 0x8
	// Bit ADDRIE.
	I2C_CR1_ADDRIE = 0x8
	// Position of NACKIE field.
	I2C_CR1_NACKIE_Pos = 0x4
	// Bit mask of NACKIE field.
	I2C_CR1_NACKIE_Msk = 0x10
	// Bit NACKIE.
	I2C_CR1_NACKIE = 0x10
	// Position of STOPIE field.
	I2C_CR1_STOPIE_Pos = 0x5
	// Bit mask of STOPIE field.
	I2C_CR1_STOPIE_Msk = 0x20
	// Bit STOPIE.
	I2C_CR1_STOPIE = 0x20
	// Position of TCIE field.
	I2C_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	I2C_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	I2C_CR1_TCIE = 0x40
	// Position of ERRIE field.
	I2C_CR1_ERRIE_Pos = 0x7
	// Bit mask of ERRIE field.
	I2C_CR1_ERRIE_Msk = 0x80
	// Bit ERRIE.
	I2C_CR1_ERRIE = 0x80
	// Position of DNF field.
	I2C_CR1_DNF_Pos = 0x8
	// Bit mask of DNF field.
	I2C_CR1_DNF_Msk = 0xf00
	// Position of ANFOFF field.
	I2C_CR1_ANFOFF_Pos = 0xc
	// Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF_Msk = 0x1000
	// Bit ANFOFF.
	I2C_CR1_ANFOFF = 0x1000
	// Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Pos = 0xe
	// Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk = 0x4000
	// Bit TXDMAEN.
	I2C_CR1_TXDMAEN = 0x4000
	// Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Pos = 0xf
	// Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk = 0x8000
	// Bit RXDMAEN.
	I2C_CR1_RXDMAEN = 0x8000
	// Position of SBC field.
	I2C_CR1_SBC_Pos = 0x10
	// Bit mask of SBC field.
	I2C_CR1_SBC_Msk = 0x10000
	// Bit SBC.
	I2C_CR1_SBC = 0x10000
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x11
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x20000
	// Position of WUPEN field.
	I2C_CR1_WUPEN_Pos = 0x12
	// Bit mask of WUPEN field.
	I2C_CR1_WUPEN_Msk = 0x40000
	// Bit WUPEN.
	I2C_CR1_WUPEN = 0x40000
	// Position of GCEN field.
	I2C_CR1_GCEN_Pos = 0x13
	// Bit mask of GCEN field.
	I2C_CR1_GCEN_Msk = 0x80000
	// Bit GCEN.
	I2C_CR1_GCEN = 0x80000
	// Position of SMBHEN field.
	I2C_CR1_SMBHEN_Pos = 0x14
	// Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN_Msk = 0x100000
	// Bit SMBHEN.
	I2C_CR1_SMBHEN = 0x100000
	// Position of SMBDEN field.
	I2C_CR1_SMBDEN_Pos = 0x15
	// Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN_Msk = 0x200000
	// Bit SMBDEN.
	I2C_CR1_SMBDEN = 0x200000
	// Position of ALERTEN field.
	I2C_CR1_ALERTEN_Pos = 0x16
	// Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN_Msk = 0x400000
	// Bit ALERTEN.
	I2C_CR1_ALERTEN = 0x400000
	// Position of PECEN field.
	I2C_CR1_PECEN_Pos = 0x17
	// Bit mask of PECEN field.
	I2C_CR1_PECEN_Msk = 0x800000
	// Bit PECEN.
	I2C_CR1_PECEN = 0x800000

	// CR2: Control register 2
	// Position of PECBYTE field.
	I2C_CR2_PECBYTE_Pos = 0x1a
	// Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000
	// Bit PECBYTE.
	I2C_CR2_PECBYTE = 0x4000000
	// Position of AUTOEND field.
	I2C_CR2_AUTOEND_Pos = 0x19
	// Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000
	// Bit AUTOEND.
	I2C_CR2_AUTOEND = 0x2000000
	// Position of RELOAD field.
	I2C_CR2_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	I2C_CR2_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	I2C_CR2_RELOAD = 0x1000000
	// Position of NBYTES field.
	I2C_CR2_NBYTES_Pos = 0x10
	// Bit mask of NBYTES field.
	I2C_CR2_NBYTES_Msk = 0xff0000
	// Position of NACK field.
	I2C_CR2_NACK_Pos = 0xf
	// Bit mask of NACK field.
	I2C_CR2_NACK_Msk = 0x8000
	// Bit NACK.
	I2C_CR2_NACK = 0x8000
	// Position of STOP field.
	I2C_CR2_STOP_Pos = 0xe
	// Bit mask of STOP field.
	I2C_CR2_STOP_Msk = 0x4000
	// Bit STOP.
	I2C_CR2_STOP = 0x4000
	// Position of START field.
	I2C_CR2_START_Pos = 0xd
	// Bit mask of START field.
	I2C_CR2_START_Msk = 0x2000
	// Bit START.
	I2C_CR2_START = 0x2000
	// Position of HEAD10R field.
	I2C_CR2_HEAD10R_Pos = 0xc
	// Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000
	// Bit HEAD10R.
	I2C_CR2_HEAD10R = 0x1000
	// Position of ADD10 field.
	I2C_CR2_ADD10_Pos = 0xb
	// Bit mask of ADD10 field.
	I2C_CR2_ADD10_Msk = 0x800
	// Bit ADD10.
	I2C_CR2_ADD10 = 0x800
	// Position of RD_WRN field.
	I2C_CR2_RD_WRN_Pos = 0xa
	// Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN_Msk = 0x400
	// Bit RD_WRN.
	I2C_CR2_RD_WRN = 0x400
	// Position of SADD field.
	I2C_CR2_SADD_Pos = 0x0
	// Bit mask of SADD field.
	I2C_CR2_SADD_Msk = 0x3ff

	// OAR1: Own address register 1
	// Position of OA1 field.
	I2C_OAR1_OA1_Pos = 0x0
	// Bit mask of OA1 field.
	I2C_OAR1_OA1_Msk = 0x3ff
	// Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Pos = 0xa
	// Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400
	// Bit OA1MODE.
	I2C_OAR1_OA1MODE = 0x400
	// Position of OA1EN field.
	I2C_OAR1_OA1EN_Pos = 0xf
	// Bit mask of OA1EN field.
	I2C_OAR1_OA1EN_Msk = 0x8000
	// Bit OA1EN.
	I2C_OAR1_OA1EN = 0x8000

	// OAR2: Own address register 2
	// Position of OA2 field.
	I2C_OAR2_OA2_Pos = 0x1
	// Bit mask of OA2 field.
	I2C_OAR2_OA2_Msk = 0xfe
	// Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Pos = 0x8
	// Bit mask of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700
	// Position of OA2EN field.
	I2C_OAR2_OA2EN_Pos = 0xf
	// Bit mask of OA2EN field.
	I2C_OAR2_OA2EN_Msk = 0x8000
	// Bit OA2EN.
	I2C_OAR2_OA2EN = 0x8000

	// TIMINGR: Timing register
	// Position of SCLL field.
	I2C_TIMINGR_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_TIMINGR_SCLL_Msk = 0xff
	// Position of SCLH field.
	I2C_TIMINGR_SCLH_Pos = 0x8
	// Bit mask of SCLH field.
	I2C_TIMINGR_SCLH_Msk = 0xff00
	// Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Pos = 0x10
	// Bit mask of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000
	// Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14
	// Bit mask of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000
	// Position of PRESC field.
	I2C_TIMINGR_PRESC_Pos = 0x1c
	// Bit mask of PRESC field.
	I2C_TIMINGR_PRESC_Msk = 0xf0000000

	// TIMEOUTR: Status register 1
	// Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0
	// Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff
	// Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Pos = 0xc
	// Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk = 0x1000
	// Bit TIDLE.
	I2C_TIMEOUTR_TIDLE = 0x1000
	// Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf
	// Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000
	// Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMOUTEN = 0x8000
	// Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10
	// Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000
	// Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Pos = 0x1f
	// Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk = 0x80000000
	// Bit TEXTEN.
	I2C_TIMEOUTR_TEXTEN = 0x80000000

	// ISR: Interrupt and Status register
	// Position of ADDCODE field.
	I2C_ISR_ADDCODE_Pos = 0x11
	// Bit mask of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000
	// Position of DIR field.
	I2C_ISR_DIR_Pos = 0x10
	// Bit mask of DIR field.
	I2C_ISR_DIR_Msk = 0x10000
	// Bit DIR.
	I2C_ISR_DIR = 0x10000
	// Position of BUSY field.
	I2C_ISR_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	I2C_ISR_BUSY_Msk = 0x8000
	// Bit BUSY.
	I2C_ISR_BUSY = 0x8000
	// Position of ALERT field.
	I2C_ISR_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_ISR_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_ISR_ALERT = 0x2000
	// Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000
	// Bit TIMEOUT.
	I2C_ISR_TIMEOUT = 0x1000
	// Position of PECERR field.
	I2C_ISR_PECERR_Pos = 0xb
	// Bit mask of PECERR field.
	I2C_ISR_PECERR_Msk = 0x800
	// Bit PECERR.
	I2C_ISR_PECERR = 0x800
	// Position of OVR field.
	I2C_ISR_OVR_Pos = 0xa
	// Bit mask of OVR field.
	I2C_ISR_OVR_Msk = 0x400
	// Bit OVR.
	I2C_ISR_OVR = 0x400
	// Position of ARLO field.
	I2C_ISR_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_ISR_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_ISR_ARLO = 0x200
	// Position of BERR field.
	I2C_ISR_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_ISR_BERR_Msk = 0x100
	// Bit BERR.
	I2C_ISR_BERR = 0x100
	// Position of TCR field.
	I2C_ISR_TCR_Pos = 0x7
	// Bit mask of TCR field.
	I2C_ISR_TCR_Msk = 0x80
	// Bit TCR.
	I2C_ISR_TCR = 0x80
	// Position of TC field.
	I2C_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	I2C_ISR_TC_Msk = 0x40
	// Bit TC.
	I2C_ISR_TC = 0x40
	// Position of STOPF field.
	I2C_ISR_STOPF_Pos = 0x5
	// Bit mask of STOPF field.
	I2C_ISR_STOPF_Msk = 0x20
	// Bit STOPF.
	I2C_ISR_STOPF = 0x20
	// Position of NACKF field.
	I2C_ISR_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	I2C_ISR_NACKF_Msk = 0x10
	// Bit NACKF.
	I2C_ISR_NACKF = 0x10
	// Position of ADDR field.
	I2C_ISR_ADDR_Pos = 0x3
	// Bit mask of ADDR field.
	I2C_ISR_ADDR_Msk = 0x8
	// Bit ADDR.
	I2C_ISR_ADDR = 0x8
	// Position of RXNE field.
	I2C_ISR_RXNE_Pos = 0x2
	// Bit mask of RXNE field.
	I2C_ISR_RXNE_Msk = 0x4
	// Bit RXNE.
	I2C_ISR_RXNE = 0x4
	// Position of TXIS field.
	I2C_ISR_TXIS_Pos = 0x1
	// Bit mask of TXIS field.
	I2C_ISR_TXIS_Msk = 0x2
	// Bit TXIS.
	I2C_ISR_TXIS = 0x2
	// Position of TXE field.
	I2C_ISR_TXE_Pos = 0x0
	// Bit mask of TXE field.
	I2C_ISR_TXE_Msk = 0x1
	// Bit TXE.
	I2C_ISR_TXE = 0x1

	// ICR: Interrupt clear register
	// Position of ALERTCF field.
	I2C_ICR_ALERTCF_Pos = 0xd
	// Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF_Msk = 0x2000
	// Bit ALERTCF.
	I2C_ICR_ALERTCF = 0x2000
	// Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Pos = 0xc
	// Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000
	// Bit TIMOUTCF.
	I2C_ICR_TIMOUTCF = 0x1000
	// Position of PECCF field.
	I2C_ICR_PECCF_Pos = 0xb
	// Bit mask of PECCF field.
	I2C_ICR_PECCF_Msk = 0x800
	// Bit PECCF.
	I2C_ICR_PECCF = 0x800
	// Position of OVRCF field.
	I2C_ICR_OVRCF_Pos = 0xa
	// Bit mask of OVRCF field.
	I2C_ICR_OVRCF_Msk = 0x400
	// Bit OVRCF.
	I2C_ICR_OVRCF = 0x400
	// Position of ARLOCF field.
	I2C_ICR_ARLOCF_Pos = 0x9
	// Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF_Msk = 0x200
	// Bit ARLOCF.
	I2C_ICR_ARLOCF = 0x200
	// Position of BERRCF field.
	I2C_ICR_BERRCF_Pos = 0x8
	// Bit mask of BERRCF field.
	I2C_ICR_BERRCF_Msk = 0x100
	// Bit BERRCF.
	I2C_ICR_BERRCF = 0x100
	// Position of STOPCF field.
	I2C_ICR_STOPCF_Pos = 0x5
	// Bit mask of STOPCF field.
	I2C_ICR_STOPCF_Msk = 0x20
	// Bit STOPCF.
	I2C_ICR_STOPCF = 0x20
	// Position of NACKCF field.
	I2C_ICR_NACKCF_Pos = 0x4
	// Bit mask of NACKCF field.
	I2C_ICR_NACKCF_Msk = 0x10
	// Bit NACKCF.
	I2C_ICR_NACKCF = 0x10
	// Position of ADDRCF field.
	I2C_ICR_ADDRCF_Pos = 0x3
	// Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF_Msk = 0x8
	// Bit ADDRCF.
	I2C_ICR_ADDRCF = 0x8

	// PECR: PEC register
	// Position of PEC field.
	I2C_PECR_PEC_Pos = 0x0
	// Bit mask of PEC field.
	I2C_PECR_PEC_Msk = 0xff

	// RXDR: Receive data register
	// Position of RXDATA field.
	I2C_RXDR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff

	// TXDR: Transmit data register
	// Position of TXDATA field.
	I2C_TXDR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff
)

// Bitfields for Flash: Flash
const (
	// ACR: Access control register
	// Position of LATENCY field.
	Flash_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0x7
	// Position of PRFTEN field.
	Flash_ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	Flash_ACR_PRFTEN = 0x100
	// Position of ICEN field.
	Flash_ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	Flash_ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	Flash_ACR_ICEN = 0x200
	// Position of DCEN field.
	Flash_ACR_DCEN_Pos = 0xa
	// Bit mask of DCEN field.
	Flash_ACR_DCEN_Msk = 0x400
	// Bit DCEN.
	Flash_ACR_DCEN = 0x400
	// Position of ICRST field.
	Flash_ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	Flash_ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	Flash_ACR_ICRST = 0x800
	// Position of DCRST field.
	Flash_ACR_DCRST_Pos = 0xc
	// Bit mask of DCRST field.
	Flash_ACR_DCRST_Msk = 0x1000
	// Bit DCRST.
	Flash_ACR_DCRST = 0x1000
	// Position of PES field.
	Flash_ACR_PES_Pos = 0xf
	// Bit mask of PES field.
	Flash_ACR_PES_Msk = 0x8000
	// Bit PES.
	Flash_ACR_PES = 0x8000
	// Position of EMPTY field.
	Flash_ACR_EMPTY_Pos = 0x10
	// Bit mask of EMPTY field.
	Flash_ACR_EMPTY_Msk = 0x10000
	// Bit EMPTY.
	Flash_ACR_EMPTY = 0x10000

	// KEYR: Flash key register
	// Position of KEYR field.
	Flash_KEYR_KEYR_Pos = 0x0
	// Bit mask of KEYR field.
	Flash_KEYR_KEYR_Msk = 0xffffffff

	// OPTKEYR: Option byte key register
	// Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0
	// Bit mask of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff

	// SR: Status register
	// Position of EOP field.
	Flash_SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	Flash_SR_EOP_Msk = 0x1
	// Bit EOP.
	Flash_SR_EOP = 0x1
	// Position of OPERR field.
	Flash_SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	Flash_SR_OPERR_Msk = 0x2
	// Bit OPERR.
	Flash_SR_OPERR = 0x2
	// Position of PROGERR field.
	Flash_SR_PROGERR_Pos = 0x3
	// Bit mask of PROGERR field.
	Flash_SR_PROGERR_Msk = 0x8
	// Bit PROGERR.
	Flash_SR_PROGERR = 0x8
	// Position of WRPERR field.
	Flash_SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	Flash_SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	Flash_SR_WRPERR = 0x10
	// Position of PGAERR field.
	Flash_SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	Flash_SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	Flash_SR_PGAERR = 0x20
	// Position of SIZERR field.
	Flash_SR_SIZERR_Pos = 0x6
	// Bit mask of SIZERR field.
	Flash_SR_SIZERR_Msk = 0x40
	// Bit SIZERR.
	Flash_SR_SIZERR = 0x40
	// Position of PGSERR field.
	Flash_SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	Flash_SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	Flash_SR_PGSERR = 0x80
	// Position of MISERR field.
	Flash_SR_MISERR_Pos = 0x8
	// Bit mask of MISERR field.
	Flash_SR_MISERR_Msk = 0x100
	// Bit MISERR.
	Flash_SR_MISERR = 0x100
	// Position of FASTERR field.
	Flash_SR_FASTERR_Pos = 0x9
	// Bit mask of FASTERR field.
	Flash_SR_FASTERR_Msk = 0x200
	// Bit FASTERR.
	Flash_SR_FASTERR = 0x200
	// Position of OPTNV field.
	Flash_SR_OPTNV_Pos = 0xd
	// Bit mask of OPTNV field.
	Flash_SR_OPTNV_Msk = 0x2000
	// Bit OPTNV.
	Flash_SR_OPTNV = 0x2000
	// Position of RDERR field.
	Flash_SR_RDERR_Pos = 0xe
	// Bit mask of RDERR field.
	Flash_SR_RDERR_Msk = 0x4000
	// Bit RDERR.
	Flash_SR_RDERR = 0x4000
	// Position of OPTVERR field.
	Flash_SR_OPTVERR_Pos = 0xf
	// Bit mask of OPTVERR field.
	Flash_SR_OPTVERR_Msk = 0x8000
	// Bit OPTVERR.
	Flash_SR_OPTVERR = 0x8000
	// Position of BSY field.
	Flash_SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	Flash_SR_BSY_Msk = 0x10000
	// Bit BSY.
	Flash_SR_BSY = 0x10000
	// Position of CFGBSY field.
	Flash_SR_CFGBSY_Pos = 0x12
	// Bit mask of CFGBSY field.
	Flash_SR_CFGBSY_Msk = 0x40000
	// Bit CFGBSY.
	Flash_SR_CFGBSY = 0x40000
	// Position of PESD field.
	Flash_SR_PESD_Pos = 0x13
	// Bit mask of PESD field.
	Flash_SR_PESD_Msk = 0x80000
	// Bit PESD.
	Flash_SR_PESD = 0x80000

	// CR: Flash control register
	// Position of PG field.
	Flash_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	Flash_CR_PG_Msk = 0x1
	// Bit PG.
	Flash_CR_PG = 0x1
	// Position of PER field.
	Flash_CR_PER_Pos = 0x1
	// Bit mask of PER field.
	Flash_CR_PER_Msk = 0x2
	// Bit PER.
	Flash_CR_PER = 0x2
	// Position of MER field.
	Flash_CR_MER_Pos = 0x2
	// Bit mask of MER field.
	Flash_CR_MER_Msk = 0x4
	// Bit MER.
	Flash_CR_MER = 0x4
	// Position of PNB field.
	Flash_CR_PNB_Pos = 0x3
	// Bit mask of PNB field.
	Flash_CR_PNB_Msk = 0x7f8
	// Position of STRT field.
	Flash_CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	Flash_CR_STRT_Msk = 0x10000
	// Bit STRT.
	Flash_CR_STRT = 0x10000
	// Position of OPTSTRT field.
	Flash_CR_OPTSTRT_Pos = 0x11
	// Bit mask of OPTSTRT field.
	Flash_CR_OPTSTRT_Msk = 0x20000
	// Bit OPTSTRT.
	Flash_CR_OPTSTRT = 0x20000
	// Position of FSTPG field.
	Flash_CR_FSTPG_Pos = 0x12
	// Bit mask of FSTPG field.
	Flash_CR_FSTPG_Msk = 0x40000
	// Bit FSTPG.
	Flash_CR_FSTPG = 0x40000
	// Position of EOPIE field.
	Flash_CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	Flash_CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	Flash_CR_EOPIE = 0x1000000
	// Position of ERRIE field.
	Flash_CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	Flash_CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	Flash_CR_ERRIE = 0x2000000
	// Position of RDERRIE field.
	Flash_CR_RDERRIE_Pos = 0x1a
	// Bit mask of RDERRIE field.
	Flash_CR_RDERRIE_Msk = 0x4000000
	// Bit RDERRIE.
	Flash_CR_RDERRIE = 0x4000000
	// Position of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Pos = 0x1b
	// Bit mask of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Msk = 0x8000000
	// Bit OBL_LAUNCH.
	Flash_CR_OBL_LAUNCH = 0x8000000
	// Position of OPTLOCK field.
	Flash_CR_OPTLOCK_Pos = 0x1e
	// Bit mask of OPTLOCK field.
	Flash_CR_OPTLOCK_Msk = 0x40000000
	// Bit OPTLOCK.
	Flash_CR_OPTLOCK = 0x40000000
	// Position of LOCK field.
	Flash_CR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Flash_CR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Flash_CR_LOCK = 0x80000000

	// ECCR: Flash ECC register
	// Position of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Pos = 0x0
	// Bit mask of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Msk = 0x1ffff
	// Position of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Pos = 0x14
	// Bit mask of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Msk = 0x100000
	// Bit SYSF_ECC.
	Flash_ECCR_SYSF_ECC = 0x100000
	// Position of ECCCIE field.
	Flash_ECCR_ECCCIE_Pos = 0x18
	// Bit mask of ECCCIE field.
	Flash_ECCR_ECCCIE_Msk = 0x1000000
	// Bit ECCCIE.
	Flash_ECCR_ECCCIE = 0x1000000
	// Position of CPUID field.
	Flash_ECCR_CPUID_Pos = 0x1a
	// Bit mask of CPUID field.
	Flash_ECCR_CPUID_Msk = 0x1c000000
	// Position of ECCC field.
	Flash_ECCR_ECCC_Pos = 0x1e
	// Bit mask of ECCC field.
	Flash_ECCR_ECCC_Msk = 0x40000000
	// Bit ECCC.
	Flash_ECCR_ECCC = 0x40000000
	// Position of ECCD field.
	Flash_ECCR_ECCD_Pos = 0x1f
	// Bit mask of ECCD field.
	Flash_ECCR_ECCD_Msk = 0x80000000
	// Bit ECCD.
	Flash_ECCR_ECCD = 0x80000000

	// OPTR: Flash option register
	// Position of RDP field.
	Flash_OPTR_RDP_Pos = 0x0
	// Bit mask of RDP field.
	Flash_OPTR_RDP_Msk = 0xff
	// Position of ESE field.
	Flash_OPTR_ESE_Pos = 0x8
	// Bit mask of ESE field.
	Flash_OPTR_ESE_Msk = 0x100
	// Bit ESE.
	Flash_OPTR_ESE = 0x100
	// Position of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Pos = 0x9
	// Bit mask of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Msk = 0xe00
	// Position of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Pos = 0xc
	// Bit mask of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Msk = 0x1000
	// Bit NRST_STOP.
	Flash_OPTR_NRST_STOP = 0x1000
	// Position of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Pos = 0xd
	// Bit mask of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Msk = 0x2000
	// Bit NRST_STDBY.
	Flash_OPTR_NRST_STDBY = 0x2000
	// Position of NRST_SHDW field.
	Flash_OPTR_NRST_SHDW_Pos = 0xe
	// Bit mask of NRST_SHDW field.
	Flash_OPTR_NRST_SHDW_Msk = 0x4000
	// Bit NRST_SHDW.
	Flash_OPTR_NRST_SHDW = 0x4000
	// Position of IDWG_SW field.
	Flash_OPTR_IDWG_SW_Pos = 0x10
	// Bit mask of IDWG_SW field.
	Flash_OPTR_IDWG_SW_Msk = 0x10000
	// Bit IDWG_SW.
	Flash_OPTR_IDWG_SW = 0x10000
	// Position of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Pos = 0x11
	// Bit mask of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Msk = 0x20000
	// Bit IWDG_STOP.
	Flash_OPTR_IWDG_STOP = 0x20000
	// Position of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Pos = 0x12
	// Bit mask of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Msk = 0x40000
	// Bit IWDG_STDBY.
	Flash_OPTR_IWDG_STDBY = 0x40000
	// Position of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Pos = 0x13
	// Bit mask of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Msk = 0x80000
	// Bit WWDG_SW.
	Flash_OPTR_WWDG_SW = 0x80000
	// Position of NBOOT1 field.
	Flash_OPTR_NBOOT1_Pos = 0x17
	// Bit mask of NBOOT1 field.
	Flash_OPTR_NBOOT1_Msk = 0x800000
	// Bit NBOOT1.
	Flash_OPTR_NBOOT1 = 0x800000
	// Position of SRAM2_PE field.
	Flash_OPTR_SRAM2_PE_Pos = 0x18
	// Bit mask of SRAM2_PE field.
	Flash_OPTR_SRAM2_PE_Msk = 0x1000000
	// Bit SRAM2_PE.
	Flash_OPTR_SRAM2_PE = 0x1000000
	// Position of SRAM2_RST field.
	Flash_OPTR_SRAM2_RST_Pos = 0x19
	// Bit mask of SRAM2_RST field.
	Flash_OPTR_SRAM2_RST_Msk = 0x2000000
	// Bit SRAM2_RST.
	Flash_OPTR_SRAM2_RST = 0x2000000
	// Position of NSWBOOT0 field.
	Flash_OPTR_NSWBOOT0_Pos = 0x1a
	// Bit mask of NSWBOOT0 field.
	Flash_OPTR_NSWBOOT0_Msk = 0x4000000
	// Bit NSWBOOT0.
	Flash_OPTR_NSWBOOT0 = 0x4000000
	// Position of NBOOT0 field.
	Flash_OPTR_NBOOT0_Pos = 0x1b
	// Bit mask of NBOOT0 field.
	Flash_OPTR_NBOOT0_Msk = 0x8000000
	// Bit NBOOT0.
	Flash_OPTR_NBOOT0 = 0x8000000
	// Position of AGC_TRIM field.
	Flash_OPTR_AGC_TRIM_Pos = 0x1d
	// Bit mask of AGC_TRIM field.
	Flash_OPTR_AGC_TRIM_Msk = 0xe0000000

	// PCROP1ASR: Flash Bank 1 PCROP Start address zone A register
	// Position of PCROP1A_STRT field.
	Flash_PCROP1ASR_PCROP1A_STRT_Pos = 0x0
	// Bit mask of PCROP1A_STRT field.
	Flash_PCROP1ASR_PCROP1A_STRT_Msk = 0x1ff

	// PCROP1AER: Flash Bank 1 PCROP End address zone A register
	// Position of PCROP1A_END field.
	Flash_PCROP1AER_PCROP1A_END_Pos = 0x0
	// Bit mask of PCROP1A_END field.
	Flash_PCROP1AER_PCROP1A_END_Msk = 0x1ff
	// Position of PCROP_RDP field.
	Flash_PCROP1AER_PCROP_RDP_Pos = 0x1f
	// Bit mask of PCROP_RDP field.
	Flash_PCROP1AER_PCROP_RDP_Msk = 0x80000000
	// Bit PCROP_RDP.
	Flash_PCROP1AER_PCROP_RDP = 0x80000000

	// WRP1AR: Flash Bank 1 WRP area A address register
	// Position of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Pos = 0x0
	// Bit mask of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Msk = 0xff
	// Position of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Pos = 0x10
	// Bit mask of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Msk = 0xff0000

	// WRP1BR: Flash Bank 1 WRP area B address register
	// Position of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Pos = 0x10
	// Bit mask of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Msk = 0xff0000
	// Position of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Pos = 0x0
	// Bit mask of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Msk = 0xff

	// PCROP1BSR: Flash Bank 1 PCROP Start address area B register
	// Position of PCROP1B_STRT field.
	Flash_PCROP1BSR_PCROP1B_STRT_Pos = 0x0
	// Bit mask of PCROP1B_STRT field.
	Flash_PCROP1BSR_PCROP1B_STRT_Msk = 0x1ff

	// PCROP1BER: Flash Bank 1 PCROP End address area B register
	// Position of PCROP1B_END field.
	Flash_PCROP1BER_PCROP1B_END_Pos = 0x0
	// Bit mask of PCROP1B_END field.
	Flash_PCROP1BER_PCROP1B_END_Msk = 0x1ff

	// IPCCBR: IPCC mailbox data buffer address register
	// Position of IPCCDBA field.
	Flash_IPCCBR_IPCCDBA_Pos = 0x0
	// Bit mask of IPCCDBA field.
	Flash_IPCCBR_IPCCDBA_Msk = 0x3fff

	// C2ACR: CPU2 cortex M0 access control register
	// Position of PRFTEN field.
	Flash_C2ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	Flash_C2ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	Flash_C2ACR_PRFTEN = 0x100
	// Position of ICEN field.
	Flash_C2ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	Flash_C2ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	Flash_C2ACR_ICEN = 0x200
	// Position of ICRST field.
	Flash_C2ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	Flash_C2ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	Flash_C2ACR_ICRST = 0x800
	// Position of PES field.
	Flash_C2ACR_PES_Pos = 0xf
	// Bit mask of PES field.
	Flash_C2ACR_PES_Msk = 0x8000
	// Bit PES.
	Flash_C2ACR_PES = 0x8000

	// C2SR: CPU2 cortex M0 status register
	// Position of EOP field.
	Flash_C2SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	Flash_C2SR_EOP_Msk = 0x1
	// Bit EOP.
	Flash_C2SR_EOP = 0x1
	// Position of OPERR field.
	Flash_C2SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	Flash_C2SR_OPERR_Msk = 0x2
	// Bit OPERR.
	Flash_C2SR_OPERR = 0x2
	// Position of PROGERR field.
	Flash_C2SR_PROGERR_Pos = 0x3
	// Bit mask of PROGERR field.
	Flash_C2SR_PROGERR_Msk = 0x8
	// Bit PROGERR.
	Flash_C2SR_PROGERR = 0x8
	// Position of WRPERR field.
	Flash_C2SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	Flash_C2SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	Flash_C2SR_WRPERR = 0x10
	// Position of PGAERR field.
	Flash_C2SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	Flash_C2SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	Flash_C2SR_PGAERR = 0x20
	// Position of SIZERR field.
	Flash_C2SR_SIZERR_Pos = 0x6
	// Bit mask of SIZERR field.
	Flash_C2SR_SIZERR_Msk = 0x40
	// Bit SIZERR.
	Flash_C2SR_SIZERR = 0x40
	// Position of PGSERR field.
	Flash_C2SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	Flash_C2SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	Flash_C2SR_PGSERR = 0x80
	// Position of MISSERR field.
	Flash_C2SR_MISSERR_Pos = 0x8
	// Bit mask of MISSERR field.
	Flash_C2SR_MISSERR_Msk = 0x100
	// Bit MISSERR.
	Flash_C2SR_MISSERR = 0x100
	// Position of FASTERR field.
	Flash_C2SR_FASTERR_Pos = 0x9
	// Bit mask of FASTERR field.
	Flash_C2SR_FASTERR_Msk = 0x200
	// Bit FASTERR.
	Flash_C2SR_FASTERR = 0x200
	// Position of RDERR field.
	Flash_C2SR_RDERR_Pos = 0xe
	// Bit mask of RDERR field.
	Flash_C2SR_RDERR_Msk = 0x4000
	// Bit RDERR.
	Flash_C2SR_RDERR = 0x4000
	// Position of BSY field.
	Flash_C2SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	Flash_C2SR_BSY_Msk = 0x10000
	// Bit BSY.
	Flash_C2SR_BSY = 0x10000
	// Position of CFGBSY field.
	Flash_C2SR_CFGBSY_Pos = 0x12
	// Bit mask of CFGBSY field.
	Flash_C2SR_CFGBSY_Msk = 0x40000
	// Bit CFGBSY.
	Flash_C2SR_CFGBSY = 0x40000
	// Position of PESD field.
	Flash_C2SR_PESD_Pos = 0x13
	// Bit mask of PESD field.
	Flash_C2SR_PESD_Msk = 0x80000
	// Bit PESD.
	Flash_C2SR_PESD = 0x80000

	// C2CR: CPU2 cortex M0 control register
	// Position of PG field.
	Flash_C2CR_PG_Pos = 0x0
	// Bit mask of PG field.
	Flash_C2CR_PG_Msk = 0x1
	// Bit PG.
	Flash_C2CR_PG = 0x1
	// Position of PER field.
	Flash_C2CR_PER_Pos = 0x1
	// Bit mask of PER field.
	Flash_C2CR_PER_Msk = 0x2
	// Bit PER.
	Flash_C2CR_PER = 0x2
	// Position of MER field.
	Flash_C2CR_MER_Pos = 0x2
	// Bit mask of MER field.
	Flash_C2CR_MER_Msk = 0x4
	// Bit MER.
	Flash_C2CR_MER = 0x4
	// Position of PNB field.
	Flash_C2CR_PNB_Pos = 0x3
	// Bit mask of PNB field.
	Flash_C2CR_PNB_Msk = 0x7f8
	// Position of STRT field.
	Flash_C2CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	Flash_C2CR_STRT_Msk = 0x10000
	// Bit STRT.
	Flash_C2CR_STRT = 0x10000
	// Position of FSTPG field.
	Flash_C2CR_FSTPG_Pos = 0x12
	// Bit mask of FSTPG field.
	Flash_C2CR_FSTPG_Msk = 0x40000
	// Bit FSTPG.
	Flash_C2CR_FSTPG = 0x40000
	// Position of EOPIE field.
	Flash_C2CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	Flash_C2CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	Flash_C2CR_EOPIE = 0x1000000
	// Position of ERRIE field.
	Flash_C2CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	Flash_C2CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	Flash_C2CR_ERRIE = 0x2000000
	// Position of RDERRIE field.
	Flash_C2CR_RDERRIE_Pos = 0x1a
	// Bit mask of RDERRIE field.
	Flash_C2CR_RDERRIE_Msk = 0x4000000
	// Bit RDERRIE.
	Flash_C2CR_RDERRIE = 0x4000000

	// SFR: Secure flash start address register
	// Position of SFSA field.
	Flash_SFR_SFSA_Pos = 0x0
	// Bit mask of SFSA field.
	Flash_SFR_SFSA_Msk = 0xff
	// Position of DDS field.
	Flash_SFR_DDS_Pos = 0xc
	// Bit mask of DDS field.
	Flash_SFR_DDS_Msk = 0x1000
	// Bit DDS.
	Flash_SFR_DDS = 0x1000
	// Position of FSD field.
	Flash_SFR_FSD_Pos = 0x8
	// Bit mask of FSD field.
	Flash_SFR_FSD_Msk = 0x100
	// Bit FSD.
	Flash_SFR_FSD = 0x100

	// SRRVR: Secure SRAM2 start address and cortex M0 reset vector register
	// Position of SBRV field.
	Flash_SRRVR_SBRV_Pos = 0x0
	// Bit mask of SBRV field.
	Flash_SRRVR_SBRV_Msk = 0x3ffff
	// Position of SBRSA field.
	Flash_SRRVR_SBRSA_Pos = 0x12
	// Bit mask of SBRSA field.
	Flash_SRRVR_SBRSA_Msk = 0x7c0000
	// Position of BRSD field.
	Flash_SRRVR_BRSD_Pos = 0x17
	// Bit mask of BRSD field.
	Flash_SRRVR_BRSD_Msk = 0x800000
	// Bit BRSD.
	Flash_SRRVR_BRSD = 0x800000
	// Position of SNBRSA field.
	Flash_SRRVR_SNBRSA_Pos = 0x19
	// Bit mask of SNBRSA field.
	Flash_SRRVR_SNBRSA_Msk = 0x3e000000
	// Position of C2OPT field.
	Flash_SRRVR_C2OPT_Pos = 0x1f
	// Bit mask of C2OPT field.
	Flash_SRRVR_C2OPT_Msk = 0x80000000
	// Bit C2OPT.
	Flash_SRRVR_C2OPT = 0x80000000
	// Position of NBRSD field.
	Flash_SRRVR_NBRSD_Pos = 0x1e
	// Bit mask of NBRSD field.
	Flash_SRRVR_NBRSD_Msk = 0x40000000
	// Bit NBRSD.
	Flash_SRRVR_NBRSD = 0x40000000
)

// Bitfields for QUADSPI: QuadSPI interface
const (
	// CR: control register
	// Position of PRESCALER field.
	QUADSPI_CR_PRESCALER_Pos = 0x18
	// Bit mask of PRESCALER field.
	QUADSPI_CR_PRESCALER_Msk = 0xff000000
	// Position of PMM field.
	QUADSPI_CR_PMM_Pos = 0x17
	// Bit mask of PMM field.
	QUADSPI_CR_PMM_Msk = 0x800000
	// Bit PMM.
	QUADSPI_CR_PMM = 0x800000
	// Position of APMS field.
	QUADSPI_CR_APMS_Pos = 0x16
	// Bit mask of APMS field.
	QUADSPI_CR_APMS_Msk = 0x400000
	// Bit APMS.
	QUADSPI_CR_APMS = 0x400000
	// Position of TOIE field.
	QUADSPI_CR_TOIE_Pos = 0x14
	// Bit mask of TOIE field.
	QUADSPI_CR_TOIE_Msk = 0x100000
	// Bit TOIE.
	QUADSPI_CR_TOIE = 0x100000
	// Position of SMIE field.
	QUADSPI_CR_SMIE_Pos = 0x13
	// Bit mask of SMIE field.
	QUADSPI_CR_SMIE_Msk = 0x80000
	// Bit SMIE.
	QUADSPI_CR_SMIE = 0x80000
	// Position of FTIE field.
	QUADSPI_CR_FTIE_Pos = 0x12
	// Bit mask of FTIE field.
	QUADSPI_CR_FTIE_Msk = 0x40000
	// Bit FTIE.
	QUADSPI_CR_FTIE = 0x40000
	// Position of TCIE field.
	QUADSPI_CR_TCIE_Pos = 0x11
	// Bit mask of TCIE field.
	QUADSPI_CR_TCIE_Msk = 0x20000
	// Bit TCIE.
	QUADSPI_CR_TCIE = 0x20000
	// Position of TEIE field.
	QUADSPI_CR_TEIE_Pos = 0x10
	// Bit mask of TEIE field.
	QUADSPI_CR_TEIE_Msk = 0x10000
	// Bit TEIE.
	QUADSPI_CR_TEIE = 0x10000
	// Position of FTHRES field.
	QUADSPI_CR_FTHRES_Pos = 0x8
	// Bit mask of FTHRES field.
	QUADSPI_CR_FTHRES_Msk = 0xf00
	// Position of SSHIFT field.
	QUADSPI_CR_SSHIFT_Pos = 0x4
	// Bit mask of SSHIFT field.
	QUADSPI_CR_SSHIFT_Msk = 0x10
	// Bit SSHIFT.
	QUADSPI_CR_SSHIFT = 0x10
	// Position of TCEN field.
	QUADSPI_CR_TCEN_Pos = 0x3
	// Bit mask of TCEN field.
	QUADSPI_CR_TCEN_Msk = 0x8
	// Bit TCEN.
	QUADSPI_CR_TCEN = 0x8
	// Position of DMAEN field.
	QUADSPI_CR_DMAEN_Pos = 0x2
	// Bit mask of DMAEN field.
	QUADSPI_CR_DMAEN_Msk = 0x4
	// Bit DMAEN.
	QUADSPI_CR_DMAEN = 0x4
	// Position of ABORT field.
	QUADSPI_CR_ABORT_Pos = 0x1
	// Bit mask of ABORT field.
	QUADSPI_CR_ABORT_Msk = 0x2
	// Bit ABORT.
	QUADSPI_CR_ABORT = 0x2
	// Position of EN field.
	QUADSPI_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	QUADSPI_CR_EN_Msk = 0x1
	// Bit EN.
	QUADSPI_CR_EN = 0x1

	// DCR: device configuration register
	// Position of FSIZE field.
	QUADSPI_DCR_FSIZE_Pos = 0x10
	// Bit mask of FSIZE field.
	QUADSPI_DCR_FSIZE_Msk = 0x1f0000
	// Position of CSHT field.
	QUADSPI_DCR_CSHT_Pos = 0x8
	// Bit mask of CSHT field.
	QUADSPI_DCR_CSHT_Msk = 0x700
	// Position of CKMODE field.
	QUADSPI_DCR_CKMODE_Pos = 0x0
	// Bit mask of CKMODE field.
	QUADSPI_DCR_CKMODE_Msk = 0x1
	// Bit CKMODE.
	QUADSPI_DCR_CKMODE = 0x1

	// SR: status register
	// Position of FLEVEL field.
	QUADSPI_SR_FLEVEL_Pos = 0x8
	// Bit mask of FLEVEL field.
	QUADSPI_SR_FLEVEL_Msk = 0x1f00
	// Position of BUSY field.
	QUADSPI_SR_BUSY_Pos = 0x5
	// Bit mask of BUSY field.
	QUADSPI_SR_BUSY_Msk = 0x20
	// Bit BUSY.
	QUADSPI_SR_BUSY = 0x20
	// Position of TOF field.
	QUADSPI_SR_TOF_Pos = 0x4
	// Bit mask of TOF field.
	QUADSPI_SR_TOF_Msk = 0x10
	// Bit TOF.
	QUADSPI_SR_TOF = 0x10
	// Position of SMF field.
	QUADSPI_SR_SMF_Pos = 0x3
	// Bit mask of SMF field.
	QUADSPI_SR_SMF_Msk = 0x8
	// Bit SMF.
	QUADSPI_SR_SMF = 0x8
	// Position of FTF field.
	QUADSPI_SR_FTF_Pos = 0x2
	// Bit mask of FTF field.
	QUADSPI_SR_FTF_Msk = 0x4
	// Bit FTF.
	QUADSPI_SR_FTF = 0x4
	// Position of TCF field.
	QUADSPI_SR_TCF_Pos = 0x1
	// Bit mask of TCF field.
	QUADSPI_SR_TCF_Msk = 0x2
	// Bit TCF.
	QUADSPI_SR_TCF = 0x2
	// Position of TEF field.
	QUADSPI_SR_TEF_Pos = 0x0
	// Bit mask of TEF field.
	QUADSPI_SR_TEF_Msk = 0x1
	// Bit TEF.
	QUADSPI_SR_TEF = 0x1

	// FCR: flag clear register
	// Position of CTOF field.
	QUADSPI_FCR_CTOF_Pos = 0x4
	// Bit mask of CTOF field.
	QUADSPI_FCR_CTOF_Msk = 0x10
	// Bit CTOF.
	QUADSPI_FCR_CTOF = 0x10
	// Position of CSMF field.
	QUADSPI_FCR_CSMF_Pos = 0x3
	// Bit mask of CSMF field.
	QUADSPI_FCR_CSMF_Msk = 0x8
	// Bit CSMF.
	QUADSPI_FCR_CSMF = 0x8
	// Position of CTCF field.
	QUADSPI_FCR_CTCF_Pos = 0x1
	// Bit mask of CTCF field.
	QUADSPI_FCR_CTCF_Msk = 0x2
	// Bit CTCF.
	QUADSPI_FCR_CTCF = 0x2
	// Position of CTEF field.
	QUADSPI_FCR_CTEF_Pos = 0x0
	// Bit mask of CTEF field.
	QUADSPI_FCR_CTEF_Msk = 0x1
	// Bit CTEF.
	QUADSPI_FCR_CTEF = 0x1

	// DLR: data length register
	// Position of DL field.
	QUADSPI_DLR_DL_Pos = 0x0
	// Bit mask of DL field.
	QUADSPI_DLR_DL_Msk = 0xffffffff

	// CCR: communication configuration register
	// Position of DDRM field.
	QUADSPI_CCR_DDRM_Pos = 0x1f
	// Bit mask of DDRM field.
	QUADSPI_CCR_DDRM_Msk = 0x80000000
	// Bit DDRM.
	QUADSPI_CCR_DDRM = 0x80000000
	// Position of SIOO field.
	QUADSPI_CCR_SIOO_Pos = 0x1c
	// Bit mask of SIOO field.
	QUADSPI_CCR_SIOO_Msk = 0x10000000
	// Bit SIOO.
	QUADSPI_CCR_SIOO = 0x10000000
	// Position of FMODE field.
	QUADSPI_CCR_FMODE_Pos = 0x1a
	// Bit mask of FMODE field.
	QUADSPI_CCR_FMODE_Msk = 0xc000000
	// Position of DMODE field.
	QUADSPI_CCR_DMODE_Pos = 0x18
	// Bit mask of DMODE field.
	QUADSPI_CCR_DMODE_Msk = 0x3000000
	// Position of DCYC field.
	QUADSPI_CCR_DCYC_Pos = 0x12
	// Bit mask of DCYC field.
	QUADSPI_CCR_DCYC_Msk = 0x7c0000
	// Position of ABSIZE field.
	QUADSPI_CCR_ABSIZE_Pos = 0x10
	// Bit mask of ABSIZE field.
	QUADSPI_CCR_ABSIZE_Msk = 0x30000
	// Position of ABMODE field.
	QUADSPI_CCR_ABMODE_Pos = 0xe
	// Bit mask of ABMODE field.
	QUADSPI_CCR_ABMODE_Msk = 0xc000
	// Position of ADSIZE field.
	QUADSPI_CCR_ADSIZE_Pos = 0xc
	// Bit mask of ADSIZE field.
	QUADSPI_CCR_ADSIZE_Msk = 0x3000
	// Position of ADMODE field.
	QUADSPI_CCR_ADMODE_Pos = 0xa
	// Bit mask of ADMODE field.
	QUADSPI_CCR_ADMODE_Msk = 0xc00
	// Position of IMODE field.
	QUADSPI_CCR_IMODE_Pos = 0x8
	// Bit mask of IMODE field.
	QUADSPI_CCR_IMODE_Msk = 0x300
	// Position of INSTRUCTION field.
	QUADSPI_CCR_INSTRUCTION_Pos = 0x0
	// Bit mask of INSTRUCTION field.
	QUADSPI_CCR_INSTRUCTION_Msk = 0xff

	// AR: address register
	// Position of ADDRESS field.
	QUADSPI_AR_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	QUADSPI_AR_ADDRESS_Msk = 0xffffffff

	// ABR: ABR
	// Position of ALTERNATE field.
	QUADSPI_ABR_ALTERNATE_Pos = 0x0
	// Bit mask of ALTERNATE field.
	QUADSPI_ABR_ALTERNATE_Msk = 0xffffffff

	// DR: data register
	// Position of DATA field.
	QUADSPI_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	QUADSPI_DR_DATA_Msk = 0xffffffff

	// PSMKR: polling status mask register
	// Position of MASK field.
	QUADSPI_PSMKR_MASK_Pos = 0x0
	// Bit mask of MASK field.
	QUADSPI_PSMKR_MASK_Msk = 0xffffffff

	// PSMAR: polling status match register
	// Position of MATCH field.
	QUADSPI_PSMAR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	QUADSPI_PSMAR_MATCH_Msk = 0xffffffff

	// PIR: polling interval register
	// Position of INTERVAL field.
	QUADSPI_PIR_INTERVAL_Pos = 0x0
	// Bit mask of INTERVAL field.
	QUADSPI_PIR_INTERVAL_Msk = 0xffff

	// LPTR: low-power timeout register
	// Position of TIMEOUT field.
	QUADSPI_LPTR_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	QUADSPI_LPTR_TIMEOUT_Msk = 0xffff
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	// Position of PLLSAI1RDY field.
	RCC_CR_PLLSAI1RDY_Pos = 0x1b
	// Bit mask of PLLSAI1RDY field.
	RCC_CR_PLLSAI1RDY_Msk = 0x8000000
	// Bit PLLSAI1RDY.
	RCC_CR_PLLSAI1RDY = 0x8000000
	// Position of PLLSAI1ON field.
	RCC_CR_PLLSAI1ON_Pos = 0x1a
	// Bit mask of PLLSAI1ON field.
	RCC_CR_PLLSAI1ON_Msk = 0x4000000
	// Bit PLLSAI1ON.
	RCC_CR_PLLSAI1ON = 0x4000000
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Position of HSEPRE field.
	RCC_CR_HSEPRE_Pos = 0x14
	// Bit mask of HSEPRE field.
	RCC_CR_HSEPRE_Msk = 0x100000
	// Bit HSEPRE.
	RCC_CR_HSEPRE = 0x100000
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Position of HSIKERDY field.
	RCC_CR_HSIKERDY_Pos = 0xc
	// Bit mask of HSIKERDY field.
	RCC_CR_HSIKERDY_Msk = 0x1000
	// Bit HSIKERDY.
	RCC_CR_HSIKERDY = 0x1000
	// Position of HSIASFS field.
	RCC_CR_HSIASFS_Pos = 0xb
	// Bit mask of HSIASFS field.
	RCC_CR_HSIASFS_Msk = 0x800
	// Bit HSIASFS.
	RCC_CR_HSIASFS = 0x800
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0xa
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x400
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x400
	// Position of HSIKERON field.
	RCC_CR_HSIKERON_Pos = 0x9
	// Bit mask of HSIKERON field.
	RCC_CR_HSIKERON_Msk = 0x200
	// Bit HSIKERON.
	RCC_CR_HSIKERON = 0x200
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x8
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x100
	// Bit HSION.
	RCC_CR_HSION = 0x100
	// Position of MSIRANGE field.
	RCC_CR_MSIRANGE_Pos = 0x4
	// Bit mask of MSIRANGE field.
	RCC_CR_MSIRANGE_Msk = 0xf0
	// Position of MSIPLLEN field.
	RCC_CR_MSIPLLEN_Pos = 0x2
	// Bit mask of MSIPLLEN field.
	RCC_CR_MSIPLLEN_Msk = 0x4
	// Bit MSIPLLEN.
	RCC_CR_MSIPLLEN = 0x4
	// Position of MSIRDY field.
	RCC_CR_MSIRDY_Pos = 0x1
	// Bit mask of MSIRDY field.
	RCC_CR_MSIRDY_Msk = 0x2
	// Bit MSIRDY.
	RCC_CR_MSIRDY = 0x2
	// Position of MSION field.
	RCC_CR_MSION_Pos = 0x0
	// Bit mask of MSION field.
	RCC_CR_MSION_Msk = 0x1
	// Bit MSION.
	RCC_CR_MSION = 0x1

	// ICSCR: Internal clock sources calibration register
	// Position of HSITRIM field.
	RCC_ICSCR_HSITRIM_Pos = 0x18
	// Bit mask of HSITRIM field.
	RCC_ICSCR_HSITRIM_Msk = 0x7f000000
	// Position of HSICAL field.
	RCC_ICSCR_HSICAL_Pos = 0x10
	// Bit mask of HSICAL field.
	RCC_ICSCR_HSICAL_Msk = 0xff0000
	// Position of MSITRIM field.
	RCC_ICSCR_MSITRIM_Pos = 0x8
	// Bit mask of MSITRIM field.
	RCC_ICSCR_MSITRIM_Msk = 0xff00
	// Position of MSICAL field.
	RCC_ICSCR_MSICAL_Pos = 0x0
	// Bit mask of MSICAL field.
	RCC_ICSCR_MSICAL_Msk = 0xff

	// CFGR: Clock configuration register
	// Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Pos = 0x1c
	// Bit mask of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk = 0x70000000
	// Position of MCOSEL field.
	RCC_CFGR_MCOSEL_Pos = 0x18
	// Bit mask of MCOSEL field.
	RCC_CFGR_MCOSEL_Msk = 0xf000000
	// Position of PPRE2F field.
	RCC_CFGR_PPRE2F_Pos = 0x12
	// Bit mask of PPRE2F field.
	RCC_CFGR_PPRE2F_Msk = 0x40000
	// Bit PPRE2F.
	RCC_CFGR_PPRE2F = 0x40000
	// Position of PPRE1F field.
	RCC_CFGR_PPRE1F_Pos = 0x11
	// Bit mask of PPRE1F field.
	RCC_CFGR_PPRE1F_Msk = 0x20000
	// Bit PPRE1F.
	RCC_CFGR_PPRE1F = 0x20000
	// Position of HPREF field.
	RCC_CFGR_HPREF_Pos = 0x10
	// Bit mask of HPREF field.
	RCC_CFGR_HPREF_Msk = 0x10000
	// Bit HPREF.
	RCC_CFGR_HPREF = 0x10000
	// Position of STOPWUCK field.
	RCC_CFGR_STOPWUCK_Pos = 0xf
	// Bit mask of STOPWUCK field.
	RCC_CFGR_STOPWUCK_Msk = 0x8000
	// Bit STOPWUCK.
	RCC_CFGR_STOPWUCK = 0x8000
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xb
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0x3800
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0x8
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x700
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3

	// PLLCFGR: PLLSYS configuration register
	// Position of PLLR field.
	RCC_PLLCFGR_PLLR_Pos = 0x1d
	// Bit mask of PLLR field.
	RCC_PLLCFGR_PLLR_Msk = 0xe0000000
	// Position of PLLREN field.
	RCC_PLLCFGR_PLLREN_Pos = 0x1c
	// Bit mask of PLLREN field.
	RCC_PLLCFGR_PLLREN_Msk = 0x10000000
	// Bit PLLREN.
	RCC_PLLCFGR_PLLREN = 0x10000000
	// Position of PLLQ field.
	RCC_PLLCFGR_PLLQ_Pos = 0x19
	// Bit mask of PLLQ field.
	RCC_PLLCFGR_PLLQ_Msk = 0xe000000
	// Position of PLLQEN field.
	RCC_PLLCFGR_PLLQEN_Pos = 0x18
	// Bit mask of PLLQEN field.
	RCC_PLLCFGR_PLLQEN_Msk = 0x1000000
	// Bit PLLQEN.
	RCC_PLLCFGR_PLLQEN = 0x1000000
	// Position of PLLP field.
	RCC_PLLCFGR_PLLP_Pos = 0x11
	// Bit mask of PLLP field.
	RCC_PLLCFGR_PLLP_Msk = 0x3e0000
	// Position of PLLPEN field.
	RCC_PLLCFGR_PLLPEN_Pos = 0x10
	// Bit mask of PLLPEN field.
	RCC_PLLCFGR_PLLPEN_Msk = 0x10000
	// Bit PLLPEN.
	RCC_PLLCFGR_PLLPEN = 0x10000
	// Position of PLLN field.
	RCC_PLLCFGR_PLLN_Pos = 0x8
	// Bit mask of PLLN field.
	RCC_PLLCFGR_PLLN_Msk = 0x7f00
	// Position of PLLM field.
	RCC_PLLCFGR_PLLM_Pos = 0x4
	// Bit mask of PLLM field.
	RCC_PLLCFGR_PLLM_Msk = 0x70
	// Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Pos = 0x0
	// Bit mask of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk = 0x3

	// PLLSAI1CFGR: PLLSAI1 configuration register
	// Position of PLLR field.
	RCC_PLLSAI1CFGR_PLLR_Pos = 0x1d
	// Bit mask of PLLR field.
	RCC_PLLSAI1CFGR_PLLR_Msk = 0xe0000000
	// Position of PLLREN field.
	RCC_PLLSAI1CFGR_PLLREN_Pos = 0x1c
	// Bit mask of PLLREN field.
	RCC_PLLSAI1CFGR_PLLREN_Msk = 0x10000000
	// Bit PLLREN.
	RCC_PLLSAI1CFGR_PLLREN = 0x10000000
	// Position of PLLQ field.
	RCC_PLLSAI1CFGR_PLLQ_Pos = 0x19
	// Bit mask of PLLQ field.
	RCC_PLLSAI1CFGR_PLLQ_Msk = 0xe000000
	// Position of PLLQEN field.
	RCC_PLLSAI1CFGR_PLLQEN_Pos = 0x18
	// Bit mask of PLLQEN field.
	RCC_PLLSAI1CFGR_PLLQEN_Msk = 0x1000000
	// Bit PLLQEN.
	RCC_PLLSAI1CFGR_PLLQEN = 0x1000000
	// Position of PLLP field.
	RCC_PLLSAI1CFGR_PLLP_Pos = 0x11
	// Bit mask of PLLP field.
	RCC_PLLSAI1CFGR_PLLP_Msk = 0x3e0000
	// Position of PLLPEN field.
	RCC_PLLSAI1CFGR_PLLPEN_Pos = 0x10
	// Bit mask of PLLPEN field.
	RCC_PLLSAI1CFGR_PLLPEN_Msk = 0x10000
	// Bit PLLPEN.
	RCC_PLLSAI1CFGR_PLLPEN = 0x10000
	// Position of PLLN field.
	RCC_PLLSAI1CFGR_PLLN_Pos = 0x8
	// Bit mask of PLLN field.
	RCC_PLLSAI1CFGR_PLLN_Msk = 0x7f00

	// CIER: Clock interrupt enable register
	// Position of LSI2RDYIE field.
	RCC_CIER_LSI2RDYIE_Pos = 0xb
	// Bit mask of LSI2RDYIE field.
	RCC_CIER_LSI2RDYIE_Msk = 0x800
	// Bit LSI2RDYIE.
	RCC_CIER_LSI2RDYIE = 0x800
	// Position of HSI48RDYIE field.
	RCC_CIER_HSI48RDYIE_Pos = 0xa
	// Bit mask of HSI48RDYIE field.
	RCC_CIER_HSI48RDYIE_Msk = 0x400
	// Bit HSI48RDYIE.
	RCC_CIER_HSI48RDYIE = 0x400
	// Position of LSECSSIE field.
	RCC_CIER_LSECSSIE_Pos = 0x9
	// Bit mask of LSECSSIE field.
	RCC_CIER_LSECSSIE_Msk = 0x200
	// Bit LSECSSIE.
	RCC_CIER_LSECSSIE = 0x200
	// Position of PLLSAI1RDYIE field.
	RCC_CIER_PLLSAI1RDYIE_Pos = 0x6
	// Bit mask of PLLSAI1RDYIE field.
	RCC_CIER_PLLSAI1RDYIE_Msk = 0x40
	// Bit PLLSAI1RDYIE.
	RCC_CIER_PLLSAI1RDYIE = 0x40
	// Position of PLLRDYIE field.
	RCC_CIER_PLLRDYIE_Pos = 0x5
	// Bit mask of PLLRDYIE field.
	RCC_CIER_PLLRDYIE_Msk = 0x20
	// Bit PLLRDYIE.
	RCC_CIER_PLLRDYIE = 0x20
	// Position of HSERDYIE field.
	RCC_CIER_HSERDYIE_Pos = 0x4
	// Bit mask of HSERDYIE field.
	RCC_CIER_HSERDYIE_Msk = 0x10
	// Bit HSERDYIE.
	RCC_CIER_HSERDYIE = 0x10
	// Position of HSIRDYIE field.
	RCC_CIER_HSIRDYIE_Pos = 0x3
	// Bit mask of HSIRDYIE field.
	RCC_CIER_HSIRDYIE_Msk = 0x8
	// Bit HSIRDYIE.
	RCC_CIER_HSIRDYIE = 0x8
	// Position of MSIRDYIE field.
	RCC_CIER_MSIRDYIE_Pos = 0x2
	// Bit mask of MSIRDYIE field.
	RCC_CIER_MSIRDYIE_Msk = 0x4
	// Bit MSIRDYIE.
	RCC_CIER_MSIRDYIE = 0x4
	// Position of LSERDYIE field.
	RCC_CIER_LSERDYIE_Pos = 0x1
	// Bit mask of LSERDYIE field.
	RCC_CIER_LSERDYIE_Msk = 0x2
	// Bit LSERDYIE.
	RCC_CIER_LSERDYIE = 0x2
	// Position of LSI1RDYIE field.
	RCC_CIER_LSI1RDYIE_Pos = 0x0
	// Bit mask of LSI1RDYIE field.
	RCC_CIER_LSI1RDYIE_Msk = 0x1
	// Bit LSI1RDYIE.
	RCC_CIER_LSI1RDYIE = 0x1

	// CIFR: Clock interrupt flag register
	// Position of LSI2RDYF field.
	RCC_CIFR_LSI2RDYF_Pos = 0xb
	// Bit mask of LSI2RDYF field.
	RCC_CIFR_LSI2RDYF_Msk = 0x800
	// Bit LSI2RDYF.
	RCC_CIFR_LSI2RDYF = 0x800
	// Position of HSI48RDYF field.
	RCC_CIFR_HSI48RDYF_Pos = 0xa
	// Bit mask of HSI48RDYF field.
	RCC_CIFR_HSI48RDYF_Msk = 0x400
	// Bit HSI48RDYF.
	RCC_CIFR_HSI48RDYF = 0x400
	// Position of LSECSSF field.
	RCC_CIFR_LSECSSF_Pos = 0x9
	// Bit mask of LSECSSF field.
	RCC_CIFR_LSECSSF_Msk = 0x200
	// Bit LSECSSF.
	RCC_CIFR_LSECSSF = 0x200
	// Position of HSECSSF field.
	RCC_CIFR_HSECSSF_Pos = 0x8
	// Bit mask of HSECSSF field.
	RCC_CIFR_HSECSSF_Msk = 0x100
	// Bit HSECSSF.
	RCC_CIFR_HSECSSF = 0x100
	// Position of PLLSAI1RDYF field.
	RCC_CIFR_PLLSAI1RDYF_Pos = 0x6
	// Bit mask of PLLSAI1RDYF field.
	RCC_CIFR_PLLSAI1RDYF_Msk = 0x40
	// Bit PLLSAI1RDYF.
	RCC_CIFR_PLLSAI1RDYF = 0x40
	// Position of PLLRDYF field.
	RCC_CIFR_PLLRDYF_Pos = 0x5
	// Bit mask of PLLRDYF field.
	RCC_CIFR_PLLRDYF_Msk = 0x20
	// Bit PLLRDYF.
	RCC_CIFR_PLLRDYF = 0x20
	// Position of HSERDYF field.
	RCC_CIFR_HSERDYF_Pos = 0x4
	// Bit mask of HSERDYF field.
	RCC_CIFR_HSERDYF_Msk = 0x10
	// Bit HSERDYF.
	RCC_CIFR_HSERDYF = 0x10
	// Position of HSIRDYF field.
	RCC_CIFR_HSIRDYF_Pos = 0x3
	// Bit mask of HSIRDYF field.
	RCC_CIFR_HSIRDYF_Msk = 0x8
	// Bit HSIRDYF.
	RCC_CIFR_HSIRDYF = 0x8
	// Position of MSIRDYF field.
	RCC_CIFR_MSIRDYF_Pos = 0x2
	// Bit mask of MSIRDYF field.
	RCC_CIFR_MSIRDYF_Msk = 0x4
	// Bit MSIRDYF.
	RCC_CIFR_MSIRDYF = 0x4
	// Position of LSERDYF field.
	RCC_CIFR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIFR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIFR_LSERDYF = 0x2
	// Position of LSI1RDYF field.
	RCC_CIFR_LSI1RDYF_Pos = 0x0
	// Bit mask of LSI1RDYF field.
	RCC_CIFR_LSI1RDYF_Msk = 0x1
	// Bit LSI1RDYF.
	RCC_CIFR_LSI1RDYF = 0x1

	// CICR: Clock interrupt clear register
	// Position of LSI2RDYC field.
	RCC_CICR_LSI2RDYC_Pos = 0xb
	// Bit mask of LSI2RDYC field.
	RCC_CICR_LSI2RDYC_Msk = 0x800
	// Bit LSI2RDYC.
	RCC_CICR_LSI2RDYC = 0x800
	// Position of HSI48RDYC field.
	RCC_CICR_HSI48RDYC_Pos = 0xa
	// Bit mask of HSI48RDYC field.
	RCC_CICR_HSI48RDYC_Msk = 0x400
	// Bit HSI48RDYC.
	RCC_CICR_HSI48RDYC = 0x400
	// Position of LSECSSC field.
	RCC_CICR_LSECSSC_Pos = 0x9
	// Bit mask of LSECSSC field.
	RCC_CICR_LSECSSC_Msk = 0x200
	// Bit LSECSSC.
	RCC_CICR_LSECSSC = 0x200
	// Position of HSECSSC field.
	RCC_CICR_HSECSSC_Pos = 0x8
	// Bit mask of HSECSSC field.
	RCC_CICR_HSECSSC_Msk = 0x100
	// Bit HSECSSC.
	RCC_CICR_HSECSSC = 0x100
	// Position of PLLSAI1RDYC field.
	RCC_CICR_PLLSAI1RDYC_Pos = 0x6
	// Bit mask of PLLSAI1RDYC field.
	RCC_CICR_PLLSAI1RDYC_Msk = 0x40
	// Bit PLLSAI1RDYC.
	RCC_CICR_PLLSAI1RDYC = 0x40
	// Position of PLLRDYC field.
	RCC_CICR_PLLRDYC_Pos = 0x5
	// Bit mask of PLLRDYC field.
	RCC_CICR_PLLRDYC_Msk = 0x20
	// Bit PLLRDYC.
	RCC_CICR_PLLRDYC = 0x20
	// Position of HSERDYC field.
	RCC_CICR_HSERDYC_Pos = 0x4
	// Bit mask of HSERDYC field.
	RCC_CICR_HSERDYC_Msk = 0x10
	// Bit HSERDYC.
	RCC_CICR_HSERDYC = 0x10
	// Position of HSIRDYC field.
	RCC_CICR_HSIRDYC_Pos = 0x3
	// Bit mask of HSIRDYC field.
	RCC_CICR_HSIRDYC_Msk = 0x8
	// Bit HSIRDYC.
	RCC_CICR_HSIRDYC = 0x8
	// Position of MSIRDYC field.
	RCC_CICR_MSIRDYC_Pos = 0x2
	// Bit mask of MSIRDYC field.
	RCC_CICR_MSIRDYC_Msk = 0x4
	// Bit MSIRDYC.
	RCC_CICR_MSIRDYC = 0x4
	// Position of LSERDYC field.
	RCC_CICR_LSERDYC_Pos = 0x1
	// Bit mask of LSERDYC field.
	RCC_CICR_LSERDYC_Msk = 0x2
	// Bit LSERDYC.
	RCC_CICR_LSERDYC = 0x2
	// Position of LSI1RDYC field.
	RCC_CICR_LSI1RDYC_Pos = 0x0
	// Bit mask of LSI1RDYC field.
	RCC_CICR_LSI1RDYC_Msk = 0x1
	// Bit LSI1RDYC.
	RCC_CICR_LSI1RDYC = 0x1

	// SMPSCR: Step Down converter control register
	// Position of SMPSSWS field.
	RCC_SMPSCR_SMPSSWS_Pos = 0x8
	// Bit mask of SMPSSWS field.
	RCC_SMPSCR_SMPSSWS_Msk = 0x300
	// Position of SMPSDIV field.
	RCC_SMPSCR_SMPSDIV_Pos = 0x4
	// Bit mask of SMPSDIV field.
	RCC_SMPSCR_SMPSDIV_Msk = 0x30
	// Position of SMPSSEL field.
	RCC_SMPSCR_SMPSSEL_Pos = 0x0
	// Bit mask of SMPSSEL field.
	RCC_SMPSCR_SMPSSEL_Msk = 0x3

	// AHB1RSTR: AHB1 peripheral reset register
	// Position of TSCRST field.
	RCC_AHB1RSTR_TSCRST_Pos = 0x10
	// Bit mask of TSCRST field.
	RCC_AHB1RSTR_TSCRST_Msk = 0x10000
	// Bit TSCRST.
	RCC_AHB1RSTR_TSCRST = 0x10000
	// Position of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Pos = 0xc
	// Bit mask of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Msk = 0x1000
	// Bit CRCRST.
	RCC_AHB1RSTR_CRCRST = 0x1000
	// Position of DMAMUXRST field.
	RCC_AHB1RSTR_DMAMUXRST_Pos = 0x2
	// Bit mask of DMAMUXRST field.
	RCC_AHB1RSTR_DMAMUXRST_Msk = 0x4
	// Bit DMAMUXRST.
	RCC_AHB1RSTR_DMAMUXRST = 0x4
	// Position of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Pos = 0x1
	// Bit mask of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Msk = 0x2
	// Bit DMA2RST.
	RCC_AHB1RSTR_DMA2RST = 0x2
	// Position of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Pos = 0x0
	// Bit mask of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Msk = 0x1
	// Bit DMA1RST.
	RCC_AHB1RSTR_DMA1RST = 0x1

	// AHB2RSTR: AHB2 peripheral reset register
	// Position of AES1RST field.
	RCC_AHB2RSTR_AES1RST_Pos = 0x10
	// Bit mask of AES1RST field.
	RCC_AHB2RSTR_AES1RST_Msk = 0x10000
	// Bit AES1RST.
	RCC_AHB2RSTR_AES1RST = 0x10000
	// Position of ADCRST field.
	RCC_AHB2RSTR_ADCRST_Pos = 0xd
	// Bit mask of ADCRST field.
	RCC_AHB2RSTR_ADCRST_Msk = 0x2000
	// Bit ADCRST.
	RCC_AHB2RSTR_ADCRST = 0x2000
	// Position of GPIOHRST field.
	RCC_AHB2RSTR_GPIOHRST_Pos = 0x7
	// Bit mask of GPIOHRST field.
	RCC_AHB2RSTR_GPIOHRST_Msk = 0x80
	// Bit GPIOHRST.
	RCC_AHB2RSTR_GPIOHRST = 0x80
	// Position of GPIOERST field.
	RCC_AHB2RSTR_GPIOERST_Pos = 0x4
	// Bit mask of GPIOERST field.
	RCC_AHB2RSTR_GPIOERST_Msk = 0x10
	// Bit GPIOERST.
	RCC_AHB2RSTR_GPIOERST = 0x10
	// Position of GPIODRST field.
	RCC_AHB2RSTR_GPIODRST_Pos = 0x3
	// Bit mask of GPIODRST field.
	RCC_AHB2RSTR_GPIODRST_Msk = 0x8
	// Bit GPIODRST.
	RCC_AHB2RSTR_GPIODRST = 0x8
	// Position of GPIOCRST field.
	RCC_AHB2RSTR_GPIOCRST_Pos = 0x2
	// Bit mask of GPIOCRST field.
	RCC_AHB2RSTR_GPIOCRST_Msk = 0x4
	// Bit GPIOCRST.
	RCC_AHB2RSTR_GPIOCRST = 0x4
	// Position of GPIOBRST field.
	RCC_AHB2RSTR_GPIOBRST_Pos = 0x1
	// Bit mask of GPIOBRST field.
	RCC_AHB2RSTR_GPIOBRST_Msk = 0x2
	// Bit GPIOBRST.
	RCC_AHB2RSTR_GPIOBRST = 0x2
	// Position of GPIOARST field.
	RCC_AHB2RSTR_GPIOARST_Pos = 0x0
	// Bit mask of GPIOARST field.
	RCC_AHB2RSTR_GPIOARST_Msk = 0x1
	// Bit GPIOARST.
	RCC_AHB2RSTR_GPIOARST = 0x1

	// AHB3RSTR: AHB3 peripheral reset register
	// Position of FLASHRST field.
	RCC_AHB3RSTR_FLASHRST_Pos = 0x19
	// Bit mask of FLASHRST field.
	RCC_AHB3RSTR_FLASHRST_Msk = 0x2000000
	// Bit FLASHRST.
	RCC_AHB3RSTR_FLASHRST = 0x2000000
	// Position of IPCCRST field.
	RCC_AHB3RSTR_IPCCRST_Pos = 0x14
	// Bit mask of IPCCRST field.
	RCC_AHB3RSTR_IPCCRST_Msk = 0x100000
	// Bit IPCCRST.
	RCC_AHB3RSTR_IPCCRST = 0x100000
	// Position of HSEMRST field.
	RCC_AHB3RSTR_HSEMRST_Pos = 0x13
	// Bit mask of HSEMRST field.
	RCC_AHB3RSTR_HSEMRST_Msk = 0x80000
	// Bit HSEMRST.
	RCC_AHB3RSTR_HSEMRST = 0x80000
	// Position of RNGRST field.
	RCC_AHB3RSTR_RNGRST_Pos = 0x12
	// Bit mask of RNGRST field.
	RCC_AHB3RSTR_RNGRST_Msk = 0x40000
	// Bit RNGRST.
	RCC_AHB3RSTR_RNGRST = 0x40000
	// Position of AES2RST field.
	RCC_AHB3RSTR_AES2RST_Pos = 0x11
	// Bit mask of AES2RST field.
	RCC_AHB3RSTR_AES2RST_Msk = 0x20000
	// Bit AES2RST.
	RCC_AHB3RSTR_AES2RST = 0x20000
	// Position of PKARST field.
	RCC_AHB3RSTR_PKARST_Pos = 0x10
	// Bit mask of PKARST field.
	RCC_AHB3RSTR_PKARST_Msk = 0x10000
	// Bit PKARST.
	RCC_AHB3RSTR_PKARST = 0x10000
	// Position of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST_Pos = 0x8
	// Bit mask of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST_Msk = 0x100
	// Bit QSPIRST.
	RCC_AHB3RSTR_QSPIRST = 0x100

	// APB1RSTR1: APB1 peripheral reset register 1
	// Position of LPTIM1RST field.
	RCC_APB1RSTR1_LPTIM1RST_Pos = 0x1f
	// Bit mask of LPTIM1RST field.
	RCC_APB1RSTR1_LPTIM1RST_Msk = 0x80000000
	// Bit LPTIM1RST.
	RCC_APB1RSTR1_LPTIM1RST = 0x80000000
	// Position of USBFSRST field.
	RCC_APB1RSTR1_USBFSRST_Pos = 0x1a
	// Bit mask of USBFSRST field.
	RCC_APB1RSTR1_USBFSRST_Msk = 0x4000000
	// Bit USBFSRST.
	RCC_APB1RSTR1_USBFSRST = 0x4000000
	// Position of CRSRST field.
	RCC_APB1RSTR1_CRSRST_Pos = 0x18
	// Bit mask of CRSRST field.
	RCC_APB1RSTR1_CRSRST_Msk = 0x1000000
	// Bit CRSRST.
	RCC_APB1RSTR1_CRSRST = 0x1000000
	// Position of I2C3RST field.
	RCC_APB1RSTR1_I2C3RST_Pos = 0x17
	// Bit mask of I2C3RST field.
	RCC_APB1RSTR1_I2C3RST_Msk = 0x800000
	// Bit I2C3RST.
	RCC_APB1RSTR1_I2C3RST = 0x800000
	// Position of I2C1RST field.
	RCC_APB1RSTR1_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR1_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR1_I2C1RST = 0x200000
	// Position of SPI2RST field.
	RCC_APB1RSTR1_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APB1RSTR1_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APB1RSTR1_SPI2RST = 0x4000
	// Position of LCDRST field.
	RCC_APB1RSTR1_LCDRST_Pos = 0x9
	// Bit mask of LCDRST field.
	RCC_APB1RSTR1_LCDRST_Msk = 0x200
	// Bit LCDRST.
	RCC_APB1RSTR1_LCDRST = 0x200
	// Position of TIM2RST field.
	RCC_APB1RSTR1_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR1_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR1_TIM2RST = 0x1

	// APB1RSTR2: APB1 peripheral reset register 2
	// Position of LPTIM2RST field.
	RCC_APB1RSTR2_LPTIM2RST_Pos = 0x5
	// Bit mask of LPTIM2RST field.
	RCC_APB1RSTR2_LPTIM2RST_Msk = 0x20
	// Bit LPTIM2RST.
	RCC_APB1RSTR2_LPTIM2RST = 0x20
	// Position of LPUART1RST field.
	RCC_APB1RSTR2_LPUART1RST_Pos = 0x0
	// Bit mask of LPUART1RST field.
	RCC_APB1RSTR2_LPUART1RST_Msk = 0x1
	// Bit LPUART1RST.
	RCC_APB1RSTR2_LPUART1RST = 0x1

	// APB2RSTR: APB2 peripheral reset register
	// Position of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Pos = 0x15
	// Bit mask of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Msk = 0x200000
	// Bit SAI1RST.
	RCC_APB2RSTR_SAI1RST = 0x200000
	// Position of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Pos = 0x12
	// Bit mask of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Msk = 0x40000
	// Bit TIM17RST.
	RCC_APB2RSTR_TIM17RST = 0x40000
	// Position of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Pos = 0x11
	// Bit mask of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Msk = 0x20000
	// Bit TIM16RST.
	RCC_APB2RSTR_TIM16RST = 0x20000
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0xe
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x4000
	// Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APB2RSTR_SPI1RST = 0x1000
	// Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Pos = 0xb
	// Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk = 0x800
	// Bit TIM1RST.
	RCC_APB2RSTR_TIM1RST = 0x800

	// APB3RSTR: APB3 peripheral reset register
	// Position of RFRST field.
	RCC_APB3RSTR_RFRST_Pos = 0x0
	// Bit mask of RFRST field.
	RCC_APB3RSTR_RFRST_Msk = 0x1
	// Bit RFRST.
	RCC_APB3RSTR_RFRST = 0x1

	// AHB1ENR: AHB1 peripheral clock enable register
	// Position of TSCEN field.
	RCC_AHB1ENR_TSCEN_Pos = 0x10
	// Bit mask of TSCEN field.
	RCC_AHB1ENR_TSCEN_Msk = 0x10000
	// Bit TSCEN.
	RCC_AHB1ENR_TSCEN = 0x10000
	// Position of CRCEN field.
	RCC_AHB1ENR_CRCEN_Pos = 0xc
	// Bit mask of CRCEN field.
	RCC_AHB1ENR_CRCEN_Msk = 0x1000
	// Bit CRCEN.
	RCC_AHB1ENR_CRCEN = 0x1000
	// Position of DMAMUXEN field.
	RCC_AHB1ENR_DMAMUXEN_Pos = 0x2
	// Bit mask of DMAMUXEN field.
	RCC_AHB1ENR_DMAMUXEN_Msk = 0x4
	// Bit DMAMUXEN.
	RCC_AHB1ENR_DMAMUXEN = 0x4
	// Position of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Pos = 0x1
	// Bit mask of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Msk = 0x2
	// Bit DMA2EN.
	RCC_AHB1ENR_DMA2EN = 0x2
	// Position of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Pos = 0x0
	// Bit mask of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Msk = 0x1
	// Bit DMA1EN.
	RCC_AHB1ENR_DMA1EN = 0x1

	// AHB2ENR: AHB2 peripheral clock enable register
	// Position of AES1EN field.
	RCC_AHB2ENR_AES1EN_Pos = 0x10
	// Bit mask of AES1EN field.
	RCC_AHB2ENR_AES1EN_Msk = 0x10000
	// Bit AES1EN.
	RCC_AHB2ENR_AES1EN = 0x10000
	// Position of ADCEN field.
	RCC_AHB2ENR_ADCEN_Pos = 0xd
	// Bit mask of ADCEN field.
	RCC_AHB2ENR_ADCEN_Msk = 0x2000
	// Bit ADCEN.
	RCC_AHB2ENR_ADCEN = 0x2000
	// Position of GPIOHEN field.
	RCC_AHB2ENR_GPIOHEN_Pos = 0x7
	// Bit mask of GPIOHEN field.
	RCC_AHB2ENR_GPIOHEN_Msk = 0x80
	// Bit GPIOHEN.
	RCC_AHB2ENR_GPIOHEN = 0x80
	// Position of GPIOEEN field.
	RCC_AHB2ENR_GPIOEEN_Pos = 0x4
	// Bit mask of GPIOEEN field.
	RCC_AHB2ENR_GPIOEEN_Msk = 0x10
	// Bit GPIOEEN.
	RCC_AHB2ENR_GPIOEEN = 0x10
	// Position of GPIODEN field.
	RCC_AHB2ENR_GPIODEN_Pos = 0x3
	// Bit mask of GPIODEN field.
	RCC_AHB2ENR_GPIODEN_Msk = 0x8
	// Bit GPIODEN.
	RCC_AHB2ENR_GPIODEN = 0x8
	// Position of GPIOCEN field.
	RCC_AHB2ENR_GPIOCEN_Pos = 0x2
	// Bit mask of GPIOCEN field.
	RCC_AHB2ENR_GPIOCEN_Msk = 0x4
	// Bit GPIOCEN.
	RCC_AHB2ENR_GPIOCEN = 0x4
	// Position of GPIOBEN field.
	RCC_AHB2ENR_GPIOBEN_Pos = 0x1
	// Bit mask of GPIOBEN field.
	RCC_AHB2ENR_GPIOBEN_Msk = 0x2
	// Bit GPIOBEN.
	RCC_AHB2ENR_GPIOBEN = 0x2
	// Position of GPIOAEN field.
	RCC_AHB2ENR_GPIOAEN_Pos = 0x0
	// Bit mask of GPIOAEN field.
	RCC_AHB2ENR_GPIOAEN_Msk = 0x1
	// Bit GPIOAEN.
	RCC_AHB2ENR_GPIOAEN = 0x1

	// AHB3ENR: AHB3 peripheral clock enable register
	// Position of FLASHEN field.
	RCC_AHB3ENR_FLASHEN_Pos = 0x19
	// Bit mask of FLASHEN field.
	RCC_AHB3ENR_FLASHEN_Msk = 0x2000000
	// Bit FLASHEN.
	RCC_AHB3ENR_FLASHEN = 0x2000000
	// Position of IPCCEN field.
	RCC_AHB3ENR_IPCCEN_Pos = 0x14
	// Bit mask of IPCCEN field.
	RCC_AHB3ENR_IPCCEN_Msk = 0x100000
	// Bit IPCCEN.
	RCC_AHB3ENR_IPCCEN = 0x100000
	// Position of HSEMEN field.
	RCC_AHB3ENR_HSEMEN_Pos = 0x13
	// Bit mask of HSEMEN field.
	RCC_AHB3ENR_HSEMEN_Msk = 0x80000
	// Bit HSEMEN.
	RCC_AHB3ENR_HSEMEN = 0x80000
	// Position of RNGEN field.
	RCC_AHB3ENR_RNGEN_Pos = 0x12
	// Bit mask of RNGEN field.
	RCC_AHB3ENR_RNGEN_Msk = 0x40000
	// Bit RNGEN.
	RCC_AHB3ENR_RNGEN = 0x40000
	// Position of AES2EN field.
	RCC_AHB3ENR_AES2EN_Pos = 0x11
	// Bit mask of AES2EN field.
	RCC_AHB3ENR_AES2EN_Msk = 0x20000
	// Bit AES2EN.
	RCC_AHB3ENR_AES2EN = 0x20000
	// Position of PKAEN field.
	RCC_AHB3ENR_PKAEN_Pos = 0x10
	// Bit mask of PKAEN field.
	RCC_AHB3ENR_PKAEN_Msk = 0x10000
	// Bit PKAEN.
	RCC_AHB3ENR_PKAEN = 0x10000
	// Position of QSPIEN field.
	RCC_AHB3ENR_QSPIEN_Pos = 0x8
	// Bit mask of QSPIEN field.
	RCC_AHB3ENR_QSPIEN_Msk = 0x100
	// Bit QSPIEN.
	RCC_AHB3ENR_QSPIEN = 0x100

	// APB1ENR1: APB1ENR1
	// Position of LPTIM1EN field.
	RCC_APB1ENR1_LPTIM1EN_Pos = 0x1f
	// Bit mask of LPTIM1EN field.
	RCC_APB1ENR1_LPTIM1EN_Msk = 0x80000000
	// Bit LPTIM1EN.
	RCC_APB1ENR1_LPTIM1EN = 0x80000000
	// Position of USBEN field.
	RCC_APB1ENR1_USBEN_Pos = 0x1a
	// Bit mask of USBEN field.
	RCC_APB1ENR1_USBEN_Msk = 0x4000000
	// Bit USBEN.
	RCC_APB1ENR1_USBEN = 0x4000000
	// Position of CRSEN field.
	RCC_APB1ENR1_CRSEN_Pos = 0x18
	// Bit mask of CRSEN field.
	RCC_APB1ENR1_CRSEN_Msk = 0x1000000
	// Bit CRSEN.
	RCC_APB1ENR1_CRSEN = 0x1000000
	// Position of I2C3EN field.
	RCC_APB1ENR1_I2C3EN_Pos = 0x17
	// Bit mask of I2C3EN field.
	RCC_APB1ENR1_I2C3EN_Msk = 0x800000
	// Bit I2C3EN.
	RCC_APB1ENR1_I2C3EN = 0x800000
	// Position of I2C1EN field.
	RCC_APB1ENR1_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR1_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR1_I2C1EN = 0x200000
	// Position of SPI2EN field.
	RCC_APB1ENR1_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APB1ENR1_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APB1ENR1_SPI2EN = 0x4000
	// Position of WWDGEN field.
	RCC_APB1ENR1_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR1_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR1_WWDGEN = 0x800
	// Position of RTCAPBEN field.
	RCC_APB1ENR1_RTCAPBEN_Pos = 0xa
	// Bit mask of RTCAPBEN field.
	RCC_APB1ENR1_RTCAPBEN_Msk = 0x400
	// Bit RTCAPBEN.
	RCC_APB1ENR1_RTCAPBEN = 0x400
	// Position of LCDEN field.
	RCC_APB1ENR1_LCDEN_Pos = 0x9
	// Bit mask of LCDEN field.
	RCC_APB1ENR1_LCDEN_Msk = 0x200
	// Bit LCDEN.
	RCC_APB1ENR1_LCDEN = 0x200
	// Position of TIM2EN field.
	RCC_APB1ENR1_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR1_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR1_TIM2EN = 0x1

	// APB1ENR2: APB1 peripheral clock enable register 2
	// Position of LPTIM2EN field.
	RCC_APB1ENR2_LPTIM2EN_Pos = 0x5
	// Bit mask of LPTIM2EN field.
	RCC_APB1ENR2_LPTIM2EN_Msk = 0x20
	// Bit LPTIM2EN.
	RCC_APB1ENR2_LPTIM2EN = 0x20
	// Position of LPUART1EN field.
	RCC_APB1ENR2_LPUART1EN_Pos = 0x0
	// Bit mask of LPUART1EN field.
	RCC_APB1ENR2_LPUART1EN_Msk = 0x1
	// Bit LPUART1EN.
	RCC_APB1ENR2_LPUART1EN = 0x1

	// APB2ENR: APB2ENR
	// Position of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Pos = 0x15
	// Bit mask of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Msk = 0x200000
	// Bit SAI1EN.
	RCC_APB2ENR_SAI1EN = 0x200000
	// Position of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Pos = 0x12
	// Bit mask of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Msk = 0x40000
	// Bit TIM17EN.
	RCC_APB2ENR_TIM17EN = 0x40000
	// Position of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Pos = 0x11
	// Bit mask of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Msk = 0x20000
	// Bit TIM16EN.
	RCC_APB2ENR_TIM16EN = 0x20000
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0xe
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x4000
	// Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APB2ENR_SPI1EN = 0x1000
	// Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Pos = 0xb
	// Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk = 0x800
	// Bit TIM1EN.
	RCC_APB2ENR_TIM1EN = 0x800

	// AHB1SMENR: AHB1 peripheral clocks enable in Sleep and Stop modes register
	// Position of TSCSMEN field.
	RCC_AHB1SMENR_TSCSMEN_Pos = 0x10
	// Bit mask of TSCSMEN field.
	RCC_AHB1SMENR_TSCSMEN_Msk = 0x10000
	// Bit TSCSMEN.
	RCC_AHB1SMENR_TSCSMEN = 0x10000
	// Position of CRCSMEN field.
	RCC_AHB1SMENR_CRCSMEN_Pos = 0xc
	// Bit mask of CRCSMEN field.
	RCC_AHB1SMENR_CRCSMEN_Msk = 0x1000
	// Bit CRCSMEN.
	RCC_AHB1SMENR_CRCSMEN = 0x1000
	// Position of SRAM1SMEN field.
	RCC_AHB1SMENR_SRAM1SMEN_Pos = 0x9
	// Bit mask of SRAM1SMEN field.
	RCC_AHB1SMENR_SRAM1SMEN_Msk = 0x200
	// Bit SRAM1SMEN.
	RCC_AHB1SMENR_SRAM1SMEN = 0x200
	// Position of DMAMUXSMEN field.
	RCC_AHB1SMENR_DMAMUXSMEN_Pos = 0x2
	// Bit mask of DMAMUXSMEN field.
	RCC_AHB1SMENR_DMAMUXSMEN_Msk = 0x4
	// Bit DMAMUXSMEN.
	RCC_AHB1SMENR_DMAMUXSMEN = 0x4
	// Position of DMA2SMEN field.
	RCC_AHB1SMENR_DMA2SMEN_Pos = 0x1
	// Bit mask of DMA2SMEN field.
	RCC_AHB1SMENR_DMA2SMEN_Msk = 0x2
	// Bit DMA2SMEN.
	RCC_AHB1SMENR_DMA2SMEN = 0x2
	// Position of DMA1SMEN field.
	RCC_AHB1SMENR_DMA1SMEN_Pos = 0x0
	// Bit mask of DMA1SMEN field.
	RCC_AHB1SMENR_DMA1SMEN_Msk = 0x1
	// Bit DMA1SMEN.
	RCC_AHB1SMENR_DMA1SMEN = 0x1

	// AHB2SMENR: AHB2 peripheral clocks enable in Sleep and Stop modes register
	// Position of AES1SMEN field.
	RCC_AHB2SMENR_AES1SMEN_Pos = 0x10
	// Bit mask of AES1SMEN field.
	RCC_AHB2SMENR_AES1SMEN_Msk = 0x10000
	// Bit AES1SMEN.
	RCC_AHB2SMENR_AES1SMEN = 0x10000
	// Position of ADCFSSMEN field.
	RCC_AHB2SMENR_ADCFSSMEN_Pos = 0xd
	// Bit mask of ADCFSSMEN field.
	RCC_AHB2SMENR_ADCFSSMEN_Msk = 0x2000
	// Bit ADCFSSMEN.
	RCC_AHB2SMENR_ADCFSSMEN = 0x2000
	// Position of GPIOHSMEN field.
	RCC_AHB2SMENR_GPIOHSMEN_Pos = 0x7
	// Bit mask of GPIOHSMEN field.
	RCC_AHB2SMENR_GPIOHSMEN_Msk = 0x80
	// Bit GPIOHSMEN.
	RCC_AHB2SMENR_GPIOHSMEN = 0x80
	// Position of GPIOESMEN field.
	RCC_AHB2SMENR_GPIOESMEN_Pos = 0x4
	// Bit mask of GPIOESMEN field.
	RCC_AHB2SMENR_GPIOESMEN_Msk = 0x10
	// Bit GPIOESMEN.
	RCC_AHB2SMENR_GPIOESMEN = 0x10
	// Position of GPIODSMEN field.
	RCC_AHB2SMENR_GPIODSMEN_Pos = 0x3
	// Bit mask of GPIODSMEN field.
	RCC_AHB2SMENR_GPIODSMEN_Msk = 0x8
	// Bit GPIODSMEN.
	RCC_AHB2SMENR_GPIODSMEN = 0x8
	// Position of GPIOCSMEN field.
	RCC_AHB2SMENR_GPIOCSMEN_Pos = 0x2
	// Bit mask of GPIOCSMEN field.
	RCC_AHB2SMENR_GPIOCSMEN_Msk = 0x4
	// Bit GPIOCSMEN.
	RCC_AHB2SMENR_GPIOCSMEN = 0x4
	// Position of GPIOBSMEN field.
	RCC_AHB2SMENR_GPIOBSMEN_Pos = 0x1
	// Bit mask of GPIOBSMEN field.
	RCC_AHB2SMENR_GPIOBSMEN_Msk = 0x2
	// Bit GPIOBSMEN.
	RCC_AHB2SMENR_GPIOBSMEN = 0x2
	// Position of GPIOASMEN field.
	RCC_AHB2SMENR_GPIOASMEN_Pos = 0x0
	// Bit mask of GPIOASMEN field.
	RCC_AHB2SMENR_GPIOASMEN_Msk = 0x1
	// Bit GPIOASMEN.
	RCC_AHB2SMENR_GPIOASMEN = 0x1

	// AHB3SMENR: AHB3 peripheral clocks enable in Sleep and Stop modes register
	// Position of FLASHSMEN field.
	RCC_AHB3SMENR_FLASHSMEN_Pos = 0x19
	// Bit mask of FLASHSMEN field.
	RCC_AHB3SMENR_FLASHSMEN_Msk = 0x2000000
	// Bit FLASHSMEN.
	RCC_AHB3SMENR_FLASHSMEN = 0x2000000
	// Position of SRAM2SMEN field.
	RCC_AHB3SMENR_SRAM2SMEN_Pos = 0x18
	// Bit mask of SRAM2SMEN field.
	RCC_AHB3SMENR_SRAM2SMEN_Msk = 0x1000000
	// Bit SRAM2SMEN.
	RCC_AHB3SMENR_SRAM2SMEN = 0x1000000
	// Position of RNGSMEN field.
	RCC_AHB3SMENR_RNGSMEN_Pos = 0x12
	// Bit mask of RNGSMEN field.
	RCC_AHB3SMENR_RNGSMEN_Msk = 0x40000
	// Bit RNGSMEN.
	RCC_AHB3SMENR_RNGSMEN = 0x40000
	// Position of AES2SMEN field.
	RCC_AHB3SMENR_AES2SMEN_Pos = 0x11
	// Bit mask of AES2SMEN field.
	RCC_AHB3SMENR_AES2SMEN_Msk = 0x20000
	// Bit AES2SMEN.
	RCC_AHB3SMENR_AES2SMEN = 0x20000
	// Position of PKASMEN field.
	RCC_AHB3SMENR_PKASMEN_Pos = 0x10
	// Bit mask of PKASMEN field.
	RCC_AHB3SMENR_PKASMEN_Msk = 0x10000
	// Bit PKASMEN.
	RCC_AHB3SMENR_PKASMEN = 0x10000
	// Position of QSPISMEN field.
	RCC_AHB3SMENR_QSPISMEN_Pos = 0x8
	// Bit mask of QSPISMEN field.
	RCC_AHB3SMENR_QSPISMEN_Msk = 0x100
	// Bit QSPISMEN.
	RCC_AHB3SMENR_QSPISMEN = 0x100

	// APB1SMENR1: APB1SMENR1
	// Position of LPTIM1SMEN field.
	RCC_APB1SMENR1_LPTIM1SMEN_Pos = 0x1f
	// Bit mask of LPTIM1SMEN field.
	RCC_APB1SMENR1_LPTIM1SMEN_Msk = 0x80000000
	// Bit LPTIM1SMEN.
	RCC_APB1SMENR1_LPTIM1SMEN = 0x80000000
	// Position of USBSMEN field.
	RCC_APB1SMENR1_USBSMEN_Pos = 0x1a
	// Bit mask of USBSMEN field.
	RCC_APB1SMENR1_USBSMEN_Msk = 0x4000000
	// Bit USBSMEN.
	RCC_APB1SMENR1_USBSMEN = 0x4000000
	// Position of CRSMEN field.
	RCC_APB1SMENR1_CRSMEN_Pos = 0x18
	// Bit mask of CRSMEN field.
	RCC_APB1SMENR1_CRSMEN_Msk = 0x1000000
	// Bit CRSMEN.
	RCC_APB1SMENR1_CRSMEN = 0x1000000
	// Position of I2C3SMEN field.
	RCC_APB1SMENR1_I2C3SMEN_Pos = 0x17
	// Bit mask of I2C3SMEN field.
	RCC_APB1SMENR1_I2C3SMEN_Msk = 0x800000
	// Bit I2C3SMEN.
	RCC_APB1SMENR1_I2C3SMEN = 0x800000
	// Position of I2C1SMEN field.
	RCC_APB1SMENR1_I2C1SMEN_Pos = 0x15
	// Bit mask of I2C1SMEN field.
	RCC_APB1SMENR1_I2C1SMEN_Msk = 0x200000
	// Bit I2C1SMEN.
	RCC_APB1SMENR1_I2C1SMEN = 0x200000
	// Position of SPI2SMEN field.
	RCC_APB1SMENR1_SPI2SMEN_Pos = 0xe
	// Bit mask of SPI2SMEN field.
	RCC_APB1SMENR1_SPI2SMEN_Msk = 0x4000
	// Bit SPI2SMEN.
	RCC_APB1SMENR1_SPI2SMEN = 0x4000
	// Position of WWDGSMEN field.
	RCC_APB1SMENR1_WWDGSMEN_Pos = 0xb
	// Bit mask of WWDGSMEN field.
	RCC_APB1SMENR1_WWDGSMEN_Msk = 0x800
	// Bit WWDGSMEN.
	RCC_APB1SMENR1_WWDGSMEN = 0x800
	// Position of RTCAPBSMEN field.
	RCC_APB1SMENR1_RTCAPBSMEN_Pos = 0xa
	// Bit mask of RTCAPBSMEN field.
	RCC_APB1SMENR1_RTCAPBSMEN_Msk = 0x400
	// Bit RTCAPBSMEN.
	RCC_APB1SMENR1_RTCAPBSMEN = 0x400
	// Position of LCDSMEN field.
	RCC_APB1SMENR1_LCDSMEN_Pos = 0x9
	// Bit mask of LCDSMEN field.
	RCC_APB1SMENR1_LCDSMEN_Msk = 0x200
	// Bit LCDSMEN.
	RCC_APB1SMENR1_LCDSMEN = 0x200
	// Position of TIM2SMEN field.
	RCC_APB1SMENR1_TIM2SMEN_Pos = 0x0
	// Bit mask of TIM2SMEN field.
	RCC_APB1SMENR1_TIM2SMEN_Msk = 0x1
	// Bit TIM2SMEN.
	RCC_APB1SMENR1_TIM2SMEN = 0x1

	// APB1SMENR2: APB1 peripheral clocks enable in Sleep and Stop modes register 2
	// Position of LPTIM2SMEN field.
	RCC_APB1SMENR2_LPTIM2SMEN_Pos = 0x5
	// Bit mask of LPTIM2SMEN field.
	RCC_APB1SMENR2_LPTIM2SMEN_Msk = 0x20
	// Bit LPTIM2SMEN.
	RCC_APB1SMENR2_LPTIM2SMEN = 0x20
	// Position of LPUART1SMEN field.
	RCC_APB1SMENR2_LPUART1SMEN_Pos = 0x0
	// Bit mask of LPUART1SMEN field.
	RCC_APB1SMENR2_LPUART1SMEN_Msk = 0x1
	// Bit LPUART1SMEN.
	RCC_APB1SMENR2_LPUART1SMEN = 0x1

	// APB2SMENR: APB2SMENR
	// Position of SAI1SMEN field.
	RCC_APB2SMENR_SAI1SMEN_Pos = 0x15
	// Bit mask of SAI1SMEN field.
	RCC_APB2SMENR_SAI1SMEN_Msk = 0x200000
	// Bit SAI1SMEN.
	RCC_APB2SMENR_SAI1SMEN = 0x200000
	// Position of TIM17SMEN field.
	RCC_APB2SMENR_TIM17SMEN_Pos = 0x12
	// Bit mask of TIM17SMEN field.
	RCC_APB2SMENR_TIM17SMEN_Msk = 0x40000
	// Bit TIM17SMEN.
	RCC_APB2SMENR_TIM17SMEN = 0x40000
	// Position of TIM16SMEN field.
	RCC_APB2SMENR_TIM16SMEN_Pos = 0x11
	// Bit mask of TIM16SMEN field.
	RCC_APB2SMENR_TIM16SMEN_Msk = 0x20000
	// Bit TIM16SMEN.
	RCC_APB2SMENR_TIM16SMEN = 0x20000
	// Position of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN_Pos = 0xe
	// Bit mask of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN_Msk = 0x4000
	// Bit USART1SMEN.
	RCC_APB2SMENR_USART1SMEN = 0x4000
	// Position of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN_Pos = 0xc
	// Bit mask of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN_Msk = 0x1000
	// Bit SPI1SMEN.
	RCC_APB2SMENR_SPI1SMEN = 0x1000
	// Position of TIM1SMEN field.
	RCC_APB2SMENR_TIM1SMEN_Pos = 0xb
	// Bit mask of TIM1SMEN field.
	RCC_APB2SMENR_TIM1SMEN_Msk = 0x800
	// Bit TIM1SMEN.
	RCC_APB2SMENR_TIM1SMEN = 0x800

	// CCIPR: CCIPR
	// Position of RNGSEL field.
	RCC_CCIPR_RNGSEL_Pos = 0x1e
	// Bit mask of RNGSEL field.
	RCC_CCIPR_RNGSEL_Msk = 0xc0000000
	// Position of ADCSEL field.
	RCC_CCIPR_ADCSEL_Pos = 0x1c
	// Bit mask of ADCSEL field.
	RCC_CCIPR_ADCSEL_Msk = 0x30000000
	// Position of CLK48SEL field.
	RCC_CCIPR_CLK48SEL_Pos = 0x1a
	// Bit mask of CLK48SEL field.
	RCC_CCIPR_CLK48SEL_Msk = 0xc000000
	// Position of SAI1SEL field.
	RCC_CCIPR_SAI1SEL_Pos = 0x16
	// Bit mask of SAI1SEL field.
	RCC_CCIPR_SAI1SEL_Msk = 0xc00000
	// Position of LPTIM2SEL field.
	RCC_CCIPR_LPTIM2SEL_Pos = 0x14
	// Bit mask of LPTIM2SEL field.
	RCC_CCIPR_LPTIM2SEL_Msk = 0x300000
	// Position of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Pos = 0x12
	// Bit mask of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Msk = 0xc0000
	// Position of I2C3SEL field.
	RCC_CCIPR_I2C3SEL_Pos = 0x10
	// Bit mask of I2C3SEL field.
	RCC_CCIPR_I2C3SEL_Msk = 0x30000
	// Position of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Pos = 0xc
	// Bit mask of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Msk = 0x3000
	// Position of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Pos = 0xa
	// Bit mask of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Msk = 0xc00
	// Position of USART1SEL field.
	RCC_CCIPR_USART1SEL_Pos = 0x0
	// Bit mask of USART1SEL field.
	RCC_CCIPR_USART1SEL_Msk = 0x3

	// BDCR: BDCR
	// Position of LSCOSEL field.
	RCC_BDCR_LSCOSEL_Pos = 0x19
	// Bit mask of LSCOSEL field.
	RCC_BDCR_LSCOSEL_Msk = 0x6000000
	// Position of LSCOEN field.
	RCC_BDCR_LSCOEN_Pos = 0x18
	// Bit mask of LSCOEN field.
	RCC_BDCR_LSCOEN_Msk = 0x1000000
	// Bit LSCOEN.
	RCC_BDCR_LSCOEN = 0x1000000
	// Position of BDRST field.
	RCC_BDCR_BDRST_Pos = 0x10
	// Bit mask of BDRST field.
	RCC_BDCR_BDRST_Msk = 0x10000
	// Bit BDRST.
	RCC_BDCR_BDRST = 0x10000
	// Position of RTCEN field.
	RCC_BDCR_RTCEN_Pos = 0xf
	// Bit mask of RTCEN field.
	RCC_BDCR_RTCEN_Msk = 0x8000
	// Bit RTCEN.
	RCC_BDCR_RTCEN = 0x8000
	// Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Pos = 0x8
	// Bit mask of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300
	// Position of LSECSSD_ field.
	RCC_BDCR_LSECSSD__Pos = 0x6
	// Bit mask of LSECSSD_ field.
	RCC_BDCR_LSECSSD__Msk = 0x40
	// Bit LSECSSD_.
	RCC_BDCR_LSECSSD_ = 0x40
	// Position of LSECSSON field.
	RCC_BDCR_LSECSSON_Pos = 0x5
	// Bit mask of LSECSSON field.
	RCC_BDCR_LSECSSON_Msk = 0x20
	// Bit LSECSSON.
	RCC_BDCR_LSECSSON = 0x20
	// Position of LSEDRV field.
	RCC_BDCR_LSEDRV_Pos = 0x3
	// Bit mask of LSEDRV field.
	RCC_BDCR_LSEDRV_Msk = 0x18
	// Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Pos = 0x2
	// Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4
	// Bit LSEBYP.
	RCC_BDCR_LSEBYP = 0x4
	// Position of LSERDY field.
	RCC_BDCR_LSERDY_Pos = 0x1
	// Bit mask of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2
	// Bit LSERDY.
	RCC_BDCR_LSERDY = 0x2
	// Position of LSEON field.
	RCC_BDCR_LSEON_Pos = 0x0
	// Bit mask of LSEON field.
	RCC_BDCR_LSEON_Msk = 0x1
	// Bit LSEON.
	RCC_BDCR_LSEON = 0x1

	// CSR: CSR
	// Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Pos = 0x1f
	// Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000
	// Bit LPWRRSTF.
	RCC_CSR_LPWRRSTF = 0x80000000
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Pos = 0x1d
	// Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000
	// Bit IWDGRSTF.
	RCC_CSR_IWDGRSTF = 0x20000000
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// Position of BORRSTF field.
	RCC_CSR_BORRSTF_Pos = 0x1b
	// Bit mask of BORRSTF field.
	RCC_CSR_BORRSTF_Msk = 0x8000000
	// Bit BORRSTF.
	RCC_CSR_BORRSTF = 0x8000000
	// Position of PINRSTF field.
	RCC_CSR_PINRSTF_Pos = 0x1a
	// Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF_Msk = 0x4000000
	// Bit PINRSTF.
	RCC_CSR_PINRSTF = 0x4000000
	// Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Pos = 0x19
	// Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk = 0x2000000
	// Bit OBLRSTF.
	RCC_CSR_OBLRSTF = 0x2000000
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x17
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x800000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x800000
	// Position of RFWKPSEL field.
	RCC_CSR_RFWKPSEL_Pos = 0xe
	// Bit mask of RFWKPSEL field.
	RCC_CSR_RFWKPSEL_Msk = 0xc000
	// Position of LSI2BW field.
	RCC_CSR_LSI2BW_Pos = 0x8
	// Bit mask of LSI2BW field.
	RCC_CSR_LSI2BW_Msk = 0xf00
	// Position of LSI2TRIMOK field.
	RCC_CSR_LSI2TRIMOK_Pos = 0x5
	// Bit mask of LSI2TRIMOK field.
	RCC_CSR_LSI2TRIMOK_Msk = 0x20
	// Bit LSI2TRIMOK.
	RCC_CSR_LSI2TRIMOK = 0x20
	// Position of LSI2TRIMEN field.
	RCC_CSR_LSI2TRIMEN_Pos = 0x4
	// Bit mask of LSI2TRIMEN field.
	RCC_CSR_LSI2TRIMEN_Msk = 0x10
	// Bit LSI2TRIMEN.
	RCC_CSR_LSI2TRIMEN = 0x10
	// Position of LSI2RDY field.
	RCC_CSR_LSI2RDY_Pos = 0x3
	// Bit mask of LSI2RDY field.
	RCC_CSR_LSI2RDY_Msk = 0x8
	// Bit LSI2RDY.
	RCC_CSR_LSI2RDY = 0x8
	// Position of LSI2ON field.
	RCC_CSR_LSI2ON_Pos = 0x2
	// Bit mask of LSI2ON field.
	RCC_CSR_LSI2ON_Msk = 0x4
	// Bit LSI2ON.
	RCC_CSR_LSI2ON = 0x4
	// Position of LSI1RDY field.
	RCC_CSR_LSI1RDY_Pos = 0x1
	// Bit mask of LSI1RDY field.
	RCC_CSR_LSI1RDY_Msk = 0x2
	// Bit LSI1RDY.
	RCC_CSR_LSI1RDY = 0x2
	// Position of LSI1ON field.
	RCC_CSR_LSI1ON_Pos = 0x0
	// Bit mask of LSI1ON field.
	RCC_CSR_LSI1ON_Msk = 0x1
	// Bit LSI1ON.
	RCC_CSR_LSI1ON = 0x1
	// Position of RFRSTS field.
	RCC_CSR_RFRSTS_Pos = 0x10
	// Bit mask of RFRSTS field.
	RCC_CSR_RFRSTS_Msk = 0x10000
	// Bit RFRSTS.
	RCC_CSR_RFRSTS = 0x10000

	// CRRCR: Clock recovery RC register
	// Position of HSI48CAL field.
	RCC_CRRCR_HSI48CAL_Pos = 0x7
	// Bit mask of HSI48CAL field.
	RCC_CRRCR_HSI48CAL_Msk = 0xff80
	// Position of HSI48RDY field.
	RCC_CRRCR_HSI48RDY_Pos = 0x1
	// Bit mask of HSI48RDY field.
	RCC_CRRCR_HSI48RDY_Msk = 0x2
	// Bit HSI48RDY.
	RCC_CRRCR_HSI48RDY = 0x2
	// Position of HSI48ON field.
	RCC_CRRCR_HSI48ON_Pos = 0x0
	// Bit mask of HSI48ON field.
	RCC_CRRCR_HSI48ON_Msk = 0x1
	// Bit HSI48ON.
	RCC_CRRCR_HSI48ON = 0x1

	// HSECR: Clock HSE register
	// Position of HSETUNE field.
	RCC_HSECR_HSETUNE_Pos = 0x8
	// Bit mask of HSETUNE field.
	RCC_HSECR_HSETUNE_Msk = 0x3f00
	// Position of HSEGMC field.
	RCC_HSECR_HSEGMC_Pos = 0x4
	// Bit mask of HSEGMC field.
	RCC_HSECR_HSEGMC_Msk = 0x70
	// Position of HSES field.
	RCC_HSECR_HSES_Pos = 0x3
	// Bit mask of HSES field.
	RCC_HSECR_HSES_Msk = 0x8
	// Bit HSES.
	RCC_HSECR_HSES = 0x8
	// Position of UNLOCKED field.
	RCC_HSECR_UNLOCKED_Pos = 0x0
	// Bit mask of UNLOCKED field.
	RCC_HSECR_UNLOCKED_Msk = 0x1
	// Bit UNLOCKED.
	RCC_HSECR_UNLOCKED = 0x1

	// EXTCFGR: Extended clock recovery register
	// Position of RFCSS field.
	RCC_EXTCFGR_RFCSS_Pos = 0x14
	// Bit mask of RFCSS field.
	RCC_EXTCFGR_RFCSS_Msk = 0x100000
	// Bit RFCSS.
	RCC_EXTCFGR_RFCSS = 0x100000
	// Position of C2HPREF field.
	RCC_EXTCFGR_C2HPREF_Pos = 0x11
	// Bit mask of C2HPREF field.
	RCC_EXTCFGR_C2HPREF_Msk = 0x20000
	// Bit C2HPREF.
	RCC_EXTCFGR_C2HPREF = 0x20000
	// Position of SHDHPREF field.
	RCC_EXTCFGR_SHDHPREF_Pos = 0x10
	// Bit mask of SHDHPREF field.
	RCC_EXTCFGR_SHDHPREF_Msk = 0x10000
	// Bit SHDHPREF.
	RCC_EXTCFGR_SHDHPREF = 0x10000
	// Position of C2HPRE field.
	RCC_EXTCFGR_C2HPRE_Pos = 0x4
	// Bit mask of C2HPRE field.
	RCC_EXTCFGR_C2HPRE_Msk = 0xf0
	// Position of SHDHPRE field.
	RCC_EXTCFGR_SHDHPRE_Pos = 0x0
	// Bit mask of SHDHPRE field.
	RCC_EXTCFGR_SHDHPRE_Msk = 0xf

	// C2AHB1ENR: CPU2 AHB1 peripheral clock enable register
	// Position of TSCEN field.
	RCC_C2AHB1ENR_TSCEN_Pos = 0x10
	// Bit mask of TSCEN field.
	RCC_C2AHB1ENR_TSCEN_Msk = 0x10000
	// Bit TSCEN.
	RCC_C2AHB1ENR_TSCEN = 0x10000
	// Position of CRCEN field.
	RCC_C2AHB1ENR_CRCEN_Pos = 0xc
	// Bit mask of CRCEN field.
	RCC_C2AHB1ENR_CRCEN_Msk = 0x1000
	// Bit CRCEN.
	RCC_C2AHB1ENR_CRCEN = 0x1000
	// Position of SRAM1EN field.
	RCC_C2AHB1ENR_SRAM1EN_Pos = 0x9
	// Bit mask of SRAM1EN field.
	RCC_C2AHB1ENR_SRAM1EN_Msk = 0x200
	// Bit SRAM1EN.
	RCC_C2AHB1ENR_SRAM1EN = 0x200
	// Position of DMAMUXEN field.
	RCC_C2AHB1ENR_DMAMUXEN_Pos = 0x2
	// Bit mask of DMAMUXEN field.
	RCC_C2AHB1ENR_DMAMUXEN_Msk = 0x4
	// Bit DMAMUXEN.
	RCC_C2AHB1ENR_DMAMUXEN = 0x4
	// Position of DMA2EN field.
	RCC_C2AHB1ENR_DMA2EN_Pos = 0x1
	// Bit mask of DMA2EN field.
	RCC_C2AHB1ENR_DMA2EN_Msk = 0x2
	// Bit DMA2EN.
	RCC_C2AHB1ENR_DMA2EN = 0x2
	// Position of DMA1EN field.
	RCC_C2AHB1ENR_DMA1EN_Pos = 0x0
	// Bit mask of DMA1EN field.
	RCC_C2AHB1ENR_DMA1EN_Msk = 0x1
	// Bit DMA1EN.
	RCC_C2AHB1ENR_DMA1EN = 0x1

	// C2AHB2ENR: CPU2 AHB2 peripheral clock enable register
	// Position of AES1EN field.
	RCC_C2AHB2ENR_AES1EN_Pos = 0x10
	// Bit mask of AES1EN field.
	RCC_C2AHB2ENR_AES1EN_Msk = 0x10000
	// Bit AES1EN.
	RCC_C2AHB2ENR_AES1EN = 0x10000
	// Position of ADCEN field.
	RCC_C2AHB2ENR_ADCEN_Pos = 0xd
	// Bit mask of ADCEN field.
	RCC_C2AHB2ENR_ADCEN_Msk = 0x2000
	// Bit ADCEN.
	RCC_C2AHB2ENR_ADCEN = 0x2000
	// Position of GPIOHEN field.
	RCC_C2AHB2ENR_GPIOHEN_Pos = 0x7
	// Bit mask of GPIOHEN field.
	RCC_C2AHB2ENR_GPIOHEN_Msk = 0x80
	// Bit GPIOHEN.
	RCC_C2AHB2ENR_GPIOHEN = 0x80
	// Position of GPIOEEN field.
	RCC_C2AHB2ENR_GPIOEEN_Pos = 0x4
	// Bit mask of GPIOEEN field.
	RCC_C2AHB2ENR_GPIOEEN_Msk = 0x10
	// Bit GPIOEEN.
	RCC_C2AHB2ENR_GPIOEEN = 0x10
	// Position of GPIODEN field.
	RCC_C2AHB2ENR_GPIODEN_Pos = 0x3
	// Bit mask of GPIODEN field.
	RCC_C2AHB2ENR_GPIODEN_Msk = 0x8
	// Bit GPIODEN.
	RCC_C2AHB2ENR_GPIODEN = 0x8
	// Position of GPIOCEN field.
	RCC_C2AHB2ENR_GPIOCEN_Pos = 0x2
	// Bit mask of GPIOCEN field.
	RCC_C2AHB2ENR_GPIOCEN_Msk = 0x4
	// Bit GPIOCEN.
	RCC_C2AHB2ENR_GPIOCEN = 0x4
	// Position of GPIOBEN field.
	RCC_C2AHB2ENR_GPIOBEN_Pos = 0x1
	// Bit mask of GPIOBEN field.
	RCC_C2AHB2ENR_GPIOBEN_Msk = 0x2
	// Bit GPIOBEN.
	RCC_C2AHB2ENR_GPIOBEN = 0x2
	// Position of GPIOAEN field.
	RCC_C2AHB2ENR_GPIOAEN_Pos = 0x0
	// Bit mask of GPIOAEN field.
	RCC_C2AHB2ENR_GPIOAEN_Msk = 0x1
	// Bit GPIOAEN.
	RCC_C2AHB2ENR_GPIOAEN = 0x1

	// C2AHB3ENR: CPU2 AHB3 peripheral clock enable register
	// Position of FLASHEN field.
	RCC_C2AHB3ENR_FLASHEN_Pos = 0x19
	// Bit mask of FLASHEN field.
	RCC_C2AHB3ENR_FLASHEN_Msk = 0x2000000
	// Bit FLASHEN.
	RCC_C2AHB3ENR_FLASHEN = 0x2000000
	// Position of IPCCEN field.
	RCC_C2AHB3ENR_IPCCEN_Pos = 0x14
	// Bit mask of IPCCEN field.
	RCC_C2AHB3ENR_IPCCEN_Msk = 0x100000
	// Bit IPCCEN.
	RCC_C2AHB3ENR_IPCCEN = 0x100000
	// Position of HSEMEN field.
	RCC_C2AHB3ENR_HSEMEN_Pos = 0x13
	// Bit mask of HSEMEN field.
	RCC_C2AHB3ENR_HSEMEN_Msk = 0x80000
	// Bit HSEMEN.
	RCC_C2AHB3ENR_HSEMEN = 0x80000
	// Position of RNGEN field.
	RCC_C2AHB3ENR_RNGEN_Pos = 0x12
	// Bit mask of RNGEN field.
	RCC_C2AHB3ENR_RNGEN_Msk = 0x40000
	// Bit RNGEN.
	RCC_C2AHB3ENR_RNGEN = 0x40000
	// Position of AES2EN field.
	RCC_C2AHB3ENR_AES2EN_Pos = 0x11
	// Bit mask of AES2EN field.
	RCC_C2AHB3ENR_AES2EN_Msk = 0x20000
	// Bit AES2EN.
	RCC_C2AHB3ENR_AES2EN = 0x20000
	// Position of PKAEN field.
	RCC_C2AHB3ENR_PKAEN_Pos = 0x10
	// Bit mask of PKAEN field.
	RCC_C2AHB3ENR_PKAEN_Msk = 0x10000
	// Bit PKAEN.
	RCC_C2AHB3ENR_PKAEN = 0x10000

	// C2APB1ENR1: CPU2 APB1ENR1
	// Position of LPTIM1EN field.
	RCC_C2APB1ENR1_LPTIM1EN_Pos = 0x1f
	// Bit mask of LPTIM1EN field.
	RCC_C2APB1ENR1_LPTIM1EN_Msk = 0x80000000
	// Bit LPTIM1EN.
	RCC_C2APB1ENR1_LPTIM1EN = 0x80000000
	// Position of USBEN field.
	RCC_C2APB1ENR1_USBEN_Pos = 0x1a
	// Bit mask of USBEN field.
	RCC_C2APB1ENR1_USBEN_Msk = 0x4000000
	// Bit USBEN.
	RCC_C2APB1ENR1_USBEN = 0x4000000
	// Position of CRSEN field.
	RCC_C2APB1ENR1_CRSEN_Pos = 0x18
	// Bit mask of CRSEN field.
	RCC_C2APB1ENR1_CRSEN_Msk = 0x1000000
	// Bit CRSEN.
	RCC_C2APB1ENR1_CRSEN = 0x1000000
	// Position of I2C3EN field.
	RCC_C2APB1ENR1_I2C3EN_Pos = 0x17
	// Bit mask of I2C3EN field.
	RCC_C2APB1ENR1_I2C3EN_Msk = 0x800000
	// Bit I2C3EN.
	RCC_C2APB1ENR1_I2C3EN = 0x800000
	// Position of I2C1EN field.
	RCC_C2APB1ENR1_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_C2APB1ENR1_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_C2APB1ENR1_I2C1EN = 0x200000
	// Position of SPI2EN field.
	RCC_C2APB1ENR1_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_C2APB1ENR1_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_C2APB1ENR1_SPI2EN = 0x4000
	// Position of RTCAPBEN field.
	RCC_C2APB1ENR1_RTCAPBEN_Pos = 0xa
	// Bit mask of RTCAPBEN field.
	RCC_C2APB1ENR1_RTCAPBEN_Msk = 0x400
	// Bit RTCAPBEN.
	RCC_C2APB1ENR1_RTCAPBEN = 0x400
	// Position of LCDEN field.
	RCC_C2APB1ENR1_LCDEN_Pos = 0x9
	// Bit mask of LCDEN field.
	RCC_C2APB1ENR1_LCDEN_Msk = 0x200
	// Bit LCDEN.
	RCC_C2APB1ENR1_LCDEN = 0x200
	// Position of TIM2EN field.
	RCC_C2APB1ENR1_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_C2APB1ENR1_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_C2APB1ENR1_TIM2EN = 0x1

	// C2APB1ENR2: CPU2 APB1 peripheral clock enable register 2
	// Position of LPTIM2EN field.
	RCC_C2APB1ENR2_LPTIM2EN_Pos = 0x5
	// Bit mask of LPTIM2EN field.
	RCC_C2APB1ENR2_LPTIM2EN_Msk = 0x20
	// Bit LPTIM2EN.
	RCC_C2APB1ENR2_LPTIM2EN = 0x20
	// Position of LPUART1EN field.
	RCC_C2APB1ENR2_LPUART1EN_Pos = 0x0
	// Bit mask of LPUART1EN field.
	RCC_C2APB1ENR2_LPUART1EN_Msk = 0x1
	// Bit LPUART1EN.
	RCC_C2APB1ENR2_LPUART1EN = 0x1

	// C2APB2ENR: CPU2 APB2ENR
	// Position of SAI1EN field.
	RCC_C2APB2ENR_SAI1EN_Pos = 0x15
	// Bit mask of SAI1EN field.
	RCC_C2APB2ENR_SAI1EN_Msk = 0x200000
	// Bit SAI1EN.
	RCC_C2APB2ENR_SAI1EN = 0x200000
	// Position of TIM17EN field.
	RCC_C2APB2ENR_TIM17EN_Pos = 0x12
	// Bit mask of TIM17EN field.
	RCC_C2APB2ENR_TIM17EN_Msk = 0x40000
	// Bit TIM17EN.
	RCC_C2APB2ENR_TIM17EN = 0x40000
	// Position of TIM16EN field.
	RCC_C2APB2ENR_TIM16EN_Pos = 0x11
	// Bit mask of TIM16EN field.
	RCC_C2APB2ENR_TIM16EN_Msk = 0x20000
	// Bit TIM16EN.
	RCC_C2APB2ENR_TIM16EN = 0x20000
	// Position of USART1EN field.
	RCC_C2APB2ENR_USART1EN_Pos = 0xe
	// Bit mask of USART1EN field.
	RCC_C2APB2ENR_USART1EN_Msk = 0x4000
	// Bit USART1EN.
	RCC_C2APB2ENR_USART1EN = 0x4000
	// Position of SPI1EN field.
	RCC_C2APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_C2APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_C2APB2ENR_SPI1EN = 0x1000
	// Position of TIM1EN field.
	RCC_C2APB2ENR_TIM1EN_Pos = 0xb
	// Bit mask of TIM1EN field.
	RCC_C2APB2ENR_TIM1EN_Msk = 0x800
	// Bit TIM1EN.
	RCC_C2APB2ENR_TIM1EN = 0x800

	// C2APB3ENR: CPU2 APB3ENR
	// Position of EN802 field.
	RCC_C2APB3ENR_EN802_Pos = 0x1
	// Bit mask of EN802 field.
	RCC_C2APB3ENR_EN802_Msk = 0x2
	// Bit EN802.
	RCC_C2APB3ENR_EN802 = 0x2
	// Position of BLEEN field.
	RCC_C2APB3ENR_BLEEN_Pos = 0x0
	// Bit mask of BLEEN field.
	RCC_C2APB3ENR_BLEEN_Msk = 0x1
	// Bit BLEEN.
	RCC_C2APB3ENR_BLEEN = 0x1

	// C2AHB1SMENR: CPU2 AHB1 peripheral clocks enable in Sleep and Stop modes register
	// Position of TSCSMEN field.
	RCC_C2AHB1SMENR_TSCSMEN_Pos = 0x10
	// Bit mask of TSCSMEN field.
	RCC_C2AHB1SMENR_TSCSMEN_Msk = 0x10000
	// Bit TSCSMEN.
	RCC_C2AHB1SMENR_TSCSMEN = 0x10000
	// Position of CRCSMEN field.
	RCC_C2AHB1SMENR_CRCSMEN_Pos = 0xc
	// Bit mask of CRCSMEN field.
	RCC_C2AHB1SMENR_CRCSMEN_Msk = 0x1000
	// Bit CRCSMEN.
	RCC_C2AHB1SMENR_CRCSMEN = 0x1000
	// Position of SRAM1SMEN field.
	RCC_C2AHB1SMENR_SRAM1SMEN_Pos = 0x9
	// Bit mask of SRAM1SMEN field.
	RCC_C2AHB1SMENR_SRAM1SMEN_Msk = 0x200
	// Bit SRAM1SMEN.
	RCC_C2AHB1SMENR_SRAM1SMEN = 0x200
	// Position of DMAMUXSMEN field.
	RCC_C2AHB1SMENR_DMAMUXSMEN_Pos = 0x2
	// Bit mask of DMAMUXSMEN field.
	RCC_C2AHB1SMENR_DMAMUXSMEN_Msk = 0x4
	// Bit DMAMUXSMEN.
	RCC_C2AHB1SMENR_DMAMUXSMEN = 0x4
	// Position of DMA2SMEN field.
	RCC_C2AHB1SMENR_DMA2SMEN_Pos = 0x1
	// Bit mask of DMA2SMEN field.
	RCC_C2AHB1SMENR_DMA2SMEN_Msk = 0x2
	// Bit DMA2SMEN.
	RCC_C2AHB1SMENR_DMA2SMEN = 0x2
	// Position of DMA1SMEN field.
	RCC_C2AHB1SMENR_DMA1SMEN_Pos = 0x0
	// Bit mask of DMA1SMEN field.
	RCC_C2AHB1SMENR_DMA1SMEN_Msk = 0x1
	// Bit DMA1SMEN.
	RCC_C2AHB1SMENR_DMA1SMEN = 0x1

	// C2AHB2SMENR: CPU2 AHB2 peripheral clocks enable in Sleep and Stop modes register
	// Position of AES1SMEN field.
	RCC_C2AHB2SMENR_AES1SMEN_Pos = 0x10
	// Bit mask of AES1SMEN field.
	RCC_C2AHB2SMENR_AES1SMEN_Msk = 0x10000
	// Bit AES1SMEN.
	RCC_C2AHB2SMENR_AES1SMEN = 0x10000
	// Position of ADCFSSMEN field.
	RCC_C2AHB2SMENR_ADCFSSMEN_Pos = 0xd
	// Bit mask of ADCFSSMEN field.
	RCC_C2AHB2SMENR_ADCFSSMEN_Msk = 0x2000
	// Bit ADCFSSMEN.
	RCC_C2AHB2SMENR_ADCFSSMEN = 0x2000
	// Position of GPIOHSMEN field.
	RCC_C2AHB2SMENR_GPIOHSMEN_Pos = 0x7
	// Bit mask of GPIOHSMEN field.
	RCC_C2AHB2SMENR_GPIOHSMEN_Msk = 0x80
	// Bit GPIOHSMEN.
	RCC_C2AHB2SMENR_GPIOHSMEN = 0x80
	// Position of GPIOESMEN field.
	RCC_C2AHB2SMENR_GPIOESMEN_Pos = 0x4
	// Bit mask of GPIOESMEN field.
	RCC_C2AHB2SMENR_GPIOESMEN_Msk = 0x10
	// Bit GPIOESMEN.
	RCC_C2AHB2SMENR_GPIOESMEN = 0x10
	// Position of GPIODSMEN field.
	RCC_C2AHB2SMENR_GPIODSMEN_Pos = 0x3
	// Bit mask of GPIODSMEN field.
	RCC_C2AHB2SMENR_GPIODSMEN_Msk = 0x8
	// Bit GPIODSMEN.
	RCC_C2AHB2SMENR_GPIODSMEN = 0x8
	// Position of GPIOCSMEN field.
	RCC_C2AHB2SMENR_GPIOCSMEN_Pos = 0x2
	// Bit mask of GPIOCSMEN field.
	RCC_C2AHB2SMENR_GPIOCSMEN_Msk = 0x4
	// Bit GPIOCSMEN.
	RCC_C2AHB2SMENR_GPIOCSMEN = 0x4
	// Position of GPIOBSMEN field.
	RCC_C2AHB2SMENR_GPIOBSMEN_Pos = 0x1
	// Bit mask of GPIOBSMEN field.
	RCC_C2AHB2SMENR_GPIOBSMEN_Msk = 0x2
	// Bit GPIOBSMEN.
	RCC_C2AHB2SMENR_GPIOBSMEN = 0x2
	// Position of GPIOASMEN field.
	RCC_C2AHB2SMENR_GPIOASMEN_Pos = 0x0
	// Bit mask of GPIOASMEN field.
	RCC_C2AHB2SMENR_GPIOASMEN_Msk = 0x1
	// Bit GPIOASMEN.
	RCC_C2AHB2SMENR_GPIOASMEN = 0x1

	// C2AHB3SMENR: CPU2 AHB3 peripheral clocks enable in Sleep and Stop modes register
	// Position of FLASHSMEN field.
	RCC_C2AHB3SMENR_FLASHSMEN_Pos = 0x19
	// Bit mask of FLASHSMEN field.
	RCC_C2AHB3SMENR_FLASHSMEN_Msk = 0x2000000
	// Bit FLASHSMEN.
	RCC_C2AHB3SMENR_FLASHSMEN = 0x2000000
	// Position of SRAM2SMEN field.
	RCC_C2AHB3SMENR_SRAM2SMEN_Pos = 0x18
	// Bit mask of SRAM2SMEN field.
	RCC_C2AHB3SMENR_SRAM2SMEN_Msk = 0x1000000
	// Bit SRAM2SMEN.
	RCC_C2AHB3SMENR_SRAM2SMEN = 0x1000000
	// Position of RNGSMEN field.
	RCC_C2AHB3SMENR_RNGSMEN_Pos = 0x12
	// Bit mask of RNGSMEN field.
	RCC_C2AHB3SMENR_RNGSMEN_Msk = 0x40000
	// Bit RNGSMEN.
	RCC_C2AHB3SMENR_RNGSMEN = 0x40000
	// Position of AES2SMEN field.
	RCC_C2AHB3SMENR_AES2SMEN_Pos = 0x11
	// Bit mask of AES2SMEN field.
	RCC_C2AHB3SMENR_AES2SMEN_Msk = 0x20000
	// Bit AES2SMEN.
	RCC_C2AHB3SMENR_AES2SMEN = 0x20000
	// Position of PKASMEN field.
	RCC_C2AHB3SMENR_PKASMEN_Pos = 0x10
	// Bit mask of PKASMEN field.
	RCC_C2AHB3SMENR_PKASMEN_Msk = 0x10000
	// Bit PKASMEN.
	RCC_C2AHB3SMENR_PKASMEN = 0x10000

	// C2APB1SMENR1: CPU2 APB1SMENR1
	// Position of LPTIM1SMEN field.
	RCC_C2APB1SMENR1_LPTIM1SMEN_Pos = 0x1f
	// Bit mask of LPTIM1SMEN field.
	RCC_C2APB1SMENR1_LPTIM1SMEN_Msk = 0x80000000
	// Bit LPTIM1SMEN.
	RCC_C2APB1SMENR1_LPTIM1SMEN = 0x80000000
	// Position of USBSMEN field.
	RCC_C2APB1SMENR1_USBSMEN_Pos = 0x1a
	// Bit mask of USBSMEN field.
	RCC_C2APB1SMENR1_USBSMEN_Msk = 0x4000000
	// Bit USBSMEN.
	RCC_C2APB1SMENR1_USBSMEN = 0x4000000
	// Position of CRSMEN field.
	RCC_C2APB1SMENR1_CRSMEN_Pos = 0x18
	// Bit mask of CRSMEN field.
	RCC_C2APB1SMENR1_CRSMEN_Msk = 0x1000000
	// Bit CRSMEN.
	RCC_C2APB1SMENR1_CRSMEN = 0x1000000
	// Position of I2C3SMEN field.
	RCC_C2APB1SMENR1_I2C3SMEN_Pos = 0x17
	// Bit mask of I2C3SMEN field.
	RCC_C2APB1SMENR1_I2C3SMEN_Msk = 0x800000
	// Bit I2C3SMEN.
	RCC_C2APB1SMENR1_I2C3SMEN = 0x800000
	// Position of I2C1SMEN field.
	RCC_C2APB1SMENR1_I2C1SMEN_Pos = 0x15
	// Bit mask of I2C1SMEN field.
	RCC_C2APB1SMENR1_I2C1SMEN_Msk = 0x200000
	// Bit I2C1SMEN.
	RCC_C2APB1SMENR1_I2C1SMEN = 0x200000
	// Position of SPI2SMEN field.
	RCC_C2APB1SMENR1_SPI2SMEN_Pos = 0xe
	// Bit mask of SPI2SMEN field.
	RCC_C2APB1SMENR1_SPI2SMEN_Msk = 0x4000
	// Bit SPI2SMEN.
	RCC_C2APB1SMENR1_SPI2SMEN = 0x4000
	// Position of RTCAPBSMEN field.
	RCC_C2APB1SMENR1_RTCAPBSMEN_Pos = 0xa
	// Bit mask of RTCAPBSMEN field.
	RCC_C2APB1SMENR1_RTCAPBSMEN_Msk = 0x400
	// Bit RTCAPBSMEN.
	RCC_C2APB1SMENR1_RTCAPBSMEN = 0x400
	// Position of LCDSMEN field.
	RCC_C2APB1SMENR1_LCDSMEN_Pos = 0x9
	// Bit mask of LCDSMEN field.
	RCC_C2APB1SMENR1_LCDSMEN_Msk = 0x200
	// Bit LCDSMEN.
	RCC_C2APB1SMENR1_LCDSMEN = 0x200
	// Position of TIM2SMEN field.
	RCC_C2APB1SMENR1_TIM2SMEN_Pos = 0x0
	// Bit mask of TIM2SMEN field.
	RCC_C2APB1SMENR1_TIM2SMEN_Msk = 0x1
	// Bit TIM2SMEN.
	RCC_C2APB1SMENR1_TIM2SMEN = 0x1

	// C2APB1SMENR2: CPU2 APB1 peripheral clocks enable in Sleep and Stop modes register 2
	// Position of LPTIM2SMEN field.
	RCC_C2APB1SMENR2_LPTIM2SMEN_Pos = 0x5
	// Bit mask of LPTIM2SMEN field.
	RCC_C2APB1SMENR2_LPTIM2SMEN_Msk = 0x20
	// Bit LPTIM2SMEN.
	RCC_C2APB1SMENR2_LPTIM2SMEN = 0x20
	// Position of LPUART1SMEN field.
	RCC_C2APB1SMENR2_LPUART1SMEN_Pos = 0x0
	// Bit mask of LPUART1SMEN field.
	RCC_C2APB1SMENR2_LPUART1SMEN_Msk = 0x1
	// Bit LPUART1SMEN.
	RCC_C2APB1SMENR2_LPUART1SMEN = 0x1

	// C2APB2SMENR: CPU2 APB2SMENR
	// Position of SAI1SMEN field.
	RCC_C2APB2SMENR_SAI1SMEN_Pos = 0x15
	// Bit mask of SAI1SMEN field.
	RCC_C2APB2SMENR_SAI1SMEN_Msk = 0x200000
	// Bit SAI1SMEN.
	RCC_C2APB2SMENR_SAI1SMEN = 0x200000
	// Position of TIM17SMEN field.
	RCC_C2APB2SMENR_TIM17SMEN_Pos = 0x12
	// Bit mask of TIM17SMEN field.
	RCC_C2APB2SMENR_TIM17SMEN_Msk = 0x40000
	// Bit TIM17SMEN.
	RCC_C2APB2SMENR_TIM17SMEN = 0x40000
	// Position of TIM16SMEN field.
	RCC_C2APB2SMENR_TIM16SMEN_Pos = 0x11
	// Bit mask of TIM16SMEN field.
	RCC_C2APB2SMENR_TIM16SMEN_Msk = 0x20000
	// Bit TIM16SMEN.
	RCC_C2APB2SMENR_TIM16SMEN = 0x20000
	// Position of USART1SMEN field.
	RCC_C2APB2SMENR_USART1SMEN_Pos = 0xe
	// Bit mask of USART1SMEN field.
	RCC_C2APB2SMENR_USART1SMEN_Msk = 0x4000
	// Bit USART1SMEN.
	RCC_C2APB2SMENR_USART1SMEN = 0x4000
	// Position of SPI1SMEN field.
	RCC_C2APB2SMENR_SPI1SMEN_Pos = 0xc
	// Bit mask of SPI1SMEN field.
	RCC_C2APB2SMENR_SPI1SMEN_Msk = 0x1000
	// Bit SPI1SMEN.
	RCC_C2APB2SMENR_SPI1SMEN = 0x1000
	// Position of TIM1SMEN field.
	RCC_C2APB2SMENR_TIM1SMEN_Pos = 0xb
	// Bit mask of TIM1SMEN field.
	RCC_C2APB2SMENR_TIM1SMEN_Msk = 0x800
	// Bit TIM1SMEN.
	RCC_C2APB2SMENR_TIM1SMEN = 0x800

	// C2APB3SMENR: CPU2 APB3SMENR
	// Position of SMEN802 field.
	RCC_C2APB3SMENR_SMEN802_Pos = 0x1
	// Bit mask of SMEN802 field.
	RCC_C2APB3SMENR_SMEN802_Msk = 0x2
	// Bit SMEN802.
	RCC_C2APB3SMENR_SMEN802 = 0x2
	// Position of BLESMEN field.
	RCC_C2APB3SMENR_BLESMEN_Pos = 0x0
	// Bit mask of BLESMEN field.
	RCC_C2APB3SMENR_BLESMEN_Msk = 0x1
	// Bit BLESMEN.
	RCC_C2APB3SMENR_BLESMEN = 0x1
)

// Bitfields for PWR: Power control
const (
	// CR1: Power control register 1
	// Position of LPR field.
	PWR_CR1_LPR_Pos = 0xe
	// Bit mask of LPR field.
	PWR_CR1_LPR_Msk = 0x4000
	// Bit LPR.
	PWR_CR1_LPR = 0x4000
	// Position of VOS field.
	PWR_CR1_VOS_Pos = 0x9
	// Bit mask of VOS field.
	PWR_CR1_VOS_Msk = 0x600
	// Position of DBP field.
	PWR_CR1_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR1_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR1_DBP = 0x100
	// Position of FPDS field.
	PWR_CR1_FPDS_Pos = 0x5
	// Bit mask of FPDS field.
	PWR_CR1_FPDS_Msk = 0x20
	// Bit FPDS.
	PWR_CR1_FPDS = 0x20
	// Position of FPDR field.
	PWR_CR1_FPDR_Pos = 0x4
	// Bit mask of FPDR field.
	PWR_CR1_FPDR_Msk = 0x10
	// Bit FPDR.
	PWR_CR1_FPDR = 0x10
	// Position of LPMS field.
	PWR_CR1_LPMS_Pos = 0x0
	// Bit mask of LPMS field.
	PWR_CR1_LPMS_Msk = 0x7

	// CR2: Power control register 2
	// Position of USV field.
	PWR_CR2_USV_Pos = 0xa
	// Bit mask of USV field.
	PWR_CR2_USV_Msk = 0x400
	// Bit USV.
	PWR_CR2_USV = 0x400
	// Position of PVME3 field.
	PWR_CR2_PVME3_Pos = 0x6
	// Bit mask of PVME3 field.
	PWR_CR2_PVME3_Msk = 0x40
	// Bit PVME3.
	PWR_CR2_PVME3 = 0x40
	// Position of PVME1 field.
	PWR_CR2_PVME1_Pos = 0x4
	// Bit mask of PVME1 field.
	PWR_CR2_PVME1_Msk = 0x10
	// Bit PVME1.
	PWR_CR2_PVME1 = 0x10
	// Position of PLS field.
	PWR_CR2_PLS_Pos = 0x1
	// Bit mask of PLS field.
	PWR_CR2_PLS_Msk = 0xe
	// Position of PVDE field.
	PWR_CR2_PVDE_Pos = 0x0
	// Bit mask of PVDE field.
	PWR_CR2_PVDE_Msk = 0x1
	// Bit PVDE.
	PWR_CR2_PVDE = 0x1

	// CR3: Power control register 3
	// Position of EIWUL field.
	PWR_CR3_EIWUL_Pos = 0xf
	// Bit mask of EIWUL field.
	PWR_CR3_EIWUL_Msk = 0x8000
	// Bit EIWUL.
	PWR_CR3_EIWUL = 0x8000
	// Position of EC2H field.
	PWR_CR3_EC2H_Pos = 0xe
	// Bit mask of EC2H field.
	PWR_CR3_EC2H_Msk = 0x4000
	// Bit EC2H.
	PWR_CR3_EC2H = 0x4000
	// Position of E802A field.
	PWR_CR3_E802A_Pos = 0xd
	// Bit mask of E802A field.
	PWR_CR3_E802A_Msk = 0x2000
	// Bit E802A.
	PWR_CR3_E802A = 0x2000
	// Position of EBLEA field.
	PWR_CR3_EBLEA_Pos = 0xb
	// Bit mask of EBLEA field.
	PWR_CR3_EBLEA_Msk = 0x800
	// Bit EBLEA.
	PWR_CR3_EBLEA = 0x800
	// Position of ECRPE field.
	PWR_CR3_ECRPE_Pos = 0xc
	// Bit mask of ECRPE field.
	PWR_CR3_ECRPE_Msk = 0x1000
	// Bit ECRPE.
	PWR_CR3_ECRPE = 0x1000
	// Position of APC field.
	PWR_CR3_APC_Pos = 0xa
	// Bit mask of APC field.
	PWR_CR3_APC_Msk = 0x400
	// Bit APC.
	PWR_CR3_APC = 0x400
	// Position of RRS field.
	PWR_CR3_RRS_Pos = 0x9
	// Bit mask of RRS field.
	PWR_CR3_RRS_Msk = 0x200
	// Bit RRS.
	PWR_CR3_RRS = 0x200
	// Position of EBORHSDFB field.
	PWR_CR3_EBORHSDFB_Pos = 0x8
	// Bit mask of EBORHSDFB field.
	PWR_CR3_EBORHSDFB_Msk = 0x100
	// Bit EBORHSDFB.
	PWR_CR3_EBORHSDFB = 0x100
	// Position of EWUP5 field.
	PWR_CR3_EWUP5_Pos = 0x4
	// Bit mask of EWUP5 field.
	PWR_CR3_EWUP5_Msk = 0x10
	// Bit EWUP5.
	PWR_CR3_EWUP5 = 0x10
	// Position of EWUP4 field.
	PWR_CR3_EWUP4_Pos = 0x3
	// Bit mask of EWUP4 field.
	PWR_CR3_EWUP4_Msk = 0x8
	// Bit EWUP4.
	PWR_CR3_EWUP4 = 0x8
	// Position of EWUP3 field.
	PWR_CR3_EWUP3_Pos = 0x2
	// Bit mask of EWUP3 field.
	PWR_CR3_EWUP3_Msk = 0x4
	// Bit EWUP3.
	PWR_CR3_EWUP3 = 0x4
	// Position of EWUP2 field.
	PWR_CR3_EWUP2_Pos = 0x1
	// Bit mask of EWUP2 field.
	PWR_CR3_EWUP2_Msk = 0x2
	// Bit EWUP2.
	PWR_CR3_EWUP2 = 0x2
	// Position of EWUP1 field.
	PWR_CR3_EWUP1_Pos = 0x0
	// Bit mask of EWUP1 field.
	PWR_CR3_EWUP1_Msk = 0x1
	// Bit EWUP1.
	PWR_CR3_EWUP1 = 0x1

	// CR4: Power control register 4
	// Position of C2BOOT field.
	PWR_CR4_C2BOOT_Pos = 0xf
	// Bit mask of C2BOOT field.
	PWR_CR4_C2BOOT_Msk = 0x8000
	// Bit C2BOOT.
	PWR_CR4_C2BOOT = 0x8000
	// Position of VBRS field.
	PWR_CR4_VBRS_Pos = 0x9
	// Bit mask of VBRS field.
	PWR_CR4_VBRS_Msk = 0x200
	// Bit VBRS.
	PWR_CR4_VBRS = 0x200
	// Position of VBE field.
	PWR_CR4_VBE_Pos = 0x8
	// Bit mask of VBE field.
	PWR_CR4_VBE_Msk = 0x100
	// Bit VBE.
	PWR_CR4_VBE = 0x100
	// Position of WP5 field.
	PWR_CR4_WP5_Pos = 0x4
	// Bit mask of WP5 field.
	PWR_CR4_WP5_Msk = 0x10
	// Bit WP5.
	PWR_CR4_WP5 = 0x10
	// Position of WP4 field.
	PWR_CR4_WP4_Pos = 0x3
	// Bit mask of WP4 field.
	PWR_CR4_WP4_Msk = 0x8
	// Bit WP4.
	PWR_CR4_WP4 = 0x8
	// Position of WP3 field.
	PWR_CR4_WP3_Pos = 0x2
	// Bit mask of WP3 field.
	PWR_CR4_WP3_Msk = 0x4
	// Bit WP3.
	PWR_CR4_WP3 = 0x4
	// Position of WP2 field.
	PWR_CR4_WP2_Pos = 0x1
	// Bit mask of WP2 field.
	PWR_CR4_WP2_Msk = 0x2
	// Bit WP2.
	PWR_CR4_WP2 = 0x2
	// Position of WP1 field.
	PWR_CR4_WP1_Pos = 0x0
	// Bit mask of WP1 field.
	PWR_CR4_WP1_Msk = 0x1
	// Bit WP1.
	PWR_CR4_WP1 = 0x1

	// SR1: Power status register 1
	// Position of WUFI field.
	PWR_SR1_WUFI_Pos = 0xf
	// Bit mask of WUFI field.
	PWR_SR1_WUFI_Msk = 0x8000
	// Bit WUFI.
	PWR_SR1_WUFI = 0x8000
	// Position of C2HF field.
	PWR_SR1_C2HF_Pos = 0xe
	// Bit mask of C2HF field.
	PWR_SR1_C2HF_Msk = 0x4000
	// Bit C2HF.
	PWR_SR1_C2HF = 0x4000
	// Position of AF802 field.
	PWR_SR1_AF802_Pos = 0xd
	// Bit mask of AF802 field.
	PWR_SR1_AF802_Msk = 0x2000
	// Bit AF802.
	PWR_SR1_AF802 = 0x2000
	// Position of BLEAF field.
	PWR_SR1_BLEAF_Pos = 0xc
	// Bit mask of BLEAF field.
	PWR_SR1_BLEAF_Msk = 0x1000
	// Bit BLEAF.
	PWR_SR1_BLEAF = 0x1000
	// Position of CRPEF field.
	PWR_SR1_CRPEF_Pos = 0xb
	// Bit mask of CRPEF field.
	PWR_SR1_CRPEF_Msk = 0x800
	// Bit CRPEF.
	PWR_SR1_CRPEF = 0x800
	// Position of _802WUF field.
	PWR_SR1__802WUF_Pos = 0xa
	// Bit mask of _802WUF field.
	PWR_SR1__802WUF_Msk = 0x400
	// Bit _802WUF.
	PWR_SR1__802WUF = 0x400
	// Position of BLEWUF field.
	PWR_SR1_BLEWUF_Pos = 0x9
	// Bit mask of BLEWUF field.
	PWR_SR1_BLEWUF_Msk = 0x200
	// Bit BLEWUF.
	PWR_SR1_BLEWUF = 0x200
	// Position of BORHF field.
	PWR_SR1_BORHF_Pos = 0x8
	// Bit mask of BORHF field.
	PWR_SR1_BORHF_Msk = 0x100
	// Bit BORHF.
	PWR_SR1_BORHF = 0x100
	// Position of SDFBF field.
	PWR_SR1_SDFBF_Pos = 0x7
	// Bit mask of SDFBF field.
	PWR_SR1_SDFBF_Msk = 0x80
	// Bit SDFBF.
	PWR_SR1_SDFBF = 0x80
	// Position of CWUF5 field.
	PWR_SR1_CWUF5_Pos = 0x4
	// Bit mask of CWUF5 field.
	PWR_SR1_CWUF5_Msk = 0x10
	// Bit CWUF5.
	PWR_SR1_CWUF5 = 0x10
	// Position of CWUF4 field.
	PWR_SR1_CWUF4_Pos = 0x3
	// Bit mask of CWUF4 field.
	PWR_SR1_CWUF4_Msk = 0x8
	// Bit CWUF4.
	PWR_SR1_CWUF4 = 0x8
	// Position of CWUF3 field.
	PWR_SR1_CWUF3_Pos = 0x2
	// Bit mask of CWUF3 field.
	PWR_SR1_CWUF3_Msk = 0x4
	// Bit CWUF3.
	PWR_SR1_CWUF3 = 0x4
	// Position of CWUF2 field.
	PWR_SR1_CWUF2_Pos = 0x1
	// Bit mask of CWUF2 field.
	PWR_SR1_CWUF2_Msk = 0x2
	// Bit CWUF2.
	PWR_SR1_CWUF2 = 0x2
	// Position of CWUF1 field.
	PWR_SR1_CWUF1_Pos = 0x0
	// Bit mask of CWUF1 field.
	PWR_SR1_CWUF1_Msk = 0x1
	// Bit CWUF1.
	PWR_SR1_CWUF1 = 0x1

	// SR2: Power status register 2
	// Position of PVMO3 field.
	PWR_SR2_PVMO3_Pos = 0xe
	// Bit mask of PVMO3 field.
	PWR_SR2_PVMO3_Msk = 0x4000
	// Bit PVMO3.
	PWR_SR2_PVMO3 = 0x4000
	// Position of PVMO1 field.
	PWR_SR2_PVMO1_Pos = 0xc
	// Bit mask of PVMO1 field.
	PWR_SR2_PVMO1_Msk = 0x1000
	// Bit PVMO1.
	PWR_SR2_PVMO1 = 0x1000
	// Position of PVDO field.
	PWR_SR2_PVDO_Pos = 0xb
	// Bit mask of PVDO field.
	PWR_SR2_PVDO_Msk = 0x800
	// Bit PVDO.
	PWR_SR2_PVDO = 0x800
	// Position of VOSF field.
	PWR_SR2_VOSF_Pos = 0xa
	// Bit mask of VOSF field.
	PWR_SR2_VOSF_Msk = 0x400
	// Bit VOSF.
	PWR_SR2_VOSF = 0x400
	// Position of REGLPF field.
	PWR_SR2_REGLPF_Pos = 0x9
	// Bit mask of REGLPF field.
	PWR_SR2_REGLPF_Msk = 0x200
	// Bit REGLPF.
	PWR_SR2_REGLPF = 0x200
	// Position of REGLPS field.
	PWR_SR2_REGLPS_Pos = 0x8
	// Bit mask of REGLPS field.
	PWR_SR2_REGLPS_Msk = 0x100
	// Bit REGLPS.
	PWR_SR2_REGLPS = 0x100
	// Position of SDSMPSF field.
	PWR_SR2_SDSMPSF_Pos = 0x1
	// Bit mask of SDSMPSF field.
	PWR_SR2_SDSMPSF_Msk = 0x2
	// Bit SDSMPSF.
	PWR_SR2_SDSMPSF = 0x2
	// Position of SDBF field.
	PWR_SR2_SDBF_Pos = 0x0
	// Bit mask of SDBF field.
	PWR_SR2_SDBF_Msk = 0x1
	// Bit SDBF.
	PWR_SR2_SDBF = 0x1

	// SCR: Power status clear register
	// Position of CC2HF field.
	PWR_SCR_CC2HF_Pos = 0xe
	// Bit mask of CC2HF field.
	PWR_SCR_CC2HF_Msk = 0x4000
	// Bit CC2HF.
	PWR_SCR_CC2HF = 0x4000
	// Position of C802AF field.
	PWR_SCR_C802AF_Pos = 0xd
	// Bit mask of C802AF field.
	PWR_SCR_C802AF_Msk = 0x2000
	// Bit C802AF.
	PWR_SCR_C802AF = 0x2000
	// Position of CBLEAF field.
	PWR_SCR_CBLEAF_Pos = 0xc
	// Bit mask of CBLEAF field.
	PWR_SCR_CBLEAF_Msk = 0x1000
	// Bit CBLEAF.
	PWR_SCR_CBLEAF = 0x1000
	// Position of CCRPEF field.
	PWR_SCR_CCRPEF_Pos = 0xb
	// Bit mask of CCRPEF field.
	PWR_SCR_CCRPEF_Msk = 0x800
	// Bit CCRPEF.
	PWR_SCR_CCRPEF = 0x800
	// Position of C802WUF field.
	PWR_SCR_C802WUF_Pos = 0xa
	// Bit mask of C802WUF field.
	PWR_SCR_C802WUF_Msk = 0x400
	// Bit C802WUF.
	PWR_SCR_C802WUF = 0x400
	// Position of CBLEWUF field.
	PWR_SCR_CBLEWUF_Pos = 0x9
	// Bit mask of CBLEWUF field.
	PWR_SCR_CBLEWUF_Msk = 0x200
	// Bit CBLEWUF.
	PWR_SCR_CBLEWUF = 0x200
	// Position of CBORHF field.
	PWR_SCR_CBORHF_Pos = 0x8
	// Bit mask of CBORHF field.
	PWR_SCR_CBORHF_Msk = 0x100
	// Bit CBORHF.
	PWR_SCR_CBORHF = 0x100
	// Position of CSMPSFBF field.
	PWR_SCR_CSMPSFBF_Pos = 0x7
	// Bit mask of CSMPSFBF field.
	PWR_SCR_CSMPSFBF_Msk = 0x80
	// Bit CSMPSFBF.
	PWR_SCR_CSMPSFBF = 0x80
	// Position of CWUF5 field.
	PWR_SCR_CWUF5_Pos = 0x4
	// Bit mask of CWUF5 field.
	PWR_SCR_CWUF5_Msk = 0x10
	// Bit CWUF5.
	PWR_SCR_CWUF5 = 0x10
	// Position of CWUF4 field.
	PWR_SCR_CWUF4_Pos = 0x3
	// Bit mask of CWUF4 field.
	PWR_SCR_CWUF4_Msk = 0x8
	// Bit CWUF4.
	PWR_SCR_CWUF4 = 0x8
	// Position of CWUF3 field.
	PWR_SCR_CWUF3_Pos = 0x2
	// Bit mask of CWUF3 field.
	PWR_SCR_CWUF3_Msk = 0x4
	// Bit CWUF3.
	PWR_SCR_CWUF3 = 0x4
	// Position of CWUF2 field.
	PWR_SCR_CWUF2_Pos = 0x1
	// Bit mask of CWUF2 field.
	PWR_SCR_CWUF2_Msk = 0x2
	// Bit CWUF2.
	PWR_SCR_CWUF2 = 0x2
	// Position of CWUF1 field.
	PWR_SCR_CWUF1_Pos = 0x0
	// Bit mask of CWUF1 field.
	PWR_SCR_CWUF1_Msk = 0x1
	// Bit CWUF1.
	PWR_SCR_CWUF1 = 0x1

	// CR5: Power control register 5
	// Position of SDEB field.
	PWR_CR5_SDEB_Pos = 0xf
	// Bit mask of SDEB field.
	PWR_CR5_SDEB_Msk = 0x8000
	// Bit SDEB.
	PWR_CR5_SDEB = 0x8000
	// Position of SDBEN field.
	PWR_CR5_SDBEN_Pos = 0xe
	// Bit mask of SDBEN field.
	PWR_CR5_SDBEN_Msk = 0x4000
	// Bit SDBEN.
	PWR_CR5_SDBEN = 0x4000
	// Position of SMPSCFG field.
	PWR_CR5_SMPSCFG_Pos = 0x9
	// Bit mask of SMPSCFG field.
	PWR_CR5_SMPSCFG_Msk = 0x200
	// Bit SMPSCFG.
	PWR_CR5_SMPSCFG = 0x200
	// Position of BORHC field.
	PWR_CR5_BORHC_Pos = 0x8
	// Bit mask of BORHC field.
	PWR_CR5_BORHC_Msk = 0x100
	// Bit BORHC.
	PWR_CR5_BORHC = 0x100
	// Position of SDSC field.
	PWR_CR5_SDSC_Pos = 0x4
	// Bit mask of SDSC field.
	PWR_CR5_SDSC_Msk = 0x70
	// Position of SDVOS field.
	PWR_CR5_SDVOS_Pos = 0x0
	// Bit mask of SDVOS field.
	PWR_CR5_SDVOS_Msk = 0xf

	// PUCRA: Power Port A pull-up control register
	// Position of PU15 field.
	PWR_PUCRA_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRA_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRA_PU15 = 0x8000
	// Position of PU13 field.
	PWR_PUCRA_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRA_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRA_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRA_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRA_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRA_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRA_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRA_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRA_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRA_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRA_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRA_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRA_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRA_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRA_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRA_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRA_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRA_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRA_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRA_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRA_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRA_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRA_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRA_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRA_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRA_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRA_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRA_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRA_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRA_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRA_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRA_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRA_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRA_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRA_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRA_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRA_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRA_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRA_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRA_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRA_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRA_PU0 = 0x1

	// PDCRA: Power Port A pull-down control register
	// Position of PD14 field.
	PWR_PDCRA_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRA_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRA_PD14 = 0x4000
	// Position of PD12 field.
	PWR_PDCRA_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRA_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRA_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRA_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRA_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRA_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRA_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRA_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRA_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRA_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRA_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRA_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRA_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRA_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRA_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRA_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRA_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRA_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRA_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRA_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRA_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRA_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRA_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRA_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRA_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRA_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRA_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRA_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRA_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRA_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRA_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRA_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRA_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRA_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRA_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRA_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRA_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRA_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRA_PD0 = 0x1

	// PUCRB: Power Port B pull-up control register
	// Position of PU15 field.
	PWR_PUCRB_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRB_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRB_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRB_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRB_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRB_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRB_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRB_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRB_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRB_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRB_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRB_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRB_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRB_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRB_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRB_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRB_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRB_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRB_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRB_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRB_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRB_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRB_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRB_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRB_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRB_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRB_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRB_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRB_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRB_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRB_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRB_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRB_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRB_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRB_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRB_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRB_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRB_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRB_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRB_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRB_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRB_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRB_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRB_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRB_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRB_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRB_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRB_PU0 = 0x1

	// PDCRB: Power Port B pull-down control register
	// Position of PD15 field.
	PWR_PDCRB_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRB_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRB_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRB_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRB_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRB_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRB_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRB_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRB_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRB_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRB_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRB_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRB_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRB_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRB_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRB_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRB_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRB_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRB_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRB_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRB_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRB_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRB_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRB_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRB_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRB_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRB_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRB_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRB_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRB_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRB_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRB_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRB_PD5 = 0x20
	// Position of PD3 field.
	PWR_PDCRB_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRB_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRB_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRB_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRB_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRB_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRB_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRB_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRB_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRB_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRB_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRB_PD0 = 0x1

	// PUCRC: Power Port C pull-up control register
	// Position of PU15 field.
	PWR_PUCRC_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRC_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRC_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRC_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRC_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRC_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRC_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRC_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRC_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRC_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRC_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRC_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRC_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRC_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRC_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRC_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRC_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRC_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRC_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRC_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRC_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRC_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRC_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRC_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRC_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRC_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRC_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRC_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRC_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRC_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRC_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRC_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRC_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRC_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRC_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRC_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRC_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRC_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRC_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRC_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRC_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRC_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRC_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRC_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRC_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRC_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRC_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRC_PU0 = 0x1

	// PDCRC: Power Port C pull-down control register
	// Position of PD15 field.
	PWR_PDCRC_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRC_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRC_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRC_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRC_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRC_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRC_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRC_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRC_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRC_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRC_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRC_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRC_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRC_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRC_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRC_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRC_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRC_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRC_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRC_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRC_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRC_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRC_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRC_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRC_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRC_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRC_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRC_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRC_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRC_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRC_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRC_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRC_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRC_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRC_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRC_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRC_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRC_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRC_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRC_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRC_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRC_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRC_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRC_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRC_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRC_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRC_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRC_PD0 = 0x1

	// PUCRD: Power Port D pull-up control register
	// Position of PU15 field.
	PWR_PUCRD_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRD_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRD_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRD_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRD_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRD_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRD_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRD_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRD_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRD_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRD_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRD_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRD_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRD_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRD_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRD_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRD_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRD_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRD_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRD_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRD_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRD_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRD_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRD_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRD_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRD_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRD_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRD_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRD_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRD_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRD_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRD_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRD_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRD_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRD_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRD_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRD_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRD_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRD_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRD_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRD_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRD_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRD_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRD_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRD_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRD_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRD_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRD_PU0 = 0x1

	// PDCRD: Power Port D pull-down control register
	// Position of PD15 field.
	PWR_PDCRD_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRD_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRD_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRD_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRD_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRD_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRD_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRD_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRD_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRD_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRD_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRD_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRD_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRD_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRD_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRD_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRD_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRD_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRD_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRD_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRD_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRD_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRD_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRD_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRD_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRD_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRD_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRD_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRD_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRD_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRD_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRD_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRD_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRD_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRD_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRD_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRD_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRD_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRD_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRD_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRD_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRD_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRD_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRD_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRD_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRD_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRD_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRD_PD0 = 0x1

	// PUCRE: Power Port E pull-up control register
	// Position of PU4 field.
	PWR_PUCRE_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRE_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRE_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRE_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRE_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRE_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRE_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRE_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRE_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRE_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRE_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRE_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRE_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRE_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRE_PU0 = 0x1

	// PDCRE: Power Port E pull-down control register
	// Position of PD4 field.
	PWR_PDCRE_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRE_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRE_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRE_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRE_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRE_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRE_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRE_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRE_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRE_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRE_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRE_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRE_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRE_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRE_PD0 = 0x1

	// PUCRH: Power Port H pull-up control register
	// Position of PU3 field.
	PWR_PUCRH_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRH_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRH_PU3 = 0x8
	// Position of PU1 field.
	PWR_PUCRH_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRH_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRH_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRH_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRH_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRH_PU0 = 0x1

	// PDCRH: Power Port H pull-down control register
	// Position of PD3 field.
	PWR_PDCRH_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRH_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRH_PD3 = 0x8
	// Position of PD1 field.
	PWR_PDCRH_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRH_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRH_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRH_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRH_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRH_PD0 = 0x1

	// C2CR1: CPU2 Power control register 1
	// Position of _802EWKUP field.
	PWR_C2CR1__802EWKUP_Pos = 0xf
	// Bit mask of _802EWKUP field.
	PWR_C2CR1__802EWKUP_Msk = 0x8000
	// Bit _802EWKUP.
	PWR_C2CR1__802EWKUP = 0x8000
	// Position of BLEEWKUP field.
	PWR_C2CR1_BLEEWKUP_Pos = 0xe
	// Bit mask of BLEEWKUP field.
	PWR_C2CR1_BLEEWKUP_Msk = 0x4000
	// Bit BLEEWKUP.
	PWR_C2CR1_BLEEWKUP = 0x4000
	// Position of FPDS field.
	PWR_C2CR1_FPDS_Pos = 0x5
	// Bit mask of FPDS field.
	PWR_C2CR1_FPDS_Msk = 0x20
	// Bit FPDS.
	PWR_C2CR1_FPDS = 0x20
	// Position of FPDR field.
	PWR_C2CR1_FPDR_Pos = 0x4
	// Bit mask of FPDR field.
	PWR_C2CR1_FPDR_Msk = 0x10
	// Bit FPDR.
	PWR_C2CR1_FPDR = 0x10
	// Position of LPMS field.
	PWR_C2CR1_LPMS_Pos = 0x0
	// Bit mask of LPMS field.
	PWR_C2CR1_LPMS_Msk = 0x7

	// C2CR3: CPU2 Power control register 3
	// Position of EIWUL field.
	PWR_C2CR3_EIWUL_Pos = 0xf
	// Bit mask of EIWUL field.
	PWR_C2CR3_EIWUL_Msk = 0x8000
	// Bit EIWUL.
	PWR_C2CR3_EIWUL = 0x8000
	// Position of APC field.
	PWR_C2CR3_APC_Pos = 0xc
	// Bit mask of APC field.
	PWR_C2CR3_APC_Msk = 0x1000
	// Bit APC.
	PWR_C2CR3_APC = 0x1000
	// Position of E802WUP field.
	PWR_C2CR3_E802WUP_Pos = 0xa
	// Bit mask of E802WUP field.
	PWR_C2CR3_E802WUP_Msk = 0x400
	// Bit E802WUP.
	PWR_C2CR3_E802WUP = 0x400
	// Position of EBLEWUP field.
	PWR_C2CR3_EBLEWUP_Pos = 0x9
	// Bit mask of EBLEWUP field.
	PWR_C2CR3_EBLEWUP_Msk = 0x200
	// Bit EBLEWUP.
	PWR_C2CR3_EBLEWUP = 0x200
	// Position of EWUP5 field.
	PWR_C2CR3_EWUP5_Pos = 0x4
	// Bit mask of EWUP5 field.
	PWR_C2CR3_EWUP5_Msk = 0x10
	// Bit EWUP5.
	PWR_C2CR3_EWUP5 = 0x10
	// Position of EWUP4 field.
	PWR_C2CR3_EWUP4_Pos = 0x3
	// Bit mask of EWUP4 field.
	PWR_C2CR3_EWUP4_Msk = 0x8
	// Bit EWUP4.
	PWR_C2CR3_EWUP4 = 0x8
	// Position of EWUP3 field.
	PWR_C2CR3_EWUP3_Pos = 0x2
	// Bit mask of EWUP3 field.
	PWR_C2CR3_EWUP3_Msk = 0x4
	// Bit EWUP3.
	PWR_C2CR3_EWUP3 = 0x4
	// Position of EWUP2 field.
	PWR_C2CR3_EWUP2_Pos = 0x1
	// Bit mask of EWUP2 field.
	PWR_C2CR3_EWUP2_Msk = 0x2
	// Bit EWUP2.
	PWR_C2CR3_EWUP2 = 0x2
	// Position of EWUP1 field.
	PWR_C2CR3_EWUP1_Pos = 0x0
	// Bit mask of EWUP1 field.
	PWR_C2CR3_EWUP1_Msk = 0x1
	// Bit EWUP1.
	PWR_C2CR3_EWUP1 = 0x1

	// EXTSCR: Power status clear register
	// Position of C2DS field.
	PWR_EXTSCR_C2DS_Pos = 0xf
	// Bit mask of C2DS field.
	PWR_EXTSCR_C2DS_Msk = 0x8000
	// Bit C2DS.
	PWR_EXTSCR_C2DS = 0x8000
	// Position of C1DS field.
	PWR_EXTSCR_C1DS_Pos = 0xe
	// Bit mask of C1DS field.
	PWR_EXTSCR_C1DS_Msk = 0x4000
	// Bit C1DS.
	PWR_EXTSCR_C1DS = 0x4000
	// Position of CRPF field.
	PWR_EXTSCR_CRPF_Pos = 0xd
	// Bit mask of CRPF field.
	PWR_EXTSCR_CRPF_Msk = 0x2000
	// Bit CRPF.
	PWR_EXTSCR_CRPF = 0x2000
	// Position of C2STOPF field.
	PWR_EXTSCR_C2STOPF_Pos = 0xb
	// Bit mask of C2STOPF field.
	PWR_EXTSCR_C2STOPF_Msk = 0x800
	// Bit C2STOPF.
	PWR_EXTSCR_C2STOPF = 0x800
	// Position of C2SBF field.
	PWR_EXTSCR_C2SBF_Pos = 0xa
	// Bit mask of C2SBF field.
	PWR_EXTSCR_C2SBF_Msk = 0x400
	// Bit C2SBF.
	PWR_EXTSCR_C2SBF = 0x400
	// Position of C1STOPF field.
	PWR_EXTSCR_C1STOPF_Pos = 0x9
	// Bit mask of C1STOPF field.
	PWR_EXTSCR_C1STOPF_Msk = 0x200
	// Bit C1STOPF.
	PWR_EXTSCR_C1STOPF = 0x200
	// Position of C1SBF field.
	PWR_EXTSCR_C1SBF_Pos = 0x8
	// Bit mask of C1SBF field.
	PWR_EXTSCR_C1SBF_Msk = 0x100
	// Bit C1SBF.
	PWR_EXTSCR_C1SBF = 0x100
	// Position of CCRPF field.
	PWR_EXTSCR_CCRPF_Pos = 0x2
	// Bit mask of CCRPF field.
	PWR_EXTSCR_CCRPF_Msk = 0x4
	// Bit CCRPF.
	PWR_EXTSCR_CCRPF = 0x4
	// Position of C2CSSF field.
	PWR_EXTSCR_C2CSSF_Pos = 0x1
	// Bit mask of C2CSSF field.
	PWR_EXTSCR_C2CSSF_Msk = 0x2
	// Bit C2CSSF.
	PWR_EXTSCR_C2CSSF = 0x2
	// Position of C1CSSF field.
	PWR_EXTSCR_C1CSSF_Pos = 0x0
	// Bit mask of C1CSSF field.
	PWR_EXTSCR_C1CSSF_Msk = 0x1
	// Bit C1CSSF.
	PWR_EXTSCR_C1CSSF = 0x1
)

// Bitfields for SYSCFG: System configuration controller
const (
	// MEMRMP: memory remap register
	// Position of MEM_MODE field.
	SYSCFG_MEMRMP_MEM_MODE_Pos = 0x0
	// Bit mask of MEM_MODE field.
	SYSCFG_MEMRMP_MEM_MODE_Msk = 0x7

	// CFGR1: configuration register 1
	// Position of FPU_IE field.
	SYSCFG_CFGR1_FPU_IE_Pos = 0x1a
	// Bit mask of FPU_IE field.
	SYSCFG_CFGR1_FPU_IE_Msk = 0xfc000000
	// Position of I2C3_FMP field.
	SYSCFG_CFGR1_I2C3_FMP_Pos = 0x16
	// Bit mask of I2C3_FMP field.
	SYSCFG_CFGR1_I2C3_FMP_Msk = 0x400000
	// Bit I2C3_FMP.
	SYSCFG_CFGR1_I2C3_FMP = 0x400000
	// Position of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP_Pos = 0x14
	// Bit mask of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP_Msk = 0x100000
	// Bit I2C1_FMP.
	SYSCFG_CFGR1_I2C1_FMP = 0x100000
	// Position of I2C_PB9_FMP field.
	SYSCFG_CFGR1_I2C_PB9_FMP_Pos = 0x13
	// Bit mask of I2C_PB9_FMP field.
	SYSCFG_CFGR1_I2C_PB9_FMP_Msk = 0x80000
	// Bit I2C_PB9_FMP.
	SYSCFG_CFGR1_I2C_PB9_FMP = 0x80000
	// Position of I2C_PB8_FMP field.
	SYSCFG_CFGR1_I2C_PB8_FMP_Pos = 0x12
	// Bit mask of I2C_PB8_FMP field.
	SYSCFG_CFGR1_I2C_PB8_FMP_Msk = 0x40000
	// Bit I2C_PB8_FMP.
	SYSCFG_CFGR1_I2C_PB8_FMP = 0x40000
	// Position of I2C_PB7_FMP field.
	SYSCFG_CFGR1_I2C_PB7_FMP_Pos = 0x11
	// Bit mask of I2C_PB7_FMP field.
	SYSCFG_CFGR1_I2C_PB7_FMP_Msk = 0x20000
	// Bit I2C_PB7_FMP.
	SYSCFG_CFGR1_I2C_PB7_FMP = 0x20000
	// Position of I2C_PB6_FMP field.
	SYSCFG_CFGR1_I2C_PB6_FMP_Pos = 0x10
	// Bit mask of I2C_PB6_FMP field.
	SYSCFG_CFGR1_I2C_PB6_FMP_Msk = 0x10000
	// Bit I2C_PB6_FMP.
	SYSCFG_CFGR1_I2C_PB6_FMP = 0x10000
	// Position of BOOSTEN field.
	SYSCFG_CFGR1_BOOSTEN_Pos = 0x8
	// Bit mask of BOOSTEN field.
	SYSCFG_CFGR1_BOOSTEN_Msk = 0x100
	// Bit BOOSTEN.
	SYSCFG_CFGR1_BOOSTEN = 0x100

	// EXTICR1: external interrupt configuration register 1
	// Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc
	// Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0x7000
	// Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8
	// Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0x700
	// Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4
	// Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0x70
	// Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0
	// Bit mask of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0x7

	// EXTICR2: external interrupt configuration register 2
	// Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc
	// Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0x7000
	// Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8
	// Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0x700
	// Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4
	// Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0x70
	// Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0
	// Bit mask of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0x7

	// EXTICR3: external interrupt configuration register 3
	// Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc
	// Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0x7000
	// Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8
	// Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0x700
	// Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Pos = 0x4
	// Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk = 0x70
	// Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Pos = 0x0
	// Bit mask of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk = 0x7

	// EXTICR4: external interrupt configuration register 4
	// Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc
	// Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0x7000
	// Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8
	// Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0x700
	// Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4
	// Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0x70
	// Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0
	// Bit mask of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0x7

	// SCSR: SCSR
	// Position of SRAM2BSY field.
	SYSCFG_SCSR_SRAM2BSY_Pos = 0x1
	// Bit mask of SRAM2BSY field.
	SYSCFG_SCSR_SRAM2BSY_Msk = 0x2
	// Bit SRAM2BSY.
	SYSCFG_SCSR_SRAM2BSY = 0x2
	// Position of SRAM2ER field.
	SYSCFG_SCSR_SRAM2ER_Pos = 0x0
	// Bit mask of SRAM2ER field.
	SYSCFG_SCSR_SRAM2ER_Msk = 0x1
	// Bit SRAM2ER.
	SYSCFG_SCSR_SRAM2ER = 0x1
	// Position of C2RFD field.
	SYSCFG_SCSR_C2RFD_Pos = 0x1f
	// Bit mask of C2RFD field.
	SYSCFG_SCSR_C2RFD_Msk = 0x80000000
	// Bit C2RFD.
	SYSCFG_SCSR_C2RFD = 0x80000000

	// CFGR2: CFGR2
	// Position of SPF field.
	SYSCFG_CFGR2_SPF_Pos = 0x8
	// Bit mask of SPF field.
	SYSCFG_CFGR2_SPF_Msk = 0x100
	// Bit SPF.
	SYSCFG_CFGR2_SPF = 0x100
	// Position of ECCL field.
	SYSCFG_CFGR2_ECCL_Pos = 0x3
	// Bit mask of ECCL field.
	SYSCFG_CFGR2_ECCL_Msk = 0x8
	// Bit ECCL.
	SYSCFG_CFGR2_ECCL = 0x8
	// Position of PVDL field.
	SYSCFG_CFGR2_PVDL_Pos = 0x2
	// Bit mask of PVDL field.
	SYSCFG_CFGR2_PVDL_Msk = 0x4
	// Bit PVDL.
	SYSCFG_CFGR2_PVDL = 0x4
	// Position of SPL field.
	SYSCFG_CFGR2_SPL_Pos = 0x1
	// Bit mask of SPL field.
	SYSCFG_CFGR2_SPL_Msk = 0x2
	// Bit SPL.
	SYSCFG_CFGR2_SPL = 0x2
	// Position of CLL field.
	SYSCFG_CFGR2_CLL_Pos = 0x0
	// Bit mask of CLL field.
	SYSCFG_CFGR2_CLL_Msk = 0x1
	// Bit CLL.
	SYSCFG_CFGR2_CLL = 0x1

	// SWPR: SRAM2 write protection register
	// Position of P31WP field.
	SYSCFG_SWPR_P31WP_Pos = 0x1f
	// Bit mask of P31WP field.
	SYSCFG_SWPR_P31WP_Msk = 0x80000000
	// Bit P31WP.
	SYSCFG_SWPR_P31WP = 0x80000000
	// Position of P30WP field.
	SYSCFG_SWPR_P30WP_Pos = 0x1e
	// Bit mask of P30WP field.
	SYSCFG_SWPR_P30WP_Msk = 0x40000000
	// Bit P30WP.
	SYSCFG_SWPR_P30WP = 0x40000000
	// Position of P29WP field.
	SYSCFG_SWPR_P29WP_Pos = 0x1d
	// Bit mask of P29WP field.
	SYSCFG_SWPR_P29WP_Msk = 0x20000000
	// Bit P29WP.
	SYSCFG_SWPR_P29WP = 0x20000000
	// Position of P28WP field.
	SYSCFG_SWPR_P28WP_Pos = 0x1c
	// Bit mask of P28WP field.
	SYSCFG_SWPR_P28WP_Msk = 0x10000000
	// Bit P28WP.
	SYSCFG_SWPR_P28WP = 0x10000000
	// Position of P27WP field.
	SYSCFG_SWPR_P27WP_Pos = 0x1b
	// Bit mask of P27WP field.
	SYSCFG_SWPR_P27WP_Msk = 0x8000000
	// Bit P27WP.
	SYSCFG_SWPR_P27WP = 0x8000000
	// Position of P26WP field.
	SYSCFG_SWPR_P26WP_Pos = 0x1a
	// Bit mask of P26WP field.
	SYSCFG_SWPR_P26WP_Msk = 0x4000000
	// Bit P26WP.
	SYSCFG_SWPR_P26WP = 0x4000000
	// Position of P25WP field.
	SYSCFG_SWPR_P25WP_Pos = 0x19
	// Bit mask of P25WP field.
	SYSCFG_SWPR_P25WP_Msk = 0x2000000
	// Bit P25WP.
	SYSCFG_SWPR_P25WP = 0x2000000
	// Position of P24WP field.
	SYSCFG_SWPR_P24WP_Pos = 0x18
	// Bit mask of P24WP field.
	SYSCFG_SWPR_P24WP_Msk = 0x1000000
	// Bit P24WP.
	SYSCFG_SWPR_P24WP = 0x1000000
	// Position of P23WP field.
	SYSCFG_SWPR_P23WP_Pos = 0x17
	// Bit mask of P23WP field.
	SYSCFG_SWPR_P23WP_Msk = 0x800000
	// Bit P23WP.
	SYSCFG_SWPR_P23WP = 0x800000
	// Position of P22WP field.
	SYSCFG_SWPR_P22WP_Pos = 0x16
	// Bit mask of P22WP field.
	SYSCFG_SWPR_P22WP_Msk = 0x400000
	// Bit P22WP.
	SYSCFG_SWPR_P22WP = 0x400000
	// Position of P21WP field.
	SYSCFG_SWPR_P21WP_Pos = 0x15
	// Bit mask of P21WP field.
	SYSCFG_SWPR_P21WP_Msk = 0x200000
	// Bit P21WP.
	SYSCFG_SWPR_P21WP = 0x200000
	// Position of P20WP field.
	SYSCFG_SWPR_P20WP_Pos = 0x14
	// Bit mask of P20WP field.
	SYSCFG_SWPR_P20WP_Msk = 0x100000
	// Bit P20WP.
	SYSCFG_SWPR_P20WP = 0x100000
	// Position of P19WP field.
	SYSCFG_SWPR_P19WP_Pos = 0x13
	// Bit mask of P19WP field.
	SYSCFG_SWPR_P19WP_Msk = 0x80000
	// Bit P19WP.
	SYSCFG_SWPR_P19WP = 0x80000
	// Position of P18WP field.
	SYSCFG_SWPR_P18WP_Pos = 0x12
	// Bit mask of P18WP field.
	SYSCFG_SWPR_P18WP_Msk = 0x40000
	// Bit P18WP.
	SYSCFG_SWPR_P18WP = 0x40000
	// Position of P17WP field.
	SYSCFG_SWPR_P17WP_Pos = 0x11
	// Bit mask of P17WP field.
	SYSCFG_SWPR_P17WP_Msk = 0x20000
	// Bit P17WP.
	SYSCFG_SWPR_P17WP = 0x20000
	// Position of P16WP field.
	SYSCFG_SWPR_P16WP_Pos = 0x10
	// Bit mask of P16WP field.
	SYSCFG_SWPR_P16WP_Msk = 0x10000
	// Bit P16WP.
	SYSCFG_SWPR_P16WP = 0x10000
	// Position of P15WP field.
	SYSCFG_SWPR_P15WP_Pos = 0xf
	// Bit mask of P15WP field.
	SYSCFG_SWPR_P15WP_Msk = 0x8000
	// Bit P15WP.
	SYSCFG_SWPR_P15WP = 0x8000
	// Position of P14WP field.
	SYSCFG_SWPR_P14WP_Pos = 0xe
	// Bit mask of P14WP field.
	SYSCFG_SWPR_P14WP_Msk = 0x4000
	// Bit P14WP.
	SYSCFG_SWPR_P14WP = 0x4000
	// Position of P13WP field.
	SYSCFG_SWPR_P13WP_Pos = 0xd
	// Bit mask of P13WP field.
	SYSCFG_SWPR_P13WP_Msk = 0x2000
	// Bit P13WP.
	SYSCFG_SWPR_P13WP = 0x2000
	// Position of P12WP field.
	SYSCFG_SWPR_P12WP_Pos = 0xc
	// Bit mask of P12WP field.
	SYSCFG_SWPR_P12WP_Msk = 0x1000
	// Bit P12WP.
	SYSCFG_SWPR_P12WP = 0x1000
	// Position of P11WP field.
	SYSCFG_SWPR_P11WP_Pos = 0xb
	// Bit mask of P11WP field.
	SYSCFG_SWPR_P11WP_Msk = 0x800
	// Bit P11WP.
	SYSCFG_SWPR_P11WP = 0x800
	// Position of P10WP field.
	SYSCFG_SWPR_P10WP_Pos = 0xa
	// Bit mask of P10WP field.
	SYSCFG_SWPR_P10WP_Msk = 0x400
	// Bit P10WP.
	SYSCFG_SWPR_P10WP = 0x400
	// Position of P9WP field.
	SYSCFG_SWPR_P9WP_Pos = 0x9
	// Bit mask of P9WP field.
	SYSCFG_SWPR_P9WP_Msk = 0x200
	// Bit P9WP.
	SYSCFG_SWPR_P9WP = 0x200
	// Position of P8WP field.
	SYSCFG_SWPR_P8WP_Pos = 0x8
	// Bit mask of P8WP field.
	SYSCFG_SWPR_P8WP_Msk = 0x100
	// Bit P8WP.
	SYSCFG_SWPR_P8WP = 0x100
	// Position of P7WP field.
	SYSCFG_SWPR_P7WP_Pos = 0x7
	// Bit mask of P7WP field.
	SYSCFG_SWPR_P7WP_Msk = 0x80
	// Bit P7WP.
	SYSCFG_SWPR_P7WP = 0x80
	// Position of P6WP field.
	SYSCFG_SWPR_P6WP_Pos = 0x6
	// Bit mask of P6WP field.
	SYSCFG_SWPR_P6WP_Msk = 0x40
	// Bit P6WP.
	SYSCFG_SWPR_P6WP = 0x40
	// Position of P5WP field.
	SYSCFG_SWPR_P5WP_Pos = 0x5
	// Bit mask of P5WP field.
	SYSCFG_SWPR_P5WP_Msk = 0x20
	// Bit P5WP.
	SYSCFG_SWPR_P5WP = 0x20
	// Position of P4WP field.
	SYSCFG_SWPR_P4WP_Pos = 0x4
	// Bit mask of P4WP field.
	SYSCFG_SWPR_P4WP_Msk = 0x10
	// Bit P4WP.
	SYSCFG_SWPR_P4WP = 0x10
	// Position of P3WP field.
	SYSCFG_SWPR_P3WP_Pos = 0x3
	// Bit mask of P3WP field.
	SYSCFG_SWPR_P3WP_Msk = 0x8
	// Bit P3WP.
	SYSCFG_SWPR_P3WP = 0x8
	// Position of P2WP field.
	SYSCFG_SWPR_P2WP_Pos = 0x2
	// Bit mask of P2WP field.
	SYSCFG_SWPR_P2WP_Msk = 0x4
	// Bit P2WP.
	SYSCFG_SWPR_P2WP = 0x4
	// Position of P1WP field.
	SYSCFG_SWPR_P1WP_Pos = 0x1
	// Bit mask of P1WP field.
	SYSCFG_SWPR_P1WP_Msk = 0x2
	// Bit P1WP.
	SYSCFG_SWPR_P1WP = 0x2
	// Position of P0WP field.
	SYSCFG_SWPR_P0WP_Pos = 0x0
	// Bit mask of P0WP field.
	SYSCFG_SWPR_P0WP_Msk = 0x1
	// Bit P0WP.
	SYSCFG_SWPR_P0WP = 0x1

	// SKR: SKR
	// Position of KEY field.
	SYSCFG_SKR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	SYSCFG_SKR_KEY_Msk = 0xff

	// SWPR2: SRAM2 write protection register 2
	// Position of P63WP field.
	SYSCFG_SWPR2_P63WP_Pos = 0x1f
	// Bit mask of P63WP field.
	SYSCFG_SWPR2_P63WP_Msk = 0x80000000
	// Bit P63WP.
	SYSCFG_SWPR2_P63WP = 0x80000000
	// Position of P62WP field.
	SYSCFG_SWPR2_P62WP_Pos = 0x1e
	// Bit mask of P62WP field.
	SYSCFG_SWPR2_P62WP_Msk = 0x40000000
	// Bit P62WP.
	SYSCFG_SWPR2_P62WP = 0x40000000
	// Position of P61WP field.
	SYSCFG_SWPR2_P61WP_Pos = 0x1d
	// Bit mask of P61WP field.
	SYSCFG_SWPR2_P61WP_Msk = 0x20000000
	// Bit P61WP.
	SYSCFG_SWPR2_P61WP = 0x20000000
	// Position of P60WP field.
	SYSCFG_SWPR2_P60WP_Pos = 0x1c
	// Bit mask of P60WP field.
	SYSCFG_SWPR2_P60WP_Msk = 0x10000000
	// Bit P60WP.
	SYSCFG_SWPR2_P60WP = 0x10000000
	// Position of P59WP field.
	SYSCFG_SWPR2_P59WP_Pos = 0x1b
	// Bit mask of P59WP field.
	SYSCFG_SWPR2_P59WP_Msk = 0x8000000
	// Bit P59WP.
	SYSCFG_SWPR2_P59WP = 0x8000000
	// Position of P58WP field.
	SYSCFG_SWPR2_P58WP_Pos = 0x1a
	// Bit mask of P58WP field.
	SYSCFG_SWPR2_P58WP_Msk = 0x4000000
	// Bit P58WP.
	SYSCFG_SWPR2_P58WP = 0x4000000
	// Position of P57WP field.
	SYSCFG_SWPR2_P57WP_Pos = 0x19
	// Bit mask of P57WP field.
	SYSCFG_SWPR2_P57WP_Msk = 0x2000000
	// Bit P57WP.
	SYSCFG_SWPR2_P57WP = 0x2000000
	// Position of P56WP field.
	SYSCFG_SWPR2_P56WP_Pos = 0x18
	// Bit mask of P56WP field.
	SYSCFG_SWPR2_P56WP_Msk = 0x1000000
	// Bit P56WP.
	SYSCFG_SWPR2_P56WP = 0x1000000
	// Position of P55WP field.
	SYSCFG_SWPR2_P55WP_Pos = 0x17
	// Bit mask of P55WP field.
	SYSCFG_SWPR2_P55WP_Msk = 0x800000
	// Bit P55WP.
	SYSCFG_SWPR2_P55WP = 0x800000
	// Position of P54WP field.
	SYSCFG_SWPR2_P54WP_Pos = 0x16
	// Bit mask of P54WP field.
	SYSCFG_SWPR2_P54WP_Msk = 0x400000
	// Bit P54WP.
	SYSCFG_SWPR2_P54WP = 0x400000
	// Position of P53WP field.
	SYSCFG_SWPR2_P53WP_Pos = 0x15
	// Bit mask of P53WP field.
	SYSCFG_SWPR2_P53WP_Msk = 0x200000
	// Bit P53WP.
	SYSCFG_SWPR2_P53WP = 0x200000
	// Position of P52WP field.
	SYSCFG_SWPR2_P52WP_Pos = 0x14
	// Bit mask of P52WP field.
	SYSCFG_SWPR2_P52WP_Msk = 0x100000
	// Bit P52WP.
	SYSCFG_SWPR2_P52WP = 0x100000
	// Position of P51WP field.
	SYSCFG_SWPR2_P51WP_Pos = 0x13
	// Bit mask of P51WP field.
	SYSCFG_SWPR2_P51WP_Msk = 0x80000
	// Bit P51WP.
	SYSCFG_SWPR2_P51WP = 0x80000
	// Position of P50WP field.
	SYSCFG_SWPR2_P50WP_Pos = 0x12
	// Bit mask of P50WP field.
	SYSCFG_SWPR2_P50WP_Msk = 0x40000
	// Bit P50WP.
	SYSCFG_SWPR2_P50WP = 0x40000
	// Position of P49WP field.
	SYSCFG_SWPR2_P49WP_Pos = 0x11
	// Bit mask of P49WP field.
	SYSCFG_SWPR2_P49WP_Msk = 0x20000
	// Bit P49WP.
	SYSCFG_SWPR2_P49WP = 0x20000
	// Position of P48WP field.
	SYSCFG_SWPR2_P48WP_Pos = 0x10
	// Bit mask of P48WP field.
	SYSCFG_SWPR2_P48WP_Msk = 0x10000
	// Bit P48WP.
	SYSCFG_SWPR2_P48WP = 0x10000
	// Position of P47WP field.
	SYSCFG_SWPR2_P47WP_Pos = 0xf
	// Bit mask of P47WP field.
	SYSCFG_SWPR2_P47WP_Msk = 0x8000
	// Bit P47WP.
	SYSCFG_SWPR2_P47WP = 0x8000
	// Position of P46WP field.
	SYSCFG_SWPR2_P46WP_Pos = 0xe
	// Bit mask of P46WP field.
	SYSCFG_SWPR2_P46WP_Msk = 0x4000
	// Bit P46WP.
	SYSCFG_SWPR2_P46WP = 0x4000
	// Position of P45WP field.
	SYSCFG_SWPR2_P45WP_Pos = 0xd
	// Bit mask of P45WP field.
	SYSCFG_SWPR2_P45WP_Msk = 0x2000
	// Bit P45WP.
	SYSCFG_SWPR2_P45WP = 0x2000
	// Position of P44WP field.
	SYSCFG_SWPR2_P44WP_Pos = 0xc
	// Bit mask of P44WP field.
	SYSCFG_SWPR2_P44WP_Msk = 0x1000
	// Bit P44WP.
	SYSCFG_SWPR2_P44WP = 0x1000
	// Position of P43WP field.
	SYSCFG_SWPR2_P43WP_Pos = 0xb
	// Bit mask of P43WP field.
	SYSCFG_SWPR2_P43WP_Msk = 0x800
	// Bit P43WP.
	SYSCFG_SWPR2_P43WP = 0x800
	// Position of P42WP field.
	SYSCFG_SWPR2_P42WP_Pos = 0xa
	// Bit mask of P42WP field.
	SYSCFG_SWPR2_P42WP_Msk = 0x400
	// Bit P42WP.
	SYSCFG_SWPR2_P42WP = 0x400
	// Position of P41WP field.
	SYSCFG_SWPR2_P41WP_Pos = 0x9
	// Bit mask of P41WP field.
	SYSCFG_SWPR2_P41WP_Msk = 0x200
	// Bit P41WP.
	SYSCFG_SWPR2_P41WP = 0x200
	// Position of P40WP field.
	SYSCFG_SWPR2_P40WP_Pos = 0x8
	// Bit mask of P40WP field.
	SYSCFG_SWPR2_P40WP_Msk = 0x100
	// Bit P40WP.
	SYSCFG_SWPR2_P40WP = 0x100
	// Position of P39WP field.
	SYSCFG_SWPR2_P39WP_Pos = 0x7
	// Bit mask of P39WP field.
	SYSCFG_SWPR2_P39WP_Msk = 0x80
	// Bit P39WP.
	SYSCFG_SWPR2_P39WP = 0x80
	// Position of P38WP field.
	SYSCFG_SWPR2_P38WP_Pos = 0x6
	// Bit mask of P38WP field.
	SYSCFG_SWPR2_P38WP_Msk = 0x40
	// Bit P38WP.
	SYSCFG_SWPR2_P38WP = 0x40
	// Position of P37WP field.
	SYSCFG_SWPR2_P37WP_Pos = 0x5
	// Bit mask of P37WP field.
	SYSCFG_SWPR2_P37WP_Msk = 0x20
	// Bit P37WP.
	SYSCFG_SWPR2_P37WP = 0x20
	// Position of P36WP field.
	SYSCFG_SWPR2_P36WP_Pos = 0x4
	// Bit mask of P36WP field.
	SYSCFG_SWPR2_P36WP_Msk = 0x10
	// Bit P36WP.
	SYSCFG_SWPR2_P36WP = 0x10
	// Position of P35WP field.
	SYSCFG_SWPR2_P35WP_Pos = 0x3
	// Bit mask of P35WP field.
	SYSCFG_SWPR2_P35WP_Msk = 0x8
	// Bit P35WP.
	SYSCFG_SWPR2_P35WP = 0x8
	// Position of P34WP field.
	SYSCFG_SWPR2_P34WP_Pos = 0x2
	// Bit mask of P34WP field.
	SYSCFG_SWPR2_P34WP_Msk = 0x4
	// Bit P34WP.
	SYSCFG_SWPR2_P34WP = 0x4
	// Position of P33WP field.
	SYSCFG_SWPR2_P33WP_Pos = 0x1
	// Bit mask of P33WP field.
	SYSCFG_SWPR2_P33WP_Msk = 0x2
	// Bit P33WP.
	SYSCFG_SWPR2_P33WP = 0x2
	// Position of P32WP field.
	SYSCFG_SWPR2_P32WP_Pos = 0x0
	// Bit mask of P32WP field.
	SYSCFG_SWPR2_P32WP_Msk = 0x1
	// Bit P32WP.
	SYSCFG_SWPR2_P32WP = 0x1

	// IMR1: CPU1 interrupt mask register 1
	// Position of TIM1IM field.
	SYSCFG_IMR1_TIM1IM_Pos = 0xd
	// Bit mask of TIM1IM field.
	SYSCFG_IMR1_TIM1IM_Msk = 0x2000
	// Bit TIM1IM.
	SYSCFG_IMR1_TIM1IM = 0x2000
	// Position of TIM16IM field.
	SYSCFG_IMR1_TIM16IM_Pos = 0xe
	// Bit mask of TIM16IM field.
	SYSCFG_IMR1_TIM16IM_Msk = 0x4000
	// Bit TIM16IM.
	SYSCFG_IMR1_TIM16IM = 0x4000
	// Position of TIM17IM field.
	SYSCFG_IMR1_TIM17IM_Pos = 0xf
	// Bit mask of TIM17IM field.
	SYSCFG_IMR1_TIM17IM_Msk = 0x8000
	// Bit TIM17IM.
	SYSCFG_IMR1_TIM17IM = 0x8000
	// Position of EXIT5IM field.
	SYSCFG_IMR1_EXIT5IM_Pos = 0x15
	// Bit mask of EXIT5IM field.
	SYSCFG_IMR1_EXIT5IM_Msk = 0x200000
	// Bit EXIT5IM.
	SYSCFG_IMR1_EXIT5IM = 0x200000
	// Position of EXIT6IM field.
	SYSCFG_IMR1_EXIT6IM_Pos = 0x16
	// Bit mask of EXIT6IM field.
	SYSCFG_IMR1_EXIT6IM_Msk = 0x400000
	// Bit EXIT6IM.
	SYSCFG_IMR1_EXIT6IM = 0x400000
	// Position of EXIT7IM field.
	SYSCFG_IMR1_EXIT7IM_Pos = 0x17
	// Bit mask of EXIT7IM field.
	SYSCFG_IMR1_EXIT7IM_Msk = 0x800000
	// Bit EXIT7IM.
	SYSCFG_IMR1_EXIT7IM = 0x800000
	// Position of EXIT8IM field.
	SYSCFG_IMR1_EXIT8IM_Pos = 0x18
	// Bit mask of EXIT8IM field.
	SYSCFG_IMR1_EXIT8IM_Msk = 0x1000000
	// Bit EXIT8IM.
	SYSCFG_IMR1_EXIT8IM = 0x1000000
	// Position of EXIT9IM field.
	SYSCFG_IMR1_EXIT9IM_Pos = 0x19
	// Bit mask of EXIT9IM field.
	SYSCFG_IMR1_EXIT9IM_Msk = 0x2000000
	// Bit EXIT9IM.
	SYSCFG_IMR1_EXIT9IM = 0x2000000
	// Position of EXIT10IM field.
	SYSCFG_IMR1_EXIT10IM_Pos = 0x1a
	// Bit mask of EXIT10IM field.
	SYSCFG_IMR1_EXIT10IM_Msk = 0x4000000
	// Bit EXIT10IM.
	SYSCFG_IMR1_EXIT10IM = 0x4000000
	// Position of EXIT11IM field.
	SYSCFG_IMR1_EXIT11IM_Pos = 0x1b
	// Bit mask of EXIT11IM field.
	SYSCFG_IMR1_EXIT11IM_Msk = 0x8000000
	// Bit EXIT11IM.
	SYSCFG_IMR1_EXIT11IM = 0x8000000
	// Position of EXIT12IM field.
	SYSCFG_IMR1_EXIT12IM_Pos = 0x1c
	// Bit mask of EXIT12IM field.
	SYSCFG_IMR1_EXIT12IM_Msk = 0x10000000
	// Bit EXIT12IM.
	SYSCFG_IMR1_EXIT12IM = 0x10000000
	// Position of EXIT13IM field.
	SYSCFG_IMR1_EXIT13IM_Pos = 0x1d
	// Bit mask of EXIT13IM field.
	SYSCFG_IMR1_EXIT13IM_Msk = 0x20000000
	// Bit EXIT13IM.
	SYSCFG_IMR1_EXIT13IM = 0x20000000
	// Position of EXIT14IM field.
	SYSCFG_IMR1_EXIT14IM_Pos = 0x1e
	// Bit mask of EXIT14IM field.
	SYSCFG_IMR1_EXIT14IM_Msk = 0x40000000
	// Bit EXIT14IM.
	SYSCFG_IMR1_EXIT14IM = 0x40000000
	// Position of EXIT15IM field.
	SYSCFG_IMR1_EXIT15IM_Pos = 0x1f
	// Bit mask of EXIT15IM field.
	SYSCFG_IMR1_EXIT15IM_Msk = 0x80000000
	// Bit EXIT15IM.
	SYSCFG_IMR1_EXIT15IM = 0x80000000

	// IMR2: CPU1 interrupt mask register 2
	// Position of PVM3IM field.
	SYSCFG_IMR2_PVM3IM_Pos = 0x12
	// Bit mask of PVM3IM field.
	SYSCFG_IMR2_PVM3IM_Msk = 0x40000
	// Bit PVM3IM.
	SYSCFG_IMR2_PVM3IM = 0x40000
	// Position of PVM1IM field.
	SYSCFG_IMR2_PVM1IM_Pos = 0x10
	// Bit mask of PVM1IM field.
	SYSCFG_IMR2_PVM1IM_Msk = 0x10000
	// Bit PVM1IM.
	SYSCFG_IMR2_PVM1IM = 0x10000
	// Position of PVDIM field.
	SYSCFG_IMR2_PVDIM_Pos = 0x14
	// Bit mask of PVDIM field.
	SYSCFG_IMR2_PVDIM_Msk = 0x100000
	// Bit PVDIM.
	SYSCFG_IMR2_PVDIM = 0x100000

	// C2IMR1: CPU2 interrupt mask register 1
	// Position of RTCSTAMP field.
	SYSCFG_C2IMR1_RTCSTAMP_Pos = 0x0
	// Bit mask of RTCSTAMP field.
	SYSCFG_C2IMR1_RTCSTAMP_Msk = 0x1
	// Bit RTCSTAMP.
	SYSCFG_C2IMR1_RTCSTAMP = 0x1
	// Position of RTCWKUP field.
	SYSCFG_C2IMR1_RTCWKUP_Pos = 0x3
	// Bit mask of RTCWKUP field.
	SYSCFG_C2IMR1_RTCWKUP_Msk = 0x8
	// Bit RTCWKUP.
	SYSCFG_C2IMR1_RTCWKUP = 0x8
	// Position of RTCALARM field.
	SYSCFG_C2IMR1_RTCALARM_Pos = 0x4
	// Bit mask of RTCALARM field.
	SYSCFG_C2IMR1_RTCALARM_Msk = 0x10
	// Bit RTCALARM.
	SYSCFG_C2IMR1_RTCALARM = 0x10
	// Position of RCC field.
	SYSCFG_C2IMR1_RCC_Pos = 0x5
	// Bit mask of RCC field.
	SYSCFG_C2IMR1_RCC_Msk = 0x20
	// Bit RCC.
	SYSCFG_C2IMR1_RCC = 0x20
	// Position of FLASH field.
	SYSCFG_C2IMR1_FLASH_Pos = 0x6
	// Bit mask of FLASH field.
	SYSCFG_C2IMR1_FLASH_Msk = 0x40
	// Bit FLASH.
	SYSCFG_C2IMR1_FLASH = 0x40
	// Position of PKA field.
	SYSCFG_C2IMR1_PKA_Pos = 0x8
	// Bit mask of PKA field.
	SYSCFG_C2IMR1_PKA_Msk = 0x100
	// Bit PKA.
	SYSCFG_C2IMR1_PKA = 0x100
	// Position of RNG field.
	SYSCFG_C2IMR1_RNG_Pos = 0x9
	// Bit mask of RNG field.
	SYSCFG_C2IMR1_RNG_Msk = 0x200
	// Bit RNG.
	SYSCFG_C2IMR1_RNG = 0x200
	// Position of AES1 field.
	SYSCFG_C2IMR1_AES1_Pos = 0xa
	// Bit mask of AES1 field.
	SYSCFG_C2IMR1_AES1_Msk = 0x400
	// Bit AES1.
	SYSCFG_C2IMR1_AES1 = 0x400
	// Position of COMP field.
	SYSCFG_C2IMR1_COMP_Pos = 0xb
	// Bit mask of COMP field.
	SYSCFG_C2IMR1_COMP_Msk = 0x800
	// Bit COMP.
	SYSCFG_C2IMR1_COMP = 0x800
	// Position of ADC field.
	SYSCFG_C2IMR1_ADC_Pos = 0xc
	// Bit mask of ADC field.
	SYSCFG_C2IMR1_ADC_Msk = 0x1000
	// Bit ADC.
	SYSCFG_C2IMR1_ADC = 0x1000

	// C2IMR2: CPU2 interrupt mask register 1
	// Position of DMA1_CH1_IM field.
	SYSCFG_C2IMR2_DMA1_CH1_IM_Pos = 0x0
	// Bit mask of DMA1_CH1_IM field.
	SYSCFG_C2IMR2_DMA1_CH1_IM_Msk = 0x1
	// Bit DMA1_CH1_IM.
	SYSCFG_C2IMR2_DMA1_CH1_IM = 0x1
	// Position of DMA1_CH2_IM field.
	SYSCFG_C2IMR2_DMA1_CH2_IM_Pos = 0x1
	// Bit mask of DMA1_CH2_IM field.
	SYSCFG_C2IMR2_DMA1_CH2_IM_Msk = 0x2
	// Bit DMA1_CH2_IM.
	SYSCFG_C2IMR2_DMA1_CH2_IM = 0x2
	// Position of DMA1_CH3_IM field.
	SYSCFG_C2IMR2_DMA1_CH3_IM_Pos = 0x2
	// Bit mask of DMA1_CH3_IM field.
	SYSCFG_C2IMR2_DMA1_CH3_IM_Msk = 0x4
	// Bit DMA1_CH3_IM.
	SYSCFG_C2IMR2_DMA1_CH3_IM = 0x4
	// Position of DMA1_CH4_IM field.
	SYSCFG_C2IMR2_DMA1_CH4_IM_Pos = 0x3
	// Bit mask of DMA1_CH4_IM field.
	SYSCFG_C2IMR2_DMA1_CH4_IM_Msk = 0x8
	// Bit DMA1_CH4_IM.
	SYSCFG_C2IMR2_DMA1_CH4_IM = 0x8
	// Position of DMA1_CH5_IM field.
	SYSCFG_C2IMR2_DMA1_CH5_IM_Pos = 0x4
	// Bit mask of DMA1_CH5_IM field.
	SYSCFG_C2IMR2_DMA1_CH5_IM_Msk = 0x10
	// Bit DMA1_CH5_IM.
	SYSCFG_C2IMR2_DMA1_CH5_IM = 0x10
	// Position of DMA1_CH6_IM field.
	SYSCFG_C2IMR2_DMA1_CH6_IM_Pos = 0x5
	// Bit mask of DMA1_CH6_IM field.
	SYSCFG_C2IMR2_DMA1_CH6_IM_Msk = 0x20
	// Bit DMA1_CH6_IM.
	SYSCFG_C2IMR2_DMA1_CH6_IM = 0x20
	// Position of DMA1_CH7_IM field.
	SYSCFG_C2IMR2_DMA1_CH7_IM_Pos = 0x6
	// Bit mask of DMA1_CH7_IM field.
	SYSCFG_C2IMR2_DMA1_CH7_IM_Msk = 0x40
	// Bit DMA1_CH7_IM.
	SYSCFG_C2IMR2_DMA1_CH7_IM = 0x40
	// Position of DMA2_CH1_IM field.
	SYSCFG_C2IMR2_DMA2_CH1_IM_Pos = 0x8
	// Bit mask of DMA2_CH1_IM field.
	SYSCFG_C2IMR2_DMA2_CH1_IM_Msk = 0x100
	// Bit DMA2_CH1_IM.
	SYSCFG_C2IMR2_DMA2_CH1_IM = 0x100
	// Position of DMA2_CH2_IM field.
	SYSCFG_C2IMR2_DMA2_CH2_IM_Pos = 0x9
	// Bit mask of DMA2_CH2_IM field.
	SYSCFG_C2IMR2_DMA2_CH2_IM_Msk = 0x200
	// Bit DMA2_CH2_IM.
	SYSCFG_C2IMR2_DMA2_CH2_IM = 0x200
	// Position of DMA2_CH3_IM field.
	SYSCFG_C2IMR2_DMA2_CH3_IM_Pos = 0xa
	// Bit mask of DMA2_CH3_IM field.
	SYSCFG_C2IMR2_DMA2_CH3_IM_Msk = 0x400
	// Bit DMA2_CH3_IM.
	SYSCFG_C2IMR2_DMA2_CH3_IM = 0x400
	// Position of DMA2_CH4_IM field.
	SYSCFG_C2IMR2_DMA2_CH4_IM_Pos = 0xb
	// Bit mask of DMA2_CH4_IM field.
	SYSCFG_C2IMR2_DMA2_CH4_IM_Msk = 0x800
	// Bit DMA2_CH4_IM.
	SYSCFG_C2IMR2_DMA2_CH4_IM = 0x800
	// Position of DMA2_CH5_IM field.
	SYSCFG_C2IMR2_DMA2_CH5_IM_Pos = 0xc
	// Bit mask of DMA2_CH5_IM field.
	SYSCFG_C2IMR2_DMA2_CH5_IM_Msk = 0x1000
	// Bit DMA2_CH5_IM.
	SYSCFG_C2IMR2_DMA2_CH5_IM = 0x1000
	// Position of DMA2_CH6_IM field.
	SYSCFG_C2IMR2_DMA2_CH6_IM_Pos = 0xd
	// Bit mask of DMA2_CH6_IM field.
	SYSCFG_C2IMR2_DMA2_CH6_IM_Msk = 0x2000
	// Bit DMA2_CH6_IM.
	SYSCFG_C2IMR2_DMA2_CH6_IM = 0x2000
	// Position of DMA2_CH7_IM field.
	SYSCFG_C2IMR2_DMA2_CH7_IM_Pos = 0xe
	// Bit mask of DMA2_CH7_IM field.
	SYSCFG_C2IMR2_DMA2_CH7_IM_Msk = 0x4000
	// Bit DMA2_CH7_IM.
	SYSCFG_C2IMR2_DMA2_CH7_IM = 0x4000
	// Position of DMAM_UX1_IM field.
	SYSCFG_C2IMR2_DMAM_UX1_IM_Pos = 0xf
	// Bit mask of DMAM_UX1_IM field.
	SYSCFG_C2IMR2_DMAM_UX1_IM_Msk = 0x8000
	// Bit DMAM_UX1_IM.
	SYSCFG_C2IMR2_DMAM_UX1_IM = 0x8000
	// Position of PVM1IM field.
	SYSCFG_C2IMR2_PVM1IM_Pos = 0x10
	// Bit mask of PVM1IM field.
	SYSCFG_C2IMR2_PVM1IM_Msk = 0x10000
	// Bit PVM1IM.
	SYSCFG_C2IMR2_PVM1IM = 0x10000
	// Position of PVM3IM field.
	SYSCFG_C2IMR2_PVM3IM_Pos = 0x12
	// Bit mask of PVM3IM field.
	SYSCFG_C2IMR2_PVM3IM_Msk = 0x40000
	// Bit PVM3IM.
	SYSCFG_C2IMR2_PVM3IM = 0x40000
	// Position of PVDIM field.
	SYSCFG_C2IMR2_PVDIM_Pos = 0x14
	// Bit mask of PVDIM field.
	SYSCFG_C2IMR2_PVDIM_Msk = 0x100000
	// Bit PVDIM.
	SYSCFG_C2IMR2_PVDIM = 0x100000
	// Position of TSCIM field.
	SYSCFG_C2IMR2_TSCIM_Pos = 0x15
	// Bit mask of TSCIM field.
	SYSCFG_C2IMR2_TSCIM_Msk = 0x200000
	// Bit TSCIM.
	SYSCFG_C2IMR2_TSCIM = 0x200000
	// Position of LCDIM field.
	SYSCFG_C2IMR2_LCDIM_Pos = 0x16
	// Bit mask of LCDIM field.
	SYSCFG_C2IMR2_LCDIM_Msk = 0x400000
	// Bit LCDIM.
	SYSCFG_C2IMR2_LCDIM = 0x400000

	// SIPCR: secure IP control register
	// Position of SAES1 field.
	SYSCFG_SIPCR_SAES1_Pos = 0x0
	// Bit mask of SAES1 field.
	SYSCFG_SIPCR_SAES1_Msk = 0x1
	// Bit SAES1.
	SYSCFG_SIPCR_SAES1 = 0x1
	// Position of SAES2 field.
	SYSCFG_SIPCR_SAES2_Pos = 0x1
	// Bit mask of SAES2 field.
	SYSCFG_SIPCR_SAES2_Msk = 0x2
	// Bit SAES2.
	SYSCFG_SIPCR_SAES2 = 0x2
	// Position of SPKA field.
	SYSCFG_SIPCR_SPKA_Pos = 0x2
	// Bit mask of SPKA field.
	SYSCFG_SIPCR_SPKA_Msk = 0x4
	// Bit SPKA.
	SYSCFG_SIPCR_SPKA = 0x4
	// Position of SRNG field.
	SYSCFG_SIPCR_SRNG_Pos = 0x3
	// Bit mask of SRNG field.
	SYSCFG_SIPCR_SRNG_Msk = 0x8
	// Bit SRNG.
	SYSCFG_SIPCR_SRNG = 0x8
)

// Bitfields for RNG: Random number generator
const (
	// CR: control register
	// Position of RNGEN field.
	RNG_CR_RNGEN_Pos = 0x2
	// Bit mask of RNGEN field.
	RNG_CR_RNGEN_Msk = 0x4
	// Bit RNGEN.
	RNG_CR_RNGEN = 0x4
	// Position of IE field.
	RNG_CR_IE_Pos = 0x3
	// Bit mask of IE field.
	RNG_CR_IE_Msk = 0x8
	// Bit IE.
	RNG_CR_IE = 0x8
	// Position of BYP field.
	RNG_CR_BYP_Pos = 0x6
	// Bit mask of BYP field.
	RNG_CR_BYP_Msk = 0x40
	// Bit BYP.
	RNG_CR_BYP = 0x40

	// SR: status register
	// Position of SEIS field.
	RNG_SR_SEIS_Pos = 0x6
	// Bit mask of SEIS field.
	RNG_SR_SEIS_Msk = 0x40
	// Bit SEIS.
	RNG_SR_SEIS = 0x40
	// Position of CEIS field.
	RNG_SR_CEIS_Pos = 0x5
	// Bit mask of CEIS field.
	RNG_SR_CEIS_Msk = 0x20
	// Bit CEIS.
	RNG_SR_CEIS = 0x20
	// Position of SECS field.
	RNG_SR_SECS_Pos = 0x2
	// Bit mask of SECS field.
	RNG_SR_SECS_Msk = 0x4
	// Bit SECS.
	RNG_SR_SECS = 0x4
	// Position of CECS field.
	RNG_SR_CECS_Pos = 0x1
	// Bit mask of CECS field.
	RNG_SR_CECS_Msk = 0x2
	// Bit CECS.
	RNG_SR_CECS = 0x2
	// Position of DRDY field.
	RNG_SR_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	RNG_SR_DRDY_Msk = 0x1
	// Bit DRDY.
	RNG_SR_DRDY = 0x1

	// DR: data register
	// Position of RNDATA field.
	RNG_DR_RNDATA_Pos = 0x0
	// Bit mask of RNDATA field.
	RNG_DR_RNDATA_Msk = 0xffffffff
)

// Bitfields for AES1: Advanced encryption standard hardware accelerator 1
const (
	// CR: control register
	// Position of NPBLB field.
	AES1_CR_NPBLB_Pos = 0x14
	// Bit mask of NPBLB field.
	AES1_CR_NPBLB_Msk = 0xf00000
	// Position of KEYSIZE field.
	AES1_CR_KEYSIZE_Pos = 0x12
	// Bit mask of KEYSIZE field.
	AES1_CR_KEYSIZE_Msk = 0x40000
	// Bit KEYSIZE.
	AES1_CR_KEYSIZE = 0x40000
	// Position of CHMOD2 field.
	AES1_CR_CHMOD2_Pos = 0x10
	// Bit mask of CHMOD2 field.
	AES1_CR_CHMOD2_Msk = 0x10000
	// Bit CHMOD2.
	AES1_CR_CHMOD2 = 0x10000
	// Position of GCMPH field.
	AES1_CR_GCMPH_Pos = 0xd
	// Bit mask of GCMPH field.
	AES1_CR_GCMPH_Msk = 0x6000
	// Position of DMAOUTEN field.
	AES1_CR_DMAOUTEN_Pos = 0xc
	// Bit mask of DMAOUTEN field.
	AES1_CR_DMAOUTEN_Msk = 0x1000
	// Bit DMAOUTEN.
	AES1_CR_DMAOUTEN = 0x1000
	// Position of DMAINEN field.
	AES1_CR_DMAINEN_Pos = 0xb
	// Bit mask of DMAINEN field.
	AES1_CR_DMAINEN_Msk = 0x800
	// Bit DMAINEN.
	AES1_CR_DMAINEN = 0x800
	// Position of ERRIE field.
	AES1_CR_ERRIE_Pos = 0xa
	// Bit mask of ERRIE field.
	AES1_CR_ERRIE_Msk = 0x400
	// Bit ERRIE.
	AES1_CR_ERRIE = 0x400
	// Position of CCFIE field.
	AES1_CR_CCFIE_Pos = 0x9
	// Bit mask of CCFIE field.
	AES1_CR_CCFIE_Msk = 0x200
	// Bit CCFIE.
	AES1_CR_CCFIE = 0x200
	// Position of ERRC field.
	AES1_CR_ERRC_Pos = 0x8
	// Bit mask of ERRC field.
	AES1_CR_ERRC_Msk = 0x100
	// Bit ERRC.
	AES1_CR_ERRC = 0x100
	// Position of CCFC field.
	AES1_CR_CCFC_Pos = 0x7
	// Bit mask of CCFC field.
	AES1_CR_CCFC_Msk = 0x80
	// Bit CCFC.
	AES1_CR_CCFC = 0x80
	// Position of CHMOD10 field.
	AES1_CR_CHMOD10_Pos = 0x5
	// Bit mask of CHMOD10 field.
	AES1_CR_CHMOD10_Msk = 0x60
	// Position of MODE field.
	AES1_CR_MODE_Pos = 0x3
	// Bit mask of MODE field.
	AES1_CR_MODE_Msk = 0x18
	// Position of DATATYPE field.
	AES1_CR_DATATYPE_Pos = 0x1
	// Bit mask of DATATYPE field.
	AES1_CR_DATATYPE_Msk = 0x6
	// Position of EN field.
	AES1_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	AES1_CR_EN_Msk = 0x1
	// Bit EN.
	AES1_CR_EN = 0x1

	// SR: status register
	// Position of BUSY field.
	AES1_SR_BUSY_Pos = 0x3
	// Bit mask of BUSY field.
	AES1_SR_BUSY_Msk = 0x8
	// Bit BUSY.
	AES1_SR_BUSY = 0x8
	// Position of WRERR field.
	AES1_SR_WRERR_Pos = 0x2
	// Bit mask of WRERR field.
	AES1_SR_WRERR_Msk = 0x4
	// Bit WRERR.
	AES1_SR_WRERR = 0x4
	// Position of RDERR field.
	AES1_SR_RDERR_Pos = 0x1
	// Bit mask of RDERR field.
	AES1_SR_RDERR_Msk = 0x2
	// Bit RDERR.
	AES1_SR_RDERR = 0x2
	// Position of CCF field.
	AES1_SR_CCF_Pos = 0x0
	// Bit mask of CCF field.
	AES1_SR_CCF_Msk = 0x1
	// Bit CCF.
	AES1_SR_CCF = 0x1

	// DINR: data input register
	// Position of AES_DINR field.
	AES1_DINR_AES_DINR_Pos = 0x0
	// Bit mask of AES_DINR field.
	AES1_DINR_AES_DINR_Msk = 0xffffffff

	// DOUTR: data output register
	// Position of AES_DOUTR field.
	AES1_DOUTR_AES_DOUTR_Pos = 0x0
	// Bit mask of AES_DOUTR field.
	AES1_DOUTR_AES_DOUTR_Msk = 0xffffffff

	// KEYR0: key register 0
	// Position of AES_KEYR0 field.
	AES1_KEYR0_AES_KEYR0_Pos = 0x0
	// Bit mask of AES_KEYR0 field.
	AES1_KEYR0_AES_KEYR0_Msk = 0xffffffff

	// KEYR1: key register 1
	// Position of AES_KEYR1 field.
	AES1_KEYR1_AES_KEYR1_Pos = 0x0
	// Bit mask of AES_KEYR1 field.
	AES1_KEYR1_AES_KEYR1_Msk = 0xffffffff

	// KEYR2: key register 2
	// Position of AES_KEYR2 field.
	AES1_KEYR2_AES_KEYR2_Pos = 0x0
	// Bit mask of AES_KEYR2 field.
	AES1_KEYR2_AES_KEYR2_Msk = 0xffffffff

	// KEYR3: key register 3
	// Position of AES_KEYR3 field.
	AES1_KEYR3_AES_KEYR3_Pos = 0x0
	// Bit mask of AES_KEYR3 field.
	AES1_KEYR3_AES_KEYR3_Msk = 0xffffffff

	// IVR0: initialization vector register 0
	// Position of AES_IVR0 field.
	AES1_IVR0_AES_IVR0_Pos = 0x0
	// Bit mask of AES_IVR0 field.
	AES1_IVR0_AES_IVR0_Msk = 0xffffffff

	// IVR1: initialization vector register 1
	// Position of AES_IVR1 field.
	AES1_IVR1_AES_IVR1_Pos = 0x0
	// Bit mask of AES_IVR1 field.
	AES1_IVR1_AES_IVR1_Msk = 0xffffffff

	// IVR2: initialization vector register 2
	// Position of AES_IVR2 field.
	AES1_IVR2_AES_IVR2_Pos = 0x0
	// Bit mask of AES_IVR2 field.
	AES1_IVR2_AES_IVR2_Msk = 0xffffffff

	// IVR3: initialization vector register 3
	// Position of AES_IVR3 field.
	AES1_IVR3_AES_IVR3_Pos = 0x0
	// Bit mask of AES_IVR3 field.
	AES1_IVR3_AES_IVR3_Msk = 0xffffffff

	// KEYR4: key register 4
	// Position of AES_KEYR4 field.
	AES1_KEYR4_AES_KEYR4_Pos = 0x0
	// Bit mask of AES_KEYR4 field.
	AES1_KEYR4_AES_KEYR4_Msk = 0xffffffff

	// KEYR5: key register 5
	// Position of AES_KEYR5 field.
	AES1_KEYR5_AES_KEYR5_Pos = 0x0
	// Bit mask of AES_KEYR5 field.
	AES1_KEYR5_AES_KEYR5_Msk = 0xffffffff

	// KEYR6: key register 6
	// Position of AES_KEYR6 field.
	AES1_KEYR6_AES_KEYR6_Pos = 0x0
	// Bit mask of AES_KEYR6 field.
	AES1_KEYR6_AES_KEYR6_Msk = 0xffffffff

	// KEYR7: key register 7
	// Position of AES_KEYR7 field.
	AES1_KEYR7_AES_KEYR7_Pos = 0x0
	// Bit mask of AES_KEYR7 field.
	AES1_KEYR7_AES_KEYR7_Msk = 0xffffffff

	// SUSP0R: AES suspend register 0
	// Position of AES_SUSP0R field.
	AES1_SUSP0R_AES_SUSP0R_Pos = 0x0
	// Bit mask of AES_SUSP0R field.
	AES1_SUSP0R_AES_SUSP0R_Msk = 0xffffffff

	// SUSP1R: AES suspend register 1
	// Position of AES_SUSP1R field.
	AES1_SUSP1R_AES_SUSP1R_Pos = 0x0
	// Bit mask of AES_SUSP1R field.
	AES1_SUSP1R_AES_SUSP1R_Msk = 0xffffffff

	// SUSP2R: AES suspend register 2
	// Position of AES_SUSP2R field.
	AES1_SUSP2R_AES_SUSP2R_Pos = 0x0
	// Bit mask of AES_SUSP2R field.
	AES1_SUSP2R_AES_SUSP2R_Msk = 0xffffffff

	// SUSP3R: AES suspend register 3
	// Position of AES_SUSP3R field.
	AES1_SUSP3R_AES_SUSP3R_Pos = 0x0
	// Bit mask of AES_SUSP3R field.
	AES1_SUSP3R_AES_SUSP3R_Msk = 0xffffffff

	// SUSP4R: AES suspend register 4
	// Position of AES_SUSP4R field.
	AES1_SUSP4R_AES_SUSP4R_Pos = 0x0
	// Bit mask of AES_SUSP4R field.
	AES1_SUSP4R_AES_SUSP4R_Msk = 0xffffffff

	// SUSP5R: AES suspend register 5
	// Position of AES_SUSP5R field.
	AES1_SUSP5R_AES_SUSP5R_Pos = 0x0
	// Bit mask of AES_SUSP5R field.
	AES1_SUSP5R_AES_SUSP5R_Msk = 0xffffffff

	// SUSP6R: AES suspend register 6
	// Position of AES_SUSP6R field.
	AES1_SUSP6R_AES_SUSP6R_Pos = 0x0
	// Bit mask of AES_SUSP6R field.
	AES1_SUSP6R_AES_SUSP6R_Msk = 0xffffffff

	// SUSP7R: AES suspend register 7
	// Position of AES_SUSP7R field.
	AES1_SUSP7R_AES_SUSP7R_Pos = 0x0
	// Bit mask of AES_SUSP7R field.
	AES1_SUSP7R_AES_SUSP7R_Msk = 0xffffffff

	// HWCFR: AES hardware configuration register
	// Position of CFG4 field.
	AES1_HWCFR_CFG4_Pos = 0xc
	// Bit mask of CFG4 field.
	AES1_HWCFR_CFG4_Msk = 0xf000
	// Position of CFG3 field.
	AES1_HWCFR_CFG3_Pos = 0x8
	// Bit mask of CFG3 field.
	AES1_HWCFR_CFG3_Msk = 0xf00
	// Position of CFG2 field.
	AES1_HWCFR_CFG2_Pos = 0x4
	// Bit mask of CFG2 field.
	AES1_HWCFR_CFG2_Msk = 0xf0
	// Position of CFG1 field.
	AES1_HWCFR_CFG1_Pos = 0x0
	// Bit mask of CFG1 field.
	AES1_HWCFR_CFG1_Msk = 0xf

	// VERR: AES version register
	// Position of MAJREV field.
	AES1_VERR_MAJREV_Pos = 0x4
	// Bit mask of MAJREV field.
	AES1_VERR_MAJREV_Msk = 0xf0
	// Position of MINREV field.
	AES1_VERR_MINREV_Pos = 0x0
	// Bit mask of MINREV field.
	AES1_VERR_MINREV_Msk = 0xf

	// IPIDR: AES identification register
	// Position of ID field.
	AES1_IPIDR_ID_Pos = 0x0
	// Bit mask of ID field.
	AES1_IPIDR_ID_Msk = 0xffffffff

	// SIDR: AES size ID register
	// Position of ID field.
	AES1_SIDR_ID_Pos = 0x0
	// Bit mask of ID field.
	AES1_SIDR_ID_Msk = 0xffffffff
)

// Bitfields for HSEM: HSEM
const (
	// R0: Semaphore 0 register
	// Position of LOCK field.
	Hardware_Semaphore_R0_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R0_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R0_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R0_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R0_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R0_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R0_PROCID_Msk = 0xff

	// R1: Semaphore 1 register
	// Position of LOCK field.
	Hardware_Semaphore_R1_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R1_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R1_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R1_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R1_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R1_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R1_PROCID_Msk = 0xff

	// R2: Semaphore 2 register
	// Position of LOCK field.
	Hardware_Semaphore_R2_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R2_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R2_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R2_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R2_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R2_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R2_PROCID_Msk = 0xff

	// R3: Semaphore 3 register
	// Position of LOCK field.
	Hardware_Semaphore_R3_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R3_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R3_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R3_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R3_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R3_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R3_PROCID_Msk = 0xff

	// R4: Semaphore 4 register
	// Position of LOCK field.
	Hardware_Semaphore_R4_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R4_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R4_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R4_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R4_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R4_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R4_PROCID_Msk = 0xff

	// R5: Semaphore 5 register
	// Position of LOCK field.
	Hardware_Semaphore_R5_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R5_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R5_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R5_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R5_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R5_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R5_PROCID_Msk = 0xff

	// R6: Semaphore 6 register
	// Position of LOCK field.
	Hardware_Semaphore_R6_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R6_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R6_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R6_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R6_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R6_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R6_PROCID_Msk = 0xff

	// R7: Semaphore 7 register
	// Position of LOCK field.
	Hardware_Semaphore_R7_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R7_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R7_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R7_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R7_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R7_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R7_PROCID_Msk = 0xff

	// R8: Semaphore 8 register
	// Position of LOCK field.
	Hardware_Semaphore_R8_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R8_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R8_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R8_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R8_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R8_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R8_PROCID_Msk = 0xff

	// R9: Semaphore 9 register
	// Position of LOCK field.
	Hardware_Semaphore_R9_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R9_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R9_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R9_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R9_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R9_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R9_PROCID_Msk = 0xff

	// R10: Semaphore 10 register
	// Position of LOCK field.
	Hardware_Semaphore_R10_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R10_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R10_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R10_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R10_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R10_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R10_PROCID_Msk = 0xff

	// R11: Semaphore 11 register
	// Position of LOCK field.
	Hardware_Semaphore_R11_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R11_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R11_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R11_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R11_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R11_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R11_PROCID_Msk = 0xff

	// R12: Semaphore 12 register
	// Position of LOCK field.
	Hardware_Semaphore_R12_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R12_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R12_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R12_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R12_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R12_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R12_PROCID_Msk = 0xff

	// R13: Semaphore 13 register
	// Position of LOCK field.
	Hardware_Semaphore_R13_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R13_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R13_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R13_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R13_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R13_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R13_PROCID_Msk = 0xff

	// R14: Semaphore 14 register
	// Position of LOCK field.
	Hardware_Semaphore_R14_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R14_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R14_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R14_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R14_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R14_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R14_PROCID_Msk = 0xff

	// R15: Semaphore 15 register
	// Position of LOCK field.
	Hardware_Semaphore_R15_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R15_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R15_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R15_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R15_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R15_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R15_PROCID_Msk = 0xff

	// R16: Semaphore 16 register
	// Position of LOCK field.
	Hardware_Semaphore_R16_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R16_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R16_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R16_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R16_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R16_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R16_PROCID_Msk = 0xff

	// R17: Semaphore 17 register
	// Position of LOCK field.
	Hardware_Semaphore_R17_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R17_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R17_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R17_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R17_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R17_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R17_PROCID_Msk = 0xff

	// R18: Semaphore 18 register
	// Position of LOCK field.
	Hardware_Semaphore_R18_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R18_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R18_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R18_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R18_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R18_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R18_PROCID_Msk = 0xff

	// R19: Semaphore 19 register
	// Position of LOCK field.
	Hardware_Semaphore_R19_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R19_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R19_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R19_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R19_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R19_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R19_PROCID_Msk = 0xff

	// R20: Semaphore 20 register
	// Position of LOCK field.
	Hardware_Semaphore_R20_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R20_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R20_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R20_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R20_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R20_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R20_PROCID_Msk = 0xff

	// R21: Semaphore 21 register
	// Position of LOCK field.
	Hardware_Semaphore_R21_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R21_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R21_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R21_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R21_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R21_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R21_PROCID_Msk = 0xff

	// R22: Semaphore 22 register
	// Position of LOCK field.
	Hardware_Semaphore_R22_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R22_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R22_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R22_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R22_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R22_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R22_PROCID_Msk = 0xff

	// R23: Semaphore 23 register
	// Position of LOCK field.
	Hardware_Semaphore_R23_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R23_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R23_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R23_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R23_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R23_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R23_PROCID_Msk = 0xff

	// R24: Semaphore 24 register
	// Position of LOCK field.
	Hardware_Semaphore_R24_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R24_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R24_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R24_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R24_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R24_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R24_PROCID_Msk = 0xff

	// R25: Semaphore 25 register
	// Position of LOCK field.
	Hardware_Semaphore_R25_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R25_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R25_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R25_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R25_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R25_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R25_PROCID_Msk = 0xff

	// R26: Semaphore 26 register
	// Position of LOCK field.
	Hardware_Semaphore_R26_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R26_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R26_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R26_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R26_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R26_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R26_PROCID_Msk = 0xff

	// R27: Semaphore 27 register
	// Position of LOCK field.
	Hardware_Semaphore_R27_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R27_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R27_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R27_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R27_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R27_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R27_PROCID_Msk = 0xff

	// R28: Semaphore 28 register
	// Position of LOCK field.
	Hardware_Semaphore_R28_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R28_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R28_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R28_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R28_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R28_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R28_PROCID_Msk = 0xff

	// R29: Semaphore 29 register
	// Position of LOCK field.
	Hardware_Semaphore_R29_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R29_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R29_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R29_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R29_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R29_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R29_PROCID_Msk = 0xff

	// R30: Semaphore 30 register
	// Position of LOCK field.
	Hardware_Semaphore_R30_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R30_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R30_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R30_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R30_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R30_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R30_PROCID_Msk = 0xff

	// R31: Semaphore 31 register
	// Position of LOCK field.
	Hardware_Semaphore_R31_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_R31_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_R31_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_R31_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_R31_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_R31_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_R31_PROCID_Msk = 0xff

	// RLR0: Semaphore 0 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR0_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR0_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR0_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR0_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR0_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR0_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR0_PROCID_Msk = 0xff

	// RLR1: Semaphore 1 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR1_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR1_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR1_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR1_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR1_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR1_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR1_PROCID_Msk = 0xff

	// RLR2: Semaphore 2 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR2_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR2_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR2_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR2_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR2_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR2_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR2_PROCID_Msk = 0xff

	// RLR3: Semaphore 3 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR3_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR3_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR3_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR3_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR3_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR3_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR3_PROCID_Msk = 0xff

	// RLR4: Semaphore 4 read lock read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR4_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR4_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR4_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR4_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR4_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR4_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR4_PROCID_Msk = 0xff

	// RLR5: Semaphore 5 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR5_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR5_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR5_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR5_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR5_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR5_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR5_PROCID_Msk = 0xff

	// RLR6: Semaphore 6 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR6_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR6_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR6_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR6_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR6_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR6_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR6_PROCID_Msk = 0xff

	// RLR7: Semaphore 7 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR7_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR7_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR7_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR7_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR7_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR7_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR7_PROCID_Msk = 0xff

	// RLR8: Semaphore 8 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR8_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR8_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR8_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR8_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR8_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR8_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR8_PROCID_Msk = 0xff

	// RLR9: Semaphore 9 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR9_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR9_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR9_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR9_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR9_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR9_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR9_PROCID_Msk = 0xff

	// RLR10: Semaphore 10 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR10_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR10_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR10_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR10_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR10_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR10_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR10_PROCID_Msk = 0xff

	// RLR11: Semaphore 11 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR11_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR11_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR11_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR11_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR11_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR11_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR11_PROCID_Msk = 0xff

	// RLR12: Semaphore 12 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR12_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR12_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR12_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR12_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR12_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR12_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR12_PROCID_Msk = 0xff

	// RLR13: Semaphore 13 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR13_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR13_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR13_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR13_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR13_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR13_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR13_PROCID_Msk = 0xff

	// RLR14: Semaphore 14 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR14_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR14_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR14_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR14_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR14_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR14_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR14_PROCID_Msk = 0xff

	// RLR15: Semaphore 15 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR15_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR15_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR15_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR15_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR15_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR15_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR15_PROCID_Msk = 0xff

	// RLR16: Semaphore 16 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR16_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR16_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR16_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR16_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR16_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR16_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR16_PROCID_Msk = 0xff

	// RLR17: Semaphore 17 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR17_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR17_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR17_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR17_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR17_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR17_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR17_PROCID_Msk = 0xff

	// RLR18: Semaphore 18 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR18_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR18_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR18_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR18_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR18_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR18_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR18_PROCID_Msk = 0xff

	// RLR19: Semaphore 19 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR19_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR19_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR19_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR19_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR19_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR19_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR19_PROCID_Msk = 0xff

	// RLR20: Semaphore 20 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR20_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR20_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR20_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR20_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR20_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR20_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR20_PROCID_Msk = 0xff

	// RLR21: Semaphore 21 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR21_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR21_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR21_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR21_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR21_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR21_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR21_PROCID_Msk = 0xff

	// RLR22: Semaphore 22 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR22_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR22_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR22_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR22_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR22_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR22_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR22_PROCID_Msk = 0xff

	// RLR23: Semaphore 23 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR23_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR23_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR23_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR23_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR23_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR23_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR23_PROCID_Msk = 0xff

	// RLR24: Semaphore 24 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR24_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR24_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR24_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR24_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR24_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR24_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR24_PROCID_Msk = 0xff

	// RLR25: Semaphore 25 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR25_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR25_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR25_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR25_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR25_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR25_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR25_PROCID_Msk = 0xff

	// RLR26: Semaphore 26 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR26_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR26_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR26_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR26_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR26_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR26_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR26_PROCID_Msk = 0xff

	// RLR27: Semaphore 27 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR27_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR27_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR27_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR27_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR27_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR27_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR27_PROCID_Msk = 0xff

	// RLR28: Semaphore 28 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR28_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR28_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR28_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR28_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR28_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR28_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR28_PROCID_Msk = 0xff

	// RLR29: Semaphore 29 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR29_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR29_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR29_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR29_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR29_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR29_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR29_PROCID_Msk = 0xff

	// RLR30: Semaphore 30 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR30_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR30_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR30_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR30_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR30_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR30_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR30_PROCID_Msk = 0xff

	// RLR31: Semaphore 31 read lock register
	// Position of LOCK field.
	Hardware_Semaphore_RLR31_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Hardware_Semaphore_RLR31_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Hardware_Semaphore_RLR31_LOCK = 0x80000000
	// Position of COREID field.
	Hardware_Semaphore_RLR31_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_RLR31_COREID_Msk = 0xf00
	// Position of PROCID field.
	Hardware_Semaphore_RLR31_PROCID_Pos = 0x0
	// Bit mask of PROCID field.
	Hardware_Semaphore_RLR31_PROCID_Msk = 0xff

	// C1IER0: HSEM Interrupt enable register
	// Position of ISEm field.
	Hardware_Semaphore_C1IER0_ISEm_Pos = 0x0
	// Bit mask of ISEm field.
	Hardware_Semaphore_C1IER0_ISEm_Msk = 0xffffffff

	// C1ICR: HSEM Interrupt clear register
	// Position of ISCm field.
	Hardware_Semaphore_C1ICR_ISCm_Pos = 0x0
	// Bit mask of ISCm field.
	Hardware_Semaphore_C1ICR_ISCm_Msk = 0xffffffff

	// C1ISR: HSEM Interrupt status register
	// Position of ISFm field.
	Hardware_Semaphore_C1ISR_ISFm_Pos = 0x0
	// Bit mask of ISFm field.
	Hardware_Semaphore_C1ISR_ISFm_Msk = 0xffffffff

	// C1MISR: HSEM Masked interrupt status register
	// Position of MISFm field.
	Hardware_Semaphore_C1MISR_MISFm_Pos = 0x0
	// Bit mask of MISFm field.
	Hardware_Semaphore_C1MISR_MISFm_Msk = 0xffffffff

	// C2IER0: HSEM Interrupt enable register
	// Position of ISEm field.
	Hardware_Semaphore_C2IER0_ISEm_Pos = 0x0
	// Bit mask of ISEm field.
	Hardware_Semaphore_C2IER0_ISEm_Msk = 0xffffffff

	// C2ICR: HSEM Interrupt clear register
	// Position of ISCm field.
	Hardware_Semaphore_C2ICR_ISCm_Pos = 0x0
	// Bit mask of ISCm field.
	Hardware_Semaphore_C2ICR_ISCm_Msk = 0xffffffff

	// C2ISR: HSEM Interrupt status register
	// Position of ISFm field.
	Hardware_Semaphore_C2ISR_ISFm_Pos = 0x0
	// Bit mask of ISFm field.
	Hardware_Semaphore_C2ISR_ISFm_Msk = 0xffffffff

	// C2MISR: HSEM Masked interrupt status register
	// Position of MISFm field.
	Hardware_Semaphore_C2MISR_MISFm_Pos = 0x0
	// Bit mask of MISFm field.
	Hardware_Semaphore_C2MISR_MISFm_Msk = 0xffffffff

	// CR: Semaphore Clear register
	// Position of KEY field.
	Hardware_Semaphore_CR_KEY_Pos = 0x10
	// Bit mask of KEY field.
	Hardware_Semaphore_CR_KEY_Msk = 0xffff0000
	// Position of COREID field.
	Hardware_Semaphore_CR_COREID_Pos = 0x8
	// Bit mask of COREID field.
	Hardware_Semaphore_CR_COREID_Msk = 0xf00

	// KEYR: Interrupt clear register
	// Position of KEY field.
	Hardware_Semaphore_KEYR_KEY_Pos = 0x10
	// Bit mask of KEY field.
	Hardware_Semaphore_KEYR_KEY_Msk = 0xffff0000

	// HWCFGR2: Semaphore hardware configuration register 2
	// Position of MASTERID4 field.
	Hardware_Semaphore_HWCFGR2_MASTERID4_Pos = 0xc
	// Bit mask of MASTERID4 field.
	Hardware_Semaphore_HWCFGR2_MASTERID4_Msk = 0xf000
	// Position of MASTERID3 field.
	Hardware_Semaphore_HWCFGR2_MASTERID3_Pos = 0x8
	// Bit mask of MASTERID3 field.
	Hardware_Semaphore_HWCFGR2_MASTERID3_Msk = 0xf00
	// Position of MASTERID2 field.
	Hardware_Semaphore_HWCFGR2_MASTERID2_Pos = 0x4
	// Bit mask of MASTERID2 field.
	Hardware_Semaphore_HWCFGR2_MASTERID2_Msk = 0xf0
	// Position of MASTERID1 field.
	Hardware_Semaphore_HWCFGR2_MASTERID1_Pos = 0x0
	// Bit mask of MASTERID1 field.
	Hardware_Semaphore_HWCFGR2_MASTERID1_Msk = 0xf

	// HWCFGR1: Semaphore hardware configuration register 1
	// Position of NBINT field.
	Hardware_Semaphore_HWCFGR1_NBINT_Pos = 0x8
	// Bit mask of NBINT field.
	Hardware_Semaphore_HWCFGR1_NBINT_Msk = 0xf00
	// Position of NBSEM field.
	Hardware_Semaphore_HWCFGR1_NBSEM_Pos = 0x0
	// Bit mask of NBSEM field.
	Hardware_Semaphore_HWCFGR1_NBSEM_Msk = 0xff

	// VERR: HSEM version register
	// Position of MAJREV field.
	Hardware_Semaphore_VERR_MAJREV_Pos = 0x4
	// Bit mask of MAJREV field.
	Hardware_Semaphore_VERR_MAJREV_Msk = 0xf0
	// Position of MINREV field.
	Hardware_Semaphore_VERR_MINREV_Pos = 0x0
	// Bit mask of MINREV field.
	Hardware_Semaphore_VERR_MINREV_Msk = 0xf

	// IPIDR: HSEM indentification register
	// Position of ID field.
	Hardware_Semaphore_IPIDR_ID_Pos = 0x0
	// Bit mask of ID field.
	Hardware_Semaphore_IPIDR_ID_Msk = 0xffffffff

	// SIDR: HSEM size indentification register
	// Position of SID field.
	Hardware_Semaphore_SIDR_SID_Pos = 0x0
	// Bit mask of SID field.
	Hardware_Semaphore_SIDR_SID_Msk = 0xffffffff
)

// Bitfields for ADC: Analog to Digital Converter instance 1
const (
	// ISR: ADC interrupt and status register
	// Position of JQOVF field.
	ADC_ISR_JQOVF_Pos = 0xa
	// Bit mask of JQOVF field.
	ADC_ISR_JQOVF_Msk = 0x400
	// Bit JQOVF.
	ADC_ISR_JQOVF = 0x400
	// Position of AWD3 field.
	ADC_ISR_AWD3_Pos = 0x9
	// Bit mask of AWD3 field.
	ADC_ISR_AWD3_Msk = 0x200
	// Bit AWD3.
	ADC_ISR_AWD3 = 0x200
	// Position of AWD2 field.
	ADC_ISR_AWD2_Pos = 0x8
	// Bit mask of AWD2 field.
	ADC_ISR_AWD2_Msk = 0x100
	// Bit AWD2.
	ADC_ISR_AWD2 = 0x100
	// Position of AWD1 field.
	ADC_ISR_AWD1_Pos = 0x7
	// Bit mask of AWD1 field.
	ADC_ISR_AWD1_Msk = 0x80
	// Bit AWD1.
	ADC_ISR_AWD1 = 0x80
	// Position of JEOS field.
	ADC_ISR_JEOS_Pos = 0x6
	// Bit mask of JEOS field.
	ADC_ISR_JEOS_Msk = 0x40
	// Bit JEOS.
	ADC_ISR_JEOS = 0x40
	// Position of JEOC field.
	ADC_ISR_JEOC_Pos = 0x5
	// Bit mask of JEOC field.
	ADC_ISR_JEOC_Msk = 0x20
	// Bit JEOC.
	ADC_ISR_JEOC = 0x20
	// Position of OVR field.
	ADC_ISR_OVR_Pos = 0x4
	// Bit mask of OVR field.
	ADC_ISR_OVR_Msk = 0x10
	// Bit OVR.
	ADC_ISR_OVR = 0x10
	// Position of EOS field.
	ADC_ISR_EOS_Pos = 0x3
	// Bit mask of EOS field.
	ADC_ISR_EOS_Msk = 0x8
	// Bit EOS.
	ADC_ISR_EOS = 0x8
	// Position of EOC field.
	ADC_ISR_EOC_Pos = 0x2
	// Bit mask of EOC field.
	ADC_ISR_EOC_Msk = 0x4
	// Bit EOC.
	ADC_ISR_EOC = 0x4
	// Position of EOSMP field.
	ADC_ISR_EOSMP_Pos = 0x1
	// Bit mask of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2
	// Bit EOSMP.
	ADC_ISR_EOSMP = 0x2
	// Position of ADRDY field.
	ADC_ISR_ADRDY_Pos = 0x0
	// Bit mask of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1
	// Bit ADRDY.
	ADC_ISR_ADRDY = 0x1

	// IER: ADC interrupt enable register
	// Position of JQOVFIE field.
	ADC_IER_JQOVFIE_Pos = 0xa
	// Bit mask of JQOVFIE field.
	ADC_IER_JQOVFIE_Msk = 0x400
	// Bit JQOVFIE.
	ADC_IER_JQOVFIE = 0x400
	// Position of AWD3IE field.
	ADC_IER_AWD3IE_Pos = 0x9
	// Bit mask of AWD3IE field.
	ADC_IER_AWD3IE_Msk = 0x200
	// Bit AWD3IE.
	ADC_IER_AWD3IE = 0x200
	// Position of AWD2IE field.
	ADC_IER_AWD2IE_Pos = 0x8
	// Bit mask of AWD2IE field.
	ADC_IER_AWD2IE_Msk = 0x100
	// Bit AWD2IE.
	ADC_IER_AWD2IE = 0x100
	// Position of AWD1IE field.
	ADC_IER_AWD1IE_Pos = 0x7
	// Bit mask of AWD1IE field.
	ADC_IER_AWD1IE_Msk = 0x80
	// Bit AWD1IE.
	ADC_IER_AWD1IE = 0x80
	// Position of JEOSIE field.
	ADC_IER_JEOSIE_Pos = 0x6
	// Bit mask of JEOSIE field.
	ADC_IER_JEOSIE_Msk = 0x40
	// Bit JEOSIE.
	ADC_IER_JEOSIE = 0x40
	// Position of JEOCIE field.
	ADC_IER_JEOCIE_Pos = 0x5
	// Bit mask of JEOCIE field.
	ADC_IER_JEOCIE_Msk = 0x20
	// Bit JEOCIE.
	ADC_IER_JEOCIE = 0x20
	// Position of OVRIE field.
	ADC_IER_OVRIE_Pos = 0x4
	// Bit mask of OVRIE field.
	ADC_IER_OVRIE_Msk = 0x10
	// Bit OVRIE.
	ADC_IER_OVRIE = 0x10
	// Position of EOSIE field.
	ADC_IER_EOSIE_Pos = 0x3
	// Bit mask of EOSIE field.
	ADC_IER_EOSIE_Msk = 0x8
	// Bit EOSIE.
	ADC_IER_EOSIE = 0x8
	// Position of EOCIE field.
	ADC_IER_EOCIE_Pos = 0x2
	// Bit mask of EOCIE field.
	ADC_IER_EOCIE_Msk = 0x4
	// Bit EOCIE.
	ADC_IER_EOCIE = 0x4
	// Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Pos = 0x1
	// Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2
	// Bit EOSMPIE.
	ADC_IER_EOSMPIE = 0x2
	// Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Pos = 0x0
	// Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1
	// Bit ADRDYIE.
	ADC_IER_ADRDYIE = 0x1

	// CR: ADC control register
	// Position of ADCAL field.
	ADC_CR_ADCAL_Pos = 0x1f
	// Bit mask of ADCAL field.
	ADC_CR_ADCAL_Msk = 0x80000000
	// Bit ADCAL.
	ADC_CR_ADCAL = 0x80000000
	// Position of ADCALDIF field.
	ADC_CR_ADCALDIF_Pos = 0x1e
	// Bit mask of ADCALDIF field.
	ADC_CR_ADCALDIF_Msk = 0x40000000
	// Bit ADCALDIF.
	ADC_CR_ADCALDIF = 0x40000000
	// Position of DEEPPWD field.
	ADC_CR_DEEPPWD_Pos = 0x1d
	// Bit mask of DEEPPWD field.
	ADC_CR_DEEPPWD_Msk = 0x20000000
	// Bit DEEPPWD.
	ADC_CR_DEEPPWD = 0x20000000
	// Position of ADVREGEN field.
	ADC_CR_ADVREGEN_Pos = 0x1c
	// Bit mask of ADVREGEN field.
	ADC_CR_ADVREGEN_Msk = 0x10000000
	// Bit ADVREGEN.
	ADC_CR_ADVREGEN = 0x10000000
	// Position of JADSTP field.
	ADC_CR_JADSTP_Pos = 0x5
	// Bit mask of JADSTP field.
	ADC_CR_JADSTP_Msk = 0x20
	// Bit JADSTP.
	ADC_CR_JADSTP = 0x20
	// Position of ADSTP field.
	ADC_CR_ADSTP_Pos = 0x4
	// Bit mask of ADSTP field.
	ADC_CR_ADSTP_Msk = 0x10
	// Bit ADSTP.
	ADC_CR_ADSTP = 0x10
	// Position of JADSTART field.
	ADC_CR_JADSTART_Pos = 0x3
	// Bit mask of JADSTART field.
	ADC_CR_JADSTART_Msk = 0x8
	// Bit JADSTART.
	ADC_CR_JADSTART = 0x8
	// Position of ADSTART field.
	ADC_CR_ADSTART_Pos = 0x2
	// Bit mask of ADSTART field.
	ADC_CR_ADSTART_Msk = 0x4
	// Bit ADSTART.
	ADC_CR_ADSTART = 0x4
	// Position of ADDIS field.
	ADC_CR_ADDIS_Pos = 0x1
	// Bit mask of ADDIS field.
	ADC_CR_ADDIS_Msk = 0x2
	// Bit ADDIS.
	ADC_CR_ADDIS = 0x2
	// Position of ADEN field.
	ADC_CR_ADEN_Pos = 0x0
	// Bit mask of ADEN field.
	ADC_CR_ADEN_Msk = 0x1
	// Bit ADEN.
	ADC_CR_ADEN = 0x1

	// CFGR: ADC configuration register 1
	// Position of JQDIS field.
	ADC_CFGR_JQDIS_Pos = 0x1f
	// Bit mask of JQDIS field.
	ADC_CFGR_JQDIS_Msk = 0x80000000
	// Bit JQDIS.
	ADC_CFGR_JQDIS = 0x80000000
	// Position of AWDCH1CH field.
	ADC_CFGR_AWDCH1CH_Pos = 0x1a
	// Bit mask of AWDCH1CH field.
	ADC_CFGR_AWDCH1CH_Msk = 0x7c000000
	// Position of JAUTO field.
	ADC_CFGR_JAUTO_Pos = 0x19
	// Bit mask of JAUTO field.
	ADC_CFGR_JAUTO_Msk = 0x2000000
	// Bit JAUTO.
	ADC_CFGR_JAUTO = 0x2000000
	// Position of JAWD1EN field.
	ADC_CFGR_JAWD1EN_Pos = 0x18
	// Bit mask of JAWD1EN field.
	ADC_CFGR_JAWD1EN_Msk = 0x1000000
	// Bit JAWD1EN.
	ADC_CFGR_JAWD1EN = 0x1000000
	// Position of AWD1EN field.
	ADC_CFGR_AWD1EN_Pos = 0x17
	// Bit mask of AWD1EN field.
	ADC_CFGR_AWD1EN_Msk = 0x800000
	// Bit AWD1EN.
	ADC_CFGR_AWD1EN = 0x800000
	// Position of AWD1SGL field.
	ADC_CFGR_AWD1SGL_Pos = 0x16
	// Bit mask of AWD1SGL field.
	ADC_CFGR_AWD1SGL_Msk = 0x400000
	// Bit AWD1SGL.
	ADC_CFGR_AWD1SGL = 0x400000
	// Position of JQM field.
	ADC_CFGR_JQM_Pos = 0x15
	// Bit mask of JQM field.
	ADC_CFGR_JQM_Msk = 0x200000
	// Bit JQM.
	ADC_CFGR_JQM = 0x200000
	// Position of JDISCEN field.
	ADC_CFGR_JDISCEN_Pos = 0x14
	// Bit mask of JDISCEN field.
	ADC_CFGR_JDISCEN_Msk = 0x100000
	// Bit JDISCEN.
	ADC_CFGR_JDISCEN = 0x100000
	// Position of DISCNUM field.
	ADC_CFGR_DISCNUM_Pos = 0x11
	// Bit mask of DISCNUM field.
	ADC_CFGR_DISCNUM_Msk = 0xe0000
	// Position of DISCEN field.
	ADC_CFGR_DISCEN_Pos = 0x10
	// Bit mask of DISCEN field.
	ADC_CFGR_DISCEN_Msk = 0x10000
	// Bit DISCEN.
	ADC_CFGR_DISCEN = 0x10000
	// Position of AUTDLY field.
	ADC_CFGR_AUTDLY_Pos = 0xe
	// Bit mask of AUTDLY field.
	ADC_CFGR_AUTDLY_Msk = 0x4000
	// Bit AUTDLY.
	ADC_CFGR_AUTDLY = 0x4000
	// Position of CONT field.
	ADC_CFGR_CONT_Pos = 0xd
	// Bit mask of CONT field.
	ADC_CFGR_CONT_Msk = 0x2000
	// Bit CONT.
	ADC_CFGR_CONT = 0x2000
	// Position of OVRMOD field.
	ADC_CFGR_OVRMOD_Pos = 0xc
	// Bit mask of OVRMOD field.
	ADC_CFGR_OVRMOD_Msk = 0x1000
	// Bit OVRMOD.
	ADC_CFGR_OVRMOD = 0x1000
	// Position of EXTEN field.
	ADC_CFGR_EXTEN_Pos = 0xa
	// Bit mask of EXTEN field.
	ADC_CFGR_EXTEN_Msk = 0xc00
	// Position of EXTSEL field.
	ADC_CFGR_EXTSEL_Pos = 0x6
	// Bit mask of EXTSEL field.
	ADC_CFGR_EXTSEL_Msk = 0x3c0
	// Position of ALIGN field.
	ADC_CFGR_ALIGN_Pos = 0x5
	// Bit mask of ALIGN field.
	ADC_CFGR_ALIGN_Msk = 0x20
	// Bit ALIGN.
	ADC_CFGR_ALIGN = 0x20
	// Position of RES field.
	ADC_CFGR_RES_Pos = 0x3
	// Bit mask of RES field.
	ADC_CFGR_RES_Msk = 0x18
	// Position of DMACFG field.
	ADC_CFGR_DMACFG_Pos = 0x1
	// Bit mask of DMACFG field.
	ADC_CFGR_DMACFG_Msk = 0x2
	// Bit DMACFG.
	ADC_CFGR_DMACFG = 0x2
	// Position of DMAEN field.
	ADC_CFGR_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	ADC_CFGR_DMAEN_Msk = 0x1
	// Bit DMAEN.
	ADC_CFGR_DMAEN = 0x1

	// CFGR2: ADC configuration register 2
	// Position of ROVSM field.
	ADC_CFGR2_ROVSM_Pos = 0xa
	// Bit mask of ROVSM field.
	ADC_CFGR2_ROVSM_Msk = 0x400
	// Bit ROVSM.
	ADC_CFGR2_ROVSM = 0x400
	// Position of TOVS field.
	ADC_CFGR2_TOVS_Pos = 0x9
	// Bit mask of TOVS field.
	ADC_CFGR2_TOVS_Msk = 0x200
	// Bit TOVS.
	ADC_CFGR2_TOVS = 0x200
	// Position of OVSS field.
	ADC_CFGR2_OVSS_Pos = 0x5
	// Bit mask of OVSS field.
	ADC_CFGR2_OVSS_Msk = 0x1e0
	// Position of OVSR field.
	ADC_CFGR2_OVSR_Pos = 0x2
	// Bit mask of OVSR field.
	ADC_CFGR2_OVSR_Msk = 0x1c
	// Position of JOVSE field.
	ADC_CFGR2_JOVSE_Pos = 0x1
	// Bit mask of JOVSE field.
	ADC_CFGR2_JOVSE_Msk = 0x2
	// Bit JOVSE.
	ADC_CFGR2_JOVSE = 0x2
	// Position of ROVSE field.
	ADC_CFGR2_ROVSE_Pos = 0x0
	// Bit mask of ROVSE field.
	ADC_CFGR2_ROVSE_Msk = 0x1
	// Bit ROVSE.
	ADC_CFGR2_ROVSE = 0x1

	// SMPR1: ADC sampling time register 1
	// Position of SMP9 field.
	ADC_SMPR1_SMP9_Pos = 0x1b
	// Bit mask of SMP9 field.
	ADC_SMPR1_SMP9_Msk = 0x38000000
	// Position of SMP8 field.
	ADC_SMPR1_SMP8_Pos = 0x18
	// Bit mask of SMP8 field.
	ADC_SMPR1_SMP8_Msk = 0x7000000
	// Position of SMP7 field.
	ADC_SMPR1_SMP7_Pos = 0x15
	// Bit mask of SMP7 field.
	ADC_SMPR1_SMP7_Msk = 0xe00000
	// Position of SMP6 field.
	ADC_SMPR1_SMP6_Pos = 0x12
	// Bit mask of SMP6 field.
	ADC_SMPR1_SMP6_Msk = 0x1c0000
	// Position of SMP5 field.
	ADC_SMPR1_SMP5_Pos = 0xf
	// Bit mask of SMP5 field.
	ADC_SMPR1_SMP5_Msk = 0x38000
	// Position of SMP4 field.
	ADC_SMPR1_SMP4_Pos = 0xc
	// Bit mask of SMP4 field.
	ADC_SMPR1_SMP4_Msk = 0x7000
	// Position of SMP3 field.
	ADC_SMPR1_SMP3_Pos = 0x9
	// Bit mask of SMP3 field.
	ADC_SMPR1_SMP3_Msk = 0xe00
	// Position of SMP2 field.
	ADC_SMPR1_SMP2_Pos = 0x6
	// Bit mask of SMP2 field.
	ADC_SMPR1_SMP2_Msk = 0x1c0
	// Position of SMP1 field.
	ADC_SMPR1_SMP1_Pos = 0x3
	// Bit mask of SMP1 field.
	ADC_SMPR1_SMP1_Msk = 0x38

	// SMPR2: ADC sampling time register 2
	// Position of SMP18 field.
	ADC_SMPR2_SMP18_Pos = 0x18
	// Bit mask of SMP18 field.
	ADC_SMPR2_SMP18_Msk = 0x7000000
	// Position of SMP17 field.
	ADC_SMPR2_SMP17_Pos = 0x15
	// Bit mask of SMP17 field.
	ADC_SMPR2_SMP17_Msk = 0xe00000
	// Position of SMP16 field.
	ADC_SMPR2_SMP16_Pos = 0x12
	// Bit mask of SMP16 field.
	ADC_SMPR2_SMP16_Msk = 0x1c0000
	// Position of SMP15 field.
	ADC_SMPR2_SMP15_Pos = 0xf
	// Bit mask of SMP15 field.
	ADC_SMPR2_SMP15_Msk = 0x38000
	// Position of SMP14 field.
	ADC_SMPR2_SMP14_Pos = 0xc
	// Bit mask of SMP14 field.
	ADC_SMPR2_SMP14_Msk = 0x7000
	// Position of SMP13 field.
	ADC_SMPR2_SMP13_Pos = 0x9
	// Bit mask of SMP13 field.
	ADC_SMPR2_SMP13_Msk = 0xe00
	// Position of SMP12 field.
	ADC_SMPR2_SMP12_Pos = 0x6
	// Bit mask of SMP12 field.
	ADC_SMPR2_SMP12_Msk = 0x1c0
	// Position of SMP11 field.
	ADC_SMPR2_SMP11_Pos = 0x3
	// Bit mask of SMP11 field.
	ADC_SMPR2_SMP11_Msk = 0x38
	// Position of SMP10 field.
	ADC_SMPR2_SMP10_Pos = 0x0
	// Bit mask of SMP10 field.
	ADC_SMPR2_SMP10_Msk = 0x7

	// TR1: ADC analog watchdog 1 threshold register
	// Position of HT1 field.
	ADC_TR1_HT1_Pos = 0x10
	// Bit mask of HT1 field.
	ADC_TR1_HT1_Msk = 0xfff0000
	// Position of LT1 field.
	ADC_TR1_LT1_Pos = 0x0
	// Bit mask of LT1 field.
	ADC_TR1_LT1_Msk = 0xfff

	// TR2: ADC analog watchdog 2 threshold register
	// Position of HT2 field.
	ADC_TR2_HT2_Pos = 0x10
	// Bit mask of HT2 field.
	ADC_TR2_HT2_Msk = 0xff0000
	// Position of LT2 field.
	ADC_TR2_LT2_Pos = 0x0
	// Bit mask of LT2 field.
	ADC_TR2_LT2_Msk = 0xff

	// TR3: ADC analog watchdog 3 threshold register
	// Position of HT3 field.
	ADC_TR3_HT3_Pos = 0x10
	// Bit mask of HT3 field.
	ADC_TR3_HT3_Msk = 0xff0000
	// Position of LT3 field.
	ADC_TR3_LT3_Pos = 0x0
	// Bit mask of LT3 field.
	ADC_TR3_LT3_Msk = 0xff

	// SQR1: ADC group regular sequencer ranks register 1
	// Position of SQ4 field.
	ADC_SQR1_SQ4_Pos = 0x18
	// Bit mask of SQ4 field.
	ADC_SQR1_SQ4_Msk = 0x1f000000
	// Position of SQ3 field.
	ADC_SQR1_SQ3_Pos = 0x12
	// Bit mask of SQ3 field.
	ADC_SQR1_SQ3_Msk = 0x7c0000
	// Position of SQ2 field.
	ADC_SQR1_SQ2_Pos = 0xc
	// Bit mask of SQ2 field.
	ADC_SQR1_SQ2_Msk = 0x1f000
	// Position of SQ1 field.
	ADC_SQR1_SQ1_Pos = 0x6
	// Bit mask of SQ1 field.
	ADC_SQR1_SQ1_Msk = 0x7c0
	// Position of L field.
	ADC_SQR1_L_Pos = 0x0
	// Bit mask of L field.
	ADC_SQR1_L_Msk = 0xf

	// SQR2: ADC group regular sequencer ranks register 2
	// Position of SQ9 field.
	ADC_SQR2_SQ9_Pos = 0x18
	// Bit mask of SQ9 field.
	ADC_SQR2_SQ9_Msk = 0x1f000000
	// Position of SQ8 field.
	ADC_SQR2_SQ8_Pos = 0x12
	// Bit mask of SQ8 field.
	ADC_SQR2_SQ8_Msk = 0x7c0000
	// Position of SQ7 field.
	ADC_SQR2_SQ7_Pos = 0xc
	// Bit mask of SQ7 field.
	ADC_SQR2_SQ7_Msk = 0x1f000
	// Position of SQ6 field.
	ADC_SQR2_SQ6_Pos = 0x6
	// Bit mask of SQ6 field.
	ADC_SQR2_SQ6_Msk = 0x7c0
	// Position of SQ5 field.
	ADC_SQR2_SQ5_Pos = 0x0
	// Bit mask of SQ5 field.
	ADC_SQR2_SQ5_Msk = 0x1f

	// SQR3: ADC group regular sequencer ranks register 3
	// Position of SQ14 field.
	ADC_SQR3_SQ14_Pos = 0x18
	// Bit mask of SQ14 field.
	ADC_SQR3_SQ14_Msk = 0x1f000000
	// Position of SQ13 field.
	ADC_SQR3_SQ13_Pos = 0x12
	// Bit mask of SQ13 field.
	ADC_SQR3_SQ13_Msk = 0x7c0000
	// Position of SQ12 field.
	ADC_SQR3_SQ12_Pos = 0xc
	// Bit mask of SQ12 field.
	ADC_SQR3_SQ12_Msk = 0x1f000
	// Position of SQ11 field.
	ADC_SQR3_SQ11_Pos = 0x6
	// Bit mask of SQ11 field.
	ADC_SQR3_SQ11_Msk = 0x7c0
	// Position of SQ10 field.
	ADC_SQR3_SQ10_Pos = 0x0
	// Bit mask of SQ10 field.
	ADC_SQR3_SQ10_Msk = 0x1f

	// SQR4: ADC group regular sequencer ranks register 4
	// Position of SQ16 field.
	ADC_SQR4_SQ16_Pos = 0x6
	// Bit mask of SQ16 field.
	ADC_SQR4_SQ16_Msk = 0x7c0
	// Position of SQ15 field.
	ADC_SQR4_SQ15_Pos = 0x0
	// Bit mask of SQ15 field.
	ADC_SQR4_SQ15_Msk = 0x1f

	// DR: ADC group regular conversion data register
	// Position of RDATA_0_6 field.
	ADC_DR_RDATA_0_6_Pos = 0x0
	// Bit mask of RDATA_0_6 field.
	ADC_DR_RDATA_0_6_Msk = 0x3f
	// Position of RDATA_7_15 field.
	ADC_DR_RDATA_7_15_Pos = 0x7
	// Bit mask of RDATA_7_15 field.
	ADC_DR_RDATA_7_15_Msk = 0xff80

	// JSQR: ADC group injected sequencer register
	// Position of JSQ4 field.
	ADC_JSQR_JSQ4_Pos = 0x1a
	// Bit mask of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0x7c000000
	// Position of JSQ3 field.
	ADC_JSQR_JSQ3_Pos = 0x14
	// Bit mask of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x1f00000
	// Position of JSQ2 field.
	ADC_JSQR_JSQ2_Pos = 0xe
	// Bit mask of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x7c000
	// Position of JSQ1 field.
	ADC_JSQR_JSQ1_Pos = 0x8
	// Bit mask of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f00
	// Position of JEXTEN field.
	ADC_JSQR_JEXTEN_Pos = 0x6
	// Bit mask of JEXTEN field.
	ADC_JSQR_JEXTEN_Msk = 0xc0
	// Position of JEXTSEL field.
	ADC_JSQR_JEXTSEL_Pos = 0x2
	// Bit mask of JEXTSEL field.
	ADC_JSQR_JEXTSEL_Msk = 0x3c
	// Position of JL field.
	ADC_JSQR_JL_Pos = 0x0
	// Bit mask of JL field.
	ADC_JSQR_JL_Msk = 0x3

	// OFR1: ADC offset number 1 register
	// Position of OFFSET1_EN field.
	ADC_OFR1_OFFSET1_EN_Pos = 0x1f
	// Bit mask of OFFSET1_EN field.
	ADC_OFR1_OFFSET1_EN_Msk = 0x80000000
	// Bit OFFSET1_EN.
	ADC_OFR1_OFFSET1_EN = 0x80000000
	// Position of OFFSET1_CH field.
	ADC_OFR1_OFFSET1_CH_Pos = 0x1a
	// Bit mask of OFFSET1_CH field.
	ADC_OFR1_OFFSET1_CH_Msk = 0x7c000000
	// Position of OFFSET1 field.
	ADC_OFR1_OFFSET1_Pos = 0x0
	// Bit mask of OFFSET1 field.
	ADC_OFR1_OFFSET1_Msk = 0xfff

	// OFR2: ADC offset number 2 register
	// Position of OFFSET2_EN field.
	ADC_OFR2_OFFSET2_EN_Pos = 0x1f
	// Bit mask of OFFSET2_EN field.
	ADC_OFR2_OFFSET2_EN_Msk = 0x80000000
	// Bit OFFSET2_EN.
	ADC_OFR2_OFFSET2_EN = 0x80000000
	// Position of OFFSET2_CH field.
	ADC_OFR2_OFFSET2_CH_Pos = 0x1a
	// Bit mask of OFFSET2_CH field.
	ADC_OFR2_OFFSET2_CH_Msk = 0x7c000000
	// Position of OFFSET2 field.
	ADC_OFR2_OFFSET2_Pos = 0x0
	// Bit mask of OFFSET2 field.
	ADC_OFR2_OFFSET2_Msk = 0xfff

	// OFR3: ADC offset number 3 register
	// Position of OFFSET3_EN field.
	ADC_OFR3_OFFSET3_EN_Pos = 0x1f
	// Bit mask of OFFSET3_EN field.
	ADC_OFR3_OFFSET3_EN_Msk = 0x80000000
	// Bit OFFSET3_EN.
	ADC_OFR3_OFFSET3_EN = 0x80000000
	// Position of OFFSET3_CH field.
	ADC_OFR3_OFFSET3_CH_Pos = 0x1a
	// Bit mask of OFFSET3_CH field.
	ADC_OFR3_OFFSET3_CH_Msk = 0x7c000000
	// Position of OFFSET3 field.
	ADC_OFR3_OFFSET3_Pos = 0x0
	// Bit mask of OFFSET3 field.
	ADC_OFR3_OFFSET3_Msk = 0xfff

	// OFR4: ADC offset number 4 register
	// Position of OFFSET4_EN field.
	ADC_OFR4_OFFSET4_EN_Pos = 0x1f
	// Bit mask of OFFSET4_EN field.
	ADC_OFR4_OFFSET4_EN_Msk = 0x80000000
	// Bit OFFSET4_EN.
	ADC_OFR4_OFFSET4_EN = 0x80000000
	// Position of OFFSET4_CH field.
	ADC_OFR4_OFFSET4_CH_Pos = 0x1a
	// Bit mask of OFFSET4_CH field.
	ADC_OFR4_OFFSET4_CH_Msk = 0x7c000000
	// Position of OFFSET4 field.
	ADC_OFR4_OFFSET4_Pos = 0x0
	// Bit mask of OFFSET4 field.
	ADC_OFR4_OFFSET4_Msk = 0xfff

	// JDR1: ADC group injected sequencer rank 1 register
	// Position of JDATA1 field.
	ADC_JDR1_JDATA1_Pos = 0x0
	// Bit mask of JDATA1 field.
	ADC_JDR1_JDATA1_Msk = 0xffff

	// JDR2: ADC group injected sequencer rank 2 register
	// Position of JDATA2 field.
	ADC_JDR2_JDATA2_Pos = 0x0
	// Bit mask of JDATA2 field.
	ADC_JDR2_JDATA2_Msk = 0xffff

	// JDR3: ADC group injected sequencer rank 3 register
	// Position of JDATA3 field.
	ADC_JDR3_JDATA3_Pos = 0x0
	// Bit mask of JDATA3 field.
	ADC_JDR3_JDATA3_Msk = 0xffff

	// JDR4: ADC group injected sequencer rank 4 register
	// Position of JDATA4 field.
	ADC_JDR4_JDATA4_Pos = 0x0
	// Bit mask of JDATA4 field.
	ADC_JDR4_JDATA4_Msk = 0xffff

	// AWD2CR: ADC analog watchdog 2 configuration register
	// Position of AWD2CH field.
	ADC_AWD2CR_AWD2CH_Pos = 0x0
	// Bit mask of AWD2CH field.
	ADC_AWD2CR_AWD2CH_Msk = 0x7ffff

	// AWD3CR: ADC analog watchdog 3 configuration register
	// Position of AWD3CH field.
	ADC_AWD3CR_AWD3CH_Pos = 0x0
	// Bit mask of AWD3CH field.
	ADC_AWD3CR_AWD3CH_Msk = 0x7ffff

	// DIFSEL: ADC channel differential or single-ended mode selection register
	// Position of DIFSEL_0 field.
	ADC_DIFSEL_DIFSEL_0_Pos = 0x0
	// Bit mask of DIFSEL_0 field.
	ADC_DIFSEL_DIFSEL_0_Msk = 0x1
	// Bit DIFSEL_0.
	ADC_DIFSEL_DIFSEL_0 = 0x1
	// Position of DIFSEL_1_15 field.
	ADC_DIFSEL_DIFSEL_1_15_Pos = 0x1
	// Bit mask of DIFSEL_1_15 field.
	ADC_DIFSEL_DIFSEL_1_15_Msk = 0xfffe
	// Position of DIFSEL_16_18 field.
	ADC_DIFSEL_DIFSEL_16_18_Pos = 0x10
	// Bit mask of DIFSEL_16_18 field.
	ADC_DIFSEL_DIFSEL_16_18_Msk = 0x70000

	// CALFACT: ADC calibration factors register
	// Position of CALFACT_D field.
	ADC_CALFACT_CALFACT_D_Pos = 0x10
	// Bit mask of CALFACT_D field.
	ADC_CALFACT_CALFACT_D_Msk = 0x7f0000
	// Position of CALFACT_S field.
	ADC_CALFACT_CALFACT_S_Pos = 0x0
	// Bit mask of CALFACT_S field.
	ADC_CALFACT_CALFACT_S_Msk = 0x7f

	// CCR: ADC common control register
	// Position of VBATEN field.
	ADC_CCR_VBATEN_Pos = 0x18
	// Bit mask of VBATEN field.
	ADC_CCR_VBATEN_Msk = 0x1000000
	// Bit VBATEN.
	ADC_CCR_VBATEN = 0x1000000
	// Position of TSEN field.
	ADC_CCR_TSEN_Pos = 0x17
	// Bit mask of TSEN field.
	ADC_CCR_TSEN_Msk = 0x800000
	// Bit TSEN.
	ADC_CCR_TSEN = 0x800000
	// Position of VREFEN field.
	ADC_CCR_VREFEN_Pos = 0x16
	// Bit mask of VREFEN field.
	ADC_CCR_VREFEN_Msk = 0x400000
	// Bit VREFEN.
	ADC_CCR_VREFEN = 0x400000
	// Position of PRESC field.
	ADC_CCR_PRESC_Pos = 0x12
	// Bit mask of PRESC field.
	ADC_CCR_PRESC_Msk = 0x3c0000
	// Position of CKMODE field.
	ADC_CCR_CKMODE_Pos = 0x10
	// Bit mask of CKMODE field.
	ADC_CCR_CKMODE_Msk = 0x30000
)

// Bitfields for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFSEL7 field.
	GPIO_AFRL_AFSEL7_Pos = 0x1c
	// Bit mask of AFSEL7 field.
	GPIO_AFRL_AFSEL7_Msk = 0xf0000000
	// Position of AFSEL6 field.
	GPIO_AFRL_AFSEL6_Pos = 0x18
	// Bit mask of AFSEL6 field.
	GPIO_AFRL_AFSEL6_Msk = 0xf000000
	// Position of AFSEL5 field.
	GPIO_AFRL_AFSEL5_Pos = 0x14
	// Bit mask of AFSEL5 field.
	GPIO_AFRL_AFSEL5_Msk = 0xf00000
	// Position of AFSEL4 field.
	GPIO_AFRL_AFSEL4_Pos = 0x10
	// Bit mask of AFSEL4 field.
	GPIO_AFRL_AFSEL4_Msk = 0xf0000
	// Position of AFSEL3 field.
	GPIO_AFRL_AFSEL3_Pos = 0xc
	// Bit mask of AFSEL3 field.
	GPIO_AFRL_AFSEL3_Msk = 0xf000
	// Position of AFSEL2 field.
	GPIO_AFRL_AFSEL2_Pos = 0x8
	// Bit mask of AFSEL2 field.
	GPIO_AFRL_AFSEL2_Msk = 0xf00
	// Position of AFSEL1 field.
	GPIO_AFRL_AFSEL1_Pos = 0x4
	// Bit mask of AFSEL1 field.
	GPIO_AFRL_AFSEL1_Msk = 0xf0
	// Position of AFSEL0 field.
	GPIO_AFRL_AFSEL0_Pos = 0x0
	// Bit mask of AFSEL0 field.
	GPIO_AFRL_AFSEL0_Msk = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFSEL15 field.
	GPIO_AFRH_AFSEL15_Pos = 0x1c
	// Bit mask of AFSEL15 field.
	GPIO_AFRH_AFSEL15_Msk = 0xf0000000
	// Position of AFSEL14 field.
	GPIO_AFRH_AFSEL14_Pos = 0x18
	// Bit mask of AFSEL14 field.
	GPIO_AFRH_AFSEL14_Msk = 0xf000000
	// Position of AFSEL13 field.
	GPIO_AFRH_AFSEL13_Pos = 0x14
	// Bit mask of AFSEL13 field.
	GPIO_AFRH_AFSEL13_Msk = 0xf00000
	// Position of AFSEL12 field.
	GPIO_AFRH_AFSEL12_Pos = 0x10
	// Bit mask of AFSEL12 field.
	GPIO_AFRH_AFSEL12_Msk = 0xf0000
	// Position of AFSEL11 field.
	GPIO_AFRH_AFSEL11_Pos = 0xc
	// Bit mask of AFSEL11 field.
	GPIO_AFRH_AFSEL11_Msk = 0xf000
	// Position of AFSEL10 field.
	GPIO_AFRH_AFSEL10_Pos = 0x8
	// Bit mask of AFSEL10 field.
	GPIO_AFRH_AFSEL10_Msk = 0xf00
	// Position of AFSEL9 field.
	GPIO_AFRH_AFSEL9_Pos = 0x4
	// Bit mask of AFSEL9 field.
	GPIO_AFRH_AFSEL9_Msk = 0xf0
	// Position of AFSEL8 field.
	GPIO_AFRH_AFSEL8_Pos = 0x0
	// Bit mask of AFSEL8 field.
	GPIO_AFRH_AFSEL8_Msk = 0xf

	// BRR: port bit reset register
	// Position of BR0 field.
	GPIO_BRR_BR0_Pos = 0x0
	// Bit mask of BR0 field.
	GPIO_BRR_BR0_Msk = 0x1
	// Bit BR0.
	GPIO_BRR_BR0 = 0x1
	// Position of BR1 field.
	GPIO_BRR_BR1_Pos = 0x1
	// Bit mask of BR1 field.
	GPIO_BRR_BR1_Msk = 0x2
	// Bit BR1.
	GPIO_BRR_BR1 = 0x2
	// Position of BR2 field.
	GPIO_BRR_BR2_Pos = 0x2
	// Bit mask of BR2 field.
	GPIO_BRR_BR2_Msk = 0x4
	// Bit BR2.
	GPIO_BRR_BR2 = 0x4
	// Position of BR3 field.
	GPIO_BRR_BR3_Pos = 0x3
	// Bit mask of BR3 field.
	GPIO_BRR_BR3_Msk = 0x8
	// Bit BR3.
	GPIO_BRR_BR3 = 0x8
	// Position of BR4 field.
	GPIO_BRR_BR4_Pos = 0x4
	// Bit mask of BR4 field.
	GPIO_BRR_BR4_Msk = 0x10
	// Bit BR4.
	GPIO_BRR_BR4 = 0x10
	// Position of BR5 field.
	GPIO_BRR_BR5_Pos = 0x5
	// Bit mask of BR5 field.
	GPIO_BRR_BR5_Msk = 0x20
	// Bit BR5.
	GPIO_BRR_BR5 = 0x20
	// Position of BR6 field.
	GPIO_BRR_BR6_Pos = 0x6
	// Bit mask of BR6 field.
	GPIO_BRR_BR6_Msk = 0x40
	// Bit BR6.
	GPIO_BRR_BR6 = 0x40
	// Position of BR7 field.
	GPIO_BRR_BR7_Pos = 0x7
	// Bit mask of BR7 field.
	GPIO_BRR_BR7_Msk = 0x80
	// Bit BR7.
	GPIO_BRR_BR7 = 0x80
	// Position of BR8 field.
	GPIO_BRR_BR8_Pos = 0x8
	// Bit mask of BR8 field.
	GPIO_BRR_BR8_Msk = 0x100
	// Bit BR8.
	GPIO_BRR_BR8 = 0x100
	// Position of BR9 field.
	GPIO_BRR_BR9_Pos = 0x9
	// Bit mask of BR9 field.
	GPIO_BRR_BR9_Msk = 0x200
	// Bit BR9.
	GPIO_BRR_BR9 = 0x200
	// Position of BR10 field.
	GPIO_BRR_BR10_Pos = 0xa
	// Bit mask of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400
	// Bit BR10.
	GPIO_BRR_BR10 = 0x400
	// Position of BR11 field.
	GPIO_BRR_BR11_Pos = 0xb
	// Bit mask of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800
	// Bit BR11.
	GPIO_BRR_BR11 = 0x800
	// Position of BR12 field.
	GPIO_BRR_BR12_Pos = 0xc
	// Bit mask of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000
	// Bit BR12.
	GPIO_BRR_BR12 = 0x1000
	// Position of BR13 field.
	GPIO_BRR_BR13_Pos = 0xd
	// Bit mask of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000
	// Bit BR13.
	GPIO_BRR_BR13 = 0x2000
	// Position of BR14 field.
	GPIO_BRR_BR14_Pos = 0xe
	// Bit mask of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000
	// Bit BR14.
	GPIO_BRR_BR14 = 0x4000
	// Position of BR15 field.
	GPIO_BRR_BR15_Pos = 0xf
	// Bit mask of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000
	// Bit BR15.
	GPIO_BRR_BR15 = 0x8000
)

// Bitfields for SAI1: Serial audio interface
const (
	// GCR: Global configuration register
	// Position of SYNCOUT field.
	SAI_GCR_SYNCOUT_Pos = 0x4
	// Bit mask of SYNCOUT field.
	SAI_GCR_SYNCOUT_Msk = 0x30
	// Position of SYNCIN field.
	SAI_GCR_SYNCIN_Pos = 0x0
	// Bit mask of SYNCIN field.
	SAI_GCR_SYNCIN_Msk = 0x3

	// CH.CR1: AConfiguration register 1
	// Position of MCKEN field.
	SAI_CH_CR1_MCKEN_Pos = 0x1b
	// Bit mask of MCKEN field.
	SAI_CH_CR1_MCKEN_Msk = 0x8000000
	// Bit MCKEN.
	SAI_CH_CR1_MCKEN = 0x8000000
	// Position of OSR field.
	SAI_CH_CR1_OSR_Pos = 0x1a
	// Bit mask of OSR field.
	SAI_CH_CR1_OSR_Msk = 0x4000000
	// Bit OSR.
	SAI_CH_CR1_OSR = 0x4000000
	// Position of MCKDIV field.
	SAI_CH_CR1_MCKDIV_Pos = 0x14
	// Bit mask of MCKDIV field.
	SAI_CH_CR1_MCKDIV_Msk = 0x3f00000
	// Position of NODIV field.
	SAI_CH_CR1_NODIV_Pos = 0x13
	// Bit mask of NODIV field.
	SAI_CH_CR1_NODIV_Msk = 0x80000
	// Bit NODIV.
	SAI_CH_CR1_NODIV = 0x80000
	// Position of DMAEN field.
	SAI_CH_CR1_DMAEN_Pos = 0x11
	// Bit mask of DMAEN field.
	SAI_CH_CR1_DMAEN_Msk = 0x20000
	// Bit DMAEN.
	SAI_CH_CR1_DMAEN = 0x20000
	// Position of SAIEN field.
	SAI_CH_CR1_SAIEN_Pos = 0x10
	// Bit mask of SAIEN field.
	SAI_CH_CR1_SAIEN_Msk = 0x10000
	// Bit SAIEN.
	SAI_CH_CR1_SAIEN = 0x10000
	// Position of OUTDRIV field.
	SAI_CH_CR1_OUTDRIV_Pos = 0xd
	// Bit mask of OUTDRIV field.
	SAI_CH_CR1_OUTDRIV_Msk = 0x2000
	// Bit OUTDRIV.
	SAI_CH_CR1_OUTDRIV = 0x2000
	// Position of MONO field.
	SAI_CH_CR1_MONO_Pos = 0xc
	// Bit mask of MONO field.
	SAI_CH_CR1_MONO_Msk = 0x1000
	// Bit MONO.
	SAI_CH_CR1_MONO = 0x1000
	// Position of SYNCEN field.
	SAI_CH_CR1_SYNCEN_Pos = 0xa
	// Bit mask of SYNCEN field.
	SAI_CH_CR1_SYNCEN_Msk = 0xc00
	// Position of CKSTR field.
	SAI_CH_CR1_CKSTR_Pos = 0x9
	// Bit mask of CKSTR field.
	SAI_CH_CR1_CKSTR_Msk = 0x200
	// Bit CKSTR.
	SAI_CH_CR1_CKSTR = 0x200
	// Position of LSBFIRST field.
	SAI_CH_CR1_LSBFIRST_Pos = 0x8
	// Bit mask of LSBFIRST field.
	SAI_CH_CR1_LSBFIRST_Msk = 0x100
	// Bit LSBFIRST.
	SAI_CH_CR1_LSBFIRST = 0x100
	// Position of DS field.
	SAI_CH_CR1_DS_Pos = 0x5
	// Bit mask of DS field.
	SAI_CH_CR1_DS_Msk = 0xe0
	// Position of PRTCFG field.
	SAI_CH_CR1_PRTCFG_Pos = 0x2
	// Bit mask of PRTCFG field.
	SAI_CH_CR1_PRTCFG_Msk = 0xc
	// Position of MODE field.
	SAI_CH_CR1_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SAI_CH_CR1_MODE_Msk = 0x3

	// CH.CR2: AConfiguration register 2
	// Position of COMP field.
	SAI_CH_CR2_COMP_Pos = 0xe
	// Bit mask of COMP field.
	SAI_CH_CR2_COMP_Msk = 0xc000
	// Position of CPL field.
	SAI_CH_CR2_CPL_Pos = 0xd
	// Bit mask of CPL field.
	SAI_CH_CR2_CPL_Msk = 0x2000
	// Bit CPL.
	SAI_CH_CR2_CPL = 0x2000
	// Position of MUTECN field.
	SAI_CH_CR2_MUTECN_Pos = 0x7
	// Bit mask of MUTECN field.
	SAI_CH_CR2_MUTECN_Msk = 0x1f80
	// Position of MUTEVAL field.
	SAI_CH_CR2_MUTEVAL_Pos = 0x6
	// Bit mask of MUTEVAL field.
	SAI_CH_CR2_MUTEVAL_Msk = 0x40
	// Bit MUTEVAL.
	SAI_CH_CR2_MUTEVAL = 0x40
	// Position of MUTE field.
	SAI_CH_CR2_MUTE_Pos = 0x5
	// Bit mask of MUTE field.
	SAI_CH_CR2_MUTE_Msk = 0x20
	// Bit MUTE.
	SAI_CH_CR2_MUTE = 0x20
	// Position of TRIS field.
	SAI_CH_CR2_TRIS_Pos = 0x4
	// Bit mask of TRIS field.
	SAI_CH_CR2_TRIS_Msk = 0x10
	// Bit TRIS.
	SAI_CH_CR2_TRIS = 0x10
	// Position of FFLUSH field.
	SAI_CH_CR2_FFLUSH_Pos = 0x3
	// Bit mask of FFLUSH field.
	SAI_CH_CR2_FFLUSH_Msk = 0x8
	// Bit FFLUSH.
	SAI_CH_CR2_FFLUSH = 0x8
	// Position of FTH field.
	SAI_CH_CR2_FTH_Pos = 0x0
	// Bit mask of FTH field.
	SAI_CH_CR2_FTH_Msk = 0x7

	// CH.FRCR: AFRCR
	// Position of FSOFF field.
	SAI_CH_FRCR_FSOFF_Pos = 0x12
	// Bit mask of FSOFF field.
	SAI_CH_FRCR_FSOFF_Msk = 0x40000
	// Bit FSOFF.
	SAI_CH_FRCR_FSOFF = 0x40000
	// Position of FSPOL field.
	SAI_CH_FRCR_FSPOL_Pos = 0x11
	// Bit mask of FSPOL field.
	SAI_CH_FRCR_FSPOL_Msk = 0x20000
	// Bit FSPOL.
	SAI_CH_FRCR_FSPOL = 0x20000
	// Position of FSDEF field.
	SAI_CH_FRCR_FSDEF_Pos = 0x10
	// Bit mask of FSDEF field.
	SAI_CH_FRCR_FSDEF_Msk = 0x10000
	// Bit FSDEF.
	SAI_CH_FRCR_FSDEF = 0x10000
	// Position of FSALL field.
	SAI_CH_FRCR_FSALL_Pos = 0x8
	// Bit mask of FSALL field.
	SAI_CH_FRCR_FSALL_Msk = 0x7f00
	// Position of FRL field.
	SAI_CH_FRCR_FRL_Pos = 0x0
	// Bit mask of FRL field.
	SAI_CH_FRCR_FRL_Msk = 0xff

	// CH.SLOTR: ASlot register
	// Position of SLOTEN field.
	SAI_CH_SLOTR_SLOTEN_Pos = 0x10
	// Bit mask of SLOTEN field.
	SAI_CH_SLOTR_SLOTEN_Msk = 0xffff0000
	// Position of NBSLOT field.
	SAI_CH_SLOTR_NBSLOT_Pos = 0x8
	// Bit mask of NBSLOT field.
	SAI_CH_SLOTR_NBSLOT_Msk = 0xf00
	// Position of SLOTSZ field.
	SAI_CH_SLOTR_SLOTSZ_Pos = 0x6
	// Bit mask of SLOTSZ field.
	SAI_CH_SLOTR_SLOTSZ_Msk = 0xc0
	// Position of FBOFF field.
	SAI_CH_SLOTR_FBOFF_Pos = 0x0
	// Bit mask of FBOFF field.
	SAI_CH_SLOTR_FBOFF_Msk = 0x1f

	// CH.IM: AInterrupt mask register2
	// Position of LFSDETIE field.
	SAI_CH_IM_LFSDETIE_Pos = 0x6
	// Bit mask of LFSDETIE field.
	SAI_CH_IM_LFSDETIE_Msk = 0x40
	// Bit LFSDETIE.
	SAI_CH_IM_LFSDETIE = 0x40
	// Position of AFSDETIE field.
	SAI_CH_IM_AFSDETIE_Pos = 0x5
	// Bit mask of AFSDETIE field.
	SAI_CH_IM_AFSDETIE_Msk = 0x20
	// Bit AFSDETIE.
	SAI_CH_IM_AFSDETIE = 0x20
	// Position of CNRDYIE field.
	SAI_CH_IM_CNRDYIE_Pos = 0x4
	// Bit mask of CNRDYIE field.
	SAI_CH_IM_CNRDYIE_Msk = 0x10
	// Bit CNRDYIE.
	SAI_CH_IM_CNRDYIE = 0x10
	// Position of FREQIE field.
	SAI_CH_IM_FREQIE_Pos = 0x3
	// Bit mask of FREQIE field.
	SAI_CH_IM_FREQIE_Msk = 0x8
	// Bit FREQIE.
	SAI_CH_IM_FREQIE = 0x8
	// Position of WCKCFGIE field.
	SAI_CH_IM_WCKCFGIE_Pos = 0x2
	// Bit mask of WCKCFGIE field.
	SAI_CH_IM_WCKCFGIE_Msk = 0x4
	// Bit WCKCFGIE.
	SAI_CH_IM_WCKCFGIE = 0x4
	// Position of MUTEDETIE field.
	SAI_CH_IM_MUTEDETIE_Pos = 0x1
	// Bit mask of MUTEDETIE field.
	SAI_CH_IM_MUTEDETIE_Msk = 0x2
	// Bit MUTEDETIE.
	SAI_CH_IM_MUTEDETIE = 0x2
	// Position of OVRUDRIE field.
	SAI_CH_IM_OVRUDRIE_Pos = 0x0
	// Bit mask of OVRUDRIE field.
	SAI_CH_IM_OVRUDRIE_Msk = 0x1
	// Bit OVRUDRIE.
	SAI_CH_IM_OVRUDRIE = 0x1

	// CH.SR: AStatus register
	// Position of FLVL field.
	SAI_CH_SR_FLVL_Pos = 0x10
	// Bit mask of FLVL field.
	SAI_CH_SR_FLVL_Msk = 0x70000
	// Position of LFSDET field.
	SAI_CH_SR_LFSDET_Pos = 0x6
	// Bit mask of LFSDET field.
	SAI_CH_SR_LFSDET_Msk = 0x40
	// Bit LFSDET.
	SAI_CH_SR_LFSDET = 0x40
	// Position of AFSDET field.
	SAI_CH_SR_AFSDET_Pos = 0x5
	// Bit mask of AFSDET field.
	SAI_CH_SR_AFSDET_Msk = 0x20
	// Bit AFSDET.
	SAI_CH_SR_AFSDET = 0x20
	// Position of CNRDY field.
	SAI_CH_SR_CNRDY_Pos = 0x4
	// Bit mask of CNRDY field.
	SAI_CH_SR_CNRDY_Msk = 0x10
	// Bit CNRDY.
	SAI_CH_SR_CNRDY = 0x10
	// Position of FREQ field.
	SAI_CH_SR_FREQ_Pos = 0x3
	// Bit mask of FREQ field.
	SAI_CH_SR_FREQ_Msk = 0x8
	// Bit FREQ.
	SAI_CH_SR_FREQ = 0x8
	// Position of WCKCFG field.
	SAI_CH_SR_WCKCFG_Pos = 0x2
	// Bit mask of WCKCFG field.
	SAI_CH_SR_WCKCFG_Msk = 0x4
	// Bit WCKCFG.
	SAI_CH_SR_WCKCFG = 0x4
	// Position of MUTEDET field.
	SAI_CH_SR_MUTEDET_Pos = 0x1
	// Bit mask of MUTEDET field.
	SAI_CH_SR_MUTEDET_Msk = 0x2
	// Bit MUTEDET.
	SAI_CH_SR_MUTEDET = 0x2
	// Position of OVRUDR field.
	SAI_CH_SR_OVRUDR_Pos = 0x0
	// Bit mask of OVRUDR field.
	SAI_CH_SR_OVRUDR_Msk = 0x1
	// Bit OVRUDR.
	SAI_CH_SR_OVRUDR = 0x1

	// CH.CLRFR: AClear flag register
	// Position of CLFSDET field.
	SAI_CH_CLRFR_CLFSDET_Pos = 0x6
	// Bit mask of CLFSDET field.
	SAI_CH_CLRFR_CLFSDET_Msk = 0x40
	// Bit CLFSDET.
	SAI_CH_CLRFR_CLFSDET = 0x40
	// Position of CAFSDET field.
	SAI_CH_CLRFR_CAFSDET_Pos = 0x5
	// Bit mask of CAFSDET field.
	SAI_CH_CLRFR_CAFSDET_Msk = 0x20
	// Bit CAFSDET.
	SAI_CH_CLRFR_CAFSDET = 0x20
	// Position of CCNRDY field.
	SAI_CH_CLRFR_CCNRDY_Pos = 0x4
	// Bit mask of CCNRDY field.
	SAI_CH_CLRFR_CCNRDY_Msk = 0x10
	// Bit CCNRDY.
	SAI_CH_CLRFR_CCNRDY = 0x10
	// Position of CWCKCFG field.
	SAI_CH_CLRFR_CWCKCFG_Pos = 0x2
	// Bit mask of CWCKCFG field.
	SAI_CH_CLRFR_CWCKCFG_Msk = 0x4
	// Bit CWCKCFG.
	SAI_CH_CLRFR_CWCKCFG = 0x4
	// Position of CMUTEDET field.
	SAI_CH_CLRFR_CMUTEDET_Pos = 0x1
	// Bit mask of CMUTEDET field.
	SAI_CH_CLRFR_CMUTEDET_Msk = 0x2
	// Bit CMUTEDET.
	SAI_CH_CLRFR_CMUTEDET = 0x2
	// Position of COVRUDR field.
	SAI_CH_CLRFR_COVRUDR_Pos = 0x0
	// Bit mask of COVRUDR field.
	SAI_CH_CLRFR_COVRUDR_Msk = 0x1
	// Bit COVRUDR.
	SAI_CH_CLRFR_COVRUDR = 0x1

	// CH.DR: AData register
	// Position of DATA field.
	SAI_CH_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SAI_CH_DR_DATA_Msk = 0xffffffff

	// PDMCR: PDM control register
	// Position of CKEN4 field.
	SAI_PDMCR_CKEN4_Pos = 0xb
	// Bit mask of CKEN4 field.
	SAI_PDMCR_CKEN4_Msk = 0x800
	// Bit CKEN4.
	SAI_PDMCR_CKEN4 = 0x800
	// Position of CKEN3 field.
	SAI_PDMCR_CKEN3_Pos = 0xa
	// Bit mask of CKEN3 field.
	SAI_PDMCR_CKEN3_Msk = 0x400
	// Bit CKEN3.
	SAI_PDMCR_CKEN3 = 0x400
	// Position of CKEN2 field.
	SAI_PDMCR_CKEN2_Pos = 0x9
	// Bit mask of CKEN2 field.
	SAI_PDMCR_CKEN2_Msk = 0x200
	// Bit CKEN2.
	SAI_PDMCR_CKEN2 = 0x200
	// Position of CKEN1 field.
	SAI_PDMCR_CKEN1_Pos = 0x8
	// Bit mask of CKEN1 field.
	SAI_PDMCR_CKEN1_Msk = 0x100
	// Bit CKEN1.
	SAI_PDMCR_CKEN1 = 0x100
	// Position of MICNBR field.
	SAI_PDMCR_MICNBR_Pos = 0x4
	// Bit mask of MICNBR field.
	SAI_PDMCR_MICNBR_Msk = 0x30
	// Position of PDMEN field.
	SAI_PDMCR_PDMEN_Pos = 0x0
	// Bit mask of PDMEN field.
	SAI_PDMCR_PDMEN_Msk = 0x1
	// Bit PDMEN.
	SAI_PDMCR_PDMEN = 0x1

	// PDMDLY: PDM delay register
	// Position of DLYM4R field.
	SAI_PDMDLY_DLYM4R_Pos = 0x1c
	// Bit mask of DLYM4R field.
	SAI_PDMDLY_DLYM4R_Msk = 0x70000000
	// Position of DLYM4L field.
	SAI_PDMDLY_DLYM4L_Pos = 0x18
	// Bit mask of DLYM4L field.
	SAI_PDMDLY_DLYM4L_Msk = 0x7000000
	// Position of DLYM3R field.
	SAI_PDMDLY_DLYM3R_Pos = 0x14
	// Bit mask of DLYM3R field.
	SAI_PDMDLY_DLYM3R_Msk = 0x700000
	// Position of DLYM3L field.
	SAI_PDMDLY_DLYM3L_Pos = 0x10
	// Bit mask of DLYM3L field.
	SAI_PDMDLY_DLYM3L_Msk = 0x70000
	// Position of DLYM2R field.
	SAI_PDMDLY_DLYM2R_Pos = 0xc
	// Bit mask of DLYM2R field.
	SAI_PDMDLY_DLYM2R_Msk = 0x7000
	// Position of DLYM2L field.
	SAI_PDMDLY_DLYM2L_Pos = 0x8
	// Bit mask of DLYM2L field.
	SAI_PDMDLY_DLYM2L_Msk = 0x700
	// Position of DLYM1R field.
	SAI_PDMDLY_DLYM1R_Pos = 0x4
	// Bit mask of DLYM1R field.
	SAI_PDMDLY_DLYM1R_Msk = 0x70
	// Position of DLYM1L field.
	SAI_PDMDLY_DLYM1L_Pos = 0x0
	// Bit mask of DLYM1L field.
	SAI_PDMDLY_DLYM1L_Msk = 0x7
)

// Bitfields for TIM2: General-purpose-timers
const (
	// CR1: control register 1
	// Position of UIFREMAP field.
	TIM_CR1_UIFREMAP_Pos = 0xb
	// Bit mask of UIFREMAP field.
	TIM_CR1_UIFREMAP_Msk = 0x800
	// Bit UIFREMAP.
	TIM_CR1_UIFREMAP = 0x800
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// Position of CMS field.
	TIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_CR1_CMS_Msk = 0x60
	// Position of DIR field.
	TIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_CR1_DIR = 0x10
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1

	// CR2: control register 2
	// Position of TI1S field.
	TIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_CR2_TI1S = 0x80
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8

	// SMCR: slave mode control register
	// Position of SMS_3 field.
	TIM_SMCR_SMS_3_Pos = 0x10
	// Bit mask of SMS_3 field.
	TIM_SMCR_SMS_3_Msk = 0x10000
	// Bit SMS_3.
	TIM_SMCR_SMS_3 = 0x10000
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// Position of MSM field.
	TIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_SMCR_MSM = 0x80
	// Position of TS field.
	TIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	TIM_SMCR_TS_Msk = 0x70
	// Position of OCCS field.
	TIM_SMCR_OCCS_Pos = 0x3
	// Bit mask of OCCS field.
	TIM_SMCR_OCCS_Msk = 0x8
	// Bit OCCS.
	TIM_SMCR_OCCS = 0x8
	// Position of SMS field.
	TIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	TIM_SMCR_SMS_Msk = 0x7

	// DIER: DMA/Interrupt enable register
	// Position of CC4DE field.
	TIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_DIER_CC4DE = 0x1000
	// Position of CC3DE field.
	TIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_DIER_CC3DE = 0x800
	// Position of CC2DE field.
	TIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_DIER_CC2DE = 0x400
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Position of TIE field.
	TIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_DIER_TIE = 0x40
	// Position of CC4IE field.
	TIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_DIER_CC4IE = 0x10
	// Position of CC3IE field.
	TIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_DIER_CC3IE = 0x8
	// Position of CC2IE field.
	TIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_DIER_CC2IE = 0x4
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1

	// SR: status register
	// Position of CC4OF field.
	TIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_SR_CC4OF = 0x1000
	// Position of CC3OF field.
	TIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_SR_CC3OF = 0x800
	// Position of CC2OF field.
	TIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_SR_CC2OF = 0x400
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// Position of TIF field.
	TIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_SR_TIF = 0x40
	// Position of CC4IF field.
	TIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_SR_CC4IF = 0x10
	// Position of CC3IF field.
	TIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_SR_CC3IF = 0x8
	// Position of CC2IF field.
	TIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_SR_CC2IF = 0x4
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1

	// EGR: event generation register
	// Position of TG field.
	TIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_EGR_TG = 0x40
	// Position of CC4G field.
	TIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_EGR_CC4G = 0x10
	// Position of CC3G field.
	TIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_EGR_CC3G = 0x8
	// Position of CC2G field.
	TIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_EGR_CC2G = 0x4
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of OC2M_3 field.
	TIM_CCMR1_Output_OC2M_3_Pos = 0x18
	// Bit mask of OC2M_3 field.
	TIM_CCMR1_Output_OC2M_3_Msk = 0x1000000
	// Bit OC2M_3.
	TIM_CCMR1_Output_OC2M_3 = 0x1000000
	// Position of OC1M_3 field.
	TIM_CCMR1_Output_OC1M_3_Pos = 0x10
	// Bit mask of OC1M_3 field.
	TIM_CCMR1_Output_OC1M_3_Msk = 0x10000
	// Bit OC1M_3.
	TIM_CCMR1_Output_OC1M_3 = 0x10000
	// Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk = 0x7000
	// Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIM_CCMR1_Output_OC2PE = 0x800
	// Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIM_CCMR1_Output_OC2FE = 0x400
	// Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk = 0x300
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80
	// Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk = 0x70
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk = 0xf000
	// Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk = 0x300
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of OC4M_3 field.
	TIM_CCMR2_Output_OC4M_3_Pos = 0x18
	// Bit mask of OC4M_3 field.
	TIM_CCMR2_Output_OC4M_3_Msk = 0x1000000
	// Bit OC4M_3.
	TIM_CCMR2_Output_OC4M_3 = 0x1000000
	// Position of OC3M_3 field.
	TIM_CCMR2_Output_OC3M_3_Pos = 0x10
	// Bit mask of OC3M_3 field.
	TIM_CCMR2_Output_OC3M_3_Msk = 0x10000
	// Bit OC3M_3.
	TIM_CCMR2_Output_OC3M_3 = 0x10000
	// Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk = 0x7000
	// Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIM_CCMR2_Output_OC4PE = 0x800
	// Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIM_CCMR2_Output_OC4FE = 0x400
	// Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk = 0x300
	// Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIM_CCMR2_Output_OC3CE = 0x80
	// Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk = 0x70
	// Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIM_CCMR2_Output_OC3PE = 0x8
	// Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIM_CCMR2_Output_OC3FE = 0x4
	// Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk = 0x3

	// CCMR2_Input: capture/compare mode register 2 (input mode)
	// Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk = 0xf000
	// Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk = 0x300
	// Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk = 0x3

	// CCER: capture/compare enable register
	// Position of CC4NP field.
	TIM_CCER_CC4NP_Pos = 0xf
	// Bit mask of CC4NP field.
	TIM_CCER_CC4NP_Msk = 0x8000
	// Bit CC4NP.
	TIM_CCER_CC4NP = 0x8000
	// Position of CC4P field.
	TIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIM_CCER_CC4P = 0x2000
	// Position of CC4E field.
	TIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIM_CCER_CC4E = 0x1000
	// Position of CC3NP field.
	TIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIM_CCER_CC3NP = 0x800
	// Position of CC3P field.
	TIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIM_CCER_CC3P = 0x200
	// Position of CC3E field.
	TIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIM_CCER_CC3E = 0x100
	// Position of CC2NP field.
	TIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIM_CCER_CC2NP = 0x80
	// Position of CC2P field.
	TIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIM_CCER_CC2P = 0x20
	// Position of CC2E field.
	TIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIM_CCER_CC2E = 0x10
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1

	// CNT: counter
	// Position of CNT_H field.
	TIM_CNT_CNT_H_Pos = 0x10
	// Bit mask of CNT_H field.
	TIM_CNT_CNT_H_Msk = 0x7fff0000
	// Position of CNT_L field.
	TIM_CNT_CNT_L_Pos = 0x0
	// Bit mask of CNT_L field.
	TIM_CNT_CNT_L_Msk = 0xffff
	// Position of UIFCPY field.
	TIM_CNT_UIFCPY_Pos = 0x1f
	// Bit mask of UIFCPY field.
	TIM_CNT_UIFCPY_Msk = 0x80000000
	// Bit UIFCPY.
	TIM_CNT_UIFCPY = 0x80000000

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR_H field.
	TIM_ARR_ARR_H_Pos = 0x10
	// Bit mask of ARR_H field.
	TIM_ARR_ARR_H_Msk = 0xffff0000
	// Position of ARR_L field.
	TIM_ARR_ARR_L_Pos = 0x0
	// Bit mask of ARR_L field.
	TIM_ARR_ARR_L_Msk = 0xffff

	// CCR1: capture/compare register 1
	// Position of CCR1_H field.
	TIM_CCR1_CCR1_H_Pos = 0x10
	// Bit mask of CCR1_H field.
	TIM_CCR1_CCR1_H_Msk = 0xffff0000
	// Position of CCR1_L field.
	TIM_CCR1_CCR1_L_Pos = 0x0
	// Bit mask of CCR1_L field.
	TIM_CCR1_CCR1_L_Msk = 0xffff

	// CCR2: capture/compare register 2
	// Position of CCR2_H field.
	TIM_CCR2_CCR2_H_Pos = 0x10
	// Bit mask of CCR2_H field.
	TIM_CCR2_CCR2_H_Msk = 0xffff0000
	// Position of CCR2_L field.
	TIM_CCR2_CCR2_L_Pos = 0x0
	// Bit mask of CCR2_L field.
	TIM_CCR2_CCR2_L_Msk = 0xffff

	// CCR3: capture/compare register 3
	// Position of CCR3_H field.
	TIM_CCR3_CCR3_H_Pos = 0x10
	// Bit mask of CCR3_H field.
	TIM_CCR3_CCR3_H_Msk = 0xffff0000
	// Position of CCR3_L field.
	TIM_CCR3_CCR3_L_Pos = 0x0
	// Bit mask of CCR3_L field.
	TIM_CCR3_CCR3_L_Msk = 0xffff

	// CCR4: capture/compare register 4
	// Position of CCR4_H field.
	TIM_CCR4_CCR4_H_Pos = 0x10
	// Bit mask of CCR4_H field.
	TIM_CCR4_CCR4_H_Msk = 0xffff0000
	// Position of CCR4_L field.
	TIM_CCR4_CCR4_L_Pos = 0x0
	// Bit mask of CCR4_L field.
	TIM_CCR4_CCR4_L_Msk = 0xffff

	// DCR: DMA control register
	// Position of DBL field.
	TIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	TIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff

	// OR: TIM2 option register
	// Position of TI4_RMP field.
	TIM_OR_TI4_RMP_Pos = 0x2
	// Bit mask of TI4_RMP field.
	TIM_OR_TI4_RMP_Msk = 0xc
	// Position of ETR_RMP field.
	TIM_OR_ETR_RMP_Pos = 0x1
	// Bit mask of ETR_RMP field.
	TIM_OR_ETR_RMP_Msk = 0x2
	// Bit ETR_RMP.
	TIM_OR_ETR_RMP = 0x2
	// Position of ITR_RMP field.
	TIM_OR_ITR_RMP_Pos = 0x0
	// Bit mask of ITR_RMP field.
	TIM_OR_ITR_RMP_Msk = 0x1
	// Bit ITR_RMP.
	TIM_OR_ITR_RMP = 0x1

	// AF: TIM2 alternate function option register 1
	// Position of ETRSEL field.
	TIM_AF_ETRSEL_Pos = 0xe
	// Bit mask of ETRSEL field.
	TIM_AF_ETRSEL_Msk = 0x1c000
)

// Bitfields for LPTIM1: Low power timer
const (
	// ISR: Interrupt and Status Register
	// Position of DOWN field.
	LPTIM_ISR_DOWN_Pos = 0x6
	// Bit mask of DOWN field.
	LPTIM_ISR_DOWN_Msk = 0x40
	// Bit DOWN.
	LPTIM_ISR_DOWN = 0x40
	// Position of UP field.
	LPTIM_ISR_UP_Pos = 0x5
	// Bit mask of UP field.
	LPTIM_ISR_UP_Msk = 0x20
	// Bit UP.
	LPTIM_ISR_UP = 0x20
	// Position of ARROK field.
	LPTIM_ISR_ARROK_Pos = 0x4
	// Bit mask of ARROK field.
	LPTIM_ISR_ARROK_Msk = 0x10
	// Bit ARROK.
	LPTIM_ISR_ARROK = 0x10
	// Position of CMPOK field.
	LPTIM_ISR_CMPOK_Pos = 0x3
	// Bit mask of CMPOK field.
	LPTIM_ISR_CMPOK_Msk = 0x8
	// Bit CMPOK.
	LPTIM_ISR_CMPOK = 0x8
	// Position of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Pos = 0x2
	// Bit mask of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Msk = 0x4
	// Bit EXTTRIG.
	LPTIM_ISR_EXTTRIG = 0x4
	// Position of ARRM field.
	LPTIM_ISR_ARRM_Pos = 0x1
	// Bit mask of ARRM field.
	LPTIM_ISR_ARRM_Msk = 0x2
	// Bit ARRM.
	LPTIM_ISR_ARRM = 0x2
	// Position of CMPM field.
	LPTIM_ISR_CMPM_Pos = 0x0
	// Bit mask of CMPM field.
	LPTIM_ISR_CMPM_Msk = 0x1
	// Bit CMPM.
	LPTIM_ISR_CMPM = 0x1

	// ICR: Interrupt Clear Register
	// Position of DOWNCF field.
	LPTIM_ICR_DOWNCF_Pos = 0x6
	// Bit mask of DOWNCF field.
	LPTIM_ICR_DOWNCF_Msk = 0x40
	// Bit DOWNCF.
	LPTIM_ICR_DOWNCF = 0x40
	// Position of UPCF field.
	LPTIM_ICR_UPCF_Pos = 0x5
	// Bit mask of UPCF field.
	LPTIM_ICR_UPCF_Msk = 0x20
	// Bit UPCF.
	LPTIM_ICR_UPCF = 0x20
	// Position of ARROKCF field.
	LPTIM_ICR_ARROKCF_Pos = 0x4
	// Bit mask of ARROKCF field.
	LPTIM_ICR_ARROKCF_Msk = 0x10
	// Bit ARROKCF.
	LPTIM_ICR_ARROKCF = 0x10
	// Position of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Pos = 0x3
	// Bit mask of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Msk = 0x8
	// Bit CMPOKCF.
	LPTIM_ICR_CMPOKCF = 0x8
	// Position of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Pos = 0x2
	// Bit mask of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Msk = 0x4
	// Bit EXTTRIGCF.
	LPTIM_ICR_EXTTRIGCF = 0x4
	// Position of ARRMCF field.
	LPTIM_ICR_ARRMCF_Pos = 0x1
	// Bit mask of ARRMCF field.
	LPTIM_ICR_ARRMCF_Msk = 0x2
	// Bit ARRMCF.
	LPTIM_ICR_ARRMCF = 0x2
	// Position of CMPMCF field.
	LPTIM_ICR_CMPMCF_Pos = 0x0
	// Bit mask of CMPMCF field.
	LPTIM_ICR_CMPMCF_Msk = 0x1
	// Bit CMPMCF.
	LPTIM_ICR_CMPMCF = 0x1

	// IER: Interrupt Enable Register
	// Position of DOWNIE field.
	LPTIM_IER_DOWNIE_Pos = 0x6
	// Bit mask of DOWNIE field.
	LPTIM_IER_DOWNIE_Msk = 0x40
	// Bit DOWNIE.
	LPTIM_IER_DOWNIE = 0x40
	// Position of UPIE field.
	LPTIM_IER_UPIE_Pos = 0x5
	// Bit mask of UPIE field.
	LPTIM_IER_UPIE_Msk = 0x20
	// Bit UPIE.
	LPTIM_IER_UPIE = 0x20
	// Position of ARROKIE field.
	LPTIM_IER_ARROKIE_Pos = 0x4
	// Bit mask of ARROKIE field.
	LPTIM_IER_ARROKIE_Msk = 0x10
	// Bit ARROKIE.
	LPTIM_IER_ARROKIE = 0x10
	// Position of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Pos = 0x3
	// Bit mask of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Msk = 0x8
	// Bit CMPOKIE.
	LPTIM_IER_CMPOKIE = 0x8
	// Position of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Pos = 0x2
	// Bit mask of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Msk = 0x4
	// Bit EXTTRIGIE.
	LPTIM_IER_EXTTRIGIE = 0x4
	// Position of ARRMIE field.
	LPTIM_IER_ARRMIE_Pos = 0x1
	// Bit mask of ARRMIE field.
	LPTIM_IER_ARRMIE_Msk = 0x2
	// Bit ARRMIE.
	LPTIM_IER_ARRMIE = 0x2
	// Position of CMPMIE field.
	LPTIM_IER_CMPMIE_Pos = 0x0
	// Bit mask of CMPMIE field.
	LPTIM_IER_CMPMIE_Msk = 0x1
	// Bit CMPMIE.
	LPTIM_IER_CMPMIE = 0x1

	// CFGR: Configuration Register
	// Position of ENC field.
	LPTIM_CFGR_ENC_Pos = 0x18
	// Bit mask of ENC field.
	LPTIM_CFGR_ENC_Msk = 0x1000000
	// Bit ENC.
	LPTIM_CFGR_ENC = 0x1000000
	// Position of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Pos = 0x17
	// Bit mask of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Msk = 0x800000
	// Bit COUNTMODE.
	LPTIM_CFGR_COUNTMODE = 0x800000
	// Position of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Pos = 0x16
	// Bit mask of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Msk = 0x400000
	// Bit PRELOAD.
	LPTIM_CFGR_PRELOAD = 0x400000
	// Position of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Pos = 0x15
	// Bit mask of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Msk = 0x200000
	// Bit WAVPOL.
	LPTIM_CFGR_WAVPOL = 0x200000
	// Position of WAVE field.
	LPTIM_CFGR_WAVE_Pos = 0x14
	// Bit mask of WAVE field.
	LPTIM_CFGR_WAVE_Msk = 0x100000
	// Bit WAVE.
	LPTIM_CFGR_WAVE = 0x100000
	// Position of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Pos = 0x13
	// Bit mask of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Msk = 0x80000
	// Bit TIMOUT.
	LPTIM_CFGR_TIMOUT = 0x80000
	// Position of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Pos = 0x11
	// Bit mask of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Msk = 0x60000
	// Position of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Pos = 0xd
	// Bit mask of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Msk = 0xe000
	// Position of PRESC field.
	LPTIM_CFGR_PRESC_Pos = 0x9
	// Bit mask of PRESC field.
	LPTIM_CFGR_PRESC_Msk = 0xe00
	// Position of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Pos = 0x6
	// Bit mask of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Msk = 0xc0
	// Position of CKFLT field.
	LPTIM_CFGR_CKFLT_Pos = 0x3
	// Bit mask of CKFLT field.
	LPTIM_CFGR_CKFLT_Msk = 0x18
	// Position of CKPOL field.
	LPTIM_CFGR_CKPOL_Pos = 0x1
	// Bit mask of CKPOL field.
	LPTIM_CFGR_CKPOL_Msk = 0x6
	// Position of CKSEL field.
	LPTIM_CFGR_CKSEL_Pos = 0x0
	// Bit mask of CKSEL field.
	LPTIM_CFGR_CKSEL_Msk = 0x1
	// Bit CKSEL.
	LPTIM_CFGR_CKSEL = 0x1

	// CR: Control Register
	// Position of RSTARE field.
	LPTIM_CR_RSTARE_Pos = 0x4
	// Bit mask of RSTARE field.
	LPTIM_CR_RSTARE_Msk = 0x10
	// Bit RSTARE.
	LPTIM_CR_RSTARE = 0x10
	// Position of COUNTRST field.
	LPTIM_CR_COUNTRST_Pos = 0x3
	// Bit mask of COUNTRST field.
	LPTIM_CR_COUNTRST_Msk = 0x8
	// Bit COUNTRST.
	LPTIM_CR_COUNTRST = 0x8
	// Position of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Pos = 0x2
	// Bit mask of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Msk = 0x4
	// Bit CNTSTRT.
	LPTIM_CR_CNTSTRT = 0x4
	// Position of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Pos = 0x1
	// Bit mask of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Msk = 0x2
	// Bit SNGSTRT.
	LPTIM_CR_SNGSTRT = 0x2
	// Position of ENABLE field.
	LPTIM_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	LPTIM_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	LPTIM_CR_ENABLE = 0x1

	// CMP: Compare Register
	// Position of CMP field.
	LPTIM_CMP_CMP_Pos = 0x0
	// Bit mask of CMP field.
	LPTIM_CMP_CMP_Msk = 0xffff

	// ARR: Autoreload Register
	// Position of ARR field.
	LPTIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	LPTIM_ARR_ARR_Msk = 0xffff

	// CNT: Counter Register
	// Position of CNT field.
	LPTIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	LPTIM_CNT_CNT_Msk = 0xffff

	// OR: Option Register
	// Position of OR1 field.
	LPTIM_OR_OR1_Pos = 0x0
	// Bit mask of OR1 field.
	LPTIM_OR_OR1_Msk = 0x1
	// Bit OR1.
	LPTIM_OR_OR1 = 0x1
	// Position of OR2 field.
	LPTIM_OR_OR2_Pos = 0x1
	// Bit mask of OR2 field.
	LPTIM_OR_OR2_Msk = 0x2
	// Bit OR2.
	LPTIM_OR_OR2 = 0x2
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	// Position of RXFFIE field.
	USART_CR1_RXFFIE_Pos = 0x1f
	// Bit mask of RXFFIE field.
	USART_CR1_RXFFIE_Msk = 0x80000000
	// Bit RXFFIE.
	USART_CR1_RXFFIE = 0x80000000
	// Position of TXFEIE field.
	USART_CR1_TXFEIE_Pos = 0x1e
	// Bit mask of TXFEIE field.
	USART_CR1_TXFEIE_Msk = 0x40000000
	// Bit TXFEIE.
	USART_CR1_TXFEIE = 0x40000000
	// Position of FIFOEN field.
	USART_CR1_FIFOEN_Pos = 0x1d
	// Bit mask of FIFOEN field.
	USART_CR1_FIFOEN_Msk = 0x20000000
	// Bit FIFOEN.
	USART_CR1_FIFOEN = 0x20000000
	// Position of M1 field.
	USART_CR1_M1_Pos = 0x1c
	// Bit mask of M1 field.
	USART_CR1_M1_Msk = 0x10000000
	// Bit M1.
	USART_CR1_M1 = 0x10000000
	// Position of EOBIE field.
	USART_CR1_EOBIE_Pos = 0x1b
	// Bit mask of EOBIE field.
	USART_CR1_EOBIE_Msk = 0x8000000
	// Bit EOBIE.
	USART_CR1_EOBIE = 0x8000000
	// Position of RTOIE field.
	USART_CR1_RTOIE_Pos = 0x1a
	// Bit mask of RTOIE field.
	USART_CR1_RTOIE_Msk = 0x4000000
	// Bit RTOIE.
	USART_CR1_RTOIE = 0x4000000
	// Position of DEAT4 field.
	USART_CR1_DEAT4_Pos = 0x19
	// Bit mask of DEAT4 field.
	USART_CR1_DEAT4_Msk = 0x2000000
	// Bit DEAT4.
	USART_CR1_DEAT4 = 0x2000000
	// Position of DEAT3 field.
	USART_CR1_DEAT3_Pos = 0x18
	// Bit mask of DEAT3 field.
	USART_CR1_DEAT3_Msk = 0x1000000
	// Bit DEAT3.
	USART_CR1_DEAT3 = 0x1000000
	// Position of DEAT2 field.
	USART_CR1_DEAT2_Pos = 0x17
	// Bit mask of DEAT2 field.
	USART_CR1_DEAT2_Msk = 0x800000
	// Bit DEAT2.
	USART_CR1_DEAT2 = 0x800000
	// Position of DEAT1 field.
	USART_CR1_DEAT1_Pos = 0x16
	// Bit mask of DEAT1 field.
	USART_CR1_DEAT1_Msk = 0x400000
	// Bit DEAT1.
	USART_CR1_DEAT1 = 0x400000
	// Position of DEAT0 field.
	USART_CR1_DEAT0_Pos = 0x15
	// Bit mask of DEAT0 field.
	USART_CR1_DEAT0_Msk = 0x200000
	// Bit DEAT0.
	USART_CR1_DEAT0 = 0x200000
	// Position of DEDT4 field.
	USART_CR1_DEDT4_Pos = 0x14
	// Bit mask of DEDT4 field.
	USART_CR1_DEDT4_Msk = 0x100000
	// Bit DEDT4.
	USART_CR1_DEDT4 = 0x100000
	// Position of DEDT3 field.
	USART_CR1_DEDT3_Pos = 0x13
	// Bit mask of DEDT3 field.
	USART_CR1_DEDT3_Msk = 0x80000
	// Bit DEDT3.
	USART_CR1_DEDT3 = 0x80000
	// Position of DEDT2 field.
	USART_CR1_DEDT2_Pos = 0x12
	// Bit mask of DEDT2 field.
	USART_CR1_DEDT2_Msk = 0x40000
	// Bit DEDT2.
	USART_CR1_DEDT2 = 0x40000
	// Position of DEDT1 field.
	USART_CR1_DEDT1_Pos = 0x11
	// Bit mask of DEDT1 field.
	USART_CR1_DEDT1_Msk = 0x20000
	// Bit DEDT1.
	USART_CR1_DEDT1 = 0x20000
	// Position of DEDT0 field.
	USART_CR1_DEDT0_Pos = 0x10
	// Bit mask of DEDT0 field.
	USART_CR1_DEDT0_Msk = 0x10000
	// Bit DEDT0.
	USART_CR1_DEDT0 = 0x10000
	// Position of OVER8 field.
	USART_CR1_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_OVER8 = 0x8000
	// Position of CMIE field.
	USART_CR1_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_CMIE = 0x4000
	// Position of MME field.
	USART_CR1_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_MME = 0x2000
	// Position of M0 field.
	USART_CR1_M0_Pos = 0xc
	// Bit mask of M0 field.
	USART_CR1_M0_Msk = 0x1000
	// Bit M0.
	USART_CR1_M0 = 0x1000
	// Position of WAKE field.
	USART_CR1_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_WAKE = 0x800
	// Position of PCE field.
	USART_CR1_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_PCE = 0x400
	// Position of PS field.
	USART_CR1_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_PS = 0x200
	// Position of PEIE field.
	USART_CR1_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_PEIE = 0x100
	// Position of TXEIE field.
	USART_CR1_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_TXEIE = 0x80
	// Position of TCIE field.
	USART_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_TCIE = 0x40
	// Position of RXNEIE field.
	USART_CR1_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_RXNEIE = 0x20
	// Position of IDLEIE field.
	USART_CR1_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_IDLEIE = 0x10
	// Position of TE field.
	USART_CR1_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_TE = 0x8
	// Position of RE field.
	USART_CR1_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_RE = 0x4
	// Position of UESM field.
	USART_CR1_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_UESM = 0x2
	// Position of UE field.
	USART_CR1_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_UE = 0x1

	// CR2: Control register 2
	// Position of ADD4_7 field.
	USART_CR2_ADD4_7_Pos = 0x1c
	// Bit mask of ADD4_7 field.
	USART_CR2_ADD4_7_Msk = 0xf0000000
	// Position of ADD0_3 field.
	USART_CR2_ADD0_3_Pos = 0x18
	// Bit mask of ADD0_3 field.
	USART_CR2_ADD0_3_Msk = 0xf000000
	// Position of RTOEN field.
	USART_CR2_RTOEN_Pos = 0x17
	// Bit mask of RTOEN field.
	USART_CR2_RTOEN_Msk = 0x800000
	// Bit RTOEN.
	USART_CR2_RTOEN = 0x800000
	// Position of ABRMOD1 field.
	USART_CR2_ABRMOD1_Pos = 0x16
	// Bit mask of ABRMOD1 field.
	USART_CR2_ABRMOD1_Msk = 0x400000
	// Bit ABRMOD1.
	USART_CR2_ABRMOD1 = 0x400000
	// Position of ABRMOD0 field.
	USART_CR2_ABRMOD0_Pos = 0x15
	// Bit mask of ABRMOD0 field.
	USART_CR2_ABRMOD0_Msk = 0x200000
	// Bit ABRMOD0.
	USART_CR2_ABRMOD0 = 0x200000
	// Position of ABREN field.
	USART_CR2_ABREN_Pos = 0x14
	// Bit mask of ABREN field.
	USART_CR2_ABREN_Msk = 0x100000
	// Bit ABREN.
	USART_CR2_ABREN = 0x100000
	// Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Pos = 0x13
	// Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000
	// Bit MSBFIRST.
	USART_CR2_MSBFIRST = 0x80000
	// Position of TAINV field.
	USART_CR2_TAINV_Pos = 0x12
	// Bit mask of TAINV field.
	USART_CR2_TAINV_Msk = 0x40000
	// Bit TAINV.
	USART_CR2_TAINV = 0x40000
	// Position of TXINV field.
	USART_CR2_TXINV_Pos = 0x11
	// Bit mask of TXINV field.
	USART_CR2_TXINV_Msk = 0x20000
	// Bit TXINV.
	USART_CR2_TXINV = 0x20000
	// Position of RXINV field.
	USART_CR2_RXINV_Pos = 0x10
	// Bit mask of RXINV field.
	USART_CR2_RXINV_Msk = 0x10000
	// Bit RXINV.
	USART_CR2_RXINV = 0x10000
	// Position of SWAP field.
	USART_CR2_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	USART_CR2_SWAP_Msk = 0x8000
	// Bit SWAP.
	USART_CR2_SWAP = 0x8000
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// Position of ADDM7 field.
	USART_CR2_ADDM7_Pos = 0x4
	// Bit mask of ADDM7 field.
	USART_CR2_ADDM7_Msk = 0x10
	// Bit ADDM7.
	USART_CR2_ADDM7 = 0x10
	// Position of DIS_NSS field.
	USART_CR2_DIS_NSS_Pos = 0x3
	// Bit mask of DIS_NSS field.
	USART_CR2_DIS_NSS_Msk = 0x8
	// Bit DIS_NSS.
	USART_CR2_DIS_NSS = 0x8
	// Position of SLVEN field.
	USART_CR2_SLVEN_Pos = 0x0
	// Bit mask of SLVEN field.
	USART_CR2_SLVEN_Msk = 0x1
	// Bit SLVEN.
	USART_CR2_SLVEN = 0x1

	// CR3: Control register 3
	// Position of TXFTCFG field.
	USART_CR3_TXFTCFG_Pos = 0x1d
	// Bit mask of TXFTCFG field.
	USART_CR3_TXFTCFG_Msk = 0xe0000000
	// Position of RXFTIE field.
	USART_CR3_RXFTIE_Pos = 0x1c
	// Bit mask of RXFTIE field.
	USART_CR3_RXFTIE_Msk = 0x10000000
	// Bit RXFTIE.
	USART_CR3_RXFTIE = 0x10000000
	// Position of RXFTCFG field.
	USART_CR3_RXFTCFG_Pos = 0x19
	// Bit mask of RXFTCFG field.
	USART_CR3_RXFTCFG_Msk = 0xe000000
	// Position of TCBGTIE field.
	USART_CR3_TCBGTIE_Pos = 0x18
	// Bit mask of TCBGTIE field.
	USART_CR3_TCBGTIE_Msk = 0x1000000
	// Bit TCBGTIE.
	USART_CR3_TCBGTIE = 0x1000000
	// Position of TXFTIE field.
	USART_CR3_TXFTIE_Pos = 0x17
	// Bit mask of TXFTIE field.
	USART_CR3_TXFTIE_Msk = 0x800000
	// Bit TXFTIE.
	USART_CR3_TXFTIE = 0x800000
	// Position of WUFIE field.
	USART_CR3_WUFIE_Pos = 0x16
	// Bit mask of WUFIE field.
	USART_CR3_WUFIE_Msk = 0x400000
	// Bit WUFIE.
	USART_CR3_WUFIE = 0x400000
	// Position of WUS field.
	USART_CR3_WUS_Pos = 0x14
	// Bit mask of WUS field.
	USART_CR3_WUS_Msk = 0x300000
	// Position of SCARCNT field.
	USART_CR3_SCARCNT_Pos = 0x11
	// Bit mask of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000
	// Position of DEP field.
	USART_CR3_DEP_Pos = 0xf
	// Bit mask of DEP field.
	USART_CR3_DEP_Msk = 0x8000
	// Bit DEP.
	USART_CR3_DEP = 0x8000
	// Position of DEM field.
	USART_CR3_DEM_Pos = 0xe
	// Bit mask of DEM field.
	USART_CR3_DEM_Msk = 0x4000
	// Bit DEM.
	USART_CR3_DEM = 0x4000
	// Position of DDRE field.
	USART_CR3_DDRE_Pos = 0xd
	// Bit mask of DDRE field.
	USART_CR3_DDRE_Msk = 0x2000
	// Bit DDRE.
	USART_CR3_DDRE = 0x2000
	// Position of OVRDIS field.
	USART_CR3_OVRDIS_Pos = 0xc
	// Bit mask of OVRDIS field.
	USART_CR3_OVRDIS_Msk = 0x1000
	// Bit OVRDIS.
	USART_CR3_OVRDIS = 0x1000
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1

	// BRR: Baud rate register
	// Position of BRR field.
	USART_BRR_BRR_Pos = 0x0
	// Bit mask of BRR field.
	USART_BRR_BRR_Msk = 0xffff

	// GTPR: Guard time and prescaler register
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff

	// RTOR: Receiver timeout register
	// Position of BLEN field.
	USART_RTOR_BLEN_Pos = 0x18
	// Bit mask of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000
	// Position of RTO field.
	USART_RTOR_RTO_Pos = 0x0
	// Bit mask of RTO field.
	USART_RTOR_RTO_Msk = 0xffffff

	// RQR: Request register
	// Position of TXFRQ field.
	USART_RQR_TXFRQ_Pos = 0x4
	// Bit mask of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10
	// Bit TXFRQ.
	USART_RQR_TXFRQ = 0x10
	// Position of RXFRQ field.
	USART_RQR_RXFRQ_Pos = 0x3
	// Bit mask of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8
	// Bit RXFRQ.
	USART_RQR_RXFRQ = 0x8
	// Position of MMRQ field.
	USART_RQR_MMRQ_Pos = 0x2
	// Bit mask of MMRQ field.
	USART_RQR_MMRQ_Msk = 0x4
	// Bit MMRQ.
	USART_RQR_MMRQ = 0x4
	// Position of SBKRQ field.
	USART_RQR_SBKRQ_Pos = 0x1
	// Bit mask of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2
	// Bit SBKRQ.
	USART_RQR_SBKRQ = 0x2
	// Position of ABRRQ field.
	USART_RQR_ABRRQ_Pos = 0x0
	// Bit mask of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1
	// Bit ABRRQ.
	USART_RQR_ABRRQ = 0x1

	// ISR: Interrupt & status register
	// Position of TXFT field.
	USART_ISR_TXFT_Pos = 0x1b
	// Bit mask of TXFT field.
	USART_ISR_TXFT_Msk = 0x8000000
	// Bit TXFT.
	USART_ISR_TXFT = 0x8000000
	// Position of RXFT field.
	USART_ISR_RXFT_Pos = 0x1a
	// Bit mask of RXFT field.
	USART_ISR_RXFT_Msk = 0x4000000
	// Bit RXFT.
	USART_ISR_RXFT = 0x4000000
	// Position of TCBGT field.
	USART_ISR_TCBGT_Pos = 0x19
	// Bit mask of TCBGT field.
	USART_ISR_TCBGT_Msk = 0x2000000
	// Bit TCBGT.
	USART_ISR_TCBGT = 0x2000000
	// Position of RXFF field.
	USART_ISR_RXFF_Pos = 0x18
	// Bit mask of RXFF field.
	USART_ISR_RXFF_Msk = 0x1000000
	// Bit RXFF.
	USART_ISR_RXFF = 0x1000000
	// Position of TXFE field.
	USART_ISR_TXFE_Pos = 0x17
	// Bit mask of TXFE field.
	USART_ISR_TXFE_Msk = 0x800000
	// Bit TXFE.
	USART_ISR_TXFE = 0x800000
	// Position of REACK field.
	USART_ISR_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_REACK = 0x400000
	// Position of TEACK field.
	USART_ISR_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_TEACK = 0x200000
	// Position of WUF field.
	USART_ISR_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_WUF = 0x100000
	// Position of RWU field.
	USART_ISR_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_RWU = 0x80000
	// Position of SBKF field.
	USART_ISR_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_SBKF = 0x40000
	// Position of CMF field.
	USART_ISR_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_CMF = 0x20000
	// Position of BUSY field.
	USART_ISR_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_BUSY = 0x10000
	// Position of ABRF field.
	USART_ISR_ABRF_Pos = 0xf
	// Bit mask of ABRF field.
	USART_ISR_ABRF_Msk = 0x8000
	// Bit ABRF.
	USART_ISR_ABRF = 0x8000
	// Position of ABRE field.
	USART_ISR_ABRE_Pos = 0xe
	// Bit mask of ABRE field.
	USART_ISR_ABRE_Msk = 0x4000
	// Bit ABRE.
	USART_ISR_ABRE = 0x4000
	// Position of UDR field.
	USART_ISR_UDR_Pos = 0xd
	// Bit mask of UDR field.
	USART_ISR_UDR_Msk = 0x2000
	// Bit UDR.
	USART_ISR_UDR = 0x2000
	// Position of EOBF field.
	USART_ISR_EOBF_Pos = 0xc
	// Bit mask of EOBF field.
	USART_ISR_EOBF_Msk = 0x1000
	// Bit EOBF.
	USART_ISR_EOBF = 0x1000
	// Position of RTOF field.
	USART_ISR_RTOF_Pos = 0xb
	// Bit mask of RTOF field.
	USART_ISR_RTOF_Msk = 0x800
	// Bit RTOF.
	USART_ISR_RTOF = 0x800
	// Position of CTS field.
	USART_ISR_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_CTS = 0x400
	// Position of CTSIF field.
	USART_ISR_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_CTSIF = 0x200
	// Position of LBDF field.
	USART_ISR_LBDF_Pos = 0x8
	// Bit mask of LBDF field.
	USART_ISR_LBDF_Msk = 0x100
	// Bit LBDF.
	USART_ISR_LBDF = 0x100
	// Position of TXE field.
	USART_ISR_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_ISR_TXE_Msk = 0x80
	// Bit TXE.
	USART_ISR_TXE = 0x80
	// Position of TC field.
	USART_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_TC = 0x40
	// Position of RXNE field.
	USART_ISR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_ISR_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_ISR_RXNE = 0x20
	// Position of IDLE field.
	USART_ISR_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_IDLE = 0x10
	// Position of ORE field.
	USART_ISR_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_ORE = 0x8
	// Position of NF field.
	USART_ISR_NF_Pos = 0x2
	// Bit mask of NF field.
	USART_ISR_NF_Msk = 0x4
	// Bit NF.
	USART_ISR_NF = 0x4
	// Position of FE field.
	USART_ISR_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_FE = 0x2
	// Position of PE field.
	USART_ISR_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_PE = 0x1

	// ICR: Interrupt flag clear register
	// Position of WUCF field.
	USART_ICR_WUCF_Pos = 0x14
	// Bit mask of WUCF field.
	USART_ICR_WUCF_Msk = 0x100000
	// Bit WUCF.
	USART_ICR_WUCF = 0x100000
	// Position of CMCF field.
	USART_ICR_CMCF_Pos = 0x11
	// Bit mask of CMCF field.
	USART_ICR_CMCF_Msk = 0x20000
	// Bit CMCF.
	USART_ICR_CMCF = 0x20000
	// Position of UDRCF field.
	USART_ICR_UDRCF_Pos = 0xd
	// Bit mask of UDRCF field.
	USART_ICR_UDRCF_Msk = 0x2000
	// Bit UDRCF.
	USART_ICR_UDRCF = 0x2000
	// Position of EOBCF field.
	USART_ICR_EOBCF_Pos = 0xc
	// Bit mask of EOBCF field.
	USART_ICR_EOBCF_Msk = 0x1000
	// Bit EOBCF.
	USART_ICR_EOBCF = 0x1000
	// Position of RTOCF field.
	USART_ICR_RTOCF_Pos = 0xb
	// Bit mask of RTOCF field.
	USART_ICR_RTOCF_Msk = 0x800
	// Bit RTOCF.
	USART_ICR_RTOCF = 0x800
	// Position of CTSCF field.
	USART_ICR_CTSCF_Pos = 0x9
	// Bit mask of CTSCF field.
	USART_ICR_CTSCF_Msk = 0x200
	// Bit CTSCF.
	USART_ICR_CTSCF = 0x200
	// Position of LBDCF field.
	USART_ICR_LBDCF_Pos = 0x8
	// Bit mask of LBDCF field.
	USART_ICR_LBDCF_Msk = 0x100
	// Bit LBDCF.
	USART_ICR_LBDCF = 0x100
	// Position of TCBGTCF field.
	USART_ICR_TCBGTCF_Pos = 0x7
	// Bit mask of TCBGTCF field.
	USART_ICR_TCBGTCF_Msk = 0x80
	// Bit TCBGTCF.
	USART_ICR_TCBGTCF = 0x80
	// Position of TCCF field.
	USART_ICR_TCCF_Pos = 0x6
	// Bit mask of TCCF field.
	USART_ICR_TCCF_Msk = 0x40
	// Bit TCCF.
	USART_ICR_TCCF = 0x40
	// Position of TXFECF field.
	USART_ICR_TXFECF_Pos = 0x5
	// Bit mask of TXFECF field.
	USART_ICR_TXFECF_Msk = 0x20
	// Bit TXFECF.
	USART_ICR_TXFECF = 0x20
	// Position of IDLECF field.
	USART_ICR_IDLECF_Pos = 0x4
	// Bit mask of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10
	// Bit IDLECF.
	USART_ICR_IDLECF = 0x10
	// Position of ORECF field.
	USART_ICR_ORECF_Pos = 0x3
	// Bit mask of ORECF field.
	USART_ICR_ORECF_Msk = 0x8
	// Bit ORECF.
	USART_ICR_ORECF = 0x8
	// Position of NCF field.
	USART_ICR_NCF_Pos = 0x2
	// Bit mask of NCF field.
	USART_ICR_NCF_Msk = 0x4
	// Bit NCF.
	USART_ICR_NCF = 0x4
	// Position of FECF field.
	USART_ICR_FECF_Pos = 0x1
	// Bit mask of FECF field.
	USART_ICR_FECF_Msk = 0x2
	// Bit FECF.
	USART_ICR_FECF = 0x2
	// Position of PECF field.
	USART_ICR_PECF_Pos = 0x0
	// Bit mask of PECF field.
	USART_ICR_PECF_Msk = 0x1
	// Bit PECF.
	USART_ICR_PECF = 0x1

	// RDR: Receive data register
	// Position of RDR field.
	USART_RDR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_RDR_RDR_Msk = 0x1ff

	// TDR: Transmit data register
	// Position of TDR field.
	USART_TDR_TDR_Pos = 0x0
	// Bit mask of TDR field.
	USART_TDR_TDR_Msk = 0x1ff

	// PRESC: Prescaler register
	// Position of PRESCALER field.
	USART_PRESC_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	USART_PRESC_PRESCALER_Msk = 0xf
)

// Bitfields for SPI1: Serial peripheral interface/Inter-IC sound
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Position of DFF field.
	SPI_CR1_DFF_Pos = 0xb
	// Bit mask of DFF field.
	SPI_CR1_DFF_Msk = 0x800
	// Bit DFF.
	SPI_CR1_DFF = 0x800
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1

	// CR2: control register 2
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// Position of NSSP field.
	SPI_CR2_NSSP_Pos = 0x3
	// Bit mask of NSSP field.
	SPI_CR2_NSSP_Msk = 0x8
	// Bit NSSP.
	SPI_CR2_NSSP = 0x8
	// Position of FRF field.
	SPI_CR2_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR2_FRF_Msk = 0x10
	// Bit FRF.
	SPI_CR2_FRF = 0x10
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// Position of DS field.
	SPI_CR2_DS_Pos = 0x8
	// Bit mask of DS field.
	SPI_CR2_DS_Msk = 0xf00
	// Position of FRXTH field.
	SPI_CR2_FRXTH_Pos = 0xc
	// Bit mask of FRXTH field.
	SPI_CR2_FRXTH_Msk = 0x1000
	// Bit FRXTH.
	SPI_CR2_FRXTH = 0x1000
	// Position of LDMA_RX field.
	SPI_CR2_LDMA_RX_Pos = 0xd
	// Bit mask of LDMA_RX field.
	SPI_CR2_LDMA_RX_Msk = 0x2000
	// Bit LDMA_RX.
	SPI_CR2_LDMA_RX = 0x2000
	// Position of LDMA_TX field.
	SPI_CR2_LDMA_TX_Pos = 0xe
	// Bit mask of LDMA_TX field.
	SPI_CR2_LDMA_TX_Msk = 0x4000
	// Bit LDMA_TX.
	SPI_CR2_LDMA_TX = 0x4000

	// SR: status register
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// Position of TIFRFE field.
	SPI_SR_TIFRFE_Pos = 0x8
	// Bit mask of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100
	// Bit TIFRFE.
	SPI_SR_TIFRFE = 0x100
	// Position of FRLVL field.
	SPI_SR_FRLVL_Pos = 0x9
	// Bit mask of FRLVL field.
	SPI_SR_FRLVL_Msk = 0x600
	// Position of FTLVL field.
	SPI_SR_FTLVL_Pos = 0xb
	// Bit mask of FTLVL field.
	SPI_SR_FTLVL_Msk = 0x1800

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff
)

// Bitfields for VREFBUF: Voltage reference buffer
const (
	// CSR: VREF control and status register
	// Position of ENVR field.
	VREF_CSR_ENVR_Pos = 0x0
	// Bit mask of ENVR field.
	VREF_CSR_ENVR_Msk = 0x1
	// Bit ENVR.
	VREF_CSR_ENVR = 0x1
	// Position of HIZ field.
	VREF_CSR_HIZ_Pos = 0x1
	// Bit mask of HIZ field.
	VREF_CSR_HIZ_Msk = 0x2
	// Bit HIZ.
	VREF_CSR_HIZ = 0x2
	// Position of VRS field.
	VREF_CSR_VRS_Pos = 0x2
	// Bit mask of VRS field.
	VREF_CSR_VRS_Msk = 0x4
	// Bit VRS.
	VREF_CSR_VRS = 0x4
	// Position of VRR field.
	VREF_CSR_VRR_Pos = 0x3
	// Bit mask of VRR field.
	VREF_CSR_VRR_Msk = 0x8
	// Bit VRR.
	VREF_CSR_VRR = 0x8

	// CCR: calibration control register
	// Position of TRIM field.
	VREF_CCR_TRIM_Pos = 0x0
	// Bit mask of TRIM field.
	VREF_CCR_TRIM_Msk = 0x3f
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	// Position of PM field.
	RTC_TR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TR_PM = 0x400000
	// Position of HT field.
	RTC_TR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TR_SU_Msk = 0xf

	// DR: date register
	// Position of YT field.
	RTC_DR_YT_Pos = 0x14
	// Bit mask of YT field.
	RTC_DR_YT_Msk = 0xf00000
	// Position of YU field.
	RTC_DR_YU_Pos = 0x10
	// Bit mask of YU field.
	RTC_DR_YU_Msk = 0xf0000
	// Position of WDU field.
	RTC_DR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_DR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_DR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_DR_MT_Msk = 0x1000
	// Bit MT.
	RTC_DR_MT = 0x1000
	// Position of MU field.
	RTC_DR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_DR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_DR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_DR_DT_Msk = 0x30
	// Position of DU field.
	RTC_DR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_DR_DU_Msk = 0xf

	// CR: control register
	// Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Pos = 0x0
	// Bit mask of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7
	// Position of TSEDGE field.
	RTC_CR_TSEDGE_Pos = 0x3
	// Bit mask of TSEDGE field.
	RTC_CR_TSEDGE_Msk = 0x8
	// Bit TSEDGE.
	RTC_CR_TSEDGE = 0x8
	// Position of REFCKON field.
	RTC_CR_REFCKON_Pos = 0x4
	// Bit mask of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10
	// Bit REFCKON.
	RTC_CR_REFCKON = 0x10
	// Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Pos = 0x5
	// Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20
	// Bit BYPSHAD.
	RTC_CR_BYPSHAD = 0x20
	// Position of FMT field.
	RTC_CR_FMT_Pos = 0x6
	// Bit mask of FMT field.
	RTC_CR_FMT_Msk = 0x40
	// Bit FMT.
	RTC_CR_FMT = 0x40
	// Position of ALRAE field.
	RTC_CR_ALRAE_Pos = 0x8
	// Bit mask of ALRAE field.
	RTC_CR_ALRAE_Msk = 0x100
	// Bit ALRAE.
	RTC_CR_ALRAE = 0x100
	// Position of ALRBE field.
	RTC_CR_ALRBE_Pos = 0x9
	// Bit mask of ALRBE field.
	RTC_CR_ALRBE_Msk = 0x200
	// Bit ALRBE.
	RTC_CR_ALRBE = 0x200
	// Position of WUTE field.
	RTC_CR_WUTE_Pos = 0xa
	// Bit mask of WUTE field.
	RTC_CR_WUTE_Msk = 0x400
	// Bit WUTE.
	RTC_CR_WUTE = 0x400
	// Position of TSE field.
	RTC_CR_TSE_Pos = 0xb
	// Bit mask of TSE field.
	RTC_CR_TSE_Msk = 0x800
	// Bit TSE.
	RTC_CR_TSE = 0x800
	// Position of ALRAIE field.
	RTC_CR_ALRAIE_Pos = 0xc
	// Bit mask of ALRAIE field.
	RTC_CR_ALRAIE_Msk = 0x1000
	// Bit ALRAIE.
	RTC_CR_ALRAIE = 0x1000
	// Position of ALRBIE field.
	RTC_CR_ALRBIE_Pos = 0xd
	// Bit mask of ALRBIE field.
	RTC_CR_ALRBIE_Msk = 0x2000
	// Bit ALRBIE.
	RTC_CR_ALRBIE = 0x2000
	// Position of WUTIE field.
	RTC_CR_WUTIE_Pos = 0xe
	// Bit mask of WUTIE field.
	RTC_CR_WUTIE_Msk = 0x4000
	// Bit WUTIE.
	RTC_CR_WUTIE = 0x4000
	// Position of TSIE field.
	RTC_CR_TSIE_Pos = 0xf
	// Bit mask of TSIE field.
	RTC_CR_TSIE_Msk = 0x8000
	// Bit TSIE.
	RTC_CR_TSIE = 0x8000
	// Position of ADD1H field.
	RTC_CR_ADD1H_Pos = 0x10
	// Bit mask of ADD1H field.
	RTC_CR_ADD1H_Msk = 0x10000
	// Bit ADD1H.
	RTC_CR_ADD1H = 0x10000
	// Position of SUB1H field.
	RTC_CR_SUB1H_Pos = 0x11
	// Bit mask of SUB1H field.
	RTC_CR_SUB1H_Msk = 0x20000
	// Bit SUB1H.
	RTC_CR_SUB1H = 0x20000
	// Position of BKP field.
	RTC_CR_BKP_Pos = 0x12
	// Bit mask of BKP field.
	RTC_CR_BKP_Msk = 0x40000
	// Bit BKP.
	RTC_CR_BKP = 0x40000
	// Position of COSEL field.
	RTC_CR_COSEL_Pos = 0x13
	// Bit mask of COSEL field.
	RTC_CR_COSEL_Msk = 0x80000
	// Bit COSEL.
	RTC_CR_COSEL = 0x80000
	// Position of POL field.
	RTC_CR_POL_Pos = 0x14
	// Bit mask of POL field.
	RTC_CR_POL_Msk = 0x100000
	// Bit POL.
	RTC_CR_POL = 0x100000
	// Position of OSEL field.
	RTC_CR_OSEL_Pos = 0x15
	// Bit mask of OSEL field.
	RTC_CR_OSEL_Msk = 0x600000
	// Position of COE field.
	RTC_CR_COE_Pos = 0x17
	// Bit mask of COE field.
	RTC_CR_COE_Msk = 0x800000
	// Bit COE.
	RTC_CR_COE = 0x800000
	// Position of ITSE field.
	RTC_CR_ITSE_Pos = 0x18
	// Bit mask of ITSE field.
	RTC_CR_ITSE_Msk = 0x1000000
	// Bit ITSE.
	RTC_CR_ITSE = 0x1000000

	// ISR: initialization and status register
	// Position of ALRAWF field.
	RTC_ISR_ALRAWF_Pos = 0x0
	// Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF_Msk = 0x1
	// Bit ALRAWF.
	RTC_ISR_ALRAWF = 0x1
	// Position of ALRBWF field.
	RTC_ISR_ALRBWF_Pos = 0x1
	// Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF_Msk = 0x2
	// Bit ALRBWF.
	RTC_ISR_ALRBWF = 0x2
	// Position of WUTWF field.
	RTC_ISR_WUTWF_Pos = 0x2
	// Bit mask of WUTWF field.
	RTC_ISR_WUTWF_Msk = 0x4
	// Bit WUTWF.
	RTC_ISR_WUTWF = 0x4
	// Position of SHPF field.
	RTC_ISR_SHPF_Pos = 0x3
	// Bit mask of SHPF field.
	RTC_ISR_SHPF_Msk = 0x8
	// Bit SHPF.
	RTC_ISR_SHPF = 0x8
	// Position of INITS field.
	RTC_ISR_INITS_Pos = 0x4
	// Bit mask of INITS field.
	RTC_ISR_INITS_Msk = 0x10
	// Bit INITS.
	RTC_ISR_INITS = 0x10
	// Position of RSF field.
	RTC_ISR_RSF_Pos = 0x5
	// Bit mask of RSF field.
	RTC_ISR_RSF_Msk = 0x20
	// Bit RSF.
	RTC_ISR_RSF = 0x20
	// Position of INITF field.
	RTC_ISR_INITF_Pos = 0x6
	// Bit mask of INITF field.
	RTC_ISR_INITF_Msk = 0x40
	// Bit INITF.
	RTC_ISR_INITF = 0x40
	// Position of INIT field.
	RTC_ISR_INIT_Pos = 0x7
	// Bit mask of INIT field.
	RTC_ISR_INIT_Msk = 0x80
	// Bit INIT.
	RTC_ISR_INIT = 0x80
	// Position of ALRAF field.
	RTC_ISR_ALRAF_Pos = 0x8
	// Bit mask of ALRAF field.
	RTC_ISR_ALRAF_Msk = 0x100
	// Bit ALRAF.
	RTC_ISR_ALRAF = 0x100
	// Position of ALRBF field.
	RTC_ISR_ALRBF_Pos = 0x9
	// Bit mask of ALRBF field.
	RTC_ISR_ALRBF_Msk = 0x200
	// Bit ALRBF.
	RTC_ISR_ALRBF = 0x200
	// Position of WUTF field.
	RTC_ISR_WUTF_Pos = 0xa
	// Bit mask of WUTF field.
	RTC_ISR_WUTF_Msk = 0x400
	// Bit WUTF.
	RTC_ISR_WUTF = 0x400
	// Position of TSF field.
	RTC_ISR_TSF_Pos = 0xb
	// Bit mask of TSF field.
	RTC_ISR_TSF_Msk = 0x800
	// Bit TSF.
	RTC_ISR_TSF = 0x800
	// Position of TSOVF field.
	RTC_ISR_TSOVF_Pos = 0xc
	// Bit mask of TSOVF field.
	RTC_ISR_TSOVF_Msk = 0x1000
	// Bit TSOVF.
	RTC_ISR_TSOVF = 0x1000
	// Position of TAMP1F field.
	RTC_ISR_TAMP1F_Pos = 0xd
	// Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F_Msk = 0x2000
	// Bit TAMP1F.
	RTC_ISR_TAMP1F = 0x2000
	// Position of TAMP2F field.
	RTC_ISR_TAMP2F_Pos = 0xe
	// Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F_Msk = 0x4000
	// Bit TAMP2F.
	RTC_ISR_TAMP2F = 0x4000
	// Position of TAMP3F field.
	RTC_ISR_TAMP3F_Pos = 0xf
	// Bit mask of TAMP3F field.
	RTC_ISR_TAMP3F_Msk = 0x8000
	// Bit TAMP3F.
	RTC_ISR_TAMP3F = 0x8000
	// Position of RECALPF field.
	RTC_ISR_RECALPF_Pos = 0x10
	// Bit mask of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000
	// Bit RECALPF.
	RTC_ISR_RECALPF = 0x10000
	// Position of ITSF field.
	RTC_ISR_ITSF_Pos = 0x11
	// Bit mask of ITSF field.
	RTC_ISR_ITSF_Msk = 0x20000
	// Bit ITSF.
	RTC_ISR_ITSF = 0x20000

	// PRER: prescaler register
	// Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Pos = 0x10
	// Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000
	// Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Pos = 0x0
	// Bit mask of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff

	// WUTR: wakeup timer register
	// Position of WUT field.
	RTC_WUTR_WUT_Pos = 0x0
	// Bit mask of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff

	// ALRMAR: alarm A register
	// Position of MSK4 field.
	RTC_ALRMAR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMAR_MSK4 = 0x80000000
	// Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMAR_WDSEL = 0x40000000
	// Position of DT field.
	RTC_ALRMAR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMAR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMAR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMAR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMAR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMAR_MSK3 = 0x800000
	// Position of PM field.
	RTC_ALRMAR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMAR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMAR_PM = 0x400000
	// Position of HT field.
	RTC_ALRMAR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMAR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMAR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMAR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMAR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMAR_MSK2 = 0x8000
	// Position of MNT field.
	RTC_ALRMAR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMAR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMAR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMAR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMAR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMAR_MSK1 = 0x80
	// Position of ST field.
	RTC_ALRMAR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMAR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMAR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMAR_SU_Msk = 0xf

	// ALRMBR: alarm B register
	// Position of MSK4 field.
	RTC_ALRMBR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMBR_MSK4 = 0x80000000
	// Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMBR_WDSEL = 0x40000000
	// Position of DT field.
	RTC_ALRMBR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMBR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMBR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMBR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMBR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMBR_MSK3 = 0x800000
	// Position of PM field.
	RTC_ALRMBR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMBR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMBR_PM = 0x400000
	// Position of HT field.
	RTC_ALRMBR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMBR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMBR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMBR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMBR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMBR_MSK2 = 0x8000
	// Position of MNT field.
	RTC_ALRMBR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMBR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMBR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMBR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMBR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMBR_MSK1 = 0x80
	// Position of ST field.
	RTC_ALRMBR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMBR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMBR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMBR_SU_Msk = 0xf

	// WPR: write protection register
	// Position of KEY field.
	RTC_WPR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	RTC_WPR_KEY_Msk = 0xff

	// SSR: sub second register
	// Position of SS field.
	RTC_SSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_SSR_SS_Msk = 0xffff

	// SHIFTR: shift control register
	// Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Pos = 0x1f
	// Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000
	// Bit ADD1S.
	RTC_SHIFTR_ADD1S = 0x80000000
	// Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Pos = 0x0
	// Bit mask of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff

	// TSTR: time stamp time register
	// Position of SU field.
	RTC_TSTR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TSTR_SU_Msk = 0xf
	// Position of ST field.
	RTC_TSTR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TSTR_ST_Msk = 0x70
	// Position of MNU field.
	RTC_TSTR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00
	// Position of MNT field.
	RTC_TSTR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000
	// Position of HU field.
	RTC_TSTR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TSTR_HU_Msk = 0xf0000
	// Position of HT field.
	RTC_TSTR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TSTR_HT_Msk = 0x300000
	// Position of PM field.
	RTC_TSTR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TSTR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TSTR_PM = 0x400000

	// TSDR: time stamp date register
	// Position of WDU field.
	RTC_TSDR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_TSDR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_TSDR_MT_Msk = 0x1000
	// Bit MT.
	RTC_TSDR_MT = 0x1000
	// Position of MU field.
	RTC_TSDR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_TSDR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_TSDR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_TSDR_DT_Msk = 0x30
	// Position of DU field.
	RTC_TSDR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_TSDR_DU_Msk = 0xf

	// TSSSR: timestamp sub second register
	// Position of SS field.
	RTC_TSSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_TSSSR_SS_Msk = 0xffff

	// CALR: calibration register
	// Position of CALP field.
	RTC_CALR_CALP_Pos = 0xf
	// Bit mask of CALP field.
	RTC_CALR_CALP_Msk = 0x8000
	// Bit CALP.
	RTC_CALR_CALP = 0x8000
	// Position of CALW8 field.
	RTC_CALR_CALW8_Pos = 0xe
	// Bit mask of CALW8 field.
	RTC_CALR_CALW8_Msk = 0x4000
	// Bit CALW8.
	RTC_CALR_CALW8 = 0x4000
	// Position of CALW16 field.
	RTC_CALR_CALW16_Pos = 0xd
	// Bit mask of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000
	// Bit CALW16.
	RTC_CALR_CALW16 = 0x2000
	// Position of CALM field.
	RTC_CALR_CALM_Pos = 0x0
	// Bit mask of CALM field.
	RTC_CALR_CALM_Msk = 0x1ff

	// TAMPCR: tamper configuration register
	// Position of TAMP1E field.
	RTC_TAMPCR_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	RTC_TAMPCR_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	RTC_TAMPCR_TAMP1E = 0x1
	// Position of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG_Pos = 0x1
	// Bit mask of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG_Msk = 0x2
	// Bit TAMP1TRG.
	RTC_TAMPCR_TAMP1TRG = 0x2
	// Position of TAMPIE field.
	RTC_TAMPCR_TAMPIE_Pos = 0x2
	// Bit mask of TAMPIE field.
	RTC_TAMPCR_TAMPIE_Msk = 0x4
	// Bit TAMPIE.
	RTC_TAMPCR_TAMPIE = 0x4
	// Position of TAMP2E field.
	RTC_TAMPCR_TAMP2E_Pos = 0x3
	// Bit mask of TAMP2E field.
	RTC_TAMPCR_TAMP2E_Msk = 0x8
	// Bit TAMP2E.
	RTC_TAMPCR_TAMP2E = 0x8
	// Position of TAMP2TRG field.
	RTC_TAMPCR_TAMP2TRG_Pos = 0x4
	// Bit mask of TAMP2TRG field.
	RTC_TAMPCR_TAMP2TRG_Msk = 0x10
	// Bit TAMP2TRG.
	RTC_TAMPCR_TAMP2TRG = 0x10
	// Position of TAMP3E field.
	RTC_TAMPCR_TAMP3E_Pos = 0x5
	// Bit mask of TAMP3E field.
	RTC_TAMPCR_TAMP3E_Msk = 0x20
	// Bit TAMP3E.
	RTC_TAMPCR_TAMP3E = 0x20
	// Position of TAMP3TRG field.
	RTC_TAMPCR_TAMP3TRG_Pos = 0x6
	// Bit mask of TAMP3TRG field.
	RTC_TAMPCR_TAMP3TRG_Msk = 0x40
	// Bit TAMP3TRG.
	RTC_TAMPCR_TAMP3TRG = 0x40
	// Position of TAMPTS field.
	RTC_TAMPCR_TAMPTS_Pos = 0x7
	// Bit mask of TAMPTS field.
	RTC_TAMPCR_TAMPTS_Msk = 0x80
	// Bit TAMPTS.
	RTC_TAMPCR_TAMPTS = 0x80
	// Position of TAMPFREQ field.
	RTC_TAMPCR_TAMPFREQ_Pos = 0x8
	// Bit mask of TAMPFREQ field.
	RTC_TAMPCR_TAMPFREQ_Msk = 0x700
	// Position of TAMPFLT field.
	RTC_TAMPCR_TAMPFLT_Pos = 0xb
	// Bit mask of TAMPFLT field.
	RTC_TAMPCR_TAMPFLT_Msk = 0x1800
	// Position of TAMPPRCH field.
	RTC_TAMPCR_TAMPPRCH_Pos = 0xd
	// Bit mask of TAMPPRCH field.
	RTC_TAMPCR_TAMPPRCH_Msk = 0x6000
	// Position of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS_Pos = 0xf
	// Bit mask of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS_Msk = 0x8000
	// Bit TAMPPUDIS.
	RTC_TAMPCR_TAMPPUDIS = 0x8000
	// Position of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE_Pos = 0x10
	// Bit mask of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE_Msk = 0x10000
	// Bit TAMP1IE.
	RTC_TAMPCR_TAMP1IE = 0x10000
	// Position of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE_Pos = 0x11
	// Bit mask of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE_Msk = 0x20000
	// Bit TAMP1NOERASE.
	RTC_TAMPCR_TAMP1NOERASE = 0x20000
	// Position of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF_Pos = 0x12
	// Bit mask of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF_Msk = 0x40000
	// Bit TAMP1MF.
	RTC_TAMPCR_TAMP1MF = 0x40000
	// Position of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE_Pos = 0x13
	// Bit mask of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE_Msk = 0x80000
	// Bit TAMP2IE.
	RTC_TAMPCR_TAMP2IE = 0x80000
	// Position of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE_Pos = 0x14
	// Bit mask of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE_Msk = 0x100000
	// Bit TAMP2NOERASE.
	RTC_TAMPCR_TAMP2NOERASE = 0x100000
	// Position of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF_Pos = 0x15
	// Bit mask of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF_Msk = 0x200000
	// Bit TAMP2MF.
	RTC_TAMPCR_TAMP2MF = 0x200000
	// Position of TAMP3IE field.
	RTC_TAMPCR_TAMP3IE_Pos = 0x16
	// Bit mask of TAMP3IE field.
	RTC_TAMPCR_TAMP3IE_Msk = 0x400000
	// Bit TAMP3IE.
	RTC_TAMPCR_TAMP3IE = 0x400000
	// Position of TAMP3NOERASE field.
	RTC_TAMPCR_TAMP3NOERASE_Pos = 0x17
	// Bit mask of TAMP3NOERASE field.
	RTC_TAMPCR_TAMP3NOERASE_Msk = 0x800000
	// Bit TAMP3NOERASE.
	RTC_TAMPCR_TAMP3NOERASE = 0x800000
	// Position of TAMP3MF field.
	RTC_TAMPCR_TAMP3MF_Pos = 0x18
	// Bit mask of TAMP3MF field.
	RTC_TAMPCR_TAMP3MF_Msk = 0x1000000
	// Bit TAMP3MF.
	RTC_TAMPCR_TAMP3MF = 0x1000000

	// ALRMASSR: alarm A sub second register
	// Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMASSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMASSR_SS_Msk = 0x7fff

	// ALRMBSSR: alarm B sub second register
	// Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMBSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMBSSR_SS_Msk = 0x7fff

	// OR: option register
	// Position of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE_Pos = 0x0
	// Bit mask of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE_Msk = 0x1
	// Bit RTC_ALARM_TYPE.
	RTC_OR_RTC_ALARM_TYPE = 0x1
	// Position of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP_Pos = 0x1
	// Bit mask of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP_Msk = 0x2
	// Bit RTC_OUT_RMP.
	RTC_OR_RTC_OUT_RMP = 0x2

	// BKP0R: backup register
	// Position of BKP field.
	RTC_BKP0R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP0R_BKP_Msk = 0xffffffff

	// BKP1R: backup register
	// Position of BKP field.
	RTC_BKP1R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP1R_BKP_Msk = 0xffffffff

	// BKP2R: backup register
	// Position of BKP field.
	RTC_BKP2R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP2R_BKP_Msk = 0xffffffff

	// BKP3R: backup register
	// Position of BKP field.
	RTC_BKP3R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP3R_BKP_Msk = 0xffffffff

	// BKP4R: backup register
	// Position of BKP field.
	RTC_BKP4R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP4R_BKP_Msk = 0xffffffff

	// BKP5R: backup register
	// Position of BKP field.
	RTC_BKP5R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP5R_BKP_Msk = 0xffffffff

	// BKP6R: backup register
	// Position of BKP field.
	RTC_BKP6R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP6R_BKP_Msk = 0xffffffff

	// BKP7R: backup register
	// Position of BKP field.
	RTC_BKP7R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP7R_BKP_Msk = 0xffffffff

	// BKP8R: backup register
	// Position of BKP field.
	RTC_BKP8R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP8R_BKP_Msk = 0xffffffff

	// BKP9R: backup register
	// Position of BKP field.
	RTC_BKP9R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP9R_BKP_Msk = 0xffffffff

	// BKP10R: backup register
	// Position of BKP field.
	RTC_BKP10R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP10R_BKP_Msk = 0xffffffff

	// BKP11R: backup register
	// Position of BKP field.
	RTC_BKP11R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP11R_BKP_Msk = 0xffffffff

	// BKP12R: backup register
	// Position of BKP field.
	RTC_BKP12R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP12R_BKP_Msk = 0xffffffff

	// BKP13R: backup register
	// Position of BKP field.
	RTC_BKP13R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP13R_BKP_Msk = 0xffffffff

	// BKP14R: backup register
	// Position of BKP field.
	RTC_BKP14R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP14R_BKP_Msk = 0xffffffff

	// BKP15R: backup register
	// Position of BKP field.
	RTC_BKP15R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP15R_BKP_Msk = 0xffffffff

	// BKP16R: backup register
	// Position of BKP field.
	RTC_BKP16R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP16R_BKP_Msk = 0xffffffff

	// BKP17R: backup register
	// Position of BKP field.
	RTC_BKP17R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP17R_BKP_Msk = 0xffffffff

	// BKP18R: backup register
	// Position of BKP field.
	RTC_BKP18R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP18R_BKP_Msk = 0xffffffff

	// BKP19R: backup register
	// Position of BKP field.
	RTC_BKP19R_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKP19R_BKP_Msk = 0xffffffff
)

// Bitfields for DBGMCU: Debug support
const (
	// IDCODE: MCU Device ID Code Register
	// Position of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Msk = 0xfff
	// Position of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: Debug MCU Configuration Register
	// Position of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Pos = 0x0
	// Bit mask of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Msk = 0x1
	// Bit DBG_SLEEP.
	DBGMCU_CR_DBG_SLEEP = 0x1
	// Position of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBGMCU_CR_DBG_STOP = 0x2
	// Position of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBGMCU_CR_DBG_STANDBY = 0x4
	// Position of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN_Pos = 0x5
	// Bit mask of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN_Msk = 0x20
	// Bit TRACE_IOEN.
	DBGMCU_CR_TRACE_IOEN = 0x20
	// Position of TRGOEN field.
	DBGMCU_CR_TRGOEN_Pos = 0x1c
	// Bit mask of TRGOEN field.
	DBGMCU_CR_TRGOEN_Msk = 0x10000000
	// Bit TRGOEN.
	DBGMCU_CR_TRGOEN = 0x10000000

	// APB1FZR1: APB1 Low Freeze Register CPU1
	// Position of DBG_TIMER2_STOP field.
	DBGMCU_APB1FZR1_DBG_TIMER2_STOP_Pos = 0x0
	// Bit mask of DBG_TIMER2_STOP field.
	DBGMCU_APB1FZR1_DBG_TIMER2_STOP_Msk = 0x1
	// Bit DBG_TIMER2_STOP.
	DBGMCU_APB1FZR1_DBG_TIMER2_STOP = 0x1
	// Position of DBG_RTC_STOP field.
	DBGMCU_APB1FZR1_DBG_RTC_STOP_Pos = 0xa
	// Bit mask of DBG_RTC_STOP field.
	DBGMCU_APB1FZR1_DBG_RTC_STOP_Msk = 0x400
	// Bit DBG_RTC_STOP.
	DBGMCU_APB1FZR1_DBG_RTC_STOP = 0x400
	// Position of DBG_WWDG_STOP field.
	DBGMCU_APB1FZR1_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBGMCU_APB1FZR1_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBGMCU_APB1FZR1_DBG_WWDG_STOP = 0x800
	// Position of DBG_IWDG_STOP field.
	DBGMCU_APB1FZR1_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBGMCU_APB1FZR1_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBGMCU_APB1FZR1_DBG_IWDG_STOP = 0x1000
	// Position of DBG_I2C1_STOP field.
	DBGMCU_APB1FZR1_DBG_I2C1_STOP_Pos = 0x15
	// Bit mask of DBG_I2C1_STOP field.
	DBGMCU_APB1FZR1_DBG_I2C1_STOP_Msk = 0x200000
	// Bit DBG_I2C1_STOP.
	DBGMCU_APB1FZR1_DBG_I2C1_STOP = 0x200000
	// Position of DBG_I2C3_STOP field.
	DBGMCU_APB1FZR1_DBG_I2C3_STOP_Pos = 0x17
	// Bit mask of DBG_I2C3_STOP field.
	DBGMCU_APB1FZR1_DBG_I2C3_STOP_Msk = 0x800000
	// Bit DBG_I2C3_STOP.
	DBGMCU_APB1FZR1_DBG_I2C3_STOP = 0x800000
	// Position of DBG_LPTIM1_STOP field.
	DBGMCU_APB1FZR1_DBG_LPTIM1_STOP_Pos = 0x1f
	// Bit mask of DBG_LPTIM1_STOP field.
	DBGMCU_APB1FZR1_DBG_LPTIM1_STOP_Msk = 0x80000000
	// Bit DBG_LPTIM1_STOP.
	DBGMCU_APB1FZR1_DBG_LPTIM1_STOP = 0x80000000

	// C2AP_B1FZR1: APB1 Low Freeze Register CPU2
	// Position of DBG_LPTIM2_STOP field.
	DBGMCU_C2AP_B1FZR1_DBG_LPTIM2_STOP_Pos = 0x0
	// Bit mask of DBG_LPTIM2_STOP field.
	DBGMCU_C2AP_B1FZR1_DBG_LPTIM2_STOP_Msk = 0x1
	// Bit DBG_LPTIM2_STOP.
	DBGMCU_C2AP_B1FZR1_DBG_LPTIM2_STOP = 0x1
	// Position of DBG_RTC_STOP field.
	DBGMCU_C2AP_B1FZR1_DBG_RTC_STOP_Pos = 0xa
	// Bit mask of DBG_RTC_STOP field.
	DBGMCU_C2AP_B1FZR1_DBG_RTC_STOP_Msk = 0x400
	// Bit DBG_RTC_STOP.
	DBGMCU_C2AP_B1FZR1_DBG_RTC_STOP = 0x400
	// Position of DBG_IWDG_STOP field.
	DBGMCU_C2AP_B1FZR1_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBGMCU_C2AP_B1FZR1_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBGMCU_C2AP_B1FZR1_DBG_IWDG_STOP = 0x1000
	// Position of DBG_I2C1_STOP field.
	DBGMCU_C2AP_B1FZR1_DBG_I2C1_STOP_Pos = 0x15
	// Bit mask of DBG_I2C1_STOP field.
	DBGMCU_C2AP_B1FZR1_DBG_I2C1_STOP_Msk = 0x200000
	// Bit DBG_I2C1_STOP.
	DBGMCU_C2AP_B1FZR1_DBG_I2C1_STOP = 0x200000
	// Position of DBG_I2C3_STOP field.
	DBGMCU_C2AP_B1FZR1_DBG_I2C3_STOP_Pos = 0x17
	// Bit mask of DBG_I2C3_STOP field.
	DBGMCU_C2AP_B1FZR1_DBG_I2C3_STOP_Msk = 0x800000
	// Bit DBG_I2C3_STOP.
	DBGMCU_C2AP_B1FZR1_DBG_I2C3_STOP = 0x800000
	// Position of DBG_LPTIM1_STOP field.
	DBGMCU_C2AP_B1FZR1_DBG_LPTIM1_STOP_Pos = 0x1f
	// Bit mask of DBG_LPTIM1_STOP field.
	DBGMCU_C2AP_B1FZR1_DBG_LPTIM1_STOP_Msk = 0x80000000
	// Bit DBG_LPTIM1_STOP.
	DBGMCU_C2AP_B1FZR1_DBG_LPTIM1_STOP = 0x80000000

	// APB1FZR2: APB1 High Freeze Register CPU1
	// Position of DBG_LPTIM2_STOP field.
	DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Pos = 0x5
	// Bit mask of DBG_LPTIM2_STOP field.
	DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Msk = 0x20
	// Bit DBG_LPTIM2_STOP.
	DBGMCU_APB1FZR2_DBG_LPTIM2_STOP = 0x20

	// C2APB1FZR2: APB1 High Freeze Register CPU2
	// Position of DBG_LPTIM2_STOP field.
	DBGMCU_C2APB1FZR2_DBG_LPTIM2_STOP_Pos = 0x5
	// Bit mask of DBG_LPTIM2_STOP field.
	DBGMCU_C2APB1FZR2_DBG_LPTIM2_STOP_Msk = 0x20
	// Bit DBG_LPTIM2_STOP.
	DBGMCU_C2APB1FZR2_DBG_LPTIM2_STOP = 0x20

	// C2APB2FZR: APB2 Freeze Register CPU2
	// Position of DBG_TIM1_STOP field.
	DBGMCU_C2APB2FZR_DBG_TIM1_STOP_Pos = 0xb
	// Bit mask of DBG_TIM1_STOP field.
	DBGMCU_C2APB2FZR_DBG_TIM1_STOP_Msk = 0x800
	// Bit DBG_TIM1_STOP.
	DBGMCU_C2APB2FZR_DBG_TIM1_STOP = 0x800
	// Position of DBG_TIM16_STOP field.
	DBGMCU_C2APB2FZR_DBG_TIM16_STOP_Pos = 0x11
	// Bit mask of DBG_TIM16_STOP field.
	DBGMCU_C2APB2FZR_DBG_TIM16_STOP_Msk = 0x20000
	// Bit DBG_TIM16_STOP.
	DBGMCU_C2APB2FZR_DBG_TIM16_STOP = 0x20000
	// Position of DBG_TIM17_STOP field.
	DBGMCU_C2APB2FZR_DBG_TIM17_STOP_Pos = 0x12
	// Bit mask of DBG_TIM17_STOP field.
	DBGMCU_C2APB2FZR_DBG_TIM17_STOP_Msk = 0x40000
	// Bit DBG_TIM17_STOP.
	DBGMCU_C2APB2FZR_DBG_TIM17_STOP = 0x40000

	// APB2FZR: APB2 Freeze Register CPU1
	// Position of DBG_TIM1_STOP field.
	DBGMCU_APB2FZR_DBG_TIM1_STOP_Pos = 0xb
	// Bit mask of DBG_TIM1_STOP field.
	DBGMCU_APB2FZR_DBG_TIM1_STOP_Msk = 0x800
	// Bit DBG_TIM1_STOP.
	DBGMCU_APB2FZR_DBG_TIM1_STOP = 0x800
	// Position of DBG_TIM16_STOP field.
	DBGMCU_APB2FZR_DBG_TIM16_STOP_Pos = 0x11
	// Bit mask of DBG_TIM16_STOP field.
	DBGMCU_APB2FZR_DBG_TIM16_STOP_Msk = 0x20000
	// Bit DBG_TIM16_STOP.
	DBGMCU_APB2FZR_DBG_TIM16_STOP = 0x20000
	// Position of DBG_TIM17_STOP field.
	DBGMCU_APB2FZR_DBG_TIM17_STOP_Pos = 0x12
	// Bit mask of DBG_TIM17_STOP field.
	DBGMCU_APB2FZR_DBG_TIM17_STOP_Msk = 0x40000
	// Bit DBG_TIM17_STOP.
	DBGMCU_APB2FZR_DBG_TIM17_STOP = 0x40000
)

// Bitfields for PKA: PKA
const (
	// CR: Control register
	// Position of ADDRERRIE field.
	PKA_CR_ADDRERRIE_Pos = 0x14
	// Bit mask of ADDRERRIE field.
	PKA_CR_ADDRERRIE_Msk = 0x100000
	// Bit ADDRERRIE.
	PKA_CR_ADDRERRIE = 0x100000
	// Position of RAMERRIE field.
	PKA_CR_RAMERRIE_Pos = 0x13
	// Bit mask of RAMERRIE field.
	PKA_CR_RAMERRIE_Msk = 0x80000
	// Bit RAMERRIE.
	PKA_CR_RAMERRIE = 0x80000
	// Position of PROCENDIE field.
	PKA_CR_PROCENDIE_Pos = 0x11
	// Bit mask of PROCENDIE field.
	PKA_CR_PROCENDIE_Msk = 0x20000
	// Bit PROCENDIE.
	PKA_CR_PROCENDIE = 0x20000
	// Position of MODE field.
	PKA_CR_MODE_Pos = 0x8
	// Bit mask of MODE field.
	PKA_CR_MODE_Msk = 0x3f00
	// Position of SECLVL field.
	PKA_CR_SECLVL_Pos = 0x2
	// Bit mask of SECLVL field.
	PKA_CR_SECLVL_Msk = 0x4
	// Bit SECLVL.
	PKA_CR_SECLVL = 0x4
	// Position of START field.
	PKA_CR_START_Pos = 0x1
	// Bit mask of START field.
	PKA_CR_START_Msk = 0x2
	// Bit START.
	PKA_CR_START = 0x2
	// Position of EN field.
	PKA_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	PKA_CR_EN_Msk = 0x1
	// Bit EN.
	PKA_CR_EN = 0x1

	// SR: PKA status register
	// Position of ADDRERRF field.
	PKA_SR_ADDRERRF_Pos = 0x14
	// Bit mask of ADDRERRF field.
	PKA_SR_ADDRERRF_Msk = 0x100000
	// Bit ADDRERRF.
	PKA_SR_ADDRERRF = 0x100000
	// Position of RAMERRF field.
	PKA_SR_RAMERRF_Pos = 0x13
	// Bit mask of RAMERRF field.
	PKA_SR_RAMERRF_Msk = 0x80000
	// Bit RAMERRF.
	PKA_SR_RAMERRF = 0x80000
	// Position of PROCENDF field.
	PKA_SR_PROCENDF_Pos = 0x11
	// Bit mask of PROCENDF field.
	PKA_SR_PROCENDF_Msk = 0x20000
	// Bit PROCENDF.
	PKA_SR_PROCENDF = 0x20000
	// Position of BUSY field.
	PKA_SR_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	PKA_SR_BUSY_Msk = 0x10000
	// Bit BUSY.
	PKA_SR_BUSY = 0x10000

	// CLRFR: PKA clear flag register
	// Position of ADDRERRFC field.
	PKA_CLRFR_ADDRERRFC_Pos = 0x14
	// Bit mask of ADDRERRFC field.
	PKA_CLRFR_ADDRERRFC_Msk = 0x100000
	// Bit ADDRERRFC.
	PKA_CLRFR_ADDRERRFC = 0x100000
	// Position of RAMERRFC field.
	PKA_CLRFR_RAMERRFC_Pos = 0x13
	// Bit mask of RAMERRFC field.
	PKA_CLRFR_RAMERRFC_Msk = 0x80000
	// Bit RAMERRFC.
	PKA_CLRFR_RAMERRFC = 0x80000
	// Position of PROCENDFC field.
	PKA_CLRFR_PROCENDFC_Pos = 0x11
	// Bit mask of PROCENDFC field.
	PKA_CLRFR_PROCENDFC_Msk = 0x20000
	// Bit PROCENDFC.
	PKA_CLRFR_PROCENDFC = 0x20000

	// VERR: PKA version register
	// Position of MINREV field.
	PKA_VERR_MINREV_Pos = 0x0
	// Bit mask of MINREV field.
	PKA_VERR_MINREV_Msk = 0xf
	// Position of MAJREV field.
	PKA_VERR_MAJREV_Pos = 0x4
	// Bit mask of MAJREV field.
	PKA_VERR_MAJREV_Msk = 0xf0

	// IPIDR: PKA identification register
	// Position of ID field.
	PKA_IPIDR_ID_Pos = 0x0
	// Bit mask of ID field.
	PKA_IPIDR_ID_Msk = 0xffffffff

	// SIDR: PKA size ID register
	// Position of SID field.
	PKA_SIDR_SID_Pos = 0x0
	// Bit mask of SID field.
	PKA_SIDR_SID_Msk = 0xffffffff
)

// Bitfields for IPCC: IPCC
const (
	// C1CR: Control register CPU1
	// Position of TXFIE field.
	IPCC_C1CR_TXFIE_Pos = 0x10
	// Bit mask of TXFIE field.
	IPCC_C1CR_TXFIE_Msk = 0x10000
	// Bit TXFIE.
	IPCC_C1CR_TXFIE = 0x10000
	// Position of RXOIE field.
	IPCC_C1CR_RXOIE_Pos = 0x0
	// Bit mask of RXOIE field.
	IPCC_C1CR_RXOIE_Msk = 0x1
	// Bit RXOIE.
	IPCC_C1CR_RXOIE = 0x1

	// C1MR: Mask register CPU1
	// Position of CH6FM field.
	IPCC_C1MR_CH6FM_Pos = 0x15
	// Bit mask of CH6FM field.
	IPCC_C1MR_CH6FM_Msk = 0x200000
	// Bit CH6FM.
	IPCC_C1MR_CH6FM = 0x200000
	// Position of CH5FM field.
	IPCC_C1MR_CH5FM_Pos = 0x14
	// Bit mask of CH5FM field.
	IPCC_C1MR_CH5FM_Msk = 0x100000
	// Bit CH5FM.
	IPCC_C1MR_CH5FM = 0x100000
	// Position of CH4FM field.
	IPCC_C1MR_CH4FM_Pos = 0x13
	// Bit mask of CH4FM field.
	IPCC_C1MR_CH4FM_Msk = 0x80000
	// Bit CH4FM.
	IPCC_C1MR_CH4FM = 0x80000
	// Position of CH3FM field.
	IPCC_C1MR_CH3FM_Pos = 0x12
	// Bit mask of CH3FM field.
	IPCC_C1MR_CH3FM_Msk = 0x40000
	// Bit CH3FM.
	IPCC_C1MR_CH3FM = 0x40000
	// Position of CH2FM field.
	IPCC_C1MR_CH2FM_Pos = 0x11
	// Bit mask of CH2FM field.
	IPCC_C1MR_CH2FM_Msk = 0x20000
	// Bit CH2FM.
	IPCC_C1MR_CH2FM = 0x20000
	// Position of CH1FM field.
	IPCC_C1MR_CH1FM_Pos = 0x10
	// Bit mask of CH1FM field.
	IPCC_C1MR_CH1FM_Msk = 0x10000
	// Bit CH1FM.
	IPCC_C1MR_CH1FM = 0x10000
	// Position of CH6OM field.
	IPCC_C1MR_CH6OM_Pos = 0x5
	// Bit mask of CH6OM field.
	IPCC_C1MR_CH6OM_Msk = 0x20
	// Bit CH6OM.
	IPCC_C1MR_CH6OM = 0x20
	// Position of CH5OM field.
	IPCC_C1MR_CH5OM_Pos = 0x4
	// Bit mask of CH5OM field.
	IPCC_C1MR_CH5OM_Msk = 0x10
	// Bit CH5OM.
	IPCC_C1MR_CH5OM = 0x10
	// Position of CH4OM field.
	IPCC_C1MR_CH4OM_Pos = 0x3
	// Bit mask of CH4OM field.
	IPCC_C1MR_CH4OM_Msk = 0x8
	// Bit CH4OM.
	IPCC_C1MR_CH4OM = 0x8
	// Position of CH3OM field.
	IPCC_C1MR_CH3OM_Pos = 0x2
	// Bit mask of CH3OM field.
	IPCC_C1MR_CH3OM_Msk = 0x4
	// Bit CH3OM.
	IPCC_C1MR_CH3OM = 0x4
	// Position of CH2OM field.
	IPCC_C1MR_CH2OM_Pos = 0x1
	// Bit mask of CH2OM field.
	IPCC_C1MR_CH2OM_Msk = 0x2
	// Bit CH2OM.
	IPCC_C1MR_CH2OM = 0x2
	// Position of CH1OM field.
	IPCC_C1MR_CH1OM_Pos = 0x0
	// Bit mask of CH1OM field.
	IPCC_C1MR_CH1OM_Msk = 0x1
	// Bit CH1OM.
	IPCC_C1MR_CH1OM = 0x1

	// C1SCR: Status Set or Clear register CPU1
	// Position of CH6S field.
	IPCC_C1SCR_CH6S_Pos = 0x15
	// Bit mask of CH6S field.
	IPCC_C1SCR_CH6S_Msk = 0x200000
	// Bit CH6S.
	IPCC_C1SCR_CH6S = 0x200000
	// Position of CH5S field.
	IPCC_C1SCR_CH5S_Pos = 0x14
	// Bit mask of CH5S field.
	IPCC_C1SCR_CH5S_Msk = 0x100000
	// Bit CH5S.
	IPCC_C1SCR_CH5S = 0x100000
	// Position of CH4S field.
	IPCC_C1SCR_CH4S_Pos = 0x13
	// Bit mask of CH4S field.
	IPCC_C1SCR_CH4S_Msk = 0x80000
	// Bit CH4S.
	IPCC_C1SCR_CH4S = 0x80000
	// Position of CH3S field.
	IPCC_C1SCR_CH3S_Pos = 0x12
	// Bit mask of CH3S field.
	IPCC_C1SCR_CH3S_Msk = 0x40000
	// Bit CH3S.
	IPCC_C1SCR_CH3S = 0x40000
	// Position of CH2S field.
	IPCC_C1SCR_CH2S_Pos = 0x11
	// Bit mask of CH2S field.
	IPCC_C1SCR_CH2S_Msk = 0x20000
	// Bit CH2S.
	IPCC_C1SCR_CH2S = 0x20000
	// Position of CH1S field.
	IPCC_C1SCR_CH1S_Pos = 0x10
	// Bit mask of CH1S field.
	IPCC_C1SCR_CH1S_Msk = 0x10000
	// Bit CH1S.
	IPCC_C1SCR_CH1S = 0x10000
	// Position of CH6C field.
	IPCC_C1SCR_CH6C_Pos = 0x5
	// Bit mask of CH6C field.
	IPCC_C1SCR_CH6C_Msk = 0x20
	// Bit CH6C.
	IPCC_C1SCR_CH6C = 0x20
	// Position of CH5C field.
	IPCC_C1SCR_CH5C_Pos = 0x4
	// Bit mask of CH5C field.
	IPCC_C1SCR_CH5C_Msk = 0x10
	// Bit CH5C.
	IPCC_C1SCR_CH5C = 0x10
	// Position of CH4C field.
	IPCC_C1SCR_CH4C_Pos = 0x3
	// Bit mask of CH4C field.
	IPCC_C1SCR_CH4C_Msk = 0x8
	// Bit CH4C.
	IPCC_C1SCR_CH4C = 0x8
	// Position of CH3C field.
	IPCC_C1SCR_CH3C_Pos = 0x2
	// Bit mask of CH3C field.
	IPCC_C1SCR_CH3C_Msk = 0x4
	// Bit CH3C.
	IPCC_C1SCR_CH3C = 0x4
	// Position of CH2C field.
	IPCC_C1SCR_CH2C_Pos = 0x1
	// Bit mask of CH2C field.
	IPCC_C1SCR_CH2C_Msk = 0x2
	// Bit CH2C.
	IPCC_C1SCR_CH2C = 0x2
	// Position of CH1C field.
	IPCC_C1SCR_CH1C_Pos = 0x0
	// Bit mask of CH1C field.
	IPCC_C1SCR_CH1C_Msk = 0x1
	// Bit CH1C.
	IPCC_C1SCR_CH1C = 0x1

	// C1TO2SR: CPU1 to CPU2 status register
	// Position of CH6F field.
	IPCC_C1TO2SR_CH6F_Pos = 0x5
	// Bit mask of CH6F field.
	IPCC_C1TO2SR_CH6F_Msk = 0x20
	// Bit CH6F.
	IPCC_C1TO2SR_CH6F = 0x20
	// Position of CH5F field.
	IPCC_C1TO2SR_CH5F_Pos = 0x4
	// Bit mask of CH5F field.
	IPCC_C1TO2SR_CH5F_Msk = 0x10
	// Bit CH5F.
	IPCC_C1TO2SR_CH5F = 0x10
	// Position of CH4F field.
	IPCC_C1TO2SR_CH4F_Pos = 0x3
	// Bit mask of CH4F field.
	IPCC_C1TO2SR_CH4F_Msk = 0x8
	// Bit CH4F.
	IPCC_C1TO2SR_CH4F = 0x8
	// Position of CH3F field.
	IPCC_C1TO2SR_CH3F_Pos = 0x2
	// Bit mask of CH3F field.
	IPCC_C1TO2SR_CH3F_Msk = 0x4
	// Bit CH3F.
	IPCC_C1TO2SR_CH3F = 0x4
	// Position of CH2F field.
	IPCC_C1TO2SR_CH2F_Pos = 0x1
	// Bit mask of CH2F field.
	IPCC_C1TO2SR_CH2F_Msk = 0x2
	// Bit CH2F.
	IPCC_C1TO2SR_CH2F = 0x2
	// Position of CH1F field.
	IPCC_C1TO2SR_CH1F_Pos = 0x0
	// Bit mask of CH1F field.
	IPCC_C1TO2SR_CH1F_Msk = 0x1
	// Bit CH1F.
	IPCC_C1TO2SR_CH1F = 0x1

	// C2CR: Control register CPU2
	// Position of TXFIE field.
	IPCC_C2CR_TXFIE_Pos = 0x10
	// Bit mask of TXFIE field.
	IPCC_C2CR_TXFIE_Msk = 0x10000
	// Bit TXFIE.
	IPCC_C2CR_TXFIE = 0x10000
	// Position of RXOIE field.
	IPCC_C2CR_RXOIE_Pos = 0x0
	// Bit mask of RXOIE field.
	IPCC_C2CR_RXOIE_Msk = 0x1
	// Bit RXOIE.
	IPCC_C2CR_RXOIE = 0x1

	// C2MR: Mask register CPU2
	// Position of CH6FM field.
	IPCC_C2MR_CH6FM_Pos = 0x15
	// Bit mask of CH6FM field.
	IPCC_C2MR_CH6FM_Msk = 0x200000
	// Bit CH6FM.
	IPCC_C2MR_CH6FM = 0x200000
	// Position of CH5FM field.
	IPCC_C2MR_CH5FM_Pos = 0x14
	// Bit mask of CH5FM field.
	IPCC_C2MR_CH5FM_Msk = 0x100000
	// Bit CH5FM.
	IPCC_C2MR_CH5FM = 0x100000
	// Position of CH4FM field.
	IPCC_C2MR_CH4FM_Pos = 0x13
	// Bit mask of CH4FM field.
	IPCC_C2MR_CH4FM_Msk = 0x80000
	// Bit CH4FM.
	IPCC_C2MR_CH4FM = 0x80000
	// Position of CH3FM field.
	IPCC_C2MR_CH3FM_Pos = 0x12
	// Bit mask of CH3FM field.
	IPCC_C2MR_CH3FM_Msk = 0x40000
	// Bit CH3FM.
	IPCC_C2MR_CH3FM = 0x40000
	// Position of CH2FM field.
	IPCC_C2MR_CH2FM_Pos = 0x11
	// Bit mask of CH2FM field.
	IPCC_C2MR_CH2FM_Msk = 0x20000
	// Bit CH2FM.
	IPCC_C2MR_CH2FM = 0x20000
	// Position of CH1FM field.
	IPCC_C2MR_CH1FM_Pos = 0x10
	// Bit mask of CH1FM field.
	IPCC_C2MR_CH1FM_Msk = 0x10000
	// Bit CH1FM.
	IPCC_C2MR_CH1FM = 0x10000
	// Position of CH6OM field.
	IPCC_C2MR_CH6OM_Pos = 0x5
	// Bit mask of CH6OM field.
	IPCC_C2MR_CH6OM_Msk = 0x20
	// Bit CH6OM.
	IPCC_C2MR_CH6OM = 0x20
	// Position of CH5OM field.
	IPCC_C2MR_CH5OM_Pos = 0x4
	// Bit mask of CH5OM field.
	IPCC_C2MR_CH5OM_Msk = 0x10
	// Bit CH5OM.
	IPCC_C2MR_CH5OM = 0x10
	// Position of CH4OM field.
	IPCC_C2MR_CH4OM_Pos = 0x3
	// Bit mask of CH4OM field.
	IPCC_C2MR_CH4OM_Msk = 0x8
	// Bit CH4OM.
	IPCC_C2MR_CH4OM = 0x8
	// Position of CH3OM field.
	IPCC_C2MR_CH3OM_Pos = 0x2
	// Bit mask of CH3OM field.
	IPCC_C2MR_CH3OM_Msk = 0x4
	// Bit CH3OM.
	IPCC_C2MR_CH3OM = 0x4
	// Position of CH2OM field.
	IPCC_C2MR_CH2OM_Pos = 0x1
	// Bit mask of CH2OM field.
	IPCC_C2MR_CH2OM_Msk = 0x2
	// Bit CH2OM.
	IPCC_C2MR_CH2OM = 0x2
	// Position of CH1OM field.
	IPCC_C2MR_CH1OM_Pos = 0x0
	// Bit mask of CH1OM field.
	IPCC_C2MR_CH1OM_Msk = 0x1
	// Bit CH1OM.
	IPCC_C2MR_CH1OM = 0x1

	// C2SCR: Status Set or Clear register CPU2
	// Position of CH6S field.
	IPCC_C2SCR_CH6S_Pos = 0x15
	// Bit mask of CH6S field.
	IPCC_C2SCR_CH6S_Msk = 0x200000
	// Bit CH6S.
	IPCC_C2SCR_CH6S = 0x200000
	// Position of CH5S field.
	IPCC_C2SCR_CH5S_Pos = 0x14
	// Bit mask of CH5S field.
	IPCC_C2SCR_CH5S_Msk = 0x100000
	// Bit CH5S.
	IPCC_C2SCR_CH5S = 0x100000
	// Position of CH4S field.
	IPCC_C2SCR_CH4S_Pos = 0x13
	// Bit mask of CH4S field.
	IPCC_C2SCR_CH4S_Msk = 0x80000
	// Bit CH4S.
	IPCC_C2SCR_CH4S = 0x80000
	// Position of CH3S field.
	IPCC_C2SCR_CH3S_Pos = 0x12
	// Bit mask of CH3S field.
	IPCC_C2SCR_CH3S_Msk = 0x40000
	// Bit CH3S.
	IPCC_C2SCR_CH3S = 0x40000
	// Position of CH2S field.
	IPCC_C2SCR_CH2S_Pos = 0x11
	// Bit mask of CH2S field.
	IPCC_C2SCR_CH2S_Msk = 0x20000
	// Bit CH2S.
	IPCC_C2SCR_CH2S = 0x20000
	// Position of CH1S field.
	IPCC_C2SCR_CH1S_Pos = 0x10
	// Bit mask of CH1S field.
	IPCC_C2SCR_CH1S_Msk = 0x10000
	// Bit CH1S.
	IPCC_C2SCR_CH1S = 0x10000
	// Position of CH6C field.
	IPCC_C2SCR_CH6C_Pos = 0x5
	// Bit mask of CH6C field.
	IPCC_C2SCR_CH6C_Msk = 0x20
	// Bit CH6C.
	IPCC_C2SCR_CH6C = 0x20
	// Position of CH5C field.
	IPCC_C2SCR_CH5C_Pos = 0x4
	// Bit mask of CH5C field.
	IPCC_C2SCR_CH5C_Msk = 0x10
	// Bit CH5C.
	IPCC_C2SCR_CH5C = 0x10
	// Position of CH4C field.
	IPCC_C2SCR_CH4C_Pos = 0x3
	// Bit mask of CH4C field.
	IPCC_C2SCR_CH4C_Msk = 0x8
	// Bit CH4C.
	IPCC_C2SCR_CH4C = 0x8
	// Position of CH3C field.
	IPCC_C2SCR_CH3C_Pos = 0x2
	// Bit mask of CH3C field.
	IPCC_C2SCR_CH3C_Msk = 0x4
	// Bit CH3C.
	IPCC_C2SCR_CH3C = 0x4
	// Position of CH2C field.
	IPCC_C2SCR_CH2C_Pos = 0x1
	// Bit mask of CH2C field.
	IPCC_C2SCR_CH2C_Msk = 0x2
	// Bit CH2C.
	IPCC_C2SCR_CH2C = 0x2
	// Position of CH1C field.
	IPCC_C2SCR_CH1C_Pos = 0x0
	// Bit mask of CH1C field.
	IPCC_C2SCR_CH1C_Msk = 0x1
	// Bit CH1C.
	IPCC_C2SCR_CH1C = 0x1

	// C2TOC1SR: CPU2 to CPU1 status register
	// Position of CH6F field.
	IPCC_C2TOC1SR_CH6F_Pos = 0x5
	// Bit mask of CH6F field.
	IPCC_C2TOC1SR_CH6F_Msk = 0x20
	// Bit CH6F.
	IPCC_C2TOC1SR_CH6F = 0x20
	// Position of CH5F field.
	IPCC_C2TOC1SR_CH5F_Pos = 0x4
	// Bit mask of CH5F field.
	IPCC_C2TOC1SR_CH5F_Msk = 0x10
	// Bit CH5F.
	IPCC_C2TOC1SR_CH5F = 0x10
	// Position of CH4F field.
	IPCC_C2TOC1SR_CH4F_Pos = 0x3
	// Bit mask of CH4F field.
	IPCC_C2TOC1SR_CH4F_Msk = 0x8
	// Bit CH4F.
	IPCC_C2TOC1SR_CH4F = 0x8
	// Position of CH3F field.
	IPCC_C2TOC1SR_CH3F_Pos = 0x2
	// Bit mask of CH3F field.
	IPCC_C2TOC1SR_CH3F_Msk = 0x4
	// Bit CH3F.
	IPCC_C2TOC1SR_CH3F = 0x4
	// Position of CH2F field.
	IPCC_C2TOC1SR_CH2F_Pos = 0x1
	// Bit mask of CH2F field.
	IPCC_C2TOC1SR_CH2F_Msk = 0x2
	// Bit CH2F.
	IPCC_C2TOC1SR_CH2F = 0x2
	// Position of CH1F field.
	IPCC_C2TOC1SR_CH1F_Pos = 0x0
	// Bit mask of CH1F field.
	IPCC_C2TOC1SR_CH1F_Msk = 0x1
	// Bit CH1F.
	IPCC_C2TOC1SR_CH1F = 0x1

	// HWCFGR: IPCC Hardware configuration register
	// Position of CHANNELS field.
	IPCC_HWCFGR_CHANNELS_Pos = 0x0
	// Bit mask of CHANNELS field.
	IPCC_HWCFGR_CHANNELS_Msk = 0xff

	// VERR: IPCC version register
	// Position of MAJREV field.
	IPCC_VERR_MAJREV_Pos = 0x4
	// Bit mask of MAJREV field.
	IPCC_VERR_MAJREV_Msk = 0xf0
	// Position of MINREV field.
	IPCC_VERR_MINREV_Pos = 0x0
	// Bit mask of MINREV field.
	IPCC_VERR_MINREV_Msk = 0xf

	// IPIDR: IPCC indentification register
	// Position of IPID field.
	IPCC_IPIDR_IPID_Pos = 0x0
	// Bit mask of IPID field.
	IPCC_IPIDR_IPID_Msk = 0xffffffff

	// SIDR: IPCC size indentification register
	// Position of SID field.
	IPCC_SIDR_SID_Pos = 0x0
	// Bit mask of SID field.
	IPCC_SIDR_SID_Msk = 0xffffffff
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// RTSR1: rising trigger selection register
	// Position of RT field.
	EXTI_RTSR1_RT_Pos = 0x0
	// Bit mask of RT field.
	EXTI_RTSR1_RT_Msk = 0x3fffff
	// Position of RT_31 field.
	EXTI_RTSR1_RT_31_Pos = 0x1f
	// Bit mask of RT_31 field.
	EXTI_RTSR1_RT_31_Msk = 0x80000000
	// Bit RT_31.
	EXTI_RTSR1_RT_31 = 0x80000000

	// FTSR1: falling trigger selection register
	// Position of FT field.
	EXTI_FTSR1_FT_Pos = 0x0
	// Bit mask of FT field.
	EXTI_FTSR1_FT_Msk = 0x3fffff
	// Position of FT_31 field.
	EXTI_FTSR1_FT_31_Pos = 0x1f
	// Bit mask of FT_31 field.
	EXTI_FTSR1_FT_31_Msk = 0x80000000
	// Bit FT_31.
	EXTI_FTSR1_FT_31 = 0x80000000

	// SWIER1: software interrupt event register
	// Position of SWI field.
	EXTI_SWIER1_SWI_Pos = 0x0
	// Bit mask of SWI field.
	EXTI_SWIER1_SWI_Msk = 0x3fffff
	// Position of SWI_31 field.
	EXTI_SWIER1_SWI_31_Pos = 0x1f
	// Bit mask of SWI_31 field.
	EXTI_SWIER1_SWI_31_Msk = 0x80000000
	// Bit SWI_31.
	EXTI_SWIER1_SWI_31 = 0x80000000

	// PR1: EXTI pending register
	// Position of PIF field.
	EXTI_PR1_PIF_Pos = 0x0
	// Bit mask of PIF field.
	EXTI_PR1_PIF_Msk = 0x3fffff
	// Position of PIF_31 field.
	EXTI_PR1_PIF_31_Pos = 0x1f
	// Bit mask of PIF_31 field.
	EXTI_PR1_PIF_31_Msk = 0x80000000
	// Bit PIF_31.
	EXTI_PR1_PIF_31 = 0x80000000

	// RTSR2: rising trigger selection register
	// Position of RT33 field.
	EXTI_RTSR2_RT33_Pos = 0x1
	// Bit mask of RT33 field.
	EXTI_RTSR2_RT33_Msk = 0x2
	// Bit RT33.
	EXTI_RTSR2_RT33 = 0x2
	// Position of RT40_41 field.
	EXTI_RTSR2_RT40_41_Pos = 0x8
	// Bit mask of RT40_41 field.
	EXTI_RTSR2_RT40_41_Msk = 0x300

	// FTSR2: falling trigger selection register
	// Position of FT33 field.
	EXTI_FTSR2_FT33_Pos = 0x1
	// Bit mask of FT33 field.
	EXTI_FTSR2_FT33_Msk = 0x2
	// Bit FT33.
	EXTI_FTSR2_FT33 = 0x2
	// Position of FT40_41 field.
	EXTI_FTSR2_FT40_41_Pos = 0x8
	// Bit mask of FT40_41 field.
	EXTI_FTSR2_FT40_41_Msk = 0x300

	// SWIER2: software interrupt event register
	// Position of SWI33 field.
	EXTI_SWIER2_SWI33_Pos = 0x1
	// Bit mask of SWI33 field.
	EXTI_SWIER2_SWI33_Msk = 0x2
	// Bit SWI33.
	EXTI_SWIER2_SWI33 = 0x2
	// Position of SWI40_41 field.
	EXTI_SWIER2_SWI40_41_Pos = 0x8
	// Bit mask of SWI40_41 field.
	EXTI_SWIER2_SWI40_41_Msk = 0x300

	// PR2: pending register
	// Position of PIF33 field.
	EXTI_PR2_PIF33_Pos = 0x1
	// Bit mask of PIF33 field.
	EXTI_PR2_PIF33_Msk = 0x2
	// Bit PIF33.
	EXTI_PR2_PIF33 = 0x2
	// Position of PIF40_41 field.
	EXTI_PR2_PIF40_41_Pos = 0x8
	// Bit mask of PIF40_41 field.
	EXTI_PR2_PIF40_41_Msk = 0x300

	// C1IMR1: CPUm wakeup with interrupt mask register
	// Position of IM field.
	EXTI_C1IMR1_IM_Pos = 0x0
	// Bit mask of IM field.
	EXTI_C1IMR1_IM_Msk = 0xffffffff

	// C1EMR1: CPUm wakeup with event mask register
	// Position of EM0_15 field.
	EXTI_C1EMR1_EM0_15_Pos = 0x0
	// Bit mask of EM0_15 field.
	EXTI_C1EMR1_EM0_15_Msk = 0xffff
	// Position of EM17_21 field.
	EXTI_C1EMR1_EM17_21_Pos = 0x11
	// Bit mask of EM17_21 field.
	EXTI_C1EMR1_EM17_21_Msk = 0x3e0000

	// C1IMR2: CPUm wakeup with interrupt mask register
	// Position of IM field.
	EXTI_C1IMR2_IM_Pos = 0x0
	// Bit mask of IM field.
	EXTI_C1IMR2_IM_Msk = 0x1ffff

	// C1EMR2: CPUm wakeup with event mask register
	// Position of EM field.
	EXTI_C1EMR2_EM_Pos = 0x8
	// Bit mask of EM field.
	EXTI_C1EMR2_EM_Msk = 0x300

	// C2IMR1: CPUm wakeup with interrupt mask register
	// Position of IM field.
	EXTI_C2IMR1_IM_Pos = 0x0
	// Bit mask of IM field.
	EXTI_C2IMR1_IM_Msk = 0xffffffff

	// C2EMR1: CPUm wakeup with event mask register
	// Position of EM0_15 field.
	EXTI_C2EMR1_EM0_15_Pos = 0x0
	// Bit mask of EM0_15 field.
	EXTI_C2EMR1_EM0_15_Msk = 0xffff
	// Position of EM17_21 field.
	EXTI_C2EMR1_EM17_21_Pos = 0x11
	// Bit mask of EM17_21 field.
	EXTI_C2EMR1_EM17_21_Msk = 0x3e0000

	// C2IMR2: CPUm wakeup with interrupt mask register
	// Position of IM field.
	EXTI_C2IMR2_IM_Pos = 0x0
	// Bit mask of IM field.
	EXTI_C2IMR2_IM_Msk = 0x1ffff

	// C2EMR2: CPUm wakeup with event mask register
	// Position of EM field.
	EXTI_C2EMR2_EM_Pos = 0x8
	// Bit mask of EM field.
	EXTI_C2EMR2_EM_Msk = 0x300

	// HWCFGR7: EXTI Hardware configuration registers
	// Position of CPUEVENT field.
	EXTI_HWCFGR7_CPUEVENT_Pos = 0x0
	// Bit mask of CPUEVENT field.
	EXTI_HWCFGR7_CPUEVENT_Msk = 0xffffffff

	// HWCFGR6: Hardware configuration registers
	// Position of CPUEVENT field.
	EXTI_HWCFGR6_CPUEVENT_Pos = 0x0
	// Bit mask of CPUEVENT field.
	EXTI_HWCFGR6_CPUEVENT_Msk = 0xffffffff

	// HWCFGR5: Hardware configuration registers
	// Position of CPUEVENT field.
	EXTI_HWCFGR5_CPUEVENT_Pos = 0x0
	// Bit mask of CPUEVENT field.
	EXTI_HWCFGR5_CPUEVENT_Msk = 0xffffffff

	// HWCFGR4: Hardware configuration registers
	// Position of EVENT_TRG field.
	EXTI_HWCFGR4_EVENT_TRG_Pos = 0x0
	// Bit mask of EVENT_TRG field.
	EXTI_HWCFGR4_EVENT_TRG_Msk = 0xffffffff

	// HWCFGR3: Hardware configuration registers
	// Position of EVENT_TRG field.
	EXTI_HWCFGR3_EVENT_TRG_Pos = 0x0
	// Bit mask of EVENT_TRG field.
	EXTI_HWCFGR3_EVENT_TRG_Msk = 0xffffffff

	// HWCFGR2: Hardware configuration registers
	// Position of EVENT_TRG field.
	EXTI_HWCFGR2_EVENT_TRG_Pos = 0x0
	// Bit mask of EVENT_TRG field.
	EXTI_HWCFGR2_EVENT_TRG_Msk = 0xffffffff

	// HWCFGR1: Hardware configuration register 1
	// Position of NBEVENTS field.
	EXTI_HWCFGR1_NBEVENTS_Pos = 0x0
	// Bit mask of NBEVENTS field.
	EXTI_HWCFGR1_NBEVENTS_Msk = 0xff
	// Position of NBCPUS field.
	EXTI_HWCFGR1_NBCPUS_Pos = 0x8
	// Bit mask of NBCPUS field.
	EXTI_HWCFGR1_NBCPUS_Msk = 0xf00
	// Position of CPUEVTEN field.
	EXTI_HWCFGR1_CPUEVTEN_Pos = 0xc
	// Bit mask of CPUEVTEN field.
	EXTI_HWCFGR1_CPUEVTEN_Msk = 0xf000

	// VERR: EXTI IP Version register
	// Position of MINREV field.
	EXTI_VERR_MINREV_Pos = 0x0
	// Bit mask of MINREV field.
	EXTI_VERR_MINREV_Msk = 0xf
	// Position of MAJREV field.
	EXTI_VERR_MAJREV_Pos = 0x4
	// Bit mask of MAJREV field.
	EXTI_VERR_MAJREV_Msk = 0xf0

	// IPIDR: Identification register
	// Position of IPID field.
	EXTI_IPIDR_IPID_Pos = 0x0
	// Bit mask of IPID field.
	EXTI_IPIDR_IPID_Msk = 0xffffffff

	// SIDR: Size ID register
	// Position of SID field.
	EXTI_SIDR_SID_Pos = 0x0
	// Bit mask of SID field.
	EXTI_SIDR_SID_Msk = 0xffffffff
)

// Bitfields for CRS: Clock recovery system
const (
	// CR: CRS control register
	// Position of SYNCOKIE field.
	CRS_CR_SYNCOKIE_Pos = 0x0
	// Bit mask of SYNCOKIE field.
	CRS_CR_SYNCOKIE_Msk = 0x1
	// Bit SYNCOKIE.
	CRS_CR_SYNCOKIE = 0x1
	// Position of SYNCWARNIE field.
	CRS_CR_SYNCWARNIE_Pos = 0x1
	// Bit mask of SYNCWARNIE field.
	CRS_CR_SYNCWARNIE_Msk = 0x2
	// Bit SYNCWARNIE.
	CRS_CR_SYNCWARNIE = 0x2
	// Position of ERRIE field.
	CRS_CR_ERRIE_Pos = 0x2
	// Bit mask of ERRIE field.
	CRS_CR_ERRIE_Msk = 0x4
	// Bit ERRIE.
	CRS_CR_ERRIE = 0x4
	// Position of ESYNCIE field.
	CRS_CR_ESYNCIE_Pos = 0x3
	// Bit mask of ESYNCIE field.
	CRS_CR_ESYNCIE_Msk = 0x8
	// Bit ESYNCIE.
	CRS_CR_ESYNCIE = 0x8
	// Position of CEN field.
	CRS_CR_CEN_Pos = 0x5
	// Bit mask of CEN field.
	CRS_CR_CEN_Msk = 0x20
	// Bit CEN.
	CRS_CR_CEN = 0x20
	// Position of AUTOTRIMEN field.
	CRS_CR_AUTOTRIMEN_Pos = 0x6
	// Bit mask of AUTOTRIMEN field.
	CRS_CR_AUTOTRIMEN_Msk = 0x40
	// Bit AUTOTRIMEN.
	CRS_CR_AUTOTRIMEN = 0x40
	// Position of SWSYNC field.
	CRS_CR_SWSYNC_Pos = 0x7
	// Bit mask of SWSYNC field.
	CRS_CR_SWSYNC_Msk = 0x80
	// Bit SWSYNC.
	CRS_CR_SWSYNC = 0x80
	// Position of TRIM field.
	CRS_CR_TRIM_Pos = 0x8
	// Bit mask of TRIM field.
	CRS_CR_TRIM_Msk = 0x3f00

	// CFGR: CRS configuration register
	// Position of RELOAD field.
	CRS_CFGR_RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	CRS_CFGR_RELOAD_Msk = 0xffff
	// Position of FELIM field.
	CRS_CFGR_FELIM_Pos = 0x10
	// Bit mask of FELIM field.
	CRS_CFGR_FELIM_Msk = 0xff0000
	// Position of SYNCDIV field.
	CRS_CFGR_SYNCDIV_Pos = 0x18
	// Bit mask of SYNCDIV field.
	CRS_CFGR_SYNCDIV_Msk = 0x7000000
	// Position of SYNCSRC field.
	CRS_CFGR_SYNCSRC_Pos = 0x1c
	// Bit mask of SYNCSRC field.
	CRS_CFGR_SYNCSRC_Msk = 0x30000000
	// Position of SYNCPOL field.
	CRS_CFGR_SYNCPOL_Pos = 0x1f
	// Bit mask of SYNCPOL field.
	CRS_CFGR_SYNCPOL_Msk = 0x80000000
	// Bit SYNCPOL.
	CRS_CFGR_SYNCPOL = 0x80000000

	// ISR: CRS interrupt and status register
	// Position of SYNCOKF field.
	CRS_ISR_SYNCOKF_Pos = 0x0
	// Bit mask of SYNCOKF field.
	CRS_ISR_SYNCOKF_Msk = 0x1
	// Bit SYNCOKF.
	CRS_ISR_SYNCOKF = 0x1
	// Position of SYNCWARNF field.
	CRS_ISR_SYNCWARNF_Pos = 0x1
	// Bit mask of SYNCWARNF field.
	CRS_ISR_SYNCWARNF_Msk = 0x2
	// Bit SYNCWARNF.
	CRS_ISR_SYNCWARNF = 0x2
	// Position of ERRF field.
	CRS_ISR_ERRF_Pos = 0x2
	// Bit mask of ERRF field.
	CRS_ISR_ERRF_Msk = 0x4
	// Bit ERRF.
	CRS_ISR_ERRF = 0x4
	// Position of ESYNCF field.
	CRS_ISR_ESYNCF_Pos = 0x3
	// Bit mask of ESYNCF field.
	CRS_ISR_ESYNCF_Msk = 0x8
	// Bit ESYNCF.
	CRS_ISR_ESYNCF = 0x8
	// Position of SYNCERR field.
	CRS_ISR_SYNCERR_Pos = 0x8
	// Bit mask of SYNCERR field.
	CRS_ISR_SYNCERR_Msk = 0x100
	// Bit SYNCERR.
	CRS_ISR_SYNCERR = 0x100
	// Position of SYNCMISS field.
	CRS_ISR_SYNCMISS_Pos = 0x9
	// Bit mask of SYNCMISS field.
	CRS_ISR_SYNCMISS_Msk = 0x200
	// Bit SYNCMISS.
	CRS_ISR_SYNCMISS = 0x200
	// Position of TRIMOVF field.
	CRS_ISR_TRIMOVF_Pos = 0xa
	// Bit mask of TRIMOVF field.
	CRS_ISR_TRIMOVF_Msk = 0x400
	// Bit TRIMOVF.
	CRS_ISR_TRIMOVF = 0x400
	// Position of FEDIR field.
	CRS_ISR_FEDIR_Pos = 0xf
	// Bit mask of FEDIR field.
	CRS_ISR_FEDIR_Msk = 0x8000
	// Bit FEDIR.
	CRS_ISR_FEDIR = 0x8000
	// Position of FECAP field.
	CRS_ISR_FECAP_Pos = 0x10
	// Bit mask of FECAP field.
	CRS_ISR_FECAP_Msk = 0xffff0000

	// ICR: CRS interrupt flag clear register
	// Position of SYNCOKC field.
	CRS_ICR_SYNCOKC_Pos = 0x0
	// Bit mask of SYNCOKC field.
	CRS_ICR_SYNCOKC_Msk = 0x1
	// Bit SYNCOKC.
	CRS_ICR_SYNCOKC = 0x1
	// Position of SYNCWARNC field.
	CRS_ICR_SYNCWARNC_Pos = 0x1
	// Bit mask of SYNCWARNC field.
	CRS_ICR_SYNCWARNC_Msk = 0x2
	// Bit SYNCWARNC.
	CRS_ICR_SYNCWARNC = 0x2
	// Position of ERRC field.
	CRS_ICR_ERRC_Pos = 0x2
	// Bit mask of ERRC field.
	CRS_ICR_ERRC_Msk = 0x4
	// Bit ERRC.
	CRS_ICR_ERRC = 0x4
	// Position of ESYNCC field.
	CRS_ICR_ESYNCC_Pos = 0x3
	// Bit mask of ESYNCC field.
	CRS_ICR_ESYNCC_Msk = 0x8
	// Bit ESYNCC.
	CRS_ICR_ESYNCC = 0x8
)

// Bitfields for USB: Universal serial bus full-speed device interface
const (
	// EP0R: endpoint 0 register
	// Position of EA field.
	USB_EP0R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP0R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP0R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP0R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP0R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP0R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP0R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP0R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP0R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP0R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP0R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP0R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP0R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP0R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP0R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP0R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP0R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP0R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP0R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP0R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP0R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP0R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP0R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP0R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP0R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP0R_CTR_RX = 0x8000

	// EP1R: endpoint 1 register
	// Position of EA field.
	USB_EP1R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP1R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP1R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP1R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP1R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP1R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP1R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP1R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP1R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP1R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP1R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP1R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP1R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP1R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP1R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP1R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP1R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP1R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP1R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP1R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP1R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP1R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP1R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP1R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP1R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP1R_CTR_RX = 0x8000

	// EP2R: endpoint 2 register
	// Position of EA field.
	USB_EP2R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP2R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP2R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP2R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP2R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP2R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP2R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP2R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP2R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP2R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP2R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP2R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP2R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP2R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP2R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP2R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP2R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP2R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP2R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP2R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP2R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP2R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP2R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP2R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP2R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP2R_CTR_RX = 0x8000

	// EP3R: endpoint 3 register
	// Position of EA field.
	USB_EP3R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP3R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP3R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP3R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP3R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP3R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP3R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP3R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP3R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP3R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP3R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP3R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP3R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP3R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP3R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP3R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP3R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP3R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP3R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP3R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP3R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP3R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP3R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP3R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP3R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP3R_CTR_RX = 0x8000

	// EP4R: endpoint 4 register
	// Position of EA field.
	USB_EP4R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP4R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP4R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP4R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP4R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP4R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP4R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP4R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP4R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP4R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP4R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP4R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP4R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP4R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP4R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP4R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP4R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP4R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP4R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP4R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP4R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP4R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP4R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP4R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP4R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP4R_CTR_RX = 0x8000

	// EP5R: endpoint 5 register
	// Position of EA field.
	USB_EP5R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP5R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP5R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP5R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP5R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP5R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP5R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP5R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP5R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP5R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP5R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP5R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP5R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP5R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP5R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP5R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP5R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP5R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP5R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP5R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP5R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP5R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP5R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP5R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP5R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP5R_CTR_RX = 0x8000

	// EP6R: endpoint 6 register
	// Position of EA field.
	USB_EP6R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP6R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP6R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP6R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP6R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP6R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP6R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP6R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP6R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP6R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP6R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP6R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP6R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP6R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP6R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP6R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP6R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP6R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP6R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP6R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP6R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP6R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP6R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP6R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP6R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP6R_CTR_RX = 0x8000

	// EP7R: endpoint 7 register
	// Position of EA field.
	USB_EP7R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP7R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP7R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP7R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP7R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP7R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP7R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP7R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP7R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP7R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP7R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP7R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP7R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP7R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP7R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP7R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP7R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP7R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP7R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP7R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP7R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP7R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP7R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP7R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP7R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP7R_CTR_RX = 0x8000

	// CNTR: control register
	// Position of FRES field.
	USB_CNTR_FRES_Pos = 0x0
	// Bit mask of FRES field.
	USB_CNTR_FRES_Msk = 0x1
	// Bit FRES.
	USB_CNTR_FRES = 0x1
	// Position of PDWN field.
	USB_CNTR_PDWN_Pos = 0x1
	// Bit mask of PDWN field.
	USB_CNTR_PDWN_Msk = 0x2
	// Bit PDWN.
	USB_CNTR_PDWN = 0x2
	// Position of LPMODE field.
	USB_CNTR_LPMODE_Pos = 0x2
	// Bit mask of LPMODE field.
	USB_CNTR_LPMODE_Msk = 0x4
	// Bit LPMODE.
	USB_CNTR_LPMODE = 0x4
	// Position of FSUSP field.
	USB_CNTR_FSUSP_Pos = 0x3
	// Bit mask of FSUSP field.
	USB_CNTR_FSUSP_Msk = 0x8
	// Bit FSUSP.
	USB_CNTR_FSUSP = 0x8
	// Position of RESUME field.
	USB_CNTR_RESUME_Pos = 0x4
	// Bit mask of RESUME field.
	USB_CNTR_RESUME_Msk = 0x10
	// Bit RESUME.
	USB_CNTR_RESUME = 0x10
	// Position of L1RESUME field.
	USB_CNTR_L1RESUME_Pos = 0x5
	// Bit mask of L1RESUME field.
	USB_CNTR_L1RESUME_Msk = 0x20
	// Bit L1RESUME.
	USB_CNTR_L1RESUME = 0x20
	// Position of L1REQM field.
	USB_CNTR_L1REQM_Pos = 0x7
	// Bit mask of L1REQM field.
	USB_CNTR_L1REQM_Msk = 0x80
	// Bit L1REQM.
	USB_CNTR_L1REQM = 0x80
	// Position of ESOFM field.
	USB_CNTR_ESOFM_Pos = 0x8
	// Bit mask of ESOFM field.
	USB_CNTR_ESOFM_Msk = 0x100
	// Bit ESOFM.
	USB_CNTR_ESOFM = 0x100
	// Position of SOFM field.
	USB_CNTR_SOFM_Pos = 0x9
	// Bit mask of SOFM field.
	USB_CNTR_SOFM_Msk = 0x200
	// Bit SOFM.
	USB_CNTR_SOFM = 0x200
	// Position of RESETM field.
	USB_CNTR_RESETM_Pos = 0xa
	// Bit mask of RESETM field.
	USB_CNTR_RESETM_Msk = 0x400
	// Bit RESETM.
	USB_CNTR_RESETM = 0x400
	// Position of SUSPM field.
	USB_CNTR_SUSPM_Pos = 0xb
	// Bit mask of SUSPM field.
	USB_CNTR_SUSPM_Msk = 0x800
	// Bit SUSPM.
	USB_CNTR_SUSPM = 0x800
	// Position of WKUPM field.
	USB_CNTR_WKUPM_Pos = 0xc
	// Bit mask of WKUPM field.
	USB_CNTR_WKUPM_Msk = 0x1000
	// Bit WKUPM.
	USB_CNTR_WKUPM = 0x1000
	// Position of ERRM field.
	USB_CNTR_ERRM_Pos = 0xd
	// Bit mask of ERRM field.
	USB_CNTR_ERRM_Msk = 0x2000
	// Bit ERRM.
	USB_CNTR_ERRM = 0x2000
	// Position of PMAOVRM field.
	USB_CNTR_PMAOVRM_Pos = 0xe
	// Bit mask of PMAOVRM field.
	USB_CNTR_PMAOVRM_Msk = 0x4000
	// Bit PMAOVRM.
	USB_CNTR_PMAOVRM = 0x4000
	// Position of CTRM field.
	USB_CNTR_CTRM_Pos = 0xf
	// Bit mask of CTRM field.
	USB_CNTR_CTRM_Msk = 0x8000
	// Bit CTRM.
	USB_CNTR_CTRM = 0x8000

	// ISTR: interrupt status register
	// Position of EP_ID field.
	USB_ISTR_EP_ID_Pos = 0x0
	// Bit mask of EP_ID field.
	USB_ISTR_EP_ID_Msk = 0xf
	// Position of DIR field.
	USB_ISTR_DIR_Pos = 0x4
	// Bit mask of DIR field.
	USB_ISTR_DIR_Msk = 0x10
	// Bit DIR.
	USB_ISTR_DIR = 0x10
	// Position of L1REQ field.
	USB_ISTR_L1REQ_Pos = 0x7
	// Bit mask of L1REQ field.
	USB_ISTR_L1REQ_Msk = 0x80
	// Bit L1REQ.
	USB_ISTR_L1REQ = 0x80
	// Position of ESOF field.
	USB_ISTR_ESOF_Pos = 0x8
	// Bit mask of ESOF field.
	USB_ISTR_ESOF_Msk = 0x100
	// Bit ESOF.
	USB_ISTR_ESOF = 0x100
	// Position of SOF field.
	USB_ISTR_SOF_Pos = 0x9
	// Bit mask of SOF field.
	USB_ISTR_SOF_Msk = 0x200
	// Bit SOF.
	USB_ISTR_SOF = 0x200
	// Position of RESET field.
	USB_ISTR_RESET_Pos = 0xa
	// Bit mask of RESET field.
	USB_ISTR_RESET_Msk = 0x400
	// Bit RESET.
	USB_ISTR_RESET = 0x400
	// Position of SUSP field.
	USB_ISTR_SUSP_Pos = 0xb
	// Bit mask of SUSP field.
	USB_ISTR_SUSP_Msk = 0x800
	// Bit SUSP.
	USB_ISTR_SUSP = 0x800
	// Position of WKUP field.
	USB_ISTR_WKUP_Pos = 0xc
	// Bit mask of WKUP field.
	USB_ISTR_WKUP_Msk = 0x1000
	// Bit WKUP.
	USB_ISTR_WKUP = 0x1000
	// Position of ERR field.
	USB_ISTR_ERR_Pos = 0xd
	// Bit mask of ERR field.
	USB_ISTR_ERR_Msk = 0x2000
	// Bit ERR.
	USB_ISTR_ERR = 0x2000
	// Position of PMAOVR field.
	USB_ISTR_PMAOVR_Pos = 0xe
	// Bit mask of PMAOVR field.
	USB_ISTR_PMAOVR_Msk = 0x4000
	// Bit PMAOVR.
	USB_ISTR_PMAOVR = 0x4000
	// Position of CTR field.
	USB_ISTR_CTR_Pos = 0xf
	// Bit mask of CTR field.
	USB_ISTR_CTR_Msk = 0x8000
	// Bit CTR.
	USB_ISTR_CTR = 0x8000

	// FNR: frame number register
	// Position of FN field.
	USB_FNR_FN_Pos = 0x0
	// Bit mask of FN field.
	USB_FNR_FN_Msk = 0x7ff
	// Position of LSOF field.
	USB_FNR_LSOF_Pos = 0xb
	// Bit mask of LSOF field.
	USB_FNR_LSOF_Msk = 0x1800
	// Position of LCK field.
	USB_FNR_LCK_Pos = 0xd
	// Bit mask of LCK field.
	USB_FNR_LCK_Msk = 0x2000
	// Bit LCK.
	USB_FNR_LCK = 0x2000
	// Position of RXDM field.
	USB_FNR_RXDM_Pos = 0xe
	// Bit mask of RXDM field.
	USB_FNR_RXDM_Msk = 0x4000
	// Bit RXDM.
	USB_FNR_RXDM = 0x4000
	// Position of RXDP field.
	USB_FNR_RXDP_Pos = 0xf
	// Bit mask of RXDP field.
	USB_FNR_RXDP_Msk = 0x8000
	// Bit RXDP.
	USB_FNR_RXDP = 0x8000

	// DADDR: device address
	// Position of ADD field.
	USB_DADDR_ADD_Pos = 0x0
	// Bit mask of ADD field.
	USB_DADDR_ADD_Msk = 0x7f
	// Position of EF field.
	USB_DADDR_EF_Pos = 0x7
	// Bit mask of EF field.
	USB_DADDR_EF_Msk = 0x80
	// Bit EF.
	USB_DADDR_EF = 0x80

	// BTABLE: Buffer table address
	// Position of BTABLE field.
	USB_BTABLE_BTABLE_Pos = 0x3
	// Bit mask of BTABLE field.
	USB_BTABLE_BTABLE_Msk = 0xfff8

	// COUNT0_TX: Transmission byte count 0
	// Position of COUNT0_TX field.
	USB_COUNT0_TX_COUNT0_TX_Pos = 0x0
	// Bit mask of COUNT0_TX field.
	USB_COUNT0_TX_COUNT0_TX_Msk = 0x3ff

	// ADDR0_RX: Reception buffer address 0
	// Position of ADDR0_RX field.
	USB_ADDR0_RX_ADDR0_RX_Pos = 0x1
	// Bit mask of ADDR0_RX field.
	USB_ADDR0_RX_ADDR0_RX_Msk = 0xfffe

	// LPMCSR: control and status register
	// Position of LPMEN field.
	USB_LPMCSR_LPMEN_Pos = 0x0
	// Bit mask of LPMEN field.
	USB_LPMCSR_LPMEN_Msk = 0x1
	// Bit LPMEN.
	USB_LPMCSR_LPMEN = 0x1
	// Position of LPMACK field.
	USB_LPMCSR_LPMACK_Pos = 0x1
	// Bit mask of LPMACK field.
	USB_LPMCSR_LPMACK_Msk = 0x2
	// Bit LPMACK.
	USB_LPMCSR_LPMACK = 0x2
	// Position of REMWAKE field.
	USB_LPMCSR_REMWAKE_Pos = 0x3
	// Bit mask of REMWAKE field.
	USB_LPMCSR_REMWAKE_Msk = 0x8
	// Bit REMWAKE.
	USB_LPMCSR_REMWAKE = 0x8
	// Position of BESL field.
	USB_LPMCSR_BESL_Pos = 0x4
	// Bit mask of BESL field.
	USB_LPMCSR_BESL_Msk = 0xf0

	// COUNT0_RX: Reception byte count 0
	// Position of COUNT0_RX field.
	USB_COUNT0_RX_COUNT0_RX_Pos = 0x0
	// Bit mask of COUNT0_RX field.
	USB_COUNT0_RX_COUNT0_RX_Msk = 0x3ff
	// Position of NUM_BLOCK field.
	USB_COUNT0_RX_NUM_BLOCK_Pos = 0xa
	// Bit mask of NUM_BLOCK field.
	USB_COUNT0_RX_NUM_BLOCK_Msk = 0x7c00
	// Position of BL_SIZE field.
	USB_COUNT0_RX_BL_SIZE_Pos = 0xf
	// Bit mask of BL_SIZE field.
	USB_COUNT0_RX_BL_SIZE_Msk = 0x8000
	// Bit BL_SIZE.
	USB_COUNT0_RX_BL_SIZE = 0x8000

	// BCDR: Battery charging detector(
	// Position of BCDEN field.
	USB_BCDR_BCDEN_Pos = 0x0
	// Bit mask of BCDEN field.
	USB_BCDR_BCDEN_Msk = 0x1
	// Bit BCDEN.
	USB_BCDR_BCDEN = 0x1
	// Position of DCDEN field.
	USB_BCDR_DCDEN_Pos = 0x1
	// Bit mask of DCDEN field.
	USB_BCDR_DCDEN_Msk = 0x2
	// Bit DCDEN.
	USB_BCDR_DCDEN = 0x2
	// Position of PDEN field.
	USB_BCDR_PDEN_Pos = 0x2
	// Bit mask of PDEN field.
	USB_BCDR_PDEN_Msk = 0x4
	// Bit PDEN.
	USB_BCDR_PDEN = 0x4
	// Position of SDEN field.
	USB_BCDR_SDEN_Pos = 0x3
	// Bit mask of SDEN field.
	USB_BCDR_SDEN_Msk = 0x8
	// Bit SDEN.
	USB_BCDR_SDEN = 0x8
	// Position of DCDET field.
	USB_BCDR_DCDET_Pos = 0x4
	// Bit mask of DCDET field.
	USB_BCDR_DCDET_Msk = 0x10
	// Bit DCDET.
	USB_BCDR_DCDET = 0x10
	// Position of PDET field.
	USB_BCDR_PDET_Pos = 0x5
	// Bit mask of PDET field.
	USB_BCDR_PDET_Msk = 0x20
	// Bit PDET.
	USB_BCDR_PDET = 0x20
	// Position of SDET field.
	USB_BCDR_SDET_Pos = 0x6
	// Bit mask of SDET field.
	USB_BCDR_SDET_Msk = 0x40
	// Bit SDET.
	USB_BCDR_SDET = 0x40
	// Position of PS2DET field.
	USB_BCDR_PS2DET_Pos = 0x7
	// Bit mask of PS2DET field.
	USB_BCDR_PS2DET_Msk = 0x80
	// Bit PS2DET.
	USB_BCDR_PS2DET = 0x80
	// Position of DPPU field.
	USB_BCDR_DPPU_Pos = 0xf
	// Bit mask of DPPU field.
	USB_BCDR_DPPU_Msk = 0x8000
	// Bit DPPU.
	USB_BCDR_DPPU = 0x8000

	// COUNT1_TX: Transmission byte count 0
	// Position of COUNT1_TX field.
	USB_COUNT1_TX_COUNT1_TX_Pos = 0x0
	// Bit mask of COUNT1_TX field.
	USB_COUNT1_TX_COUNT1_TX_Msk = 0x3ff

	// ADDR1_RX: Reception buffer address 0
	// Position of ADDR1_RX field.
	USB_ADDR1_RX_ADDR1_RX_Pos = 0x1
	// Bit mask of ADDR1_RX field.
	USB_ADDR1_RX_ADDR1_RX_Msk = 0xfffe

	// COUNT1_RX: Reception byte count 0
	// Position of COUNT1_RX field.
	USB_COUNT1_RX_COUNT1_RX_Pos = 0x0
	// Bit mask of COUNT1_RX field.
	USB_COUNT1_RX_COUNT1_RX_Msk = 0x3ff
	// Position of NUM_BLOCK field.
	USB_COUNT1_RX_NUM_BLOCK_Pos = 0xa
	// Bit mask of NUM_BLOCK field.
	USB_COUNT1_RX_NUM_BLOCK_Msk = 0x7c00
	// Position of BL_SIZE field.
	USB_COUNT1_RX_BL_SIZE_Pos = 0xf
	// Bit mask of BL_SIZE field.
	USB_COUNT1_RX_BL_SIZE_Msk = 0x8000
	// Bit BL_SIZE.
	USB_COUNT1_RX_BL_SIZE = 0x8000

	// COUNT2_TX: Transmission byte count 0
	// Position of COUNT2_TX field.
	USB_COUNT2_TX_COUNT2_TX_Pos = 0x0
	// Bit mask of COUNT2_TX field.
	USB_COUNT2_TX_COUNT2_TX_Msk = 0x3ff

	// ADDR2_RX: Reception buffer address 0
	// Position of ADDR2_RX field.
	USB_ADDR2_RX_ADDR2_RX_Pos = 0x1
	// Bit mask of ADDR2_RX field.
	USB_ADDR2_RX_ADDR2_RX_Msk = 0xfffe

	// COUNT2_RX: Reception byte count 0
	// Position of COUNT2_RX field.
	USB_COUNT2_RX_COUNT2_RX_Pos = 0x0
	// Bit mask of COUNT2_RX field.
	USB_COUNT2_RX_COUNT2_RX_Msk = 0x3ff
	// Position of NUM_BLOCK field.
	USB_COUNT2_RX_NUM_BLOCK_Pos = 0xa
	// Bit mask of NUM_BLOCK field.
	USB_COUNT2_RX_NUM_BLOCK_Msk = 0x7c00
	// Position of BL_SIZE field.
	USB_COUNT2_RX_BL_SIZE_Pos = 0xf
	// Bit mask of BL_SIZE field.
	USB_COUNT2_RX_BL_SIZE_Msk = 0x8000
	// Bit BL_SIZE.
	USB_COUNT2_RX_BL_SIZE = 0x8000

	// COUNT3_TX: Transmission byte count 0
	// Position of COUNT3_TX field.
	USB_COUNT3_TX_COUNT3_TX_Pos = 0x0
	// Bit mask of COUNT3_TX field.
	USB_COUNT3_TX_COUNT3_TX_Msk = 0x3ff

	// ADDR3_RX: Reception buffer address 0
	// Position of ADDR3_RX field.
	USB_ADDR3_RX_ADDR3_RX_Pos = 0x1
	// Bit mask of ADDR3_RX field.
	USB_ADDR3_RX_ADDR3_RX_Msk = 0xfffe

	// COUNT3_RX: Reception byte count 0
	// Position of COUNT3_RX field.
	USB_COUNT3_RX_COUNT3_RX_Pos = 0x0
	// Bit mask of COUNT3_RX field.
	USB_COUNT3_RX_COUNT3_RX_Msk = 0x3ff
	// Position of NUM_BLOCK field.
	USB_COUNT3_RX_NUM_BLOCK_Pos = 0xa
	// Bit mask of NUM_BLOCK field.
	USB_COUNT3_RX_NUM_BLOCK_Msk = 0x7c00
	// Position of BL_SIZE field.
	USB_COUNT3_RX_BL_SIZE_Pos = 0xf
	// Bit mask of BL_SIZE field.
	USB_COUNT3_RX_BL_SIZE_Msk = 0x8000
	// Bit BL_SIZE.
	USB_COUNT3_RX_BL_SIZE = 0x8000

	// COUNT4_TX: Transmission byte count 0
	// Position of COUNT4_TX field.
	USB_COUNT4_TX_COUNT4_TX_Pos = 0x0
	// Bit mask of COUNT4_TX field.
	USB_COUNT4_TX_COUNT4_TX_Msk = 0x3ff

	// ADDR4_RX: Reception buffer address 0
	// Position of ADDR4_RX field.
	USB_ADDR4_RX_ADDR4_RX_Pos = 0x1
	// Bit mask of ADDR4_RX field.
	USB_ADDR4_RX_ADDR4_RX_Msk = 0xfffe

	// COUNT4_RX: Reception byte count 0
	// Position of COUNT4_RX field.
	USB_COUNT4_RX_COUNT4_RX_Pos = 0x0
	// Bit mask of COUNT4_RX field.
	USB_COUNT4_RX_COUNT4_RX_Msk = 0x3ff
	// Position of NUM_BLOCK field.
	USB_COUNT4_RX_NUM_BLOCK_Pos = 0xa
	// Bit mask of NUM_BLOCK field.
	USB_COUNT4_RX_NUM_BLOCK_Msk = 0x7c00
	// Position of BL_SIZE field.
	USB_COUNT4_RX_BL_SIZE_Pos = 0xf
	// Bit mask of BL_SIZE field.
	USB_COUNT4_RX_BL_SIZE_Msk = 0x8000
	// Bit BL_SIZE.
	USB_COUNT4_RX_BL_SIZE = 0x8000

	// COUNT5_TX: Transmission byte count 0
	// Position of COUNT5_TX field.
	USB_COUNT5_TX_COUNT5_TX_Pos = 0x0
	// Bit mask of COUNT5_TX field.
	USB_COUNT5_TX_COUNT5_TX_Msk = 0x3ff

	// ADDR5_RX: Reception buffer address 0
	// Position of ADDR5_RX field.
	USB_ADDR5_RX_ADDR5_RX_Pos = 0x1
	// Bit mask of ADDR5_RX field.
	USB_ADDR5_RX_ADDR5_RX_Msk = 0xfffe

	// COUNT5_RX: Reception byte count 0
	// Position of COUNT5_RX field.
	USB_COUNT5_RX_COUNT5_RX_Pos = 0x0
	// Bit mask of COUNT5_RX field.
	USB_COUNT5_RX_COUNT5_RX_Msk = 0x3ff
	// Position of NUM_BLOCK field.
	USB_COUNT5_RX_NUM_BLOCK_Pos = 0xa
	// Bit mask of NUM_BLOCK field.
	USB_COUNT5_RX_NUM_BLOCK_Msk = 0x7c00
	// Position of BL_SIZE field.
	USB_COUNT5_RX_BL_SIZE_Pos = 0xf
	// Bit mask of BL_SIZE field.
	USB_COUNT5_RX_BL_SIZE_Msk = 0x8000
	// Bit BL_SIZE.
	USB_COUNT5_RX_BL_SIZE = 0x8000

	// COUNT6_TX: Transmission byte count 0
	// Position of COUNT6_TX field.
	USB_COUNT6_TX_COUNT6_TX_Pos = 0x0
	// Bit mask of COUNT6_TX field.
	USB_COUNT6_TX_COUNT6_TX_Msk = 0x3ff

	// ADDR6_RX: Reception buffer address 0
	// Position of ADDR6_RX field.
	USB_ADDR6_RX_ADDR6_RX_Pos = 0x1
	// Bit mask of ADDR6_RX field.
	USB_ADDR6_RX_ADDR6_RX_Msk = 0xfffe

	// COUNT6_RX: Reception byte count 0
	// Position of COUNT6_RX field.
	USB_COUNT6_RX_COUNT6_RX_Pos = 0x0
	// Bit mask of COUNT6_RX field.
	USB_COUNT6_RX_COUNT6_RX_Msk = 0x3ff
	// Position of NUM_BLOCK field.
	USB_COUNT6_RX_NUM_BLOCK_Pos = 0xa
	// Bit mask of NUM_BLOCK field.
	USB_COUNT6_RX_NUM_BLOCK_Msk = 0x7c00
	// Position of BL_SIZE field.
	USB_COUNT6_RX_BL_SIZE_Pos = 0xf
	// Bit mask of BL_SIZE field.
	USB_COUNT6_RX_BL_SIZE_Msk = 0x8000
	// Bit BL_SIZE.
	USB_COUNT6_RX_BL_SIZE = 0x8000

	// COUNT7_TX: Transmission byte count 0
	// Position of COUNT7_TX field.
	USB_COUNT7_TX_COUNT7_TX_Pos = 0x0
	// Bit mask of COUNT7_TX field.
	USB_COUNT7_TX_COUNT7_TX_Msk = 0x3ff

	// ADDR7_RX: Reception buffer address 0
	// Position of ADDR7_RX field.
	USB_ADDR7_RX_ADDR7_RX_Pos = 0x1
	// Bit mask of ADDR7_RX field.
	USB_ADDR7_RX_ADDR7_RX_Msk = 0xfffe

	// COUNT7_RX: Reception byte count 0
	// Position of COUNT7_RX field.
	USB_COUNT7_RX_COUNT7_RX_Pos = 0x0
	// Bit mask of COUNT7_RX field.
	USB_COUNT7_RX_COUNT7_RX_Msk = 0x3ff
	// Position of NUM_BLOCK field.
	USB_COUNT7_RX_NUM_BLOCK_Pos = 0xa
	// Bit mask of NUM_BLOCK field.
	USB_COUNT7_RX_NUM_BLOCK_Msk = 0x7c00
	// Position of BL_SIZE field.
	USB_COUNT7_RX_BL_SIZE_Pos = 0xf
	// Bit mask of BL_SIZE field.
	USB_COUNT7_RX_BL_SIZE_Msk = 0x8000
	// Bit BL_SIZE.
	USB_COUNT7_RX_BL_SIZE = 0x8000
)

// Bitfields for SCB: System control block
const (
	// CPUID: CPUID base register
	// Position of Revision field.
	SCB_CPUID_Revision_Pos = 0x0
	// Bit mask of Revision field.
	SCB_CPUID_Revision_Msk = 0xf
	// Position of PartNo field.
	SCB_CPUID_PartNo_Pos = 0x4
	// Bit mask of PartNo field.
	SCB_CPUID_PartNo_Msk = 0xfff0
	// Position of Constant field.
	SCB_CPUID_Constant_Pos = 0x10
	// Bit mask of Constant field.
	SCB_CPUID_Constant_Msk = 0xf0000
	// Position of Variant field.
	SCB_CPUID_Variant_Pos = 0x14
	// Bit mask of Variant field.
	SCB_CPUID_Variant_Msk = 0xf00000
	// Position of Implementer field.
	SCB_CPUID_Implementer_Pos = 0x18
	// Bit mask of Implementer field.
	SCB_CPUID_Implementer_Msk = 0xff000000

	// ICSR: Interrupt control and state register
	// Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Pos = 0x0
	// Bit mask of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk = 0x1ff
	// Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Pos = 0xb
	// Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk = 0x800
	// Bit RETTOBASE.
	SCB_ICSR_RETTOBASE = 0x800
	// Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Pos = 0xc
	// Bit mask of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000
	// Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Pos = 0x16
	// Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk = 0x400000
	// Bit ISRPENDING.
	SCB_ICSR_ISRPENDING = 0x400000
	// Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Pos = 0x19
	// Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk = 0x2000000
	// Bit PENDSTCLR.
	SCB_ICSR_PENDSTCLR = 0x2000000
	// Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Pos = 0x1a
	// Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk = 0x4000000
	// Bit PENDSTSET.
	SCB_ICSR_PENDSTSET = 0x4000000
	// Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Pos = 0x1b
	// Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk = 0x8000000
	// Bit PENDSVCLR.
	SCB_ICSR_PENDSVCLR = 0x8000000
	// Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Pos = 0x1c
	// Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk = 0x10000000
	// Bit PENDSVSET.
	SCB_ICSR_PENDSVSET = 0x10000000
	// Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Pos = 0x1f
	// Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk = 0x80000000
	// Bit NMIPENDSET.
	SCB_ICSR_NMIPENDSET = 0x80000000

	// VTOR: Vector table offset register
	// Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Pos = 0x9
	// Bit mask of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0x3ffffe00

	// AIRCR: Application interrupt and reset control register
	// Position of VECTRESET field.
	SCB_AIRCR_VECTRESET_Pos = 0x0
	// Bit mask of VECTRESET field.
	SCB_AIRCR_VECTRESET_Msk = 0x1
	// Bit VECTRESET.
	SCB_AIRCR_VECTRESET = 0x1
	// Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1
	// Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2
	// Bit VECTCLRACTIVE.
	SCB_AIRCR_VECTCLRACTIVE = 0x2
	// Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Pos = 0x2
	// Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk = 0x4
	// Bit SYSRESETREQ.
	SCB_AIRCR_SYSRESETREQ = 0x4
	// Position of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Pos = 0x8
	// Bit mask of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Msk = 0x700
	// Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Pos = 0xf
	// Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk = 0x8000
	// Bit ENDIANESS.
	SCB_AIRCR_ENDIANESS = 0x8000
	// Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Pos = 0x10
	// Bit mask of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk = 0xffff0000

	// SCR: System control register
	// Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Pos = 0x1
	// Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2
	// Bit SLEEPONEXIT.
	SCB_SCR_SLEEPONEXIT = 0x2
	// Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Pos = 0x2
	// Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk = 0x4
	// Bit SLEEPDEEP.
	SCB_SCR_SLEEPDEEP = 0x4
	// Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Pos = 0x4
	// Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk = 0x10
	// Bit SEVEONPEND.
	SCB_SCR_SEVEONPEND = 0x10

	// CCR: Configuration and control register
	// Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Pos = 0x0
	// Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1
	// Bit NONBASETHRDENA.
	SCB_CCR_NONBASETHRDENA = 0x1
	// Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Pos = 0x1
	// Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk = 0x2
	// Bit USERSETMPEND.
	SCB_CCR_USERSETMPEND = 0x2
	// Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Pos = 0x3
	// Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk = 0x8
	// Bit UNALIGN__TRP.
	SCB_CCR_UNALIGN__TRP = 0x8
	// Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Pos = 0x4
	// Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk = 0x10
	// Bit DIV_0_TRP.
	SCB_CCR_DIV_0_TRP = 0x10
	// Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Pos = 0x8
	// Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk = 0x100
	// Bit BFHFNMIGN.
	SCB_CCR_BFHFNMIGN = 0x100
	// Position of STKALIGN field.
	SCB_CCR_STKALIGN_Pos = 0x9
	// Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN_Msk = 0x200
	// Bit STKALIGN.
	SCB_CCR_STKALIGN = 0x200

	// SHPR1: System handler priority registers
	// Position of PRI_4 field.
	SCB_SHPR1_PRI_4_Pos = 0x0
	// Bit mask of PRI_4 field.
	SCB_SHPR1_PRI_4_Msk = 0xff
	// Position of PRI_5 field.
	SCB_SHPR1_PRI_5_Pos = 0x8
	// Bit mask of PRI_5 field.
	SCB_SHPR1_PRI_5_Msk = 0xff00
	// Position of PRI_6 field.
	SCB_SHPR1_PRI_6_Pos = 0x10
	// Bit mask of PRI_6 field.
	SCB_SHPR1_PRI_6_Msk = 0xff0000

	// SHPR2: System handler priority registers
	// Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000

	// SHPR3: System handler priority registers
	// Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000

	// SHCRS: System handler control and state register
	// Position of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Pos = 0x0
	// Bit mask of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Msk = 0x1
	// Bit MEMFAULTACT.
	SCB_SHCRS_MEMFAULTACT = 0x1
	// Position of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Pos = 0x1
	// Bit mask of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Msk = 0x2
	// Bit BUSFAULTACT.
	SCB_SHCRS_BUSFAULTACT = 0x2
	// Position of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Pos = 0x3
	// Bit mask of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Msk = 0x8
	// Bit USGFAULTACT.
	SCB_SHCRS_USGFAULTACT = 0x8
	// Position of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Pos = 0x7
	// Bit mask of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Msk = 0x80
	// Bit SVCALLACT.
	SCB_SHCRS_SVCALLACT = 0x80
	// Position of MONITORACT field.
	SCB_SHCRS_MONITORACT_Pos = 0x8
	// Bit mask of MONITORACT field.
	SCB_SHCRS_MONITORACT_Msk = 0x100
	// Bit MONITORACT.
	SCB_SHCRS_MONITORACT = 0x100
	// Position of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Pos = 0xa
	// Bit mask of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Msk = 0x400
	// Bit PENDSVACT.
	SCB_SHCRS_PENDSVACT = 0x400
	// Position of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Pos = 0xb
	// Bit mask of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Msk = 0x800
	// Bit SYSTICKACT.
	SCB_SHCRS_SYSTICKACT = 0x800
	// Position of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Pos = 0xc
	// Bit mask of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Msk = 0x1000
	// Bit USGFAULTPENDED.
	SCB_SHCRS_USGFAULTPENDED = 0x1000
	// Position of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Pos = 0xd
	// Bit mask of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Msk = 0x2000
	// Bit MEMFAULTPENDED.
	SCB_SHCRS_MEMFAULTPENDED = 0x2000
	// Position of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Pos = 0xe
	// Bit mask of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Msk = 0x4000
	// Bit BUSFAULTPENDED.
	SCB_SHCRS_BUSFAULTPENDED = 0x4000
	// Position of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Pos = 0xf
	// Bit mask of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Msk = 0x8000
	// Bit SVCALLPENDED.
	SCB_SHCRS_SVCALLPENDED = 0x8000
	// Position of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Pos = 0x10
	// Bit mask of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Msk = 0x10000
	// Bit MEMFAULTENA.
	SCB_SHCRS_MEMFAULTENA = 0x10000
	// Position of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Pos = 0x11
	// Bit mask of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Msk = 0x20000
	// Bit BUSFAULTENA.
	SCB_SHCRS_BUSFAULTENA = 0x20000
	// Position of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Pos = 0x12
	// Bit mask of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Msk = 0x40000
	// Bit USGFAULTENA.
	SCB_SHCRS_USGFAULTENA = 0x40000

	// CFSR_UFSR_BFSR_MMFSR: Configurable fault status register
	// Position of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Pos = 0x1
	// Bit mask of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Msk = 0x2
	// Bit IACCVIOL.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL = 0x2
	// Position of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Pos = 0x3
	// Bit mask of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Msk = 0x8
	// Bit MUNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR = 0x8
	// Position of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Pos = 0x4
	// Bit mask of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Msk = 0x10
	// Bit MSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR = 0x10
	// Position of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Pos = 0x5
	// Bit mask of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Msk = 0x20
	// Bit MLSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR = 0x20
	// Position of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Pos = 0x7
	// Bit mask of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Msk = 0x80
	// Bit MMARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID = 0x80
	// Position of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Pos = 0x8
	// Bit mask of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Msk = 0x100
	// Bit IBUSERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR = 0x100
	// Position of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Pos = 0x9
	// Bit mask of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Msk = 0x200
	// Bit PRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR = 0x200
	// Position of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Pos = 0xa
	// Bit mask of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Msk = 0x400
	// Bit IMPRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR = 0x400
	// Position of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Pos = 0xb
	// Bit mask of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Msk = 0x800
	// Bit UNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR = 0x800
	// Position of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Pos = 0xc
	// Bit mask of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Msk = 0x1000
	// Bit STKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR = 0x1000
	// Position of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Pos = 0xd
	// Bit mask of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Msk = 0x2000
	// Bit LSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR = 0x2000
	// Position of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Pos = 0xf
	// Bit mask of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Msk = 0x8000
	// Bit BFARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID = 0x8000
	// Position of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Pos = 0x10
	// Bit mask of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Msk = 0x10000
	// Bit UNDEFINSTR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR = 0x10000
	// Position of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Pos = 0x11
	// Bit mask of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Msk = 0x20000
	// Bit INVSTATE.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE = 0x20000
	// Position of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Pos = 0x12
	// Bit mask of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Msk = 0x40000
	// Bit INVPC.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC = 0x40000
	// Position of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Pos = 0x13
	// Bit mask of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Msk = 0x80000
	// Bit NOCP.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP = 0x80000
	// Position of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Pos = 0x18
	// Bit mask of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Msk = 0x1000000
	// Bit UNALIGNED.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED = 0x1000000
	// Position of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Pos = 0x19
	// Bit mask of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Msk = 0x2000000
	// Bit DIVBYZERO.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO = 0x2000000

	// HFSR: Hard fault status register
	// Position of VECTTBL field.
	SCB_HFSR_VECTTBL_Pos = 0x1
	// Bit mask of VECTTBL field.
	SCB_HFSR_VECTTBL_Msk = 0x2
	// Bit VECTTBL.
	SCB_HFSR_VECTTBL = 0x2
	// Position of FORCED field.
	SCB_HFSR_FORCED_Pos = 0x1e
	// Bit mask of FORCED field.
	SCB_HFSR_FORCED_Msk = 0x40000000
	// Bit FORCED.
	SCB_HFSR_FORCED = 0x40000000
	// Position of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Pos = 0x1f
	// Bit mask of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Msk = 0x80000000
	// Bit DEBUG_VT.
	SCB_HFSR_DEBUG_VT = 0x80000000

	// MMFAR: Memory management fault address register
	// Position of MMFAR field.
	SCB_MMFAR_MMFAR_Pos = 0x0
	// Bit mask of MMFAR field.
	SCB_MMFAR_MMFAR_Msk = 0xffffffff

	// BFAR: Bus fault address register
	// Position of BFAR field.
	SCB_BFAR_BFAR_Pos = 0x0
	// Bit mask of BFAR field.
	SCB_BFAR_BFAR_Msk = 0xffffffff

	// AFSR: Auxiliary fault status register
	// Position of IMPDEF field.
	SCB_AFSR_IMPDEF_Pos = 0x0
	// Bit mask of IMPDEF field.
	SCB_AFSR_IMPDEF_Msk = 0xffffffff
)

// Bitfields for STK: SysTick timer
const (
	// CTRL: SysTick control and status register
	// Position of ENABLE field.
	STK_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	STK_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	STK_CTRL_ENABLE = 0x1
	// Position of TICKINT field.
	STK_CTRL_TICKINT_Pos = 0x1
	// Bit mask of TICKINT field.
	STK_CTRL_TICKINT_Msk = 0x2
	// Bit TICKINT.
	STK_CTRL_TICKINT = 0x2
	// Position of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Pos = 0x2
	// Bit mask of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Msk = 0x4
	// Bit CLKSOURCE.
	STK_CTRL_CLKSOURCE = 0x4
	// Position of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Pos = 0x10
	// Bit mask of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Msk = 0x10000
	// Bit COUNTFLAG.
	STK_CTRL_COUNTFLAG = 0x10000

	// LOAD: SysTick reload value register
	// Position of RELOAD field.
	STK_LOAD_RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	STK_LOAD_RELOAD_Msk = 0xffffff

	// VAL: SysTick current value register
	// Position of CURRENT field.
	STK_VAL_CURRENT_Pos = 0x0
	// Bit mask of CURRENT field.
	STK_VAL_CURRENT_Msk = 0xffffff

	// CALIB: SysTick calibration value register
	// Position of TENMS field.
	STK_CALIB_TENMS_Pos = 0x0
	// Bit mask of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff
	// Position of SKEW field.
	STK_CALIB_SKEW_Pos = 0x1e
	// Bit mask of SKEW field.
	STK_CALIB_SKEW_Msk = 0x40000000
	// Bit SKEW.
	STK_CALIB_SKEW = 0x40000000
	// Position of NOREF field.
	STK_CALIB_NOREF_Pos = 0x1f
	// Bit mask of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000
	// Bit NOREF.
	STK_CALIB_NOREF = 0x80000000
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	// Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0
	// Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1
	// Bit SEPARATE.
	MPU_MPU_TYPER_SEPARATE = 0x1
	// Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Pos = 0x8
	// Bit mask of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk = 0xff00
	// Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Pos = 0x10
	// Bit mask of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk = 0xff0000

	// MPU_CTRL: MPU control register
	// Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_CTRL_ENABLE = 0x1
	// Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Pos = 0x1
	// Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk = 0x2
	// Bit HFNMIENA.
	MPU_MPU_CTRL_HFNMIENA = 0x2
	// Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2
	// Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4
	// Bit PRIVDEFENA.
	MPU_MPU_CTRL_PRIVDEFENA = 0x4

	// MPU_RNR: MPU region number register
	// Position of REGION field.
	MPU_MPU_RNR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff

	// MPU_RBAR: MPU region base address register
	// Position of REGION field.
	MPU_MPU_RBAR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf
	// Position of VALID field.
	MPU_MPU_RBAR_VALID_Pos = 0x4
	// Bit mask of VALID field.
	MPU_MPU_RBAR_VALID_Msk = 0x10
	// Bit VALID.
	MPU_MPU_RBAR_VALID = 0x10
	// Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Pos = 0x5
	// Bit mask of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk = 0xffffffe0

	// MPU_RASR: MPU region attribute and size register
	// Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_RASR_ENABLE = 0x1
	// Position of SIZE field.
	MPU_MPU_RASR_SIZE_Pos = 0x1
	// Bit mask of SIZE field.
	MPU_MPU_RASR_SIZE_Msk = 0x3e
	// Position of SRD field.
	MPU_MPU_RASR_SRD_Pos = 0x8
	// Bit mask of SRD field.
	MPU_MPU_RASR_SRD_Msk = 0xff00
	// Position of B field.
	MPU_MPU_RASR_B_Pos = 0x10
	// Bit mask of B field.
	MPU_MPU_RASR_B_Msk = 0x10000
	// Bit B.
	MPU_MPU_RASR_B = 0x10000
	// Position of C field.
	MPU_MPU_RASR_C_Pos = 0x11
	// Bit mask of C field.
	MPU_MPU_RASR_C_Msk = 0x20000
	// Bit C.
	MPU_MPU_RASR_C = 0x20000
	// Position of S field.
	MPU_MPU_RASR_S_Pos = 0x12
	// Bit mask of S field.
	MPU_MPU_RASR_S_Msk = 0x40000
	// Bit S.
	MPU_MPU_RASR_S = 0x40000
	// Position of TEX field.
	MPU_MPU_RASR_TEX_Pos = 0x13
	// Bit mask of TEX field.
	MPU_MPU_RASR_TEX_Msk = 0x380000
	// Position of AP field.
	MPU_MPU_RASR_AP_Pos = 0x18
	// Bit mask of AP field.
	MPU_MPU_RASR_AP_Msk = 0x7000000
	// Position of XN field.
	MPU_MPU_RASR_XN_Pos = 0x1c
	// Bit mask of XN field.
	MPU_MPU_RASR_XN_Msk = 0x10000000
	// Bit XN.
	MPU_MPU_RASR_XN = 0x10000000
)

// Bitfields for FPU: Floting point unit
const (
	// FPCCR: Floating-point context control register
	// Position of LSPACT field.
	FPU_FPCCR_LSPACT_Pos = 0x0
	// Bit mask of LSPACT field.
	FPU_FPCCR_LSPACT_Msk = 0x1
	// Bit LSPACT.
	FPU_FPCCR_LSPACT = 0x1
	// Position of USER field.
	FPU_FPCCR_USER_Pos = 0x1
	// Bit mask of USER field.
	FPU_FPCCR_USER_Msk = 0x2
	// Bit USER.
	FPU_FPCCR_USER = 0x2
	// Position of THREAD field.
	FPU_FPCCR_THREAD_Pos = 0x3
	// Bit mask of THREAD field.
	FPU_FPCCR_THREAD_Msk = 0x8
	// Bit THREAD.
	FPU_FPCCR_THREAD = 0x8
	// Position of HFRDY field.
	FPU_FPCCR_HFRDY_Pos = 0x4
	// Bit mask of HFRDY field.
	FPU_FPCCR_HFRDY_Msk = 0x10
	// Bit HFRDY.
	FPU_FPCCR_HFRDY = 0x10
	// Position of MMRDY field.
	FPU_FPCCR_MMRDY_Pos = 0x5
	// Bit mask of MMRDY field.
	FPU_FPCCR_MMRDY_Msk = 0x20
	// Bit MMRDY.
	FPU_FPCCR_MMRDY = 0x20
	// Position of BFRDY field.
	FPU_FPCCR_BFRDY_Pos = 0x6
	// Bit mask of BFRDY field.
	FPU_FPCCR_BFRDY_Msk = 0x40
	// Bit BFRDY.
	FPU_FPCCR_BFRDY = 0x40
	// Position of MONRDY field.
	FPU_FPCCR_MONRDY_Pos = 0x8
	// Bit mask of MONRDY field.
	FPU_FPCCR_MONRDY_Msk = 0x100
	// Bit MONRDY.
	FPU_FPCCR_MONRDY = 0x100
	// Position of LSPEN field.
	FPU_FPCCR_LSPEN_Pos = 0x1e
	// Bit mask of LSPEN field.
	FPU_FPCCR_LSPEN_Msk = 0x40000000
	// Bit LSPEN.
	FPU_FPCCR_LSPEN = 0x40000000
	// Position of ASPEN field.
	FPU_FPCCR_ASPEN_Pos = 0x1f
	// Bit mask of ASPEN field.
	FPU_FPCCR_ASPEN_Msk = 0x80000000
	// Bit ASPEN.
	FPU_FPCCR_ASPEN = 0x80000000

	// FPCAR: Floating-point context address register
	// Position of ADDRESS field.
	FPU_FPCAR_ADDRESS_Pos = 0x3
	// Bit mask of ADDRESS field.
	FPU_FPCAR_ADDRESS_Msk = 0xfffffff8

	// FPSCR: Floating-point status control register
	// Position of IOC field.
	FPU_FPSCR_IOC_Pos = 0x0
	// Bit mask of IOC field.
	FPU_FPSCR_IOC_Msk = 0x1
	// Bit IOC.
	FPU_FPSCR_IOC = 0x1
	// Position of DZC field.
	FPU_FPSCR_DZC_Pos = 0x1
	// Bit mask of DZC field.
	FPU_FPSCR_DZC_Msk = 0x2
	// Bit DZC.
	FPU_FPSCR_DZC = 0x2
	// Position of OFC field.
	FPU_FPSCR_OFC_Pos = 0x2
	// Bit mask of OFC field.
	FPU_FPSCR_OFC_Msk = 0x4
	// Bit OFC.
	FPU_FPSCR_OFC = 0x4
	// Position of UFC field.
	FPU_FPSCR_UFC_Pos = 0x3
	// Bit mask of UFC field.
	FPU_FPSCR_UFC_Msk = 0x8
	// Bit UFC.
	FPU_FPSCR_UFC = 0x8
	// Position of IXC field.
	FPU_FPSCR_IXC_Pos = 0x4
	// Bit mask of IXC field.
	FPU_FPSCR_IXC_Msk = 0x10
	// Bit IXC.
	FPU_FPSCR_IXC = 0x10
	// Position of IDC field.
	FPU_FPSCR_IDC_Pos = 0x7
	// Bit mask of IDC field.
	FPU_FPSCR_IDC_Msk = 0x80
	// Bit IDC.
	FPU_FPSCR_IDC = 0x80
	// Position of RMode field.
	FPU_FPSCR_RMode_Pos = 0x16
	// Bit mask of RMode field.
	FPU_FPSCR_RMode_Msk = 0xc00000
	// Position of FZ field.
	FPU_FPSCR_FZ_Pos = 0x18
	// Bit mask of FZ field.
	FPU_FPSCR_FZ_Msk = 0x1000000
	// Bit FZ.
	FPU_FPSCR_FZ = 0x1000000
	// Position of DN field.
	FPU_FPSCR_DN_Pos = 0x19
	// Bit mask of DN field.
	FPU_FPSCR_DN_Msk = 0x2000000
	// Bit DN.
	FPU_FPSCR_DN = 0x2000000
	// Position of AHP field.
	FPU_FPSCR_AHP_Pos = 0x1a
	// Bit mask of AHP field.
	FPU_FPSCR_AHP_Msk = 0x4000000
	// Bit AHP.
	FPU_FPSCR_AHP = 0x4000000
	// Position of V field.
	FPU_FPSCR_V_Pos = 0x1c
	// Bit mask of V field.
	FPU_FPSCR_V_Msk = 0x10000000
	// Bit V.
	FPU_FPSCR_V = 0x10000000
	// Position of C field.
	FPU_FPSCR_C_Pos = 0x1d
	// Bit mask of C field.
	FPU_FPSCR_C_Msk = 0x20000000
	// Bit C.
	FPU_FPSCR_C = 0x20000000
	// Position of Z field.
	FPU_FPSCR_Z_Pos = 0x1e
	// Bit mask of Z field.
	FPU_FPSCR_Z_Msk = 0x40000000
	// Bit Z.
	FPU_FPSCR_Z = 0x40000000
	// Position of N field.
	FPU_FPSCR_N_Pos = 0x1f
	// Bit mask of N field.
	FPU_FPSCR_N_Msk = 0x80000000
	// Bit N.
	FPU_FPSCR_N = 0x80000000
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER0_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff

	// ISER1: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER1_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff

	// ICER0: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER0_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff

	// ICER1: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER1_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff

	// ISPR0: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff

	// ISPR1: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff

	// ICPR0: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff

	// ICPR1: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff

	// IABR0: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff

	// IABR1: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff

	// IPR0: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000

	// IPR1: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000

	// IPR2: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000

	// IPR3: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000

	// IPR4: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000

	// IPR5: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000

	// IPR6: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000

	// IPR7: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000

	// IPR8: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000

	// IPR9: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000

	// IPR10: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000

	// IPR11: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000

	// IPR12: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000

	// IPR13: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000

	// IPR14: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Msk = 0xff000000

	// IPR15: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Msk = 0xff000000

	// IPR16: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Msk = 0xff000000

	// IPR17: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Msk = 0xff000000
)
