
[//]: # (Generated 2021-01-14T21:19:07.436154. Changes belong into template/documentation/readme.template)

#Vico
Program version 1.2.2


THIS PROGRAM IS NO LONGER IN DEVELOPMENT. NO FURTHER UPDATES!
In August 2020 it became clear that the choice of programming languages and libraries lead to grave performance problems.
Combined with the fact that this is hardly a unique program, a piano roll midi sequencer, it has been decided that
no further development will happen. Here is the original description of the program:

Vico is a minimalistic Midi sequencer that is intended to be used in parallel with other software.

"Vico" (with c like ts in "bats") just means "sequence" or "order" in Esperanto for obvious reasons.

In a loop- or pattern based environment you often want to have a 'free flowing' track in order to
create an instrumental solo, for example. Sometimes you just want to record a sketch or an idea
quickly and not open or create an entire DAW project.

Vico fulfills these conditions by connecting exactly one source to one output, and records and
plays back in between. Or to put it another way: you only get one track, intended
for one instrument (but with convenient layers).

Vico has been written primarily for users of Patroneo, but has no closer technical bond. Patroneo
is a program characterized by strict repetitions and constant reuse of very short patterns. With
this you can quickly create whole arrangements for drums, bass and accompaniment chords, but a
beautiful, long melody is extremely cumbersome. Therefore Vico wants to solve this problem.

However, all programs that run as JACK transport masters or JACK timebase masters are suitable as
"remote control".


This README is just a short introduction. Consult the manual (see below) for more information.

# Contact and Information

* Website https://www.laborejo.org
* Bugs and Issues: https://www.laborejo.org/bugs
* Git Repositories for all programs: https://git.laborejo.org
* Documentation and Manual https://www.laborejo.org/documentation/vico

# Installation and Starting

## Download

### Release Version
If the latest release is not available through your package manger you can build it yourself:
Download the latest code release on https://www.laborejo.org/downloads and extract it.

### Git Version
It is possible to clone a git repository.

`git clone https://git.laborejo.org/lss/vico.git`

## Dependencies
* Glibc
* Python 3.6 (maybe earlier)
* PyQt5 for Python 3
* DejaVu Sans Sarif TTF (Font) (recommended, but not technically necessary)


#### Build Dependencies
* Bash
* GCC (development is done on 8.2, but most likely you can use a much earlier version)

### Environment:
* Jack Audio Connection Kit must be running
* Agordejo / New Session Manager ("NSM")

## Build
    ./configure --prefix=/usr/local
    make
    sudo make install


## Starting

There are multiple ways to run Vico which should give you the flexibility to configure your
system as you want.

We make no distinction if you installed Vico yourself or through the distributions package-manager.

The differences are: With or without Agordejo, with or without sound, installed or from the source dir.

### Installed , running through Agordejo (New Session Manager) (recommended)
Starting Vico through Agordejo after you installed vico system-wide
is the recommended and only supported way. Start agordejo and load or create a new
session. Then use the program launcher to add `vico`.
It should appear with an icon in the list and open its GUI.

### Installed without Agordejo
If you start vico directly it will present you with a dialog to choose your session directory.

You can also start vico from a terminal (or create a starter script).

`vico --save DIRECTORY`

Uses the given directory to save. The dir will be created or loaded from if already present. Use
the applications file menu to save (Ctrl+s).

You can use this to load and save the files from an existing NSM session. If you create a new
directory you can copy it manually to an NSM session directory, but that requires renaming the
directory to append the unique ID provided by NSM.

Sending SIGUSR1 to the program in this mode will trigger a save.

Closing through your window manager in this mode will actually quit the application without a
prompt to save changes.

## From source directory
You can run Vico after extracting the release archive or cloning from git, without installation.

### Calfbox
"Calfbox" is the name of our internal realtime midi/audio python module.

* It is bundled with the application for a normal install.
* Or you could run `./configure` and `make calfbox` without subsequent install, which creates a `sitepackages` directory in the source dir. You can then run `./vico` directly from the source.
* A third option is `./vico --mute` which runs without sound at all and does not need calfbox.

### From source directory with NSM
The developer uses this way to develop and use the software, so it will always be as stable as the
compiled version. But it is a bit less performant than building and installing it.

After extracting the release archive create a symlink from `vico` into your PATH. e.g. /usr/bin
or ~/bin, if that exists on your system.

If you compiled without installing you can also symlink to `./vico.bin`

### From source dir without NSM
Use `./vico --save` (see above). If you compiled without installing you can also run `./vico.bin`

### No NSM, no Make, No Sound
Combining the above options you can start the program directly after unpacking or cloning from git:

`./vico --save /tmp --mute`

Or even shorter:

`./vico -s /tmp -m`

This is the minimal run mode which is only useful for testing and development. But if you only want
to look at the GUI and are not in the mood to install anything -including dependencies-, go ahead.

