/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.prefix.DefaultPluginPrefixRequest;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.prefix.PluginPrefixResolver;
import org.apache.maven.plugin.prefix.PluginPrefixResult;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=MojoDescriptorCreator.class)
public class MojoDescriptorCreator {
    @Requirement
    private Logger logger;
    @Requirement
    private PluginVersionResolver pluginVersionResolver;
    @Requirement
    private BuildPluginManager pluginManager;
    @Requirement
    private PluginPrefixResolver pluginPrefixResolver;
    @Requirement
    private LifecyclePluginResolver lifecyclePluginResolver;

    public MojoDescriptorCreator() {
    }

    public MojoDescriptorCreator(PluginVersionResolver pluginVersionResolver, BuildPluginManager pluginManager, PluginPrefixResolver pluginPrefixResolver, LifecyclePluginResolver lifecyclePluginResolver) {
        this.pluginVersionResolver = pluginVersionResolver;
        this.pluginManager = pluginManager;
        this.pluginPrefixResolver = pluginPrefixResolver;
        this.lifecyclePluginResolver = lifecyclePluginResolver;
    }

    private Plugin findPlugin(String groupId, String artifactId, Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!artifactId.equals(plugin.getArtifactId()) || !groupId.equals(plugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }

    public static Xpp3Dom convert(MojoDescriptor mojoDescriptor) {
        Xpp3Dom dom = new Xpp3Dom("configuration");
        PlexusConfiguration c = mojoDescriptor.getMojoConfiguration();
        PlexusConfiguration[] ces = c.getChildren();
        if (ces != null) {
            for (PlexusConfiguration ce : ces) {
                String value = ce.getValue(null);
                String defaultValue = ce.getAttribute("default-value", null);
                if (value == null && defaultValue == null) continue;
                Xpp3Dom e2 = new Xpp3Dom(ce.getName());
                e2.setValue(value);
                if (defaultValue != null) {
                    e2.setAttribute("default-value", defaultValue);
                }
                dom.addChild(e2);
            }
        }
        return dom;
    }

    public MojoDescriptor getMojoDescriptor(String task, MavenSession session2, MavenProject project2) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        int executionIdx;
        String goal = null;
        Plugin plugin = null;
        StringTokenizer tok = new StringTokenizer(task, ":");
        int numTokens = tok.countTokens();
        if (numTokens >= 4) {
            plugin = new Plugin();
            plugin.setGroupId(tok.nextToken());
            plugin.setArtifactId(tok.nextToken());
            plugin.setVersion(tok.nextToken());
            goal = tok.nextToken();
            while (tok.hasMoreTokens()) {
                goal = goal + ":" + tok.nextToken();
            }
        } else if (numTokens == 3) {
            plugin = new Plugin();
            plugin.setGroupId(tok.nextToken());
            plugin.setArtifactId(tok.nextToken());
            goal = tok.nextToken();
        } else if (numTokens <= 2) {
            String prefix = tok.nextToken();
            goal = numTokens == 2 ? tok.nextToken() : "";
            plugin = this.findPluginForPrefix(prefix, session2);
        }
        if ((executionIdx = goal.indexOf(64)) > 0) {
            goal = goal.substring(0, executionIdx);
        }
        this.injectPluginDeclarationFromProject(plugin, project2);
        if (plugin.getVersion() == null) {
            this.resolvePluginVersion(plugin, session2, project2);
        }
        return this.pluginManager.getMojoDescriptor(plugin, goal, project2.getRemotePluginRepositories(), session2.getRepositorySession());
    }

    public Plugin findPluginForPrefix(String prefix, MavenSession session2) throws NoPluginFoundForPrefixException {
        if (session2.getCurrentProject() != null) {
            try {
                this.lifecyclePluginResolver.resolveMissingPluginVersions(session2.getCurrentProject(), session2);
            }
            catch (PluginVersionResolutionException e2) {
                this.logger.debug(e2.getMessage(), e2);
            }
        }
        DefaultPluginPrefixRequest prefixRequest = new DefaultPluginPrefixRequest(prefix, session2);
        PluginPrefixResult prefixResult = this.pluginPrefixResolver.resolve(prefixRequest);
        Plugin plugin = new Plugin();
        plugin.setGroupId(prefixResult.getGroupId());
        plugin.setArtifactId(prefixResult.getArtifactId());
        return plugin;
    }

    private void resolvePluginVersion(Plugin plugin, MavenSession session2, MavenProject project2) throws PluginVersionResolutionException {
        DefaultPluginVersionRequest versionRequest = new DefaultPluginVersionRequest(plugin, session2.getRepositorySession(), project2.getRemotePluginRepositories());
        plugin.setVersion(this.pluginVersionResolver.resolve(versionRequest).getVersion());
    }

    private void injectPluginDeclarationFromProject(Plugin plugin, MavenProject project2) {
        Plugin pluginInPom = this.findPlugin(plugin, project2.getBuildPlugins());
        if (pluginInPom == null && project2.getPluginManagement() != null) {
            pluginInPom = this.findPlugin(plugin, project2.getPluginManagement().getPlugins());
        }
        if (pluginInPom != null) {
            if (plugin.getVersion() == null) {
                plugin.setVersion(pluginInPom.getVersion());
            }
            plugin.setDependencies(new ArrayList<Dependency>(pluginInPom.getDependencies()));
        }
    }

    private Plugin findPlugin(Plugin plugin, Collection<Plugin> plugins) {
        return this.findPlugin(plugin.getGroupId(), plugin.getArtifactId(), plugins);
    }
}

