/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultRepositoryEventDispatcher
implements RepositoryEventDispatcher,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryEventDispatcher.class);
    private Collection<RepositoryListener> listeners = new ArrayList<RepositoryListener>();

    public DefaultRepositoryEventDispatcher() {
    }

    @Inject
    DefaultRepositoryEventDispatcher(Set<RepositoryListener> listeners) {
        this.setRepositoryListeners(listeners);
    }

    public DefaultRepositoryEventDispatcher addRepositoryListener(RepositoryListener listener) {
        this.listeners.add(Objects.requireNonNull(listener, "repository listener cannot be null"));
        return this;
    }

    public DefaultRepositoryEventDispatcher setRepositoryListeners(Collection<RepositoryListener> listeners) {
        this.listeners = listeners == null ? new ArrayList<RepositoryListener>() : listeners;
        return this;
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRepositoryListeners(locator.getServices(RepositoryListener.class));
    }

    @Override
    public void dispatch(RepositoryEvent event2) {
        RepositoryListener listener;
        if (!this.listeners.isEmpty()) {
            for (RepositoryListener listener2 : this.listeners) {
                this.dispatch(event2, listener2);
            }
        }
        if ((listener = event2.getSession().getRepositoryListener()) != null) {
            this.dispatch(event2, listener);
        }
    }

    private void dispatch(RepositoryEvent event2, RepositoryListener listener) {
        try {
            switch (event2.getType()) {
                case ARTIFACT_DEPLOYED: {
                    listener.artifactDeployed(event2);
                    break;
                }
                case ARTIFACT_DEPLOYING: {
                    listener.artifactDeploying(event2);
                    break;
                }
                case ARTIFACT_DESCRIPTOR_INVALID: {
                    listener.artifactDescriptorInvalid(event2);
                    break;
                }
                case ARTIFACT_DESCRIPTOR_MISSING: {
                    listener.artifactDescriptorMissing(event2);
                    break;
                }
                case ARTIFACT_DOWNLOADED: {
                    listener.artifactDownloaded(event2);
                    break;
                }
                case ARTIFACT_DOWNLOADING: {
                    listener.artifactDownloading(event2);
                    break;
                }
                case ARTIFACT_INSTALLED: {
                    listener.artifactInstalled(event2);
                    break;
                }
                case ARTIFACT_INSTALLING: {
                    listener.artifactInstalling(event2);
                    break;
                }
                case ARTIFACT_RESOLVED: {
                    listener.artifactResolved(event2);
                    break;
                }
                case ARTIFACT_RESOLVING: {
                    listener.artifactResolving(event2);
                    break;
                }
                case METADATA_DEPLOYED: {
                    listener.metadataDeployed(event2);
                    break;
                }
                case METADATA_DEPLOYING: {
                    listener.metadataDeploying(event2);
                    break;
                }
                case METADATA_DOWNLOADED: {
                    listener.metadataDownloaded(event2);
                    break;
                }
                case METADATA_DOWNLOADING: {
                    listener.metadataDownloading(event2);
                    break;
                }
                case METADATA_INSTALLED: {
                    listener.metadataInstalled(event2);
                    break;
                }
                case METADATA_INSTALLING: {
                    listener.metadataInstalling(event2);
                    break;
                }
                case METADATA_INVALID: {
                    listener.metadataInvalid(event2);
                    break;
                }
                case METADATA_RESOLVED: {
                    listener.metadataResolved(event2);
                    break;
                }
                case METADATA_RESOLVING: {
                    listener.metadataResolving(event2);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown repository event type " + (Object)((Object)event2.getType()));
                }
            }
        }
        catch (Exception | LinkageError e2) {
            this.logError(e2, listener);
        }
    }

    private void logError(Throwable e2, Object listener) {
        LOGGER.warn("Failed to dispatch repository event to {}", (Object)listener.getClass().getCanonicalName(), (Object)e2);
    }
}

