/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop.reporter;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gephi.branding.desktop.reporter.Report;
import org.gephi.branding.desktop.reporter.ReportController;
import org.gephi.branding.desktop.reporter.ViewDataPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;

public class ReportPanel
extends JPanel {
    private final Report report;
    private final ReportController reportController = new ReportController();
    private final Document document;
    private JTextField emailTextField;
    private JCheckBox followCheckBox;
    private JLabel helpLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JLabel labelEmail;
    private JTextArea problemArea;
    private JTextField summaryTextField;
    private JButton viewDataButton;

    public ReportPanel(Report report) {
        this.report = report;
        this.document = this.reportController.buildReportDocument(this.report);
        this.initComponents();
        this.followCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportPanel.this.labelEmail.setEnabled(ReportPanel.this.followCheckBox.isSelected());
                ReportPanel.this.emailTextField.setEnabled(ReportPanel.this.followCheckBox.isSelected());
                ReportPanel.this.helpLabel.setEnabled(ReportPanel.this.followCheckBox.isSelected());
            }
        });
        this.labelEmail.setEnabled(this.followCheckBox.isSelected());
        this.emailTextField.setEnabled(this.followCheckBox.isSelected());
        this.helpLabel.setEnabled(this.followCheckBox.isSelected());
        this.viewDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportPanel.this.report.setUserDescription(ReportPanel.this.problemArea.getText());
                ReportPanel.this.report.setUserEmail(ReportPanel.this.emailTextField.getText());
                DialogDescriptor dd = new DialogDescriptor((Object)new ViewDataPanel(ReportPanel.this.document), NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.viewData.title"), true, -1, null, null);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            }
        });
        this.setup();
    }

    private void setup() {
        this.summaryTextField.setText(this.report.getSummary());
        this.emailTextField.setText(this.report.getUserEmail());
        this.problemArea.setText(this.report.getUserDescription());
    }

    public void showDialog() {
        Object[] options = new Object[]{NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.dialog.sendButton"), DialogDescriptor.CANCEL_OPTION};
        String title = NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.dialog.title");
        DialogDescriptor dd = new DialogDescriptor((Object)this, title, true, options, options[0], 0, null, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == options[0]) {
            this.report.setUserDescription(this.problemArea.getText());
            this.report.setUserEmail(this.emailTextField.getText());
            this.reportController.sendReport(this.report);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.summaryTextField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.problemArea = new JTextArea();
        this.jLabel2 = new JLabel();
        this.followCheckBox = new JCheckBox();
        this.labelEmail = new JLabel();
        this.emailTextField = new JTextField();
        this.helpLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.viewDataButton = new JButton();
        this.jLabel1.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel1.text"));
        this.summaryTextField.setEditable(false);
        this.summaryTextField.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.summaryTextField.text"));
        this.problemArea.setColumns(20);
        this.problemArea.setRows(5);
        this.jScrollPane1.setViewportView(this.problemArea);
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setForeground(new Color(0, 73, 204));
        this.jLabel2.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel2.text"));
        this.followCheckBox.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.followCheckBox.text"));
        this.labelEmail.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.labelEmail.text"));
        this.emailTextField.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.emailTextField.text"));
        this.helpLabel.setFont(new Font("Tahoma", 0, 10));
        this.helpLabel.setForeground(new Color(102, 102, 102));
        this.helpLabel.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.helpLabel.text"));
        this.jLabel3.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.jLabel3.text"));
        this.viewDataButton.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.viewDataButton.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 128, Short.MAX_VALUE).addComponent(this.viewDataButton)).addComponent(this.jScrollPane1, -1, 572, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 572, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.summaryTextField, -1, 520, Short.MAX_VALUE)).addComponent(this.followCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.labelEmail).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.helpLabel, -1, 517, Short.MAX_VALUE).addComponent(this.emailTextField, -1, 517, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, 14, -2).addComponent(this.viewDataButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.summaryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 149, -2)).addGroup(layout.createSequentialGroup().addGap(218, 218, 218).addComponent(this.followCheckBox))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.emailTextField, -2, -1, -2).addComponent(this.labelEmail)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

