/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import javax.swing.SwingUtilities;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.JaveleonModule;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.NbInstaller;
import org.openide.modules.Dependency;
import org.openide.util.Exceptions;

class JaveleonModuleReloader {
    private static JaveleonModuleReloader reloader = new JaveleonModuleReloader();
    private HashMap<String, Module> registeredModules = new HashMap();

    static JaveleonModuleReloader getDefault() {
        return reloader;
    }

    private JaveleonModuleReloader() {
    }

    boolean reloadJaveleonModule(File jar, ModuleManager mgr, NbInstaller installer, Events ev) throws IOException {
        if (!JaveleonModule.incrementGlobalId()) {
            return false;
        }
        System.err.println("Start Javeleon module update...");
        Module m = null;
        JaveleonModule tm = null;
        for (Module module : mgr.getModules()) {
            if (module.getJarFile() == null || !jar.equals(module.getJarFile())) continue;
            m = module;
            tm = this.createJaveleonModule(mgr, jar, new ModuleHistory(jar.getAbsolutePath()));
            break;
        }
        if (m == null) {
            return false;
        }
        List dependents = mgr.simulateJaveleonReload(m);
        this.setupClassLoaderForJaveleonModule(mgr, tm);
        this.refreshLayer(m, (Module)tm, installer, mgr);
        for (Module m3 : dependents) {
            File moduleJar = m3.getJarFile();
            JaveleonModule toRefresh = this.createJaveleonModule(mgr, moduleJar, new ModuleHistory(moduleJar.getAbsolutePath()));
            this.setupClassLoaderForJaveleonModule(mgr, toRefresh);
            this.refreshLayer(m3, (Module)toRefresh, installer, mgr);
        }
        System.err.println("Javeleon finished module update...");
        MainLookup.systemClassLoaderChanged(mgr.getClassLoader());
        ev.log("finishDeployTestModule", new Object[]{jar});
        return true;
    }

    private JaveleonModule createJaveleonModule(ModuleManager mgr, File jar, Object history) throws IOException {
        try {
            return new JaveleonModule(mgr, jar.getAbsoluteFile(), history, mgr.getEvents());
        }
        catch (IOException ex) {
            System.err.println("EXCEPTION IN MGR.createJav...");
            throw ex;
        }
    }

    private void setupClassLoaderForJaveleonModule(ModuleManager mgr, JaveleonModule javeleonModule) throws InvalidException {
        try {
            Dependency[] dependencies = javeleonModule.getDependenciesArray();
            HashSet<Module> parents = new HashSet<Module>(dependencies.length * 4 / 3 + 1);
            for (Dependency dep : dependencies) {
                if (dep.getType() != 1) continue;
                String name = (String)Util.parseCodeName((String)dep.getName())[0];
                Module parent = mgr.get(name);
                if (parent == null) {
                    throw new IOException("Parent " + name + " not found!");
                }
                parents.add(parent);
            }
            javeleonModule.classLoaderUp(parents);
        }
        catch (IOException ioe) {
            InvalidException ie = new InvalidException((Module)javeleonModule, ioe.toString());
            ie.initCause((Throwable)ioe);
            throw ie;
        }
    }

    private Set<?> getOpenTopComponents(ClassLoader loader) {
        try {
            Class<?> classWindowManager = loader.loadClass("org.openide.windows.WindowManager");
            Object manager = classWindowManager.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
            Object registry = classWindowManager.getMethod("getRegistry", new Class[0]).invoke(manager, new Object[0]);
            Class<?> classRegistry = loader.loadClass("org.openide.windows.TopComponent$Registry");
            return (Set)classRegistry.getMethod("getOpened", new Class[0]).invoke(registry, new Object[0]);
        }
        catch (Exception ex) {
            return Collections.emptySet();
        }
    }

    private void restoreOpenTopComponents(final ClassLoader loader, final Set<?> openTCs) {
        if (openTCs == null || openTCs.isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> classTopComponent = loader.loadClass("org.openide.windows.TopComponent");
                    for (Object topComponent : openTCs) {
                        classTopComponent.getMethod("open", new Class[0]).invoke(topComponent, new Object[0]);
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void refreshLayer(Module original, Module newModule, NbInstaller installer, ModuleManager mgr) {
        try {
            boolean changed = this.layersChanged(original, newModule);
            Set<?> openTCs = null;
            if (changed) {
                openTCs = this.getOpenTopComponents(mgr.getClassLoader());
                Module registeredModule = this.getAndClearRegisteredModule(original);
                installer.loadLayers(Collections.singletonList(registeredModule), false);
                installer.dispose(registeredModule);
            }
            mgr.replaceJaveleonModule(original, newModule);
            if (changed) {
                installer.prepare(newModule);
                installer.loadLayers(Collections.singletonList(newModule), true);
                this.registerModule(newModule);
                this.restoreOpenTopComponents(mgr.getClassLoader(), openTCs);
            }
            if (!changed && !(original instanceof JaveleonModule)) {
                this.registerModule(original);
            }
        }
        catch (InvalidException changed) {
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
        }
    }

    private boolean layersChanged(Module m1, Module m2) {
        return this.CRC32Layer(m1) != this.CRC32Layer(m2) || this.CRC32GeneratedLayer(m1) != this.CRC32GeneratedLayer(m2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateChecksum(URL layer) {
        long l;
        if (layer == null) {
            return -1L;
        }
        InputStream is = layer.openStream();
        try {
            CheckedInputStream cis = new CheckedInputStream(is, new CRC32());
            byte[] buf = new byte[1024];
            while (cis.read(buf) >= 0) {
            }
            cis.close();
            l = cis.getChecksum().getValue();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                return -1L;
            }
        }
        is.close();
        return l;
    }

    private long CRC32Layer(Module m) {
        String layerResource = m.getManifest().getMainAttributes().getValue("OpenIDE-Module-Layer");
        String osgi = m.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
        if (layerResource != null && osgi == null) {
            URL layer = m.getClassLoader().getResource(layerResource);
            return this.calculateChecksum(layer);
        }
        return -1L;
    }

    private long CRC32GeneratedLayer(Module m) {
        String layerRessource = "META-INF/generated-layer.xml";
        URL layer = m.getClassLoader().getResource(layerRessource);
        return this.calculateChecksum(layer);
    }

    private Module getAndClearRegisteredModule(Module original) {
        return this.registeredModules.containsKey(original.getCodeNameBase()) ? this.registeredModules.remove(original.getCodeNameBase()) : original;
    }

    private void registerModule(Module newModule) {
        this.registeredModules.put(newModule.getCodeNameBase(), newModule);
    }
}

