/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.net.MalformedURLException;
import java.net.URL;

public abstract class MapSource {
    protected String[] _extensions = null;

    public abstract int getNumLayers();

    public abstract String getName();

    public abstract String getBaseUrl(int var1);

    public abstract String getSiteName(int var1);

    public final String getFileExtension(int n) {
        return this._extensions[n];
    }

    public abstract String makeURL(int var1, int var2, int var3, int var4);

    public abstract int getMaxZoomLevel();

    public String makeFilePath(int n, int n2, int n3, int n4) {
        return String.valueOf(this.getSiteName(n)) + n2 + "/" + n3 + "/" + n4 + "." + this.getFileExtension(n);
    }

    public static String fixBaseUrl(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = string;
        boolean bl = false;
        try {
            bl = new URL(string2.replace('[', 'w').replace(']', 'w')).toString() != null;
        }
        catch (MalformedURLException malformedURLException) {
            bl = false;
        }
        if (!bl) {
            if (string2.indexOf("://") >= 0) {
                return null;
            }
            string2 = "http://" + string2;
        }
        if (!string2.endsWith("/")) {
            string2 = String.valueOf(string2) + "/";
        }
        try {
            URL uRL = new URL(string2.replace('[', 'w').replace(']', 'w'));
            if (uRL.getHost().indexOf(46) < 0) {
                return null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            string2 = null;
        }
        return string2;
    }

    public abstract String getConfigString();

    public String getSiteStrings() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.getNumLayers()) {
            String string = this.getBaseUrl(n);
            if (string != null) {
                stringBuilder.append(string);
                stringBuilder.append(';');
                stringBuilder.append(this.getFileExtension(n));
                stringBuilder.append(';');
            }
            ++n;
        }
        return stringBuilder.toString();
    }
}

