/*
 * Decompiled with CFR 0.152.
 */
package hdf.hdf5lib;

import hdf.hdf5lib.ArrayDescriptor;
import hdf.hdf5lib.HDFNativeData;
import hdf.hdf5lib.exceptions.HDF5Exception;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public class HDFArray {
    private Object _theArray = null;
    private ArrayDescriptor _desc = null;
    private byte[] _barray = null;

    public HDFArray(Object object) throws HDF5Exception {
        Serializable serializable;
        if (object == null) {
            serializable = new HDF5JavaException("HDFArray: array is null?: ");
        }
        if (!(serializable = object.getClass()).isArray()) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: not an array?: ");
            throw hDF5JavaException;
        }
        this._theArray = object;
        this._desc = new ArrayDescriptor(this._theArray);
        if (this._desc == null) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: internal error: array description failed?: ");
            throw hDF5JavaException;
        }
    }

    public byte[] emptyBytes() throws HDF5JavaException {
        byte[] byArray = null;
        byArray = ArrayDescriptor.dims == 1 && ArrayDescriptor.NT == 'B' ? (byte[])this._theArray : new byte[ArrayDescriptor.totalSize];
        if (byArray == null) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: emptyBytes: allocation failed");
            throw hDF5JavaException;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] byteify() throws HDF5JavaException {
        int n;
        if (this._barray != null) {
            return this._barray;
        }
        if (this._theArray == null) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify not an array?: ");
            throw hDF5JavaException;
        }
        if (ArrayDescriptor.dims == 1) {
            if (ArrayDescriptor.NT == 'B') {
                this._barray = (byte[])this._theArray;
                return this._barray;
            }
            try {
                byte[] byArray;
                this._barray = new byte[ArrayDescriptor.totalSize];
                if (ArrayDescriptor.NT == 'I') {
                    byArray = HDFNativeData.intToByte(0, ArrayDescriptor.dimlen[1], (int[])this._theArray);
                } else if (ArrayDescriptor.NT == 'S') {
                    byArray = HDFNativeData.shortToByte(0, ArrayDescriptor.dimlen[1], (short[])this._theArray);
                } else if (ArrayDescriptor.NT == 'F') {
                    byArray = HDFNativeData.floatToByte(0, ArrayDescriptor.dimlen[1], (float[])this._theArray);
                } else if (ArrayDescriptor.NT == 'J') {
                    byArray = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[1], (long[])this._theArray);
                } else if (ArrayDescriptor.NT == 'D') {
                    byArray = HDFNativeData.doubleToByte(0, ArrayDescriptor.dimlen[1], (double[])this._theArray);
                } else {
                    if (ArrayDescriptor.NT != 'L') {
                        HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: unknown type of data?");
                        throw hDF5JavaException;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        byArray = this.ByteObjToByte((Byte[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        byArray = this.IntegerToByte((Integer[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        byArray = this.ShortToByte((Short[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        byArray = this.FloatObjToByte((Float[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        byArray = this.DoubleObjToByte((Double[])this._theArray);
                    } else {
                        if (!ArrayDescriptor.className.equals("java.lang.Long")) {
                            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: unknown type of Object?");
                            throw hDF5JavaException;
                        }
                        byArray = this.LongObjToByte((Long[])this._theArray);
                    }
                }
                System.arraycopy(byArray, 0, this._barray, 0, ArrayDescriptor.dimlen[1] * ArrayDescriptor.NTsize);
                return this._barray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify array too big?");
                throw hDF5JavaException;
            }
        }
        try {
            this._barray = new byte[ArrayDescriptor.totalSize];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify array too big?");
            throw hDF5JavaException;
        }
        Object object = this._theArray;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n2 >= ArrayDescriptor.totalSize) {
                if (n2 < ArrayDescriptor.totalSize) {
                    throw new InternalError(new String("HDFArray::byteify: Panic didn't complete all input data: n=  " + n2 + " size = " + ArrayDescriptor.totalSize));
                }
                break;
            }
            object = ArrayDescriptor.objs[0];
            n3 = n2 / ArrayDescriptor.bytetoindex[0];
            n3 %= ArrayDescriptor.dimlen[0];
            for (n = 0; n < ArrayDescriptor.dims; ++n) {
                n3 = n2 / ArrayDescriptor.bytetoindex[n];
                if ((n3 %= ArrayDescriptor.dimlen[n]) == ArrayDescriptor.currentindex[n]) {
                    object = ArrayDescriptor.objs[n];
                    continue;
                }
                if (n3 > ArrayDescriptor.dimlen[n] - 1) {
                    throw new IndexOutOfBoundsException("HDFArray: byteify index OOB?");
                }
                object = Array.get(object, n3);
                ArrayDescriptor.currentindex[n] = n3;
                ArrayDescriptor.objs[n] = object;
            }
            try {
                byte[] byArray;
                if (ArrayDescriptor.NT == 'J') {
                    byArray = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    byArray = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'I') {
                    byArray = HDFNativeData.intToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (int[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'S') {
                    byArray = HDFNativeData.shortToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (short[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'B') {
                    byArray = (byte[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1];
                } else if (ArrayDescriptor.NT == 'F') {
                    byArray = HDFNativeData.floatToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (float[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'D') {
                    byArray = HDFNativeData.doubleToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (double[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else {
                    if (ArrayDescriptor.NT != 'L') {
                        HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify unknown type not implemented?");
                        throw hDF5JavaException;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        byArray = this.ByteObjToByte((Byte[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        byArray = this.IntegerToByte((Integer[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        byArray = this.ShortToByte((Short[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        byArray = this.FloatObjToByte((Float[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        byArray = this.DoubleObjToByte((Double[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else {
                        if (!ArrayDescriptor.className.equals("java.lang.Long")) {
                            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify Object type not implemented?");
                            throw hDF5JavaException;
                        }
                        byArray = this.LongObjToByte((Long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    }
                }
                System.arraycopy(byArray, 0, this._barray, n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims] * ArrayDescriptor.NTsize);
                n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify array too big?");
                throw hDF5JavaException;
            }
        }
        n = 0;
        while (n < ArrayDescriptor.dims) {
            if (ArrayDescriptor.currentindex[n] != ArrayDescriptor.dimlen[n] - 1) {
                throw new InternalError(new String("Panic didn't complete all data: currentindex[" + n + "] = " + ArrayDescriptor.currentindex[n] + " (should be " + (ArrayDescriptor.dimlen[n] - 1) + " ?)"));
            }
            ++n;
        }
        return this._barray;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object arrayify(byte[] var1_1) throws HDF5JavaException {
        if (this._theArray == null) {
            var2_2 = new HDF5JavaException("arrayify: not an array?: ");
            throw var2_2;
        }
        if (Array.getLength(var1_1) != ArrayDescriptor.totalSize) {
            var2_3 = new HDF5JavaException("arrayify: array is wrong size?: ");
            throw var2_3;
        }
        this._barray = var1_1;
        if (ArrayDescriptor.dims == 1) {
            try {
                if (ArrayDescriptor.NT == 'I') {
                    var2_4 = HDFNativeData.byteToInt(this._barray);
                    System.arraycopy(var2_4, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'S') {
                    var2_5 = HDFNativeData.byteToShort(this._barray);
                    System.arraycopy(var2_5, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'F') {
                    var2_6 = HDFNativeData.byteToFloat(this._barray);
                    System.arraycopy(var2_6, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'J') {
                    var2_7 = HDFNativeData.byteToLong(this._barray);
                    System.arraycopy(var2_7, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'D') {
                    var2_8 = HDFNativeData.byteToDouble(this._barray);
                    System.arraycopy(var2_8, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'B') {
                    System.arraycopy(this._barray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'L') {
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        var2_9 = this.ByteToByteObj(this._barray);
                        System.arraycopy(var2_9, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        var2_10 = this.ByteToInteger(this._barray);
                        System.arraycopy(var2_10, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        var2_11 = this.ByteToShort(this._barray);
                        System.arraycopy(var2_11, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        var2_12 = this.ByteToFloatObj(this._barray);
                        System.arraycopy(var2_12, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        var2_13 = this.ByteToDoubleObj(this._barray);
                        System.arraycopy(var2_13, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Long")) {
                        var2_14 = this.ByteToLongObj(this._barray);
                        System.arraycopy(var2_14, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    var2_15 = new HDF5JavaException("arrayify:  Object type not implemented yet...");
                    throw var2_15;
                }
                var2_16 = new HDF5JavaException("arrayify:  unknown type not implemented yet...");
                throw var2_16;
            }
            catch (OutOfMemoryError var2_17) {
                var3_19 = new HDF5JavaException("HDFArray: arrayify array too big?");
                throw var3_19;
            }
        }
        var2_18 = this._theArray;
        var3_20 = 0;
        var4_21 = 0;
        var5_22 = 0;
        var7_23 /* !! */  = null;
        switch (ArrayDescriptor.NT) {
            case 'J': {
                var7_23 /* !! */  = (byte[])HDFNativeData.byteToLong(this._barray);
                break;
            }
            case 'S': {
                var7_23 /* !! */  = (byte[])HDFNativeData.byteToShort(this._barray);
                break;
            }
            case 'I': {
                var7_23 /* !! */  = (byte[])HDFNativeData.byteToInt(this._barray);
                break;
            }
            case 'F': {
                var7_23 /* !! */  = (byte[])HDFNativeData.byteToFloat(this._barray);
                break;
            }
            case 'D': {
                var7_23 /* !! */  = (byte[])HDFNativeData.byteToDouble(this._barray);
                break;
            }
            case 'B': {
                var7_23 /* !! */  = this._barray;
                break;
            }
            case 'L': {
                if (!ArrayDescriptor.className.equals("java.lang.Byte")) ** GOTO lbl93
                var7_23 /* !! */  = this.ByteToByteObj(this._barray);
                ** GOTO lbl110
lbl93:
                // 1 sources

                if (!ArrayDescriptor.className.equals("java.lang.Short")) ** GOTO lbl96
                var7_23 /* !! */  = (byte[])this.ByteToShort(this._barray);
                ** GOTO lbl110
lbl96:
                // 1 sources

                if (!ArrayDescriptor.className.equals("java.lang.Integer")) ** GOTO lbl99
                var7_23 /* !! */  = (byte[])this.ByteToInteger(this._barray);
                ** GOTO lbl110
lbl99:
                // 1 sources

                if (!ArrayDescriptor.className.equals("java.lang.Long")) ** GOTO lbl102
                var7_23 /* !! */  = (byte[])this.ByteToLongObj(this._barray);
                ** GOTO lbl110
lbl102:
                // 1 sources

                if (!ArrayDescriptor.className.equals("java.lang.Float")) ** GOTO lbl105
                var7_23 /* !! */  = (byte[])this.ByteToFloatObj(this._barray);
                ** GOTO lbl110
lbl105:
                // 1 sources

                if (ArrayDescriptor.className.equals("java.lang.Double")) {
                    var7_23 /* !! */  = (byte[])this.ByteToDoubleObj(this._barray);
                } else {
                    var8_24 = new HDF5JavaException("HDFArray: unsupported Object type: " + ArrayDescriptor.NT);
                    throw var8_24;
                }
            }
lbl110:
            // 7 sources

            default: {
                var8_25 = new HDF5JavaException("HDFArray: unknown or unsupported type: " + ArrayDescriptor.NT);
                throw var8_25;
            }
        }
        while (var3_20 < ArrayDescriptor.totalSize) {
            var2_18 = ArrayDescriptor.objs[0];
            var5_22 = var3_20 / ArrayDescriptor.bytetoindex[0];
            var5_22 %= ArrayDescriptor.dimlen[0];
            for (var6_28 = 0; var6_28 < ArrayDescriptor.dims; ++var6_28) {
                var5_22 = var3_20 / ArrayDescriptor.bytetoindex[var6_28];
                if ((var5_22 %= ArrayDescriptor.dimlen[var6_28]) == ArrayDescriptor.currentindex[var6_28]) {
                    var2_18 = ArrayDescriptor.objs[var6_28];
                    continue;
                }
                if (var5_22 > ArrayDescriptor.dimlen[var6_28] - 1) {
                    System.out.println("out of bounds?");
                    return null;
                }
                var2_18 = Array.get(var2_18, var5_22);
                ArrayDescriptor.currentindex[var6_28] = var5_22;
                ArrayDescriptor.objs[var6_28] = var2_18;
            }
            try {
                var8_26 /* !! */  = null;
                var9_29 = var4_21 + ArrayDescriptor.dimlen[ArrayDescriptor.dims];
                switch (ArrayDescriptor.NT) {
                    case 'B': {
                        var8_26 /* !! */  = Arrays.copyOfRange(var7_23 /* !! */ , var4_21, var9_29);
                        break;
                    }
                    case 'S': {
                        var8_26 /* !! */  = (byte[])Arrays.copyOfRange((short[])var7_23 /* !! */ , var4_21, var9_29);
                        break;
                    }
                    case 'I': {
                        var8_26 /* !! */  = (byte[])Arrays.copyOfRange((int[])var7_23 /* !! */ , var4_21, var9_29);
                        break;
                    }
                    case 'J': {
                        var8_26 /* !! */  = (byte[])Arrays.copyOfRange((long[])var7_23 /* !! */ , var4_21, var9_29);
                        break;
                    }
                    case 'F': {
                        var8_26 /* !! */  = (byte[])Arrays.copyOfRange((float[])var7_23 /* !! */ , var4_21, var9_29);
                        break;
                    }
                    case 'D': {
                        var8_26 /* !! */  = (byte[])Arrays.copyOfRange((double[])var7_23 /* !! */ , var4_21, var9_29);
                        break;
                    }
                    case 'L': {
                        if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                            var8_26 /* !! */  = Arrays.copyOfRange((Byte[])var7_23 /* !! */ , var4_21, var9_29);
                            break;
                        }
                        if (ArrayDescriptor.className.equals("java.lang.Short")) {
                            var8_26 /* !! */  = (byte[])Arrays.copyOfRange((Short[])var7_23 /* !! */ , var4_21, var9_29);
                            break;
                        }
                        if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                            var8_26 /* !! */  = (byte[])Arrays.copyOfRange((Integer[])var7_23 /* !! */ , var4_21, var9_29);
                            break;
                        }
                        if (ArrayDescriptor.className.equals("java.lang.Long")) {
                            var8_26 /* !! */  = (byte[])Arrays.copyOfRange((Long[])var7_23 /* !! */ , var4_21, var9_29);
                            break;
                        }
                        if (ArrayDescriptor.className.equals("java.lang.Float")) {
                            var8_26 /* !! */  = (byte[])Arrays.copyOfRange((Float[])var7_23 /* !! */ , var4_21, var9_29);
                            break;
                        }
                        if (ArrayDescriptor.className.equals("java.lang.Double")) {
                            var8_26 /* !! */  = (byte[])Arrays.copyOfRange((Double[])var7_23 /* !! */ , var4_21, var9_29);
                            break;
                        }
                        var10_31 = new HDF5JavaException("HDFArray: unsupported Object type: " + ArrayDescriptor.NT);
                        throw var10_31;
                    }
                }
                Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], var8_26 /* !! */ );
                var3_20 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                v0 = ArrayDescriptor.dims - 1;
                ArrayDescriptor.currentindex[v0] = ArrayDescriptor.currentindex[v0] + 1;
                var4_21 = var9_29;
            }
            catch (OutOfMemoryError var8_27) {
                var9_30 = new HDF5JavaException("HDFArray: arrayify array too big?");
                throw var9_30;
            }
        }
        if (var3_20 < ArrayDescriptor.totalSize) {
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all input data: n=  " + var3_20 + " size = " + ArrayDescriptor.totalSize));
        }
        for (var6_28 = 0; var6_28 <= ArrayDescriptor.dims - 2; ++var6_28) {
            if (ArrayDescriptor.currentindex[var6_28] == ArrayDescriptor.dimlen[var6_28] - 1) continue;
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + var6_28 + "] = " + ArrayDescriptor.currentindex[var6_28] + " (should be " + (ArrayDescriptor.dimlen[var6_28] - 1) + "?"));
        }
        if (ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1] != ArrayDescriptor.dimlen[ArrayDescriptor.dims - 1]) {
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + var6_28 + "] = " + ArrayDescriptor.currentindex[var6_28] + " (should be " + ArrayDescriptor.dimlen[var6_28] + "?"));
        }
        return this._theArray;
    }

    private byte[] IntegerToByte(Integer[] integerArray) {
        int n = Array.getLength(integerArray);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = integerArray[i];
        }
        return HDFNativeData.intToByte(0, n, nArray);
    }

    private Integer[] ByteToInteger(byte[] byArray) {
        int[] nArray = HDFNativeData.byteToInt(byArray);
        int n = Array.getLength(nArray);
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = new Integer(nArray[i]);
        }
        return integerArray;
    }

    private Integer[] ByteToInteger(int n, int n2, byte[] byArray) {
        int[] nArray = HDFNativeData.byteToInt(n, n2, byArray);
        int n3 = Array.getLength(nArray);
        Integer[] integerArray = new Integer[n3];
        for (int i = 0; i < n3; ++i) {
            integerArray[i] = new Integer(nArray[i]);
        }
        return integerArray;
    }

    private byte[] ShortToByte(Short[] shortArray) {
        int n = Array.getLength(shortArray);
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = shortArray[i];
        }
        return HDFNativeData.shortToByte(0, n, sArray);
    }

    private Short[] ByteToShort(byte[] byArray) {
        short[] sArray = HDFNativeData.byteToShort(byArray);
        int n = Array.getLength(sArray);
        Short[] shortArray = new Short[n];
        for (int i = 0; i < n; ++i) {
            shortArray[i] = new Short(sArray[i]);
        }
        return shortArray;
    }

    private Short[] ByteToShort(int n, int n2, byte[] byArray) {
        short[] sArray = HDFNativeData.byteToShort(n, n2, byArray);
        int n3 = Array.getLength(sArray);
        Short[] shortArray = new Short[n3];
        for (int i = 0; i < n3; ++i) {
            shortArray[i] = new Short(sArray[i]);
        }
        return shortArray;
    }

    private byte[] ByteObjToByte(Byte[] byteArray) {
        int n = Array.getLength(byteArray);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = byteArray[i];
        }
        return byArray;
    }

    private Byte[] ByteToByteObj(byte[] byArray) {
        int n = Array.getLength(byArray);
        Byte[] byteArray = new Byte[n];
        for (int i = 0; i < n; ++i) {
            byteArray[i] = new Byte(byArray[i]);
        }
        return byteArray;
    }

    private Byte[] ByteToByteObj(int n, int n2, byte[] byArray) {
        Byte[] byteArray = new Byte[n2];
        for (int i = 0; i < n2; ++i) {
            byteArray[i] = new Byte(byArray[i]);
        }
        return byteArray;
    }

    private byte[] FloatObjToByte(Float[] floatArray) {
        int n = Array.getLength(floatArray);
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = floatArray[i].floatValue();
        }
        return HDFNativeData.floatToByte(0, n, fArray);
    }

    private Float[] ByteToFloatObj(byte[] byArray) {
        float[] fArray = HDFNativeData.byteToFloat(byArray);
        int n = Array.getLength(fArray);
        Float[] floatArray = new Float[n];
        for (int i = 0; i < n; ++i) {
            floatArray[i] = new Float(fArray[i]);
        }
        return floatArray;
    }

    private Float[] ByteToFloatObj(int n, int n2, byte[] byArray) {
        float[] fArray = HDFNativeData.byteToFloat(n, n2, byArray);
        int n3 = Array.getLength(fArray);
        Float[] floatArray = new Float[n3];
        for (int i = 0; i < n3; ++i) {
            floatArray[i] = new Float(fArray[i]);
        }
        return floatArray;
    }

    private byte[] DoubleObjToByte(Double[] doubleArray) {
        int n = Array.getLength(doubleArray);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = doubleArray[i];
        }
        return HDFNativeData.doubleToByte(0, n, dArray);
    }

    private Double[] ByteToDoubleObj(byte[] byArray) {
        double[] dArray = HDFNativeData.byteToDouble(byArray);
        int n = Array.getLength(dArray);
        Double[] doubleArray = new Double[n];
        for (int i = 0; i < n; ++i) {
            doubleArray[i] = new Double(dArray[i]);
        }
        return doubleArray;
    }

    private Double[] ByteToDoubleObj(int n, int n2, byte[] byArray) {
        double[] dArray = HDFNativeData.byteToDouble(n, n2, byArray);
        int n3 = Array.getLength(dArray);
        Double[] doubleArray = new Double[n3];
        for (int i = 0; i < n3; ++i) {
            doubleArray[i] = new Double(dArray[i]);
        }
        return doubleArray;
    }

    private byte[] LongObjToByte(Long[] longArray) {
        int n = Array.getLength(longArray);
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = longArray[i];
        }
        return HDFNativeData.longToByte(0, n, lArray);
    }

    private Long[] ByteToLongObj(byte[] byArray) {
        long[] lArray = HDFNativeData.byteToLong(byArray);
        int n = Array.getLength(lArray);
        Long[] longArray = new Long[n];
        for (int i = 0; i < n; ++i) {
            longArray[i] = new Long(lArray[i]);
        }
        return longArray;
    }

    private Long[] ByteToLongObj(int n, int n2, byte[] byArray) {
        long[] lArray = HDFNativeData.byteToLong(n, n2, byArray);
        int n3 = Array.getLength(lArray);
        Long[] longArray = new Long[n3];
        for (int i = 0; i < n3; ++i) {
            longArray[i] = new Long(lArray[i]);
        }
        return longArray;
    }
}

