/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.osm.search.SearchSetting;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.gui.dialogs.SearchDialog;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.overpass.OverpassWizardRegistration;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBoxModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.SearchCompilerQueryWizard;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.Utils;

public final class OverpassQueryWizardDialog
extends SearchDialog {
    private static final ListProperty OVERPASS_WIZARD_HISTORY = new ListProperty("download.overpass.wizard", (List<String>)new ArrayList<String>());
    private final OverpassWizardRegistration.OverpassWizardCallbacks callbacks;
    private static final int BUILD_QUERY = 0;
    private static final int BUILD_AN_EXECUTE_QUERY = 1;
    private static final int CANCEL = 2;
    private AutoCompComboBoxModel<SearchSetting> model;
    private AutoCompComboBoxModel.Preferences prefs;

    public OverpassQueryWizardDialog(OverpassWizardRegistration.OverpassWizardCallbacks callbacks) {
        super(new SearchSetting(), new AutoCompComboBoxModel<SearchSetting>(), new SearchDialog.PanelOptions(false, true), callbacks.getParent(), I18n.tr("Overpass Query Wizard", new Object[0]), I18n.tr("Build query", new Object[0]), I18n.tr("Build query and execute", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.callbacks = callbacks;
        this.model = this.hcbSearchString.getModel();
        this.setButtonIcons("dialogs/magic-wand", "download-overpass", "cancel");
        this.setCancelButton(3);
        this.setDefaultButton(2);
        this.prefs = this.model.prefs(SearchSetting::fromString, SearchSetting::toString);
        this.prefs.load(OVERPASS_WIZARD_HISTORY);
    }

    @Override
    public void buttonAction(int buttonIndex, ActionEvent evt) {
        switch (buttonIndex) {
            case 0: {
                if (!this.buildQueryAction()) break;
                this.saveHistory();
                super.buttonAction(0, evt);
                break;
            }
            case 1: {
                if (!this.buildQueryAction()) break;
                this.saveHistory();
                super.buttonAction(1, evt);
                DownloadDialog.getInstance().startDownload();
                break;
            }
            default: {
                super.buttonAction(buttonIndex, evt);
            }
        }
    }

    private void saveHistory() {
        this.model.addTopElement(SearchSetting.fromString(this.hcbSearchString.getText()));
        this.prefs.save(OVERPASS_WIZARD_HISTORY);
    }

    private Optional<String> tryParseSearchTerm(String searchTerm) {
        try {
            return Optional.of(SearchCompilerQueryWizard.constructQuery(searchTerm));
        }
        catch (IllegalStateException | UncheckedParseException ex) {
            Logging.error(ex);
            JOptionPane.showMessageDialog(this.callbacks.getParent(), "<html>" + I18n.tr("The Overpass wizard could not parse the following query:", new Object[0]) + Utils.joinAsHtmlUnorderedList(Collections.singleton(Utils.escapeReservedCharactersHTML(searchTerm))) + "</html>", I18n.tr("Parse error", new Object[0]), 0);
            return Optional.empty();
        }
    }

    private boolean buildQueryAction() {
        Optional<String> q = this.tryParseSearchTerm(this.getSearchSettings().text);
        q.ifPresent(this.callbacks::submitWizardResult);
        return q.isPresent();
    }
}

