/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002\u001a\f\u0010\u0011\u001a\u00020\u000f*\u00020\u0010H\u0002\u001a\f\u0010\u0012\u001a\u00020\u000f*\u00020\u0010H\u0000\u001a\"\u0010\u0013\u001a\u00020\u000b*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\" \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0005\u00a8\u0006\u0018"}, d2={"jvmStaticInCompanionPhase", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getJvmStaticInCompanionPhase", "()Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "jvmStaticInObjectPhase", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getJvmStaticInObjectPhase", "coerceToUnit", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrTypeOperatorCallImpl;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "isJvmStaticDeclaration", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isJvmStaticInCompanion", "isJvmStaticInObject", "makeStatic", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "context", "replaceCallee", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.jvm"})
public final class JvmStaticAnnotationLoweringKt {
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> jvmStaticInObjectPhase = PhaseBuildersKt.makeIrModulePhase$default(jvmStaticInObjectPhase.1.INSTANCE, "JvmStaticInObject", "Make JvmStatic functions in non-companion objects static and replace all call sites in the module", null, null, null, null, null, 248, null);
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrFile> jvmStaticInCompanionPhase = PhaseBuildersKt.makeIrFilePhase$default(jvmStaticInCompanionPhase.1.INSTANCE, "JvmStaticInCompanion", "Synthesize static proxy functions for JvmStatic functions in companion objects", null, null, null, null, null, 248, null);

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> getJvmStaticInObjectPhase() {
        return jvmStaticInObjectPhase;
    }

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrFile> getJvmStaticInCompanionPhase() {
        return jvmStaticInCompanionPhase;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isJvmStaticDeclaration(IrDeclaration $this$isJvmStaticDeclaration) {
        Object object;
        boolean bl;
        IrDeclarationBase irDeclarationBase;
        if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$isJvmStaticDeclaration, AnnotationUtilKt.getJVM_STATIC_ANNOTATION_FQ_NAME())) return true;
        IrDeclarationBase irDeclarationBase2 = irDeclarationBase = $this$isJvmStaticDeclaration instanceof IrSimpleFunction ? (IrSimpleFunction)$this$isJvmStaticDeclaration : null;
        if (irDeclarationBase == null) {
            bl = false;
        } else {
            object = ((IrSimpleFunction)irDeclarationBase).getCorrespondingPropertySymbol();
            if (object == null) {
                bl = false;
            } else {
                IrProperty irProperty2 = (IrProperty)object.getOwner();
                if (irProperty2 == null) {
                    bl = false;
                } else {
                    if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)irProperty2, AnnotationUtilKt.getJVM_STATIC_ANNOTATION_FQ_NAME())) {
                        return true;
                    }
                    bl = false;
                }
            }
        }
        if (bl) return true;
        if (!($this$isJvmStaticDeclaration instanceof IrProperty)) return false;
        IrProperty irProperty3 = (IrProperty)$this$isJvmStaticDeclaration;
        irDeclarationBase = irProperty3;
        if (irDeclarationBase == null) {
            return false;
        }
        object = ((IrProperty)irDeclarationBase).getGetter();
        if (object == null) {
            return false;
        }
        if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)object, AnnotationUtilKt.getJVM_STATIC_ANNOTATION_FQ_NAME())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isJvmStaticInCompanion(IrDeclaration $this$isJvmStaticInCompanion) {
        if (!JvmStaticAnnotationLoweringKt.isJvmStaticDeclaration($this$isJvmStaticInCompanion)) return false;
        IrDeclarationParent irDeclarationParent = $this$isJvmStaticInCompanion.getParent();
        if (!(irDeclarationParent instanceof IrClass)) return false;
        IrClass irClass2 = (IrClass)irDeclarationParent;
        IrClass irClass3 = irClass2;
        if (irClass3 == null) {
            return false;
        }
        if (!irClass3.isCompanion()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJvmStaticInObject(@NotNull IrDeclaration $this$isJvmStaticInObject) {
        Intrinsics.checkNotNullParameter($this$isJvmStaticInObject, "<this>");
        if (!JvmStaticAnnotationLoweringKt.isJvmStaticDeclaration($this$isJvmStaticInObject)) return false;
        IrDeclarationParent irDeclarationParent = $this$isJvmStaticInObject.getParent();
        if (!(irDeclarationParent instanceof IrClass)) return false;
        IrClass irClass2 = (IrClass)irDeclarationParent;
        IrClass irClass3 = irClass2;
        if (irClass3 == null) {
            return false;
        }
        if (!IrUtilsKt.isNonCompanionObject(irClass3)) return false;
        return true;
    }

    private static final IrTypeOperatorCallImpl coerceToUnit(IrExpression $this$coerceToUnit, IrBuiltIns irBuiltIns) {
        return new IrTypeOperatorCallImpl($this$coerceToUnit.getStartOffset(), $this$coerceToUnit.getEndOffset(), irBuiltIns.getUnitType(), IrTypeOperator.IMPLICIT_COERCION_TO_UNIT, irBuiltIns.getUnitType(), $this$coerceToUnit);
    }

    private static final IrExpression makeStatic(IrMemberAccessExpression<?> $this$makeStatic, JvmBackendContext context2, IrSimpleFunction replaceCallee) {
        IrExpression irExpression;
        IrExpression irExpression2 = $this$makeStatic.getDispatchReceiver();
        if (irExpression2 == null) {
            irExpression = $this$makeStatic;
        } else {
            IrExpression irExpression3;
            IrMemberAccessExpression newCall;
            IrExpression irExpression4 = irExpression2;
            boolean bl = false;
            boolean bl2 = false;
            IrExpression receiver = irExpression4;
            boolean bl3 = false;
            $this$makeStatic.setDispatchReceiver(null);
            IrMemberAccessExpression irMemberAccessExpression = newCall = replaceCallee != null ? (IrMemberAccessExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrCall)$this$makeStatic), replaceCallee, false, false, null, null, 60, null) : $this$makeStatic;
            if (IrUtilsKt.isTrivial(receiver)) {
                irExpression3 = newCall;
            } else {
                IrBlockImpl irBlockImpl = new IrBlockImpl($this$makeStatic.getStartOffset(), $this$makeStatic.getEndOffset(), newCall.getType(), null, 8, null);
                boolean bl4 = false;
                boolean bl5 = false;
                IrBlockImpl $this$makeStatic_u24lambda_u2d1_u24lambda_u2d0 = irBlockImpl;
                boolean bl6 = false;
                IrBlockImpl irBlockImpl2 = $this$makeStatic_u24lambda_u2d1_u24lambda_u2d0;
                Collection collection = irBlockImpl2.getStatements();
                IrTypeOperatorCallImpl irTypeOperatorCallImpl = JvmStaticAnnotationLoweringKt.coerceToUnit(receiver, context2.getIrBuiltIns());
                boolean bl7 = false;
                collection.add(irTypeOperatorCallImpl);
                irBlockImpl2 = $this$makeStatic_u24lambda_u2d1_u24lambda_u2d0;
                collection = irBlockImpl2.getStatements();
                boolean bl8 = false;
                collection.add(newCall);
                irExpression3 = irBlockImpl;
            }
            IrExpression irExpression5 = irExpression3;
            irExpression = irExpression5 == null ? (IrExpression)$this$makeStatic : irExpression5;
        }
        return irExpression;
    }

    public static final /* synthetic */ boolean access$isJvmStaticDeclaration(IrDeclaration $receiver) {
        return JvmStaticAnnotationLoweringKt.isJvmStaticDeclaration($receiver);
    }

    public static final /* synthetic */ IrExpression access$makeStatic(IrMemberAccessExpression $receiver, JvmBackendContext context2, IrSimpleFunction replaceCallee) {
        return JvmStaticAnnotationLoweringKt.makeStatic($receiver, context2, replaceCallee);
    }

    public static final /* synthetic */ boolean access$isJvmStaticInCompanion(IrDeclaration $receiver) {
        return JvmStaticAnnotationLoweringKt.isJvmStaticInCompanion($receiver);
    }
}

